// xc functional: TPSS exchange functional
// Functional Form: Pure functional; Semi-local meta-GGA (tau-form)
// Parameterization: Electron gas + empirical functional form compatible with some exact scaling limits.
// Original article: http://dx.doi.org/10.1103/PhysRevLett.91.146401
// 
// Implemented by Alyssa Bienvenu, June 2016
void xc_tpssx(double &E, double *dE, double const *D, double const Factor)
{
   double const Au = 0.0310907;
   double const Alpha1u = 0.2137;
   double const Beta1u = 7.5957;
   double const Beta2u = 3.5876;
   double const Beta3u = 1.6382;
   double const Beta4u = 0.49294;
   double const Ap = 0.01554535;
   double const Alpha1p = 0.20548;
   double const Beta1p = 14.1189;
   double const Beta2p = 6.1977;
   double const Beta3p = 3.3662;
   double const Beta4p = 0.62517;
   double const Aa = 0.0168869;
   double const Alpha1a = 0.11125;
   double const Beta1a = 10.357;
   double const Beta2a = 3.6231;
   double const Beta3a = 0.88026;
   double const Beta4a = 0.49671;
   double rhoc = D[0];
   double rhoo = D[1];
   double sigmacc = D[2];
   double sigmaco = D[3];
   double sigmaoo = D[4];
   double tauc = D[5];
   double tauo = D[6];
   double r1 = 1.442249570307408;
   double r2 = 0.6827840632552957;
   double r3 = rhoc - 1.0*rhoo;
   double r4 = pow(r3,(4.0/3.0));
   double r5 = 0.4807498567691361;
   double r6 = 0.2173369174628993;
   double r7 = 1.0/pow(r3,(8.0/3.0));
   double r8 = sigmaoo - 2.0*sigmaco + sigmacc;
   double r9 = 0.309939510227399*r5*r6*r7*r8 + 1;
   double r10 = 1.0/sqr(r9);
   double r11 = 3.522640219227933e-05;
   double r12 = 0.04723533569227512;
   double r13 = 1.0/pow(r3,(16.0/3.0));
   double r14 = sqr(r8);
   double r15 = 0.01026598225468434;
   double r16 = 1.0/pow(r3,8);
   double r17 = pow(r8,3);
   double r18 = 0.1602499522563787;
   double r19 = 1.0/r8;
   double r20 = tauc - 1.0*tauo;
   double r21 = 8.0*r19*r20*r3 - 1;
   double r22 = 1.25*r18*r21*r6*r7*r8 - 1;
   double r23 = sqrt(0.5*r18*r6*r7*r8*r22*r21 + 1);
   double r24 = 1.0/r23;
   double r25 = 0.5*r18*r6*r7*r8 + 0.45*r22*r24;
   double r26 = 0.2311204247835449;
   double r27 = 1.0/sqr(r3);
   double r28 = 1.0/sqr(r20);
   double r29 = sqrt(0.0028125*r14*r27*r28 + 0.03125*r12*r13*r14*r26);
   double r30 = 0.015625*r14*r27*r28 + 1;
   double r31 = 1.0/sqr(r30);
   double r32 = 0.02485875*r27*r14*r31*r28 + 0.1234567901234568;
   double r33 = 0.25*r32*r5*r6*r7*r8 - 0.1802469135802469*r25*r29 + 0.001721886167929995*r27*r14*r28 + 0.07209876543209877*sqr(r25) + 0.0005857410937499999*r15*r16*r17 + 7.773631840796019*r11*r12*r13*r14;
   double r34 = 1.243781094527363*r10*r33 + 1;
   double r35 = 1.804 - 0.804/r34;
   double r36 = rhoo + rhoc;
   double r37 = pow(r36,(4.0/3.0));
   double r38 = 1.0/pow(r36,(8.0/3.0));
   double r39 = sigmaoo + 2.0*sigmaco + sigmacc;
   double r40 = 0.309939510227399*r5*r6*r38*r39 + 1;
   double r41 = 1.0/sqr(r40);
   double r42 = 1.0/pow(r36,(16.0/3.0));
   double r43 = sqr(r39);
   double r44 = 1.0/pow(r36,8);
   double r45 = pow(r39,3);
   double r46 = 1.0/sqr(r36);
   double r47 = tauo + tauc;
   double r48 = 1.0/sqr(r47);
   double r49 = sqrt(0.0028125*r43*r46*r48 + 0.03125*r12*r26*r42*r43);
   double r50 = 1.0/r39;
   double r51 = 8.0*r36*r47*r50 - 1;
   double r52 = 1.25*r18*r38*r39*r51*r6 - 1;
   double r53 = sqrt(0.5*r18*r6*r38*r39*r51*r52 + 1);
   double r54 = 1.0/r53;
   double r55 = 0.5*r18*r38*r39*r6 + 0.45*r52*r54;
   double r56 = 0.015625*r43*r46*r48 + 1;
   double r57 = 1.0/sqr(r56);
   double r58 = 0.02485875*r46*r43*r48*r57 + 0.1234567901234568;
   double r59 = 0.25*r38*r39*r5*r58*r6 + 0.07209876543209877*sqr(r55) - 0.1802469135802469*r49*r55 + 0.001721886167929995*r46*r43*r48 + 0.0005857410937499999*r15*r44*r45 + 7.773631840796019*r11*r12*r42*r43;
   double r60 = 1.243781094527363*r41*r59 + 1;
   double r61 = 1.804 - 0.804/r60;
   double r62 = pow(r3,(1.0/3.0));
   double r63 = 1.0/sqr(r34);
   double r64 = 1.0/pow(r3,(11.0/3.0));
   double r65 = 1.0/pow(r9,3);
   double r66 = 1.174213406409309e-05;
   double r67 = 1.0/pow(r3,(19.0/3.0));
   double r68 = 1.0/pow(r3,9);
   double r69 = 0.07704014159451494;
   double r70 = 1.0/pow(r3,3);
   double r71 = 1.0/r29;
   double r72 = 1.0/pow(r3,5);
   double r73 = pow(r8,4);
   double r74 = 1.0/pow(r30,3);
   double r75 = 1.0/pow(r20,4);
   double r76 = 0.05341665075212624;
   double r77 = 10.0*r18*r20*r6*r7 - 10.0*r21*r6*r64*r76*r8;
   double r78 = 1.0/pow(r23,3);
   double r79 = (-4.0*r6*r64*r76*r8) - 0.225*(4.0*r18*r6*r7*r22*r20 + 0.5*r18*r6*r7*r8*r77*r21 - 4.0*r76*r6*r64*r8*r22*r21)*r22*r78 + 0.45*r24*r77;
   double r80 = 1.0/pow(r36,(19.0/3.0));
   double r81 = 1.0/pow(r36,3);
   double r82 = 1.0/pow(r36,(11.0/3.0));
   double r83 = 10.0*r18*r38*r47*r6 - 10.0*r39*r51*r6*r76*r82;
   double r84 = 1.0/pow(r53,3);
   double r85 = (-0.225*r52*((-4.0*r76*r6*r82*r39*r51*r52) + 4.0*r18*r6*r38*r47*r52 + 0.5*r18*r6*r38*r39*r51*r83)*r84) + 0.45*r54*r83 - 4.0*r39*r6*r76*r82;
   double r86 = 1.0/r49;
   double r87 = pow(r39,4);
   double r88 = 1.0/pow(r47,4);
   double r89 = 1.0/pow(r56,3);
   double r90 = 1.0/pow(r40,3);
   double r91 = 1.0/sqr(r60);
   double r92 = -0.3015*r1*r2*r37*(1.243781094527363*r41*(0.25*r38*r39*r5*r6*((0.001553671875*r87*r88*r89)/pow(r36,5) - 0.0497175*r81*r43*r48*r57) - 0.09012345679012346*r55*((-0.005625*r43*r48*r81) - 0.5*r12*r43*r69*r80)*r86 + 0.1441975308641975*r55*r85 - 0.1802469135802469*r49*r85 - 2.0*r18*r39*r58*r6*r82 - 0.003443772335859989*r81*r43*r48 - (0.004685928749999999*r15*r45)/pow(r36,9) - 124.3781094527363*r66*r12*r80*r43) + 6.167950452286547*r18*r6*r82*r39*r90*r59)*r91;
   double r93 = -1.5*r5*r2*pow(r36,(1.0/3.0))*r61;
   double r94 = 10.0*r21*r6*r64*r76*r8 - 10.0*r18*r20*r6*r7;
   double r95 = 0.45*r24*r94 + 4.0*r6*r64*r76*r8 - 0.225*((-4.0*r18*r6*r7*r22*r20) + 0.5*r18*r6*r7*r8*r94*r21 + 4.0*r76*r6*r64*r8*r22*r21)*r22*r78;
   double r96 = 1.0/pow(r3,4);
   double r97 = 1.0/pow(r3,(5.0/3.0));
   double r98 = 1.25*r18*r21*r6*r7 - 10.0*r18*r19*r20*r6*r97;
   double r99 = 0.45*r24*r98 - 0.225*((-4.0*r18*r6*r97*r19*r22*r20) + 0.5*r18*r6*r7*r8*r98*r21 + 0.5*r18*r6*r7*r22*r21)*r22*r78 + 0.5*r18*r6*r7;
   double r100 = 1.0/pow(r36,(5.0/3.0));
   double r101 = 1.25*r18*r38*r51*r6 - 10.0*r100*r18*r47*r50*r6;
   double r102 = (-0.225*r52*(0.5*r18*r6*r38*r51*r52 - 4.0*r18*r6*r100*r50*r47*r52 + 0.5*r18*r6*r38*r39*r51*r101)*r84) + 0.5*r18*r38*r6 + 0.45*r101*r54;
   double r103 = 1.0/pow(r36,4);
   double r104 = (-0.3015*r1*r2*r4*r63*(1.243781094527363*r10*((-0.1802469135802469*r29*r99) + 0.1441975308641975*r25*r99 - 0.09012345679012346*r25*r71*(0.005625*r27*r28*r8 + 0.0625*r12*r13*r26*r8) + 0.25*(0.0497175*r27*r8*r31*r28 - 0.001553671875*r96*r17*r74*r75)*r5*r6*r7*r8 + 15.54726368159204*r11*r12*r13*r8 + 0.25*r32*r5*r6*r7 + 0.003443772335859989*r27*r8*r28 + 0.00175722328125*r15*r16*r14) - 0.7709938065358184*r5*r6*r7*r65*r33)) - 0.3015*r1*r2*r37*(1.243781094527363*r41*((-0.09012345679012346*(0.005625*r39*r46*r48 + 0.0625*r12*r26*r39*r42)*r55*r86) + 0.25*r38*r5*r58*r6 + 0.25*r38*r39*r5*(0.0497175*r46*r39*r48*r57 - 0.001553671875*r103*r45*r88*r89)*r6 + 0.1441975308641975*r102*r55 - 0.1802469135802469*r102*r49 + 0.003443772335859989*r46*r39*r48 + 0.00175722328125*r15*r44*r43 + 15.54726368159204*r11*r12*r42*r39) - 0.7709938065358184*r5*r6*r38*r90*r59)*r91;
   double r105 = 20.0*r18*r19*r20*r6*r97 - 2.5*r18*r21*r6*r7;
   double r106 = (-0.225*(8.0*r18*r6*r97*r19*r22*r20 + 0.5*r18*r6*r7*r8*r105*r21 - 1.0*r18*r6*r7*r22*r21)*r22*r78) - 1.0*r18*r6*r7 + 0.45*r105*r24;
   double r107 = 2.5*r18*r38*r51*r6 - 20.0*r100*r18*r47*r50*r6;
   double r108 = (-0.225*r52*(1.0*r18*r6*r38*r51*r52 - 8.0*r18*r6*r100*r50*r47*r52 + 0.5*r18*r6*r38*r39*r51*r107)*r84) + 0.45*r107*r54 + r18*r6*r38;
   double r109 = 0.02568004719817164;
   double r110 = 1.0/pow(r3,(13.0/3.0));
   double r111 = 0.5*r1*r24*r6*r97 - 0.225*(5.0*r109*r12*r110*r8*r21 + 4.0*r18*r6*r97*r22)*r22*r78;
   double r112 = 1.0/pow(r20,3);
   double r113 = 1.0/pow(r20,5);
   double r114 = 1.0/pow(r47,3);
   double r115 = 0.5*r1*r100*r54*r6 - 0.225*r52*(4.0*r18*r6*r100*r52 + (5.0*r109*r12*r39*r51)/pow(r36,(13.0/3.0)))*r84;
   double r116 = -0.375*r1*r2*r37*r41*(0.25*r38*r39*r5*r6*((0.001553671875*r103*r87*r89)/pow(r47,5) - 0.0497175*r46*r43*r114*r57) + 0.0005069444444444444*r114*r43*r46*r55*r86 + 0.1441975308641975*r115*r55 - 0.1802469135802469*r115*r49 - 0.003443772335859989*r46*r43*r114)*r91;
   double r117 = (-0.5*r1*r24*r6*r97) - 0.225*((-5.0*r109*r12*r110*r8*r21) - 4.0*r18*r6*r97*r22)*r22*r78;
   E += Factor*((-0.375*r1*r2*r37*r61) - 0.375*r1*r2*r4*r35);
   dE[0] += Factor*(r93 + r92 - 0.3015*r1*r2*r4*r63*(1.243781094527363*r10*(0.25*(0.001553671875*r72*r73*r74*r75 - 0.0497175*r70*r14*r31*r28)*r5*r6*r7*r8 - 2.0*r18*r32*r6*r64*r8 - 0.1802469135802469*r29*r79 + 0.1441975308641975*r25*r79 - 0.09012345679012346*r25*((-0.005625*r14*r28*r70) - 0.5*r12*r14*r67*r69)*r71 - 0.003443772335859989*r70*r14*r28 - 0.004685928749999999*r15*r68*r17 - 124.3781094527363*r66*r12*r67*r14) + 6.167950452286547*r18*r6*r64*r8*r65*r33) - 1.5*r5*r2*r62*r35);
   dE[1] += Factor*((-0.3015*r1*r2*r4*r63*(1.243781094527363*r10*((-0.1802469135802469*r29*r95) + 0.1441975308641975*r25*r95 + 0.25*(0.0497175*r70*r14*r31*r28 - 0.001553671875*r72*r73*r74*r75)*r5*r6*r7*r8 + 2.0*r18*r32*r6*r64*r8 - 0.09012345679012346*r25*(0.005625*r14*r28*r70 + 0.5*r12*r14*r67*r69)*r71 + 0.003443772335859989*r70*r14*r28 + 0.004685928749999999*r15*r68*r17 + 124.3781094527363*r66*r12*r67*r14) - 6.167950452286547*r18*r6*r64*r8*r65*r33)) + r93 + r92 + 1.5*r5*r2*r62*r35);
   dE[2] += Factor*(r104);
   dE[3] += Factor*((-0.3015*r1*r2*r37*(1.243781094527363*r41*((-0.09012345679012346*(0.01125*r39*r46*r48 + 0.125*r12*r26*r39*r42)*r55*r86) + 0.5*r38*r5*r58*r6 + 0.25*r38*r39*r5*(0.099435*r46*r39*r48*r57 - 0.00310734375*r103*r45*r88*r89)*r6 + 0.1441975308641975*r108*r55 - 0.1802469135802469*r108*r49 + 0.006887544671719978*r46*r39*r48 + 0.0035144465625*r15*r44*r43 + 31.09452736318408*r11*r12*r42*r39) - 1.541987613071637*r5*r6*r38*r90*r59)*r91) - 0.3015*r1*r2*r4*r63*(1.243781094527363*r10*((-0.09012345679012346*r25*r71*((-0.01125*r27*r28*r8) - 0.125*r12*r13*r26*r8)) + 0.25*(0.00310734375*r96*r17*r74*r75 - 0.099435*r27*r8*r31*r28)*r5*r6*r7*r8 - 31.09452736318408*r11*r12*r13*r8 - 0.5*r32*r5*r6*r7 - 0.1802469135802469*r106*r29 - 0.006887544671719978*r27*r8*r28 + 0.1441975308641975*r106*r25 - 0.0035144465625*r15*r16*r14) + 1.541987613071637*r5*r6*r7*r65*r33));
   dE[4] += Factor*(r104);
   dE[5] += Factor*(r116 - 0.375*r1*r10*r2*r4*r63*(0.25*(0.001553671875*r96*r73*r74*r113 - 0.0497175*r27*r14*r31*r112)*r5*r6*r7*r8 + 0.0005069444444444444*r112*r14*r25*r27*r71 - 0.1802469135802469*r111*r29 + 0.1441975308641975*r111*r25 - 0.003443772335859989*r27*r14*r112));
   dE[6] += Factor*(r116 - 0.375*r1*r10*r2*r4*r63*(0.25*(0.0497175*r27*r14*r31*r112 - 0.001553671875*r96*r73*r74*r113)*r5*r6*r7*r8 - 0.0005069444444444444*r112*r14*r25*r27*r71 - 0.1802469135802469*r117*r29 + 0.1441975308641975*r117*r25 + 0.003443772335859989*r27*r14*r112));
   // suppress potential unused variable warnings.
   (void)rhoc; (void)rhoo; (void)sigmacc; (void)sigmaco; (void)sigmaoo; (void)tauc;
   (void)tauo; (void)Au; (void)Alpha1u; (void)Beta1u; (void)Beta2u; (void)Beta3u;
   (void)Beta4u; (void)Ap; (void)Alpha1p; (void)Beta1p; (void)Beta2p; (void)Beta3p;
   (void)Beta4p; (void)Aa; (void)Alpha1a; (void)Beta1a; (void)Beta2a; (void)Beta3a;
   (void)Beta4a;
}

/* kate: syntax c++; */

