// xc functional: PBE GGA correlation functional. (http://dx.doi.org/10.1103/PhysRevLett.77.3865)
void xc_pbec(double &E, double *dE, double const *D, double const Factor)
{
   double const Au = 0.0310907;
   double const Alpha1u = 0.2137;
   double const Beta1u = 7.5957;
   double const Beta2u = 3.5876;
   double const Beta3u = 1.6382;
   double const Beta4u = 0.49294;
   double const Ap = 0.01554535;
   double const Alpha1p = 0.20548;
   double const Beta1p = 14.1189;
   double const Beta2p = 6.1977;
   double const Beta3p = 3.3662;
   double const Beta4p = 0.62517;
   double const Aa = 0.0168869;
   double const Alpha1a = 0.11125;
   double const Beta1a = 10.357;
   double const Beta2a = 3.6231;
   double const Beta3a = 0.88026;
   double const Beta4a = 0.49671;
   double rhoc = D[0];
   double rhoo = D[1];
   double sigmacc = D[2];
   double sigmaco = D[3];
   double sigmaoo = D[4];
   double r1 = 2.080083823051904;
   double r2 = 0.39685026299205;
   double r3 = 2.145029397111025;
   double r4 = 1.0/r3;
   double r5 = 1.0/pow(rhoc,(2.0/3.0));
   double r6 = 1.732050807568877;
   double r7 = 0.5641895835477563;
   double r8 = sqrt(rhoc);
   double r9 = 1.0/r8;
   double r10 = 1.442249570307408;
   double r11 = 0.6299605249474366;
   double r12 = 1.464591887561523;
   double r13 = 1.0/r12;
   double r14 = 1.0/pow(rhoc,(1.0/3.0));
   double r15 = 0.7937005259840997;
   double r16 = 1.200936955176003;
   double r17 = 0.8263074871107581;
   double r18 = 1.0/pow(rhoc,(1.0/6.0));
   double r19 = 0.5*r6*r7*r9*Beta3u + r1*r2*r4*Beta4u*r5 + r15*r16*r17*Beta1u*r18 + r10*r11*r13*Beta2u*r14;
   double r20 = 0.5/(r19*Au) + 1;
   double r21 = log(r20);
   double r22 = r10*r11*r13*Alpha1u*r14 + 1;
   double r23 = -2.0*r21*r22*Au;
   double r24 = 2.519842099789746;
   double r25 = 1.0/(r24 - 2.0);
   double r26 = 0.5*r6*r7*r9*Beta3p + r1*r2*r4*Beta4p*r5 + r15*r16*r17*Beta1p*r18 + r10*r11*r13*Beta2p*r14;
   double r27 = 0.5/(r26*Ap) + 1;
   double r28 = log(r27);
   double r29 = r10*r11*r13*Alpha1p*r14 + 1;
   double r30 = 2.0*r21*r22*Au;
   double r31 = r30 - 2.0*r28*r29*Ap;
   double r32 = 1.0/pow(rhoc,4);
   double r33 = pow(rhoo,4);
   double r34 = 1.0/rhoc;
   double r35 = 1 - 1.0*r34*rhoo;
   double r36 = r34*rhoo + 1;
   double r37 = pow(r36,(4.0/3.0)) + pow(r35,(4.0/3.0)) - 2;
   double r38 = r25*r31*r32*r33*r37;
   double r39 = 0.5*r6*r7*r9*Beta3a + r1*r2*r4*Beta4a*r5 + r15*r16*r17*Beta1a*r18 + r10*r11*r13*Beta2a*r14;
   double r40 = 0.5/(r39*Aa) + 1;
   double r41 = log(r40);
   double r42 = r10*r11*r13*Alpha1a*r14 + 1;
   double r43 = 1 - 1.0*r32*r33;
   double r44 = 2.25*r37*r41*r42*r43*Aa;
   double r45 = pow(r36,(2.0/3.0)) + pow(r35,(2.0/3.0));
   double r46 = pow(r45,3);
   double r47 = 1.0/r10;
   double r48 = 1.0/pow(rhoc,(7.0/3.0));
   double r49 = sqr(r45);
   double r50 = 1.0/r49;
   double r51 = 1.0/r46;
   double r52 = (-2.25*r37*r41*r42*r43*Aa) - 1.0*r25*r31*r32*r33*r37 + r30;
   double r53 = pow(2.718281828459045,(257.3117475433186*r51*r52));
   double r54 = r53 - 1;
   double r55 = 1.0/r54;
   double r56 = 0.5365315849918411*r47*r12*r48*r50*r55*sigmacc;
   double r57 = r56 + 1;
   double r58 = 1.0/r1;
   double r59 = 1.0/pow(rhoc,(14.0/3.0));
   double r60 = 1.0/pow(r45,4);
   double r61 = 1.0/sqr(r54);
   double r62 = sqr(sigmacc);
   double r63 = 0.2878661416938572*r58*r3*r59*r60*r61*r62 + r56 + 1;
   double r64 = 1.0/r63;
   double r65 = 0.5365315849918411*r47*r12*r48*r50*sigmacc*r57*r64 + 1;
   double r66 = log(r65);
   double r67 = 0.003886336358706862*r46*r66;
   double r68 = 1.0/r20;
   double r69 = 1.0/pow(rhoc,(5.0/3.0));
   double r70 = 1.0/pow(r8,3);
   double r71 = 1.0/pow(rhoc,(4.0/3.0));
   double r72 = 1.0/r24;
   double r73 = 0.4003123183920009;
   double r74 = 1.0/pow(rhoc,(7.0/6.0));
   double r75 = (-2.0*r2*r4*r47*r69*Beta4u) - 0.25*r6*r7*r70*Beta3u - 1.0*r11*r13*r58*r71*Beta2u - 1.0*r17*r72*r73*r74*Beta1u;
   double r76 = 1.0/sqr(r19);
   double r77 = 1.0/sqr(rhoc);
   double r78 = pow(r35,(1.0/3.0));
   double r79 = pow(r36,(1.0/3.0));
   double r80 = 1.333333333333333*r77*r78*rhoo - 1.333333333333333*r77*r79*rhoo;
   double r81 = 1.0/pow(rhoc,5);
   double r82 = -1.0*r22*r68*r75*r76;
   double r83 = -2.0*r11*r13*r21*r58*r71*Alpha1u*Au;
   double r84 = (1.0*r29*((-2.0*r2*r4*r47*r69*Beta4p) - 0.25*r6*r7*r70*Beta3p - 1.0*r11*r13*r58*r71*Beta2p - 1.0*r17*r72*r73*r74*Beta1p))/(sqr(r26)*r27) + 2.0*r11*r13*r28*r58*r71*Alpha1p*Ap + r83 + r82;
   double r85 = 1.0/r40;
   double r86 = (-2.0*r2*r4*r47*r69*Beta4a) - 0.25*r6*r7*r70*Beta3a - 1.0*r11*r13*r58*r71*Beta2a - 1.0*r17*r72*r73*r74*Beta1a;
   double r87 = 1.0/sqr(r39);
   double r88 = 4.326748710922225;
   double r89 = 0.1574901312368591;
   double r90 = 1.0/r65;
   double r91 = 1.0/sqr(r63);
   double r92 = 1.0/r78;
   double r93 = 1.0/r79;
   double r94 = 0.6666666666666666*r77*r92*rhoo - 0.6666666666666666*r77*r93*rhoo;
   double r95 = -1.073063169983682*r47*r12*r48*r94*r51*r55*sigmacc;
   double r96 = 1.0/r88;
   double r97 = 1.0/pow(rhoc,(10.0/3.0));
   double r98 = -3.755721094942888*r96*r12*r97*r50*r55*sigmacc;
   double r99 = 257.3117475433186*r51*((-9.0*r33*r37*r41*r42*r81*Aa) - 2.25*r41*r42*r43*r80*Aa + 1.125*r37*r42*r43*r85*r86*r87 - 1.0*r25*r32*r33*r37*r84 + r83 + r82 + 4.0*r25*r31*r33*r37*r81 - 1.0*r25*r31*r32*r33*r80 + r88*r89*r13*Aa*Alpha1a*r41*r71*r43*r37) - 771.9352426299557*r94*r60*r52;
   double r100 = -0.5365315849918411*r47*r12*r48*r50*r99*r61*r53*sigmacc;
   double r101 = 1.0/pow(r45,5);
   double r102 = 1.0/pow(r54,3);
   double r103 = 1.333333333333333*r34*r79 - 1.333333333333333*r34*r78;
   double r104 = pow(rhoo,3);
   double r105 = 0.6666666666666666*r34*r93 - 0.6666666666666666*r34*r92;
   double r106 = -1.073063169983682*r47*r12*r48*r105*r51*r55*sigmacc;
   double r107 = 257.3117475433186*r51*((-2.25*r103*r41*r42*r43*Aa) + 9.0*r104*r32*r37*r41*r42*Aa - 4.0*r104*r25*r31*r32*r37 - 1.0*r103*r25*r31*r32*r33) - 771.9352426299557*r105*r60*r52;
   double r108 = -0.5365315849918411*r47*r12*r48*r50*r107*r61*r53*sigmacc;
   E += Factor*(rhoc*(r67 + r44 + r38 + r23));
   dE[0] += Factor*(rhoc*(0.003886336358706862*r46*r90*((-0.5365315849918411*r12*r47*r48*r50*r57*r91*((-(0.6458274964773596*r3*r60*r61*r62)/pow(rhoc,(17.0/3.0))) + r98 + r95 - 1.151464566775429*r58*r3*r59*r94*r101*r61*r62 - 0.5757322833877143*r58*r3*r59*r60*r99*r102*r53*r62 + r100)*sigmacc) - 1.073063169983682*r47*r12*r48*r94*r51*sigmacc*r57*r64 - 3.755721094942888*r96*r12*r97*r50*sigmacc*r57*r64 + 0.5365315849918411*r47*r12*r48*r50*sigmacc*(r100 + r98 + r95)*r64) + 2.0*r11*r13*r21*r58*r71*Alpha1u*Au - 1.0*r13*r37*r41*r43*r71*r88*r89*Aa*Alpha1a + 9.0*r33*r37*r41*r42*r81*Aa + 2.25*r41*r42*r43*r80*Aa - 1.125*r37*r42*r43*r85*r86*r87 - 4.0*r25*r31*r33*r37*r81 + r25*r31*r32*r33*r80 + r68*r75*r22*r76 + 0.01165900907612059*r94*r49*r66 + r25*r84*r32*r33*r37) + r67 + r44 + r38 + r23);
   dE[1] += Factor*((2.25*r103*r41*r42*r43*Aa - 9.0*r104*r32*r37*r41*r42*Aa + 0.01165900907612059*r105*r49*r66 + 0.003886336358706862*r46*r90*(0.5365315849918411*r47*r12*r48*r50*sigmacc*(r108 + r106)*r64 - 1.073063169983682*r47*r12*r48*r105*r51*sigmacc*r57*r64 - 0.5365315849918411*r47*r12*r48*r50*sigmacc*r57*r91*((-0.5757322833877143*r58*r3*r59*r60*r107*r102*r53*r62) - 1.151464566775429*r58*r3*r59*r105*r101*r61*r62 + r108 + r106)) + 4.0*r104*r25*r31*r32*r37 + r25*r31*r32*r33*r103)*rhoc);
   dE[2] += Factor*(0.003886336358706862*rhoc*r46*(0.5365315849918411*r47*r12*r48*r50*r57*r64 + 0.2878661416938572*r58*r3*r59*r60*r55*sigmacc*r64 - 0.5365315849918411*r47*r12*r48*r50*sigmacc*(0.5757322833877143*r58*r3*r59*r60*r61*sigmacc + 0.5365315849918411*r47*r12*r48*r50*r55)*r57*r91)*r90);
   dE[3] += Factor*(0);
   dE[4] += Factor*(0);
   // suppress potential unused variable warnings.
   (void)rhoc; (void)rhoo; (void)sigmacc; (void)sigmaco; (void)sigmaoo; (void)Au;
   (void)Alpha1u; (void)Beta1u; (void)Beta2u; (void)Beta3u; (void)Beta4u; (void)Ap;
   (void)Alpha1p; (void)Beta1p; (void)Beta2p; (void)Beta3p; (void)Beta4p; (void)Aa;
   (void)Alpha1a; (void)Beta1a; (void)Beta2a; (void)Beta3a; (void)Beta4a;
}

/* kate: syntax c++; */

