// xc functional: Laplace-Level TPSS correlation functional
void xc_ll_tpss(double &E, double *dE, double const *D, double const Factor)
{
   double const Au = 0.0310907;
   double const Alpha1u = 0.2137;
   double const Beta1u = 7.5957;
   double const Beta2u = 3.5876;
   double const Beta3u = 1.6382;
   double const Beta4u = 0.49294;
   double const Ap = 0.01554535;
   double const Alpha1p = 0.20548;
   double const Beta1p = 14.1189;
   double const Beta2p = 6.1977;
   double const Beta3p = 3.3662;
   double const Beta4p = 0.62517;
   double const Aa = 0.0168869;
   double const Alpha1a = 0.11125;
   double const Beta1a = 10.357;
   double const Beta2a = 3.6231;
   double const Beta3a = 0.88026;
   double const Beta4a = 0.49671;
   double rhoc = D[0];
   double rhoo = D[1];
   double sigmacc = D[2];
   double sigmaco = D[3];
   double sigmaoo = D[4];
   double tauc = D[5];
   double tauo = D[6];
   double upsilonc = D[7];
   double upsilono = D[8];
   double r1 = 1.442249570307408;
   double r2 = 1.464591887561523;
   double r3 = 1.0/r2;
   double r4 = rhoc - 1.0*rhoo;
   double r5 = pow(r4,(4.0/3.0));
   double r6 = 2.080083823051904;
   double r7 = 1.0/r6;
   double r8 = 4.601151114470489;
   double r9 = 1.0/r8;
   double r10 = pow(r4,(8.0/3.0));
   double r11 = 1.0/r10;
   double r12 = sigmaoo - 2.0*sigmaco + sigmacc;
   double r13 = 0.309939510227399*r7*r9*r11*r12 + 1;
   double r14 = 1.0/sqr(r13);
   double r15 = 3.522640219227933e-05;
   double r16 = 0.04723533569227512;
   double r17 = 1.0/pow(r4,(16.0/3.0));
   double r18 = sqr(r12);
   double r19 = 0.01026598225468434;
   double r20 = 1.0/pow(r4,8);
   double r21 = pow(r12,3);
   double r22 = 6.240251469155714;
   double r23 = 1.0/r22;
   double r24 = 1.0/r12;
   double r25 = 1.25*r11*r12*r23*r9;
   double r26 = r25 + 1;
   double r27 = 1.0/sqr(r26);
   double r28 = 0.0009511128591915428;
   double r29 = 0.5*r16*r17*r18*r28;
   double r30 = 0.002853338577574629;
   double r31 = 1.0/pow(r4,(10.0/3.0));
   double r32 = upsilonc - 1.0*upsilono;
   double r33 = sqr(r32);
   double r34 = 0.5*r16*r30*r31*r33;
   double r35 = 0.02568004719817164;
   double r36 = 1.0/pow(r4,(13.0/3.0));
   double r37 = -0.0625*r12*r16*r32*r35*r36;
   double r38 = r37 + r34 + r29;
   double r39 = sqr(r38);
   double r40 = sqrt(r27*r39 + 1);
   double r41 = 1.0/r40;
   double r42 = 0.01780555025070874;
   double r43 = 0.05341665075212624;
   double r44 = pow(r4,(5.0/3.0));
   double r45 = 1.0/r44;
   double r46 = 5.0*r32*r43*r45*r9 + 1.25*r11*r12*r42*r9 + r37 + r34 + r29 + 1;
   double r47 = r41*r46 - 1.25*r11*r12*r23*r9;
   double r48 = PC07_Fab(r47);
   double r49 = r48*r47 + r25;
   double r50 = 0.8*r10*r22*r24*r49*r8 - 1;
   double r51 = 1.25*r11*r12*r23*r50*r9 - 1;
   double r52 = sqrt(0.5*r23*r9*r11*r12*r51*r50 + 1);
   double r53 = 1.0/r52;
   double r54 = 0.5*r11*r12*r23*r9 + 0.45*r51*r53;
   double r55 = 4.326748710922225;
   double r56 = 1.0/r55;
   double r57 = 1.0/sqr(r49);
   double r58 = sqrt(0.03125*r16*r17*r18*r56*r57 + 0.03125*r16*r17*r18*r56);
   double r59 = 1.5625*r16*r17*r18*r35*r57 + 1;
   double r60 = 1.0/sqr(r59);
   double r61 = 2.485875*r35*r16*r17*r18*r60*r57 + 0.1234567901234568;
   double r62 = 0.25*r11*r12*r61*r7*r9 - 0.1802469135802469*r54*r58 + 0.01913206853255549*r56*r16*r17*r18*r57 + 0.07209876543209877*sqr(r54) + 0.0005857410937499999*r19*r20*r21 + 7.773631840796019*r15*r16*r17*r18;
   double r63 = 1.243781094527363*r14*r62 + 1;
   double r64 = 1.804 - 0.804/r63;
   double r65 = 1.0/sqr(rhoc);
   double r66 = sqr(sigmacc);
   double r67 = sqr(rhoo);
   double r68 = 1.0/pow(rhoc,4);
   double r69 = pow(rhoo,4);
   double r70 = 1.0/pow(rhoc,6);
   double r71 = pow(rhoo,6);
   double r72 = 2.26*r70*r71 + 0.5*r68*r69 + 0.87*r65*r67 + 0.53;
   double r73 = 1.0/pow(rhoc,(8.0/3.0));
   double r74 = 1.0/rhoc;
   double r75 = 1 - 1.0*r74*rhoo;
   double r76 = pow(r75,(4.0/3.0));
   double r77 = r74*rhoo + 1;
   double r78 = pow(r77,(4.0/3.0));
   double r79 = 1.0/r78 + 1.0/r76;
   double r80 = sigmaoo - 2.0*r74*rhoo*sigmaco + r65*r67*sigmacc;
   double r81 = 0.125*r7*r73*r79*r80*r9 + 1;
   double r82 = 1.0/pow(r81,4);
   double r83 = r72*r82 + 1;
   double r84 = 0.5*rhoc;
   double r85 = r84 - 0.5*rhoo;
   double r86 = 1.0/Ap;
   double r87 = 1.587401051968199;
   double r88 = 1.0/r87;
   double r89 = 2.145029397111025;
   double r90 = 1.0/r89;
   double r91 = pow(r4,(2.0/3.0));
   double r92 = 1.414213562373095;
   double r93 = 1.0/r92;
   double r94 = 1.732050807568877;
   double r95 = 0.5641895835477563;
   double r96 = sqrt(r4);
   double r97 = 1.259921049894873;
   double r98 = 1.0/r97;
   double r99 = pow(r4,(1.0/3.0));
   double r100 = 1.0/r99;
   double r101 = 0.8908987181403393;
   double r102 = 1.200936955176003;
   double r103 = 0.8263074871107581;
   double r104 = (1.0*r6*r88*r90*Beta4p)/r91 + (1.0*r93*r94*r95*Beta3p)/r96 + (1.0*r101*r102*r103*Beta1p)/pow(r4,(1.0/6.0)) + r98*r1*r3*Beta2p*r100;
   double r105 = (0.5*r86)/r104 + 1;
   double r106 = log(r105);
   double r107 = r98*r1*r3*Alpha1p*r100 + 1;
   double r108 = 1.0/r1;
   double r109 = 1.0/pow(r4,(7.0/3.0));
   double r110 = pow(2.718281828459045,(128.6558737716593*Ap*r106*r107));
   double r111 = r110 - 1;
   double r112 = 1.0/r111;
   double r113 = 0.2682657924959205*r108*r2*r109*r112*r12;
   double r114 = r113 + 1;
   double r115 = 1.0/pow(r4,(14.0/3.0));
   double r116 = 1.0/sqr(r111);
   double r117 = 0.07196653542346429*r7*r89*r115*r116*r18 + r113 + 1;
   double r118 = 1.0/r117;
   double r119 = 0.2682657924959205*r108*r2*r109*r12*r114*r118 + 1;
   double r120 = 0.01554534543482745*log(r119) - 2.0*r106*r107*Ap;
   double r121 = 0.5*rhoo + r84;
   double r122 = rhoo + rhoc;
   double r123 = pow(r122,(1.0/3.0));
   double r124 = 1.0/r123;
   double r125 = r98*r1*r3*Alpha1p*r124 + 1;
   double r126 = pow(r122,(2.0/3.0));
   double r127 = sqrt(r122);
   double r128 = (1.0*r6*r88*r90*Beta4p)/r126 + (1.0*r93*r94*r95*Beta3p)/r127 + (1.0*r101*r102*r103*Beta1p)/pow(r122,(1.0/6.0)) + r98*r1*r3*Beta2p*r124;
   double r129 = (0.5*r86)/r128 + 1;
   double r130 = log(r129);
   double r131 = 1.0/pow(r122,(7.0/3.0));
   double r132 = sigmaoo + 2.0*sigmaco + sigmacc;
   double r133 = pow(2.718281828459045,(128.6558737716593*Ap*r125*r130));
   double r134 = r133 - 1;
   double r135 = 1.0/r134;
   double r136 = 0.2682657924959205*r108*r2*r131*r135*r132;
   double r137 = r136 + 1;
   double r138 = 1.0/pow(r122,(14.0/3.0));
   double r139 = 1.0/sqr(r134);
   double r140 = sqr(r132);
   double r141 = 0.07196653542346429*r7*r89*r138*r139*r140 + r136 + 1;
   double r142 = 1.0/r141;
   double r143 = 0.2682657924959205*r108*r2*r131*r132*r137*r142 + 1;
   double r144 = 0.01554534543482745*log(r143) - 2.0*r125*r130*Ap;
   double r145 = r74*r121*r144 + r74*r85*r120;
   double r146 = pow(r122,(5.0/3.0));
   double r147 = pow(r122,(8.0/3.0));
   double r148 = 1.0/r147;
   double r149 = 1.25*r132*r148*r23*r9;
   double r150 = 1.0/pow(r122,(16.0/3.0));
   double r151 = 0.5*r140*r150*r16*r28;
   double r152 = 1.0/r146;
   double r153 = upsilono + upsilonc;
   double r154 = 1.0/pow(r122,(13.0/3.0));
   double r155 = -0.0625*r132*r153*r154*r16*r35;
   double r156 = 1.0/pow(r122,(10.0/3.0));
   double r157 = sqr(r153);
   double r158 = 0.5*r156*r157*r16*r30;
   double r159 = 5.0*r152*r153*r43*r9 + 1.25*r132*r148*r42*r9 + r158 + r155 + r151 + 1;
   double r160 = r149 + 1;
   double r161 = 1.0/sqr(r160);
   double r162 = r158 + r155 + r151;
   double r163 = sqr(r162);
   double r164 = sqrt(r161*r163 + 1);
   double r165 = 1.0/r164;
   double r166 = r159*r165 - 1.25*r132*r148*r23*r9;
   double r167 = PC07_Fab(r166);
   double r168 = r166*r167 + r149;
   double r169 = 0.05*r22*r44*r49*r8 + 0.05*r146*r168*r22*r8;
   double r170 = 1.0/sqr(r169);
   double r171 = 0.39685026299205;
   double r172 = 1.0/pow(rhoc,(2.0/3.0));
   double r173 = sqrt(rhoc);
   double r174 = 1.0/r173;
   double r175 = 0.6299605249474366;
   double r176 = 1.0/pow(rhoc,(1.0/3.0));
   double r177 = 1.0/pow(rhoc,(1.0/6.0));
   double r178 = 0.5*r174*r94*r95*Beta3u + r98*r102*r103*Beta1u*r177 + r1*r175*r3*Beta2u*r176 + r6*r171*r90*Beta4u*r172;
   double r179 = 0.5/(r178*Au) + 1;
   double r180 = log(r179);
   double r181 = r1*r175*r3*Alpha1u*r176 + 1;
   double r182 = 2.519842099789746;
   double r183 = 1.0/(r182 - 2.0);
   double r184 = 0.5*r174*r94*r95*Beta3p + r98*r102*r103*Beta1p*r177 + r1*r175*r3*Beta2p*r176 + r6*r171*r90*Beta4p*r172;
   double r185 = (0.5*r86)/r184 + 1;
   double r186 = log(r185);
   double r187 = r1*r175*r3*Alpha1p*r176 + 1;
   double r188 = 2.0*r180*r181*Au;
   double r189 = r188 - 2.0*r186*r187*Ap;
   double r190 = r78 + r76 - 2;
   double r191 = 0.5*r174*r94*r95*Beta3a + r98*r102*r103*Beta1a*r177 + r1*r175*r3*Beta2a*r176 + r6*r171*r90*Beta4a*r172;
   double r192 = 0.5/(r191*Aa) + 1;
   double r193 = log(r192);
   double r194 = r1*r175*r3*Alpha1a*r176 + 1;
   double r195 = 1 - 1.0*r68*r69;
   double r196 = pow(r77,(2.0/3.0)) + pow(r75,(2.0/3.0));
   double r197 = pow(r196,3);
   double r198 = 1.0/pow(rhoc,(7.0/3.0));
   double r199 = sqr(r196);
   double r200 = 1.0/r199;
   double r201 = 1.0/r197;
   double r202 = (-2.25*r190*r193*r194*r195*Aa) - 1.0*r183*r189*r190*r68*r69 + r188;
   double r203 = pow(2.718281828459045,(257.3117475433186*r201*r202));
   double r204 = r203 - 1;
   double r205 = 1.0/r204;
   double r206 = 0.5365315849918411*r108*r2*r198*r200*r205*sigmacc;
   double r207 = r206 + 1;
   double r208 = 1.0/pow(rhoc,(14.0/3.0));
   double r209 = 1.0/pow(r196,4);
   double r210 = 1.0/sqr(r204);
   double r211 = 0.2878661416938572*r7*r89*r208*r209*r210*r66 + r206 + 1;
   double r212 = 1.0/r211;
   double r213 = 0.5365315849918411*r108*r2*r198*r200*sigmacc*r207*r212 + 1;
   double r214 = log(r213);
   double r215 = (-2.0*r180*r181*Au) + 2.25*r190*r193*r194*r195*Aa + 0.003886336358706862*r197*r214 + r183*r189*r68*r69*r190;
   double r216 = 0.015625*r170*r65*r66*r72*r82 + 1;
   double r217 = r215*r216 - 0.015625*r145*r170*r65*r66*r83;
   double r218 = 1.0/pow(rhoc,3);
   double r219 = pow(sigmacc,3);
   double r220 = 1.0/pow(r169,3);
   double r221 = 0.00546875*r218*r219*r220*r217 + 1;
   double r222 = pow(r122,(4.0/3.0));
   double r223 = 0.309939510227399*r7*r9*r148*r132 + 1;
   double r224 = 1.0/sqr(r223);
   double r225 = 1.0/pow(r122,8);
   double r226 = pow(r132,3);
   double r227 = 1.0/sqr(r168);
   double r228 = sqrt(0.03125*r140*r150*r16*r227*r56 + 0.03125*r140*r150*r16*r56);
   double r229 = 1.0/r132;
   double r230 = 0.8*r147*r168*r22*r229*r8 - 1;
   double r231 = 1.25*r132*r148*r23*r230*r9 - 1;
   double r232 = sqrt(0.5*r23*r9*r148*r132*r230*r231 + 1);
   double r233 = 1.0/r232;
   double r234 = 0.5*r132*r148*r23*r9 + 0.45*r231*r233;
   double r235 = 1.5625*r140*r150*r16*r227*r35 + 1;
   double r236 = 1.0/sqr(r235);
   double r237 = 2.485875*r35*r16*r150*r140*r227*r236 + 0.1234567901234568;
   double r238 = 0.25*r132*r148*r237*r7*r9 + 0.07209876543209877*sqr(r234) - 0.1802469135802469*r228*r234 + 0.01913206853255549*r56*r16*r150*r140*r227 + 0.0005857410937499999*r19*r225*r226 + 7.773631840796019*r15*r16*r150*r140;
   double r239 = 1.243781094527363*r224*r238 + 1;
   double r240 = 1.804 - 0.804/r239;
   double r241 = 1.0/sqr(r63);
   double r242 = 1.0/pow(r4,(11.0/3.0));
   double r243 = 1.0/pow(r13,3);
   double r244 = 1.174213406409309e-05;
   double r245 = 1.0/pow(r4,(19.0/3.0));
   double r246 = 1.0/pow(r4,9);
   double r247 = 0.07704014159451494;
   double r248 = -10.0*r12*r242*r43*r9;
   double r249 = 10.0*r12*r242*r43*r9;
   double r250 = 0.005935183416902912;
   double r251 = 0.0003170376197305141;
   double r252 = -8.0*r16*r18*r245*r251;
   double r253 = -5.0*r16*r28*r33*r36;
   double r254 = 0.00856001573272388;
   double r255 = 0.8125*r12*r16*r17*r254*r32;
   double r256 = 1.0/pow(r40,3);
   double r257 = 1.0/pow(r26,3);
   double r258 = (-0.5*r256*r46*(20.0*r12*r242*r257*r39*r43*r9 + 2.0*(r255 + r253 + r252)*r27*r38)) + r41*((-25.0*r11*r32*r42*r9) - 10.0*r12*r242*r250*r9 + r255 + r253 + r252) + r249;
   double r259 = dPC07_Fab(r47);
   double r260 = r259*r47*r258 + r48*r258 + r248;
   double r261 = 6.4*r24*r44*r49*r6*r8 + 0.8*r10*r22*r24*r260*r8;
   double r262 = 1.25*r11*r12*r23*r261*r9 - 10.0*r12*r242*r43*r50*r9;
   double r263 = 1.0/pow(r52,3);
   double r264 = (-4.0*r12*r242*r43*r9) + 0.45*r262*r53 - 0.225*(0.5*r23*r9*r11*r12*r51*r261 + 0.5*r23*r9*r11*r12*r262*r50 - 4.0*r43*r9*r242*r12*r51*r50)*r263*r51;
   double r265 = 1.0/r58;
   double r266 = 1.0/pow(r49,3);
   double r267 = 1.0/pow(r59,3);
   double r268 = -1.5*r7*r3*r123*r240;
   double r269 = 1.0/r105;
   double r270 = 1.0/pow(r92,3);
   double r271 = 1.0/pow(r96,3);
   double r272 = 1.0/r5;
   double r273 = 0.4454493590701696;
   double r274 = 0.4003123183920009;
   double r275 = 1.0/pow(r4,(7.0/6.0));
   double r276 = (-1.0*r108*r45*r90*r97*Beta4p) - 1.0*r270*r271*r94*r95*Beta3p - 1.0*r272*r3*r7*r98*Beta2p - 1.0*r103*r273*r274*r275*Beta1p;
   double r277 = 1.0/sqr(r104);
   double r278 = 1.0/r119;
   double r279 = 1.0/sqr(r117);
   double r280 = -1.877860547471444*r56*r2*r31*r112*r12;
   double r281 = (-128.6558737716593*r98*r7*r3*Alpha1p*Ap*r106*r272) - 64.32793688582964*r269*r276*r107*r277;
   double r282 = -0.2682657924959205*r108*r2*r281*r109*r116*r110*r12;
   double r283 = 1.0/pow(r4,(17.0/3.0));
   double r284 = 1.0/pow(r111,3);
   double r285 = 1.0/r222;
   double r286 = (-1.0*r108*r152*r90*r97*Beta4p) - (1.0*r270*r94*r95*Beta3p)/pow(r127,3) - 1.0*r285*r3*r7*r98*Beta2p - (1.0*r103*r273*r274*Beta1p)/pow(r122,(7.0/6.0));
   double r287 = 1.0/sqr(r128);
   double r288 = 1.0/r129;
   double r289 = 1.0/r143;
   double r290 = 1.0/sqr(r141);
   double r291 = -1.877860547471444*r56*r2*r156*r135*r132;
   double r292 = (-128.6558737716593*r98*r7*r3*Alpha1p*Ap*r285*r130) - 64.32793688582964*r286*r125*r287*r288;
   double r293 = -0.2682657924959205*r108*r2*r131*r139*r133*r292*r132;
   double r294 = r121*r74*(0.01554534543482745*r289*((-0.2682657924959205*r108*r131*r132*r137*r2*r290*((-(0.1439330708469286*r133*r138*r140*r292*r7*r89)/pow(r134,3)) - (1.0075314959285*r139*r140*r23*r89)/pow(r122,(17.0/3.0)) + r293 + r291)) + 0.2682657924959205*r108*r2*r131*r132*(r293 + r291)*r142 - 1.877860547471444*r56*r2*r156*r132*r137*r142) + r286*r125*r287*r288 + r87*r7*r3*Alpha1p*Ap*r285*r130);
   double r295 = 0.5*r74*r144;
   double r296 = 1.0/pow(r75,(7.0/3.0));
   double r297 = 1.0/pow(r77,(7.0/3.0));
   double r298 = 0.125*r7*r73*r79*r9*(2.0*r65*rhoo*sigmaco - 2.0*r218*r67*sigmacc) + 0.125*r7*r73*r80*r9*(1.333333333333333*r297*r65*rhoo - 1.333333333333333*r296*r65*rhoo) - (1.0*r23*r79*r80*r9)/pow(rhoc,(11.0/3.0));
   double r299 = 1.0/pow(r81,5);
   double r300 = 1.0/pow(rhoc,5);
   double r301 = (-(13.56*r71)/pow(rhoc,7)) - 2.0*r300*r69 - 1.74*r218*r67;
   double r302 = 1.0/r179;
   double r303 = 1.0/pow(rhoc,(5.0/3.0));
   double r304 = 1.0/pow(r173,3);
   double r305 = 1.0/pow(rhoc,(4.0/3.0));
   double r306 = 1.0/r182;
   double r307 = 1.0/pow(rhoc,(7.0/6.0));
   double r308 = (-2.0*r108*r171*r303*r90*Beta4u) - 0.25*r304*r94*r95*Beta3u - 1.0*r175*r3*r305*r7*Beta2u - 1.0*r103*r274*r306*r307*Beta1u;
   double r309 = 1.0/sqr(r178);
   double r310 = pow(r75,(1.0/3.0));
   double r311 = pow(r77,(1.0/3.0));
   double r312 = 1.333333333333333*r310*r65*rhoo - 1.333333333333333*r311*r65*rhoo;
   double r313 = -1.0*r181*r302*r308*r309;
   double r314 = -2.0*r175*r180*r3*r305*r7*Alpha1u*Au;
   double r315 = (1.0*r187*((-2.0*r108*r171*r303*r90*Beta4p) - 0.25*r304*r94*r95*Beta3p - 1.0*r175*r3*r305*r7*Beta2p - 1.0*r103*r274*r306*r307*Beta1p))/(sqr(r184)*r185) + 2.0*r175*r186*r3*r305*r7*Alpha1p*Ap + r314 + r313;
   double r316 = 1.0/r192;
   double r317 = (-2.0*r108*r171*r303*r90*Beta4a) - 0.25*r304*r94*r95*Beta3a - 1.0*r175*r3*r305*r7*Beta2a - 1.0*r103*r274*r306*r307*Beta1a;
   double r318 = 1.0/sqr(r191);
   double r319 = 0.1574901312368591;
   double r320 = 1.0/r213;
   double r321 = 1.0/sqr(r211);
   double r322 = 1.0/r310;
   double r323 = 1.0/r311;
   double r324 = 0.6666666666666666*r322*r65*rhoo - 0.6666666666666666*r323*r65*rhoo;
   double r325 = -1.073063169983682*r108*r2*r198*r324*r201*r205*sigmacc;
   double r326 = 1.0/pow(rhoc,(10.0/3.0));
   double r327 = -3.755721094942888*r56*r2*r326*r200*r205*sigmacc;
   double r328 = 257.3117475433186*r201*((-9.0*r190*r193*r194*r300*r69*Aa) - 2.25*r193*r194*r195*r312*Aa - 1.0*r183*r190*r315*r68*r69 - 1.0*r183*r189*r312*r68*r69 + 4.0*r183*r189*r190*r300*r69 + 1.125*r190*r194*r195*r316*r317*r318 + r314 + r313 + r55*r319*r3*Aa*Alpha1a*r193*r305*r195*r190) - 771.9352426299557*r324*r209*r202;
   double r329 = -0.5365315849918411*r108*r2*r198*r200*r328*r210*r203*sigmacc;
   double r330 = 1.0/pow(r196,5);
   double r331 = 1.0/pow(rhoc,(17.0/3.0));
   double r332 = 1.0/pow(r204,3);
   double r333 = 0.25*r126*r168*r6*r8;
   double r334 = 1.0/pow(r122,(11.0/3.0));
   double r335 = 1.0/pow(r122,(19.0/3.0));
   double r336 = -8.0*r140*r16*r251*r335;
   double r337 = 0.8125*r132*r150*r153*r16*r254;
   double r338 = -5.0*r154*r157*r16*r28;
   double r339 = 1.0/pow(r160,3);
   double r340 = 1.0/pow(r164,3);
   double r341 = (-0.5*r159*r340*(20.0*r132*r163*r334*r339*r43*r9 + 2.0*r161*r162*(r338 + r337 + r336))) + r165*((-25.0*r148*r153*r42*r9) - 10.0*r132*r250*r334*r9 + r338 + r337 + r336) + 10.0*r132*r334*r43*r9;
   double r342 = dPC07_Fab(r166);
   double r343 = (-10.0*r132*r334*r43*r9) + r341*r166*r342 + r341*r167;
   double r344 = 0.05*r146*r22*r343*r8;
   double r345 = 0.25*r49*r6*r8*r91 + 0.05*r22*r260*r44*r8 + r344 + r333;
   double r346 = r216*(2.0*r175*r180*r3*r305*r7*Alpha1u*Au - 1.0*r190*r193*r195*r3*r305*r319*r55*Aa*Alpha1a + 9.0*r190*r193*r194*r300*r69*Aa + 2.25*r193*r194*r195*r312*Aa - 4.0*r183*r189*r190*r300*r69 - 1.125*r190*r194*r195*r316*r317*r318 + r183*r189*r68*r69*r312 + r302*r308*r181*r309 + 0.01165900907612059*r324*r199*r214 + 0.003886336358706862*r197*r320*(0.5365315849918411*r108*r2*r198*r200*sigmacc*(r329 + r327 + r325)*r212 - 3.755721094942888*r56*r2*r326*r200*sigmacc*r207*r212 - 1.073063169983682*r108*r2*r198*r324*r201*sigmacc*r207*r212 - 0.5365315849918411*r108*r2*r198*r200*sigmacc*r207*r321*((-0.5757322833877143*r7*r89*r208*r209*r328*r332*r203*r66) - 4.030125983714*r23*r89*r331*r209*r210*r66 - 1.151464566775429*r7*r89*r208*r324*r330*r210*r66 + r329 + r327 + r325)) + r183*r315*r68*r69*r190) - 0.015625*r170*r65*r66*r83*((-1.0*r120*r65*r85) - 1.0*r121*r144*r65 + r295 + r294 + 0.5*r74*r120 + r74*r85*(0.01554534543482745*r278*(0.2682657924959205*r108*r2*r109*r12*(r282 + r280)*r118 - 1.877860547471444*r56*r2*r31*r12*r114*r118 - 0.2682657924959205*r108*r2*r109*r12*r114*r279*((-0.1439330708469286*r7*r89*r281*r115*r284*r110*r18) - 1.0075314959285*r23*r89*r283*r116*r18 + r282 + r280)) + r87*r7*r3*Alpha1p*Ap*r106*r272 + r269*r276*r107*r277)) + 0.03125*r145*r220*r345*r65*r66*r83 + 0.03125*r145*r170*r218*r66*r83 + r215*((-0.03125*r220*r345*r65*r66*r72*r82) - 0.03125*r170*r218*r66*r72*r82 + 0.015625*r170*r301*r65*r66*r82 - 0.0625*r170*r298*r299*r65*r66*r72) - 0.015625*r145*r170*r65*r66*(r301*r82 - 4.0*r298*r299*r72);
   double r347 = 1.0/pow(r169,4);
   double r348 = 1.0/sqr(r239);
   double r349 = 1.0/pow(r223,3);
   double r350 = 1.0/pow(r168,3);
   double r351 = 1.0/r228;
   double r352 = 1.0/pow(r235,3);
   double r353 = 6.4*r146*r168*r229*r6*r8 + 0.8*r147*r22*r229*r343*r8;
   double r354 = 1.25*r132*r148*r23*r353*r9 - 10.0*r132*r230*r334*r43*r9;
   double r355 = 1.0/pow(r232,3);
   double r356 = (-4.0*r132*r334*r43*r9) - 0.225*r231*(0.5*r23*r9*r148*r132*r230*r354 + 0.5*r23*r9*r148*r132*r231*r353 - 4.0*r43*r9*r334*r132*r230*r231)*r355 + 0.45*r233*r354;
   double r357 = -0.3015*r1*r222*r3*r348*(1.243781094527363*r224*(0.25*r132*r148*((-4.97175*r140*r150*r16*r227*r35*((-3.125*r140*r150*r16*r343*r35*r350) - 25.0*r140*r16*r227*r254*r335)*r352) - 4.97175*r35*r16*r150*r140*r350*r236*r343 - 39.774*r254*r16*r335*r140*r227*r236)*r7*r9 - 2.0*r132*r23*r237*r334*r9 - 0.09012345679012346*r234*r351*((-0.0625*r140*r150*r16*r343*r350*r56) - 0.5*r140*r16*r227*r247*r335 - 0.5*r140*r16*r247*r335) + 0.1441975308641975*r234*r356 - 0.1802469135802469*r228*r356 - 0.03826413706511099*r56*r16*r150*r140*r350*r343 - 0.3061130965208879*r247*r16*r335*r140*r227 - (0.004685928749999999*r19*r226)/pow(r122,9) - 124.3781094527363*r244*r16*r335*r140) + 6.167950452286547*r23*r9*r334*r132*r349*r238);
   double r358 = 8.0*r16*r18*r245*r251;
   double r359 = 5.0*r16*r28*r33*r36;
   double r360 = -0.8125*r12*r16*r17*r254*r32;
   double r361 = (-0.5*r256*r46*(2.0*r27*(r360 + r359 + r358)*r38 - 20.0*r12*r242*r257*r39*r43*r9)) + r41*(25.0*r11*r32*r42*r9 + 10.0*r12*r242*r250*r9 + r360 + r359 + r358) + r248;
   double r362 = r259*r47*r361 + r48*r361 + r249;
   double r363 = 0.8*r10*r22*r24*r362*r8 - 6.4*r24*r44*r49*r6*r8;
   double r364 = 10.0*r12*r242*r43*r50*r9 + 1.25*r11*r12*r23*r363*r9;
   double r365 = 4.0*r12*r242*r43*r9 + 0.45*r364*r53 - 0.225*r263*(0.5*r23*r9*r11*r12*r51*r363 + 0.5*r23*r9*r11*r12*r364*r50 + 4.0*r43*r9*r242*r12*r51*r50)*r51;
   double r366 = r273*r274*r103*Beta1p*r275 + r98*r7*r3*Beta2p*r272 + r270*r94*r95*Beta3p*r271 + r97*r108*r90*Beta4p*r45;
   double r367 = 1.877860547471444*r56*r2*r31*r112*r12;
   double r368 = 128.6558737716593*r98*r7*r3*Alpha1p*Ap*r106*r272 - 64.32793688582964*r269*r366*r107*r277;
   double r369 = -0.2682657924959205*r108*r2*r368*r109*r116*r110*r12;
   double r370 = 0.125*r7*r73*r79*r9*(2.0*r65*rhoo*sigmacc - 2.0*r74*sigmaco) + 0.125*r7*r73*(1.333333333333333*r296*r74 - 1.333333333333333*r297*r74)*r80*r9;
   double r371 = pow(rhoo,3);
   double r372 = 13.56*r70*pow(rhoo,5) + 2.0*r68*r371 + 1.74*r65*rhoo;
   double r373 = 1.333333333333333*r311*r74 - 1.333333333333333*r310*r74;
   double r374 = 0.6666666666666666*r323*r74 - 0.6666666666666666*r322*r74;
   double r375 = -1.073063169983682*r108*r2*r198*r374*r201*r205*sigmacc;
   double r376 = 257.3117475433186*r201*(9.0*r190*r193*r194*r371*r68*Aa - 2.25*r193*r194*r195*r373*Aa - 1.0*r183*r189*r373*r68*r69 - 4.0*r183*r189*r190*r371*r68) - 771.9352426299557*r374*r209*r202;
   double r377 = -0.5365315849918411*r108*r2*r198*r200*r376*r210*r203*sigmacc;
   double r378 = (-0.25*r49*r6*r8*r91) + 0.05*r22*r362*r44*r8 + r344 + r333;
   double r379 = (-0.015625*r170*r65*r66*r83*(r74*r85*((-1.0*r106*r272*r3*r7*r87*Alpha1p*Ap) + r269*r366*r107*r277 + 0.01554534543482745*r278*(0.2682657924959205*r108*r2*r109*r12*(r369 + r367)*r118 + 1.877860547471444*r56*r2*r31*r12*r114*r118 - 0.2682657924959205*r108*r2*r109*r12*r114*r279*((-0.1439330708469286*r7*r89*r368*r115*r284*r110*r18) + 1.0075314959285*r23*r89*r283*r116*r18 + r369 + r367))) + r295 + r294 - 0.5*r74*r120)) + r216*((-9.0*r190*r193*r194*r371*r68*Aa) + 2.25*r193*r194*r195*r373*Aa + 4.0*r183*r189*r190*r371*r68 + r183*r189*r68*r69*r373 + 0.01165900907612059*r374*r199*r214 + 0.003886336358706862*r197*r320*(0.5365315849918411*r108*r2*r198*r200*sigmacc*(r377 + r375)*r212 - 1.073063169983682*r108*r2*r198*r374*r201*sigmacc*r207*r212 - 0.5365315849918411*r108*r2*r198*r200*sigmacc*r207*r321*((-0.5757322833877143*r7*r89*r208*r209*r376*r332*r203*r66) - 1.151464566775429*r7*r89*r208*r374*r330*r210*r66 + r377 + r375))) + 0.03125*r145*r220*r378*r65*r66*r83 + r215*((-0.03125*r220*r378*r65*r66*r72*r82) + 0.015625*r170*r372*r65*r66*r82 - 0.0625*r170*r299*r370*r65*r66*r72) - 0.015625*r145*r170*r65*r66*(r372*r82 - 4.0*r299*r370*r72);
   double r380 = 1.0/r18;
   double r381 = r28*r16*r17*r12;
   double r382 = -0.0625*r16*r32*r35*r36;
   double r383 = r41*(1.25*r11*r42*r9 + r382 + r381) - 0.5*r256*r46*(2.0*r27*r38*(r382 + r381) - 2.5*r11*r23*r257*r39*r9) - 1.25*r11*r23*r9;
   double r384 = 1.25*r11*r23*r9 + r48*r383 + r259*r47*r383;
   double r385 = 0.8*r10*r22*r24*r384*r8 - 0.8*r10*r22*r380*r49*r8;
   double r386 = 1.25*r11*r23*r50*r9 + 1.25*r11*r12*r23*r385*r9;
   double r387 = 0.5*r11*r23*r9 + 0.45*r386*r53 - 0.225*r263*(0.5*r23*r9*r11*r12*r51*r385 + 0.5*r23*r9*r11*r12*r386*r50 + 0.5*r23*r9*r11*r51*r50)*r51;
   double r388 = -0.3015*r1*r241*r3*r5*(1.243781094527363*r14*(0.25*r11*r61*r7*r9 + 0.25*r11*r12*((-4.97175*r16*r17*r18*r267*r35*r57*(3.125*r12*r16*r17*r35*r57 - 3.125*r16*r17*r18*r266*r35*r384)) + 4.97175*r35*r16*r17*r12*r60*r57 - 4.97175*r35*r16*r17*r18*r60*r266*r384)*r7*r9 - 0.1802469135802469*r387*r58 - 0.09012345679012346*r265*r54*(0.0625*r12*r16*r17*r56*r57 - 0.0625*r16*r17*r18*r266*r384*r56 + 0.0625*r12*r16*r17*r56) + 0.03826413706511099*r56*r16*r17*r12*r57 + 0.1441975308641975*r387*r54 - 0.03826413706511099*r56*r16*r17*r18*r266*r384 + 0.00175722328125*r19*r20*r18 + 15.54726368159204*r15*r16*r17*r12) - 0.7709938065358184*r7*r9*r11*r243*r62);
   double r389 = -0.015625*r170*(0.01554534543482745*r74*r121*(0.2682657924959205*r108*r2*r131*r137*r142 + 0.07196653542346429*r7*r89*r138*r135*r132*r142 - 0.2682657924959205*r108*r2*r131*r132*(0.1439330708469286*r7*r89*r138*r139*r132 + 0.2682657924959205*r108*r2*r131*r135)*r137*r290)*r289 + 0.01554534543482745*r74*r85*(0.2682657924959205*r108*r2*r109*r114*r118 + 0.07196653542346429*r7*r89*r115*r112*r12*r118 - 0.2682657924959205*r108*r2*r109*r12*(0.1439330708469286*r7*r89*r115*r116*r12 + 0.2682657924959205*r108*r2*r109*r112)*r114*r279)*r278)*r65*r66*r83;
   double r390 = 1.0/pow(rhoc,(20.0/3.0));
   double r391 = r28*r16*r150*r132;
   double r392 = -0.0625*r153*r154*r16*r35;
   double r393 = r165*(1.25*r148*r42*r9 + r392 + r391) - 0.5*r159*r340*(2.0*r161*r162*(r392 + r391) - 2.5*r148*r163*r23*r339*r9) - 1.25*r148*r23*r9;
   double r394 = 1.25*r148*r23*r9 + r393*r166*r342 + r393*r167;
   double r395 = 0.05*r22*r384*r44*r8 + 0.05*r146*r22*r394*r8;
   double r396 = 0.03125*r145*r220*r395*r65*r66*r83;
   double r397 = -0.03125*r220*r395*r65*r66*r72*r82;
   double r398 = r215*(0.03125*r170*r65*r72*r82*sigmacc - 0.0078125*r170*r299*r390*r66*r67*r7*r72*r79*r9 + r397) - 0.03125*r145*r170*r65*r83*sigmacc + 0.0078125*r145*r170*r299*r390*r66*r67*r7*r72*r79*r9 + r396 + r389 + 0.003886336358706862*r197*(0.5365315849918411*r108*r2*r198*r200*r207*r212 + 0.2878661416938572*r7*r89*r208*r209*r205*sigmacc*r212 - 0.5365315849918411*r108*r2*r198*r200*sigmacc*(0.5757322833877143*r7*r89*r208*r209*r210*sigmacc + 0.5365315849918411*r108*r2*r198*r200*r205)*r207*r321)*r320*r216;
   double r399 = -0.01640625*r218*r219*r347*r217*r395;
   double r400 = 1.0/r140;
   double r401 = 0.8*r147*r22*r229*r394*r8 - 0.8*r147*r168*r22*r400*r8;
   double r402 = 1.25*r132*r148*r23*r401*r9 + 1.25*r148*r23*r230*r9;
   double r403 = 0.5*r148*r23*r9 - 0.225*r231*r355*(0.5*r23*r9*r148*r132*r230*r402 + 0.5*r23*r9*r148*r132*r231*r401 + 0.5*r23*r9*r148*r230*r231) + 0.45*r233*r402;
   double r404 = -0.3015*r1*r222*r3*r348*(1.243781094527363*r224*(0.25*r132*r148*((-4.97175*r140*r150*r16*r227*r35*r352*(3.125*r132*r150*r16*r227*r35 - 3.125*r140*r150*r16*r35*r350*r394)) - 4.97175*r35*r16*r150*r140*r350*r236*r394 + 4.97175*r35*r16*r150*r132*r227*r236)*r7*r9 + 0.25*r148*r237*r7*r9 - 0.09012345679012346*r234*r351*((-0.0625*r140*r150*r16*r350*r394*r56) + 0.0625*r132*r150*r16*r227*r56 + 0.0625*r132*r150*r16*r56) + 0.1441975308641975*r234*r403 - 0.1802469135802469*r228*r403 - 0.03826413706511099*r56*r16*r150*r140*r350*r394 + 0.03826413706511099*r56*r16*r150*r132*r227 + 0.00175722328125*r19*r225*r140 + 15.54726368159204*r15*r16*r150*r132) - 0.7709938065358184*r7*r9*r148*r349*r238);
   double r405 = -2.0*r12*r16*r17*r28;
   double r406 = 0.125*r16*r32*r35*r36;
   double r407 = r41*((-2.5*r11*r42*r9) + r406 + r405) - 0.5*r256*r46*(5.0*r11*r23*r257*r39*r9 + 2.0*r27*r38*(r406 + r405)) + 2.5*r11*r23*r9;
   double r408 = (-2.5*r11*r23*r9) + r48*r407 + r259*r47*r407;
   double r409 = 1.6*r10*r22*r380*r49*r8 + 0.8*r10*r22*r24*r408*r8;
   double r410 = 1.25*r11*r12*r23*r409*r9 - 2.5*r11*r23*r50*r9;
   double r411 = (-1.0*r11*r23*r9) + 0.45*r410*r53 - 0.225*r263*(0.5*r23*r9*r11*r12*r51*r409 + 0.5*r23*r9*r11*r12*r410*r50 - 1.0*r23*r9*r11*r51*r50)*r51;
   double r412 = 2.0*r132*r150*r16*r28;
   double r413 = -0.125*r153*r154*r16*r35;
   double r414 = r165*(2.5*r148*r42*r9 + r413 + r412) - 0.5*r159*r340*(2.0*r161*r162*(r413 + r412) - 5.0*r148*r163*r23*r339*r9) - 2.5*r148*r23*r9;
   double r415 = 2.5*r148*r23*r9 + r414*r166*r342 + r414*r167;
   double r416 = 0.05*r22*r408*r44*r8 + 0.05*r146*r22*r415*r8;
   double r417 = r215*(0.015625*r170*r299*r331*r66*r7*r72*r79*r9*rhoo - 0.03125*r220*r416*r65*r66*r72*r82) - 0.015625*r145*r170*r299*r331*r66*r7*r72*r79*r9*rhoo + 0.03125*r145*r220*r416*r65*r66*r83 - 0.015625*r170*(0.01554534543482745*r74*r121*(0.5365315849918411*r108*r2*r131*r137*r142 + 0.1439330708469286*r7*r89*r138*r135*r132*r142 - 0.2682657924959205*r108*r2*r131*r132*(0.2878661416938572*r7*r89*r138*r139*r132 + 0.5365315849918411*r108*r2*r131*r135)*r137*r290)*r289 + 0.01554534543482745*r74*r85*((-0.5365315849918411*r108*r2*r109*r114*r118) - 0.1439330708469286*r7*r89*r115*r112*r12*r118 - 0.2682657924959205*r108*r2*r109*r12*((-0.2878661416938572*r7*r89*r115*r116*r12) - 0.5365315849918411*r108*r2*r109*r112)*r114*r279)*r278)*r65*r66*r83;
   double r418 = 0.8*r147*r22*r229*r415*r8 - 1.6*r147*r168*r22*r400*r8;
   double r419 = 1.25*r132*r148*r23*r418*r9 + 2.5*r148*r23*r230*r9;
   double r420 = (-0.225*r231*r355*(0.5*r23*r9*r148*r132*r230*r419 + 0.5*r23*r9*r148*r132*r231*r418 + 1.0*r23*r9*r148*r230*r231)) + 0.45*r233*r419 + r23*r9*r148;
   double r421 = r215*(r397 - 0.0078125*r170*r208*r299*r66*r7*r72*r79*r9) + 0.0078125*r145*r170*r208*r299*r66*r7*r72*r79*r9 + r396 + r389;
   double r422 = -0.0625*r12*r16*r35*r36;
   double r423 = r30*r16*r31*r32;
   double r424 = r41*(5.0*r43*r45*r9 + r423 + r422) - 1.0*r256*r27*r38*(r423 + r422)*r46;
   double r425 = r259*r47*r424 + r48*r424;
   double r426 = 0.45*r425*r53 - 0.225*r263*(0.5*r23*r9*r11*r12*r50*r425 + 0.4*r51*r425)*r51;
   double r427 = 0.0006594648241003232;
   double r428 = 0.00223117693796192;
   double r429 = 1.0/pow(r4,(32.0/3.0));
   double r430 = pow(r12,4);
   double r431 = 1.0/pow(r49,5);
   double r432 = -0.0625*r132*r154*r16*r35;
   double r433 = r30*r16*r156*r153;
   double r434 = r165*(5.0*r152*r43*r9 + r433 + r432) - 1.0*r159*r161*r162*r340*(r433 + r432);
   double r435 = r434*r166*r342 + r434*r167;
   double r436 = 0.05*r146*r22*r435*r8;
   double r437 = 0.05*r22*r425*r44*r8 + r436;
   double r438 = 0.03125*r145*r220*r437*r65*r66*r83 - 0.03125*r215*r220*r437*r65*r66*r72*r82;
   double r439 = 0.45*r233*r435 - 0.225*r231*r355*(0.4*r231*r435 + 0.5*r23*r9*r148*r132*r230*r435);
   double r440 = -0.375*r1*r222*r224*r3*r348*(0.25*r132*r148*((15.53671875*pow(r132,4)*r352*r427*r428*r435)/(pow(r122,(32.0/3.0))*pow(r168,5)) - 4.97175*r35*r16*r150*r140*r350*r236*r435)*r7*r9 + 0.1441975308641975*r234*r439 - 0.1802469135802469*r228*r439 + 0.45625*r140*r150*r16*r234*r30*r350*r351*r435 - 0.03826413706511099*r56*r16*r150*r140*r350*r435);
   double r441 = 0.0625*r12*r16*r35*r36;
   double r442 = -1.0*r16*r30*r31*r32;
   double r443 = r41*((-5.0*r43*r45*r9) + r442 + r441) - 1.0*r256*r27*r38*(r442 + r441)*r46;
   double r444 = r259*r47*r443 + r48*r443;
   double r445 = 0.45*r444*r53 - 0.225*r263*(0.5*r23*r9*r11*r12*r50*r444 + 0.4*r51*r444)*r51;
   double r446 = 0.05*r22*r44*r444*r8 + r436;
   double r447 = 0.03125*r145*r220*r446*r65*r66*r83 - 0.03125*r215*r220*r446*r65*r66*r72*r82;
   E += Factor*((-0.375*r1*r3*r222*r240) + rhoc*r217*r221 - 0.375*r1*r3*r5*r64);
   dE[0] += Factor*((-0.3015*r1*r241*r3*r5*(1.243781094527363*r14*(0.25*r11*r12*((-4.97175*r16*r17*r18*r267*r35*r57*((-25.0*r16*r18*r245*r254*r57) - 3.125*r16*r17*r18*r260*r266*r35)) - 39.774*r254*r16*r245*r18*r60*r57 - 4.97175*r35*r16*r17*r18*r60*r266*r260)*r7*r9 - 2.0*r12*r23*r242*r61*r9 - 0.1802469135802469*r264*r58 - 0.09012345679012346*r265*r54*((-0.5*r16*r18*r245*r247*r57) - 0.0625*r16*r17*r18*r260*r266*r56 - 0.5*r16*r18*r245*r247) - 0.3061130965208879*r247*r16*r245*r18*r57 + 0.1441975308641975*r264*r54 - 0.03826413706511099*r56*r16*r17*r18*r266*r260 - 0.004685928749999999*r19*r246*r21 - 124.3781094527363*r244*r16*r245*r18) + 6.167950452286547*r23*r9*r242*r12*r243*r62)) - 1.5*r7*r3*r99*r64 + r357 + rhoc*r217*(0.00546875*r218*r219*r220*r346 - 0.01640625*r218*r219*r347*r217*r345 - 0.01640625*r68*r219*r220*r217) + rhoc*r221*r346 + r268 + r217*r221);
   dE[1] += Factor*((-0.3015*r1*r241*r3*r5*(1.243781094527363*r14*(0.25*r11*r12*((-4.97175*r16*r17*r18*r267*r35*r57*(25.0*r16*r18*r245*r254*r57 - 3.125*r16*r17*r18*r266*r35*r362)) + 39.774*r254*r16*r245*r18*r60*r57 - 4.97175*r35*r16*r17*r18*r60*r266*r362)*r7*r9 + 2.0*r12*r23*r242*r61*r9 - 0.1802469135802469*r365*r58 - 0.09012345679012346*r265*r54*(0.5*r16*r18*r245*r247*r57 - 0.0625*r16*r17*r18*r266*r362*r56 + 0.5*r16*r18*r245*r247) + 0.3061130965208879*r247*r16*r245*r18*r57 + 0.1441975308641975*r365*r54 - 0.03826413706511099*r56*r16*r17*r18*r266*r362 + 0.004685928749999999*r19*r246*r21 + 124.3781094527363*r244*r16*r245*r18) - 6.167950452286547*r23*r9*r242*r12*r243*r62)) + 1.5*r7*r3*r99*r64 + rhoc*r217*(0.00546875*r218*r219*r220*r379 - 0.01640625*r218*r219*r347*r217*r378) + rhoc*r221*r379 + r357 + r268);
   dE[2] += Factor*(r404 + rhoc*r217*(0.00546875*r218*r219*r220*r398 + r399 + 0.01640625*r218*r66*r220*r217) + rhoc*r221*r398 + r388);
   dE[3] += Factor*((-0.3015*r1*r241*r3*r5*(1.243781094527363*r14*((-0.5*r11*r61*r7*r9) + 0.25*r11*r12*((-4.97175*r16*r17*r18*r267*r35*r57*((-6.25*r12*r16*r17*r35*r57) - 3.125*r16*r17*r18*r266*r35*r408)) - 9.9435*r35*r16*r17*r12*r60*r57 - 4.97175*r35*r16*r17*r18*r60*r266*r408)*r7*r9 - 0.1802469135802469*r411*r58 - 0.09012345679012346*r265*r54*((-0.125*r12*r16*r17*r56*r57) - 0.0625*r16*r17*r18*r266*r408*r56 - 0.125*r12*r16*r17*r56) - 0.07652827413022198*r56*r16*r17*r12*r57 + 0.1441975308641975*r411*r54 - 0.03826413706511099*r56*r16*r17*r18*r266*r408 - 0.0035144465625*r19*r20*r18 - 31.09452736318408*r15*r16*r17*r12) + 1.541987613071637*r7*r9*r11*r243*r62)) - 0.3015*r1*r222*r3*r348*(1.243781094527363*r224*(0.25*r132*r148*((-4.97175*r140*r150*r16*r227*r35*r352*(6.25*r132*r150*r16*r227*r35 - 3.125*r140*r150*r16*r35*r350*r415)) - 4.97175*r35*r16*r150*r140*r350*r236*r415 + 9.9435*r35*r16*r150*r132*r227*r236)*r7*r9 + 0.5*r148*r237*r7*r9 - 0.09012345679012346*r234*r351*((-0.0625*r140*r150*r16*r350*r415*r56) + 0.125*r132*r150*r16*r227*r56 + 0.125*r132*r150*r16*r56) + 0.1441975308641975*r234*r420 - 0.1802469135802469*r228*r420 - 0.03826413706511099*r56*r16*r150*r140*r350*r415 + 0.07652827413022198*r56*r16*r150*r132*r227 + 0.0035144465625*r19*r225*r140 + 31.09452736318408*r15*r16*r150*r132) - 1.541987613071637*r7*r9*r148*r349*r238) + rhoc*r217*(0.00546875*r218*r219*r220*r417 - 0.01640625*r218*r219*r347*r217*r416) + rhoc*r221*r417);
   dE[4] += Factor*(r404 + rhoc*r217*(0.00546875*r218*r219*r220*r421 + r399) + rhoc*r221*r421 + r388);
   dE[5] += Factor*(0);
   dE[6] += Factor*(0);
   dE[7] += Factor*((-0.375*r1*r14*r241*r3*r5*(0.25*r11*r12*(15.53671875*r427*r428*r429*r430*r267*r431*r425 - 4.97175*r35*r16*r17*r18*r60*r266*r425)*r7*r9 - 0.1802469135802469*r426*r58 + 0.1441975308641975*r426*r54 + 0.45625*r16*r17*r18*r265*r266*r30*r425*r54 - 0.03826413706511099*r56*r16*r17*r18*r266*r425)) + r440 + rhoc*r217*(0.00546875*r218*r219*r220*r438 - 0.01640625*r218*r219*r347*r217*r437) + rhoc*r221*r438);
   dE[8] += Factor*((-0.375*r1*r14*r241*r3*r5*(0.25*r11*r12*(15.53671875*r427*r428*r429*r430*r267*r431*r444 - 4.97175*r35*r16*r17*r18*r60*r266*r444)*r7*r9 - 0.1802469135802469*r445*r58 + 0.1441975308641975*r445*r54 + 0.45625*r16*r17*r18*r265*r266*r30*r444*r54 - 0.03826413706511099*r56*r16*r17*r18*r266*r444)) + rhoc*r217*(0.00546875*r218*r219*r220*r447 - 0.01640625*r218*r219*r347*r217*r446) + rhoc*r221*r447 + r440);
   // suppress potential unused variable warnings.
   (void)rhoc; (void)rhoo; (void)sigmacc; (void)sigmaco; (void)sigmaoo; (void)tauc;
   (void)tauo; (void)upsilonc; (void)upsilono; (void)Au; (void)Alpha1u;
   (void)Beta1u; (void)Beta2u; (void)Beta3u; (void)Beta4u; (void)Ap; (void)Alpha1p;
   (void)Beta1p; (void)Beta2p; (void)Beta3p; (void)Beta4p; (void)Aa; (void)Alpha1a;
   (void)Beta1a; (void)Beta2a; (void)Beta3a; (void)Beta4a;
}

/* kate: syntax c++; */

