// bond torsion coordinate: dihedral X=B-A,Y=C-B,Z=D-C.  plane defined by X,Y  and Y,Z
void pc_torsion(void *, double &V, double *dVdX, double const &Factor, double const *pXyz, index_t const *iAtom)
{
   index_t iAx = 3.0*iAtom[0] + 0;
   index_t iAy = 3.0*iAtom[0] + 1;
   index_t iAz = 3.0*iAtom[0] + 2;
   index_t iBx = 3.0*iAtom[1] + 0;
   index_t iBy = 3.0*iAtom[1] + 1;
   index_t iBz = 3.0*iAtom[1] + 2;
   index_t iCx = 3.0*iAtom[2] + 0;
   index_t iCy = 3.0*iAtom[2] + 1;
   index_t iCz = 3.0*iAtom[2] + 2;
   index_t iDx = 3.0*iAtom[3] + 0;
   index_t iDy = 3.0*iAtom[3] + 1;
   index_t iDz = 3.0*iAtom[3] + 2;
   double Ax = pXyz[iAx];
   double Ay = pXyz[iAy];
   double Az = pXyz[iAz];
   double Bx = pXyz[iBx];
   double By = pXyz[iBy];
   double Bz = pXyz[iBz];
   double Cx = pXyz[iCx];
   double Cy = pXyz[iCy];
   double Cz = pXyz[iCz];
   double Dx = pXyz[iDx];
   double Dy = pXyz[iDy];
   double Dz = pXyz[iDz];
   double r1 = -1.0*Bx;
   double r2 = Cx + r1;
   double r3 = -1.0*By;
   double r4 = Cy + r3;
   double r5 = -1.0*Bz;
   double r6 = Cz + r5;
   double r7 = sqr(r6) + sqr(r4) + sqr(r2);
   double r8 = sqrt(r7);
   double r9 = -1.0*Az;
   double r10 = Bz + r9;
   double r11 = -1.0*Cx;
   double r12 = Dx + r11;
   double r13 = -1.0*r12*r4;
   double r14 = -1.0*Cy;
   double r15 = Dy + r14;
   double r16 = r2*r15;
   double r17 = r16 + r13;
   double r18 = -1.0*Ay;
   double r19 = By + r18;
   double r20 = r6*r12;
   double r21 = -1.0*Cz;
   double r22 = Dz + r21;
   double r23 = -1.0*r2*r22;
   double r24 = r23 + r20;
   double r25 = -1.0*Ax;
   double r26 = Bx + r25;
   double r27 = -1.0*r15*r6;
   double r28 = r4*r22;
   double r29 = r28 + r27;
   double r30 = r26*r29 + r19*r24 + r10*r17;
   double r31 = r26*r4;
   double r32 = r31 - 1.0*r19*r2;
   double r33 = r10*r2;
   double r34 = r33 - 1.0*r26*r6;
   double r35 = r19*r6;
   double r36 = r35 - 1.0*r10*r4;
   double r37 = r36*r29 + r34*r24 + r32*r17;
   double r38 = r14 + By;
   double r39 = 1.0/(sqr(r37) + r7*sqr(r30));
   double r40 = r21 + Bz;
   double r41 = r11 + Bx;
   double r42 = -1.0*Dy;
   double r43 = r42 + Cy;
   double r44 = 1.0/r8;
   double r45 = -1.0*Dz;
   double r46 = r45 + Cz;
   double r47 = -1.0*Dx;
   double r48 = r47 + Cx;
   double r49 = Dy + r3;
   double r50 = r45 + Bz;
   double r51 = r47 + Bx;
   double r52 = Dz + r5;
   double r53 = Dx + r1;
   double r54 = r42 + By;
   V += Factor*(atan2(r8*r30,r37));
   dVdX[iAx] += Factor*(r37*r39*(r6*r15 - 1.0*r22*r4)*r8 - 1.0*(r6*r24 + r38*r17)*r30*r39*r8);
   dVdX[iAy] += Factor*(r37*r39*(r2*r22 - 1.0*r12*r6)*r8 - 1.0*(r40*r29 + r2*r17)*r30*r39*r8);
   dVdX[iAz] += Factor*((r4*r12 - 1.0*r15*r2)*r37*r39*r8 - 1.0*(r4*r29 + r41*r24)*r30*r39*r8);
   dVdX[iBx] += Factor*(r37*r39*(r8*(r28 + r19*r22 + r27 + r10*r43) - 1.0*r2*r30*r44) - 1.0*((r21 + Az)*r24 + r34*r22 + (Cy + r18)*r17 + r32*r43)*r30*r39*r8);
   dVdX[iBy] += Factor*(r37*r39*(r8*(r23 + r26*r46 + r20 + r10*r12) - 1.0*r30*r4*r44) - 1.0*((Cz + r9)*r29 + r36*r46 + (r11 + Ax)*r17 + r32*r12)*r30*r39*r8);
   dVdX[iBz] += Factor*(r37*r39*(r8*(r16 + r26*r15 + r13 + r19*r48) - 1.0*r30*r44*r6) - 1.0*((r14 + Ay)*r29 + (Cx + r25)*r24 + r36*r15 + r34*r48)*r30*r39*r8);
   dVdX[iCx] += Factor*(r37*(r2*r44*r30 + r8*(r19*r50 + r10*r49))*r39 - 1.0*(r10*r24 + r34*r50 + (r3 + Ay)*r17 + r32*r49)*r30*r39*r8);
   dVdX[iCy] += Factor*(r37*(r4*r44*r30 + r8*(r26*r52 + r10*r51))*r39 - 1.0*((r5 + Az)*r29 + r36*r52 + r26*r17 + r32*r51)*r30*r39*r8);
   dVdX[iCz] += Factor*(r37*(r6*r44*r30 + r8*(r26*r54 + r19*r53))*r39 - 1.0*(r19*r29 + (r1 + Ax)*r24 + r36*r54 + r34*r53)*r30*r39*r8);
   dVdX[iDx] += Factor*((r35 + r10*r38)*r8*r37*r39 - 1.0*r30*(r6*r34 + r38*r32)*r39*r8);
   dVdX[iDy] += Factor*((r26*r40 + r33)*r8*r37*r39 - 1.0*r30*(r40*r36 + r2*r32)*r39*r8);
   dVdX[iDz] += Factor*((r31 + r19*r41)*r8*r37*r39 - 1.0*r30*(r4*r36 + r41*r34)*r39*r8);
   // suppress potential unused variable warnings.
   (void)Ax; (void)Ay; (void)Az; (void)Bx; (void)By; (void)Bz; (void)Cx; (void)Cy;
   (void)Cz; (void)Dx; (void)Dy; (void)Dz;
}

/* kate: syntax c++; */

