// distance between center of positions (AB) and C
void pc_dist_cop21_hess(void *, double *dVdXX, index_t nb, double const &Factor, double const *pXyz, index_t const *iAtom)
{
   index_t iAx = 3.0*iAtom[0] + 0;
   index_t iAy = 3.0*iAtom[0] + 1;
   index_t iAz = 3.0*iAtom[0] + 2;
   index_t iBx = 3.0*iAtom[1] + 0;
   index_t iBy = 3.0*iAtom[1] + 1;
   index_t iBz = 3.0*iAtom[1] + 2;
   index_t iCx = 3.0*iAtom[2] + 0;
   index_t iCy = 3.0*iAtom[2] + 1;
   index_t iCz = 3.0*iAtom[2] + 2;
   double Ax = pXyz[iAx];
   double Ay = pXyz[iAy];
   double Az = pXyz[iAz];
   double Bx = pXyz[iBx];
   double By = pXyz[iBy];
   double Bz = pXyz[iBz];
   double Cx = pXyz[iCx];
   double Cy = pXyz[iCy];
   double Cz = pXyz[iCz];
   double r1 = 0.5*(Bx + Ax) - 1.0*Cx;
   double r2 = sqr(r1);
   double r3 = 0.5*(By + Ay) - 1.0*Cy;
   double r4 = sqr(r3);
   double r5 = 0.5*(Bz + Az) - 1.0*Cz;
   double r6 = sqr(r5);
   double r7 = sqrt(r6 + r4 + r2);
   double r8 = 1.0/pow(r7,3);
   double r9 = 1.0/r7;
   double r10 = 0.25*r9;
   double r11 = r10 - 0.25*r2*r8;
   double r12 = -0.25*r1*r3*r8;
   double r13 = -0.25*r1*r5*r8;
   double r14 = -0.5*r9;
   double r15 = 0.5*r2*r8 + r14;
   double r16 = 0.5*r1*r3*r8;
   double r17 = 0.5*r1*r5*r8;
   double r18 = r10 - 0.25*r4*r8;
   double r19 = -0.25*r3*r5*r8;
   double r20 = 0.5*r4*r8 + r14;
   double r21 = 0.5*r3*r5*r8;
   double r22 = r10 - 0.25*r6*r8;
   double r23 = 0.5*r6*r8 + r14;
   double r24 = -1.0*r1*r3*r8;
   double r25 = -1.0*r1*r5*r8;
   double r26 = -1.0*r3*r5*r8;
   dVdXX[iAx + nb*(iAx)] += Factor*(r11);
   dVdXX[iAx + nb*(iAy)] += Factor*(r12);
   dVdXX[iAx + nb*(iAz)] += Factor*(r13);
   dVdXX[iAx + nb*(iBx)] += Factor*(r11);
   dVdXX[iAx + nb*(iBy)] += Factor*(r12);
   dVdXX[iAx + nb*(iBz)] += Factor*(r13);
   dVdXX[iAx + nb*(iCx)] += Factor*(r15);
   dVdXX[iAx + nb*(iCy)] += Factor*(r16);
   dVdXX[iAx + nb*(iCz)] += Factor*(r17);
   dVdXX[iAy + nb*(iAx)] += Factor*(r12);
   dVdXX[iAy + nb*(iAy)] += Factor*(r18);
   dVdXX[iAy + nb*(iAz)] += Factor*(r19);
   dVdXX[iAy + nb*(iBx)] += Factor*(r12);
   dVdXX[iAy + nb*(iBy)] += Factor*(r18);
   dVdXX[iAy + nb*(iBz)] += Factor*(r19);
   dVdXX[iAy + nb*(iCx)] += Factor*(r16);
   dVdXX[iAy + nb*(iCy)] += Factor*(r20);
   dVdXX[iAy + nb*(iCz)] += Factor*(r21);
   dVdXX[iAz + nb*(iAx)] += Factor*(r13);
   dVdXX[iAz + nb*(iAy)] += Factor*(r19);
   dVdXX[iAz + nb*(iAz)] += Factor*(r22);
   dVdXX[iAz + nb*(iBx)] += Factor*(r13);
   dVdXX[iAz + nb*(iBy)] += Factor*(r19);
   dVdXX[iAz + nb*(iBz)] += Factor*(r22);
   dVdXX[iAz + nb*(iCx)] += Factor*(r17);
   dVdXX[iAz + nb*(iCy)] += Factor*(r21);
   dVdXX[iAz + nb*(iCz)] += Factor*(r23);
   dVdXX[iBx + nb*(iAx)] += Factor*(r11);
   dVdXX[iBx + nb*(iAy)] += Factor*(r12);
   dVdXX[iBx + nb*(iAz)] += Factor*(r13);
   dVdXX[iBx + nb*(iBx)] += Factor*(r11);
   dVdXX[iBx + nb*(iBy)] += Factor*(r12);
   dVdXX[iBx + nb*(iBz)] += Factor*(r13);
   dVdXX[iBx + nb*(iCx)] += Factor*(r15);
   dVdXX[iBx + nb*(iCy)] += Factor*(r16);
   dVdXX[iBx + nb*(iCz)] += Factor*(r17);
   dVdXX[iBy + nb*(iAx)] += Factor*(r12);
   dVdXX[iBy + nb*(iAy)] += Factor*(r18);
   dVdXX[iBy + nb*(iAz)] += Factor*(r19);
   dVdXX[iBy + nb*(iBx)] += Factor*(r12);
   dVdXX[iBy + nb*(iBy)] += Factor*(r18);
   dVdXX[iBy + nb*(iBz)] += Factor*(r19);
   dVdXX[iBy + nb*(iCx)] += Factor*(r16);
   dVdXX[iBy + nb*(iCy)] += Factor*(r20);
   dVdXX[iBy + nb*(iCz)] += Factor*(r21);
   dVdXX[iBz + nb*(iAx)] += Factor*(r13);
   dVdXX[iBz + nb*(iAy)] += Factor*(r19);
   dVdXX[iBz + nb*(iAz)] += Factor*(r22);
   dVdXX[iBz + nb*(iBx)] += Factor*(r13);
   dVdXX[iBz + nb*(iBy)] += Factor*(r19);
   dVdXX[iBz + nb*(iBz)] += Factor*(r22);
   dVdXX[iBz + nb*(iCx)] += Factor*(r17);
   dVdXX[iBz + nb*(iCy)] += Factor*(r21);
   dVdXX[iBz + nb*(iCz)] += Factor*(r23);
   dVdXX[iCx + nb*(iAx)] += Factor*(r15);
   dVdXX[iCx + nb*(iAy)] += Factor*(r16);
   dVdXX[iCx + nb*(iAz)] += Factor*(r17);
   dVdXX[iCx + nb*(iBx)] += Factor*(r15);
   dVdXX[iCx + nb*(iBy)] += Factor*(r16);
   dVdXX[iCx + nb*(iBz)] += Factor*(r17);
   dVdXX[iCx + nb*(iCx)] += Factor*(r9 - 1.0*r2*r8);
   dVdXX[iCx + nb*(iCy)] += Factor*(r24);
   dVdXX[iCx + nb*(iCz)] += Factor*(r25);
   dVdXX[iCy + nb*(iAx)] += Factor*(r16);
   dVdXX[iCy + nb*(iAy)] += Factor*(r20);
   dVdXX[iCy + nb*(iAz)] += Factor*(r21);
   dVdXX[iCy + nb*(iBx)] += Factor*(r16);
   dVdXX[iCy + nb*(iBy)] += Factor*(r20);
   dVdXX[iCy + nb*(iBz)] += Factor*(r21);
   dVdXX[iCy + nb*(iCx)] += Factor*(r24);
   dVdXX[iCy + nb*(iCy)] += Factor*(r9 - 1.0*r4*r8);
   dVdXX[iCy + nb*(iCz)] += Factor*(r26);
   dVdXX[iCz + nb*(iAx)] += Factor*(r17);
   dVdXX[iCz + nb*(iAy)] += Factor*(r21);
   dVdXX[iCz + nb*(iAz)] += Factor*(r23);
   dVdXX[iCz + nb*(iBx)] += Factor*(r17);
   dVdXX[iCz + nb*(iBy)] += Factor*(r21);
   dVdXX[iCz + nb*(iBz)] += Factor*(r23);
   dVdXX[iCz + nb*(iCx)] += Factor*(r25);
   dVdXX[iCz + nb*(iCy)] += Factor*(r26);
   dVdXX[iCz + nb*(iCz)] += Factor*(r9 - 1.0*r6*r8);
   // suppress potential unused variable warnings.
   (void)Ax; (void)Ay; (void)Az; (void)Bx; (void)By; (void)Bz; (void)Cx; (void)Cy;
   (void)Cz;
}

/* kate: syntax c++; */

