// bend coordinate: angle between A-B and C-B
void pc_bend_hess(void *, double *dVdXX, index_t nb, double const &Factor, double const *pXyz, index_t const *iAtom)
{
   index_t iAx = 3.0*iAtom[0] + 0;
   index_t iAy = 3.0*iAtom[0] + 1;
   index_t iAz = 3.0*iAtom[0] + 2;
   index_t iBx = 3.0*iAtom[1] + 0;
   index_t iBy = 3.0*iAtom[1] + 1;
   index_t iBz = 3.0*iAtom[1] + 2;
   index_t iCx = 3.0*iAtom[2] + 0;
   index_t iCy = 3.0*iAtom[2] + 1;
   index_t iCz = 3.0*iAtom[2] + 2;
   double Ax = pXyz[iAx];
   double Ay = pXyz[iAy];
   double Az = pXyz[iAz];
   double Bx = pXyz[iBx];
   double By = pXyz[iBy];
   double Bz = pXyz[iBz];
   double Cx = pXyz[iCx];
   double Cy = pXyz[iCy];
   double Cz = pXyz[iCz];
   double r1 = -1.0*Bx;
   double r2 = r1 + Ax;
   double r3 = sqr(r2);
   double r4 = -1.0*By;
   double r5 = r4 + Ay;
   double r6 = sqr(r5);
   double r7 = -1.0*Bz;
   double r8 = r7 + Az;
   double r9 = sqr(r8);
   double r10 = r9 + r6 + r3;
   double r11 = 1.0/r10;
   double r12 = Cx + r1;
   double r13 = Cy + r4;
   double r14 = Cz + r7;
   double r15 = r8*r14 + r5*r13 + r2*r12;
   double r16 = sqr(r15);
   double r17 = sqr(r12);
   double r18 = sqr(r13);
   double r19 = sqr(r14);
   double r20 = r19 + r18 + r17;
   double r21 = 1.0/r20;
   double r22 = sqrt(1 - 1.0*r11*r16*r21);
   double r23 = 1.0/r22;
   double r24 = sqrt(r10);
   double r25 = 1.0/pow(r24,3);
   double r26 = sqrt(r20);
   double r27 = 1.0/r26;
   double r28 = 1.0/pow(r24,5);
   double r29 = 3.0*r15*r27*r28*r3;
   double r30 = -1.0*r15*r25*r27;
   double r31 = 1.0/sqr(r10);
   double r32 = 2.0*r16*r2*r21*r31 - 2.0*r11*r12*r15*r21;
   double r33 = 1.0/pow(r22,3);
   double r34 = 1.0/r24;
   double r35 = r34*r12*r27 - 1.0*r15*r2*r25*r27;
   double r36 = 3.0*r15*r2*r27*r28*r5;
   double r37 = -1.0*r23*((-1.0*r12*r25*r27*r5) + r36 - 1.0*r13*r2*r25*r27);
   double r38 = 2.0*r16*r21*r31*r5 - 2.0*r11*r13*r15*r21;
   double r39 = 2.0*r16*r21*r31*r8 - 2.0*r11*r14*r15*r21;
   double r40 = 3.0*r15*r2*r27*r28*r8;
   double r41 = -1.0*r23*((-1.0*r12*r25*r27*r8) + r40 - 1.0*r14*r2*r25*r27);
   double r42 = 1.0/pow(r26,3);
   double r43 = -1.0*r12*r15*r2*r25*r42;
   double r44 = -1.0*r27*r34;
   double r45 = (-1.0*Cx) + 2.0*Bx - 1.0*Ax;
   double r46 = r25*r15*r27;
   double r47 = -1.0*r23*(r46 - 1.0*r2*r25*r27*r45 + r44 + r43 + r34*r17*r42 - 3.0*r15*r27*r28*r3 + r2*r25*r12*r27);
   double r48 = 1.0/sqr(r20);
   double r49 = (-2.0*r11*r12*r16*r48) - 2.0*r11*r15*r21*r45 - 2.0*r16*r2*r21*r31;
   double r50 = r34*r12*r13*r42;
   double r51 = -1.0*r13*r15*r2*r25*r42;
   double r52 = (-1.0*Cy) + 2.0*By - 1.0*Ay;
   double r53 = -3.0*r15*r2*r27*r28*r5;
   double r54 = -1.0*r23*(r53 - 1.0*r2*r25*r27*r52 + r51 + r50 + r5*r25*r12*r27);
   double r55 = (-2.0*r11*r15*r21*r52) - 2.0*r16*r21*r31*r5 - 2.0*r11*r13*r16*r48;
   double r56 = (-1.0*Cz) + 2.0*Bz - 1.0*Az;
   double r57 = (-2.0*r16*r21*r31*r8) - 2.0*r11*r15*r21*r56 - 2.0*r11*r14*r16*r48;
   double r58 = r34*r12*r14*r42;
   double r59 = -1.0*r14*r15*r2*r25*r42;
   double r60 = -3.0*r15*r2*r27*r28*r8;
   double r61 = -1.0*r23*(r60 + r59 + r58 - 1.0*r2*r25*r27*r56 + r25*r8*r12*r27);
   double r62 = r34*r27;
   double r63 = -1.0*r23*(r62 - 1.0*r17*r34*r42 + r2*r25*r12*r15*r42 - 1.0*r25*r27*r3);
   double r64 = 2.0*r11*r12*r16*r48 - 2.0*r11*r15*r2*r21;
   double r65 = -1.0*r12*r13*r34*r42;
   double r66 = r2*r25*r13*r15*r42;
   double r67 = -1.0*r2*r25*r27*r5;
   double r68 = -1.0*r23*(r67 + r66 + r65);
   double r69 = 2.0*r11*r13*r16*r48 - 2.0*r11*r15*r21*r5;
   double r70 = -1.0*r12*r14*r34*r42;
   double r71 = r2*r25*r14*r15*r42;
   double r72 = -1.0*r2*r25*r27*r8;
   double r73 = -1.0*r23*(r72 + r71 + r70);
   double r74 = 2.0*r11*r14*r16*r48 - 2.0*r11*r15*r21*r8;
   double r75 = r34*r13*r27 - 1.0*r15*r25*r27*r5;
   double r76 = 3.0*r15*r27*r28*r6;
   double r77 = 3.0*r15*r27*r28*r5*r8;
   double r78 = -1.0*r23*((-1.0*r13*r25*r27*r8) + r77 - 1.0*r14*r25*r27*r5);
   double r79 = -1.0*r12*r15*r25*r42*r5;
   double r80 = -1.0*r23*(r79 + r53 + r50 - 1.0*r25*r27*r45*r5 + r2*r25*r13*r27);
   double r81 = -1.0*r13*r15*r25*r42*r5;
   double r82 = -1.0*r23*(r81 - 3.0*r15*r27*r28*r6 - 1.0*r25*r27*r5*r52 + r46 + r44 + r34*r18*r42 + r5*r25*r13*r27);
   double r83 = r34*r13*r14*r42;
   double r84 = -1.0*r14*r15*r25*r42*r5;
   double r85 = -3.0*r15*r27*r28*r5*r8;
   double r86 = -1.0*r23*(r85 + r84 + r83 - 1.0*r25*r27*r5*r56 + r25*r8*r13*r27);
   double r87 = r5*r25*r12*r15*r42;
   double r88 = -1.0*r23*(r67 + r87 + r65);
   double r89 = -1.0*r23*(r62 - 1.0*r25*r27*r6 - 1.0*r18*r34*r42 + r5*r25*r13*r15*r42);
   double r90 = -1.0*r13*r14*r34*r42;
   double r91 = r5*r25*r14*r15*r42;
   double r92 = -1.0*r25*r27*r5*r8;
   double r93 = -1.0*r23*(r92 + r91 + r90);
   double r94 = r34*r14*r27 - 1.0*r15*r25*r27*r8;
   double r95 = 3.0*r15*r27*r28*r9;
   double r96 = -1.0*r12*r15*r25*r42*r8;
   double r97 = -1.0*r23*(r96 - 1.0*r25*r27*r45*r8 + r60 + r58 + r2*r25*r14*r27);
   double r98 = -1.0*r13*r15*r25*r42*r8;
   double r99 = -1.0*r23*(r98 + r85 + r83 - 1.0*r25*r27*r52*r8 + r5*r25*r14*r27);
   double r100 = -1.0*r14*r15*r25*r42*r8;
   double r101 = -1.0*r23*((-3.0*r15*r27*r28*r9) - 1.0*r25*r27*r56*r8 + r46 + r44 + r34*r19*r42 + r25*r8*r14*r27 + r100);
   double r102 = r25*r8*r12*r15*r42;
   double r103 = -1.0*r23*(r72 + r102 + r70);
   double r104 = r25*r8*r13*r15*r42;
   double r105 = -1.0*r23*(r92 + r104 + r90);
   double r106 = -1.0*r23*((-1.0*r25*r27*r9) + r62 - 1.0*r19*r34*r42 + r25*r8*r14*r15*r42);
   double r107 = r2*r25*r15*r27 + r34*r45*r27 + r34*r12*r15*r42;
   double r108 = 1.0/pow(r26,5);
   double r109 = 3.0*r108*r15*r17*r34;
   double r110 = -1.0*r15*r34*r42;
   double r111 = 2.0*r27*r34;
   double r112 = 3.0*r108*r12*r13*r15*r34;
   double r113 = -1.0*r23*(r36 + r2*r25*r52*r27 + r5*r25*r45*r27 + r66 + r87 + r34*r45*r13*r42 + r34*r12*r52*r42 + r112);
   double r114 = 3.0*r108*r12*r14*r15*r34;
   double r115 = -1.0*r23*(r40 + r2*r25*r56*r27 + r25*r8*r45*r27 + r71 + r102 + r34*r45*r14*r42 + r34*r12*r56*r42 + r114);
   double r116 = r34*r15*r42;
   double r117 = -1.0*r23*((-1.0*r12*r34*r42*r45) + r44 + r43 + r2*r34*r12*r42 - 3.0*r108*r15*r17*r34 + r3*r25*r27 + r116);
   double r118 = -3.0*r108*r12*r13*r15*r34;
   double r119 = r2*r5*r25*r27;
   double r120 = -1.0*r23*(r51 - 1.0*r13*r34*r42*r45 + r5*r34*r12*r42 + r119 + r118);
   double r121 = -3.0*r108*r12*r14*r15*r34;
   double r122 = r2*r25*r8*r27;
   double r123 = -1.0*r23*(r59 - 1.0*r14*r34*r42*r45 + r34*r8*r12*r42 + r122 + r121);
   double r124 = r5*r25*r15*r27 + r34*r52*r27 + r34*r13*r15*r42;
   double r125 = 3.0*r108*r15*r18*r34;
   double r126 = 3.0*r108*r13*r14*r15*r34;
   double r127 = -1.0*r23*(r77 + r5*r25*r56*r27 + r25*r8*r52*r27 + r91 + r104 + r34*r52*r14*r42 + r34*r13*r56*r42 + r126);
   double r128 = -1.0*r23*(r79 - 1.0*r12*r34*r42*r52 + r2*r34*r13*r42 + r119 + r118);
   double r129 = -1.0*r23*(r81 - 1.0*r13*r34*r42*r52 + r44 + r5*r34*r13*r42 - 3.0*r108*r15*r18*r34 + r6*r25*r27 + r116);
   double r130 = -3.0*r108*r13*r14*r15*r34;
   double r131 = r5*r25*r8*r27;
   double r132 = -1.0*r23*(r84 - 1.0*r14*r34*r42*r52 + r34*r8*r13*r42 + r131 + r130);
   double r133 = r25*r8*r15*r27 + r34*r56*r27 + r34*r14*r15*r42;
   double r134 = 3.0*r108*r15*r19*r34;
   double r135 = -1.0*r23*(r96 - 1.0*r12*r34*r42*r56 + r2*r34*r14*r42 + r122 + r121);
   double r136 = -1.0*r23*(r98 - 1.0*r13*r34*r42*r56 + r5*r34*r14*r42 + r131 + r130);
   double r137 = -1.0*r23*((-1.0*r14*r34*r42*r56) + r44 + r34*r8*r14*r42 - 3.0*r108*r15*r19*r34 + r25*r9*r27 + r116 + r100);
   double r138 = r2*r34*r27 - 1.0*r12*r15*r34*r42;
   double r139 = -1.0*r23*((-1.0*r12*r34*r42*r5) - 1.0*r13*r2*r34*r42 + r112);
   double r140 = -1.0*r23*((-1.0*r12*r34*r42*r8) - 1.0*r14*r2*r34*r42 + r114);
   double r141 = r5*r34*r27 - 1.0*r13*r15*r34*r42;
   double r142 = -1.0*r23*((-1.0*r13*r34*r42*r8) - 1.0*r14*r34*r42*r5 + r126);
   double r143 = r34*r8*r27 - 1.0*r14*r15*r34*r42;
   dVdXX[iAx + nb*(iAx)] += Factor*(0.5*r32*r33*r35 - 1.0*r23*(r30 + r29 - 2.0*r12*r2*r25*r27));
   dVdXX[iAx + nb*(iAy)] += Factor*(0.5*r33*r35*r38 + r37);
   dVdXX[iAx + nb*(iAz)] += Factor*(r41 + 0.5*r33*r35*r39);
   dVdXX[iAx + nb*(iBx)] += Factor*(0.5*r33*r35*r49 + r47);
   dVdXX[iAx + nb*(iBy)] += Factor*(0.5*r33*r35*r55 + r54);
   dVdXX[iAx + nb*(iBz)] += Factor*(r61 + 0.5*r33*r35*r57);
   dVdXX[iAx + nb*(iCx)] += Factor*(0.5*r33*r35*r64 + r63);
   dVdXX[iAx + nb*(iCy)] += Factor*(0.5*r33*r35*r69 + r68);
   dVdXX[iAx + nb*(iCz)] += Factor*(0.5*r33*r35*r74 + r73);
   dVdXX[iAy + nb*(iAx)] += Factor*(0.5*r32*r33*r75 + r37);
   dVdXX[iAy + nb*(iAy)] += Factor*(0.5*r33*r38*r75 - 1.0*r23*(r76 - 2.0*r13*r25*r27*r5 + r30));
   dVdXX[iAy + nb*(iAz)] += Factor*(r78 + 0.5*r33*r39*r75);
   dVdXX[iAy + nb*(iBx)] += Factor*(r80 + 0.5*r33*r49*r75);
   dVdXX[iAy + nb*(iBy)] += Factor*(r82 + 0.5*r33*r55*r75);
   dVdXX[iAy + nb*(iBz)] += Factor*(r86 + 0.5*r33*r57*r75);
   dVdXX[iAy + nb*(iCx)] += Factor*(r88 + 0.5*r33*r64*r75);
   dVdXX[iAy + nb*(iCy)] += Factor*(r89 + 0.5*r33*r69*r75);
   dVdXX[iAy + nb*(iCz)] += Factor*(r93 + 0.5*r33*r74*r75);
   dVdXX[iAz + nb*(iAx)] += Factor*(0.5*r32*r33*r94 + r41);
   dVdXX[iAz + nb*(iAy)] += Factor*(0.5*r33*r38*r94 + r78);
   dVdXX[iAz + nb*(iAz)] += Factor*(0.5*r33*r39*r94 - 1.0*r23*(r95 - 2.0*r14*r25*r27*r8 + r30));
   dVdXX[iAz + nb*(iBx)] += Factor*(r97 + 0.5*r33*r49*r94);
   dVdXX[iAz + nb*(iBy)] += Factor*(r99 + 0.5*r33*r55*r94);
   dVdXX[iAz + nb*(iBz)] += Factor*(0.5*r33*r57*r94 + r101);
   dVdXX[iAz + nb*(iCx)] += Factor*(0.5*r33*r64*r94 + r103);
   dVdXX[iAz + nb*(iCy)] += Factor*(0.5*r33*r69*r94 + r105);
   dVdXX[iAz + nb*(iCz)] += Factor*(0.5*r33*r74*r94 + r106);
   dVdXX[iBx + nb*(iAx)] += Factor*(r47 + 0.5*r107*r32*r33);
   dVdXX[iBx + nb*(iAy)] += Factor*(r80 + 0.5*r107*r33*r38);
   dVdXX[iBx + nb*(iAz)] += Factor*(r97 + 0.5*r107*r33*r39);
   dVdXX[iBx + nb*(iBx)] += Factor*(0.5*r107*r33*r49 - 1.0*r23*(2.0*r12*r34*r42*r45 + 2.0*r2*r25*r27*r45 + 2.0*r12*r15*r2*r25*r42 + r30 + r29 + r111 + r110 + r109));
   dVdXX[iBx + nb*(iBy)] += Factor*(0.5*r107*r33*r55 + r113);
   dVdXX[iBx + nb*(iBz)] += Factor*(0.5*r107*r33*r57 + r115);
   dVdXX[iBx + nb*(iCx)] += Factor*(0.5*r107*r33*r64 + r117);
   dVdXX[iBx + nb*(iCy)] += Factor*(0.5*r107*r33*r69 + r120);
   dVdXX[iBx + nb*(iCz)] += Factor*(0.5*r107*r33*r74 + r123);
   dVdXX[iBy + nb*(iAx)] += Factor*(r54 + 0.5*r124*r32*r33);
   dVdXX[iBy + nb*(iAy)] += Factor*(r82 + 0.5*r124*r33*r38);
   dVdXX[iBy + nb*(iAz)] += Factor*(r99 + 0.5*r124*r33*r39);
   dVdXX[iBy + nb*(iBx)] += Factor*(0.5*r124*r33*r49 + r113);
   dVdXX[iBy + nb*(iBy)] += Factor*(0.5*r124*r33*r55 - 1.0*r23*(r76 + 2.0*r25*r27*r5*r52 + 2.0*r13*r34*r42*r52 + 2.0*r13*r15*r25*r42*r5 + r30 + r125 + r111 + r110));
   dVdXX[iBy + nb*(iBz)] += Factor*(0.5*r124*r33*r57 + r127);
   dVdXX[iBy + nb*(iCx)] += Factor*(0.5*r124*r33*r64 + r128);
   dVdXX[iBy + nb*(iCy)] += Factor*(0.5*r124*r33*r69 + r129);
   dVdXX[iBy + nb*(iCz)] += Factor*(0.5*r124*r33*r74 + r132);
   dVdXX[iBz + nb*(iAx)] += Factor*(r61 + 0.5*r133*r32*r33);
   dVdXX[iBz + nb*(iAy)] += Factor*(r86 + 0.5*r133*r33*r38);
   dVdXX[iBz + nb*(iAz)] += Factor*(0.5*r133*r33*r39 + r101);
   dVdXX[iBz + nb*(iBx)] += Factor*(0.5*r133*r33*r49 + r115);
   dVdXX[iBz + nb*(iBy)] += Factor*(0.5*r133*r33*r55 + r127);
   dVdXX[iBz + nb*(iBz)] += Factor*(0.5*r133*r33*r57 - 1.0*r23*(r95 + 2.0*r25*r27*r56*r8 + 2.0*r14*r15*r25*r42*r8 + 2.0*r14*r34*r42*r56 + r30 + r134 + r111 + r110));
   dVdXX[iBz + nb*(iCx)] += Factor*(0.5*r133*r33*r64 + r135);
   dVdXX[iBz + nb*(iCy)] += Factor*(0.5*r133*r33*r69 + r136);
   dVdXX[iBz + nb*(iCz)] += Factor*(0.5*r133*r33*r74 + r137);
   dVdXX[iCx + nb*(iAx)] += Factor*(r63 + 0.5*r138*r32*r33);
   dVdXX[iCx + nb*(iAy)] += Factor*(r88 + 0.5*r138*r33*r38);
   dVdXX[iCx + nb*(iAz)] += Factor*(0.5*r138*r33*r39 + r103);
   dVdXX[iCx + nb*(iBx)] += Factor*(0.5*r138*r33*r49 + r117);
   dVdXX[iCx + nb*(iBy)] += Factor*(0.5*r138*r33*r55 + r128);
   dVdXX[iCx + nb*(iBz)] += Factor*(0.5*r138*r33*r57 + r135);
   dVdXX[iCx + nb*(iCx)] += Factor*(0.5*r138*r33*r64 - 1.0*r23*((-2.0*r12*r2*r34*r42) + r110 + r109));
   dVdXX[iCx + nb*(iCy)] += Factor*(0.5*r138*r33*r69 + r139);
   dVdXX[iCx + nb*(iCz)] += Factor*(0.5*r138*r33*r74 + r140);
   dVdXX[iCy + nb*(iAx)] += Factor*(r68 + 0.5*r141*r32*r33);
   dVdXX[iCy + nb*(iAy)] += Factor*(r89 + 0.5*r141*r33*r38);
   dVdXX[iCy + nb*(iAz)] += Factor*(0.5*r141*r33*r39 + r105);
   dVdXX[iCy + nb*(iBx)] += Factor*(0.5*r141*r33*r49 + r120);
   dVdXX[iCy + nb*(iBy)] += Factor*(0.5*r141*r33*r55 + r129);
   dVdXX[iCy + nb*(iBz)] += Factor*(0.5*r141*r33*r57 + r136);
   dVdXX[iCy + nb*(iCx)] += Factor*(0.5*r141*r33*r64 + r139);
   dVdXX[iCy + nb*(iCy)] += Factor*(0.5*r141*r33*r69 - 1.0*r23*((-2.0*r13*r34*r42*r5) + r125 + r110));
   dVdXX[iCy + nb*(iCz)] += Factor*(0.5*r141*r33*r74 + r142);
   dVdXX[iCz + nb*(iAx)] += Factor*(r73 + 0.5*r143*r32*r33);
   dVdXX[iCz + nb*(iAy)] += Factor*(r93 + 0.5*r143*r33*r38);
   dVdXX[iCz + nb*(iAz)] += Factor*(0.5*r143*r33*r39 + r106);
   dVdXX[iCz + nb*(iBx)] += Factor*(0.5*r143*r33*r49 + r123);
   dVdXX[iCz + nb*(iBy)] += Factor*(0.5*r143*r33*r55 + r132);
   dVdXX[iCz + nb*(iBz)] += Factor*(0.5*r143*r33*r57 + r137);
   dVdXX[iCz + nb*(iCx)] += Factor*(0.5*r143*r33*r64 + r140);
   dVdXX[iCz + nb*(iCy)] += Factor*(0.5*r143*r33*r69 + r142);
   dVdXX[iCz + nb*(iCz)] += Factor*(0.5*r143*r33*r74 - 1.0*r23*((-2.0*r14*r34*r42*r8) + r134 + r110));
   // suppress potential unused variable warnings.
   (void)Ax; (void)Ay; (void)Az; (void)Bx; (void)By; (void)Bz; (void)Cx; (void)Cy;
   (void)Cz;
}

/* kate: syntax c++; */

