/* CtDftDispCorr.inl v20160702 EST [storm, Gerald Knizia] */
namespace dftd3 {

// called r2r4 in dftd3.f, contains sqrt(0.5*r2r4(i)*sqrt(float(i))) (i.e., transformed <r^2>/<r^4> values)
static double const g_C6R2r4TermTable[95] = {
   0.0, 2.00734898, 1.56637132, 5.01986934, 3.85379032, 3.64446594, 3.10492822, 2.71175247,
   2.5936168, 2.3882525, 2.21522516, 6.58585536, 5.46295967, 5.65216669, 4.88284902, 4.29727576,
   4.04108902, 3.72932356, 3.44677275, 7.97762753, 7.07623947, 6.60844053, 6.28791364, 6.07728703,
   5.54643096, 5.80491167, 5.58415602, 5.41374528, 5.28497229, 5.22592821, 5.09817141, 6.12149689,
   5.54083734, 5.06696878, 4.87005108, 4.59089647, 4.31176304, 9.55461698, 8.67396077, 7.97210197,
   7.43439917, 6.58711862, 6.19536215, 6.0151729, 5.8162341, 5.65710424, 5.52640661, 5.44263305,
   5.58285373, 7.02081898, 6.46815523, 5.9808912, 5.81686657, 5.53321815, 5.25477007, 11.02204549,
   10.15679528, 9.35167836, 9.06926079, 8.97241155, 8.90092807, 8.8598484, 8.81736827, 8.7931771,
   7.89969626, 8.80588454, 8.42439218, 8.54289262, 8.4758337, 8.45090888, 8.47339339, 7.83525634,
   8.20702843, 7.70559063, 7.32755997, 7.03887381, 6.6897872, 6.05450052, 5.88752022, 5.70661499,
   5.78450695, 7.79780729, 7.26443867, 6.78151984, 6.67883169, 6.39024318, 6.09527958, 11.79156076,
   11.10997644, 9.51377795, 8.67197068, 8.77140725, 8.65402716, 8.53923501, 8.85024712
};

// covalent radii in a.u., as used in the D3 program. They come from Pykkoe, apparently (scaled by k2=4/3 and converted to abohr).
static double const g_C6RcovTable[95] = {
   0.0, 0.80628308, 1.15903197, 3.02356173, 2.36845659, 1.94011865, 1.88972601, 1.78894056,
   1.58736983, 1.61256616, 1.68815527, 3.52748848, 3.14954334, 2.84718717, 2.62041997, 2.7715982,
   2.57002732, 2.49443835, 2.41884923, 4.434557, 3.8802373, 3.35111422, 3.07395437, 3.04875805,
   2.7715982, 2.69600923, 2.62041997, 2.51963467, 2.49443835, 2.544831, 2.74640188, 2.82199085,
   2.74640188, 2.89757982, 2.7715982, 2.87238349, 2.94797246, 4.7621095, 4.2077898, 3.70386304,
   3.50229216, 3.3259179, 3.12434702, 2.89757982, 2.84718717, 2.84718717, 2.72120556, 2.89757982,
   3.0991507, 3.22513231, 3.17473967, 3.17473967, 3.0991507, 3.3259179, 3.30072128, 5.26603625,
   4.434557, 4.08180818, 3.70386304, 3.98102289, 3.95582657, 3.93062995, 3.90543362, 3.80464833,
   3.82984466, 3.80464833, 3.77945201, 3.75425569, 3.75425569, 3.72905937, 3.85504098, 3.67866672,
   3.45189952, 3.30072128, 3.0991507, 2.97316878, 2.92277614, 2.79679452, 2.82199085, 2.84718717,
   3.3259179, 3.27552496, 3.27552496, 3.42670319, 3.30072128, 3.47709584, 3.57788113, 5.06446567,
   4.56053862, 4.2077898, 3.98102289, 3.82984466, 3.85504098, 3.8802373, 3.90543362
};
struct FC6EntryIndex { char iz, jz; size_t ibeg, iend; };
struct FC6Entry { char iz, jz, icn, jcn; double c6, cni, cnj; };
static FC6EntryIndex const g_C6ParameterIndexTable[4465] = {
    {  1,  1,    0,    3},
    {  2,  1,    3,    5},
    {  2,  2,    5,    6},
    {  3,  1,    6,   10},
    {  3,  2,   10,   12},
    {  3,  3,   12,   15},
    {  4,  1,   15,   21},
    {  4,  2,   21,   24},
    {  4,  3,   24,   30},
    {  4,  4,   30,   36},
    {  5,  1,   36,   46},
    {  5,  2,   46,   51},
    {  5,  3,   51,   61},
    {  5,  4,   61,   76},
    {  5,  5,   76,   91},
    {  6,  1,   91,  101},
    {  6,  2,  101,  106},
    {  6,  3,  106,  116},
    {  6,  4,  116,  131},
    {  6,  5,  131,  156},
    {  6,  6,  156,  171},
    {  7,  1,  171,  179},
    {  7,  2,  179,  183},
    {  7,  3,  183,  191},
    {  7,  4,  191,  203},
    {  7,  5,  203,  223},
    {  7,  6,  223,  243},
    {  7,  7,  243,  253},
    {  8,  1,  253,  259},
    {  8,  2,  259,  262},
    {  8,  3,  262,  268},
    {  8,  4,  268,  277},
    {  8,  5,  277,  292},
    {  8,  6,  292,  307},
    {  8,  7,  307,  319},
    {  8,  8,  319,  325},
    {  9,  1,  325,  329},
    {  9,  2,  329,  331},
    {  9,  3,  331,  335},
    {  9,  4,  335,  341},
    {  9,  5,  341,  351},
    {  9,  6,  351,  361},
    {  9,  7,  361,  369},
    {  9,  8,  369,  375},
    {  9,  9,  375,  378},
    { 10,  1,  378,  380},
    { 10,  2,  380,  381},
    { 10,  3,  381,  383},
    { 10,  4,  383,  386},
    { 10,  5,  386,  391},
    { 10,  6,  391,  396},
    { 10,  7,  396,  400},
    { 10,  8,  400,  403},
    { 10,  9,  403,  405},
    { 10, 10,  405,  406},
    { 11,  1,  406,  410},
    { 11,  2,  410,  412},
    { 11,  3,  412,  416},
    { 11,  4,  416,  422},
    { 11,  5,  422,  432},
    { 11,  6,  432,  442},
    { 11,  7,  442,  450},
    { 11,  8,  450,  456},
    { 11,  9,  456,  460},
    { 11, 10,  460,  462},
    { 11, 11,  462,  465},
    { 12,  1,  465,  471},
    { 12,  2,  471,  474},
    { 12,  3,  474,  480},
    { 12,  4,  480,  489},
    { 12,  5,  489,  504},
    { 12,  6,  504,  519},
    { 12,  7,  519,  531},
    { 12,  8,  531,  540},
    { 12,  9,  540,  546},
    { 12, 10,  546,  549},
    { 12, 11,  549,  555},
    { 12, 12,  555,  561},
    { 13,  1,  561,  569},
    { 13,  2,  569,  573},
    { 13,  3,  573,  581},
    { 13,  4,  581,  593},
    { 13,  5,  593,  613},
    { 13,  6,  613,  633},
    { 13,  7,  633,  649},
    { 13,  8,  649,  661},
    { 13,  9,  661,  669},
    { 13, 10,  669,  673},
    { 13, 11,  673,  681},
    { 13, 12,  681,  693},
    { 13, 13,  693,  703},
    { 14,  1,  703,  713},
    { 14,  2,  713,  718},
    { 14,  3,  718,  728},
    { 14,  4,  728,  743},
    { 14,  5,  743,  768},
    { 14,  6,  768,  793},
    { 14,  7,  793,  813},
    { 14,  8,  813,  828},
    { 14,  9,  828,  838},
    { 14, 10,  838,  843},
    { 14, 11,  843,  853},
    { 14, 12,  853,  868},
    { 14, 13,  868,  888},
    { 14, 14,  888,  903},
    { 15,  1,  903,  911},
    { 15,  2,  911,  915},
    { 15,  3,  915,  923},
    { 15,  4,  923,  935},
    { 15,  5,  935,  955},
    { 15,  6,  955,  975},
    { 15,  7,  975,  991},
    { 15,  8,  991, 1003},
    { 15,  9, 1003, 1011},
    { 15, 10, 1011, 1015},
    { 15, 11, 1015, 1023},
    { 15, 12, 1023, 1035},
    { 15, 13, 1035, 1051},
    { 15, 14, 1051, 1071},
    { 15, 15, 1071, 1081},
    { 16,  1, 1081, 1087},
    { 16,  2, 1087, 1090},
    { 16,  3, 1090, 1096},
    { 16,  4, 1096, 1105},
    { 16,  5, 1105, 1120},
    { 16,  6, 1120, 1135},
    { 16,  7, 1135, 1147},
    { 16,  8, 1147, 1156},
    { 16,  9, 1156, 1162},
    { 16, 10, 1162, 1165},
    { 16, 11, 1165, 1171},
    { 16, 12, 1171, 1180},
    { 16, 13, 1180, 1192},
    { 16, 14, 1192, 1207},
    { 16, 15, 1207, 1219},
    { 16, 16, 1219, 1225},
    { 17,  1, 1225, 1229},
    { 17,  2, 1229, 1231},
    { 17,  3, 1231, 1235},
    { 17,  4, 1235, 1241},
    { 17,  5, 1241, 1251},
    { 17,  6, 1251, 1261},
    { 17,  7, 1261, 1269},
    { 17,  8, 1269, 1275},
    { 17,  9, 1275, 1279},
    { 17, 10, 1279, 1281},
    { 17, 11, 1281, 1285},
    { 17, 12, 1285, 1291},
    { 17, 13, 1291, 1299},
    { 17, 14, 1299, 1309},
    { 17, 15, 1309, 1317},
    { 17, 16, 1317, 1323},
    { 17, 17, 1323, 1326},
    { 18,  1, 1326, 1328},
    { 18,  2, 1328, 1329},
    { 18,  3, 1329, 1331},
    { 18,  4, 1331, 1334},
    { 18,  5, 1334, 1339},
    { 18,  6, 1339, 1344},
    { 18,  7, 1344, 1348},
    { 18,  8, 1348, 1351},
    { 18,  9, 1351, 1353},
    { 18, 10, 1353, 1354},
    { 18, 11, 1354, 1356},
    { 18, 12, 1356, 1359},
    { 18, 13, 1359, 1363},
    { 18, 14, 1363, 1368},
    { 18, 15, 1368, 1372},
    { 18, 16, 1372, 1375},
    { 18, 17, 1375, 1377},
    { 18, 18, 1377, 1378},
    { 19,  1, 1378, 1382},
    { 19,  2, 1382, 1384},
    { 19,  3, 1384, 1388},
    { 19,  4, 1388, 1394},
    { 19,  5, 1394, 1404},
    { 19,  6, 1404, 1414},
    { 19,  7, 1414, 1422},
    { 19,  8, 1422, 1428},
    { 19,  9, 1428, 1432},
    { 19, 10, 1432, 1434},
    { 19, 11, 1434, 1438},
    { 19, 12, 1438, 1444},
    { 19, 13, 1444, 1452},
    { 19, 14, 1452, 1462},
    { 19, 15, 1462, 1470},
    { 19, 16, 1470, 1476},
    { 19, 17, 1476, 1480},
    { 19, 18, 1480, 1482},
    { 19, 19, 1482, 1485},
    { 20,  1, 1485, 1491},
    { 20,  2, 1491, 1494},
    { 20,  3, 1494, 1500},
    { 20,  4, 1500, 1509},
    { 20,  5, 1509, 1524},
    { 20,  6, 1524, 1539},
    { 20,  7, 1539, 1551},
    { 20,  8, 1551, 1560},
    { 20,  9, 1560, 1566},
    { 20, 10, 1566, 1569},
    { 20, 11, 1569, 1575},
    { 20, 12, 1575, 1584},
    { 20, 13, 1584, 1596},
    { 20, 14, 1596, 1611},
    { 20, 15, 1611, 1623},
    { 20, 16, 1623, 1632},
    { 20, 17, 1632, 1638},
    { 20, 18, 1638, 1641},
    { 20, 19, 1641, 1647},
    { 20, 20, 1647, 1653},
    { 21,  1, 1653, 1659},
    { 21,  2, 1659, 1662},
    { 21,  3, 1662, 1668},
    { 21,  4, 1668, 1677},
    { 21,  5, 1677, 1692},
    { 21,  6, 1692, 1707},
    { 21,  7, 1707, 1719},
    { 21,  8, 1719, 1728},
    { 21,  9, 1728, 1734},
    { 21, 10, 1734, 1737},
    { 21, 11, 1737, 1743},
    { 21, 12, 1743, 1752},
    { 21, 13, 1752, 1764},
    { 21, 14, 1764, 1779},
    { 21, 15, 1779, 1791},
    { 21, 16, 1791, 1800},
    { 21, 17, 1800, 1806},
    { 21, 18, 1806, 1809},
    { 21, 19, 1809, 1815},
    { 21, 20, 1815, 1824},
    { 21, 21, 1824, 1830},
    { 22,  1, 1830, 1836},
    { 22,  2, 1836, 1839},
    { 22,  3, 1839, 1845},
    { 22,  4, 1845, 1854},
    { 22,  5, 1854, 1869},
    { 22,  6, 1869, 1884},
    { 22,  7, 1884, 1896},
    { 22,  8, 1896, 1905},
    { 22,  9, 1905, 1911},
    { 22, 10, 1911, 1914},
    { 22, 11, 1914, 1920},
    { 22, 12, 1920, 1929},
    { 22, 13, 1929, 1941},
    { 22, 14, 1941, 1956},
    { 22, 15, 1956, 1968},
    { 22, 16, 1968, 1977},
    { 22, 17, 1977, 1983},
    { 22, 18, 1983, 1986},
    { 22, 19, 1986, 1992},
    { 22, 20, 1992, 2001},
    { 22, 21, 2001, 2010},
    { 22, 22, 2010, 2016},
    { 23,  1, 2016, 2022},
    { 23,  2, 2022, 2025},
    { 23,  3, 2025, 2031},
    { 23,  4, 2031, 2040},
    { 23,  5, 2040, 2055},
    { 23,  6, 2055, 2070},
    { 23,  7, 2070, 2082},
    { 23,  8, 2082, 2091},
    { 23,  9, 2091, 2097},
    { 23, 10, 2097, 2100},
    { 23, 11, 2100, 2106},
    { 23, 12, 2106, 2115},
    { 23, 13, 2115, 2127},
    { 23, 14, 2127, 2142},
    { 23, 15, 2142, 2154},
    { 23, 16, 2154, 2163},
    { 23, 17, 2163, 2169},
    { 23, 18, 2169, 2172},
    { 23, 19, 2172, 2178},
    { 23, 20, 2178, 2187},
    { 23, 21, 2187, 2196},
    { 23, 22, 2196, 2205},
    { 23, 23, 2205, 2211},
    { 24,  1, 2211, 2217},
    { 24,  2, 2217, 2220},
    { 24,  3, 2220, 2226},
    { 24,  4, 2226, 2235},
    { 24,  5, 2235, 2250},
    { 24,  6, 2250, 2265},
    { 24,  7, 2265, 2277},
    { 24,  8, 2277, 2286},
    { 24,  9, 2286, 2292},
    { 24, 10, 2292, 2295},
    { 24, 11, 2295, 2301},
    { 24, 12, 2301, 2310},
    { 24, 13, 2310, 2322},
    { 24, 14, 2322, 2337},
    { 24, 15, 2337, 2349},
    { 24, 16, 2349, 2358},
    { 24, 17, 2358, 2364},
    { 24, 18, 2364, 2367},
    { 24, 19, 2367, 2373},
    { 24, 20, 2373, 2382},
    { 24, 21, 2382, 2391},
    { 24, 22, 2391, 2400},
    { 24, 23, 2400, 2409},
    { 24, 24, 2409, 2415},
    { 25,  1, 2415, 2421},
    { 25,  2, 2421, 2424},
    { 25,  3, 2424, 2430},
    { 25,  4, 2430, 2439},
    { 25,  5, 2439, 2454},
    { 25,  6, 2454, 2469},
    { 25,  7, 2469, 2481},
    { 25,  8, 2481, 2490},
    { 25,  9, 2490, 2496},
    { 25, 10, 2496, 2499},
    { 25, 11, 2499, 2505},
    { 25, 12, 2505, 2514},
    { 25, 13, 2514, 2526},
    { 25, 14, 2526, 2541},
    { 25, 15, 2541, 2553},
    { 25, 16, 2553, 2562},
    { 25, 17, 2562, 2568},
    { 25, 18, 2568, 2571},
    { 25, 19, 2571, 2577},
    { 25, 20, 2577, 2586},
    { 25, 21, 2586, 2595},
    { 25, 22, 2595, 2604},
    { 25, 23, 2604, 2613},
    { 25, 24, 2613, 2622},
    { 25, 25, 2622, 2628},
    { 26,  1, 2628, 2634},
    { 26,  2, 2634, 2637},
    { 26,  3, 2637, 2643},
    { 26,  4, 2643, 2652},
    { 26,  5, 2652, 2667},
    { 26,  6, 2667, 2682},
    { 26,  7, 2682, 2694},
    { 26,  8, 2694, 2703},
    { 26,  9, 2703, 2709},
    { 26, 10, 2709, 2712},
    { 26, 11, 2712, 2718},
    { 26, 12, 2718, 2727},
    { 26, 13, 2727, 2739},
    { 26, 14, 2739, 2754},
    { 26, 15, 2754, 2766},
    { 26, 16, 2766, 2775},
    { 26, 17, 2775, 2781},
    { 26, 18, 2781, 2784},
    { 26, 19, 2784, 2790},
    { 26, 20, 2790, 2799},
    { 26, 21, 2799, 2808},
    { 26, 22, 2808, 2817},
    { 26, 23, 2817, 2826},
    { 26, 24, 2826, 2835},
    { 26, 25, 2835, 2844},
    { 26, 26, 2844, 2850},
    { 27,  1, 2850, 2858},
    { 27,  2, 2858, 2862},
    { 27,  3, 2862, 2870},
    { 27,  4, 2870, 2882},
    { 27,  5, 2882, 2902},
    { 27,  6, 2902, 2922},
    { 27,  7, 2922, 2938},
    { 27,  8, 2938, 2950},
    { 27,  9, 2950, 2958},
    { 27, 10, 2958, 2962},
    { 27, 11, 2962, 2970},
    { 27, 12, 2970, 2982},
    { 27, 13, 2982, 2998},
    { 27, 14, 2998, 3018},
    { 27, 15, 3018, 3034},
    { 27, 16, 3034, 3046},
    { 27, 17, 3046, 3054},
    { 27, 18, 3054, 3058},
    { 27, 19, 3058, 3066},
    { 27, 20, 3066, 3078},
    { 27, 21, 3078, 3090},
    { 27, 22, 3090, 3102},
    { 27, 23, 3102, 3114},
    { 27, 24, 3114, 3126},
    { 27, 25, 3126, 3138},
    { 27, 26, 3138, 3150},
    { 27, 27, 3150, 3160},
    { 28,  1, 3160, 3168},
    { 28,  2, 3168, 3172},
    { 28,  3, 3172, 3180},
    { 28,  4, 3180, 3192},
    { 28,  5, 3192, 3212},
    { 28,  6, 3212, 3232},
    { 28,  7, 3232, 3248},
    { 28,  8, 3248, 3260},
    { 28,  9, 3260, 3268},
    { 28, 10, 3268, 3272},
    { 28, 11, 3272, 3280},
    { 28, 12, 3280, 3292},
    { 28, 13, 3292, 3308},
    { 28, 14, 3308, 3328},
    { 28, 15, 3328, 3344},
    { 28, 16, 3344, 3356},
    { 28, 17, 3356, 3364},
    { 28, 18, 3364, 3368},
    { 28, 19, 3368, 3376},
    { 28, 20, 3376, 3388},
    { 28, 21, 3388, 3400},
    { 28, 22, 3400, 3412},
    { 28, 23, 3412, 3424},
    { 28, 24, 3424, 3436},
    { 28, 25, 3436, 3448},
    { 28, 26, 3448, 3460},
    { 28, 27, 3460, 3476},
    { 28, 28, 3476, 3486},
    { 29,  1, 3486, 3490},
    { 29,  2, 3490, 3492},
    { 29,  3, 3492, 3496},
    { 29,  4, 3496, 3502},
    { 29,  5, 3502, 3512},
    { 29,  6, 3512, 3522},
    { 29,  7, 3522, 3530},
    { 29,  8, 3530, 3536},
    { 29,  9, 3536, 3540},
    { 29, 10, 3540, 3542},
    { 29, 11, 3542, 3546},
    { 29, 12, 3546, 3552},
    { 29, 13, 3552, 3560},
    { 29, 14, 3560, 3570},
    { 29, 15, 3570, 3578},
    { 29, 16, 3578, 3584},
    { 29, 17, 3584, 3588},
    { 29, 18, 3588, 3590},
    { 29, 19, 3590, 3594},
    { 29, 20, 3594, 3600},
    { 29, 21, 3600, 3606},
    { 29, 22, 3606, 3612},
    { 29, 23, 3612, 3618},
    { 29, 24, 3618, 3624},
    { 29, 25, 3624, 3630},
    { 29, 26, 3630, 3636},
    { 29, 27, 3636, 3644},
    { 29, 28, 3644, 3652},
    { 29, 29, 3652, 3655},
    { 30,  1, 3655, 3659},
    { 30,  2, 3659, 3661},
    { 30,  3, 3661, 3665},
    { 30,  4, 3665, 3671},
    { 30,  5, 3671, 3681},
    { 30,  6, 3681, 3691},
    { 30,  7, 3691, 3699},
    { 30,  8, 3699, 3705},
    { 30,  9, 3705, 3709},
    { 30, 10, 3709, 3711},
    { 30, 11, 3711, 3715},
    { 30, 12, 3715, 3721},
    { 30, 13, 3721, 3729},
    { 30, 14, 3729, 3739},
    { 30, 15, 3739, 3747},
    { 30, 16, 3747, 3753},
    { 30, 17, 3753, 3757},
    { 30, 18, 3757, 3759},
    { 30, 19, 3759, 3763},
    { 30, 20, 3763, 3769},
    { 30, 21, 3769, 3775},
    { 30, 22, 3775, 3781},
    { 30, 23, 3781, 3787},
    { 30, 24, 3787, 3793},
    { 30, 25, 3793, 3799},
    { 30, 26, 3799, 3805},
    { 30, 27, 3805, 3813},
    { 30, 28, 3813, 3821},
    { 30, 29, 3821, 3825},
    { 30, 30, 3825, 3828},
    { 31,  1, 3828, 3836},
    { 31,  2, 3836, 3840},
    { 31,  3, 3840, 3848},
    { 31,  4, 3848, 3860},
    { 31,  5, 3860, 3880},
    { 31,  6, 3880, 3900},
    { 31,  7, 3900, 3916},
    { 31,  8, 3916, 3928},
    { 31,  9, 3928, 3936},
    { 31, 10, 3936, 3940},
    { 31, 11, 3940, 3948},
    { 31, 12, 3948, 3960},
    { 31, 13, 3960, 3976},
    { 31, 14, 3976, 3996},
    { 31, 15, 3996, 4012},
    { 31, 16, 4012, 4024},
    { 31, 17, 4024, 4032},
    { 31, 18, 4032, 4036},
    { 31, 19, 4036, 4044},
    { 31, 20, 4044, 4056},
    { 31, 21, 4056, 4068},
    { 31, 22, 4068, 4080},
    { 31, 23, 4080, 4092},
    { 31, 24, 4092, 4104},
    { 31, 25, 4104, 4116},
    { 31, 26, 4116, 4128},
    { 31, 27, 4128, 4144},
    { 31, 28, 4144, 4160},
    { 31, 29, 4160, 4168},
    { 31, 30, 4168, 4176},
    { 31, 31, 4176, 4186},
    { 32,  1, 4186, 4196},
    { 32,  2, 4196, 4201},
    { 32,  3, 4201, 4211},
    { 32,  4, 4211, 4226},
    { 32,  5, 4226, 4251},
    { 32,  6, 4251, 4276},
    { 32,  7, 4276, 4296},
    { 32,  8, 4296, 4311},
    { 32,  9, 4311, 4321},
    { 32, 10, 4321, 4326},
    { 32, 11, 4326, 4336},
    { 32, 12, 4336, 4351},
    { 32, 13, 4351, 4371},
    { 32, 14, 4371, 4396},
    { 32, 15, 4396, 4416},
    { 32, 16, 4416, 4431},
    { 32, 17, 4431, 4441},
    { 32, 18, 4441, 4446},
    { 32, 19, 4446, 4456},
    { 32, 20, 4456, 4471},
    { 32, 21, 4471, 4486},
    { 32, 22, 4486, 4501},
    { 32, 23, 4501, 4516},
    { 32, 24, 4516, 4531},
    { 32, 25, 4531, 4546},
    { 32, 26, 4546, 4561},
    { 32, 27, 4561, 4581},
    { 32, 28, 4581, 4601},
    { 32, 29, 4601, 4611},
    { 32, 30, 4611, 4621},
    { 32, 31, 4621, 4641},
    { 32, 32, 4641, 4656},
    { 33,  1, 4656, 4664},
    { 33,  2, 4664, 4668},
    { 33,  3, 4668, 4676},
    { 33,  4, 4676, 4688},
    { 33,  5, 4688, 4708},
    { 33,  6, 4708, 4728},
    { 33,  7, 4728, 4744},
    { 33,  8, 4744, 4756},
    { 33,  9, 4756, 4764},
    { 33, 10, 4764, 4768},
    { 33, 11, 4768, 4776},
    { 33, 12, 4776, 4788},
    { 33, 13, 4788, 4804},
    { 33, 14, 4804, 4824},
    { 33, 15, 4824, 4840},
    { 33, 16, 4840, 4852},
    { 33, 17, 4852, 4860},
    { 33, 18, 4860, 4864},
    { 33, 19, 4864, 4872},
    { 33, 20, 4872, 4884},
    { 33, 21, 4884, 4896},
    { 33, 22, 4896, 4908},
    { 33, 23, 4908, 4920},
    { 33, 24, 4920, 4932},
    { 33, 25, 4932, 4944},
    { 33, 26, 4944, 4956},
    { 33, 27, 4956, 4972},
    { 33, 28, 4972, 4988},
    { 33, 29, 4988, 4996},
    { 33, 30, 4996, 5004},
    { 33, 31, 5004, 5020},
    { 33, 32, 5020, 5040},
    { 33, 33, 5040, 5050},
    { 34,  1, 5050, 5056},
    { 34,  2, 5056, 5059},
    { 34,  3, 5059, 5065},
    { 34,  4, 5065, 5074},
    { 34,  5, 5074, 5089},
    { 34,  6, 5089, 5104},
    { 34,  7, 5104, 5116},
    { 34,  8, 5116, 5125},
    { 34,  9, 5125, 5131},
    { 34, 10, 5131, 5134},
    { 34, 11, 5134, 5140},
    { 34, 12, 5140, 5149},
    { 34, 13, 5149, 5161},
    { 34, 14, 5161, 5176},
    { 34, 15, 5176, 5188},
    { 34, 16, 5188, 5197},
    { 34, 17, 5197, 5203},
    { 34, 18, 5203, 5206},
    { 34, 19, 5206, 5212},
    { 34, 20, 5212, 5221},
    { 34, 21, 5221, 5230},
    { 34, 22, 5230, 5239},
    { 34, 23, 5239, 5248},
    { 34, 24, 5248, 5257},
    { 34, 25, 5257, 5266},
    { 34, 26, 5266, 5275},
    { 34, 27, 5275, 5287},
    { 34, 28, 5287, 5299},
    { 34, 29, 5299, 5305},
    { 34, 30, 5305, 5311},
    { 34, 31, 5311, 5323},
    { 34, 32, 5323, 5338},
    { 34, 33, 5338, 5350},
    { 34, 34, 5350, 5356},
    { 35,  1, 5356, 5360},
    { 35,  2, 5360, 5362},
    { 35,  3, 5362, 5366},
    { 35,  4, 5366, 5372},
    { 35,  5, 5372, 5382},
    { 35,  6, 5382, 5392},
    { 35,  7, 5392, 5400},
    { 35,  8, 5400, 5406},
    { 35,  9, 5406, 5410},
    { 35, 10, 5410, 5412},
    { 35, 11, 5412, 5416},
    { 35, 12, 5416, 5422},
    { 35, 13, 5422, 5430},
    { 35, 14, 5430, 5440},
    { 35, 15, 5440, 5448},
    { 35, 16, 5448, 5454},
    { 35, 17, 5454, 5458},
    { 35, 18, 5458, 5460},
    { 35, 19, 5460, 5464},
    { 35, 20, 5464, 5470},
    { 35, 21, 5470, 5476},
    { 35, 22, 5476, 5482},
    { 35, 23, 5482, 5488},
    { 35, 24, 5488, 5494},
    { 35, 25, 5494, 5500},
    { 35, 26, 5500, 5506},
    { 35, 27, 5506, 5514},
    { 35, 28, 5514, 5522},
    { 35, 29, 5522, 5526},
    { 35, 30, 5526, 5530},
    { 35, 31, 5530, 5538},
    { 35, 32, 5538, 5548},
    { 35, 33, 5548, 5556},
    { 35, 34, 5556, 5562},
    { 35, 35, 5562, 5565},
    { 36,  1, 5565, 5567},
    { 36,  2, 5567, 5568},
    { 36,  3, 5568, 5570},
    { 36,  4, 5570, 5573},
    { 36,  5, 5573, 5578},
    { 36,  6, 5578, 5583},
    { 36,  7, 5583, 5587},
    { 36,  8, 5587, 5590},
    { 36,  9, 5590, 5592},
    { 36, 10, 5592, 5593},
    { 36, 11, 5593, 5595},
    { 36, 12, 5595, 5598},
    { 36, 13, 5598, 5602},
    { 36, 14, 5602, 5607},
    { 36, 15, 5607, 5611},
    { 36, 16, 5611, 5614},
    { 36, 17, 5614, 5616},
    { 36, 18, 5616, 5617},
    { 36, 19, 5617, 5619},
    { 36, 20, 5619, 5622},
    { 36, 21, 5622, 5625},
    { 36, 22, 5625, 5628},
    { 36, 23, 5628, 5631},
    { 36, 24, 5631, 5634},
    { 36, 25, 5634, 5637},
    { 36, 26, 5637, 5640},
    { 36, 27, 5640, 5644},
    { 36, 28, 5644, 5648},
    { 36, 29, 5648, 5650},
    { 36, 30, 5650, 5652},
    { 36, 31, 5652, 5656},
    { 36, 32, 5656, 5661},
    { 36, 33, 5661, 5665},
    { 36, 34, 5665, 5668},
    { 36, 35, 5668, 5670},
    { 36, 36, 5670, 5671},
    { 37,  1, 5671, 5675},
    { 37,  2, 5675, 5677},
    { 37,  3, 5677, 5681},
    { 37,  4, 5681, 5687},
    { 37,  5, 5687, 5697},
    { 37,  6, 5697, 5707},
    { 37,  7, 5707, 5715},
    { 37,  8, 5715, 5721},
    { 37,  9, 5721, 5725},
    { 37, 10, 5725, 5727},
    { 37, 11, 5727, 5731},
    { 37, 12, 5731, 5737},
    { 37, 13, 5737, 5745},
    { 37, 14, 5745, 5755},
    { 37, 15, 5755, 5763},
    { 37, 16, 5763, 5769},
    { 37, 17, 5769, 5773},
    { 37, 18, 5773, 5775},
    { 37, 19, 5775, 5779},
    { 37, 20, 5779, 5785},
    { 37, 21, 5785, 5791},
    { 37, 22, 5791, 5797},
    { 37, 23, 5797, 5803},
    { 37, 24, 5803, 5809},
    { 37, 25, 5809, 5815},
    { 37, 26, 5815, 5821},
    { 37, 27, 5821, 5829},
    { 37, 28, 5829, 5837},
    { 37, 29, 5837, 5841},
    { 37, 30, 5841, 5845},
    { 37, 31, 5845, 5853},
    { 37, 32, 5853, 5863},
    { 37, 33, 5863, 5871},
    { 37, 34, 5871, 5877},
    { 37, 35, 5877, 5881},
    { 37, 36, 5881, 5883},
    { 37, 37, 5883, 5886},
    { 38,  1, 5886, 5892},
    { 38,  2, 5892, 5895},
    { 38,  3, 5895, 5901},
    { 38,  4, 5901, 5910},
    { 38,  5, 5910, 5925},
    { 38,  6, 5925, 5940},
    { 38,  7, 5940, 5952},
    { 38,  8, 5952, 5961},
    { 38,  9, 5961, 5967},
    { 38, 10, 5967, 5970},
    { 38, 11, 5970, 5976},
    { 38, 12, 5976, 5985},
    { 38, 13, 5985, 5997},
    { 38, 14, 5997, 6012},
    { 38, 15, 6012, 6024},
    { 38, 16, 6024, 6033},
    { 38, 17, 6033, 6039},
    { 38, 18, 6039, 6042},
    { 38, 19, 6042, 6048},
    { 38, 20, 6048, 6057},
    { 38, 21, 6057, 6066},
    { 38, 22, 6066, 6075},
    { 38, 23, 6075, 6084},
    { 38, 24, 6084, 6093},
    { 38, 25, 6093, 6102},
    { 38, 26, 6102, 6111},
    { 38, 27, 6111, 6123},
    { 38, 28, 6123, 6135},
    { 38, 29, 6135, 6141},
    { 38, 30, 6141, 6147},
    { 38, 31, 6147, 6159},
    { 38, 32, 6159, 6174},
    { 38, 33, 6174, 6186},
    { 38, 34, 6186, 6195},
    { 38, 35, 6195, 6201},
    { 38, 36, 6201, 6204},
    { 38, 37, 6204, 6210},
    { 38, 38, 6210, 6216},
    { 39,  1, 6216, 6222},
    { 39,  2, 6222, 6225},
    { 39,  3, 6225, 6231},
    { 39,  4, 6231, 6240},
    { 39,  5, 6240, 6255},
    { 39,  6, 6255, 6270},
    { 39,  7, 6270, 6282},
    { 39,  8, 6282, 6291},
    { 39,  9, 6291, 6297},
    { 39, 10, 6297, 6300},
    { 39, 11, 6300, 6306},
    { 39, 12, 6306, 6315},
    { 39, 13, 6315, 6327},
    { 39, 14, 6327, 6342},
    { 39, 15, 6342, 6354},
    { 39, 16, 6354, 6363},
    { 39, 17, 6363, 6369},
    { 39, 18, 6369, 6372},
    { 39, 19, 6372, 6378},
    { 39, 20, 6378, 6387},
    { 39, 21, 6387, 6396},
    { 39, 22, 6396, 6405},
    { 39, 23, 6405, 6414},
    { 39, 24, 6414, 6423},
    { 39, 25, 6423, 6432},
    { 39, 26, 6432, 6441},
    { 39, 27, 6441, 6453},
    { 39, 28, 6453, 6465},
    { 39, 29, 6465, 6471},
    { 39, 30, 6471, 6477},
    { 39, 31, 6477, 6489},
    { 39, 32, 6489, 6504},
    { 39, 33, 6504, 6516},
    { 39, 34, 6516, 6525},
    { 39, 35, 6525, 6531},
    { 39, 36, 6531, 6534},
    { 39, 37, 6534, 6540},
    { 39, 38, 6540, 6549},
    { 39, 39, 6549, 6555},
    { 40,  1, 6555, 6561},
    { 40,  2, 6561, 6564},
    { 40,  3, 6564, 6570},
    { 40,  4, 6570, 6579},
    { 40,  5, 6579, 6594},
    { 40,  6, 6594, 6609},
    { 40,  7, 6609, 6621},
    { 40,  8, 6621, 6630},
    { 40,  9, 6630, 6636},
    { 40, 10, 6636, 6639},
    { 40, 11, 6639, 6645},
    { 40, 12, 6645, 6654},
    { 40, 13, 6654, 6666},
    { 40, 14, 6666, 6681},
    { 40, 15, 6681, 6693},
    { 40, 16, 6693, 6702},
    { 40, 17, 6702, 6708},
    { 40, 18, 6708, 6711},
    { 40, 19, 6711, 6717},
    { 40, 20, 6717, 6726},
    { 40, 21, 6726, 6735},
    { 40, 22, 6735, 6744},
    { 40, 23, 6744, 6753},
    { 40, 24, 6753, 6762},
    { 40, 25, 6762, 6771},
    { 40, 26, 6771, 6780},
    { 40, 27, 6780, 6792},
    { 40, 28, 6792, 6804},
    { 40, 29, 6804, 6810},
    { 40, 30, 6810, 6816},
    { 40, 31, 6816, 6828},
    { 40, 32, 6828, 6843},
    { 40, 33, 6843, 6855},
    { 40, 34, 6855, 6864},
    { 40, 35, 6864, 6870},
    { 40, 36, 6870, 6873},
    { 40, 37, 6873, 6879},
    { 40, 38, 6879, 6888},
    { 40, 39, 6888, 6897},
    { 40, 40, 6897, 6903},
    { 41,  1, 6903, 6909},
    { 41,  2, 6909, 6912},
    { 41,  3, 6912, 6918},
    { 41,  4, 6918, 6927},
    { 41,  5, 6927, 6942},
    { 41,  6, 6942, 6957},
    { 41,  7, 6957, 6969},
    { 41,  8, 6969, 6978},
    { 41,  9, 6978, 6984},
    { 41, 10, 6984, 6987},
    { 41, 11, 6987, 6993},
    { 41, 12, 6993, 7002},
    { 41, 13, 7002, 7014},
    { 41, 14, 7014, 7029},
    { 41, 15, 7029, 7041},
    { 41, 16, 7041, 7050},
    { 41, 17, 7050, 7056},
    { 41, 18, 7056, 7059},
    { 41, 19, 7059, 7065},
    { 41, 20, 7065, 7074},
    { 41, 21, 7074, 7083},
    { 41, 22, 7083, 7092},
    { 41, 23, 7092, 7101},
    { 41, 24, 7101, 7110},
    { 41, 25, 7110, 7119},
    { 41, 26, 7119, 7128},
    { 41, 27, 7128, 7140},
    { 41, 28, 7140, 7152},
    { 41, 29, 7152, 7158},
    { 41, 30, 7158, 7164},
    { 41, 31, 7164, 7176},
    { 41, 32, 7176, 7191},
    { 41, 33, 7191, 7203},
    { 41, 34, 7203, 7212},
    { 41, 35, 7212, 7218},
    { 41, 36, 7218, 7221},
    { 41, 37, 7221, 7227},
    { 41, 38, 7227, 7236},
    { 41, 39, 7236, 7245},
    { 41, 40, 7245, 7254},
    { 41, 41, 7254, 7260},
    { 42,  1, 7260, 7266},
    { 42,  2, 7266, 7269},
    { 42,  3, 7269, 7275},
    { 42,  4, 7275, 7284},
    { 42,  5, 7284, 7299},
    { 42,  6, 7299, 7314},
    { 42,  7, 7314, 7326},
    { 42,  8, 7326, 7335},
    { 42,  9, 7335, 7341},
    { 42, 10, 7341, 7344},
    { 42, 11, 7344, 7350},
    { 42, 12, 7350, 7359},
    { 42, 13, 7359, 7371},
    { 42, 14, 7371, 7386},
    { 42, 15, 7386, 7398},
    { 42, 16, 7398, 7407},
    { 42, 17, 7407, 7413},
    { 42, 18, 7413, 7416},
    { 42, 19, 7416, 7422},
    { 42, 20, 7422, 7431},
    { 42, 21, 7431, 7440},
    { 42, 22, 7440, 7449},
    { 42, 23, 7449, 7458},
    { 42, 24, 7458, 7467},
    { 42, 25, 7467, 7476},
    { 42, 26, 7476, 7485},
    { 42, 27, 7485, 7497},
    { 42, 28, 7497, 7509},
    { 42, 29, 7509, 7515},
    { 42, 30, 7515, 7521},
    { 42, 31, 7521, 7533},
    { 42, 32, 7533, 7548},
    { 42, 33, 7548, 7560},
    { 42, 34, 7560, 7569},
    { 42, 35, 7569, 7575},
    { 42, 36, 7575, 7578},
    { 42, 37, 7578, 7584},
    { 42, 38, 7584, 7593},
    { 42, 39, 7593, 7602},
    { 42, 40, 7602, 7611},
    { 42, 41, 7611, 7620},
    { 42, 42, 7620, 7626},
    { 43,  1, 7626, 7632},
    { 43,  2, 7632, 7635},
    { 43,  3, 7635, 7641},
    { 43,  4, 7641, 7650},
    { 43,  5, 7650, 7665},
    { 43,  6, 7665, 7680},
    { 43,  7, 7680, 7692},
    { 43,  8, 7692, 7701},
    { 43,  9, 7701, 7707},
    { 43, 10, 7707, 7710},
    { 43, 11, 7710, 7716},
    { 43, 12, 7716, 7725},
    { 43, 13, 7725, 7737},
    { 43, 14, 7737, 7752},
    { 43, 15, 7752, 7764},
    { 43, 16, 7764, 7773},
    { 43, 17, 7773, 7779},
    { 43, 18, 7779, 7782},
    { 43, 19, 7782, 7788},
    { 43, 20, 7788, 7797},
    { 43, 21, 7797, 7806},
    { 43, 22, 7806, 7815},
    { 43, 23, 7815, 7824},
    { 43, 24, 7824, 7833},
    { 43, 25, 7833, 7842},
    { 43, 26, 7842, 7851},
    { 43, 27, 7851, 7863},
    { 43, 28, 7863, 7875},
    { 43, 29, 7875, 7881},
    { 43, 30, 7881, 7887},
    { 43, 31, 7887, 7899},
    { 43, 32, 7899, 7914},
    { 43, 33, 7914, 7926},
    { 43, 34, 7926, 7935},
    { 43, 35, 7935, 7941},
    { 43, 36, 7941, 7944},
    { 43, 37, 7944, 7950},
    { 43, 38, 7950, 7959},
    { 43, 39, 7959, 7968},
    { 43, 40, 7968, 7977},
    { 43, 41, 7977, 7986},
    { 43, 42, 7986, 7995},
    { 43, 43, 7995, 8001},
    { 44,  1, 8001, 8007},
    { 44,  2, 8007, 8010},
    { 44,  3, 8010, 8016},
    { 44,  4, 8016, 8025},
    { 44,  5, 8025, 8040},
    { 44,  6, 8040, 8055},
    { 44,  7, 8055, 8067},
    { 44,  8, 8067, 8076},
    { 44,  9, 8076, 8082},
    { 44, 10, 8082, 8085},
    { 44, 11, 8085, 8091},
    { 44, 12, 8091, 8100},
    { 44, 13, 8100, 8112},
    { 44, 14, 8112, 8127},
    { 44, 15, 8127, 8139},
    { 44, 16, 8139, 8148},
    { 44, 17, 8148, 8154},
    { 44, 18, 8154, 8157},
    { 44, 19, 8157, 8163},
    { 44, 20, 8163, 8172},
    { 44, 21, 8172, 8181},
    { 44, 22, 8181, 8190},
    { 44, 23, 8190, 8199},
    { 44, 24, 8199, 8208},
    { 44, 25, 8208, 8217},
    { 44, 26, 8217, 8226},
    { 44, 27, 8226, 8238},
    { 44, 28, 8238, 8250},
    { 44, 29, 8250, 8256},
    { 44, 30, 8256, 8262},
    { 44, 31, 8262, 8274},
    { 44, 32, 8274, 8289},
    { 44, 33, 8289, 8301},
    { 44, 34, 8301, 8310},
    { 44, 35, 8310, 8316},
    { 44, 36, 8316, 8319},
    { 44, 37, 8319, 8325},
    { 44, 38, 8325, 8334},
    { 44, 39, 8334, 8343},
    { 44, 40, 8343, 8352},
    { 44, 41, 8352, 8361},
    { 44, 42, 8361, 8370},
    { 44, 43, 8370, 8379},
    { 44, 44, 8379, 8385},
    { 45,  1, 8385, 8391},
    { 45,  2, 8391, 8394},
    { 45,  3, 8394, 8400},
    { 45,  4, 8400, 8409},
    { 45,  5, 8409, 8424},
    { 45,  6, 8424, 8439},
    { 45,  7, 8439, 8451},
    { 45,  8, 8451, 8460},
    { 45,  9, 8460, 8466},
    { 45, 10, 8466, 8469},
    { 45, 11, 8469, 8475},
    { 45, 12, 8475, 8484},
    { 45, 13, 8484, 8496},
    { 45, 14, 8496, 8511},
    { 45, 15, 8511, 8523},
    { 45, 16, 8523, 8532},
    { 45, 17, 8532, 8538},
    { 45, 18, 8538, 8541},
    { 45, 19, 8541, 8547},
    { 45, 20, 8547, 8556},
    { 45, 21, 8556, 8565},
    { 45, 22, 8565, 8574},
    { 45, 23, 8574, 8583},
    { 45, 24, 8583, 8592},
    { 45, 25, 8592, 8601},
    { 45, 26, 8601, 8610},
    { 45, 27, 8610, 8622},
    { 45, 28, 8622, 8634},
    { 45, 29, 8634, 8640},
    { 45, 30, 8640, 8646},
    { 45, 31, 8646, 8658},
    { 45, 32, 8658, 8673},
    { 45, 33, 8673, 8685},
    { 45, 34, 8685, 8694},
    { 45, 35, 8694, 8700},
    { 45, 36, 8700, 8703},
    { 45, 37, 8703, 8709},
    { 45, 38, 8709, 8718},
    { 45, 39, 8718, 8727},
    { 45, 40, 8727, 8736},
    { 45, 41, 8736, 8745},
    { 45, 42, 8745, 8754},
    { 45, 43, 8754, 8763},
    { 45, 44, 8763, 8772},
    { 45, 45, 8772, 8778},
    { 46,  1, 8778, 8784},
    { 46,  2, 8784, 8787},
    { 46,  3, 8787, 8793},
    { 46,  4, 8793, 8802},
    { 46,  5, 8802, 8817},
    { 46,  6, 8817, 8832},
    { 46,  7, 8832, 8844},
    { 46,  8, 8844, 8853},
    { 46,  9, 8853, 8859},
    { 46, 10, 8859, 8862},
    { 46, 11, 8862, 8868},
    { 46, 12, 8868, 8877},
    { 46, 13, 8877, 8889},
    { 46, 14, 8889, 8904},
    { 46, 15, 8904, 8916},
    { 46, 16, 8916, 8925},
    { 46, 17, 8925, 8931},
    { 46, 18, 8931, 8934},
    { 46, 19, 8934, 8940},
    { 46, 20, 8940, 8949},
    { 46, 21, 8949, 8958},
    { 46, 22, 8958, 8967},
    { 46, 23, 8967, 8976},
    { 46, 24, 8976, 8985},
    { 46, 25, 8985, 8994},
    { 46, 26, 8994, 9003},
    { 46, 27, 9003, 9015},
    { 46, 28, 9015, 9027},
    { 46, 29, 9027, 9033},
    { 46, 30, 9033, 9039},
    { 46, 31, 9039, 9051},
    { 46, 32, 9051, 9066},
    { 46, 33, 9066, 9078},
    { 46, 34, 9078, 9087},
    { 46, 35, 9087, 9093},
    { 46, 36, 9093, 9096},
    { 46, 37, 9096, 9102},
    { 46, 38, 9102, 9111},
    { 46, 39, 9111, 9120},
    { 46, 40, 9120, 9129},
    { 46, 41, 9129, 9138},
    { 46, 42, 9138, 9147},
    { 46, 43, 9147, 9156},
    { 46, 44, 9156, 9165},
    { 46, 45, 9165, 9174},
    { 46, 46, 9174, 9180},
    { 47,  1, 9180, 9184},
    { 47,  2, 9184, 9186},
    { 47,  3, 9186, 9190},
    { 47,  4, 9190, 9196},
    { 47,  5, 9196, 9206},
    { 47,  6, 9206, 9216},
    { 47,  7, 9216, 9224},
    { 47,  8, 9224, 9230},
    { 47,  9, 9230, 9234},
    { 47, 10, 9234, 9236},
    { 47, 11, 9236, 9240},
    { 47, 12, 9240, 9246},
    { 47, 13, 9246, 9254},
    { 47, 14, 9254, 9264},
    { 47, 15, 9264, 9272},
    { 47, 16, 9272, 9278},
    { 47, 17, 9278, 9282},
    { 47, 18, 9282, 9284},
    { 47, 19, 9284, 9288},
    { 47, 20, 9288, 9294},
    { 47, 21, 9294, 9300},
    { 47, 22, 9300, 9306},
    { 47, 23, 9306, 9312},
    { 47, 24, 9312, 9318},
    { 47, 25, 9318, 9324},
    { 47, 26, 9324, 9330},
    { 47, 27, 9330, 9338},
    { 47, 28, 9338, 9346},
    { 47, 29, 9346, 9350},
    { 47, 30, 9350, 9354},
    { 47, 31, 9354, 9362},
    { 47, 32, 9362, 9372},
    { 47, 33, 9372, 9380},
    { 47, 34, 9380, 9386},
    { 47, 35, 9386, 9390},
    { 47, 36, 9390, 9392},
    { 47, 37, 9392, 9396},
    { 47, 38, 9396, 9402},
    { 47, 39, 9402, 9408},
    { 47, 40, 9408, 9414},
    { 47, 41, 9414, 9420},
    { 47, 42, 9420, 9426},
    { 47, 43, 9426, 9432},
    { 47, 44, 9432, 9438},
    { 47, 45, 9438, 9444},
    { 47, 46, 9444, 9450},
    { 47, 47, 9450, 9453},
    { 48,  1, 9453, 9457},
    { 48,  2, 9457, 9459},
    { 48,  3, 9459, 9463},
    { 48,  4, 9463, 9469},
    { 48,  5, 9469, 9479},
    { 48,  6, 9479, 9489},
    { 48,  7, 9489, 9497},
    { 48,  8, 9497, 9503},
    { 48,  9, 9503, 9507},
    { 48, 10, 9507, 9509},
    { 48, 11, 9509, 9513},
    { 48, 12, 9513, 9519},
    { 48, 13, 9519, 9527},
    { 48, 14, 9527, 9537},
    { 48, 15, 9537, 9545},
    { 48, 16, 9545, 9551},
    { 48, 17, 9551, 9555},
    { 48, 18, 9555, 9557},
    { 48, 19, 9557, 9561},
    { 48, 20, 9561, 9567},
    { 48, 21, 9567, 9573},
    { 48, 22, 9573, 9579},
    { 48, 23, 9579, 9585},
    { 48, 24, 9585, 9591},
    { 48, 25, 9591, 9597},
    { 48, 26, 9597, 9603},
    { 48, 27, 9603, 9611},
    { 48, 28, 9611, 9619},
    { 48, 29, 9619, 9623},
    { 48, 30, 9623, 9627},
    { 48, 31, 9627, 9635},
    { 48, 32, 9635, 9645},
    { 48, 33, 9645, 9653},
    { 48, 34, 9653, 9659},
    { 48, 35, 9659, 9663},
    { 48, 36, 9663, 9665},
    { 48, 37, 9665, 9669},
    { 48, 38, 9669, 9675},
    { 48, 39, 9675, 9681},
    { 48, 40, 9681, 9687},
    { 48, 41, 9687, 9693},
    { 48, 42, 9693, 9699},
    { 48, 43, 9699, 9705},
    { 48, 44, 9705, 9711},
    { 48, 45, 9711, 9717},
    { 48, 46, 9717, 9723},
    { 48, 47, 9723, 9727},
    { 48, 48, 9727, 9730},
    { 49,  1, 9730, 9738},
    { 49,  2, 9738, 9742},
    { 49,  3, 9742, 9750},
    { 49,  4, 9750, 9762},
    { 49,  5, 9762, 9782},
    { 49,  6, 9782, 9802},
    { 49,  7, 9802, 9818},
    { 49,  8, 9818, 9830},
    { 49,  9, 9830, 9838},
    { 49, 10, 9838, 9842},
    { 49, 11, 9842, 9850},
    { 49, 12, 9850, 9862},
    { 49, 13, 9862, 9878},
    { 49, 14, 9878, 9898},
    { 49, 15, 9898, 9914},
    { 49, 16, 9914, 9926},
    { 49, 17, 9926, 9934},
    { 49, 18, 9934, 9938},
    { 49, 19, 9938, 9946},
    { 49, 20, 9946, 9958},
    { 49, 21, 9958, 9970},
    { 49, 22, 9970, 9982},
    { 49, 23, 9982, 9994},
    { 49, 24, 9994,10006},
    { 49, 25,10006,10018},
    { 49, 26,10018,10030},
    { 49, 27,10030,10046},
    { 49, 28,10046,10062},
    { 49, 29,10062,10070},
    { 49, 30,10070,10078},
    { 49, 31,10078,10094},
    { 49, 32,10094,10114},
    { 49, 33,10114,10130},
    { 49, 34,10130,10142},
    { 49, 35,10142,10150},
    { 49, 36,10150,10154},
    { 49, 37,10154,10162},
    { 49, 38,10162,10174},
    { 49, 39,10174,10186},
    { 49, 40,10186,10198},
    { 49, 41,10198,10210},
    { 49, 42,10210,10222},
    { 49, 43,10222,10234},
    { 49, 44,10234,10246},
    { 49, 45,10246,10258},
    { 49, 46,10258,10270},
    { 49, 47,10270,10278},
    { 49, 48,10278,10286},
    { 49, 49,10286,10296},
    { 50,  1,10296,10306},
    { 50,  2,10306,10311},
    { 50,  3,10311,10321},
    { 50,  4,10321,10336},
    { 50,  5,10336,10361},
    { 50,  6,10361,10386},
    { 50,  7,10386,10406},
    { 50,  8,10406,10421},
    { 50,  9,10421,10431},
    { 50, 10,10431,10436},
    { 50, 11,10436,10446},
    { 50, 12,10446,10461},
    { 50, 13,10461,10481},
    { 50, 14,10481,10506},
    { 50, 15,10506,10526},
    { 50, 16,10526,10541},
    { 50, 17,10541,10551},
    { 50, 18,10551,10556},
    { 50, 19,10556,10566},
    { 50, 20,10566,10581},
    { 50, 21,10581,10596},
    { 50, 22,10596,10611},
    { 50, 23,10611,10626},
    { 50, 24,10626,10641},
    { 50, 25,10641,10656},
    { 50, 26,10656,10671},
    { 50, 27,10671,10691},
    { 50, 28,10691,10711},
    { 50, 29,10711,10721},
    { 50, 30,10721,10731},
    { 50, 31,10731,10751},
    { 50, 32,10751,10776},
    { 50, 33,10776,10796},
    { 50, 34,10796,10811},
    { 50, 35,10811,10821},
    { 50, 36,10821,10826},
    { 50, 37,10826,10836},
    { 50, 38,10836,10851},
    { 50, 39,10851,10866},
    { 50, 40,10866,10881},
    { 50, 41,10881,10896},
    { 50, 42,10896,10911},
    { 50, 43,10911,10926},
    { 50, 44,10926,10941},
    { 50, 45,10941,10956},
    { 50, 46,10956,10971},
    { 50, 47,10971,10981},
    { 50, 48,10981,10991},
    { 50, 49,10991,11011},
    { 50, 50,11011,11026},
    { 51,  1,11026,11034},
    { 51,  2,11034,11038},
    { 51,  3,11038,11046},
    { 51,  4,11046,11058},
    { 51,  5,11058,11078},
    { 51,  6,11078,11098},
    { 51,  7,11098,11114},
    { 51,  8,11114,11126},
    { 51,  9,11126,11134},
    { 51, 10,11134,11138},
    { 51, 11,11138,11146},
    { 51, 12,11146,11158},
    { 51, 13,11158,11174},
    { 51, 14,11174,11194},
    { 51, 15,11194,11210},
    { 51, 16,11210,11222},
    { 51, 17,11222,11230},
    { 51, 18,11230,11234},
    { 51, 19,11234,11242},
    { 51, 20,11242,11254},
    { 51, 21,11254,11266},
    { 51, 22,11266,11278},
    { 51, 23,11278,11290},
    { 51, 24,11290,11302},
    { 51, 25,11302,11314},
    { 51, 26,11314,11326},
    { 51, 27,11326,11342},
    { 51, 28,11342,11358},
    { 51, 29,11358,11366},
    { 51, 30,11366,11374},
    { 51, 31,11374,11390},
    { 51, 32,11390,11410},
    { 51, 33,11410,11426},
    { 51, 34,11426,11438},
    { 51, 35,11438,11446},
    { 51, 36,11446,11450},
    { 51, 37,11450,11458},
    { 51, 38,11458,11470},
    { 51, 39,11470,11482},
    { 51, 40,11482,11494},
    { 51, 41,11494,11506},
    { 51, 42,11506,11518},
    { 51, 43,11518,11530},
    { 51, 44,11530,11542},
    { 51, 45,11542,11554},
    { 51, 46,11554,11566},
    { 51, 47,11566,11574},
    { 51, 48,11574,11582},
    { 51, 49,11582,11598},
    { 51, 50,11598,11618},
    { 51, 51,11618,11628},
    { 52,  1,11628,11634},
    { 52,  2,11634,11637},
    { 52,  3,11637,11643},
    { 52,  4,11643,11652},
    { 52,  5,11652,11667},
    { 52,  6,11667,11682},
    { 52,  7,11682,11694},
    { 52,  8,11694,11703},
    { 52,  9,11703,11709},
    { 52, 10,11709,11712},
    { 52, 11,11712,11718},
    { 52, 12,11718,11727},
    { 52, 13,11727,11739},
    { 52, 14,11739,11754},
    { 52, 15,11754,11766},
    { 52, 16,11766,11775},
    { 52, 17,11775,11781},
    { 52, 18,11781,11784},
    { 52, 19,11784,11790},
    { 52, 20,11790,11799},
    { 52, 21,11799,11808},
    { 52, 22,11808,11817},
    { 52, 23,11817,11826},
    { 52, 24,11826,11835},
    { 52, 25,11835,11844},
    { 52, 26,11844,11853},
    { 52, 27,11853,11865},
    { 52, 28,11865,11877},
    { 52, 29,11877,11883},
    { 52, 30,11883,11889},
    { 52, 31,11889,11901},
    { 52, 32,11901,11916},
    { 52, 33,11916,11928},
    { 52, 34,11928,11937},
    { 52, 35,11937,11943},
    { 52, 36,11943,11946},
    { 52, 37,11946,11952},
    { 52, 38,11952,11961},
    { 52, 39,11961,11970},
    { 52, 40,11970,11979},
    { 52, 41,11979,11988},
    { 52, 42,11988,11997},
    { 52, 43,11997,12006},
    { 52, 44,12006,12015},
    { 52, 45,12015,12024},
    { 52, 46,12024,12033},
    { 52, 47,12033,12039},
    { 52, 48,12039,12045},
    { 52, 49,12045,12057},
    { 52, 50,12057,12072},
    { 52, 51,12072,12084},
    { 52, 52,12084,12090},
    { 53,  1,12090,12094},
    { 53,  2,12094,12096},
    { 53,  3,12096,12100},
    { 53,  4,12100,12106},
    { 53,  5,12106,12116},
    { 53,  6,12116,12126},
    { 53,  7,12126,12134},
    { 53,  8,12134,12140},
    { 53,  9,12140,12144},
    { 53, 10,12144,12146},
    { 53, 11,12146,12150},
    { 53, 12,12150,12156},
    { 53, 13,12156,12164},
    { 53, 14,12164,12174},
    { 53, 15,12174,12182},
    { 53, 16,12182,12188},
    { 53, 17,12188,12192},
    { 53, 18,12192,12194},
    { 53, 19,12194,12198},
    { 53, 20,12198,12204},
    { 53, 21,12204,12210},
    { 53, 22,12210,12216},
    { 53, 23,12216,12222},
    { 53, 24,12222,12228},
    { 53, 25,12228,12234},
    { 53, 26,12234,12240},
    { 53, 27,12240,12248},
    { 53, 28,12248,12256},
    { 53, 29,12256,12260},
    { 53, 30,12260,12264},
    { 53, 31,12264,12272},
    { 53, 32,12272,12282},
    { 53, 33,12282,12290},
    { 53, 34,12290,12296},
    { 53, 35,12296,12300},
    { 53, 36,12300,12302},
    { 53, 37,12302,12306},
    { 53, 38,12306,12312},
    { 53, 39,12312,12318},
    { 53, 40,12318,12324},
    { 53, 41,12324,12330},
    { 53, 42,12330,12336},
    { 53, 43,12336,12342},
    { 53, 44,12342,12348},
    { 53, 45,12348,12354},
    { 53, 46,12354,12360},
    { 53, 47,12360,12364},
    { 53, 48,12364,12368},
    { 53, 49,12368,12376},
    { 53, 50,12376,12386},
    { 53, 51,12386,12394},
    { 53, 52,12394,12400},
    { 53, 53,12400,12403},
    { 54,  1,12403,12405},
    { 54,  2,12405,12406},
    { 54,  3,12406,12408},
    { 54,  4,12408,12411},
    { 54,  5,12411,12416},
    { 54,  6,12416,12421},
    { 54,  7,12421,12425},
    { 54,  8,12425,12428},
    { 54,  9,12428,12430},
    { 54, 10,12430,12431},
    { 54, 11,12431,12433},
    { 54, 12,12433,12436},
    { 54, 13,12436,12440},
    { 54, 14,12440,12445},
    { 54, 15,12445,12449},
    { 54, 16,12449,12452},
    { 54, 17,12452,12454},
    { 54, 18,12454,12455},
    { 54, 19,12455,12457},
    { 54, 20,12457,12460},
    { 54, 21,12460,12463},
    { 54, 22,12463,12466},
    { 54, 23,12466,12469},
    { 54, 24,12469,12472},
    { 54, 25,12472,12475},
    { 54, 26,12475,12478},
    { 54, 27,12478,12482},
    { 54, 28,12482,12486},
    { 54, 29,12486,12488},
    { 54, 30,12488,12490},
    { 54, 31,12490,12494},
    { 54, 32,12494,12499},
    { 54, 33,12499,12503},
    { 54, 34,12503,12506},
    { 54, 35,12506,12508},
    { 54, 36,12508,12509},
    { 54, 37,12509,12511},
    { 54, 38,12511,12514},
    { 54, 39,12514,12517},
    { 54, 40,12517,12520},
    { 54, 41,12520,12523},
    { 54, 42,12523,12526},
    { 54, 43,12526,12529},
    { 54, 44,12529,12532},
    { 54, 45,12532,12535},
    { 54, 46,12535,12538},
    { 54, 47,12538,12540},
    { 54, 48,12540,12542},
    { 54, 49,12542,12546},
    { 54, 50,12546,12551},
    { 54, 51,12551,12555},
    { 54, 52,12555,12558},
    { 54, 53,12558,12560},
    { 54, 54,12560,12561},
    { 55,  1,12561,12565},
    { 55,  2,12565,12567},
    { 55,  3,12567,12571},
    { 55,  4,12571,12577},
    { 55,  5,12577,12587},
    { 55,  6,12587,12597},
    { 55,  7,12597,12605},
    { 55,  8,12605,12611},
    { 55,  9,12611,12615},
    { 55, 10,12615,12617},
    { 55, 11,12617,12621},
    { 55, 12,12621,12627},
    { 55, 13,12627,12635},
    { 55, 14,12635,12645},
    { 55, 15,12645,12653},
    { 55, 16,12653,12659},
    { 55, 17,12659,12663},
    { 55, 18,12663,12665},
    { 55, 19,12665,12669},
    { 55, 20,12669,12675},
    { 55, 21,12675,12681},
    { 55, 22,12681,12687},
    { 55, 23,12687,12693},
    { 55, 24,12693,12699},
    { 55, 25,12699,12705},
    { 55, 26,12705,12711},
    { 55, 27,12711,12719},
    { 55, 28,12719,12727},
    { 55, 29,12727,12731},
    { 55, 30,12731,12735},
    { 55, 31,12735,12743},
    { 55, 32,12743,12753},
    { 55, 33,12753,12761},
    { 55, 34,12761,12767},
    { 55, 35,12767,12771},
    { 55, 36,12771,12773},
    { 55, 37,12773,12777},
    { 55, 38,12777,12783},
    { 55, 39,12783,12789},
    { 55, 40,12789,12795},
    { 55, 41,12795,12801},
    { 55, 42,12801,12807},
    { 55, 43,12807,12813},
    { 55, 44,12813,12819},
    { 55, 45,12819,12825},
    { 55, 46,12825,12831},
    { 55, 47,12831,12835},
    { 55, 48,12835,12839},
    { 55, 49,12839,12847},
    { 55, 50,12847,12857},
    { 55, 51,12857,12865},
    { 55, 52,12865,12871},
    { 55, 53,12871,12875},
    { 55, 54,12875,12877},
    { 55, 55,12877,12880},
    { 56,  1,12880,12886},
    { 56,  2,12886,12889},
    { 56,  3,12889,12895},
    { 56,  4,12895,12904},
    { 56,  5,12904,12919},
    { 56,  6,12919,12934},
    { 56,  7,12934,12946},
    { 56,  8,12946,12955},
    { 56,  9,12955,12961},
    { 56, 10,12961,12964},
    { 56, 11,12964,12970},
    { 56, 12,12970,12979},
    { 56, 13,12979,12991},
    { 56, 14,12991,13006},
    { 56, 15,13006,13018},
    { 56, 16,13018,13027},
    { 56, 17,13027,13033},
    { 56, 18,13033,13036},
    { 56, 19,13036,13042},
    { 56, 20,13042,13051},
    { 56, 21,13051,13060},
    { 56, 22,13060,13069},
    { 56, 23,13069,13078},
    { 56, 24,13078,13087},
    { 56, 25,13087,13096},
    { 56, 26,13096,13105},
    { 56, 27,13105,13117},
    { 56, 28,13117,13129},
    { 56, 29,13129,13135},
    { 56, 30,13135,13141},
    { 56, 31,13141,13153},
    { 56, 32,13153,13168},
    { 56, 33,13168,13180},
    { 56, 34,13180,13189},
    { 56, 35,13189,13195},
    { 56, 36,13195,13198},
    { 56, 37,13198,13204},
    { 56, 38,13204,13213},
    { 56, 39,13213,13222},
    { 56, 40,13222,13231},
    { 56, 41,13231,13240},
    { 56, 42,13240,13249},
    { 56, 43,13249,13258},
    { 56, 44,13258,13267},
    { 56, 45,13267,13276},
    { 56, 46,13276,13285},
    { 56, 47,13285,13291},
    { 56, 48,13291,13297},
    { 56, 49,13297,13309},
    { 56, 50,13309,13324},
    { 56, 51,13324,13336},
    { 56, 52,13336,13345},
    { 56, 53,13345,13351},
    { 56, 54,13351,13354},
    { 56, 55,13354,13360},
    { 56, 56,13360,13366},
    { 57,  1,13366,13372},
    { 57,  2,13372,13375},
    { 57,  3,13375,13381},
    { 57,  4,13381,13390},
    { 57,  5,13390,13405},
    { 57,  6,13405,13420},
    { 57,  7,13420,13432},
    { 57,  8,13432,13441},
    { 57,  9,13441,13447},
    { 57, 10,13447,13450},
    { 57, 11,13450,13456},
    { 57, 12,13456,13465},
    { 57, 13,13465,13477},
    { 57, 14,13477,13492},
    { 57, 15,13492,13504},
    { 57, 16,13504,13513},
    { 57, 17,13513,13519},
    { 57, 18,13519,13522},
    { 57, 19,13522,13528},
    { 57, 20,13528,13537},
    { 57, 21,13537,13546},
    { 57, 22,13546,13555},
    { 57, 23,13555,13564},
    { 57, 24,13564,13573},
    { 57, 25,13573,13582},
    { 57, 26,13582,13591},
    { 57, 27,13591,13603},
    { 57, 28,13603,13615},
    { 57, 29,13615,13621},
    { 57, 30,13621,13627},
    { 57, 31,13627,13639},
    { 57, 32,13639,13654},
    { 57, 33,13654,13666},
    { 57, 34,13666,13675},
    { 57, 35,13675,13681},
    { 57, 36,13681,13684},
    { 57, 37,13684,13690},
    { 57, 38,13690,13699},
    { 57, 39,13699,13708},
    { 57, 40,13708,13717},
    { 57, 41,13717,13726},
    { 57, 42,13726,13735},
    { 57, 43,13735,13744},
    { 57, 44,13744,13753},
    { 57, 45,13753,13762},
    { 57, 46,13762,13771},
    { 57, 47,13771,13777},
    { 57, 48,13777,13783},
    { 57, 49,13783,13795},
    { 57, 50,13795,13810},
    { 57, 51,13810,13822},
    { 57, 52,13822,13831},
    { 57, 53,13831,13837},
    { 57, 54,13837,13840},
    { 57, 55,13840,13846},
    { 57, 56,13846,13855},
    { 57, 57,13855,13861},
    { 58,  1,13861,13863},
    { 58,  2,13863,13864},
    { 58,  3,13864,13866},
    { 58,  4,13866,13869},
    { 58,  5,13869,13874},
    { 58,  6,13874,13879},
    { 58,  7,13879,13883},
    { 58,  8,13883,13886},
    { 58,  9,13886,13888},
    { 58, 10,13888,13889},
    { 58, 11,13889,13891},
    { 58, 12,13891,13894},
    { 58, 13,13894,13898},
    { 58, 14,13898,13903},
    { 58, 15,13903,13907},
    { 58, 16,13907,13910},
    { 58, 17,13910,13912},
    { 58, 18,13912,13913},
    { 58, 19,13913,13915},
    { 58, 20,13915,13918},
    { 58, 21,13918,13921},
    { 58, 22,13921,13924},
    { 58, 23,13924,13927},
    { 58, 24,13927,13930},
    { 58, 25,13930,13933},
    { 58, 26,13933,13936},
    { 58, 27,13936,13940},
    { 58, 28,13940,13944},
    { 58, 29,13944,13946},
    { 58, 30,13946,13948},
    { 58, 31,13948,13952},
    { 58, 32,13952,13957},
    { 58, 33,13957,13961},
    { 58, 34,13961,13964},
    { 58, 35,13964,13966},
    { 58, 36,13966,13967},
    { 58, 37,13967,13969},
    { 58, 38,13969,13972},
    { 58, 39,13972,13975},
    { 58, 40,13975,13978},
    { 58, 41,13978,13981},
    { 58, 42,13981,13984},
    { 58, 43,13984,13987},
    { 58, 44,13987,13990},
    { 58, 45,13990,13993},
    { 58, 46,13993,13996},
    { 58, 47,13996,13998},
    { 58, 48,13998,14000},
    { 58, 49,14000,14004},
    { 58, 50,14004,14009},
    { 58, 51,14009,14013},
    { 58, 52,14013,14016},
    { 58, 53,14016,14018},
    { 58, 54,14018,14019},
    { 58, 55,14019,14021},
    { 58, 56,14021,14024},
    { 58, 57,14024,14027},
    { 58, 58,14027,14028},
    { 59,  1,14028,14032},
    { 59,  2,14032,14034},
    { 59,  3,14034,14038},
    { 59,  4,14038,14044},
    { 59,  5,14044,14054},
    { 59,  6,14054,14064},
    { 59,  7,14064,14072},
    { 59,  8,14072,14078},
    { 59,  9,14078,14082},
    { 59, 10,14082,14084},
    { 59, 11,14084,14088},
    { 59, 12,14088,14094},
    { 59, 13,14094,14102},
    { 59, 14,14102,14112},
    { 59, 15,14112,14120},
    { 59, 16,14120,14126},
    { 59, 17,14126,14130},
    { 59, 18,14130,14132},
    { 59, 19,14132,14136},
    { 59, 20,14136,14142},
    { 59, 21,14142,14148},
    { 59, 22,14148,14154},
    { 59, 23,14154,14160},
    { 59, 24,14160,14166},
    { 59, 25,14166,14172},
    { 59, 26,14172,14178},
    { 59, 27,14178,14186},
    { 59, 28,14186,14194},
    { 59, 29,14194,14198},
    { 59, 30,14198,14202},
    { 59, 31,14202,14210},
    { 59, 32,14210,14220},
    { 59, 33,14220,14228},
    { 59, 34,14228,14234},
    { 59, 35,14234,14238},
    { 59, 36,14238,14240},
    { 59, 37,14240,14244},
    { 59, 38,14244,14250},
    { 59, 39,14250,14256},
    { 59, 40,14256,14262},
    { 59, 41,14262,14268},
    { 59, 42,14268,14274},
    { 59, 43,14274,14280},
    { 59, 44,14280,14286},
    { 59, 45,14286,14292},
    { 59, 46,14292,14298},
    { 59, 47,14298,14302},
    { 59, 48,14302,14306},
    { 59, 49,14306,14314},
    { 59, 50,14314,14324},
    { 59, 51,14324,14332},
    { 59, 52,14332,14338},
    { 59, 53,14338,14342},
    { 59, 54,14342,14344},
    { 59, 55,14344,14348},
    { 59, 56,14348,14354},
    { 59, 57,14354,14360},
    { 59, 58,14360,14362},
    { 59, 59,14362,14365},
    { 60,  1,14365,14369},
    { 60,  2,14369,14371},
    { 60,  3,14371,14375},
    { 60,  4,14375,14381},
    { 60,  5,14381,14391},
    { 60,  6,14391,14401},
    { 60,  7,14401,14409},
    { 60,  8,14409,14415},
    { 60,  9,14415,14419},
    { 60, 10,14419,14421},
    { 60, 11,14421,14425},
    { 60, 12,14425,14431},
    { 60, 13,14431,14439},
    { 60, 14,14439,14449},
    { 60, 15,14449,14457},
    { 60, 16,14457,14463},
    { 60, 17,14463,14467},
    { 60, 18,14467,14469},
    { 60, 19,14469,14473},
    { 60, 20,14473,14479},
    { 60, 21,14479,14485},
    { 60, 22,14485,14491},
    { 60, 23,14491,14497},
    { 60, 24,14497,14503},
    { 60, 25,14503,14509},
    { 60, 26,14509,14515},
    { 60, 27,14515,14523},
    { 60, 28,14523,14531},
    { 60, 29,14531,14535},
    { 60, 30,14535,14539},
    { 60, 31,14539,14547},
    { 60, 32,14547,14557},
    { 60, 33,14557,14565},
    { 60, 34,14565,14571},
    { 60, 35,14571,14575},
    { 60, 36,14575,14577},
    { 60, 37,14577,14581},
    { 60, 38,14581,14587},
    { 60, 39,14587,14593},
    { 60, 40,14593,14599},
    { 60, 41,14599,14605},
    { 60, 42,14605,14611},
    { 60, 43,14611,14617},
    { 60, 44,14617,14623},
    { 60, 45,14623,14629},
    { 60, 46,14629,14635},
    { 60, 47,14635,14639},
    { 60, 48,14639,14643},
    { 60, 49,14643,14651},
    { 60, 50,14651,14661},
    { 60, 51,14661,14669},
    { 60, 52,14669,14675},
    { 60, 53,14675,14679},
    { 60, 54,14679,14681},
    { 60, 55,14681,14685},
    { 60, 56,14685,14691},
    { 60, 57,14691,14697},
    { 60, 58,14697,14699},
    { 60, 59,14699,14703},
    { 60, 60,14703,14706},
    { 61,  1,14706,14710},
    { 61,  2,14710,14712},
    { 61,  3,14712,14716},
    { 61,  4,14716,14722},
    { 61,  5,14722,14732},
    { 61,  6,14732,14742},
    { 61,  7,14742,14750},
    { 61,  8,14750,14756},
    { 61,  9,14756,14760},
    { 61, 10,14760,14762},
    { 61, 11,14762,14766},
    { 61, 12,14766,14772},
    { 61, 13,14772,14780},
    { 61, 14,14780,14790},
    { 61, 15,14790,14798},
    { 61, 16,14798,14804},
    { 61, 17,14804,14808},
    { 61, 18,14808,14810},
    { 61, 19,14810,14814},
    { 61, 20,14814,14820},
    { 61, 21,14820,14826},
    { 61, 22,14826,14832},
    { 61, 23,14832,14838},
    { 61, 24,14838,14844},
    { 61, 25,14844,14850},
    { 61, 26,14850,14856},
    { 61, 27,14856,14864},
    { 61, 28,14864,14872},
    { 61, 29,14872,14876},
    { 61, 30,14876,14880},
    { 61, 31,14880,14888},
    { 61, 32,14888,14898},
    { 61, 33,14898,14906},
    { 61, 34,14906,14912},
    { 61, 35,14912,14916},
    { 61, 36,14916,14918},
    { 61, 37,14918,14922},
    { 61, 38,14922,14928},
    { 61, 39,14928,14934},
    { 61, 40,14934,14940},
    { 61, 41,14940,14946},
    { 61, 42,14946,14952},
    { 61, 43,14952,14958},
    { 61, 44,14958,14964},
    { 61, 45,14964,14970},
    { 61, 46,14970,14976},
    { 61, 47,14976,14980},
    { 61, 48,14980,14984},
    { 61, 49,14984,14992},
    { 61, 50,14992,15002},
    { 61, 51,15002,15010},
    { 61, 52,15010,15016},
    { 61, 53,15016,15020},
    { 61, 54,15020,15022},
    { 61, 55,15022,15026},
    { 61, 56,15026,15032},
    { 61, 57,15032,15038},
    { 61, 58,15038,15040},
    { 61, 59,15040,15044},
    { 61, 60,15044,15048},
    { 61, 61,15048,15051},
    { 62,  1,15051,15055},
    { 62,  2,15055,15057},
    { 62,  3,15057,15061},
    { 62,  4,15061,15067},
    { 62,  5,15067,15077},
    { 62,  6,15077,15087},
    { 62,  7,15087,15095},
    { 62,  8,15095,15101},
    { 62,  9,15101,15105},
    { 62, 10,15105,15107},
    { 62, 11,15107,15111},
    { 62, 12,15111,15117},
    { 62, 13,15117,15125},
    { 62, 14,15125,15135},
    { 62, 15,15135,15143},
    { 62, 16,15143,15149},
    { 62, 17,15149,15153},
    { 62, 18,15153,15155},
    { 62, 19,15155,15159},
    { 62, 20,15159,15165},
    { 62, 21,15165,15171},
    { 62, 22,15171,15177},
    { 62, 23,15177,15183},
    { 62, 24,15183,15189},
    { 62, 25,15189,15195},
    { 62, 26,15195,15201},
    { 62, 27,15201,15209},
    { 62, 28,15209,15217},
    { 62, 29,15217,15221},
    { 62, 30,15221,15225},
    { 62, 31,15225,15233},
    { 62, 32,15233,15243},
    { 62, 33,15243,15251},
    { 62, 34,15251,15257},
    { 62, 35,15257,15261},
    { 62, 36,15261,15263},
    { 62, 37,15263,15267},
    { 62, 38,15267,15273},
    { 62, 39,15273,15279},
    { 62, 40,15279,15285},
    { 62, 41,15285,15291},
    { 62, 42,15291,15297},
    { 62, 43,15297,15303},
    { 62, 44,15303,15309},
    { 62, 45,15309,15315},
    { 62, 46,15315,15321},
    { 62, 47,15321,15325},
    { 62, 48,15325,15329},
    { 62, 49,15329,15337},
    { 62, 50,15337,15347},
    { 62, 51,15347,15355},
    { 62, 52,15355,15361},
    { 62, 53,15361,15365},
    { 62, 54,15365,15367},
    { 62, 55,15367,15371},
    { 62, 56,15371,15377},
    { 62, 57,15377,15383},
    { 62, 58,15383,15385},
    { 62, 59,15385,15389},
    { 62, 60,15389,15393},
    { 62, 61,15393,15397},
    { 62, 62,15397,15400},
    { 63,  1,15400,15404},
    { 63,  2,15404,15406},
    { 63,  3,15406,15410},
    { 63,  4,15410,15416},
    { 63,  5,15416,15426},
    { 63,  6,15426,15436},
    { 63,  7,15436,15444},
    { 63,  8,15444,15450},
    { 63,  9,15450,15454},
    { 63, 10,15454,15456},
    { 63, 11,15456,15460},
    { 63, 12,15460,15466},
    { 63, 13,15466,15474},
    { 63, 14,15474,15484},
    { 63, 15,15484,15492},
    { 63, 16,15492,15498},
    { 63, 17,15498,15502},
    { 63, 18,15502,15504},
    { 63, 19,15504,15508},
    { 63, 20,15508,15514},
    { 63, 21,15514,15520},
    { 63, 22,15520,15526},
    { 63, 23,15526,15532},
    { 63, 24,15532,15538},
    { 63, 25,15538,15544},
    { 63, 26,15544,15550},
    { 63, 27,15550,15558},
    { 63, 28,15558,15566},
    { 63, 29,15566,15570},
    { 63, 30,15570,15574},
    { 63, 31,15574,15582},
    { 63, 32,15582,15592},
    { 63, 33,15592,15600},
    { 63, 34,15600,15606},
    { 63, 35,15606,15610},
    { 63, 36,15610,15612},
    { 63, 37,15612,15616},
    { 63, 38,15616,15622},
    { 63, 39,15622,15628},
    { 63, 40,15628,15634},
    { 63, 41,15634,15640},
    { 63, 42,15640,15646},
    { 63, 43,15646,15652},
    { 63, 44,15652,15658},
    { 63, 45,15658,15664},
    { 63, 46,15664,15670},
    { 63, 47,15670,15674},
    { 63, 48,15674,15678},
    { 63, 49,15678,15686},
    { 63, 50,15686,15696},
    { 63, 51,15696,15704},
    { 63, 52,15704,15710},
    { 63, 53,15710,15714},
    { 63, 54,15714,15716},
    { 63, 55,15716,15720},
    { 63, 56,15720,15726},
    { 63, 57,15726,15732},
    { 63, 58,15732,15734},
    { 63, 59,15734,15738},
    { 63, 60,15738,15742},
    { 63, 61,15742,15746},
    { 63, 62,15746,15750},
    { 63, 63,15750,15753},
    { 64,  1,15753,15757},
    { 64,  2,15757,15759},
    { 64,  3,15759,15763},
    { 64,  4,15763,15769},
    { 64,  5,15769,15779},
    { 64,  6,15779,15789},
    { 64,  7,15789,15797},
    { 64,  8,15797,15803},
    { 64,  9,15803,15807},
    { 64, 10,15807,15809},
    { 64, 11,15809,15813},
    { 64, 12,15813,15819},
    { 64, 13,15819,15827},
    { 64, 14,15827,15837},
    { 64, 15,15837,15845},
    { 64, 16,15845,15851},
    { 64, 17,15851,15855},
    { 64, 18,15855,15857},
    { 64, 19,15857,15861},
    { 64, 20,15861,15867},
    { 64, 21,15867,15873},
    { 64, 22,15873,15879},
    { 64, 23,15879,15885},
    { 64, 24,15885,15891},
    { 64, 25,15891,15897},
    { 64, 26,15897,15903},
    { 64, 27,15903,15911},
    { 64, 28,15911,15919},
    { 64, 29,15919,15923},
    { 64, 30,15923,15927},
    { 64, 31,15927,15935},
    { 64, 32,15935,15945},
    { 64, 33,15945,15953},
    { 64, 34,15953,15959},
    { 64, 35,15959,15963},
    { 64, 36,15963,15965},
    { 64, 37,15965,15969},
    { 64, 38,15969,15975},
    { 64, 39,15975,15981},
    { 64, 40,15981,15987},
    { 64, 41,15987,15993},
    { 64, 42,15993,15999},
    { 64, 43,15999,16005},
    { 64, 44,16005,16011},
    { 64, 45,16011,16017},
    { 64, 46,16017,16023},
    { 64, 47,16023,16027},
    { 64, 48,16027,16031},
    { 64, 49,16031,16039},
    { 64, 50,16039,16049},
    { 64, 51,16049,16057},
    { 64, 52,16057,16063},
    { 64, 53,16063,16067},
    { 64, 54,16067,16069},
    { 64, 55,16069,16073},
    { 64, 56,16073,16079},
    { 64, 57,16079,16085},
    { 64, 58,16085,16087},
    { 64, 59,16087,16091},
    { 64, 60,16091,16095},
    { 64, 61,16095,16099},
    { 64, 62,16099,16103},
    { 64, 63,16103,16107},
    { 64, 64,16107,16110},
    { 65,  1,16110,16114},
    { 65,  2,16114,16116},
    { 65,  3,16116,16120},
    { 65,  4,16120,16126},
    { 65,  5,16126,16136},
    { 65,  6,16136,16146},
    { 65,  7,16146,16154},
    { 65,  8,16154,16160},
    { 65,  9,16160,16164},
    { 65, 10,16164,16166},
    { 65, 11,16166,16170},
    { 65, 12,16170,16176},
    { 65, 13,16176,16184},
    { 65, 14,16184,16194},
    { 65, 15,16194,16202},
    { 65, 16,16202,16208},
    { 65, 17,16208,16212},
    { 65, 18,16212,16214},
    { 65, 19,16214,16218},
    { 65, 20,16218,16224},
    { 65, 21,16224,16230},
    { 65, 22,16230,16236},
    { 65, 23,16236,16242},
    { 65, 24,16242,16248},
    { 65, 25,16248,16254},
    { 65, 26,16254,16260},
    { 65, 27,16260,16268},
    { 65, 28,16268,16276},
    { 65, 29,16276,16280},
    { 65, 30,16280,16284},
    { 65, 31,16284,16292},
    { 65, 32,16292,16302},
    { 65, 33,16302,16310},
    { 65, 34,16310,16316},
    { 65, 35,16316,16320},
    { 65, 36,16320,16322},
    { 65, 37,16322,16326},
    { 65, 38,16326,16332},
    { 65, 39,16332,16338},
    { 65, 40,16338,16344},
    { 65, 41,16344,16350},
    { 65, 42,16350,16356},
    { 65, 43,16356,16362},
    { 65, 44,16362,16368},
    { 65, 45,16368,16374},
    { 65, 46,16374,16380},
    { 65, 47,16380,16384},
    { 65, 48,16384,16388},
    { 65, 49,16388,16396},
    { 65, 50,16396,16406},
    { 65, 51,16406,16414},
    { 65, 52,16414,16420},
    { 65, 53,16420,16424},
    { 65, 54,16424,16426},
    { 65, 55,16426,16430},
    { 65, 56,16430,16436},
    { 65, 57,16436,16442},
    { 65, 58,16442,16444},
    { 65, 59,16444,16448},
    { 65, 60,16448,16452},
    { 65, 61,16452,16456},
    { 65, 62,16456,16460},
    { 65, 63,16460,16464},
    { 65, 64,16464,16468},
    { 65, 65,16468,16471},
    { 66,  1,16471,16475},
    { 66,  2,16475,16477},
    { 66,  3,16477,16481},
    { 66,  4,16481,16487},
    { 66,  5,16487,16497},
    { 66,  6,16497,16507},
    { 66,  7,16507,16515},
    { 66,  8,16515,16521},
    { 66,  9,16521,16525},
    { 66, 10,16525,16527},
    { 66, 11,16527,16531},
    { 66, 12,16531,16537},
    { 66, 13,16537,16545},
    { 66, 14,16545,16555},
    { 66, 15,16555,16563},
    { 66, 16,16563,16569},
    { 66, 17,16569,16573},
    { 66, 18,16573,16575},
    { 66, 19,16575,16579},
    { 66, 20,16579,16585},
    { 66, 21,16585,16591},
    { 66, 22,16591,16597},
    { 66, 23,16597,16603},
    { 66, 24,16603,16609},
    { 66, 25,16609,16615},
    { 66, 26,16615,16621},
    { 66, 27,16621,16629},
    { 66, 28,16629,16637},
    { 66, 29,16637,16641},
    { 66, 30,16641,16645},
    { 66, 31,16645,16653},
    { 66, 32,16653,16663},
    { 66, 33,16663,16671},
    { 66, 34,16671,16677},
    { 66, 35,16677,16681},
    { 66, 36,16681,16683},
    { 66, 37,16683,16687},
    { 66, 38,16687,16693},
    { 66, 39,16693,16699},
    { 66, 40,16699,16705},
    { 66, 41,16705,16711},
    { 66, 42,16711,16717},
    { 66, 43,16717,16723},
    { 66, 44,16723,16729},
    { 66, 45,16729,16735},
    { 66, 46,16735,16741},
    { 66, 47,16741,16745},
    { 66, 48,16745,16749},
    { 66, 49,16749,16757},
    { 66, 50,16757,16767},
    { 66, 51,16767,16775},
    { 66, 52,16775,16781},
    { 66, 53,16781,16785},
    { 66, 54,16785,16787},
    { 66, 55,16787,16791},
    { 66, 56,16791,16797},
    { 66, 57,16797,16803},
    { 66, 58,16803,16805},
    { 66, 59,16805,16809},
    { 66, 60,16809,16813},
    { 66, 61,16813,16817},
    { 66, 62,16817,16821},
    { 66, 63,16821,16825},
    { 66, 64,16825,16829},
    { 66, 65,16829,16833},
    { 66, 66,16833,16836},
    { 67,  1,16836,16840},
    { 67,  2,16840,16842},
    { 67,  3,16842,16846},
    { 67,  4,16846,16852},
    { 67,  5,16852,16862},
    { 67,  6,16862,16872},
    { 67,  7,16872,16880},
    { 67,  8,16880,16886},
    { 67,  9,16886,16890},
    { 67, 10,16890,16892},
    { 67, 11,16892,16896},
    { 67, 12,16896,16902},
    { 67, 13,16902,16910},
    { 67, 14,16910,16920},
    { 67, 15,16920,16928},
    { 67, 16,16928,16934},
    { 67, 17,16934,16938},
    { 67, 18,16938,16940},
    { 67, 19,16940,16944},
    { 67, 20,16944,16950},
    { 67, 21,16950,16956},
    { 67, 22,16956,16962},
    { 67, 23,16962,16968},
    { 67, 24,16968,16974},
    { 67, 25,16974,16980},
    { 67, 26,16980,16986},
    { 67, 27,16986,16994},
    { 67, 28,16994,17002},
    { 67, 29,17002,17006},
    { 67, 30,17006,17010},
    { 67, 31,17010,17018},
    { 67, 32,17018,17028},
    { 67, 33,17028,17036},
    { 67, 34,17036,17042},
    { 67, 35,17042,17046},
    { 67, 36,17046,17048},
    { 67, 37,17048,17052},
    { 67, 38,17052,17058},
    { 67, 39,17058,17064},
    { 67, 40,17064,17070},
    { 67, 41,17070,17076},
    { 67, 42,17076,17082},
    { 67, 43,17082,17088},
    { 67, 44,17088,17094},
    { 67, 45,17094,17100},
    { 67, 46,17100,17106},
    { 67, 47,17106,17110},
    { 67, 48,17110,17114},
    { 67, 49,17114,17122},
    { 67, 50,17122,17132},
    { 67, 51,17132,17140},
    { 67, 52,17140,17146},
    { 67, 53,17146,17150},
    { 67, 54,17150,17152},
    { 67, 55,17152,17156},
    { 67, 56,17156,17162},
    { 67, 57,17162,17168},
    { 67, 58,17168,17170},
    { 67, 59,17170,17174},
    { 67, 60,17174,17178},
    { 67, 61,17178,17182},
    { 67, 62,17182,17186},
    { 67, 63,17186,17190},
    { 67, 64,17190,17194},
    { 67, 65,17194,17198},
    { 67, 66,17198,17202},
    { 67, 67,17202,17205},
    { 68,  1,17205,17209},
    { 68,  2,17209,17211},
    { 68,  3,17211,17215},
    { 68,  4,17215,17221},
    { 68,  5,17221,17231},
    { 68,  6,17231,17241},
    { 68,  7,17241,17249},
    { 68,  8,17249,17255},
    { 68,  9,17255,17259},
    { 68, 10,17259,17261},
    { 68, 11,17261,17265},
    { 68, 12,17265,17271},
    { 68, 13,17271,17279},
    { 68, 14,17279,17289},
    { 68, 15,17289,17297},
    { 68, 16,17297,17303},
    { 68, 17,17303,17307},
    { 68, 18,17307,17309},
    { 68, 19,17309,17313},
    { 68, 20,17313,17319},
    { 68, 21,17319,17325},
    { 68, 22,17325,17331},
    { 68, 23,17331,17337},
    { 68, 24,17337,17343},
    { 68, 25,17343,17349},
    { 68, 26,17349,17355},
    { 68, 27,17355,17363},
    { 68, 28,17363,17371},
    { 68, 29,17371,17375},
    { 68, 30,17375,17379},
    { 68, 31,17379,17387},
    { 68, 32,17387,17397},
    { 68, 33,17397,17405},
    { 68, 34,17405,17411},
    { 68, 35,17411,17415},
    { 68, 36,17415,17417},
    { 68, 37,17417,17421},
    { 68, 38,17421,17427},
    { 68, 39,17427,17433},
    { 68, 40,17433,17439},
    { 68, 41,17439,17445},
    { 68, 42,17445,17451},
    { 68, 43,17451,17457},
    { 68, 44,17457,17463},
    { 68, 45,17463,17469},
    { 68, 46,17469,17475},
    { 68, 47,17475,17479},
    { 68, 48,17479,17483},
    { 68, 49,17483,17491},
    { 68, 50,17491,17501},
    { 68, 51,17501,17509},
    { 68, 52,17509,17515},
    { 68, 53,17515,17519},
    { 68, 54,17519,17521},
    { 68, 55,17521,17525},
    { 68, 56,17525,17531},
    { 68, 57,17531,17537},
    { 68, 58,17537,17539},
    { 68, 59,17539,17543},
    { 68, 60,17543,17547},
    { 68, 61,17547,17551},
    { 68, 62,17551,17555},
    { 68, 63,17555,17559},
    { 68, 64,17559,17563},
    { 68, 65,17563,17567},
    { 68, 66,17567,17571},
    { 68, 67,17571,17575},
    { 68, 68,17575,17578},
    { 69,  1,17578,17582},
    { 69,  2,17582,17584},
    { 69,  3,17584,17588},
    { 69,  4,17588,17594},
    { 69,  5,17594,17604},
    { 69,  6,17604,17614},
    { 69,  7,17614,17622},
    { 69,  8,17622,17628},
    { 69,  9,17628,17632},
    { 69, 10,17632,17634},
    { 69, 11,17634,17638},
    { 69, 12,17638,17644},
    { 69, 13,17644,17652},
    { 69, 14,17652,17662},
    { 69, 15,17662,17670},
    { 69, 16,17670,17676},
    { 69, 17,17676,17680},
    { 69, 18,17680,17682},
    { 69, 19,17682,17686},
    { 69, 20,17686,17692},
    { 69, 21,17692,17698},
    { 69, 22,17698,17704},
    { 69, 23,17704,17710},
    { 69, 24,17710,17716},
    { 69, 25,17716,17722},
    { 69, 26,17722,17728},
    { 69, 27,17728,17736},
    { 69, 28,17736,17744},
    { 69, 29,17744,17748},
    { 69, 30,17748,17752},
    { 69, 31,17752,17760},
    { 69, 32,17760,17770},
    { 69, 33,17770,17778},
    { 69, 34,17778,17784},
    { 69, 35,17784,17788},
    { 69, 36,17788,17790},
    { 69, 37,17790,17794},
    { 69, 38,17794,17800},
    { 69, 39,17800,17806},
    { 69, 40,17806,17812},
    { 69, 41,17812,17818},
    { 69, 42,17818,17824},
    { 69, 43,17824,17830},
    { 69, 44,17830,17836},
    { 69, 45,17836,17842},
    { 69, 46,17842,17848},
    { 69, 47,17848,17852},
    { 69, 48,17852,17856},
    { 69, 49,17856,17864},
    { 69, 50,17864,17874},
    { 69, 51,17874,17882},
    { 69, 52,17882,17888},
    { 69, 53,17888,17892},
    { 69, 54,17892,17894},
    { 69, 55,17894,17898},
    { 69, 56,17898,17904},
    { 69, 57,17904,17910},
    { 69, 58,17910,17912},
    { 69, 59,17912,17916},
    { 69, 60,17916,17920},
    { 69, 61,17920,17924},
    { 69, 62,17924,17928},
    { 69, 63,17928,17932},
    { 69, 64,17932,17936},
    { 69, 65,17936,17940},
    { 69, 66,17940,17944},
    { 69, 67,17944,17948},
    { 69, 68,17948,17952},
    { 69, 69,17952,17955},
    { 70,  1,17955,17959},
    { 70,  2,17959,17961},
    { 70,  3,17961,17965},
    { 70,  4,17965,17971},
    { 70,  5,17971,17981},
    { 70,  6,17981,17991},
    { 70,  7,17991,17999},
    { 70,  8,17999,18005},
    { 70,  9,18005,18009},
    { 70, 10,18009,18011},
    { 70, 11,18011,18015},
    { 70, 12,18015,18021},
    { 70, 13,18021,18029},
    { 70, 14,18029,18039},
    { 70, 15,18039,18047},
    { 70, 16,18047,18053},
    { 70, 17,18053,18057},
    { 70, 18,18057,18059},
    { 70, 19,18059,18063},
    { 70, 20,18063,18069},
    { 70, 21,18069,18075},
    { 70, 22,18075,18081},
    { 70, 23,18081,18087},
    { 70, 24,18087,18093},
    { 70, 25,18093,18099},
    { 70, 26,18099,18105},
    { 70, 27,18105,18113},
    { 70, 28,18113,18121},
    { 70, 29,18121,18125},
    { 70, 30,18125,18129},
    { 70, 31,18129,18137},
    { 70, 32,18137,18147},
    { 70, 33,18147,18155},
    { 70, 34,18155,18161},
    { 70, 35,18161,18165},
    { 70, 36,18165,18167},
    { 70, 37,18167,18171},
    { 70, 38,18171,18177},
    { 70, 39,18177,18183},
    { 70, 40,18183,18189},
    { 70, 41,18189,18195},
    { 70, 42,18195,18201},
    { 70, 43,18201,18207},
    { 70, 44,18207,18213},
    { 70, 45,18213,18219},
    { 70, 46,18219,18225},
    { 70, 47,18225,18229},
    { 70, 48,18229,18233},
    { 70, 49,18233,18241},
    { 70, 50,18241,18251},
    { 70, 51,18251,18259},
    { 70, 52,18259,18265},
    { 70, 53,18265,18269},
    { 70, 54,18269,18271},
    { 70, 55,18271,18275},
    { 70, 56,18275,18281},
    { 70, 57,18281,18287},
    { 70, 58,18287,18289},
    { 70, 59,18289,18293},
    { 70, 60,18293,18297},
    { 70, 61,18297,18301},
    { 70, 62,18301,18305},
    { 70, 63,18305,18309},
    { 70, 64,18309,18313},
    { 70, 65,18313,18317},
    { 70, 66,18317,18321},
    { 70, 67,18321,18325},
    { 70, 68,18325,18329},
    { 70, 69,18329,18333},
    { 70, 70,18333,18336},
    { 71,  1,18336,18340},
    { 71,  2,18340,18342},
    { 71,  3,18342,18346},
    { 71,  4,18346,18352},
    { 71,  5,18352,18362},
    { 71,  6,18362,18372},
    { 71,  7,18372,18380},
    { 71,  8,18380,18386},
    { 71,  9,18386,18390},
    { 71, 10,18390,18392},
    { 71, 11,18392,18396},
    { 71, 12,18396,18402},
    { 71, 13,18402,18410},
    { 71, 14,18410,18420},
    { 71, 15,18420,18428},
    { 71, 16,18428,18434},
    { 71, 17,18434,18438},
    { 71, 18,18438,18440},
    { 71, 19,18440,18444},
    { 71, 20,18444,18450},
    { 71, 21,18450,18456},
    { 71, 22,18456,18462},
    { 71, 23,18462,18468},
    { 71, 24,18468,18474},
    { 71, 25,18474,18480},
    { 71, 26,18480,18486},
    { 71, 27,18486,18494},
    { 71, 28,18494,18502},
    { 71, 29,18502,18506},
    { 71, 30,18506,18510},
    { 71, 31,18510,18518},
    { 71, 32,18518,18528},
    { 71, 33,18528,18536},
    { 71, 34,18536,18542},
    { 71, 35,18542,18546},
    { 71, 36,18546,18548},
    { 71, 37,18548,18552},
    { 71, 38,18552,18558},
    { 71, 39,18558,18564},
    { 71, 40,18564,18570},
    { 71, 41,18570,18576},
    { 71, 42,18576,18582},
    { 71, 43,18582,18588},
    { 71, 44,18588,18594},
    { 71, 45,18594,18600},
    { 71, 46,18600,18606},
    { 71, 47,18606,18610},
    { 71, 48,18610,18614},
    { 71, 49,18614,18622},
    { 71, 50,18622,18632},
    { 71, 51,18632,18640},
    { 71, 52,18640,18646},
    { 71, 53,18646,18650},
    { 71, 54,18650,18652},
    { 71, 55,18652,18656},
    { 71, 56,18656,18662},
    { 71, 57,18662,18668},
    { 71, 58,18668,18670},
    { 71, 59,18670,18674},
    { 71, 60,18674,18678},
    { 71, 61,18678,18682},
    { 71, 62,18682,18686},
    { 71, 63,18686,18690},
    { 71, 64,18690,18694},
    { 71, 65,18694,18698},
    { 71, 66,18698,18702},
    { 71, 67,18702,18706},
    { 71, 68,18706,18710},
    { 71, 69,18710,18714},
    { 71, 70,18714,18718},
    { 71, 71,18718,18721},
    { 72,  1,18721,18727},
    { 72,  2,18727,18730},
    { 72,  3,18730,18736},
    { 72,  4,18736,18745},
    { 72,  5,18745,18760},
    { 72,  6,18760,18775},
    { 72,  7,18775,18787},
    { 72,  8,18787,18796},
    { 72,  9,18796,18802},
    { 72, 10,18802,18805},
    { 72, 11,18805,18811},
    { 72, 12,18811,18820},
    { 72, 13,18820,18832},
    { 72, 14,18832,18847},
    { 72, 15,18847,18859},
    { 72, 16,18859,18868},
    { 72, 17,18868,18874},
    { 72, 18,18874,18877},
    { 72, 19,18877,18883},
    { 72, 20,18883,18892},
    { 72, 21,18892,18901},
    { 72, 22,18901,18910},
    { 72, 23,18910,18919},
    { 72, 24,18919,18928},
    { 72, 25,18928,18937},
    { 72, 26,18937,18946},
    { 72, 27,18946,18958},
    { 72, 28,18958,18970},
    { 72, 29,18970,18976},
    { 72, 30,18976,18982},
    { 72, 31,18982,18994},
    { 72, 32,18994,19009},
    { 72, 33,19009,19021},
    { 72, 34,19021,19030},
    { 72, 35,19030,19036},
    { 72, 36,19036,19039},
    { 72, 37,19039,19045},
    { 72, 38,19045,19054},
    { 72, 39,19054,19063},
    { 72, 40,19063,19072},
    { 72, 41,19072,19081},
    { 72, 42,19081,19090},
    { 72, 43,19090,19099},
    { 72, 44,19099,19108},
    { 72, 45,19108,19117},
    { 72, 46,19117,19126},
    { 72, 47,19126,19132},
    { 72, 48,19132,19138},
    { 72, 49,19138,19150},
    { 72, 50,19150,19165},
    { 72, 51,19165,19177},
    { 72, 52,19177,19186},
    { 72, 53,19186,19192},
    { 72, 54,19192,19195},
    { 72, 55,19195,19201},
    { 72, 56,19201,19210},
    { 72, 57,19210,19219},
    { 72, 58,19219,19222},
    { 72, 59,19222,19228},
    { 72, 60,19228,19234},
    { 72, 61,19234,19240},
    { 72, 62,19240,19246},
    { 72, 63,19246,19252},
    { 72, 64,19252,19258},
    { 72, 65,19258,19264},
    { 72, 66,19264,19270},
    { 72, 67,19270,19276},
    { 72, 68,19276,19282},
    { 72, 69,19282,19288},
    { 72, 70,19288,19294},
    { 72, 71,19294,19300},
    { 72, 72,19300,19306},
    { 73,  1,19306,19312},
    { 73,  2,19312,19315},
    { 73,  3,19315,19321},
    { 73,  4,19321,19330},
    { 73,  5,19330,19345},
    { 73,  6,19345,19360},
    { 73,  7,19360,19372},
    { 73,  8,19372,19381},
    { 73,  9,19381,19387},
    { 73, 10,19387,19390},
    { 73, 11,19390,19396},
    { 73, 12,19396,19405},
    { 73, 13,19405,19417},
    { 73, 14,19417,19432},
    { 73, 15,19432,19444},
    { 73, 16,19444,19453},
    { 73, 17,19453,19459},
    { 73, 18,19459,19462},
    { 73, 19,19462,19468},
    { 73, 20,19468,19477},
    { 73, 21,19477,19486},
    { 73, 22,19486,19495},
    { 73, 23,19495,19504},
    { 73, 24,19504,19513},
    { 73, 25,19513,19522},
    { 73, 26,19522,19531},
    { 73, 27,19531,19543},
    { 73, 28,19543,19555},
    { 73, 29,19555,19561},
    { 73, 30,19561,19567},
    { 73, 31,19567,19579},
    { 73, 32,19579,19594},
    { 73, 33,19594,19606},
    { 73, 34,19606,19615},
    { 73, 35,19615,19621},
    { 73, 36,19621,19624},
    { 73, 37,19624,19630},
    { 73, 38,19630,19639},
    { 73, 39,19639,19648},
    { 73, 40,19648,19657},
    { 73, 41,19657,19666},
    { 73, 42,19666,19675},
    { 73, 43,19675,19684},
    { 73, 44,19684,19693},
    { 73, 45,19693,19702},
    { 73, 46,19702,19711},
    { 73, 47,19711,19717},
    { 73, 48,19717,19723},
    { 73, 49,19723,19735},
    { 73, 50,19735,19750},
    { 73, 51,19750,19762},
    { 73, 52,19762,19771},
    { 73, 53,19771,19777},
    { 73, 54,19777,19780},
    { 73, 55,19780,19786},
    { 73, 56,19786,19795},
    { 73, 57,19795,19804},
    { 73, 58,19804,19807},
    { 73, 59,19807,19813},
    { 73, 60,19813,19819},
    { 73, 61,19819,19825},
    { 73, 62,19825,19831},
    { 73, 63,19831,19837},
    { 73, 64,19837,19843},
    { 73, 65,19843,19849},
    { 73, 66,19849,19855},
    { 73, 67,19855,19861},
    { 73, 68,19861,19867},
    { 73, 69,19867,19873},
    { 73, 70,19873,19879},
    { 73, 71,19879,19885},
    { 73, 72,19885,19894},
    { 73, 73,19894,19900},
    { 74,  1,19900,19906},
    { 74,  2,19906,19909},
    { 74,  3,19909,19915},
    { 74,  4,19915,19924},
    { 74,  5,19924,19939},
    { 74,  6,19939,19954},
    { 74,  7,19954,19966},
    { 74,  8,19966,19975},
    { 74,  9,19975,19981},
    { 74, 10,19981,19984},
    { 74, 11,19984,19990},
    { 74, 12,19990,19999},
    { 74, 13,19999,20011},
    { 74, 14,20011,20026},
    { 74, 15,20026,20038},
    { 74, 16,20038,20047},
    { 74, 17,20047,20053},
    { 74, 18,20053,20056},
    { 74, 19,20056,20062},
    { 74, 20,20062,20071},
    { 74, 21,20071,20080},
    { 74, 22,20080,20089},
    { 74, 23,20089,20098},
    { 74, 24,20098,20107},
    { 74, 25,20107,20116},
    { 74, 26,20116,20125},
    { 74, 27,20125,20137},
    { 74, 28,20137,20149},
    { 74, 29,20149,20155},
    { 74, 30,20155,20161},
    { 74, 31,20161,20173},
    { 74, 32,20173,20188},
    { 74, 33,20188,20200},
    { 74, 34,20200,20209},
    { 74, 35,20209,20215},
    { 74, 36,20215,20218},
    { 74, 37,20218,20224},
    { 74, 38,20224,20233},
    { 74, 39,20233,20242},
    { 74, 40,20242,20251},
    { 74, 41,20251,20260},
    { 74, 42,20260,20269},
    { 74, 43,20269,20278},
    { 74, 44,20278,20287},
    { 74, 45,20287,20296},
    { 74, 46,20296,20305},
    { 74, 47,20305,20311},
    { 74, 48,20311,20317},
    { 74, 49,20317,20329},
    { 74, 50,20329,20344},
    { 74, 51,20344,20356},
    { 74, 52,20356,20365},
    { 74, 53,20365,20371},
    { 74, 54,20371,20374},
    { 74, 55,20374,20380},
    { 74, 56,20380,20389},
    { 74, 57,20389,20398},
    { 74, 58,20398,20401},
    { 74, 59,20401,20407},
    { 74, 60,20407,20413},
    { 74, 61,20413,20419},
    { 74, 62,20419,20425},
    { 74, 63,20425,20431},
    { 74, 64,20431,20437},
    { 74, 65,20437,20443},
    { 74, 66,20443,20449},
    { 74, 67,20449,20455},
    { 74, 68,20455,20461},
    { 74, 69,20461,20467},
    { 74, 70,20467,20473},
    { 74, 71,20473,20479},
    { 74, 72,20479,20488},
    { 74, 73,20488,20497},
    { 74, 74,20497,20503},
    { 75,  1,20503,20509},
    { 75,  2,20509,20512},
    { 75,  3,20512,20518},
    { 75,  4,20518,20527},
    { 75,  5,20527,20542},
    { 75,  6,20542,20557},
    { 75,  7,20557,20569},
    { 75,  8,20569,20578},
    { 75,  9,20578,20584},
    { 75, 10,20584,20587},
    { 75, 11,20587,20593},
    { 75, 12,20593,20602},
    { 75, 13,20602,20614},
    { 75, 14,20614,20629},
    { 75, 15,20629,20641},
    { 75, 16,20641,20650},
    { 75, 17,20650,20656},
    { 75, 18,20656,20659},
    { 75, 19,20659,20665},
    { 75, 20,20665,20674},
    { 75, 21,20674,20683},
    { 75, 22,20683,20692},
    { 75, 23,20692,20701},
    { 75, 24,20701,20710},
    { 75, 25,20710,20719},
    { 75, 26,20719,20728},
    { 75, 27,20728,20740},
    { 75, 28,20740,20752},
    { 75, 29,20752,20758},
    { 75, 30,20758,20764},
    { 75, 31,20764,20776},
    { 75, 32,20776,20791},
    { 75, 33,20791,20803},
    { 75, 34,20803,20812},
    { 75, 35,20812,20818},
    { 75, 36,20818,20821},
    { 75, 37,20821,20827},
    { 75, 38,20827,20836},
    { 75, 39,20836,20845},
    { 75, 40,20845,20854},
    { 75, 41,20854,20863},
    { 75, 42,20863,20872},
    { 75, 43,20872,20881},
    { 75, 44,20881,20890},
    { 75, 45,20890,20899},
    { 75, 46,20899,20908},
    { 75, 47,20908,20914},
    { 75, 48,20914,20920},
    { 75, 49,20920,20932},
    { 75, 50,20932,20947},
    { 75, 51,20947,20959},
    { 75, 52,20959,20968},
    { 75, 53,20968,20974},
    { 75, 54,20974,20977},
    { 75, 55,20977,20983},
    { 75, 56,20983,20992},
    { 75, 57,20992,21001},
    { 75, 58,21001,21004},
    { 75, 59,21004,21010},
    { 75, 60,21010,21016},
    { 75, 61,21016,21022},
    { 75, 62,21022,21028},
    { 75, 63,21028,21034},
    { 75, 64,21034,21040},
    { 75, 65,21040,21046},
    { 75, 66,21046,21052},
    { 75, 67,21052,21058},
    { 75, 68,21058,21064},
    { 75, 69,21064,21070},
    { 75, 70,21070,21076},
    { 75, 71,21076,21082},
    { 75, 72,21082,21091},
    { 75, 73,21091,21100},
    { 75, 74,21100,21109},
    { 75, 75,21109,21115},
    { 76,  1,21115,21121},
    { 76,  2,21121,21124},
    { 76,  3,21124,21130},
    { 76,  4,21130,21139},
    { 76,  5,21139,21154},
    { 76,  6,21154,21169},
    { 76,  7,21169,21181},
    { 76,  8,21181,21190},
    { 76,  9,21190,21196},
    { 76, 10,21196,21199},
    { 76, 11,21199,21205},
    { 76, 12,21205,21214},
    { 76, 13,21214,21226},
    { 76, 14,21226,21241},
    { 76, 15,21241,21253},
    { 76, 16,21253,21262},
    { 76, 17,21262,21268},
    { 76, 18,21268,21271},
    { 76, 19,21271,21277},
    { 76, 20,21277,21286},
    { 76, 21,21286,21295},
    { 76, 22,21295,21304},
    { 76, 23,21304,21313},
    { 76, 24,21313,21322},
    { 76, 25,21322,21331},
    { 76, 26,21331,21340},
    { 76, 27,21340,21352},
    { 76, 28,21352,21364},
    { 76, 29,21364,21370},
    { 76, 30,21370,21376},
    { 76, 31,21376,21388},
    { 76, 32,21388,21403},
    { 76, 33,21403,21415},
    { 76, 34,21415,21424},
    { 76, 35,21424,21430},
    { 76, 36,21430,21433},
    { 76, 37,21433,21439},
    { 76, 38,21439,21448},
    { 76, 39,21448,21457},
    { 76, 40,21457,21466},
    { 76, 41,21466,21475},
    { 76, 42,21475,21484},
    { 76, 43,21484,21493},
    { 76, 44,21493,21502},
    { 76, 45,21502,21511},
    { 76, 46,21511,21520},
    { 76, 47,21520,21526},
    { 76, 48,21526,21532},
    { 76, 49,21532,21544},
    { 76, 50,21544,21559},
    { 76, 51,21559,21571},
    { 76, 52,21571,21580},
    { 76, 53,21580,21586},
    { 76, 54,21586,21589},
    { 76, 55,21589,21595},
    { 76, 56,21595,21604},
    { 76, 57,21604,21613},
    { 76, 58,21613,21616},
    { 76, 59,21616,21622},
    { 76, 60,21622,21628},
    { 76, 61,21628,21634},
    { 76, 62,21634,21640},
    { 76, 63,21640,21646},
    { 76, 64,21646,21652},
    { 76, 65,21652,21658},
    { 76, 66,21658,21664},
    { 76, 67,21664,21670},
    { 76, 68,21670,21676},
    { 76, 69,21676,21682},
    { 76, 70,21682,21688},
    { 76, 71,21688,21694},
    { 76, 72,21694,21703},
    { 76, 73,21703,21712},
    { 76, 74,21712,21721},
    { 76, 75,21721,21730},
    { 76, 76,21730,21736},
    { 77,  1,21736,21742},
    { 77,  2,21742,21745},
    { 77,  3,21745,21751},
    { 77,  4,21751,21760},
    { 77,  5,21760,21775},
    { 77,  6,21775,21790},
    { 77,  7,21790,21802},
    { 77,  8,21802,21811},
    { 77,  9,21811,21817},
    { 77, 10,21817,21820},
    { 77, 11,21820,21826},
    { 77, 12,21826,21835},
    { 77, 13,21835,21847},
    { 77, 14,21847,21862},
    { 77, 15,21862,21874},
    { 77, 16,21874,21883},
    { 77, 17,21883,21889},
    { 77, 18,21889,21892},
    { 77, 19,21892,21898},
    { 77, 20,21898,21907},
    { 77, 21,21907,21916},
    { 77, 22,21916,21925},
    { 77, 23,21925,21934},
    { 77, 24,21934,21943},
    { 77, 25,21943,21952},
    { 77, 26,21952,21961},
    { 77, 27,21961,21973},
    { 77, 28,21973,21985},
    { 77, 29,21985,21991},
    { 77, 30,21991,21997},
    { 77, 31,21997,22009},
    { 77, 32,22009,22024},
    { 77, 33,22024,22036},
    { 77, 34,22036,22045},
    { 77, 35,22045,22051},
    { 77, 36,22051,22054},
    { 77, 37,22054,22060},
    { 77, 38,22060,22069},
    { 77, 39,22069,22078},
    { 77, 40,22078,22087},
    { 77, 41,22087,22096},
    { 77, 42,22096,22105},
    { 77, 43,22105,22114},
    { 77, 44,22114,22123},
    { 77, 45,22123,22132},
    { 77, 46,22132,22141},
    { 77, 47,22141,22147},
    { 77, 48,22147,22153},
    { 77, 49,22153,22165},
    { 77, 50,22165,22180},
    { 77, 51,22180,22192},
    { 77, 52,22192,22201},
    { 77, 53,22201,22207},
    { 77, 54,22207,22210},
    { 77, 55,22210,22216},
    { 77, 56,22216,22225},
    { 77, 57,22225,22234},
    { 77, 58,22234,22237},
    { 77, 59,22237,22243},
    { 77, 60,22243,22249},
    { 77, 61,22249,22255},
    { 77, 62,22255,22261},
    { 77, 63,22261,22267},
    { 77, 64,22267,22273},
    { 77, 65,22273,22279},
    { 77, 66,22279,22285},
    { 77, 67,22285,22291},
    { 77, 68,22291,22297},
    { 77, 69,22297,22303},
    { 77, 70,22303,22309},
    { 77, 71,22309,22315},
    { 77, 72,22315,22324},
    { 77, 73,22324,22333},
    { 77, 74,22333,22342},
    { 77, 75,22342,22351},
    { 77, 76,22351,22360},
    { 77, 77,22360,22366},
    { 78,  1,22366,22372},
    { 78,  2,22372,22375},
    { 78,  3,22375,22381},
    { 78,  4,22381,22390},
    { 78,  5,22390,22405},
    { 78,  6,22405,22420},
    { 78,  7,22420,22432},
    { 78,  8,22432,22441},
    { 78,  9,22441,22447},
    { 78, 10,22447,22450},
    { 78, 11,22450,22456},
    { 78, 12,22456,22465},
    { 78, 13,22465,22477},
    { 78, 14,22477,22492},
    { 78, 15,22492,22504},
    { 78, 16,22504,22513},
    { 78, 17,22513,22519},
    { 78, 18,22519,22522},
    { 78, 19,22522,22528},
    { 78, 20,22528,22537},
    { 78, 21,22537,22546},
    { 78, 22,22546,22555},
    { 78, 23,22555,22564},
    { 78, 24,22564,22573},
    { 78, 25,22573,22582},
    { 78, 26,22582,22591},
    { 78, 27,22591,22603},
    { 78, 28,22603,22615},
    { 78, 29,22615,22621},
    { 78, 30,22621,22627},
    { 78, 31,22627,22639},
    { 78, 32,22639,22654},
    { 78, 33,22654,22666},
    { 78, 34,22666,22675},
    { 78, 35,22675,22681},
    { 78, 36,22681,22684},
    { 78, 37,22684,22690},
    { 78, 38,22690,22699},
    { 78, 39,22699,22708},
    { 78, 40,22708,22717},
    { 78, 41,22717,22726},
    { 78, 42,22726,22735},
    { 78, 43,22735,22744},
    { 78, 44,22744,22753},
    { 78, 45,22753,22762},
    { 78, 46,22762,22771},
    { 78, 47,22771,22777},
    { 78, 48,22777,22783},
    { 78, 49,22783,22795},
    { 78, 50,22795,22810},
    { 78, 51,22810,22822},
    { 78, 52,22822,22831},
    { 78, 53,22831,22837},
    { 78, 54,22837,22840},
    { 78, 55,22840,22846},
    { 78, 56,22846,22855},
    { 78, 57,22855,22864},
    { 78, 58,22864,22867},
    { 78, 59,22867,22873},
    { 78, 60,22873,22879},
    { 78, 61,22879,22885},
    { 78, 62,22885,22891},
    { 78, 63,22891,22897},
    { 78, 64,22897,22903},
    { 78, 65,22903,22909},
    { 78, 66,22909,22915},
    { 78, 67,22915,22921},
    { 78, 68,22921,22927},
    { 78, 69,22927,22933},
    { 78, 70,22933,22939},
    { 78, 71,22939,22945},
    { 78, 72,22945,22954},
    { 78, 73,22954,22963},
    { 78, 74,22963,22972},
    { 78, 75,22972,22981},
    { 78, 76,22981,22990},
    { 78, 77,22990,22999},
    { 78, 78,22999,23005},
    { 79,  1,23005,23009},
    { 79,  2,23009,23011},
    { 79,  3,23011,23015},
    { 79,  4,23015,23021},
    { 79,  5,23021,23031},
    { 79,  6,23031,23041},
    { 79,  7,23041,23049},
    { 79,  8,23049,23055},
    { 79,  9,23055,23059},
    { 79, 10,23059,23061},
    { 79, 11,23061,23065},
    { 79, 12,23065,23071},
    { 79, 13,23071,23079},
    { 79, 14,23079,23089},
    { 79, 15,23089,23097},
    { 79, 16,23097,23103},
    { 79, 17,23103,23107},
    { 79, 18,23107,23109},
    { 79, 19,23109,23113},
    { 79, 20,23113,23119},
    { 79, 21,23119,23125},
    { 79, 22,23125,23131},
    { 79, 23,23131,23137},
    { 79, 24,23137,23143},
    { 79, 25,23143,23149},
    { 79, 26,23149,23155},
    { 79, 27,23155,23163},
    { 79, 28,23163,23171},
    { 79, 29,23171,23175},
    { 79, 30,23175,23179},
    { 79, 31,23179,23187},
    { 79, 32,23187,23197},
    { 79, 33,23197,23205},
    { 79, 34,23205,23211},
    { 79, 35,23211,23215},
    { 79, 36,23215,23217},
    { 79, 37,23217,23221},
    { 79, 38,23221,23227},
    { 79, 39,23227,23233},
    { 79, 40,23233,23239},
    { 79, 41,23239,23245},
    { 79, 42,23245,23251},
    { 79, 43,23251,23257},
    { 79, 44,23257,23263},
    { 79, 45,23263,23269},
    { 79, 46,23269,23275},
    { 79, 47,23275,23279},
    { 79, 48,23279,23283},
    { 79, 49,23283,23291},
    { 79, 50,23291,23301},
    { 79, 51,23301,23309},
    { 79, 52,23309,23315},
    { 79, 53,23315,23319},
    { 79, 54,23319,23321},
    { 79, 55,23321,23325},
    { 79, 56,23325,23331},
    { 79, 57,23331,23337},
    { 79, 58,23337,23339},
    { 79, 59,23339,23343},
    { 79, 60,23343,23347},
    { 79, 61,23347,23351},
    { 79, 62,23351,23355},
    { 79, 63,23355,23359},
    { 79, 64,23359,23363},
    { 79, 65,23363,23367},
    { 79, 66,23367,23371},
    { 79, 67,23371,23375},
    { 79, 68,23375,23379},
    { 79, 69,23379,23383},
    { 79, 70,23383,23387},
    { 79, 71,23387,23391},
    { 79, 72,23391,23397},
    { 79, 73,23397,23403},
    { 79, 74,23403,23409},
    { 79, 75,23409,23415},
    { 79, 76,23415,23421},
    { 79, 77,23421,23427},
    { 79, 78,23427,23433},
    { 79, 79,23433,23436},
    { 80,  1,23436,23440},
    { 80,  2,23440,23442},
    { 80,  3,23442,23446},
    { 80,  4,23446,23452},
    { 80,  5,23452,23462},
    { 80,  6,23462,23472},
    { 80,  7,23472,23480},
    { 80,  8,23480,23486},
    { 80,  9,23486,23490},
    { 80, 10,23490,23492},
    { 80, 11,23492,23496},
    { 80, 12,23496,23502},
    { 80, 13,23502,23510},
    { 80, 14,23510,23520},
    { 80, 15,23520,23528},
    { 80, 16,23528,23534},
    { 80, 17,23534,23538},
    { 80, 18,23538,23540},
    { 80, 19,23540,23544},
    { 80, 20,23544,23550},
    { 80, 21,23550,23556},
    { 80, 22,23556,23562},
    { 80, 23,23562,23568},
    { 80, 24,23568,23574},
    { 80, 25,23574,23580},
    { 80, 26,23580,23586},
    { 80, 27,23586,23594},
    { 80, 28,23594,23602},
    { 80, 29,23602,23606},
    { 80, 30,23606,23610},
    { 80, 31,23610,23618},
    { 80, 32,23618,23628},
    { 80, 33,23628,23636},
    { 80, 34,23636,23642},
    { 80, 35,23642,23646},
    { 80, 36,23646,23648},
    { 80, 37,23648,23652},
    { 80, 38,23652,23658},
    { 80, 39,23658,23664},
    { 80, 40,23664,23670},
    { 80, 41,23670,23676},
    { 80, 42,23676,23682},
    { 80, 43,23682,23688},
    { 80, 44,23688,23694},
    { 80, 45,23694,23700},
    { 80, 46,23700,23706},
    { 80, 47,23706,23710},
    { 80, 48,23710,23714},
    { 80, 49,23714,23722},
    { 80, 50,23722,23732},
    { 80, 51,23732,23740},
    { 80, 52,23740,23746},
    { 80, 53,23746,23750},
    { 80, 54,23750,23752},
    { 80, 55,23752,23756},
    { 80, 56,23756,23762},
    { 80, 57,23762,23768},
    { 80, 58,23768,23770},
    { 80, 59,23770,23774},
    { 80, 60,23774,23778},
    { 80, 61,23778,23782},
    { 80, 62,23782,23786},
    { 80, 63,23786,23790},
    { 80, 64,23790,23794},
    { 80, 65,23794,23798},
    { 80, 66,23798,23802},
    { 80, 67,23802,23806},
    { 80, 68,23806,23810},
    { 80, 69,23810,23814},
    { 80, 70,23814,23818},
    { 80, 71,23818,23822},
    { 80, 72,23822,23828},
    { 80, 73,23828,23834},
    { 80, 74,23834,23840},
    { 80, 75,23840,23846},
    { 80, 76,23846,23852},
    { 80, 77,23852,23858},
    { 80, 78,23858,23864},
    { 80, 79,23864,23868},
    { 80, 80,23868,23871},
    { 81,  1,23871,23879},
    { 81,  2,23879,23883},
    { 81,  3,23883,23891},
    { 81,  4,23891,23903},
    { 81,  5,23903,23923},
    { 81,  6,23923,23943},
    { 81,  7,23943,23959},
    { 81,  8,23959,23971},
    { 81,  9,23971,23979},
    { 81, 10,23979,23983},
    { 81, 11,23983,23991},
    { 81, 12,23991,24003},
    { 81, 13,24003,24019},
    { 81, 14,24019,24039},
    { 81, 15,24039,24055},
    { 81, 16,24055,24067},
    { 81, 17,24067,24075},
    { 81, 18,24075,24079},
    { 81, 19,24079,24087},
    { 81, 20,24087,24099},
    { 81, 21,24099,24111},
    { 81, 22,24111,24123},
    { 81, 23,24123,24135},
    { 81, 24,24135,24147},
    { 81, 25,24147,24159},
    { 81, 26,24159,24171},
    { 81, 27,24171,24187},
    { 81, 28,24187,24203},
    { 81, 29,24203,24211},
    { 81, 30,24211,24219},
    { 81, 31,24219,24235},
    { 81, 32,24235,24255},
    { 81, 33,24255,24271},
    { 81, 34,24271,24283},
    { 81, 35,24283,24291},
    { 81, 36,24291,24295},
    { 81, 37,24295,24303},
    { 81, 38,24303,24315},
    { 81, 39,24315,24327},
    { 81, 40,24327,24339},
    { 81, 41,24339,24351},
    { 81, 42,24351,24363},
    { 81, 43,24363,24375},
    { 81, 44,24375,24387},
    { 81, 45,24387,24399},
    { 81, 46,24399,24411},
    { 81, 47,24411,24419},
    { 81, 48,24419,24427},
    { 81, 49,24427,24443},
    { 81, 50,24443,24463},
    { 81, 51,24463,24479},
    { 81, 52,24479,24491},
    { 81, 53,24491,24499},
    { 81, 54,24499,24503},
    { 81, 55,24503,24511},
    { 81, 56,24511,24523},
    { 81, 57,24523,24535},
    { 81, 58,24535,24539},
    { 81, 59,24539,24547},
    { 81, 60,24547,24555},
    { 81, 61,24555,24563},
    { 81, 62,24563,24571},
    { 81, 63,24571,24579},
    { 81, 64,24579,24587},
    { 81, 65,24587,24595},
    { 81, 66,24595,24603},
    { 81, 67,24603,24611},
    { 81, 68,24611,24619},
    { 81, 69,24619,24627},
    { 81, 70,24627,24635},
    { 81, 71,24635,24643},
    { 81, 72,24643,24655},
    { 81, 73,24655,24667},
    { 81, 74,24667,24679},
    { 81, 75,24679,24691},
    { 81, 76,24691,24703},
    { 81, 77,24703,24715},
    { 81, 78,24715,24727},
    { 81, 79,24727,24735},
    { 81, 80,24735,24743},
    { 81, 81,24743,24753},
    { 82,  1,24753,24763},
    { 82,  2,24763,24768},
    { 82,  3,24768,24778},
    { 82,  4,24778,24793},
    { 82,  5,24793,24818},
    { 82,  6,24818,24843},
    { 82,  7,24843,24863},
    { 82,  8,24863,24878},
    { 82,  9,24878,24888},
    { 82, 10,24888,24893},
    { 82, 11,24893,24903},
    { 82, 12,24903,24918},
    { 82, 13,24918,24938},
    { 82, 14,24938,24963},
    { 82, 15,24963,24983},
    { 82, 16,24983,24998},
    { 82, 17,24998,25008},
    { 82, 18,25008,25013},
    { 82, 19,25013,25023},
    { 82, 20,25023,25038},
    { 82, 21,25038,25053},
    { 82, 22,25053,25068},
    { 82, 23,25068,25083},
    { 82, 24,25083,25098},
    { 82, 25,25098,25113},
    { 82, 26,25113,25128},
    { 82, 27,25128,25148},
    { 82, 28,25148,25168},
    { 82, 29,25168,25178},
    { 82, 30,25178,25188},
    { 82, 31,25188,25208},
    { 82, 32,25208,25233},
    { 82, 33,25233,25253},
    { 82, 34,25253,25268},
    { 82, 35,25268,25278},
    { 82, 36,25278,25283},
    { 82, 37,25283,25293},
    { 82, 38,25293,25308},
    { 82, 39,25308,25323},
    { 82, 40,25323,25338},
    { 82, 41,25338,25353},
    { 82, 42,25353,25368},
    { 82, 43,25368,25383},
    { 82, 44,25383,25398},
    { 82, 45,25398,25413},
    { 82, 46,25413,25428},
    { 82, 47,25428,25438},
    { 82, 48,25438,25448},
    { 82, 49,25448,25468},
    { 82, 50,25468,25493},
    { 82, 51,25493,25513},
    { 82, 52,25513,25528},
    { 82, 53,25528,25538},
    { 82, 54,25538,25543},
    { 82, 55,25543,25553},
    { 82, 56,25553,25568},
    { 82, 57,25568,25583},
    { 82, 58,25583,25588},
    { 82, 59,25588,25598},
    { 82, 60,25598,25608},
    { 82, 61,25608,25618},
    { 82, 62,25618,25628},
    { 82, 63,25628,25638},
    { 82, 64,25638,25648},
    { 82, 65,25648,25658},
    { 82, 66,25658,25668},
    { 82, 67,25668,25678},
    { 82, 68,25678,25688},
    { 82, 69,25688,25698},
    { 82, 70,25698,25708},
    { 82, 71,25708,25718},
    { 82, 72,25718,25733},
    { 82, 73,25733,25748},
    { 82, 74,25748,25763},
    { 82, 75,25763,25778},
    { 82, 76,25778,25793},
    { 82, 77,25793,25808},
    { 82, 78,25808,25823},
    { 82, 79,25823,25833},
    { 82, 80,25833,25843},
    { 82, 81,25843,25863},
    { 82, 82,25863,25878},
    { 83,  1,25878,25886},
    { 83,  2,25886,25890},
    { 83,  3,25890,25898},
    { 83,  4,25898,25910},
    { 83,  5,25910,25930},
    { 83,  6,25930,25950},
    { 83,  7,25950,25966},
    { 83,  8,25966,25978},
    { 83,  9,25978,25986},
    { 83, 10,25986,25990},
    { 83, 11,25990,25998},
    { 83, 12,25998,26010},
    { 83, 13,26010,26026},
    { 83, 14,26026,26046},
    { 83, 15,26046,26062},
    { 83, 16,26062,26074},
    { 83, 17,26074,26082},
    { 83, 18,26082,26086},
    { 83, 19,26086,26094},
    { 83, 20,26094,26106},
    { 83, 21,26106,26118},
    { 83, 22,26118,26130},
    { 83, 23,26130,26142},
    { 83, 24,26142,26154},
    { 83, 25,26154,26166},
    { 83, 26,26166,26178},
    { 83, 27,26178,26194},
    { 83, 28,26194,26210},
    { 83, 29,26210,26218},
    { 83, 30,26218,26226},
    { 83, 31,26226,26242},
    { 83, 32,26242,26262},
    { 83, 33,26262,26278},
    { 83, 34,26278,26290},
    { 83, 35,26290,26298},
    { 83, 36,26298,26302},
    { 83, 37,26302,26310},
    { 83, 38,26310,26322},
    { 83, 39,26322,26334},
    { 83, 40,26334,26346},
    { 83, 41,26346,26358},
    { 83, 42,26358,26370},
    { 83, 43,26370,26382},
    { 83, 44,26382,26394},
    { 83, 45,26394,26406},
    { 83, 46,26406,26418},
    { 83, 47,26418,26426},
    { 83, 48,26426,26434},
    { 83, 49,26434,26450},
    { 83, 50,26450,26470},
    { 83, 51,26470,26486},
    { 83, 52,26486,26498},
    { 83, 53,26498,26506},
    { 83, 54,26506,26510},
    { 83, 55,26510,26518},
    { 83, 56,26518,26530},
    { 83, 57,26530,26542},
    { 83, 58,26542,26546},
    { 83, 59,26546,26554},
    { 83, 60,26554,26562},
    { 83, 61,26562,26570},
    { 83, 62,26570,26578},
    { 83, 63,26578,26586},
    { 83, 64,26586,26594},
    { 83, 65,26594,26602},
    { 83, 66,26602,26610},
    { 83, 67,26610,26618},
    { 83, 68,26618,26626},
    { 83, 69,26626,26634},
    { 83, 70,26634,26642},
    { 83, 71,26642,26650},
    { 83, 72,26650,26662},
    { 83, 73,26662,26674},
    { 83, 74,26674,26686},
    { 83, 75,26686,26698},
    { 83, 76,26698,26710},
    { 83, 77,26710,26722},
    { 83, 78,26722,26734},
    { 83, 79,26734,26742},
    { 83, 80,26742,26750},
    { 83, 81,26750,26766},
    { 83, 82,26766,26786},
    { 83, 83,26786,26796},
    { 84,  1,26796,26802},
    { 84,  2,26802,26805},
    { 84,  3,26805,26811},
    { 84,  4,26811,26820},
    { 84,  5,26820,26835},
    { 84,  6,26835,26850},
    { 84,  7,26850,26862},
    { 84,  8,26862,26871},
    { 84,  9,26871,26877},
    { 84, 10,26877,26880},
    { 84, 11,26880,26886},
    { 84, 12,26886,26895},
    { 84, 13,26895,26907},
    { 84, 14,26907,26922},
    { 84, 15,26922,26934},
    { 84, 16,26934,26943},
    { 84, 17,26943,26949},
    { 84, 18,26949,26952},
    { 84, 19,26952,26958},
    { 84, 20,26958,26967},
    { 84, 21,26967,26976},
    { 84, 22,26976,26985},
    { 84, 23,26985,26994},
    { 84, 24,26994,27003},
    { 84, 25,27003,27012},
    { 84, 26,27012,27021},
    { 84, 27,27021,27033},
    { 84, 28,27033,27045},
    { 84, 29,27045,27051},
    { 84, 30,27051,27057},
    { 84, 31,27057,27069},
    { 84, 32,27069,27084},
    { 84, 33,27084,27096},
    { 84, 34,27096,27105},
    { 84, 35,27105,27111},
    { 84, 36,27111,27114},
    { 84, 37,27114,27120},
    { 84, 38,27120,27129},
    { 84, 39,27129,27138},
    { 84, 40,27138,27147},
    { 84, 41,27147,27156},
    { 84, 42,27156,27165},
    { 84, 43,27165,27174},
    { 84, 44,27174,27183},
    { 84, 45,27183,27192},
    { 84, 46,27192,27201},
    { 84, 47,27201,27207},
    { 84, 48,27207,27213},
    { 84, 49,27213,27225},
    { 84, 50,27225,27240},
    { 84, 51,27240,27252},
    { 84, 52,27252,27261},
    { 84, 53,27261,27267},
    { 84, 54,27267,27270},
    { 84, 55,27270,27276},
    { 84, 56,27276,27285},
    { 84, 57,27285,27294},
    { 84, 58,27294,27297},
    { 84, 59,27297,27303},
    { 84, 60,27303,27309},
    { 84, 61,27309,27315},
    { 84, 62,27315,27321},
    { 84, 63,27321,27327},
    { 84, 64,27327,27333},
    { 84, 65,27333,27339},
    { 84, 66,27339,27345},
    { 84, 67,27345,27351},
    { 84, 68,27351,27357},
    { 84, 69,27357,27363},
    { 84, 70,27363,27369},
    { 84, 71,27369,27375},
    { 84, 72,27375,27384},
    { 84, 73,27384,27393},
    { 84, 74,27393,27402},
    { 84, 75,27402,27411},
    { 84, 76,27411,27420},
    { 84, 77,27420,27429},
    { 84, 78,27429,27438},
    { 84, 79,27438,27444},
    { 84, 80,27444,27450},
    { 84, 81,27450,27462},
    { 84, 82,27462,27477},
    { 84, 83,27477,27489},
    { 84, 84,27489,27495},
    { 85,  1,27495,27499},
    { 85,  2,27499,27501},
    { 85,  3,27501,27505},
    { 85,  4,27505,27511},
    { 85,  5,27511,27521},
    { 85,  6,27521,27531},
    { 85,  7,27531,27539},
    { 85,  8,27539,27545},
    { 85,  9,27545,27549},
    { 85, 10,27549,27551},
    { 85, 11,27551,27555},
    { 85, 12,27555,27561},
    { 85, 13,27561,27569},
    { 85, 14,27569,27579},
    { 85, 15,27579,27587},
    { 85, 16,27587,27593},
    { 85, 17,27593,27597},
    { 85, 18,27597,27599},
    { 85, 19,27599,27603},
    { 85, 20,27603,27609},
    { 85, 21,27609,27615},
    { 85, 22,27615,27621},
    { 85, 23,27621,27627},
    { 85, 24,27627,27633},
    { 85, 25,27633,27639},
    { 85, 26,27639,27645},
    { 85, 27,27645,27653},
    { 85, 28,27653,27661},
    { 85, 29,27661,27665},
    { 85, 30,27665,27669},
    { 85, 31,27669,27677},
    { 85, 32,27677,27687},
    { 85, 33,27687,27695},
    { 85, 34,27695,27701},
    { 85, 35,27701,27705},
    { 85, 36,27705,27707},
    { 85, 37,27707,27711},
    { 85, 38,27711,27717},
    { 85, 39,27717,27723},
    { 85, 40,27723,27729},
    { 85, 41,27729,27735},
    { 85, 42,27735,27741},
    { 85, 43,27741,27747},
    { 85, 44,27747,27753},
    { 85, 45,27753,27759},
    { 85, 46,27759,27765},
    { 85, 47,27765,27769},
    { 85, 48,27769,27773},
    { 85, 49,27773,27781},
    { 85, 50,27781,27791},
    { 85, 51,27791,27799},
    { 85, 52,27799,27805},
    { 85, 53,27805,27809},
    { 85, 54,27809,27811},
    { 85, 55,27811,27815},
    { 85, 56,27815,27821},
    { 85, 57,27821,27827},
    { 85, 58,27827,27829},
    { 85, 59,27829,27833},
    { 85, 60,27833,27837},
    { 85, 61,27837,27841},
    { 85, 62,27841,27845},
    { 85, 63,27845,27849},
    { 85, 64,27849,27853},
    { 85, 65,27853,27857},
    { 85, 66,27857,27861},
    { 85, 67,27861,27865},
    { 85, 68,27865,27869},
    { 85, 69,27869,27873},
    { 85, 70,27873,27877},
    { 85, 71,27877,27881},
    { 85, 72,27881,27887},
    { 85, 73,27887,27893},
    { 85, 74,27893,27899},
    { 85, 75,27899,27905},
    { 85, 76,27905,27911},
    { 85, 77,27911,27917},
    { 85, 78,27917,27923},
    { 85, 79,27923,27927},
    { 85, 80,27927,27931},
    { 85, 81,27931,27939},
    { 85, 82,27939,27949},
    { 85, 83,27949,27957},
    { 85, 84,27957,27963},
    { 85, 85,27963,27966},
    { 86,  1,27966,27968},
    { 86,  2,27968,27969},
    { 86,  3,27969,27971},
    { 86,  4,27971,27974},
    { 86,  5,27974,27979},
    { 86,  6,27979,27984},
    { 86,  7,27984,27988},
    { 86,  8,27988,27991},
    { 86,  9,27991,27993},
    { 86, 10,27993,27994},
    { 86, 11,27994,27996},
    { 86, 12,27996,27999},
    { 86, 13,27999,28003},
    { 86, 14,28003,28008},
    { 86, 15,28008,28012},
    { 86, 16,28012,28015},
    { 86, 17,28015,28017},
    { 86, 18,28017,28018},
    { 86, 19,28018,28020},
    { 86, 20,28020,28023},
    { 86, 21,28023,28026},
    { 86, 22,28026,28029},
    { 86, 23,28029,28032},
    { 86, 24,28032,28035},
    { 86, 25,28035,28038},
    { 86, 26,28038,28041},
    { 86, 27,28041,28045},
    { 86, 28,28045,28049},
    { 86, 29,28049,28051},
    { 86, 30,28051,28053},
    { 86, 31,28053,28057},
    { 86, 32,28057,28062},
    { 86, 33,28062,28066},
    { 86, 34,28066,28069},
    { 86, 35,28069,28071},
    { 86, 36,28071,28072},
    { 86, 37,28072,28074},
    { 86, 38,28074,28077},
    { 86, 39,28077,28080},
    { 86, 40,28080,28083},
    { 86, 41,28083,28086},
    { 86, 42,28086,28089},
    { 86, 43,28089,28092},
    { 86, 44,28092,28095},
    { 86, 45,28095,28098},
    { 86, 46,28098,28101},
    { 86, 47,28101,28103},
    { 86, 48,28103,28105},
    { 86, 49,28105,28109},
    { 86, 50,28109,28114},
    { 86, 51,28114,28118},
    { 86, 52,28118,28121},
    { 86, 53,28121,28123},
    { 86, 54,28123,28124},
    { 86, 55,28124,28126},
    { 86, 56,28126,28129},
    { 86, 57,28129,28132},
    { 86, 58,28132,28133},
    { 86, 59,28133,28135},
    { 86, 60,28135,28137},
    { 86, 61,28137,28139},
    { 86, 62,28139,28141},
    { 86, 63,28141,28143},
    { 86, 64,28143,28145},
    { 86, 65,28145,28147},
    { 86, 66,28147,28149},
    { 86, 67,28149,28151},
    { 86, 68,28151,28153},
    { 86, 69,28153,28155},
    { 86, 70,28155,28157},
    { 86, 71,28157,28159},
    { 86, 72,28159,28162},
    { 86, 73,28162,28165},
    { 86, 74,28165,28168},
    { 86, 75,28168,28171},
    { 86, 76,28171,28174},
    { 86, 77,28174,28177},
    { 86, 78,28177,28180},
    { 86, 79,28180,28182},
    { 86, 80,28182,28184},
    { 86, 81,28184,28188},
    { 86, 82,28188,28193},
    { 86, 83,28193,28197},
    { 86, 84,28197,28200},
    { 86, 85,28200,28202},
    { 86, 86,28202,28203},
    { 87,  1,28203,28207},
    { 87,  2,28207,28209},
    { 87,  3,28209,28213},
    { 87,  4,28213,28219},
    { 87,  5,28219,28229},
    { 87,  6,28229,28239},
    { 87,  7,28239,28247},
    { 87,  8,28247,28253},
    { 87,  9,28253,28257},
    { 87, 10,28257,28259},
    { 87, 11,28259,28263},
    { 87, 12,28263,28269},
    { 87, 13,28269,28277},
    { 87, 14,28277,28287},
    { 87, 15,28287,28295},
    { 87, 16,28295,28301},
    { 87, 17,28301,28305},
    { 87, 18,28305,28307},
    { 87, 19,28307,28311},
    { 87, 20,28311,28317},
    { 87, 21,28317,28323},
    { 87, 22,28323,28329},
    { 87, 23,28329,28335},
    { 87, 24,28335,28341},
    { 87, 25,28341,28347},
    { 87, 26,28347,28353},
    { 87, 27,28353,28361},
    { 87, 28,28361,28369},
    { 87, 29,28369,28373},
    { 87, 30,28373,28377},
    { 87, 31,28377,28385},
    { 87, 32,28385,28395},
    { 87, 33,28395,28403},
    { 87, 34,28403,28409},
    { 87, 35,28409,28413},
    { 87, 36,28413,28415},
    { 87, 37,28415,28419},
    { 87, 38,28419,28425},
    { 87, 39,28425,28431},
    { 87, 40,28431,28437},
    { 87, 41,28437,28443},
    { 87, 42,28443,28449},
    { 87, 43,28449,28455},
    { 87, 44,28455,28461},
    { 87, 45,28461,28467},
    { 87, 46,28467,28473},
    { 87, 47,28473,28477},
    { 87, 48,28477,28481},
    { 87, 49,28481,28489},
    { 87, 50,28489,28499},
    { 87, 51,28499,28507},
    { 87, 52,28507,28513},
    { 87, 53,28513,28517},
    { 87, 54,28517,28519},
    { 87, 55,28519,28523},
    { 87, 56,28523,28529},
    { 87, 57,28529,28535},
    { 87, 58,28535,28537},
    { 87, 59,28537,28541},
    { 87, 60,28541,28545},
    { 87, 61,28545,28549},
    { 87, 62,28549,28553},
    { 87, 63,28553,28557},
    { 87, 64,28557,28561},
    { 87, 65,28561,28565},
    { 87, 66,28565,28569},
    { 87, 67,28569,28573},
    { 87, 68,28573,28577},
    { 87, 69,28577,28581},
    { 87, 70,28581,28585},
    { 87, 71,28585,28589},
    { 87, 72,28589,28595},
    { 87, 73,28595,28601},
    { 87, 74,28601,28607},
    { 87, 75,28607,28613},
    { 87, 76,28613,28619},
    { 87, 77,28619,28625},
    { 87, 78,28625,28631},
    { 87, 79,28631,28635},
    { 87, 80,28635,28639},
    { 87, 81,28639,28647},
    { 87, 82,28647,28657},
    { 87, 83,28657,28665},
    { 87, 84,28665,28671},
    { 87, 85,28671,28675},
    { 87, 86,28675,28677},
    { 87, 87,28677,28680},
    { 88,  1,28680,28686},
    { 88,  2,28686,28689},
    { 88,  3,28689,28695},
    { 88,  4,28695,28704},
    { 88,  5,28704,28719},
    { 88,  6,28719,28734},
    { 88,  7,28734,28746},
    { 88,  8,28746,28755},
    { 88,  9,28755,28761},
    { 88, 10,28761,28764},
    { 88, 11,28764,28770},
    { 88, 12,28770,28779},
    { 88, 13,28779,28791},
    { 88, 14,28791,28806},
    { 88, 15,28806,28818},
    { 88, 16,28818,28827},
    { 88, 17,28827,28833},
    { 88, 18,28833,28836},
    { 88, 19,28836,28842},
    { 88, 20,28842,28851},
    { 88, 21,28851,28860},
    { 88, 22,28860,28869},
    { 88, 23,28869,28878},
    { 88, 24,28878,28887},
    { 88, 25,28887,28896},
    { 88, 26,28896,28905},
    { 88, 27,28905,28917},
    { 88, 28,28917,28929},
    { 88, 29,28929,28935},
    { 88, 30,28935,28941},
    { 88, 31,28941,28953},
    { 88, 32,28953,28968},
    { 88, 33,28968,28980},
    { 88, 34,28980,28989},
    { 88, 35,28989,28995},
    { 88, 36,28995,28998},
    { 88, 37,28998,29004},
    { 88, 38,29004,29013},
    { 88, 39,29013,29022},
    { 88, 40,29022,29031},
    { 88, 41,29031,29040},
    { 88, 42,29040,29049},
    { 88, 43,29049,29058},
    { 88, 44,29058,29067},
    { 88, 45,29067,29076},
    { 88, 46,29076,29085},
    { 88, 47,29085,29091},
    { 88, 48,29091,29097},
    { 88, 49,29097,29109},
    { 88, 50,29109,29124},
    { 88, 51,29124,29136},
    { 88, 52,29136,29145},
    { 88, 53,29145,29151},
    { 88, 54,29151,29154},
    { 88, 55,29154,29160},
    { 88, 56,29160,29169},
    { 88, 57,29169,29178},
    { 88, 58,29178,29181},
    { 88, 59,29181,29187},
    { 88, 60,29187,29193},
    { 88, 61,29193,29199},
    { 88, 62,29199,29205},
    { 88, 63,29205,29211},
    { 88, 64,29211,29217},
    { 88, 65,29217,29223},
    { 88, 66,29223,29229},
    { 88, 67,29229,29235},
    { 88, 68,29235,29241},
    { 88, 69,29241,29247},
    { 88, 70,29247,29253},
    { 88, 71,29253,29259},
    { 88, 72,29259,29268},
    { 88, 73,29268,29277},
    { 88, 74,29277,29286},
    { 88, 75,29286,29295},
    { 88, 76,29295,29304},
    { 88, 77,29304,29313},
    { 88, 78,29313,29322},
    { 88, 79,29322,29328},
    { 88, 80,29328,29334},
    { 88, 81,29334,29346},
    { 88, 82,29346,29361},
    { 88, 83,29361,29373},
    { 88, 84,29373,29382},
    { 88, 85,29382,29388},
    { 88, 86,29388,29391},
    { 88, 87,29391,29397},
    { 88, 88,29397,29403},
    { 89,  1,29403,29407},
    { 89,  2,29407,29409},
    { 89,  3,29409,29413},
    { 89,  4,29413,29419},
    { 89,  5,29419,29429},
    { 89,  6,29429,29439},
    { 89,  7,29439,29447},
    { 89,  8,29447,29453},
    { 89,  9,29453,29457},
    { 89, 10,29457,29459},
    { 89, 11,29459,29463},
    { 89, 12,29463,29469},
    { 89, 13,29469,29477},
    { 89, 14,29477,29487},
    { 89, 15,29487,29495},
    { 89, 16,29495,29501},
    { 89, 17,29501,29505},
    { 89, 18,29505,29507},
    { 89, 19,29507,29511},
    { 89, 20,29511,29517},
    { 89, 21,29517,29523},
    { 89, 22,29523,29529},
    { 89, 23,29529,29535},
    { 89, 24,29535,29541},
    { 89, 25,29541,29547},
    { 89, 26,29547,29553},
    { 89, 27,29553,29561},
    { 89, 28,29561,29569},
    { 89, 29,29569,29573},
    { 89, 30,29573,29577},
    { 89, 31,29577,29585},
    { 89, 32,29585,29595},
    { 89, 33,29595,29603},
    { 89, 34,29603,29609},
    { 89, 35,29609,29613},
    { 89, 36,29613,29615},
    { 89, 37,29615,29619},
    { 89, 38,29619,29625},
    { 89, 39,29625,29631},
    { 89, 40,29631,29637},
    { 89, 41,29637,29643},
    { 89, 42,29643,29649},
    { 89, 43,29649,29655},
    { 89, 44,29655,29661},
    { 89, 45,29661,29667},
    { 89, 46,29667,29673},
    { 89, 47,29673,29677},
    { 89, 48,29677,29681},
    { 89, 49,29681,29689},
    { 89, 50,29689,29699},
    { 89, 51,29699,29707},
    { 89, 52,29707,29713},
    { 89, 53,29713,29717},
    { 89, 54,29717,29719},
    { 89, 55,29719,29723},
    { 89, 56,29723,29729},
    { 89, 57,29729,29735},
    { 89, 58,29735,29737},
    { 89, 59,29737,29741},
    { 89, 60,29741,29745},
    { 89, 61,29745,29749},
    { 89, 62,29749,29753},
    { 89, 63,29753,29757},
    { 89, 64,29757,29761},
    { 89, 65,29761,29765},
    { 89, 66,29765,29769},
    { 89, 67,29769,29773},
    { 89, 68,29773,29777},
    { 89, 69,29777,29781},
    { 89, 70,29781,29785},
    { 89, 71,29785,29789},
    { 89, 72,29789,29795},
    { 89, 73,29795,29801},
    { 89, 74,29801,29807},
    { 89, 75,29807,29813},
    { 89, 76,29813,29819},
    { 89, 77,29819,29825},
    { 89, 78,29825,29831},
    { 89, 79,29831,29835},
    { 89, 80,29835,29839},
    { 89, 81,29839,29847},
    { 89, 82,29847,29857},
    { 89, 83,29857,29865},
    { 89, 84,29865,29871},
    { 89, 85,29871,29875},
    { 89, 86,29875,29877},
    { 89, 87,29877,29881},
    { 89, 88,29881,29887},
    { 89, 89,29887,29890},
    { 90,  1,29890,29894},
    { 90,  2,29894,29896},
    { 90,  3,29896,29900},
    { 90,  4,29900,29906},
    { 90,  5,29906,29916},
    { 90,  6,29916,29926},
    { 90,  7,29926,29934},
    { 90,  8,29934,29940},
    { 90,  9,29940,29944},
    { 90, 10,29944,29946},
    { 90, 11,29946,29950},
    { 90, 12,29950,29956},
    { 90, 13,29956,29964},
    { 90, 14,29964,29974},
    { 90, 15,29974,29982},
    { 90, 16,29982,29988},
    { 90, 17,29988,29992},
    { 90, 18,29992,29994},
    { 90, 19,29994,29998},
    { 90, 20,29998,30004},
    { 90, 21,30004,30010},
    { 90, 22,30010,30016},
    { 90, 23,30016,30022},
    { 90, 24,30022,30028},
    { 90, 25,30028,30034},
    { 90, 26,30034,30040},
    { 90, 27,30040,30048},
    { 90, 28,30048,30056},
    { 90, 29,30056,30060},
    { 90, 30,30060,30064},
    { 90, 31,30064,30072},
    { 90, 32,30072,30082},
    { 90, 33,30082,30090},
    { 90, 34,30090,30096},
    { 90, 35,30096,30100},
    { 90, 36,30100,30102},
    { 90, 37,30102,30106},
    { 90, 38,30106,30112},
    { 90, 39,30112,30118},
    { 90, 40,30118,30124},
    { 90, 41,30124,30130},
    { 90, 42,30130,30136},
    { 90, 43,30136,30142},
    { 90, 44,30142,30148},
    { 90, 45,30148,30154},
    { 90, 46,30154,30160},
    { 90, 47,30160,30164},
    { 90, 48,30164,30168},
    { 90, 49,30168,30176},
    { 90, 50,30176,30186},
    { 90, 51,30186,30194},
    { 90, 52,30194,30200},
    { 90, 53,30200,30204},
    { 90, 54,30204,30206},
    { 90, 55,30206,30210},
    { 90, 56,30210,30216},
    { 90, 57,30216,30222},
    { 90, 58,30222,30224},
    { 90, 59,30224,30228},
    { 90, 60,30228,30232},
    { 90, 61,30232,30236},
    { 90, 62,30236,30240},
    { 90, 63,30240,30244},
    { 90, 64,30244,30248},
    { 90, 65,30248,30252},
    { 90, 66,30252,30256},
    { 90, 67,30256,30260},
    { 90, 68,30260,30264},
    { 90, 69,30264,30268},
    { 90, 70,30268,30272},
    { 90, 71,30272,30276},
    { 90, 72,30276,30282},
    { 90, 73,30282,30288},
    { 90, 74,30288,30294},
    { 90, 75,30294,30300},
    { 90, 76,30300,30306},
    { 90, 77,30306,30312},
    { 90, 78,30312,30318},
    { 90, 79,30318,30322},
    { 90, 80,30322,30326},
    { 90, 81,30326,30334},
    { 90, 82,30334,30344},
    { 90, 83,30344,30352},
    { 90, 84,30352,30358},
    { 90, 85,30358,30362},
    { 90, 86,30362,30364},
    { 90, 87,30364,30368},
    { 90, 88,30368,30374},
    { 90, 89,30374,30378},
    { 90, 90,30378,30381},
    { 91,  1,30381,30385},
    { 91,  2,30385,30387},
    { 91,  3,30387,30391},
    { 91,  4,30391,30397},
    { 91,  5,30397,30407},
    { 91,  6,30407,30417},
    { 91,  7,30417,30425},
    { 91,  8,30425,30431},
    { 91,  9,30431,30435},
    { 91, 10,30435,30437},
    { 91, 11,30437,30441},
    { 91, 12,30441,30447},
    { 91, 13,30447,30455},
    { 91, 14,30455,30465},
    { 91, 15,30465,30473},
    { 91, 16,30473,30479},
    { 91, 17,30479,30483},
    { 91, 18,30483,30485},
    { 91, 19,30485,30489},
    { 91, 20,30489,30495},
    { 91, 21,30495,30501},
    { 91, 22,30501,30507},
    { 91, 23,30507,30513},
    { 91, 24,30513,30519},
    { 91, 25,30519,30525},
    { 91, 26,30525,30531},
    { 91, 27,30531,30539},
    { 91, 28,30539,30547},
    { 91, 29,30547,30551},
    { 91, 30,30551,30555},
    { 91, 31,30555,30563},
    { 91, 32,30563,30573},
    { 91, 33,30573,30581},
    { 91, 34,30581,30587},
    { 91, 35,30587,30591},
    { 91, 36,30591,30593},
    { 91, 37,30593,30597},
    { 91, 38,30597,30603},
    { 91, 39,30603,30609},
    { 91, 40,30609,30615},
    { 91, 41,30615,30621},
    { 91, 42,30621,30627},
    { 91, 43,30627,30633},
    { 91, 44,30633,30639},
    { 91, 45,30639,30645},
    { 91, 46,30645,30651},
    { 91, 47,30651,30655},
    { 91, 48,30655,30659},
    { 91, 49,30659,30667},
    { 91, 50,30667,30677},
    { 91, 51,30677,30685},
    { 91, 52,30685,30691},
    { 91, 53,30691,30695},
    { 91, 54,30695,30697},
    { 91, 55,30697,30701},
    { 91, 56,30701,30707},
    { 91, 57,30707,30713},
    { 91, 58,30713,30715},
    { 91, 59,30715,30719},
    { 91, 60,30719,30723},
    { 91, 61,30723,30727},
    { 91, 62,30727,30731},
    { 91, 63,30731,30735},
    { 91, 64,30735,30739},
    { 91, 65,30739,30743},
    { 91, 66,30743,30747},
    { 91, 67,30747,30751},
    { 91, 68,30751,30755},
    { 91, 69,30755,30759},
    { 91, 70,30759,30763},
    { 91, 71,30763,30767},
    { 91, 72,30767,30773},
    { 91, 73,30773,30779},
    { 91, 74,30779,30785},
    { 91, 75,30785,30791},
    { 91, 76,30791,30797},
    { 91, 77,30797,30803},
    { 91, 78,30803,30809},
    { 91, 79,30809,30813},
    { 91, 80,30813,30817},
    { 91, 81,30817,30825},
    { 91, 82,30825,30835},
    { 91, 83,30835,30843},
    { 91, 84,30843,30849},
    { 91, 85,30849,30853},
    { 91, 86,30853,30855},
    { 91, 87,30855,30859},
    { 91, 88,30859,30865},
    { 91, 89,30865,30869},
    { 91, 90,30869,30873},
    { 91, 91,30873,30876},
    { 92,  1,30876,30880},
    { 92,  2,30880,30882},
    { 92,  3,30882,30886},
    { 92,  4,30886,30892},
    { 92,  5,30892,30902},
    { 92,  6,30902,30912},
    { 92,  7,30912,30920},
    { 92,  8,30920,30926},
    { 92,  9,30926,30930},
    { 92, 10,30930,30932},
    { 92, 11,30932,30936},
    { 92, 12,30936,30942},
    { 92, 13,30942,30950},
    { 92, 14,30950,30960},
    { 92, 15,30960,30968},
    { 92, 16,30968,30974},
    { 92, 17,30974,30978},
    { 92, 18,30978,30980},
    { 92, 19,30980,30984},
    { 92, 20,30984,30990},
    { 92, 21,30990,30996},
    { 92, 22,30996,31002},
    { 92, 23,31002,31008},
    { 92, 24,31008,31014},
    { 92, 25,31014,31020},
    { 92, 26,31020,31026},
    { 92, 27,31026,31034},
    { 92, 28,31034,31042},
    { 92, 29,31042,31046},
    { 92, 30,31046,31050},
    { 92, 31,31050,31058},
    { 92, 32,31058,31068},
    { 92, 33,31068,31076},
    { 92, 34,31076,31082},
    { 92, 35,31082,31086},
    { 92, 36,31086,31088},
    { 92, 37,31088,31092},
    { 92, 38,31092,31098},
    { 92, 39,31098,31104},
    { 92, 40,31104,31110},
    { 92, 41,31110,31116},
    { 92, 42,31116,31122},
    { 92, 43,31122,31128},
    { 92, 44,31128,31134},
    { 92, 45,31134,31140},
    { 92, 46,31140,31146},
    { 92, 47,31146,31150},
    { 92, 48,31150,31154},
    { 92, 49,31154,31162},
    { 92, 50,31162,31172},
    { 92, 51,31172,31180},
    { 92, 52,31180,31186},
    { 92, 53,31186,31190},
    { 92, 54,31190,31192},
    { 92, 55,31192,31196},
    { 92, 56,31196,31202},
    { 92, 57,31202,31208},
    { 92, 58,31208,31210},
    { 92, 59,31210,31214},
    { 92, 60,31214,31218},
    { 92, 61,31218,31222},
    { 92, 62,31222,31226},
    { 92, 63,31226,31230},
    { 92, 64,31230,31234},
    { 92, 65,31234,31238},
    { 92, 66,31238,31242},
    { 92, 67,31242,31246},
    { 92, 68,31246,31250},
    { 92, 69,31250,31254},
    { 92, 70,31254,31258},
    { 92, 71,31258,31262},
    { 92, 72,31262,31268},
    { 92, 73,31268,31274},
    { 92, 74,31274,31280},
    { 92, 75,31280,31286},
    { 92, 76,31286,31292},
    { 92, 77,31292,31298},
    { 92, 78,31298,31304},
    { 92, 79,31304,31308},
    { 92, 80,31308,31312},
    { 92, 81,31312,31320},
    { 92, 82,31320,31330},
    { 92, 83,31330,31338},
    { 92, 84,31338,31344},
    { 92, 85,31344,31348},
    { 92, 86,31348,31350},
    { 92, 87,31350,31354},
    { 92, 88,31354,31360},
    { 92, 89,31360,31364},
    { 92, 90,31364,31368},
    { 92, 91,31368,31372},
    { 92, 92,31372,31375},
    { 93,  1,31375,31379},
    { 93,  2,31379,31381},
    { 93,  3,31381,31385},
    { 93,  4,31385,31391},
    { 93,  5,31391,31401},
    { 93,  6,31401,31411},
    { 93,  7,31411,31419},
    { 93,  8,31419,31425},
    { 93,  9,31425,31429},
    { 93, 10,31429,31431},
    { 93, 11,31431,31435},
    { 93, 12,31435,31441},
    { 93, 13,31441,31449},
    { 93, 14,31449,31459},
    { 93, 15,31459,31467},
    { 93, 16,31467,31473},
    { 93, 17,31473,31477},
    { 93, 18,31477,31479},
    { 93, 19,31479,31483},
    { 93, 20,31483,31489},
    { 93, 21,31489,31495},
    { 93, 22,31495,31501},
    { 93, 23,31501,31507},
    { 93, 24,31507,31513},
    { 93, 25,31513,31519},
    { 93, 26,31519,31525},
    { 93, 27,31525,31533},
    { 93, 28,31533,31541},
    { 93, 29,31541,31545},
    { 93, 30,31545,31549},
    { 93, 31,31549,31557},
    { 93, 32,31557,31567},
    { 93, 33,31567,31575},
    { 93, 34,31575,31581},
    { 93, 35,31581,31585},
    { 93, 36,31585,31587},
    { 93, 37,31587,31591},
    { 93, 38,31591,31597},
    { 93, 39,31597,31603},
    { 93, 40,31603,31609},
    { 93, 41,31609,31615},
    { 93, 42,31615,31621},
    { 93, 43,31621,31627},
    { 93, 44,31627,31633},
    { 93, 45,31633,31639},
    { 93, 46,31639,31645},
    { 93, 47,31645,31649},
    { 93, 48,31649,31653},
    { 93, 49,31653,31661},
    { 93, 50,31661,31671},
    { 93, 51,31671,31679},
    { 93, 52,31679,31685},
    { 93, 53,31685,31689},
    { 93, 54,31689,31691},
    { 93, 55,31691,31695},
    { 93, 56,31695,31701},
    { 93, 57,31701,31707},
    { 93, 58,31707,31709},
    { 93, 59,31709,31713},
    { 93, 60,31713,31717},
    { 93, 61,31717,31721},
    { 93, 62,31721,31725},
    { 93, 63,31725,31729},
    { 93, 64,31729,31733},
    { 93, 65,31733,31737},
    { 93, 66,31737,31741},
    { 93, 67,31741,31745},
    { 93, 68,31745,31749},
    { 93, 69,31749,31753},
    { 93, 70,31753,31757},
    { 93, 71,31757,31761},
    { 93, 72,31761,31767},
    { 93, 73,31767,31773},
    { 93, 74,31773,31779},
    { 93, 75,31779,31785},
    { 93, 76,31785,31791},
    { 93, 77,31791,31797},
    { 93, 78,31797,31803},
    { 93, 79,31803,31807},
    { 93, 80,31807,31811},
    { 93, 81,31811,31819},
    { 93, 82,31819,31829},
    { 93, 83,31829,31837},
    { 93, 84,31837,31843},
    { 93, 85,31843,31847},
    { 93, 86,31847,31849},
    { 93, 87,31849,31853},
    { 93, 88,31853,31859},
    { 93, 89,31859,31863},
    { 93, 90,31863,31867},
    { 93, 91,31867,31871},
    { 93, 92,31871,31875},
    { 93, 93,31875,31878},
    { 94,  1,31878,31882},
    { 94,  2,31882,31884},
    { 94,  3,31884,31888},
    { 94,  4,31888,31894},
    { 94,  5,31894,31904},
    { 94,  6,31904,31914},
    { 94,  7,31914,31922},
    { 94,  8,31922,31928},
    { 94,  9,31928,31932},
    { 94, 10,31932,31934},
    { 94, 11,31934,31938},
    { 94, 12,31938,31944},
    { 94, 13,31944,31952},
    { 94, 14,31952,31962},
    { 94, 15,31962,31970},
    { 94, 16,31970,31976},
    { 94, 17,31976,31980},
    { 94, 18,31980,31982},
    { 94, 19,31982,31986},
    { 94, 20,31986,31992},
    { 94, 21,31992,31998},
    { 94, 22,31998,32004},
    { 94, 23,32004,32010},
    { 94, 24,32010,32016},
    { 94, 25,32016,32022},
    { 94, 26,32022,32028},
    { 94, 27,32028,32036},
    { 94, 28,32036,32044},
    { 94, 29,32044,32048},
    { 94, 30,32048,32052},
    { 94, 31,32052,32060},
    { 94, 32,32060,32070},
    { 94, 33,32070,32078},
    { 94, 34,32078,32084},
    { 94, 35,32084,32088},
    { 94, 36,32088,32090},
    { 94, 37,32090,32094},
    { 94, 38,32094,32100},
    { 94, 39,32100,32106},
    { 94, 40,32106,32112},
    { 94, 41,32112,32118},
    { 94, 42,32118,32124},
    { 94, 43,32124,32130},
    { 94, 44,32130,32136},
    { 94, 45,32136,32142},
    { 94, 46,32142,32148},
    { 94, 47,32148,32152},
    { 94, 48,32152,32156},
    { 94, 49,32156,32164},
    { 94, 50,32164,32174},
    { 94, 51,32174,32182},
    { 94, 52,32182,32188},
    { 94, 53,32188,32192},
    { 94, 54,32192,32194},
    { 94, 55,32194,32198},
    { 94, 56,32198,32204},
    { 94, 57,32204,32210},
    { 94, 58,32210,32212},
    { 94, 59,32212,32216},
    { 94, 60,32216,32220},
    { 94, 61,32220,32224},
    { 94, 62,32224,32228},
    { 94, 63,32228,32232},
    { 94, 64,32232,32236},
    { 94, 65,32236,32240},
    { 94, 66,32240,32244},
    { 94, 67,32244,32248},
    { 94, 68,32248,32252},
    { 94, 69,32252,32256},
    { 94, 70,32256,32260},
    { 94, 71,32260,32264},
    { 94, 72,32264,32270},
    { 94, 73,32270,32276},
    { 94, 74,32276,32282},
    { 94, 75,32282,32288},
    { 94, 76,32288,32294},
    { 94, 77,32294,32300},
    { 94, 78,32300,32306},
    { 94, 79,32306,32310},
    { 94, 80,32310,32314},
    { 94, 81,32314,32322},
    { 94, 82,32322,32332},
    { 94, 83,32332,32340},
    { 94, 84,32340,32346},
    { 94, 85,32346,32350},
    { 94, 86,32350,32352},
    { 94, 87,32352,32356},
    { 94, 88,32356,32362},
    { 94, 89,32362,32366},
    { 94, 90,32366,32370},
    { 94, 91,32370,32374},
    { 94, 92,32374,32378},
    { 94, 93,32378,32382},
    { 94, 94,32382,32385}
};
static FC6Entry const g_C6ParameterTable[32385] = {
    {  1,  1,  0,  0, 0.30267000e+01, 0.91180000e+00, 0.91180000e+00},
    {  1,  1,  1,  0, 0.47379000e+01, 0.00000000e+00, 0.91180000e+00},
    {  1,  1,  1,  1, 0.75916000e+01, 0.00000000e+00, 0.00000000e+00},
    {  2,  1,  0,  0, 0.20835000e+01, 0.00000000e+00, 0.91180000e+00},
    {  2,  1,  0,  1, 0.31287000e+01, 0.00000000e+00, 0.00000000e+00},
    {  2,  2,  0,  0, 0.15583000e+01, 0.00000000e+00, 0.00000000e+00},
    {  3,  1,  0,  0, 0.38944800e+02, 0.00000000e+00, 0.91180000e+00},
    {  3,  1,  0,  1, 0.68939100e+02, 0.00000000e+00, 0.00000000e+00},
    {  3,  1,  1,  0, 0.14316500e+02, 0.98650000e+00, 0.91180000e+00},
    {  3,  1,  1,  1, 0.24057300e+02, 0.98650000e+00, 0.00000000e+00},
    {  3,  2,  0,  0, 0.22150800e+02, 0.00000000e+00, 0.00000000e+00},
    {  3,  2,  1,  0, 0.87773000e+01, 0.98650000e+00, 0.00000000e+00},
    {  3,  3,  0,  0, 0.11634454e+04, 0.00000000e+00, 0.00000000e+00},
    {  3,  3,  1,  0, 0.28221060e+03, 0.98650000e+00, 0.00000000e+00},
    {  3,  3,  1,  1, 0.85319700e+02, 0.98650000e+00, 0.98650000e+00},
    {  4,  1,  0,  0, 0.24441500e+02, 0.00000000e+00, 0.91180000e+00},
    {  4,  1,  0,  1, 0.41307800e+02, 0.00000000e+00, 0.00000000e+00},
    {  4,  1,  1,  0, 0.18465600e+02, 0.98080000e+00, 0.91180000e+00},
    {  4,  1,  1,  1, 0.30786600e+02, 0.98080000e+00, 0.00000000e+00},
    {  4,  1,  2,  0, 0.12593100e+02, 0.19697000e+01, 0.91180000e+00},
    {  4,  1,  2,  1, 0.20403900e+02, 0.19697000e+01, 0.00000000e+00},
    {  4,  2,  0,  0, 0.14824600e+02, 0.00000000e+00, 0.00000000e+00},
    {  4,  2,  1,  0, 0.11465500e+02, 0.98080000e+00, 0.00000000e+00},
    {  4,  2,  2,  0, 0.81628000e+01, 0.19697000e+01, 0.00000000e+00},
    {  4,  3,  0,  0, 0.49461900e+03, 0.00000000e+00, 0.00000000e+00},
    {  4,  3,  0,  1, 0.14813230e+03, 0.00000000e+00, 0.98650000e+00},
    {  4,  3,  1,  0, 0.35221600e+03, 0.98080000e+00, 0.00000000e+00},
    {  4,  3,  1,  1, 0.10750830e+03, 0.98080000e+00, 0.98650000e+00},
    {  4,  3,  2,  0, 0.19470360e+03, 0.19697000e+01, 0.00000000e+00},
    {  4,  3,  2,  1, 0.66200900e+02, 0.19697000e+01, 0.98650000e+00},
    {  4,  4,  0,  0, 0.25748630e+03, 0.00000000e+00, 0.00000000e+00},
    {  4,  4,  1,  0, 0.18634530e+03, 0.98080000e+00, 0.00000000e+00},
    {  4,  4,  1,  1, 0.13584450e+03, 0.98080000e+00, 0.98080000e+00},
    {  4,  4,  2,  0, 0.11396770e+03, 0.19697000e+01, 0.00000000e+00},
    {  4,  4,  2,  1, 0.84400000e+02, 0.19697000e+01, 0.98080000e+00},
    {  4,  4,  2,  2, 0.55136400e+02, 0.19697000e+01, 0.19697000e+01},
    {  5,  1,  0,  0, 0.17314300e+02, 0.00000000e+00, 0.91180000e+00},
    {  5,  1,  0,  1, 0.28276700e+02, 0.00000000e+00, 0.00000000e+00},
    {  5,  1,  1,  0, 0.14723700e+02, 0.97060000e+00, 0.91180000e+00},
    {  5,  1,  1,  1, 0.23841200e+02, 0.97060000e+00, 0.00000000e+00},
    {  5,  1,  2,  0, 0.12495200e+02, 0.19441000e+01, 0.91180000e+00},
    {  5,  1,  2,  1, 0.20059700e+02, 0.19441000e+01, 0.00000000e+00},
    {  5,  1,  3,  0, 0.97472000e+01, 0.29128000e+01, 0.91180000e+00},
    {  5,  1,  3,  1, 0.15353100e+02, 0.29128000e+01, 0.00000000e+00},
    {  5,  1,  4,  0, 0.92092000e+01, 0.45856000e+01, 0.91180000e+00},
    {  5,  1,  4,  1, 0.14454100e+02, 0.45856000e+01, 0.00000000e+00},
    {  5,  2,  0,  0, 0.11097500e+02, 0.00000000e+00, 0.00000000e+00},
    {  5,  2,  1,  0, 0.95836000e+01, 0.97060000e+00, 0.00000000e+00},
    {  5,  2,  2,  0, 0.82586000e+01, 0.19441000e+01, 0.00000000e+00},
    {  5,  2,  3,  0, 0.66434000e+01, 0.29128000e+01, 0.00000000e+00},
    {  5,  2,  4,  0, 0.63181000e+01, 0.45856000e+01, 0.00000000e+00},
    {  5,  3,  0,  0, 0.28373080e+03, 0.00000000e+00, 0.00000000e+00},
    {  5,  3,  0,  1, 0.93672900e+02, 0.00000000e+00, 0.98650000e+00},
    {  5,  3,  1,  0, 0.23142090e+03, 0.97060000e+00, 0.00000000e+00},
    {  5,  3,  1,  1, 0.77663300e+02, 0.97060000e+00, 0.98650000e+00},
    {  5,  3,  2,  0, 0.18876110e+03, 0.19441000e+01, 0.00000000e+00},
    {  5,  3,  2,  1, 0.64255300e+02, 0.19441000e+01, 0.98650000e+00},
    {  5,  3,  3,  0, 0.12998750e+03, 0.29128000e+01, 0.00000000e+00},
    {  5,  3,  3,  1, 0.47033800e+02, 0.29128000e+01, 0.98650000e+00},
    {  5,  3,  4,  0, 0.12066280e+03, 0.45856000e+01, 0.00000000e+00},
    {  5,  3,  4,  1, 0.43974600e+02, 0.45856000e+01, 0.98650000e+00},
    {  5,  4,  0,  0, 0.16159710e+03, 0.00000000e+00, 0.00000000e+00},
    {  5,  4,  0,  1, 0.11908150e+03, 0.00000000e+00, 0.98080000e+00},
    {  5,  4,  0,  2, 0.76723000e+02, 0.00000000e+00, 0.19697000e+01},
    {  5,  4,  1,  0, 0.13372650e+03, 0.97060000e+00, 0.00000000e+00},
    {  5,  4,  1,  1, 0.98993800e+02, 0.97060000e+00, 0.98080000e+00},
    {  5,  4,  1,  2, 0.64430100e+02, 0.97060000e+00, 0.19697000e+01},
    {  5,  4,  2,  0, 0.11041850e+03, 0.19441000e+01, 0.00000000e+00},
    {  5,  4,  2,  1, 0.82143000e+02, 0.19441000e+01, 0.98080000e+00},
    {  5,  4,  2,  2, 0.53991900e+02, 0.19441000e+01, 0.19697000e+01},
    {  5,  4,  3,  0, 0.80427600e+02, 0.29128000e+01, 0.00000000e+00},
    {  5,  4,  3,  1, 0.60523400e+02, 0.29128000e+01, 0.98080000e+00},
    {  5,  4,  3,  2, 0.40935800e+02, 0.29128000e+01, 0.19697000e+01},
    {  5,  4,  4,  0, 0.75131100e+02, 0.45856000e+01, 0.00000000e+00},
    {  5,  4,  4,  1, 0.56652700e+02, 0.45856000e+01, 0.98080000e+00},
    {  5,  4,  4,  2, 0.38474500e+02, 0.45856000e+01, 0.19697000e+01},
    {  5,  5,  0,  0, 0.10717770e+03, 0.00000000e+00, 0.00000000e+00},
    {  5,  5,  1,  0, 0.89742900e+02, 0.97060000e+00, 0.00000000e+00},
    {  5,  5,  1,  1, 0.75368600e+02, 0.97060000e+00, 0.97060000e+00},
    {  5,  5,  2,  0, 0.74986500e+02, 0.19441000e+01, 0.00000000e+00},
    {  5,  5,  2,  1, 0.63168500e+02, 0.19441000e+01, 0.97060000e+00},
    {  5,  5,  2,  2, 0.53112800e+02, 0.19441000e+01, 0.19441000e+01},
    {  5,  5,  3,  0, 0.56411600e+02, 0.29128000e+01, 0.00000000e+00},
    {  5,  5,  3,  1, 0.47858000e+02, 0.29128000e+01, 0.97060000e+00},
    {  5,  5,  3,  2, 0.40519200e+02, 0.29128000e+01, 0.19441000e+01},
    {  5,  5,  3,  3, 0.31443600e+02, 0.29128000e+01, 0.29128000e+01},
    {  5,  5,  4,  0, 0.52960600e+02, 0.45856000e+01, 0.00000000e+00},
    {  5,  5,  4,  1, 0.44988800e+02, 0.45856000e+01, 0.97060000e+00},
    {  5,  5,  4,  2, 0.38139800e+02, 0.45856000e+01, 0.19441000e+01},
    {  5,  5,  4,  3, 0.29680400e+02, 0.45856000e+01, 0.29128000e+01},
    {  5,  5,  4,  4, 0.28031500e+02, 0.45856000e+01, 0.45856000e+01},
    {  6,  1,  0,  0, 0.12140200e+02, 0.00000000e+00, 0.91180000e+00},
    {  6,  1,  0,  1, 0.19265300e+02, 0.00000000e+00, 0.00000000e+00},
    {  6,  1,  1,  0, 0.11393200e+02, 0.98680000e+00, 0.91180000e+00},
    {  6,  1,  1,  1, 0.18057500e+02, 0.98680000e+00, 0.00000000e+00},
    {  6,  1,  2,  0, 0.94203000e+01, 0.19985000e+01, 0.91180000e+00},
    {  6,  1,  2,  1, 0.14762300e+02, 0.19985000e+01, 0.00000000e+00},
    {  6,  1,  3,  0, 0.88210000e+01, 0.29987000e+01, 0.91180000e+00},
    {  6,  1,  3,  1, 0.13799200e+02, 0.29987000e+01, 0.00000000e+00},
    {  6,  1,  4,  0, 0.73662000e+01, 0.39844000e+01, 0.91180000e+00},
    {  6,  1,  4,  1, 0.11329900e+02, 0.39844000e+01, 0.00000000e+00},
    {  6,  2,  0,  0, 0.81841000e+01, 0.00000000e+00, 0.00000000e+00},
    {  6,  2,  1,  0, 0.77065000e+01, 0.98680000e+00, 0.00000000e+00},
    {  6,  2,  2,  0, 0.65027000e+01, 0.19985000e+01, 0.00000000e+00},
    {  6,  2,  3,  0, 0.61196000e+01, 0.29987000e+01, 0.00000000e+00},
    {  6,  2,  4,  0, 0.52567000e+01, 0.39844000e+01, 0.00000000e+00},
    {  6,  3,  0,  0, 0.16990300e+03, 0.00000000e+00, 0.00000000e+00},
    {  6,  3,  0,  1, 0.60086000e+02, 0.00000000e+00, 0.98650000e+00},
    {  6,  3,  1,  0, 0.16045900e+03, 0.98680000e+00, 0.00000000e+00},
    {  6,  3,  1,  1, 0.56346800e+02, 0.98680000e+00, 0.98650000e+00},
    {  6,  3,  2,  0, 0.12377070e+03, 0.19985000e+01, 0.00000000e+00},
    {  6,  3,  2,  1, 0.44932000e+02, 0.19985000e+01, 0.98650000e+00},
    {  6,  3,  3,  0, 0.11594980e+03, 0.29987000e+01, 0.00000000e+00},
    {  6,  3,  3,  1, 0.41971300e+02, 0.29987000e+01, 0.98650000e+00},
    {  6,  3,  4,  0, 0.87818300e+02, 0.39844000e+01, 0.00000000e+00},
    {  6,  3,  4,  1, 0.33215800e+02, 0.39844000e+01, 0.98650000e+00},
    {  6,  4,  0,  0, 0.10295600e+03, 0.00000000e+00, 0.00000000e+00},
    {  6,  4,  0,  1, 0.77095100e+02, 0.00000000e+00, 0.98080000e+00},
    {  6,  4,  0,  2, 0.51562800e+02, 0.00000000e+00, 0.19697000e+01},
    {  6,  4,  1,  0, 0.96543100e+02, 0.98680000e+00, 0.00000000e+00},
    {  6,  4,  1,  1, 0.72316200e+02, 0.98680000e+00, 0.98080000e+00},
    {  6,  4,  1,  2, 0.48307200e+02, 0.98680000e+00, 0.19697000e+01},
    {  6,  4,  2,  0, 0.76755200e+02, 0.19985000e+01, 0.00000000e+00},
    {  6,  4,  2,  1, 0.57880500e+02, 0.19985000e+01, 0.98080000e+00},
    {  6,  4,  2,  2, 0.39281400e+02, 0.19985000e+01, 0.19697000e+01},
    {  6,  4,  3,  0, 0.71681800e+02, 0.29987000e+01, 0.00000000e+00},
    {  6,  4,  3,  1, 0.54077000e+02, 0.29987000e+01, 0.98080000e+00},
    {  6,  4,  3,  2, 0.36697700e+02, 0.29987000e+01, 0.19697000e+01},
    {  6,  4,  4,  0, 0.56466200e+02, 0.39844000e+01, 0.00000000e+00},
    {  6,  4,  4,  1, 0.43062000e+02, 0.39844000e+01, 0.98080000e+00},
    {  6,  4,  4,  2, 0.29881900e+02, 0.39844000e+01, 0.19697000e+01},
    {  6,  5,  0,  0, 0.71279400e+02, 0.00000000e+00, 0.00000000e+00},
    {  6,  5,  0,  1, 0.60299600e+02, 0.00000000e+00, 0.97060000e+00},
    {  6,  5,  0,  2, 0.50909000e+02, 0.00000000e+00, 0.19441000e+01},
    {  6,  5,  0,  3, 0.39244900e+02, 0.00000000e+00, 0.29128000e+01},
    {  6,  5,  0,  4, 0.37004200e+02, 0.00000000e+00, 0.45856000e+01},
    {  6,  5,  1,  0, 0.66798600e+02, 0.98680000e+00, 0.00000000e+00},
    {  6,  5,  1,  1, 0.56529500e+02, 0.98680000e+00, 0.97060000e+00},
    {  6,  5,  1,  2, 0.47746200e+02, 0.98680000e+00, 0.19441000e+01},
    {  6,  5,  1,  3, 0.36816600e+02, 0.98680000e+00, 0.29128000e+01},
    {  6,  5,  1,  4, 0.34722600e+02, 0.98680000e+00, 0.45856000e+01},
    {  6,  5,  2,  0, 0.54085400e+02, 0.19985000e+01, 0.00000000e+00},
    {  6,  5,  2,  1, 0.45963200e+02, 0.19985000e+01, 0.97060000e+00},
    {  6,  5,  2,  2, 0.38983400e+02, 0.19985000e+01, 0.19441000e+01},
    {  6,  5,  2,  3, 0.30353600e+02, 0.19985000e+01, 0.29128000e+01},
    {  6,  5,  2,  4, 0.28676300e+02, 0.19985000e+01, 0.45856000e+01},
    {  6,  5,  3,  0, 0.50530300e+02, 0.29987000e+01, 0.00000000e+00},
    {  6,  5,  3,  1, 0.42964600e+02, 0.29987000e+01, 0.97060000e+00},
    {  6,  5,  3,  2, 0.36460400e+02, 0.29987000e+01, 0.19441000e+01},
    {  6,  5,  3,  3, 0.28412100e+02, 0.29987000e+01, 0.29128000e+01},
    {  6,  5,  3,  4, 0.26850600e+02, 0.29987000e+01, 0.45856000e+01},
    {  6,  5,  4,  0, 0.40896200e+02, 0.39844000e+01, 0.00000000e+00},
    {  6,  5,  4,  1, 0.34999000e+02, 0.39844000e+01, 0.97060000e+00},
    {  6,  5,  4,  2, 0.29891600e+02, 0.39844000e+01, 0.19441000e+01},
    {  6,  5,  4,  3, 0.23621000e+02, 0.39844000e+01, 0.29128000e+01},
    {  6,  5,  4,  4, 0.22379700e+02, 0.39844000e+01, 0.45856000e+01},
    {  6,  6,  0,  0, 0.49113000e+02, 0.00000000e+00, 0.00000000e+00},
    {  6,  6,  1,  0, 0.46068100e+02, 0.98680000e+00, 0.00000000e+00},
    {  6,  6,  1,  1, 0.43245200e+02, 0.98680000e+00, 0.98680000e+00},
    {  6,  6,  2,  0, 0.37841900e+02, 0.19985000e+01, 0.00000000e+00},
    {  6,  6,  2,  1, 0.35521900e+02, 0.19985000e+01, 0.98680000e+00},
    {  6,  6,  2,  2, 0.29360200e+02, 0.19985000e+01, 0.19985000e+01},
    {  6,  6,  3,  0, 0.35412900e+02, 0.29987000e+01, 0.00000000e+00},
    {  6,  6,  3,  1, 0.33254000e+02, 0.29987000e+01, 0.98680000e+00},
    {  6,  6,  3,  2, 0.27506300e+02, 0.29987000e+01, 0.19985000e+01},
    {  6,  6,  3,  3, 0.25780900e+02, 0.29987000e+01, 0.29987000e+01},
    {  6,  6,  4,  0, 0.29283000e+02, 0.39844000e+01, 0.00000000e+00},
    {  6,  6,  4,  1, 0.27520600e+02, 0.39844000e+01, 0.98680000e+00},
    {  6,  6,  4,  2, 0.22951700e+02, 0.39844000e+01, 0.19985000e+01},
    {  6,  6,  4,  3, 0.21537700e+02, 0.39844000e+01, 0.29987000e+01},
    {  6,  6,  4,  4, 0.18206700e+02, 0.39844000e+01, 0.39844000e+01},
    {  7,  1,  0,  0, 0.87171000e+01, 0.00000000e+00, 0.91180000e+00},
    {  7,  1,  0,  1, 0.13516400e+02, 0.00000000e+00, 0.00000000e+00},
    {  7,  1,  1,  0, 0.81417000e+01, 0.99440000e+00, 0.91180000e+00},
    {  7,  1,  1,  1, 0.12598000e+02, 0.99440000e+00, 0.00000000e+00},
    {  7,  1,  2,  0, 0.76610000e+01, 0.20143000e+01, 0.91180000e+00},
    {  7,  1,  2,  1, 0.11821400e+02, 0.20143000e+01, 0.00000000e+00},
    {  7,  1,  3,  0, 0.67746000e+01, 0.29903000e+01, 0.91180000e+00},
    {  7,  1,  3,  1, 0.10398700e+02, 0.29903000e+01, 0.00000000e+00},
    {  7,  2,  0,  0, 0.61380000e+01, 0.00000000e+00, 0.00000000e+00},
    {  7,  2,  1,  0, 0.57601000e+01, 0.99440000e+00, 0.00000000e+00},
    {  7,  2,  2,  0, 0.54559000e+01, 0.20143000e+01, 0.00000000e+00},
    {  7,  2,  3,  0, 0.48836000e+01, 0.29903000e+01, 0.00000000e+00},
    {  7,  3,  0,  0, 0.10848540e+03, 0.00000000e+00, 0.00000000e+00},
    {  7,  3,  0,  1, 0.40294400e+02, 0.00000000e+00, 0.98650000e+00},
    {  7,  3,  1,  0, 0.10127010e+03, 0.99440000e+00, 0.00000000e+00},
    {  7,  3,  1,  1, 0.37493900e+02, 0.99440000e+00, 0.98650000e+00},
    {  7,  3,  2,  0, 0.94006000e+02, 0.20143000e+01, 0.00000000e+00},
    {  7,  3,  2,  1, 0.35019400e+02, 0.20143000e+01, 0.98650000e+00},
    {  7,  3,  3,  0, 0.81977000e+02, 0.29903000e+01, 0.00000000e+00},
    {  7,  3,  3,  1, 0.30602200e+02, 0.29903000e+01, 0.98650000e+00},
    {  7,  4,  0,  0, 0.68645800e+02, 0.00000000e+00, 0.00000000e+00},
    {  7,  4,  0,  1, 0.52085200e+02, 0.00000000e+00, 0.98080000e+00},
    {  7,  4,  0,  2, 0.35790200e+02, 0.00000000e+00, 0.19697000e+01},
    {  7,  4,  1,  0, 0.63858000e+02, 0.99440000e+00, 0.00000000e+00},
    {  7,  4,  1,  1, 0.48488500e+02, 0.99440000e+00, 0.98080000e+00},
    {  7,  4,  1,  2, 0.33327400e+02, 0.99440000e+00, 0.19697000e+01},
    {  7,  4,  2,  0, 0.59598300e+02, 0.20143000e+01, 0.00000000e+00},
    {  7,  4,  2,  1, 0.45316400e+02, 0.20143000e+01, 0.98080000e+00},
    {  7,  4,  2,  2, 0.31240700e+02, 0.20143000e+01, 0.19697000e+01},
    {  7,  4,  3,  0, 0.52023700e+02, 0.29903000e+01, 0.00000000e+00},
    {  7,  4,  3,  1, 0.39647800e+02, 0.29903000e+01, 0.98080000e+00},
    {  7,  4,  3,  2, 0.27422500e+02, 0.29903000e+01, 0.19697000e+01},
    {  7,  5,  0,  0, 0.49113200e+02, 0.00000000e+00, 0.00000000e+00},
    {  7,  5,  0,  1, 0.41901500e+02, 0.00000000e+00, 0.97060000e+00},
    {  7,  5,  0,  2, 0.35677800e+02, 0.00000000e+00, 0.19441000e+01},
    {  7,  5,  0,  3, 0.28012900e+02, 0.00000000e+00, 0.29128000e+01},
    {  7,  5,  0,  4, 0.26508300e+02, 0.00000000e+00, 0.45856000e+01},
    {  7,  5,  1,  0, 0.45731900e+02, 0.99440000e+00, 0.00000000e+00},
    {  7,  5,  1,  1, 0.39043300e+02, 0.99440000e+00, 0.97060000e+00},
    {  7,  5,  1,  2, 0.33267700e+02, 0.99440000e+00, 0.19441000e+01},
    {  7,  5,  1,  3, 0.26148100e+02, 0.99440000e+00, 0.29128000e+01},
    {  7,  5,  1,  4, 0.24752500e+02, 0.99440000e+00, 0.45856000e+01},
    {  7,  5,  2,  0, 0.42834800e+02, 0.20143000e+01, 0.00000000e+00},
    {  7,  5,  2,  1, 0.36606300e+02, 0.20143000e+01, 0.97060000e+00},
    {  7,  5,  2,  2, 0.31222100e+02, 0.20143000e+01, 0.19441000e+01},
    {  7,  5,  2,  3, 0.24591900e+02, 0.20143000e+01, 0.29128000e+01},
    {  7,  5,  2,  4, 0.23290000e+02, 0.20143000e+01, 0.45856000e+01},
    {  7,  5,  3,  0, 0.37568500e+02, 0.29903000e+01, 0.00000000e+00},
    {  7,  5,  3,  1, 0.32164400e+02, 0.29903000e+01, 0.97060000e+00},
    {  7,  5,  3,  2, 0.27484200e+02, 0.29903000e+01, 0.19441000e+01},
    {  7,  5,  3,  3, 0.21720500e+02, 0.29903000e+01, 0.29128000e+01},
    {  7,  5,  3,  4, 0.20588600e+02, 0.29903000e+01, 0.45856000e+01},
    {  7,  6,  0,  0, 0.34814600e+02, 0.00000000e+00, 0.00000000e+00},
    {  7,  6,  0,  1, 0.32700900e+02, 0.00000000e+00, 0.98680000e+00},
    {  7,  6,  0,  2, 0.27170400e+02, 0.00000000e+00, 0.19985000e+01},
    {  7,  6,  0,  3, 0.25479900e+02, 0.00000000e+00, 0.29987000e+01},
    {  7,  6,  0,  4, 0.21419900e+02, 0.00000000e+00, 0.39844000e+01},
    {  7,  6,  1,  0, 0.32484800e+02, 0.99440000e+00, 0.00000000e+00},
    {  7,  6,  1,  1, 0.30541000e+02, 0.99440000e+00, 0.98680000e+00},
    {  7,  6,  1,  2, 0.25382700e+02, 0.99440000e+00, 0.19985000e+01},
    {  7,  6,  1,  3, 0.23813600e+02, 0.99440000e+00, 0.29987000e+01},
    {  7,  6,  1,  4, 0.20046800e+02, 0.99440000e+00, 0.39844000e+01},
    {  7,  6,  2,  0, 0.30530500e+02, 0.20143000e+01, 0.00000000e+00},
    {  7,  6,  2,  1, 0.28693800e+02, 0.20143000e+01, 0.98680000e+00},
    {  7,  6,  2,  2, 0.23896500e+02, 0.20143000e+01, 0.19985000e+01},
    {  7,  6,  2,  3, 0.22427900e+02, 0.20143000e+01, 0.29987000e+01},
    {  7,  6,  2,  4, 0.18917200e+02, 0.20143000e+01, 0.39844000e+01},
    {  7,  6,  3,  0, 0.26935100e+02, 0.29903000e+01, 0.00000000e+00},
    {  7,  6,  3,  1, 0.25331800e+02, 0.29903000e+01, 0.98680000e+00},
    {  7,  6,  3,  2, 0.21148800e+02, 0.29903000e+01, 0.19985000e+01},
    {  7,  6,  3,  3, 0.19866900e+02, 0.29903000e+01, 0.29987000e+01},
    {  7,  6,  3,  4, 0.16816900e+02, 0.29903000e+01, 0.39844000e+01},
    {  7,  7,  0,  0, 0.25268500e+02, 0.00000000e+00, 0.00000000e+00},
    {  7,  7,  1,  0, 0.23629500e+02, 0.99440000e+00, 0.00000000e+00},
    {  7,  7,  1,  1, 0.22124100e+02, 0.99440000e+00, 0.99440000e+00},
    {  7,  7,  2,  0, 0.22279400e+02, 0.20143000e+01, 0.00000000e+00},
    {  7,  7,  2,  1, 0.20850100e+02, 0.20143000e+01, 0.99440000e+00},
    {  7,  7,  2,  2, 0.19676800e+02, 0.20143000e+01, 0.20143000e+01},
    {  7,  7,  3,  0, 0.19770700e+02, 0.29903000e+01, 0.00000000e+00},
    {  7,  7,  3,  1, 0.18518000e+02, 0.29903000e+01, 0.99440000e+00},
    {  7,  7,  3,  2, 0.17492800e+02, 0.29903000e+01, 0.20143000e+01},
    {  7,  7,  3,  3, 0.15581700e+02, 0.29903000e+01, 0.29903000e+01},
    {  8,  1,  0,  0, 0.67180000e+01, 0.00000000e+00, 0.91180000e+00},
    {  8,  1,  0,  1, 0.10237100e+02, 0.00000000e+00, 0.00000000e+00},
    {  8,  1,  1,  0, 0.60575000e+01, 0.99250000e+00, 0.91180000e+00},
    {  8,  1,  1,  1, 0.91812000e+01, 0.99250000e+00, 0.00000000e+00},
    {  8,  1,  2,  0, 0.53717000e+01, 0.19887000e+01, 0.91180000e+00},
    {  8,  1,  2,  1, 0.80848000e+01, 0.19887000e+01, 0.00000000e+00},
    {  8,  2,  0,  0, 0.48949000e+01, 0.00000000e+00, 0.00000000e+00},
    {  8,  2,  1,  0, 0.44593000e+01, 0.99250000e+00, 0.00000000e+00},
    {  8,  2,  2,  0, 0.40179000e+01, 0.19887000e+01, 0.00000000e+00},
    {  8,  3,  0,  0, 0.76961300e+02, 0.00000000e+00, 0.00000000e+00},
    {  8,  3,  0,  1, 0.29557500e+02, 0.00000000e+00, 0.98650000e+00},
    {  8,  3,  1,  0, 0.67931200e+02, 0.99250000e+00, 0.00000000e+00},
    {  8,  3,  1,  1, 0.26270800e+02, 0.99250000e+00, 0.98650000e+00},
    {  8,  3,  2,  0, 0.58670300e+02, 0.19887000e+01, 0.00000000e+00},
    {  8,  3,  2,  1, 0.22893000e+02, 0.19887000e+01, 0.98650000e+00},
    {  8,  4,  0,  0, 0.50125200e+02, 0.00000000e+00, 0.00000000e+00},
    {  8,  4,  0,  1, 0.38413200e+02, 0.00000000e+00, 0.98080000e+00},
    {  8,  4,  0,  2, 0.26895400e+02, 0.00000000e+00, 0.19697000e+01},
    {  8,  4,  1,  0, 0.44496800e+02, 0.99250000e+00, 0.00000000e+00},
    {  8,  4,  1,  1, 0.34198300e+02, 0.99250000e+00, 0.98080000e+00},
    {  8,  4,  1,  2, 0.24059200e+02, 0.99250000e+00, 0.19697000e+01},
    {  8,  4,  2,  0, 0.38702700e+02, 0.19887000e+01, 0.00000000e+00},
    {  8,  4,  2,  1, 0.29852300e+02, 0.19887000e+01, 0.98080000e+00},
    {  8,  4,  2,  2, 0.21128200e+02, 0.19887000e+01, 0.19697000e+01},
    {  8,  5,  0,  0, 0.36724700e+02, 0.00000000e+00, 0.00000000e+00},
    {  8,  5,  0,  1, 0.31535400e+02, 0.00000000e+00, 0.97060000e+00},
    {  8,  5,  0,  2, 0.27024700e+02, 0.00000000e+00, 0.19441000e+01},
    {  8,  5,  0,  3, 0.21498900e+02, 0.00000000e+00, 0.29128000e+01},
    {  8,  5,  0,  4, 0.20399800e+02, 0.00000000e+00, 0.45856000e+01},
    {  8,  5,  1,  0, 0.32813600e+02, 0.99250000e+00, 0.00000000e+00},
    {  8,  5,  1,  1, 0.28232700e+02, 0.99250000e+00, 0.97060000e+00},
    {  8,  5,  1,  2, 0.24241600e+02, 0.99250000e+00, 0.19441000e+01},
    {  8,  5,  1,  3, 0.19357100e+02, 0.99250000e+00, 0.29128000e+01},
    {  8,  5,  1,  4, 0.18383100e+02, 0.99250000e+00, 0.45856000e+01},
    {  8,  5,  2,  0, 0.28771300e+02, 0.19887000e+01, 0.00000000e+00},
    {  8,  5,  2,  1, 0.24818500e+02, 0.19887000e+01, 0.97060000e+00},
    {  8,  5,  2,  2, 0.21364800e+02, 0.19887000e+01, 0.19441000e+01},
    {  8,  5,  2,  3, 0.17142400e+02, 0.19887000e+01, 0.29128000e+01},
    {  8,  5,  2,  4, 0.16298700e+02, 0.19887000e+01, 0.45856000e+01},
    {  8,  6,  0,  0, 0.26592900e+02, 0.00000000e+00, 0.00000000e+00},
    {  8,  6,  0,  1, 0.25009700e+02, 0.00000000e+00, 0.98680000e+00},
    {  8,  6,  0,  2, 0.20959700e+02, 0.00000000e+00, 0.19985000e+01},
    {  8,  6,  0,  3, 0.19694300e+02, 0.00000000e+00, 0.29987000e+01},
    {  8,  6,  0,  4, 0.16754400e+02, 0.00000000e+00, 0.39844000e+01},
    {  8,  6,  1,  0, 0.23912000e+02, 0.99250000e+00, 0.00000000e+00},
    {  8,  6,  1,  1, 0.22517800e+02, 0.99250000e+00, 0.98680000e+00},
    {  8,  6,  1,  2, 0.18903400e+02, 0.99250000e+00, 0.19985000e+01},
    {  8,  6,  1,  3, 0.17775000e+02, 0.99250000e+00, 0.29987000e+01},
    {  8,  6,  1,  4, 0.15175100e+02, 0.99250000e+00, 0.39844000e+01},
    {  8,  6,  2,  0, 0.21142800e+02, 0.19887000e+01, 0.00000000e+00},
    {  8,  6,  2,  1, 0.19909000e+02, 0.19887000e+01, 0.98680000e+00},
    {  8,  6,  2,  2, 0.16785500e+02, 0.19887000e+01, 0.19985000e+01},
    {  8,  6,  2,  3, 0.15800900e+02, 0.19887000e+01, 0.29987000e+01},
    {  8,  6,  2,  4, 0.13552500e+02, 0.19887000e+01, 0.39844000e+01},
    {  8,  7,  0,  0, 0.19654600e+02, 0.00000000e+00, 0.00000000e+00},
    {  8,  7,  0,  1, 0.18412800e+02, 0.00000000e+00, 0.99440000e+00},
    {  8,  7,  0,  2, 0.17409300e+02, 0.00000000e+00, 0.20143000e+01},
    {  8,  7,  0,  3, 0.15524900e+02, 0.00000000e+00, 0.29903000e+01},
    {  8,  7,  1,  0, 0.17769800e+02, 0.99250000e+00, 0.00000000e+00},
    {  8,  7,  1,  1, 0.16677500e+02, 0.99250000e+00, 0.99440000e+00},
    {  8,  7,  1,  2, 0.15763100e+02, 0.99250000e+00, 0.20143000e+01},
    {  8,  7,  1,  3, 0.14079300e+02, 0.99250000e+00, 0.29903000e+01},
    {  8,  7,  2,  0, 0.15836400e+02, 0.19887000e+01, 0.00000000e+00},
    {  8,  7,  2,  1, 0.14860000e+02, 0.19887000e+01, 0.99440000e+00},
    {  8,  7,  2,  2, 0.14080700e+02, 0.19887000e+01, 0.20143000e+01},
    {  8,  7,  2,  3, 0.12607700e+02, 0.19887000e+01, 0.29903000e+01},
    {  8,  8,  0,  0, 0.15505900e+02, 0.00000000e+00, 0.00000000e+00},
    {  8,  8,  1,  0, 0.14076400e+02, 0.99250000e+00, 0.00000000e+00},
    {  8,  8,  1,  1, 0.12816100e+02, 0.99250000e+00, 0.99250000e+00},
    {  8,  8,  2,  0, 0.12627700e+02, 0.19887000e+01, 0.00000000e+00},
    {  8,  8,  2,  1, 0.11500900e+02, 0.19887000e+01, 0.99250000e+00},
    {  8,  8,  2,  2, 0.10370800e+02, 0.19887000e+01, 0.19887000e+01},
    {  9,  1,  0,  0, 0.51616000e+01, 0.00000000e+00, 0.91180000e+00},
    {  9,  1,  0,  1, 0.77441000e+01, 0.00000000e+00, 0.00000000e+00},
    {  9,  1,  1,  0, 0.42672000e+01, 0.99820000e+00, 0.91180000e+00},
    {  9,  1,  1,  1, 0.63000000e+01, 0.99820000e+00, 0.00000000e+00},
    {  9,  2,  0,  0, 0.38825000e+01, 0.00000000e+00, 0.00000000e+00},
    {  9,  2,  1,  0, 0.33077000e+01, 0.99820000e+00, 0.00000000e+00},
    {  9,  3,  0,  0, 0.55093300e+02, 0.00000000e+00, 0.00000000e+00},
    {  9,  3,  0,  1, 0.21760500e+02, 0.00000000e+00, 0.98650000e+00},
    {  9,  3,  1,  0, 0.42062700e+02, 0.99820000e+00, 0.00000000e+00},
    {  9,  3,  1,  1, 0.17173300e+02, 0.99820000e+00, 0.98650000e+00},
    {  9,  4,  0,  0, 0.36745300e+02, 0.00000000e+00, 0.00000000e+00},
    {  9,  4,  0,  1, 0.28409800e+02, 0.00000000e+00, 0.98080000e+00},
    {  9,  4,  0,  2, 0.20208300e+02, 0.00000000e+00, 0.19697000e+01},
    {  9,  4,  1,  0, 0.28861500e+02, 0.99820000e+00, 0.00000000e+00},
    {  9,  4,  1,  1, 0.22541300e+02, 0.99820000e+00, 0.98080000e+00},
    {  9,  4,  1,  2, 0.16318500e+02, 0.99820000e+00, 0.19697000e+01},
    {  9,  5,  0,  0, 0.27482100e+02, 0.00000000e+00, 0.00000000e+00},
    {  9,  5,  0,  1, 0.23736900e+02, 0.00000000e+00, 0.97060000e+00},
    {  9,  5,  0,  2, 0.20459200e+02, 0.00000000e+00, 0.19441000e+01},
    {  9,  5,  0,  3, 0.16460700e+02, 0.00000000e+00, 0.29128000e+01},
    {  9,  5,  0,  4, 0.15657800e+02, 0.00000000e+00, 0.45856000e+01},
    {  9,  5,  1,  0, 0.22093100e+02, 0.99820000e+00, 0.00000000e+00},
    {  9,  5,  1,  1, 0.19202900e+02, 0.99820000e+00, 0.97060000e+00},
    {  9,  5,  1,  2, 0.16653100e+02, 0.99820000e+00, 0.19441000e+01},
    {  9,  5,  1,  3, 0.13558100e+02, 0.99820000e+00, 0.29128000e+01},
    {  9,  5,  1,  4, 0.12929100e+02, 0.99820000e+00, 0.45856000e+01},
    {  9,  6,  0,  0, 0.20282700e+02, 0.00000000e+00, 0.00000000e+00},
    {  9,  6,  0,  1, 0.19097400e+02, 0.00000000e+00, 0.98680000e+00},
    {  9,  6,  0,  2, 0.16131200e+02, 0.00000000e+00, 0.19985000e+01},
    {  9,  6,  0,  3, 0.15188300e+02, 0.00000000e+00, 0.29987000e+01},
    {  9,  6,  0,  4, 0.13054600e+02, 0.00000000e+00, 0.39844000e+01},
    {  9,  6,  1,  0, 0.16637300e+02, 0.99820000e+00, 0.00000000e+00},
    {  9,  6,  1,  1, 0.15685700e+02, 0.99820000e+00, 0.98680000e+00},
    {  9,  6,  1,  2, 0.13352900e+02, 0.99820000e+00, 0.19985000e+01},
    {  9,  6,  1,  3, 0.12597000e+02, 0.99820000e+00, 0.29987000e+01},
    {  9,  6,  1,  4, 0.10939100e+02, 0.99820000e+00, 0.39844000e+01},
    {  9,  7,  0,  0, 0.15241800e+02, 0.00000000e+00, 0.00000000e+00},
    {  9,  7,  0,  1, 0.14301500e+02, 0.00000000e+00, 0.99440000e+00},
    {  9,  7,  0,  2, 0.13561300e+02, 0.00000000e+00, 0.20143000e+01},
    {  9,  7,  0,  3, 0.12151100e+02, 0.00000000e+00, 0.29903000e+01},
    {  9,  7,  1,  0, 0.12710700e+02, 0.99820000e+00, 0.00000000e+00},
    {  9,  7,  1,  1, 0.11947000e+02, 0.99820000e+00, 0.99440000e+00},
    {  9,  7,  1,  2, 0.11357100e+02, 0.99820000e+00, 0.20143000e+01},
    {  9,  7,  1,  3, 0.10221400e+02, 0.99820000e+00, 0.29903000e+01},
    {  9,  8,  0,  0, 0.12183400e+02, 0.00000000e+00, 0.00000000e+00},
    {  9,  8,  0,  1, 0.11099400e+02, 0.00000000e+00, 0.99250000e+00},
    {  9,  8,  0,  2, 0.10022200e+02, 0.00000000e+00, 0.19887000e+01},
    {  9,  8,  1,  0, 0.10286700e+02, 0.99820000e+00, 0.00000000e+00},
    {  9,  8,  1,  1, 0.94048000e+01, 0.99820000e+00, 0.99250000e+00},
    {  9,  8,  1,  2, 0.85397000e+01, 0.99820000e+00, 0.19887000e+01},
    {  9,  9,  0,  0, 0.96916000e+01, 0.00000000e+00, 0.00000000e+00},
    {  9,  9,  1,  0, 0.82739000e+01, 0.99820000e+00, 0.00000000e+00},
    {  9,  9,  1,  1, 0.71341000e+01, 0.99820000e+00, 0.99820000e+00},
    { 10,  1,  0,  0, 0.40112000e+01, 0.00000000e+00, 0.91180000e+00},
    { 10,  1,  0,  1, 0.59403000e+01, 0.00000000e+00, 0.00000000e+00},
    { 10,  2,  0,  0, 0.31025000e+01, 0.00000000e+00, 0.00000000e+00},
    { 10,  3,  0,  0, 0.40473100e+02, 0.00000000e+00, 0.00000000e+00},
    { 10,  3,  0,  1, 0.16338800e+02, 0.00000000e+00, 0.98650000e+00},
    { 10,  4,  0,  0, 0.27486700e+02, 0.00000000e+00, 0.00000000e+00},
    { 10,  4,  0,  1, 0.21406700e+02, 0.00000000e+00, 0.98080000e+00},
    { 10,  4,  0,  2, 0.15417600e+02, 0.00000000e+00, 0.19697000e+01},
    { 10,  5,  0,  0, 0.20902200e+02, 0.00000000e+00, 0.00000000e+00},
    { 10,  5,  0,  1, 0.18142400e+02, 0.00000000e+00, 0.97060000e+00},
    { 10,  5,  0,  2, 0.15712700e+02, 0.00000000e+00, 0.19441000e+01},
    { 10,  5,  0,  3, 0.12757700e+02, 0.00000000e+00, 0.29128000e+01},
    { 10,  5,  0,  4, 0.12160800e+02, 0.00000000e+00, 0.45856000e+01},
    { 10,  6,  0,  0, 0.15674000e+02, 0.00000000e+00, 0.00000000e+00},
    { 10,  6,  0,  1, 0.14771600e+02, 0.00000000e+00, 0.98680000e+00},
    { 10,  6,  0,  2, 0.12562900e+02, 0.00000000e+00, 0.19985000e+01},
    { 10,  6,  0,  3, 0.11851300e+02, 0.00000000e+00, 0.29987000e+01},
    { 10,  6,  0,  4, 0.10271600e+02, 0.00000000e+00, 0.39844000e+01},
    { 10,  7,  0,  0, 0.11947900e+02, 0.00000000e+00, 0.00000000e+00},
    { 10,  7,  0,  1, 0.11224300e+02, 0.00000000e+00, 0.99440000e+00},
    { 10,  7,  0,  2, 0.10674000e+02, 0.00000000e+00, 0.20143000e+01},
    { 10,  7,  0,  3, 0.96050000e+01, 0.00000000e+00, 0.29903000e+01},
    { 10,  8,  0,  0, 0.96606000e+01, 0.00000000e+00, 0.00000000e+00},
    { 10,  8,  0,  1, 0.88252000e+01, 0.00000000e+00, 0.99250000e+00},
    { 10,  8,  0,  2, 0.80175000e+01, 0.00000000e+00, 0.19887000e+01},
    { 10,  9,  0,  0, 0.77691000e+01, 0.00000000e+00, 0.00000000e+00},
    { 10,  9,  0,  1, 0.66950000e+01, 0.00000000e+00, 0.99820000e+00},
    { 10, 10,  0,  0, 0.62896000e+01, 0.00000000e+00, 0.00000000e+00},
    { 11,  1,  0,  0, 0.46823200e+02, 0.00000000e+00, 0.91180000e+00},
    { 11,  1,  0,  1, 0.82564100e+02, 0.00000000e+00, 0.00000000e+00},
    { 11,  1,  1,  0, 0.20756700e+02, 0.96840000e+00, 0.91180000e+00},
    { 11,  1,  1,  1, 0.34995200e+02, 0.96840000e+00, 0.00000000e+00},
    { 11,  2,  0,  0, 0.26862800e+02, 0.00000000e+00, 0.00000000e+00},
    { 11,  2,  1,  0, 0.12728700e+02, 0.96840000e+00, 0.00000000e+00},
    { 11,  3,  0,  0, 0.13673272e+04, 0.00000000e+00, 0.00000000e+00},
    { 11,  3,  0,  1, 0.33534500e+03, 0.00000000e+00, 0.98650000e+00},
    { 11,  3,  1,  0, 0.42571610e+03, 0.96840000e+00, 0.00000000e+00},
    { 11,  3,  1,  1, 0.12582450e+03, 0.96840000e+00, 0.98650000e+00},
    { 11,  4,  0,  0, 0.58745630e+03, 0.00000000e+00, 0.00000000e+00},
    { 11,  4,  0,  1, 0.41864880e+03, 0.00000000e+00, 0.98080000e+00},
    { 11,  4,  0,  2, 0.23280600e+03, 0.00000000e+00, 0.19697000e+01},
    { 11,  4,  1,  0, 0.21865720e+03, 0.96840000e+00, 0.00000000e+00},
    { 11,  4,  1,  1, 0.15832680e+03, 0.96840000e+00, 0.98080000e+00},
    { 11,  4,  1,  2, 0.96512500e+02, 0.96840000e+00, 0.19697000e+01},
    { 11,  5,  0,  0, 0.33872120e+03, 0.00000000e+00, 0.00000000e+00},
    { 11,  5,  0,  1, 0.27656710e+03, 0.00000000e+00, 0.97060000e+00},
    { 11,  5,  0,  2, 0.22578430e+03, 0.00000000e+00, 0.19441000e+01},
    { 11,  5,  0,  3, 0.15611380e+03, 0.00000000e+00, 0.29128000e+01},
    { 11,  5,  0,  4, 0.14500200e+03, 0.00000000e+00, 0.45856000e+01},
    { 11,  5,  1,  0, 0.13695360e+03, 0.96840000e+00, 0.00000000e+00},
    { 11,  5,  1,  1, 0.11340160e+03, 0.96840000e+00, 0.97060000e+00},
    { 11,  5,  1,  2, 0.93715900e+02, 0.96840000e+00, 0.19441000e+01},
    { 11,  5,  1,  3, 0.68275500e+02, 0.96840000e+00, 0.29128000e+01},
    { 11,  5,  1,  4, 0.63812300e+02, 0.96840000e+00, 0.45856000e+01},
    { 11,  6,  0,  0, 0.20376310e+03, 0.00000000e+00, 0.00000000e+00},
    { 11,  6,  0,  1, 0.19237290e+03, 0.00000000e+00, 0.98680000e+00},
    { 11,  6,  0,  2, 0.14876180e+03, 0.00000000e+00, 0.19985000e+01},
    { 11,  6,  0,  3, 0.13937530e+03, 0.00000000e+00, 0.29987000e+01},
    { 11,  6,  0,  4, 0.10592480e+03, 0.00000000e+00, 0.39844000e+01},
    { 11,  6,  1,  0, 0.87395600e+02, 0.96840000e+00, 0.00000000e+00},
    { 11,  6,  1,  1, 0.82014400e+02, 0.96840000e+00, 0.98680000e+00},
    { 11,  6,  1,  2, 0.65273900e+02, 0.96840000e+00, 0.19985000e+01},
    { 11,  6,  1,  3, 0.61017400e+02, 0.96840000e+00, 0.29987000e+01},
    { 11,  6,  1,  4, 0.48162200e+02, 0.96840000e+00, 0.39844000e+01},
    { 11,  7,  0,  0, 0.13065630e+03, 0.00000000e+00, 0.00000000e+00},
    { 11,  7,  0,  1, 0.12196010e+03, 0.00000000e+00, 0.99440000e+00},
    { 11,  7,  0,  2, 0.11330310e+03, 0.00000000e+00, 0.20143000e+01},
    { 11,  7,  0,  3, 0.98880600e+02, 0.00000000e+00, 0.29903000e+01},
    { 11,  7,  1,  0, 0.58485300e+02, 0.96840000e+00, 0.00000000e+00},
    { 11,  7,  1,  1, 0.54445400e+02, 0.96840000e+00, 0.99440000e+00},
    { 11,  7,  1,  2, 0.50867200e+02, 0.96840000e+00, 0.20143000e+01},
    { 11,  7,  1,  3, 0.44492400e+02, 0.96840000e+00, 0.29903000e+01},
    { 11,  8,  0,  0, 0.93026300e+02, 0.00000000e+00, 0.00000000e+00},
    { 11,  8,  0,  1, 0.82182000e+02, 0.00000000e+00, 0.99250000e+00},
    { 11,  8,  0,  2, 0.71099900e+02, 0.00000000e+00, 0.19887000e+01},
    { 11,  8,  1,  0, 0.42891100e+02, 0.96840000e+00, 0.00000000e+00},
    { 11,  8,  1,  1, 0.38122700e+02, 0.96840000e+00, 0.99250000e+00},
    { 11,  8,  1,  2, 0.33263600e+02, 0.96840000e+00, 0.19887000e+01},
    { 11,  9,  0,  0, 0.66842300e+02, 0.00000000e+00, 0.00000000e+00},
    { 11,  9,  0,  1, 0.51249800e+02, 0.00000000e+00, 0.99820000e+00},
    { 11,  9,  1,  0, 0.31606000e+02, 0.96840000e+00, 0.00000000e+00},
    { 11,  9,  1,  1, 0.24956000e+02, 0.96840000e+00, 0.99820000e+00},
    { 11, 10,  0,  0, 0.49279900e+02, 0.00000000e+00, 0.00000000e+00},
    { 11, 10,  1,  0, 0.23774500e+02, 0.96840000e+00, 0.00000000e+00},
    { 11, 11,  0,  0, 0.16080286e+04, 0.00000000e+00, 0.00000000e+00},
    { 11, 11,  1,  0, 0.50543630e+03, 0.96840000e+00, 0.00000000e+00},
    { 11, 11,  1,  1, 0.18610520e+03, 0.96840000e+00, 0.96840000e+00},
    { 12,  1,  0,  0, 0.38353100e+02, 0.00000000e+00, 0.91180000e+00},
    { 12,  1,  0,  1, 0.65370300e+02, 0.00000000e+00, 0.00000000e+00},
    { 12,  1,  1,  0, 0.31991300e+02, 0.96280000e+00, 0.91180000e+00},
    { 12,  1,  1,  1, 0.54102100e+02, 0.96280000e+00, 0.00000000e+00},
    { 12,  1,  2,  0, 0.21837000e+02, 0.19496000e+01, 0.91180000e+00},
    { 12,  1,  2,  1, 0.35919000e+02, 0.19496000e+01, 0.00000000e+00},
    { 12,  2,  0,  0, 0.23032000e+02, 0.00000000e+00, 0.00000000e+00},
    { 12,  2,  1,  0, 0.19464800e+02, 0.96280000e+00, 0.00000000e+00},
    { 12,  2,  2,  0, 0.13849600e+02, 0.19496000e+01, 0.00000000e+00},
    { 12,  3,  0,  0, 0.83081560e+03, 0.00000000e+00, 0.00000000e+00},
    { 12,  3,  0,  1, 0.24016270e+03, 0.00000000e+00, 0.98650000e+00},
    { 12,  3,  1,  0, 0.67003300e+03, 0.96280000e+00, 0.00000000e+00},
    { 12,  3,  1,  1, 0.19570570e+03, 0.96280000e+00, 0.98650000e+00},
    { 12,  3,  2,  0, 0.37081900e+03, 0.19496000e+01, 0.00000000e+00},
    { 12,  3,  2,  1, 0.12078080e+03, 0.19496000e+01, 0.98650000e+00},
    { 12,  4,  0,  0, 0.41821640e+03, 0.00000000e+00, 0.00000000e+00},
    { 12,  4,  0,  1, 0.30137770e+03, 0.00000000e+00, 0.98080000e+00},
    { 12,  4,  0,  2, 0.18116530e+03, 0.00000000e+00, 0.19697000e+01},
    { 12,  4,  1,  0, 0.34026020e+03, 0.96280000e+00, 0.00000000e+00},
    { 12,  4,  1,  1, 0.24622270e+03, 0.96280000e+00, 0.98080000e+00},
    { 12,  4,  1,  2, 0.14938320e+03, 0.96280000e+00, 0.19697000e+01},
    { 12,  4,  2,  0, 0.20867690e+03, 0.19496000e+01, 0.00000000e+00},
    { 12,  4,  2,  1, 0.15315750e+03, 0.19496000e+01, 0.98080000e+00},
    { 12,  4,  2,  2, 0.97810100e+02, 0.19496000e+01, 0.19697000e+01},
    { 12,  5,  0,  0, 0.25813030e+03, 0.00000000e+00, 0.00000000e+00},
    { 12,  5,  0,  1, 0.21299790e+03, 0.00000000e+00, 0.97060000e+00},
    { 12,  5,  0,  2, 0.17539140e+03, 0.00000000e+00, 0.19441000e+01},
    { 12,  5,  0,  3, 0.12654250e+03, 0.00000000e+00, 0.29128000e+01},
    { 12,  5,  0,  4, 0.11807480e+03, 0.00000000e+00, 0.45856000e+01},
    { 12,  5,  1,  0, 0.21221800e+03, 0.96280000e+00, 0.00000000e+00},
    { 12,  5,  1,  1, 0.17556460e+03, 0.96280000e+00, 0.97060000e+00},
    { 12,  5,  1,  2, 0.14497830e+03, 0.96280000e+00, 0.19441000e+01},
    { 12,  5,  1,  3, 0.10530540e+03, 0.96280000e+00, 0.29128000e+01},
    { 12,  5,  1,  4, 0.98372400e+02, 0.96280000e+00, 0.45856000e+01},
    { 12,  5,  2,  0, 0.13699320e+03, 0.19496000e+01, 0.00000000e+00},
    { 12,  5,  2,  1, 0.11441900e+03, 0.19496000e+01, 0.97060000e+00},
    { 12,  5,  2,  2, 0.95357500e+02, 0.19496000e+01, 0.19441000e+01},
    { 12,  5,  2,  3, 0.71302300e+02, 0.19496000e+01, 0.29128000e+01},
    { 12,  5,  2,  4, 0.66869600e+02, 0.19496000e+01, 0.45856000e+01},
    { 12,  6,  0,  0, 0.16260820e+03, 0.00000000e+00, 0.00000000e+00},
    { 12,  6,  0,  1, 0.15261300e+03, 0.00000000e+00, 0.98680000e+00},
    { 12,  6,  0,  2, 0.12073860e+03, 0.00000000e+00, 0.19985000e+01},
    { 12,  6,  0,  3, 0.11282100e+03, 0.00000000e+00, 0.29987000e+01},
    { 12,  6,  0,  4, 0.88262000e+02, 0.00000000e+00, 0.39844000e+01},
    { 12,  6,  1,  0, 0.13492270e+03, 0.96280000e+00, 0.00000000e+00},
    { 12,  6,  1,  1, 0.12666570e+03, 0.96280000e+00, 0.98680000e+00},
    { 12,  6,  1,  2, 0.10058170e+03, 0.96280000e+00, 0.19985000e+01},
    { 12,  6,  1,  3, 0.93997800e+02, 0.96280000e+00, 0.29987000e+01},
    { 12,  6,  1,  4, 0.74002800e+02, 0.96280000e+00, 0.39844000e+01},
    { 12,  6,  2,  0, 0.90330500e+02, 0.19496000e+01, 0.00000000e+00},
    { 12,  6,  2,  1, 0.84617800e+02, 0.19496000e+01, 0.98680000e+00},
    { 12,  6,  2,  2, 0.68298400e+02, 0.19496000e+01, 0.19985000e+01},
    { 12,  6,  2,  3, 0.63794400e+02, 0.19496000e+01, 0.29987000e+01},
    { 12,  6,  2,  4, 0.51352500e+02, 0.19496000e+01, 0.39844000e+01},
    { 12,  7,  0,  0, 0.10761500e+03, 0.00000000e+00, 0.00000000e+00},
    { 12,  7,  0,  1, 0.10014430e+03, 0.00000000e+00, 0.99440000e+00},
    { 12,  7,  0,  2, 0.93413000e+02, 0.00000000e+00, 0.20143000e+01},
    { 12,  7,  0,  3, 0.81535200e+02, 0.00000000e+00, 0.29903000e+01},
    { 12,  7,  1,  0, 0.89964600e+02, 0.96280000e+00, 0.00000000e+00},
    { 12,  7,  1,  1, 0.83770300e+02, 0.96280000e+00, 0.99440000e+00},
    { 12,  7,  1,  2, 0.78176000e+02, 0.96280000e+00, 0.20143000e+01},
    { 12,  7,  1,  3, 0.68314100e+02, 0.96280000e+00, 0.29903000e+01},
    { 12,  7,  2,  0, 0.61837200e+02, 0.19496000e+01, 0.00000000e+00},
    { 12,  7,  2,  1, 0.57539800e+02, 0.19496000e+01, 0.99440000e+00},
    { 12,  7,  2,  2, 0.53880300e+02, 0.19496000e+01, 0.20143000e+01},
    { 12,  7,  2,  3, 0.47205900e+02, 0.19496000e+01, 0.29903000e+01},
    { 12,  8,  0,  0, 0.78225000e+02, 0.00000000e+00, 0.00000000e+00},
    { 12,  8,  0,  1, 0.69367500e+02, 0.00000000e+00, 0.99250000e+00},
    { 12,  8,  0,  2, 0.60298300e+02, 0.00000000e+00, 0.19887000e+01},
    { 12,  8,  1,  0, 0.65760900e+02, 0.96280000e+00, 0.00000000e+00},
    { 12,  8,  1,  1, 0.58430300e+02, 0.96280000e+00, 0.99250000e+00},
    { 12,  8,  1,  2, 0.50866900e+02, 0.96280000e+00, 0.19887000e+01},
    { 12,  8,  2,  0, 0.46034700e+02, 0.19496000e+01, 0.00000000e+00},
    { 12,  8,  2,  1, 0.41060500e+02, 0.19496000e+01, 0.99250000e+00},
    { 12,  8,  2,  2, 0.35966500e+02, 0.19496000e+01, 0.19887000e+01},
    { 12,  9,  0,  0, 0.57160500e+02, 0.00000000e+00, 0.00000000e+00},
    { 12,  9,  0,  1, 0.44714100e+02, 0.00000000e+00, 0.99820000e+00},
    { 12,  9,  1,  0, 0.48286500e+02, 0.96280000e+00, 0.00000000e+00},
    { 12,  9,  1,  1, 0.37988400e+02, 0.96280000e+00, 0.99820000e+00},
    { 12,  9,  2,  0, 0.34331400e+02, 0.19496000e+01, 0.00000000e+00},
    { 12,  9,  2,  1, 0.27484100e+02, 0.19496000e+01, 0.99820000e+00},
    { 12, 10,  0,  0, 0.42677100e+02, 0.00000000e+00, 0.00000000e+00},
    { 12, 10,  1,  0, 0.36191100e+02, 0.96280000e+00, 0.00000000e+00},
    { 12, 10,  2,  0, 0.26053300e+02, 0.19496000e+01, 0.00000000e+00},
    { 12, 11,  0,  0, 0.98516970e+03, 0.00000000e+00, 0.00000000e+00},
    { 12, 11,  0,  1, 0.35591800e+03, 0.00000000e+00, 0.96840000e+00},
    { 12, 11,  1,  0, 0.79475970e+03, 0.96280000e+00, 0.00000000e+00},
    { 12, 11,  1,  1, 0.28960820e+03, 0.96280000e+00, 0.96840000e+00},
    { 12, 11,  2,  0, 0.44240190e+03, 0.19496000e+01, 0.00000000e+00},
    { 12, 11,  2,  1, 0.17686830e+03, 0.19496000e+01, 0.96840000e+00},
    { 12, 12,  0,  0, 0.68337580e+03, 0.00000000e+00, 0.00000000e+00},
    { 12, 12,  1,  0, 0.55459670e+03, 0.96280000e+00, 0.00000000e+00},
    { 12, 12,  1,  1, 0.45127080e+03, 0.96280000e+00, 0.96280000e+00},
    { 12, 12,  2,  0, 0.33424930e+03, 0.19496000e+01, 0.00000000e+00},
    { 12, 12,  2,  1, 0.27415900e+03, 0.19496000e+01, 0.96280000e+00},
    { 12, 12,  2,  2, 0.17556160e+03, 0.19496000e+01, 0.19496000e+01},
    { 13,  1,  0,  0, 0.36290900e+02, 0.00000000e+00, 0.91180000e+00},
    { 13,  1,  0,  1, 0.60855800e+02, 0.00000000e+00, 0.00000000e+00},
    { 13,  1,  1,  0, 0.33104800e+02, 0.96480000e+00, 0.91180000e+00},
    { 13,  1,  1,  1, 0.55263600e+02, 0.96480000e+00, 0.00000000e+00},
    { 13,  1,  2,  0, 0.26352400e+02, 0.19311000e+01, 0.91180000e+00},
    { 13,  1,  2,  1, 0.43366100e+02, 0.19311000e+01, 0.00000000e+00},
    { 13,  1,  3,  0, 0.21058400e+02, 0.29146000e+01, 0.91180000e+00},
    { 13,  1,  3,  1, 0.34070000e+02, 0.29146000e+01, 0.00000000e+00},
    { 13,  2,  0,  0, 0.22322400e+02, 0.00000000e+00, 0.00000000e+00},
    { 13,  2,  1,  0, 0.20515800e+02, 0.96480000e+00, 0.00000000e+00},
    { 13,  2,  2,  0, 0.16703100e+02, 0.19311000e+01, 0.00000000e+00},
    { 13,  2,  3,  0, 0.13698200e+02, 0.29146000e+01, 0.00000000e+00},
    { 13,  3,  0,  0, 0.70582540e+03, 0.00000000e+00, 0.00000000e+00},
    { 13,  3,  0,  1, 0.21472650e+03, 0.00000000e+00, 0.98650000e+00},
    { 13,  3,  1,  0, 0.62753090e+03, 0.96480000e+00, 0.00000000e+00},
    { 13,  3,  1,  1, 0.19307070e+03, 0.96480000e+00, 0.98650000e+00},
    { 13,  3,  2,  0, 0.45636130e+03, 0.19311000e+01, 0.00000000e+00},
    { 13,  3,  2,  1, 0.14644260e+03, 0.19311000e+01, 0.98650000e+00},
    { 13,  3,  3,  0, 0.32279250e+03, 0.29146000e+01, 0.00000000e+00},
    { 13,  3,  3,  1, 0.11021360e+03, 0.29146000e+01, 0.98650000e+00},
    { 13,  4,  0,  0, 0.37263020e+03, 0.00000000e+00, 0.00000000e+00},
    { 13,  4,  0,  1, 0.27074610e+03, 0.00000000e+00, 0.98080000e+00},
    { 13,  4,  0,  2, 0.16729290e+03, 0.00000000e+00, 0.19697000e+01},
    { 13,  4,  1,  0, 0.33473350e+03, 0.96480000e+00, 0.00000000e+00},
    { 13,  4,  1,  1, 0.24376120e+03, 0.96480000e+00, 0.98080000e+00},
    { 13,  4,  1,  2, 0.15159310e+03, 0.96480000e+00, 0.19697000e+01},
    { 13,  4,  2,  0, 0.25306490e+03, 0.19311000e+01, 0.00000000e+00},
    { 13,  4,  2,  1, 0.18573100e+03, 0.19311000e+01, 0.98080000e+00},
    { 13,  4,  2,  2, 0.11812330e+03, 0.19311000e+01, 0.19697000e+01},
    { 13,  4,  3,  0, 0.18966050e+03, 0.29146000e+01, 0.00000000e+00},
    { 13,  4,  3,  1, 0.14056320e+03, 0.29146000e+01, 0.98080000e+00},
    { 13,  4,  3,  2, 0.92012600e+02, 0.29146000e+01, 0.19697000e+01},
    { 13,  5,  0,  0, 0.23647800e+03, 0.00000000e+00, 0.00000000e+00},
    { 13,  5,  0,  1, 0.19620140e+03, 0.00000000e+00, 0.97060000e+00},
    { 13,  5,  0,  2, 0.16244730e+03, 0.00000000e+00, 0.19441000e+01},
    { 13,  5,  0,  3, 0.11915450e+03, 0.00000000e+00, 0.29128000e+01},
    { 13,  5,  0,  4, 0.11143770e+03, 0.00000000e+00, 0.45856000e+01},
    { 13,  5,  1,  0, 0.21388480e+03, 0.96480000e+00, 0.00000000e+00},
    { 13,  5,  1,  1, 0.17772540e+03, 0.96480000e+00, 0.97060000e+00},
    { 13,  5,  1,  2, 0.14737660e+03, 0.96480000e+00, 0.19441000e+01},
    { 13,  5,  1,  3, 0.10855170e+03, 0.96480000e+00, 0.29128000e+01},
    { 13,  5,  1,  4, 0.10158890e+03, 0.96480000e+00, 0.45856000e+01},
    { 13,  5,  2,  0, 0.16559380e+03, 0.19311000e+01, 0.00000000e+00},
    { 13,  5,  2,  1, 0.13828380e+03, 0.19311000e+01, 0.97060000e+00},
    { 13,  5,  2,  2, 0.11524800e+03, 0.19311000e+01, 0.19441000e+01},
    { 13,  5,  2,  3, 0.86053200e+02, 0.19311000e+01, 0.29128000e+01},
    { 13,  5,  2,  4, 0.80700500e+02, 0.19311000e+01, 0.45856000e+01},
    { 13,  5,  3,  0, 0.12796450e+03, 0.29146000e+01, 0.00000000e+00},
    { 13,  5,  3,  1, 0.10751580e+03, 0.29146000e+01, 0.97060000e+00},
    { 13,  5,  3,  2, 0.90144000e+02, 0.29146000e+01, 0.19441000e+01},
    { 13,  5,  3,  3, 0.68433000e+02, 0.29146000e+01, 0.29128000e+01},
    { 13,  5,  3,  4, 0.64333200e+02, 0.29146000e+01, 0.45856000e+01},
    { 13,  6,  0,  0, 0.15209340e+03, 0.00000000e+00, 0.00000000e+00},
    { 13,  6,  0,  1, 0.14260940e+03, 0.00000000e+00, 0.98680000e+00},
    { 13,  6,  0,  2, 0.11385600e+03, 0.00000000e+00, 0.19985000e+01},
    { 13,  6,  0,  3, 0.10635080e+03, 0.00000000e+00, 0.29987000e+01},
    { 13,  6,  0,  4, 0.84307300e+02, 0.00000000e+00, 0.39844000e+01},
    { 13,  6,  1,  0, 0.13832540e+03, 0.96480000e+00, 0.00000000e+00},
    { 13,  6,  1,  1, 0.12969220e+03, 0.96480000e+00, 0.98680000e+00},
    { 13,  6,  1,  2, 0.10379070e+03, 0.96480000e+00, 0.19985000e+01},
    { 13,  6,  1,  3, 0.96956000e+02, 0.96480000e+00, 0.29987000e+01},
    { 13,  6,  1,  4, 0.77136200e+02, 0.96480000e+00, 0.39844000e+01},
    { 13,  6,  2,  0, 0.10905410e+03, 0.19311000e+01, 0.00000000e+00},
    { 13,  6,  2,  1, 0.10220950e+03, 0.19311000e+01, 0.98680000e+00},
    { 13,  6,  2,  2, 0.82430300e+02, 0.19311000e+01, 0.19985000e+01},
    { 13,  6,  2,  3, 0.77008700e+02, 0.19311000e+01, 0.29987000e+01},
    { 13,  6,  2,  4, 0.61961000e+02, 0.19311000e+01, 0.39844000e+01},
    { 13,  6,  3,  0, 0.86160500e+02, 0.29146000e+01, 0.00000000e+00},
    { 13,  6,  3,  1, 0.80711100e+02, 0.29146000e+01, 0.98680000e+00},
    { 13,  6,  3,  2, 0.65696800e+02, 0.29146000e+01, 0.19985000e+01},
    { 13,  6,  3,  3, 0.61382900e+02, 0.29146000e+01, 0.29987000e+01},
    { 13,  6,  3,  4, 0.50039700e+02, 0.29146000e+01, 0.39844000e+01},
    { 13,  7,  0,  0, 0.10220000e+03, 0.00000000e+00, 0.00000000e+00},
    { 13,  7,  0,  1, 0.95091600e+02, 0.00000000e+00, 0.99440000e+00},
    { 13,  7,  0,  2, 0.88840700e+02, 0.00000000e+00, 0.20143000e+01},
    { 13,  7,  0,  3, 0.77652000e+02, 0.00000000e+00, 0.29903000e+01},
    { 13,  7,  1,  0, 0.93354200e+02, 0.96480000e+00, 0.00000000e+00},
    { 13,  7,  1,  1, 0.86872800e+02, 0.96480000e+00, 0.99440000e+00},
    { 13,  7,  1,  2, 0.81202600e+02, 0.96480000e+00, 0.20143000e+01},
    { 13,  7,  1,  3, 0.71023100e+02, 0.96480000e+00, 0.29903000e+01},
    { 13,  7,  2,  0, 0.74611700e+02, 0.19311000e+01, 0.00000000e+00},
    { 13,  7,  2,  1, 0.69450100e+02, 0.19311000e+01, 0.99440000e+00},
    { 13,  7,  2,  2, 0.65016400e+02, 0.19311000e+01, 0.20143000e+01},
    { 13,  7,  2,  3, 0.56971300e+02, 0.19311000e+01, 0.29903000e+01},
    { 13,  7,  3,  0, 0.59907400e+02, 0.29146000e+01, 0.00000000e+00},
    { 13,  7,  3,  1, 0.55779300e+02, 0.29146000e+01, 0.99440000e+00},
    { 13,  7,  3,  2, 0.52313600e+02, 0.29146000e+01, 0.20143000e+01},
    { 13,  7,  3,  3, 0.45939900e+02, 0.29146000e+01, 0.29903000e+01},
    { 13,  8,  0,  0, 0.75075500e+02, 0.00000000e+00, 0.00000000e+00},
    { 13,  8,  0,  1, 0.66745100e+02, 0.00000000e+00, 0.99250000e+00},
    { 13,  8,  0,  2, 0.58195100e+02, 0.00000000e+00, 0.19887000e+01},
    { 13,  8,  1,  0, 0.68798300e+02, 0.96480000e+00, 0.00000000e+00},
    { 13,  8,  1,  1, 0.61217500e+02, 0.96480000e+00, 0.99250000e+00},
    { 13,  8,  1,  2, 0.53436500e+02, 0.96480000e+00, 0.19887000e+01},
    { 13,  8,  2,  0, 0.55525000e+02, 0.19311000e+01, 0.00000000e+00},
    { 13,  8,  2,  1, 0.49531900e+02, 0.19311000e+01, 0.99250000e+00},
    { 13,  8,  2,  2, 0.43378800e+02, 0.19311000e+01, 0.19887000e+01},
    { 13,  8,  3,  0, 0.45087600e+02, 0.29146000e+01, 0.00000000e+00},
    { 13,  8,  3,  1, 0.40337400e+02, 0.29146000e+01, 0.99250000e+00},
    { 13,  8,  3,  2, 0.35460200e+02, 0.29146000e+01, 0.19887000e+01},
    { 13,  9,  0,  0, 0.55341200e+02, 0.00000000e+00, 0.00000000e+00},
    { 13,  9,  0,  1, 0.43736400e+02, 0.00000000e+00, 0.99820000e+00},
    { 13,  9,  1,  0, 0.50857700e+02, 0.96480000e+00, 0.00000000e+00},
    { 13,  9,  1,  1, 0.40322000e+02, 0.96480000e+00, 0.99820000e+00},
    { 13,  9,  2,  0, 0.41391400e+02, 0.19311000e+01, 0.00000000e+00},
    { 13,  9,  2,  1, 0.33126500e+02, 0.19311000e+01, 0.99820000e+00},
    { 13,  9,  3,  0, 0.33933400e+02, 0.29146000e+01, 0.00000000e+00},
    { 13,  9,  3,  1, 0.27443600e+02, 0.29146000e+01, 0.99820000e+00},
    { 13, 10,  0,  0, 0.41596600e+02, 0.00000000e+00, 0.00000000e+00},
    { 13, 10,  1,  0, 0.38315400e+02, 0.96480000e+00, 0.00000000e+00},
    { 13, 10,  2,  0, 0.31394400e+02, 0.19311000e+01, 0.00000000e+00},
    { 13, 10,  3,  0, 0.25933500e+02, 0.29146000e+01, 0.00000000e+00},
    { 13, 11,  0,  0, 0.83896480e+03, 0.00000000e+00, 0.00000000e+00},
    { 13, 11,  0,  1, 0.31645880e+03, 0.00000000e+00, 0.96840000e+00},
    { 13, 11,  1,  0, 0.74634190e+03, 0.96480000e+00, 0.00000000e+00},
    { 13, 11,  1,  1, 0.28422510e+03, 0.96480000e+00, 0.96840000e+00},
    { 13, 11,  2,  0, 0.54393780e+03, 0.19311000e+01, 0.00000000e+00},
    { 13, 11,  2,  1, 0.21467960e+03, 0.19311000e+01, 0.96840000e+00},
    { 13, 11,  3,  0, 0.38609800e+03, 0.29146000e+01, 0.00000000e+00},
    { 13, 11,  3,  1, 0.16065940e+03, 0.29146000e+01, 0.96840000e+00},
    { 13, 12,  0,  0, 0.60346890e+03, 0.00000000e+00, 0.00000000e+00},
    { 13, 12,  0,  1, 0.49208290e+03, 0.00000000e+00, 0.96280000e+00},
    { 13, 12,  0,  2, 0.30473370e+03, 0.00000000e+00, 0.19496000e+01},
    { 13, 12,  1,  0, 0.54102850e+03, 0.96480000e+00, 0.00000000e+00},
    { 13, 12,  1,  1, 0.44173220e+03, 0.96480000e+00, 0.96280000e+00},
    { 13, 12,  1,  2, 0.27526090e+03, 0.96480000e+00, 0.19496000e+01},
    { 13, 12,  2,  0, 0.40606870e+03, 0.19311000e+01, 0.00000000e+00},
    { 13, 12,  2,  1, 0.33305050e+03, 0.19311000e+01, 0.96280000e+00},
    { 13, 12,  2,  2, 0.21219710e+03, 0.19311000e+01, 0.19496000e+01},
    { 13, 12,  3,  0, 0.30133070e+03, 0.29146000e+01, 0.00000000e+00},
    { 13, 12,  3,  1, 0.24856920e+03, 0.29146000e+01, 0.96280000e+00},
    { 13, 12,  3,  2, 0.16311000e+03, 0.29146000e+01, 0.19496000e+01},
    { 13, 13,  0,  0, 0.54054060e+03, 0.00000000e+00, 0.00000000e+00},
    { 13, 13,  1,  0, 0.48623650e+03, 0.96480000e+00, 0.00000000e+00},
    { 13, 13,  1,  1, 0.43775750e+03, 0.96480000e+00, 0.96480000e+00},
    { 13, 13,  2,  0, 0.36938290e+03, 0.19311000e+01, 0.00000000e+00},
    { 13, 13,  2,  1, 0.33353410e+03, 0.19311000e+01, 0.96480000e+00},
    { 13, 13,  2,  2, 0.25674970e+03, 0.19311000e+01, 0.19311000e+01},
    { 13, 13,  3,  0, 0.27856390e+03, 0.29146000e+01, 0.00000000e+00},
    { 13, 13,  3,  1, 0.25249530e+03, 0.29146000e+01, 0.96480000e+00},
    { 13, 13,  3,  2, 0.19694110e+03, 0.29146000e+01, 0.19311000e+01},
    { 13, 13,  3,  3, 0.15359450e+03, 0.29146000e+01, 0.29146000e+01},
    { 14,  1,  0,  0, 0.29594700e+02, 0.00000000e+00, 0.91180000e+00},
    { 14,  1,  0,  1, 0.48518200e+02, 0.00000000e+00, 0.00000000e+00},
    { 14,  1,  1,  0, 0.27498900e+02, 0.95070000e+00, 0.91180000e+00},
    { 14,  1,  1,  1, 0.44903000e+02, 0.95070000e+00, 0.00000000e+00},
    { 14,  1,  2,  0, 0.25702100e+02, 0.19435000e+01, 0.91180000e+00},
    { 14,  1,  2,  1, 0.41822200e+02, 0.19435000e+01, 0.00000000e+00},
    { 14,  1,  3,  0, 0.24983300e+02, 0.29407000e+01, 0.91180000e+00},
    { 14,  1,  3,  1, 0.40697200e+02, 0.29407000e+01, 0.00000000e+00},
    { 14,  1,  4,  0, 0.21006400e+02, 0.38677000e+01, 0.91180000e+00},
    { 14,  1,  4,  1, 0.33712600e+02, 0.38677000e+01, 0.00000000e+00},
    { 14,  2,  0,  0, 0.18850000e+02, 0.00000000e+00, 0.00000000e+00},
    { 14,  2,  1,  0, 0.17635600e+02, 0.95070000e+00, 0.00000000e+00},
    { 14,  2,  2,  0, 0.16580600e+02, 0.19435000e+01, 0.00000000e+00},
    { 14,  2,  3,  0, 0.16110400e+02, 0.29407000e+01, 0.00000000e+00},
    { 14,  2,  4,  0, 0.13854700e+02, 0.38677000e+01, 0.00000000e+00},
    { 14,  3,  0,  0, 0.49534490e+03, 0.00000000e+00, 0.00000000e+00},
    { 14,  3,  0,  1, 0.16205080e+03, 0.00000000e+00, 0.98650000e+00},
    { 14,  3,  1,  0, 0.45095830e+03, 0.95070000e+00, 0.00000000e+00},
    { 14,  3,  1,  1, 0.14874780e+03, 0.95070000e+00, 0.98650000e+00},
    { 14,  3,  2,  0, 0.41243230e+03, 0.19435000e+01, 0.00000000e+00},
    { 14,  3,  2,  1, 0.13744580e+03, 0.19435000e+01, 0.98650000e+00},
    { 14,  3,  3,  0, 0.40808020e+03, 0.29407000e+01, 0.00000000e+00},
    { 14,  3,  3,  1, 0.13444900e+03, 0.29407000e+01, 0.98650000e+00},
    { 14,  3,  4,  0, 0.30879530e+03, 0.38677000e+01, 0.00000000e+00},
    { 14,  3,  4,  1, 0.10727210e+03, 0.38677000e+01, 0.98650000e+00},
    { 14,  4,  0,  0, 0.27978630e+03, 0.00000000e+00, 0.00000000e+00},
    { 14,  4,  0,  1, 0.20575440e+03, 0.00000000e+00, 0.98080000e+00},
    { 14,  4,  0,  2, 0.13189200e+03, 0.00000000e+00, 0.19697000e+01},
    { 14,  4,  1,  0, 0.25658810e+03, 0.95070000e+00, 0.00000000e+00},
    { 14,  4,  1,  1, 0.18910900e+03, 0.95070000e+00, 0.98080000e+00},
    { 14,  4,  1,  2, 0.12183330e+03, 0.95070000e+00, 0.19697000e+01},
    { 14,  4,  2,  0, 0.23689910e+03, 0.19435000e+01, 0.00000000e+00},
    { 14,  4,  2,  1, 0.17493150e+03, 0.19435000e+01, 0.98080000e+00},
    { 14,  4,  2,  2, 0.11328200e+03, 0.19435000e+01, 0.19697000e+01},
    { 14,  4,  3,  0, 0.23182510e+03, 0.29407000e+01, 0.00000000e+00},
    { 14,  4,  3,  1, 0.17103980e+03, 0.29407000e+01, 0.98080000e+00},
    { 14,  4,  3,  2, 0.11031340e+03, 0.29407000e+01, 0.19697000e+01},
    { 14,  4,  4,  0, 0.18425660e+03, 0.38677000e+01, 0.00000000e+00},
    { 14,  4,  4,  1, 0.13717830e+03, 0.38677000e+01, 0.98080000e+00},
    { 14,  4,  4,  2, 0.90695600e+02, 0.38677000e+01, 0.19697000e+01},
    { 14,  5,  0,  0, 0.18451110e+03, 0.00000000e+00, 0.00000000e+00},
    { 14,  5,  0,  1, 0.15429010e+03, 0.00000000e+00, 0.97060000e+00},
    { 14,  5,  0,  2, 0.12874590e+03, 0.00000000e+00, 0.19441000e+01},
    { 14,  5,  0,  3, 0.96531300e+02, 0.00000000e+00, 0.29128000e+01},
    { 14,  5,  0,  4, 0.90574000e+02, 0.00000000e+00, 0.45856000e+01},
    { 14,  5,  1,  0, 0.17018910e+03, 0.95070000e+00, 0.00000000e+00},
    { 14,  5,  1,  1, 0.14251230e+03, 0.95070000e+00, 0.97060000e+00},
    { 14,  5,  1,  2, 0.11908890e+03, 0.95070000e+00, 0.19441000e+01},
    { 14,  5,  1,  3, 0.89594800e+02, 0.95070000e+00, 0.29128000e+01},
    { 14,  5,  1,  4, 0.84115800e+02, 0.95070000e+00, 0.45856000e+01},
    { 14,  5,  2,  0, 0.15801650e+03, 0.19435000e+01, 0.00000000e+00},
    { 14,  5,  2,  1, 0.13248310e+03, 0.19435000e+01, 0.97060000e+00},
    { 14,  5,  2,  2, 0.11084470e+03, 0.19435000e+01, 0.19441000e+01},
    { 14,  5,  2,  3, 0.83658600e+02, 0.19435000e+01, 0.29128000e+01},
    { 14,  5,  2,  4, 0.78583500e+02, 0.19435000e+01, 0.45856000e+01},
    { 14,  5,  3,  0, 0.15403880e+03, 0.29407000e+01, 0.00000000e+00},
    { 14,  5,  3,  1, 0.12908980e+03, 0.29407000e+01, 0.97060000e+00},
    { 14,  5,  3,  2, 0.10796470e+03, 0.29407000e+01, 0.19441000e+01},
    { 14,  5,  3,  3, 0.81347800e+02, 0.29407000e+01, 0.29128000e+01},
    { 14,  5,  3,  4, 0.76403800e+02, 0.29407000e+01, 0.45856000e+01},
    { 14,  5,  4,  0, 0.12577640e+03, 0.38677000e+01, 0.00000000e+00},
    { 14,  5,  4,  1, 0.10598260e+03, 0.38677000e+01, 0.97060000e+00},
    { 14,  5,  4,  2, 0.89119000e+02, 0.38677000e+01, 0.19441000e+01},
    { 14,  5,  4,  3, 0.68110600e+02, 0.38677000e+01, 0.29128000e+01},
    { 14,  5,  4,  4, 0.64108300e+02, 0.38677000e+01, 0.45856000e+01},
    { 14,  6,  0,  0, 0.12213870e+03, 0.00000000e+00, 0.00000000e+00},
    { 14,  6,  0,  1, 0.11444050e+03, 0.00000000e+00, 0.98680000e+00},
    { 14,  6,  0,  2, 0.92493100e+02, 0.00000000e+00, 0.19985000e+01},
    { 14,  6,  0,  3, 0.86399900e+02, 0.00000000e+00, 0.29987000e+01},
    { 14,  6,  0,  4, 0.69722400e+02, 0.00000000e+00, 0.39844000e+01},
    { 14,  6,  1,  0, 0.11320460e+03, 0.95070000e+00, 0.00000000e+00},
    { 14,  6,  1,  1, 0.10608060e+03, 0.95070000e+00, 0.98680000e+00},
    { 14,  6,  1,  2, 0.85906800e+02, 0.95070000e+00, 0.19985000e+01},
    { 14,  6,  1,  3, 0.80261800e+02, 0.95070000e+00, 0.29987000e+01},
    { 14,  6,  1,  4, 0.64967200e+02, 0.95070000e+00, 0.39844000e+01},
    { 14,  6,  2,  0, 0.10557130e+03, 0.19435000e+01, 0.00000000e+00},
    { 14,  6,  2,  1, 0.98927800e+02, 0.19435000e+01, 0.98680000e+00},
    { 14,  6,  2,  2, 0.80261900e+02, 0.19435000e+01, 0.19985000e+01},
    { 14,  6,  2,  3, 0.74996700e+02, 0.19435000e+01, 0.29987000e+01},
    { 14,  6,  2,  4, 0.60868700e+02, 0.19435000e+01, 0.39844000e+01},
    { 14,  6,  3,  0, 0.10272020e+03, 0.29407000e+01, 0.00000000e+00},
    { 14,  6,  3,  1, 0.96287200e+02, 0.29407000e+01, 0.98680000e+00},
    { 14,  6,  3,  2, 0.78057400e+02, 0.29407000e+01, 0.19985000e+01},
    { 14,  6,  3,  3, 0.72953000e+02, 0.29407000e+01, 0.29987000e+01},
    { 14,  6,  3,  4, 0.59158300e+02, 0.29407000e+01, 0.39844000e+01},
    { 14,  6,  4,  0, 0.85522300e+02, 0.38677000e+01, 0.00000000e+00},
    { 14,  6,  4,  1, 0.80142700e+02, 0.38677000e+01, 0.98680000e+00},
    { 14,  6,  4,  2, 0.65487900e+02, 0.38677000e+01, 0.19985000e+01},
    { 14,  6,  4,  3, 0.61216900e+02, 0.38677000e+01, 0.29987000e+01},
    { 14,  6,  4,  4, 0.50205300e+02, 0.38677000e+01, 0.39844000e+01},
    { 14,  7,  0,  0, 0.83849800e+02, 0.00000000e+00, 0.00000000e+00},
    { 14,  7,  0,  1, 0.78046600e+02, 0.00000000e+00, 0.99440000e+00},
    { 14,  7,  0,  2, 0.73085800e+02, 0.00000000e+00, 0.20143000e+01},
    { 14,  7,  0,  3, 0.64057600e+02, 0.00000000e+00, 0.29903000e+01},
    { 14,  7,  1,  0, 0.78019000e+02, 0.95070000e+00, 0.00000000e+00},
    { 14,  7,  1,  1, 0.72637300e+02, 0.95070000e+00, 0.99440000e+00},
    { 14,  7,  1,  2, 0.68050400e+02, 0.95070000e+00, 0.20143000e+01},
    { 14,  7,  1,  3, 0.59688700e+02, 0.95070000e+00, 0.29903000e+01},
    { 14,  7,  2,  0, 0.73007300e+02, 0.19435000e+01, 0.00000000e+00},
    { 14,  7,  2,  1, 0.67982000e+02, 0.19435000e+01, 0.99440000e+00},
    { 14,  7,  2,  2, 0.63715100e+02, 0.19435000e+01, 0.20143000e+01},
    { 14,  7,  2,  3, 0.55919700e+02, 0.19435000e+01, 0.29903000e+01},
    { 14,  7,  3,  0, 0.70976100e+02, 0.29407000e+01, 0.00000000e+00},
    { 14,  7,  3,  1, 0.66105200e+02, 0.29407000e+01, 0.99440000e+00},
    { 14,  7,  3,  2, 0.61953000e+02, 0.29407000e+01, 0.20143000e+01},
    { 14,  7,  3,  3, 0.54385700e+02, 0.29407000e+01, 0.29903000e+01},
    { 14,  7,  4,  0, 0.59931900e+02, 0.38677000e+01, 0.00000000e+00},
    { 14,  7,  4,  1, 0.55839400e+02, 0.38677000e+01, 0.99440000e+00},
    { 14,  7,  4,  2, 0.52413600e+02, 0.38677000e+01, 0.20143000e+01},
    { 14,  7,  4,  3, 0.46103100e+02, 0.38677000e+01, 0.29903000e+01},
    { 14,  8,  0,  0, 0.62534900e+02, 0.00000000e+00, 0.00000000e+00},
    { 14,  8,  0,  1, 0.55817500e+02, 0.00000000e+00, 0.99250000e+00},
    { 14,  8,  0,  2, 0.48906600e+02, 0.00000000e+00, 0.19887000e+01},
    { 14,  8,  1,  0, 0.58355700e+02, 0.95070000e+00, 0.00000000e+00},
    { 14,  8,  1,  1, 0.52131100e+02, 0.95070000e+00, 0.99250000e+00},
    { 14,  8,  1,  2, 0.45727300e+02, 0.95070000e+00, 0.19887000e+01},
    { 14,  8,  2,  0, 0.54744300e+02, 0.19435000e+01, 0.00000000e+00},
    { 14,  8,  2,  1, 0.48939100e+02, 0.19435000e+01, 0.99250000e+00},
    { 14,  8,  2,  2, 0.42967900e+02, 0.19435000e+01, 0.19887000e+01},
    { 14,  8,  3,  0, 0.53206100e+02, 0.29407000e+01, 0.00000000e+00},
    { 14,  8,  3,  1, 0.47566400e+02, 0.29407000e+01, 0.99250000e+00},
    { 14,  8,  3,  2, 0.41768700e+02, 0.29407000e+01, 0.19887000e+01},
    { 14,  8,  4,  0, 0.45368800e+02, 0.38677000e+01, 0.00000000e+00},
    { 14,  8,  4,  1, 0.40663500e+02, 0.38677000e+01, 0.99250000e+00},
    { 14,  8,  4,  2, 0.35824700e+02, 0.38677000e+01, 0.19887000e+01},
    { 14,  9,  0,  0, 0.46693600e+02, 0.00000000e+00, 0.00000000e+00},
    { 14,  9,  0,  1, 0.37442100e+02, 0.00000000e+00, 0.99820000e+00},
    { 14,  9,  1,  0, 0.43685500e+02, 0.95070000e+00, 0.00000000e+00},
    { 14,  9,  1,  1, 0.35129000e+02, 0.95070000e+00, 0.99820000e+00},
    { 14,  9,  2,  0, 0.41072800e+02, 0.19435000e+01, 0.00000000e+00},
    { 14,  9,  2,  1, 0.33107500e+02, 0.19435000e+01, 0.99820000e+00},
    { 14,  9,  3,  0, 0.39917200e+02, 0.29407000e+01, 0.00000000e+00},
    { 14,  9,  3,  1, 0.32173000e+02, 0.29407000e+01, 0.99820000e+00},
    { 14,  9,  4,  0, 0.34318700e+02, 0.38677000e+01, 0.00000000e+00},
    { 14,  9,  4,  1, 0.27908600e+02, 0.38677000e+01, 0.99820000e+00},
    { 14, 10,  0,  0, 0.35455000e+02, 0.00000000e+00, 0.00000000e+00},
    { 14, 10,  1,  0, 0.33241600e+02, 0.95070000e+00, 0.00000000e+00},
    { 14, 10,  2,  0, 0.31310700e+02, 0.19435000e+01, 0.00000000e+00},
    { 14, 10,  3,  0, 0.30433800e+02, 0.29407000e+01, 0.00000000e+00},
    { 14, 10,  4,  0, 0.26335800e+02, 0.38677000e+01, 0.00000000e+00},
    { 14, 11,  0,  0, 0.59104580e+03, 0.00000000e+00, 0.00000000e+00},
    { 14, 11,  0,  1, 0.23713260e+03, 0.00000000e+00, 0.96840000e+00},
    { 14, 11,  1,  0, 0.53834120e+03, 0.95070000e+00, 0.00000000e+00},
    { 14, 11,  1,  1, 0.21750490e+03, 0.95070000e+00, 0.96840000e+00},
    { 14, 11,  2,  0, 0.49265620e+03, 0.19435000e+01, 0.00000000e+00},
    { 14, 11,  2,  1, 0.20080380e+03, 0.19435000e+01, 0.96840000e+00},
    { 14, 11,  3,  0, 0.48717610e+03, 0.29407000e+01, 0.00000000e+00},
    { 14, 11,  3,  1, 0.19665260e+03, 0.29407000e+01, 0.96840000e+00},
    { 14, 11,  4,  0, 0.36977170e+03, 0.38677000e+01, 0.00000000e+00},
    { 14, 11,  4,  1, 0.15615450e+03, 0.38677000e+01, 0.96840000e+00},
    { 14, 12,  0,  0, 0.44764230e+03, 0.00000000e+00, 0.00000000e+00},
    { 14, 12,  0,  1, 0.36758110e+03, 0.00000000e+00, 0.96280000e+00},
    { 14, 12,  0,  2, 0.23613880e+03, 0.00000000e+00, 0.19496000e+01},
    { 14, 12,  1,  0, 0.40991740e+03, 0.95070000e+00, 0.00000000e+00},
    { 14, 12,  1,  1, 0.33702500e+03, 0.95070000e+00, 0.96280000e+00},
    { 14, 12,  1,  2, 0.21754710e+03, 0.95070000e+00, 0.19496000e+01},
    { 14, 12,  2,  0, 0.37783600e+03, 0.19435000e+01, 0.00000000e+00},
    { 14, 12,  2,  1, 0.31098970e+03, 0.19435000e+01, 0.96280000e+00},
    { 14, 12,  2,  2, 0.20177580e+03, 0.19435000e+01, 0.19496000e+01},
    { 14, 12,  3,  0, 0.37037780e+03, 0.29407000e+01, 0.00000000e+00},
    { 14, 12,  3,  1, 0.30467970e+03, 0.29407000e+01, 0.96280000e+00},
    { 14, 12,  3,  2, 0.19678410e+03, 0.29407000e+01, 0.19496000e+01},
    { 14, 12,  4,  0, 0.29187160e+03, 0.38677000e+01, 0.00000000e+00},
    { 14, 12,  4,  1, 0.24139030e+03, 0.38677000e+01, 0.96280000e+00},
    { 14, 12,  4,  2, 0.15991150e+03, 0.38677000e+01, 0.19496000e+01},
    { 14, 13,  0,  0, 0.40896060e+03, 0.00000000e+00, 0.00000000e+00},
    { 14, 13,  0,  1, 0.36962320e+03, 0.00000000e+00, 0.96480000e+00},
    { 14, 13,  0,  2, 0.28548250e+03, 0.00000000e+00, 0.19311000e+01},
    { 14, 13,  0,  3, 0.21994790e+03, 0.00000000e+00, 0.29146000e+01},
    { 14, 13,  1,  0, 0.37552330e+03, 0.95070000e+00, 0.00000000e+00},
    { 14, 13,  1,  1, 0.33965160e+03, 0.95070000e+00, 0.96480000e+00},
    { 14, 13,  1,  2, 0.26297700e+03, 0.95070000e+00, 0.19311000e+01},
    { 14, 13,  1,  3, 0.20322260e+03, 0.95070000e+00, 0.29146000e+01},
    { 14, 13,  2,  0, 0.34711540e+03, 0.19435000e+01, 0.00000000e+00},
    { 14, 13,  2,  1, 0.31418090e+03, 0.19435000e+01, 0.96480000e+00},
    { 14, 13,  2,  2, 0.24384070e+03, 0.19435000e+01, 0.19311000e+01},
    { 14, 13,  2,  3, 0.18900340e+03, 0.19435000e+01, 0.29146000e+01},
    { 14, 13,  3,  0, 0.33945020e+03, 0.29407000e+01, 0.00000000e+00},
    { 14, 13,  3,  1, 0.30710150e+03, 0.29407000e+01, 0.96480000e+00},
    { 14, 13,  3,  2, 0.23794340e+03, 0.29407000e+01, 0.19311000e+01},
    { 14, 13,  3,  3, 0.18402910e+03, 0.29407000e+01, 0.29146000e+01},
    { 14, 13,  4,  0, 0.27132020e+03, 0.38677000e+01, 0.00000000e+00},
    { 14, 13,  4,  1, 0.24630130e+03, 0.38677000e+01, 0.96480000e+00},
    { 14, 13,  4,  2, 0.19305340e+03, 0.38677000e+01, 0.19311000e+01},
    { 14, 13,  4,  3, 0.15146030e+03, 0.38677000e+01, 0.29146000e+01},
    { 14, 14,  0,  0, 0.31785740e+03, 0.00000000e+00, 0.00000000e+00},
    { 14, 14,  1,  0, 0.29299940e+03, 0.95070000e+00, 0.00000000e+00},
    { 14, 14,  1,  1, 0.27026500e+03, 0.95070000e+00, 0.95070000e+00},
    { 14, 14,  2,  0, 0.27188440e+03, 0.19435000e+01, 0.00000000e+00},
    { 14, 14,  2,  1, 0.25093760e+03, 0.19435000e+01, 0.95070000e+00},
    { 14, 14,  2,  2, 0.23312540e+03, 0.19435000e+01, 0.19435000e+01},
    { 14, 14,  3,  0, 0.26511890e+03, 0.29407000e+01, 0.00000000e+00},
    { 14, 14,  3,  1, 0.24462880e+03, 0.29407000e+01, 0.95070000e+00},
    { 14, 14,  3,  2, 0.22718820e+03, 0.29407000e+01, 0.19435000e+01},
    { 14, 14,  3,  3, 0.22150460e+03, 0.29407000e+01, 0.29407000e+01},
    { 14, 14,  4,  0, 0.21589980e+03, 0.38677000e+01, 0.00000000e+00},
    { 14, 14,  4,  1, 0.19975300e+03, 0.38677000e+01, 0.95070000e+00},
    { 14, 14,  4,  2, 0.18599960e+03, 0.38677000e+01, 0.19435000e+01},
    { 14, 14,  4,  3, 0.18102370e+03, 0.38677000e+01, 0.29407000e+01},
    { 14, 14,  4,  4, 0.14977340e+03, 0.38677000e+01, 0.38677000e+01},
    { 15,  1,  0,  0, 0.23760400e+02, 0.00000000e+00, 0.91180000e+00},
    { 15,  1,  0,  1, 0.38139700e+02, 0.00000000e+00, 0.00000000e+00},
    { 15,  1,  1,  0, 0.23090800e+02, 0.99470000e+00, 0.91180000e+00},
    { 15,  1,  1,  1, 0.37023600e+02, 0.99470000e+00, 0.00000000e+00},
    { 15,  1,  2,  0, 0.22742900e+02, 0.20102000e+01, 0.91180000e+00},
    { 15,  1,  2,  1, 0.36493600e+02, 0.20102000e+01, 0.00000000e+00},
    { 15,  1,  3,  0, 0.21250700e+02, 0.29859000e+01, 0.91180000e+00},
    { 15,  1,  3,  1, 0.33919300e+02, 0.29859000e+01, 0.00000000e+00},
    { 15,  2,  0,  0, 0.15668900e+02, 0.00000000e+00, 0.00000000e+00},
    { 15,  2,  1,  0, 0.15261900e+02, 0.99470000e+00, 0.00000000e+00},
    { 15,  2,  2,  0, 0.15024500e+02, 0.20102000e+01, 0.00000000e+00},
    { 15,  2,  3,  0, 0.14157700e+02, 0.29859000e+01, 0.00000000e+00},
    { 15,  3,  0,  0, 0.35080300e+03, 0.00000000e+00, 0.00000000e+00},
    { 15,  3,  0,  1, 0.12150670e+03, 0.00000000e+00, 0.98650000e+00},
    { 15,  3,  1,  0, 0.33966930e+03, 0.99470000e+00, 0.00000000e+00},
    { 15,  3,  1,  1, 0.11774720e+03, 0.99470000e+00, 0.98650000e+00},
    { 15,  3,  2,  0, 0.33746620e+03, 0.20102000e+01, 0.00000000e+00},
    { 15,  3,  2,  1, 0.11639410e+03, 0.20102000e+01, 0.98650000e+00},
    { 15,  3,  3,  0, 0.30477070e+03, 0.29859000e+01, 0.00000000e+00},
    { 15,  3,  3,  1, 0.10684660e+03, 0.29859000e+01, 0.98650000e+00},
    { 15,  4,  0,  0, 0.20873310e+03, 0.00000000e+00, 0.00000000e+00},
    { 15,  4,  0,  1, 0.15536440e+03, 0.00000000e+00, 0.98080000e+00},
    { 15,  4,  0,  2, 0.10261760e+03, 0.00000000e+00, 0.19697000e+01},
    { 15,  4,  1,  0, 0.20222820e+03, 0.99470000e+00, 0.00000000e+00},
    { 15,  4,  1,  1, 0.15060680e+03, 0.99470000e+00, 0.98080000e+00},
    { 15,  4,  1,  2, 0.99565600e+02, 0.99470000e+00, 0.19697000e+01},
    { 15,  4,  2,  0, 0.19995760e+03, 0.20102000e+01, 0.00000000e+00},
    { 15,  4,  2,  1, 0.14881940e+03, 0.20102000e+01, 0.98080000e+00},
    { 15,  4,  2,  2, 0.98185900e+02, 0.20102000e+01, 0.19697000e+01},
    { 15,  4,  3,  0, 0.18330560e+03, 0.29859000e+01, 0.00000000e+00},
    { 15,  4,  3,  1, 0.13686740e+03, 0.29859000e+01, 0.98080000e+00},
    { 15,  4,  3,  2, 0.91020600e+02, 0.29859000e+01, 0.19697000e+01},
    { 15,  5,  0,  0, 0.14234810e+03, 0.00000000e+00, 0.00000000e+00},
    { 15,  5,  0,  1, 0.11993530e+03, 0.00000000e+00, 0.97060000e+00},
    { 15,  5,  0,  2, 0.10084320e+03, 0.00000000e+00, 0.19441000e+01},
    { 15,  5,  0,  3, 0.77042900e+02, 0.00000000e+00, 0.29128000e+01},
    { 15,  5,  0,  4, 0.72514500e+02, 0.00000000e+00, 0.45856000e+01},
    { 15,  5,  1,  0, 0.13807740e+03, 0.99470000e+00, 0.00000000e+00},
    { 15,  5,  1,  1, 0.11638180e+03, 0.99470000e+00, 0.97060000e+00},
    { 15,  5,  1,  2, 0.97894700e+02, 0.99470000e+00, 0.19441000e+01},
    { 15,  5,  1,  3, 0.74849700e+02, 0.99470000e+00, 0.29128000e+01},
    { 15,  5,  1,  4, 0.70462900e+02, 0.99470000e+00, 0.45856000e+01},
    { 15,  5,  2,  0, 0.13624020e+03, 0.20102000e+01, 0.00000000e+00},
    { 15,  5,  2,  1, 0.11479680e+03, 0.20102000e+01, 0.97060000e+00},
    { 15,  5,  2,  2, 0.96532400e+02, 0.20102000e+01, 0.19441000e+01},
    { 15,  5,  2,  3, 0.73739700e+02, 0.20102000e+01, 0.29128000e+01},
    { 15,  5,  2,  4, 0.69411500e+02, 0.20102000e+01, 0.45856000e+01},
    { 15,  5,  3,  0, 0.12601940e+03, 0.29859000e+01, 0.00000000e+00},
    { 15,  5,  3,  1, 0.10639230e+03, 0.29859000e+01, 0.97060000e+00},
    { 15,  5,  3,  2, 0.89639100e+02, 0.29859000e+01, 0.19441000e+01},
    { 15,  5,  3,  3, 0.68800700e+02, 0.29859000e+01, 0.29128000e+01},
    { 15,  5,  3,  4, 0.64812700e+02, 0.29859000e+01, 0.45856000e+01},
    { 15,  6,  0,  0, 0.96750300e+02, 0.00000000e+00, 0.00000000e+00},
    { 15,  6,  0,  1, 0.90676700e+02, 0.00000000e+00, 0.98680000e+00},
    { 15,  6,  0,  2, 0.74078400e+02, 0.00000000e+00, 0.19985000e+01},
    { 15,  6,  0,  3, 0.69251500e+02, 0.00000000e+00, 0.29987000e+01},
    { 15,  6,  0,  4, 0.56785200e+02, 0.00000000e+00, 0.39844000e+01},
    { 15,  6,  1,  0, 0.93966300e+02, 0.99470000e+00, 0.00000000e+00},
    { 15,  6,  1,  1, 0.88076900e+02, 0.99470000e+00, 0.98680000e+00},
    { 15,  6,  1,  2, 0.71991400e+02, 0.99470000e+00, 0.19985000e+01},
    { 15,  6,  1,  3, 0.67308800e+02, 0.99470000e+00, 0.29987000e+01},
    { 15,  6,  1,  4, 0.55237500e+02, 0.99470000e+00, 0.39844000e+01},
    { 15,  6,  2,  0, 0.92608000e+02, 0.20102000e+01, 0.00000000e+00},
    { 15,  6,  2,  1, 0.86812800e+02, 0.20102000e+01, 0.98680000e+00},
    { 15,  6,  2,  2, 0.70926900e+02, 0.20102000e+01, 0.19985000e+01},
    { 15,  6,  2,  3, 0.66319400e+02, 0.20102000e+01, 0.29987000e+01},
    { 15,  6,  2,  4, 0.54394100e+02, 0.20102000e+01, 0.39844000e+01},
    { 15,  6,  3,  0, 0.86242700e+02, 0.29859000e+01, 0.00000000e+00},
    { 15,  6,  3,  1, 0.80849600e+02, 0.29859000e+01, 0.98680000e+00},
    { 15,  6,  3,  2, 0.66234300e+02, 0.29859000e+01, 0.19985000e+01},
    { 15,  6,  3,  3, 0.61943300e+02, 0.29859000e+01, 0.29987000e+01},
    { 15,  6,  3,  4, 0.51004800e+02, 0.29859000e+01, 0.39844000e+01},
    { 15,  7,  0,  0, 0.67787300e+02, 0.00000000e+00, 0.00000000e+00},
    { 15,  7,  0,  1, 0.63166900e+02, 0.00000000e+00, 0.99440000e+00},
    { 15,  7,  0,  2, 0.59285900e+02, 0.00000000e+00, 0.20143000e+01},
    { 15,  7,  0,  3, 0.52150900e+02, 0.00000000e+00, 0.29903000e+01},
    { 15,  7,  1,  0, 0.65912700e+02, 0.99470000e+00, 0.00000000e+00},
    { 15,  7,  1,  1, 0.61428600e+02, 0.99470000e+00, 0.99440000e+00},
    { 15,  7,  1,  2, 0.57663200e+02, 0.99470000e+00, 0.20143000e+01},
    { 15,  7,  1,  3, 0.50739800e+02, 0.99470000e+00, 0.29903000e+01},
    { 15,  7,  2,  0, 0.64920900e+02, 0.20102000e+01, 0.00000000e+00},
    { 15,  7,  2,  1, 0.60508500e+02, 0.20102000e+01, 0.99440000e+00},
    { 15,  7,  2,  2, 0.56798100e+02, 0.20102000e+01, 0.20143000e+01},
    { 15,  7,  2,  3, 0.49981800e+02, 0.20102000e+01, 0.29903000e+01},
    { 15,  7,  3,  0, 0.60766300e+02, 0.29859000e+01, 0.00000000e+00},
    { 15,  7,  3,  1, 0.56650800e+02, 0.29859000e+01, 0.99440000e+00},
    { 15,  7,  3,  2, 0.53207600e+02, 0.29859000e+01, 0.20143000e+01},
    { 15,  7,  3,  3, 0.46863500e+02, 0.29859000e+01, 0.29903000e+01},
    { 15,  8,  0,  0, 0.51309800e+02, 0.00000000e+00, 0.00000000e+00},
    { 15,  8,  0,  1, 0.45993700e+02, 0.00000000e+00, 0.99250000e+00},
    { 15,  8,  0,  2, 0.40516700e+02, 0.00000000e+00, 0.19887000e+01},
    { 15,  8,  1,  0, 0.49937400e+02, 0.99470000e+00, 0.00000000e+00},
    { 15,  8,  1,  1, 0.44777000e+02, 0.99470000e+00, 0.99250000e+00},
    { 15,  8,  1,  2, 0.39461700e+02, 0.99470000e+00, 0.19887000e+01},
    { 15,  8,  2,  0, 0.49172900e+02, 0.20102000e+01, 0.00000000e+00},
    { 15,  8,  2,  1, 0.44090400e+02, 0.20102000e+01, 0.99250000e+00},
    { 15,  8,  2,  2, 0.38857800e+02, 0.20102000e+01, 0.19887000e+01},
    { 15,  8,  3,  0, 0.46192700e+02, 0.29859000e+01, 0.00000000e+00},
    { 15,  8,  3,  1, 0.41460000e+02, 0.29859000e+01, 0.99250000e+00},
    { 15,  8,  3,  2, 0.36587500e+02, 0.29859000e+01, 0.19887000e+01},
    { 15,  9,  0,  0, 0.38808400e+02, 0.00000000e+00, 0.00000000e+00},
    { 15,  9,  0,  1, 0.31557700e+02, 0.00000000e+00, 0.99820000e+00},
    { 15,  9,  1,  0, 0.37803500e+02, 0.99470000e+00, 0.00000000e+00},
    { 15,  9,  1,  1, 0.30768800e+02, 0.99470000e+00, 0.99820000e+00},
    { 15,  9,  2,  0, 0.37220500e+02, 0.20102000e+01, 0.00000000e+00},
    { 15,  9,  2,  1, 0.30289400e+02, 0.20102000e+01, 0.99820000e+00},
    { 15,  9,  3,  0, 0.35073300e+02, 0.29859000e+01, 0.00000000e+00},
    { 15,  9,  3,  1, 0.28636200e+02, 0.29859000e+01, 0.99820000e+00},
    { 15, 10,  0,  0, 0.29776700e+02, 0.00000000e+00, 0.00000000e+00},
    { 15, 10,  1,  0, 0.29028000e+02, 0.99470000e+00, 0.00000000e+00},
    { 15, 10,  2,  0, 0.28580500e+02, 0.20102000e+01, 0.00000000e+00},
    { 15, 10,  3,  0, 0.26999000e+02, 0.29859000e+01, 0.00000000e+00},
    { 15, 11,  0,  0, 0.42000640e+03, 0.00000000e+00, 0.00000000e+00},
    { 15, 11,  0,  1, 0.17692050e+03, 0.00000000e+00, 0.96840000e+00},
    { 15, 11,  1,  0, 0.40671500e+03, 0.99470000e+00, 0.00000000e+00},
    { 15, 11,  1,  1, 0.17144690e+03, 0.99470000e+00, 0.96840000e+00},
    { 15, 11,  2,  0, 0.40398020e+03, 0.20102000e+01, 0.00000000e+00},
    { 15, 11,  2,  1, 0.16956980e+03, 0.20102000e+01, 0.96840000e+00},
    { 15, 11,  3,  0, 0.36521100e+03, 0.29859000e+01, 0.00000000e+00},
    { 15, 11,  3,  1, 0.15544950e+03, 0.29859000e+01, 0.96840000e+00},
    { 15, 12,  0,  0, 0.33078010e+03, 0.00000000e+00, 0.00000000e+00},
    { 15, 12,  0,  1, 0.27352680e+03, 0.00000000e+00, 0.96280000e+00},
    { 15, 12,  0,  2, 0.18098430e+03, 0.00000000e+00, 0.19496000e+01},
    { 15, 12,  1,  0, 0.32041760e+03, 0.99470000e+00, 0.00000000e+00},
    { 15, 12,  1,  1, 0.26503780e+03, 0.99470000e+00, 0.96280000e+00},
    { 15, 12,  1,  2, 0.17550060e+03, 0.99470000e+00, 0.19496000e+01},
    { 15, 12,  2,  0, 0.31708240e+03, 0.20102000e+01, 0.00000000e+00},
    { 15, 12,  2,  1, 0.26216960e+03, 0.20102000e+01, 0.96280000e+00},
    { 15, 12,  2,  2, 0.17322270e+03, 0.20102000e+01, 0.19496000e+01},
    { 15, 12,  3,  0, 0.28990900e+03, 0.29859000e+01, 0.00000000e+00},
    { 15, 12,  3,  1, 0.24015820e+03, 0.29859000e+01, 0.96280000e+00},
    { 15, 12,  3,  2, 0.15995620e+03, 0.29859000e+01, 0.19496000e+01},
    { 15, 13,  0,  0, 0.30729650e+03, 0.00000000e+00, 0.00000000e+00},
    { 15, 13,  0,  1, 0.27892720e+03, 0.00000000e+00, 0.96480000e+00},
    { 15, 13,  0,  2, 0.21853020e+03, 0.00000000e+00, 0.19311000e+01},
    { 15, 13,  0,  3, 0.17135570e+03, 0.00000000e+00, 0.29146000e+01},
    { 15, 13,  1,  0, 0.29780760e+03, 0.99470000e+00, 0.00000000e+00},
    { 15, 13,  1,  1, 0.27035800e+03, 0.99470000e+00, 0.96480000e+00},
    { 15, 13,  1,  2, 0.21192050e+03, 0.99470000e+00, 0.19311000e+01},
    { 15, 13,  1,  3, 0.16626980e+03, 0.99470000e+00, 0.29146000e+01},
    { 15, 13,  2,  0, 0.29434030e+03, 0.20102000e+01, 0.00000000e+00},
    { 15, 13,  2,  1, 0.26714040e+03, 0.20102000e+01, 0.96480000e+00},
    { 15, 13,  2,  2, 0.20920610e+03, 0.20102000e+01, 0.19311000e+01},
    { 15, 13,  2,  3, 0.16395650e+03, 0.20102000e+01, 0.29146000e+01},
    { 15, 13,  3,  0, 0.27035350e+03, 0.29859000e+01, 0.00000000e+00},
    { 15, 13,  3,  1, 0.24565290e+03, 0.29859000e+01, 0.96480000e+00},
    { 15, 13,  3,  2, 0.19311320e+03, 0.29859000e+01, 0.19311000e+01},
    { 15, 13,  3,  3, 0.15204520e+03, 0.29859000e+01, 0.29146000e+01},
    { 15, 14,  0,  0, 0.24435460e+03, 0.00000000e+00, 0.00000000e+00},
    { 15, 14,  0,  1, 0.22606570e+03, 0.00000000e+00, 0.95070000e+00},
    { 15, 14,  0,  2, 0.21048400e+03, 0.00000000e+00, 0.19435000e+01},
    { 15, 14,  0,  3, 0.20487700e+03, 0.00000000e+00, 0.29407000e+01},
    { 15, 14,  0,  4, 0.16943560e+03, 0.00000000e+00, 0.38677000e+01},
    { 15, 14,  1,  0, 0.23698640e+03, 0.99470000e+00, 0.00000000e+00},
    { 15, 14,  1,  1, 0.21928630e+03, 0.99470000e+00, 0.95070000e+00},
    { 15, 14,  1,  2, 0.20419980e+03, 0.99470000e+00, 0.19435000e+01},
    { 15, 14,  1,  3, 0.19876160e+03, 0.99470000e+00, 0.29407000e+01},
    { 15, 14,  1,  4, 0.16446690e+03, 0.99470000e+00, 0.38677000e+01},
    { 15, 14,  2,  0, 0.23387520e+03, 0.20102000e+01, 0.00000000e+00},
    { 15, 14,  2,  1, 0.21636930e+03, 0.20102000e+01, 0.95070000e+00},
    { 15, 14,  2,  2, 0.20144650e+03, 0.20102000e+01, 0.19435000e+01},
    { 15, 14,  2,  3, 0.19611960e+03, 0.20102000e+01, 0.29407000e+01},
    { 15, 14,  2,  4, 0.16212890e+03, 0.20102000e+01, 0.38677000e+01},
    { 15, 14,  3,  0, 0.21613030e+03, 0.29859000e+01, 0.00000000e+00},
    { 15, 14,  3,  1, 0.20014220e+03, 0.29859000e+01, 0.95070000e+00},
    { 15, 14,  3,  2, 0.18650310e+03, 0.29859000e+01, 0.19435000e+01},
    { 15, 14,  3,  3, 0.18148400e+03, 0.29859000e+01, 0.29407000e+01},
    { 15, 14,  3,  4, 0.15063080e+03, 0.29859000e+01, 0.38677000e+01},
    { 15, 15,  0,  0, 0.19168870e+03, 0.00000000e+00, 0.00000000e+00},
    { 15, 15,  1,  0, 0.18606840e+03, 0.99470000e+00, 0.00000000e+00},
    { 15, 15,  1,  1, 0.18062380e+03, 0.99470000e+00, 0.99470000e+00},
    { 15, 15,  2,  0, 0.18343220e+03, 0.20102000e+01, 0.00000000e+00},
    { 15, 15,  2,  1, 0.17806220e+03, 0.20102000e+01, 0.99470000e+00},
    { 15, 15,  2,  2, 0.17555340e+03, 0.20102000e+01, 0.20102000e+01},
    { 15, 15,  3,  0, 0.17040450e+03, 0.29859000e+01, 0.00000000e+00},
    { 15, 15,  3,  1, 0.16545180e+03, 0.29859000e+01, 0.99470000e+00},
    { 15, 15,  3,  2, 0.16307640e+03, 0.29859000e+01, 0.20102000e+01},
    { 15, 15,  3,  3, 0.15168860e+03, 0.29859000e+01, 0.29859000e+01},
    { 16,  1,  0,  0, 0.20094800e+02, 0.00000000e+00, 0.91180000e+00},
    { 16,  1,  0,  1, 0.31771300e+02, 0.00000000e+00, 0.00000000e+00},
    { 16,  1,  1,  0, 0.19866700e+02, 0.99480000e+00, 0.91180000e+00},
    { 16,  1,  1,  1, 0.31412700e+02, 0.99480000e+00, 0.00000000e+00},
    { 16,  1,  2,  0, 0.19472900e+02, 0.19903000e+01, 0.91180000e+00},
    { 16,  1,  2,  1, 0.30774700e+02, 0.19903000e+01, 0.00000000e+00},
    { 16,  2,  0,  0, 0.13610800e+02, 0.00000000e+00, 0.00000000e+00},
    { 16,  2,  1,  0, 0.13459800e+02, 0.99480000e+00, 0.00000000e+00},
    { 16,  2,  2,  0, 0.13209000e+02, 0.19903000e+01, 0.00000000e+00},
    { 16,  3,  0,  0, 0.27378670e+03, 0.00000000e+00, 0.00000000e+00},
    { 16,  3,  0,  1, 0.98124900e+02, 0.00000000e+00, 0.98650000e+00},
    { 16,  3,  1,  0, 0.27130110e+03, 0.99480000e+00, 0.00000000e+00},
    { 16,  3,  1,  1, 0.97084900e+02, 0.99480000e+00, 0.98650000e+00},
    { 16,  3,  2,  0, 0.26554640e+03, 0.19903000e+01, 0.00000000e+00},
    { 16,  3,  2,  1, 0.95053100e+02, 0.19903000e+01, 0.98650000e+00},
    { 16,  4,  0,  0, 0.16795130e+03, 0.00000000e+00, 0.00000000e+00},
    { 16,  4,  0,  1, 0.12609930e+03, 0.00000000e+00, 0.98080000e+00},
    { 16,  4,  0,  2, 0.84869100e+02, 0.00000000e+00, 0.19697000e+01},
    { 16,  4,  1,  0, 0.16618070e+03, 0.99480000e+00, 0.00000000e+00},
    { 16,  4,  1,  1, 0.12475120e+03, 0.99480000e+00, 0.98080000e+00},
    { 16,  4,  1,  2, 0.83918100e+02, 0.99480000e+00, 0.19697000e+01},
    { 16,  4,  2,  0, 0.16268750e+03, 0.19903000e+01, 0.00000000e+00},
    { 16,  4,  2,  1, 0.12215340e+03, 0.19903000e+01, 0.98080000e+00},
    { 16,  4,  2,  2, 0.82197300e+02, 0.19903000e+01, 0.19697000e+01},
    { 16,  5,  0,  0, 0.11711210e+03, 0.00000000e+00, 0.00000000e+00},
    { 16,  5,  0,  1, 0.99215900e+02, 0.00000000e+00, 0.97060000e+00},
    { 16,  5,  0,  2, 0.83884700e+02, 0.00000000e+00, 0.19441000e+01},
    { 16,  5,  0,  3, 0.64891800e+02, 0.00000000e+00, 0.29128000e+01},
    { 16,  5,  0,  4, 0.61218400e+02, 0.00000000e+00, 0.45856000e+01},
    { 16,  5,  1,  0, 0.11581680e+03, 0.99480000e+00, 0.00000000e+00},
    { 16,  5,  1,  1, 0.98113900e+02, 0.99480000e+00, 0.97060000e+00},
    { 16,  5,  1,  2, 0.82949700e+02, 0.99480000e+00, 0.19441000e+01},
    { 16,  5,  1,  3, 0.64157300e+02, 0.99480000e+00, 0.29128000e+01},
    { 16,  5,  1,  4, 0.60525500e+02, 0.99480000e+00, 0.45856000e+01},
    { 16,  5,  2,  0, 0.11343240e+03, 0.19903000e+01, 0.00000000e+00},
    { 16,  5,  2,  1, 0.96110000e+02, 0.19903000e+01, 0.97060000e+00},
    { 16,  5,  2,  2, 0.81269300e+02, 0.19903000e+01, 0.19441000e+01},
    { 16,  5,  2,  3, 0.62878300e+02, 0.19903000e+01, 0.29128000e+01},
    { 16,  5,  2,  4, 0.59323900e+02, 0.19903000e+01, 0.45856000e+01},
    { 16,  6,  0,  0, 0.81091900e+02, 0.00000000e+00, 0.00000000e+00},
    { 16,  6,  0,  1, 0.76055200e+02, 0.00000000e+00, 0.98680000e+00},
    { 16,  6,  0,  2, 0.62595300e+02, 0.00000000e+00, 0.19985000e+01},
    { 16,  6,  0,  3, 0.58577600e+02, 0.00000000e+00, 0.29987000e+01},
    { 16,  6,  0,  4, 0.48568100e+02, 0.00000000e+00, 0.39844000e+01},
    { 16,  6,  1,  0, 0.80180400e+02, 0.99480000e+00, 0.00000000e+00},
    { 16,  6,  1,  1, 0.75203900e+02, 0.99480000e+00, 0.98680000e+00},
    { 16,  6,  1,  2, 0.61891600e+02, 0.99480000e+00, 0.19985000e+01},
    { 16,  6,  1,  3, 0.57922100e+02, 0.99480000e+00, 0.29987000e+01},
    { 16,  6,  1,  4, 0.48022100e+02, 0.99480000e+00, 0.39844000e+01},
    { 16,  6,  2,  0, 0.78572900e+02, 0.19903000e+01, 0.00000000e+00},
    { 16,  6,  2,  1, 0.73700600e+02, 0.19903000e+01, 0.98680000e+00},
    { 16,  6,  2,  2, 0.60669000e+02, 0.19903000e+01, 0.19985000e+01},
    { 16,  6,  2,  3, 0.56782600e+02, 0.19903000e+01, 0.29987000e+01},
    { 16,  6,  2,  4, 0.47094300e+02, 0.19903000e+01, 0.39844000e+01},
    { 16,  7,  0,  0, 0.57673400e+02, 0.00000000e+00, 0.00000000e+00},
    { 16,  7,  0,  1, 0.53810700e+02, 0.00000000e+00, 0.99440000e+00},
    { 16,  7,  0,  2, 0.50594600e+02, 0.00000000e+00, 0.20143000e+01},
    { 16,  7,  0,  3, 0.44652900e+02, 0.00000000e+00, 0.29903000e+01},
    { 16,  7,  1,  0, 0.57025500e+02, 0.99480000e+00, 0.00000000e+00},
    { 16,  7,  1,  1, 0.53208600e+02, 0.99480000e+00, 0.99440000e+00},
    { 16,  7,  1,  2, 0.50029800e+02, 0.99480000e+00, 0.20143000e+01},
    { 16,  7,  1,  3, 0.44158100e+02, 0.99480000e+00, 0.29903000e+01},
    { 16,  7,  2,  0, 0.55913600e+02, 0.19903000e+01, 0.00000000e+00},
    { 16,  7,  2,  1, 0.52175300e+02, 0.19903000e+01, 0.99440000e+00},
    { 16,  7,  2,  2, 0.49062900e+02, 0.19903000e+01, 0.20143000e+01},
    { 16,  7,  2,  3, 0.43313000e+02, 0.19903000e+01, 0.29903000e+01},
    { 16,  8,  0,  0, 0.44147000e+02, 0.00000000e+00, 0.00000000e+00},
    { 16,  8,  0,  1, 0.39709100e+02, 0.00000000e+00, 0.99250000e+00},
    { 16,  8,  0,  2, 0.35137700e+02, 0.00000000e+00, 0.19887000e+01},
    { 16,  8,  1,  0, 0.43654800e+02, 0.99480000e+00, 0.00000000e+00},
    { 16,  8,  1,  1, 0.39268300e+02, 0.99480000e+00, 0.99250000e+00},
    { 16,  8,  1,  2, 0.34751000e+02, 0.99480000e+00, 0.19887000e+01},
    { 16,  8,  2,  0, 0.42824500e+02, 0.19903000e+01, 0.00000000e+00},
    { 16,  8,  2,  1, 0.38527600e+02, 0.19903000e+01, 0.99250000e+00},
    { 16,  8,  2,  2, 0.34104200e+02, 0.19903000e+01, 0.19887000e+01},
    { 16,  9,  0,  0, 0.33726400e+02, 0.00000000e+00, 0.00000000e+00},
    { 16,  9,  0,  1, 0.27713700e+02, 0.00000000e+00, 0.99820000e+00},
    { 16,  9,  1,  0, 0.33355000e+02, 0.99480000e+00, 0.00000000e+00},
    { 16,  9,  1,  1, 0.27411700e+02, 0.99480000e+00, 0.99820000e+00},
    { 16,  9,  2,  0, 0.32736500e+02, 0.19903000e+01, 0.00000000e+00},
    { 16,  9,  2,  1, 0.26916300e+02, 0.19903000e+01, 0.99820000e+00},
    { 16, 10,  0,  0, 0.26094000e+02, 0.00000000e+00, 0.00000000e+00},
    { 16, 10,  1,  0, 0.25810700e+02, 0.99480000e+00, 0.00000000e+00},
    { 16, 10,  2,  0, 0.25343500e+02, 0.19903000e+01, 0.00000000e+00},
    { 16, 11,  0,  0, 0.32859900e+03, 0.00000000e+00, 0.00000000e+00},
    { 16, 11,  0,  1, 0.14254300e+03, 0.00000000e+00, 0.96840000e+00},
    { 16, 11,  1,  0, 0.32559690e+03, 0.99480000e+00, 0.00000000e+00},
    { 16, 11,  1,  1, 0.14105990e+03, 0.99480000e+00, 0.96840000e+00},
    { 16, 11,  2,  0, 0.31871200e+03, 0.19903000e+01, 0.00000000e+00},
    { 16, 11,  2,  1, 0.13811660e+03, 0.19903000e+01, 0.96840000e+00},
    { 16, 12,  0,  0, 0.26466650e+03, 0.00000000e+00, 0.00000000e+00},
    { 16, 12,  0,  1, 0.21994890e+03, 0.00000000e+00, 0.96280000e+00},
    { 16, 12,  0,  2, 0.14821300e+03, 0.00000000e+00, 0.19496000e+01},
    { 16, 12,  1,  0, 0.26194370e+03, 0.99480000e+00, 0.00000000e+00},
    { 16, 12,  1,  1, 0.21766290e+03, 0.99480000e+00, 0.96280000e+00},
    { 16, 12,  1,  2, 0.14658490e+03, 0.99480000e+00, 0.19496000e+01},
    { 16, 12,  2,  0, 0.25643150e+03, 0.19903000e+01, 0.00000000e+00},
    { 16, 12,  2,  1, 0.21310360e+03, 0.19903000e+01, 0.96280000e+00},
    { 16, 12,  2,  2, 0.14355230e+03, 0.19903000e+01, 0.19496000e+01},
    { 16, 13,  0,  0, 0.24850080e+03, 0.00000000e+00, 0.00000000e+00},
    { 16, 13,  0,  1, 0.22621560e+03, 0.00000000e+00, 0.96480000e+00},
    { 16, 13,  0,  2, 0.17889260e+03, 0.00000000e+00, 0.19311000e+01},
    { 16, 13,  0,  3, 0.14185170e+03, 0.00000000e+00, 0.29146000e+01},
    { 16, 13,  1,  0, 0.24585680e+03, 0.99480000e+00, 0.00000000e+00},
    { 16, 13,  1,  1, 0.22379420e+03, 0.99480000e+00, 0.96480000e+00},
    { 16, 13,  1,  2, 0.17693650e+03, 0.99480000e+00, 0.19311000e+01},
    { 16, 13,  1,  3, 0.14026180e+03, 0.99480000e+00, 0.29146000e+01},
    { 16, 13,  2,  0, 0.24071650e+03, 0.19903000e+01, 0.00000000e+00},
    { 16, 13,  2,  1, 0.21912850e+03, 0.19903000e+01, 0.96480000e+00},
    { 16, 13,  2,  2, 0.17327790e+03, 0.19903000e+01, 0.19311000e+01},
    { 16, 13,  2,  3, 0.13739070e+03, 0.19903000e+01, 0.29146000e+01},
    { 16, 14,  0,  0, 0.20053740e+03, 0.00000000e+00, 0.00000000e+00},
    { 16, 14,  0,  1, 0.18600510e+03, 0.00000000e+00, 0.95070000e+00},
    { 16, 14,  0,  2, 0.17357980e+03, 0.00000000e+00, 0.19435000e+01},
    { 16, 14,  0,  3, 0.16882250e+03, 0.00000000e+00, 0.29407000e+01},
    { 16, 14,  0,  4, 0.14099550e+03, 0.00000000e+00, 0.38677000e+01},
    { 16, 14,  1,  0, 0.19832660e+03, 0.99480000e+00, 0.00000000e+00},
    { 16, 14,  1,  1, 0.18394830e+03, 0.99480000e+00, 0.95070000e+00},
    { 16, 14,  1,  2, 0.17165370e+03, 0.99480000e+00, 0.19435000e+01},
    { 16, 14,  1,  3, 0.16695970e+03, 0.99480000e+00, 0.29407000e+01},
    { 16, 14,  1,  4, 0.13940860e+03, 0.99480000e+00, 0.38677000e+01},
    { 16, 14,  2,  0, 0.19423140e+03, 0.19903000e+01, 0.00000000e+00},
    { 16, 14,  2,  1, 0.18016220e+03, 0.19903000e+01, 0.95070000e+00},
    { 16, 14,  2,  2, 0.16813020e+03, 0.19903000e+01, 0.19435000e+01},
    { 16, 14,  2,  3, 0.16353520e+03, 0.19903000e+01, 0.29407000e+01},
    { 16, 14,  2,  4, 0.13657580e+03, 0.19903000e+01, 0.38677000e+01},
    { 16, 15,  0,  0, 0.15948980e+03, 0.00000000e+00, 0.00000000e+00},
    { 16, 15,  0,  1, 0.15492290e+03, 0.00000000e+00, 0.99470000e+00},
    { 16, 15,  0,  2, 0.15264700e+03, 0.00000000e+00, 0.20102000e+01},
    { 16, 15,  0,  3, 0.14229820e+03, 0.00000000e+00, 0.29859000e+01},
    { 16, 15,  1,  0, 0.15769710e+03, 0.99480000e+00, 0.00000000e+00},
    { 16, 15,  1,  1, 0.15318230e+03, 0.99480000e+00, 0.99470000e+00},
    { 16, 15,  1,  2, 0.15093640e+03, 0.99480000e+00, 0.20102000e+01},
    { 16, 15,  1,  3, 0.14069580e+03, 0.99480000e+00, 0.29859000e+01},
    { 16, 15,  2,  0, 0.15449350e+03, 0.19903000e+01, 0.00000000e+00},
    { 16, 15,  2,  1, 0.15007480e+03, 0.19903000e+01, 0.99470000e+00},
    { 16, 15,  2,  2, 0.14787500e+03, 0.19903000e+01, 0.20102000e+01},
    { 16, 15,  2,  3, 0.13785400e+03, 0.19903000e+01, 0.29859000e+01},
    { 16, 16,  0,  0, 0.13400660e+03, 0.00000000e+00, 0.00000000e+00},
    { 16, 16,  1,  0, 0.13249220e+03, 0.99480000e+00, 0.00000000e+00},
    { 16, 16,  1,  1, 0.13099650e+03, 0.99480000e+00, 0.99480000e+00},
    { 16, 16,  2,  0, 0.12984130e+03, 0.19903000e+01, 0.00000000e+00},
    { 16, 16,  2,  1, 0.12837640e+03, 0.19903000e+01, 0.99480000e+00},
    { 16, 16,  2,  2, 0.12581090e+03, 0.19903000e+01, 0.19903000e+01},
    { 17,  1,  0,  0, 0.16705200e+02, 0.00000000e+00, 0.91180000e+00},
    { 17,  1,  0,  1, 0.26017000e+02, 0.00000000e+00, 0.00000000e+00},
    { 17,  1,  1,  0, 0.16527300e+02, 0.99720000e+00, 0.91180000e+00},
    { 17,  1,  1,  1, 0.25741400e+02, 0.99720000e+00, 0.00000000e+00},
    { 17,  2,  0,  0, 0.11630200e+02, 0.00000000e+00, 0.00000000e+00},
    { 17,  2,  1,  0, 0.11509200e+02, 0.99720000e+00, 0.00000000e+00},
    { 17,  3,  0,  0, 0.21066260e+03, 0.00000000e+00, 0.00000000e+00},
    { 17,  3,  0,  1, 0.77986500e+02, 0.00000000e+00, 0.98650000e+00},
    { 17,  3,  1,  0, 0.20877430e+03, 0.99720000e+00, 0.00000000e+00},
    { 17,  3,  1,  1, 0.77202300e+02, 0.99720000e+00, 0.98650000e+00},
    { 17,  4,  0,  0, 0.13298080e+03, 0.00000000e+00, 0.00000000e+00},
    { 17,  4,  0,  1, 0.10072120e+03, 0.00000000e+00, 0.98080000e+00},
    { 17,  4,  0,  2, 0.69006900e+02, 0.00000000e+00, 0.19697000e+01},
    { 17,  4,  1,  0, 0.13164980e+03, 0.99720000e+00, 0.00000000e+00},
    { 17,  4,  1,  1, 0.99699500e+02, 0.99720000e+00, 0.98080000e+00},
    { 17,  4,  1,  2, 0.68280600e+02, 0.99720000e+00, 0.19697000e+01},
    { 17,  5,  0,  0, 0.94761200e+02, 0.00000000e+00, 0.00000000e+00},
    { 17,  5,  0,  1, 0.80727200e+02, 0.00000000e+00, 0.97060000e+00},
    { 17,  5,  0,  2, 0.68633100e+02, 0.00000000e+00, 0.19441000e+01},
    { 17,  5,  0,  3, 0.53734300e+02, 0.00000000e+00, 0.29128000e+01},
    { 17,  5,  0,  4, 0.50810200e+02, 0.00000000e+00, 0.45856000e+01},
    { 17,  5,  1,  0, 0.93774300e+02, 0.99720000e+00, 0.00000000e+00},
    { 17,  5,  1,  1, 0.79883300e+02, 0.99720000e+00, 0.97060000e+00},
    { 17,  5,  1,  2, 0.67913200e+02, 0.99720000e+00, 0.19441000e+01},
    { 17,  5,  1,  3, 0.53163800e+02, 0.99720000e+00, 0.29128000e+01},
    { 17,  5,  1,  4, 0.50270800e+02, 0.99720000e+00, 0.45856000e+01},
    { 17,  6,  0,  0, 0.66840700e+02, 0.00000000e+00, 0.00000000e+00},
    { 17,  6,  0,  1, 0.62746500e+02, 0.00000000e+00, 0.98680000e+00},
    { 17,  6,  0,  2, 0.52020800e+02, 0.00000000e+00, 0.19985000e+01},
    { 17,  6,  0,  3, 0.48744800e+02, 0.00000000e+00, 0.29987000e+01},
    { 17,  6,  0,  4, 0.40851600e+02, 0.00000000e+00, 0.39844000e+01},
    { 17,  6,  1,  0, 0.66135400e+02, 0.99720000e+00, 0.00000000e+00},
    { 17,  6,  1,  1, 0.62086400e+02, 0.99720000e+00, 0.98680000e+00},
    { 17,  6,  1,  2, 0.51472100e+02, 0.99720000e+00, 0.19985000e+01},
    { 17,  6,  1,  3, 0.48232800e+02, 0.99720000e+00, 0.29987000e+01},
    { 17,  6,  1,  4, 0.40420900e+02, 0.99720000e+00, 0.39844000e+01},
    { 17,  7,  0,  0, 0.48262400e+02, 0.00000000e+00, 0.00000000e+00},
    { 17,  7,  0,  1, 0.45095200e+02, 0.00000000e+00, 0.99440000e+00},
    { 17,  7,  0,  2, 0.42481600e+02, 0.00000000e+00, 0.20143000e+01},
    { 17,  7,  0,  3, 0.37629500e+02, 0.00000000e+00, 0.29903000e+01},
    { 17,  7,  1,  0, 0.47754000e+02, 0.99720000e+00, 0.00000000e+00},
    { 17,  7,  1,  1, 0.44621700e+02, 0.99720000e+00, 0.99440000e+00},
    { 17,  7,  1,  2, 0.42036700e+02, 0.99720000e+00, 0.20143000e+01},
    { 17,  7,  1,  3, 0.37238100e+02, 0.99720000e+00, 0.29903000e+01},
    { 17,  8,  0,  0, 0.37368800e+02, 0.00000000e+00, 0.00000000e+00},
    { 17,  8,  0,  1, 0.33731300e+02, 0.00000000e+00, 0.99250000e+00},
    { 17,  8,  0,  2, 0.29991800e+02, 0.00000000e+00, 0.19887000e+01},
    { 17,  8,  1,  0, 0.36978300e+02, 0.99720000e+00, 0.00000000e+00},
    { 17,  8,  1,  1, 0.33380100e+02, 0.99720000e+00, 0.99250000e+00},
    { 17,  8,  1,  2, 0.29682200e+02, 0.99720000e+00, 0.19887000e+01},
    { 17,  9,  0,  0, 0.28844500e+02, 0.00000000e+00, 0.00000000e+00},
    { 17,  9,  0,  1, 0.23950500e+02, 0.00000000e+00, 0.99820000e+00},
    { 17,  9,  1,  0, 0.28546800e+02, 0.99720000e+00, 0.00000000e+00},
    { 17,  9,  1,  1, 0.23705900e+02, 0.99720000e+00, 0.99820000e+00},
    { 17, 10,  0,  0, 0.22512100e+02, 0.00000000e+00, 0.00000000e+00},
    { 17, 10,  1,  0, 0.22283200e+02, 0.99720000e+00, 0.00000000e+00},
    { 17, 11,  0,  0, 0.25351360e+03, 0.00000000e+00, 0.00000000e+00},
    { 17, 11,  0,  1, 0.11310250e+03, 0.00000000e+00, 0.96840000e+00},
    { 17, 11,  1,  0, 0.25123260e+03, 0.99720000e+00, 0.00000000e+00},
    { 17, 11,  1,  1, 0.11198290e+03, 0.99720000e+00, 0.96840000e+00},
    { 17, 12,  0,  0, 0.20849780e+03, 0.00000000e+00, 0.00000000e+00},
    { 17, 12,  0,  1, 0.17413990e+03, 0.00000000e+00, 0.96280000e+00},
    { 17, 12,  0,  2, 0.11939110e+03, 0.00000000e+00, 0.19496000e+01},
    { 17, 12,  1,  0, 0.20645210e+03, 0.99720000e+00, 0.00000000e+00},
    { 17, 12,  1,  1, 0.17241480e+03, 0.99720000e+00, 0.96280000e+00},
    { 17, 12,  1,  2, 0.11815670e+03, 0.99720000e+00, 0.19496000e+01},
    { 17, 13,  0,  0, 0.19775940e+03, 0.00000000e+00, 0.00000000e+00},
    { 17, 13,  0,  1, 0.18054300e+03, 0.00000000e+00, 0.96480000e+00},
    { 17, 13,  0,  2, 0.14406690e+03, 0.00000000e+00, 0.19311000e+01},
    { 17, 13,  0,  3, 0.11545520e+03, 0.00000000e+00, 0.29146000e+01},
    { 17, 13,  1,  0, 0.19576470e+03, 0.99720000e+00, 0.00000000e+00},
    { 17, 13,  1,  1, 0.17871270e+03, 0.99720000e+00, 0.96480000e+00},
    { 17, 13,  1,  2, 0.14258060e+03, 0.99720000e+00, 0.19311000e+01},
    { 17, 13,  1,  3, 0.11424050e+03, 0.99720000e+00, 0.29146000e+01},
    { 17, 14,  0,  0, 0.16186860e+03, 0.00000000e+00, 0.00000000e+00},
    { 17, 14,  0,  1, 0.15052310e+03, 0.00000000e+00, 0.95070000e+00},
    { 17, 14,  0,  2, 0.14078240e+03, 0.00000000e+00, 0.19435000e+01},
    { 17, 14,  0,  3, 0.13684600e+03, 0.00000000e+00, 0.29407000e+01},
    { 17, 14,  0,  4, 0.11535420e+03, 0.00000000e+00, 0.38677000e+01},
    { 17, 14,  1,  0, 0.16018790e+03, 0.99720000e+00, 0.00000000e+00},
    { 17, 14,  1,  1, 0.14895590e+03, 0.99720000e+00, 0.95070000e+00},
    { 17, 14,  1,  2, 0.13931250e+03, 0.99720000e+00, 0.19435000e+01},
    { 17, 14,  1,  3, 0.13542340e+03, 0.99720000e+00, 0.29407000e+01},
    { 17, 14,  1,  4, 0.11413580e+03, 0.99720000e+00, 0.38677000e+01},
    { 17, 15,  0,  0, 0.13047250e+03, 0.00000000e+00, 0.00000000e+00},
    { 17, 15,  0,  1, 0.12683120e+03, 0.00000000e+00, 0.99470000e+00},
    { 17, 15,  0,  2, 0.12491620e+03, 0.00000000e+00, 0.20102000e+01},
    { 17, 15,  0,  3, 0.11683550e+03, 0.00000000e+00, 0.29859000e+01},
    { 17, 15,  1,  0, 0.12909560e+03, 0.99720000e+00, 0.00000000e+00},
    { 17, 15,  1,  1, 0.12549300e+03, 0.99720000e+00, 0.99470000e+00},
    { 17, 15,  1,  2, 0.12360110e+03, 0.99720000e+00, 0.20102000e+01},
    { 17, 15,  1,  3, 0.11560060e+03, 0.99720000e+00, 0.29859000e+01},
    { 17, 16,  0,  0, 0.11070060e+03, 0.00000000e+00, 0.00000000e+00},
    { 17, 16,  0,  1, 0.10944860e+03, 0.00000000e+00, 0.99480000e+00},
    { 17, 16,  0,  2, 0.10729640e+03, 0.00000000e+00, 0.19903000e+01},
    { 17, 16,  1,  0, 0.10952700e+03, 0.99720000e+00, 0.00000000e+00},
    { 17, 16,  1,  1, 0.10828930e+03, 0.99720000e+00, 0.99480000e+00},
    { 17, 16,  1,  2, 0.10616060e+03, 0.99720000e+00, 0.19903000e+01},
    { 17, 17,  0,  0, 0.92346000e+02, 0.00000000e+00, 0.00000000e+00},
    { 17, 17,  1,  0, 0.91366700e+02, 0.99720000e+00, 0.00000000e+00},
    { 17, 17,  1,  1, 0.90398500e+02, 0.99720000e+00, 0.99720000e+00},
    { 18,  1,  0,  0, 0.13870000e+02, 0.00000000e+00, 0.91180000e+00},
    { 18,  1,  0,  1, 0.21305500e+02, 0.00000000e+00, 0.00000000e+00},
    { 18,  2,  0,  0, 0.99130000e+01, 0.00000000e+00, 0.00000000e+00},
    { 18,  3,  0,  0, 0.16354970e+03, 0.00000000e+00, 0.00000000e+00},
    { 18,  3,  0,  1, 0.62220500e+02, 0.00000000e+00, 0.98650000e+00},
    { 18,  4,  0,  0, 0.10572290e+03, 0.00000000e+00, 0.00000000e+00},
    { 18,  4,  0,  1, 0.80717400e+02, 0.00000000e+00, 0.98080000e+00},
    { 18,  4,  0,  2, 0.56151700e+02, 0.00000000e+00, 0.19697000e+01},
    { 18,  5,  0,  0, 0.76794900e+02, 0.00000000e+00, 0.00000000e+00},
    { 18,  5,  0,  1, 0.65758000e+02, 0.00000000e+00, 0.97060000e+00},
    { 18,  5,  0,  2, 0.56192600e+02, 0.00000000e+00, 0.19441000e+01},
    { 18,  5,  0,  3, 0.44461300e+02, 0.00000000e+00, 0.29128000e+01},
    { 18,  5,  0,  4, 0.42132400e+02, 0.00000000e+00, 0.45856000e+01},
    { 18,  6,  0,  0, 0.55089800e+02, 0.00000000e+00, 0.00000000e+00},
    { 18,  6,  0,  1, 0.51768400e+02, 0.00000000e+00, 0.98680000e+00},
    { 18,  6,  0,  2, 0.43206400e+02, 0.00000000e+00, 0.19985000e+01},
    { 18,  6,  0,  3, 0.40544100e+02, 0.00000000e+00, 0.29987000e+01},
    { 18,  6,  0,  4, 0.34305000e+02, 0.00000000e+00, 0.39844000e+01},
    { 18,  7,  0,  0, 0.40343500e+02, 0.00000000e+00, 0.00000000e+00},
    { 18,  7,  0,  1, 0.37752200e+02, 0.00000000e+00, 0.99440000e+00},
    { 18,  7,  0,  2, 0.35633400e+02, 0.00000000e+00, 0.20143000e+01},
    { 18,  7,  0,  3, 0.31680400e+02, 0.00000000e+00, 0.29903000e+01},
    { 18,  8,  0,  0, 0.31578300e+02, 0.00000000e+00, 0.00000000e+00},
    { 18,  8,  0,  1, 0.28600000e+02, 0.00000000e+00, 0.99250000e+00},
    { 18,  8,  0,  2, 0.25551400e+02, 0.00000000e+00, 0.19887000e+01},
    { 18,  9,  0,  0, 0.24617800e+02, 0.00000000e+00, 0.00000000e+00},
    { 18,  9,  0,  1, 0.20639400e+02, 0.00000000e+00, 0.99820000e+00},
    { 18, 10,  0,  0, 0.19377400e+02, 0.00000000e+00, 0.00000000e+00},
    { 18, 11,  0,  0, 0.19734400e+03, 0.00000000e+00, 0.00000000e+00},
    { 18, 11,  0,  1, 0.90173500e+02, 0.00000000e+00, 0.96840000e+00},
    { 18, 12,  0,  0, 0.16510060e+03, 0.00000000e+00, 0.00000000e+00},
    { 18, 12,  0,  1, 0.13851900e+03, 0.00000000e+00, 0.96280000e+00},
    { 18, 12,  0,  2, 0.96381300e+02, 0.00000000e+00, 0.19496000e+01},
    { 18, 13,  0,  0, 0.15795950e+03, 0.00000000e+00, 0.00000000e+00},
    { 18, 13,  0,  1, 0.14457980e+03, 0.00000000e+00, 0.96480000e+00},
    { 18, 13,  0,  2, 0.11628170e+03, 0.00000000e+00, 0.19311000e+01},
    { 18, 13,  0,  3, 0.94042800e+02, 0.00000000e+00, 0.29146000e+01},
    { 18, 14,  0,  0, 0.13089270e+03, 0.00000000e+00, 0.00000000e+00},
    { 18, 14,  0,  1, 0.12200120e+03, 0.00000000e+00, 0.95070000e+00},
    { 18, 14,  0,  2, 0.11433480e+03, 0.00000000e+00, 0.19435000e+01},
    { 18, 14,  0,  3, 0.11110440e+03, 0.00000000e+00, 0.29407000e+01},
    { 18, 14,  0,  4, 0.94402700e+02, 0.00000000e+00, 0.38677000e+01},
    { 18, 15,  0,  0, 0.10676980e+03, 0.00000000e+00, 0.00000000e+00},
    { 18, 15,  0,  1, 0.10386530e+03, 0.00000000e+00, 0.99470000e+00},
    { 18, 15,  0,  2, 0.10227010e+03, 0.00000000e+00, 0.20102000e+01},
    { 18, 15,  0,  3, 0.95933600e+02, 0.00000000e+00, 0.29859000e+01},
    { 18, 16,  0,  0, 0.91401400e+02, 0.00000000e+00, 0.00000000e+00},
    { 18, 16,  0,  1, 0.90371600e+02, 0.00000000e+00, 0.99480000e+00},
    { 18, 16,  0,  2, 0.88626800e+02, 0.00000000e+00, 0.19903000e+01},
    { 18, 17,  0,  0, 0.76938300e+02, 0.00000000e+00, 0.00000000e+00},
    { 18, 17,  0,  1, 0.76125600e+02, 0.00000000e+00, 0.99720000e+00},
    { 18, 18,  0,  0, 0.64646200e+02, 0.00000000e+00, 0.00000000e+00},
    { 19,  1,  0,  0, 0.76237600e+02, 0.00000000e+00, 0.91180000e+00},
    { 19,  1,  0,  1, 0.13444410e+03, 0.00000000e+00, 0.00000000e+00},
    { 19,  1,  1,  0, 0.29300000e+02, 0.97670000e+00, 0.91180000e+00},
    { 19,  1,  1,  1, 0.48449900e+02, 0.97670000e+00, 0.00000000e+00},
    { 19,  2,  0,  0, 0.44041100e+02, 0.00000000e+00, 0.00000000e+00},
    { 19,  2,  1,  0, 0.18665500e+02, 0.97670000e+00, 0.00000000e+00},
    { 19,  3,  0,  0, 0.23871574e+04, 0.00000000e+00, 0.00000000e+00},
    { 19,  3,  0,  1, 0.55515160e+03, 0.00000000e+00, 0.98650000e+00},
    { 19,  3,  1,  0, 0.56029540e+03, 0.97670000e+00, 0.00000000e+00},
    { 19,  3,  1,  1, 0.16874120e+03, 0.97670000e+00, 0.98650000e+00},
    { 19,  4,  0,  0, 0.97231970e+03, 0.00000000e+00, 0.00000000e+00},
    { 19,  4,  0,  1, 0.69485960e+03, 0.00000000e+00, 0.98080000e+00},
    { 19,  4,  0,  2, 0.37942250e+03, 0.00000000e+00, 0.19697000e+01},
    { 19,  4,  1,  0, 0.29222240e+03, 0.97670000e+00, 0.00000000e+00},
    { 19,  4,  1,  1, 0.21344440e+03, 0.97670000e+00, 0.98080000e+00},
    { 19,  4,  1,  2, 0.13247510e+03, 0.97670000e+00, 0.19697000e+01},
    { 19,  5,  0,  0, 0.55419800e+03, 0.00000000e+00, 0.00000000e+00},
    { 19,  5,  0,  1, 0.45251930e+03, 0.00000000e+00, 0.97060000e+00},
    { 19,  5,  0,  2, 0.37015350e+03, 0.00000000e+00, 0.19441000e+01},
    { 19,  5,  0,  3, 0.25422370e+03, 0.00000000e+00, 0.29128000e+01},
    { 19,  5,  0,  4, 0.23618020e+03, 0.00000000e+00, 0.45856000e+01},
    { 19,  5,  1,  0, 0.18695660e+03, 0.97670000e+00, 0.00000000e+00},
    { 19,  5,  1,  1, 0.15577810e+03, 0.97670000e+00, 0.97060000e+00},
    { 19,  5,  1,  2, 0.12959630e+03, 0.97670000e+00, 0.19441000e+01},
    { 19,  5,  1,  3, 0.95849700e+02, 0.97670000e+00, 0.29128000e+01},
    { 19,  5,  1,  4, 0.89856900e+02, 0.97670000e+00, 0.45856000e+01},
    { 19,  6,  0,  0, 0.33226940e+03, 0.00000000e+00, 0.00000000e+00},
    { 19,  6,  0,  1, 0.31458000e+03, 0.00000000e+00, 0.98680000e+00},
    { 19,  6,  0,  2, 0.24263660e+03, 0.00000000e+00, 0.19985000e+01},
    { 19,  6,  0,  3, 0.22766000e+03, 0.00000000e+00, 0.29987000e+01},
    { 19,  6,  0,  4, 0.17296850e+03, 0.00000000e+00, 0.39844000e+01},
    { 19,  6,  1,  0, 0.12192920e+03, 0.97670000e+00, 0.00000000e+00},
    { 19,  6,  1,  1, 0.11457230e+03, 0.97670000e+00, 0.98680000e+00},
    { 19,  6,  1,  2, 0.92024000e+02, 0.97670000e+00, 0.19985000e+01},
    { 19,  6,  1,  3, 0.86148100e+02, 0.97670000e+00, 0.29987000e+01},
    { 19,  6,  1,  4, 0.69043400e+02, 0.97670000e+00, 0.39844000e+01},
    { 19,  7,  0,  0, 0.21320010e+03, 0.00000000e+00, 0.00000000e+00},
    { 19,  7,  0,  1, 0.19944050e+03, 0.00000000e+00, 0.99440000e+00},
    { 19,  7,  0,  2, 0.18521810e+03, 0.00000000e+00, 0.20143000e+01},
    { 19,  7,  0,  3, 0.16201600e+03, 0.00000000e+00, 0.29903000e+01},
    { 19,  7,  1,  0, 0.83215300e+02, 0.97670000e+00, 0.00000000e+00},
    { 19,  7,  1,  1, 0.77631700e+02, 0.97670000e+00, 0.99440000e+00},
    { 19,  7,  1,  2, 0.72681800e+02, 0.97670000e+00, 0.20143000e+01},
    { 19,  7,  1,  3, 0.63868600e+02, 0.97670000e+00, 0.29903000e+01},
    { 19,  8,  0,  0, 0.15214200e+03, 0.00000000e+00, 0.00000000e+00},
    { 19,  8,  0,  1, 0.13465080e+03, 0.00000000e+00, 0.99250000e+00},
    { 19,  8,  0,  2, 0.11670690e+03, 0.00000000e+00, 0.19887000e+01},
    { 19,  8,  1,  0, 0.61994800e+02, 0.97670000e+00, 0.00000000e+00},
    { 19,  8,  1,  1, 0.55403200e+02, 0.97670000e+00, 0.99250000e+00},
    { 19,  8,  1,  2, 0.48638000e+02, 0.97670000e+00, 0.19887000e+01},
    { 19,  9,  0,  0, 0.10964390e+03, 0.00000000e+00, 0.00000000e+00},
    { 19,  9,  0,  1, 0.84368800e+02, 0.00000000e+00, 0.99820000e+00},
    { 19,  9,  1,  0, 0.46352000e+02, 0.97670000e+00, 0.00000000e+00},
    { 19,  9,  1,  1, 0.37198200e+02, 0.97670000e+00, 0.99820000e+00},
    { 19, 10,  0,  0, 0.81086100e+02, 0.00000000e+00, 0.00000000e+00},
    { 19, 10,  1,  0, 0.35296900e+02, 0.97670000e+00, 0.00000000e+00},
    { 19, 11,  0,  0, 0.27986124e+04, 0.00000000e+00, 0.00000000e+00},
    { 19, 11,  0,  1, 0.84082990e+03, 0.00000000e+00, 0.96840000e+00},
    { 19, 11,  1,  0, 0.66603570e+03, 0.97670000e+00, 0.00000000e+00},
    { 19, 11,  1,  1, 0.24922000e+03, 0.97670000e+00, 0.96840000e+00},
    { 19, 12,  0,  0, 0.16420587e+04, 0.00000000e+00, 0.00000000e+00},
    { 19, 12,  0,  1, 0.13273176e+04, 0.00000000e+00, 0.96280000e+00},
    { 19, 12,  0,  2, 0.72363460e+03, 0.00000000e+00, 0.19496000e+01},
    { 19, 12,  1,  0, 0.47376610e+03, 0.97670000e+00, 0.00000000e+00},
    { 19, 12,  1,  1, 0.38733490e+03, 0.97670000e+00, 0.96280000e+00},
    { 19, 12,  1,  2, 0.24017250e+03, 0.97670000e+00, 0.19496000e+01},
    { 19, 13,  0,  0, 0.13879361e+04, 0.00000000e+00, 0.00000000e+00},
    { 19, 13,  0,  1, 0.12332237e+04, 0.00000000e+00, 0.96480000e+00},
    { 19, 13,  0,  2, 0.89462280e+03, 0.00000000e+00, 0.19311000e+01},
    { 19, 13,  0,  3, 0.62895370e+03, 0.00000000e+00, 0.29146000e+01},
    { 19, 13,  1,  0, 0.42489260e+03, 0.97670000e+00, 0.00000000e+00},
    { 19, 13,  1,  1, 0.38264220e+03, 0.97670000e+00, 0.96480000e+00},
    { 19, 13,  1,  2, 0.29160280e+03, 0.97670000e+00, 0.19311000e+01},
    { 19, 13,  1,  3, 0.22072640e+03, 0.97670000e+00, 0.29146000e+01},
    { 19, 14,  0,  0, 0.96762830e+03, 0.00000000e+00, 0.00000000e+00},
    { 19, 14,  0,  1, 0.88126240e+03, 0.00000000e+00, 0.95070000e+00},
    { 19, 14,  0,  2, 0.80549240e+03, 0.00000000e+00, 0.19435000e+01},
    { 19, 14,  0,  3, 0.79883900e+03, 0.00000000e+00, 0.29407000e+01},
    { 19, 14,  0,  4, 0.60221160e+03, 0.00000000e+00, 0.38677000e+01},
    { 19, 14,  1,  0, 0.32282330e+03, 0.97670000e+00, 0.00000000e+00},
    { 19, 14,  1,  1, 0.29694090e+03, 0.97670000e+00, 0.95070000e+00},
    { 19, 14,  1,  2, 0.27480560e+03, 0.97670000e+00, 0.19435000e+01},
    { 19, 14,  1,  3, 0.26897780e+03, 0.97670000e+00, 0.29407000e+01},
    { 19, 14,  1,  4, 0.21587970e+03, 0.97670000e+00, 0.38677000e+01},
    { 19, 15,  0,  0, 0.68449680e+03, 0.00000000e+00, 0.00000000e+00},
    { 19, 15,  0,  1, 0.66311840e+03, 0.00000000e+00, 0.99470000e+00},
    { 19, 15,  0,  2, 0.65923940e+03, 0.00000000e+00, 0.20102000e+01},
    { 19, 15,  0,  3, 0.59510330e+03, 0.00000000e+00, 0.29859000e+01},
    { 19, 15,  1,  0, 0.24457290e+03, 0.97670000e+00, 0.00000000e+00},
    { 19, 15,  1,  1, 0.23721910e+03, 0.97670000e+00, 0.99470000e+00},
    { 19, 15,  1,  2, 0.23449210e+03, 0.97670000e+00, 0.20102000e+01},
    { 19, 15,  1,  3, 0.21584670e+03, 0.97670000e+00, 0.29859000e+01},
    { 19, 16,  0,  0, 0.53523840e+03, 0.00000000e+00, 0.00000000e+00},
    { 19, 16,  0,  1, 0.53051920e+03, 0.00000000e+00, 0.99480000e+00},
    { 19, 16,  0,  2, 0.51938020e+03, 0.00000000e+00, 0.19903000e+01},
    { 19, 16,  1,  0, 0.19946720e+03, 0.97670000e+00, 0.00000000e+00},
    { 19, 16,  1,  1, 0.19738060e+03, 0.97670000e+00, 0.99480000e+00},
    { 19, 16,  1,  2, 0.19334120e+03, 0.97670000e+00, 0.19903000e+01},
    { 19, 17,  0,  0, 0.41315120e+03, 0.00000000e+00, 0.00000000e+00},
    { 19, 17,  0,  1, 0.40951050e+03, 0.00000000e+00, 0.99720000e+00},
    { 19, 17,  1,  0, 0.16033040e+03, 0.97670000e+00, 0.00000000e+00},
    { 19, 17,  1,  1, 0.15873300e+03, 0.97670000e+00, 0.99720000e+00},
    { 19, 18,  0,  0, 0.32211550e+03, 0.00000000e+00, 0.00000000e+00},
    { 19, 18,  1,  0, 0.12942830e+03, 0.97670000e+00, 0.00000000e+00},
    { 19, 19,  0,  0, 0.49835009e+04, 0.00000000e+00, 0.00000000e+00},
    { 19, 19,  1,  0, 0.11122277e+04, 0.97670000e+00, 0.00000000e+00},
    { 19, 19,  1,  1, 0.33802070e+03, 0.97670000e+00, 0.97670000e+00},
    { 20,  1,  0,  0, 0.65818000e+02, 0.00000000e+00, 0.91180000e+00},
    { 20,  1,  0,  1, 0.11348570e+03, 0.00000000e+00, 0.00000000e+00},
    { 20,  1,  1,  0, 0.52987100e+02, 0.98310000e+00, 0.91180000e+00},
    { 20,  1,  1,  1, 0.90792700e+02, 0.98310000e+00, 0.00000000e+00},
    { 20,  1,  2,  0, 0.30678300e+02, 0.19349000e+01, 0.91180000e+00},
    { 20,  1,  2,  1, 0.50236800e+02, 0.19349000e+01, 0.00000000e+00},
    { 20,  2,  0,  0, 0.39070100e+02, 0.00000000e+00, 0.00000000e+00},
    { 20,  2,  1,  0, 0.31879600e+02, 0.98310000e+00, 0.00000000e+00},
    { 20,  2,  2,  0, 0.19724700e+02, 0.19349000e+01, 0.00000000e+00},
    { 20,  3,  0,  0, 0.16144719e+04, 0.00000000e+00, 0.00000000e+00},
    { 20,  3,  0,  1, 0.43415760e+03, 0.00000000e+00, 0.98650000e+00},
    { 20,  3,  1,  0, 0.13100314e+04, 0.98310000e+00, 0.00000000e+00},
    { 20,  3,  1,  1, 0.34561200e+03, 0.98310000e+00, 0.98650000e+00},
    { 20,  3,  2,  0, 0.52531960e+03, 0.19349000e+01, 0.00000000e+00},
    { 20,  3,  2,  1, 0.16890090e+03, 0.19349000e+01, 0.98650000e+00},
    { 20,  4,  0,  0, 0.75790700e+03, 0.00000000e+00, 0.00000000e+00},
    { 20,  4,  0,  1, 0.54358420e+03, 0.00000000e+00, 0.98080000e+00},
    { 20,  4,  0,  2, 0.31651020e+03, 0.00000000e+00, 0.19697000e+01},
    { 20,  4,  1,  0, 0.60256610e+03, 0.98310000e+00, 0.00000000e+00},
    { 20,  4,  1,  1, 0.43402840e+03, 0.98310000e+00, 0.98080000e+00},
    { 20,  4,  1,  2, 0.25257780e+03, 0.98310000e+00, 0.19697000e+01},
    { 20,  4,  2,  0, 0.29170210e+03, 0.19349000e+01, 0.00000000e+00},
    { 20,  4,  2,  1, 0.21431710e+03, 0.19349000e+01, 0.98080000e+00},
    { 20,  4,  2,  2, 0.13659980e+03, 0.19349000e+01, 0.19697000e+01},
    { 20,  5,  0,  0, 0.45484390e+03, 0.00000000e+00, 0.00000000e+00},
    { 20,  5,  0,  1, 0.37388150e+03, 0.00000000e+00, 0.97060000e+00},
    { 20,  5,  0,  2, 0.30690780e+03, 0.00000000e+00, 0.19441000e+01},
    { 20,  5,  0,  3, 0.21794570e+03, 0.00000000e+00, 0.29128000e+01},
    { 20,  5,  0,  4, 0.20306790e+03, 0.00000000e+00, 0.45856000e+01},
    { 20,  5,  1,  0, 0.36268620e+03, 0.98310000e+00, 0.00000000e+00},
    { 20,  5,  1,  1, 0.29872640e+03, 0.98310000e+00, 0.97060000e+00},
    { 20,  5,  1,  2, 0.24594980e+03, 0.98310000e+00, 0.19441000e+01},
    { 20,  5,  1,  3, 0.17514340e+03, 0.98310000e+00, 0.29128000e+01},
    { 20,  5,  1,  4, 0.16335340e+03, 0.98310000e+00, 0.45856000e+01},
    { 20,  5,  2,  0, 0.19141350e+03, 0.19349000e+01, 0.00000000e+00},
    { 20,  5,  2,  1, 0.16007340e+03, 0.19349000e+01, 0.97060000e+00},
    { 20,  5,  2,  2, 0.13359950e+03, 0.19349000e+01, 0.19441000e+01},
    { 20,  5,  2,  3, 0.10006100e+03, 0.19349000e+01, 0.29128000e+01},
    { 20,  5,  2,  4, 0.93919400e+02, 0.19349000e+01, 0.45856000e+01},
    { 20,  6,  0,  0, 0.28170350e+03, 0.00000000e+00, 0.00000000e+00},
    { 20,  6,  0,  1, 0.26512060e+03, 0.00000000e+00, 0.98680000e+00},
    { 20,  6,  0,  2, 0.20802230e+03, 0.00000000e+00, 0.19985000e+01},
    { 20,  6,  0,  3, 0.19467190e+03, 0.00000000e+00, 0.29987000e+01},
    { 20,  6,  0,  4, 0.15082030e+03, 0.00000000e+00, 0.39844000e+01},
    { 20,  6,  1,  0, 0.22596290e+03, 0.98310000e+00, 0.00000000e+00},
    { 20,  6,  1,  1, 0.21289570e+03, 0.98310000e+00, 0.98680000e+00},
    { 20,  6,  1,  2, 0.16741450e+03, 0.98310000e+00, 0.19985000e+01},
    { 20,  6,  1,  3, 0.15677020e+03, 0.98310000e+00, 0.29987000e+01},
    { 20,  6,  1,  4, 0.12207070e+03, 0.98310000e+00, 0.39844000e+01},
    { 20,  6,  2,  0, 0.12668360e+03, 0.19349000e+01, 0.00000000e+00},
    { 20,  6,  2,  1, 0.11882550e+03, 0.19349000e+01, 0.98680000e+00},
    { 20,  6,  2,  2, 0.96055300e+02, 0.19349000e+01, 0.19985000e+01},
    { 20,  6,  2,  3, 0.89828500e+02, 0.19349000e+01, 0.29987000e+01},
    { 20,  6,  2,  4, 0.72552400e+02, 0.19349000e+01, 0.39844000e+01},
    { 20,  7,  0,  0, 0.18454980e+03, 0.00000000e+00, 0.00000000e+00},
    { 20,  7,  0,  1, 0.17204550e+03, 0.00000000e+00, 0.99440000e+00},
    { 20,  7,  0,  2, 0.16027500e+03, 0.00000000e+00, 0.20143000e+01},
    { 20,  7,  0,  3, 0.14002730e+03, 0.00000000e+00, 0.29903000e+01},
    { 20,  7,  1,  0, 0.14897930e+03, 0.98310000e+00, 0.00000000e+00},
    { 20,  7,  1,  1, 0.13902190e+03, 0.98310000e+00, 0.99440000e+00},
    { 20,  7,  1,  2, 0.12958410e+03, 0.98310000e+00, 0.20143000e+01},
    { 20,  7,  1,  3, 0.11341610e+03, 0.98310000e+00, 0.29903000e+01},
    { 20,  7,  2,  0, 0.87190600e+02, 0.19349000e+01, 0.00000000e+00},
    { 20,  7,  2,  1, 0.81252500e+02, 0.19349000e+01, 0.99440000e+00},
    { 20,  7,  2,  2, 0.76136500e+02, 0.19349000e+01, 0.20143000e+01},
    { 20,  7,  2,  3, 0.66870600e+02, 0.19349000e+01, 0.29903000e+01},
    { 20,  8,  0,  0, 0.13338470e+03, 0.00000000e+00, 0.00000000e+00},
    { 20,  8,  0,  1, 0.11824110e+03, 0.00000000e+00, 0.99250000e+00},
    { 20,  8,  0,  2, 0.10271260e+03, 0.00000000e+00, 0.19887000e+01},
    { 20,  8,  1,  0, 0.10827180e+03, 0.98310000e+00, 0.00000000e+00},
    { 20,  8,  1,  1, 0.96158400e+02, 0.98310000e+00, 0.99250000e+00},
    { 20,  8,  1,  2, 0.83727900e+02, 0.98310000e+00, 0.19887000e+01},
    { 20,  8,  2,  0, 0.65252500e+02, 0.19349000e+01, 0.00000000e+00},
    { 20,  8,  2,  1, 0.58342300e+02, 0.19349000e+01, 0.99250000e+00},
    { 20,  8,  2,  2, 0.51242500e+02, 0.19349000e+01, 0.19887000e+01},
    { 20,  9,  0,  0, 0.97082400e+02, 0.00000000e+00, 0.00000000e+00},
    { 20,  9,  0,  1, 0.75585000e+02, 0.00000000e+00, 0.99820000e+00},
    { 20,  9,  1,  0, 0.79221800e+02, 0.98310000e+00, 0.00000000e+00},
    { 20,  9,  1,  1, 0.62058000e+02, 0.98310000e+00, 0.99820000e+00},
    { 20,  9,  2,  0, 0.48933100e+02, 0.19349000e+01, 0.00000000e+00},
    { 20,  9,  2,  1, 0.39404800e+02, 0.19349000e+01, 0.99820000e+00},
    { 20, 10,  0,  0, 0.72307200e+02, 0.00000000e+00, 0.00000000e+00},
    { 20, 10,  1,  0, 0.59277900e+02, 0.98310000e+00, 0.00000000e+00},
    { 20, 10,  2,  0, 0.37325800e+02, 0.19349000e+01, 0.00000000e+00},
    { 20, 11,  0,  0, 0.19077081e+04, 0.00000000e+00, 0.00000000e+00},
    { 20, 11,  0,  1, 0.64831050e+03, 0.00000000e+00, 0.96840000e+00},
    { 20, 11,  1,  0, 0.15457064e+04, 0.98310000e+00, 0.00000000e+00},
    { 20, 11,  1,  1, 0.51669170e+03, 0.98310000e+00, 0.96840000e+00},
    { 20, 11,  2,  0, 0.62655260e+03, 0.19349000e+01, 0.00000000e+00},
    { 20, 11,  2,  1, 0.24782230e+03, 0.19349000e+01, 0.96840000e+00},
    { 20, 12,  0,  0, 0.12525932e+04, 0.00000000e+00, 0.00000000e+00},
    { 20, 12,  0,  1, 0.10137695e+04, 0.00000000e+00, 0.96280000e+00},
    { 20, 12,  0,  2, 0.59087370e+03, 0.00000000e+00, 0.19496000e+01},
    { 20, 12,  1,  0, 0.99724860e+03, 0.98310000e+00, 0.00000000e+00},
    { 20, 12,  1,  1, 0.80921820e+03, 0.98310000e+00, 0.96280000e+00},
    { 20, 12,  1,  2, 0.47030590e+03, 0.98310000e+00, 0.19496000e+01},
    { 20, 12,  2,  0, 0.46815270e+03, 0.19349000e+01, 0.00000000e+00},
    { 20, 12,  2,  1, 0.38413080e+03, 0.19349000e+01, 0.96280000e+00},
    { 20, 12,  2,  2, 0.24509830e+03, 0.19349000e+01, 0.19496000e+01},
    { 20, 13,  0,  0, 0.10888420e+04, 0.00000000e+00, 0.00000000e+00},
    { 20, 13,  0,  1, 0.97304930e+03, 0.00000000e+00, 0.96480000e+00},
    { 20, 13,  0,  2, 0.72140890e+03, 0.00000000e+00, 0.19311000e+01},
    { 20, 13,  0,  3, 0.52583670e+03, 0.00000000e+00, 0.29146000e+01},
    { 20, 13,  1,  0, 0.86695170e+03, 0.98310000e+00, 0.00000000e+00},
    { 20, 13,  1,  1, 0.77508320e+03, 0.98310000e+00, 0.96480000e+00},
    { 20, 13,  1,  2, 0.57547210e+03, 0.98310000e+00, 0.19311000e+01},
    { 20, 13,  1,  3, 0.41971290e+03, 0.98310000e+00, 0.29146000e+01},
    { 20, 13,  2,  0, 0.42605680e+03, 0.19349000e+01, 0.00000000e+00},
    { 20, 13,  2,  1, 0.38485550e+03, 0.19349000e+01, 0.96480000e+00},
    { 20, 13,  2,  2, 0.29655720e+03, 0.19349000e+01, 0.19311000e+01},
    { 20, 13,  2,  3, 0.22781080e+03, 0.19349000e+01, 0.29146000e+01},
    { 20, 14,  0,  0, 0.79063470e+03, 0.00000000e+00, 0.00000000e+00},
    { 20, 14,  0,  1, 0.72251110e+03, 0.00000000e+00, 0.95070000e+00},
    { 20, 14,  0,  2, 0.66409770e+03, 0.00000000e+00, 0.19435000e+01},
    { 20, 14,  0,  3, 0.65341740e+03, 0.00000000e+00, 0.29407000e+01},
    { 20, 14,  0,  4, 0.50727030e+03, 0.00000000e+00, 0.38677000e+01},
    { 20, 14,  1,  0, 0.63004560e+03, 0.98310000e+00, 0.00000000e+00},
    { 20, 14,  1,  1, 0.57629620e+03, 0.98310000e+00, 0.95070000e+00},
    { 20, 14,  1,  2, 0.52989460e+03, 0.98310000e+00, 0.19435000e+01},
    { 20, 14,  1,  3, 0.52175350e+03, 0.98310000e+00, 0.29407000e+01},
    { 20, 14,  1,  4, 0.40567650e+03, 0.98310000e+00, 0.38677000e+01},
    { 20, 14,  2,  0, 0.32981710e+03, 0.19349000e+01, 0.00000000e+00},
    { 20, 14,  2,  1, 0.30397250e+03, 0.19349000e+01, 0.95070000e+00},
    { 20, 14,  2,  2, 0.28198140e+03, 0.19349000e+01, 0.19435000e+01},
    { 20, 14,  2,  3, 0.27522420e+03, 0.19349000e+01, 0.29407000e+01},
    { 20, 14,  2,  4, 0.22361620e+03, 0.19349000e+01, 0.38677000e+01},
    { 20, 15,  0,  0, 0.57546270e+03, 0.00000000e+00, 0.00000000e+00},
    { 20, 15,  0,  1, 0.55742550e+03, 0.00000000e+00, 0.99470000e+00},
    { 20, 15,  0,  2, 0.55248890e+03, 0.00000000e+00, 0.20102000e+01},
    { 20, 15,  0,  3, 0.50296540e+03, 0.00000000e+00, 0.29859000e+01},
    { 20, 15,  1,  0, 0.46026350e+03, 0.98310000e+00, 0.00000000e+00},
    { 20, 15,  1,  1, 0.44601700e+03, 0.98310000e+00, 0.99470000e+00},
    { 20, 15,  1,  2, 0.44207020e+03, 0.98310000e+00, 0.20102000e+01},
    { 20, 15,  1,  3, 0.40282860e+03, 0.98310000e+00, 0.29859000e+01},
    { 20, 15,  2,  0, 0.25315190e+03, 0.19349000e+01, 0.00000000e+00},
    { 20, 15,  2,  1, 0.24556540e+03, 0.19349000e+01, 0.99470000e+00},
    { 20, 15,  2,  2, 0.24244540e+03, 0.19349000e+01, 0.20102000e+01},
    { 20, 15,  2,  3, 0.22395660e+03, 0.19349000e+01, 0.29859000e+01},
    { 20, 16,  0,  0, 0.45684430e+03, 0.00000000e+00, 0.00000000e+00},
    { 20, 16,  0,  1, 0.45237450e+03, 0.00000000e+00, 0.99480000e+00},
    { 20, 16,  0,  2, 0.44287350e+03, 0.00000000e+00, 0.19903000e+01},
    { 20, 16,  1,  0, 0.36677110e+03, 0.98310000e+00, 0.00000000e+00},
    { 20, 16,  1,  1, 0.36319510e+03, 0.98310000e+00, 0.99480000e+00},
    { 20, 16,  1,  2, 0.35561610e+03, 0.98310000e+00, 0.19903000e+01},
    { 20, 16,  2,  0, 0.20785310e+03, 0.19349000e+01, 0.00000000e+00},
    { 20, 16,  2,  1, 0.20560060e+03, 0.19349000e+01, 0.99480000e+00},
    { 20, 16,  2,  2, 0.20138950e+03, 0.19349000e+01, 0.19903000e+01},
    { 20, 17,  0,  0, 0.35747370e+03, 0.00000000e+00, 0.00000000e+00},
    { 20, 17,  0,  1, 0.35409350e+03, 0.00000000e+00, 0.99720000e+00},
    { 20, 17,  1,  0, 0.28821820e+03, 0.98310000e+00, 0.00000000e+00},
    { 20, 17,  1,  1, 0.28549050e+03, 0.98310000e+00, 0.99720000e+00},
    { 20, 17,  2,  0, 0.16800650e+03, 0.19349000e+01, 0.00000000e+00},
    { 20, 17,  2,  1, 0.16628780e+03, 0.19349000e+01, 0.99720000e+00},
    { 20, 18,  0,  0, 0.28168230e+03, 0.00000000e+00, 0.00000000e+00},
    { 20, 18,  1,  0, 0.22808920e+03, 0.98310000e+00, 0.00000000e+00},
    { 20, 18,  2,  0, 0.13616380e+03, 0.19349000e+01, 0.00000000e+00},
    { 20, 19,  0,  0, 0.32404393e+04, 0.00000000e+00, 0.00000000e+00},
    { 20, 19,  0,  1, 0.86017710e+03, 0.00000000e+00, 0.97670000e+00},
    { 20, 19,  1,  0, 0.26610830e+04, 0.98310000e+00, 0.00000000e+00},
    { 20, 19,  1,  1, 0.68899110e+03, 0.98310000e+00, 0.97670000e+00},
    { 20, 19,  2,  0, 0.10305394e+04, 0.19349000e+01, 0.00000000e+00},
    { 20, 19,  2,  1, 0.33777950e+03, 0.19349000e+01, 0.97670000e+00},
    { 20, 20,  0,  0, 0.23526862e+04, 0.00000000e+00, 0.00000000e+00},
    { 20, 20,  1,  0, 0.18864221e+04, 0.98310000e+00, 0.00000000e+00},
    { 20, 20,  1,  1, 0.15251891e+04, 0.98310000e+00, 0.98310000e+00},
    { 20, 20,  2,  0, 0.83223790e+03, 0.19349000e+01, 0.00000000e+00},
    { 20, 20,  2,  1, 0.66406200e+03, 0.19349000e+01, 0.98310000e+00},
    { 20, 20,  2,  2, 0.34333430e+03, 0.19349000e+01, 0.19349000e+01},
    { 21,  1,  0,  0, 0.54966900e+02, 0.00000000e+00, 0.91180000e+00},
    { 21,  1,  0,  1, 0.94208300e+02, 0.00000000e+00, 0.00000000e+00},
    { 21,  1,  1,  0, 0.29995300e+02, 0.18627000e+01, 0.91180000e+00},
    { 21,  1,  1,  1, 0.48975300e+02, 0.18627000e+01, 0.00000000e+00},
    { 21,  1,  2,  0, 0.29861500e+02, 0.28999000e+01, 0.91180000e+00},
    { 21,  1,  2,  1, 0.48492900e+02, 0.28999000e+01, 0.00000000e+00},
    { 21,  2,  0,  0, 0.32899500e+02, 0.00000000e+00, 0.00000000e+00},
    { 21,  2,  1,  0, 0.19384100e+02, 0.18627000e+01, 0.00000000e+00},
    { 21,  2,  2,  0, 0.19430400e+02, 0.28999000e+01, 0.00000000e+00},
    { 21,  3,  0,  0, 0.12781183e+04, 0.00000000e+00, 0.00000000e+00},
    { 21,  3,  0,  1, 0.35403170e+03, 0.00000000e+00, 0.98650000e+00},
    { 21,  3,  1,  0, 0.50482680e+03, 0.18627000e+01, 0.00000000e+00},
    { 21,  3,  1,  1, 0.16364460e+03, 0.18627000e+01, 0.98650000e+00},
    { 21,  3,  2,  0, 0.48195860e+03, 0.28999000e+01, 0.00000000e+00},
    { 21,  3,  2,  1, 0.15957150e+03, 0.28999000e+01, 0.98650000e+00},
    { 21,  4,  0,  0, 0.61733580e+03, 0.00000000e+00, 0.00000000e+00},
    { 21,  4,  0,  1, 0.44371900e+03, 0.00000000e+00, 0.98080000e+00},
    { 21,  4,  0,  2, 0.26194430e+03, 0.00000000e+00, 0.19697000e+01},
    { 21,  4,  1,  0, 0.28244200e+03, 0.18627000e+01, 0.00000000e+00},
    { 21,  4,  1,  1, 0.20781070e+03, 0.18627000e+01, 0.98080000e+00},
    { 21,  4,  1,  2, 0.13298680e+03, 0.18627000e+01, 0.19697000e+01},
    { 21,  4,  2,  0, 0.27500610e+03, 0.28999000e+01, 0.00000000e+00},
    { 21,  4,  2,  1, 0.20306780e+03, 0.28999000e+01, 0.98080000e+00},
    { 21,  4,  2,  2, 0.13129800e+03, 0.28999000e+01, 0.19697000e+01},
    { 21,  5,  0,  0, 0.37504180e+03, 0.00000000e+00, 0.00000000e+00},
    { 21,  5,  0,  1, 0.30887210e+03, 0.00000000e+00, 0.97060000e+00},
    { 21,  5,  0,  2, 0.25395340e+03, 0.00000000e+00, 0.19441000e+01},
    { 21,  5,  0,  3, 0.18168340e+03, 0.00000000e+00, 0.29128000e+01},
    { 21,  5,  0,  4, 0.16941860e+03, 0.00000000e+00, 0.45856000e+01},
    { 21,  5,  1,  0, 0.18614190e+03, 0.18627000e+01, 0.00000000e+00},
    { 21,  5,  1,  1, 0.15582280e+03, 0.18627000e+01, 0.97060000e+00},
    { 21,  5,  1,  2, 0.13017250e+03, 0.18627000e+01, 0.19441000e+01},
    { 21,  5,  1,  3, 0.97755000e+02, 0.18627000e+01, 0.29128000e+01},
    { 21,  5,  1,  4, 0.91795100e+02, 0.18627000e+01, 0.45856000e+01},
    { 21,  5,  2,  0, 0.18324130e+03, 0.28999000e+01, 0.00000000e+00},
    { 21,  5,  2,  1, 0.15370500e+03, 0.28999000e+01, 0.97060000e+00},
    { 21,  5,  2,  2, 0.12867160e+03, 0.28999000e+01, 0.19441000e+01},
    { 21,  5,  2,  3, 0.97163200e+02, 0.28999000e+01, 0.29128000e+01},
    { 21,  5,  2,  4, 0.91307200e+02, 0.28999000e+01, 0.45856000e+01},
    { 21,  6,  0,  0, 0.23419500e+03, 0.00000000e+00, 0.00000000e+00},
    { 21,  6,  0,  1, 0.22018540e+03, 0.00000000e+00, 0.98680000e+00},
    { 21,  6,  0,  2, 0.17346300e+03, 0.00000000e+00, 0.19985000e+01},
    { 21,  6,  0,  3, 0.16226090e+03, 0.00000000e+00, 0.29987000e+01},
    { 21,  6,  0,  4, 0.12634910e+03, 0.00000000e+00, 0.39844000e+01},
    { 21,  6,  1,  0, 0.12363790e+03, 0.18627000e+01, 0.00000000e+00},
    { 21,  6,  1,  1, 0.11597260e+03, 0.18627000e+01, 0.98680000e+00},
    { 21,  6,  1,  2, 0.93891100e+02, 0.18627000e+01, 0.19985000e+01},
    { 21,  6,  1,  3, 0.87815300e+02, 0.18627000e+01, 0.29987000e+01},
    { 21,  6,  1,  4, 0.71085400e+02, 0.18627000e+01, 0.39844000e+01},
    { 21,  6,  2,  0, 0.12261150e+03, 0.28999000e+01, 0.00000000e+00},
    { 21,  6,  2,  1, 0.11497100e+03, 0.28999000e+01, 0.98680000e+00},
    { 21,  6,  2,  2, 0.93360300e+02, 0.28999000e+01, 0.19985000e+01},
    { 21,  6,  2,  3, 0.87304800e+02, 0.28999000e+01, 0.29987000e+01},
    { 21,  6,  2,  4, 0.70967000e+02, 0.28999000e+01, 0.39844000e+01},
    { 21,  7,  0,  0, 0.15429470e+03, 0.00000000e+00, 0.00000000e+00},
    { 21,  7,  0,  1, 0.14376580e+03, 0.00000000e+00, 0.99440000e+00},
    { 21,  7,  0,  2, 0.13403140e+03, 0.00000000e+00, 0.20143000e+01},
    { 21,  7,  0,  3, 0.11711120e+03, 0.00000000e+00, 0.29903000e+01},
    { 21,  7,  1,  0, 0.85340400e+02, 0.18627000e+01, 0.00000000e+00},
    { 21,  7,  1,  1, 0.79538300e+02, 0.18627000e+01, 0.99440000e+00},
    { 21,  7,  1,  2, 0.74558700e+02, 0.18627000e+01, 0.20143000e+01},
    { 21,  7,  1,  3, 0.65520300e+02, 0.18627000e+01, 0.29903000e+01},
    { 21,  7,  2,  0, 0.85046400e+02, 0.28999000e+01, 0.00000000e+00},
    { 21,  7,  2,  1, 0.79258600e+02, 0.28999000e+01, 0.99440000e+00},
    { 21,  7,  2,  2, 0.74329700e+02, 0.28999000e+01, 0.20143000e+01},
    { 21,  7,  2,  3, 0.65341500e+02, 0.28999000e+01, 0.29903000e+01},
    { 21,  8,  0,  0, 0.11193590e+03, 0.00000000e+00, 0.00000000e+00},
    { 21,  8,  0,  1, 0.99293900e+02, 0.00000000e+00, 0.99250000e+00},
    { 21,  8,  0,  2, 0.86336500e+02, 0.00000000e+00, 0.19887000e+01},
    { 21,  8,  1,  0, 0.64007200e+02, 0.18627000e+01, 0.00000000e+00},
    { 21,  8,  1,  1, 0.57261100e+02, 0.18627000e+01, 0.99250000e+00},
    { 21,  8,  1,  2, 0.50337300e+02, 0.18627000e+01, 0.19887000e+01},
    { 21,  8,  2,  0, 0.63983900e+02, 0.28999000e+01, 0.00000000e+00},
    { 21,  8,  2,  1, 0.57280500e+02, 0.28999000e+01, 0.99250000e+00},
    { 21,  8,  2,  2, 0.50392000e+02, 0.28999000e+01, 0.19887000e+01},
    { 21,  9,  0,  0, 0.81724200e+02, 0.00000000e+00, 0.00000000e+00},
    { 21,  9,  0,  1, 0.63856400e+02, 0.00000000e+00, 0.99820000e+00},
    { 21,  9,  1,  0, 0.48093600e+02, 0.18627000e+01, 0.00000000e+00},
    { 21,  9,  1,  1, 0.38809700e+02, 0.18627000e+01, 0.99820000e+00},
    { 21,  9,  2,  0, 0.48189200e+02, 0.28999000e+01, 0.00000000e+00},
    { 21,  9,  2,  1, 0.38989900e+02, 0.28999000e+01, 0.99820000e+00},
    { 21, 10,  0,  0, 0.61015400e+02, 0.00000000e+00, 0.00000000e+00},
    { 21, 10,  1,  0, 0.36746800e+02, 0.18627000e+01, 0.00000000e+00},
    { 21, 10,  2,  0, 0.36880000e+02, 0.28999000e+01, 0.00000000e+00},
    { 21, 11,  0,  0, 0.15125338e+04, 0.00000000e+00, 0.00000000e+00},
    { 21, 11,  0,  1, 0.52709170e+03, 0.00000000e+00, 0.96840000e+00},
    { 21, 11,  1,  0, 0.60249290e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 11,  1,  1, 0.23997140e+03, 0.18627000e+01, 0.96840000e+00},
    { 21, 11,  2,  0, 0.57574000e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 11,  2,  1, 0.23346740e+03, 0.28999000e+01, 0.96840000e+00},
    { 21, 12,  0,  0, 0.10155454e+04, 0.00000000e+00, 0.00000000e+00},
    { 21, 12,  0,  1, 0.82289570e+03, 0.00000000e+00, 0.96280000e+00},
    { 21, 12,  0,  2, 0.48646530e+03, 0.00000000e+00, 0.19496000e+01},
    { 21, 12,  1,  0, 0.45276000e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 12,  1,  1, 0.37177680e+03, 0.18627000e+01, 0.96280000e+00},
    { 21, 12,  1,  2, 0.23815400e+03, 0.18627000e+01, 0.19496000e+01},
    { 21, 12,  2,  0, 0.43920300e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 12,  2,  1, 0.36145020e+03, 0.28999000e+01, 0.96280000e+00},
    { 21, 12,  2,  2, 0.23400680e+03, 0.28999000e+01, 0.19496000e+01},
    { 21, 13,  0,  0, 0.88860250e+03, 0.00000000e+00, 0.00000000e+00},
    { 21, 13,  0,  1, 0.79522060e+03, 0.00000000e+00, 0.96480000e+00},
    { 21, 13,  0,  2, 0.59270500e+03, 0.00000000e+00, 0.19311000e+01},
    { 21, 13,  0,  3, 0.43542050e+03, 0.00000000e+00, 0.29146000e+01},
    { 21, 13,  1,  0, 0.41290580e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 13,  1,  1, 0.37318450e+03, 0.18627000e+01, 0.96480000e+00},
    { 21, 13,  1,  2, 0.28808340e+03, 0.18627000e+01, 0.19311000e+01},
    { 21, 13,  1,  3, 0.22183390e+03, 0.18627000e+01, 0.29146000e+01},
    { 21, 13,  2,  0, 0.40293570e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 13,  2,  1, 0.36466680e+03, 0.28999000e+01, 0.96480000e+00},
    { 21, 13,  2,  2, 0.28286280e+03, 0.28999000e+01, 0.19311000e+01},
    { 21, 13,  2,  3, 0.21910140e+03, 0.28999000e+01, 0.29146000e+01},
    { 21, 14,  0,  0, 0.65120400e+03, 0.00000000e+00, 0.00000000e+00},
    { 21, 14,  0,  1, 0.59567250e+03, 0.00000000e+00, 0.95070000e+00},
    { 21, 14,  0,  2, 0.54821150e+03, 0.00000000e+00, 0.19435000e+01},
    { 21, 14,  0,  3, 0.53857540e+03, 0.00000000e+00, 0.29407000e+01},
    { 21, 14,  0,  4, 0.42088950e+03, 0.00000000e+00, 0.38677000e+01},
    { 21, 14,  1,  0, 0.32058960e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 14,  1,  1, 0.29561010e+03, 0.18627000e+01, 0.95070000e+00},
    { 21, 14,  1,  2, 0.27434930e+03, 0.18627000e+01, 0.19435000e+01},
    { 21, 14,  1,  3, 0.26771200e+03, 0.18627000e+01, 0.29407000e+01},
    { 21, 14,  1,  4, 0.21796280e+03, 0.18627000e+01, 0.38677000e+01},
    { 21, 14,  2,  0, 0.31526550e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 14,  2,  1, 0.29100370e+03, 0.28999000e+01, 0.95070000e+00},
    { 21, 14,  2,  2, 0.27035480e+03, 0.28999000e+01, 0.19435000e+01},
    { 21, 14,  2,  3, 0.26358530e+03, 0.28999000e+01, 0.29407000e+01},
    { 21, 14,  2,  4, 0.21570270e+03, 0.28999000e+01, 0.38677000e+01},
    { 21, 15,  0,  0, 0.47727970e+03, 0.00000000e+00, 0.00000000e+00},
    { 21, 15,  0,  1, 0.46235110e+03, 0.00000000e+00, 0.99470000e+00},
    { 21, 15,  0,  2, 0.45796080e+03, 0.00000000e+00, 0.20102000e+01},
    { 21, 15,  0,  3, 0.41774000e+03, 0.00000000e+00, 0.29859000e+01},
    { 21, 15,  1,  0, 0.24673580e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 15,  1,  1, 0.23937010e+03, 0.18627000e+01, 0.99470000e+00},
    { 21, 15,  1,  2, 0.23629650e+03, 0.18627000e+01, 0.20102000e+01},
    { 21, 15,  1,  3, 0.21843190e+03, 0.18627000e+01, 0.29859000e+01},
    { 21, 15,  2,  0, 0.24412340e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 15,  2,  1, 0.23687400e+03, 0.28999000e+01, 0.99470000e+00},
    { 21, 15,  2,  2, 0.23372820e+03, 0.28999000e+01, 0.20102000e+01},
    { 21, 15,  2,  3, 0.21640380e+03, 0.28999000e+01, 0.29859000e+01},
    { 21, 16,  0,  0, 0.38041070e+03, 0.00000000e+00, 0.00000000e+00},
    { 21, 16,  0,  1, 0.37661420e+03, 0.00000000e+00, 0.99480000e+00},
    { 21, 16,  0,  2, 0.36871310e+03, 0.00000000e+00, 0.19903000e+01},
    { 21, 16,  1,  0, 0.20296720e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 16,  1,  1, 0.20076220e+03, 0.18627000e+01, 0.99480000e+00},
    { 21, 16,  1,  2, 0.19666010e+03, 0.18627000e+01, 0.19903000e+01},
    { 21, 16,  2,  0, 0.20154660e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 16,  2,  1, 0.19933220e+03, 0.28999000e+01, 0.99480000e+00},
    { 21, 16,  2,  2, 0.19526710e+03, 0.28999000e+01, 0.19903000e+01},
    { 21, 17,  0,  0, 0.29876860e+03, 0.00000000e+00, 0.00000000e+00},
    { 21, 17,  0,  1, 0.29590280e+03, 0.00000000e+00, 0.99720000e+00},
    { 21, 17,  1,  0, 0.16436550e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 17,  1,  1, 0.16268060e+03, 0.18627000e+01, 0.99720000e+00},
    { 21, 17,  2,  0, 0.16374820e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 17,  2,  1, 0.16205420e+03, 0.28999000e+01, 0.99720000e+00},
    { 21, 18,  0,  0, 0.23614170e+03, 0.00000000e+00, 0.00000000e+00},
    { 21, 18,  1,  0, 0.13344040e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 18,  2,  0, 0.13328650e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 19,  0,  0, 0.25499412e+04, 0.00000000e+00, 0.00000000e+00},
    { 21, 19,  0,  1, 0.70072810e+03, 0.00000000e+00, 0.97670000e+00},
    { 21, 19,  1,  0, 0.98858810e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 19,  1,  1, 0.32770920e+03, 0.18627000e+01, 0.97670000e+00},
    { 21, 19,  2,  0, 0.94339620e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 19,  2,  1, 0.32000430e+03, 0.28999000e+01, 0.97670000e+00},
    { 21, 20,  0,  0, 0.18887902e+04, 0.00000000e+00, 0.00000000e+00},
    { 21, 20,  0,  1, 0.15101427e+04, 0.00000000e+00, 0.98310000e+00},
    { 21, 20,  0,  2, 0.68387860e+03, 0.00000000e+00, 0.19349000e+01},
    { 21, 20,  1,  0, 0.80323800e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 20,  1,  1, 0.64070760e+03, 0.18627000e+01, 0.98310000e+00},
    { 21, 20,  1,  2, 0.33367800e+03, 0.18627000e+01, 0.19349000e+01},
    { 21, 20,  2,  0, 0.77413680e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 20,  2,  1, 0.61816760e+03, 0.28999000e+01, 0.98310000e+00},
    { 21, 20,  2,  2, 0.32764580e+03, 0.28999000e+01, 0.19349000e+01},
    { 21, 21,  0,  0, 0.15224676e+04, 0.00000000e+00, 0.00000000e+00},
    { 21, 21,  1,  0, 0.66067800e+03, 0.18627000e+01, 0.00000000e+00},
    { 21, 21,  1,  1, 0.32450680e+03, 0.18627000e+01, 0.18627000e+01},
    { 21, 21,  2,  0, 0.63848690e+03, 0.28999000e+01, 0.00000000e+00},
    { 21, 21,  2,  1, 0.31880040e+03, 0.28999000e+01, 0.18627000e+01},
    { 21, 21,  2,  2, 0.31398460e+03, 0.28999000e+01, 0.28999000e+01},
    { 22,  1,  0,  0, 0.53687500e+02, 0.00000000e+00, 0.91180000e+00},
    { 22,  1,  0,  1, 0.91333400e+02, 0.00000000e+00, 0.00000000e+00},
    { 22,  1,  1,  0, 0.29000900e+02, 0.18299000e+01, 0.91180000e+00},
    { 22,  1,  1,  1, 0.47275500e+02, 0.18299000e+01, 0.00000000e+00},
    { 22,  1,  2,  0, 0.30259300e+02, 0.38675000e+01, 0.91180000e+00},
    { 22,  1,  2,  1, 0.49098300e+02, 0.38675000e+01, 0.00000000e+00},
    { 22,  2,  0,  0, 0.32531600e+02, 0.00000000e+00, 0.00000000e+00},
    { 22,  2,  1,  0, 0.18808400e+02, 0.18299000e+01, 0.00000000e+00},
    { 22,  2,  2,  0, 0.19720500e+02, 0.38675000e+01, 0.00000000e+00},
    { 22,  3,  0,  0, 0.11929128e+04, 0.00000000e+00, 0.00000000e+00},
    { 22,  3,  0,  1, 0.33738960e+03, 0.00000000e+00, 0.98650000e+00},
    { 22,  3,  1,  0, 0.48829310e+03, 0.18299000e+01, 0.00000000e+00},
    { 22,  3,  1,  1, 0.15766670e+03, 0.18299000e+01, 0.98650000e+00},
    { 22,  3,  2,  0, 0.48620980e+03, 0.38675000e+01, 0.00000000e+00},
    { 22,  3,  2,  1, 0.16130130e+03, 0.38675000e+01, 0.98650000e+00},
    { 22,  4,  0,  0, 0.58748980e+03, 0.00000000e+00, 0.00000000e+00},
    { 22,  4,  0,  1, 0.42362170e+03, 0.00000000e+00, 0.98080000e+00},
    { 22,  4,  0,  2, 0.25305430e+03, 0.00000000e+00, 0.19697000e+01},
    { 22,  4,  1,  0, 0.27202010e+03, 0.18299000e+01, 0.00000000e+00},
    { 22,  4,  1,  1, 0.20036690e+03, 0.18299000e+01, 0.98080000e+00},
    { 22,  4,  1,  2, 0.12828620e+03, 0.18299000e+01, 0.19697000e+01},
    { 22,  4,  2,  0, 0.27793710e+03, 0.38675000e+01, 0.00000000e+00},
    { 22,  4,  2,  1, 0.20531340e+03, 0.38675000e+01, 0.98080000e+00},
    { 22,  4,  2,  2, 0.13288810e+03, 0.38675000e+01, 0.19697000e+01},
    { 22,  5,  0,  0, 0.36108650e+03, 0.00000000e+00, 0.00000000e+00},
    { 22,  5,  0,  1, 0.29808710e+03, 0.00000000e+00, 0.97060000e+00},
    { 22,  5,  0,  2, 0.24566470e+03, 0.00000000e+00, 0.19441000e+01},
    { 22,  5,  0,  3, 0.17706600e+03, 0.00000000e+00, 0.29128000e+01},
    { 22,  5,  0,  4, 0.16529120e+03, 0.00000000e+00, 0.45856000e+01},
    { 22,  5,  1,  0, 0.17950770e+03, 0.18299000e+01, 0.00000000e+00},
    { 22,  5,  1,  1, 0.15035200e+03, 0.18299000e+01, 0.97060000e+00},
    { 22,  5,  1,  2, 0.12570170e+03, 0.18299000e+01, 0.19441000e+01},
    { 22,  5,  1,  3, 0.94475800e+02, 0.18299000e+01, 0.29128000e+01},
    { 22,  5,  1,  4, 0.88738900e+02, 0.18299000e+01, 0.45856000e+01},
    { 22,  5,  2,  0, 0.18540740e+03, 0.38675000e+01, 0.00000000e+00},
    { 22,  5,  2,  1, 0.15556610e+03, 0.38675000e+01, 0.97060000e+00},
    { 22,  5,  2,  2, 0.13026620e+03, 0.38675000e+01, 0.19441000e+01},
    { 22,  5,  2,  3, 0.98436300e+02, 0.38675000e+01, 0.29128000e+01},
    { 22,  5,  2,  4, 0.92515400e+02, 0.38675000e+01, 0.45856000e+01},
    { 22,  6,  0,  0, 0.22757230e+03, 0.00000000e+00, 0.00000000e+00},
    { 22,  6,  0,  1, 0.21386820e+03, 0.00000000e+00, 0.98680000e+00},
    { 22,  6,  0,  2, 0.16920640e+03, 0.00000000e+00, 0.19985000e+01},
    { 22,  6,  0,  3, 0.15827050e+03, 0.00000000e+00, 0.29987000e+01},
    { 22,  6,  0,  4, 0.12400130e+03, 0.00000000e+00, 0.39844000e+01},
    { 22,  6,  1,  0, 0.11943760e+03, 0.18299000e+01, 0.00000000e+00},
    { 22,  6,  1,  1, 0.11205230e+03, 0.18299000e+01, 0.98680000e+00},
    { 22,  6,  1,  2, 0.90783800e+02, 0.18299000e+01, 0.19985000e+01},
    { 22,  6,  1,  3, 0.84925300e+02, 0.18299000e+01, 0.29987000e+01},
    { 22,  6,  1,  4, 0.68829700e+02, 0.18299000e+01, 0.39844000e+01},
    { 22,  6,  2,  0, 0.12418490e+03, 0.38675000e+01, 0.00000000e+00},
    { 22,  6,  2,  1, 0.11644710e+03, 0.38675000e+01, 0.98680000e+00},
    { 22,  6,  2,  2, 0.94601300e+02, 0.38675000e+01, 0.19985000e+01},
    { 22,  6,  2,  3, 0.88470300e+02, 0.38675000e+01, 0.29987000e+01},
    { 22,  6,  2,  4, 0.71959500e+02, 0.38675000e+01, 0.39844000e+01},
    { 22,  7,  0,  0, 0.15101990e+03, 0.00000000e+00, 0.00000000e+00},
    { 22,  7,  0,  1, 0.14071150e+03, 0.00000000e+00, 0.99440000e+00},
    { 22,  7,  0,  2, 0.13130150e+03, 0.00000000e+00, 0.20143000e+01},
    { 22,  7,  0,  3, 0.11482560e+03, 0.00000000e+00, 0.29903000e+01},
    { 22,  7,  1,  0, 0.82583400e+02, 0.18299000e+01, 0.00000000e+00},
    { 22,  7,  1,  1, 0.76983400e+02, 0.18299000e+01, 0.99440000e+00},
    { 22,  7,  1,  2, 0.72182800e+02, 0.18299000e+01, 0.20143000e+01},
    { 22,  7,  1,  3, 0.63464500e+02, 0.18299000e+01, 0.29903000e+01},
    { 22,  7,  2,  0, 0.86210900e+02, 0.38675000e+01, 0.00000000e+00},
    { 22,  7,  2,  1, 0.80346400e+02, 0.38675000e+01, 0.99440000e+00},
    { 22,  7,  2,  2, 0.75360900e+02, 0.38675000e+01, 0.20143000e+01},
    { 22,  7,  2,  3, 0.66260700e+02, 0.38675000e+01, 0.29903000e+01},
    { 22,  8,  0,  0, 0.11014520e+03, 0.00000000e+00, 0.00000000e+00},
    { 22,  8,  0,  1, 0.97834500e+02, 0.00000000e+00, 0.99250000e+00},
    { 22,  8,  0,  2, 0.85221900e+02, 0.00000000e+00, 0.19887000e+01},
    { 22,  8,  1,  0, 0.62030900e+02, 0.18299000e+01, 0.00000000e+00},
    { 22,  8,  1,  1, 0.55516000e+02, 0.18299000e+01, 0.99250000e+00},
    { 22,  8,  1,  2, 0.48839600e+02, 0.18299000e+01, 0.19887000e+01},
    { 22,  8,  2,  0, 0.64903700e+02, 0.38675000e+01, 0.00000000e+00},
    { 22,  8,  2,  1, 0.58112700e+02, 0.38675000e+01, 0.99250000e+00},
    { 22,  8,  2,  2, 0.51141000e+02, 0.38675000e+01, 0.19887000e+01},
    { 22,  9,  0,  0, 0.80797500e+02, 0.00000000e+00, 0.00000000e+00},
    { 22,  9,  0,  1, 0.63474800e+02, 0.00000000e+00, 0.99820000e+00},
    { 22,  9,  1,  0, 0.46676500e+02, 0.18299000e+01, 0.00000000e+00},
    { 22,  9,  1,  1, 0.37722200e+02, 0.18299000e+01, 0.99820000e+00},
    { 22,  9,  2,  0, 0.48913100e+02, 0.38675000e+01, 0.00000000e+00},
    { 22,  9,  2,  1, 0.39601500e+02, 0.38675000e+01, 0.99820000e+00},
    { 22, 10,  0,  0, 0.60559400e+02, 0.00000000e+00, 0.00000000e+00},
    { 22, 10,  1,  0, 0.35711700e+02, 0.18299000e+01, 0.00000000e+00},
    { 22, 10,  2,  0, 0.37455400e+02, 0.38675000e+01, 0.00000000e+00},
    { 22, 11,  0,  0, 0.14131570e+04, 0.00000000e+00, 0.00000000e+00},
    { 22, 11,  0,  1, 0.50123930e+03, 0.00000000e+00, 0.96840000e+00},
    { 22, 11,  1,  0, 0.58252700e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 11,  1,  1, 0.23126120e+03, 0.18299000e+01, 0.96840000e+00},
    { 22, 11,  2,  0, 0.58090670e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 11,  2,  1, 0.23597180e+03, 0.38675000e+01, 0.96840000e+00},
    { 22, 12,  0,  0, 0.96298310e+03, 0.00000000e+00, 0.00000000e+00},
    { 22, 12,  0,  1, 0.78169930e+03, 0.00000000e+00, 0.96280000e+00},
    { 22, 12,  0,  2, 0.46745060e+03, 0.00000000e+00, 0.19496000e+01},
    { 22, 12,  1,  0, 0.43610910e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 12,  1,  1, 0.35836020e+03, 0.18299000e+01, 0.96280000e+00},
    { 22, 12,  1,  2, 0.22957540e+03, 0.18299000e+01, 0.19496000e+01},
    { 22, 12,  2,  0, 0.44375570e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 12,  2,  1, 0.36527360e+03, 0.38675000e+01, 0.96280000e+00},
    { 22, 12,  2,  2, 0.23672460e+03, 0.38675000e+01, 0.19496000e+01},
    { 22, 13,  0,  0, 0.84746150e+03, 0.00000000e+00, 0.00000000e+00},
    { 22, 13,  0,  1, 0.75945320e+03, 0.00000000e+00, 0.96480000e+00},
    { 22, 13,  0,  2, 0.56890770e+03, 0.00000000e+00, 0.19311000e+01},
    { 22, 13,  0,  3, 0.42087110e+03, 0.00000000e+00, 0.29146000e+01},
    { 22, 13,  1,  0, 0.39786180e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 13,  1,  1, 0.35964970e+03, 0.18299000e+01, 0.96480000e+00},
    { 22, 13,  1,  2, 0.27780740e+03, 0.18299000e+01, 0.19311000e+01},
    { 22, 13,  1,  3, 0.21401930e+03, 0.18299000e+01, 0.29146000e+01},
    { 22, 13,  2,  0, 0.40733310e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 13,  2,  1, 0.36870140e+03, 0.38675000e+01, 0.96480000e+00},
    { 22, 13,  2,  2, 0.28613170e+03, 0.38675000e+01, 0.19311000e+01},
    { 22, 13,  2,  3, 0.22177080e+03, 0.38675000e+01, 0.29146000e+01},
    { 22, 14,  0,  0, 0.62623530e+03, 0.00000000e+00, 0.00000000e+00},
    { 22, 14,  0,  1, 0.57349880e+03, 0.00000000e+00, 0.95070000e+00},
    { 22, 14,  0,  2, 0.52845930e+03, 0.00000000e+00, 0.19435000e+01},
    { 22, 14,  0,  3, 0.51863330e+03, 0.00000000e+00, 0.29407000e+01},
    { 22, 14,  0,  4, 0.40781600e+03, 0.00000000e+00, 0.38677000e+01},
    { 22, 14,  1,  0, 0.30910810e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 14,  1,  1, 0.28509570e+03, 0.18299000e+01, 0.95070000e+00},
    { 22, 14,  1,  2, 0.26463020e+03, 0.18299000e+01, 0.19435000e+01},
    { 22, 14,  1,  3, 0.25825540e+03, 0.18299000e+01, 0.29407000e+01},
    { 22, 14,  1,  4, 0.21039040e+03, 0.18299000e+01, 0.38677000e+01},
    { 22, 14,  2,  0, 0.31895500e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 14,  2,  1, 0.29444790e+03, 0.38675000e+01, 0.95070000e+00},
    { 22, 14,  2,  2, 0.27358870e+03, 0.38675000e+01, 0.19435000e+01},
    { 22, 14,  2,  3, 0.26672430e+03, 0.38675000e+01, 0.29407000e+01},
    { 22, 14,  2,  4, 0.21838960e+03, 0.38675000e+01, 0.38677000e+01},
    { 22, 15,  0,  0, 0.46232470e+03, 0.00000000e+00, 0.00000000e+00},
    { 22, 15,  0,  1, 0.44795900e+03, 0.00000000e+00, 0.99470000e+00},
    { 22, 15,  0,  2, 0.44347230e+03, 0.00000000e+00, 0.20102000e+01},
    { 22, 15,  0,  3, 0.40534620e+03, 0.00000000e+00, 0.29859000e+01},
    { 22, 15,  1,  0, 0.23816440e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 15,  1,  1, 0.23107730e+03, 0.18299000e+01, 0.99470000e+00},
    { 22, 15,  1,  2, 0.22810870e+03, 0.18299000e+01, 0.20102000e+01},
    { 22, 15,  1,  3, 0.21092280e+03, 0.18299000e+01, 0.29859000e+01},
    { 22, 15,  2,  0, 0.24716030e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 15,  2,  1, 0.23982940e+03, 0.38675000e+01, 0.99470000e+00},
    { 22, 15,  2,  2, 0.23663740e+03, 0.38675000e+01, 0.20102000e+01},
    { 22, 15,  2,  3, 0.21913910e+03, 0.38675000e+01, 0.29859000e+01},
    { 22, 16,  0,  0, 0.37026310e+03, 0.00000000e+00, 0.00000000e+00},
    { 22, 16,  0,  1, 0.36651510e+03, 0.00000000e+00, 0.99480000e+00},
    { 22, 16,  0,  2, 0.35885540e+03, 0.00000000e+00, 0.19903000e+01},
    { 22, 16,  1,  0, 0.19611280e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 16,  1,  1, 0.19398450e+03, 0.18299000e+01, 0.99480000e+00},
    { 22, 16,  1,  2, 0.19002900e+03, 0.18299000e+01, 0.19903000e+01},
    { 22, 16,  2,  0, 0.20416200e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 16,  2,  1, 0.20191810e+03, 0.38675000e+01, 0.99480000e+00},
    { 22, 16,  2,  2, 0.19780370e+03, 0.38675000e+01, 0.19903000e+01},
    { 22, 17,  0,  0, 0.29218530e+03, 0.00000000e+00, 0.00000000e+00},
    { 22, 17,  0,  1, 0.28935120e+03, 0.00000000e+00, 0.99720000e+00},
    { 22, 17,  1,  0, 0.15898920e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 17,  1,  1, 0.15736040e+03, 0.18299000e+01, 0.99720000e+00},
    { 22, 17,  2,  0, 0.16596320e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 17,  2,  1, 0.16424590e+03, 0.38675000e+01, 0.99720000e+00},
    { 22, 18,  0,  0, 0.23192080e+03, 0.00000000e+00, 0.00000000e+00},
    { 22, 18,  1,  0, 0.12921800e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 18,  2,  0, 0.13515860e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 19,  0,  0, 0.23746690e+04, 0.00000000e+00, 0.00000000e+00},
    { 22, 19,  0,  1, 0.66875460e+03, 0.00000000e+00, 0.97670000e+00},
    { 22, 19,  1,  0, 0.96033760e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 19,  1,  1, 0.31625180e+03, 0.18299000e+01, 0.97670000e+00},
    { 22, 19,  2,  0, 0.95162680e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 19,  2,  1, 0.32361900e+03, 0.38675000e+01, 0.97670000e+00},
    { 22, 20,  0,  0, 0.17795162e+04, 0.00000000e+00, 0.00000000e+00},
    { 22, 20,  0,  1, 0.14223244e+04, 0.00000000e+00, 0.98310000e+00},
    { 22, 20,  0,  2, 0.65674740e+03, 0.00000000e+00, 0.19349000e+01},
    { 22, 20,  1,  0, 0.77468630e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 20,  1,  1, 0.61943010e+03, 0.18299000e+01, 0.98310000e+00},
    { 22, 20,  1,  2, 0.32184410e+03, 0.18299000e+01, 0.19349000e+01},
    { 22, 20,  2,  0, 0.78176790e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 20,  2,  1, 0.62430360e+03, 0.38675000e+01, 0.98310000e+00},
    { 22, 20,  2,  2, 0.33148510e+03, 0.38675000e+01, 0.19349000e+01},
    { 22, 21,  0,  0, 0.14382841e+04, 0.00000000e+00, 0.00000000e+00},
    { 22, 21,  0,  1, 0.63504570e+03, 0.00000000e+00, 0.18627000e+01},
    { 22, 21,  0,  2, 0.61524940e+03, 0.00000000e+00, 0.28999000e+01},
    { 22, 21,  1,  0, 0.63687060e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 21,  1,  1, 0.31292020e+03, 0.18299000e+01, 0.18627000e+01},
    { 22, 21,  1,  2, 0.30759130e+03, 0.18299000e+01, 0.28999000e+01},
    { 22, 21,  2,  0, 0.64493880e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 21,  2,  1, 0.32257050e+03, 0.38675000e+01, 0.18627000e+01},
    { 22, 21,  2,  2, 0.31775890e+03, 0.38675000e+01, 0.28999000e+01},
    { 22, 22,  0,  0, 0.13619185e+04, 0.00000000e+00, 0.00000000e+00},
    { 22, 22,  1,  0, 0.61222250e+03, 0.18299000e+01, 0.00000000e+00},
    { 22, 22,  1,  1, 0.30199880e+03, 0.18299000e+01, 0.18299000e+01},
    { 22, 22,  2,  0, 0.62162280e+03, 0.38675000e+01, 0.00000000e+00},
    { 22, 22,  2,  1, 0.31124080e+03, 0.38675000e+01, 0.18299000e+01},
    { 22, 22,  2,  2, 0.32158900e+03, 0.38675000e+01, 0.38675000e+01},
    { 23,  1,  0,  0, 0.49481900e+02, 0.00000000e+00, 0.91180000e+00},
    { 23,  1,  0,  1, 0.83831300e+02, 0.00000000e+00, 0.00000000e+00},
    { 23,  1,  1,  0, 0.28406700e+02, 0.19138000e+01, 0.91180000e+00},
    { 23,  1,  1,  1, 0.46308900e+02, 0.19138000e+01, 0.00000000e+00},
    { 23,  1,  2,  0, 0.27688000e+02, 0.29110000e+01, 0.91180000e+00},
    { 23,  1,  2,  1, 0.44884200e+02, 0.29110000e+01, 0.00000000e+00},
    { 23,  2,  0,  0, 0.30185100e+02, 0.00000000e+00, 0.00000000e+00},
    { 23,  2,  1,  0, 0.18435900e+02, 0.19138000e+01, 0.00000000e+00},
    { 23,  2,  2,  0, 0.18112700e+02, 0.29110000e+01, 0.00000000e+00},
    { 23,  3,  0,  0, 0.10690426e+04, 0.00000000e+00, 0.00000000e+00},
    { 23,  3,  0,  1, 0.30654820e+03, 0.00000000e+00, 0.98650000e+00},
    { 23,  3,  1,  0, 0.47914020e+03, 0.19138000e+01, 0.00000000e+00},
    { 23,  3,  1,  1, 0.15457620e+03, 0.19138000e+01, 0.98650000e+00},
    { 23,  3,  2,  0, 0.44829230e+03, 0.29110000e+01, 0.00000000e+00},
    { 23,  3,  2,  1, 0.14764100e+03, 0.29110000e+01, 0.98650000e+00},
    { 23,  4,  0,  0, 0.53334990e+03, 0.00000000e+00, 0.00000000e+00},
    { 23,  4,  0,  1, 0.38527540e+03, 0.00000000e+00, 0.98080000e+00},
    { 23,  4,  0,  2, 0.23180650e+03, 0.00000000e+00, 0.19697000e+01},
    { 23,  4,  1,  0, 0.26670500e+03, 0.19138000e+01, 0.00000000e+00},
    { 23,  4,  1,  1, 0.19640270e+03, 0.19138000e+01, 0.98080000e+00},
    { 23,  4,  1,  2, 0.12567780e+03, 0.19138000e+01, 0.19697000e+01},
    { 23,  4,  2,  0, 0.25437670e+03, 0.29110000e+01, 0.00000000e+00},
    { 23,  4,  2,  1, 0.18795310e+03, 0.29110000e+01, 0.98080000e+00},
    { 23,  4,  2,  2, 0.12146010e+03, 0.29110000e+01, 0.19697000e+01},
    { 23,  5,  0,  0, 0.33010230e+03, 0.00000000e+00, 0.00000000e+00},
    { 23,  5,  0,  1, 0.27287470e+03, 0.00000000e+00, 0.97060000e+00},
    { 23,  5,  0,  2, 0.22517830e+03, 0.00000000e+00, 0.19441000e+01},
    { 23,  5,  0,  3, 0.16299900e+03, 0.00000000e+00, 0.29128000e+01},
    { 23,  5,  0,  4, 0.15225000e+03, 0.00000000e+00, 0.45856000e+01},
    { 23,  5,  1,  0, 0.17589090e+03, 0.19138000e+01, 0.00000000e+00},
    { 23,  5,  1,  1, 0.14731530e+03, 0.19138000e+01, 0.97060000e+00},
    { 23,  5,  1,  2, 0.12315290e+03, 0.19138000e+01, 0.19441000e+01},
    { 23,  5,  1,  3, 0.92545100e+02, 0.19138000e+01, 0.29128000e+01},
    { 23,  5,  1,  4, 0.86926400e+02, 0.19138000e+01, 0.45856000e+01},
    { 23,  5,  2,  0, 0.16952210e+03, 0.29110000e+01, 0.00000000e+00},
    { 23,  5,  2,  1, 0.14227280e+03, 0.29110000e+01, 0.97060000e+00},
    { 23,  5,  2,  2, 0.11917710e+03, 0.29110000e+01, 0.19441000e+01},
    { 23,  5,  2,  3, 0.90057400e+02, 0.29110000e+01, 0.29128000e+01},
    { 23,  5,  2,  4, 0.84657000e+02, 0.29110000e+01, 0.45856000e+01},
    { 23,  6,  0,  0, 0.20914500e+03, 0.00000000e+00, 0.00000000e+00},
    { 23,  6,  0,  1, 0.19648850e+03, 0.00000000e+00, 0.98680000e+00},
    { 23,  6,  0,  2, 0.15583870e+03, 0.00000000e+00, 0.19985000e+01},
    { 23,  6,  0,  3, 0.14575800e+03, 0.00000000e+00, 0.29987000e+01},
    { 23,  6,  0,  4, 0.11458700e+03, 0.00000000e+00, 0.39844000e+01},
    { 23,  6,  1,  0, 0.11700980e+03, 0.19138000e+01, 0.00000000e+00},
    { 23,  6,  1,  1, 0.10977970e+03, 0.19138000e+01, 0.98680000e+00},
    { 23,  6,  1,  2, 0.88942900e+02, 0.19138000e+01, 0.19985000e+01},
    { 23,  6,  1,  3, 0.83211100e+02, 0.19138000e+01, 0.29987000e+01},
    { 23,  6,  1,  4, 0.67438300e+02, 0.19138000e+01, 0.39844000e+01},
    { 23,  6,  2,  0, 0.11361290e+03, 0.29110000e+01, 0.00000000e+00},
    { 23,  6,  2,  1, 0.10657110e+03, 0.29110000e+01, 0.98680000e+00},
    { 23,  6,  2,  2, 0.86606000e+02, 0.29110000e+01, 0.19985000e+01},
    { 23,  6,  2,  3, 0.81022900e+02, 0.29110000e+01, 0.29987000e+01},
    { 23,  6,  2,  4, 0.65947300e+02, 0.29110000e+01, 0.39844000e+01},
    { 23,  7,  0,  0, 0.13935120e+03, 0.00000000e+00, 0.00000000e+00},
    { 23,  7,  0,  1, 0.12982970e+03, 0.00000000e+00, 0.99440000e+00},
    { 23,  7,  0,  2, 0.12121190e+03, 0.00000000e+00, 0.20143000e+01},
    { 23,  7,  0,  3, 0.10604890e+03, 0.00000000e+00, 0.29903000e+01},
    { 23,  7,  1,  0, 0.80914400e+02, 0.19138000e+01, 0.00000000e+00},
    { 23,  7,  1,  1, 0.75430300e+02, 0.19138000e+01, 0.99440000e+00},
    { 23,  7,  1,  2, 0.70734700e+02, 0.19138000e+01, 0.20143000e+01},
    { 23,  7,  1,  3, 0.62202000e+02, 0.19138000e+01, 0.29903000e+01},
    { 23,  7,  2,  0, 0.78976100e+02, 0.29110000e+01, 0.00000000e+00},
    { 23,  7,  2,  1, 0.73627500e+02, 0.29110000e+01, 0.99440000e+00},
    { 23,  7,  2,  2, 0.69080900e+02, 0.29110000e+01, 0.20143000e+01},
    { 23,  7,  2,  3, 0.60783400e+02, 0.29110000e+01, 0.29903000e+01},
    { 23,  8,  0,  0, 0.10193250e+03, 0.00000000e+00, 0.00000000e+00},
    { 23,  8,  0,  1, 0.90600700e+02, 0.00000000e+00, 0.99250000e+00},
    { 23,  8,  0,  2, 0.79000300e+02, 0.00000000e+00, 0.19887000e+01},
    { 23,  8,  1,  0, 0.60793300e+02, 0.19138000e+01, 0.00000000e+00},
    { 23,  8,  1,  1, 0.54410900e+02, 0.19138000e+01, 0.99250000e+00},
    { 23,  8,  1,  2, 0.47881500e+02, 0.19138000e+01, 0.19887000e+01},
    { 23,  8,  2,  0, 0.59544500e+02, 0.29110000e+01, 0.00000000e+00},
    { 23,  8,  2,  1, 0.53340000e+02, 0.29110000e+01, 0.99250000e+00},
    { 23,  8,  2,  2, 0.46987500e+02, 0.29110000e+01, 0.19887000e+01},
    { 23,  9,  0,  0, 0.74967100e+02, 0.00000000e+00, 0.00000000e+00},
    { 23,  9,  0,  1, 0.59066500e+02, 0.00000000e+00, 0.99820000e+00},
    { 23,  9,  1,  0, 0.45763000e+02, 0.19138000e+01, 0.00000000e+00},
    { 23,  9,  1,  1, 0.36996200e+02, 0.19138000e+01, 0.99820000e+00},
    { 23,  9,  2,  0, 0.44949300e+02, 0.29110000e+01, 0.00000000e+00},
    { 23,  9,  2,  1, 0.36451300e+02, 0.29110000e+01, 0.99820000e+00},
    { 23, 10,  0,  0, 0.56310800e+02, 0.00000000e+00, 0.00000000e+00},
    { 23, 10,  1,  0, 0.35029000e+02, 0.19138000e+01, 0.00000000e+00},
    { 23, 10,  2,  0, 0.34478900e+02, 0.29110000e+01, 0.00000000e+00},
    { 23, 11,  0,  0, 0.12673139e+04, 0.00000000e+00, 0.00000000e+00},
    { 23, 11,  0,  1, 0.45480300e+03, 0.00000000e+00, 0.96840000e+00},
    { 23, 11,  1,  0, 0.57164550e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 11,  1,  1, 0.22678860e+03, 0.19138000e+01, 0.96840000e+00},
    { 23, 11,  2,  0, 0.53544830e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 11,  2,  1, 0.21618670e+03, 0.29110000e+01, 0.96840000e+00},
    { 23, 12,  0,  0, 0.87225790e+03, 0.00000000e+00, 0.00000000e+00},
    { 23, 12,  0,  1, 0.70876840e+03, 0.00000000e+00, 0.96280000e+00},
    { 23, 12,  0,  2, 0.42688150e+03, 0.00000000e+00, 0.19496000e+01},
    { 23, 12,  1,  0, 0.42771560e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 12,  1,  1, 0.35139280e+03, 0.19138000e+01, 0.96280000e+00},
    { 23, 12,  1,  2, 0.22498220e+03, 0.19138000e+01, 0.19496000e+01},
    { 23, 12,  2,  0, 0.40656420e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 12,  2,  1, 0.33467830e+03, 0.29110000e+01, 0.96280000e+00},
    { 23, 12,  2,  2, 0.21643950e+03, 0.29110000e+01, 0.19496000e+01},
    { 23, 13,  0,  0, 0.77034320e+03, 0.00000000e+00, 0.00000000e+00},
    { 23, 13,  0,  1, 0.69091560e+03, 0.00000000e+00, 0.96480000e+00},
    { 23, 13,  0,  2, 0.51913280e+03, 0.00000000e+00, 0.19311000e+01},
    { 23, 13,  0,  3, 0.38566110e+03, 0.00000000e+00, 0.29146000e+01},
    { 23, 13,  1,  0, 0.39004320e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 13,  1,  1, 0.35255750e+03, 0.19138000e+01, 0.96480000e+00},
    { 23, 13,  1,  2, 0.27224960e+03, 0.19138000e+01, 0.19311000e+01},
    { 23, 13,  1,  3, 0.20967420e+03, 0.19138000e+01, 0.29146000e+01},
    { 23, 13,  2,  0, 0.37280190e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 13,  2,  1, 0.33741280e+03, 0.29110000e+01, 0.96480000e+00},
    { 23, 13,  2,  2, 0.26172830e+03, 0.29110000e+01, 0.19311000e+01},
    { 23, 13,  2,  3, 0.20271680e+03, 0.29110000e+01, 0.29146000e+01},
    { 23, 14,  0,  0, 0.57211290e+03, 0.00000000e+00, 0.00000000e+00},
    { 23, 14,  0,  1, 0.52428080e+03, 0.00000000e+00, 0.95070000e+00},
    { 23, 14,  0,  2, 0.48345990e+03, 0.00000000e+00, 0.19435000e+01},
    { 23, 14,  0,  3, 0.47415850e+03, 0.00000000e+00, 0.29407000e+01},
    { 23, 14,  0,  4, 0.37420690e+03, 0.00000000e+00, 0.38677000e+01},
    { 23, 14,  1,  0, 0.30289850e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 14,  1,  1, 0.27935630e+03, 0.19138000e+01, 0.95070000e+00},
    { 23, 14,  1,  2, 0.25929250e+03, 0.19138000e+01, 0.19435000e+01},
    { 23, 14,  1,  3, 0.25306610e+03, 0.19138000e+01, 0.29407000e+01},
    { 23, 14,  1,  4, 0.20610620e+03, 0.19138000e+01, 0.38677000e+01},
    { 23, 14,  2,  0, 0.29163180e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 14,  2,  1, 0.26924130e+03, 0.29110000e+01, 0.95070000e+00},
    { 23, 14,  2,  2, 0.25015910e+03, 0.29110000e+01, 0.19435000e+01},
    { 23, 14,  2,  3, 0.24396540e+03, 0.29110000e+01, 0.29407000e+01},
    { 23, 14,  2,  4, 0.19966610e+03, 0.29110000e+01, 0.38677000e+01},
    { 23, 15,  0,  0, 0.42414700e+03, 0.00000000e+00, 0.00000000e+00},
    { 23, 15,  0,  1, 0.41101210e+03, 0.00000000e+00, 0.99470000e+00},
    { 23, 15,  0,  2, 0.40676720e+03, 0.00000000e+00, 0.20102000e+01},
    { 23, 15,  0,  3, 0.37223260e+03, 0.00000000e+00, 0.29859000e+01},
    { 23, 15,  1,  0, 0.23331760e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 15,  1,  1, 0.22637670e+03, 0.19138000e+01, 0.99470000e+00},
    { 23, 15,  1,  2, 0.22347840e+03, 0.19138000e+01, 0.20102000e+01},
    { 23, 15,  1,  3, 0.20662740e+03, 0.19138000e+01, 0.29859000e+01},
    { 23, 15,  2,  0, 0.22598490e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 15,  2,  1, 0.21930330e+03, 0.29110000e+01, 0.99470000e+00},
    { 23, 15,  2,  2, 0.21641010e+03, 0.29110000e+01, 0.20102000e+01},
    { 23, 15,  2,  3, 0.20040530e+03, 0.29110000e+01, 0.29859000e+01},
    { 23, 16,  0,  0, 0.34060200e+03, 0.00000000e+00, 0.00000000e+00},
    { 23, 16,  0,  1, 0.33712500e+03, 0.00000000e+00, 0.99480000e+00},
    { 23, 16,  0,  2, 0.33009380e+03, 0.00000000e+00, 0.19903000e+01},
    { 23, 16,  1,  0, 0.19211130e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 16,  1,  1, 0.19002990e+03, 0.19138000e+01, 0.99480000e+00},
    { 23, 16,  1,  2, 0.18615760e+03, 0.19138000e+01, 0.19903000e+01},
    { 23, 16,  2,  0, 0.18676650e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 16,  2,  1, 0.18472410e+03, 0.29110000e+01, 0.99480000e+00},
    { 23, 16,  2,  2, 0.18097100e+03, 0.29110000e+01, 0.19903000e+01},
    { 23, 17,  0,  0, 0.26948630e+03, 0.00000000e+00, 0.00000000e+00},
    { 23, 17,  0,  1, 0.26685570e+03, 0.00000000e+00, 0.99720000e+00},
    { 23, 17,  1,  0, 0.15575070e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 17,  1,  1, 0.15415760e+03, 0.19138000e+01, 0.99720000e+00},
    { 23, 17,  2,  0, 0.15194160e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 17,  2,  1, 0.15037570e+03, 0.29110000e+01, 0.99720000e+00},
    { 23, 18,  0,  0, 0.21440020e+03, 0.00000000e+00, 0.00000000e+00},
    { 23, 18,  1,  0, 0.12660270e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 18,  2,  0, 0.12386350e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 19,  0,  0, 0.21241985e+04, 0.00000000e+00, 0.00000000e+00},
    { 23, 19,  0,  1, 0.60799510e+03, 0.00000000e+00, 0.97670000e+00},
    { 23, 19,  1,  0, 0.94198370e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 19,  1,  1, 0.31011080e+03, 0.19138000e+01, 0.97670000e+00},
    { 23, 19,  2,  0, 0.87974450e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 19,  2,  1, 0.29674310e+03, 0.29110000e+01, 0.97670000e+00},
    { 23, 20,  0,  0, 0.16049178e+04, 0.00000000e+00, 0.00000000e+00},
    { 23, 20,  0,  1, 0.12821610e+04, 0.00000000e+00, 0.98310000e+00},
    { 23, 20,  0,  2, 0.59945210e+03, 0.00000000e+00, 0.19349000e+01},
    { 23, 20,  1,  0, 0.76007180e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 20,  1,  1, 0.60755710e+03, 0.19138000e+01, 0.98310000e+00},
    { 23, 20,  1,  2, 0.31546860e+03, 0.19138000e+01, 0.19349000e+01},
    { 23, 20,  2,  0, 0.71816300e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 20,  2,  1, 0.57423510e+03, 0.29110000e+01, 0.98310000e+00},
    { 23, 20,  2,  2, 0.30339700e+03, 0.29110000e+01, 0.19349000e+01},
    { 23, 21,  0,  0, 0.12995197e+04, 0.00000000e+00, 0.00000000e+00},
    { 23, 21,  0,  1, 0.57995840e+03, 0.00000000e+00, 0.18627000e+01},
    { 23, 21,  0,  2, 0.56271800e+03, 0.00000000e+00, 0.28999000e+01},
    { 23, 21,  1,  0, 0.62478010e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 21,  1,  1, 0.30673890e+03, 0.19138000e+01, 0.18627000e+01},
    { 23, 21,  1,  2, 0.30144200e+03, 0.19138000e+01, 0.28999000e+01},
    { 23, 21,  2,  0, 0.59186950e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 21,  2,  1, 0.29523740e+03, 0.29110000e+01, 0.18627000e+01},
    { 23, 21,  2,  2, 0.29073090e+03, 0.29110000e+01, 0.28999000e+01},
    { 23, 22,  0,  0, 0.12323235e+04, 0.00000000e+00, 0.00000000e+00},
    { 23, 22,  0,  1, 0.55911570e+03, 0.00000000e+00, 0.18299000e+01},
    { 23, 22,  0,  2, 0.56863160e+03, 0.00000000e+00, 0.38675000e+01},
    { 23, 22,  1,  0, 0.60052210e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 22,  1,  1, 0.29600290e+03, 0.19138000e+01, 0.18299000e+01},
    { 23, 22,  1,  2, 0.30502010e+03, 0.19138000e+01, 0.38675000e+01},
    { 23, 22,  2,  0, 0.57022820e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 22,  2,  1, 0.28494970e+03, 0.29110000e+01, 0.18299000e+01},
    { 23, 22,  2,  2, 0.29424170e+03, 0.29110000e+01, 0.38675000e+01},
    { 23, 23,  0,  0, 0.11160984e+04, 0.00000000e+00, 0.00000000e+00},
    { 23, 23,  1,  0, 0.54839080e+03, 0.19138000e+01, 0.00000000e+00},
    { 23, 23,  1,  1, 0.29014360e+03, 0.19138000e+01, 0.19138000e+01},
    { 23, 23,  2,  0, 0.52146020e+03, 0.29110000e+01, 0.00000000e+00},
    { 23, 23,  2,  1, 0.27927550e+03, 0.29110000e+01, 0.19138000e+01},
    { 23, 23,  2,  2, 0.26933490e+03, 0.29110000e+01, 0.29110000e+01},
    { 24,  1,  0,  0, 0.39122100e+02, 0.00000000e+00, 0.91180000e+00},
    { 24,  1,  0,  1, 0.65983700e+02, 0.00000000e+00, 0.00000000e+00},
    { 24,  1,  1,  0, 0.28056200e+02, 0.18269000e+01, 0.91180000e+00},
    { 24,  1,  1,  1, 0.45817300e+02, 0.18269000e+01, 0.00000000e+00},
    { 24,  1,  2,  0, 0.21313400e+02, 0.10619100e+02, 0.91180000e+00},
    { 24,  1,  2,  1, 0.33942700e+02, 0.10619100e+02, 0.00000000e+00},
    { 24,  2,  0,  0, 0.24146300e+02, 0.00000000e+00, 0.00000000e+00},
    { 24,  2,  1,  0, 0.18175400e+02, 0.18269000e+01, 0.00000000e+00},
    { 24,  2,  2,  0, 0.14405100e+02, 0.10619100e+02, 0.00000000e+00},
    { 24,  3,  0,  0, 0.84409360e+03, 0.00000000e+00, 0.00000000e+00},
    { 24,  3,  0,  1, 0.24050330e+03, 0.00000000e+00, 0.98650000e+00},
    { 24,  3,  1,  0, 0.48059440e+03, 0.18269000e+01, 0.00000000e+00},
    { 24,  3,  1,  1, 0.15375390e+03, 0.18269000e+01, 0.98650000e+00},
    { 24,  3,  2,  0, 0.31428070e+03, 0.10619100e+02, 0.00000000e+00},
    { 24,  3,  2,  1, 0.10775270e+03, 0.10619100e+02, 0.98650000e+00},
    { 24,  4,  0,  0, 0.41816350e+03, 0.00000000e+00, 0.00000000e+00},
    { 24,  4,  0,  1, 0.30260610e+03, 0.00000000e+00, 0.98080000e+00},
    { 24,  4,  0,  2, 0.18215580e+03, 0.00000000e+00, 0.19697000e+01},
    { 24,  4,  1,  0, 0.26540880e+03, 0.18269000e+01, 0.00000000e+00},
    { 24,  4,  1,  1, 0.19523170e+03, 0.18269000e+01, 0.98080000e+00},
    { 24,  4,  1,  2, 0.12446450e+03, 0.18269000e+01, 0.19697000e+01},
    { 24,  4,  2,  0, 0.18490790e+03, 0.10619100e+02, 0.00000000e+00},
    { 24,  4,  2,  1, 0.13789190e+03, 0.10619100e+02, 0.98080000e+00},
    { 24,  4,  2,  2, 0.91098500e+02, 0.10619100e+02, 0.19697000e+01},
    { 24,  5,  0,  0, 0.25930210e+03, 0.00000000e+00, 0.00000000e+00},
    { 24,  5,  0,  1, 0.21463600e+03, 0.00000000e+00, 0.97060000e+00},
    { 24,  5,  0,  2, 0.17740000e+03, 0.00000000e+00, 0.19441000e+01},
    { 24,  5,  0,  3, 0.12872330e+03, 0.00000000e+00, 0.29128000e+01},
    { 24,  5,  0,  4, 0.12032780e+03, 0.00000000e+00, 0.45856000e+01},
    { 24,  5,  1,  0, 0.17437190e+03, 0.18269000e+01, 0.00000000e+00},
    { 24,  5,  1,  1, 0.14594770e+03, 0.18269000e+01, 0.97060000e+00},
    { 24,  5,  1,  2, 0.12193400e+03, 0.18269000e+01, 0.19441000e+01},
    { 24,  5,  1,  3, 0.91452800e+02, 0.18269000e+01, 0.29128000e+01},
    { 24,  5,  1,  4, 0.85880600e+02, 0.18269000e+01, 0.45856000e+01},
    { 24,  5,  2,  0, 0.12637360e+03, 0.10619100e+02, 0.00000000e+00},
    { 24,  5,  2,  1, 0.10672440e+03, 0.10619100e+02, 0.97060000e+00},
    { 24,  5,  2,  2, 0.89961000e+02, 0.10619100e+02, 0.19441000e+01},
    { 24,  5,  2,  3, 0.68995800e+02, 0.10619100e+02, 0.29128000e+01},
    { 24,  5,  2,  4, 0.65034900e+02, 0.10619100e+02, 0.45856000e+01},
    { 24,  6,  0,  0, 0.16498820e+03, 0.00000000e+00, 0.00000000e+00},
    { 24,  6,  0,  1, 0.15511710e+03, 0.00000000e+00, 0.98680000e+00},
    { 24,  6,  0,  2, 0.12325910e+03, 0.00000000e+00, 0.19985000e+01},
    { 24,  6,  0,  3, 0.11536970e+03, 0.00000000e+00, 0.29987000e+01},
    { 24,  6,  0,  4, 0.91023300e+02, 0.00000000e+00, 0.39844000e+01},
    { 24,  6,  1,  0, 0.11571820e+03, 0.18269000e+01, 0.00000000e+00},
    { 24,  6,  1,  1, 0.10858200e+03, 0.18269000e+01, 0.98680000e+00},
    { 24,  6,  1,  2, 0.87888900e+02, 0.18269000e+01, 0.19985000e+01},
    { 24,  6,  1,  3, 0.82233100e+02, 0.18269000e+01, 0.29987000e+01},
    { 24,  6,  1,  4, 0.66556800e+02, 0.18269000e+01, 0.39844000e+01},
    { 24,  6,  2,  0, 0.86546400e+02, 0.10619100e+02, 0.00000000e+00},
    { 24,  6,  2,  1, 0.81233500e+02, 0.10619100e+02, 0.98680000e+00},
    { 24,  6,  2,  2, 0.66613100e+02, 0.10619100e+02, 0.19985000e+01},
    { 24,  6,  2,  3, 0.62396300e+02, 0.10619100e+02, 0.29987000e+01},
    { 24,  6,  2,  4, 0.51461000e+02, 0.10619100e+02, 0.39844000e+01},
    { 24,  7,  0,  0, 0.11048610e+03, 0.00000000e+00, 0.00000000e+00},
    { 24,  7,  0,  1, 0.10301890e+03, 0.00000000e+00, 0.99440000e+00},
    { 24,  7,  0,  2, 0.96254700e+02, 0.00000000e+00, 0.20143000e+01},
    { 24,  7,  0,  3, 0.84363100e+02, 0.00000000e+00, 0.29903000e+01},
    { 24,  7,  1,  0, 0.79902400e+02, 0.18269000e+01, 0.00000000e+00},
    { 24,  7,  1,  1, 0.74489000e+02, 0.18269000e+01, 0.99440000e+00},
    { 24,  7,  1,  2, 0.69847100e+02, 0.18269000e+01, 0.20143000e+01},
    { 24,  7,  1,  3, 0.61420200e+02, 0.18269000e+01, 0.29903000e+01},
    { 24,  7,  2,  0, 0.61247100e+02, 0.10619100e+02, 0.00000000e+00},
    { 24,  7,  2,  1, 0.57176600e+02, 0.10619100e+02, 0.99440000e+00},
    { 24,  7,  2,  2, 0.53772600e+02, 0.10619100e+02, 0.20143000e+01},
    { 24,  7,  2,  3, 0.47503300e+02, 0.10619100e+02, 0.29903000e+01},
    { 24,  8,  0,  0, 0.81200000e+02, 0.00000000e+00, 0.00000000e+00},
    { 24,  8,  0,  1, 0.72287200e+02, 0.00000000e+00, 0.99250000e+00},
    { 24,  8,  0,  2, 0.63186700e+02, 0.00000000e+00, 0.19887000e+01},
    { 24,  8,  1,  0, 0.59982900e+02, 0.18269000e+01, 0.00000000e+00},
    { 24,  8,  1,  1, 0.53673300e+02, 0.18269000e+01, 0.99250000e+00},
    { 24,  8,  1,  2, 0.47229700e+02, 0.18269000e+01, 0.19887000e+01},
    { 24,  8,  2,  0, 0.46813800e+02, 0.10619100e+02, 0.00000000e+00},
    { 24,  8,  2,  1, 0.42104600e+02, 0.10619100e+02, 0.99250000e+00},
    { 24,  8,  2,  2, 0.37302400e+02, 0.10619100e+02, 0.19887000e+01},
    { 24,  9,  0,  0, 0.60009900e+02, 0.00000000e+00, 0.00000000e+00},
    { 24,  9,  0,  1, 0.47531800e+02, 0.00000000e+00, 0.99820000e+00},
    { 24,  9,  1,  0, 0.45129000e+02, 0.18269000e+01, 0.00000000e+00},
    { 24,  9,  1,  1, 0.36459400e+02, 0.18269000e+01, 0.99820000e+00},
    { 24,  9,  2,  0, 0.35781100e+02, 0.10619100e+02, 0.00000000e+00},
    { 24,  9,  2,  1, 0.29392300e+02, 0.10619100e+02, 0.99820000e+00},
    { 24, 10,  0,  0, 0.45282000e+02, 0.00000000e+00, 0.00000000e+00},
    { 24, 10,  1,  0, 0.34535000e+02, 0.18269000e+01, 0.00000000e+00},
    { 24, 10,  2,  0, 0.27737200e+02, 0.10619100e+02, 0.00000000e+00},
    { 24, 11,  0,  0, 0.10004652e+04, 0.00000000e+00, 0.00000000e+00},
    { 24, 11,  0,  1, 0.35715080e+03, 0.00000000e+00, 0.96840000e+00},
    { 24, 11,  1,  0, 0.57314360e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 11,  1,  1, 0.22578370e+03, 0.18269000e+01, 0.96840000e+00},
    { 24, 11,  2,  0, 0.37649060e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 11,  2,  1, 0.15738300e+03, 0.10619100e+02, 0.96840000e+00},
    { 24, 12,  0,  0, 0.68440150e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 12,  0,  1, 0.55661270e+03, 0.00000000e+00, 0.96280000e+00},
    { 24, 12,  0,  2, 0.33501180e+03, 0.00000000e+00, 0.19496000e+01},
    { 24, 12,  1,  0, 0.42622760e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 12,  1,  1, 0.34993280e+03, 0.18269000e+01, 0.96280000e+00},
    { 24, 12,  1,  2, 0.22318550e+03, 0.18269000e+01, 0.19496000e+01},
    { 24, 12,  2,  0, 0.29367770e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 12,  2,  1, 0.24300490e+03, 0.10619100e+02, 0.96280000e+00},
    { 24, 12,  2,  2, 0.16055540e+03, 0.10619100e+02, 0.19496000e+01},
    { 24, 13,  0,  0, 0.60440710e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 13,  0,  1, 0.54224590e+03, 0.00000000e+00, 0.96480000e+00},
    { 24, 13,  0,  2, 0.40772880e+03, 0.00000000e+00, 0.19311000e+01},
    { 24, 13,  0,  3, 0.30312660e+03, 0.00000000e+00, 0.29146000e+01},
    { 24, 13,  1,  0, 0.38786950e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 13,  1,  1, 0.35042960e+03, 0.18269000e+01, 0.96480000e+00},
    { 24, 13,  1,  2, 0.27016230e+03, 0.18269000e+01, 0.19311000e+01},
    { 24, 13,  1,  3, 0.20762990e+03, 0.18269000e+01, 0.29146000e+01},
    { 24, 13,  2,  0, 0.27250150e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 13,  2,  1, 0.24743720e+03, 0.10619100e+02, 0.96480000e+00},
    { 24, 13,  2,  2, 0.19398150e+03, 0.10619100e+02, 0.19311000e+01},
    { 24, 13,  2,  3, 0.15223080e+03, 0.10619100e+02, 0.29146000e+01},
    { 24, 14,  0,  0, 0.44922160e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 14,  0,  1, 0.41188790e+03, 0.00000000e+00, 0.95070000e+00},
    { 24, 14,  0,  2, 0.37993850e+03, 0.00000000e+00, 0.19435000e+01},
    { 24, 14,  0,  3, 0.37278380e+03, 0.00000000e+00, 0.29407000e+01},
    { 24, 14,  0,  4, 0.29450370e+03, 0.00000000e+00, 0.38677000e+01},
    { 24, 14,  1,  0, 0.30039280e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 14,  1,  1, 0.27695120e+03, 0.18269000e+01, 0.95070000e+00},
    { 24, 14,  1,  2, 0.25696820e+03, 0.18269000e+01, 0.19435000e+01},
    { 24, 14,  1,  3, 0.25088270e+03, 0.18269000e+01, 0.29407000e+01},
    { 24, 14,  1,  4, 0.20396330e+03, 0.18269000e+01, 0.38677000e+01},
    { 24, 14,  2,  0, 0.21680010e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 14,  2,  1, 0.20073440e+03, 0.10619100e+02, 0.95070000e+00},
    { 24, 14,  2,  2, 0.18700360e+03, 0.10619100e+02, 0.19435000e+01},
    { 24, 14,  2,  3, 0.18218540e+03, 0.10619100e+02, 0.29407000e+01},
    { 24, 14,  2,  4, 0.15083440e+03, 0.10619100e+02, 0.38677000e+01},
    { 24, 15,  0,  0, 0.33383800e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 15,  0,  1, 0.32359140e+03, 0.00000000e+00, 0.99470000e+00},
    { 24, 15,  0,  2, 0.32027340e+03, 0.00000000e+00, 0.20102000e+01},
    { 24, 15,  0,  3, 0.29326800e+03, 0.00000000e+00, 0.29859000e+01},
    { 24, 15,  1,  0, 0.23090900e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 15,  1,  1, 0.22403030e+03, 0.18269000e+01, 0.99470000e+00},
    { 24, 15,  1,  2, 0.22119860e+03, 0.18269000e+01, 0.20102000e+01},
    { 24, 15,  1,  3, 0.20440810e+03, 0.18269000e+01, 0.29859000e+01},
    { 24, 15,  2,  0, 0.17067670e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 15,  2,  1, 0.16576280e+03, 0.10619100e+02, 0.99470000e+00},
    { 24, 15,  2,  2, 0.16347330e+03, 0.10619100e+02, 0.20102000e+01},
    { 24, 15,  2,  3, 0.15200100e+03, 0.10619100e+02, 0.29859000e+01},
    { 24, 16,  0,  0, 0.26880290e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 16,  0,  1, 0.26607620e+03, 0.00000000e+00, 0.99480000e+00},
    { 24, 16,  0,  2, 0.26056470e+03, 0.00000000e+00, 0.19903000e+01},
    { 24, 16,  1,  0, 0.18990520e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 16,  1,  1, 0.18785700e+03, 0.18269000e+01, 0.99480000e+00},
    { 24, 16,  1,  2, 0.18402800e+03, 0.18269000e+01, 0.19903000e+01},
    { 24, 16,  2,  0, 0.14267950e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 16,  2,  1, 0.14110920e+03, 0.10619100e+02, 0.99480000e+00},
    { 24, 16,  2,  2, 0.13829440e+03, 0.10619100e+02, 0.19903000e+01},
    { 24, 17,  0,  0, 0.21336680e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 17,  0,  1, 0.21129280e+03, 0.00000000e+00, 0.99720000e+00},
    { 24, 17,  1,  0, 0.15380570e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 17,  1,  1, 0.15223830e+03, 0.18269000e+01, 0.99720000e+00},
    { 24, 17,  2,  0, 0.11742580e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 17,  2,  1, 0.11621000e+03, 0.10619100e+02, 0.99720000e+00},
    { 24, 18,  0,  0, 0.17034650e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 18,  1,  0, 0.12492650e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 18,  2,  0, 0.96759300e+02, 0.10619100e+02, 0.00000000e+00},
    { 24, 19,  0,  0, 0.16836701e+04, 0.00000000e+00, 0.00000000e+00},
    { 24, 19,  0,  1, 0.47897440e+03, 0.00000000e+00, 0.97670000e+00},
    { 24, 19,  1,  0, 0.94587000e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 19,  1,  1, 0.30839010e+03, 0.18269000e+01, 0.97670000e+00},
    { 24, 19,  2,  0, 0.61705660e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 19,  2,  1, 0.21890440e+03, 0.10619100e+02, 0.97670000e+00},
    { 24, 20,  0,  0, 0.12630809e+04, 0.00000000e+00, 0.00000000e+00},
    { 24, 20,  0,  1, 0.10115955e+04, 0.00000000e+00, 0.98310000e+00},
    { 24, 20,  0,  2, 0.47138320e+03, 0.00000000e+00, 0.19349000e+01},
    { 24, 20,  1,  0, 0.75936840e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 20,  1,  1, 0.60707000e+03, 0.18269000e+01, 0.98310000e+00},
    { 24, 20,  1,  2, 0.31305380e+03, 0.18269000e+01, 0.19349000e+01},
    { 24, 20,  2,  0, 0.51377680e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 20,  2,  1, 0.41206100e+03, 0.10619100e+02, 0.98310000e+00},
    { 24, 20,  2,  2, 0.22568810e+03, 0.10619100e+02, 0.19349000e+01},
    { 24, 21,  0,  0, 0.10216871e+04, 0.00000000e+00, 0.00000000e+00},
    { 24, 21,  0,  1, 0.45620230e+03, 0.00000000e+00, 0.18627000e+01},
    { 24, 21,  0,  2, 0.44267360e+03, 0.00000000e+00, 0.28999000e+01},
    { 24, 21,  1,  0, 0.62353320e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 21,  1,  1, 0.30430940e+03, 0.18269000e+01, 0.18627000e+01},
    { 24, 21,  1,  2, 0.29881900e+03, 0.18269000e+01, 0.28999000e+01},
    { 24, 21,  2,  0, 0.42547450e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 21,  2,  1, 0.22010130e+03, 0.10619100e+02, 0.18627000e+01},
    { 24, 21,  2,  2, 0.21764940e+03, 0.10619100e+02, 0.28999000e+01},
    { 24, 22,  0,  0, 0.96885650e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 22,  0,  1, 0.44007620e+03, 0.00000000e+00, 0.18299000e+01},
    { 24, 22,  0,  2, 0.44737630e+03, 0.00000000e+00, 0.38675000e+01},
    { 24, 22,  1,  0, 0.59879810e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 22,  1,  1, 0.29365980e+03, 0.18269000e+01, 0.18299000e+01},
    { 24, 22,  1,  2, 0.30234740e+03, 0.18269000e+01, 0.38675000e+01},
    { 24, 22,  2,  0, 0.41213870e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 22,  2,  1, 0.21264500e+03, 0.10619100e+02, 0.18299000e+01},
    { 24, 22,  2,  2, 0.22041700e+03, 0.10619100e+02, 0.38675000e+01},
    { 24, 23,  0,  0, 0.87738550e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 23,  0,  1, 0.43166830e+03, 0.00000000e+00, 0.19138000e+01},
    { 24, 23,  0,  2, 0.41056610e+03, 0.00000000e+00, 0.29110000e+01},
    { 24, 23,  1,  0, 0.54652440e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 23,  1,  1, 0.28786570e+03, 0.18269000e+01, 0.19138000e+01},
    { 24, 23,  1,  2, 0.27688190e+03, 0.18269000e+01, 0.29110000e+01},
    { 24, 23,  2,  0, 0.37806600e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 23,  2,  1, 0.20840940e+03, 0.10619100e+02, 0.19138000e+01},
    { 24, 23,  2,  2, 0.20186410e+03, 0.10619100e+02, 0.29110000e+01},
    { 24, 24,  0,  0, 0.69074250e+03, 0.00000000e+00, 0.00000000e+00},
    { 24, 24,  1,  0, 0.43023530e+03, 0.18269000e+01, 0.00000000e+00},
    { 24, 24,  1,  1, 0.28569050e+03, 0.18269000e+01, 0.18269000e+01},
    { 24, 24,  2,  0, 0.29848940e+03, 0.10619100e+02, 0.00000000e+00},
    { 24, 24,  2,  1, 0.20634260e+03, 0.10619100e+02, 0.18269000e+01},
    { 24, 24,  2,  2, 0.15334350e+03, 0.10619100e+02, 0.10619100e+02},
    { 25,  1,  0,  0, 0.43002800e+02, 0.00000000e+00, 0.91180000e+00},
    { 25,  1,  0,  1, 0.72411100e+02, 0.00000000e+00, 0.00000000e+00},
    { 25,  1,  1,  0, 0.26181000e+02, 0.16406000e+01, 0.91180000e+00},
    { 25,  1,  1,  1, 0.42392700e+02, 0.16406000e+01, 0.00000000e+00},
    { 25,  1,  2,  0, 0.18469400e+02, 0.98849000e+01, 0.91180000e+00},
    { 25,  1,  2,  1, 0.29120800e+02, 0.98849000e+01, 0.00000000e+00},
    { 25,  2,  0,  0, 0.26497800e+02, 0.00000000e+00, 0.00000000e+00},
    { 25,  2,  1,  0, 0.17152600e+02, 0.16406000e+01, 0.00000000e+00},
    { 25,  2,  2,  0, 0.12698500e+02, 0.98849000e+01, 0.00000000e+00},
    { 25,  3,  0,  0, 0.89197560e+03, 0.00000000e+00, 0.00000000e+00},
    { 25,  3,  0,  1, 0.26090190e+03, 0.00000000e+00, 0.98650000e+00},
    { 25,  3,  1,  0, 0.41608360e+03, 0.16406000e+01, 0.00000000e+00},
    { 25,  3,  1,  1, 0.13874910e+03, 0.16406000e+01, 0.98650000e+00},
    { 25,  3,  2,  0, 0.25656890e+03, 0.98849000e+01, 0.00000000e+00},
    { 25,  3,  2,  1, 0.90423100e+02, 0.98849000e+01, 0.98650000e+00},
    { 25,  4,  0,  0, 0.45336860e+03, 0.00000000e+00, 0.00000000e+00},
    { 25,  4,  0,  1, 0.32840120e+03, 0.00000000e+00, 0.98080000e+00},
    { 25,  4,  0,  2, 0.19964260e+03, 0.00000000e+00, 0.19697000e+01},
    { 25,  4,  1,  0, 0.23896060e+03, 0.16406000e+01, 0.00000000e+00},
    { 25,  4,  1,  1, 0.17668170e+03, 0.16406000e+01, 0.98080000e+00},
    { 25,  4,  1,  2, 0.11464650e+03, 0.16406000e+01, 0.19697000e+01},
    { 25,  4,  2,  0, 0.15476870e+03, 0.98849000e+01, 0.00000000e+00},
    { 25,  4,  2,  1, 0.11610320e+03, 0.98849000e+01, 0.98080000e+00},
    { 25,  4,  2,  2, 0.77782300e+02, 0.98849000e+01, 0.19697000e+01},
    { 25,  5,  0,  0, 0.28347440e+03, 0.00000000e+00, 0.00000000e+00},
    { 25,  5,  0,  1, 0.23480000e+03, 0.00000000e+00, 0.97060000e+00},
    { 25,  5,  0,  2, 0.19413780e+03, 0.00000000e+00, 0.19441000e+01},
    { 25,  5,  0,  3, 0.14140710e+03, 0.00000000e+00, 0.29128000e+01},
    { 25,  5,  0,  4, 0.13219840e+03, 0.00000000e+00, 0.45856000e+01},
    { 25,  5,  1,  0, 0.15984920e+03, 0.16406000e+01, 0.00000000e+00},
    { 25,  5,  1,  1, 0.13421360e+03, 0.16406000e+01, 0.97060000e+00},
    { 25,  5,  1,  2, 0.11246480e+03, 0.16406000e+01, 0.19441000e+01},
    { 25,  5,  1,  3, 0.85131200e+02, 0.16406000e+01, 0.29128000e+01},
    { 25,  5,  1,  4, 0.80037500e+02, 0.16406000e+01, 0.45856000e+01},
    { 25,  5,  2,  0, 0.10748660e+03, 0.98849000e+01, 0.00000000e+00},
    { 25,  5,  2,  1, 0.91109100e+02, 0.98849000e+01, 0.97060000e+00},
    { 25,  5,  2,  2, 0.77081200e+02, 0.98849000e+01, 0.19441000e+01},
    { 25,  5,  2,  3, 0.59631300e+02, 0.98849000e+01, 0.29128000e+01},
    { 25,  5,  2,  4, 0.56292100e+02, 0.98849000e+01, 0.45856000e+01},
    { 25,  6,  0,  0, 0.18100350e+03, 0.00000000e+00, 0.00000000e+00},
    { 25,  6,  0,  1, 0.16997960e+03, 0.00000000e+00, 0.98680000e+00},
    { 25,  6,  0,  2, 0.13529940e+03, 0.00000000e+00, 0.19985000e+01},
    { 25,  6,  0,  3, 0.12654160e+03, 0.00000000e+00, 0.29987000e+01},
    { 25,  6,  0,  4, 0.99976800e+02, 0.00000000e+00, 0.39844000e+01},
    { 25,  6,  1,  0, 0.10733820e+03, 0.16406000e+01, 0.00000000e+00},
    { 25,  6,  1,  1, 0.10064630e+03, 0.16406000e+01, 0.98680000e+00},
    { 25,  6,  1,  2, 0.81873100e+02, 0.16406000e+01, 0.19985000e+01},
    { 25,  6,  1,  3, 0.76584600e+02, 0.16406000e+01, 0.29987000e+01},
    { 25,  6,  1,  4, 0.62393100e+02, 0.16406000e+01, 0.39844000e+01},
    { 25,  6,  2,  0, 0.74551100e+02, 0.98849000e+01, 0.00000000e+00},
    { 25,  6,  2,  1, 0.69988300e+02, 0.98849000e+01, 0.98680000e+00},
    { 25,  6,  2,  2, 0.57689300e+02, 0.98849000e+01, 0.19985000e+01},
    { 25,  6,  2,  3, 0.54067600e+02, 0.98849000e+01, 0.29987000e+01},
    { 25,  6,  2,  4, 0.44917900e+02, 0.98849000e+01, 0.39844000e+01},
    { 25,  7,  0,  0, 0.12132330e+03, 0.00000000e+00, 0.00000000e+00},
    { 25,  7,  0,  1, 0.11302480e+03, 0.00000000e+00, 0.99440000e+00},
    { 25,  7,  0,  2, 0.10560800e+03, 0.00000000e+00, 0.20143000e+01},
    { 25,  7,  0,  3, 0.92463600e+02, 0.00000000e+00, 0.29903000e+01},
    { 25,  7,  1,  0, 0.74699800e+02, 0.16406000e+01, 0.00000000e+00},
    { 25,  7,  1,  1, 0.69621500e+02, 0.16406000e+01, 0.99440000e+00},
    { 25,  7,  1,  2, 0.65341500e+02, 0.16406000e+01, 0.20143000e+01},
    { 25,  7,  1,  3, 0.57491500e+02, 0.16406000e+01, 0.29903000e+01},
    { 25,  7,  2,  0, 0.53282800e+02, 0.98849000e+01, 0.00000000e+00},
    { 25,  7,  2,  1, 0.49769800e+02, 0.98849000e+01, 0.99440000e+00},
    { 25,  7,  2,  2, 0.46868100e+02, 0.98849000e+01, 0.20143000e+01},
    { 25,  7,  2,  3, 0.41486200e+02, 0.98849000e+01, 0.29903000e+01},
    { 25,  8,  0,  0, 0.89134600e+02, 0.00000000e+00, 0.00000000e+00},
    { 25,  8,  0,  1, 0.79304700e+02, 0.00000000e+00, 0.99250000e+00},
    { 25,  8,  0,  2, 0.69259800e+02, 0.00000000e+00, 0.19887000e+01},
    { 25,  8,  1,  0, 0.56362200e+02, 0.16406000e+01, 0.00000000e+00},
    { 25,  8,  1,  1, 0.50485800e+02, 0.16406000e+01, 0.99250000e+00},
    { 25,  8,  1,  2, 0.44488800e+02, 0.16406000e+01, 0.19887000e+01},
    { 25,  8,  2,  0, 0.41023700e+02, 0.98849000e+01, 0.00000000e+00},
    { 25,  8,  2,  1, 0.36969200e+02, 0.98849000e+01, 0.99250000e+00},
    { 25,  8,  2,  2, 0.32849500e+02, 0.98849000e+01, 0.19887000e+01},
    { 25,  9,  0,  0, 0.65811200e+02, 0.00000000e+00, 0.00000000e+00},
    { 25,  9,  0,  1, 0.52078000e+02, 0.00000000e+00, 0.99820000e+00},
    { 25,  9,  1,  0, 0.42576400e+02, 0.16406000e+01, 0.00000000e+00},
    { 25,  9,  1,  1, 0.34548100e+02, 0.16406000e+01, 0.99820000e+00},
    { 25,  9,  2,  0, 0.31558200e+02, 0.98849000e+01, 0.00000000e+00},
    { 25,  9,  2,  1, 0.26092600e+02, 0.98849000e+01, 0.99820000e+00},
    { 25, 10,  0,  0, 0.49595900e+02, 0.00000000e+00, 0.00000000e+00},
    { 25, 10,  1,  0, 0.32680600e+02, 0.16406000e+01, 0.00000000e+00},
    { 25, 10,  2,  0, 0.24595700e+02, 0.98849000e+01, 0.00000000e+00},
    { 25, 11,  0,  0, 0.10585103e+04, 0.00000000e+00, 0.00000000e+00},
    { 25, 11,  0,  1, 0.38634260e+03, 0.00000000e+00, 0.96840000e+00},
    { 25, 11,  1,  0, 0.49735820e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 11,  1,  1, 0.20296760e+03, 0.16406000e+01, 0.96840000e+00},
    { 25, 11,  2,  0, 0.30795570e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 11,  2,  1, 0.13182570e+03, 0.98849000e+01, 0.96840000e+00},
    { 25, 12,  0,  0, 0.73904110e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 12,  0,  1, 0.60144990e+03, 0.00000000e+00, 0.96280000e+00},
    { 25, 12,  0,  2, 0.36600240e+03, 0.00000000e+00, 0.19496000e+01},
    { 25, 12,  1,  0, 0.38129680e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 12,  1,  1, 0.31401190e+03, 0.16406000e+01, 0.96280000e+00},
    { 25, 12,  1,  2, 0.20404460e+03, 0.16406000e+01, 0.19496000e+01},
    { 25, 12,  2,  0, 0.24475170e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 12,  2,  1, 0.20321730e+03, 0.98849000e+01, 0.96280000e+00},
    { 25, 12,  2,  2, 0.13616190e+03, 0.98849000e+01, 0.19496000e+01},
    { 25, 13,  0,  0, 0.65607380e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 13,  0,  1, 0.58914750e+03, 0.00000000e+00, 0.96480000e+00},
    { 25, 13,  0,  2, 0.44462830e+03, 0.00000000e+00, 0.19311000e+01},
    { 25, 13,  0,  3, 0.33231560e+03, 0.00000000e+00, 0.29146000e+01},
    { 25, 13,  1,  0, 0.35045220e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 13,  1,  1, 0.31732870e+03, 0.16406000e+01, 0.96480000e+00},
    { 25, 13,  1,  2, 0.24655880e+03, 0.16406000e+01, 0.19311000e+01},
    { 25, 13,  1,  3, 0.19138970e+03, 0.16406000e+01, 0.29146000e+01},
    { 25, 13,  2,  0, 0.22891250e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 13,  2,  1, 0.20829020e+03, 0.98849000e+01, 0.96480000e+00},
    { 25, 13,  2,  2, 0.16440450e+03, 0.98849000e+01, 0.19311000e+01},
    { 25, 13,  2,  3, 0.13008090e+03, 0.98849000e+01, 0.29146000e+01},
    { 25, 14,  0,  0, 0.49081560e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 14,  0,  1, 0.45022340e+03, 0.00000000e+00, 0.95070000e+00},
    { 25, 14,  0,  2, 0.41561120e+03, 0.00000000e+00, 0.19435000e+01},
    { 25, 14,  0,  3, 0.40724250e+03, 0.00000000e+00, 0.29407000e+01},
    { 25, 14,  0,  4, 0.32309480e+03, 0.00000000e+00, 0.38677000e+01},
    { 25, 14,  1,  0, 0.27492570e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 14,  1,  1, 0.25388000e+03, 0.16406000e+01, 0.95070000e+00},
    { 25, 14,  1,  2, 0.23596760e+03, 0.16406000e+01, 0.19435000e+01},
    { 25, 14,  1,  3, 0.23001820e+03, 0.16406000e+01, 0.29407000e+01},
    { 25, 14,  1,  4, 0.18858340e+03, 0.16406000e+01, 0.38677000e+01},
    { 25, 14,  2,  0, 0.18409450e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 14,  2,  1, 0.17075150e+03, 0.98849000e+01, 0.95070000e+00},
    { 25, 14,  2,  2, 0.15932860e+03, 0.98849000e+01, 0.19435000e+01},
    { 25, 14,  2,  3, 0.15510950e+03, 0.98849000e+01, 0.29407000e+01},
    { 25, 14,  2,  4, 0.12933240e+03, 0.98849000e+01, 0.38677000e+01},
    { 25, 15,  0,  0, 0.36612040e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 15,  0,  1, 0.35484320e+03, 0.00000000e+00, 0.99470000e+00},
    { 25, 15,  0,  2, 0.35102240e+03, 0.00000000e+00, 0.20102000e+01},
    { 25, 15,  0,  3, 0.32176790e+03, 0.00000000e+00, 0.29859000e+01},
    { 25, 15,  1,  0, 0.21341010e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 15,  1,  1, 0.20709950e+03, 0.16406000e+01, 0.99470000e+00},
    { 25, 15,  1,  2, 0.20433190e+03, 0.16406000e+01, 0.20102000e+01},
    { 25, 15,  1,  3, 0.18931020e+03, 0.16406000e+01, 0.29859000e+01},
    { 25, 15,  2,  0, 0.14631750e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 15,  2,  1, 0.14216740e+03, 0.98849000e+01, 0.99470000e+00},
    { 25, 15,  2,  2, 0.14014430e+03, 0.98849000e+01, 0.20102000e+01},
    { 25, 15,  2,  3, 0.13062480e+03, 0.98849000e+01, 0.29859000e+01},
    { 25, 16,  0,  0, 0.29517370e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 16,  0,  1, 0.29212570e+03, 0.00000000e+00, 0.99480000e+00},
    { 25, 16,  0,  2, 0.28605270e+03, 0.00000000e+00, 0.19903000e+01},
    { 25, 16,  1,  0, 0.17651650e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 16,  1,  1, 0.17457750e+03, 0.16406000e+01, 0.99480000e+00},
    { 25, 16,  1,  2, 0.17103060e+03, 0.16406000e+01, 0.19903000e+01},
    { 25, 16,  2,  0, 0.12311700e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 16,  2,  1, 0.12175410e+03, 0.98849000e+01, 0.99480000e+00},
    { 25, 16,  2,  2, 0.11934860e+03, 0.98849000e+01, 0.19903000e+01},
    { 25, 17,  0,  0, 0.23445330e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 17,  0,  1, 0.23214470e+03, 0.00000000e+00, 0.99720000e+00},
    { 25, 17,  1,  0, 0.14370010e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 17,  1,  1, 0.14221510e+03, 0.16406000e+01, 0.99720000e+00},
    { 25, 17,  2,  0, 0.10197460e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 17,  2,  1, 0.10091430e+03, 0.98849000e+01, 0.99720000e+00},
    { 25, 18,  0,  0, 0.18717280e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 18,  1,  0, 0.11720570e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 18,  2,  0, 0.84510700e+02, 0.98849000e+01, 0.00000000e+00},
    { 25, 19,  0,  0, 0.17680322e+04, 0.00000000e+00, 0.00000000e+00},
    { 25, 19,  0,  1, 0.51805830e+03, 0.00000000e+00, 0.97670000e+00},
    { 25, 19,  1,  0, 0.81424680e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 19,  1,  1, 0.27872590e+03, 0.16406000e+01, 0.97670000e+00},
    { 25, 19,  2,  0, 0.50386210e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 19,  2,  1, 0.18481700e+03, 0.98849000e+01, 0.97670000e+00},
    { 25, 20,  0,  0, 0.13514785e+04, 0.00000000e+00, 0.00000000e+00},
    { 25, 20,  0,  1, 0.10791532e+04, 0.00000000e+00, 0.98310000e+00},
    { 25, 20,  0,  2, 0.51365160e+03, 0.00000000e+00, 0.19349000e+01},
    { 25, 20,  1,  0, 0.67083370e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 20,  1,  1, 0.53581490e+03, 0.16406000e+01, 0.98310000e+00},
    { 25, 20,  1,  2, 0.28580680e+03, 0.16406000e+01, 0.19349000e+01},
    { 25, 20,  2,  0, 0.42523820e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 20,  2,  1, 0.34176740e+03, 0.98849000e+01, 0.98310000e+00},
    { 25, 20,  2,  2, 0.19163220e+03, 0.98849000e+01, 0.19349000e+01},
    { 25, 21,  0,  0, 0.10971539e+04, 0.00000000e+00, 0.00000000e+00},
    { 25, 21,  0,  1, 0.49734740e+03, 0.00000000e+00, 0.18627000e+01},
    { 25, 21,  0,  2, 0.48359930e+03, 0.00000000e+00, 0.28999000e+01},
    { 25, 21,  1,  0, 0.55379310e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 21,  1,  1, 0.27819650e+03, 0.16406000e+01, 0.18627000e+01},
    { 25, 21,  1,  2, 0.27417030e+03, 0.16406000e+01, 0.28999000e+01},
    { 25, 21,  2,  0, 0.35332830e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 21,  2,  1, 0.18713640e+03, 0.98849000e+01, 0.18627000e+01},
    { 25, 21,  2,  2, 0.18555440e+03, 0.98849000e+01, 0.28999000e+01},
    { 25, 22,  0,  0, 0.10426625e+04, 0.00000000e+00, 0.00000000e+00},
    { 25, 22,  0,  1, 0.47949690e+03, 0.00000000e+00, 0.18299000e+01},
    { 25, 22,  0,  2, 0.48878880e+03, 0.00000000e+00, 0.38675000e+01},
    { 25, 22,  1,  0, 0.53412660e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 22,  1,  1, 0.26846570e+03, 0.16406000e+01, 0.18299000e+01},
    { 25, 22,  1,  2, 0.27750050e+03, 0.16406000e+01, 0.38675000e+01},
    { 25, 22,  2,  0, 0.34349160e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 22,  2,  1, 0.18091050e+03, 0.98849000e+01, 0.18299000e+01},
    { 25, 22,  2,  2, 0.18798380e+03, 0.98849000e+01, 0.38675000e+01},
    { 25, 23,  0,  0, 0.94560720e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 23,  0,  1, 0.47025290e+03, 0.00000000e+00, 0.19138000e+01},
    { 25, 23,  0,  2, 0.44806980e+03, 0.00000000e+00, 0.29110000e+01},
    { 25, 23,  1,  0, 0.48879470e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 23,  1,  1, 0.26311270e+03, 0.16406000e+01, 0.19138000e+01},
    { 25, 23,  1,  2, 0.25393700e+03, 0.16406000e+01, 0.29110000e+01},
    { 25, 23,  2,  0, 0.31574920e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 23,  2,  1, 0.17729930e+03, 0.98849000e+01, 0.19138000e+01},
    { 25, 23,  2,  2, 0.17219800e+03, 0.98849000e+01, 0.29110000e+01},
    { 25, 24,  0,  0, 0.74331790e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 24,  0,  1, 0.46829610e+03, 0.00000000e+00, 0.18269000e+01},
    { 25, 24,  0,  2, 0.32635580e+03, 0.00000000e+00, 0.10619100e+02},
    { 25, 24,  1,  0, 0.38469310e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 24,  1,  1, 0.26077730e+03, 0.16406000e+01, 0.18269000e+01},
    { 25, 24,  1,  2, 0.19055280e+03, 0.16406000e+01, 0.10619100e+02},
    { 25, 24,  2,  0, 0.24968190e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 24,  2,  1, 0.17538670e+03, 0.98849000e+01, 0.18269000e+01},
    { 25, 24,  2,  2, 0.13182880e+03, 0.98849000e+01, 0.10619100e+02},
    { 25, 25,  0,  0, 0.80274840e+03, 0.00000000e+00, 0.00000000e+00},
    { 25, 25,  1,  0, 0.42042070e+03, 0.16406000e+01, 0.00000000e+00},
    { 25, 25,  1,  1, 0.23955540e+03, 0.16406000e+01, 0.16406000e+01},
    { 25, 25,  2,  0, 0.27339370e+03, 0.98849000e+01, 0.00000000e+00},
    { 25, 25,  2,  1, 0.16268440e+03, 0.98849000e+01, 0.16406000e+01},
    { 25, 25,  2,  2, 0.11384630e+03, 0.98849000e+01, 0.98849000e+01},
    { 26,  1,  0,  0, 0.33911000e+02, 0.00000000e+00, 0.91180000e+00},
    { 26,  1,  0,  1, 0.56799300e+02, 0.00000000e+00, 0.00000000e+00},
    { 26,  1,  1,  0, 0.24345200e+02, 0.16483000e+01, 0.91180000e+00},
    { 26,  1,  1,  1, 0.39274200e+02, 0.16483000e+01, 0.00000000e+00},
    { 26,  1,  2,  0, 0.18097700e+02, 0.91376000e+01, 0.91180000e+00},
    { 26,  1,  2,  1, 0.28566500e+02, 0.91376000e+01, 0.00000000e+00},
    { 26,  2,  0,  0, 0.21175000e+02, 0.00000000e+00, 0.00000000e+00},
    { 26,  2,  1,  0, 0.16056000e+02, 0.16483000e+01, 0.00000000e+00},
    { 26,  2,  2,  0, 0.12427700e+02, 0.91376000e+01, 0.00000000e+00},
    { 26,  3,  0,  0, 0.69845390e+03, 0.00000000e+00, 0.00000000e+00},
    { 26,  3,  0,  1, 0.20361490e+03, 0.00000000e+00, 0.98650000e+00},
    { 26,  3,  1,  0, 0.37921170e+03, 0.16483000e+01, 0.00000000e+00},
    { 26,  3,  1,  1, 0.12754920e+03, 0.16483000e+01, 0.98650000e+00},
    { 26,  3,  2,  0, 0.25324320e+03, 0.91376000e+01, 0.00000000e+00},
    { 26,  3,  2,  1, 0.88953800e+02, 0.91376000e+01, 0.98650000e+00},
    { 26,  4,  0,  0, 0.35353580e+03, 0.00000000e+00, 0.00000000e+00},
    { 26,  4,  0,  1, 0.25660430e+03, 0.00000000e+00, 0.98080000e+00},
    { 26,  4,  0,  2, 0.15628450e+03, 0.00000000e+00, 0.19697000e+01},
    { 26,  4,  1,  0, 0.21947750e+03, 0.16483000e+01, 0.00000000e+00},
    { 26,  4,  1,  1, 0.16261080e+03, 0.16483000e+01, 0.98080000e+00},
    { 26,  4,  1,  2, 0.10602860e+03, 0.16483000e+01, 0.19697000e+01},
    { 26,  4,  2,  0, 0.15229860e+03, 0.91376000e+01, 0.00000000e+00},
    { 26,  4,  2,  1, 0.11416130e+03, 0.91376000e+01, 0.98080000e+00},
    { 26,  4,  2,  2, 0.76349400e+02, 0.91376000e+01, 0.19697000e+01},
    { 26,  5,  0,  0, 0.22175470e+03, 0.00000000e+00, 0.00000000e+00},
    { 26,  5,  0,  1, 0.18397370e+03, 0.00000000e+00, 0.97060000e+00},
    { 26,  5,  0,  2, 0.15238870e+03, 0.00000000e+00, 0.19441000e+01},
    { 26,  5,  0,  3, 0.11135690e+03, 0.00000000e+00, 0.29128000e+01},
    { 26,  5,  0,  4, 0.10419900e+03, 0.00000000e+00, 0.45856000e+01},
    { 26,  5,  1,  0, 0.14762980e+03, 0.16483000e+01, 0.00000000e+00},
    { 26,  5,  1,  1, 0.12411700e+03, 0.16483000e+01, 0.97060000e+00},
    { 26,  5,  1,  2, 0.10414370e+03, 0.16483000e+01, 0.19441000e+01},
    { 26,  5,  1,  3, 0.79083200e+02, 0.16483000e+01, 0.29128000e+01},
    { 26,  5,  1,  4, 0.74393000e+02, 0.16483000e+01, 0.45856000e+01},
    { 26,  5,  2,  0, 0.10555810e+03, 0.91376000e+01, 0.00000000e+00},
    { 26,  5,  2,  1, 0.89435400e+02, 0.91376000e+01, 0.97060000e+00},
    { 26,  5,  2,  2, 0.75632700e+02, 0.91376000e+01, 0.19441000e+01},
    { 26,  5,  2,  3, 0.58451500e+02, 0.91376000e+01, 0.29128000e+01},
    { 26,  5,  2,  4, 0.55169800e+02, 0.91376000e+01, 0.45856000e+01},
    { 26,  6,  0,  0, 0.14234670e+03, 0.00000000e+00, 0.00000000e+00},
    { 26,  6,  0,  1, 0.13377000e+03, 0.00000000e+00, 0.98680000e+00},
    { 26,  6,  0,  2, 0.10673260e+03, 0.00000000e+00, 0.19985000e+01},
    { 26,  6,  0,  3, 0.99901700e+02, 0.00000000e+00, 0.29987000e+01},
    { 26,  6,  0,  4, 0.79263000e+02, 0.00000000e+00, 0.39844000e+01},
    { 26,  6,  1,  0, 0.99588000e+02, 0.16483000e+01, 0.00000000e+00},
    { 26,  6,  1,  1, 0.93384800e+02, 0.16483000e+01, 0.98680000e+00},
    { 26,  6,  1,  2, 0.76113200e+02, 0.16483000e+01, 0.19985000e+01},
    { 26,  6,  1,  3, 0.71211000e+02, 0.16483000e+01, 0.29987000e+01},
    { 26,  6,  1,  4, 0.58177600e+02, 0.16483000e+01, 0.39844000e+01},
    { 26,  6,  2,  0, 0.73107900e+02, 0.91376000e+01, 0.00000000e+00},
    { 26,  6,  2,  1, 0.68629300e+02, 0.91376000e+01, 0.98680000e+00},
    { 26,  6,  2,  2, 0.56542900e+02, 0.91376000e+01, 0.19985000e+01},
    { 26,  6,  2,  3, 0.52992800e+02, 0.91376000e+01, 0.29987000e+01},
    { 26,  6,  2,  4, 0.43990200e+02, 0.91376000e+01, 0.39844000e+01},
    { 26,  7,  0,  0, 0.95978200e+02, 0.00000000e+00, 0.00000000e+00},
    { 26,  7,  0,  1, 0.89486800e+02, 0.00000000e+00, 0.99440000e+00},
    { 26,  7,  0,  2, 0.83691600e+02, 0.00000000e+00, 0.20143000e+01},
    { 26,  7,  0,  3, 0.73418500e+02, 0.00000000e+00, 0.29903000e+01},
    { 26,  7,  1,  0, 0.69563800e+02, 0.16483000e+01, 0.00000000e+00},
    { 26,  7,  1,  1, 0.64846800e+02, 0.16483000e+01, 0.99440000e+00},
    { 26,  7,  1,  2, 0.60892000e+02, 0.16483000e+01, 0.20143000e+01},
    { 26,  7,  1,  3, 0.53617100e+02, 0.16483000e+01, 0.29903000e+01},
    { 26,  7,  2,  0, 0.52202800e+02, 0.91376000e+01, 0.00000000e+00},
    { 26,  7,  2,  1, 0.48755800e+02, 0.91376000e+01, 0.99440000e+00},
    { 26,  7,  2,  2, 0.45914000e+02, 0.91376000e+01, 0.20143000e+01},
    { 26,  7,  2,  3, 0.40637600e+02, 0.91376000e+01, 0.29903000e+01},
    { 26,  8,  0,  0, 0.70894200e+02, 0.00000000e+00, 0.00000000e+00},
    { 26,  8,  0,  1, 0.63186500e+02, 0.00000000e+00, 0.99250000e+00},
    { 26,  8,  0,  2, 0.55335600e+02, 0.00000000e+00, 0.19887000e+01},
    { 26,  8,  1,  0, 0.52635100e+02, 0.16483000e+01, 0.00000000e+00},
    { 26,  8,  1,  1, 0.47181600e+02, 0.16483000e+01, 0.99250000e+00},
    { 26,  8,  1,  2, 0.41627000e+02, 0.16483000e+01, 0.19887000e+01},
    { 26,  8,  2,  0, 0.40170900e+02, 0.91376000e+01, 0.00000000e+00},
    { 26,  8,  2,  1, 0.36191900e+02, 0.91376000e+01, 0.99250000e+00},
    { 26,  8,  2,  2, 0.32158400e+02, 0.91376000e+01, 0.19887000e+01},
    { 26,  9,  0,  0, 0.52631000e+02, 0.00000000e+00, 0.00000000e+00},
    { 26,  9,  0,  1, 0.41894200e+02, 0.00000000e+00, 0.99820000e+00},
    { 26,  9,  1,  0, 0.39862800e+02, 0.16483000e+01, 0.00000000e+00},
    { 26,  9,  1,  1, 0.32432100e+02, 0.16483000e+01, 0.99820000e+00},
    { 26,  9,  2,  0, 0.30892500e+02, 0.91376000e+01, 0.00000000e+00},
    { 26,  9,  2,  1, 0.25531400e+02, 0.91376000e+01, 0.99820000e+00},
    { 26, 10,  0,  0, 0.39865900e+02, 0.00000000e+00, 0.00000000e+00},
    { 26, 10,  1,  0, 0.30664800e+02, 0.16483000e+01, 0.00000000e+00},
    { 26, 10,  2,  0, 0.24074100e+02, 0.91376000e+01, 0.00000000e+00},
    { 26, 11,  0,  0, 0.82889360e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 11,  0,  1, 0.30174010e+03, 0.00000000e+00, 0.96840000e+00},
    { 26, 11,  1,  0, 0.45354440e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 11,  1,  1, 0.18646690e+03, 0.16483000e+01, 0.96840000e+00},
    { 26, 11,  2,  0, 0.30391240e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 11,  2,  1, 0.12973320e+03, 0.91376000e+01, 0.96840000e+00},
    { 26, 12,  0,  0, 0.57651210e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 12,  0,  1, 0.46964370e+03, 0.00000000e+00, 0.96280000e+00},
    { 26, 12,  0,  2, 0.28599690e+03, 0.00000000e+00, 0.19496000e+01},
    { 26, 12,  1,  0, 0.34971160e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 12,  1,  1, 0.28833710e+03, 0.16483000e+01, 0.96280000e+00},
    { 26, 12,  1,  2, 0.18825250e+03, 0.16483000e+01, 0.19496000e+01},
    { 26, 12,  2,  0, 0.24099620e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 12,  2,  1, 0.20000410e+03, 0.91376000e+01, 0.96280000e+00},
    { 26, 12,  2,  2, 0.13378530e+03, 0.91376000e+01, 0.19496000e+01},
    { 26, 13,  0,  0, 0.51208230e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 13,  0,  1, 0.46004960e+03, 0.00000000e+00, 0.96480000e+00},
    { 26, 13,  0,  2, 0.34763940e+03, 0.00000000e+00, 0.19311000e+01},
    { 26, 13,  0,  3, 0.26022290e+03, 0.00000000e+00, 0.29146000e+01},
    { 26, 13,  1,  0, 0.32227810e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 13,  1,  1, 0.29202470e+03, 0.16483000e+01, 0.96480000e+00},
    { 26, 13,  1,  2, 0.22743270e+03, 0.16483000e+01, 0.19311000e+01},
    { 26, 13,  1,  3, 0.17705420e+03, 0.16483000e+01, 0.29146000e+01},
    { 26, 13,  2,  0, 0.22516630e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 13,  2,  1, 0.20482820e+03, 0.91376000e+01, 0.96480000e+00},
    { 26, 13,  2,  2, 0.16153570e+03, 0.91376000e+01, 0.19311000e+01},
    { 26, 13,  2,  3, 0.12768330e+03, 0.91376000e+01, 0.29146000e+01},
    { 26, 14,  0,  0, 0.38374450e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 14,  0,  1, 0.35224080e+03, 0.00000000e+00, 0.95070000e+00},
    { 26, 14,  0,  2, 0.32531170e+03, 0.00000000e+00, 0.19435000e+01},
    { 26, 14,  0,  3, 0.31885890e+03, 0.00000000e+00, 0.29407000e+01},
    { 26, 14,  0,  4, 0.25339650e+03, 0.00000000e+00, 0.38677000e+01},
    { 26, 14,  1,  0, 0.25376380e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 14,  1,  1, 0.23448430e+03, 0.16483000e+01, 0.95070000e+00},
    { 26, 14,  1,  2, 0.21806460e+03, 0.16483000e+01, 0.19435000e+01},
    { 26, 14,  1,  3, 0.21251260e+03, 0.16483000e+01, 0.29407000e+01},
    { 26, 14,  1,  4, 0.17467580e+03, 0.16483000e+01, 0.38677000e+01},
    { 26, 14,  2,  0, 0.18083460e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 14,  2,  1, 0.16769170e+03, 0.91376000e+01, 0.95070000e+00},
    { 26, 14,  2,  2, 0.15644370e+03, 0.91376000e+01, 0.19435000e+01},
    { 26, 14,  2,  3, 0.15231640e+03, 0.91376000e+01, 0.29407000e+01},
    { 26, 14,  2,  4, 0.12689320e+03, 0.91376000e+01, 0.38677000e+01},
    { 26, 15,  0,  0, 0.28716060e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 15,  0,  1, 0.27840200e+03, 0.00000000e+00, 0.99470000e+00},
    { 26, 15,  0,  2, 0.27541380e+03, 0.00000000e+00, 0.20102000e+01},
    { 26, 15,  0,  3, 0.25267400e+03, 0.00000000e+00, 0.29859000e+01},
    { 26, 15,  1,  0, 0.19765690e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 15,  1,  1, 0.19184290e+03, 0.16483000e+01, 0.99470000e+00},
    { 26, 15,  1,  2, 0.18924970e+03, 0.16483000e+01, 0.20102000e+01},
    { 26, 15,  1,  3, 0.17549190e+03, 0.16483000e+01, 0.29859000e+01},
    { 26, 15,  2,  0, 0.14355850e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 15,  2,  1, 0.13948020e+03, 0.91376000e+01, 0.99470000e+00},
    { 26, 15,  2,  2, 0.13750430e+03, 0.91376000e+01, 0.20102000e+01},
    { 26, 15,  2,  3, 0.12812710e+03, 0.91376000e+01, 0.29859000e+01},
    { 26, 16,  0,  0, 0.23226250e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 16,  0,  1, 0.22987760e+03, 0.00000000e+00, 0.99480000e+00},
    { 26, 16,  0,  2, 0.22513570e+03, 0.00000000e+00, 0.19903000e+01},
    { 26, 16,  1,  0, 0.16387940e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 16,  1,  1, 0.16207500e+03, 0.16483000e+01, 0.99480000e+00},
    { 26, 16,  1,  2, 0.15879330e+03, 0.16483000e+01, 0.19903000e+01},
    { 26, 16,  2,  0, 0.12070600e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 16,  2,  1, 0.11937190e+03, 0.91376000e+01, 0.99480000e+00},
    { 26, 16,  2,  2, 0.11701210e+03, 0.91376000e+01, 0.19903000e+01},
    { 26, 17,  0,  0, 0.18518230e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 17,  0,  1, 0.18336610e+03, 0.00000000e+00, 0.99720000e+00},
    { 26, 17,  1,  0, 0.13373240e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 17,  1,  1, 0.13234800e+03, 0.16483000e+01, 0.99720000e+00},
    { 26, 17,  2,  0, 0.99911900e+02, 0.91376000e+01, 0.00000000e+00},
    { 26, 17,  2,  1, 0.98874700e+02, 0.91376000e+01, 0.99720000e+00},
    { 26, 18,  0,  0, 0.14843190e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 18,  1,  0, 0.10931550e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 18,  2,  0, 0.82759100e+02, 0.91376000e+01, 0.00000000e+00},
    { 26, 19,  0,  0, 0.13889522e+04, 0.00000000e+00, 0.00000000e+00},
    { 26, 19,  0,  1, 0.40608760e+03, 0.00000000e+00, 0.97670000e+00},
    { 26, 19,  1,  0, 0.74225200e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 19,  1,  1, 0.25675790e+03, 0.16483000e+01, 0.97670000e+00},
    { 26, 19,  2,  0, 0.49731050e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 19,  2,  1, 0.18170400e+03, 0.91376000e+01, 0.97670000e+00},
    { 26, 20,  0,  0, 0.10565193e+04, 0.00000000e+00, 0.00000000e+00},
    { 26, 20,  0,  1, 0.84546860e+03, 0.00000000e+00, 0.98310000e+00},
    { 26, 20,  0,  2, 0.40218720e+03, 0.00000000e+00, 0.19349000e+01},
    { 26, 20,  1,  0, 0.61392330e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 20,  1,  1, 0.49074810e+03, 0.16483000e+01, 0.98310000e+00},
    { 26, 20,  1,  2, 0.26379300e+03, 0.16483000e+01, 0.19349000e+01},
    { 26, 20,  2,  0, 0.41906350e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 20,  2,  1, 0.33670380e+03, 0.91376000e+01, 0.98310000e+00},
    { 26, 20,  2,  2, 0.18826960e+03, 0.91376000e+01, 0.19349000e+01},
    { 26, 21,  0,  0, 0.85717300e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 21,  0,  1, 0.38959740e+03, 0.00000000e+00, 0.18627000e+01},
    { 26, 21,  0,  2, 0.37893660e+03, 0.00000000e+00, 0.28999000e+01},
    { 26, 21,  1,  0, 0.50734010e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 21,  1,  1, 0.25688890e+03, 0.16483000e+01, 0.18627000e+01},
    { 26, 21,  1,  2, 0.25341680e+03, 0.16483000e+01, 0.28999000e+01},
    { 26, 21,  2,  0, 0.34806420e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 21,  2,  1, 0.18382570e+03, 0.91376000e+01, 0.18627000e+01},
    { 26, 21,  2,  2, 0.18220620e+03, 0.91376000e+01, 0.28999000e+01},
    { 26, 22,  0,  0, 0.81484020e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 22,  0,  1, 0.37582420e+03, 0.00000000e+00, 0.18299000e+01},
    { 26, 22,  0,  2, 0.38306060e+03, 0.00000000e+00, 0.38675000e+01},
    { 26, 22,  1,  0, 0.48989960e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 22,  1,  1, 0.24796360e+03, 0.16483000e+01, 0.18299000e+01},
    { 26, 22,  1,  2, 0.25652910e+03, 0.16483000e+01, 0.38675000e+01},
    { 26, 22,  2,  0, 0.33822830e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 22,  2,  1, 0.17770070e+03, 0.91376000e+01, 0.18299000e+01},
    { 26, 22,  2,  2, 0.18458560e+03, 0.91376000e+01, 0.38675000e+01},
    { 26, 23,  0,  0, 0.73905420e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 23,  0,  1, 0.36861360e+03, 0.00000000e+00, 0.19138000e+01},
    { 26, 23,  0,  2, 0.35139390e+03, 0.00000000e+00, 0.29110000e+01},
    { 26, 23,  1,  0, 0.44862620e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 23,  1,  1, 0.24301480e+03, 0.16483000e+01, 0.19138000e+01},
    { 26, 23,  1,  2, 0.23476650e+03, 0.16483000e+01, 0.29110000e+01},
    { 26, 23,  2,  0, 0.31083750e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 23,  2,  1, 0.17415940e+03, 0.91376000e+01, 0.19138000e+01},
    { 26, 23,  2,  2, 0.16909000e+03, 0.91376000e+01, 0.29110000e+01},
    { 26, 24,  0,  0, 0.58181140e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 24,  0,  1, 0.36707850e+03, 0.00000000e+00, 0.18269000e+01},
    { 26, 24,  0,  2, 0.25682780e+03, 0.00000000e+00, 0.10619100e+02},
    { 26, 24,  1,  0, 0.35327090e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 24,  1,  1, 0.24078340e+03, 0.16483000e+01, 0.18269000e+01},
    { 26, 24,  1,  2, 0.17666070e+03, 0.16483000e+01, 0.10619100e+02},
    { 26, 24,  2,  0, 0.24576290e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 24,  2,  1, 0.17230360e+03, 0.91376000e+01, 0.18269000e+01},
    { 26, 24,  2,  2, 0.12934440e+03, 0.91376000e+01, 0.10619100e+02},
    { 26, 25,  0,  0, 0.62754030e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 25,  0,  1, 0.32962730e+03, 0.00000000e+00, 0.16406000e+01},
    { 26, 25,  0,  2, 0.21557380e+03, 0.00000000e+00, 0.98849000e+01},
    { 26, 25,  1,  0, 0.38626020e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 25,  1,  1, 0.22153400e+03, 0.16483000e+01, 0.16406000e+01},
    { 26, 25,  1,  2, 0.15107680e+03, 0.16483000e+01, 0.98849000e+01},
    { 26, 25,  2,  0, 0.26904940e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 25,  2,  1, 0.15974020e+03, 0.91376000e+01, 0.16406000e+01},
    { 26, 25,  2,  2, 0.11164910e+03, 0.91376000e+01, 0.98849000e+01},
    { 26, 26,  0,  0, 0.49133490e+03, 0.00000000e+00, 0.00000000e+00},
    { 26, 26,  1,  0, 0.30304800e+03, 0.16483000e+01, 0.00000000e+00},
    { 26, 26,  1,  1, 0.20499250e+03, 0.16483000e+01, 0.16483000e+01},
    { 26, 26,  2,  0, 0.21211090e+03, 0.91376000e+01, 0.00000000e+00},
    { 26, 26,  2,  1, 0.14831710e+03, 0.91376000e+01, 0.16483000e+01},
    { 26, 26,  2,  2, 0.10950410e+03, 0.91376000e+01, 0.91376000e+01},
    { 27,  1,  0,  0, 0.36323400e+02, 0.00000000e+00, 0.91180000e+00},
    { 27,  1,  0,  1, 0.60574600e+02, 0.00000000e+00, 0.00000000e+00},
    { 27,  1,  1,  0, 0.23231000e+02, 0.17149000e+01, 0.91180000e+00},
    { 27,  1,  1,  1, 0.37449600e+02, 0.17149000e+01, 0.00000000e+00},
    { 27,  1,  2,  0, 0.20774100e+02, 0.29263000e+01, 0.91180000e+00},
    { 27,  1,  2,  1, 0.33330700e+02, 0.29263000e+01, 0.00000000e+00},
    { 27,  1,  3,  0, 0.18750000e+02, 0.77785000e+01, 0.91180000e+00},
    { 27,  1,  3,  1, 0.29768000e+02, 0.77785000e+01, 0.00000000e+00},
    { 27,  2,  0,  0, 0.22723300e+02, 0.00000000e+00, 0.00000000e+00},
    { 27,  2,  1,  0, 0.15354500e+02, 0.17149000e+01, 0.00000000e+00},
    { 27,  2,  2,  0, 0.13880400e+02, 0.29263000e+01, 0.00000000e+00},
    { 27,  2,  3,  0, 0.12752300e+02, 0.77785000e+01, 0.00000000e+00},
    { 27,  3,  0,  0, 0.70153240e+03, 0.00000000e+00, 0.00000000e+00},
    { 27,  3,  0,  1, 0.21289780e+03, 0.00000000e+00, 0.98650000e+00},
    { 27,  3,  1,  0, 0.36237460e+03, 0.17149000e+01, 0.00000000e+00},
    { 27,  3,  1,  1, 0.12160370e+03, 0.17149000e+01, 0.98650000e+00},
    { 27,  3,  2,  0, 0.31984480e+03, 0.29263000e+01, 0.00000000e+00},
    { 27,  3,  2,  1, 0.10755820e+03, 0.29263000e+01, 0.98650000e+00},
    { 27,  3,  3,  0, 0.27075980e+03, 0.77785000e+01, 0.00000000e+00},
    { 27,  3,  3,  1, 0.93835600e+02, 0.77785000e+01, 0.98650000e+00},
    { 27,  4,  0,  0, 0.36919280e+03, 0.00000000e+00, 0.00000000e+00},
    { 27,  4,  0,  1, 0.26862840e+03, 0.00000000e+00, 0.98080000e+00},
    { 27,  4,  0,  2, 0.16621660e+03, 0.00000000e+00, 0.19697000e+01},
    { 27,  4,  1,  0, 0.20922270e+03, 0.17149000e+01, 0.00000000e+00},
    { 27,  4,  1,  1, 0.15505540e+03, 0.17149000e+01, 0.98080000e+00},
    { 27,  4,  1,  2, 0.10108010e+03, 0.17149000e+01, 0.19697000e+01},
    { 27,  4,  2,  0, 0.18489380e+03, 0.29263000e+01, 0.00000000e+00},
    { 27,  4,  2,  1, 0.13729980e+03, 0.29263000e+01, 0.98080000e+00},
    { 27,  4,  2,  2, 0.89789100e+02, 0.29263000e+01, 0.19697000e+01},
    { 27,  4,  3,  0, 0.16088700e+03, 0.77785000e+01, 0.00000000e+00},
    { 27,  4,  3,  1, 0.12018800e+03, 0.77785000e+01, 0.98080000e+00},
    { 27,  4,  3,  2, 0.79784500e+02, 0.77785000e+01, 0.19697000e+01},
    { 27,  5,  0,  0, 0.23486930e+03, 0.00000000e+00, 0.00000000e+00},
    { 27,  5,  0,  1, 0.19517310e+03, 0.00000000e+00, 0.97060000e+00},
    { 27,  5,  0,  2, 0.16187200e+03, 0.00000000e+00, 0.19441000e+01},
    { 27,  5,  0,  3, 0.11910910e+03, 0.00000000e+00, 0.29128000e+01},
    { 27,  5,  0,  4, 0.11150630e+03, 0.00000000e+00, 0.45856000e+01},
    { 27,  5,  1,  0, 0.14074280e+03, 0.17149000e+01, 0.00000000e+00},
    { 27,  5,  1,  1, 0.11835300e+03, 0.17149000e+01, 0.97060000e+00},
    { 27,  5,  1,  2, 0.99334300e+02, 0.17149000e+01, 0.19441000e+01},
    { 27,  5,  1,  3, 0.75452500e+02, 0.17149000e+01, 0.29128000e+01},
    { 27,  5,  1,  4, 0.70987100e+02, 0.17149000e+01, 0.45856000e+01},
    { 27,  5,  2,  0, 0.12490870e+03, 0.29263000e+01, 0.00000000e+00},
    { 27,  5,  2,  1, 0.10520190e+03, 0.29263000e+01, 0.97060000e+00},
    { 27,  5,  2,  2, 0.88440500e+02, 0.29263000e+01, 0.19441000e+01},
    { 27,  5,  2,  3, 0.67393200e+02, 0.29263000e+01, 0.29128000e+01},
    { 27,  5,  2,  4, 0.63454300e+02, 0.29263000e+01, 0.45856000e+01},
    { 27,  5,  3,  0, 0.11053650e+03, 0.77785000e+01, 0.00000000e+00},
    { 27,  5,  3,  1, 0.93454100e+02, 0.77785000e+01, 0.97060000e+00},
    { 27,  5,  3,  2, 0.78862400e+02, 0.77785000e+01, 0.19441000e+01},
    { 27,  5,  3,  3, 0.60653700e+02, 0.77785000e+01, 0.29128000e+01},
    { 27,  5,  3,  4, 0.57198700e+02, 0.77785000e+01, 0.45856000e+01},
    { 27,  6,  0,  0, 0.15187030e+03, 0.00000000e+00, 0.00000000e+00},
    { 27,  6,  0,  1, 0.14251400e+03, 0.00000000e+00, 0.98680000e+00},
    { 27,  6,  0,  2, 0.11409130e+03, 0.00000000e+00, 0.19985000e+01},
    { 27,  6,  0,  3, 0.10669170e+03, 0.00000000e+00, 0.29987000e+01},
    { 27,  6,  0,  4, 0.84954700e+02, 0.00000000e+00, 0.39844000e+01},
    { 27,  6,  1,  0, 0.95005100e+02, 0.17149000e+01, 0.00000000e+00},
    { 27,  6,  1,  1, 0.89099200e+02, 0.17149000e+01, 0.98680000e+00},
    { 27,  6,  1,  2, 0.72644300e+02, 0.17149000e+01, 0.19985000e+01},
    { 27,  6,  1,  3, 0.67977400e+02, 0.17149000e+01, 0.29987000e+01},
    { 27,  6,  1,  4, 0.55565400e+02, 0.17149000e+01, 0.39844000e+01},
    { 27,  6,  2,  0, 0.84755200e+02, 0.29263000e+01, 0.00000000e+00},
    { 27,  6,  2,  1, 0.79527300e+02, 0.29263000e+01, 0.98680000e+00},
    { 27,  6,  2,  2, 0.64985600e+02, 0.29263000e+01, 0.19985000e+01},
    { 27,  6,  2,  3, 0.60851300e+02, 0.29263000e+01, 0.29987000e+01},
    { 27,  6,  2,  4, 0.49914800e+02, 0.29263000e+01, 0.39844000e+01},
    { 27,  6,  3,  0, 0.76007200e+02, 0.77785000e+01, 0.00000000e+00},
    { 27,  6,  3,  1, 0.71331800e+02, 0.77785000e+01, 0.98680000e+00},
    { 27,  6,  3,  2, 0.58605700e+02, 0.77785000e+01, 0.19985000e+01},
    { 27,  6,  3,  3, 0.54906600e+02, 0.77785000e+01, 0.29987000e+01},
    { 27,  6,  3,  4, 0.45389100e+02, 0.77785000e+01, 0.39844000e+01},
    { 27,  7,  0,  0, 0.10275030e+03, 0.00000000e+00, 0.00000000e+00},
    { 27,  7,  0,  1, 0.95705100e+02, 0.00000000e+00, 0.99440000e+00},
    { 27,  7,  0,  2, 0.89534500e+02, 0.00000000e+00, 0.20143000e+01},
    { 27,  7,  0,  3, 0.78469600e+02, 0.00000000e+00, 0.29903000e+01},
    { 27,  7,  1,  0, 0.66421800e+02, 0.17149000e+01, 0.00000000e+00},
    { 27,  7,  1,  1, 0.61925600e+02, 0.17149000e+01, 0.99440000e+00},
    { 27,  7,  1,  2, 0.58161100e+02, 0.17149000e+01, 0.20143000e+01},
    { 27,  7,  1,  3, 0.51231800e+02, 0.17149000e+01, 0.29903000e+01},
    { 27,  7,  2,  0, 0.59562800e+02, 0.29263000e+01, 0.00000000e+00},
    { 27,  7,  2,  1, 0.55568500e+02, 0.29263000e+01, 0.99440000e+00},
    { 27,  7,  2,  2, 0.52232200e+02, 0.29263000e+01, 0.20143000e+01},
    { 27,  7,  2,  3, 0.46084100e+02, 0.29263000e+01, 0.29903000e+01},
    { 27,  7,  3,  0, 0.53969500e+02, 0.77785000e+01, 0.00000000e+00},
    { 27,  7,  3,  1, 0.50381400e+02, 0.77785000e+01, 0.99440000e+00},
    { 27,  7,  3,  2, 0.47416800e+02, 0.77785000e+01, 0.20143000e+01},
    { 27,  7,  3,  3, 0.41919300e+02, 0.77785000e+01, 0.29903000e+01},
    { 27,  8,  0,  0, 0.75991200e+02, 0.00000000e+00, 0.00000000e+00},
    { 27,  8,  0,  1, 0.67711700e+02, 0.00000000e+00, 0.99250000e+00},
    { 27,  8,  0,  2, 0.59268800e+02, 0.00000000e+00, 0.19887000e+01},
    { 27,  8,  1,  0, 0.50301600e+02, 0.17149000e+01, 0.00000000e+00},
    { 27,  8,  1,  1, 0.45100200e+02, 0.17149000e+01, 0.99250000e+00},
    { 27,  8,  1,  2, 0.39813100e+02, 0.17149000e+01, 0.19887000e+01},
    { 27,  8,  2,  0, 0.45306600e+02, 0.29263000e+01, 0.00000000e+00},
    { 27,  8,  2,  1, 0.40679900e+02, 0.29263000e+01, 0.99250000e+00},
    { 27,  8,  2,  2, 0.35989200e+02, 0.29263000e+01, 0.19887000e+01},
    { 27,  8,  3,  0, 0.41362300e+02, 0.77785000e+01, 0.00000000e+00},
    { 27,  8,  3,  1, 0.37217800e+02, 0.77785000e+01, 0.99250000e+00},
    { 27,  8,  3,  2, 0.33021500e+02, 0.77785000e+01, 0.19887000e+01},
    { 27,  9,  0,  0, 0.56430700e+02, 0.00000000e+00, 0.00000000e+00},
    { 27,  9,  0,  1, 0.44940700e+02, 0.00000000e+00, 0.99820000e+00},
    { 27,  9,  1,  0, 0.38131300e+02, 0.17149000e+01, 0.00000000e+00},
    { 27,  9,  1,  1, 0.31051600e+02, 0.17149000e+01, 0.99820000e+00},
    { 27,  9,  2,  0, 0.34493500e+02, 0.29263000e+01, 0.00000000e+00},
    { 27,  9,  2,  1, 0.28212200e+02, 0.29263000e+01, 0.99820000e+00},
    { 27,  9,  3,  0, 0.31698500e+02, 0.77785000e+01, 0.00000000e+00},
    { 27,  9,  3,  1, 0.26103100e+02, 0.77785000e+01, 0.99820000e+00},
    { 27, 10,  0,  0, 0.42727000e+02, 0.00000000e+00, 0.00000000e+00},
    { 27, 10,  1,  0, 0.29359800e+02, 0.17149000e+01, 0.00000000e+00},
    { 27, 10,  2,  0, 0.26662700e+02, 0.29263000e+01, 0.00000000e+00},
    { 27, 10,  3,  0, 0.24634300e+02, 0.77785000e+01, 0.00000000e+00},
    { 27, 11,  0,  0, 0.83418260e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 11,  0,  1, 0.31417180e+03, 0.00000000e+00, 0.96840000e+00},
    { 27, 11,  1,  0, 0.43337360e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 11,  1,  1, 0.17783550e+03, 0.17149000e+01, 0.96840000e+00},
    { 27, 11,  2,  0, 0.38268210e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 11,  2,  1, 0.15735780e+03, 0.29263000e+01, 0.96840000e+00},
    { 27, 11,  3,  0, 0.32462410e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 11,  3,  1, 0.13698410e+03, 0.77785000e+01, 0.96840000e+00},
    { 27, 12,  0,  0, 0.59833020e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 12,  0,  1, 0.48817150e+03, 0.00000000e+00, 0.96280000e+00},
    { 27, 12,  0,  2, 0.30245180e+03, 0.00000000e+00, 0.19496000e+01},
    { 27, 12,  1,  0, 0.33347670e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 12,  1,  1, 0.27498400e+03, 0.17149000e+01, 0.96280000e+00},
    { 27, 12,  1,  2, 0.17945530e+03, 0.17149000e+01, 0.19496000e+01},
    { 27, 12,  2,  0, 0.29460910e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 12,  2,  1, 0.24318090e+03, 0.29263000e+01, 0.96280000e+00},
    { 27, 12,  2,  2, 0.15909800e+03, 0.29263000e+01, 0.19496000e+01},
    { 27, 12,  3,  0, 0.25515610e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 12,  3,  1, 0.21133880e+03, 0.77785000e+01, 0.96280000e+00},
    { 27, 12,  3,  2, 0.14035180e+03, 0.77785000e+01, 0.19496000e+01},
    { 27, 13,  0,  0, 0.53597060e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 13,  0,  1, 0.48229900e+03, 0.00000000e+00, 0.96480000e+00},
    { 27, 13,  0,  2, 0.36672360e+03, 0.00000000e+00, 0.19311000e+01},
    { 27, 13,  0,  3, 0.27689480e+03, 0.00000000e+00, 0.29146000e+01},
    { 27, 13,  1,  0, 0.30725400e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 13,  1,  1, 0.27841730e+03, 0.17149000e+01, 0.96480000e+00},
    { 27, 13,  1,  2, 0.21683930e+03, 0.17149000e+01, 0.19311000e+01},
    { 27, 13,  1,  3, 0.16880270e+03, 0.17149000e+01, 0.29146000e+01},
    { 27, 13,  2,  0, 0.27182260e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 13,  2,  1, 0.24645390e+03, 0.29263000e+01, 0.96480000e+00},
    { 27, 13,  2,  2, 0.19227550e+03, 0.29263000e+01, 0.19311000e+01},
    { 27, 13,  2,  3, 0.14999510e+03, 0.29263000e+01, 0.29146000e+01},
    { 27, 13,  3,  0, 0.23739610e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 13,  3,  1, 0.21570660e+03, 0.77785000e+01, 0.96480000e+00},
    { 27, 13,  3,  2, 0.16949030e+03, 0.77785000e+01, 0.19311000e+01},
    { 27, 13,  3,  3, 0.13338200e+03, 0.77785000e+01, 0.29146000e+01},
    { 27, 14,  0,  0, 0.40599070e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 14,  0,  1, 0.37301250e+03, 0.00000000e+00, 0.95070000e+00},
    { 27, 14,  0,  2, 0.34494790e+03, 0.00000000e+00, 0.19435000e+01},
    { 27, 14,  0,  3, 0.33746240e+03, 0.00000000e+00, 0.29407000e+01},
    { 27, 14,  0,  4, 0.27008810e+03, 0.00000000e+00, 0.38677000e+01},
    { 27, 14,  1,  0, 0.24191590e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 14,  1,  1, 0.22355480e+03, 0.17149000e+01, 0.95070000e+00},
    { 27, 14,  1,  2, 0.20790840e+03, 0.17149000e+01, 0.19435000e+01},
    { 27, 14,  1,  3, 0.20263880e+03, 0.17149000e+01, 0.29407000e+01},
    { 27, 14,  1,  4, 0.16656740e+03, 0.17149000e+01, 0.38677000e+01},
    { 27, 14,  2,  0, 0.21457260e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 14,  2,  1, 0.19841740e+03, 0.29263000e+01, 0.95070000e+00},
    { 27, 14,  2,  2, 0.18462850e+03, 0.29263000e+01, 0.19435000e+01},
    { 27, 14,  2,  3, 0.17996900e+03, 0.29263000e+01, 0.29407000e+01},
    { 27, 14,  2,  4, 0.14822590e+03, 0.29263000e+01, 0.38677000e+01},
    { 27, 14,  3,  0, 0.18954880e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 14,  3,  1, 0.17559630e+03, 0.77785000e+01, 0.95070000e+00},
    { 27, 14,  3,  2, 0.16367210e+03, 0.77785000e+01, 0.19435000e+01},
    { 27, 14,  3,  3, 0.15940630e+03, 0.77785000e+01, 0.29407000e+01},
    { 27, 14,  3,  4, 0.13228840e+03, 0.77785000e+01, 0.38677000e+01},
    { 27, 15,  0,  0, 0.30592560e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 15,  0,  1, 0.29657890e+03, 0.00000000e+00, 0.99470000e+00},
    { 27, 15,  0,  2, 0.29316610e+03, 0.00000000e+00, 0.20102000e+01},
    { 27, 15,  0,  3, 0.26948070e+03, 0.00000000e+00, 0.29859000e+01},
    { 27, 15,  1,  0, 0.18848520e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 15,  1,  1, 0.18295110e+03, 0.17149000e+01, 0.99470000e+00},
    { 27, 15,  1,  2, 0.18048460e+03, 0.17149000e+01, 0.20102000e+01},
    { 27, 15,  1,  3, 0.16737650e+03, 0.17149000e+01, 0.29859000e+01},
    { 27, 15,  2,  0, 0.16773560e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 15,  2,  1, 0.16285410e+03, 0.29263000e+01, 0.99470000e+00},
    { 27, 15,  2,  2, 0.16065780e+03, 0.29263000e+01, 0.20102000e+01},
    { 27, 15,  2,  3, 0.14911580e+03, 0.29263000e+01, 0.29859000e+01},
    { 27, 15,  3,  0, 0.14967090e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 15,  3,  1, 0.14538010e+03, 0.77785000e+01, 0.99470000e+00},
    { 27, 15,  3,  2, 0.14335180e+03, 0.77785000e+01, 0.20102000e+01},
    { 27, 15,  3,  3, 0.13339560e+03, 0.77785000e+01, 0.29859000e+01},
    { 27, 16,  0,  0, 0.24821160e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 16,  0,  1, 0.24559880e+03, 0.00000000e+00, 0.99480000e+00},
    { 27, 16,  0,  2, 0.24051750e+03, 0.00000000e+00, 0.19903000e+01},
    { 27, 16,  1,  0, 0.15634230e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 16,  1,  1, 0.15462430e+03, 0.17149000e+01, 0.99480000e+00},
    { 27, 16,  1,  2, 0.15149830e+03, 0.17149000e+01, 0.19903000e+01},
    { 27, 16,  2,  0, 0.13954300e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 16,  2,  1, 0.13801590e+03, 0.29263000e+01, 0.99480000e+00},
    { 27, 16,  2,  2, 0.13524560e+03, 0.29263000e+01, 0.19903000e+01},
    { 27, 16,  3,  0, 0.12537250e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 16,  3,  1, 0.12399050e+03, 0.77785000e+01, 0.99480000e+00},
    { 27, 16,  3,  2, 0.12152560e+03, 0.77785000e+01, 0.19903000e+01},
    { 27, 17,  0,  0, 0.19835700e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 17,  0,  1, 0.19637550e+03, 0.00000000e+00, 0.99720000e+00},
    { 27, 17,  1,  0, 0.12765130e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 17,  1,  1, 0.12633190e+03, 0.17149000e+01, 0.99720000e+00},
    { 27, 17,  2,  0, 0.11430910e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 17,  2,  1, 0.11313180e+03, 0.29263000e+01, 0.99720000e+00},
    { 27, 17,  3,  0, 0.10339310e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 17,  3,  1, 0.10232230e+03, 0.77785000e+01, 0.99720000e+00},
    { 27, 18,  0,  0, 0.15919570e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 18,  1,  0, 0.10440910e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 18,  2,  0, 0.93808400e+02, 0.29263000e+01, 0.00000000e+00},
    { 27, 18,  3,  0, 0.85361600e+02, 0.77785000e+01, 0.00000000e+00},
    { 27, 19,  0,  0, 0.13829771e+04, 0.00000000e+00, 0.00000000e+00},
    { 27, 19,  0,  1, 0.42338090e+03, 0.00000000e+00, 0.97670000e+00},
    { 27, 19,  1,  0, 0.71018180e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 19,  1,  1, 0.24501880e+03, 0.17149000e+01, 0.97670000e+00},
    { 27, 19,  2,  0, 0.62812380e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 19,  2,  1, 0.21759670e+03, 0.29263000e+01, 0.97670000e+00},
    { 27, 19,  3,  0, 0.53130440e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 19,  3,  1, 0.19095210e+03, 0.77785000e+01, 0.97670000e+00},
    { 27, 20,  0,  0, 0.10817690e+04, 0.00000000e+00, 0.00000000e+00},
    { 27, 20,  0,  1, 0.86250360e+03, 0.00000000e+00, 0.98310000e+00},
    { 27, 20,  0,  2, 0.42395230e+03, 0.00000000e+00, 0.19349000e+01},
    { 27, 20,  1,  0, 0.58595780e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 20,  1,  1, 0.46868990e+03, 0.17149000e+01, 0.98310000e+00},
    { 27, 20,  1,  2, 0.25158410e+03, 0.17149000e+01, 0.19349000e+01},
    { 27, 20,  2,  0, 0.51787690e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 20,  2,  1, 0.41483380e+03, 0.29263000e+01, 0.98310000e+00},
    { 27, 20,  2,  2, 0.22342730e+03, 0.29263000e+01, 0.19349000e+01},
    { 27, 20,  3,  0, 0.44506810e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 20,  3,  1, 0.35707210e+03, 0.77785000e+01, 0.98310000e+00},
    { 27, 20,  3,  2, 0.19732010e+03, 0.77785000e+01, 0.19349000e+01},
    { 27, 21,  0,  0, 0.88245030e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 21,  0,  1, 0.41105720e+03, 0.00000000e+00, 0.18627000e+01},
    { 27, 21,  0,  2, 0.40112950e+03, 0.00000000e+00, 0.28999000e+01},
    { 27, 21,  1,  0, 0.48407230e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 21,  1,  1, 0.24500350e+03, 0.17149000e+01, 0.18627000e+01},
    { 27, 21,  1,  2, 0.24168330e+03, 0.17149000e+01, 0.28999000e+01},
    { 27, 21,  2,  0, 0.42788660e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 21,  2,  1, 0.21769090e+03, 0.29263000e+01, 0.18627000e+01},
    { 27, 21,  2,  2, 0.21483990e+03, 0.29263000e+01, 0.28999000e+01},
    { 27, 21,  3,  0, 0.36908350e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 21,  3,  1, 0.19252210e+03, 0.77785000e+01, 0.18627000e+01},
    { 27, 21,  3,  2, 0.19055180e+03, 0.77785000e+01, 0.28999000e+01},
    { 27, 22,  0,  0, 0.84183350e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 22,  0,  1, 0.39627480e+03, 0.00000000e+00, 0.18299000e+01},
    { 27, 22,  0,  2, 0.40558090e+03, 0.00000000e+00, 0.38675000e+01},
    { 27, 22,  1,  0, 0.46739840e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 22,  1,  1, 0.23653250e+03, 0.17149000e+01, 0.18299000e+01},
    { 27, 22,  1,  2, 0.24465710e+03, 0.17149000e+01, 0.38675000e+01},
    { 27, 22,  2,  0, 0.41344790e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 22,  2,  1, 0.21024640e+03, 0.29263000e+01, 0.18299000e+01},
    { 27, 22,  2,  2, 0.21751780e+03, 0.29263000e+01, 0.38675000e+01},
    { 27, 22,  3,  0, 0.35797830e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 22,  3,  1, 0.18603690e+03, 0.77785000e+01, 0.18299000e+01},
    { 27, 22,  3,  2, 0.19300120e+03, 0.77785000e+01, 0.38675000e+01},
    { 27, 23,  0,  0, 0.76531780e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 23,  0,  1, 0.38857290e+03, 0.00000000e+00, 0.19138000e+01},
    { 27, 23,  0,  2, 0.37151490e+03, 0.00000000e+00, 0.29110000e+01},
    { 27, 23,  1,  0, 0.42799360e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 23,  1,  1, 0.23181800e+03, 0.17149000e+01, 0.19138000e+01},
    { 27, 23,  1,  2, 0.22394370e+03, 0.17149000e+01, 0.29110000e+01},
    { 27, 23,  2,  0, 0.37873270e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 23,  2,  1, 0.20607570e+03, 0.29263000e+01, 0.19138000e+01},
    { 27, 23,  2,  2, 0.19920380e+03, 0.29263000e+01, 0.29110000e+01},
    { 27, 23,  3,  0, 0.32864070e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 23,  3,  1, 0.18233530e+03, 0.77785000e+01, 0.19138000e+01},
    { 27, 23,  3,  2, 0.17676920e+03, 0.77785000e+01, 0.29110000e+01},
    { 27, 24,  0,  0, 0.60141780e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 24,  0,  1, 0.38644860e+03, 0.00000000e+00, 0.18269000e+01},
    { 27, 24,  0,  2, 0.27263010e+03, 0.00000000e+00, 0.10619100e+02},
    { 27, 24,  1,  0, 0.33714360e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 24,  1,  1, 0.22970220e+03, 0.17149000e+01, 0.18269000e+01},
    { 27, 24,  1,  2, 0.16859690e+03, 0.17149000e+01, 0.10619100e+02},
    { 27, 24,  2,  0, 0.29871690e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 24,  2,  1, 0.20417500e+03, 0.29263000e+01, 0.18269000e+01},
    { 27, 24,  2,  2, 0.15048630e+03, 0.29263000e+01, 0.10619100e+02},
    { 27, 24,  3,  0, 0.25957220e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 24,  3,  1, 0.18047740e+03, 0.77785000e+01, 0.18269000e+01},
    { 27, 24,  3,  2, 0.13462870e+03, 0.77785000e+01, 0.10619100e+02},
    { 27, 25,  0,  0, 0.65196880e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 25,  0,  1, 0.34919410e+03, 0.00000000e+00, 0.16406000e+01},
    { 27, 25,  0,  2, 0.22950770e+03, 0.00000000e+00, 0.98849000e+01},
    { 27, 25,  1,  0, 0.36847190e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 25,  1,  1, 0.21130250e+03, 0.17149000e+01, 0.16406000e+01},
    { 27, 25,  1,  2, 0.14421590e+03, 0.17149000e+01, 0.98849000e+01},
    { 27, 25,  2,  0, 0.32626030e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 25,  2,  1, 0.18795640e+03, 0.29263000e+01, 0.16406000e+01},
    { 27, 25,  2,  2, 0.12896280e+03, 0.29263000e+01, 0.98849000e+01},
    { 27, 25,  3,  0, 0.28401670e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 25,  3,  1, 0.16694170e+03, 0.77785000e+01, 0.16406000e+01},
    { 27, 25,  3,  2, 0.11592230e+03, 0.77785000e+01, 0.98849000e+01},
    { 27, 26,  0,  0, 0.50977640e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 26,  0,  1, 0.32134480e+03, 0.00000000e+00, 0.16483000e+01},
    { 27, 26,  0,  2, 0.22573460e+03, 0.00000000e+00, 0.91376000e+01},
    { 27, 26,  1,  0, 0.28919370e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 26,  1,  1, 0.19554300e+03, 0.17149000e+01, 0.16483000e+01},
    { 27, 26,  1,  2, 0.14158150e+03, 0.17149000e+01, 0.91376000e+01},
    { 27, 26,  2,  0, 0.25642380e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 26,  2,  1, 0.17405360e+03, 0.29263000e+01, 0.16483000e+01},
    { 27, 26,  2,  2, 0.12658850e+03, 0.29263000e+01, 0.91376000e+01},
    { 27, 26,  3,  0, 0.22363540e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 26,  3,  1, 0.15486080e+03, 0.77785000e+01, 0.16483000e+01},
    { 27, 26,  3,  2, 0.11372870e+03, 0.77785000e+01, 0.91376000e+01},
    { 27, 27,  0,  0, 0.53277940e+03, 0.00000000e+00, 0.00000000e+00},
    { 27, 27,  1,  0, 0.30649680e+03, 0.17149000e+01, 0.00000000e+00},
    { 27, 27,  1,  1, 0.18654620e+03, 0.17149000e+01, 0.17149000e+01},
    { 27, 27,  2,  0, 0.27162880e+03, 0.29263000e+01, 0.00000000e+00},
    { 27, 27,  2,  1, 0.16609110e+03, 0.29263000e+01, 0.17149000e+01},
    { 27, 27,  2,  2, 0.14806570e+03, 0.29263000e+01, 0.29263000e+01},
    { 27, 27,  3,  0, 0.23769940e+03, 0.77785000e+01, 0.00000000e+00},
    { 27, 27,  3,  1, 0.14780570e+03, 0.77785000e+01, 0.17149000e+01},
    { 27, 27,  3,  2, 0.13200850e+03, 0.77785000e+01, 0.29263000e+01},
    { 27, 27,  3,  3, 0.11828630e+03, 0.77785000e+01, 0.77785000e+01},
    { 28,  1,  0,  0, 0.37159600e+02, 0.00000000e+00, 0.91180000e+00},
    { 28,  1,  0,  1, 0.62253200e+02, 0.00000000e+00, 0.00000000e+00},
    { 28,  1,  1,  0, 0.22682200e+02, 0.17937000e+01, 0.91180000e+00},
    { 28,  1,  1,  1, 0.36590100e+02, 0.17937000e+01, 0.00000000e+00},
    { 28,  1,  2,  0, 0.19464800e+02, 0.65458000e+01, 0.91180000e+00},
    { 28,  1,  2,  1, 0.31098100e+02, 0.65458000e+01, 0.00000000e+00},
    { 28,  1,  3,  0, 0.20185300e+02, 0.62918000e+01, 0.91180000e+00},
    { 28,  1,  3,  1, 0.32514900e+02, 0.62918000e+01, 0.00000000e+00},
    { 28,  2,  0,  0, 0.23079200e+02, 0.00000000e+00, 0.00000000e+00},
    { 28,  2,  1,  0, 0.14983300e+02, 0.17937000e+01, 0.00000000e+00},
    { 28,  2,  2,  0, 0.13097900e+02, 0.65458000e+01, 0.00000000e+00},
    { 28,  2,  3,  0, 0.13430500e+02, 0.62918000e+01, 0.00000000e+00},
    { 28,  3,  0,  0, 0.73885800e+03, 0.00000000e+00, 0.00000000e+00},
    { 28,  3,  0,  1, 0.22117390e+03, 0.00000000e+00, 0.98650000e+00},
    { 28,  3,  1,  0, 0.35596060e+03, 0.17937000e+01, 0.00000000e+00},
    { 28,  3,  1,  1, 0.11907250e+03, 0.17937000e+01, 0.98650000e+00},
    { 28,  3,  2,  0, 0.29104880e+03, 0.65458000e+01, 0.00000000e+00},
    { 28,  3,  2,  1, 0.99345400e+02, 0.65458000e+01, 0.98650000e+00},
    { 28,  3,  3,  0, 0.32065850e+03, 0.62918000e+01, 0.00000000e+00},
    { 28,  3,  3,  1, 0.10615450e+03, 0.62918000e+01, 0.98650000e+00},
    { 28,  4,  0,  0, 0.38391400e+03, 0.00000000e+00, 0.00000000e+00},
    { 28,  4,  0,  1, 0.27871160e+03, 0.00000000e+00, 0.98080000e+00},
    { 28,  4,  0,  2, 0.17120430e+03, 0.00000000e+00, 0.19697000e+01},
    { 28,  4,  1,  0, 0.20490860e+03, 0.17937000e+01, 0.00000000e+00},
    { 28,  4,  1,  1, 0.15177980e+03, 0.17937000e+01, 0.98080000e+00},
    { 28,  4,  1,  2, 0.98800400e+02, 0.17937000e+01, 0.19697000e+01},
    { 28,  4,  2,  0, 0.17059360e+03, 0.65458000e+01, 0.00000000e+00},
    { 28,  4,  2,  1, 0.12698120e+03, 0.65458000e+01, 0.98080000e+00},
    { 28,  4,  2,  2, 0.83603000e+02, 0.65458000e+01, 0.19697000e+01},
    { 28,  4,  3,  0, 0.18269550e+03, 0.62918000e+01, 0.00000000e+00},
    { 28,  4,  3,  1, 0.13527020e+03, 0.62918000e+01, 0.98080000e+00},
    { 28,  4,  3,  2, 0.87785200e+02, 0.62918000e+01, 0.19697000e+01},
    { 28,  5,  0,  0, 0.24241740e+03, 0.00000000e+00, 0.00000000e+00},
    { 28,  5,  0,  1, 0.20113510e+03, 0.00000000e+00, 0.97060000e+00},
    { 28,  5,  0,  2, 0.16656140e+03, 0.00000000e+00, 0.19441000e+01},
    { 28,  5,  0,  3, 0.12201440e+03, 0.00000000e+00, 0.29128000e+01},
    { 28,  5,  0,  4, 0.11415060e+03, 0.00000000e+00, 0.45856000e+01},
    { 28,  5,  1,  0, 0.13762540e+03, 0.17937000e+01, 0.00000000e+00},
    { 28,  5,  1,  1, 0.11570000e+03, 0.17937000e+01, 0.97060000e+00},
    { 28,  5,  1,  2, 0.97081600e+02, 0.17937000e+01, 0.19441000e+01},
    { 28,  5,  1,  3, 0.73686500e+02, 0.17937000e+01, 0.29128000e+01},
    { 28,  5,  1,  4, 0.69319400e+02, 0.17937000e+01, 0.45856000e+01},
    { 28,  5,  2,  0, 0.11609230e+03, 0.65458000e+01, 0.00000000e+00},
    { 28,  5,  2,  1, 0.97926800e+02, 0.65458000e+01, 0.97060000e+00},
    { 28,  5,  2,  2, 0.82447400e+02, 0.65458000e+01, 0.19441000e+01},
    { 28,  5,  2,  3, 0.63074000e+02, 0.65458000e+01, 0.29128000e+01},
    { 28,  5,  2,  4, 0.59424700e+02, 0.65458000e+01, 0.45856000e+01},
    { 28,  5,  3,  0, 0.12239150e+03, 0.62918000e+01, 0.00000000e+00},
    { 28,  5,  3,  1, 0.10292200e+03, 0.62918000e+01, 0.97060000e+00},
    { 28,  5,  3,  2, 0.86389500e+02, 0.62918000e+01, 0.19441000e+01},
    { 28,  5,  3,  3, 0.65561800e+02, 0.62918000e+01, 0.29128000e+01},
    { 28,  5,  3,  4, 0.61697400e+02, 0.62918000e+01, 0.45856000e+01},
    { 28,  6,  0,  0, 0.15585070e+03, 0.00000000e+00, 0.00000000e+00},
    { 28,  6,  0,  1, 0.14627110e+03, 0.00000000e+00, 0.98680000e+00},
    { 28,  6,  0,  2, 0.11680720e+03, 0.00000000e+00, 0.19985000e+01},
    { 28,  6,  0,  3, 0.10923050e+03, 0.00000000e+00, 0.29987000e+01},
    { 28,  6,  0,  4, 0.86660100e+02, 0.00000000e+00, 0.39844000e+01},
    { 28,  6,  1,  0, 0.92810700e+02, 0.17937000e+01, 0.00000000e+00},
    { 28,  6,  1,  1, 0.87043200e+02, 0.17937000e+01, 0.98680000e+00},
    { 28,  6,  1,  2, 0.70944400e+02, 0.17937000e+01, 0.19985000e+01},
    { 28,  6,  1,  3, 0.66389700e+02, 0.17937000e+01, 0.29987000e+01},
    { 28,  6,  1,  4, 0.54239700e+02, 0.17937000e+01, 0.39844000e+01},
    { 28,  6,  2,  0, 0.79205600e+02, 0.65458000e+01, 0.00000000e+00},
    { 28,  6,  2,  1, 0.74314900e+02, 0.65458000e+01, 0.98680000e+00},
    { 28,  6,  2,  2, 0.60867800e+02, 0.65458000e+01, 0.19985000e+01},
    { 28,  6,  2,  3, 0.57004600e+02, 0.65458000e+01, 0.29987000e+01},
    { 28,  6,  2,  4, 0.46907100e+02, 0.65458000e+01, 0.39844000e+01},
    { 28,  6,  3,  0, 0.82593000e+02, 0.62918000e+01, 0.00000000e+00},
    { 28,  6,  3,  1, 0.77512400e+02, 0.62918000e+01, 0.98680000e+00},
    { 28,  6,  3,  2, 0.63209200e+02, 0.62918000e+01, 0.19985000e+01},
    { 28,  6,  3,  3, 0.59198000e+02, 0.62918000e+01, 0.29987000e+01},
    { 28,  6,  3,  4, 0.48414900e+02, 0.62918000e+01, 0.39844000e+01},
    { 28,  7,  0,  0, 0.10498340e+03, 0.00000000e+00, 0.00000000e+00},
    { 28,  7,  0,  1, 0.97776100e+02, 0.00000000e+00, 0.99440000e+00},
    { 28,  7,  0,  2, 0.91429500e+02, 0.00000000e+00, 0.20143000e+01},
    { 28,  7,  0,  3, 0.80085300e+02, 0.00000000e+00, 0.29903000e+01},
    { 28,  7,  1,  0, 0.64851900e+02, 0.17937000e+01, 0.00000000e+00},
    { 28,  7,  1,  1, 0.60460800e+02, 0.17937000e+01, 0.99440000e+00},
    { 28,  7,  1,  2, 0.56786800e+02, 0.17937000e+01, 0.20143000e+01},
    { 28,  7,  1,  3, 0.50021800e+02, 0.17937000e+01, 0.29903000e+01},
    { 28,  7,  2,  0, 0.55895400e+02, 0.65458000e+01, 0.00000000e+00},
    { 28,  7,  2,  1, 0.52153200e+02, 0.65458000e+01, 0.99440000e+00},
    { 28,  7,  2,  2, 0.49051100e+02, 0.65458000e+01, 0.20143000e+01},
    { 28,  7,  2,  3, 0.43309600e+02, 0.65458000e+01, 0.29903000e+01},
    { 28,  7,  3,  0, 0.57846900e+02, 0.62918000e+01, 0.00000000e+00},
    { 28,  7,  3,  1, 0.53969000e+02, 0.62918000e+01, 0.99440000e+00},
    { 28,  7,  3,  2, 0.50719800e+02, 0.62918000e+01, 0.20143000e+01},
    { 28,  7,  3,  3, 0.44744200e+02, 0.62918000e+01, 0.29903000e+01},
    { 28,  8,  0,  0, 0.77401000e+02, 0.00000000e+00, 0.00000000e+00},
    { 28,  8,  0,  1, 0.68908600e+02, 0.00000000e+00, 0.99250000e+00},
    { 28,  8,  0,  2, 0.60257500e+02, 0.00000000e+00, 0.19887000e+01},
    { 28,  8,  1,  0, 0.49099600e+02, 0.17937000e+01, 0.00000000e+00},
    { 28,  8,  1,  1, 0.44017300e+02, 0.17937000e+01, 0.99250000e+00},
    { 28,  8,  1,  2, 0.38859700e+02, 0.17937000e+01, 0.19887000e+01},
    { 28,  8,  2,  0, 0.42646200e+02, 0.65458000e+01, 0.00000000e+00},
    { 28,  8,  2,  1, 0.38319400e+02, 0.65458000e+01, 0.99250000e+00},
    { 28,  8,  2,  2, 0.33942700e+02, 0.65458000e+01, 0.19887000e+01},
    { 28,  8,  3,  0, 0.43916100e+02, 0.62918000e+01, 0.00000000e+00},
    { 28,  8,  3,  1, 0.39412500e+02, 0.62918000e+01, 0.99250000e+00},
    { 28,  8,  3,  2, 0.34859600e+02, 0.62918000e+01, 0.19887000e+01},
    { 28,  9,  0,  0, 0.57324800e+02, 0.00000000e+00, 0.00000000e+00},
    { 28,  9,  0,  1, 0.45515500e+02, 0.00000000e+00, 0.99820000e+00},
    { 28,  9,  1,  0, 0.37215800e+02, 0.17937000e+01, 0.00000000e+00},
    { 28,  9,  1,  1, 0.30300400e+02, 0.17937000e+01, 0.99820000e+00},
    { 28,  9,  2,  0, 0.32555300e+02, 0.65458000e+01, 0.00000000e+00},
    { 28,  9,  2,  1, 0.26700000e+02, 0.65458000e+01, 0.99820000e+00},
    { 28,  9,  3,  0, 0.33392400e+02, 0.62918000e+01, 0.00000000e+00},
    { 28,  9,  3,  1, 0.27270500e+02, 0.62918000e+01, 0.99820000e+00},
    { 28, 10,  0,  0, 0.43312900e+02, 0.00000000e+00, 0.00000000e+00},
    { 28, 10,  1,  0, 0.28655400e+02, 0.17937000e+01, 0.00000000e+00},
    { 28, 10,  2,  0, 0.25221000e+02, 0.65458000e+01, 0.00000000e+00},
    { 28, 10,  3,  0, 0.25794000e+02, 0.62918000e+01, 0.00000000e+00},
    { 28, 11,  0,  0, 0.87793540e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 11,  0,  1, 0.32682710e+03, 0.00000000e+00, 0.96840000e+00},
    { 28, 11,  1,  0, 0.42564550e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 11,  1,  1, 0.17420010e+03, 0.17937000e+01, 0.96840000e+00},
    { 28, 11,  2,  0, 0.34857980e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 11,  2,  1, 0.14518540e+03, 0.65458000e+01, 0.96840000e+00},
    { 28, 11,  3,  0, 0.38337730e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 11,  3,  1, 0.15557860e+03, 0.62918000e+01, 0.96840000e+00},
    { 28, 12,  0,  0, 0.62363050e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 12,  0,  1, 0.50815850e+03, 0.00000000e+00, 0.96280000e+00},
    { 28, 12,  0,  2, 0.31258620e+03, 0.00000000e+00, 0.19496000e+01},
    { 28, 12,  1,  0, 0.32678640e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 12,  1,  1, 0.26937790e+03, 0.17937000e+01, 0.96280000e+00},
    { 28, 12,  1,  2, 0.17553430e+03, 0.17937000e+01, 0.19496000e+01},
    { 28, 12,  2,  0, 0.27122230e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 12,  2,  1, 0.22418120e+03, 0.65458000e+01, 0.96280000e+00},
    { 28, 12,  2,  2, 0.14769120e+03, 0.65458000e+01, 0.19496000e+01},
    { 28, 12,  3,  0, 0.29192630e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 12,  3,  1, 0.24053020e+03, 0.62918000e+01, 0.96280000e+00},
    { 28, 12,  3,  2, 0.15613270e+03, 0.62918000e+01, 0.19496000e+01},
    { 28, 13,  0,  0, 0.55653890e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 13,  0,  1, 0.50035250e+03, 0.00000000e+00, 0.96480000e+00},
    { 28, 13,  0,  2, 0.37922800e+03, 0.00000000e+00, 0.19311000e+01},
    { 28, 13,  0,  3, 0.28511740e+03, 0.00000000e+00, 0.29146000e+01},
    { 28, 13,  1,  0, 0.30082710e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 13,  1,  1, 0.27254090e+03, 0.17937000e+01, 0.96480000e+00},
    { 28, 13,  1,  2, 0.21211940e+03, 0.17937000e+01, 0.19311000e+01},
    { 28, 13,  1,  3, 0.16499240e+03, 0.17937000e+01, 0.29146000e+01},
    { 28, 13,  2,  0, 0.25118770e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 13,  2,  1, 0.22795650e+03, 0.65458000e+01, 0.96480000e+00},
    { 28, 13,  2,  2, 0.17839840e+03, 0.65458000e+01, 0.19311000e+01},
    { 28, 13,  2,  3, 0.13971080e+03, 0.65458000e+01, 0.29146000e+01},
    { 28, 13,  3,  0, 0.26812070e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 13,  3,  1, 0.24284190e+03, 0.62918000e+01, 0.96480000e+00},
    { 28, 13,  3,  2, 0.18876990e+03, 0.62918000e+01, 0.19311000e+01},
    { 28, 13,  3,  3, 0.14661210e+03, 0.62918000e+01, 0.29146000e+01},
    { 28, 14,  0,  0, 0.41935930e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 14,  0,  1, 0.38500480e+03, 0.00000000e+00, 0.95070000e+00},
    { 28, 14,  0,  2, 0.35576410e+03, 0.00000000e+00, 0.19435000e+01},
    { 28, 14,  0,  3, 0.34824770e+03, 0.00000000e+00, 0.29407000e+01},
    { 28, 14,  0,  4, 0.27767940e+03, 0.00000000e+00, 0.38677000e+01},
    { 28, 14,  1,  0, 0.23659520e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 14,  1,  1, 0.21860660e+03, 0.17937000e+01, 0.95070000e+00},
    { 28, 14,  1,  2, 0.20327770e+03, 0.17937000e+01, 0.19435000e+01},
    { 28, 14,  1,  3, 0.19815060e+03, 0.17937000e+01, 0.29407000e+01},
    { 28, 14,  1,  4, 0.16276320e+03, 0.17937000e+01, 0.38677000e+01},
    { 28, 14,  2,  0, 0.19928550e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 14,  2,  1, 0.18441750e+03, 0.65458000e+01, 0.95070000e+00},
    { 28, 14,  2,  2, 0.17172690e+03, 0.65458000e+01, 0.19435000e+01},
    { 28, 14,  2,  3, 0.16731730e+03, 0.65458000e+01, 0.29407000e+01},
    { 28, 14,  2,  4, 0.13826350e+03, 0.65458000e+01, 0.38677000e+01},
    { 28, 14,  3,  0, 0.21041880e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 14,  3,  1, 0.19441840e+03, 0.62918000e+01, 0.95070000e+00},
    { 28, 14,  3,  2, 0.18076730e+03, 0.62918000e+01, 0.19435000e+01},
    { 28, 14,  3,  3, 0.17631430e+03, 0.62918000e+01, 0.29407000e+01},
    { 28, 14,  3,  4, 0.14466440e+03, 0.62918000e+01, 0.38677000e+01},
    { 28, 15,  0,  0, 0.31456980e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 15,  0,  1, 0.30491450e+03, 0.00000000e+00, 0.99470000e+00},
    { 28, 15,  0,  2, 0.30149740e+03, 0.00000000e+00, 0.20102000e+01},
    { 28, 15,  0,  3, 0.27679850e+03, 0.00000000e+00, 0.29859000e+01},
    { 28, 15,  1,  0, 0.18418470e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 15,  1,  1, 0.17877350e+03, 0.17937000e+01, 0.99470000e+00},
    { 28, 15,  1,  2, 0.17637500e+03, 0.17937000e+01, 0.20102000e+01},
    { 28, 15,  1,  3, 0.16353010e+03, 0.17937000e+01, 0.29859000e+01},
    { 28, 15,  2,  0, 0.15644320e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 15,  2,  1, 0.15191520e+03, 0.65458000e+01, 0.99470000e+00},
    { 28, 15,  2,  2, 0.14983280e+03, 0.65458000e+01, 0.20102000e+01},
    { 28, 15,  2,  3, 0.13922010e+03, 0.65458000e+01, 0.29859000e+01},
    { 28, 15,  3,  0, 0.16372990e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 15,  3,  1, 0.15894530e+03, 0.62918000e+01, 0.99470000e+00},
    { 28, 15,  3,  2, 0.15685490e+03, 0.62918000e+01, 0.20102000e+01},
    { 28, 15,  3,  3, 0.14541330e+03, 0.62918000e+01, 0.29859000e+01},
    { 28, 16,  0,  0, 0.25446830e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 16,  0,  1, 0.25180970e+03, 0.00000000e+00, 0.99480000e+00},
    { 28, 16,  0,  2, 0.24658640e+03, 0.00000000e+00, 0.19903000e+01},
    { 28, 16,  1,  0, 0.15270360e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 16,  1,  1, 0.15102860e+03, 0.17937000e+01, 0.99480000e+00},
    { 28, 16,  1,  2, 0.14797530e+03, 0.17937000e+01, 0.19903000e+01},
    { 28, 16,  2,  0, 0.13051020e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 16,  2,  1, 0.12907630e+03, 0.65458000e+01, 0.99480000e+00},
    { 28, 16,  2,  2, 0.12649470e+03, 0.65458000e+01, 0.19903000e+01},
    { 28, 16,  3,  0, 0.13584700e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 16,  3,  1, 0.13437370e+03, 0.62918000e+01, 0.99480000e+00},
    { 28, 16,  3,  2, 0.13167410e+03, 0.62918000e+01, 0.19903000e+01},
    { 28, 17,  0,  0, 0.20277050e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 17,  0,  1, 0.20075710e+03, 0.00000000e+00, 0.99720000e+00},
    { 28, 17,  1,  0, 0.12463170e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 17,  1,  1, 0.12334570e+03, 0.17937000e+01, 0.99720000e+00},
    { 28, 17,  2,  0, 0.10719760e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 17,  2,  1, 0.10609050e+03, 0.65458000e+01, 0.99720000e+00},
    { 28, 17,  3,  0, 0.11102480e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 17,  3,  1, 0.10989000e+03, 0.62918000e+01, 0.99720000e+00},
    { 28, 18,  0,  0, 0.16232640e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 18,  1,  0, 0.10191160e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 18,  2,  0, 0.88182900e+02, 0.65458000e+01, 0.00000000e+00},
    { 28, 18,  3,  0, 0.90955300e+02, 0.62918000e+01, 0.00000000e+00},
    { 28, 19,  0,  0, 0.14584501e+04, 0.00000000e+00, 0.00000000e+00},
    { 28, 19,  0,  1, 0.43928450e+03, 0.00000000e+00, 0.97670000e+00},
    { 28, 19,  1,  0, 0.69776500e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 19,  1,  1, 0.23988490e+03, 0.17937000e+01, 0.97670000e+00},
    { 28, 19,  2,  0, 0.57086590e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 19,  2,  1, 0.20137990e+03, 0.65458000e+01, 0.97670000e+00},
    { 28, 19,  3,  0, 0.63014120e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 19,  3,  1, 0.21449610e+03, 0.62918000e+01, 0.97670000e+00},
    { 28, 20,  0,  0, 0.11321074e+04, 0.00000000e+00, 0.00000000e+00},
    { 28, 20,  0,  1, 0.90260140e+03, 0.00000000e+00, 0.98310000e+00},
    { 28, 20,  0,  2, 0.43824820e+03, 0.00000000e+00, 0.19349000e+01},
    { 28, 20,  1,  0, 0.57475220e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 20,  1,  1, 0.45968120e+03, 0.17937000e+01, 0.98310000e+00},
    { 28, 20,  1,  2, 0.24611560e+03, 0.17937000e+01, 0.19349000e+01},
    { 28, 20,  2,  0, 0.47482250e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 20,  2,  1, 0.38042010e+03, 0.65458000e+01, 0.98310000e+00},
    { 28, 20,  2,  2, 0.20744400e+03, 0.65458000e+01, 0.19349000e+01},
    { 28, 20,  3,  0, 0.51554150e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 20,  3,  1, 0.41261420e+03, 0.62918000e+01, 0.98310000e+00},
    { 28, 20,  3,  2, 0.21936790e+03, 0.62918000e+01, 0.19349000e+01},
    { 28, 21,  0,  0, 0.92189900e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 21,  0,  1, 0.42466930e+03, 0.00000000e+00, 0.18627000e+01},
    { 28, 21,  0,  2, 0.41378410e+03, 0.00000000e+00, 0.28999000e+01},
    { 28, 21,  1,  0, 0.47462540e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 21,  1,  1, 0.23965630e+03, 0.17937000e+01, 0.18627000e+01},
    { 28, 21,  1,  2, 0.23632960e+03, 0.17937000e+01, 0.28999000e+01},
    { 28, 21,  2,  0, 0.39304870e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 21,  2,  1, 0.20223920e+03, 0.65458000e+01, 0.18627000e+01},
    { 28, 21,  2,  2, 0.19985020e+03, 0.65458000e+01, 0.28999000e+01},
    { 28, 21,  3,  0, 0.42512770e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 21,  3,  1, 0.21361290e+03, 0.62918000e+01, 0.18627000e+01},
    { 28, 21,  3,  2, 0.21045590e+03, 0.62918000e+01, 0.28999000e+01},
    { 28, 22,  0,  0, 0.87809390e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 22,  0,  1, 0.40935550e+03, 0.00000000e+00, 0.18299000e+01},
    { 28, 22,  0,  2, 0.41831130e+03, 0.00000000e+00, 0.38675000e+01},
    { 28, 22,  1,  0, 0.45811360e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 22,  1,  1, 0.23136310e+03, 0.17937000e+01, 0.18299000e+01},
    { 28, 22,  1,  2, 0.23923230e+03, 0.17937000e+01, 0.38675000e+01},
    { 28, 22,  2,  0, 0.38043770e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 22,  2,  1, 0.19535160e+03, 0.65458000e+01, 0.18299000e+01},
    { 28, 22,  2,  2, 0.20237460e+03, 0.65458000e+01, 0.38675000e+01},
    { 28, 22,  3,  0, 0.41001290e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 22,  3,  1, 0.20626510e+03, 0.62918000e+01, 0.18299000e+01},
    { 28, 22,  3,  2, 0.21305010e+03, 0.62918000e+01, 0.38675000e+01},
    { 28, 23,  0,  0, 0.79751950e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 23,  0,  1, 0.40143290e+03, 0.00000000e+00, 0.19138000e+01},
    { 28, 23,  0,  2, 0.38325570e+03, 0.00000000e+00, 0.29110000e+01},
    { 28, 23,  1,  0, 0.41940370e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 23,  1,  1, 0.22676010e+03, 0.17937000e+01, 0.19138000e+01},
    { 28, 23,  1,  2, 0.21899430e+03, 0.17937000e+01, 0.29110000e+01},
    { 28, 23,  2,  0, 0.34885100e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 23,  2,  1, 0.19147150e+03, 0.65458000e+01, 0.19138000e+01},
    { 28, 23,  2,  2, 0.18532650e+03, 0.65458000e+01, 0.29110000e+01},
    { 28, 23,  3,  0, 0.37517450e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 23,  3,  1, 0.20220500e+03, 0.62918000e+01, 0.19138000e+01},
    { 28, 23,  3,  2, 0.19516290e+03, 0.62918000e+01, 0.29110000e+01},
    { 28, 24,  0,  0, 0.62664720e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 24,  0,  1, 0.39945300e+03, 0.00000000e+00, 0.18269000e+01},
    { 28, 24,  0,  2, 0.28029770e+03, 0.00000000e+00, 0.10619100e+02},
    { 28, 24,  1,  0, 0.33038080e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 24,  1,  1, 0.22471760e+03, 0.17937000e+01, 0.18269000e+01},
    { 28, 24,  1,  2, 0.16478470e+03, 0.17937000e+01, 0.10619100e+02},
    { 28, 24,  2,  0, 0.27525510e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 24,  2,  1, 0.18962030e+03, 0.65458000e+01, 0.18269000e+01},
    { 28, 24,  2,  2, 0.14047480e+03, 0.65458000e+01, 0.10619100e+02},
    { 28, 24,  3,  0, 0.29585990e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 24,  3,  1, 0.20045980e+03, 0.62918000e+01, 0.18269000e+01},
    { 28, 24,  3,  2, 0.14698850e+03, 0.62918000e+01, 0.10619100e+02},
    { 28, 25,  0,  0, 0.67845310e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 25,  0,  1, 0.36001720e+03, 0.00000000e+00, 0.16406000e+01},
    { 28, 25,  0,  2, 0.23544990e+03, 0.00000000e+00, 0.98849000e+01},
    { 28, 25,  1,  0, 0.36096920e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 25,  1,  1, 0.20661260e+03, 0.17937000e+01, 0.16406000e+01},
    { 28, 25,  1,  2, 0.14090800e+03, 0.17937000e+01, 0.98849000e+01},
    { 28, 25,  2,  0, 0.30096400e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 25,  2,  1, 0.17495290e+03, 0.65458000e+01, 0.16406000e+01},
    { 28, 25,  2,  2, 0.12062490e+03, 0.65458000e+01, 0.98849000e+01},
    { 28, 25,  3,  0, 0.32268450e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 25,  3,  1, 0.18404780e+03, 0.62918000e+01, 0.16406000e+01},
    { 28, 25,  3,  2, 0.12572050e+03, 0.62918000e+01, 0.98849000e+01},
    { 28, 26,  0,  0, 0.53032210e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 26,  0,  1, 0.33106140e+03, 0.00000000e+00, 0.16483000e+01},
    { 28, 26,  0,  2, 0.23164220e+03, 0.00000000e+00, 0.91376000e+01},
    { 28, 26,  1,  0, 0.28330110e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 26,  1,  1, 0.19117980e+03, 0.17937000e+01, 0.16483000e+01},
    { 28, 26,  1,  2, 0.13834240e+03, 0.17937000e+01, 0.91376000e+01},
    { 28, 26,  2,  0, 0.23668420e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 26,  2,  1, 0.16212930e+03, 0.65458000e+01, 0.16483000e+01},
    { 28, 26,  2,  2, 0.11838000e+03, 0.65458000e+01, 0.91376000e+01},
    { 28, 26,  3,  0, 0.25353650e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 26,  3,  1, 0.17031170e+03, 0.62918000e+01, 0.16483000e+01},
    { 28, 26,  3,  2, 0.12344170e+03, 0.62918000e+01, 0.91376000e+01},
    { 28, 27,  0,  0, 0.55308340e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 27,  0,  1, 0.31577130e+03, 0.00000000e+00, 0.17149000e+01},
    { 28, 27,  0,  2, 0.27970520e+03, 0.00000000e+00, 0.29263000e+01},
    { 28, 27,  0,  3, 0.24420530e+03, 0.00000000e+00, 0.77785000e+01},
    { 28, 27,  1,  0, 0.30010550e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 27,  1,  1, 0.18238760e+03, 0.17937000e+01, 0.17149000e+01},
    { 28, 27,  1,  2, 0.16238310e+03, 0.17937000e+01, 0.29263000e+01},
    { 28, 27,  1,  3, 0.14445180e+03, 0.17937000e+01, 0.77785000e+01},
    { 28, 27,  2,  0, 0.25118370e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 27,  2,  1, 0.15471980e+03, 0.65458000e+01, 0.17149000e+01},
    { 28, 27,  2,  2, 0.13802230e+03, 0.65458000e+01, 0.29263000e+01},
    { 28, 27,  2,  3, 0.12331710e+03, 0.65458000e+01, 0.77785000e+01},
    { 28, 27,  3,  0, 0.26794820e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 27,  3,  1, 0.16252860e+03, 0.62918000e+01, 0.17149000e+01},
    { 28, 27,  3,  2, 0.14484240e+03, 0.62918000e+01, 0.29263000e+01},
    { 28, 27,  3,  3, 0.12886410e+03, 0.62918000e+01, 0.77785000e+01},
    { 28, 28,  0,  0, 0.57474360e+03, 0.00000000e+00, 0.00000000e+00},
    { 28, 28,  1,  0, 0.30925430e+03, 0.17937000e+01, 0.00000000e+00},
    { 28, 28,  1,  1, 0.17833110e+03, 0.17937000e+01, 0.17937000e+01},
    { 28, 28,  2,  0, 0.25838880e+03, 0.65458000e+01, 0.00000000e+00},
    { 28, 28,  2,  1, 0.15124090e+03, 0.65458000e+01, 0.17937000e+01},
    { 28, 28,  2,  2, 0.12878200e+03, 0.65458000e+01, 0.65458000e+01},
    { 28, 28,  3,  0, 0.27623270e+03, 0.62918000e+01, 0.00000000e+00},
    { 28, 28,  3,  1, 0.15894050e+03, 0.62918000e+01, 0.17937000e+01},
    { 28, 28,  3,  2, 0.13489330e+03, 0.62918000e+01, 0.65458000e+01},
    { 28, 28,  3,  3, 0.14187630e+03, 0.62918000e+01, 0.62918000e+01},
    { 29,  1,  0,  0, 0.28594000e+02, 0.00000000e+00, 0.91180000e+00},
    { 29,  1,  0,  1, 0.47649900e+02, 0.00000000e+00, 0.00000000e+00},
    { 29,  1,  1,  0, 0.22155000e+02, 0.95760000e+00, 0.91180000e+00},
    { 29,  1,  1,  1, 0.35987100e+02, 0.95760000e+00, 0.00000000e+00},
    { 29,  2,  0,  0, 0.18021600e+02, 0.00000000e+00, 0.00000000e+00},
    { 29,  2,  1,  0, 0.14514700e+02, 0.95760000e+00, 0.00000000e+00},
    { 29,  3,  0,  0, 0.56945260e+03, 0.00000000e+00, 0.00000000e+00},
    { 29,  3,  0,  1, 0.16880750e+03, 0.00000000e+00, 0.98650000e+00},
    { 29,  3,  1,  0, 0.36743080e+03, 0.95760000e+00, 0.00000000e+00},
    { 29,  3,  1,  1, 0.11943970e+03, 0.95760000e+00, 0.98650000e+00},
    { 29,  4,  0,  0, 0.29279550e+03, 0.00000000e+00, 0.00000000e+00},
    { 29,  4,  0,  1, 0.21297970e+03, 0.00000000e+00, 0.98080000e+00},
    { 29,  4,  0,  2, 0.13080120e+03, 0.00000000e+00, 0.19697000e+01},
    { 29,  4,  1,  0, 0.20593130e+03, 0.95760000e+00, 0.00000000e+00},
    { 29,  4,  1,  1, 0.15184260e+03, 0.95760000e+00, 0.98080000e+00},
    { 29,  4,  1,  2, 0.97534000e+02, 0.95760000e+00, 0.19697000e+01},
    { 29,  5,  0,  0, 0.18517410e+03, 0.00000000e+00, 0.00000000e+00},
    { 29,  5,  0,  1, 0.15388240e+03, 0.00000000e+00, 0.97060000e+00},
    { 29,  5,  0,  2, 0.12766860e+03, 0.00000000e+00, 0.19441000e+01},
    { 29,  5,  0,  3, 0.93766000e+02, 0.00000000e+00, 0.29128000e+01},
    { 29,  5,  0,  4, 0.87805200e+02, 0.00000000e+00, 0.45856000e+01},
    { 29,  5,  1,  0, 0.13637050e+03, 0.95760000e+00, 0.00000000e+00},
    { 29,  5,  1,  1, 0.11434660e+03, 0.95760000e+00, 0.97060000e+00},
    { 29,  5,  1,  2, 0.95700700e+02, 0.95760000e+00, 0.19441000e+01},
    { 29,  5,  1,  3, 0.72121600e+02, 0.95760000e+00, 0.29128000e+01},
    { 29,  5,  1,  4, 0.67783500e+02, 0.95760000e+00, 0.45856000e+01},
    { 29,  6,  0,  0, 0.11963500e+03, 0.00000000e+00, 0.00000000e+00},
    { 29,  6,  0,  1, 0.11239140e+03, 0.00000000e+00, 0.98680000e+00},
    { 29,  6,  0,  2, 0.89951500e+02, 0.00000000e+00, 0.19985000e+01},
    { 29,  6,  0,  3, 0.84202800e+02, 0.00000000e+00, 0.29987000e+01},
    { 29,  6,  0,  4, 0.67082300e+02, 0.00000000e+00, 0.39844000e+01},
    { 29,  6,  1,  0, 0.91102500e+02, 0.95760000e+00, 0.00000000e+00},
    { 29,  6,  1,  1, 0.85473100e+02, 0.95760000e+00, 0.98680000e+00},
    { 29,  6,  1,  2, 0.69405800e+02, 0.95760000e+00, 0.19985000e+01},
    { 29,  6,  1,  3, 0.64964100e+02, 0.95760000e+00, 0.29987000e+01},
    { 29,  6,  1,  4, 0.52798400e+02, 0.95760000e+00, 0.39844000e+01},
    { 29,  7,  0,  0, 0.81085500e+02, 0.00000000e+00, 0.00000000e+00},
    { 29,  7,  0,  1, 0.75598700e+02, 0.00000000e+00, 0.99440000e+00},
    { 29,  7,  0,  2, 0.70763900e+02, 0.00000000e+00, 0.20143000e+01},
    { 29,  7,  0,  3, 0.62129900e+02, 0.00000000e+00, 0.29903000e+01},
    { 29,  7,  1,  0, 0.63270900e+02, 0.95760000e+00, 0.00000000e+00},
    { 29,  7,  1,  1, 0.58990300e+02, 0.95760000e+00, 0.99440000e+00},
    { 29,  7,  1,  2, 0.55378900e+02, 0.95760000e+00, 0.20143000e+01},
    { 29,  7,  1,  3, 0.48763000e+02, 0.95760000e+00, 0.29903000e+01},
    { 29,  8,  0,  0, 0.60133500e+02, 0.00000000e+00, 0.00000000e+00},
    { 29,  8,  0,  1, 0.53642000e+02, 0.00000000e+00, 0.99250000e+00},
    { 29,  8,  0,  2, 0.47058500e+02, 0.00000000e+00, 0.19887000e+01},
    { 29,  8,  1,  0, 0.47723900e+02, 0.95760000e+00, 0.00000000e+00},
    { 29,  8,  1,  1, 0.42745800e+02, 0.95760000e+00, 0.99250000e+00},
    { 29,  8,  1,  2, 0.37708300e+02, 0.95760000e+00, 0.19887000e+01},
    { 29,  9,  0,  0, 0.44809800e+02, 0.00000000e+00, 0.00000000e+00},
    { 29,  9,  0,  1, 0.35810000e+02, 0.00000000e+00, 0.99820000e+00},
    { 29,  9,  1,  0, 0.36074900e+02, 0.95760000e+00, 0.00000000e+00},
    { 29,  9,  1,  1, 0.29280800e+02, 0.95760000e+00, 0.99820000e+00},
    { 29, 10,  0,  0, 0.34054400e+02, 0.00000000e+00, 0.00000000e+00},
    { 29, 10,  1,  0, 0.27728200e+02, 0.95760000e+00, 0.00000000e+00},
    { 29, 11,  0,  0, 0.67647730e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 11,  0,  1, 0.24981970e+03, 0.00000000e+00, 0.96840000e+00},
    { 29, 11,  1,  0, 0.43871980e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 11,  1,  1, 0.17525310e+03, 0.95760000e+00, 0.96840000e+00},
    { 29, 12,  0,  0, 0.47624260e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 12,  0,  1, 0.38842090e+03, 0.00000000e+00, 0.96280000e+00},
    { 29, 12,  0,  2, 0.23853700e+03, 0.00000000e+00, 0.19496000e+01},
    { 29, 12,  1,  0, 0.33000180e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 12,  1,  1, 0.27127550e+03, 0.95760000e+00, 0.96280000e+00},
    { 29, 12,  1,  2, 0.17436190e+03, 0.95760000e+00, 0.19496000e+01},
    { 29, 13,  0,  0, 0.42477230e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 13,  0,  1, 0.38199230e+03, 0.00000000e+00, 0.96480000e+00},
    { 29, 13,  0,  2, 0.28968240e+03, 0.00000000e+00, 0.19311000e+01},
    { 29, 13,  0,  3, 0.21789580e+03, 0.00000000e+00, 0.29146000e+01},
    { 29, 13,  1,  0, 0.30146500e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 13,  1,  1, 0.27263840e+03, 0.95760000e+00, 0.96480000e+00},
    { 29, 13,  1,  2, 0.21090190e+03, 0.95760000e+00, 0.19311000e+01},
    { 29, 13,  1,  3, 0.16280210e+03, 0.95760000e+00, 0.29146000e+01},
    { 29, 14,  0,  0, 0.32019130e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 14,  0,  1, 0.29414060e+03, 0.00000000e+00, 0.95070000e+00},
    { 29, 14,  0,  2, 0.27189110e+03, 0.00000000e+00, 0.19435000e+01},
    { 29, 14,  0,  3, 0.26631200e+03, 0.00000000e+00, 0.29407000e+01},
    { 29, 14,  0,  4, 0.21252810e+03, 0.00000000e+00, 0.38677000e+01},
    { 29, 14,  1,  0, 0.23475480e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 14,  1,  1, 0.21661540e+03, 0.95760000e+00, 0.95070000e+00},
    { 29, 14,  1,  2, 0.20115730e+03, 0.95760000e+00, 0.19435000e+01},
    { 29, 14,  1,  3, 0.19629960e+03, 0.95760000e+00, 0.29407000e+01},
    { 29, 14,  1,  4, 0.16019460e+03, 0.95760000e+00, 0.38677000e+01},
    { 29, 15,  0,  0, 0.24079740e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 15,  0,  1, 0.23348980e+03, 0.00000000e+00, 0.99470000e+00},
    { 29, 15,  0,  2, 0.23090910e+03, 0.00000000e+00, 0.20102000e+01},
    { 29, 15,  0,  3, 0.21213400e+03, 0.00000000e+00, 0.29859000e+01},
    { 29, 15,  1,  0, 0.18132670e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 15,  1,  1, 0.17596280e+03, 0.95760000e+00, 0.99470000e+00},
    { 29, 15,  1,  2, 0.17370060e+03, 0.95760000e+00, 0.20102000e+01},
    { 29, 15,  1,  3, 0.16072250e+03, 0.95760000e+00, 0.29859000e+01},
    { 29, 16,  0,  0, 0.19540750e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 16,  0,  1, 0.19338650e+03, 0.00000000e+00, 0.99480000e+00},
    { 29, 16,  0,  2, 0.18941220e+03, 0.00000000e+00, 0.19903000e+01},
    { 29, 16,  1,  0, 0.14964210e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 16,  1,  1, 0.14802440e+03, 0.95760000e+00, 0.99480000e+00},
    { 29, 16,  1,  2, 0.14502500e+03, 0.95760000e+00, 0.19903000e+01},
    { 29, 17,  0,  0, 0.15631610e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 17,  0,  1, 0.15477560e+03, 0.00000000e+00, 0.99720000e+00},
    { 29, 17,  1,  0, 0.12163290e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 17,  1,  1, 0.12039270e+03, 0.95760000e+00, 0.99720000e+00},
    { 29, 18,  0,  0, 0.12567760e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 18,  1,  0, 0.99139800e+02, 0.95760000e+00, 0.00000000e+00},
    { 29, 19,  0,  0, 0.11299518e+04, 0.00000000e+00, 0.00000000e+00},
    { 29, 19,  0,  1, 0.33711170e+03, 0.00000000e+00, 0.97670000e+00},
    { 29, 19,  1,  0, 0.72200020e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 19,  1,  1, 0.24017910e+03, 0.95760000e+00, 0.97670000e+00},
    { 29, 20,  0,  0, 0.86836740e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 20,  0,  1, 0.69450580e+03, 0.00000000e+00, 0.98310000e+00},
    { 29, 20,  0,  2, 0.33535920e+03, 0.00000000e+00, 0.19349000e+01},
    { 29, 20,  1,  0, 0.58537040e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 20,  1,  1, 0.46791560e+03, 0.95760000e+00, 0.98310000e+00},
    { 29, 20,  1,  2, 0.24467160e+03, 0.95760000e+00, 0.19349000e+01},
    { 29, 21,  0,  0, 0.70607200e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 21,  0,  1, 0.32508500e+03, 0.00000000e+00, 0.18627000e+01},
    { 29, 21,  0,  2, 0.31671020e+03, 0.00000000e+00, 0.28999000e+01},
    { 29, 21,  1,  0, 0.48164720e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 21,  1,  1, 0.23801280e+03, 0.95760000e+00, 0.18627000e+01},
    { 29, 21,  1,  2, 0.23403740e+03, 0.95760000e+00, 0.28999000e+01},
    { 29, 22,  0,  0, 0.67241280e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 22,  0,  1, 0.31360260e+03, 0.00000000e+00, 0.18299000e+01},
    { 29, 22,  0,  2, 0.32021980e+03, 0.00000000e+00, 0.38675000e+01},
    { 29, 22,  1,  0, 0.46339240e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 22,  1,  1, 0.22972260e+03, 0.95760000e+00, 0.18299000e+01},
    { 29, 22,  1,  2, 0.23685320e+03, 0.95760000e+00, 0.38675000e+01},
    { 29, 23,  0,  0, 0.61057000e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 23,  0,  1, 0.30757630e+03, 0.00000000e+00, 0.19138000e+01},
    { 29, 23,  0,  2, 0.29368160e+03, 0.00000000e+00, 0.29110000e+01},
    { 29, 23,  1,  0, 0.42341930e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 23,  1,  1, 0.22520200e+03, 0.95760000e+00, 0.19138000e+01},
    { 29, 23,  1,  2, 0.21692030e+03, 0.95760000e+00, 0.29110000e+01},
    { 29, 24,  0,  0, 0.48069380e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 24,  0,  1, 0.30611810e+03, 0.00000000e+00, 0.18269000e+01},
    { 29, 24,  0,  2, 0.21550230e+03, 0.00000000e+00, 0.10619100e+02},
    { 29, 24,  1,  0, 0.33350140e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 24,  1,  1, 0.22340090e+03, 0.95760000e+00, 0.18269000e+01},
    { 29, 24,  1,  2, 0.16235450e+03, 0.95760000e+00, 0.10619100e+02},
    { 29, 25,  0,  0, 0.51930780e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 25,  0,  1, 0.27572060e+03, 0.00000000e+00, 0.16406000e+01},
    { 29, 25,  0,  2, 0.18134820e+03, 0.00000000e+00, 0.98849000e+01},
    { 29, 25,  1,  0, 0.36341710e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 25,  1,  1, 0.20444800e+03, 0.95760000e+00, 0.16406000e+01},
    { 29, 25,  1,  2, 0.13835720e+03, 0.95760000e+00, 0.98849000e+01},
    { 29, 26,  0,  0, 0.40672680e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 26,  0,  1, 0.25370380e+03, 0.00000000e+00, 0.16483000e+01},
    { 29, 26,  0,  2, 0.17839240e+03, 0.00000000e+00, 0.91376000e+01},
    { 29, 26,  1,  0, 0.28510180e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 26,  1,  1, 0.18894450e+03, 0.95760000e+00, 0.16483000e+01},
    { 29, 26,  1,  2, 0.13590190e+03, 0.95760000e+00, 0.91376000e+01},
    { 29, 27,  0,  0, 0.42308770e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 27,  0,  1, 0.24210300e+03, 0.00000000e+00, 0.17149000e+01},
    { 29, 27,  0,  2, 0.21480930e+03, 0.00000000e+00, 0.29263000e+01},
    { 29, 27,  0,  3, 0.18784400e+03, 0.00000000e+00, 0.77785000e+01},
    { 29, 27,  1,  0, 0.30073560e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 27,  1,  1, 0.18027190e+03, 0.95760000e+00, 0.17149000e+01},
    { 29, 27,  1,  2, 0.16040150e+03, 0.95760000e+00, 0.29263000e+01},
    { 29, 27,  1,  3, 0.14216340e+03, 0.95760000e+00, 0.77785000e+01},
    { 29, 28,  0,  0, 0.43963650e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 28,  0,  1, 0.23712000e+03, 0.00000000e+00, 0.17937000e+01},
    { 29, 28,  0,  2, 0.19852020e+03, 0.00000000e+00, 0.65458000e+01},
    { 29, 28,  0,  3, 0.21214340e+03, 0.00000000e+00, 0.62918000e+01},
    { 29, 28,  1,  0, 0.31051330e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 28,  1,  1, 0.17633580e+03, 0.95760000e+00, 0.17937000e+01},
    { 29, 28,  1,  2, 0.14914790e+03, 0.95760000e+00, 0.65458000e+01},
    { 29, 28,  1,  3, 0.15733960e+03, 0.95760000e+00, 0.62918000e+01},
    { 29, 29,  0,  0, 0.33718080e+03, 0.00000000e+00, 0.00000000e+00},
    { 29, 29,  1,  0, 0.23812070e+03, 0.95760000e+00, 0.00000000e+00},
    { 29, 29,  1,  1, 0.17499690e+03, 0.95760000e+00, 0.95760000e+00},
    { 30,  1,  0,  0, 0.29868900e+02, 0.00000000e+00, 0.91180000e+00},
    { 30,  1,  0,  1, 0.49346900e+02, 0.00000000e+00, 0.00000000e+00},
    { 30,  1,  1,  0, 0.21213900e+02, 0.19419000e+01, 0.91180000e+00},
    { 30,  1,  1,  1, 0.34031200e+02, 0.19419000e+01, 0.00000000e+00},
    { 30,  2,  0,  0, 0.18969500e+02, 0.00000000e+00, 0.00000000e+00},
    { 30,  2,  1,  0, 0.14118500e+02, 0.19419000e+01, 0.00000000e+00},
    { 30,  3,  0,  0, 0.54091600e+03, 0.00000000e+00, 0.00000000e+00},
    { 30,  3,  0,  1, 0.16949490e+03, 0.00000000e+00, 0.98650000e+00},
    { 30,  3,  1,  0, 0.31788260e+03, 0.19419000e+01, 0.00000000e+00},
    { 30,  3,  1,  1, 0.10901270e+03, 0.19419000e+01, 0.98650000e+00},
    { 30,  4,  0,  0, 0.29331060e+03, 0.00000000e+00, 0.00000000e+00},
    { 30,  4,  0,  1, 0.21442560e+03, 0.00000000e+00, 0.98080000e+00},
    { 30,  4,  0,  2, 0.13479330e+03, 0.00000000e+00, 0.19697000e+01},
    { 30,  4,  1,  0, 0.18730120e+03, 0.19419000e+01, 0.00000000e+00},
    { 30,  4,  1,  1, 0.13924200e+03, 0.19419000e+01, 0.98080000e+00},
    { 30,  4,  1,  2, 0.91622700e+02, 0.19419000e+01, 0.19697000e+01},
    { 30,  5,  0,  0, 0.18962930e+03, 0.00000000e+00, 0.00000000e+00},
    { 30,  5,  0,  1, 0.15808480e+03, 0.00000000e+00, 0.97060000e+00},
    { 30,  5,  0,  2, 0.13152520e+03, 0.00000000e+00, 0.19441000e+01},
    { 30,  5,  0,  3, 0.97684500e+02, 0.00000000e+00, 0.29128000e+01},
    { 30,  5,  0,  4, 0.91572800e+02, 0.00000000e+00, 0.45856000e+01},
    { 30,  5,  1,  0, 0.12724880e+03, 0.19419000e+01, 0.00000000e+00},
    { 30,  5,  1,  1, 0.10720260e+03, 0.19419000e+01, 0.97060000e+00},
    { 30,  5,  1,  2, 0.90135100e+02, 0.19419000e+01, 0.19441000e+01},
    { 30,  5,  1,  3, 0.68807700e+02, 0.19419000e+01, 0.29128000e+01},
    { 30,  5,  1,  4, 0.64779800e+02, 0.19419000e+01, 0.45856000e+01},
    { 30,  6,  0,  0, 0.12410320e+03, 0.00000000e+00, 0.00000000e+00},
    { 30,  6,  0,  1, 0.11639870e+03, 0.00000000e+00, 0.98680000e+00},
    { 30,  6,  0,  2, 0.93687000e+02, 0.00000000e+00, 0.19985000e+01},
    { 30,  6,  0,  3, 0.87612400e+02, 0.00000000e+00, 0.29987000e+01},
    { 30,  6,  0,  4, 0.70282000e+02, 0.00000000e+00, 0.39844000e+01},
    { 30,  6,  1,  0, 0.86470900e+02, 0.19419000e+01, 0.00000000e+00},
    { 30,  6,  1,  1, 0.81068600e+02, 0.19419000e+01, 0.98680000e+00},
    { 30,  6,  1,  2, 0.66283800e+02, 0.19419000e+01, 0.19985000e+01},
    { 30,  6,  1,  3, 0.62022800e+02, 0.19419000e+01, 0.29987000e+01},
    { 30,  6,  1,  4, 0.50885600e+02, 0.19419000e+01, 0.39844000e+01},
    { 30,  7,  0,  0, 0.84731100e+02, 0.00000000e+00, 0.00000000e+00},
    { 30,  7,  0,  1, 0.78918300e+02, 0.00000000e+00, 0.99440000e+00},
    { 30,  7,  0,  2, 0.73921000e+02, 0.00000000e+00, 0.20143000e+01},
    { 30,  7,  0,  3, 0.64863300e+02, 0.00000000e+00, 0.29903000e+01},
    { 30,  7,  1,  0, 0.60733100e+02, 0.19419000e+01, 0.00000000e+00},
    { 30,  7,  1,  1, 0.56614000e+02, 0.19419000e+01, 0.99440000e+00},
    { 30,  7,  1,  2, 0.53207000e+02, 0.19419000e+01, 0.20143000e+01},
    { 30,  7,  1,  3, 0.46891100e+02, 0.19419000e+01, 0.29903000e+01},
    { 30,  8,  0,  0, 0.63077400e+02, 0.00000000e+00, 0.00000000e+00},
    { 30,  8,  0,  1, 0.56288400e+02, 0.00000000e+00, 0.99250000e+00},
    { 30,  8,  0,  2, 0.49389700e+02, 0.00000000e+00, 0.19887000e+01},
    { 30,  8,  1,  0, 0.46135500e+02, 0.19419000e+01, 0.00000000e+00},
    { 30,  8,  1,  1, 0.41386200e+02, 0.19419000e+01, 0.99250000e+00},
    { 30,  8,  1,  2, 0.36576400e+02, 0.19419000e+01, 0.19887000e+01},
    { 30,  9,  0,  0, 0.47112200e+02, 0.00000000e+00, 0.00000000e+00},
    { 30,  9,  0,  1, 0.37755900e+02, 0.00000000e+00, 0.99820000e+00},
    { 30,  9,  1,  0, 0.35062900e+02, 0.19419000e+01, 0.00000000e+00},
    { 30,  9,  1,  1, 0.28629100e+02, 0.19419000e+01, 0.99820000e+00},
    { 30, 10,  0,  0, 0.35842700e+02, 0.00000000e+00, 0.00000000e+00},
    { 30, 10,  1,  0, 0.27052400e+02, 0.19419000e+01, 0.00000000e+00},
    { 30, 11,  0,  0, 0.64434080e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 11,  0,  1, 0.24939250e+03, 0.00000000e+00, 0.96840000e+00},
    { 30, 11,  1,  0, 0.38065680e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 11,  1,  1, 0.15912280e+03, 0.19419000e+01, 0.96840000e+00},
    { 30, 12,  0,  0, 0.47291430e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 12,  0,  1, 0.38688840e+03, 0.00000000e+00, 0.96280000e+00},
    { 30, 12,  0,  2, 0.24356630e+03, 0.00000000e+00, 0.19496000e+01},
    { 30, 12,  1,  0, 0.29754400e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 12,  1,  1, 0.24580540e+03, 0.19419000e+01, 0.96280000e+00},
    { 30, 12,  1,  2, 0.16200320e+03, 0.19419000e+01, 0.19496000e+01},
    { 30, 13,  0,  0, 0.42716100e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 13,  0,  1, 0.38514490e+03, 0.00000000e+00, 0.96480000e+00},
    { 30, 13,  0,  2, 0.29490170e+03, 0.00000000e+00, 0.19311000e+01},
    { 30, 13,  0,  3, 0.22471970e+03, 0.00000000e+00, 0.29146000e+01},
    { 30, 13,  1,  0, 0.27562990e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 13,  1,  1, 0.25007300e+03, 0.19419000e+01, 0.96480000e+00},
    { 30, 13,  1,  2, 0.19559730e+03, 0.19419000e+01, 0.19311000e+01},
    { 30, 13,  1,  3, 0.15307760e+03, 0.19419000e+01, 0.29146000e+01},
    { 30, 14,  0,  0, 0.32728100e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 14,  0,  1, 0.30117090e+03, 0.00000000e+00, 0.95070000e+00},
    { 30, 14,  0,  2, 0.27896960e+03, 0.00000000e+00, 0.19435000e+01},
    { 30, 14,  0,  3, 0.27256060e+03, 0.00000000e+00, 0.29407000e+01},
    { 30, 14,  0,  4, 0.21988700e+03, 0.00000000e+00, 0.38677000e+01},
    { 30, 14,  1,  0, 0.21852820e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 14,  1,  1, 0.20213060e+03, 0.19419000e+01, 0.95070000e+00},
    { 30, 14,  1,  2, 0.18816130e+03, 0.19419000e+01, 0.19435000e+01},
    { 30, 14,  1,  3, 0.18325560e+03, 0.19419000e+01, 0.29407000e+01},
    { 30, 14,  1,  4, 0.15131410e+03, 0.19419000e+01, 0.38677000e+01},
    { 30, 15,  0,  0, 0.24897430e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 15,  0,  1, 0.24143800e+03, 0.00000000e+00, 0.99470000e+00},
    { 30, 15,  0,  2, 0.23850630e+03, 0.00000000e+00, 0.20102000e+01},
    { 30, 15,  0,  3, 0.21980160e+03, 0.00000000e+00, 0.29859000e+01},
    { 30, 15,  1,  0, 0.17118890e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 15,  1,  1, 0.16618870e+03, 0.19419000e+01, 0.99470000e+00},
    { 30, 15,  1,  2, 0.16388840e+03, 0.19419000e+01, 0.20102000e+01},
    { 30, 15,  1,  3, 0.15220000e+03, 0.19419000e+01, 0.29859000e+01},
    { 30, 16,  0,  0, 0.20324270e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 16,  0,  1, 0.20107040e+03, 0.00000000e+00, 0.99480000e+00},
    { 30, 16,  0,  2, 0.19693310e+03, 0.00000000e+00, 0.19903000e+01},
    { 30, 16,  1,  0, 0.14245910e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 16,  1,  1, 0.14088040e+03, 0.19419000e+01, 0.99480000e+00},
    { 30, 16,  1,  2, 0.13803960e+03, 0.19419000e+01, 0.19903000e+01},
    { 30, 17,  0,  0, 0.16338480e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 17,  0,  1, 0.16173370e+03, 0.00000000e+00, 0.99720000e+00},
    { 30, 17,  1,  0, 0.11666370e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 17,  1,  1, 0.11545010e+03, 0.19419000e+01, 0.99720000e+00},
    { 30, 18,  0,  0, 0.13181190e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 18,  1,  0, 0.95658600e+02, 0.19419000e+01, 0.00000000e+00},
    { 30, 19,  0,  0, 0.10625928e+04, 0.00000000e+00, 0.00000000e+00},
    { 30, 19,  0,  1, 0.33789860e+03, 0.00000000e+00, 0.97670000e+00},
    { 30, 19,  1,  0, 0.62148410e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 19,  1,  1, 0.21998520e+03, 0.19419000e+01, 0.97670000e+00},
    { 30, 20,  0,  0, 0.84685270e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 20,  0,  1, 0.67502990e+03, 0.00000000e+00, 0.98310000e+00},
    { 30, 20,  0,  2, 0.34119230e+03, 0.00000000e+00, 0.19349000e+01},
    { 30, 20,  1,  0, 0.51951820e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 20,  1,  1, 0.41556380e+03, 0.19419000e+01, 0.98310000e+00},
    { 30, 20,  1,  2, 0.22701180e+03, 0.19419000e+01, 0.19349000e+01},
    { 30, 21,  0,  0, 0.69367870e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 21,  0,  1, 0.33123100e+03, 0.00000000e+00, 0.18627000e+01},
    { 30, 21,  0,  2, 0.32428910e+03, 0.00000000e+00, 0.28999000e+01},
    { 30, 21,  1,  0, 0.43036750e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 21,  1,  1, 0.22124670e+03, 0.19419000e+01, 0.18627000e+01},
    { 30, 21,  1,  2, 0.21866030e+03, 0.19419000e+01, 0.28999000e+01},
    { 30, 22,  0,  0, 0.66410090e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 22,  0,  1, 0.31938340e+03, 0.00000000e+00, 0.18299000e+01},
    { 30, 22,  0,  2, 0.32800010e+03, 0.00000000e+00, 0.38675000e+01},
    { 30, 22,  1,  0, 0.41653280e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 22,  1,  1, 0.21361910e+03, 0.19419000e+01, 0.18299000e+01},
    { 30, 22,  1,  2, 0.22139430e+03, 0.19419000e+01, 0.38675000e+01},
    { 30, 23,  0,  0, 0.60506230e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 23,  0,  1, 0.31312860e+03, 0.00000000e+00, 0.19138000e+01},
    { 30, 23,  0,  2, 0.30031300e+03, 0.00000000e+00, 0.29110000e+01},
    { 30, 23,  1,  0, 0.38196290e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 23,  1,  1, 0.20934280e+03, 0.19419000e+01, 0.19138000e+01},
    { 30, 23,  1,  2, 0.20259800e+03, 0.19419000e+01, 0.29110000e+01},
    { 30, 24,  0,  0, 0.47555940e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 24,  0,  1, 0.31106030e+03, 0.00000000e+00, 0.18269000e+01},
    { 30, 24,  0,  2, 0.22196560e+03, 0.00000000e+00, 0.10619100e+02},
    { 30, 24,  1,  0, 0.30093230e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 24,  1,  1, 0.20729260e+03, 0.19419000e+01, 0.18269000e+01},
    { 30, 24,  1,  2, 0.15312950e+03, 0.19419000e+01, 0.10619100e+02},
    { 30, 25,  0,  0, 0.51709100e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 25,  0,  1, 0.28266670e+03, 0.00000000e+00, 0.16406000e+01},
    { 30, 25,  0,  2, 0.18772140e+03, 0.00000000e+00, 0.98849000e+01},
    { 30, 25,  1,  0, 0.32951960e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 25,  1,  1, 0.19131250e+03, 0.19419000e+01, 0.16406000e+01},
    { 30, 25,  1,  2, 0.13131000e+03, 0.19419000e+01, 0.98849000e+01},
    { 30, 26,  0,  0, 0.40455580e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 26,  0,  1, 0.26053410e+03, 0.00000000e+00, 0.16483000e+01},
    { 30, 26,  0,  2, 0.18454030e+03, 0.00000000e+00, 0.91376000e+01},
    { 30, 26,  1,  0, 0.25872900e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 26,  1,  1, 0.17720340e+03, 0.19419000e+01, 0.16483000e+01},
    { 30, 26,  1,  2, 0.12887600e+03, 0.19419000e+01, 0.91376000e+01},
    { 30, 27,  0,  0, 0.42487900e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 27,  0,  1, 0.24848550e+03, 0.00000000e+00, 0.17149000e+01},
    { 30, 27,  0,  2, 0.22045250e+03, 0.00000000e+00, 0.29263000e+01},
    { 30, 27,  0,  3, 0.19385700e+03, 0.00000000e+00, 0.77785000e+01},
    { 30, 27,  1,  0, 0.27503810e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 27,  1,  1, 0.16904610e+03, 0.19419000e+01, 0.17149000e+01},
    { 30, 27,  1,  2, 0.15059460e+03, 0.19419000e+01, 0.29263000e+01},
    { 30, 27,  1,  3, 0.13437060e+03, 0.19419000e+01, 0.77785000e+01},
    { 30, 28,  0,  0, 0.44009000e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 28,  0,  1, 0.24319600e+03, 0.00000000e+00, 0.17937000e+01},
    { 30, 28,  0,  2, 0.20431190e+03, 0.00000000e+00, 0.65458000e+01},
    { 30, 28,  0,  3, 0.21694470e+03, 0.00000000e+00, 0.62918000e+01},
    { 30, 28,  1,  0, 0.28296560e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 28,  1,  1, 0.16523610e+03, 0.19419000e+01, 0.17937000e+01},
    { 30, 28,  1,  2, 0.14045520e+03, 0.19419000e+01, 0.65458000e+01},
    { 30, 28,  1,  3, 0.14715970e+03, 0.19419000e+01, 0.62918000e+01},
    { 30, 29,  0,  0, 0.33664930e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 29,  0,  1, 0.24268930e+03, 0.00000000e+00, 0.95760000e+00},
    { 30, 29,  1,  0, 0.21695700e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 29,  1,  1, 0.16292360e+03, 0.19419000e+01, 0.95760000e+00},
    { 30, 30,  0,  0, 0.34052130e+03, 0.00000000e+00, 0.00000000e+00},
    { 30, 30,  1,  0, 0.22366220e+03, 0.19419000e+01, 0.00000000e+00},
    { 30, 30,  1,  1, 0.15345280e+03, 0.19419000e+01, 0.19419000e+01},
    { 31,  1,  0,  0, 0.35169700e+02, 0.00000000e+00, 0.91180000e+00},
    { 31,  1,  0,  1, 0.58420700e+02, 0.00000000e+00, 0.00000000e+00},
    { 31,  1,  1,  0, 0.33251500e+02, 0.96010000e+00, 0.91180000e+00},
    { 31,  1,  1,  1, 0.54991900e+02, 0.96010000e+00, 0.00000000e+00},
    { 31,  1,  2,  0, 0.26956200e+02, 0.19315000e+01, 0.91180000e+00},
    { 31,  1,  2,  1, 0.43888100e+02, 0.19315000e+01, 0.00000000e+00},
    { 31,  1,  3,  0, 0.22539000e+02, 0.29233000e+01, 0.91180000e+00},
    { 31,  1,  3,  1, 0.36144700e+02, 0.29233000e+01, 0.00000000e+00},
    { 31,  2,  0,  0, 0.22045800e+02, 0.00000000e+00, 0.00000000e+00},
    { 31,  2,  1,  0, 0.20987400e+02, 0.96010000e+00, 0.00000000e+00},
    { 31,  2,  2,  0, 0.17439200e+02, 0.19315000e+01, 0.00000000e+00},
    { 31,  2,  3,  0, 0.14929600e+02, 0.29233000e+01, 0.00000000e+00},
    { 31,  3,  0,  0, 0.65674410e+03, 0.00000000e+00, 0.00000000e+00},
    { 31,  3,  0,  1, 0.20269000e+03, 0.00000000e+00, 0.98650000e+00},
    { 31,  3,  1,  0, 0.60281040e+03, 0.96010000e+00, 0.00000000e+00},
    { 31,  3,  1,  1, 0.18876220e+03, 0.96010000e+00, 0.98650000e+00},
    { 31,  3,  2,  0, 0.44148880e+03, 0.19315000e+01, 0.00000000e+00},
    { 31,  3,  2,  1, 0.14510430e+03, 0.19315000e+01, 0.98650000e+00},
    { 31,  3,  3,  0, 0.33234640e+03, 0.29233000e+01, 0.00000000e+00},
    { 31,  3,  3,  1, 0.11512840e+03, 0.29233000e+01, 0.98650000e+00},
    { 31,  4,  0,  0, 0.35111410e+03, 0.00000000e+00, 0.00000000e+00},
    { 31,  4,  0,  1, 0.25620490e+03, 0.00000000e+00, 0.98080000e+00},
    { 31,  4,  0,  2, 0.15992730e+03, 0.00000000e+00, 0.19697000e+01},
    { 31,  4,  1,  0, 0.32666720e+03, 0.96010000e+00, 0.00000000e+00},
    { 31,  4,  1,  1, 0.23890680e+03, 0.96010000e+00, 0.98080000e+00},
    { 31,  4,  1,  2, 0.15021480e+03, 0.96010000e+00, 0.19697000e+01},
    { 31,  4,  2,  0, 0.25018890e+03, 0.19315000e+01, 0.00000000e+00},
    { 31,  4,  2,  1, 0.18457440e+03, 0.19315000e+01, 0.98080000e+00},
    { 31,  4,  2,  2, 0.11896190e+03, 0.19315000e+01, 0.19697000e+01},
    { 31,  4,  3,  0, 0.19774540e+03, 0.29233000e+01, 0.00000000e+00},
    { 31,  4,  3,  1, 0.14719230e+03, 0.29233000e+01, 0.98080000e+00},
    { 31,  4,  3,  2, 0.97234600e+02, 0.29233000e+01, 0.19697000e+01},
    { 31,  5,  0,  0, 0.22539330e+03, 0.00000000e+00, 0.00000000e+00},
    { 31,  5,  0,  1, 0.18757970e+03, 0.00000000e+00, 0.97060000e+00},
    { 31,  5,  0,  2, 0.15580800e+03, 0.00000000e+00, 0.19441000e+01},
    { 31,  5,  0,  3, 0.11517060e+03, 0.00000000e+00, 0.29128000e+01},
    { 31,  5,  0,  4, 0.10787050e+03, 0.00000000e+00, 0.45856000e+01},
    { 31,  5,  1,  0, 0.21127560e+03, 0.96010000e+00, 0.00000000e+00},
    { 31,  5,  1,  1, 0.17609760e+03, 0.96010000e+00, 0.97060000e+00},
    { 31,  5,  1,  2, 0.14648900e+03, 0.96010000e+00, 0.19441000e+01},
    { 31,  5,  1,  3, 0.10875080e+03, 0.96010000e+00, 0.29128000e+01},
    { 31,  5,  1,  4, 0.10192230e+03, 0.96010000e+00, 0.45856000e+01},
    { 31,  5,  2,  0, 0.16615250e+03, 0.19315000e+01, 0.00000000e+00},
    { 31,  5,  2,  1, 0.13925460e+03, 0.19315000e+01, 0.97060000e+00},
    { 31,  5,  2,  2, 0.11648300e+03, 0.19315000e+01, 0.19441000e+01},
    { 31,  5,  2,  3, 0.87768800e+02, 0.19315000e+01, 0.29128000e+01},
    { 31,  5,  2,  4, 0.82444700e+02, 0.19315000e+01, 0.45856000e+01},
    { 31,  5,  3,  0, 0.13488560e+03, 0.29233000e+01, 0.00000000e+00},
    { 31,  5,  3,  1, 0.11367480e+03, 0.29233000e+01, 0.97060000e+00},
    { 31,  5,  3,  2, 0.95603900e+02, 0.29233000e+01, 0.19441000e+01},
    { 31,  5,  3,  3, 0.73075400e+02, 0.29233000e+01, 0.29128000e+01},
    { 31,  5,  3,  4, 0.68793500e+02, 0.29233000e+01, 0.45856000e+01},
    { 31,  6,  0,  0, 0.14655440e+03, 0.00000000e+00, 0.00000000e+00},
    { 31,  6,  0,  1, 0.13747230e+03, 0.00000000e+00, 0.98680000e+00},
    { 31,  6,  0,  2, 0.11027700e+03, 0.00000000e+00, 0.19985000e+01},
    { 31,  6,  0,  3, 0.10307380e+03, 0.00000000e+00, 0.29987000e+01},
    { 31,  6,  0,  4, 0.82324800e+02, 0.00000000e+00, 0.39844000e+01},
    { 31,  6,  1,  0, 0.13814970e+03, 0.96010000e+00, 0.00000000e+00},
    { 31,  6,  1,  1, 0.12956700e+03, 0.96010000e+00, 0.98680000e+00},
    { 31,  6,  1,  2, 0.10418810e+03, 0.96010000e+00, 0.19985000e+01},
    { 31,  6,  1,  3, 0.97383800e+02, 0.96010000e+00, 0.29987000e+01},
    { 31,  6,  1,  4, 0.78050500e+02, 0.96010000e+00, 0.39844000e+01},
    { 31,  6,  2,  0, 0.11083840e+03, 0.19315000e+01, 0.00000000e+00},
    { 31,  6,  2,  1, 0.10391800e+03, 0.19315000e+01, 0.98680000e+00},
    { 31,  6,  2,  2, 0.84269100e+02, 0.19315000e+01, 0.19985000e+01},
    { 31,  6,  2,  3, 0.78781200e+02, 0.19315000e+01, 0.29987000e+01},
    { 31,  6,  2,  4, 0.63911700e+02, 0.19315000e+01, 0.39844000e+01},
    { 31,  6,  3,  0, 0.91766100e+02, 0.29233000e+01, 0.00000000e+00},
    { 31,  6,  3,  1, 0.86017200e+02, 0.29233000e+01, 0.98680000e+00},
    { 31,  6,  3,  2, 0.70318400e+02, 0.29233000e+01, 0.19985000e+01},
    { 31,  6,  3,  3, 0.65758400e+02, 0.29233000e+01, 0.29987000e+01},
    { 31,  6,  3,  4, 0.53961700e+02, 0.29233000e+01, 0.39844000e+01},
    { 31,  7,  0,  0, 0.99440700e+02, 0.00000000e+00, 0.00000000e+00},
    { 31,  7,  0,  1, 0.92602500e+02, 0.00000000e+00, 0.99440000e+00},
    { 31,  7,  0,  2, 0.86619400e+02, 0.00000000e+00, 0.20143000e+01},
    { 31,  7,  0,  3, 0.75880000e+02, 0.00000000e+00, 0.29903000e+01},
    { 31,  7,  1,  0, 0.94132900e+02, 0.96010000e+00, 0.00000000e+00},
    { 31,  7,  1,  1, 0.87664500e+02, 0.96010000e+00, 0.99440000e+00},
    { 31,  7,  1,  2, 0.82040200e+02, 0.96010000e+00, 0.20143000e+01},
    { 31,  7,  1,  3, 0.71907900e+02, 0.96010000e+00, 0.29903000e+01},
    { 31,  7,  2,  0, 0.76664100e+02, 0.19315000e+01, 0.00000000e+00},
    { 31,  7,  2,  1, 0.71423400e+02, 0.19315000e+01, 0.99440000e+00},
    { 31,  7,  2,  2, 0.66955000e+02, 0.19315000e+01, 0.20143000e+01},
    { 31,  7,  2,  3, 0.58812600e+02, 0.19315000e+01, 0.29903000e+01},
    { 31,  7,  3,  0, 0.64397700e+02, 0.29233000e+01, 0.00000000e+00},
    { 31,  7,  3,  1, 0.60022900e+02, 0.29233000e+01, 0.99440000e+00},
    { 31,  7,  3,  2, 0.56361200e+02, 0.29233000e+01, 0.20143000e+01},
    { 31,  7,  3,  3, 0.49615900e+02, 0.29233000e+01, 0.29903000e+01},
    { 31,  8,  0,  0, 0.73625300e+02, 0.00000000e+00, 0.00000000e+00},
    { 31,  8,  0,  1, 0.65621400e+02, 0.00000000e+00, 0.99250000e+00},
    { 31,  8,  0,  2, 0.57401600e+02, 0.00000000e+00, 0.19887000e+01},
    { 31,  8,  1,  0, 0.69903900e+02, 0.96010000e+00, 0.00000000e+00},
    { 31,  8,  1,  1, 0.62352200e+02, 0.96010000e+00, 0.99250000e+00},
    { 31,  8,  1,  2, 0.54596400e+02, 0.96010000e+00, 0.19887000e+01},
    { 31,  8,  2,  0, 0.57542500e+02, 0.19315000e+01, 0.00000000e+00},
    { 31,  8,  2,  1, 0.51470500e+02, 0.19315000e+01, 0.99250000e+00},
    { 31,  8,  2,  2, 0.45233600e+02, 0.19315000e+01, 0.19887000e+01},
    { 31,  8,  3,  0, 0.48831000e+02, 0.29233000e+01, 0.00000000e+00},
    { 31,  8,  3,  1, 0.43796200e+02, 0.29233000e+01, 0.99250000e+00},
    { 31,  8,  3,  2, 0.38626300e+02, 0.29233000e+01, 0.19887000e+01},
    { 31,  9,  0,  0, 0.54678200e+02, 0.00000000e+00, 0.00000000e+00},
    { 31,  9,  0,  1, 0.43568500e+02, 0.00000000e+00, 0.99820000e+00},
    { 31,  9,  1,  0, 0.52047600e+02, 0.96010000e+00, 0.00000000e+00},
    { 31,  9,  1,  1, 0.41590900e+02, 0.96010000e+00, 0.99820000e+00},
    { 31,  9,  2,  0, 0.43238500e+02, 0.19315000e+01, 0.00000000e+00},
    { 31,  9,  2,  1, 0.34900800e+02, 0.19315000e+01, 0.99820000e+00},
    { 31,  9,  3,  0, 0.37012900e+02, 0.29233000e+01, 0.00000000e+00},
    { 31,  9,  3,  1, 0.30155700e+02, 0.29233000e+01, 0.99820000e+00},
    { 31, 10,  0,  0, 0.41368100e+02, 0.00000000e+00, 0.00000000e+00},
    { 31, 10,  1,  0, 0.39458700e+02, 0.96010000e+00, 0.00000000e+00},
    { 31, 10,  2,  0, 0.33022800e+02, 0.19315000e+01, 0.00000000e+00},
    { 31, 10,  3,  0, 0.28465400e+02, 0.29233000e+01, 0.00000000e+00},
    { 31, 11,  0,  0, 0.78135240e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 11,  0,  1, 0.29840070e+03, 0.00000000e+00, 0.96840000e+00},
    { 31, 11,  1,  0, 0.71775310e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 11,  1,  1, 0.27751430e+03, 0.96010000e+00, 0.96840000e+00},
    { 31, 11,  2,  0, 0.52706710e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 11,  2,  1, 0.21236180e+03, 0.19315000e+01, 0.96840000e+00},
    { 31, 11,  3,  0, 0.39801800e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 11,  3,  1, 0.16772780e+03, 0.29233000e+01, 0.96840000e+00},
    { 31, 12,  0,  0, 0.56716380e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 12,  0,  1, 0.46356910e+03, 0.00000000e+00, 0.96280000e+00},
    { 31, 12,  0,  2, 0.28974250e+03, 0.00000000e+00, 0.19496000e+01},
    { 31, 12,  1,  0, 0.52642360e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 12,  1,  1, 0.43082970e+03, 0.96010000e+00, 0.96280000e+00},
    { 31, 12,  1,  2, 0.27124200e+03, 0.96010000e+00, 0.19496000e+01},
    { 31, 12,  2,  0, 0.39992630e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 12,  2,  1, 0.32896970e+03, 0.19315000e+01, 0.96280000e+00},
    { 31, 12,  2,  2, 0.21230440e+03, 0.19315000e+01, 0.19496000e+01},
    { 31, 12,  3,  0, 0.31346580e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 12,  3,  1, 0.25920610e+03, 0.29233000e+01, 0.96280000e+00},
    { 31, 12,  3,  2, 0.17153850e+03, 0.29233000e+01, 0.19496000e+01},
    { 31, 13,  0,  0, 0.51058540e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 13,  0,  1, 0.45995440e+03, 0.00000000e+00, 0.96480000e+00},
    { 31, 13,  0,  2, 0.35111920e+03, 0.00000000e+00, 0.19311000e+01},
    { 31, 13,  0,  3, 0.26645340e+03, 0.00000000e+00, 0.29146000e+01},
    { 31, 13,  1,  0, 0.47573180e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 13,  1,  1, 0.42895210e+03, 0.96010000e+00, 0.96480000e+00},
    { 31, 13,  1,  2, 0.32851000e+03, 0.96010000e+00, 0.19311000e+01},
    { 31, 13,  1,  3, 0.25034940e+03, 0.96010000e+00, 0.29146000e+01},
    { 31, 13,  2,  0, 0.36633710e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 13,  2,  1, 0.33140550e+03, 0.19315000e+01, 0.96480000e+00},
    { 31, 13,  2,  2, 0.25671210e+03, 0.19315000e+01, 0.19311000e+01},
    { 31, 13,  2,  3, 0.19848130e+03, 0.19315000e+01, 0.29146000e+01},
    { 31, 13,  3,  0, 0.29117040e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 13,  3,  1, 0.26429930e+03, 0.29233000e+01, 0.96480000e+00},
    { 31, 13,  3,  2, 0.20708710e+03, 0.29233000e+01, 0.19311000e+01},
    { 31, 13,  3,  3, 0.16240650e+03, 0.29233000e+01, 0.29146000e+01},
    { 31, 14,  0,  0, 0.38926560e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 14,  0,  1, 0.35794110e+03, 0.00000000e+00, 0.95070000e+00},
    { 31, 14,  0,  2, 0.33128490e+03, 0.00000000e+00, 0.19435000e+01},
    { 31, 14,  0,  3, 0.32381790e+03, 0.00000000e+00, 0.29407000e+01},
    { 31, 14,  0,  4, 0.26030910e+03, 0.00000000e+00, 0.38677000e+01},
    { 31, 14,  1,  0, 0.36461100e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 14,  1,  1, 0.33552060e+03, 0.96010000e+00, 0.95070000e+00},
    { 31, 14,  1,  2, 0.31077040e+03, 0.96010000e+00, 0.19435000e+01},
    { 31, 14,  1,  3, 0.30359070e+03, 0.96010000e+00, 0.29407000e+01},
    { 31, 14,  1,  4, 0.24494460e+03, 0.96010000e+00, 0.38677000e+01},
    { 31, 14,  2,  0, 0.28597610e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 14,  2,  1, 0.26387400e+03, 0.19315000e+01, 0.95070000e+00},
    { 31, 14,  2,  2, 0.24505850e+03, 0.19315000e+01, 0.19435000e+01},
    { 31, 14,  2,  3, 0.23896240e+03, 0.19315000e+01, 0.29407000e+01},
    { 31, 14,  2,  4, 0.19524610e+03, 0.19315000e+01, 0.38677000e+01},
    { 31, 14,  3,  0, 0.23154320e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 14,  3,  1, 0.21422700e+03, 0.29233000e+01, 0.95070000e+00},
    { 31, 14,  3,  2, 0.19947600e+03, 0.29233000e+01, 0.19435000e+01},
    { 31, 14,  3,  3, 0.19417780e+03, 0.29233000e+01, 0.29407000e+01},
    { 31, 14,  3,  4, 0.16060910e+03, 0.29233000e+01, 0.38677000e+01},
    { 31, 15,  0,  0, 0.29479250e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 15,  0,  1, 0.28580720e+03, 0.00000000e+00, 0.99470000e+00},
    { 31, 15,  0,  2, 0.28238710e+03, 0.00000000e+00, 0.20102000e+01},
    { 31, 15,  0,  3, 0.25991840e+03, 0.00000000e+00, 0.29859000e+01},
    { 31, 15,  1,  0, 0.27735230e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 15,  1,  1, 0.26893700e+03, 0.96010000e+00, 0.99470000e+00},
    { 31, 15,  1,  2, 0.26564070e+03, 0.96010000e+00, 0.20102000e+01},
    { 31, 15,  1,  3, 0.24479640e+03, 0.96010000e+00, 0.29859000e+01},
    { 31, 15,  2,  0, 0.22097630e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 15,  2,  1, 0.21439030e+03, 0.19315000e+01, 0.99470000e+00},
    { 31, 15,  2,  2, 0.21155710e+03, 0.19315000e+01, 0.20102000e+01},
    { 31, 15,  2,  3, 0.19576670e+03, 0.19315000e+01, 0.29859000e+01},
    { 31, 15,  3,  0, 0.18169810e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 15,  3,  1, 0.17638160e+03, 0.29233000e+01, 0.99470000e+00},
    { 31, 15,  3,  2, 0.17389310e+03, 0.29233000e+01, 0.20102000e+01},
    { 31, 15,  3,  3, 0.16155910e+03, 0.29233000e+01, 0.29859000e+01},
    { 31, 16,  0,  0, 0.23981830e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 16,  0,  1, 0.23725630e+03, 0.00000000e+00, 0.99480000e+00},
    { 31, 16,  0,  2, 0.23234090e+03, 0.00000000e+00, 0.19903000e+01},
    { 31, 16,  1,  0, 0.22627960e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 16,  1,  1, 0.22384530e+03, 0.96010000e+00, 0.99480000e+00},
    { 31, 16,  1,  2, 0.21921940e+03, 0.96010000e+00, 0.19903000e+01},
    { 31, 16,  2,  0, 0.18213800e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 16,  2,  1, 0.18013610e+03, 0.19315000e+01, 0.99480000e+00},
    { 31, 16,  2,  2, 0.17644990e+03, 0.19315000e+01, 0.19903000e+01},
    { 31, 16,  3,  0, 0.15126110e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 16,  3,  1, 0.14956740e+03, 0.29233000e+01, 0.99480000e+00},
    { 31, 16,  3,  2, 0.14653820e+03, 0.29233000e+01, 0.19903000e+01},
    { 31, 17,  0,  0, 0.19205780e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 17,  0,  1, 0.19011390e+03, 0.00000000e+00, 0.99720000e+00},
    { 31, 17,  1,  0, 0.18171780e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 17,  1,  1, 0.17986830e+03, 0.96010000e+00, 0.99720000e+00},
    { 31, 17,  2,  0, 0.14771690e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 17,  2,  1, 0.14618730e+03, 0.19315000e+01, 0.99720000e+00},
    { 31, 17,  3,  0, 0.12384420e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 17,  3,  1, 0.12254290e+03, 0.29233000e+01, 0.99720000e+00},
    { 31, 18,  0,  0, 0.15434230e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 18,  1,  0, 0.14638550e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 18,  2,  0, 0.12002340e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 18,  3,  0, 0.10145720e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 19,  0,  0, 0.12928121e+04, 0.00000000e+00, 0.00000000e+00},
    { 31, 19,  0,  1, 0.40307450e+03, 0.00000000e+00, 0.97670000e+00},
    { 31, 19,  1,  0, 0.11848327e+04, 0.96010000e+00, 0.00000000e+00},
    { 31, 19,  1,  1, 0.37584950e+03, 0.96010000e+00, 0.97670000e+00},
    { 31, 19,  2,  0, 0.86510660e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 19,  2,  1, 0.29057390e+03, 0.19315000e+01, 0.97670000e+00},
    { 31, 19,  3,  0, 0.64868790e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 19,  3,  1, 0.23199890e+03, 0.29233000e+01, 0.97670000e+00},
    { 31, 20,  0,  0, 0.10198835e+04, 0.00000000e+00, 0.00000000e+00},
    { 31, 20,  0,  1, 0.81349430e+03, 0.00000000e+00, 0.98310000e+00},
    { 31, 20,  0,  2, 0.40564880e+03, 0.00000000e+00, 0.19349000e+01},
    { 31, 20,  1,  0, 0.94258280e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 20,  1,  1, 0.75181440e+03, 0.96010000e+00, 0.98310000e+00},
    { 31, 20,  1,  2, 0.37966500e+03, 0.96010000e+00, 0.19349000e+01},
    { 31, 20,  2,  0, 0.70620410e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 20,  2,  1, 0.56411470e+03, 0.19315000e+01, 0.98310000e+00},
    { 31, 20,  2,  2, 0.29710840e+03, 0.19315000e+01, 0.19349000e+01},
    { 31, 20,  3,  0, 0.54545480e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 20,  3,  1, 0.43628440e+03, 0.29233000e+01, 0.98310000e+00},
    { 31, 20,  3,  2, 0.24008000e+03, 0.29233000e+01, 0.19349000e+01},
    { 31, 21,  0,  0, 0.83374240e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 21,  0,  1, 0.39353000e+03, 0.00000000e+00, 0.18627000e+01},
    { 31, 21,  0,  2, 0.38481720e+03, 0.00000000e+00, 0.28999000e+01},
    { 31, 21,  1,  0, 0.77197630e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 21,  1,  1, 0.36854170e+03, 0.96010000e+00, 0.18627000e+01},
    { 31, 21,  1,  2, 0.36091960e+03, 0.96010000e+00, 0.28999000e+01},
    { 31, 21,  2,  0, 0.58191500e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 21,  2,  1, 0.28899240e+03, 0.19315000e+01, 0.18627000e+01},
    { 31, 21,  2,  2, 0.28448700e+03, 0.19315000e+01, 0.28999000e+01},
    { 31, 21,  3,  0, 0.45241480e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 21,  3,  1, 0.23401650e+03, 0.29233000e+01, 0.18627000e+01},
    { 31, 21,  3,  2, 0.23151840e+03, 0.29233000e+01, 0.28999000e+01},
    { 31, 22,  0,  0, 0.79686170e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 22,  0,  1, 0.37941090e+03, 0.00000000e+00, 0.18299000e+01},
    { 31, 22,  0,  2, 0.38913250e+03, 0.00000000e+00, 0.38675000e+01},
    { 31, 22,  1,  0, 0.73902810e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 22,  1,  1, 0.35534980e+03, 0.96010000e+00, 0.18299000e+01},
    { 31, 22,  1,  2, 0.36502390e+03, 0.96010000e+00, 0.38675000e+01},
    { 31, 22,  2,  0, 0.56029450e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 22,  2,  1, 0.27882930e+03, 0.19315000e+01, 0.18299000e+01},
    { 31, 22,  2,  2, 0.28787970e+03, 0.19315000e+01, 0.38675000e+01},
    { 31, 22,  3,  0, 0.43828120e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 22,  3,  1, 0.22591360e+03, 0.29233000e+01, 0.18299000e+01},
    { 31, 22,  3,  2, 0.23440930e+03, 0.29233000e+01, 0.38675000e+01},
    { 31, 23,  0,  0, 0.72525140e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 23,  0,  1, 0.37194270e+03, 0.00000000e+00, 0.19138000e+01},
    { 31, 23,  0,  2, 0.35624690e+03, 0.00000000e+00, 0.29110000e+01},
    { 31, 23,  1,  0, 0.67328230e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 23,  1,  1, 0.34832930e+03, 0.96010000e+00, 0.19138000e+01},
    { 31, 23,  1,  2, 0.33410780e+03, 0.96010000e+00, 0.29110000e+01},
    { 31, 23,  2,  0, 0.51220750e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 23,  2,  1, 0.27324400e+03, 0.19315000e+01, 0.19138000e+01},
    { 31, 23,  2,  2, 0.26338000e+03, 0.19315000e+01, 0.29110000e+01},
    { 31, 23,  3,  0, 0.40212020e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 23,  3,  1, 0.22133820e+03, 0.29233000e+01, 0.19138000e+01},
    { 31, 23,  3,  2, 0.21438080e+03, 0.29233000e+01, 0.29110000e+01},
    { 31, 24,  0,  0, 0.56976450e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 24,  0,  1, 0.36963020e+03, 0.00000000e+00, 0.18269000e+01},
    { 31, 24,  0,  2, 0.26215300e+03, 0.00000000e+00, 0.10619100e+02},
    { 31, 24,  1,  0, 0.52900060e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 24,  1,  1, 0.34597960e+03, 0.96010000e+00, 0.18269000e+01},
    { 31, 24,  1,  2, 0.24667960e+03, 0.96010000e+00, 0.10619100e+02},
    { 31, 24,  2,  0, 0.40283090e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 24,  2,  1, 0.27091680e+03, 0.19315000e+01, 0.18269000e+01},
    { 31, 24,  2,  2, 0.19677040e+03, 0.19315000e+01, 0.10619100e+02},
    { 31, 24,  3,  0, 0.31661340e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 24,  3,  1, 0.21907040e+03, 0.29233000e+01, 0.18269000e+01},
    { 31, 24,  3,  2, 0.16205470e+03, 0.29233000e+01, 0.10619100e+02},
    { 31, 25,  0,  0, 0.61883870e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 25,  0,  1, 0.33506150e+03, 0.00000000e+00, 0.16406000e+01},
    { 31, 25,  0,  2, 0.22112170e+03, 0.00000000e+00, 0.98849000e+01},
    { 31, 25,  1,  0, 0.57532290e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 25,  1,  1, 0.31442440e+03, 0.96010000e+00, 0.16406000e+01},
    { 31, 25,  1,  2, 0.20851100e+03, 0.96010000e+00, 0.98849000e+01},
    { 31, 25,  2,  0, 0.43988290e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 25,  2,  1, 0.24831530e+03, 0.19315000e+01, 0.16406000e+01},
    { 31, 25,  2,  2, 0.16756290e+03, 0.19315000e+01, 0.98849000e+01},
    { 31, 25,  3,  0, 0.34715450e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 25,  3,  1, 0.20247400e+03, 0.29233000e+01, 0.16406000e+01},
    { 31, 25,  3,  2, 0.13899280e+03, 0.29233000e+01, 0.98849000e+01},
    { 31, 26,  0,  0, 0.48378150e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 26,  0,  1, 0.30855290e+03, 0.00000000e+00, 0.16483000e+01},
    { 31, 26,  0,  2, 0.21740400e+03, 0.00000000e+00, 0.91376000e+01},
    { 31, 26,  1,  0, 0.44990400e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 26,  1,  1, 0.28975880e+03, 0.96010000e+00, 0.16483000e+01},
    { 31, 26,  1,  2, 0.20495230e+03, 0.96010000e+00, 0.91376000e+01},
    { 31, 26,  2,  0, 0.34453520e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 26,  2,  1, 0.22943180e+03, 0.19315000e+01, 0.16483000e+01},
    { 31, 26,  2,  2, 0.16455530e+03, 0.19315000e+01, 0.91376000e+01},
    { 31, 26,  3,  0, 0.27239980e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 26,  3,  1, 0.18755800e+03, 0.29233000e+01, 0.16483000e+01},
    { 31, 26,  3,  2, 0.13638180e+03, 0.29233000e+01, 0.91376000e+01},
    { 31, 27,  0,  0, 0.50713160e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 27,  0,  1, 0.29424080e+03, 0.00000000e+00, 0.17149000e+01},
    { 31, 27,  0,  2, 0.26075480e+03, 0.00000000e+00, 0.29263000e+01},
    { 31, 27,  0,  3, 0.22867850e+03, 0.00000000e+00, 0.77785000e+01},
    { 31, 27,  1,  0, 0.47264010e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 27,  1,  1, 0.27631300e+03, 0.96010000e+00, 0.17149000e+01},
    { 31, 27,  1,  2, 0.24499140e+03, 0.96010000e+00, 0.29263000e+01},
    { 31, 27,  1,  3, 0.21533740e+03, 0.96010000e+00, 0.77785000e+01},
    { 31, 27,  2,  0, 0.36443400e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 27,  2,  1, 0.21879640e+03, 0.19315000e+01, 0.17149000e+01},
    { 31, 27,  2,  2, 0.19438680e+03, 0.19315000e+01, 0.29263000e+01},
    { 31, 27,  2,  3, 0.17220040e+03, 0.19315000e+01, 0.77785000e+01},
    { 31, 27,  3,  0, 0.29012680e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 27,  3,  1, 0.17887740e+03, 0.29233000e+01, 0.17149000e+01},
    { 31, 27,  3,  2, 0.15925840e+03, 0.29233000e+01, 0.29263000e+01},
    { 31, 27,  3,  3, 0.14216340e+03, 0.29233000e+01, 0.77785000e+01},
    { 31, 28,  0,  0, 0.52581620e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 28,  0,  1, 0.28800730e+03, 0.00000000e+00, 0.17937000e+01},
    { 31, 28,  0,  2, 0.24136360e+03, 0.00000000e+00, 0.65458000e+01},
    { 31, 28,  0,  3, 0.25679600e+03, 0.00000000e+00, 0.62918000e+01},
    { 31, 28,  1,  0, 0.48954990e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 28,  1,  1, 0.27040230e+03, 0.96010000e+00, 0.17937000e+01},
    { 31, 28,  1,  2, 0.22700010e+03, 0.96010000e+00, 0.65458000e+01},
    { 31, 28,  1,  3, 0.24100160e+03, 0.96010000e+00, 0.62918000e+01},
    { 31, 28,  2,  0, 0.37611120e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 28,  2,  1, 0.21396210e+03, 0.19315000e+01, 0.17937000e+01},
    { 31, 28,  2,  2, 0.18072890e+03, 0.19315000e+01, 0.65458000e+01},
    { 31, 28,  2,  3, 0.19047990e+03, 0.19315000e+01, 0.62918000e+01},
    { 31, 28,  3,  0, 0.29831410e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 28,  3,  1, 0.17480580e+03, 0.29233000e+01, 0.17937000e+01},
    { 31, 28,  3,  2, 0.14856420e+03, 0.29233000e+01, 0.65458000e+01},
    { 31, 28,  3,  3, 0.15548130e+03, 0.29233000e+01, 0.62918000e+01},
    { 31, 29,  0,  0, 0.40196130e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 29,  0,  1, 0.28785200e+03, 0.00000000e+00, 0.95760000e+00},
    { 31, 29,  1,  0, 0.37425370e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 29,  1,  1, 0.26973440e+03, 0.96010000e+00, 0.95760000e+00},
    { 31, 29,  2,  0, 0.28776680e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 29,  2,  1, 0.21202750e+03, 0.19315000e+01, 0.95760000e+00},
    { 31, 29,  3,  0, 0.22848110e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 29,  3,  1, 0.17212150e+03, 0.29233000e+01, 0.95760000e+00},
    { 31, 30,  0,  0, 0.40545650e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 30,  0,  1, 0.26447240e+03, 0.00000000e+00, 0.19419000e+01},
    { 31, 30,  1,  0, 0.37873290e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 30,  1,  1, 0.24870030e+03, 0.96010000e+00, 0.19419000e+01},
    { 31, 30,  2,  0, 0.29431290e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 30,  2,  1, 0.19784590e+03, 0.19315000e+01, 0.19419000e+01},
    { 31, 30,  3,  0, 0.23616610e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 30,  3,  1, 0.16247350e+03, 0.29233000e+01, 0.19419000e+01},
    { 31, 31,  0,  0, 0.48375160e+03, 0.00000000e+00, 0.00000000e+00},
    { 31, 31,  1,  0, 0.45140030e+03, 0.96010000e+00, 0.00000000e+00},
    { 31, 31,  1,  1, 0.42164970e+03, 0.96010000e+00, 0.96010000e+00},
    { 31, 31,  2,  0, 0.34953890e+03, 0.19315000e+01, 0.00000000e+00},
    { 31, 31,  2,  1, 0.32767720e+03, 0.19315000e+01, 0.96010000e+00},
    { 31, 31,  2,  2, 0.25787270e+03, 0.19315000e+01, 0.19315000e+01},
    { 31, 31,  3,  0, 0.27943460e+03, 0.29233000e+01, 0.00000000e+00},
    { 31, 31,  3,  1, 0.26291340e+03, 0.29233000e+01, 0.96010000e+00},
    { 31, 31,  3,  2, 0.20951300e+03, 0.29233000e+01, 0.19315000e+01},
    { 31, 31,  3,  3, 0.17231530e+03, 0.29233000e+01, 0.29233000e+01},
    { 32,  1,  0,  0, 0.31817000e+02, 0.00000000e+00, 0.91180000e+00},
    { 32,  1,  0,  1, 0.51990500e+02, 0.00000000e+00, 0.00000000e+00},
    { 32,  1,  1,  0, 0.29952700e+02, 0.94340000e+00, 0.91180000e+00},
    { 32,  1,  1,  1, 0.48724700e+02, 0.94340000e+00, 0.00000000e+00},
    { 32,  1,  2,  0, 0.28635900e+02, 0.19447000e+01, 0.91180000e+00},
    { 32,  1,  2,  1, 0.46440900e+02, 0.19447000e+01, 0.00000000e+00},
    { 32,  1,  3,  0, 0.25925500e+02, 0.29186000e+01, 0.91180000e+00},
    { 32,  1,  3,  1, 0.41732300e+02, 0.29186000e+01, 0.00000000e+00},
    { 32,  1,  4,  0, 0.23178400e+02, 0.38972000e+01, 0.91180000e+00},
    { 32,  1,  4,  1, 0.36966400e+02, 0.38972000e+01, 0.00000000e+00},
    { 32,  2,  0,  0, 0.20431800e+02, 0.00000000e+00, 0.00000000e+00},
    { 32,  2,  1,  0, 0.19376100e+02, 0.94340000e+00, 0.00000000e+00},
    { 32,  2,  2,  0, 0.18618600e+02, 0.19447000e+01, 0.00000000e+00},
    { 32,  2,  3,  0, 0.17061400e+02, 0.29186000e+01, 0.00000000e+00},
    { 32,  2,  4,  0, 0.15480100e+02, 0.38972000e+01, 0.00000000e+00},
    { 32,  3,  0,  0, 0.52792680e+03, 0.00000000e+00, 0.00000000e+00},
    { 32,  3,  0,  1, 0.17294250e+03, 0.00000000e+00, 0.98650000e+00},
    { 32,  3,  1,  0, 0.48401650e+03, 0.94340000e+00, 0.00000000e+00},
    { 32,  3,  1,  1, 0.16045020e+03, 0.94340000e+00, 0.98650000e+00},
    { 32,  3,  2,  0, 0.45411250e+03, 0.19447000e+01, 0.00000000e+00},
    { 32,  3,  2,  1, 0.15187590e+03, 0.19447000e+01, 0.98650000e+00},
    { 32,  3,  3,  0, 0.39241090e+03, 0.29186000e+01, 0.00000000e+00},
    { 32,  3,  3,  1, 0.13414080e+03, 0.29186000e+01, 0.98650000e+00},
    { 32,  3,  4,  0, 0.33056660e+03, 0.38972000e+01, 0.00000000e+00},
    { 32,  3,  4,  1, 0.11625770e+03, 0.38972000e+01, 0.98650000e+00},
    { 32,  4,  0,  0, 0.29842200e+03, 0.00000000e+00, 0.00000000e+00},
    { 32,  4,  0,  1, 0.21973750e+03, 0.00000000e+00, 0.98080000e+00},
    { 32,  4,  0,  2, 0.14114890e+03, 0.00000000e+00, 0.19697000e+01},
    { 32,  4,  1,  0, 0.27657170e+03, 0.94340000e+00, 0.00000000e+00},
    { 32,  4,  1,  1, 0.20416900e+03, 0.94340000e+00, 0.98080000e+00},
    { 32,  4,  1,  2, 0.13199340e+03, 0.94340000e+00, 0.19697000e+01},
    { 32,  4,  2,  0, 0.26160340e+03, 0.19447000e+01, 0.00000000e+00},
    { 32,  4,  2,  1, 0.19344570e+03, 0.19447000e+01, 0.98080000e+00},
    { 32,  4,  2,  2, 0.12562090e+03, 0.19447000e+01, 0.19697000e+01},
    { 32,  4,  3,  0, 0.23062870e+03, 0.29186000e+01, 0.00000000e+00},
    { 32,  4,  3,  1, 0.17128910e+03, 0.29186000e+01, 0.98080000e+00},
    { 32,  4,  3,  2, 0.11247080e+03, 0.29186000e+01, 0.19697000e+01},
    { 32,  4,  4,  0, 0.19940340e+03, 0.38972000e+01, 0.00000000e+00},
    { 32,  4,  4,  1, 0.14894110e+03, 0.38972000e+01, 0.98080000e+00},
    { 32,  4,  4,  2, 0.99170000e+02, 0.38972000e+01, 0.19697000e+01},
    { 32,  5,  0,  0, 0.19734480e+03, 0.00000000e+00, 0.00000000e+00},
    { 32,  5,  0,  1, 0.16519300e+03, 0.00000000e+00, 0.97060000e+00},
    { 32,  5,  0,  2, 0.13799560e+03, 0.00000000e+00, 0.19441000e+01},
    { 32,  5,  0,  3, 0.10369470e+03, 0.00000000e+00, 0.29128000e+01},
    { 32,  5,  0,  4, 0.97349000e+02, 0.00000000e+00, 0.45856000e+01},
    { 32,  5,  1,  0, 0.18420550e+03, 0.94340000e+00, 0.00000000e+00},
    { 32,  5,  1,  1, 0.15444090e+03, 0.94340000e+00, 0.97060000e+00},
    { 32,  5,  1,  2, 0.12922270e+03, 0.94340000e+00, 0.19441000e+01},
    { 32,  5,  1,  3, 0.97495300e+02, 0.94340000e+00, 0.29128000e+01},
    { 32,  5,  1,  4, 0.91589500e+02, 0.94340000e+00, 0.45856000e+01},
    { 32,  5,  2,  0, 0.17509380e+03, 0.19447000e+01, 0.00000000e+00},
    { 32,  5,  2,  1, 0.14696060e+03, 0.19447000e+01, 0.97060000e+00},
    { 32,  5,  2,  2, 0.12309690e+03, 0.19447000e+01, 0.19441000e+01},
    { 32,  5,  2,  3, 0.93130100e+02, 0.19447000e+01, 0.29128000e+01},
    { 32,  5,  2,  4, 0.87528200e+02, 0.19447000e+01, 0.45856000e+01},
    { 32,  5,  3,  0, 0.15627830e+03, 0.29186000e+01, 0.00000000e+00},
    { 32,  5,  3,  1, 0.13152340e+03, 0.29186000e+01, 0.97060000e+00},
    { 32,  5,  3,  2, 0.11046530e+03, 0.29186000e+01, 0.19441000e+01},
    { 32,  5,  3,  3, 0.84139800e+02, 0.29186000e+01, 0.29128000e+01},
    { 32,  5,  3,  4, 0.79165600e+02, 0.29186000e+01, 0.45856000e+01},
    { 32,  5,  4,  0, 0.13726170e+03, 0.38972000e+01, 0.00000000e+00},
    { 32,  5,  4,  1, 0.11591450e+03, 0.38972000e+01, 0.97060000e+00},
    { 32,  5,  4,  2, 0.97688000e+02, 0.38972000e+01, 0.19441000e+01},
    { 32,  5,  4,  3, 0.75031600e+02, 0.38972000e+01, 0.29128000e+01},
    { 32,  5,  4,  4, 0.70691700e+02, 0.38972000e+01, 0.45856000e+01},
    { 32,  6,  0,  0, 0.13109540e+03, 0.00000000e+00, 0.00000000e+00},
    { 32,  6,  0,  1, 0.12288050e+03, 0.00000000e+00, 0.98680000e+00},
    { 32,  6,  0,  2, 0.99469800e+02, 0.00000000e+00, 0.19985000e+01},
    { 32,  6,  0,  3, 0.92962100e+02, 0.00000000e+00, 0.29987000e+01},
    { 32,  6,  0,  4, 0.75207600e+02, 0.00000000e+00, 0.39844000e+01},
    { 32,  6,  1,  0, 0.12305740e+03, 0.94340000e+00, 0.00000000e+00},
    { 32,  6,  1,  1, 0.11534880e+03, 0.94340000e+00, 0.98680000e+00},
    { 32,  6,  1,  2, 0.93589300e+02, 0.94340000e+00, 0.19985000e+01},
    { 32,  6,  1,  3, 0.87478100e+02, 0.94340000e+00, 0.29987000e+01},
    { 32,  6,  1,  4, 0.71014300e+02, 0.94340000e+00, 0.39844000e+01},
    { 32,  6,  2,  0, 0.11741980e+03, 0.19447000e+01, 0.00000000e+00},
    { 32,  6,  2,  1, 0.11006510e+03, 0.19447000e+01, 0.98680000e+00},
    { 32,  6,  2,  2, 0.89444800e+02, 0.19447000e+01, 0.19985000e+01},
    { 32,  6,  2,  3, 0.83613100e+02, 0.19447000e+01, 0.29987000e+01},
    { 32,  6,  2,  4, 0.68034300e+02, 0.19447000e+01, 0.39844000e+01},
    { 32,  6,  3,  0, 0.10580040e+03, 0.29186000e+01, 0.00000000e+00},
    { 32,  6,  3,  1, 0.99176300e+02, 0.29186000e+01, 0.98680000e+00},
    { 32,  6,  3,  2, 0.80908400e+02, 0.29186000e+01, 0.19985000e+01},
    { 32,  6,  3,  3, 0.75651400e+02, 0.29186000e+01, 0.29987000e+01},
    { 32,  6,  3,  4, 0.61903800e+02, 0.29186000e+01, 0.39844000e+01},
    { 32,  6,  4,  0, 0.94035700e+02, 0.38972000e+01, 0.00000000e+00},
    { 32,  6,  4,  1, 0.88153200e+02, 0.38972000e+01, 0.98680000e+00},
    { 32,  6,  4,  2, 0.72259500e+02, 0.38972000e+01, 0.19985000e+01},
    { 32,  6,  4,  3, 0.67585400e+02, 0.38972000e+01, 0.29987000e+01},
    { 32,  6,  4,  4, 0.55685700e+02, 0.38972000e+01, 0.39844000e+01},
    { 32,  7,  0,  0, 0.90332800e+02, 0.00000000e+00, 0.00000000e+00},
    { 32,  7,  0,  1, 0.84127600e+02, 0.00000000e+00, 0.99440000e+00},
    { 32,  7,  0,  2, 0.78823500e+02, 0.00000000e+00, 0.20143000e+01},
    { 32,  7,  0,  3, 0.69171000e+02, 0.00000000e+00, 0.29903000e+01},
    { 32,  7,  1,  0, 0.85162100e+02, 0.94340000e+00, 0.00000000e+00},
    { 32,  7,  1,  1, 0.79327800e+02, 0.94340000e+00, 0.99440000e+00},
    { 32,  7,  1,  2, 0.74362700e+02, 0.94340000e+00, 0.20143000e+01},
    { 32,  7,  1,  3, 0.65304100e+02, 0.94340000e+00, 0.29903000e+01},
    { 32,  7,  2,  0, 0.81501900e+02, 0.19447000e+01, 0.00000000e+00},
    { 32,  7,  2,  1, 0.75928700e+02, 0.19447000e+01, 0.99440000e+00},
    { 32,  7,  2,  2, 0.71201700e+02, 0.19447000e+01, 0.20143000e+01},
    { 32,  7,  2,  3, 0.62560900e+02, 0.19447000e+01, 0.29903000e+01},
    { 32,  7,  3,  0, 0.73967500e+02, 0.29186000e+01, 0.00000000e+00},
    { 32,  7,  3,  1, 0.68932300e+02, 0.29186000e+01, 0.99440000e+00},
    { 32,  7,  3,  2, 0.64694600e+02, 0.29186000e+01, 0.20143000e+01},
    { 32,  7,  3,  3, 0.56913400e+02, 0.29186000e+01, 0.29903000e+01},
    { 32,  7,  4,  0, 0.66329300e+02, 0.38972000e+01, 0.00000000e+00},
    { 32,  7,  4,  1, 0.61839900e+02, 0.38972000e+01, 0.99440000e+00},
    { 32,  7,  4,  2, 0.58097400e+02, 0.38972000e+01, 0.20143000e+01},
    { 32,  7,  4,  3, 0.51187400e+02, 0.38972000e+01, 0.29903000e+01},
    { 32,  8,  0,  0, 0.67593200e+02, 0.00000000e+00, 0.00000000e+00},
    { 32,  8,  0,  1, 0.60404100e+02, 0.00000000e+00, 0.99250000e+00},
    { 32,  8,  0,  2, 0.53011000e+02, 0.00000000e+00, 0.19887000e+01},
    { 32,  8,  1,  0, 0.63924500e+02, 0.94340000e+00, 0.00000000e+00},
    { 32,  8,  1,  1, 0.57175200e+02, 0.94340000e+00, 0.99250000e+00},
    { 32,  8,  1,  2, 0.50234300e+02, 0.94340000e+00, 0.19887000e+01},
    { 32,  8,  2,  0, 0.61309900e+02, 0.19447000e+01, 0.00000000e+00},
    { 32,  8,  2,  1, 0.54869300e+02, 0.19447000e+01, 0.99250000e+00},
    { 32,  8,  2,  2, 0.48247600e+02, 0.19447000e+01, 0.19887000e+01},
    { 32,  8,  3,  0, 0.55931400e+02, 0.29186000e+01, 0.00000000e+00},
    { 32,  8,  3,  1, 0.50126900e+02, 0.29186000e+01, 0.99250000e+00},
    { 32,  8,  3,  2, 0.44161100e+02, 0.29186000e+01, 0.19887000e+01},
    { 32,  8,  4,  0, 0.50474100e+02, 0.38972000e+01, 0.00000000e+00},
    { 32,  8,  4,  1, 0.45314100e+02, 0.38972000e+01, 0.99250000e+00},
    { 32,  8,  4,  2, 0.40013200e+02, 0.38972000e+01, 0.19887000e+01},
    { 32,  9,  0,  0, 0.50641200e+02, 0.00000000e+00, 0.00000000e+00},
    { 32,  9,  0,  1, 0.40750000e+02, 0.00000000e+00, 0.99820000e+00},
    { 32,  9,  1,  0, 0.48023300e+02, 0.94340000e+00, 0.00000000e+00},
    { 32,  9,  1,  1, 0.38758300e+02, 0.94340000e+00, 0.99820000e+00},
    { 32,  9,  2,  0, 0.46146800e+02, 0.19447000e+01, 0.00000000e+00},
    { 32,  9,  2,  1, 0.37320200e+02, 0.19447000e+01, 0.99820000e+00},
    { 32,  9,  3,  0, 0.42287900e+02, 0.29186000e+01, 0.00000000e+00},
    { 32,  9,  3,  1, 0.34364200e+02, 0.29186000e+01, 0.99820000e+00},
    { 32,  9,  4,  0, 0.38369700e+02, 0.38972000e+01, 0.00000000e+00},
    { 32,  9,  4,  1, 0.31360300e+02, 0.38972000e+01, 0.99820000e+00},
    { 32, 10,  0,  0, 0.38574600e+02, 0.00000000e+00, 0.00000000e+00},
    { 32, 10,  1,  0, 0.36661500e+02, 0.94340000e+00, 0.00000000e+00},
    { 32, 10,  2,  0, 0.35284200e+02, 0.19447000e+01, 0.00000000e+00},
    { 32, 10,  3,  0, 0.32451500e+02, 0.29186000e+01, 0.00000000e+00},
    { 32, 10,  4,  0, 0.29574000e+02, 0.38972000e+01, 0.00000000e+00},
    { 32, 11,  0,  0, 0.63010410e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 11,  0,  1, 0.25314330e+03, 0.00000000e+00, 0.96840000e+00},
    { 32, 11,  1,  0, 0.57808820e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 11,  1,  1, 0.23460480e+03, 0.94340000e+00, 0.96840000e+00},
    { 32, 11,  2,  0, 0.54266570e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 11,  2,  1, 0.22190310e+03, 0.19447000e+01, 0.96840000e+00},
    { 32, 11,  3,  0, 0.46954960e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 11,  3,  1, 0.19562310e+03, 0.29186000e+01, 0.96840000e+00},
    { 32, 11,  4,  0, 0.39624310e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 11,  4,  1, 0.16914050e+03, 0.38972000e+01, 0.96840000e+00},
    { 32, 12,  0,  0, 0.47737440e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 12,  0,  1, 0.39225330e+03, 0.00000000e+00, 0.96280000e+00},
    { 32, 12,  0,  2, 0.25239640e+03, 0.00000000e+00, 0.19496000e+01},
    { 32, 12,  1,  0, 0.44152390e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 12,  1,  1, 0.36333200e+03, 0.94340000e+00, 0.96280000e+00},
    { 32, 12,  1,  2, 0.23526700e+03, 0.94340000e+00, 0.19496000e+01},
    { 32, 12,  2,  0, 0.41703070e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 12,  2,  1, 0.34351060e+03, 0.19447000e+01, 0.96280000e+00},
    { 32, 12,  2,  2, 0.22342490e+03, 0.19447000e+01, 0.19496000e+01},
    { 32, 12,  3,  0, 0.36633190e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 12,  3,  1, 0.30252130e+03, 0.29186000e+01, 0.96280000e+00},
    { 32, 12,  3,  2, 0.19895420e+03, 0.29186000e+01, 0.19496000e+01},
    { 32, 12,  4,  0, 0.31527200e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 12,  4,  1, 0.26122720e+03, 0.38972000e+01, 0.96280000e+00},
    { 32, 12,  4,  2, 0.17423120e+03, 0.38972000e+01, 0.19496000e+01},
    { 32, 13,  0,  0, 0.43650600e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 13,  0,  1, 0.39466500e+03, 0.00000000e+00, 0.96480000e+00},
    { 32, 13,  0,  2, 0.30516430e+03, 0.00000000e+00, 0.19311000e+01},
    { 32, 13,  0,  3, 0.23543820e+03, 0.00000000e+00, 0.29146000e+01},
    { 32, 13,  1,  0, 0.40516110e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 13,  1,  1, 0.36665610e+03, 0.94340000e+00, 0.96480000e+00},
    { 32, 13,  1,  2, 0.28437390e+03, 0.94340000e+00, 0.19311000e+01},
    { 32, 13,  1,  3, 0.22023170e+03, 0.94340000e+00, 0.29146000e+01},
    { 32, 13,  2,  0, 0.38363050e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 13,  2,  1, 0.34738790e+03, 0.19447000e+01, 0.96480000e+00},
    { 32, 13,  2,  2, 0.26999430e+03, 0.19447000e+01, 0.19311000e+01},
    { 32, 13,  2,  3, 0.20964300e+03, 0.19447000e+01, 0.29146000e+01},
    { 32, 13,  3,  0, 0.33910340e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 13,  3,  1, 0.30755040e+03, 0.29186000e+01, 0.96480000e+00},
    { 32, 13,  3,  2, 0.24029350e+03, 0.29186000e+01, 0.19311000e+01},
    { 32, 13,  3,  3, 0.18779330e+03, 0.29186000e+01, 0.29146000e+01},
    { 32, 13,  4,  0, 0.29419700e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 13,  4,  1, 0.26736160e+03, 0.38972000e+01, 0.96480000e+00},
    { 32, 13,  4,  2, 0.21029720e+03, 0.38972000e+01, 0.19311000e+01},
    { 32, 13,  4,  3, 0.16569080e+03, 0.38972000e+01, 0.29146000e+01},
    { 32, 14,  0,  0, 0.33983280e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 14,  0,  1, 0.31339110e+03, 0.00000000e+00, 0.95070000e+00},
    { 32, 14,  0,  2, 0.29090920e+03, 0.00000000e+00, 0.19435000e+01},
    { 32, 14,  0,  3, 0.28369090e+03, 0.00000000e+00, 0.29407000e+01},
    { 32, 14,  0,  4, 0.23133020e+03, 0.00000000e+00, 0.38677000e+01},
    { 32, 14,  1,  0, 0.31697000e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 14,  1,  1, 0.29253350e+03, 0.94340000e+00, 0.95070000e+00},
    { 32, 14,  1,  2, 0.27174380e+03, 0.94340000e+00, 0.19435000e+01},
    { 32, 14,  1,  3, 0.26489450e+03, 0.94340000e+00, 0.29407000e+01},
    { 32, 14,  1,  4, 0.21672460e+03, 0.94340000e+00, 0.38677000e+01},
    { 32, 14,  2,  0, 0.30113800e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 14,  2,  1, 0.27806710e+03, 0.19447000e+01, 0.95070000e+00},
    { 32, 14,  2,  2, 0.25843380e+03, 0.19447000e+01, 0.19435000e+01},
    { 32, 14,  2,  3, 0.25184820e+03, 0.19447000e+01, 0.29407000e+01},
    { 32, 14,  2,  4, 0.20652060e+03, 0.19447000e+01, 0.38677000e+01},
    { 32, 14,  3,  0, 0.26843700e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 14,  3,  1, 0.24819650e+03, 0.29186000e+01, 0.95070000e+00},
    { 32, 14,  3,  2, 0.23095630e+03, 0.29186000e+01, 0.19435000e+01},
    { 32, 14,  3,  3, 0.22491460e+03, 0.29186000e+01, 0.29407000e+01},
    { 32, 14,  3,  4, 0.18547740e+03, 0.29186000e+01, 0.38677000e+01},
    { 32, 14,  4,  0, 0.23539440e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 14,  4,  1, 0.21800740e+03, 0.38972000e+01, 0.95070000e+00},
    { 32, 14,  4,  2, 0.20317830e+03, 0.38972000e+01, 0.19435000e+01},
    { 32, 14,  4,  3, 0.19769460e+03, 0.38972000e+01, 0.29407000e+01},
    { 32, 14,  4,  4, 0.16418110e+03, 0.38972000e+01, 0.38677000e+01},
    { 32, 15,  0,  0, 0.26182350e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 15,  0,  1, 0.25397440e+03, 0.00000000e+00, 0.99470000e+00},
    { 32, 15,  0,  2, 0.25064010e+03, 0.00000000e+00, 0.20102000e+01},
    { 32, 15,  0,  3, 0.23175640e+03, 0.00000000e+00, 0.29859000e+01},
    { 32, 15,  1,  0, 0.24526830e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 15,  1,  1, 0.23795800e+03, 0.94340000e+00, 0.99470000e+00},
    { 32, 15,  1,  2, 0.23477850e+03, 0.94340000e+00, 0.20102000e+01},
    { 32, 15,  1,  3, 0.21733500e+03, 0.94340000e+00, 0.29859000e+01},
    { 32, 15,  2,  0, 0.23370440e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 15,  2,  1, 0.22676600e+03, 0.19447000e+01, 0.99470000e+00},
    { 32, 15,  2,  2, 0.22370080e+03, 0.19447000e+01, 0.20102000e+01},
    { 32, 15,  2,  3, 0.20723900e+03, 0.19447000e+01, 0.29859000e+01},
    { 32, 15,  3,  0, 0.20985610e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 15,  3,  1, 0.20368650e+03, 0.29186000e+01, 0.99470000e+00},
    { 32, 15,  3,  2, 0.20085430e+03, 0.29186000e+01, 0.20102000e+01},
    { 32, 15,  3,  3, 0.18642580e+03, 0.29186000e+01, 0.29859000e+01},
    { 32, 15,  4,  0, 0.18572260e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 15,  4,  1, 0.18033050e+03, 0.38972000e+01, 0.99470000e+00},
    { 32, 15,  4,  2, 0.17773730e+03, 0.38972000e+01, 0.20102000e+01},
    { 32, 15,  4,  3, 0.16535710e+03, 0.38972000e+01, 0.29859000e+01},
    { 32, 16,  0,  0, 0.21531010e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 16,  0,  1, 0.21294370e+03, 0.00000000e+00, 0.99480000e+00},
    { 32, 16,  0,  2, 0.20856850e+03, 0.00000000e+00, 0.19903000e+01},
    { 32, 16,  1,  0, 0.20228630e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 16,  1,  1, 0.20005260e+03, 0.94340000e+00, 0.99480000e+00},
    { 32, 16,  1,  2, 0.19595580e+03, 0.94340000e+00, 0.19903000e+01},
    { 32, 16,  2,  0, 0.19313150e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 16,  2,  1, 0.19099270e+03, 0.19447000e+01, 0.99480000e+00},
    { 32, 16,  2,  2, 0.18709060e+03, 0.19447000e+01, 0.19903000e+01},
    { 32, 16,  3,  0, 0.17427160e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 16,  3,  1, 0.17232720e+03, 0.29186000e+01, 0.99480000e+00},
    { 32, 16,  3,  2, 0.16882630e+03, 0.29186000e+01, 0.19903000e+01},
    { 32, 16,  4,  0, 0.15516910e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 16,  4,  1, 0.15342250e+03, 0.38972000e+01, 0.99480000e+00},
    { 32, 16,  4,  2, 0.15032780e+03, 0.38972000e+01, 0.19903000e+01},
    { 32, 17,  0,  0, 0.17419690e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 17,  0,  1, 0.17239330e+03, 0.00000000e+00, 0.99720000e+00},
    { 32, 17,  1,  0, 0.16412660e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 17,  1,  1, 0.16242060e+03, 0.94340000e+00, 0.99720000e+00},
    { 32, 17,  2,  0, 0.15700310e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 17,  2,  1, 0.15536720e+03, 0.19447000e+01, 0.99720000e+00},
    { 32, 17,  3,  0, 0.14234130e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 17,  3,  1, 0.14084920e+03, 0.29186000e+01, 0.99720000e+00},
    { 32, 17,  4,  0, 0.12747850e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 17,  4,  1, 0.12613260e+03, 0.38972000e+01, 0.99720000e+00},
    { 32, 18,  0,  0, 0.14120630e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 18,  1,  0, 0.13337940e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 18,  2,  0, 0.12781130e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 18,  3,  0, 0.11635890e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 18,  4,  0, 0.10474120e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 19,  0,  0, 0.10326651e+04, 0.00000000e+00, 0.00000000e+00},
    { 32, 19,  0,  1, 0.34544340e+03, 0.00000000e+00, 0.97670000e+00},
    { 32, 19,  1,  0, 0.94657560e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 19,  1,  1, 0.32115740e+03, 0.94340000e+00, 0.97670000e+00},
    { 32, 19,  2,  0, 0.88770750e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 19,  2,  1, 0.30442220e+03, 0.19447000e+01, 0.97670000e+00},
    { 32, 19,  3,  0, 0.76657140e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 19,  3,  1, 0.26984030e+03, 0.29186000e+01, 0.97670000e+00},
    { 32, 19,  4,  0, 0.64529730e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 19,  4,  1, 0.23497420e+03, 0.38972000e+01, 0.97670000e+00},
    { 32, 20,  0,  0, 0.84336440e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 20,  0,  1, 0.67269170e+03, 0.00000000e+00, 0.98310000e+00},
    { 32, 20,  0,  2, 0.35293360e+03, 0.00000000e+00, 0.19349000e+01},
    { 32, 20,  1,  0, 0.77753610e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 20,  1,  1, 0.62067350e+03, 0.94340000e+00, 0.98310000e+00},
    { 32, 20,  1,  2, 0.32905540e+03, 0.94340000e+00, 0.19349000e+01},
    { 32, 20,  2,  0, 0.73264330e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 20,  2,  1, 0.58505150e+03, 0.19447000e+01, 0.98310000e+00},
    { 32, 20,  2,  2, 0.31254240e+03, 0.19447000e+01, 0.19349000e+01},
    { 32, 20,  3,  0, 0.63980000e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 20,  3,  1, 0.51153740e+03, 0.29186000e+01, 0.98310000e+00},
    { 32, 20,  3,  2, 0.27842050e+03, 0.29186000e+01, 0.19349000e+01},
    { 32, 20,  4,  0, 0.54647840e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 20,  4,  1, 0.43767790e+03, 0.38972000e+01, 0.98310000e+00},
    { 32, 20,  4,  2, 0.24395900e+03, 0.38972000e+01, 0.19349000e+01},
    { 32, 21,  0,  0, 0.69470240e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 21,  0,  1, 0.34316790e+03, 0.00000000e+00, 0.18627000e+01},
    { 32, 21,  0,  2, 0.33757610e+03, 0.00000000e+00, 0.28999000e+01},
    { 32, 21,  1,  0, 0.64140640e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 21,  1,  1, 0.32013420e+03, 0.94340000e+00, 0.18627000e+01},
    { 32, 21,  1,  2, 0.31533670e+03, 0.94340000e+00, 0.28999000e+01},
    { 32, 21,  2,  0, 0.60503430e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 21,  2,  1, 0.30419020e+03, 0.19447000e+01, 0.18627000e+01},
    { 32, 21,  2,  2, 0.29990140e+03, 0.19447000e+01, 0.28999000e+01},
    { 32, 21,  3,  0, 0.52977990e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 21,  3,  1, 0.27124750e+03, 0.29186000e+01, 0.18627000e+01},
    { 32, 21,  3,  2, 0.26802690e+03, 0.29186000e+01, 0.28999000e+01},
    { 32, 21,  4,  0, 0.45407710e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 21,  4,  1, 0.23797060e+03, 0.38972000e+01, 0.18627000e+01},
    { 32, 21,  4,  2, 0.23581030e+03, 0.38972000e+01, 0.28999000e+01},
    { 32, 22,  0,  0, 0.66837860e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 22,  0,  1, 0.33097100e+03, 0.00000000e+00, 0.18299000e+01},
    { 32, 22,  0,  2, 0.34156270e+03, 0.00000000e+00, 0.38675000e+01},
    { 32, 22,  1,  0, 0.61804010e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 22,  1,  1, 0.30883040e+03, 0.94340000e+00, 0.18299000e+01},
    { 32, 22,  1,  2, 0.31910990e+03, 0.94340000e+00, 0.38675000e+01},
    { 32, 22,  2,  0, 0.58362370e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 22,  2,  1, 0.29348990e+03, 0.19447000e+01, 0.18299000e+01},
    { 32, 22,  2,  2, 0.30352280e+03, 0.19447000e+01, 0.38675000e+01},
    { 32, 22,  3,  0, 0.51242740e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 22,  3,  1, 0.26180740e+03, 0.29186000e+01, 0.18299000e+01},
    { 32, 22,  3,  2, 0.27133540e+03, 0.29186000e+01, 0.38675000e+01},
    { 32, 22,  4,  0, 0.44076620e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 22,  4,  1, 0.22980530e+03, 0.38972000e+01, 0.18299000e+01},
    { 32, 22,  4,  2, 0.23880070e+03, 0.38972000e+01, 0.38675000e+01},
    { 32, 23,  0,  0, 0.61076390e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 23,  0,  1, 0.32434350e+03, 0.00000000e+00, 0.19138000e+01},
    { 32, 23,  0,  2, 0.31241300e+03, 0.00000000e+00, 0.29110000e+01},
    { 32, 23,  1,  0, 0.56526390e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 23,  1,  1, 0.30262720e+03, 0.94340000e+00, 0.19138000e+01},
    { 32, 23,  1,  2, 0.29187130e+03, 0.94340000e+00, 0.29110000e+01},
    { 32, 23,  2,  0, 0.53412560e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 23,  2,  1, 0.28758510e+03, 0.19447000e+01, 0.19138000e+01},
    { 32, 23,  2,  2, 0.27760900e+03, 0.19447000e+01, 0.29110000e+01},
    { 32, 23,  3,  0, 0.46971220e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 23,  3,  1, 0.25651490e+03, 0.29186000e+01, 0.19138000e+01},
    { 32, 23,  3,  2, 0.24816060e+03, 0.29186000e+01, 0.29110000e+01},
    { 32, 23,  4,  0, 0.40485430e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 23,  4,  1, 0.22513260e+03, 0.38972000e+01, 0.19138000e+01},
    { 32, 23,  4,  2, 0.21840030e+03, 0.38972000e+01, 0.29110000e+01},
    { 32, 24,  0,  0, 0.47996390e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 24,  0,  1, 0.32164040e+03, 0.00000000e+00, 0.18269000e+01},
    { 32, 24,  0,  2, 0.23279920e+03, 0.00000000e+00, 0.10619100e+02},
    { 32, 24,  1,  0, 0.44441960e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 24,  1,  1, 0.29997060e+03, 0.94340000e+00, 0.18269000e+01},
    { 32, 24,  1,  2, 0.21822070e+03, 0.94340000e+00, 0.10619100e+02},
    { 32, 24,  2,  0, 0.42006420e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 24,  2,  1, 0.28497290e+03, 0.19447000e+01, 0.18269000e+01},
    { 32, 24,  2,  2, 0.20803810e+03, 0.19447000e+01, 0.10619100e+02},
    { 32, 24,  3,  0, 0.36970490e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 24,  3,  1, 0.25399050e+03, 0.29186000e+01, 0.18269000e+01},
    { 32, 24,  3,  2, 0.18702850e+03, 0.29186000e+01, 0.10619100e+02},
    { 32, 24,  4,  0, 0.31900750e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 24,  4,  1, 0.22270380e+03, 0.38972000e+01, 0.18269000e+01},
    { 32, 24,  4,  2, 0.16577460e+03, 0.38972000e+01, 0.10619100e+02},
    { 32, 25,  0,  0, 0.52418480e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 25,  0,  1, 0.29451840e+03, 0.00000000e+00, 0.16406000e+01},
    { 32, 25,  0,  2, 0.19793940e+03, 0.00000000e+00, 0.98849000e+01},
    { 32, 25,  1,  0, 0.48576480e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 25,  1,  1, 0.27526070e+03, 0.94340000e+00, 0.16406000e+01},
    { 32, 25,  1,  2, 0.18592460e+03, 0.94340000e+00, 0.98849000e+01},
    { 32, 25,  2,  0, 0.45943140e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 25,  2,  1, 0.26188660e+03, 0.19447000e+01, 0.16406000e+01},
    { 32, 25,  2,  2, 0.17749730e+03, 0.19447000e+01, 0.98849000e+01},
    { 32, 25,  3,  0, 0.40496220e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 25,  3,  1, 0.23426800e+03, 0.29186000e+01, 0.16406000e+01},
    { 32, 25,  3,  2, 0.16012070e+03, 0.29186000e+01, 0.98849000e+01},
    { 32, 25,  4,  0, 0.35008820e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 25,  4,  1, 0.20634830e+03, 0.38972000e+01, 0.16406000e+01},
    { 32, 25,  4,  2, 0.14252950e+03, 0.38972000e+01, 0.98849000e+01},
    { 32, 26,  0,  0, 0.41021060e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 26,  0,  1, 0.27197110e+03, 0.00000000e+00, 0.16483000e+01},
    { 32, 26,  0,  2, 0.19441570e+03, 0.00000000e+00, 0.91376000e+01},
    { 32, 26,  1,  0, 0.38038530e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 26,  1,  1, 0.25437350e+03, 0.94340000e+00, 0.16483000e+01},
    { 32, 26,  1,  2, 0.18256910e+03, 0.94340000e+00, 0.91376000e+01},
    { 32, 26,  2,  0, 0.35991720e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 26,  2,  1, 0.24213490e+03, 0.19447000e+01, 0.16483000e+01},
    { 32, 26,  2,  2, 0.17426540e+03, 0.19447000e+01, 0.91376000e+01},
    { 32, 26,  3,  0, 0.31759430e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 26,  3,  1, 0.21686750e+03, 0.29186000e+01, 0.16483000e+01},
    { 32, 26,  3,  2, 0.15714100e+03, 0.29186000e+01, 0.91376000e+01},
    { 32, 26,  4,  0, 0.27496140e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 26,  4,  1, 0.19131890e+03, 0.38972000e+01, 0.16483000e+01},
    { 32, 26,  4,  2, 0.13980680e+03, 0.38972000e+01, 0.91376000e+01},
    { 32, 27,  0,  0, 0.43385080e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 27,  0,  1, 0.25932240e+03, 0.00000000e+00, 0.17149000e+01},
    { 32, 27,  0,  2, 0.23021330e+03, 0.00000000e+00, 0.29263000e+01},
    { 32, 27,  0,  3, 0.20362780e+03, 0.00000000e+00, 0.77785000e+01},
    { 32, 27,  1,  0, 0.40291460e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 27,  1,  1, 0.24255720e+03, 0.94340000e+00, 0.17149000e+01},
    { 32, 27,  1,  2, 0.21547520e+03, 0.94340000e+00, 0.29263000e+01},
    { 32, 27,  1,  3, 0.19100140e+03, 0.94340000e+00, 0.77785000e+01},
    { 32, 27,  2,  0, 0.38165880e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 27,  2,  1, 0.23089560e+03, 0.19447000e+01, 0.17149000e+01},
    { 32, 27,  2,  2, 0.20521220e+03, 0.19447000e+01, 0.29263000e+01},
    { 32, 27,  2,  3, 0.18217310e+03, 0.19447000e+01, 0.77785000e+01},
    { 32, 27,  3,  0, 0.33769310e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 27,  3,  1, 0.20682100e+03, 0.29186000e+01, 0.17149000e+01},
    { 32, 27,  3,  2, 0.18402720e+03, 0.29186000e+01, 0.29263000e+01},
    { 32, 27,  3,  3, 0.16395940e+03, 0.29186000e+01, 0.77785000e+01},
    { 32, 27,  4,  0, 0.29335770e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 27,  4,  1, 0.18247980e+03, 0.38972000e+01, 0.17149000e+01},
    { 32, 27,  4,  2, 0.16260680e+03, 0.38972000e+01, 0.29263000e+01},
    { 32, 27,  4,  3, 0.14552910e+03, 0.38972000e+01, 0.77785000e+01},
    { 32, 28,  0,  0, 0.44798680e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 28,  0,  1, 0.25361340e+03, 0.00000000e+00, 0.17937000e+01},
    { 32, 28,  0,  2, 0.21391340e+03, 0.00000000e+00, 0.65458000e+01},
    { 32, 28,  0,  3, 0.22570800e+03, 0.00000000e+00, 0.62918000e+01},
    { 32, 28,  1,  0, 0.41564390e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 28,  1,  1, 0.23717370e+03, 0.94340000e+00, 0.17937000e+01},
    { 32, 28,  1,  2, 0.20040030e+03, 0.94340000e+00, 0.65458000e+01},
    { 32, 28,  1,  3, 0.21104400e+03, 0.94340000e+00, 0.62918000e+01},
    { 32, 28,  2,  0, 0.39345300e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 28,  2,  1, 0.22574350e+03, 0.19447000e+01, 0.17937000e+01},
    { 32, 28,  2,  2, 0.19097590e+03, 0.19447000e+01, 0.65458000e+01},
    { 32, 28,  2,  3, 0.20085740e+03, 0.19447000e+01, 0.62918000e+01},
    { 32, 28,  3,  0, 0.34754450e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 28,  3,  1, 0.20214420e+03, 0.29186000e+01, 0.17937000e+01},
    { 32, 28,  3,  2, 0.17152460e+03, 0.29186000e+01, 0.65458000e+01},
    { 32, 28,  3,  3, 0.17981780e+03, 0.29186000e+01, 0.62918000e+01},
    { 32, 28,  4,  0, 0.30126690e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 28,  4,  1, 0.17828580e+03, 0.38972000e+01, 0.17937000e+01},
    { 32, 28,  4,  2, 0.15184970e+03, 0.38972000e+01, 0.65458000e+01},
    { 32, 28,  4,  3, 0.15855360e+03, 0.38972000e+01, 0.62918000e+01},
    { 32, 29,  0,  0, 0.34242610e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 29,  0,  1, 0.25153860e+03, 0.00000000e+00, 0.95760000e+00},
    { 32, 29,  1,  0, 0.31786240e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 29,  1,  1, 0.23483270e+03, 0.94340000e+00, 0.95760000e+00},
    { 32, 29,  2,  0, 0.30098740e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 29,  2,  1, 0.22325740e+03, 0.19447000e+01, 0.95760000e+00},
    { 32, 29,  3,  0, 0.26609200e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 29,  3,  1, 0.19934300e+03, 0.29186000e+01, 0.95760000e+00},
    { 32, 29,  4,  0, 0.23092580e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 29,  4,  1, 0.17518440e+03, 0.38972000e+01, 0.95760000e+00},
    { 32, 30,  0,  0, 0.34998850e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 30,  0,  1, 0.23434070e+03, 0.00000000e+00, 0.19419000e+01},
    { 32, 30,  1,  0, 0.32569280e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 30,  1,  1, 0.21945080e+03, 0.94340000e+00, 0.19419000e+01},
    { 32, 30,  2,  0, 0.30895170e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 30,  2,  1, 0.20907070e+03, 0.19447000e+01, 0.19419000e+01},
    { 32, 30,  3,  0, 0.27433390e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 30,  3,  1, 0.18764810e+03, 0.29186000e+01, 0.19419000e+01},
    { 32, 30,  4,  0, 0.23939590e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 30,  4,  1, 0.16597640e+03, 0.38972000e+01, 0.19419000e+01},
    { 32, 31,  0,  0, 0.41595300e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 31,  0,  1, 0.38973700e+03, 0.00000000e+00, 0.96010000e+00},
    { 32, 31,  0,  2, 0.30609340e+03, 0.00000000e+00, 0.19315000e+01},
    { 32, 31,  0,  3, 0.24818660e+03, 0.00000000e+00, 0.29233000e+01},
    { 32, 31,  1,  0, 0.38671290e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 31,  1,  1, 0.36268320e+03, 0.94340000e+00, 0.96010000e+00},
    { 32, 31,  1,  2, 0.28580490e+03, 0.94340000e+00, 0.19315000e+01},
    { 32, 31,  1,  3, 0.23250850e+03, 0.94340000e+00, 0.29233000e+01},
    { 32, 31,  2,  0, 0.36657420e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 31,  2,  1, 0.34402320e+03, 0.19447000e+01, 0.96010000e+00},
    { 32, 31,  2,  2, 0.27172720e+03, 0.19447000e+01, 0.19315000e+01},
    { 32, 31,  2,  3, 0.22156120e+03, 0.19447000e+01, 0.29233000e+01},
    { 32, 31,  3,  0, 0.32494560e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 31,  3,  1, 0.30545790e+03, 0.29186000e+01, 0.96010000e+00},
    { 32, 31,  3,  2, 0.24266150e+03, 0.29186000e+01, 0.19315000e+01},
    { 32, 31,  3,  3, 0.19898010e+03, 0.29186000e+01, 0.29233000e+01},
    { 32, 31,  4,  0, 0.28294690e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 31,  4,  1, 0.26653500e+03, 0.38972000e+01, 0.96010000e+00},
    { 32, 31,  4,  2, 0.21328870e+03, 0.38972000e+01, 0.19315000e+01},
    { 32, 31,  4,  3, 0.17612940e+03, 0.38972000e+01, 0.29233000e+01},
    { 32, 32,  0,  0, 0.36354740e+03, 0.00000000e+00, 0.00000000e+00},
    { 32, 32,  1,  0, 0.33924040e+03, 0.94340000e+00, 0.00000000e+00},
    { 32, 32,  1,  1, 0.31685210e+03, 0.94340000e+00, 0.94340000e+00},
    { 32, 32,  2,  0, 0.32239740e+03, 0.19447000e+01, 0.00000000e+00},
    { 32, 32,  2,  1, 0.30131020e+03, 0.19447000e+01, 0.94340000e+00},
    { 32, 32,  2,  2, 0.28665450e+03, 0.19447000e+01, 0.19447000e+01},
    { 32, 32,  3,  0, 0.28761030e+03, 0.29186000e+01, 0.00000000e+00},
    { 32, 32,  3,  1, 0.26922150e+03, 0.29186000e+01, 0.94340000e+00},
    { 32, 32,  3,  2, 0.25640090e+03, 0.29186000e+01, 0.19447000e+01},
    { 32, 32,  3,  3, 0.22994980e+03, 0.29186000e+01, 0.29186000e+01},
    { 32, 32,  4,  0, 0.25245910e+03, 0.38972000e+01, 0.00000000e+00},
    { 32, 32,  4,  1, 0.23678670e+03, 0.38972000e+01, 0.94340000e+00},
    { 32, 32,  4,  2, 0.22581390e+03, 0.38972000e+01, 0.19447000e+01},
    { 32, 32,  4,  3, 0.20319220e+03, 0.38972000e+01, 0.29186000e+01},
    { 32, 32,  4,  4, 0.18029120e+03, 0.38972000e+01, 0.38972000e+01},
    { 33,  1,  0,  0, 0.27788400e+02, 0.00000000e+00, 0.91180000e+00},
    { 33,  1,  0,  1, 0.44651200e+02, 0.00000000e+00, 0.00000000e+00},
    { 33,  1,  1,  0, 0.27357400e+02, 0.98890000e+00, 0.91180000e+00},
    { 33,  1,  1,  1, 0.43906700e+02, 0.98890000e+00, 0.00000000e+00},
    { 33,  1,  2,  0, 0.26704200e+02, 0.19793000e+01, 0.91180000e+00},
    { 33,  1,  2,  1, 0.42778900e+02, 0.19793000e+01, 0.00000000e+00},
    { 33,  1,  3,  0, 0.25814400e+02, 0.29709000e+01, 0.91180000e+00},
    { 33,  1,  3,  1, 0.41243400e+02, 0.29709000e+01, 0.00000000e+00},
    { 33,  2,  0,  0, 0.18328400e+02, 0.00000000e+00, 0.00000000e+00},
    { 33,  2,  1,  0, 0.18081600e+02, 0.98890000e+00, 0.00000000e+00},
    { 33,  2,  2,  0, 0.17705100e+02, 0.19793000e+01, 0.00000000e+00},
    { 33,  2,  3,  0, 0.17190000e+02, 0.29709000e+01, 0.00000000e+00},
    { 33,  3,  0,  0, 0.41515320e+03, 0.00000000e+00, 0.00000000e+00},
    { 33,  3,  0,  1, 0.14284710e+03, 0.00000000e+00, 0.98650000e+00},
    { 33,  3,  1,  0, 0.40634270e+03, 0.98890000e+00, 0.00000000e+00},
    { 33,  3,  1,  1, 0.14013530e+03, 0.98890000e+00, 0.98650000e+00},
    { 33,  3,  2,  0, 0.39243650e+03, 0.19793000e+01, 0.00000000e+00},
    { 33,  3,  2,  1, 0.13598320e+03, 0.19793000e+01, 0.98650000e+00},
    { 33,  3,  3,  0, 0.37309010e+03, 0.29709000e+01, 0.00000000e+00},
    { 33,  3,  3,  1, 0.13030340e+03, 0.29709000e+01, 0.98650000e+00},
    { 33,  4,  0,  0, 0.24548310e+03, 0.00000000e+00, 0.00000000e+00},
    { 33,  4,  0,  1, 0.18253380e+03, 0.00000000e+00, 0.98080000e+00},
    { 33,  4,  0,  2, 0.12022240e+03, 0.00000000e+00, 0.19697000e+01},
    { 33,  4,  1,  0, 0.24075590e+03, 0.98890000e+00, 0.00000000e+00},
    { 33,  4,  1,  1, 0.17913900e+03, 0.98890000e+00, 0.98080000e+00},
    { 33,  4,  1,  2, 0.11815200e+03, 0.98890000e+00, 0.19697000e+01},
    { 33,  4,  2,  0, 0.23351510e+03, 0.19793000e+01, 0.00000000e+00},
    { 33,  4,  2,  1, 0.17394150e+03, 0.19793000e+01, 0.98080000e+00},
    { 33,  4,  2,  2, 0.11501370e+03, 0.19793000e+01, 0.19697000e+01},
    { 33,  4,  3,  0, 0.22360990e+03, 0.29709000e+01, 0.00000000e+00},
    { 33,  4,  3,  1, 0.16682950e+03, 0.29709000e+01, 0.98080000e+00},
    { 33,  4,  3,  2, 0.11074050e+03, 0.29709000e+01, 0.19697000e+01},
    { 33,  5,  0,  0, 0.16690600e+03, 0.00000000e+00, 0.00000000e+00},
    { 33,  5,  0,  1, 0.14056250e+03, 0.00000000e+00, 0.97060000e+00},
    { 33,  5,  0,  2, 0.11813540e+03, 0.00000000e+00, 0.19441000e+01},
    { 33,  5,  0,  3, 0.90137300e+02, 0.00000000e+00, 0.29128000e+01},
    { 33,  5,  0,  4, 0.84829800e+02, 0.00000000e+00, 0.45856000e+01},
    { 33,  5,  1,  0, 0.16396550e+03, 0.98890000e+00, 0.00000000e+00},
    { 33,  5,  1,  1, 0.13814460e+03, 0.98890000e+00, 0.97060000e+00},
    { 33,  5,  1,  2, 0.11615350e+03, 0.98890000e+00, 0.19441000e+01},
    { 33,  5,  1,  3, 0.88710800e+02, 0.98890000e+00, 0.29128000e+01},
    { 33,  5,  1,  4, 0.83502300e+02, 0.98890000e+00, 0.45856000e+01},
    { 33,  5,  2,  0, 0.15949690e+03, 0.19793000e+01, 0.00000000e+00},
    { 33,  5,  2,  1, 0.13447040e+03, 0.19793000e+01, 0.97060000e+00},
    { 33,  5,  2,  2, 0.11314120e+03, 0.19793000e+01, 0.19441000e+01},
    { 33,  5,  2,  3, 0.86548600e+02, 0.19793000e+01, 0.29128000e+01},
    { 33,  5,  2,  4, 0.81489600e+02, 0.19793000e+01, 0.45856000e+01},
    { 33,  5,  3,  0, 0.15340550e+03, 0.29709000e+01, 0.00000000e+00},
    { 33,  5,  3,  1, 0.12946150e+03, 0.29709000e+01, 0.97060000e+00},
    { 33,  5,  3,  2, 0.10903310e+03, 0.29709000e+01, 0.19441000e+01},
    { 33,  5,  3,  3, 0.83603600e+02, 0.29709000e+01, 0.29128000e+01},
    { 33,  5,  3,  4, 0.78747800e+02, 0.29709000e+01, 0.45856000e+01},
    { 33,  6,  0,  0, 0.11326160e+03, 0.00000000e+00, 0.00000000e+00},
    { 33,  6,  0,  1, 0.10616860e+03, 0.00000000e+00, 0.98680000e+00},
    { 33,  6,  0,  2, 0.86689500e+02, 0.00000000e+00, 0.19985000e+01},
    { 33,  6,  0,  3, 0.81056300e+02, 0.00000000e+00, 0.29987000e+01},
    { 33,  6,  0,  4, 0.66414700e+02, 0.00000000e+00, 0.39844000e+01},
    { 33,  6,  1,  0, 0.11142570e+03, 0.98890000e+00, 0.00000000e+00},
    { 33,  6,  1,  1, 0.10445320e+03, 0.98890000e+00, 0.98680000e+00},
    { 33,  6,  1,  2, 0.85337900e+02, 0.98890000e+00, 0.19985000e+01},
    { 33,  6,  1,  3, 0.79798600e+02, 0.98890000e+00, 0.29987000e+01},
    { 33,  6,  1,  4, 0.65441400e+02, 0.98890000e+00, 0.39844000e+01},
    { 33,  6,  2,  0, 0.10864070e+03, 0.19793000e+01, 0.00000000e+00},
    { 33,  6,  2,  1, 0.10184690e+03, 0.19793000e+01, 0.98680000e+00},
    { 33,  6,  2,  2, 0.83286500e+02, 0.19793000e+01, 0.19985000e+01},
    { 33,  6,  2,  3, 0.77887400e+02, 0.19793000e+01, 0.29987000e+01},
    { 33,  6,  2,  4, 0.63962100e+02, 0.19793000e+01, 0.39844000e+01},
    { 33,  6,  3,  0, 0.10484620e+03, 0.29709000e+01, 0.00000000e+00},
    { 33,  6,  3,  1, 0.98293000e+02, 0.29709000e+01, 0.98680000e+00},
    { 33,  6,  3,  2, 0.80490200e+02, 0.29709000e+01, 0.19985000e+01},
    { 33,  6,  3,  3, 0.75280800e+02, 0.29709000e+01, 0.29987000e+01},
    { 33,  6,  3,  4, 0.61943800e+02, 0.29709000e+01, 0.39844000e+01},
    { 33,  7,  0,  0, 0.79308600e+02, 0.00000000e+00, 0.00000000e+00},
    { 33,  7,  0,  1, 0.73914200e+02, 0.00000000e+00, 0.99440000e+00},
    { 33,  7,  0,  2, 0.69377000e+02, 0.00000000e+00, 0.20143000e+01},
    { 33,  7,  0,  3, 0.61042500e+02, 0.00000000e+00, 0.29903000e+01},
    { 33,  7,  1,  0, 0.78113800e+02, 0.98890000e+00, 0.00000000e+00},
    { 33,  7,  1,  1, 0.72807300e+02, 0.98890000e+00, 0.99440000e+00},
    { 33,  7,  1,  2, 0.68347700e+02, 0.98890000e+00, 0.20143000e+01},
    { 33,  7,  1,  3, 0.60151900e+02, 0.98890000e+00, 0.29903000e+01},
    { 33,  7,  2,  0, 0.76299200e+02, 0.19793000e+01, 0.00000000e+00},
    { 33,  7,  2,  1, 0.71123800e+02, 0.19793000e+01, 0.99440000e+00},
    { 33,  7,  2,  2, 0.66781800e+02, 0.19793000e+01, 0.20143000e+01},
    { 33,  7,  2,  3, 0.58794500e+02, 0.19793000e+01, 0.29903000e+01},
    { 33,  7,  3,  0, 0.73824600e+02, 0.29709000e+01, 0.00000000e+00},
    { 33,  7,  3,  1, 0.68826400e+02, 0.29709000e+01, 0.99440000e+00},
    { 33,  7,  3,  2, 0.64644600e+02, 0.29709000e+01, 0.20143000e+01},
    { 33,  7,  3,  3, 0.56939800e+02, 0.29709000e+01, 0.29903000e+01},
    { 33,  8,  0,  0, 0.60028900e+02, 0.00000000e+00, 0.00000000e+00},
    { 33,  8,  0,  1, 0.53815300e+02, 0.00000000e+00, 0.99250000e+00},
    { 33,  8,  0,  2, 0.47420200e+02, 0.00000000e+00, 0.19887000e+01},
    { 33,  8,  1,  0, 0.59176400e+02, 0.98890000e+00, 0.00000000e+00},
    { 33,  8,  1,  1, 0.53064500e+02, 0.98890000e+00, 0.99250000e+00},
    { 33,  8,  1,  2, 0.46775300e+02, 0.98890000e+00, 0.19887000e+01},
    { 33,  8,  2,  0, 0.57878400e+02, 0.19793000e+01, 0.00000000e+00},
    { 33,  8,  2,  1, 0.51919900e+02, 0.19793000e+01, 0.99250000e+00},
    { 33,  8,  2,  2, 0.45789900e+02, 0.19793000e+01, 0.19887000e+01},
    { 33,  8,  3,  0, 0.56105700e+02, 0.29709000e+01, 0.00000000e+00},
    { 33,  8,  3,  1, 0.50355500e+02, 0.29709000e+01, 0.99250000e+00},
    { 33,  8,  3,  2, 0.44441700e+02, 0.29709000e+01, 0.19887000e+01},
    { 33,  9,  0,  0, 0.45418000e+02, 0.00000000e+00, 0.00000000e+00},
    { 33,  9,  0,  1, 0.36938900e+02, 0.00000000e+00, 0.99820000e+00},
    { 33,  9,  1,  0, 0.44807900e+02, 0.98890000e+00, 0.00000000e+00},
    { 33,  9,  1,  1, 0.36472800e+02, 0.98890000e+00, 0.99820000e+00},
    { 33,  9,  2,  0, 0.43876200e+02, 0.19793000e+01, 0.00000000e+00},
    { 33,  9,  2,  1, 0.35758200e+02, 0.19793000e+01, 0.99820000e+00},
    { 33,  9,  3,  0, 0.42601300e+02, 0.29709000e+01, 0.00000000e+00},
    { 33,  9,  3,  1, 0.34778500e+02, 0.29709000e+01, 0.99820000e+00},
    { 33, 10,  0,  0, 0.34868600e+02, 0.00000000e+00, 0.00000000e+00},
    { 33, 10,  1,  0, 0.34422600e+02, 0.98890000e+00, 0.00000000e+00},
    { 33, 10,  2,  0, 0.33739100e+02, 0.19793000e+01, 0.00000000e+00},
    { 33, 10,  3,  0, 0.32802100e+02, 0.29709000e+01, 0.00000000e+00},
    { 33, 11,  0,  0, 0.49693380e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 11,  0,  1, 0.20818020e+03, 0.00000000e+00, 0.96840000e+00},
    { 33, 11,  1,  0, 0.48646380e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 11,  1,  1, 0.20419370e+03, 0.98890000e+00, 0.96840000e+00},
    { 33, 11,  2,  0, 0.46995960e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 11,  2,  1, 0.19806920e+03, 0.19793000e+01, 0.96840000e+00},
    { 33, 11,  3,  0, 0.44701790e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 11,  3,  1, 0.18967700e+03, 0.29709000e+01, 0.96840000e+00},
    { 33, 12,  0,  0, 0.38949270e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 12,  0,  1, 0.32187320e+03, 0.00000000e+00, 0.96280000e+00},
    { 33, 12,  0,  2, 0.21233920e+03, 0.00000000e+00, 0.19496000e+01},
    { 33, 12,  1,  0, 0.38183960e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 12,  1,  1, 0.31566880e+03, 0.98890000e+00, 0.96280000e+00},
    { 33, 12,  1,  2, 0.20852360e+03, 0.98890000e+00, 0.19496000e+01},
    { 33, 12,  2,  0, 0.37006380e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 12,  2,  1, 0.30612750e+03, 0.19793000e+01, 0.96280000e+00},
    { 33, 12,  2,  2, 0.20272440e+03, 0.19793000e+01, 0.19496000e+01},
    { 33, 12,  3,  0, 0.35391780e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 12,  3,  1, 0.29304400e+03, 0.29709000e+01, 0.96280000e+00},
    { 33, 12,  3,  2, 0.19481980e+03, 0.29709000e+01, 0.19496000e+01},
    { 33, 13,  0,  0, 0.36119130e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 13,  0,  1, 0.32772290e+03, 0.00000000e+00, 0.96480000e+00},
    { 33, 13,  0,  2, 0.25642310e+03, 0.00000000e+00, 0.19311000e+01},
    { 33, 13,  0,  3, 0.20075140e+03, 0.00000000e+00, 0.29146000e+01},
    { 33, 13,  1,  0, 0.35437060e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 13,  1,  1, 0.32160430e+03, 0.98890000e+00, 0.96480000e+00},
    { 33, 13,  1,  2, 0.25181270e+03, 0.98890000e+00, 0.19311000e+01},
    { 33, 13,  1,  3, 0.19730880e+03, 0.98890000e+00, 0.29146000e+01},
    { 33, 13,  2,  0, 0.34393430e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 13,  2,  1, 0.31225010e+03, 0.19793000e+01, 0.96480000e+00},
    { 33, 13,  2,  2, 0.24478960e+03, 0.19793000e+01, 0.19311000e+01},
    { 33, 13,  2,  3, 0.19209160e+03, 0.19793000e+01, 0.29146000e+01},
    { 33, 13,  3,  0, 0.32966240e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 13,  3,  1, 0.29946280e+03, 0.29709000e+01, 0.96480000e+00},
    { 33, 13,  3,  2, 0.23520410e+03, 0.29709000e+01, 0.19311000e+01},
    { 33, 13,  3,  3, 0.18498860e+03, 0.29709000e+01, 0.29146000e+01},
    { 33, 14,  0,  0, 0.28659090e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 14,  0,  1, 0.26507110e+03, 0.00000000e+00, 0.95070000e+00},
    { 33, 14,  0,  2, 0.24673790e+03, 0.00000000e+00, 0.19435000e+01},
    { 33, 14,  0,  3, 0.24023030e+03, 0.00000000e+00, 0.29407000e+01},
    { 33, 14,  0,  4, 0.19840790e+03, 0.00000000e+00, 0.38677000e+01},
    { 33, 14,  1,  0, 0.28148930e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 14,  1,  1, 0.26040440e+03, 0.98890000e+00, 0.95070000e+00},
    { 33, 14,  1,  2, 0.24243590e+03, 0.98890000e+00, 0.19435000e+01},
    { 33, 14,  1,  3, 0.23602870e+03, 0.98890000e+00, 0.29407000e+01},
    { 33, 14,  1,  4, 0.19508440e+03, 0.98890000e+00, 0.38677000e+01},
    { 33, 14,  2,  0, 0.27373340e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 14,  2,  1, 0.25331120e+03, 0.19793000e+01, 0.95070000e+00},
    { 33, 14,  2,  2, 0.23590120e+03, 0.19793000e+01, 0.19435000e+01},
    { 33, 14,  2,  3, 0.22963620e+03, 0.19793000e+01, 0.29407000e+01},
    { 33, 14,  2,  4, 0.19004830e+03, 0.19793000e+01, 0.38677000e+01},
    { 33, 14,  3,  0, 0.26315950e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 14,  3,  1, 0.24364100e+03, 0.29709000e+01, 0.95070000e+00},
    { 33, 14,  3,  2, 0.22699490e+03, 0.29709000e+01, 0.19435000e+01},
    { 33, 14,  3,  3, 0.22091650e+03, 0.29709000e+01, 0.29407000e+01},
    { 33, 14,  3,  4, 0.18319150e+03, 0.29709000e+01, 0.38677000e+01},
    { 33, 15,  0,  0, 0.22447740e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 15,  0,  1, 0.21789200e+03, 0.00000000e+00, 0.99470000e+00},
    { 33, 15,  0,  2, 0.21483630e+03, 0.00000000e+00, 0.20102000e+01},
    { 33, 15,  0,  3, 0.19950090e+03, 0.00000000e+00, 0.29859000e+01},
    { 33, 15,  1,  0, 0.22071460e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 15,  1,  1, 0.21425140e+03, 0.98890000e+00, 0.99470000e+00},
    { 33, 15,  1,  2, 0.21123800e+03, 0.98890000e+00, 0.20102000e+01},
    { 33, 15,  1,  3, 0.19621220e+03, 0.98890000e+00, 0.29859000e+01},
    { 33, 15,  2,  0, 0.21501030e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 15,  2,  1, 0.20873090e+03, 0.19793000e+01, 0.99470000e+00},
    { 33, 15,  2,  2, 0.20577840e+03, 0.19793000e+01, 0.20102000e+01},
    { 33, 15,  2,  3, 0.19122650e+03, 0.19793000e+01, 0.29859000e+01},
    { 33, 15,  3,  0, 0.20724190e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 15,  3,  1, 0.20121190e+03, 0.29709000e+01, 0.99470000e+00},
    { 33, 15,  3,  2, 0.19834020e+03, 0.29709000e+01, 0.20102000e+01},
    { 33, 15,  3,  3, 0.18443640e+03, 0.29709000e+01, 0.29859000e+01},
    { 33, 16,  0,  0, 0.18663480e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 16,  0,  1, 0.18454670e+03, 0.00000000e+00, 0.99480000e+00},
    { 33, 16,  0,  2, 0.18080070e+03, 0.00000000e+00, 0.19903000e+01},
    { 33, 16,  1,  0, 0.18364620e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 16,  1,  1, 0.18159050e+03, 0.98890000e+00, 0.99480000e+00},
    { 33, 16,  1,  2, 0.17790880e+03, 0.98890000e+00, 0.19903000e+01},
    { 33, 16,  2,  0, 0.17911600e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 16,  2,  1, 0.17710850e+03, 0.19793000e+01, 0.99480000e+00},
    { 33, 16,  2,  2, 0.17352340e+03, 0.19793000e+01, 0.19903000e+01},
    { 33, 16,  3,  0, 0.17294560e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 16,  3,  1, 0.17100300e+03, 0.29709000e+01, 0.99480000e+00},
    { 33, 16,  3,  2, 0.16754910e+03, 0.29709000e+01, 0.19903000e+01},
    { 33, 17,  0,  0, 0.15260350e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 17,  0,  1, 0.15099990e+03, 0.00000000e+00, 0.99720000e+00},
    { 33, 17,  1,  0, 0.15027420e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 17,  1,  1, 0.14869430e+03, 0.98890000e+00, 0.99720000e+00},
    { 33, 17,  2,  0, 0.14674050e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 17,  2,  1, 0.14519610e+03, 0.19793000e+01, 0.99720000e+00},
    { 33, 17,  3,  0, 0.14192450e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 17,  3,  1, 0.14042820e+03, 0.29709000e+01, 0.99720000e+00},
    { 33, 18,  0,  0, 0.12485610e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 18,  1,  0, 0.12303580e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 18,  2,  0, 0.12026980e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 18,  3,  0, 0.11649640e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 19,  0,  0, 0.81065540e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 19,  0,  1, 0.28755350e+03, 0.00000000e+00, 0.97670000e+00},
    { 33, 19,  1,  0, 0.79363060e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 19,  1,  1, 0.28230700e+03, 0.98890000e+00, 0.97670000e+00},
    { 33, 19,  2,  0, 0.76653110e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 19,  2,  1, 0.27423250e+03, 0.19793000e+01, 0.97670000e+00},
    { 33, 19,  3,  0, 0.72861950e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 19,  3,  1, 0.26315470e+03, 0.29709000e+01, 0.97670000e+00},
    { 33, 20,  0,  0, 0.67900440e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 20,  0,  1, 0.54301230e+03, 0.00000000e+00, 0.98310000e+00},
    { 33, 20,  0,  2, 0.29714260e+03, 0.00000000e+00, 0.19349000e+01},
    { 33, 20,  1,  0, 0.66532210e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 20,  1,  1, 0.53224610e+03, 0.98890000e+00, 0.98310000e+00},
    { 33, 20,  1,  2, 0.29186010e+03, 0.98890000e+00, 0.19349000e+01},
    { 33, 20,  2,  0, 0.64403510e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 20,  2,  1, 0.51543230e+03, 0.19793000e+01, 0.98310000e+00},
    { 33, 20,  2,  2, 0.28380130e+03, 0.19793000e+01, 0.19349000e+01},
    { 33, 20,  3,  0, 0.61467050e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 20,  3,  1, 0.49217040e+03, 0.29709000e+01, 0.98310000e+00},
    { 33, 20,  3,  2, 0.27279590e+03, 0.29709000e+01, 0.19349000e+01},
    { 33, 21,  0,  0, 0.56269470e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 21,  0,  1, 0.28955820e+03, 0.00000000e+00, 0.18627000e+01},
    { 33, 21,  0,  2, 0.28630450e+03, 0.00000000e+00, 0.28999000e+01},
    { 33, 21,  1,  0, 0.55149990e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 21,  1,  1, 0.28445160e+03, 0.98890000e+00, 0.18627000e+01},
    { 33, 21,  1,  2, 0.28133310e+03, 0.98890000e+00, 0.28999000e+01},
    { 33, 21,  2,  0, 0.53415750e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 21,  2,  1, 0.27666340e+03, 0.19793000e+01, 0.18627000e+01},
    { 33, 21,  2,  2, 0.27376840e+03, 0.19793000e+01, 0.28999000e+01},
    { 33, 21,  3,  0, 0.51029120e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 21,  3,  1, 0.26602940e+03, 0.29709000e+01, 0.18627000e+01},
    { 33, 21,  3,  2, 0.26344960e+03, 0.29709000e+01, 0.28999000e+01},
    { 33, 22,  0,  0, 0.54467970e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 22,  0,  1, 0.27949900e+03, 0.00000000e+00, 0.18299000e+01},
    { 33, 22,  0,  2, 0.28985600e+03, 0.00000000e+00, 0.38675000e+01},
    { 33, 22,  1,  0, 0.53402660e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 22,  1,  1, 0.27459290e+03, 0.98890000e+00, 0.18299000e+01},
    { 33, 22,  1,  2, 0.28483450e+03, 0.98890000e+00, 0.38675000e+01},
    { 33, 22,  2,  0, 0.51756110e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 22,  2,  1, 0.26710550e+03, 0.19793000e+01, 0.18299000e+01},
    { 33, 22,  2,  2, 0.27719390e+03, 0.19793000e+01, 0.38675000e+01},
    { 33, 22,  3,  0, 0.49492760e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 22,  3,  1, 0.25687630e+03, 0.29709000e+01, 0.18299000e+01},
    { 33, 22,  3,  2, 0.26677170e+03, 0.29709000e+01, 0.38675000e+01},
    { 33, 23,  0,  0, 0.49949700e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 23,  0,  1, 0.27383520e+03, 0.00000000e+00, 0.19138000e+01},
    { 33, 23,  0,  2, 0.26507780e+03, 0.00000000e+00, 0.29110000e+01},
    { 33, 23,  1,  0, 0.48982100e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 23,  1,  1, 0.26902700e+03, 0.98890000e+00, 0.19138000e+01},
    { 33, 23,  1,  2, 0.26049700e+03, 0.98890000e+00, 0.29110000e+01},
    { 33, 23,  2,  0, 0.47488980e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 23,  2,  1, 0.26168720e+03, 0.19793000e+01, 0.19138000e+01},
    { 33, 23,  2,  2, 0.25351690e+03, 0.19793000e+01, 0.29110000e+01},
    { 33, 23,  3,  0, 0.45438220e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 23,  3,  1, 0.25165870e+03, 0.29709000e+01, 0.19138000e+01},
    { 33, 23,  3,  2, 0.24398790e+03, 0.29709000e+01, 0.29110000e+01},
    { 33, 24,  0,  0, 0.39319220e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 24,  0,  1, 0.27107700e+03, 0.00000000e+00, 0.18269000e+01},
    { 33, 24,  0,  2, 0.20004860e+03, 0.00000000e+00, 0.10619100e+02},
    { 33, 24,  1,  0, 0.38565770e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 24,  1,  1, 0.26629390e+03, 0.98890000e+00, 0.18269000e+01},
    { 33, 24,  1,  2, 0.19676310e+03, 0.98890000e+00, 0.10619100e+02},
    { 33, 24,  2,  0, 0.37400380e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 24,  2,  1, 0.25898560e+03, 0.19793000e+01, 0.18269000e+01},
    { 33, 24,  2,  2, 0.19175980e+03, 0.19793000e+01, 0.10619100e+02},
    { 33, 24,  3,  0, 0.35797570e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 24,  3,  1, 0.24899550e+03, 0.29709000e+01, 0.18269000e+01},
    { 33, 24,  3,  2, 0.18493070e+03, 0.29709000e+01, 0.10619100e+02},
    { 33, 25,  0,  0, 0.43091460e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 25,  0,  1, 0.25028310e+03, 0.00000000e+00, 0.16406000e+01},
    { 33, 25,  0,  2, 0.17140770e+03, 0.00000000e+00, 0.98849000e+01},
    { 33, 25,  1,  0, 0.42268740e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 25,  1,  1, 0.24597130e+03, 0.98890000e+00, 0.16406000e+01},
    { 33, 25,  1,  2, 0.16867800e+03, 0.98890000e+00, 0.98849000e+01},
    { 33, 25,  2,  0, 0.41001990e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 25,  2,  1, 0.23941200e+03, 0.19793000e+01, 0.16406000e+01},
    { 33, 25,  2,  2, 0.16452480e+03, 0.19793000e+01, 0.98849000e+01},
    { 33, 25,  3,  0, 0.39264080e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 25,  3,  1, 0.23046590e+03, 0.29709000e+01, 0.16406000e+01},
    { 33, 25,  3,  2, 0.15885780e+03, 0.29709000e+01, 0.98849000e+01},
    { 33, 26,  0,  0, 0.33800960e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 26,  0,  1, 0.23176180e+03, 0.00000000e+00, 0.16483000e+01},
    { 33, 26,  0,  2, 0.16819670e+03, 0.00000000e+00, 0.91376000e+01},
    { 33, 26,  1,  0, 0.33163890e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 26,  1,  1, 0.22781130e+03, 0.98890000e+00, 0.16483000e+01},
    { 33, 26,  1,  2, 0.16550840e+03, 0.98890000e+00, 0.91376000e+01},
    { 33, 26,  2,  0, 0.32180920e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 26,  2,  1, 0.22180340e+03, 0.19793000e+01, 0.16483000e+01},
    { 33, 26,  2,  2, 0.16141780e+03, 0.19793000e+01, 0.91376000e+01},
    { 33, 26,  3,  0, 0.30830750e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 26,  3,  1, 0.21360980e+03, 0.29709000e+01, 0.16483000e+01},
    { 33, 26,  3,  2, 0.15583590e+03, 0.29709000e+01, 0.91376000e+01},
    { 33, 27,  0,  0, 0.35971500e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 27,  0,  1, 0.22102330e+03, 0.00000000e+00, 0.17149000e+01},
    { 33, 27,  0,  2, 0.19670460e+03, 0.00000000e+00, 0.29263000e+01},
    { 33, 27,  0,  3, 0.17541210e+03, 0.00000000e+00, 0.77785000e+01},
    { 33, 27,  1,  0, 0.35300740e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 27,  1,  1, 0.21726350e+03, 0.98890000e+00, 0.17149000e+01},
    { 33, 27,  1,  2, 0.19340210e+03, 0.98890000e+00, 0.29263000e+01},
    { 33, 27,  1,  3, 0.17255780e+03, 0.98890000e+00, 0.77785000e+01},
    { 33, 27,  2,  0, 0.34272150e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 27,  2,  1, 0.21154220e+03, 0.19793000e+01, 0.17149000e+01},
    { 33, 27,  2,  2, 0.18837020e+03, 0.19793000e+01, 0.29263000e+01},
    { 33, 27,  2,  3, 0.16821430e+03, 0.19793000e+01, 0.77785000e+01},
    { 33, 27,  3,  0, 0.32864030e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 27,  3,  1, 0.20373690e+03, 0.29709000e+01, 0.17149000e+01},
    { 33, 27,  3,  2, 0.18150050e+03, 0.29709000e+01, 0.29263000e+01},
    { 33, 27,  3,  3, 0.16228780e+03, 0.29709000e+01, 0.77785000e+01},
    { 33, 28,  0,  0, 0.37003590e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 28,  0,  1, 0.21600430e+03, 0.00000000e+00, 0.17937000e+01},
    { 33, 28,  0,  2, 0.18341100e+03, 0.00000000e+00, 0.65458000e+01},
    { 33, 28,  0,  3, 0.19211030e+03, 0.00000000e+00, 0.62918000e+01},
    { 33, 28,  1,  0, 0.36305660e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 28,  1,  1, 0.21232210e+03, 0.98890000e+00, 0.17937000e+01},
    { 33, 28,  1,  2, 0.18036950e+03, 0.98890000e+00, 0.65458000e+01},
    { 33, 28,  1,  3, 0.18884500e+03, 0.98890000e+00, 0.62918000e+01},
    { 33, 28,  2,  0, 0.35234030e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 28,  2,  1, 0.20671720e+03, 0.19793000e+01, 0.17937000e+01},
    { 33, 28,  2,  2, 0.17573990e+03, 0.19793000e+01, 0.65458000e+01},
    { 33, 28,  2,  3, 0.18386230e+03, 0.19793000e+01, 0.62918000e+01},
    { 33, 28,  3,  0, 0.33766070e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 28,  3,  1, 0.19906950e+03, 0.29709000e+01, 0.17937000e+01},
    { 33, 28,  3,  2, 0.16942270e+03, 0.29709000e+01, 0.65458000e+01},
    { 33, 28,  3,  3, 0.17705570e+03, 0.29709000e+01, 0.62918000e+01},
    { 33, 29,  0,  0, 0.28333230e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 29,  0,  1, 0.21283460e+03, 0.00000000e+00, 0.95760000e+00},
    { 33, 29,  1,  0, 0.27805780e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 29,  1,  1, 0.20913220e+03, 0.98890000e+00, 0.95760000e+00},
    { 33, 29,  2,  0, 0.26993300e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 29,  2,  1, 0.20348070e+03, 0.19793000e+01, 0.95760000e+00},
    { 33, 29,  3,  0, 0.25878300e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 29,  3,  1, 0.19575950e+03, 0.29709000e+01, 0.95760000e+00},
    { 33, 30,  0,  0, 0.29250300e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 30,  0,  1, 0.20064080e+03, 0.00000000e+00, 0.19419000e+01},
    { 33, 30,  1,  0, 0.28717780e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 30,  1,  1, 0.19727710e+03, 0.98890000e+00, 0.19419000e+01},
    { 33, 30,  2,  0, 0.27903750e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 30,  2,  1, 0.19216860e+03, 0.19793000e+01, 0.19419000e+01},
    { 33, 30,  3,  0, 0.26791080e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 30,  3,  1, 0.18520600e+03, 0.29709000e+01, 0.19419000e+01},
    { 33, 31,  0,  0, 0.34635080e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 31,  0,  1, 0.32572680e+03, 0.00000000e+00, 0.96010000e+00},
    { 33, 31,  0,  2, 0.25916500e+03, 0.00000000e+00, 0.19315000e+01},
    { 33, 31,  0,  3, 0.21282990e+03, 0.00000000e+00, 0.29233000e+01},
    { 33, 31,  1,  0, 0.33996250e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 31,  1,  1, 0.31978710e+03, 0.98890000e+00, 0.96010000e+00},
    { 33, 31,  1,  2, 0.25463590e+03, 0.98890000e+00, 0.19315000e+01},
    { 33, 31,  1,  3, 0.20926950e+03, 0.98890000e+00, 0.29233000e+01},
    { 33, 31,  2,  0, 0.33018810e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 31,  2,  1, 0.31071100e+03, 0.19793000e+01, 0.96010000e+00},
    { 33, 31,  2,  2, 0.24774210e+03, 0.19793000e+01, 0.19315000e+01},
    { 33, 31,  2,  3, 0.20387080e+03, 0.19793000e+01, 0.29233000e+01},
    { 33, 31,  3,  0, 0.31682010e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 31,  3,  1, 0.29830600e+03, 0.29709000e+01, 0.96010000e+00},
    { 33, 31,  3,  2, 0.23833640e+03, 0.29709000e+01, 0.19315000e+01},
    { 33, 31,  3,  3, 0.19651790e+03, 0.29709000e+01, 0.29233000e+01},
    { 33, 32,  0,  0, 0.30710100e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 32,  0,  1, 0.28758470e+03, 0.00000000e+00, 0.94340000e+00},
    { 33, 32,  0,  2, 0.27396550e+03, 0.00000000e+00, 0.19447000e+01},
    { 33, 32,  0,  3, 0.24587190e+03, 0.00000000e+00, 0.29186000e+01},
    { 33, 32,  0,  4, 0.21744760e+03, 0.00000000e+00, 0.38972000e+01},
    { 33, 32,  1,  0, 0.30168000e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 32,  1,  1, 0.28257170e+03, 0.98890000e+00, 0.94340000e+00},
    { 33, 32,  1,  2, 0.26923080e+03, 0.98890000e+00, 0.19447000e+01},
    { 33, 32,  1,  3, 0.24171350e+03, 0.98890000e+00, 0.29186000e+01},
    { 33, 32,  1,  4, 0.21387070e+03, 0.98890000e+00, 0.38972000e+01},
    { 33, 32,  2,  0, 0.29343220e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 32,  2,  1, 0.27494970e+03, 0.19793000e+01, 0.94340000e+00},
    { 33, 32,  2,  2, 0.26203540e+03, 0.19793000e+01, 0.19447000e+01},
    { 33, 32,  2,  3, 0.23540190e+03, 0.19793000e+01, 0.29186000e+01},
    { 33, 32,  2,  4, 0.20845000e+03, 0.19793000e+01, 0.38972000e+01},
    { 33, 32,  3,  0, 0.28218280e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 32,  3,  1, 0.26455660e+03, 0.29709000e+01, 0.94340000e+00},
    { 33, 32,  3,  2, 0.25222610e+03, 0.29709000e+01, 0.19447000e+01},
    { 33, 32,  3,  3, 0.22680190e+03, 0.29709000e+01, 0.29186000e+01},
    { 33, 32,  3,  4, 0.20106830e+03, 0.29709000e+01, 0.38972000e+01},
    { 33, 33,  0,  0, 0.26294980e+03, 0.00000000e+00, 0.00000000e+00},
    { 33, 33,  1,  0, 0.25852630e+03, 0.98890000e+00, 0.00000000e+00},
    { 33, 33,  1,  1, 0.25419240e+03, 0.98890000e+00, 0.98890000e+00},
    { 33, 33,  2,  0, 0.25181550e+03, 0.19793000e+01, 0.00000000e+00},
    { 33, 33,  2,  1, 0.24761740e+03, 0.19793000e+01, 0.98890000e+00},
    { 33, 33,  2,  2, 0.24124940e+03, 0.19793000e+01, 0.19793000e+01},
    { 33, 33,  3,  0, 0.24267360e+03, 0.29709000e+01, 0.00000000e+00},
    { 33, 33,  3,  1, 0.23866010e+03, 0.29709000e+01, 0.98890000e+00},
    { 33, 33,  3,  2, 0.23257440e+03, 0.29709000e+01, 0.19793000e+01},
    { 33, 33,  3,  3, 0.22428510e+03, 0.29709000e+01, 0.29709000e+01},
    { 34,  1,  0,  0, 0.25309800e+02, 0.00000000e+00, 0.91180000e+00},
    { 34,  1,  0,  1, 0.40201000e+02, 0.00000000e+00, 0.00000000e+00},
    { 34,  1,  1,  0, 0.25314900e+02, 0.99010000e+00, 0.91180000e+00},
    { 34,  1,  1,  1, 0.40211700e+02, 0.99010000e+00, 0.00000000e+00},
    { 34,  1,  2,  0, 0.25126800e+02, 0.19812000e+01, 0.91180000e+00},
    { 34,  1,  2,  1, 0.39896700e+02, 0.19812000e+01, 0.00000000e+00},
    { 34,  2,  0,  0, 0.17024300e+02, 0.00000000e+00, 0.00000000e+00},
    { 34,  2,  1,  0, 0.17028000e+02, 0.99010000e+00, 0.00000000e+00},
    { 34,  2,  2,  0, 0.16915700e+02, 0.19812000e+01, 0.00000000e+00},
    { 34,  3,  0,  0, 0.35454290e+03, 0.00000000e+00, 0.00000000e+00},
    { 34,  3,  0,  1, 0.12547680e+03, 0.00000000e+00, 0.98650000e+00},
    { 34,  3,  1,  0, 0.35504500e+03, 0.99010000e+00, 0.00000000e+00},
    { 34,  3,  1,  1, 0.12555640e+03, 0.99010000e+00, 0.98650000e+00},
    { 34,  3,  2,  0, 0.35181040e+03, 0.19812000e+01, 0.00000000e+00},
    { 34,  3,  2,  1, 0.12448680e+03, 0.19812000e+01, 0.98650000e+00},
    { 34,  4,  0,  0, 0.21502380e+03, 0.00000000e+00, 0.00000000e+00},
    { 34,  4,  0,  1, 0.16096870e+03, 0.00000000e+00, 0.98080000e+00},
    { 34,  4,  0,  2, 0.10763710e+03, 0.00000000e+00, 0.19697000e+01},
    { 34,  4,  1,  0, 0.21516710e+03, 0.99010000e+00, 0.00000000e+00},
    { 34,  4,  1,  1, 0.16106370e+03, 0.99010000e+00, 0.98080000e+00},
    { 34,  4,  1,  2, 0.10767130e+03, 0.99010000e+00, 0.19697000e+01},
    { 34,  4,  2,  0, 0.21331490e+03, 0.19812000e+01, 0.00000000e+00},
    { 34,  4,  2,  1, 0.15970990e+03, 0.19812000e+01, 0.98080000e+00},
    { 34,  4,  2,  2, 0.10680860e+03, 0.19812000e+01, 0.19697000e+01},
    { 34,  5,  0,  0, 0.14880080e+03, 0.00000000e+00, 0.00000000e+00},
    { 34,  5,  0,  1, 0.12584370e+03, 0.00000000e+00, 0.97060000e+00},
    { 34,  5,  0,  2, 0.10621400e+03, 0.00000000e+00, 0.19441000e+01},
    { 34,  5,  0,  3, 0.81838100e+02, 0.00000000e+00, 0.29128000e+01},
    { 34,  5,  0,  4, 0.77153300e+02, 0.00000000e+00, 0.45856000e+01},
    { 34,  5,  1,  0, 0.14885900e+03, 0.99010000e+00, 0.00000000e+00},
    { 34,  5,  1,  1, 0.12588880e+03, 0.99010000e+00, 0.97060000e+00},
    { 34,  5,  1,  2, 0.10624910e+03, 0.99010000e+00, 0.19441000e+01},
    { 34,  5,  1,  3, 0.81856400e+02, 0.99010000e+00, 0.29128000e+01},
    { 34,  5,  1,  4, 0.77170000e+02, 0.99010000e+00, 0.45856000e+01},
    { 34,  5,  2,  0, 0.14765020e+03, 0.19812000e+01, 0.00000000e+00},
    { 34,  5,  2,  1, 0.12488450e+03, 0.19812000e+01, 0.97060000e+00},
    { 34,  5,  2,  2, 0.10541670e+03, 0.19812000e+01, 0.19441000e+01},
    { 34,  5,  2,  3, 0.81240000e+02, 0.19812000e+01, 0.29128000e+01},
    { 34,  5,  2,  4, 0.76593900e+02, 0.19812000e+01, 0.45856000e+01},
    { 34,  6,  0,  0, 0.10243460e+03, 0.00000000e+00, 0.00000000e+00},
    { 34,  6,  0,  1, 0.96059900e+02, 0.00000000e+00, 0.98680000e+00},
    { 34,  6,  0,  2, 0.78883800e+02, 0.00000000e+00, 0.19985000e+01},
    { 34,  6,  0,  3, 0.73806400e+02, 0.00000000e+00, 0.29987000e+01},
    { 34,  6,  0,  4, 0.60991300e+02, 0.00000000e+00, 0.39844000e+01},
    { 34,  6,  1,  0, 0.10246200e+03, 0.99010000e+00, 0.00000000e+00},
    { 34,  6,  1,  1, 0.96087200e+02, 0.99010000e+00, 0.98680000e+00},
    { 34,  6,  1,  2, 0.78902900e+02, 0.99010000e+00, 0.19985000e+01},
    { 34,  6,  1,  3, 0.73825700e+02, 0.99010000e+00, 0.29987000e+01},
    { 34,  6,  1,  4, 0.61004100e+02, 0.99010000e+00, 0.39844000e+01},
    { 34,  6,  2,  0, 0.10167860e+03, 0.19812000e+01, 0.00000000e+00},
    { 34,  6,  2,  1, 0.95355300e+02, 0.19812000e+01, 0.98680000e+00},
    { 34,  6,  2,  2, 0.78317700e+02, 0.19812000e+01, 0.19985000e+01},
    { 34,  6,  2,  3, 0.73281400e+02, 0.19812000e+01, 0.29987000e+01},
    { 34,  6,  2,  4, 0.60572300e+02, 0.19812000e+01, 0.39844000e+01},
    { 34,  7,  0,  0, 0.72540300e+02, 0.00000000e+00, 0.00000000e+00},
    { 34,  7,  0,  1, 0.67663600e+02, 0.00000000e+00, 0.99440000e+00},
    { 34,  7,  0,  2, 0.63591900e+02, 0.00000000e+00, 0.20143000e+01},
    { 34,  7,  0,  3, 0.56081200e+02, 0.00000000e+00, 0.29903000e+01},
    { 34,  7,  1,  0, 0.72556700e+02, 0.99010000e+00, 0.00000000e+00},
    { 34,  7,  1,  1, 0.67679600e+02, 0.99010000e+00, 0.99440000e+00},
    { 34,  7,  1,  2, 0.63607400e+02, 0.99010000e+00, 0.20143000e+01},
    { 34,  7,  1,  3, 0.56096200e+02, 0.99010000e+00, 0.29903000e+01},
    { 34,  7,  2,  0, 0.72032800e+02, 0.19812000e+01, 0.00000000e+00},
    { 34,  7,  2,  1, 0.67193600e+02, 0.19812000e+01, 0.99440000e+00},
    { 34,  7,  2,  2, 0.63154900e+02, 0.19812000e+01, 0.20143000e+01},
    { 34,  7,  2,  3, 0.55703700e+02, 0.19812000e+01, 0.29903000e+01},
    { 34,  8,  0,  0, 0.55362700e+02, 0.00000000e+00, 0.00000000e+00},
    { 34,  8,  0,  1, 0.49755200e+02, 0.00000000e+00, 0.99250000e+00},
    { 34,  8,  0,  2, 0.43981900e+02, 0.00000000e+00, 0.19887000e+01},
    { 34,  8,  1,  0, 0.55375200e+02, 0.99010000e+00, 0.00000000e+00},
    { 34,  8,  1,  1, 0.49766500e+02, 0.99010000e+00, 0.99250000e+00},
    { 34,  8,  1,  2, 0.43993100e+02, 0.99010000e+00, 0.19887000e+01},
    { 34,  8,  2,  0, 0.54994300e+02, 0.19812000e+01, 0.00000000e+00},
    { 34,  8,  2,  1, 0.49429100e+02, 0.19812000e+01, 0.99250000e+00},
    { 34,  8,  2,  2, 0.43702200e+02, 0.19812000e+01, 0.19887000e+01},
    { 34,  9,  0,  0, 0.42192300e+02, 0.00000000e+00, 0.00000000e+00},
    { 34,  9,  0,  1, 0.34579200e+02, 0.00000000e+00, 0.99820000e+00},
    { 34,  9,  1,  0, 0.42202700e+02, 0.99010000e+00, 0.00000000e+00},
    { 34,  9,  1,  1, 0.34588200e+02, 0.99010000e+00, 0.99820000e+00},
    { 34,  9,  2,  0, 0.41926000e+02, 0.19812000e+01, 0.00000000e+00},
    { 34,  9,  2,  1, 0.34372900e+02, 0.19812000e+01, 0.99820000e+00},
    { 34, 10,  0,  0, 0.32584300e+02, 0.00000000e+00, 0.00000000e+00},
    { 34, 10,  1,  0, 0.32593500e+02, 0.99010000e+00, 0.00000000e+00},
    { 34, 10,  2,  0, 0.32389200e+02, 0.19812000e+01, 0.00000000e+00},
    { 34, 11,  0,  0, 0.42518640e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 11,  0,  1, 0.18247440e+03, 0.00000000e+00, 0.96840000e+00},
    { 34, 11,  1,  0, 0.42577330e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 11,  1,  1, 0.18260620e+03, 0.99010000e+00, 0.96840000e+00},
    { 34, 11,  2,  0, 0.42191950e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 11,  2,  1, 0.18104870e+03, 0.19812000e+01, 0.96840000e+00},
    { 34, 12,  0,  0, 0.33957420e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 12,  0,  1, 0.28171730e+03, 0.00000000e+00, 0.96280000e+00},
    { 34, 12,  0,  2, 0.18862140e+03, 0.00000000e+00, 0.19496000e+01},
    { 34, 12,  1,  0, 0.33984270e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 12,  1,  1, 0.28192490e+03, 0.99010000e+00, 0.96280000e+00},
    { 34, 12,  1,  2, 0.18870250e+03, 0.99010000e+00, 0.19496000e+01},
    { 34, 12,  2,  0, 0.33688690e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 12,  2,  1, 0.27950350e+03, 0.19812000e+01, 0.96280000e+00},
    { 34, 12,  2,  2, 0.18715040e+03, 0.19812000e+01, 0.19496000e+01},
    { 34, 13,  0,  0, 0.31761820e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 13,  0,  1, 0.28884850e+03, 0.00000000e+00, 0.96480000e+00},
    { 34, 13,  0,  2, 0.22769360e+03, 0.00000000e+00, 0.19311000e+01},
    { 34, 13,  0,  3, 0.17986350e+03, 0.00000000e+00, 0.29146000e+01},
    { 34, 13,  1,  0, 0.31781330e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 13,  1,  1, 0.28901630e+03, 0.99010000e+00, 0.96480000e+00},
    { 34, 13,  1,  2, 0.22779820e+03, 0.99010000e+00, 0.19311000e+01},
    { 34, 13,  1,  3, 0.17991980e+03, 0.99010000e+00, 0.29146000e+01},
    { 34, 13,  2,  0, 0.31511470e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 13,  2,  1, 0.28658090e+03, 0.19812000e+01, 0.96480000e+00},
    { 34, 13,  2,  2, 0.22592450e+03, 0.19812000e+01, 0.19311000e+01},
    { 34, 13,  2,  3, 0.17848350e+03, 0.19812000e+01, 0.29146000e+01},
    { 34, 14,  0,  0, 0.25500990e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 14,  0,  1, 0.23633230e+03, 0.00000000e+00, 0.95070000e+00},
    { 34, 14,  0,  2, 0.22038060e+03, 0.00000000e+00, 0.19435000e+01},
    { 34, 14,  0,  3, 0.21441210e+03, 0.00000000e+00, 0.29407000e+01},
    { 34, 14,  0,  4, 0.17847990e+03, 0.00000000e+00, 0.38677000e+01},
    { 34, 14,  1,  0, 0.25511530e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 14,  1,  1, 0.23642530e+03, 0.99010000e+00, 0.95070000e+00},
    { 34, 14,  1,  2, 0.22046240e+03, 0.99010000e+00, 0.19435000e+01},
    { 34, 14,  1,  3, 0.21449810e+03, 0.99010000e+00, 0.29407000e+01},
    { 34, 14,  1,  4, 0.17853020e+03, 0.99010000e+00, 0.38677000e+01},
    { 34, 14,  2,  0, 0.25302890e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 14,  2,  1, 0.23450660e+03, 0.19812000e+01, 0.95070000e+00},
    { 34, 14,  2,  2, 0.21868530e+03, 0.19812000e+01, 0.19435000e+01},
    { 34, 14,  2,  3, 0.21276790e+03, 0.19812000e+01, 0.29407000e+01},
    { 34, 14,  2,  4, 0.17712870e+03, 0.19812000e+01, 0.38677000e+01},
    { 34, 15,  0,  0, 0.20190190e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 15,  0,  1, 0.19608060e+03, 0.00000000e+00, 0.99470000e+00},
    { 34, 15,  0,  2, 0.19324100e+03, 0.00000000e+00, 0.20102000e+01},
    { 34, 15,  0,  3, 0.17993740e+03, 0.00000000e+00, 0.29859000e+01},
    { 34, 15,  1,  0, 0.20196030e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 15,  1,  1, 0.19613740e+03, 0.99010000e+00, 0.99470000e+00},
    { 34, 15,  1,  2, 0.19329960e+03, 0.99010000e+00, 0.20102000e+01},
    { 34, 15,  1,  3, 0.17998620e+03, 0.99010000e+00, 0.29859000e+01},
    { 34, 15,  2,  0, 0.20037470e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 15,  2,  1, 0.19460170e+03, 0.19812000e+01, 0.99470000e+00},
    { 34, 15,  2,  2, 0.19178480e+03, 0.19812000e+01, 0.20102000e+01},
    { 34, 15,  2,  3, 0.17859070e+03, 0.19812000e+01, 0.29859000e+01},
    { 34, 16,  0,  0, 0.16913080e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 16,  0,  1, 0.16722640e+03, 0.00000000e+00, 0.99480000e+00},
    { 34, 16,  0,  2, 0.16386810e+03, 0.00000000e+00, 0.19903000e+01},
    { 34, 16,  1,  0, 0.16917120e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 16,  1,  1, 0.16726720e+03, 0.99010000e+00, 0.99480000e+00},
    { 34, 16,  1,  2, 0.16390830e+03, 0.99010000e+00, 0.19903000e+01},
    { 34, 16,  2,  0, 0.16788680e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 16,  2,  1, 0.16599750e+03, 0.19812000e+01, 0.99480000e+00},
    { 34, 16,  2,  2, 0.16266590e+03, 0.19812000e+01, 0.19903000e+01},
    { 34, 17,  0,  0, 0.13931630e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 17,  0,  1, 0.13784430e+03, 0.00000000e+00, 0.99720000e+00},
    { 34, 17,  1,  0, 0.13934530e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 17,  1,  1, 0.13787350e+03, 0.99010000e+00, 0.99720000e+00},
    { 34, 17,  2,  0, 0.13832530e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 17,  2,  1, 0.13686440e+03, 0.19812000e+01, 0.99720000e+00},
    { 34, 18,  0,  0, 0.11474490e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 18,  1,  0, 0.11476770e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 18,  2,  0, 0.11395770e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 19,  0,  0, 0.69291160e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 19,  0,  1, 0.25436700e+03, 0.00000000e+00, 0.97670000e+00},
    { 34, 19,  1,  0, 0.69398180e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 19,  1,  1, 0.25453760e+03, 0.99010000e+00, 0.97670000e+00},
    { 34, 19,  2,  0, 0.68773700e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 19,  2,  1, 0.25244980e+03, 0.19812000e+01, 0.97670000e+00},
    { 34, 20,  0,  0, 0.58796470e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 20,  0,  1, 0.47148220e+03, 0.00000000e+00, 0.98310000e+00},
    { 34, 20,  0,  2, 0.26437900e+03, 0.00000000e+00, 0.19349000e+01},
    { 34, 20,  1,  0, 0.58857630e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 20,  1,  1, 0.47198210e+03, 0.99010000e+00, 0.98310000e+00},
    { 34, 20,  1,  2, 0.26450720e+03, 0.99010000e+00, 0.19349000e+01},
    { 34, 20,  2,  0, 0.58340090e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 20,  2,  1, 0.46788320e+03, 0.19812000e+01, 0.98310000e+00},
    { 34, 20,  2,  2, 0.26236130e+03, 0.19812000e+01, 0.19349000e+01},
    { 34, 21,  0,  0, 0.48887150e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 21,  0,  1, 0.25800840e+03, 0.00000000e+00, 0.18627000e+01},
    { 34, 21,  0,  2, 0.25587020e+03, 0.00000000e+00, 0.28999000e+01},
    { 34, 21,  1,  0, 0.48933050e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 21,  1,  1, 0.25812950e+03, 0.99010000e+00, 0.18627000e+01},
    { 34, 21,  1,  2, 0.25597460e+03, 0.99010000e+00, 0.28999000e+01},
    { 34, 21,  2,  0, 0.48505940e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 21,  2,  1, 0.25604740e+03, 0.19812000e+01, 0.18627000e+01},
    { 34, 21,  2,  2, 0.25392720e+03, 0.19812000e+01, 0.28999000e+01},
    { 34, 22,  0,  0, 0.47503480e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 22,  0,  1, 0.24922580e+03, 0.00000000e+00, 0.18299000e+01},
    { 34, 22,  0,  2, 0.25914890e+03, 0.00000000e+00, 0.38675000e+01},
    { 34, 22,  1,  0, 0.47544530e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 22,  1,  1, 0.24934370e+03, 0.99010000e+00, 0.18299000e+01},
    { 34, 22,  1,  2, 0.25925390e+03, 0.99010000e+00, 0.38675000e+01},
    { 34, 22,  2,  0, 0.47134280e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 22,  2,  1, 0.24734020e+03, 0.19812000e+01, 0.18299000e+01},
    { 34, 22,  2,  2, 0.25718410e+03, 0.19812000e+01, 0.38675000e+01},
    { 34, 23,  0,  0, 0.43657180e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 23,  0,  1, 0.24415540e+03, 0.00000000e+00, 0.19138000e+01},
    { 34, 23,  0,  2, 0.23705770e+03, 0.00000000e+00, 0.29110000e+01},
    { 34, 23,  1,  0, 0.43692930e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 23,  1,  1, 0.24427270e+03, 0.99010000e+00, 0.19138000e+01},
    { 34, 23,  1,  2, 0.23715920e+03, 0.99010000e+00, 0.29110000e+01},
    { 34, 23,  2,  0, 0.43318300e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 23,  2,  1, 0.24231110e+03, 0.19812000e+01, 0.19138000e+01},
    { 34, 23,  2,  2, 0.23527290e+03, 0.19812000e+01, 0.29110000e+01},
    { 34, 24,  0,  0, 0.34429560e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 24,  0,  1, 0.24145850e+03, 0.00000000e+00, 0.18269000e+01},
    { 34, 24,  0,  2, 0.18047050e+03, 0.00000000e+00, 0.10619100e+02},
    { 34, 24,  1,  0, 0.34458580e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 24,  1,  1, 0.24158030e+03, 0.99010000e+00, 0.18269000e+01},
    { 34, 24,  1,  2, 0.18053650e+03, 0.99010000e+00, 0.10619100e+02},
    { 34, 24,  2,  0, 0.34166370e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 24,  2,  1, 0.23963570e+03, 0.19812000e+01, 0.18269000e+01},
    { 34, 24,  2,  2, 0.17915590e+03, 0.19812000e+01, 0.10619100e+02},
    { 34, 25,  0,  0, 0.37782760e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 25,  0,  1, 0.22398570e+03, 0.00000000e+00, 0.16406000e+01},
    { 34, 25,  0,  2, 0.15541540e+03, 0.00000000e+00, 0.98849000e+01},
    { 34, 25,  1,  0, 0.37811330e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 25,  1,  1, 0.22407570e+03, 0.99010000e+00, 0.16406000e+01},
    { 34, 25,  1,  2, 0.15546520e+03, 0.99010000e+00, 0.98849000e+01},
    { 34, 25,  2,  0, 0.37490260e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 25,  2,  1, 0.22229610e+03, 0.19812000e+01, 0.16406000e+01},
    { 34, 25,  2,  2, 0.15430230e+03, 0.19812000e+01, 0.98849000e+01},
    { 34, 26,  0,  0, 0.29703960e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 26,  0,  1, 0.20779480e+03, 0.00000000e+00, 0.16483000e+01},
    { 34, 26,  0,  2, 0.15241280e+03, 0.00000000e+00, 0.91376000e+01},
    { 34, 26,  1,  0, 0.29726970e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 26,  1,  1, 0.20787480e+03, 0.99010000e+00, 0.16483000e+01},
    { 34, 26,  1,  2, 0.15246290e+03, 0.99010000e+00, 0.91376000e+01},
    { 34, 26,  2,  0, 0.29477780e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 26,  2,  1, 0.20623670e+03, 0.19812000e+01, 0.16483000e+01},
    { 34, 26,  2,  2, 0.15132020e+03, 0.19812000e+01, 0.91376000e+01},
    { 34, 27,  0,  0, 0.31701740e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 27,  0,  1, 0.19822130e+03, 0.00000000e+00, 0.17149000e+01},
    { 34, 27,  0,  2, 0.17678440e+03, 0.00000000e+00, 0.29263000e+01},
    { 34, 27,  0,  3, 0.15849070e+03, 0.00000000e+00, 0.77785000e+01},
    { 34, 27,  1,  0, 0.31722330e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 27,  1,  1, 0.19829930e+03, 0.99010000e+00, 0.17149000e+01},
    { 34, 27,  1,  2, 0.17685580e+03, 0.99010000e+00, 0.29263000e+01},
    { 34, 27,  1,  3, 0.15854630e+03, 0.99010000e+00, 0.77785000e+01},
    { 34, 27,  2,  0, 0.31457060e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 27,  2,  1, 0.19674030e+03, 0.19812000e+01, 0.17149000e+01},
    { 34, 27,  2,  2, 0.17548260e+03, 0.19812000e+01, 0.29263000e+01},
    { 34, 27,  2,  3, 0.15734260e+03, 0.19812000e+01, 0.77785000e+01},
    { 34, 28,  0,  0, 0.32534190e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 28,  0,  1, 0.19364320e+03, 0.00000000e+00, 0.17937000e+01},
    { 34, 28,  0,  2, 0.16519610e+03, 0.00000000e+00, 0.65458000e+01},
    { 34, 28,  0,  3, 0.17227180e+03, 0.00000000e+00, 0.62918000e+01},
    { 34, 28,  1,  0, 0.32556670e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 28,  1,  1, 0.19372130e+03, 0.99010000e+00, 0.17937000e+01},
    { 34, 28,  1,  2, 0.16525840e+03, 0.99010000e+00, 0.65458000e+01},
    { 34, 28,  1,  3, 0.17234930e+03, 0.99010000e+00, 0.62918000e+01},
    { 34, 28,  2,  0, 0.32282380e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 28,  2,  1, 0.19219700e+03, 0.19812000e+01, 0.17937000e+01},
    { 34, 28,  2,  2, 0.16398640e+03, 0.19812000e+01, 0.65458000e+01},
    { 34, 28,  2,  3, 0.17100310e+03, 0.19812000e+01, 0.62918000e+01},
    { 34, 29,  0,  0, 0.24963850e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 29,  0,  1, 0.19007710e+03, 0.00000000e+00, 0.95760000e+00},
    { 34, 29,  1,  0, 0.24982100e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 29,  1,  1, 0.19016850e+03, 0.99010000e+00, 0.95760000e+00},
    { 34, 29,  2,  0, 0.24774600e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 29,  2,  1, 0.18865600e+03, 0.19812000e+01, 0.95760000e+00},
    { 34, 30,  0,  0, 0.25904590e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 30,  0,  1, 0.18041890e+03, 0.00000000e+00, 0.19419000e+01},
    { 34, 30,  1,  0, 0.25919160e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 30,  1,  1, 0.18048120e+03, 0.99010000e+00, 0.19419000e+01},
    { 34, 30,  2,  0, 0.25705830e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 30,  2,  1, 0.17907470e+03, 0.19812000e+01, 0.19419000e+01},
    { 34, 31,  0,  0, 0.30595010e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 31,  0,  1, 0.28839340e+03, 0.00000000e+00, 0.96010000e+00},
    { 34, 31,  0,  2, 0.23133530e+03, 0.00000000e+00, 0.19315000e+01},
    { 34, 31,  0,  3, 0.19148490e+03, 0.00000000e+00, 0.29233000e+01},
    { 34, 31,  1,  0, 0.30612750e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 31,  1,  1, 0.28854930e+03, 0.99010000e+00, 0.96010000e+00},
    { 34, 31,  1,  2, 0.23143120e+03, 0.99010000e+00, 0.19315000e+01},
    { 34, 31,  1,  3, 0.19154240e+03, 0.99010000e+00, 0.29233000e+01},
    { 34, 31,  2,  0, 0.30357640e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 31,  2,  1, 0.28616240e+03, 0.19812000e+01, 0.96010000e+00},
    { 34, 31,  2,  2, 0.22956900e+03, 0.19812000e+01, 0.19315000e+01},
    { 34, 31,  2,  3, 0.19004420e+03, 0.19812000e+01, 0.29233000e+01},
    { 34, 32,  0,  0, 0.27365300e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 32,  0,  1, 0.25685170e+03, 0.00000000e+00, 0.94340000e+00},
    { 34, 32,  0,  2, 0.24506900e+03, 0.00000000e+00, 0.19447000e+01},
    { 34, 32,  0,  3, 0.22078460e+03, 0.00000000e+00, 0.29186000e+01},
    { 34, 32,  0,  4, 0.19619620e+03, 0.00000000e+00, 0.38972000e+01},
    { 34, 32,  1,  0, 0.27376800e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 32,  1,  1, 0.25695230e+03, 0.99010000e+00, 0.94340000e+00},
    { 34, 32,  1,  2, 0.24516040e+03, 0.99010000e+00, 0.19447000e+01},
    { 34, 32,  1,  3, 0.22085650e+03, 0.99010000e+00, 0.29186000e+01},
    { 34, 32,  1,  4, 0.19624890e+03, 0.99010000e+00, 0.38972000e+01},
    { 34, 32,  2,  0, 0.27154740e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 32,  2,  1, 0.25488570e+03, 0.19812000e+01, 0.94340000e+00},
    { 34, 32,  2,  2, 0.24320020e+03, 0.19812000e+01, 0.19447000e+01},
    { 34, 32,  2,  3, 0.21911610e+03, 0.19812000e+01, 0.29186000e+01},
    { 34, 32,  2,  4, 0.19473060e+03, 0.19812000e+01, 0.38972000e+01},
    { 34, 33,  0,  0, 0.23634730e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 33,  0,  1, 0.23250720e+03, 0.00000000e+00, 0.98890000e+00},
    { 34, 33,  0,  2, 0.22668450e+03, 0.00000000e+00, 0.19793000e+01},
    { 34, 33,  0,  3, 0.21875310e+03, 0.00000000e+00, 0.29709000e+01},
    { 34, 33,  1,  0, 0.23642060e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 33,  1,  1, 0.23257840e+03, 0.99010000e+00, 0.98890000e+00},
    { 34, 33,  1,  2, 0.22675190e+03, 0.99010000e+00, 0.19793000e+01},
    { 34, 33,  1,  3, 0.21881490e+03, 0.99010000e+00, 0.29709000e+01},
    { 34, 33,  2,  0, 0.23456310e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 33,  2,  1, 0.23075580e+03, 0.19812000e+01, 0.98890000e+00},
    { 34, 33,  2,  2, 0.22498180e+03, 0.19812000e+01, 0.19793000e+01},
    { 34, 33,  2,  3, 0.21711610e+03, 0.19812000e+01, 0.29709000e+01},
    { 34, 34,  0,  0, 0.21367380e+03, 0.00000000e+00, 0.00000000e+00},
    { 34, 34,  1,  0, 0.21372980e+03, 0.99010000e+00, 0.00000000e+00},
    { 34, 34,  1,  1, 0.21378620e+03, 0.99010000e+00, 0.99010000e+00},
    { 34, 34,  2,  0, 0.21209150e+03, 0.19812000e+01, 0.00000000e+00},
    { 34, 34,  2,  1, 0.21214750e+03, 0.19812000e+01, 0.99010000e+00},
    { 34, 34,  2,  2, 0.21052310e+03, 0.19812000e+01, 0.19812000e+01},
    { 35,  1,  0,  0, 0.22483400e+02, 0.00000000e+00, 0.91180000e+00},
    { 35,  1,  0,  1, 0.35274000e+02, 0.00000000e+00, 0.00000000e+00},
    { 35,  1,  1,  0, 0.22623000e+02, 0.99740000e+00, 0.91180000e+00},
    { 35,  1,  1,  1, 0.35512300e+02, 0.99740000e+00, 0.00000000e+00},
    { 35,  2,  0,  0, 0.15455300e+02, 0.00000000e+00, 0.00000000e+00},
    { 35,  2,  1,  0, 0.15538700e+02, 0.99740000e+00, 0.00000000e+00},
    { 35,  3,  0,  0, 0.29478970e+03, 0.00000000e+00, 0.00000000e+00},
    { 35,  3,  0,  1, 0.10733800e+03, 0.00000000e+00, 0.98650000e+00},
    { 35,  3,  1,  0, 0.29768350e+03, 0.99740000e+00, 0.00000000e+00},
    { 35,  3,  1,  1, 0.10820480e+03, 0.99740000e+00, 0.98650000e+00},
    { 35,  4,  0,  0, 0.18337420e+03, 0.00000000e+00, 0.00000000e+00},
    { 35,  4,  0,  1, 0.13827470e+03, 0.00000000e+00, 0.98080000e+00},
    { 35,  4,  0,  2, 0.93891100e+02, 0.00000000e+00, 0.19697000e+01},
    { 35,  4,  1,  0, 0.18488320e+03, 0.99740000e+00, 0.00000000e+00},
    { 35,  4,  1,  1, 0.13936170e+03, 0.99740000e+00, 0.98080000e+00},
    { 35,  4,  1,  2, 0.94551500e+02, 0.99740000e+00, 0.19697000e+01},
    { 35,  5,  0,  0, 0.12924950e+03, 0.00000000e+00, 0.00000000e+00},
    { 35,  5,  0,  1, 0.10980600e+03, 0.00000000e+00, 0.97060000e+00},
    { 35,  5,  0,  2, 0.93100300e+02, 0.00000000e+00, 0.19441000e+01},
    { 35,  5,  0,  3, 0.72461300e+02, 0.00000000e+00, 0.29128000e+01},
    { 35,  5,  0,  4, 0.68441600e+02, 0.00000000e+00, 0.45856000e+01},
    { 35,  5,  1,  0, 0.13018810e+03, 0.99740000e+00, 0.00000000e+00},
    { 35,  5,  1,  1, 0.11058020e+03, 0.99740000e+00, 0.97060000e+00},
    { 35,  5,  1,  2, 0.93737400e+02, 0.99740000e+00, 0.19441000e+01},
    { 35,  5,  1,  3, 0.72922100e+02, 0.99740000e+00, 0.29128000e+01},
    { 35,  5,  1,  4, 0.68871400e+02, 0.99740000e+00, 0.45856000e+01},
    { 35,  6,  0,  0, 0.90342400e+02, 0.00000000e+00, 0.00000000e+00},
    { 35,  6,  0,  1, 0.84772300e+02, 0.00000000e+00, 0.98680000e+00},
    { 35,  6,  0,  2, 0.70035200e+02, 0.00000000e+00, 0.19985000e+01},
    { 35,  6,  0,  3, 0.65586800e+02, 0.00000000e+00, 0.29987000e+01},
    { 35,  6,  0,  4, 0.54682400e+02, 0.00000000e+00, 0.39844000e+01},
    { 35,  6,  1,  0, 0.90934300e+02, 0.99740000e+00, 0.00000000e+00},
    { 35,  6,  1,  1, 0.85326500e+02, 0.99740000e+00, 0.98680000e+00},
    { 35,  6,  1,  2, 0.70474400e+02, 0.99740000e+00, 0.19985000e+01},
    { 35,  6,  1,  3, 0.65996700e+02, 0.99740000e+00, 0.29987000e+01},
    { 35,  6,  1,  4, 0.55002900e+02, 0.99740000e+00, 0.39844000e+01},
    { 35,  7,  0,  0, 0.64763200e+02, 0.00000000e+00, 0.00000000e+00},
    { 35,  7,  0,  1, 0.60472800e+02, 0.00000000e+00, 0.99440000e+00},
    { 35,  7,  0,  2, 0.56918700e+02, 0.00000000e+00, 0.20143000e+01},
    { 35,  7,  0,  3, 0.50334400e+02, 0.00000000e+00, 0.29903000e+01},
    { 35,  7,  1,  0, 0.65154300e+02, 0.99740000e+00, 0.00000000e+00},
    { 35,  7,  1,  1, 0.60835900e+02, 0.99740000e+00, 0.99440000e+00},
    { 35,  7,  1,  2, 0.57257800e+02, 0.99740000e+00, 0.20143000e+01},
    { 35,  7,  1,  3, 0.50629800e+02, 0.99740000e+00, 0.29903000e+01},
    { 35,  8,  0,  0, 0.49879500e+02, 0.00000000e+00, 0.00000000e+00},
    { 35,  8,  0,  1, 0.44951000e+02, 0.00000000e+00, 0.99250000e+00},
    { 35,  8,  0,  2, 0.39882100e+02, 0.00000000e+00, 0.19887000e+01},
    { 35,  8,  1,  0, 0.50163200e+02, 0.99740000e+00, 0.00000000e+00},
    { 35,  8,  1,  1, 0.45201900e+02, 0.99740000e+00, 0.99250000e+00},
    { 35,  8,  1,  2, 0.40100200e+02, 0.99740000e+00, 0.19887000e+01},
    { 35,  9,  0,  0, 0.38322500e+02, 0.00000000e+00, 0.00000000e+00},
    { 35,  9,  0,  1, 0.31669900e+02, 0.00000000e+00, 0.99820000e+00},
    { 35,  9,  1,  0, 0.38529400e+02, 0.99740000e+00, 0.00000000e+00},
    { 35,  9,  1,  1, 0.31831300e+02, 0.99740000e+00, 0.99820000e+00},
    { 35, 10,  0,  0, 0.29795800e+02, 0.00000000e+00, 0.00000000e+00},
    { 35, 10,  1,  0, 0.29950100e+02, 0.99740000e+00, 0.00000000e+00},
    { 35, 11,  0,  0, 0.35428690e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 11,  0,  1, 0.15582020e+03, 0.00000000e+00, 0.96840000e+00},
    { 35, 11,  1,  0, 0.35772460e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 11,  1,  1, 0.15710050e+03, 0.99740000e+00, 0.96840000e+00},
    { 35, 12,  0,  0, 0.28827360e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 12,  0,  1, 0.24015650e+03, 0.00000000e+00, 0.96280000e+00},
    { 35, 12,  0,  2, 0.16322210e+03, 0.00000000e+00, 0.19496000e+01},
    { 35, 12,  1,  0, 0.29072760e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 12,  1,  1, 0.24214760e+03, 0.99740000e+00, 0.96280000e+00},
    { 35, 12,  1,  2, 0.16443830e+03, 0.99740000e+00, 0.19496000e+01},
    { 35, 13,  0,  0, 0.27200980e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 13,  0,  1, 0.24796920e+03, 0.00000000e+00, 0.96480000e+00},
    { 35, 13,  0,  2, 0.19697430e+03, 0.00000000e+00, 0.19311000e+01},
    { 35, 13,  0,  3, 0.15701910e+03, 0.00000000e+00, 0.29146000e+01},
    { 35, 13,  1,  0, 0.27418940e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 13,  1,  1, 0.24992480e+03, 0.99740000e+00, 0.96480000e+00},
    { 35, 13,  1,  2, 0.19844730e+03, 0.99740000e+00, 0.19311000e+01},
    { 35, 13,  1,  3, 0.15811820e+03, 0.99740000e+00, 0.29146000e+01},
    { 35, 14,  0,  0, 0.22105370e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 14,  0,  1, 0.20529760e+03, 0.00000000e+00, 0.95070000e+00},
    { 35, 14,  0,  2, 0.19179920e+03, 0.00000000e+00, 0.19435000e+01},
    { 35, 14,  0,  3, 0.18649270e+03, 0.00000000e+00, 0.29407000e+01},
    { 35, 14,  0,  4, 0.15647810e+03, 0.00000000e+00, 0.38677000e+01},
    { 35, 14,  1,  0, 0.22268120e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 14,  1,  1, 0.20678800e+03, 0.99740000e+00, 0.95070000e+00},
    { 35, 14,  1,  2, 0.19317380e+03, 0.99740000e+00, 0.19435000e+01},
    { 35, 14,  1,  3, 0.18783780e+03, 0.99740000e+00, 0.29407000e+01},
    { 35, 14,  1,  4, 0.15754230e+03, 0.99740000e+00, 0.38677000e+01},
    { 35, 15,  0,  0, 0.17699300e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 15,  0,  1, 0.17199100e+03, 0.00000000e+00, 0.99470000e+00},
    { 35, 15,  0,  2, 0.16943130e+03, 0.00000000e+00, 0.20102000e+01},
    { 35, 15,  0,  3, 0.15821040e+03, 0.00000000e+00, 0.29859000e+01},
    { 35, 15,  1,  0, 0.17819840e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 15,  1,  1, 0.17315820e+03, 0.99740000e+00, 0.99470000e+00},
    { 35, 15,  1,  2, 0.17058580e+03, 0.99740000e+00, 0.20102000e+01},
    { 35, 15,  1,  3, 0.15926660e+03, 0.99740000e+00, 0.29859000e+01},
    { 35, 16,  0,  0, 0.14945630e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 16,  0,  1, 0.14776790e+03, 0.00000000e+00, 0.99480000e+00},
    { 35, 16,  0,  2, 0.14483870e+03, 0.00000000e+00, 0.19903000e+01},
    { 35, 16,  1,  0, 0.15042030e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 16,  1,  1, 0.14872190e+03, 0.99740000e+00, 0.99480000e+00},
    { 35, 16,  1,  2, 0.14577240e+03, 0.99740000e+00, 0.19903000e+01},
    { 35, 17,  0,  0, 0.12409090e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 17,  0,  1, 0.12277630e+03, 0.00000000e+00, 0.99720000e+00},
    { 35, 17,  1,  0, 0.12484950e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 17,  1,  1, 0.12352740e+03, 0.99740000e+00, 0.99720000e+00},
    { 35, 18,  0,  0, 0.10294710e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 18,  1,  0, 0.10354670e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 19,  0,  0, 0.57723180e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 19,  0,  1, 0.21946470e+03, 0.00000000e+00, 0.97670000e+00},
    { 35, 19,  1,  0, 0.58289140e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 19,  1,  1, 0.22116420e+03, 0.99740000e+00, 0.97670000e+00},
    { 35, 20,  0,  0, 0.49597540e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 20,  0,  1, 0.39902260e+03, 0.00000000e+00, 0.98310000e+00},
    { 35, 20,  0,  2, 0.22931470e+03, 0.00000000e+00, 0.19349000e+01},
    { 35, 20,  1,  0, 0.50041520e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 20,  1,  1, 0.40253800e+03, 0.99740000e+00, 0.98310000e+00},
    { 35, 20,  1,  2, 0.23101070e+03, 0.99740000e+00, 0.19349000e+01},
    { 35, 21,  0,  0, 0.41374680e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 21,  0,  1, 0.22413750e+03, 0.00000000e+00, 0.18627000e+01},
    { 35, 21,  0,  2, 0.22292560e+03, 0.00000000e+00, 0.28999000e+01},
    { 35, 21,  1,  0, 0.41736480e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 21,  1,  1, 0.22577840e+03, 0.99740000e+00, 0.18627000e+01},
    { 35, 21,  1,  2, 0.22452090e+03, 0.99740000e+00, 0.28999000e+01},
    { 35, 22,  0,  0, 0.40365760e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 22,  0,  1, 0.21669210e+03, 0.00000000e+00, 0.18299000e+01},
    { 35, 22,  0,  2, 0.22588180e+03, 0.00000000e+00, 0.38675000e+01},
    { 35, 22,  1,  0, 0.40709700e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 22,  1,  1, 0.21827110e+03, 0.99740000e+00, 0.18299000e+01},
    { 35, 22,  1,  2, 0.22749370e+03, 0.99740000e+00, 0.38675000e+01},
    { 35, 23,  0,  0, 0.37180710e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 23,  0,  1, 0.21227920e+03, 0.00000000e+00, 0.19138000e+01},
    { 35, 23,  0,  2, 0.20672770e+03, 0.00000000e+00, 0.29110000e+01},
    { 35, 23,  1,  0, 0.37492830e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 23,  1,  1, 0.21382760e+03, 0.99740000e+00, 0.19138000e+01},
    { 35, 23,  1,  2, 0.20820220e+03, 0.99740000e+00, 0.29110000e+01},
    { 35, 24,  0,  0, 0.29391850e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 24,  0,  1, 0.20973930e+03, 0.00000000e+00, 0.18269000e+01},
    { 35, 24,  0,  2, 0.15887040e+03, 0.00000000e+00, 0.10619100e+02},
    { 35, 24,  1,  0, 0.29636070e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 24,  1,  1, 0.21128090e+03, 0.99740000e+00, 0.18269000e+01},
    { 35, 24,  1,  2, 0.15993620e+03, 0.99740000e+00, 0.10619100e+02},
    { 35, 25,  0,  0, 0.32284330e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 25,  0,  1, 0.19545360e+03, 0.00000000e+00, 0.16406000e+01},
    { 35, 25,  0,  2, 0.13754060e+03, 0.00000000e+00, 0.98849000e+01},
    { 35, 25,  1,  0, 0.32549450e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 25,  1,  1, 0.19683950e+03, 0.99740000e+00, 0.16406000e+01},
    { 35, 25,  1,  2, 0.13842960e+03, 0.99740000e+00, 0.98849000e+01},
    { 35, 26,  0,  0, 0.25453060e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 26,  0,  1, 0.18168360e+03, 0.00000000e+00, 0.16483000e+01},
    { 35, 26,  0,  2, 0.13480510e+03, 0.00000000e+00, 0.91376000e+01},
    { 35, 26,  1,  0, 0.25659390e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 26,  1,  1, 0.18295500e+03, 0.99740000e+00, 0.16483000e+01},
    { 35, 26,  1,  2, 0.13568060e+03, 0.99740000e+00, 0.91376000e+01},
    { 35, 27,  0,  0, 0.27230530e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 27,  0,  1, 0.17337930e+03, 0.00000000e+00, 0.17149000e+01},
    { 35, 27,  0,  2, 0.15501690e+03, 0.00000000e+00, 0.29263000e+01},
    { 35, 27,  0,  3, 0.13975410e+03, 0.00000000e+00, 0.77785000e+01},
    { 35, 27,  1,  0, 0.27446200e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 27,  1,  1, 0.17459100e+03, 0.99740000e+00, 0.17149000e+01},
    { 35, 27,  1,  2, 0.15608590e+03, 0.99740000e+00, 0.29263000e+01},
    { 35, 27,  1,  3, 0.14068120e+03, 0.99740000e+00, 0.77785000e+01},
    { 35, 28,  0,  0, 0.27877050e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 28,  0,  1, 0.16931330e+03, 0.00000000e+00, 0.17937000e+01},
    { 35, 28,  0,  2, 0.14518280e+03, 0.00000000e+00, 0.65458000e+01},
    { 35, 28,  0,  3, 0.15074260e+03, 0.00000000e+00, 0.62918000e+01},
    { 35, 28,  1,  0, 0.28101540e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 28,  1,  1, 0.17050040e+03, 0.99740000e+00, 0.17937000e+01},
    { 35, 28,  1,  2, 0.14616810e+03, 0.99740000e+00, 0.65458000e+01},
    { 35, 28,  1,  3, 0.15180060e+03, 0.99740000e+00, 0.62918000e+01},
    { 35, 29,  0,  0, 0.21450590e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 29,  0,  1, 0.16558600e+03, 0.00000000e+00, 0.95760000e+00},
    { 35, 29,  1,  0, 0.21621400e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 29,  1,  1, 0.16678160e+03, 0.99740000e+00, 0.95760000e+00},
    { 35, 30,  0,  0, 0.22363480e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 30,  0,  1, 0.15822130e+03, 0.00000000e+00, 0.19419000e+01},
    { 35, 30,  1,  0, 0.22534570e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 30,  1,  1, 0.15930490e+03, 0.99740000e+00, 0.19419000e+01},
    { 35, 31,  0,  0, 0.26334580e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 31,  0,  1, 0.24882110e+03, 0.00000000e+00, 0.96010000e+00},
    { 35, 31,  0,  2, 0.20127060e+03, 0.00000000e+00, 0.19315000e+01},
    { 35, 31,  0,  3, 0.16795000e+03, 0.00000000e+00, 0.29233000e+01},
    { 35, 31,  1,  0, 0.26539390e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 31,  1,  1, 0.25072470e+03, 0.99740000e+00, 0.96010000e+00},
    { 35, 31,  1,  2, 0.20272250e+03, 0.99740000e+00, 0.19315000e+01},
    { 35, 31,  1,  3, 0.16909250e+03, 0.99740000e+00, 0.29233000e+01},
    { 35, 32,  0,  0, 0.23762950e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 32,  0,  1, 0.22357440e+03, 0.00000000e+00, 0.94340000e+00},
    { 35, 32,  0,  2, 0.21366510e+03, 0.00000000e+00, 0.19447000e+01},
    { 35, 32,  0,  3, 0.19325910e+03, 0.00000000e+00, 0.29186000e+01},
    { 35, 32,  0,  4, 0.17258230e+03, 0.00000000e+00, 0.38972000e+01},
    { 35, 32,  1,  0, 0.23936360e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 32,  1,  1, 0.22517920e+03, 0.99740000e+00, 0.94340000e+00},
    { 35, 32,  1,  2, 0.21518160e+03, 0.99740000e+00, 0.19447000e+01},
    { 35, 32,  1,  3, 0.19459280e+03, 0.99740000e+00, 0.29186000e+01},
    { 35, 32,  1,  4, 0.17373160e+03, 0.99740000e+00, 0.38972000e+01},
    { 35, 33,  0,  0, 0.20707720e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 33,  0,  1, 0.20384000e+03, 0.00000000e+00, 0.98890000e+00},
    { 35, 33,  0,  2, 0.19893080e+03, 0.00000000e+00, 0.19793000e+01},
    { 35, 33,  0,  3, 0.19224210e+03, 0.00000000e+00, 0.29709000e+01},
    { 35, 33,  1,  0, 0.20849570e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 33,  1,  1, 0.20523050e+03, 0.99740000e+00, 0.98890000e+00},
    { 35, 33,  1,  2, 0.20027860e+03, 0.99740000e+00, 0.19793000e+01},
    { 35, 33,  1,  3, 0.19353150e+03, 0.99740000e+00, 0.29709000e+01},
    { 35, 34,  0,  0, 0.18836050e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 34,  0,  1, 0.18840310e+03, 0.00000000e+00, 0.99010000e+00},
    { 35, 34,  0,  2, 0.18699940e+03, 0.00000000e+00, 0.19812000e+01},
    { 35, 34,  1,  0, 0.18959740e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 34,  1,  1, 0.18964080e+03, 0.99740000e+00, 0.99010000e+00},
    { 35, 34,  1,  2, 0.18822630e+03, 0.99740000e+00, 0.19812000e+01},
    { 35, 35,  0,  0, 0.16712970e+03, 0.00000000e+00, 0.00000000e+00},
    { 35, 35,  1,  0, 0.16817910e+03, 0.99740000e+00, 0.00000000e+00},
    { 35, 35,  1,  1, 0.16923750e+03, 0.99740000e+00, 0.99740000e+00},
    { 36,  1,  0,  0, 0.19818200e+02, 0.00000000e+00, 0.91180000e+00},
    { 36,  1,  0,  1, 0.30726100e+02, 0.00000000e+00, 0.00000000e+00},
    { 36,  2,  0,  0, 0.13921100e+02, 0.00000000e+00, 0.00000000e+00},
    { 36,  3,  0,  0, 0.24455540e+03, 0.00000000e+00, 0.00000000e+00},
    { 36,  3,  0,  1, 0.91333300e+02, 0.00000000e+00, 0.98650000e+00},
    { 36,  4,  0,  0, 0.15556160e+03, 0.00000000e+00, 0.00000000e+00},
    { 36,  4,  0,  1, 0.11812400e+03, 0.00000000e+00, 0.98080000e+00},
    { 36,  4,  0,  2, 0.81330600e+02, 0.00000000e+00, 0.19697000e+01},
    { 36,  5,  0,  0, 0.11153710e+03, 0.00000000e+00, 0.00000000e+00},
    { 36,  5,  0,  1, 0.95176300e+02, 0.00000000e+00, 0.97060000e+00},
    { 36,  5,  0,  2, 0.81051800e+02, 0.00000000e+00, 0.19441000e+01},
    { 36,  5,  0,  3, 0.63676800e+02, 0.00000000e+00, 0.29128000e+01},
    { 36,  5,  0,  4, 0.60254400e+02, 0.00000000e+00, 0.45856000e+01},
    { 36,  6,  0,  0, 0.79108000e+02, 0.00000000e+00, 0.00000000e+00},
    { 36,  6,  0,  1, 0.74286500e+02, 0.00000000e+00, 0.98680000e+00},
    { 36,  6,  0,  2, 0.61725400e+02, 0.00000000e+00, 0.19985000e+01},
    { 36,  6,  0,  3, 0.57866500e+02, 0.00000000e+00, 0.29987000e+01},
    { 36,  6,  0,  4, 0.48650000e+02, 0.00000000e+00, 0.39844000e+01},
    { 36,  7,  0,  0, 0.57389500e+02, 0.00000000e+00, 0.00000000e+00},
    { 36,  7,  0,  1, 0.53649600e+02, 0.00000000e+00, 0.99440000e+00},
    { 36,  7,  0,  2, 0.50574600e+02, 0.00000000e+00, 0.20143000e+01},
    { 36,  7,  0,  3, 0.44854600e+02, 0.00000000e+00, 0.29903000e+01},
    { 36,  8,  0,  0, 0.44600300e+02, 0.00000000e+00, 0.00000000e+00},
    { 36,  8,  0,  1, 0.40304300e+02, 0.00000000e+00, 0.99250000e+00},
    { 36,  8,  0,  2, 0.35896100e+02, 0.00000000e+00, 0.19887000e+01},
    { 36,  9,  0,  0, 0.34545200e+02, 0.00000000e+00, 0.00000000e+00},
    { 36,  9,  0,  1, 0.28780000e+02, 0.00000000e+00, 0.99820000e+00},
    { 36, 10,  0,  0, 0.27043000e+02, 0.00000000e+00, 0.00000000e+00},
    { 36, 11,  0,  0, 0.29455740e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 11,  0,  1, 0.13243480e+03, 0.00000000e+00, 0.96840000e+00},
    { 36, 12,  0,  0, 0.24359650e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 12,  0,  1, 0.20374730e+03, 0.00000000e+00, 0.96280000e+00},
    { 36, 12,  0,  2, 0.14036050e+03, 0.00000000e+00, 0.19496000e+01},
    { 36, 13,  0,  0, 0.23169040e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 13,  0,  1, 0.21169490e+03, 0.00000000e+00, 0.96480000e+00},
    { 36, 13,  0,  2, 0.16935470e+03, 0.00000000e+00, 0.19311000e+01},
    { 36, 13,  0,  3, 0.13612380e+03, 0.00000000e+00, 0.29146000e+01},
    { 36, 14,  0,  0, 0.19039340e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 14,  0,  1, 0.17718110e+03, 0.00000000e+00, 0.95070000e+00},
    { 36, 14,  0,  2, 0.16582300e+03, 0.00000000e+00, 0.19435000e+01},
    { 36, 14,  0,  3, 0.16117030e+03, 0.00000000e+00, 0.29407000e+01},
    { 36, 14,  0,  4, 0.13621020e+03, 0.00000000e+00, 0.38677000e+01},
    { 36, 15,  0,  0, 0.15405750e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 15,  0,  1, 0.14979330e+03, 0.00000000e+00, 0.99470000e+00},
    { 36, 15,  0,  2, 0.14751930e+03, 0.00000000e+00, 0.20102000e+01},
    { 36, 15,  0,  3, 0.13810760e+03, 0.00000000e+00, 0.29859000e+01},
    { 36, 16,  0,  0, 0.13109280e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 16,  0,  1, 0.12961230e+03, 0.00000000e+00, 0.99480000e+00},
    { 36, 16,  0,  2, 0.12707910e+03, 0.00000000e+00, 0.19903000e+01},
    { 36, 17,  0,  0, 0.10968390e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 17,  0,  1, 0.10852260e+03, 0.00000000e+00, 0.99720000e+00},
    { 36, 18,  0,  0, 0.91643000e+02, 0.00000000e+00, 0.00000000e+00},
    { 36, 19,  0,  0, 0.48024720e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 19,  0,  1, 0.18848190e+03, 0.00000000e+00, 0.97670000e+00},
    { 36, 20,  0,  0, 0.41697770e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 20,  0,  1, 0.33664830e+03, 0.00000000e+00, 0.98310000e+00},
    { 36, 20,  0,  2, 0.19776450e+03, 0.00000000e+00, 0.19349000e+01},
    { 36, 21,  0,  0, 0.34884740e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 21,  0,  1, 0.19358680e+03, 0.00000000e+00, 0.18627000e+01},
    { 36, 21,  0,  2, 0.19302240e+03, 0.00000000e+00, 0.28999000e+01},
    { 36, 22,  0,  0, 0.34162730e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 22,  0,  1, 0.18732310e+03, 0.00000000e+00, 0.18299000e+01},
    { 36, 22,  0,  2, 0.19566660e+03, 0.00000000e+00, 0.38675000e+01},
    { 36, 23,  0,  0, 0.31532510e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 23,  0,  1, 0.18351710e+03, 0.00000000e+00, 0.19138000e+01},
    { 36, 23,  0,  2, 0.17919650e+03, 0.00000000e+00, 0.29110000e+01},
    { 36, 24,  0,  0, 0.24994130e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 24,  0,  1, 0.18118190e+03, 0.00000000e+00, 0.18269000e+01},
    { 36, 24,  0,  2, 0.13897880e+03, 0.00000000e+00, 0.10619100e+02},
    { 36, 25,  0,  0, 0.27464190e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 25,  0,  1, 0.16950970e+03, 0.00000000e+00, 0.16406000e+01},
    { 36, 25,  0,  2, 0.12092190e+03, 0.00000000e+00, 0.98849000e+01},
    { 36, 26,  0,  0, 0.21720710e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 26,  0,  1, 0.15786610e+03, 0.00000000e+00, 0.16483000e+01},
    { 36, 26,  0,  2, 0.11845780e+03, 0.00000000e+00, 0.91376000e+01},
    { 36, 27,  0,  0, 0.23275940e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 27,  0,  1, 0.15071900e+03, 0.00000000e+00, 0.17149000e+01},
    { 36, 27,  0,  2, 0.13511470e+03, 0.00000000e+00, 0.29263000e+01},
    { 36, 27,  0,  3, 0.12245360e+03, 0.00000000e+00, 0.77785000e+01},
    { 36, 28,  0,  0, 0.23774470e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 28,  0,  1, 0.14714170e+03, 0.00000000e+00, 0.17937000e+01},
    { 36, 28,  0,  2, 0.12680940e+03, 0.00000000e+00, 0.65458000e+01},
    { 36, 28,  0,  3, 0.13116000e+03, 0.00000000e+00, 0.62918000e+01},
    { 36, 29,  0,  0, 0.18353470e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 29,  0,  1, 0.14345250e+03, 0.00000000e+00, 0.95760000e+00},
    { 36, 30,  0,  0, 0.19204840e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 30,  0,  1, 0.13785900e+03, 0.00000000e+00, 0.19419000e+01},
    { 36, 31,  0,  0, 0.22545370e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 31,  0,  1, 0.21348210e+03, 0.00000000e+00, 0.96010000e+00},
    { 36, 31,  0,  2, 0.17402300e+03, 0.00000000e+00, 0.19315000e+01},
    { 36, 31,  0,  3, 0.14629100e+03, 0.00000000e+00, 0.29233000e+01},
    { 36, 32,  0,  0, 0.20505980e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 32,  0,  1, 0.19336340e+03, 0.00000000e+00, 0.94340000e+00},
    { 36, 32,  0,  2, 0.18507510e+03, 0.00000000e+00, 0.19447000e+01},
    { 36, 32,  0,  3, 0.16801940e+03, 0.00000000e+00, 0.29186000e+01},
    { 36, 32,  0,  4, 0.15072600e+03, 0.00000000e+00, 0.38972000e+01},
    { 36, 33,  0,  0, 0.18018180e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 33,  0,  1, 0.17747160e+03, 0.00000000e+00, 0.98890000e+00},
    { 36, 33,  0,  2, 0.17335820e+03, 0.00000000e+00, 0.19793000e+01},
    { 36, 33,  0,  3, 0.16775050e+03, 0.00000000e+00, 0.29709000e+01},
    { 36, 34,  0,  0, 0.16484940e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 34,  0,  1, 0.16488330e+03, 0.00000000e+00, 0.99010000e+00},
    { 36, 34,  0,  2, 0.16369060e+03, 0.00000000e+00, 0.19812000e+01},
    { 36, 35,  0,  0, 0.14718300e+03, 0.00000000e+00, 0.00000000e+00},
    { 36, 35,  0,  1, 0.14806890e+03, 0.00000000e+00, 0.99740000e+00},
    { 36, 36,  0,  0, 0.13040170e+03, 0.00000000e+00, 0.00000000e+00},
    { 37,  1,  0,  0, 0.85949900e+02, 0.00000000e+00, 0.91180000e+00},
    { 37,  1,  0,  1, 0.15093400e+03, 0.00000000e+00, 0.00000000e+00},
    { 37,  1,  1,  0, 0.35196300e+02, 0.97380000e+00, 0.91180000e+00},
    { 37,  1,  1,  1, 0.57903900e+02, 0.97380000e+00, 0.00000000e+00},
    { 37,  2,  0,  0, 0.50049100e+02, 0.00000000e+00, 0.00000000e+00},
    { 37,  2,  1,  0, 0.22623100e+02, 0.97380000e+00, 0.00000000e+00},
    { 37,  3,  0,  0, 0.26473331e+04, 0.00000000e+00, 0.00000000e+00},
    { 37,  3,  0,  1, 0.61856810e+03, 0.00000000e+00, 0.98650000e+00},
    { 37,  3,  1,  0, 0.65740760e+03, 0.97380000e+00, 0.00000000e+00},
    { 37,  3,  1,  1, 0.19967710e+03, 0.97380000e+00, 0.98650000e+00},
    { 37,  4,  0,  0, 0.10827052e+04, 0.00000000e+00, 0.00000000e+00},
    { 37,  4,  0,  1, 0.77496560e+03, 0.00000000e+00, 0.98080000e+00},
    { 37,  4,  0,  2, 0.42517040e+03, 0.00000000e+00, 0.19697000e+01},
    { 37,  4,  1,  0, 0.34543780e+03, 0.97380000e+00, 0.00000000e+00},
    { 37,  4,  1,  1, 0.25295740e+03, 0.97380000e+00, 0.98080000e+00},
    { 37,  4,  1,  2, 0.15794790e+03, 0.97380000e+00, 0.19697000e+01},
    { 37,  5,  0,  0, 0.62008780e+03, 0.00000000e+00, 0.00000000e+00},
    { 37,  5,  0,  1, 0.50694210e+03, 0.00000000e+00, 0.97060000e+00},
    { 37,  5,  0,  2, 0.41522010e+03, 0.00000000e+00, 0.19441000e+01},
    { 37,  5,  0,  3, 0.28624860e+03, 0.00000000e+00, 0.29128000e+01},
    { 37,  5,  0,  4, 0.26610180e+03, 0.00000000e+00, 0.45856000e+01},
    { 37,  5,  1,  0, 0.22250810e+03, 0.97380000e+00, 0.00000000e+00},
    { 37,  5,  1,  1, 0.18572060e+03, 0.97380000e+00, 0.97060000e+00},
    { 37,  5,  1,  2, 0.15478270e+03, 0.97380000e+00, 0.19441000e+01},
    { 37,  5,  1,  3, 0.11497210e+03, 0.97380000e+00, 0.29128000e+01},
    { 37,  5,  1,  4, 0.10786680e+03, 0.97380000e+00, 0.45856000e+01},
    { 37,  6,  0,  0, 0.37353840e+03, 0.00000000e+00, 0.00000000e+00},
    { 37,  6,  0,  1, 0.35363020e+03, 0.00000000e+00, 0.98680000e+00},
    { 37,  6,  0,  2, 0.27337570e+03, 0.00000000e+00, 0.19985000e+01},
    { 37,  6,  0,  3, 0.25651980e+03, 0.00000000e+00, 0.29987000e+01},
    { 37,  6,  0,  4, 0.19559960e+03, 0.00000000e+00, 0.39844000e+01},
    { 37,  6,  1,  0, 0.14599740e+03, 0.97380000e+00, 0.00000000e+00},
    { 37,  6,  1,  1, 0.13721250e+03, 0.97380000e+00, 0.98680000e+00},
    { 37,  6,  1,  2, 0.11048560e+03, 0.97380000e+00, 0.19985000e+01},
    { 37,  6,  1,  3, 0.10345590e+03, 0.97380000e+00, 0.29987000e+01},
    { 37,  6,  1,  4, 0.83241800e+02, 0.97380000e+00, 0.39844000e+01},
    { 37,  7,  0,  0, 0.24069400e+03, 0.00000000e+00, 0.00000000e+00},
    { 37,  7,  0,  1, 0.22519190e+03, 0.00000000e+00, 0.99440000e+00},
    { 37,  7,  0,  2, 0.20923780e+03, 0.00000000e+00, 0.20143000e+01},
    { 37,  7,  0,  3, 0.18314860e+03, 0.00000000e+00, 0.29903000e+01},
    { 37,  7,  1,  0, 0.10014180e+03, 0.97380000e+00, 0.00000000e+00},
    { 37,  7,  1,  1, 0.93458400e+02, 0.97380000e+00, 0.99440000e+00},
    { 37,  7,  1,  2, 0.87544700e+02, 0.97380000e+00, 0.20143000e+01},
    { 37,  7,  1,  3, 0.77004000e+02, 0.97380000e+00, 0.29903000e+01},
    { 37,  8,  0,  0, 0.17233980e+03, 0.00000000e+00, 0.00000000e+00},
    { 37,  8,  0,  1, 0.15267570e+03, 0.00000000e+00, 0.99250000e+00},
    { 37,  8,  0,  2, 0.13248790e+03, 0.00000000e+00, 0.19887000e+01},
    { 37,  8,  1,  0, 0.74886800e+02, 0.97380000e+00, 0.00000000e+00},
    { 37,  8,  1,  1, 0.67004500e+02, 0.97380000e+00, 0.99250000e+00},
    { 37,  8,  1,  2, 0.58901500e+02, 0.97380000e+00, 0.19887000e+01},
    { 37,  9,  0,  0, 0.12458790e+03, 0.00000000e+00, 0.00000000e+00},
    { 37,  9,  0,  1, 0.96223500e+02, 0.00000000e+00, 0.99820000e+00},
    { 37,  9,  1,  0, 0.56177900e+02, 0.97380000e+00, 0.00000000e+00},
    { 37,  9,  1,  1, 0.45248900e+02, 0.97380000e+00, 0.99820000e+00},
    { 37, 10,  0,  0, 0.92382700e+02, 0.00000000e+00, 0.00000000e+00},
    { 37, 10,  1,  0, 0.42895700e+02, 0.97380000e+00, 0.00000000e+00},
    { 37, 11,  0,  0, 0.31041016e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 11,  0,  1, 0.93630060e+03, 0.00000000e+00, 0.96840000e+00},
    { 37, 11,  1,  0, 0.78185270e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 11,  1,  1, 0.29467950e+03, 0.97380000e+00, 0.96840000e+00},
    { 37, 12,  0,  0, 0.18264648e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 12,  0,  1, 0.14776556e+04, 0.00000000e+00, 0.96280000e+00},
    { 37, 12,  0,  2, 0.80885370e+03, 0.00000000e+00, 0.19496000e+01},
    { 37, 12,  1,  0, 0.55913370e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 12,  1,  1, 0.45778310e+03, 0.97380000e+00, 0.96280000e+00},
    { 37, 12,  1,  2, 0.28542190e+03, 0.97380000e+00, 0.19496000e+01},
    { 37, 13,  0,  0, 0.15469229e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 13,  0,  1, 0.13752558e+04, 0.00000000e+00, 0.96480000e+00},
    { 37, 13,  0,  2, 0.99974000e+03, 0.00000000e+00, 0.19311000e+01},
    { 37, 13,  0,  3, 0.70496090e+03, 0.00000000e+00, 0.29146000e+01},
    { 37, 13,  1,  0, 0.50299330e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 13,  1,  1, 0.45336360e+03, 0.97380000e+00, 0.96480000e+00},
    { 37, 13,  1,  2, 0.34649590e+03, 0.97380000e+00, 0.19311000e+01},
    { 37, 13,  1,  3, 0.26324390e+03, 0.97380000e+00, 0.29146000e+01},
    { 37, 14,  0,  0, 0.10820563e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 14,  0,  1, 0.98604380e+03, 0.00000000e+00, 0.95070000e+00},
    { 37, 14,  0,  2, 0.90177390e+03, 0.00000000e+00, 0.19435000e+01},
    { 37, 14,  0,  3, 0.89400720e+03, 0.00000000e+00, 0.29407000e+01},
    { 37, 14,  0,  4, 0.67586350e+03, 0.00000000e+00, 0.38677000e+01},
    { 37, 14,  1,  0, 0.38390840e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 14,  1,  1, 0.35341420e+03, 0.97380000e+00, 0.95070000e+00},
    { 37, 14,  1,  2, 0.32730800e+03, 0.97380000e+00, 0.19435000e+01},
    { 37, 14,  1,  3, 0.32026650e+03, 0.97380000e+00, 0.29407000e+01},
    { 37, 14,  1,  4, 0.25790200e+03, 0.97380000e+00, 0.38677000e+01},
    { 37, 15,  0,  0, 0.76813350e+03, 0.00000000e+00, 0.00000000e+00},
    { 37, 15,  0,  1, 0.74424750e+03, 0.00000000e+00, 0.99470000e+00},
    { 37, 15,  0,  2, 0.73972690e+03, 0.00000000e+00, 0.20102000e+01},
    { 37, 15,  0,  3, 0.66844010e+03, 0.00000000e+00, 0.29859000e+01},
    { 37, 15,  1,  0, 0.29216040e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 15,  1,  1, 0.28343680e+03, 0.97380000e+00, 0.99470000e+00},
    { 37, 15,  1,  2, 0.28011830e+03, 0.97380000e+00, 0.20102000e+01},
    { 37, 15,  1,  3, 0.25815200e+03, 0.97380000e+00, 0.29859000e+01},
    { 37, 16,  0,  0, 0.60222210e+03, 0.00000000e+00, 0.00000000e+00},
    { 37, 16,  0,  1, 0.59687630e+03, 0.00000000e+00, 0.99480000e+00},
    { 37, 16,  0,  2, 0.58437840e+03, 0.00000000e+00, 0.19903000e+01},
    { 37, 16,  1,  0, 0.23905720e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 16,  1,  1, 0.23654670e+03, 0.97380000e+00, 0.99480000e+00},
    { 37, 16,  1,  2, 0.23172650e+03, 0.97380000e+00, 0.19903000e+01},
    { 37, 17,  0,  0, 0.46615650e+03, 0.00000000e+00, 0.00000000e+00},
    { 37, 17,  0,  1, 0.46202520e+03, 0.00000000e+00, 0.99720000e+00},
    { 37, 17,  1,  0, 0.19278770e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 17,  1,  1, 0.19086020e+03, 0.97380000e+00, 0.99720000e+00},
    { 37, 18,  0,  0, 0.36440670e+03, 0.00000000e+00, 0.00000000e+00},
    { 37, 18,  1,  0, 0.15610100e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 19,  0,  0, 0.55302806e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 19,  0,  1, 0.12408631e+04, 0.00000000e+00, 0.97670000e+00},
    { 37, 19,  1,  0, 0.13058840e+04, 0.97380000e+00, 0.00000000e+00},
    { 37, 19,  1,  1, 0.40103710e+03, 0.97380000e+00, 0.97670000e+00},
    { 37, 20,  0,  0, 0.35994349e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 20,  0,  1, 0.29580410e+04, 0.00000000e+00, 0.98310000e+00},
    { 37, 20,  0,  2, 0.11520197e+04, 0.00000000e+00, 0.19349000e+01},
    { 37, 20,  1,  0, 0.10130706e+04, 0.97380000e+00, 0.00000000e+00},
    { 37, 20,  1,  1, 0.81234890e+03, 0.97380000e+00, 0.98310000e+00},
    { 37, 20,  1,  2, 0.40165720e+03, 0.97380000e+00, 0.19349000e+01},
    { 37, 21,  0,  0, 0.28340920e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 21,  0,  1, 0.11054608e+04, 0.00000000e+00, 0.18627000e+01},
    { 37, 21,  0,  2, 0.10561444e+04, 0.00000000e+00, 0.28999000e+01},
    { 37, 21,  1,  0, 0.82610410e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 21,  1,  1, 0.38990570e+03, 0.97380000e+00, 0.18627000e+01},
    { 37, 21,  1,  2, 0.38121510e+03, 0.97380000e+00, 0.28999000e+01},
    { 37, 22,  0,  0, 0.26412435e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 22,  0,  1, 0.10741973e+04, 0.00000000e+00, 0.18299000e+01},
    { 37, 22,  0,  2, 0.10654841e+04, 0.00000000e+00, 0.38675000e+01},
    { 37, 22,  1,  0, 0.78941170e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 22,  1,  1, 0.37639190e+03, 0.97380000e+00, 0.18299000e+01},
    { 37, 22,  1,  2, 0.38558300e+03, 0.97380000e+00, 0.38675000e+01},
    { 37, 23,  0,  0, 0.23637175e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 23,  0,  1, 0.10535834e+04, 0.00000000e+00, 0.19138000e+01},
    { 37, 23,  0,  2, 0.98495040e+03, 0.00000000e+00, 0.29110000e+01},
    { 37, 23,  1,  0, 0.71821250e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 23,  1,  1, 0.36906490e+03, 0.97380000e+00, 0.19138000e+01},
    { 37, 23,  1,  2, 0.35359290e+03, 0.97380000e+00, 0.29110000e+01},
    { 37, 24,  0,  0, 0.18740326e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 24,  0,  1, 0.10575718e+04, 0.00000000e+00, 0.18269000e+01},
    { 37, 24,  0,  2, 0.69273590e+03, 0.00000000e+00, 0.10619100e+02},
    { 37, 24,  1,  0, 0.56618560e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 24,  1,  1, 0.36686860e+03, 0.97380000e+00, 0.18269000e+01},
    { 37, 24,  1,  2, 0.26178690e+03, 0.97380000e+00, 0.10619100e+02},
    { 37, 25,  0,  0, 0.19687631e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 25,  0,  1, 0.91194330e+03, 0.00000000e+00, 0.16406000e+01},
    { 37, 25,  0,  2, 0.56671690e+03, 0.00000000e+00, 0.98849000e+01},
    { 37, 25,  1,  0, 0.61264440e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 25,  1,  1, 0.33222150e+03, 0.97380000e+00, 0.16406000e+01},
    { 37, 25,  1,  2, 0.22151020e+03, 0.97380000e+00, 0.98849000e+01},
    { 37, 26,  0,  0, 0.15471982e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 26,  0,  1, 0.83179600e+03, 0.00000000e+00, 0.16483000e+01},
    { 37, 26,  0,  2, 0.55921770e+03, 0.00000000e+00, 0.91376000e+01},
    { 37, 26,  1,  0, 0.48062360e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 26,  1,  1, 0.30627200e+03, 0.97380000e+00, 0.16483000e+01},
    { 37, 26,  1,  2, 0.21771950e+03, 0.97380000e+00, 0.91376000e+01},
    { 37, 27,  0,  0, 0.15418997e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 27,  0,  1, 0.79588590e+03, 0.00000000e+00, 0.17149000e+01},
    { 37, 27,  0,  2, 0.70427300e+03, 0.00000000e+00, 0.29263000e+01},
    { 37, 27,  0,  3, 0.59683060e+03, 0.00000000e+00, 0.77785000e+01},
    { 37, 27,  1,  0, 0.50159400e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 27,  1,  1, 0.29229920e+03, 0.97380000e+00, 0.17149000e+01},
    { 37, 27,  1,  2, 0.25980390e+03, 0.97380000e+00, 0.29263000e+01},
    { 37, 27,  1,  3, 0.22851060e+03, 0.97380000e+00, 0.77785000e+01},
    { 37, 28,  0,  0, 0.16251034e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 28,  0,  1, 0.78184410e+03, 0.00000000e+00, 0.17937000e+01},
    { 37, 28,  0,  2, 0.64057820e+03, 0.00000000e+00, 0.65458000e+01},
    { 37, 28,  0,  3, 0.70593280e+03, 0.00000000e+00, 0.62918000e+01},
    { 37, 28,  1,  0, 0.51998260e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 28,  1,  1, 0.28612410e+03, 0.97380000e+00, 0.17937000e+01},
    { 37, 28,  1,  2, 0.24066290e+03, 0.97380000e+00, 0.65458000e+01},
    { 37, 28,  1,  3, 0.25585120e+03, 0.97380000e+00, 0.62918000e+01},
    { 37, 29,  0,  0, 0.12594427e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 29,  0,  1, 0.80787860e+03, 0.00000000e+00, 0.95760000e+00},
    { 37, 29,  1,  0, 0.39935340e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 29,  1,  1, 0.28601310e+03, 0.97380000e+00, 0.95760000e+00},
    { 37, 30,  0,  0, 0.11862631e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 30,  0,  1, 0.69720120e+03, 0.00000000e+00, 0.19419000e+01},
    { 37, 30,  1,  0, 0.40105480e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 30,  1,  1, 0.26273320e+03, 0.97380000e+00, 0.19419000e+01},
    { 37, 31,  0,  0, 0.14423807e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 31,  0,  1, 0.13227322e+04, 0.00000000e+00, 0.96010000e+00},
    { 37, 31,  0,  2, 0.96816820e+03, 0.00000000e+00, 0.19315000e+01},
    { 37, 31,  0,  3, 0.72799780e+03, 0.00000000e+00, 0.29233000e+01},
    { 37, 31,  1,  0, 0.47797370e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 31,  1,  1, 0.44607980e+03, 0.97380000e+00, 0.96010000e+00},
    { 37, 31,  1,  2, 0.34599210e+03, 0.97380000e+00, 0.19315000e+01},
    { 37, 31,  1,  3, 0.27717010e+03, 0.97380000e+00, 0.29233000e+01},
    { 37, 32,  0,  0, 0.11551526e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 32,  0,  1, 0.10596044e+04, 0.00000000e+00, 0.94340000e+00},
    { 37, 32,  0,  2, 0.99420460e+03, 0.00000000e+00, 0.19447000e+01},
    { 37, 32,  0,  3, 0.85965830e+03, 0.00000000e+00, 0.29186000e+01},
    { 37, 32,  0,  4, 0.72493940e+03, 0.00000000e+00, 0.38972000e+01},
    { 37, 32,  1,  0, 0.41103890e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 32,  1,  1, 0.38250120e+03, 0.97380000e+00, 0.94340000e+00},
    { 37, 32,  1,  2, 0.36280200e+03, 0.97380000e+00, 0.19447000e+01},
    { 37, 32,  1,  3, 0.32210960e+03, 0.97380000e+00, 0.29186000e+01},
    { 37, 32,  1,  4, 0.28107340e+03, 0.97380000e+00, 0.38972000e+01},
    { 37, 33,  0,  0, 0.90942570e+03, 0.00000000e+00, 0.00000000e+00},
    { 37, 33,  0,  1, 0.89049310e+03, 0.00000000e+00, 0.98890000e+00},
    { 37, 33,  0,  2, 0.86036720e+03, 0.00000000e+00, 0.19793000e+01},
    { 37, 33,  0,  3, 0.81822470e+03, 0.00000000e+00, 0.29709000e+01},
    { 37, 33,  1,  0, 0.34339780e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 33,  1,  1, 0.33721600e+03, 0.97380000e+00, 0.98890000e+00},
    { 37, 33,  1,  2, 0.32770320e+03, 0.97380000e+00, 0.19793000e+01},
    { 37, 33,  1,  3, 0.31465180e+03, 0.97380000e+00, 0.29709000e+01},
    { 37, 34,  0,  0, 0.77892040e+03, 0.00000000e+00, 0.00000000e+00},
    { 37, 34,  0,  1, 0.78009860e+03, 0.00000000e+00, 0.99010000e+00},
    { 37, 34,  0,  2, 0.77312550e+03, 0.00000000e+00, 0.19812000e+01},
    { 37, 34,  1,  0, 0.30453120e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 34,  1,  1, 0.30472790e+03, 0.97380000e+00, 0.99010000e+00},
    { 37, 34,  1,  2, 0.30225300e+03, 0.97380000e+00, 0.19812000e+01},
    { 37, 35,  0,  0, 0.65036060e+03, 0.00000000e+00, 0.00000000e+00},
    { 37, 35,  0,  1, 0.65665740e+03, 0.00000000e+00, 0.99740000e+00},
    { 37, 35,  1,  0, 0.26345920e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 35,  1,  1, 0.26546470e+03, 0.97380000e+00, 0.99740000e+00},
    { 37, 36,  0,  0, 0.54231600e+03, 0.00000000e+00, 0.00000000e+00},
    { 37, 36,  1,  0, 0.22685900e+03, 0.97380000e+00, 0.00000000e+00},
    { 37, 37,  0,  0, 0.61387755e+04, 0.00000000e+00, 0.00000000e+00},
    { 37, 37,  1,  0, 0.14577817e+04, 0.97380000e+00, 0.00000000e+00},
    { 37, 37,  1,  1, 0.47625910e+03, 0.97380000e+00, 0.97380000e+00},
    { 38,  1,  0,  0, 0.78390100e+02, 0.00000000e+00, 0.91180000e+00},
    { 38,  1,  0,  1, 0.13506640e+03, 0.00000000e+00, 0.00000000e+00},
    { 38,  1,  1,  0, 0.64406500e+02, 0.98010000e+00, 0.91180000e+00},
    { 38,  1,  1,  1, 0.11032750e+03, 0.98010000e+00, 0.00000000e+00},
    { 38,  1,  2,  0, 0.36860600e+02, 0.19143000e+01, 0.91180000e+00},
    { 38,  1,  2,  1, 0.60189200e+02, 0.19143000e+01, 0.00000000e+00},
    { 38,  2,  0,  0, 0.46665800e+02, 0.00000000e+00, 0.00000000e+00},
    { 38,  2,  1,  0, 0.38833300e+02, 0.98010000e+00, 0.00000000e+00},
    { 38,  2,  2,  0, 0.23840100e+02, 0.19143000e+01, 0.00000000e+00},
    { 38,  3,  0,  0, 0.19442260e+04, 0.00000000e+00, 0.00000000e+00},
    { 38,  3,  0,  1, 0.51783930e+03, 0.00000000e+00, 0.98650000e+00},
    { 38,  3,  1,  0, 0.16182465e+04, 0.98010000e+00, 0.00000000e+00},
    { 38,  3,  1,  1, 0.42146100e+03, 0.98010000e+00, 0.98650000e+00},
    { 38,  3,  2,  0, 0.62823990e+03, 0.19143000e+01, 0.00000000e+00},
    { 38,  3,  2,  1, 0.20169000e+03, 0.19143000e+01, 0.98650000e+00},
    { 38,  4,  0,  0, 0.90392650e+03, 0.00000000e+00, 0.00000000e+00},
    { 38,  4,  0,  1, 0.64864220e+03, 0.00000000e+00, 0.98080000e+00},
    { 38,  4,  0,  2, 0.37664680e+03, 0.00000000e+00, 0.19697000e+01},
    { 38,  4,  1,  0, 0.73479260e+03, 0.98010000e+00, 0.00000000e+00},
    { 38,  4,  1,  1, 0.52954940e+03, 0.98010000e+00, 0.98080000e+00},
    { 38,  4,  1,  2, 0.30694330e+03, 0.98010000e+00, 0.19697000e+01},
    { 38,  4,  2,  0, 0.34816900e+03, 0.19143000e+01, 0.00000000e+00},
    { 38,  4,  2,  1, 0.25612950e+03, 0.19143000e+01, 0.98080000e+00},
    { 38,  4,  2,  2, 0.16346210e+03, 0.19143000e+01, 0.19697000e+01},
    { 38,  5,  0,  0, 0.54157290e+03, 0.00000000e+00, 0.00000000e+00},
    { 38,  5,  0,  1, 0.44526080e+03, 0.00000000e+00, 0.97060000e+00},
    { 38,  5,  0,  2, 0.36565710e+03, 0.00000000e+00, 0.19441000e+01},
    { 38,  5,  0,  3, 0.25952790e+03, 0.00000000e+00, 0.29128000e+01},
    { 38,  5,  0,  4, 0.24185040e+03, 0.00000000e+00, 0.45856000e+01},
    { 38,  5,  1,  0, 0.44112610e+03, 0.98010000e+00, 0.00000000e+00},
    { 38,  5,  1,  1, 0.36336070e+03, 0.98010000e+00, 0.97060000e+00},
    { 38,  5,  1,  2, 0.29929140e+03, 0.98010000e+00, 0.19441000e+01},
    { 38,  5,  1,  3, 0.21287590e+03, 0.98010000e+00, 0.29128000e+01},
    { 38,  5,  1,  4, 0.19856600e+03, 0.98010000e+00, 0.45856000e+01},
    { 38,  5,  2,  0, 0.22895120e+03, 0.19143000e+01, 0.00000000e+00},
    { 38,  5,  2,  1, 0.19164290e+03, 0.19143000e+01, 0.97060000e+00},
    { 38,  5,  2,  2, 0.16010980e+03, 0.19143000e+01, 0.19441000e+01},
    { 38,  5,  2,  3, 0.12013000e+03, 0.19143000e+01, 0.29128000e+01},
    { 38,  5,  2,  4, 0.11280930e+03, 0.19143000e+01, 0.45856000e+01},
    { 38,  6,  0,  0, 0.33545970e+03, 0.00000000e+00, 0.00000000e+00},
    { 38,  6,  0,  1, 0.31589230e+03, 0.00000000e+00, 0.98680000e+00},
    { 38,  6,  0,  2, 0.24782850e+03, 0.00000000e+00, 0.19985000e+01},
    { 38,  6,  0,  3, 0.23200320e+03, 0.00000000e+00, 0.29987000e+01},
    { 38,  6,  0,  4, 0.17983950e+03, 0.00000000e+00, 0.39844000e+01},
    { 38,  6,  1,  0, 0.27470310e+03, 0.98010000e+00, 0.00000000e+00},
    { 38,  6,  1,  1, 0.25898850e+03, 0.98010000e+00, 0.98680000e+00},
    { 38,  6,  1,  2, 0.20357060e+03, 0.98010000e+00, 0.19985000e+01},
    { 38,  6,  1,  3, 0.19069760e+03, 0.98010000e+00, 0.29987000e+01},
    { 38,  6,  1,  4, 0.14851410e+03, 0.98010000e+00, 0.39844000e+01},
    { 38,  6,  2,  0, 0.15197450e+03, 0.19143000e+01, 0.00000000e+00},
    { 38,  6,  2,  1, 0.14261130e+03, 0.19143000e+01, 0.98680000e+00},
    { 38,  6,  2,  2, 0.11541070e+03, 0.19143000e+01, 0.19985000e+01},
    { 38,  6,  2,  3, 0.10796880e+03, 0.19143000e+01, 0.29987000e+01},
    { 38,  6,  2,  4, 0.87389100e+02, 0.19143000e+01, 0.39844000e+01},
    { 38,  7,  0,  0, 0.21996080e+03, 0.00000000e+00, 0.00000000e+00},
    { 38,  7,  0,  1, 0.20515740e+03, 0.00000000e+00, 0.99440000e+00},
    { 38,  7,  0,  2, 0.19112680e+03, 0.00000000e+00, 0.20143000e+01},
    { 38,  7,  0,  3, 0.16708650e+03, 0.00000000e+00, 0.29903000e+01},
    { 38,  7,  1,  0, 0.18119730e+03, 0.98010000e+00, 0.00000000e+00},
    { 38,  7,  1,  1, 0.16917720e+03, 0.98010000e+00, 0.99440000e+00},
    { 38,  7,  1,  2, 0.15768360e+03, 0.98010000e+00, 0.20143000e+01},
    { 38,  7,  1,  3, 0.13809270e+03, 0.98010000e+00, 0.29903000e+01},
    { 38,  7,  2,  0, 0.10490040e+03, 0.19143000e+01, 0.00000000e+00},
    { 38,  7,  2,  1, 0.97808500e+02, 0.19143000e+01, 0.99440000e+00},
    { 38,  7,  2,  2, 0.91672500e+02, 0.19143000e+01, 0.20143000e+01},
    { 38,  7,  2,  3, 0.80586800e+02, 0.19143000e+01, 0.29903000e+01},
    { 38,  8,  0,  0, 0.15914600e+03, 0.00000000e+00, 0.00000000e+00},
    { 38,  8,  0,  1, 0.14115920e+03, 0.00000000e+00, 0.99250000e+00},
    { 38,  8,  0,  2, 0.12269280e+03, 0.00000000e+00, 0.19887000e+01},
    { 38,  8,  1,  0, 0.13178460e+03, 0.98010000e+00, 0.00000000e+00},
    { 38,  8,  1,  1, 0.11710180e+03, 0.98010000e+00, 0.99250000e+00},
    { 38,  8,  1,  2, 0.10201160e+03, 0.98010000e+00, 0.19887000e+01},
    { 38,  8,  2,  0, 0.78693300e+02, 0.19143000e+01, 0.00000000e+00},
    { 38,  8,  2,  1, 0.70428500e+02, 0.19143000e+01, 0.99250000e+00},
    { 38,  8,  2,  2, 0.61915900e+02, 0.19143000e+01, 0.19887000e+01},
    { 38,  9,  0,  0, 0.11596470e+03, 0.00000000e+00, 0.00000000e+00},
    { 38,  9,  0,  1, 0.90408100e+02, 0.00000000e+00, 0.99820000e+00},
    { 38,  9,  1,  0, 0.96508000e+02, 0.98010000e+00, 0.00000000e+00},
    { 38,  9,  1,  1, 0.75675800e+02, 0.98010000e+00, 0.99820000e+00},
    { 38,  9,  2,  0, 0.59141500e+02, 0.19143000e+01, 0.00000000e+00},
    { 38,  9,  2,  1, 0.47741100e+02, 0.19143000e+01, 0.99820000e+00},
    { 38, 10,  0,  0, 0.86462700e+02, 0.00000000e+00, 0.00000000e+00},
    { 38, 10,  1,  0, 0.72270300e+02, 0.98010000e+00, 0.00000000e+00},
    { 38, 10,  2,  0, 0.45194100e+02, 0.19143000e+01, 0.00000000e+00},
    { 38, 11,  0,  0, 0.22961906e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 11,  0,  1, 0.77398540e+03, 0.00000000e+00, 0.96840000e+00},
    { 38, 11,  1,  0, 0.19079592e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 11,  1,  1, 0.63083040e+03, 0.98010000e+00, 0.96840000e+00},
    { 38, 11,  2,  0, 0.74930050e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 11,  2,  1, 0.29600050e+03, 0.19143000e+01, 0.96840000e+00},
    { 38, 12,  0,  0, 0.14958141e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 12,  0,  1, 0.12109593e+04, 0.00000000e+00, 0.96280000e+00},
    { 38, 12,  0,  2, 0.70339060e+03, 0.00000000e+00, 0.19496000e+01},
    { 38, 12,  1,  0, 0.12181274e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 12,  1,  1, 0.98878570e+03, 0.98010000e+00, 0.96280000e+00},
    { 38, 12,  1,  2, 0.57194480e+03, 0.98010000e+00, 0.19496000e+01},
    { 38, 12,  2,  0, 0.55878190e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 12,  2,  1, 0.45880010e+03, 0.19143000e+01, 0.96280000e+00},
    { 38, 12,  2,  2, 0.29291740e+03, 0.19143000e+01, 0.19496000e+01},
    { 38, 13,  0,  0, 0.12985356e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 13,  0,  1, 0.11602539e+04, 0.00000000e+00, 0.96480000e+00},
    { 38, 13,  0,  2, 0.85956780e+03, 0.00000000e+00, 0.19311000e+01},
    { 38, 13,  0,  3, 0.62569960e+03, 0.00000000e+00, 0.29146000e+01},
    { 38, 13,  1,  0, 0.10570218e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 13,  1,  1, 0.94475350e+03, 0.98010000e+00, 0.96480000e+00},
    { 38, 13,  1,  2, 0.70067460e+03, 0.98010000e+00, 0.19311000e+01},
    { 38, 13,  1,  3, 0.50999270e+03, 0.98010000e+00, 0.29146000e+01},
    { 38, 13,  2,  0, 0.50880610e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 13,  2,  1, 0.45973700e+03, 0.19143000e+01, 0.96480000e+00},
    { 38, 13,  2,  2, 0.35455260e+03, 0.19143000e+01, 0.19311000e+01},
    { 38, 13,  2,  3, 0.27262520e+03, 0.19143000e+01, 0.29146000e+01},
    { 38, 14,  0,  0, 0.94141210e+03, 0.00000000e+00, 0.00000000e+00},
    { 38, 14,  0,  1, 0.86034210e+03, 0.00000000e+00, 0.95070000e+00},
    { 38, 14,  0,  2, 0.79067650e+03, 0.00000000e+00, 0.19435000e+01},
    { 38, 14,  0,  3, 0.77835390e+03, 0.00000000e+00, 0.29407000e+01},
    { 38, 14,  0,  4, 0.60371340e+03, 0.00000000e+00, 0.38677000e+01},
    { 38, 14,  1,  0, 0.76638470e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 14,  1,  1, 0.70100090e+03, 0.98010000e+00, 0.95070000e+00},
    { 38, 14,  1,  2, 0.64440170e+03, 0.98010000e+00, 0.19435000e+01},
    { 38, 14,  1,  3, 0.63491250e+03, 0.98010000e+00, 0.29407000e+01},
    { 38, 14,  1,  4, 0.49295740e+03, 0.98010000e+00, 0.38677000e+01},
    { 38, 14,  2,  0, 0.39434550e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 14,  2,  1, 0.36358720e+03, 0.19143000e+01, 0.95070000e+00},
    { 38, 14,  2,  2, 0.33737570e+03, 0.19143000e+01, 0.19435000e+01},
    { 38, 14,  2,  3, 0.32933860e+03, 0.19143000e+01, 0.29407000e+01},
    { 38, 14,  2,  4, 0.26785250e+03, 0.19143000e+01, 0.38677000e+01},
    { 38, 15,  0,  0, 0.68496320e+03, 0.00000000e+00, 0.00000000e+00},
    { 38, 15,  0,  1, 0.66356560e+03, 0.00000000e+00, 0.99470000e+00},
    { 38, 15,  0,  2, 0.65778770e+03, 0.00000000e+00, 0.20102000e+01},
    { 38, 15,  0,  3, 0.59874980e+03, 0.00000000e+00, 0.29859000e+01},
    { 38, 15,  1,  0, 0.55938210e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 15,  1,  1, 0.54212620e+03, 0.98010000e+00, 0.99470000e+00},
    { 38, 15,  1,  2, 0.53743520e+03, 0.98010000e+00, 0.20102000e+01},
    { 38, 15,  1,  3, 0.48959430e+03, 0.98010000e+00, 0.29859000e+01},
    { 38, 15,  2,  0, 0.30325210e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 15,  2,  1, 0.29421340e+03, 0.19143000e+01, 0.99470000e+00},
    { 38, 15,  2,  2, 0.29047610e+03, 0.19143000e+01, 0.20102000e+01},
    { 38, 15,  2,  3, 0.26845260e+03, 0.19143000e+01, 0.29859000e+01},
    { 38, 16,  0,  0, 0.54396270e+03, 0.00000000e+00, 0.00000000e+00},
    { 38, 16,  0,  1, 0.53867240e+03, 0.00000000e+00, 0.99480000e+00},
    { 38, 16,  0,  2, 0.52738380e+03, 0.00000000e+00, 0.19903000e+01},
    { 38, 16,  1,  0, 0.44578600e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 16,  1,  1, 0.44147190e+03, 0.98010000e+00, 0.99480000e+00},
    { 38, 16,  1,  2, 0.43227830e+03, 0.98010000e+00, 0.19903000e+01},
    { 38, 16,  2,  0, 0.24942670e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 16,  2,  1, 0.24672930e+03, 0.19143000e+01, 0.99480000e+00},
    { 38, 16,  2,  2, 0.24169490e+03, 0.19143000e+01, 0.19903000e+01},
    { 38, 17,  0,  0, 0.42589970e+03, 0.00000000e+00, 0.00000000e+00},
    { 38, 17,  0,  1, 0.42188670e+03, 0.00000000e+00, 0.99720000e+00},
    { 38, 17,  1,  0, 0.35042730e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 17,  1,  1, 0.34712550e+03, 0.98010000e+00, 0.99720000e+00},
    { 38, 17,  2,  0, 0.20199970e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 17,  2,  1, 0.19993530e+03, 0.19143000e+01, 0.99720000e+00},
    { 38, 18,  0,  0, 0.33586900e+03, 0.00000000e+00, 0.00000000e+00},
    { 38, 18,  1,  0, 0.27747590e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 18,  2,  0, 0.16402750e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 19,  0,  0, 0.39153529e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 19,  0,  1, 0.10279671e+04, 0.00000000e+00, 0.97670000e+00},
    { 38, 19,  1,  0, 0.33022504e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 19,  1,  1, 0.84199830e+03, 0.98010000e+00, 0.97670000e+00},
    { 38, 19,  2,  0, 0.12349320e+04, 0.19143000e+01, 0.00000000e+00},
    { 38, 19,  2,  1, 0.40435370e+03, 0.19143000e+01, 0.97670000e+00},
    { 38, 20,  0,  0, 0.28194935e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 20,  0,  1, 0.22654155e+04, 0.00000000e+00, 0.98310000e+00},
    { 38, 20,  0,  2, 0.99191430e+03, 0.00000000e+00, 0.19349000e+01},
    { 38, 20,  1,  0, 0.23148420e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 20,  1,  1, 0.18769417e+04, 0.98010000e+00, 0.98310000e+00},
    { 38, 20,  1,  2, 0.80869090e+03, 0.98010000e+00, 0.19349000e+01},
    { 38, 20,  2,  0, 0.99446760e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 20,  2,  1, 0.79454790e+03, 0.19143000e+01, 0.98310000e+00},
    { 38, 20,  2,  2, 0.41078570e+03, 0.19143000e+01, 0.19349000e+01},
    { 38, 21,  0,  0, 0.22604217e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 21,  0,  1, 0.95722710e+03, 0.00000000e+00, 0.18627000e+01},
    { 38, 21,  0,  2, 0.92214300e+03, 0.00000000e+00, 0.28999000e+01},
    { 38, 21,  1,  0, 0.18497319e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 21,  1,  1, 0.77994880e+03, 0.98010000e+00, 0.18627000e+01},
    { 38, 21,  1,  2, 0.75216410e+03, 0.98010000e+00, 0.28999000e+01},
    { 38, 21,  2,  0, 0.81692750e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 21,  2,  1, 0.39932770e+03, 0.19143000e+01, 0.18627000e+01},
    { 38, 21,  2,  2, 0.39219670e+03, 0.19143000e+01, 0.28999000e+01},
    { 38, 22,  0,  0, 0.21283951e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 22,  0,  1, 0.92365570e+03, 0.00000000e+00, 0.18299000e+01},
    { 38, 22,  0,  2, 0.93121720e+03, 0.00000000e+00, 0.38675000e+01},
    { 38, 22,  1,  0, 0.17407410e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 22,  1,  1, 0.75467530e+03, 0.98010000e+00, 0.18299000e+01},
    { 38, 22,  1,  2, 0.75959780e+03, 0.98010000e+00, 0.38675000e+01},
    { 38, 22,  2,  0, 0.78468860e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 22,  2,  1, 0.38527560e+03, 0.19143000e+01, 0.18299000e+01},
    { 38, 22,  2,  2, 0.39682160e+03, 0.19143000e+01, 0.38675000e+01},
    { 38, 23,  0,  0, 0.19186941e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 23,  0,  1, 0.90623640e+03, 0.00000000e+00, 0.19138000e+01},
    { 38, 23,  0,  2, 0.85590050e+03, 0.00000000e+00, 0.29110000e+01},
    { 38, 23,  1,  0, 0.15682263e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 23,  1,  1, 0.74017630e+03, 0.98010000e+00, 0.19138000e+01},
    { 38, 23,  1,  2, 0.69913020e+03, 0.98010000e+00, 0.29110000e+01},
    { 38, 23,  2,  0, 0.71627780e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 23,  2,  1, 0.37765080e+03, 0.19143000e+01, 0.19138000e+01},
    { 38, 23,  2,  2, 0.36331250e+03, 0.19143000e+01, 0.29110000e+01},
    { 38, 24,  0,  0, 0.15113043e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 24,  0,  1, 0.90561870e+03, 0.00000000e+00, 0.18269000e+01},
    { 38, 24,  0,  2, 0.61235490e+03, 0.00000000e+00, 0.10619100e+02},
    { 38, 24,  1,  0, 0.12385036e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 24,  1,  1, 0.73983150e+03, 0.98010000e+00, 0.18269000e+01},
    { 38, 24,  1,  2, 0.50151140e+03, 0.98010000e+00, 0.10619100e+02},
    { 38, 24,  2,  0, 0.56371140e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 24,  2,  1, 0.37474370e+03, 0.19143000e+01, 0.18269000e+01},
    { 38, 24,  2,  2, 0.27075430e+03, 0.19143000e+01, 0.10619100e+02},
    { 38, 25,  0,  0, 0.16147190e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 25,  0,  1, 0.79901250e+03, 0.00000000e+00, 0.16406000e+01},
    { 38, 25,  0,  2, 0.50680360e+03, 0.00000000e+00, 0.98849000e+01},
    { 38, 25,  1,  0, 0.13188096e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 25,  1,  1, 0.65184050e+03, 0.98010000e+00, 0.16406000e+01},
    { 38, 25,  1,  2, 0.41583400e+03, 0.98010000e+00, 0.98849000e+01},
    { 38, 25,  2,  0, 0.61384180e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 25,  2,  1, 0.34218210e+03, 0.19143000e+01, 0.16406000e+01},
    { 38, 25,  2,  2, 0.23012310e+03, 0.19143000e+01, 0.98849000e+01},
    { 38, 26,  0,  0, 0.12632327e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 26,  0,  1, 0.73123300e+03, 0.00000000e+00, 0.16483000e+01},
    { 38, 26,  0,  2, 0.49943750e+03, 0.00000000e+00, 0.91376000e+01},
    { 38, 26,  1,  0, 0.10340602e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 26,  1,  1, 0.59697670e+03, 0.98010000e+00, 0.16483000e+01},
    { 38, 26,  1,  2, 0.40967730e+03, 0.98010000e+00, 0.91376000e+01},
    { 38, 26,  2,  0, 0.48104470e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 26,  2,  1, 0.31593550e+03, 0.19143000e+01, 0.16483000e+01},
    { 38, 26,  2,  2, 0.22605370e+03, 0.19143000e+01, 0.91376000e+01},
    { 38, 27,  0,  0, 0.12908718e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 27,  0,  1, 0.69807620e+03, 0.00000000e+00, 0.17149000e+01},
    { 38, 27,  0,  2, 0.61724930e+03, 0.00000000e+00, 0.29263000e+01},
    { 38, 27,  0,  3, 0.53035890e+03, 0.00000000e+00, 0.77785000e+01},
    { 38, 27,  1,  0, 0.10522336e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 27,  1,  1, 0.57030240e+03, 0.98010000e+00, 0.17149000e+01},
    { 38, 27,  1,  2, 0.50499050e+03, 0.98010000e+00, 0.29263000e+01},
    { 38, 27,  1,  3, 0.43445030e+03, 0.98010000e+00, 0.77785000e+01},
    { 38, 27,  2,  0, 0.50672720e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 27,  2,  1, 0.30136140e+03, 0.19143000e+01, 0.17149000e+01},
    { 38, 27,  2,  2, 0.26782340e+03, 0.19143000e+01, 0.29263000e+01},
    { 38, 27,  2,  3, 0.23676080e+03, 0.19143000e+01, 0.77785000e+01},
    { 38, 28,  0,  0, 0.13513702e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 28,  0,  1, 0.68477150e+03, 0.00000000e+00, 0.17937000e+01},
    { 38, 28,  0,  2, 0.56577900e+03, 0.00000000e+00, 0.65458000e+01},
    { 38, 28,  0,  3, 0.61461390e+03, 0.00000000e+00, 0.62918000e+01},
    { 38, 28,  1,  0, 0.11016666e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 28,  1,  1, 0.55938830e+03, 0.98010000e+00, 0.17937000e+01},
    { 38, 28,  1,  2, 0.46289020e+03, 0.98010000e+00, 0.65458000e+01},
    { 38, 28,  1,  3, 0.50246340e+03, 0.98010000e+00, 0.62918000e+01},
    { 38, 28,  2,  0, 0.52370020e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 28,  2,  1, 0.29480040e+03, 0.19143000e+01, 0.17937000e+01},
    { 38, 28,  2,  2, 0.24873790e+03, 0.19143000e+01, 0.65458000e+01},
    { 38, 28,  2,  3, 0.26289820e+03, 0.19143000e+01, 0.62918000e+01},
    { 38, 29,  0,  0, 0.10377284e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 29,  0,  1, 0.69786230e+03, 0.00000000e+00, 0.95760000e+00},
    { 38, 29,  1,  0, 0.84879520e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 29,  1,  1, 0.56991510e+03, 0.98010000e+00, 0.95760000e+00},
    { 38, 29,  2,  0, 0.40117140e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 29,  2,  1, 0.29297830e+03, 0.19143000e+01, 0.95760000e+00},
    { 38, 30,  0,  0, 0.10096809e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 30,  0,  1, 0.61859280e+03, 0.00000000e+00, 0.19419000e+01},
    { 38, 30,  1,  0, 0.82251670e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 30,  1,  1, 0.50526080e+03, 0.98010000e+00, 0.19419000e+01},
    { 38, 30,  2,  0, 0.40794990e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 30,  2,  1, 0.27198180e+03, 0.19143000e+01, 0.19419000e+01},
    { 38, 31,  0,  0, 0.12165138e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 31,  0,  1, 0.11239167e+04, 0.00000000e+00, 0.96010000e+00},
    { 38, 31,  0,  2, 0.84136100e+03, 0.00000000e+00, 0.19315000e+01},
    { 38, 31,  0,  3, 0.64926400e+03, 0.00000000e+00, 0.29233000e+01},
    { 38, 31,  1,  0, 0.99191230e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 31,  1,  1, 0.91623120e+03, 0.98010000e+00, 0.96010000e+00},
    { 38, 31,  1,  2, 0.68659850e+03, 0.98010000e+00, 0.19315000e+01},
    { 38, 31,  1,  3, 0.53024480e+03, 0.98010000e+00, 0.29233000e+01},
    { 38, 31,  2,  0, 0.48488130e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 31,  2,  1, 0.45391820e+03, 0.19143000e+01, 0.96010000e+00},
    { 38, 31,  2,  2, 0.35556210e+03, 0.19143000e+01, 0.19315000e+01},
    { 38, 31,  2,  3, 0.28761670e+03, 0.19143000e+01, 0.29233000e+01},
    { 38, 32,  0,  0, 0.10044824e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 32,  0,  1, 0.92600250e+03, 0.00000000e+00, 0.94340000e+00},
    { 38, 32,  0,  2, 0.87244650e+03, 0.00000000e+00, 0.19447000e+01},
    { 38, 32,  0,  3, 0.76173640e+03, 0.00000000e+00, 0.29186000e+01},
    { 38, 32,  0,  4, 0.65048490e+03, 0.00000000e+00, 0.38972000e+01},
    { 38, 32,  1,  0, 0.81848870e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 32,  1,  1, 0.75505840e+03, 0.98010000e+00, 0.94340000e+00},
    { 38, 32,  1,  2, 0.71158620e+03, 0.98010000e+00, 0.19447000e+01},
    { 38, 32,  1,  3, 0.62192630e+03, 0.98010000e+00, 0.29186000e+01},
    { 38, 32,  1,  4, 0.53187620e+03, 0.98010000e+00, 0.38972000e+01},
    { 38, 32,  2,  0, 0.42218130e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 32,  2,  1, 0.39376600e+03, 0.19143000e+01, 0.94340000e+00},
    { 38, 32,  2,  2, 0.37409750e+03, 0.19143000e+01, 0.19447000e+01},
    { 38, 32,  2,  3, 0.33346480e+03, 0.19143000e+01, 0.29186000e+01},
    { 38, 32,  2,  4, 0.29242890e+03, 0.19143000e+01, 0.38972000e+01},
    { 38, 33,  0,  0, 0.80833700e+03, 0.00000000e+00, 0.00000000e+00},
    { 38, 33,  0,  1, 0.79208160e+03, 0.00000000e+00, 0.98890000e+00},
    { 38, 33,  0,  2, 0.76674210e+03, 0.00000000e+00, 0.19793000e+01},
    { 38, 33,  0,  3, 0.73174620e+03, 0.00000000e+00, 0.29709000e+01},
    { 38, 33,  1,  0, 0.66009280e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 33,  1,  1, 0.64702200e+03, 0.98010000e+00, 0.98890000e+00},
    { 38, 33,  1,  2, 0.62656050e+03, 0.98010000e+00, 0.19793000e+01},
    { 38, 33,  1,  3, 0.59821020e+03, 0.98010000e+00, 0.29709000e+01},
    { 38, 33,  2,  0, 0.35593940e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 33,  2,  1, 0.34965980e+03, 0.19143000e+01, 0.98890000e+00},
    { 38, 33,  2,  2, 0.34006880e+03, 0.19143000e+01, 0.19793000e+01},
    { 38, 33,  2,  3, 0.32696240e+03, 0.19143000e+01, 0.29709000e+01},
    { 38, 34,  0,  0, 0.70005320e+03, 0.00000000e+00, 0.00000000e+00},
    { 38, 34,  0,  1, 0.70080150e+03, 0.00000000e+00, 0.99010000e+00},
    { 38, 34,  0,  2, 0.69465560e+03, 0.00000000e+00, 0.19812000e+01},
    { 38, 34,  1,  0, 0.57308500e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 34,  1,  1, 0.57371350e+03, 0.98010000e+00, 0.99010000e+00},
    { 38, 34,  1,  2, 0.56874160e+03, 0.98010000e+00, 0.19812000e+01},
    { 38, 34,  2,  0, 0.31709380e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 34,  2,  1, 0.31724980e+03, 0.19143000e+01, 0.99010000e+00},
    { 38, 34,  2,  2, 0.31469330e+03, 0.19143000e+01, 0.19812000e+01},
    { 38, 35,  0,  0, 0.59073260e+03, 0.00000000e+00, 0.00000000e+00},
    { 38, 35,  0,  1, 0.59602140e+03, 0.00000000e+00, 0.99740000e+00},
    { 38, 35,  1,  0, 0.48506500e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 35,  1,  1, 0.48934610e+03, 0.98010000e+00, 0.99740000e+00},
    { 38, 35,  2,  0, 0.27544760e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 35,  2,  1, 0.27746890e+03, 0.19143000e+01, 0.99740000e+00},
    { 38, 36,  0,  0, 0.49691200e+03, 0.00000000e+00, 0.00000000e+00},
    { 38, 36,  1,  0, 0.40937610e+03, 0.98010000e+00, 0.00000000e+00},
    { 38, 36,  2,  0, 0.23792190e+03, 0.19143000e+01, 0.00000000e+00},
    { 38, 37,  0,  0, 0.43492577e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 37,  0,  1, 0.12108108e+04, 0.00000000e+00, 0.97380000e+00},
    { 38, 37,  1,  0, 0.36709261e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 37,  1,  1, 0.99279700e+03, 0.98010000e+00, 0.97380000e+00},
    { 38, 37,  2,  0, 0.13808411e+04, 0.19143000e+01, 0.00000000e+00},
    { 38, 37,  2,  1, 0.48106050e+03, 0.19143000e+01, 0.97380000e+00},
    { 38, 38,  0,  0, 0.33813672e+04, 0.00000000e+00, 0.00000000e+00},
    { 38, 38,  1,  0, 0.27824577e+04, 0.98010000e+00, 0.00000000e+00},
    { 38, 38,  1,  1, 0.23126602e+04, 0.98010000e+00, 0.98010000e+00},
    { 38, 38,  2,  0, 0.11858018e+04, 0.19143000e+01, 0.00000000e+00},
    { 38, 38,  2,  1, 0.96807870e+03, 0.19143000e+01, 0.98010000e+00},
    { 38, 38,  2,  2, 0.49174480e+03, 0.19143000e+01, 0.19143000e+01},
    { 39,  1,  0,  0, 0.70057000e+02, 0.00000000e+00, 0.91180000e+00},
    { 39,  1,  0,  1, 0.11929610e+03, 0.00000000e+00, 0.00000000e+00},
    { 39,  1,  1,  0, 0.51235600e+02, 0.19153000e+01, 0.91180000e+00},
    { 39,  1,  1,  1, 0.85681500e+02, 0.19153000e+01, 0.00000000e+00},
    { 39,  1,  2,  0, 0.36054300e+02, 0.28903000e+01, 0.91180000e+00},
    { 39,  1,  2,  1, 0.58275500e+02, 0.28903000e+01, 0.00000000e+00},
    { 39,  2,  0,  0, 0.42419500e+02, 0.00000000e+00, 0.00000000e+00},
    { 39,  2,  1,  0, 0.31988900e+02, 0.19153000e+01, 0.00000000e+00},
    { 39,  2,  2,  0, 0.23646200e+02, 0.28903000e+01, 0.00000000e+00},
    { 39,  3,  0,  0, 0.15853950e+04, 0.00000000e+00, 0.00000000e+00},
    { 39,  3,  0,  1, 0.44294480e+03, 0.00000000e+00, 0.98650000e+00},
    { 39,  3,  1,  0, 0.10745875e+04, 0.19153000e+01, 0.00000000e+00},
    { 39,  3,  1,  1, 0.30688620e+03, 0.19153000e+01, 0.98650000e+00},
    { 39,  3,  2,  0, 0.56732020e+03, 0.28903000e+01, 0.00000000e+00},
    { 39,  3,  2,  1, 0.18988940e+03, 0.28903000e+01, 0.98650000e+00},
    { 39,  4,  0,  0, 0.77148440e+03, 0.00000000e+00, 0.00000000e+00},
    { 39,  4,  0,  1, 0.55615030e+03, 0.00000000e+00, 0.98080000e+00},
    { 39,  4,  0,  2, 0.33071900e+03, 0.00000000e+00, 0.19697000e+01},
    { 39,  4,  1,  0, 0.53251100e+03, 0.19153000e+01, 0.00000000e+00},
    { 39,  4,  1,  1, 0.38765640e+03, 0.19153000e+01, 0.98080000e+00},
    { 39,  4,  1,  2, 0.23552320e+03, 0.19153000e+01, 0.19697000e+01},
    { 39,  4,  2,  0, 0.32691860e+03, 0.28903000e+01, 0.00000000e+00},
    { 39,  4,  2,  1, 0.24200800e+03, 0.28903000e+01, 0.98080000e+00},
    { 39,  4,  2,  2, 0.15742770e+03, 0.28903000e+01, 0.19697000e+01},
    { 39,  5,  0,  0, 0.47243640e+03, 0.00000000e+00, 0.00000000e+00},
    { 39,  5,  0,  1, 0.38988230e+03, 0.00000000e+00, 0.97060000e+00},
    { 39,  5,  0,  2, 0.32126520e+03, 0.00000000e+00, 0.19441000e+01},
    { 39,  5,  0,  3, 0.23111730e+03, 0.00000000e+00, 0.29128000e+01},
    { 39,  5,  0,  4, 0.21572630e+03, 0.00000000e+00, 0.45856000e+01},
    { 39,  5,  1,  0, 0.33413510e+03, 0.19153000e+01, 0.00000000e+00},
    { 39,  5,  1,  1, 0.27740500e+03, 0.19153000e+01, 0.97060000e+00},
    { 39,  5,  1,  2, 0.23013840e+03, 0.19153000e+01, 0.19441000e+01},
    { 39,  5,  1,  3, 0.16813540e+03, 0.19153000e+01, 0.29128000e+01},
    { 39,  5,  1,  4, 0.15735980e+03, 0.19153000e+01, 0.45856000e+01},
    { 39,  5,  2,  0, 0.21933470e+03, 0.28903000e+01, 0.00000000e+00},
    { 39,  5,  2,  1, 0.18428470e+03, 0.28903000e+01, 0.97060000e+00},
    { 39,  5,  2,  2, 0.15452800e+03, 0.28903000e+01, 0.19441000e+01},
    { 39,  5,  2,  3, 0.11715700e+03, 0.28903000e+01, 0.29128000e+01},
    { 39,  5,  2,  4, 0.11017370e+03, 0.28903000e+01, 0.45856000e+01},
    { 39,  6,  0,  0, 0.29721710e+03, 0.00000000e+00, 0.00000000e+00},
    { 39,  6,  0,  1, 0.27947270e+03, 0.00000000e+00, 0.98680000e+00},
    { 39,  6,  0,  2, 0.22088300e+03, 0.00000000e+00, 0.19985000e+01},
    { 39,  6,  0,  3, 0.20665890e+03, 0.00000000e+00, 0.29987000e+01},
    { 39,  6,  0,  4, 0.16177380e+03, 0.00000000e+00, 0.39844000e+01},
    { 39,  6,  1,  0, 0.21477600e+03, 0.19153000e+01, 0.00000000e+00},
    { 39,  6,  1,  1, 0.20197440e+03, 0.19153000e+01, 0.98680000e+00},
    { 39,  6,  1,  2, 0.16111150e+03, 0.19153000e+01, 0.19985000e+01},
    { 39,  6,  1,  3, 0.15078940e+03, 0.19153000e+01, 0.29987000e+01},
    { 39,  6,  1,  4, 0.11976540e+03, 0.19153000e+01, 0.39844000e+01},
    { 39,  6,  2,  0, 0.14760490e+03, 0.28903000e+01, 0.00000000e+00},
    { 39,  6,  2,  1, 0.13843530e+03, 0.28903000e+01, 0.98680000e+00},
    { 39,  6,  2,  2, 0.11266800e+03, 0.28903000e+01, 0.19985000e+01},
    { 39,  6,  2,  3, 0.10538580e+03, 0.28903000e+01, 0.29987000e+01},
    { 39,  6,  2,  4, 0.85966800e+02, 0.28903000e+01, 0.39844000e+01},
    { 39,  7,  0,  0, 0.19706110e+03, 0.00000000e+00, 0.00000000e+00},
    { 39,  7,  0,  1, 0.18368510e+03, 0.00000000e+00, 0.99440000e+00},
    { 39,  7,  0,  2, 0.17135740e+03, 0.00000000e+00, 0.20143000e+01},
    { 39,  7,  0,  3, 0.14989060e+03, 0.00000000e+00, 0.29903000e+01},
    { 39,  7,  1,  0, 0.14492070e+03, 0.19153000e+01, 0.00000000e+00},
    { 39,  7,  1,  1, 0.13518390e+03, 0.19153000e+01, 0.99440000e+00},
    { 39,  7,  1,  2, 0.12634700e+03, 0.19153000e+01, 0.20143000e+01},
    { 39,  7,  1,  3, 0.11082380e+03, 0.19153000e+01, 0.29903000e+01},
    { 39,  7,  2,  0, 0.10284790e+03, 0.28903000e+01, 0.00000000e+00},
    { 39,  7,  2,  1, 0.95889700e+02, 0.28903000e+01, 0.99440000e+00},
    { 39,  7,  2,  2, 0.89962600e+02, 0.28903000e+01, 0.20143000e+01},
    { 39,  7,  2,  3, 0.79155000e+02, 0.28903000e+01, 0.29903000e+01},
    { 39,  8,  0,  0, 0.14366020e+03, 0.00000000e+00, 0.00000000e+00},
    { 39,  8,  0,  1, 0.12762820e+03, 0.00000000e+00, 0.99250000e+00},
    { 39,  8,  0,  2, 0.11116060e+03, 0.00000000e+00, 0.19887000e+01},
    { 39,  8,  1,  0, 0.10704380e+03, 0.19153000e+01, 0.00000000e+00},
    { 39,  8,  1,  1, 0.95445800e+02, 0.19153000e+01, 0.99250000e+00},
    { 39,  8,  1,  2, 0.83510800e+02, 0.19153000e+01, 0.19887000e+01},
    { 39,  8,  2,  0, 0.77633500e+02, 0.28903000e+01, 0.00000000e+00},
    { 39,  8,  2,  1, 0.69580600e+02, 0.28903000e+01, 0.99250000e+00},
    { 39,  8,  2,  2, 0.61279600e+02, 0.28903000e+01, 0.19887000e+01},
    { 39,  9,  0,  0, 0.10534470e+03, 0.00000000e+00, 0.00000000e+00},
    { 39,  9,  0,  1, 0.82733700e+02, 0.00000000e+00, 0.99820000e+00},
    { 39,  9,  1,  0, 0.79407600e+02, 0.19153000e+01, 0.00000000e+00},
    { 39,  9,  1,  1, 0.63188900e+02, 0.19153000e+01, 0.99820000e+00},
    { 39,  9,  2,  0, 0.58635900e+02, 0.28903000e+01, 0.00000000e+00},
    { 39,  9,  2,  1, 0.47591400e+02, 0.28903000e+01, 0.99820000e+00},
    { 39, 10,  0,  0, 0.78931600e+02, 0.00000000e+00, 0.00000000e+00},
    { 39, 10,  1,  0, 0.60062800e+02, 0.19153000e+01, 0.00000000e+00},
    { 39, 10,  2,  0, 0.44975300e+02, 0.28903000e+01, 0.00000000e+00},
    { 39, 11,  0,  0, 0.18768634e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 11,  0,  1, 0.65879630e+03, 0.00000000e+00, 0.96840000e+00},
    { 39, 11,  1,  0, 0.12727028e+04, 0.19153000e+01, 0.00000000e+00},
    { 39, 11,  1,  1, 0.45499280e+03, 0.19153000e+01, 0.96840000e+00},
    { 39, 11,  2,  0, 0.67817260e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 11,  2,  1, 0.27757010e+03, 0.28903000e+01, 0.96840000e+00},
    { 39, 12,  0,  0, 0.12667602e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 12,  0,  1, 0.10281365e+04, 0.00000000e+00, 0.96280000e+00},
    { 39, 12,  0,  2, 0.61169610e+03, 0.00000000e+00, 0.19496000e+01},
    { 39, 12,  1,  0, 0.86937390e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 12,  1,  1, 0.70969610e+03, 0.19153000e+01, 0.96280000e+00},
    { 39, 12,  1,  2, 0.43039400e+03, 0.19153000e+01, 0.19496000e+01},
    { 39, 12,  2,  0, 0.52114300e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 12,  2,  1, 0.42950590e+03, 0.28903000e+01, 0.96280000e+00},
    { 39, 12,  2,  2, 0.27968340e+03, 0.28903000e+01, 0.19496000e+01},
    { 39, 13,  0,  0, 0.11122980e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 13,  0,  1, 0.99637570e+03, 0.00000000e+00, 0.96480000e+00},
    { 39, 13,  0,  2, 0.74518010e+03, 0.00000000e+00, 0.19311000e+01},
    { 39, 13,  0,  3, 0.54992420e+03, 0.00000000e+00, 0.29146000e+01},
    { 39, 13,  1,  0, 0.77186060e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 13,  1,  1, 0.69347320e+03, 0.19153000e+01, 0.96480000e+00},
    { 39, 13,  1,  2, 0.52422670e+03, 0.19153000e+01, 0.19311000e+01},
    { 39, 13,  1,  3, 0.39206600e+03, 0.19153000e+01, 0.29146000e+01},
    { 39, 13,  2,  0, 0.47968840e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 13,  2,  1, 0.43451020e+03, 0.28903000e+01, 0.96480000e+00},
    { 39, 13,  2,  2, 0.33801530e+03, 0.28903000e+01, 0.19311000e+01},
    { 39, 13,  2,  3, 0.26276340e+03, 0.28903000e+01, 0.29146000e+01},
    { 39, 14,  0,  0, 0.81954180e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 14,  0,  1, 0.75038170e+03, 0.00000000e+00, 0.95070000e+00},
    { 39, 14,  0,  2, 0.69120290e+03, 0.00000000e+00, 0.19435000e+01},
    { 39, 14,  0,  3, 0.67875770e+03, 0.00000000e+00, 0.29407000e+01},
    { 39, 14,  0,  4, 0.53268760e+03, 0.00000000e+00, 0.38677000e+01},
    { 39, 14,  1,  0, 0.57805500e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 14,  1,  1, 0.53081800e+03, 0.19153000e+01, 0.95070000e+00},
    { 39, 14,  1,  2, 0.49021540e+03, 0.19153000e+01, 0.19435000e+01},
    { 39, 14,  1,  3, 0.48074960e+03, 0.19153000e+01, 0.29407000e+01},
    { 39, 14,  1,  4, 0.38205370e+03, 0.19153000e+01, 0.38677000e+01},
    { 39, 14,  2,  0, 0.37706390e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 14,  2,  1, 0.34831620e+03, 0.28903000e+01, 0.95070000e+00},
    { 39, 14,  2,  2, 0.32383050e+03, 0.28903000e+01, 0.19435000e+01},
    { 39, 14,  2,  3, 0.31562100e+03, 0.28903000e+01, 0.29407000e+01},
    { 39, 14,  2,  4, 0.25910620e+03, 0.28903000e+01, 0.38677000e+01},
    { 39, 15,  0,  0, 0.60399160e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 15,  0,  1, 0.58524670e+03, 0.00000000e+00, 0.99470000e+00},
    { 39, 15,  0,  2, 0.57951050e+03, 0.00000000e+00, 0.20102000e+01},
    { 39, 15,  0,  3, 0.52942130e+03, 0.00000000e+00, 0.29859000e+01},
    { 39, 15,  1,  0, 0.43301710e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 15,  1,  1, 0.41987180e+03, 0.19153000e+01, 0.99470000e+00},
    { 39, 15,  1,  2, 0.41535780e+03, 0.19153000e+01, 0.20102000e+01},
    { 39, 15,  1,  3, 0.38114140e+03, 0.19153000e+01, 0.29859000e+01},
    { 39, 15,  2,  0, 0.29323240e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 15,  2,  1, 0.28458190e+03, 0.28903000e+01, 0.99470000e+00},
    { 39, 15,  2,  2, 0.28074710e+03, 0.28903000e+01, 0.20102000e+01},
    { 39, 15,  2,  3, 0.26022540e+03, 0.28903000e+01, 0.29859000e+01},
    { 39, 16,  0,  0, 0.48337970e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 16,  0,  1, 0.47852040e+03, 0.00000000e+00, 0.99480000e+00},
    { 39, 16,  0,  2, 0.46852690e+03, 0.00000000e+00, 0.19903000e+01},
    { 39, 16,  1,  0, 0.35057750e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 16,  1,  1, 0.34697100e+03, 0.19153000e+01, 0.99480000e+00},
    { 39, 16,  1,  2, 0.33980820e+03, 0.19153000e+01, 0.19903000e+01},
    { 39, 16,  2,  0, 0.24282560e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 16,  2,  1, 0.24014930e+03, 0.28903000e+01, 0.99480000e+00},
    { 39, 16,  2,  2, 0.23527170e+03, 0.28903000e+01, 0.19903000e+01},
    { 39, 17,  0,  0, 0.38124620e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 17,  0,  1, 0.37756420e+03, 0.00000000e+00, 0.99720000e+00},
    { 39, 17,  1,  0, 0.27973550e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 17,  1,  1, 0.27697730e+03, 0.19153000e+01, 0.99720000e+00},
    { 39, 17,  2,  0, 0.19787960e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 17,  2,  1, 0.19582670e+03, 0.28903000e+01, 0.99720000e+00},
    { 39, 18,  0,  0, 0.30251430e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 18,  1,  0, 0.22431260e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 18,  2,  0, 0.16150560e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 19,  0,  0, 0.31660625e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 19,  0,  1, 0.87903460e+03, 0.00000000e+00, 0.97670000e+00},
    { 39, 19,  1,  0, 0.21637031e+04, 0.19153000e+01, 0.00000000e+00},
    { 39, 19,  1,  1, 0.61384630e+03, 0.19153000e+01, 0.97670000e+00},
    { 39, 19,  2,  0, 0.11105426e+04, 0.28903000e+01, 0.00000000e+00},
    { 39, 19,  2,  1, 0.38177780e+03, 0.28903000e+01, 0.97670000e+00},
    { 39, 20,  0,  0, 0.23508018e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 20,  0,  1, 0.18821338e+04, 0.00000000e+00, 0.98310000e+00},
    { 39, 20,  0,  2, 0.86032290e+03, 0.00000000e+00, 0.19349000e+01},
    { 39, 20,  1,  0, 0.16036362e+04, 0.19153000e+01, 0.00000000e+00},
    { 39, 20,  1,  1, 0.12935159e+04, 0.19153000e+01, 0.98310000e+00},
    { 39, 20,  1,  2, 0.60584530e+03, 0.19153000e+01, 0.19349000e+01},
    { 39, 20,  2,  0, 0.91608550e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 20,  2,  1, 0.73212430e+03, 0.28903000e+01, 0.98310000e+00},
    { 39, 20,  2,  2, 0.39183600e+03, 0.28903000e+01, 0.19349000e+01},
    { 39, 21,  0,  0, 0.18967809e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 21,  0,  1, 0.83166790e+03, 0.00000000e+00, 0.18627000e+01},
    { 39, 21,  0,  2, 0.80504650e+03, 0.00000000e+00, 0.28999000e+01},
    { 39, 21,  1,  0, 0.12972964e+04, 0.19153000e+01, 0.00000000e+00},
    { 39, 21,  1,  1, 0.58631350e+03, 0.19153000e+01, 0.18627000e+01},
    { 39, 21,  1,  2, 0.57086180e+03, 0.19153000e+01, 0.28999000e+01},
    { 39, 21,  2,  0, 0.75654430e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 21,  2,  1, 0.38147190e+03, 0.28903000e+01, 0.18627000e+01},
    { 39, 21,  2,  2, 0.37616230e+03, 0.28903000e+01, 0.28999000e+01},
    { 39, 22,  0,  0, 0.17943180e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 22,  0,  1, 0.80203240e+03, 0.00000000e+00, 0.18299000e+01},
    { 39, 22,  0,  2, 0.81333020e+03, 0.00000000e+00, 0.38675000e+01},
    { 39, 22,  1,  0, 0.12323433e+04, 0.19153000e+01, 0.00000000e+00},
    { 39, 22,  1,  1, 0.56686700e+03, 0.19153000e+01, 0.18299000e+01},
    { 39, 22,  1,  2, 0.57702860e+03, 0.19153000e+01, 0.38675000e+01},
    { 39, 22,  2,  0, 0.73005840e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 22,  2,  1, 0.36814810e+03, 0.28903000e+01, 0.18299000e+01},
    { 39, 22,  2,  2, 0.38074190e+03, 0.28903000e+01, 0.38675000e+01},
    { 39, 23,  0,  0, 0.16224689e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 23,  0,  1, 0.78672550e+03, 0.00000000e+00, 0.19138000e+01},
    { 39, 23,  0,  2, 0.74643350e+03, 0.00000000e+00, 0.29110000e+01},
    { 39, 23,  1,  0, 0.11169531e+04, 0.19153000e+01, 0.00000000e+00},
    { 39, 23,  1,  1, 0.55572150e+03, 0.19153000e+01, 0.19138000e+01},
    { 39, 23,  1,  2, 0.52968240e+03, 0.19153000e+01, 0.29110000e+01},
    { 39, 23,  2,  0, 0.66827290e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 23,  2,  1, 0.36077080e+03, 0.28903000e+01, 0.19138000e+01},
    { 39, 23,  2,  2, 0.34837280e+03, 0.28903000e+01, 0.29110000e+01},
    { 39, 24,  0,  0, 0.12764352e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 24,  0,  1, 0.78474890e+03, 0.00000000e+00, 0.18269000e+01},
    { 39, 24,  0,  2, 0.53890290e+03, 0.00000000e+00, 0.10619100e+02},
    { 39, 24,  1,  0, 0.88060690e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 24,  1,  1, 0.55347640e+03, 0.19153000e+01, 0.18269000e+01},
    { 39, 24,  1,  2, 0.38709820e+03, 0.19153000e+01, 0.10619100e+02},
    { 39, 24,  2,  0, 0.52603240e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 24,  2,  1, 0.35748370e+03, 0.28903000e+01, 0.18269000e+01},
    { 39, 24,  2,  2, 0.26170420e+03, 0.28903000e+01, 0.10619100e+02},
    { 39, 25,  0,  0, 0.13714492e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 25,  0,  1, 0.69867600e+03, 0.00000000e+00, 0.16406000e+01},
    { 39, 25,  0,  2, 0.44877680e+03, 0.00000000e+00, 0.98849000e+01},
    { 39, 25,  1,  0, 0.94758340e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 25,  1,  1, 0.49633310e+03, 0.19153000e+01, 0.16406000e+01},
    { 39, 25,  1,  2, 0.32497510e+03, 0.19153000e+01, 0.98849000e+01},
    { 39, 25,  2,  0, 0.57500600e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 25,  2,  1, 0.32862230e+03, 0.28903000e+01, 0.16406000e+01},
    { 39, 25,  2,  2, 0.22356370e+03, 0.28903000e+01, 0.98849000e+01},
    { 39, 26,  0,  0, 0.10723265e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 26,  0,  1, 0.64066410e+03, 0.00000000e+00, 0.16483000e+01},
    { 39, 26,  0,  2, 0.44192580e+03, 0.00000000e+00, 0.91376000e+01},
    { 39, 26,  1,  0, 0.74266410e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 26,  1,  1, 0.45638780e+03, 0.19153000e+01, 0.16483000e+01},
    { 39, 26,  1,  2, 0.31968600e+03, 0.19153000e+01, 0.91376000e+01},
    { 39, 26,  2,  0, 0.45091200e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 26,  2,  1, 0.30396440e+03, 0.28903000e+01, 0.16483000e+01},
    { 39, 26,  2,  2, 0.21947140e+03, 0.28903000e+01, 0.91376000e+01},
    { 39, 27,  0,  0, 0.11053016e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 27,  0,  1, 0.61134030e+03, 0.00000000e+00, 0.17149000e+01},
    { 39, 27,  0,  2, 0.54087060e+03, 0.00000000e+00, 0.29263000e+01},
    { 39, 27,  0,  3, 0.46786120e+03, 0.00000000e+00, 0.77785000e+01},
    { 39, 27,  1,  0, 0.76821070e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 27,  1,  1, 0.43567010e+03, 0.19153000e+01, 0.17149000e+01},
    { 39, 27,  1,  2, 0.38637760e+03, 0.19153000e+01, 0.29263000e+01},
    { 39, 27,  1,  3, 0.33691730e+03, 0.19153000e+01, 0.77785000e+01},
    { 39, 27,  2,  0, 0.47789770e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 27,  2,  1, 0.28991370e+03, 0.28903000e+01, 0.17149000e+01},
    { 39, 27,  2,  2, 0.25791900e+03, 0.28903000e+01, 0.29263000e+01},
    { 39, 27,  2,  3, 0.22925270e+03, 0.28903000e+01, 0.77785000e+01},
    { 39, 28,  0,  0, 0.11535737e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 28,  0,  1, 0.59926520e+03, 0.00000000e+00, 0.17937000e+01},
    { 39, 28,  0,  2, 0.49739960e+03, 0.00000000e+00, 0.65458000e+01},
    { 39, 28,  0,  3, 0.53667450e+03, 0.00000000e+00, 0.62918000e+01},
    { 39, 28,  1,  0, 0.79937100e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 28,  1,  1, 0.42674050e+03, 0.19153000e+01, 0.17937000e+01},
    { 39, 28,  1,  2, 0.35647370e+03, 0.19153000e+01, 0.65458000e+01},
    { 39, 28,  1,  3, 0.38179030e+03, 0.19153000e+01, 0.62918000e+01},
    { 39, 28,  2,  0, 0.49251980e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 28,  2,  1, 0.28344240e+03, 0.28903000e+01, 0.17937000e+01},
    { 39, 28,  2,  2, 0.24013260e+03, 0.28903000e+01, 0.65458000e+01},
    { 39, 28,  2,  3, 0.25242450e+03, 0.28903000e+01, 0.62918000e+01},
    { 39, 29,  0,  0, 0.88416480e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 29,  0,  1, 0.60685850e+03, 0.00000000e+00, 0.95760000e+00},
    { 39, 29,  1,  0, 0.61409830e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 29,  1,  1, 0.42937430e+03, 0.19153000e+01, 0.95760000e+00},
    { 39, 29,  2,  0, 0.37723750e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 29,  2,  1, 0.28025690e+03, 0.28903000e+01, 0.95760000e+00},
    { 39, 30,  0,  0, 0.87069350e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 30,  0,  1, 0.54431400e+03, 0.00000000e+00, 0.19419000e+01},
    { 39, 30,  1,  0, 0.60904990e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 30,  1,  1, 0.38958110e+03, 0.19153000e+01, 0.19419000e+01},
    { 39, 30,  2,  0, 0.38708210e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 30,  2,  1, 0.26257350e+03, 0.28903000e+01, 0.19419000e+01},
    { 39, 31,  0,  0, 0.10455505e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 31,  0,  1, 0.96907770e+03, 0.00000000e+00, 0.96010000e+00},
    { 39, 31,  0,  2, 0.73335550e+03, 0.00000000e+00, 0.19315000e+01},
    { 39, 31,  0,  3, 0.57254520e+03, 0.00000000e+00, 0.29233000e+01},
    { 39, 31,  1,  0, 0.72958130e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 31,  1,  1, 0.67825900e+03, 0.19153000e+01, 0.96010000e+00},
    { 39, 31,  1,  2, 0.51944370e+03, 0.19153000e+01, 0.19315000e+01},
    { 39, 31,  1,  3, 0.41052730e+03, 0.19153000e+01, 0.29233000e+01},
    { 39, 31,  2,  0, 0.45890330e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 31,  2,  1, 0.43079250e+03, 0.28903000e+01, 0.96010000e+00},
    { 39, 31,  2,  2, 0.34065350e+03, 0.28903000e+01, 0.19315000e+01},
    { 39, 31,  2,  3, 0.27811250e+03, 0.28903000e+01, 0.29233000e+01},
    { 39, 32,  0,  0, 0.87478360e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 32,  0,  1, 0.80859910e+03, 0.00000000e+00, 0.94340000e+00},
    { 39, 32,  0,  2, 0.76334100e+03, 0.00000000e+00, 0.19447000e+01},
    { 39, 32,  0,  3, 0.66974730e+03, 0.00000000e+00, 0.29186000e+01},
    { 39, 32,  0,  4, 0.57557310e+03, 0.00000000e+00, 0.38972000e+01},
    { 39, 32,  1,  0, 0.61799850e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 32,  1,  1, 0.57321390e+03, 0.19153000e+01, 0.94340000e+00},
    { 39, 32,  1,  2, 0.54236550e+03, 0.19153000e+01, 0.19447000e+01},
    { 39, 32,  1,  3, 0.47871320e+03, 0.19153000e+01, 0.29186000e+01},
    { 39, 32,  1,  4, 0.41462030e+03, 0.19153000e+01, 0.38972000e+01},
    { 39, 32,  2,  0, 0.40396460e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 32,  2,  1, 0.37769300e+03, 0.28903000e+01, 0.94340000e+00},
    { 39, 32,  2,  2, 0.35942740e+03, 0.28903000e+01, 0.19447000e+01},
    { 39, 32,  2,  3, 0.32171900e+03, 0.28903000e+01, 0.29186000e+01},
    { 39, 32,  2,  4, 0.28359490e+03, 0.28903000e+01, 0.38972000e+01},
    { 39, 33,  0,  0, 0.71175060e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 33,  0,  1, 0.69780370e+03, 0.00000000e+00, 0.98890000e+00},
    { 39, 33,  0,  2, 0.67620360e+03, 0.00000000e+00, 0.19793000e+01},
    { 39, 33,  0,  3, 0.64647740e+03, 0.00000000e+00, 0.29709000e+01},
    { 39, 33,  1,  0, 0.50955030e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 33,  1,  1, 0.50000710e+03, 0.19153000e+01, 0.98890000e+00},
    { 39, 33,  1,  2, 0.48524610e+03, 0.19153000e+01, 0.19793000e+01},
    { 39, 33,  1,  3, 0.46492540e+03, 0.19153000e+01, 0.29709000e+01},
    { 39, 33,  2,  0, 0.34379750e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 33,  2,  1, 0.33790570e+03, 0.28903000e+01, 0.98890000e+00},
    { 39, 33,  2,  2, 0.32894310e+03, 0.28903000e+01, 0.19793000e+01},
    { 39, 33,  2,  3, 0.31671890e+03, 0.28903000e+01, 0.29709000e+01},
    { 39, 34,  0,  0, 0.62033340e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 34,  0,  1, 0.62089180e+03, 0.00000000e+00, 0.99010000e+00},
    { 39, 34,  0,  2, 0.61553170e+03, 0.00000000e+00, 0.19812000e+01},
    { 39, 34,  1,  0, 0.44813810e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 34,  1,  1, 0.44848720e+03, 0.19153000e+01, 0.99010000e+00},
    { 39, 34,  1,  2, 0.44473220e+03, 0.19153000e+01, 0.19812000e+01},
    { 39, 34,  2,  0, 0.30797330e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 34,  2,  1, 0.30809200e+03, 0.28903000e+01, 0.99010000e+00},
    { 39, 34,  2,  2, 0.30565080e+03, 0.28903000e+01, 0.19812000e+01},
    { 39, 35,  0,  0, 0.52682990e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 35,  0,  1, 0.53134260e+03, 0.00000000e+00, 0.99740000e+00},
    { 39, 35,  1,  0, 0.38429010e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 35,  1,  1, 0.38738760e+03, 0.19153000e+01, 0.99740000e+00},
    { 39, 35,  2,  0, 0.26898800e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 35,  2,  1, 0.27088100e+03, 0.28903000e+01, 0.99740000e+00},
    { 39, 36,  0,  0, 0.44570130e+03, 0.00000000e+00, 0.00000000e+00},
    { 39, 36,  1,  0, 0.32813160e+03, 0.19153000e+01, 0.00000000e+00},
    { 39, 36,  2,  0, 0.23345810e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 37,  0,  0, 0.35209466e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 37,  0,  1, 0.10374434e+04, 0.00000000e+00, 0.97380000e+00},
    { 39, 37,  1,  0, 0.24114577e+04, 0.19153000e+01, 0.00000000e+00},
    { 39, 37,  1,  1, 0.72686130e+03, 0.19153000e+01, 0.97380000e+00},
    { 39, 37,  2,  0, 0.12441578e+04, 0.28903000e+01, 0.00000000e+00},
    { 39, 37,  2,  1, 0.45524600e+03, 0.28903000e+01, 0.97380000e+00},
    { 39, 38,  0,  0, 0.28137007e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 38,  0,  1, 0.23056086e+04, 0.00000000e+00, 0.98010000e+00},
    { 39, 38,  0,  2, 0.10282536e+04, 0.00000000e+00, 0.19143000e+01},
    { 39, 38,  1,  0, 0.19209295e+04, 0.19153000e+01, 0.00000000e+00},
    { 39, 38,  1,  1, 0.15865402e+04, 0.19153000e+01, 0.98010000e+00},
    { 39, 38,  1,  2, 0.72518090e+03, 0.19153000e+01, 0.19143000e+01},
    { 39, 38,  2,  0, 0.10912408e+04, 0.28903000e+01, 0.00000000e+00},
    { 39, 38,  2,  1, 0.89074400e+03, 0.28903000e+01, 0.98010000e+00},
    { 39, 38,  2,  2, 0.46926390e+03, 0.28903000e+01, 0.19143000e+01},
    { 39, 39,  0,  0, 0.23658925e+04, 0.00000000e+00, 0.00000000e+00},
    { 39, 39,  1,  0, 0.16243636e+04, 0.19153000e+01, 0.00000000e+00},
    { 39, 39,  1,  1, 0.11322983e+04, 0.19153000e+01, 0.19153000e+01},
    { 39, 39,  2,  0, 0.95501530e+03, 0.28903000e+01, 0.00000000e+00},
    { 39, 39,  2,  1, 0.67945910e+03, 0.28903000e+01, 0.19153000e+01},
    { 39, 39,  2,  2, 0.45108450e+03, 0.28903000e+01, 0.28903000e+01},
    { 40,  1,  0,  0, 0.63780100e+02, 0.00000000e+00, 0.91180000e+00},
    { 40,  1,  0,  1, 0.10773060e+03, 0.00000000e+00, 0.00000000e+00},
    { 40,  1,  1,  0, 0.39666900e+02, 0.19355000e+01, 0.91180000e+00},
    { 40,  1,  1,  1, 0.64706800e+02, 0.19355000e+01, 0.00000000e+00},
    { 40,  1,  2,  0, 0.36540500e+02, 0.39106000e+01, 0.91180000e+00},
    { 40,  1,  2,  1, 0.58862500e+02, 0.39106000e+01, 0.00000000e+00},
    { 40,  2,  0,  0, 0.39108800e+02, 0.00000000e+00, 0.00000000e+00},
    { 40,  2,  1,  0, 0.25703700e+02, 0.19355000e+01, 0.00000000e+00},
    { 40,  2,  2,  0, 0.24088300e+02, 0.39106000e+01, 0.00000000e+00},
    { 40,  3,  0,  0, 0.13632842e+04, 0.00000000e+00, 0.00000000e+00},
    { 40,  3,  0,  1, 0.39191790e+03, 0.00000000e+00, 0.98650000e+00},
    { 40,  3,  1,  0, 0.67848100e+03, 0.19355000e+01, 0.00000000e+00},
    { 40,  3,  1,  1, 0.21671700e+03, 0.19355000e+01, 0.98650000e+00},
    { 40,  3,  2,  0, 0.56215830e+03, 0.39106000e+01, 0.00000000e+00},
    { 40,  3,  2,  1, 0.19022830e+03, 0.39106000e+01, 0.98650000e+00},
    { 40,  4,  0,  0, 0.68152830e+03, 0.00000000e+00, 0.00000000e+00},
    { 40,  4,  0,  1, 0.49301000e+03, 0.00000000e+00, 0.98080000e+00},
    { 40,  4,  0,  2, 0.29747500e+03, 0.00000000e+00, 0.19697000e+01},
    { 40,  4,  1,  0, 0.37401350e+03, 0.19355000e+01, 0.00000000e+00},
    { 40,  4,  1,  1, 0.27536440e+03, 0.19355000e+01, 0.98080000e+00},
    { 40,  4,  1,  2, 0.17565640e+03, 0.19355000e+01, 0.19697000e+01},
    { 40,  4,  2,  0, 0.32721920e+03, 0.39106000e+01, 0.00000000e+00},
    { 40,  4,  2,  1, 0.24272640e+03, 0.39106000e+01, 0.98080000e+00},
    { 40,  4,  2,  2, 0.15874420e+03, 0.39106000e+01, 0.19697000e+01},
    { 40,  5,  0,  0, 0.42323020e+03, 0.00000000e+00, 0.00000000e+00},
    { 40,  5,  0,  1, 0.35019700e+03, 0.00000000e+00, 0.97060000e+00},
    { 40,  5,  0,  2, 0.28928690e+03, 0.00000000e+00, 0.19441000e+01},
    { 40,  5,  0,  3, 0.20990660e+03, 0.00000000e+00, 0.29128000e+01},
    { 40,  5,  0,  4, 0.19615430e+03, 0.00000000e+00, 0.45856000e+01},
    { 40,  5,  1,  0, 0.24601470e+03, 0.19355000e+01, 0.00000000e+00},
    { 40,  5,  1,  1, 0.20600140e+03, 0.19355000e+01, 0.97060000e+00},
    { 40,  5,  1,  2, 0.17218100e+03, 0.19355000e+01, 0.19441000e+01},
    { 40,  5,  1,  3, 0.12924090e+03, 0.19355000e+01, 0.29128000e+01},
    { 40,  5,  1,  4, 0.12138420e+03, 0.19355000e+01, 0.45856000e+01},
    { 40,  5,  2,  0, 0.22083610e+03, 0.39106000e+01, 0.00000000e+00},
    { 40,  5,  2,  1, 0.18577620e+03, 0.39106000e+01, 0.97060000e+00},
    { 40,  5,  2,  2, 0.15597060e+03, 0.39106000e+01, 0.19441000e+01},
    { 40,  5,  2,  3, 0.11862430e+03, 0.39106000e+01, 0.29128000e+01},
    { 40,  5,  2,  4, 0.11160800e+03, 0.39106000e+01, 0.45856000e+01},
    { 40,  6,  0,  0, 0.26904900e+03, 0.00000000e+00, 0.00000000e+00},
    { 40,  6,  0,  1, 0.25282130e+03, 0.00000000e+00, 0.98680000e+00},
    { 40,  6,  0,  2, 0.20078170e+03, 0.00000000e+00, 0.19985000e+01},
    { 40,  6,  0,  3, 0.18782030e+03, 0.00000000e+00, 0.29987000e+01},
    { 40,  6,  0,  4, 0.14800690e+03, 0.00000000e+00, 0.39844000e+01},
    { 40,  6,  1,  0, 0.16345480e+03, 0.19355000e+01, 0.00000000e+00},
    { 40,  6,  1,  1, 0.15342290e+03, 0.19355000e+01, 0.98680000e+00},
    { 40,  6,  1,  2, 0.12419200e+03, 0.19355000e+01, 0.19985000e+01},
    { 40,  6,  1,  3, 0.11619730e+03, 0.19355000e+01, 0.29987000e+01},
    { 40,  6,  1,  4, 0.94117300e+02, 0.19355000e+01, 0.39844000e+01},
    { 40,  6,  2,  0, 0.14926580e+03, 0.39106000e+01, 0.00000000e+00},
    { 40,  6,  2,  1, 0.13998770e+03, 0.39106000e+01, 0.98680000e+00},
    { 40,  6,  2,  2, 0.11413350e+03, 0.39106000e+01, 0.19985000e+01},
    { 40,  6,  2,  3, 0.10676290e+03, 0.39106000e+01, 0.29987000e+01},
    { 40,  6,  2,  4, 0.87311600e+02, 0.39106000e+01, 0.39844000e+01},
    { 40,  7,  0,  0, 0.17977770e+03, 0.00000000e+00, 0.00000000e+00},
    { 40,  7,  0,  1, 0.16755010e+03, 0.00000000e+00, 0.99440000e+00},
    { 40,  7,  0,  2, 0.15645400e+03, 0.00000000e+00, 0.20143000e+01},
    { 40,  7,  0,  3, 0.13695780e+03, 0.00000000e+00, 0.29903000e+01},
    { 40,  7,  1,  0, 0.11293390e+03, 0.19355000e+01, 0.00000000e+00},
    { 40,  7,  1,  1, 0.10531510e+03, 0.19355000e+01, 0.99440000e+00},
    { 40,  7,  1,  2, 0.98716500e+02, 0.19355000e+01, 0.20143000e+01},
    { 40,  7,  1,  3, 0.86803500e+02, 0.19355000e+01, 0.29903000e+01},
    { 40,  7,  2,  0, 0.10433800e+03, 0.39106000e+01, 0.00000000e+00},
    { 40,  7,  2,  1, 0.97288100e+02, 0.39106000e+01, 0.99440000e+00},
    { 40,  7,  2,  2, 0.91307200e+02, 0.39106000e+01, 0.20143000e+01},
    { 40,  7,  2,  3, 0.80375800e+02, 0.39106000e+01, 0.29903000e+01},
    { 40,  8,  0,  0, 0.13178520e+03, 0.00000000e+00, 0.00000000e+00},
    { 40,  8,  0,  1, 0.11723280e+03, 0.00000000e+00, 0.99250000e+00},
    { 40,  8,  0,  2, 0.10228360e+03, 0.00000000e+00, 0.19887000e+01},
    { 40,  8,  1,  0, 0.84787600e+02, 0.19355000e+01, 0.00000000e+00},
    { 40,  8,  1,  1, 0.75899400e+02, 0.19355000e+01, 0.99250000e+00},
    { 40,  8,  1,  2, 0.66749800e+02, 0.19355000e+01, 0.19887000e+01},
    { 40,  8,  2,  0, 0.78933900e+02, 0.39106000e+01, 0.00000000e+00},
    { 40,  8,  2,  1, 0.70786500e+02, 0.39106000e+01, 0.99250000e+00},
    { 40,  8,  2,  2, 0.62389300e+02, 0.39106000e+01, 0.19887000e+01},
    { 40,  9,  0,  0, 0.97097700e+02, 0.00000000e+00, 0.00000000e+00},
    { 40,  9,  0,  1, 0.76671200e+02, 0.00000000e+00, 0.99820000e+00},
    { 40,  9,  1,  0, 0.63768000e+02, 0.19355000e+01, 0.00000000e+00},
    { 40,  9,  1,  1, 0.51515800e+02, 0.19355000e+01, 0.99820000e+00},
    { 40,  9,  2,  0, 0.59729900e+02, 0.39106000e+01, 0.00000000e+00},
    { 40,  9,  2,  1, 0.48576900e+02, 0.39106000e+01, 0.99820000e+00},
    { 40, 10,  0,  0, 0.73031500e+02, 0.00000000e+00, 0.00000000e+00},
    { 40, 10,  1,  0, 0.48760000e+02, 0.19355000e+01, 0.00000000e+00},
    { 40, 10,  2,  0, 0.45882400e+02, 0.39106000e+01, 0.00000000e+00},
    { 40, 11,  0,  0, 0.16162863e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 11,  0,  1, 0.58124800e+03, 0.00000000e+00, 0.96840000e+00},
    { 40, 11,  1,  0, 0.80899730e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 11,  1,  1, 0.31816780e+03, 0.19355000e+01, 0.96840000e+00},
    { 40, 11,  2,  0, 0.67243030e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 11,  2,  1, 0.27779360e+03, 0.39106000e+01, 0.96840000e+00},
    { 40, 12,  0,  0, 0.11138339e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 12,  0,  1, 0.90577500e+03, 0.00000000e+00, 0.96280000e+00},
    { 40, 12,  0,  2, 0.54679350e+03, 0.00000000e+00, 0.19496000e+01},
    { 40, 12,  1,  0, 0.60055110e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 12,  1,  1, 0.49330570e+03, 0.19355000e+01, 0.96280000e+00},
    { 40, 12,  1,  2, 0.31464020e+03, 0.19355000e+01, 0.19496000e+01},
    { 40, 12,  2,  0, 0.52068680e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 12,  2,  1, 0.42964620e+03, 0.39106000e+01, 0.96280000e+00},
    { 40, 12,  2,  2, 0.28129500e+03, 0.39106000e+01, 0.19496000e+01},
    { 40, 13,  0,  0, 0.98504940e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 13,  0,  1, 0.88385410e+03, 0.00000000e+00, 0.96480000e+00},
    { 40, 13,  0,  2, 0.66503860e+03, 0.00000000e+00, 0.19311000e+01},
    { 40, 13,  0,  3, 0.49495070e+03, 0.00000000e+00, 0.29146000e+01},
    { 40, 13,  1,  0, 0.54671760e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 13,  1,  1, 0.49402450e+03, 0.19355000e+01, 0.96480000e+00},
    { 40, 13,  1,  2, 0.38103090e+03, 0.19355000e+01, 0.19311000e+01},
    { 40, 13,  1,  3, 0.29297650e+03, 0.19355000e+01, 0.29146000e+01},
    { 40, 13,  2,  0, 0.48073130e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 13,  2,  1, 0.43578140e+03, 0.39106000e+01, 0.96480000e+00},
    { 40, 13,  2,  2, 0.33986220e+03, 0.39106000e+01, 0.19311000e+01},
    { 40, 13,  2,  3, 0.26502430e+03, 0.39106000e+01, 0.29146000e+01},
    { 40, 14,  0,  0, 0.73318070e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 14,  0,  1, 0.67218340e+03, 0.00000000e+00, 0.95070000e+00},
    { 40, 14,  0,  2, 0.62007920e+03, 0.00000000e+00, 0.19435000e+01},
    { 40, 14,  0,  3, 0.60808480e+03, 0.00000000e+00, 0.29407000e+01},
    { 40, 14,  0,  4, 0.48073180e+03, 0.00000000e+00, 0.38677000e+01},
    { 40, 14,  1,  0, 0.42369920e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 14,  1,  1, 0.39071920e+03, 0.19355000e+01, 0.95070000e+00},
    { 40, 14,  1,  2, 0.36256720e+03, 0.19355000e+01, 0.19435000e+01},
    { 40, 14,  1,  3, 0.35400180e+03, 0.19355000e+01, 0.29407000e+01},
    { 40, 14,  1,  4, 0.28794440e+03, 0.19355000e+01, 0.38677000e+01},
    { 40, 14,  2,  0, 0.37942120e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 14,  2,  1, 0.35070760e+03, 0.39106000e+01, 0.95070000e+00},
    { 40, 14,  2,  2, 0.32624310e+03, 0.39106000e+01, 0.19435000e+01},
    { 40, 14,  2,  3, 0.31785670e+03, 0.39106000e+01, 0.29407000e+01},
    { 40, 14,  2,  4, 0.26164690e+03, 0.39106000e+01, 0.38677000e+01},
    { 40, 15,  0,  0, 0.54488820e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 15,  0,  1, 0.52808410e+03, 0.00000000e+00, 0.99470000e+00},
    { 40, 15,  0,  2, 0.52257210e+03, 0.00000000e+00, 0.20102000e+01},
    { 40, 15,  0,  3, 0.47851960e+03, 0.00000000e+00, 0.29859000e+01},
    { 40, 15,  1,  0, 0.32600870e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 15,  1,  1, 0.31631690e+03, 0.19355000e+01, 0.99470000e+00},
    { 40, 15,  1,  2, 0.31230500e+03, 0.19355000e+01, 0.20102000e+01},
    { 40, 15,  1,  3, 0.28866370e+03, 0.19355000e+01, 0.29859000e+01},
    { 40, 15,  2,  0, 0.29608060e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 15,  2,  1, 0.28738300e+03, 0.39106000e+01, 0.99470000e+00},
    { 40, 15,  2,  2, 0.28345370e+03, 0.39106000e+01, 0.20102000e+01},
    { 40, 15,  2,  3, 0.26296750e+03, 0.39106000e+01, 0.29859000e+01},
    { 40, 16,  0,  0, 0.43838900e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 16,  0,  1, 0.43390360e+03, 0.00000000e+00, 0.99480000e+00},
    { 40, 16,  0,  2, 0.42487480e+03, 0.00000000e+00, 0.19903000e+01},
    { 40, 16,  1,  0, 0.26830770e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 16,  1,  1, 0.26540890e+03, 0.19355000e+01, 0.99480000e+00},
    { 40, 16,  1,  2, 0.25999910e+03, 0.19355000e+01, 0.19903000e+01},
    { 40, 16,  2,  0, 0.24572860e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 16,  2,  1, 0.24300890e+03, 0.39106000e+01, 0.99480000e+00},
    { 40, 16,  2,  2, 0.23808430e+03, 0.39106000e+01, 0.19903000e+01},
    { 40, 17,  0,  0, 0.34753340e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 17,  0,  1, 0.34413180e+03, 0.00000000e+00, 0.99720000e+00},
    { 40, 17,  1,  0, 0.21743220e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 17,  1,  1, 0.21521010e+03, 0.19355000e+01, 0.99720000e+00},
    { 40, 17,  2,  0, 0.20066650e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 17,  2,  1, 0.19857750e+03, 0.39106000e+01, 0.99720000e+00},
    { 40, 18,  0,  0, 0.27699080e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 18,  1,  0, 0.17666900e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 18,  2,  0, 0.16407610e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 19,  0,  0, 0.27111542e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 19,  0,  1, 0.77852380e+03, 0.00000000e+00, 0.97670000e+00},
    { 40, 19,  1,  0, 0.13359899e+04, 0.19355000e+01, 0.00000000e+00},
    { 40, 19,  1,  1, 0.43506490e+03, 0.19355000e+01, 0.97670000e+00},
    { 40, 19,  2,  0, 0.10998393e+04, 0.39106000e+01, 0.00000000e+00},
    { 40, 19,  2,  1, 0.38302240e+03, 0.39106000e+01, 0.97670000e+00},
    { 40, 20,  0,  0, 0.20485251e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 20,  0,  1, 0.16379667e+04, 0.00000000e+00, 0.98310000e+00},
    { 40, 20,  0,  2, 0.76820000e+03, 0.00000000e+00, 0.19349000e+01},
    { 40, 20,  1,  0, 0.10709104e+04, 0.19355000e+01, 0.00000000e+00},
    { 40, 20,  1,  1, 0.85671310e+03, 0.19355000e+01, 0.98310000e+00},
    { 40, 20,  1,  2, 0.44149510e+03, 0.19355000e+01, 0.19349000e+01},
    { 40, 20,  2,  0, 0.91252050e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 20,  2,  1, 0.72962110e+03, 0.39106000e+01, 0.98310000e+00},
    { 40, 20,  2,  2, 0.39411100e+03, 0.39106000e+01, 0.19349000e+01},
    { 40, 21,  0,  0, 0.16591156e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 21,  0,  1, 0.74343180e+03, 0.00000000e+00, 0.18627000e+01},
    { 40, 21,  0,  2, 0.72178370e+03, 0.00000000e+00, 0.28999000e+01},
    { 40, 21,  1,  0, 0.87901650e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 21,  1,  1, 0.42930190e+03, 0.19355000e+01, 0.18627000e+01},
    { 40, 21,  1,  2, 0.42153880e+03, 0.19355000e+01, 0.28999000e+01},
    { 40, 21,  2,  0, 0.75461820e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 21,  2,  1, 0.38386450e+03, 0.39106000e+01, 0.18627000e+01},
    { 40, 21,  2,  2, 0.37893950e+03, 0.39106000e+01, 0.28999000e+01},
    { 40, 22,  0,  0, 0.15741401e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 22,  0,  1, 0.71686090e+03, 0.00000000e+00, 0.18299000e+01},
    { 40, 22,  0,  2, 0.72942430e+03, 0.00000000e+00, 0.38675000e+01},
    { 40, 22,  1,  0, 0.84415650e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 22,  1,  1, 0.41420300e+03, 0.19355000e+01, 0.18299000e+01},
    { 40, 22,  1,  2, 0.42651570e+03, 0.19355000e+01, 0.38675000e+01},
    { 40, 22,  2,  0, 0.72916220e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 22,  2,  1, 0.37051580e+03, 0.39106000e+01, 0.18299000e+01},
    { 40, 22,  2,  2, 0.38359990e+03, 0.39106000e+01, 0.38675000e+01},
    { 40, 23,  0,  0, 0.14260687e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 23,  0,  1, 0.70307840e+03, 0.00000000e+00, 0.19138000e+01},
    { 40, 23,  0,  2, 0.66896670e+03, 0.00000000e+00, 0.29110000e+01},
    { 40, 23,  1,  0, 0.77041850e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 23,  1,  1, 0.40602230e+03, 0.19355000e+01, 0.19138000e+01},
    { 40, 23,  1,  2, 0.39060560e+03, 0.19355000e+01, 0.29110000e+01},
    { 40, 23,  2,  0, 0.66796950e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 23,  2,  1, 0.36307110e+03, 0.39106000e+01, 0.19138000e+01},
    { 40, 23,  2,  2, 0.35096590e+03, 0.39106000e+01, 0.29110000e+01},
    { 40, 24,  0,  0, 0.11215489e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 24,  0,  1, 0.70054320e+03, 0.00000000e+00, 0.18269000e+01},
    { 40, 24,  0,  2, 0.48594470e+03, 0.00000000e+00, 0.10619100e+02},
    { 40, 24,  1,  0, 0.60670400e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 24,  1,  1, 0.40292000e+03, 0.19355000e+01, 0.18269000e+01},
    { 40, 24,  1,  2, 0.29122970e+03, 0.19355000e+01, 0.10619100e+02},
    { 40, 24,  2,  0, 0.52595350e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 24,  2,  1, 0.35962670e+03, 0.39106000e+01, 0.18269000e+01},
    { 40, 24,  2,  2, 0.26433470e+03, 0.39106000e+01, 0.10619100e+02},
    { 40, 25,  0,  0, 0.12087451e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 25,  0,  1, 0.62707900e+03, 0.00000000e+00, 0.16406000e+01},
    { 40, 25,  0,  2, 0.40632670e+03, 0.00000000e+00, 0.98849000e+01},
    { 40, 25,  1,  0, 0.66010050e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 25,  1,  1, 0.36779370e+03, 0.19355000e+01, 0.16406000e+01},
    { 40, 25,  1,  2, 0.24759810e+03, 0.19355000e+01, 0.98849000e+01},
    { 40, 25,  2,  0, 0.57539200e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 25,  2,  1, 0.33118730e+03, 0.39106000e+01, 0.16406000e+01},
    { 40, 25,  2,  2, 0.22616840e+03, 0.39106000e+01, 0.98849000e+01},
    { 40, 26,  0,  0, 0.94517130e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 26,  0,  1, 0.57577520e+03, 0.00000000e+00, 0.16483000e+01},
    { 40, 26,  0,  2, 0.39992950e+03, 0.00000000e+00, 0.91376000e+01},
    { 40, 26,  1,  0, 0.51758120e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 26,  1,  1, 0.33962780e+03, 0.19355000e+01, 0.16483000e+01},
    { 40, 26,  1,  2, 0.24320860e+03, 0.19355000e+01, 0.91376000e+01},
    { 40, 26,  2,  0, 0.45141300e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 26,  2,  1, 0.30651240e+03, 0.39106000e+01, 0.16483000e+01},
    { 40, 26,  2,  2, 0.22198580e+03, 0.39106000e+01, 0.91376000e+01},
    { 40, 27,  0,  0, 0.97897670e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 27,  0,  1, 0.54932940e+03, 0.00000000e+00, 0.17149000e+01},
    { 40, 27,  0,  2, 0.48633250e+03, 0.00000000e+00, 0.29263000e+01},
    { 40, 27,  0,  3, 0.42252080e+03, 0.00000000e+00, 0.77785000e+01},
    { 40, 27,  1,  0, 0.54466430e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 27,  1,  1, 0.32399210e+03, 0.19355000e+01, 0.17149000e+01},
    { 40, 27,  1,  2, 0.28802430e+03, 0.19355000e+01, 0.29263000e+01},
    { 40, 27,  1,  3, 0.25466980e+03, 0.19355000e+01, 0.77785000e+01},
    { 40, 27,  2,  0, 0.47910890e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 27,  2,  1, 0.29235140e+03, 0.39106000e+01, 0.17149000e+01},
    { 40, 27,  2,  2, 0.26021080e+03, 0.39106000e+01, 0.29263000e+01},
    { 40, 27,  2,  3, 0.23167830e+03, 0.39106000e+01, 0.77785000e+01},
    { 40, 28,  0,  0, 0.10197589e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 28,  0,  1, 0.53824800e+03, 0.00000000e+00, 0.17937000e+01},
    { 40, 28,  0,  2, 0.44816000e+03, 0.00000000e+00, 0.65458000e+01},
    { 40, 28,  0,  3, 0.48150000e+03, 0.00000000e+00, 0.62918000e+01},
    { 40, 28,  1,  0, 0.56293440e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 28,  1,  1, 0.31694170e+03, 0.19355000e+01, 0.17937000e+01},
    { 40, 28,  1,  2, 0.26749730e+03, 0.19355000e+01, 0.65458000e+01},
    { 40, 28,  1,  3, 0.28270210e+03, 0.19355000e+01, 0.62918000e+01},
    { 40, 28,  2,  0, 0.49336920e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 28,  2,  1, 0.28578230e+03, 0.39106000e+01, 0.17937000e+01},
    { 40, 28,  2,  2, 0.24244220e+03, 0.39106000e+01, 0.65458000e+01},
    { 40, 28,  2,  3, 0.25445670e+03, 0.39106000e+01, 0.62918000e+01},
    { 40, 29,  0,  0, 0.78111330e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 29,  0,  1, 0.54294990e+03, 0.00000000e+00, 0.95760000e+00},
    { 40, 29,  1,  0, 0.43155440e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 29,  1,  1, 0.31499080e+03, 0.19355000e+01, 0.95760000e+00},
    { 40, 29,  2,  0, 0.37799640e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 29,  2,  1, 0.28217240e+03, 0.39106000e+01, 0.95760000e+00},
    { 40, 30,  0,  0, 0.77458710e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 30,  0,  1, 0.49050970e+03, 0.00000000e+00, 0.19419000e+01},
    { 40, 30,  1,  0, 0.43840800e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 30,  1,  1, 0.29240050e+03, 0.19355000e+01, 0.19419000e+01},
    { 40, 30,  2,  0, 0.38872950e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 30,  2,  1, 0.26504020e+03, 0.39106000e+01, 0.19419000e+01},
    { 40, 31,  0,  0, 0.92819820e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 31,  0,  1, 0.86203630e+03, 0.00000000e+00, 0.96010000e+00},
    { 40, 31,  0,  2, 0.65685920e+03, 0.00000000e+00, 0.19315000e+01},
    { 40, 31,  0,  3, 0.51656560e+03, 0.00000000e+00, 0.29233000e+01},
    { 40, 31,  1,  0, 0.52118020e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 31,  1,  1, 0.48787590e+03, 0.19355000e+01, 0.96010000e+00},
    { 40, 31,  1,  2, 0.38219520e+03, 0.19355000e+01, 0.19315000e+01},
    { 40, 31,  1,  3, 0.30919640e+03, 0.19355000e+01, 0.29233000e+01},
    { 40, 31,  2,  0, 0.46049590e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 31,  2,  1, 0.43263090e+03, 0.39106000e+01, 0.96010000e+00},
    { 40, 31,  2,  2, 0.34305200e+03, 0.39106000e+01, 0.19315000e+01},
    { 40, 31,  2,  3, 0.28082410e+03, 0.39106000e+01, 0.29233000e+01},
    { 40, 32,  0,  0, 0.78294420e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 32,  0,  1, 0.72498050e+03, 0.00000000e+00, 0.94340000e+00},
    { 40, 32,  0,  2, 0.68527160e+03, 0.00000000e+00, 0.19447000e+01},
    { 40, 32,  0,  3, 0.60315190e+03, 0.00000000e+00, 0.29186000e+01},
    { 40, 32,  0,  4, 0.52045920e+03, 0.00000000e+00, 0.38972000e+01},
    { 40, 32,  1,  0, 0.45369050e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 32,  1,  1, 0.42320760e+03, 0.19355000e+01, 0.94340000e+00},
    { 40, 32,  1,  2, 0.40208770e+03, 0.19355000e+01, 0.19447000e+01},
    { 40, 32,  1,  3, 0.35847720e+03, 0.19355000e+01, 0.29186000e+01},
    { 40, 32,  1,  4, 0.31443980e+03, 0.19355000e+01, 0.38972000e+01},
    { 40, 32,  2,  0, 0.40661960e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 32,  2,  1, 0.38045750e+03, 0.39106000e+01, 0.94340000e+00},
    { 40, 32,  2,  2, 0.36224070e+03, 0.39106000e+01, 0.19447000e+01},
    { 40, 32,  2,  3, 0.32464310e+03, 0.39106000e+01, 0.29186000e+01},
    { 40, 32,  2,  4, 0.28662000e+03, 0.39106000e+01, 0.38972000e+01},
    { 40, 33,  0,  0, 0.64155640e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 33,  0,  1, 0.62921900e+03, 0.00000000e+00, 0.98890000e+00},
    { 40, 33,  0,  2, 0.61017610e+03, 0.00000000e+00, 0.19793000e+01},
    { 40, 33,  0,  3, 0.58401600e+03, 0.00000000e+00, 0.29709000e+01},
    { 40, 33,  1,  0, 0.38264580e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 33,  1,  1, 0.37591790e+03, 0.19355000e+01, 0.98890000e+00},
    { 40, 33,  1,  2, 0.36563120e+03, 0.19355000e+01, 0.19793000e+01},
    { 40, 33,  1,  3, 0.35156410e+03, 0.19355000e+01, 0.29709000e+01},
    { 40, 33,  2,  0, 0.34703710e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 33,  2,  1, 0.34114820e+03, 0.39106000e+01, 0.98890000e+00},
    { 40, 33,  2,  2, 0.33219680e+03, 0.39106000e+01, 0.19793000e+01},
    { 40, 33,  2,  3, 0.31999160e+03, 0.39106000e+01, 0.29709000e+01},
    { 40, 34,  0,  0, 0.56154740e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 34,  0,  1, 0.56200010e+03, 0.00000000e+00, 0.99010000e+00},
    { 40, 34,  0,  2, 0.55720710e+03, 0.00000000e+00, 0.19812000e+01},
    { 40, 34,  1,  0, 0.34103380e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 34,  1,  1, 0.34120400e+03, 0.19355000e+01, 0.99010000e+00},
    { 40, 34,  1,  2, 0.33846100e+03, 0.19355000e+01, 0.19812000e+01},
    { 40, 34,  2,  0, 0.31142450e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 34,  2,  1, 0.31153680e+03, 0.39106000e+01, 0.99010000e+00},
    { 40, 34,  2,  2, 0.30908380e+03, 0.39106000e+01, 0.19812000e+01},
    { 40, 35,  0,  0, 0.47900400e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 35,  0,  1, 0.48298730e+03, 0.00000000e+00, 0.99740000e+00},
    { 40, 35,  1,  0, 0.29639440e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 35,  1,  1, 0.29856340e+03, 0.19355000e+01, 0.99740000e+00},
    { 40, 35,  2,  0, 0.27249100e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 35,  2,  1, 0.27438370e+03, 0.39106000e+01, 0.99740000e+00},
    { 40, 36,  0,  0, 0.40687270e+03, 0.00000000e+00, 0.00000000e+00},
    { 40, 36,  1,  0, 0.25615010e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 36,  2,  0, 0.23688550e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 37,  0,  0, 0.30176856e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 37,  0,  1, 0.92013580e+03, 0.00000000e+00, 0.97380000e+00},
    { 40, 37,  1,  0, 0.14937993e+04, 0.19355000e+01, 0.00000000e+00},
    { 40, 37,  1,  1, 0.51769610e+03, 0.19355000e+01, 0.97380000e+00},
    { 40, 37,  2,  0, 0.12329252e+04, 0.39106000e+01, 0.00000000e+00},
    { 40, 37,  2,  1, 0.45707170e+03, 0.39106000e+01, 0.97380000e+00},
    { 40, 38,  0,  0, 0.24494723e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 38,  0,  1, 0.20037829e+04, 0.00000000e+00, 0.98010000e+00},
    { 40, 38,  0,  2, 0.91823780e+03, 0.00000000e+00, 0.19143000e+01},
    { 40, 38,  1,  0, 0.12775813e+04, 0.19355000e+01, 0.00000000e+00},
    { 40, 38,  1,  1, 0.10443401e+04, 0.19355000e+01, 0.98010000e+00},
    { 40, 38,  1,  2, 0.52865740e+03, 0.19355000e+01, 0.19143000e+01},
    { 40, 38,  2,  0, 0.10868394e+04, 0.39106000e+01, 0.00000000e+00},
    { 40, 38,  2,  1, 0.88748100e+03, 0.39106000e+01, 0.98010000e+00},
    { 40, 38,  2,  2, 0.47210810e+03, 0.39106000e+01, 0.19143000e+01},
    { 40, 39,  0,  0, 0.20726170e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 39,  0,  1, 0.14293576e+04, 0.00000000e+00, 0.19153000e+01},
    { 40, 39,  0,  2, 0.85765270e+03, 0.00000000e+00, 0.28903000e+01},
    { 40, 39,  1,  0, 0.11066630e+04, 0.19355000e+01, 0.00000000e+00},
    { 40, 39,  1,  1, 0.78082120e+03, 0.19355000e+01, 0.19153000e+01},
    { 40, 39,  1,  2, 0.50443250e+03, 0.19355000e+01, 0.28903000e+01},
    { 40, 39,  2,  0, 0.95348210e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 39,  2,  1, 0.68026830e+03, 0.39106000e+01, 0.19153000e+01},
    { 40, 39,  2,  2, 0.45473560e+03, 0.39106000e+01, 0.28903000e+01},
    { 40, 40,  0,  0, 0.18227181e+04, 0.00000000e+00, 0.00000000e+00},
    { 40, 40,  1,  0, 0.98782570e+03, 0.19355000e+01, 0.00000000e+00},
    { 40, 40,  1,  1, 0.56867890e+03, 0.19355000e+01, 0.19355000e+01},
    { 40, 40,  2,  0, 0.85760110e+03, 0.39106000e+01, 0.00000000e+00},
    { 40, 40,  2,  1, 0.50752160e+03, 0.39106000e+01, 0.19355000e+01},
    { 40, 40,  2,  2, 0.45868960e+03, 0.39106000e+01, 0.39106000e+01},
    { 41,  1,  0,  0, 0.58676800e+02, 0.00000000e+00, 0.91180000e+00},
    { 41,  1,  0,  1, 0.98518300e+02, 0.00000000e+00, 0.00000000e+00},
    { 41,  1,  1,  0, 0.40030400e+02, 0.19545000e+01, 0.91180000e+00},
    { 41,  1,  1,  1, 0.65312900e+02, 0.19545000e+01, 0.00000000e+00},
    { 41,  1,  2,  0, 0.35315200e+02, 0.29225000e+01, 0.91180000e+00},
    { 41,  1,  2,  1, 0.56846600e+02, 0.29225000e+01, 0.00000000e+00},
    { 41,  2,  0,  0, 0.36341800e+02, 0.00000000e+00, 0.00000000e+00},
    { 41,  2,  1,  0, 0.25953400e+02, 0.19545000e+01, 0.00000000e+00},
    { 41,  2,  2,  0, 0.23359200e+02, 0.29225000e+01, 0.00000000e+00},
    { 41,  3,  0,  0, 0.12090304e+04, 0.00000000e+00, 0.00000000e+00},
    { 41,  3,  0,  1, 0.35350080e+03, 0.00000000e+00, 0.98650000e+00},
    { 41,  3,  1,  0, 0.68410400e+03, 0.19545000e+01, 0.00000000e+00},
    { 41,  3,  1,  1, 0.21897060e+03, 0.19545000e+01, 0.98650000e+00},
    { 41,  3,  2,  0, 0.54961140e+03, 0.29225000e+01, 0.00000000e+00},
    { 41,  3,  2,  1, 0.18412220e+03, 0.29225000e+01, 0.98650000e+00},
    { 41,  4,  0,  0, 0.61398500e+03, 0.00000000e+00, 0.00000000e+00},
    { 41,  4,  0,  1, 0.44537360e+03, 0.00000000e+00, 0.98080000e+00},
    { 41,  4,  0,  2, 0.27126060e+03, 0.00000000e+00, 0.19697000e+01},
    { 41,  4,  1,  0, 0.37796930e+03, 0.19545000e+01, 0.00000000e+00},
    { 41,  4,  1,  1, 0.27808810e+03, 0.19545000e+01, 0.98080000e+00},
    { 41,  4,  1,  2, 0.17733570e+03, 0.19545000e+01, 0.19697000e+01},
    { 41,  4,  2,  0, 0.31671620e+03, 0.29225000e+01, 0.00000000e+00},
    { 41,  4,  2,  1, 0.23495680e+03, 0.29225000e+01, 0.98080000e+00},
    { 41,  4,  2,  2, 0.15329480e+03, 0.29225000e+01, 0.19697000e+01},
    { 41,  5,  0,  0, 0.38490720e+03, 0.00000000e+00, 0.00000000e+00},
    { 41,  5,  0,  1, 0.31911510e+03, 0.00000000e+00, 0.97060000e+00},
    { 41,  5,  0,  2, 0.26412850e+03, 0.00000000e+00, 0.19441000e+01},
    { 41,  5,  0,  3, 0.19277650e+03, 0.00000000e+00, 0.29128000e+01},
    { 41,  5,  0,  4, 0.18030420e+03, 0.00000000e+00, 0.45856000e+01},
    { 41,  5,  1,  0, 0.24842660e+03, 0.19545000e+01, 0.00000000e+00},
    { 41,  5,  1,  1, 0.20799430e+03, 0.19545000e+01, 0.97060000e+00},
    { 41,  5,  1,  2, 0.17379460e+03, 0.19545000e+01, 0.19441000e+01},
    { 41,  5,  1,  3, 0.13043790e+03, 0.19545000e+01, 0.29128000e+01},
    { 41,  5,  1,  4, 0.12250750e+03, 0.19545000e+01, 0.45856000e+01},
    { 41,  5,  2,  0, 0.21337350e+03, 0.29225000e+01, 0.00000000e+00},
    { 41,  5,  2,  1, 0.17952910e+03, 0.29225000e+01, 0.97060000e+00},
    { 41,  5,  2,  2, 0.15076980e+03, 0.29225000e+01, 0.19441000e+01},
    { 41,  5,  2,  3, 0.11463280e+03, 0.29225000e+01, 0.29128000e+01},
    { 41,  5,  2,  4, 0.10787110e+03, 0.29225000e+01, 0.45856000e+01},
    { 41,  6,  0,  0, 0.24652410e+03, 0.00000000e+00, 0.00000000e+00},
    { 41,  6,  0,  1, 0.23159760e+03, 0.00000000e+00, 0.98680000e+00},
    { 41,  6,  0,  2, 0.18454770e+03, 0.00000000e+00, 0.19985000e+01},
    { 41,  6,  0,  3, 0.17263950e+03, 0.00000000e+00, 0.29987000e+01},
    { 41,  6,  0,  4, 0.13670500e+03, 0.00000000e+00, 0.39844000e+01},
    { 41,  6,  1,  0, 0.16499800e+03, 0.19545000e+01, 0.00000000e+00},
    { 41,  6,  1,  1, 0.15487640e+03, 0.19545000e+01, 0.98680000e+00},
    { 41,  6,  1,  2, 0.12536250e+03, 0.19545000e+01, 0.19985000e+01},
    { 41,  6,  1,  3, 0.11730510e+03, 0.19545000e+01, 0.29987000e+01},
    { 41,  6,  1,  4, 0.95000900e+02, 0.19545000e+01, 0.39844000e+01},
    { 41,  6,  2,  0, 0.14425580e+03, 0.29225000e+01, 0.00000000e+00},
    { 41,  6,  2,  1, 0.13534930e+03, 0.29225000e+01, 0.98680000e+00},
    { 41,  6,  2,  2, 0.11036390e+03, 0.29225000e+01, 0.19985000e+01},
    { 41,  6,  2,  3, 0.10327750e+03, 0.29225000e+01, 0.29987000e+01},
    { 41,  6,  2,  4, 0.84504100e+02, 0.29225000e+01, 0.39844000e+01},
    { 41,  7,  0,  0, 0.16569430e+03, 0.00000000e+00, 0.00000000e+00},
    { 41,  7,  0,  1, 0.15443560e+03, 0.00000000e+00, 0.99440000e+00},
    { 41,  7,  0,  2, 0.14431220e+03, 0.00000000e+00, 0.20143000e+01},
    { 41,  7,  0,  3, 0.12643070e+03, 0.00000000e+00, 0.29903000e+01},
    { 41,  7,  1,  0, 0.11399890e+03, 0.19545000e+01, 0.00000000e+00},
    { 41,  7,  1,  1, 0.10631410e+03, 0.19545000e+01, 0.99440000e+00},
    { 41,  7,  1,  2, 0.99662500e+02, 0.19545000e+01, 0.20143000e+01},
    { 41,  7,  1,  3, 0.87650400e+02, 0.19545000e+01, 0.29903000e+01},
    { 41,  7,  2,  0, 0.10094600e+03, 0.29225000e+01, 0.00000000e+00},
    { 41,  7,  2,  1, 0.94163100e+02, 0.29225000e+01, 0.99440000e+00},
    { 41,  7,  2,  2, 0.88394400e+02, 0.29225000e+01, 0.20143000e+01},
    { 41,  7,  2,  3, 0.77868100e+02, 0.29225000e+01, 0.29903000e+01},
    { 41,  8,  0,  0, 0.12198680e+03, 0.00000000e+00, 0.00000000e+00},
    { 41,  8,  0,  1, 0.10863780e+03, 0.00000000e+00, 0.99250000e+00},
    { 41,  8,  0,  2, 0.94928100e+02, 0.00000000e+00, 0.19887000e+01},
    { 41,  8,  1,  0, 0.85602400e+02, 0.19545000e+01, 0.00000000e+00},
    { 41,  8,  1,  1, 0.76634700e+02, 0.19545000e+01, 0.99250000e+00},
    { 41,  8,  1,  2, 0.67412800e+02, 0.19545000e+01, 0.19887000e+01},
    { 41,  8,  2,  0, 0.76465800e+02, 0.29225000e+01, 0.00000000e+00},
    { 41,  8,  2,  1, 0.68608700e+02, 0.29225000e+01, 0.99250000e+00},
    { 41,  8,  2,  2, 0.60521700e+02, 0.29225000e+01, 0.19887000e+01},
    { 41,  9,  0,  0, 0.90223400e+02, 0.00000000e+00, 0.00000000e+00},
    { 41,  9,  0,  1, 0.71549300e+02, 0.00000000e+00, 0.99820000e+00},
    { 41,  9,  1,  0, 0.64401000e+02, 0.19545000e+01, 0.00000000e+00},
    { 41,  9,  1,  1, 0.52041200e+02, 0.19545000e+01, 0.99820000e+00},
    { 41,  9,  2,  0, 0.57946700e+02, 0.29225000e+01, 0.00000000e+00},
    { 41,  9,  2,  1, 0.47194100e+02, 0.29225000e+01, 0.99820000e+00},
    { 41, 10,  0,  0, 0.68076900e+02, 0.00000000e+00, 0.00000000e+00},
    { 41, 10,  1,  0, 0.49263500e+02, 0.19545000e+01, 0.00000000e+00},
    { 41, 10,  2,  0, 0.44577600e+02, 0.29225000e+01, 0.00000000e+00},
    { 41, 11,  0,  0, 0.14346641e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 11,  0,  1, 0.52340580e+03, 0.00000000e+00, 0.96840000e+00},
    { 41, 11,  1,  0, 0.81603170e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 11,  1,  1, 0.32153780e+03, 0.19545000e+01, 0.96840000e+00},
    { 41, 11,  2,  0, 0.65711510e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 11,  2,  1, 0.26917780e+03, 0.29225000e+01, 0.96840000e+00},
    { 41, 12,  0,  0, 0.10005663e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 12,  0,  1, 0.81492890e+03, 0.00000000e+00, 0.96280000e+00},
    { 41, 12,  0,  2, 0.49648070e+03, 0.00000000e+00, 0.19496000e+01},
    { 41, 12,  1,  0, 0.60700730e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 12,  1,  1, 0.49834860e+03, 0.19545000e+01, 0.96280000e+00},
    { 41, 12,  1,  2, 0.31779230e+03, 0.19545000e+01, 0.19496000e+01},
    { 41, 12,  2,  0, 0.50467530e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 12,  2,  1, 0.41641830e+03, 0.29225000e+01, 0.96280000e+00},
    { 41, 12,  2,  2, 0.27178760e+03, 0.29225000e+01, 0.19496000e+01},
    { 41, 13,  0,  0, 0.88903020e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 13,  0,  1, 0.79860940e+03, 0.00000000e+00, 0.96480000e+00},
    { 41, 13,  0,  2, 0.60335750e+03, 0.00000000e+00, 0.19311000e+01},
    { 41, 13,  0,  3, 0.45153080e+03, 0.00000000e+00, 0.29146000e+01},
    { 41, 13,  1,  0, 0.55235500e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 13,  1,  1, 0.49907610e+03, 0.19545000e+01, 0.96480000e+00},
    { 41, 13,  1,  2, 0.38476780e+03, 0.19545000e+01, 0.19311000e+01},
    { 41, 13,  1,  3, 0.29577860e+03, 0.19545000e+01, 0.29146000e+01},
    { 41, 13,  2,  0, 0.46522590e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 13,  2,  1, 0.42164610e+03, 0.29225000e+01, 0.96480000e+00},
    { 41, 13,  2,  2, 0.32857270e+03, 0.29225000e+01, 0.19311000e+01},
    { 41, 13,  2,  3, 0.25593200e+03, 0.29225000e+01, 0.29146000e+01},
    { 41, 14,  0,  0, 0.66615070e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 14,  0,  1, 0.61131470e+03, 0.00000000e+00, 0.95070000e+00},
    { 41, 14,  0,  2, 0.56449010e+03, 0.00000000e+00, 0.19435000e+01},
    { 41, 14,  0,  3, 0.55314470e+03, 0.00000000e+00, 0.29407000e+01},
    { 41, 14,  0,  4, 0.43942810e+03, 0.00000000e+00, 0.38677000e+01},
    { 41, 14,  1,  0, 0.42788370e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 14,  1,  1, 0.39454030e+03, 0.19545000e+01, 0.95070000e+00},
    { 41, 14,  1,  2, 0.36609840e+03, 0.19545000e+01, 0.19435000e+01},
    { 41, 14,  1,  3, 0.35746120e+03, 0.19545000e+01, 0.29407000e+01},
    { 41, 14,  1,  4, 0.29066410e+03, 0.19545000e+01, 0.38677000e+01},
    { 41, 14,  2,  0, 0.36661690e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 14,  2,  1, 0.33887850e+03, 0.29225000e+01, 0.95070000e+00},
    { 41, 14,  2,  2, 0.31520730e+03, 0.29225000e+01, 0.19435000e+01},
    { 41, 14,  2,  3, 0.30723810e+03, 0.29225000e+01, 0.29407000e+01},
    { 41, 14,  2,  4, 0.25270610e+03, 0.29225000e+01, 0.38677000e+01},
    { 41, 15,  0,  0, 0.49797030e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 15,  0,  1, 0.48270360e+03, 0.00000000e+00, 0.99470000e+00},
    { 41, 15,  0,  2, 0.47747720e+03, 0.00000000e+00, 0.20102000e+01},
    { 41, 15,  0,  3, 0.43792800e+03, 0.00000000e+00, 0.29859000e+01},
    { 41, 15,  1,  0, 0.32909470e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 15,  1,  1, 0.31930990e+03, 0.19545000e+01, 0.99470000e+00},
    { 41, 15,  1,  2, 0.31527630e+03, 0.19545000e+01, 0.20102000e+01},
    { 41, 15,  1,  3, 0.29138130e+03, 0.19545000e+01, 0.29859000e+01},
    { 41, 15,  2,  0, 0.28599260e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 15,  2,  1, 0.27761880e+03, 0.29225000e+01, 0.99470000e+00},
    { 41, 15,  2,  2, 0.27386490e+03, 0.29225000e+01, 0.20102000e+01},
    { 41, 15,  2,  3, 0.25404600e+03, 0.29225000e+01, 0.29859000e+01},
    { 41, 16,  0,  0, 0.40219740e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 16,  0,  1, 0.39804190e+03, 0.00000000e+00, 0.99480000e+00},
    { 41, 16,  0,  2, 0.38978890e+03, 0.00000000e+00, 0.19903000e+01},
    { 41, 16,  1,  0, 0.27080590e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 16,  1,  1, 0.26788580e+03, 0.19545000e+01, 0.99480000e+00},
    { 41, 16,  1,  2, 0.26242950e+03, 0.19545000e+01, 0.19903000e+01},
    { 41, 16,  2,  0, 0.23744480e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 16,  2,  1, 0.23483210e+03, 0.29225000e+01, 0.99480000e+00},
    { 41, 16,  2,  2, 0.23008710e+03, 0.29225000e+01, 0.19903000e+01},
    { 41, 17,  0,  0, 0.32006760e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 17,  0,  1, 0.31691100e+03, 0.00000000e+00, 0.99720000e+00},
    { 41, 17,  1,  0, 0.21944620e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 17,  1,  1, 0.21720780e+03, 0.19545000e+01, 0.99720000e+00},
    { 41, 17,  2,  0, 0.19403010e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 17,  2,  1, 0.19201920e+03, 0.29225000e+01, 0.99720000e+00},
    { 41, 18,  0,  0, 0.25597690e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 18,  1,  0, 0.17831830e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 18,  2,  0, 0.15879150e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 19,  0,  0, 0.24006918e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 19,  0,  1, 0.70330600e+03, 0.00000000e+00, 0.97670000e+00},
    { 41, 19,  1,  0, 0.13433714e+04, 0.19545000e+01, 0.00000000e+00},
    { 41, 19,  1,  1, 0.43952280e+03, 0.19545000e+01, 0.97670000e+00},
    { 41, 19,  2,  0, 0.10788336e+04, 0.29225000e+01, 0.00000000e+00},
    { 41, 19,  2,  1, 0.37144330e+03, 0.29225000e+01, 0.97670000e+00},
    { 41, 20,  0,  0, 0.18308523e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 20,  0,  1, 0.14638890e+04, 0.00000000e+00, 0.98310000e+00},
    { 41, 20,  0,  2, 0.69731480e+03, 0.00000000e+00, 0.19349000e+01},
    { 41, 20,  1,  0, 0.10819930e+04, 0.19545000e+01, 0.00000000e+00},
    { 41, 20,  1,  1, 0.86414110e+03, 0.19545000e+01, 0.98310000e+00},
    { 41, 20,  1,  2, 0.44598950e+03, 0.19545000e+01, 0.19349000e+01},
    { 41, 20,  2,  0, 0.88761670e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 20,  2,  1, 0.71075730e+03, 0.29225000e+01, 0.98310000e+00},
    { 41, 20,  2,  2, 0.38125920e+03, 0.29225000e+01, 0.19349000e+01},
    { 41, 21,  0,  0, 0.14860620e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 21,  0,  1, 0.67533140e+03, 0.00000000e+00, 0.18627000e+01},
    { 41, 21,  0,  2, 0.65695460e+03, 0.00000000e+00, 0.28999000e+01},
    { 41, 21,  1,  0, 0.88833560e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 21,  1,  1, 0.43378650e+03, 0.19545000e+01, 0.18627000e+01},
    { 41, 21,  1,  2, 0.42572990e+03, 0.19545000e+01, 0.28999000e+01},
    { 41, 21,  2,  0, 0.73301140e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 21,  2,  1, 0.37132440e+03, 0.29225000e+01, 0.18627000e+01},
    { 41, 21,  2,  2, 0.36637160e+03, 0.29225000e+01, 0.28999000e+01},
    { 41, 22,  0,  0, 0.14126818e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 22,  0,  1, 0.65128470e+03, 0.00000000e+00, 0.18299000e+01},
    { 41, 22,  0,  2, 0.66404520e+03, 0.00000000e+00, 0.38675000e+01},
    { 41, 22,  1,  0, 0.85304640e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 22,  1,  1, 0.41830680e+03, 0.19545000e+01, 0.18299000e+01},
    { 41, 22,  1,  2, 0.43076130e+03, 0.19545000e+01, 0.38675000e+01},
    { 41, 22,  2,  0, 0.70781110e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 22,  2,  1, 0.35852320e+03, 0.29225000e+01, 0.18299000e+01},
    { 41, 22,  2,  2, 0.37088000e+03, 0.29225000e+01, 0.38675000e+01},
    { 41, 23,  0,  0, 0.12813349e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 23,  0,  1, 0.63870140e+03, 0.00000000e+00, 0.19138000e+01},
    { 41, 23,  0,  2, 0.60884420e+03, 0.00000000e+00, 0.29110000e+01},
    { 41, 23,  1,  0, 0.77852660e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 23,  1,  1, 0.41010330e+03, 0.19545000e+01, 0.19138000e+01},
    { 41, 23,  1,  2, 0.39448540e+03, 0.19545000e+01, 0.29110000e+01},
    { 41, 23,  2,  0, 0.64811200e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 23,  2,  1, 0.35134710e+03, 0.29225000e+01, 0.19138000e+01},
    { 41, 23,  2,  2, 0.33949100e+03, 0.29225000e+01, 0.29110000e+01},
    { 41, 24,  0,  0, 0.10078571e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 24,  0,  1, 0.63596390e+03, 0.00000000e+00, 0.18269000e+01},
    { 41, 24,  0,  2, 0.44423280e+03, 0.00000000e+00, 0.10619100e+02},
    { 41, 24,  1,  0, 0.61302240e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 24,  1,  1, 0.40698940e+03, 0.19545000e+01, 0.18269000e+01},
    { 41, 24,  1,  2, 0.29411860e+03, 0.19545000e+01, 0.10619100e+02},
    { 41, 24,  2,  0, 0.51073850e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 24,  2,  1, 0.34810210e+03, 0.29225000e+01, 0.18269000e+01},
    { 41, 24,  2,  2, 0.25576580e+03, 0.29225000e+01, 0.10619100e+02},
    { 41, 25,  0,  0, 0.10879837e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 25,  0,  1, 0.57118620e+03, 0.00000000e+00, 0.16406000e+01},
    { 41, 25,  0,  2, 0.37252150e+03, 0.00000000e+00, 0.98849000e+01},
    { 41, 25,  1,  0, 0.66703050e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 25,  1,  1, 0.37146910e+03, 0.19545000e+01, 0.16406000e+01},
    { 41, 25,  1,  2, 0.25002660e+03, 0.19545000e+01, 0.98849000e+01},
    { 41, 25,  2,  0, 0.55795140e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 25,  2,  1, 0.32022560e+03, 0.29225000e+01, 0.16406000e+01},
    { 41, 25,  2,  2, 0.21884580e+03, 0.29225000e+01, 0.98849000e+01},
    { 41, 26,  0,  0, 0.85106340e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 26,  0,  1, 0.52495880e+03, 0.00000000e+00, 0.16483000e+01},
    { 41, 26,  0,  2, 0.36653290e+03, 0.00000000e+00, 0.91376000e+01},
    { 41, 26,  1,  0, 0.52300200e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 26,  1,  1, 0.34300120e+03, 0.19545000e+01, 0.16483000e+01},
    { 41, 26,  1,  2, 0.24560370e+03, 0.19545000e+01, 0.91376000e+01},
    { 41, 26,  2,  0, 0.43806030e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 26,  2,  1, 0.29637490e+03, 0.29225000e+01, 0.16483000e+01},
    { 41, 26,  2,  2, 0.21480530e+03, 0.29225000e+01, 0.91376000e+01},
    { 41, 27,  0,  0, 0.88388900e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 27,  0,  1, 0.50083550e+03, 0.00000000e+00, 0.17149000e+01},
    { 41, 27,  0,  2, 0.44370070e+03, 0.00000000e+00, 0.29263000e+01},
    { 41, 27,  0,  3, 0.38664910e+03, 0.00000000e+00, 0.77785000e+01},
    { 41, 27,  1,  0, 0.55040920e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 27,  1,  1, 0.32719950e+03, 0.19545000e+01, 0.17149000e+01},
    { 41, 27,  1,  2, 0.29089880e+03, 0.19545000e+01, 0.29263000e+01},
    { 41, 27,  1,  3, 0.25719610e+03, 0.19545000e+01, 0.77785000e+01},
    { 41, 27,  2,  0, 0.46406680e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 27,  2,  1, 0.28273960e+03, 0.29225000e+01, 0.17149000e+01},
    { 41, 27,  2,  2, 0.25178560e+03, 0.29225000e+01, 0.29263000e+01},
    { 41, 27,  2,  3, 0.22415900e+03, 0.29225000e+01, 0.77785000e+01},
    { 41, 28,  0,  0, 0.91953540e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 28,  0,  1, 0.49059730e+03, 0.00000000e+00, 0.17937000e+01},
    { 41, 28,  0,  2, 0.40942870e+03, 0.00000000e+00, 0.65458000e+01},
    { 41, 28,  0,  3, 0.43865020e+03, 0.00000000e+00, 0.62918000e+01},
    { 41, 28,  1,  0, 0.56890880e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 28,  1,  1, 0.32009600e+03, 0.19545000e+01, 0.17937000e+01},
    { 41, 28,  1,  2, 0.27016880e+03, 0.19545000e+01, 0.65458000e+01},
    { 41, 28,  1,  3, 0.28559450e+03, 0.19545000e+01, 0.62918000e+01},
    { 41, 28,  2,  0, 0.47803720e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 28,  2,  1, 0.27641130e+03, 0.29225000e+01, 0.17937000e+01},
    { 41, 28,  2,  2, 0.23455580e+03, 0.29225000e+01, 0.65458000e+01},
    { 41, 28,  2,  3, 0.24630770e+03, 0.29225000e+01, 0.62918000e+01},
    { 41, 29,  0,  0, 0.70437890e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 29,  0,  1, 0.49363630e+03, 0.00000000e+00, 0.95760000e+00},
    { 41, 29,  1,  0, 0.43610420e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 29,  1,  1, 0.31821360e+03, 0.19545000e+01, 0.95760000e+00},
    { 41, 29,  2,  0, 0.36666480e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 29,  2,  1, 0.27310650e+03, 0.29225000e+01, 0.95760000e+00},
    { 41, 30,  0,  0, 0.70135490e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 30,  0,  1, 0.44803280e+03, 0.00000000e+00, 0.19419000e+01},
    { 41, 30,  1,  0, 0.44298860e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 30,  1,  1, 0.29527620e+03, 0.19545000e+01, 0.19419000e+01},
    { 41, 30,  2,  0, 0.37623990e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 30,  2,  1, 0.25621710e+03, 0.29225000e+01, 0.19419000e+01},
    { 41, 31,  0,  0, 0.83928280e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 31,  0,  1, 0.78048050e+03, 0.00000000e+00, 0.96010000e+00},
    { 41, 31,  0,  2, 0.59747450e+03, 0.00000000e+00, 0.19315000e+01},
    { 41, 31,  0,  3, 0.47214060e+03, 0.00000000e+00, 0.29233000e+01},
    { 41, 31,  1,  0, 0.52649640e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 31,  1,  1, 0.49283160e+03, 0.19545000e+01, 0.96010000e+00},
    { 41, 31,  1,  2, 0.38593850e+03, 0.19545000e+01, 0.19315000e+01},
    { 41, 31,  1,  3, 0.31215680e+03, 0.19545000e+01, 0.29233000e+01},
    { 41, 31,  2,  0, 0.44572790e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 31,  2,  1, 0.41862090e+03, 0.29225000e+01, 0.96010000e+00},
    { 41, 31,  2,  2, 0.33167180e+03, 0.29225000e+01, 0.19315000e+01},
    { 41, 31,  2,  3, 0.27131370e+03, 0.29225000e+01, 0.29233000e+01},
    { 41, 32,  0,  0, 0.71168230e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 32,  0,  1, 0.65980390e+03, 0.00000000e+00, 0.94340000e+00},
    { 41, 32,  0,  2, 0.62420610e+03, 0.00000000e+00, 0.19447000e+01},
    { 41, 32,  0,  3, 0.55060110e+03, 0.00000000e+00, 0.29186000e+01},
    { 41, 32,  0,  4, 0.47644890e+03, 0.00000000e+00, 0.38972000e+01},
    { 41, 32,  1,  0, 0.45819200e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 32,  1,  1, 0.42736220e+03, 0.19545000e+01, 0.94340000e+00},
    { 41, 32,  1,  2, 0.40601940e+03, 0.19545000e+01, 0.19447000e+01},
    { 41, 32,  1,  3, 0.36192950e+03, 0.19545000e+01, 0.29186000e+01},
    { 41, 32,  1,  4, 0.31740770e+03, 0.19545000e+01, 0.38972000e+01},
    { 41, 32,  2,  0, 0.39303660e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 32,  2,  1, 0.36771370e+03, 0.29225000e+01, 0.94340000e+00},
    { 41, 32,  2,  2, 0.35008010e+03, 0.29225000e+01, 0.19447000e+01},
    { 41, 32,  2,  3, 0.31369090e+03, 0.29225000e+01, 0.29186000e+01},
    { 41, 32,  2,  4, 0.27689930e+03, 0.29225000e+01, 0.38972000e+01},
    { 41, 33,  0,  0, 0.58600840e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 33,  0,  1, 0.57490090e+03, 0.00000000e+00, 0.98890000e+00},
    { 41, 33,  0,  2, 0.55778500e+03, 0.00000000e+00, 0.19793000e+01},
    { 41, 33,  0,  3, 0.53429150e+03, 0.00000000e+00, 0.29709000e+01},
    { 41, 33,  1,  0, 0.38630910e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 33,  1,  1, 0.37950970e+03, 0.19545000e+01, 0.98890000e+00},
    { 41, 33,  1,  2, 0.36911250e+03, 0.19545000e+01, 0.19793000e+01},
    { 41, 33,  1,  3, 0.35489700e+03, 0.19545000e+01, 0.29709000e+01},
    { 41, 33,  2,  0, 0.33529210e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 33,  2,  1, 0.32961390e+03, 0.29225000e+01, 0.98890000e+00},
    { 41, 33,  2,  2, 0.32096670e+03, 0.29225000e+01, 0.19793000e+01},
    { 41, 33,  2,  3, 0.30916430e+03, 0.29225000e+01, 0.29709000e+01},
    { 41, 34,  0,  0, 0.51450770e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 34,  0,  1, 0.51489450e+03, 0.00000000e+00, 0.99010000e+00},
    { 41, 34,  0,  2, 0.51054640e+03, 0.00000000e+00, 0.19812000e+01},
    { 41, 34,  1,  0, 0.34424250e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 34,  1,  1, 0.34441690e+03, 0.19545000e+01, 0.99010000e+00},
    { 41, 34,  1,  2, 0.34164920e+03, 0.19545000e+01, 0.19812000e+01},
    { 41, 34,  2,  0, 0.30092580e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 34,  2,  1, 0.30104260e+03, 0.29225000e+01, 0.99010000e+00},
    { 41, 34,  2,  2, 0.29868080e+03, 0.29225000e+01, 0.19812000e+01},
    { 41, 35,  0,  0, 0.44029990e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 35,  0,  1, 0.44388480e+03, 0.00000000e+00, 0.99740000e+00},
    { 41, 35,  1,  0, 0.29915350e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 35,  1,  1, 0.30134630e+03, 0.19545000e+01, 0.99740000e+00},
    { 41, 35,  2,  0, 0.26340340e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 35,  2,  1, 0.26523400e+03, 0.29225000e+01, 0.99740000e+00},
    { 41, 36,  0,  0, 0.37513390e+03, 0.00000000e+00, 0.00000000e+00},
    { 41, 36,  1,  0, 0.25853040e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 36,  2,  0, 0.22911910e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 37,  0,  0, 0.26739344e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 37,  0,  1, 0.83213680e+03, 0.00000000e+00, 0.97380000e+00},
    { 41, 37,  1,  0, 0.15017789e+04, 0.19545000e+01, 0.00000000e+00},
    { 41, 37,  1,  1, 0.52294490e+03, 0.19545000e+01, 0.97380000e+00},
    { 41, 37,  2,  0, 0.12092081e+04, 0.29225000e+01, 0.00000000e+00},
    { 41, 37,  2,  1, 0.44326820e+03, 0.29225000e+01, 0.97380000e+00},
    { 41, 38,  0,  0, 0.21882864e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 38,  0,  1, 0.17897638e+04, 0.00000000e+00, 0.98010000e+00},
    { 41, 38,  0,  2, 0.83371350e+03, 0.00000000e+00, 0.19143000e+01},
    { 41, 38,  1,  0, 0.12904826e+04, 0.19545000e+01, 0.00000000e+00},
    { 41, 38,  1,  1, 0.10528629e+04, 0.19545000e+01, 0.98010000e+00},
    { 41, 38,  1,  2, 0.53402030e+03, 0.19545000e+01, 0.19143000e+01},
    { 41, 38,  2,  0, 0.10578748e+04, 0.29225000e+01, 0.00000000e+00},
    { 41, 38,  2,  1, 0.86524620e+03, 0.29225000e+01, 0.98010000e+00},
    { 41, 38,  2,  2, 0.45688220e+03, 0.29225000e+01, 0.19143000e+01},
    { 41, 39,  0,  0, 0.18586377e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 39,  0,  1, 0.12864770e+04, 0.00000000e+00, 0.19153000e+01},
    { 41, 39,  0,  2, 0.78153770e+03, 0.00000000e+00, 0.28903000e+01},
    { 41, 39,  1,  0, 0.11181402e+04, 0.19545000e+01, 0.00000000e+00},
    { 41, 39,  1,  1, 0.78749500e+03, 0.19545000e+01, 0.19153000e+01},
    { 41, 39,  1,  2, 0.50941810e+03, 0.19545000e+01, 0.28903000e+01},
    { 41, 39,  2,  0, 0.92614390e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 39,  2,  1, 0.66073770e+03, 0.29225000e+01, 0.19153000e+01},
    { 41, 39,  2,  2, 0.43965480e+03, 0.29225000e+01, 0.28903000e+01},
    { 41, 40,  0,  0, 0.16384938e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 40,  0,  1, 0.89679520e+03, 0.00000000e+00, 0.19355000e+01},
    { 41, 40,  0,  2, 0.78230880e+03, 0.00000000e+00, 0.39106000e+01},
    { 41, 40,  1,  0, 0.99812240e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 40,  1,  1, 0.57445910e+03, 0.19545000e+01, 0.19355000e+01},
    { 41, 40,  1,  2, 0.51249950e+03, 0.19545000e+01, 0.39106000e+01},
    { 41, 40,  2,  0, 0.83217430e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 40,  2,  1, 0.49130810e+03, 0.29225000e+01, 0.19355000e+01},
    { 41, 40,  2,  2, 0.44341820e+03, 0.29225000e+01, 0.39106000e+01},
    { 41, 41,  0,  0, 0.14752500e+04, 0.00000000e+00, 0.00000000e+00},
    { 41, 41,  1,  0, 0.90608010e+03, 0.19545000e+01, 0.00000000e+00},
    { 41, 41,  1,  1, 0.58058240e+03, 0.19545000e+01, 0.19545000e+01},
    { 41, 41,  2,  0, 0.75877890e+03, 0.29225000e+01, 0.00000000e+00},
    { 41, 41,  2,  1, 0.49611270e+03, 0.29225000e+01, 0.19545000e+01},
    { 41, 41,  2,  2, 0.42889620e+03, 0.29225000e+01, 0.29225000e+01},
    { 42,  1,  0,  0, 0.46040600e+02, 0.00000000e+00, 0.91180000e+00},
    { 42,  1,  0,  1, 0.76366100e+02, 0.00000000e+00, 0.00000000e+00},
    { 42,  1,  1,  0, 0.37547800e+02, 0.19420000e+01, 0.91180000e+00},
    { 42,  1,  1,  1, 0.60977300e+02, 0.19420000e+01, 0.00000000e+00},
    { 42,  1,  2,  0, 0.31668100e+02, 0.11055600e+02, 0.91180000e+00},
    { 42,  1,  2,  1, 0.50417300e+02, 0.11055600e+02, 0.00000000e+00},
    { 42,  2,  0,  0, 0.29161700e+02, 0.00000000e+00, 0.00000000e+00},
    { 42,  2,  1,  0, 0.24553000e+02, 0.19420000e+01, 0.00000000e+00},
    { 42,  2,  2,  0, 0.21351600e+02, 0.11055600e+02, 0.00000000e+00},
    { 42,  3,  0,  0, 0.89051260e+03, 0.00000000e+00, 0.00000000e+00},
    { 42,  3,  0,  1, 0.26737610e+03, 0.00000000e+00, 0.98650000e+00},
    { 42,  3,  1,  0, 0.62818170e+03, 0.19420000e+01, 0.00000000e+00},
    { 42,  3,  1,  1, 0.20251730e+03, 0.19420000e+01, 0.98650000e+00},
    { 42,  3,  2,  0, 0.46157510e+03, 0.11055600e+02, 0.00000000e+00},
    { 42,  3,  2,  1, 0.15944040e+03, 0.11055600e+02, 0.98650000e+00},
    { 42,  4,  0,  0, 0.46330650e+03, 0.00000000e+00, 0.00000000e+00},
    { 42,  4,  0,  1, 0.33790350e+03, 0.00000000e+00, 0.98080000e+00},
    { 42,  4,  0,  2, 0.20909590e+03, 0.00000000e+00, 0.19697000e+01},
    { 42,  4,  1,  0, 0.34918970e+03, 0.19420000e+01, 0.00000000e+00},
    { 42,  4,  1,  1, 0.25760880e+03, 0.19420000e+01, 0.98080000e+00},
    { 42,  4,  1,  2, 0.16520660e+03, 0.19420000e+01, 0.19697000e+01},
    { 42,  4,  2,  0, 0.27354460e+03, 0.11055600e+02, 0.00000000e+00},
    { 42,  4,  2,  1, 0.20415190e+03, 0.11055600e+02, 0.98080000e+00},
    { 42,  4,  2,  2, 0.13524280e+03, 0.11055600e+02, 0.19697000e+01},
    { 42,  5,  0,  0, 0.29535920e+03, 0.00000000e+00, 0.00000000e+00},
    { 42,  5,  0,  1, 0.24585270e+03, 0.00000000e+00, 0.97060000e+00},
    { 42,  5,  0,  2, 0.20430920e+03, 0.00000000e+00, 0.19441000e+01},
    { 42,  5,  0,  3, 0.15074470e+03, 0.00000000e+00, 0.29128000e+01},
    { 42,  5,  0,  4, 0.14125220e+03, 0.00000000e+00, 0.45856000e+01},
    { 42,  5,  1,  0, 0.23104490e+03, 0.19420000e+01, 0.00000000e+00},
    { 42,  5,  1,  1, 0.19375570e+03, 0.19420000e+01, 0.97060000e+00},
    { 42,  5,  1,  2, 0.16219830e+03, 0.19420000e+01, 0.19441000e+01},
    { 42,  5,  1,  3, 0.12219410e+03, 0.19420000e+01, 0.29128000e+01},
    { 42,  5,  1,  4, 0.11484620e+03, 0.19420000e+01, 0.45856000e+01},
    { 42,  5,  2,  0, 0.18746660e+03, 0.11055600e+02, 0.00000000e+00},
    { 42,  5,  2,  1, 0.15835630e+03, 0.11055600e+02, 0.97060000e+00},
    { 42,  5,  2,  2, 0.13350900e+03, 0.11055600e+02, 0.19441000e+01},
    { 42,  5,  2,  3, 0.10248830e+03, 0.11055600e+02, 0.29128000e+01},
    { 42,  5,  2,  4, 0.96603000e+02, 0.11055600e+02, 0.45856000e+01},
    { 42,  6,  0,  0, 0.19195280e+03, 0.00000000e+00, 0.00000000e+00},
    { 42,  6,  0,  1, 0.18033900e+03, 0.00000000e+00, 0.98680000e+00},
    { 42,  6,  0,  2, 0.14463550e+03, 0.00000000e+00, 0.19985000e+01},
    { 42,  6,  0,  3, 0.13537160e+03, 0.00000000e+00, 0.29987000e+01},
    { 42,  6,  0,  4, 0.10823560e+03, 0.00000000e+00, 0.39844000e+01},
    { 42,  6,  1,  0, 0.15432880e+03, 0.19420000e+01, 0.00000000e+00},
    { 42,  6,  1,  1, 0.14487380e+03, 0.19420000e+01, 0.98680000e+00},
    { 42,  6,  1,  2, 0.11755240e+03, 0.19420000e+01, 0.19985000e+01},
    { 42,  6,  1,  3, 0.11002550e+03, 0.19420000e+01, 0.29987000e+01},
    { 42,  6,  1,  4, 0.89422900e+02, 0.19420000e+01, 0.39844000e+01},
    { 42,  6,  2,  0, 0.12849780e+03, 0.11055600e+02, 0.00000000e+00},
    { 42,  6,  2,  1, 0.12059460e+03, 0.11055600e+02, 0.98680000e+00},
    { 42,  6,  2,  2, 0.98890300e+02, 0.11055600e+02, 0.19985000e+01},
    { 42,  6,  2,  3, 0.92598300e+02, 0.11055600e+02, 0.29987000e+01},
    { 42,  6,  2,  4, 0.76386900e+02, 0.11055600e+02, 0.39844000e+01},
    { 42,  7,  0,  0, 0.13060450e+03, 0.00000000e+00, 0.00000000e+00},
    { 42,  7,  0,  1, 0.12180660e+03, 0.00000000e+00, 0.99440000e+00},
    { 42,  7,  0,  2, 0.11400040e+03, 0.00000000e+00, 0.20143000e+01},
    { 42,  7,  0,  3, 0.10010800e+03, 0.00000000e+00, 0.29903000e+01},
    { 42,  7,  1,  0, 0.10713040e+03, 0.19420000e+01, 0.00000000e+00},
    { 42,  7,  1,  1, 0.99938100e+02, 0.19420000e+01, 0.99440000e+00},
    { 42,  7,  1,  2, 0.93743400e+02, 0.19420000e+01, 0.20143000e+01},
    { 42,  7,  1,  3, 0.82525100e+02, 0.19420000e+01, 0.29903000e+01},
    { 42,  7,  2,  0, 0.90904300e+02, 0.11055600e+02, 0.00000000e+00},
    { 42,  7,  2,  1, 0.84858200e+02, 0.11055600e+02, 0.99440000e+00},
    { 42,  7,  2,  2, 0.79767200e+02, 0.11055600e+02, 0.20143000e+01},
    { 42,  7,  2,  3, 0.70424400e+02, 0.11055600e+02, 0.29903000e+01},
    { 42,  8,  0,  0, 0.97067500e+02, 0.00000000e+00, 0.00000000e+00},
    { 42,  8,  0,  1, 0.86680300e+02, 0.00000000e+00, 0.99250000e+00},
    { 42,  8,  0,  2, 0.76023900e+02, 0.00000000e+00, 0.19887000e+01},
    { 42,  8,  1,  0, 0.80736000e+02, 0.19420000e+01, 0.00000000e+00},
    { 42,  8,  1,  1, 0.72352000e+02, 0.19420000e+01, 0.99250000e+00},
    { 42,  8,  1,  2, 0.63740200e+02, 0.19420000e+01, 0.19887000e+01},
    { 42,  8,  2,  0, 0.69418100e+02, 0.11055600e+02, 0.00000000e+00},
    { 42,  8,  2,  1, 0.62432400e+02, 0.11055600e+02, 0.99250000e+00},
    { 42,  8,  2,  2, 0.55248400e+02, 0.11055600e+02, 0.19887000e+01},
    { 42,  9,  0,  0, 0.72418600e+02, 0.00000000e+00, 0.00000000e+00},
    { 42,  9,  0,  1, 0.57978400e+02, 0.00000000e+00, 0.99820000e+00},
    { 42,  9,  1,  0, 0.60941400e+02, 0.19420000e+01, 0.00000000e+00},
    { 42,  9,  1,  1, 0.49416600e+02, 0.19420000e+01, 0.99820000e+00},
    { 42,  9,  2,  0, 0.52984500e+02, 0.11055600e+02, 0.00000000e+00},
    { 42,  9,  2,  1, 0.43476000e+02, 0.11055600e+02, 0.99820000e+00},
    { 42, 10,  0,  0, 0.55048700e+02, 0.00000000e+00, 0.00000000e+00},
    { 42, 10,  1,  0, 0.46749800e+02, 0.19420000e+01, 0.00000000e+00},
    { 42, 10,  2,  0, 0.41003500e+02, 0.11055600e+02, 0.00000000e+00},
    { 42, 11,  0,  0, 0.10583899e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 11,  0,  1, 0.39500580e+03, 0.00000000e+00, 0.96840000e+00},
    { 42, 11,  1,  0, 0.74949740e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 11,  1,  1, 0.29717130e+03, 0.19420000e+01, 0.96840000e+00},
    { 42, 11,  2,  0, 0.55303570e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 11,  2,  1, 0.23259320e+03, 0.11055600e+02, 0.96840000e+00},
    { 42, 12,  0,  0, 0.75166280e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 12,  0,  1, 0.61402650e+03, 0.00000000e+00, 0.96280000e+00},
    { 42, 12,  0,  2, 0.37976260e+03, 0.00000000e+00, 0.19496000e+01},
    { 42, 12,  1,  0, 0.55988560e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 12,  1,  1, 0.46042340e+03, 0.19420000e+01, 0.96280000e+00},
    { 42, 12,  1,  2, 0.29518160e+03, 0.19420000e+01, 0.19496000e+01},
    { 42, 12,  2,  0, 0.43382780e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 12,  2,  1, 0.35918880e+03, 0.11055600e+02, 0.96280000e+00},
    { 42, 12,  2,  2, 0.23801690e+03, 0.11055600e+02, 0.19496000e+01},
    { 42, 13,  0,  0, 0.67311930e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 13,  0,  1, 0.60591350e+03, 0.00000000e+00, 0.96480000e+00},
    { 42, 13,  0,  2, 0.46105860e+03, 0.00000000e+00, 0.19311000e+01},
    { 42, 13,  0,  3, 0.34833970e+03, 0.00000000e+00, 0.29146000e+01},
    { 42, 13,  1,  0, 0.51108100e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 13,  1,  1, 0.46216780e+03, 0.19420000e+01, 0.96480000e+00},
    { 42, 13,  1,  2, 0.35735760e+03, 0.19420000e+01, 0.19311000e+01},
    { 42, 13,  1,  3, 0.27564350e+03, 0.19420000e+01, 0.29146000e+01},
    { 42, 13,  2,  0, 0.40329140e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 13,  2,  1, 0.36631710e+03, 0.11055600e+02, 0.96480000e+00},
    { 42, 13,  2,  2, 0.28752250e+03, 0.11055600e+02, 0.19311000e+01},
    { 42, 13,  2,  3, 0.22596360e+03, 0.11055600e+02, 0.29146000e+01},
    { 42, 14,  0,  0, 0.51023520e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 14,  0,  1, 0.46910920e+03, 0.00000000e+00, 0.95070000e+00},
    { 42, 14,  0,  2, 0.43396780e+03, 0.00000000e+00, 0.19435000e+01},
    { 42, 14,  0,  3, 0.42480720e+03, 0.00000000e+00, 0.29407000e+01},
    { 42, 14,  0,  4, 0.34034780e+03, 0.00000000e+00, 0.38677000e+01},
    { 42, 14,  1,  0, 0.39766020e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 14,  1,  1, 0.36695490e+03, 0.19420000e+01, 0.95070000e+00},
    { 42, 14,  1,  2, 0.34073580e+03, 0.19420000e+01, 0.19435000e+01},
    { 42, 14,  1,  3, 0.33259800e+03, 0.19420000e+01, 0.29407000e+01},
    { 42, 14,  1,  4, 0.27129600e+03, 0.19420000e+01, 0.38677000e+01},
    { 42, 14,  2,  0, 0.32151630e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 14,  2,  1, 0.29774360e+03, 0.11055600e+02, 0.95070000e+00},
    { 42, 14,  2,  2, 0.27743120e+03, 0.11055600e+02, 0.19435000e+01},
    { 42, 14,  2,  3, 0.27018990e+03, 0.11055600e+02, 0.29407000e+01},
    { 42, 14,  2,  4, 0.22395860e+03, 0.11055600e+02, 0.38677000e+01},
    { 42, 15,  0,  0, 0.38558950e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 15,  0,  1, 0.37394270e+03, 0.00000000e+00, 0.99470000e+00},
    { 42, 15,  0,  2, 0.36967940e+03, 0.00000000e+00, 0.20102000e+01},
    { 42, 15,  0,  3, 0.34005920e+03, 0.00000000e+00, 0.29859000e+01},
    { 42, 15,  1,  0, 0.30713840e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 15,  1,  1, 0.29806610e+03, 0.19420000e+01, 0.99470000e+00},
    { 42, 15,  1,  2, 0.29424360e+03, 0.19420000e+01, 0.20102000e+01},
    { 42, 15,  1,  3, 0.27224210e+03, 0.19420000e+01, 0.29859000e+01},
    { 42, 15,  2,  0, 0.25341230e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 15,  2,  1, 0.24610860e+03, 0.11055600e+02, 0.99470000e+00},
    { 42, 15,  2,  2, 0.24266760e+03, 0.11055600e+02, 0.20102000e+01},
    { 42, 15,  2,  3, 0.22570300e+03, 0.11055600e+02, 0.29859000e+01},
    { 42, 16,  0,  0, 0.31386570e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 16,  0,  1, 0.31058610e+03, 0.00000000e+00, 0.99480000e+00},
    { 42, 16,  0,  2, 0.30421090e+03, 0.00000000e+00, 0.19903000e+01},
    { 42, 16,  1,  0, 0.25349850e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 16,  1,  1, 0.25075730e+03, 0.19420000e+01, 0.99480000e+00},
    { 42, 16,  1,  2, 0.24567190e+03, 0.19420000e+01, 0.19903000e+01},
    { 42, 16,  2,  0, 0.21190690e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 16,  2,  1, 0.20955990e+03, 0.11055600e+02, 0.99480000e+00},
    { 42, 16,  2,  2, 0.20536950e+03, 0.11055600e+02, 0.19903000e+01},
    { 42, 17,  0,  0, 0.25177230e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 17,  0,  1, 0.24926710e+03, 0.00000000e+00, 0.99720000e+00},
    { 42, 17,  1,  0, 0.20604590e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 17,  1,  1, 0.20393970e+03, 0.19420000e+01, 0.99720000e+00},
    { 42, 17,  2,  0, 0.17439200e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 17,  2,  1, 0.17257580e+03, 0.11055600e+02, 0.99720000e+00},
    { 42, 18,  0,  0, 0.20285720e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 18,  1,  0, 0.16790140e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 18,  2,  0, 0.14363890e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 19,  0,  0, 0.17658946e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 19,  0,  1, 0.53463030e+03, 0.00000000e+00, 0.97670000e+00},
    { 42, 19,  1,  0, 0.12379643e+04, 0.19420000e+01, 0.00000000e+00},
    { 42, 19,  1,  1, 0.40759060e+03, 0.19420000e+01, 0.97670000e+00},
    { 42, 19,  2,  0, 0.90508480e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 19,  2,  1, 0.32363810e+03, 0.11055600e+02, 0.97670000e+00},
    { 42, 20,  0,  0, 0.13654837e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 20,  0,  1, 0.10926733e+04, 0.00000000e+00, 0.98310000e+00},
    { 42, 20,  0,  2, 0.53379780e+03, 0.00000000e+00, 0.19349000e+01},
    { 42, 20,  1,  0, 0.99601570e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 20,  1,  1, 0.79747730e+03, 0.19420000e+01, 0.98310000e+00},
    { 42, 20,  1,  2, 0.41448110e+03, 0.19420000e+01, 0.19349000e+01},
    { 42, 20,  2,  0, 0.75708580e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 20,  2,  1, 0.60709190e+03, 0.11055600e+02, 0.98310000e+00},
    { 42, 20,  2,  2, 0.33432060e+03, 0.11055600e+02, 0.19349000e+01},
    { 42, 21,  0,  0, 0.11120098e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 21,  0,  1, 0.51773400e+03, 0.00000000e+00, 0.18627000e+01},
    { 42, 21,  0,  2, 0.50523460e+03, 0.00000000e+00, 0.28999000e+01},
    { 42, 21,  1,  0, 0.81851610e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 21,  1,  1, 0.40315400e+03, 0.19420000e+01, 0.18627000e+01},
    { 42, 21,  1,  2, 0.39634700e+03, 0.19420000e+01, 0.28999000e+01},
    { 42, 21,  2,  0, 0.62755600e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 21,  2,  1, 0.32607870e+03, 0.11055600e+02, 0.18627000e+01},
    { 42, 21,  2,  2, 0.32266550e+03, 0.11055600e+02, 0.28999000e+01},
    { 42, 22,  0,  0, 0.10606255e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 22,  0,  1, 0.49950110e+03, 0.00000000e+00, 0.18299000e+01},
    { 42, 22,  0,  2, 0.51089670e+03, 0.00000000e+00, 0.38675000e+01},
    { 42, 22,  1,  0, 0.78705650e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 22,  1,  1, 0.38917870e+03, 0.19420000e+01, 0.18299000e+01},
    { 42, 22,  1,  2, 0.40109190e+03, 0.19420000e+01, 0.38675000e+01},
    { 42, 22,  2,  0, 0.60830000e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 22,  2,  1, 0.31499830e+03, 0.11055600e+02, 0.18299000e+01},
    { 42, 22,  2,  2, 0.32676700e+03, 0.11055600e+02, 0.38675000e+01},
    { 42, 23,  0,  0, 0.96394340e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 23,  0,  1, 0.48981600e+03, 0.00000000e+00, 0.19138000e+01},
    { 42, 23,  0,  2, 0.46840590e+03, 0.00000000e+00, 0.29110000e+01},
    { 42, 23,  1,  0, 0.71884690e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 23,  1,  1, 0.38148040e+03, 0.19420000e+01, 0.19138000e+01},
    { 42, 23,  1,  2, 0.36737500e+03, 0.19420000e+01, 0.29110000e+01},
    { 42, 23,  2,  0, 0.55823240e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 23,  2,  1, 0.30868010e+03, 0.11055600e+02, 0.19138000e+01},
    { 42, 23,  2,  2, 0.29914950e+03, 0.11055600e+02, 0.29110000e+01},
    { 42, 24,  0,  0, 0.75899550e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 24,  0,  1, 0.48719110e+03, 0.00000000e+00, 0.18269000e+01},
    { 42, 24,  0,  2, 0.34481050e+03, 0.00000000e+00, 0.10619100e+02},
    { 42, 24,  1,  0, 0.56643000e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 24,  1,  1, 0.37844740e+03, 0.19420000e+01, 0.18269000e+01},
    { 42, 24,  1,  2, 0.27484220e+03, 0.19420000e+01, 0.10619100e+02},
    { 42, 24,  2,  0, 0.44055160e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 24,  2,  1, 0.30552730e+03, 0.11055600e+02, 0.18269000e+01},
    { 42, 24,  2,  2, 0.22729470e+03, 0.11055600e+02, 0.10619100e+02},
    { 42, 25,  0,  0, 0.82093130e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 25,  0,  1, 0.43993260e+03, 0.00000000e+00, 0.16406000e+01},
    { 42, 25,  0,  2, 0.29074940e+03, 0.00000000e+00, 0.98849000e+01},
    { 42, 25,  1,  0, 0.61659930e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 25,  1,  1, 0.34604230e+03, 0.19420000e+01, 0.16406000e+01},
    { 42, 25,  1,  2, 0.23413150e+03, 0.19420000e+01, 0.98849000e+01},
    { 42, 25,  2,  0, 0.48213620e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 25,  2,  1, 0.28243340e+03, 0.11055600e+02, 0.16406000e+01},
    { 42, 25,  2,  2, 0.19544560e+03, 0.11055600e+02, 0.98849000e+01},
    { 42, 26,  0,  0, 0.64312470e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 26,  0,  1, 0.40508170e+03, 0.00000000e+00, 0.16483000e+01},
    { 42, 26,  0,  2, 0.28589770e+03, 0.00000000e+00, 0.91376000e+01},
    { 42, 26,  1,  0, 0.48385370e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 26,  1,  1, 0.31976370e+03, 0.19420000e+01, 0.16483000e+01},
    { 42, 26,  1,  2, 0.22993990e+03, 0.19420000e+01, 0.91376000e+01},
    { 42, 26,  2,  0, 0.37926880e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 26,  2,  1, 0.26186300e+03, 0.11055600e+02, 0.16483000e+01},
    { 42, 26,  2,  2, 0.19173330e+03, 0.11055600e+02, 0.91376000e+01},
    { 42, 27,  0,  0, 0.67034900e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 27,  0,  1, 0.38652450e+03, 0.00000000e+00, 0.17149000e+01},
    { 42, 27,  0,  2, 0.34307100e+03, 0.00000000e+00, 0.29263000e+01},
    { 42, 27,  0,  3, 0.30067530e+03, 0.00000000e+00, 0.77785000e+01},
    { 42, 27,  1,  0, 0.50969990e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 27,  1,  1, 0.30508870e+03, 0.19420000e+01, 0.17149000e+01},
    { 42, 27,  1,  2, 0.27145590e+03, 0.19420000e+01, 0.29263000e+01},
    { 42, 27,  1,  3, 0.24051390e+03, 0.19420000e+01, 0.77785000e+01},
    { 42, 27,  2,  0, 0.40314840e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 27,  2,  1, 0.24986950e+03, 0.11055600e+02, 0.17149000e+01},
    { 42, 27,  2,  2, 0.22295460e+03, 0.11055600e+02, 0.29263000e+01},
    { 42, 27,  2,  3, 0.19953250e+03, 0.11055600e+02, 0.77785000e+01},
    { 42, 28,  0,  0, 0.69583480e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 28,  0,  1, 0.37845940e+03, 0.00000000e+00, 0.17937000e+01},
    { 42, 28,  0,  2, 0.31734720e+03, 0.00000000e+00, 0.65458000e+01},
    { 42, 28,  0,  3, 0.33835350e+03, 0.00000000e+00, 0.62918000e+01},
    { 42, 28,  1,  0, 0.52637950e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 28,  1,  1, 0.29841290e+03, 0.19420000e+01, 0.17937000e+01},
    { 42, 28,  1,  2, 0.25232810e+03, 0.19420000e+01, 0.65458000e+01},
    { 42, 28,  1,  3, 0.26625680e+03, 0.19420000e+01, 0.62918000e+01},
    { 42, 28,  2,  0, 0.41431560e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 28,  2,  1, 0.24418470e+03, 0.11055600e+02, 0.17937000e+01},
    { 42, 28,  2,  2, 0.20815700e+03, 0.11055600e+02, 0.65458000e+01},
    { 42, 28,  2,  3, 0.21764570e+03, 0.11055600e+02, 0.62918000e+01},
    { 42, 29,  0,  0, 0.53365350e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 29,  0,  1, 0.37922990e+03, 0.00000000e+00, 0.95760000e+00},
    { 42, 29,  1,  0, 0.40384000e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 29,  1,  1, 0.29619890e+03, 0.19420000e+01, 0.95760000e+00},
    { 42, 29,  2,  0, 0.31832390e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 29,  2,  1, 0.24036730e+03, 0.11055600e+02, 0.95760000e+00},
    { 42, 30,  0,  0, 0.53452070e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 30,  0,  1, 0.34683870e+03, 0.00000000e+00, 0.19419000e+01},
    { 42, 30,  1,  0, 0.41098660e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 30,  1,  1, 0.27560550e+03, 0.19420000e+01, 0.19419000e+01},
    { 42, 30,  2,  0, 0.32847070e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 30,  2,  1, 0.22704050e+03, 0.11055600e+02, 0.19419000e+01},
    { 42, 31,  0,  0, 0.63792330e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 31,  0,  1, 0.59457650e+03, 0.00000000e+00, 0.96010000e+00},
    { 42, 31,  0,  2, 0.45889060e+03, 0.00000000e+00, 0.19315000e+01},
    { 42, 31,  0,  3, 0.36573900e+03, 0.00000000e+00, 0.29233000e+01},
    { 42, 31,  1,  0, 0.48798580e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 31,  1,  1, 0.45716410e+03, 0.19420000e+01, 0.96010000e+00},
    { 42, 31,  1,  2, 0.35915800e+03, 0.19420000e+01, 0.19315000e+01},
    { 42, 31,  1,  3, 0.29139440e+03, 0.19420000e+01, 0.29233000e+01},
    { 42, 31,  2,  0, 0.38804460e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 31,  2,  1, 0.36528020e+03, 0.11055600e+02, 0.96010000e+00},
    { 42, 31,  2,  2, 0.29172410e+03, 0.11055600e+02, 0.19315000e+01},
    { 42, 31,  2,  3, 0.24051090e+03, 0.11055600e+02, 0.29233000e+01},
    { 42, 32,  0,  0, 0.54578450e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 32,  0,  1, 0.50715030e+03, 0.00000000e+00, 0.94340000e+00},
    { 42, 32,  0,  2, 0.48055520e+03, 0.00000000e+00, 0.19447000e+01},
    { 42, 32,  0,  3, 0.42558490e+03, 0.00000000e+00, 0.29186000e+01},
    { 42, 32,  0,  4, 0.37016770e+03, 0.00000000e+00, 0.38972000e+01},
    { 42, 32,  1,  0, 0.42607030e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 32,  1,  1, 0.39775920e+03, 0.19420000e+01, 0.94340000e+00},
    { 42, 32,  1,  2, 0.37812310e+03, 0.19420000e+01, 0.19447000e+01},
    { 42, 32,  1,  3, 0.33757750e+03, 0.19420000e+01, 0.29186000e+01},
    { 42, 32,  1,  4, 0.29662500e+03, 0.19420000e+01, 0.38972000e+01},
    { 42, 32,  2,  0, 0.34515780e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 32,  2,  1, 0.32362930e+03, 0.11055600e+02, 0.94340000e+00},
    { 42, 32,  2,  2, 0.30857810e+03, 0.11055600e+02, 0.19447000e+01},
    { 42, 32,  2,  3, 0.27753210e+03, 0.11055600e+02, 0.29186000e+01},
    { 42, 32,  2,  4, 0.24611820e+03, 0.11055600e+02, 0.38972000e+01},
    { 42, 33,  0,  0, 0.45341860e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 33,  0,  1, 0.44507990e+03, 0.00000000e+00, 0.98890000e+00},
    { 42, 33,  0,  2, 0.43224960e+03, 0.00000000e+00, 0.19793000e+01},
    { 42, 33,  0,  3, 0.41465090e+03, 0.00000000e+00, 0.29709000e+01},
    { 42, 33,  1,  0, 0.36044960e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 33,  1,  1, 0.35418680e+03, 0.19420000e+01, 0.98890000e+00},
    { 42, 33,  1,  2, 0.34461330e+03, 0.19420000e+01, 0.19793000e+01},
    { 42, 33,  1,  3, 0.33152300e+03, 0.19420000e+01, 0.29709000e+01},
    { 42, 33,  2,  0, 0.29691650e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 33,  2,  1, 0.29204750e+03, 0.11055600e+02, 0.98890000e+00},
    { 42, 33,  2,  2, 0.28464110e+03, 0.11055600e+02, 0.19793000e+01},
    { 42, 33,  2,  3, 0.27453760e+03, 0.11055600e+02, 0.29709000e+01},
    { 42, 34,  0,  0, 0.40049980e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 34,  0,  1, 0.40077220e+03, 0.00000000e+00, 0.99010000e+00},
    { 42, 34,  0,  2, 0.39746440e+03, 0.00000000e+00, 0.19812000e+01},
    { 42, 34,  1,  0, 0.32194150e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 34,  1,  1, 0.32209780e+03, 0.19420000e+01, 0.99010000e+00},
    { 42, 34,  1,  2, 0.31953400e+03, 0.19420000e+01, 0.19812000e+01},
    { 42, 34,  2,  0, 0.26796230e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 34,  2,  1, 0.26805260e+03, 0.11055600e+02, 0.99010000e+00},
    { 42, 34,  2,  2, 0.26599860e+03, 0.11055600e+02, 0.19812000e+01},
    { 42, 35,  0,  0, 0.34498260e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 35,  0,  1, 0.34768000e+03, 0.00000000e+00, 0.99740000e+00},
    { 42, 35,  1,  0, 0.28047020e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 35,  1,  1, 0.28249330e+03, 0.19420000e+01, 0.99740000e+00},
    { 42, 35,  2,  0, 0.23592640e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 35,  2,  1, 0.23750190e+03, 0.11055600e+02, 0.99740000e+00},
    { 42, 36,  0,  0, 0.29579940e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 36,  1,  0, 0.24296840e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 36,  2,  0, 0.20636370e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 37,  0,  0, 0.19694796e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 37,  0,  1, 0.63394710e+03, 0.00000000e+00, 0.97380000e+00},
    { 42, 37,  1,  0, 0.13851228e+04, 0.19420000e+01, 0.00000000e+00},
    { 42, 37,  1,  1, 0.48541290e+03, 0.19420000e+01, 0.97380000e+00},
    { 42, 37,  2,  0, 0.10163718e+04, 0.11055600e+02, 0.00000000e+00},
    { 42, 37,  2,  1, 0.38712360e+03, 0.11055600e+02, 0.97380000e+00},
    { 42, 38,  0,  0, 0.16315424e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 38,  0,  1, 0.13350700e+04, 0.00000000e+00, 0.98010000e+00},
    { 42, 38,  0,  2, 0.63877680e+03, 0.00000000e+00, 0.19143000e+01},
    { 42, 38,  1,  0, 0.11881982e+04, 0.19420000e+01, 0.00000000e+00},
    { 42, 38,  1,  1, 0.97212330e+03, 0.19420000e+01, 0.98010000e+00},
    { 42, 38,  1,  2, 0.49651280e+03, 0.19420000e+01, 0.19143000e+01},
    { 42, 38,  2,  0, 0.90210970e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 38,  2,  1, 0.73864010e+03, 0.11055600e+02, 0.98010000e+00},
    { 42, 38,  2,  2, 0.40105410e+03, 0.11055600e+02, 0.19143000e+01},
    { 42, 39,  0,  0, 0.13940976e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 39,  0,  1, 0.97159590e+03, 0.00000000e+00, 0.19153000e+01},
    { 42, 39,  0,  2, 0.60242530e+03, 0.00000000e+00, 0.28903000e+01},
    { 42, 39,  1,  0, 0.10314745e+04, 0.19420000e+01, 0.00000000e+00},
    { 42, 39,  1,  1, 0.73014460e+03, 0.19420000e+01, 0.19153000e+01},
    { 42, 39,  1,  2, 0.47468070e+03, 0.19420000e+01, 0.28903000e+01},
    { 42, 39,  2,  0, 0.79517640e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 39,  2,  1, 0.57185300e+03, 0.11055600e+02, 0.19153000e+01},
    { 42, 39,  2,  2, 0.38807180e+03, 0.11055600e+02, 0.28903000e+01},
    { 42, 40,  0,  0, 0.12339095e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 40,  0,  1, 0.68718480e+03, 0.00000000e+00, 0.19355000e+01},
    { 42, 40,  0,  2, 0.60414750e+03, 0.00000000e+00, 0.39106000e+01},
    { 42, 40,  1,  0, 0.92206600e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 40,  1,  1, 0.53401080e+03, 0.19420000e+01, 0.19355000e+01},
    { 42, 40,  1,  2, 0.47788700e+03, 0.19420000e+01, 0.39106000e+01},
    { 42, 40,  2,  0, 0.71766320e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 40,  2,  1, 0.43135120e+03, 0.11055600e+02, 0.19355000e+01},
    { 42, 40,  2,  2, 0.39206550e+03, 0.11055600e+02, 0.39106000e+01},
    { 42, 41,  0,  0, 0.11140924e+04, 0.00000000e+00, 0.00000000e+00},
    { 42, 41,  0,  1, 0.69429830e+03, 0.00000000e+00, 0.19545000e+01},
    { 42, 41,  0,  2, 0.58581260e+03, 0.00000000e+00, 0.29225000e+01},
    { 42, 41,  1,  0, 0.83798490e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 41,  1,  1, 0.53935320e+03, 0.19420000e+01, 0.19545000e+01},
    { 42, 41,  1,  2, 0.46265460e+03, 0.19420000e+01, 0.29225000e+01},
    { 42, 41,  2,  0, 0.65637740e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 41,  2,  1, 0.43556920e+03, 0.11055600e+02, 0.19545000e+01},
    { 42, 41,  2,  2, 0.37920750e+03, 0.11055600e+02, 0.29225000e+01},
    { 42, 42,  0,  0, 0.84589720e+03, 0.00000000e+00, 0.00000000e+00},
    { 42, 42,  1,  0, 0.64347210e+03, 0.19420000e+01, 0.00000000e+00},
    { 42, 42,  1,  1, 0.50200730e+03, 0.19420000e+01, 0.19420000e+01},
    { 42, 42,  2,  0, 0.50974240e+03, 0.11055600e+02, 0.00000000e+00},
    { 42, 42,  2,  1, 0.40706590e+03, 0.11055600e+02, 0.19420000e+01},
    { 42, 42,  2,  2, 0.33710750e+03, 0.11055600e+02, 0.11055600e+02},
    { 43,  1,  0,  0, 0.51052700e+02, 0.00000000e+00, 0.91180000e+00},
    { 43,  1,  0,  1, 0.85080000e+02, 0.00000000e+00, 0.00000000e+00},
    { 43,  1,  1,  0, 0.41338500e+02, 0.16682000e+01, 0.91180000e+00},
    { 43,  1,  1,  1, 0.67892400e+02, 0.16682000e+01, 0.00000000e+00},
    { 43,  1,  2,  0, 0.28262700e+02, 0.95402000e+01, 0.91180000e+00},
    { 43,  1,  2,  1, 0.44596300e+02, 0.95402000e+01, 0.00000000e+00},
    { 43,  2,  0,  0, 0.32058800e+02, 0.00000000e+00, 0.00000000e+00},
    { 43,  2,  1,  0, 0.26621700e+02, 0.16682000e+01, 0.00000000e+00},
    { 43,  2,  2,  0, 0.19355600e+02, 0.95402000e+01, 0.00000000e+00},
    { 43,  3,  0,  0, 0.10116099e+04, 0.00000000e+00, 0.00000000e+00},
    { 43,  3,  0,  1, 0.30065330e+03, 0.00000000e+00, 0.98650000e+00},
    { 43,  3,  1,  0, 0.76378140e+03, 0.16682000e+01, 0.00000000e+00},
    { 43,  3,  1,  1, 0.23295390e+03, 0.16682000e+01, 0.98650000e+00},
    { 43,  3,  2,  0, 0.39142550e+03, 0.95402000e+01, 0.00000000e+00},
    { 43,  3,  2,  1, 0.13836130e+03, 0.95402000e+01, 0.98650000e+00},
    { 43,  4,  0,  0, 0.52142490e+03, 0.00000000e+00, 0.00000000e+00},
    { 43,  4,  0,  1, 0.37952540e+03, 0.00000000e+00, 0.98080000e+00},
    { 43,  4,  0,  2, 0.23346060e+03, 0.00000000e+00, 0.19697000e+01},
    { 43,  4,  1,  0, 0.40277270e+03, 0.16682000e+01, 0.00000000e+00},
    { 43,  4,  1,  1, 0.29538160e+03, 0.16682000e+01, 0.98080000e+00},
    { 43,  4,  1,  2, 0.18502440e+03, 0.16682000e+01, 0.19697000e+01},
    { 43,  4,  2,  0, 0.23684570e+03, 0.95402000e+01, 0.00000000e+00},
    { 43,  4,  2,  1, 0.17768370e+03, 0.95402000e+01, 0.98080000e+00},
    { 43,  4,  2,  2, 0.11912060e+03, 0.95402000e+01, 0.19697000e+01},
    { 43,  5,  0,  0, 0.33032570e+03, 0.00000000e+00, 0.00000000e+00},
    { 43,  5,  0,  1, 0.27453340e+03, 0.00000000e+00, 0.97060000e+00},
    { 43,  5,  0,  2, 0.22779590e+03, 0.00000000e+00, 0.19441000e+01},
    { 43,  5,  0,  3, 0.16737830e+03, 0.00000000e+00, 0.29128000e+01},
    { 43,  5,  0,  4, 0.15672560e+03, 0.00000000e+00, 0.45856000e+01},
    { 43,  5,  1,  0, 0.26037960e+03, 0.16682000e+01, 0.00000000e+00},
    { 43,  5,  1,  1, 0.21747620e+03, 0.16682000e+01, 0.97060000e+00},
    { 43,  5,  1,  2, 0.18138850e+03, 0.16682000e+01, 0.19441000e+01},
    { 43,  5,  1,  3, 0.13497050e+03, 0.16682000e+01, 0.29128000e+01},
    { 43,  5,  1,  4, 0.12665710e+03, 0.16682000e+01, 0.45856000e+01},
    { 43,  5,  2,  0, 0.16457770e+03, 0.95402000e+01, 0.00000000e+00},
    { 43,  5,  2,  1, 0.13947630e+03, 0.95402000e+01, 0.97060000e+00},
    { 43,  5,  2,  2, 0.11797580e+03, 0.95402000e+01, 0.19441000e+01},
    { 43,  5,  2,  3, 0.91251800e+02, 0.95402000e+01, 0.29128000e+01},
    { 43,  5,  2,  4, 0.86127600e+02, 0.95402000e+01, 0.45856000e+01},
    { 43,  6,  0,  0, 0.21347990e+03, 0.00000000e+00, 0.00000000e+00},
    { 43,  6,  0,  1, 0.20054640e+03, 0.00000000e+00, 0.98680000e+00},
    { 43,  6,  0,  2, 0.16045200e+03, 0.00000000e+00, 0.19985000e+01},
    { 43,  6,  0,  3, 0.15013980e+03, 0.00000000e+00, 0.29987000e+01},
    { 43,  6,  0,  4, 0.11959950e+03, 0.00000000e+00, 0.39844000e+01},
    { 43,  6,  1,  0, 0.17125810e+03, 0.16682000e+01, 0.00000000e+00},
    { 43,  6,  1,  1, 0.16092230e+03, 0.16682000e+01, 0.98680000e+00},
    { 43,  6,  1,  2, 0.12970790e+03, 0.16682000e+01, 0.19985000e+01},
    { 43,  6,  1,  3, 0.12143810e+03, 0.16682000e+01, 0.29987000e+01},
    { 43,  6,  1,  4, 0.97841700e+02, 0.16682000e+01, 0.39844000e+01},
    { 43,  6,  2,  0, 0.11407740e+03, 0.95402000e+01, 0.00000000e+00},
    { 43,  6,  2,  1, 0.10709060e+03, 0.95402000e+01, 0.98680000e+00},
    { 43,  6,  2,  2, 0.88215800e+02, 0.95402000e+01, 0.19985000e+01},
    { 43,  6,  2,  3, 0.82649600e+02, 0.95402000e+01, 0.29987000e+01},
    { 43,  6,  2,  4, 0.68623700e+02, 0.95402000e+01, 0.39844000e+01},
    { 43,  7,  0,  0, 0.14456970e+03, 0.00000000e+00, 0.00000000e+00},
    { 43,  7,  0,  1, 0.13478870e+03, 0.00000000e+00, 0.99440000e+00},
    { 43,  7,  0,  2, 0.12608010e+03, 0.00000000e+00, 0.20143000e+01},
    { 43,  7,  0,  3, 0.11061190e+03, 0.00000000e+00, 0.29903000e+01},
    { 43,  7,  1,  0, 0.11764790e+03, 0.16682000e+01, 0.00000000e+00},
    { 43,  7,  1,  1, 0.10977550e+03, 0.16682000e+01, 0.99440000e+00},
    { 43,  7,  1,  2, 0.10285060e+03, 0.16682000e+01, 0.20143000e+01},
    { 43,  7,  1,  3, 0.90466000e+02, 0.16682000e+01, 0.29903000e+01},
    { 43,  7,  2,  0, 0.81421700e+02, 0.95402000e+01, 0.00000000e+00},
    { 43,  7,  2,  1, 0.76053200e+02, 0.95402000e+01, 0.99440000e+00},
    { 43,  7,  2,  2, 0.71572300e+02, 0.95402000e+01, 0.20143000e+01},
    { 43,  7,  2,  3, 0.63308100e+02, 0.95402000e+01, 0.29903000e+01},
    { 43,  8,  0,  0, 0.10705880e+03, 0.00000000e+00, 0.00000000e+00},
    { 43,  8,  0,  1, 0.95496600e+02, 0.00000000e+00, 0.99250000e+00},
    { 43,  8,  0,  2, 0.83640900e+02, 0.00000000e+00, 0.19887000e+01},
    { 43,  8,  1,  0, 0.88060900e+02, 0.16682000e+01, 0.00000000e+00},
    { 43,  8,  1,  1, 0.78792000e+02, 0.16682000e+01, 0.99250000e+00},
    { 43,  8,  1,  2, 0.69283800e+02, 0.16682000e+01, 0.19887000e+01},
    { 43,  8,  2,  0, 0.62588600e+02, 0.95402000e+01, 0.00000000e+00},
    { 43,  8,  2,  1, 0.56396200e+02, 0.95402000e+01, 0.99250000e+00},
    { 43,  8,  2,  2, 0.50040600e+02, 0.95402000e+01, 0.19887000e+01},
    { 43,  9,  0,  0, 0.79612100e+02, 0.00000000e+00, 0.00000000e+00},
    { 43,  9,  0,  1, 0.63507900e+02, 0.00000000e+00, 0.99820000e+00},
    { 43,  9,  1,  0, 0.66109300e+02, 0.16682000e+01, 0.00000000e+00},
    { 43,  9,  1,  1, 0.53288000e+02, 0.16682000e+01, 0.99820000e+00},
    { 43,  9,  2,  0, 0.48054000e+02, 0.95402000e+01, 0.00000000e+00},
    { 43,  9,  2,  1, 0.39666800e+02, 0.95402000e+01, 0.99820000e+00},
    { 43, 10,  0,  0, 0.60352100e+02, 0.00000000e+00, 0.00000000e+00},
    { 43, 10,  1,  0, 0.50508700e+02, 0.16682000e+01, 0.00000000e+00},
    { 43, 10,  2,  0, 0.37372300e+02, 0.95402000e+01, 0.00000000e+00},
    { 43, 11,  0,  0, 0.12015234e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 11,  0,  1, 0.44452690e+03, 0.00000000e+00, 0.96840000e+00},
    { 43, 11,  1,  0, 0.90840250e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 11,  1,  1, 0.34355920e+03, 0.16682000e+01, 0.96840000e+00},
    { 43, 11,  2,  0, 0.46976960e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 11,  2,  1, 0.20154030e+03, 0.95402000e+01, 0.96840000e+00},
    { 43, 12,  0,  0, 0.84734970e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 12,  0,  1, 0.69144970e+03, 0.00000000e+00, 0.96280000e+00},
    { 43, 12,  0,  2, 0.42526560e+03, 0.00000000e+00, 0.19496000e+01},
    { 43, 12,  1,  0, 0.65125640e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 12,  1,  1, 0.53370850e+03, 0.16682000e+01, 0.96280000e+00},
    { 43, 12,  1,  2, 0.33381660e+03, 0.16682000e+01, 0.19496000e+01},
    { 43, 12,  2,  0, 0.37426910e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 12,  2,  1, 0.31080830e+03, 0.95402000e+01, 0.96280000e+00},
    { 43, 12,  2,  2, 0.20841310e+03, 0.95402000e+01, 0.19496000e+01},
    { 43, 13,  0,  0, 0.75661950e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 13,  0,  1, 0.68054270e+03, 0.00000000e+00, 0.96480000e+00},
    { 43, 13,  0,  2, 0.51647660e+03, 0.00000000e+00, 0.19311000e+01},
    { 43, 13,  0,  3, 0.38882260e+03, 0.00000000e+00, 0.29146000e+01},
    { 43, 13,  1,  0, 0.58698620e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 13,  1,  1, 0.52930430e+03, 0.16682000e+01, 0.96480000e+00},
    { 43, 13,  1,  2, 0.40520110e+03, 0.16682000e+01, 0.19311000e+01},
    { 43, 13,  1,  3, 0.30843590e+03, 0.16682000e+01, 0.29146000e+01},
    { 43, 13,  2,  0, 0.35028040e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 13,  2,  1, 0.31873880e+03, 0.95402000e+01, 0.96480000e+00},
    { 43, 13,  2,  2, 0.25164210e+03, 0.95402000e+01, 0.19311000e+01},
    { 43, 13,  2,  3, 0.19915880e+03, 0.95402000e+01, 0.29146000e+01},
    { 43, 14,  0,  0, 0.57105010e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 14,  0,  1, 0.52464790e+03, 0.00000000e+00, 0.95070000e+00},
    { 43, 14,  0,  2, 0.48500980e+03, 0.00000000e+00, 0.19435000e+01},
    { 43, 14,  0,  3, 0.47494180e+03, 0.00000000e+00, 0.29407000e+01},
    { 43, 14,  0,  4, 0.37931480e+03, 0.00000000e+00, 0.38677000e+01},
    { 43, 14,  1,  0, 0.44911910e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 14,  1,  1, 0.41359910e+03, 0.16682000e+01, 0.95070000e+00},
    { 43, 14,  1,  2, 0.38317340e+03, 0.16682000e+01, 0.19435000e+01},
    { 43, 14,  1,  3, 0.37482840e+03, 0.16682000e+01, 0.29407000e+01},
    { 43, 14,  1,  4, 0.30236440e+03, 0.16682000e+01, 0.38677000e+01},
    { 43, 14,  2,  0, 0.28184800e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 14,  2,  1, 0.26141050e+03, 0.95402000e+01, 0.95070000e+00},
    { 43, 14,  2,  2, 0.24391880e+03, 0.95402000e+01, 0.19435000e+01},
    { 43, 14,  2,  3, 0.23741460e+03, 0.95402000e+01, 0.29407000e+01},
    { 43, 14,  2,  4, 0.19799630e+03, 0.95402000e+01, 0.38677000e+01},
    { 43, 15,  0,  0, 0.42976770e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 15,  0,  1, 0.41670800e+03, 0.00000000e+00, 0.99470000e+00},
    { 43, 15,  0,  2, 0.41204130e+03, 0.00000000e+00, 0.20102000e+01},
    { 43, 15,  0,  3, 0.37860580e+03, 0.00000000e+00, 0.29859000e+01},
    { 43, 15,  1,  0, 0.34248830e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 15,  1,  1, 0.33227830e+03, 0.16682000e+01, 0.99470000e+00},
    { 43, 15,  1,  2, 0.32833170e+03, 0.16682000e+01, 0.20102000e+01},
    { 43, 15,  1,  3, 0.30274930e+03, 0.16682000e+01, 0.29859000e+01},
    { 43, 15,  2,  0, 0.22400340e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 15,  2,  1, 0.21763470e+03, 0.95402000e+01, 0.99470000e+00},
    { 43, 15,  2,  2, 0.21451760e+03, 0.95402000e+01, 0.20102000e+01},
    { 43, 15,  2,  3, 0.19994180e+03, 0.95402000e+01, 0.29859000e+01},
    { 43, 16,  0,  0, 0.34877440e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 16,  0,  1, 0.34514340e+03, 0.00000000e+00, 0.99480000e+00},
    { 43, 16,  0,  2, 0.33802960e+03, 0.00000000e+00, 0.19903000e+01},
    { 43, 16,  1,  0, 0.28056130e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 16,  1,  1, 0.27760020e+03, 0.16682000e+01, 0.99480000e+00},
    { 43, 16,  1,  2, 0.27194340e+03, 0.16682000e+01, 0.19903000e+01},
    { 43, 16,  2,  0, 0.18840440e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 16,  2,  1, 0.18630930e+03, 0.95402000e+01, 0.99480000e+00},
    { 43, 16,  2,  2, 0.18261700e+03, 0.95402000e+01, 0.19903000e+01},
    { 43, 17,  0,  0, 0.27891230e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 17,  0,  1, 0.27614550e+03, 0.00000000e+00, 0.99720000e+00},
    { 43, 17,  1,  0, 0.22648330e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 17,  1,  1, 0.22420950e+03, 0.16682000e+01, 0.99720000e+00},
    { 43, 17,  2,  0, 0.15594050e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 17,  2,  1, 0.15431180e+03, 0.95402000e+01, 0.99720000e+00},
    { 43, 18,  0,  0, 0.22407940e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 18,  1,  0, 0.18352050e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 18,  2,  0, 0.12911050e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 19,  0,  0, 0.20076137e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 19,  0,  1, 0.59993020e+03, 0.00000000e+00, 0.97670000e+00},
    { 43, 19,  1,  0, 0.15188755e+04, 0.16682000e+01, 0.00000000e+00},
    { 43, 19,  1,  1, 0.46809770e+03, 0.16682000e+01, 0.97670000e+00},
    { 43, 19,  2,  0, 0.76793390e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 19,  2,  1, 0.28243840e+03, 0.95402000e+01, 0.97670000e+00},
    { 43, 20,  0,  0, 0.15434258e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 20,  0,  1, 0.12349316e+04, 0.00000000e+00, 0.98310000e+00},
    { 43, 20,  0,  2, 0.59749150e+03, 0.00000000e+00, 0.19349000e+01},
    { 43, 20,  1,  0, 0.11783302e+04, 0.16682000e+01, 0.00000000e+00},
    { 43, 20,  1,  1, 0.94599430e+03, 0.16682000e+01, 0.98310000e+00},
    { 43, 20,  1,  2, 0.46957520e+03, 0.16682000e+01, 0.19349000e+01},
    { 43, 20,  2,  0, 0.64950000e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 20,  2,  1, 0.52184580e+03, 0.95402000e+01, 0.98310000e+00},
    { 43, 20,  2,  2, 0.29311980e+03, 0.95402000e+01, 0.19349000e+01},
    { 43, 21,  0,  0, 0.12553446e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 21,  0,  1, 0.57916230e+03, 0.00000000e+00, 0.18627000e+01},
    { 43, 21,  0,  2, 0.56455600e+03, 0.00000000e+00, 0.28999000e+01},
    { 43, 21,  1,  0, 0.96136570e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 21,  1,  1, 0.45591090e+03, 0.16682000e+01, 0.18627000e+01},
    { 43, 21,  1,  2, 0.44614920e+03, 0.16682000e+01, 0.28999000e+01},
    { 43, 21,  2,  0, 0.53986620e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 21,  2,  1, 0.28622410e+03, 0.95402000e+01, 0.18627000e+01},
    { 43, 21,  2,  2, 0.28387840e+03, 0.95402000e+01, 0.28999000e+01},
    { 43, 22,  0,  0, 0.11958434e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 22,  0,  1, 0.55872110e+03, 0.00000000e+00, 0.18299000e+01},
    { 43, 22,  0,  2, 0.57079220e+03, 0.00000000e+00, 0.38675000e+01},
    { 43, 22,  1,  0, 0.91930990e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 22,  1,  1, 0.44025610e+03, 0.16682000e+01, 0.18299000e+01},
    { 43, 22,  1,  2, 0.45128660e+03, 0.16682000e+01, 0.38675000e+01},
    { 43, 22,  2,  0, 0.52491730e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 22,  2,  1, 0.27665670e+03, 0.95402000e+01, 0.18299000e+01},
    { 43, 22,  2,  2, 0.28758070e+03, 0.95402000e+01, 0.38675000e+01},
    { 43, 23,  0,  0, 0.10860231e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 23,  0,  1, 0.54789060e+03, 0.00000000e+00, 0.19138000e+01},
    { 43, 23,  0,  2, 0.52332230e+03, 0.00000000e+00, 0.29110000e+01},
    { 43, 23,  1,  0, 0.83673410e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 23,  1,  1, 0.43163910e+03, 0.16682000e+01, 0.19138000e+01},
    { 43, 23,  1,  2, 0.41382300e+03, 0.16682000e+01, 0.29110000e+01},
    { 43, 23,  2,  0, 0.48256220e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 23,  2,  1, 0.27110010e+03, 0.95402000e+01, 0.19138000e+01},
    { 43, 23,  2,  2, 0.26334090e+03, 0.95402000e+01, 0.29110000e+01},
    { 43, 24,  0,  0, 0.85474740e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 24,  0,  1, 0.54517240e+03, 0.00000000e+00, 0.18269000e+01},
    { 43, 24,  0,  2, 0.38391860e+03, 0.00000000e+00, 0.10619100e+02},
    { 43, 24,  1,  0, 0.65972010e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 24,  1,  1, 0.42896620e+03, 0.16682000e+01, 0.18269000e+01},
    { 43, 24,  1,  2, 0.30675850e+03, 0.16682000e+01, 0.10619100e+02},
    { 43, 24,  2,  0, 0.38140060e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 24,  2,  1, 0.26813250e+03, 0.95402000e+01, 0.18269000e+01},
    { 43, 24,  2,  2, 0.20147070e+03, 0.95402000e+01, 0.10619100e+02},
    { 43, 25,  0,  0, 0.92387430e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 25,  0,  1, 0.49132100e+03, 0.00000000e+00, 0.16406000e+01},
    { 43, 25,  0,  2, 0.32305520e+03, 0.00000000e+00, 0.98849000e+01},
    { 43, 25,  1,  0, 0.71418300e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 25,  1,  1, 0.38890660e+03, 0.16682000e+01, 0.16406000e+01},
    { 43, 25,  1,  2, 0.25980510e+03, 0.16682000e+01, 0.98849000e+01},
    { 43, 25,  2,  0, 0.41786140e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 25,  2,  1, 0.24878950e+03, 0.95402000e+01, 0.16406000e+01},
    { 43, 25,  2,  2, 0.17392920e+03, 0.95402000e+01, 0.98849000e+01},
    { 43, 26,  0,  0, 0.72332020e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 26,  0,  1, 0.45208310e+03, 0.00000000e+00, 0.16483000e+01},
    { 43, 26,  0,  2, 0.31774320e+03, 0.00000000e+00, 0.91376000e+01},
    { 43, 26,  1,  0, 0.56036480e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 26,  1,  1, 0.35865620e+03, 0.16682000e+01, 0.16483000e+01},
    { 43, 26,  1,  2, 0.25533300e+03, 0.16682000e+01, 0.91376000e+01},
    { 43, 26,  2,  0, 0.32931160e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 26,  2,  1, 0.23100810e+03, 0.95402000e+01, 0.16483000e+01},
    { 43, 26,  2,  2, 0.17055570e+03, 0.95402000e+01, 0.91376000e+01},
    { 43, 27,  0,  0, 0.75296780e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 27,  0,  1, 0.43134780e+03, 0.00000000e+00, 0.17149000e+01},
    { 43, 27,  0,  2, 0.38256460e+03, 0.00000000e+00, 0.29263000e+01},
    { 43, 27,  0,  3, 0.33455830e+03, 0.00000000e+00, 0.77785000e+01},
    { 43, 27,  1,  0, 0.58529350e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 27,  1,  1, 0.34229790e+03, 0.16682000e+01, 0.17149000e+01},
    { 43, 27,  1,  2, 0.30427490e+03, 0.16682000e+01, 0.29263000e+01},
    { 43, 27,  1,  3, 0.26786660e+03, 0.16682000e+01, 0.77785000e+01},
    { 43, 27,  2,  0, 0.35085640e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 27,  2,  1, 0.22048020e+03, 0.95402000e+01, 0.17149000e+01},
    { 43, 27,  2,  2, 0.19706800e+03, 0.95402000e+01, 0.29263000e+01},
    { 43, 27,  2,  3, 0.17710190e+03, 0.95402000e+01, 0.77785000e+01},
    { 43, 28,  0,  0, 0.78224830e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 28,  0,  1, 0.42241440e+03, 0.00000000e+00, 0.17937000e+01},
    { 43, 28,  0,  2, 0.35355460e+03, 0.00000000e+00, 0.65458000e+01},
    { 43, 28,  0,  3, 0.37763020e+03, 0.00000000e+00, 0.62918000e+01},
    { 43, 28,  1,  0, 0.60647400e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 28,  1,  1, 0.33502870e+03, 0.16682000e+01, 0.17937000e+01},
    { 43, 28,  1,  2, 0.28197070e+03, 0.16682000e+01, 0.65458000e+01},
    { 43, 28,  1,  3, 0.29944610e+03, 0.16682000e+01, 0.62918000e+01},
    { 43, 28,  2,  0, 0.35990170e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 28,  2,  1, 0.21540300e+03, 0.95402000e+01, 0.17937000e+01},
    { 43, 28,  2,  2, 0.18430860e+03, 0.95402000e+01, 0.65458000e+01},
    { 43, 28,  2,  3, 0.19205910e+03, 0.95402000e+01, 0.62918000e+01},
    { 43, 29,  0,  0, 0.59961920e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 29,  0,  1, 0.42391540e+03, 0.00000000e+00, 0.95760000e+00},
    { 43, 29,  1,  0, 0.46581470e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 29,  1,  1, 0.33456150e+03, 0.16682000e+01, 0.95760000e+00},
    { 43, 29,  2,  0, 0.27699700e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 29,  2,  1, 0.21142380e+03, 0.95402000e+01, 0.95760000e+00},
    { 43, 30,  0,  0, 0.59931410e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 30,  0,  1, 0.38662560e+03, 0.00000000e+00, 0.19419000e+01},
    { 43, 30,  1,  0, 0.46845290e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 30,  1,  1, 0.30788150e+03, 0.16682000e+01, 0.19419000e+01},
    { 43, 30,  2,  0, 0.28699270e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 30,  2,  1, 0.20075620e+03, 0.95402000e+01, 0.19419000e+01},
    { 43, 31,  0,  0, 0.71598110e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 31,  0,  1, 0.66676010e+03, 0.00000000e+00, 0.96010000e+00},
    { 43, 31,  0,  2, 0.51304100e+03, 0.00000000e+00, 0.19315000e+01},
    { 43, 31,  0,  3, 0.40759020e+03, 0.00000000e+00, 0.29233000e+01},
    { 43, 31,  1,  0, 0.55815220e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 31,  1,  1, 0.52114410e+03, 0.16682000e+01, 0.96010000e+00},
    { 43, 31,  1,  2, 0.40491750e+03, 0.16682000e+01, 0.19315000e+01},
    { 43, 31,  1,  3, 0.32490950e+03, 0.16682000e+01, 0.29233000e+01},
    { 43, 31,  2,  0, 0.33826270e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 31,  2,  1, 0.31899680e+03, 0.95402000e+01, 0.96010000e+00},
    { 43, 31,  2,  2, 0.25639330e+03, 0.95402000e+01, 0.19315000e+01},
    { 43, 31,  2,  3, 0.21269370e+03, 0.95402000e+01, 0.29233000e+01},
    { 43, 32,  0,  0, 0.61053270e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 32,  0,  1, 0.56682940e+03, 0.00000000e+00, 0.94340000e+00},
    { 43, 32,  0,  2, 0.53677950e+03, 0.00000000e+00, 0.19447000e+01},
    { 43, 32,  0,  3, 0.47466380e+03, 0.00000000e+00, 0.29186000e+01},
    { 43, 32,  0,  4, 0.41205940e+03, 0.00000000e+00, 0.38972000e+01},
    { 43, 32,  1,  0, 0.48089260e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 32,  1,  1, 0.44771310e+03, 0.16682000e+01, 0.94340000e+00},
    { 43, 32,  1,  2, 0.42477910e+03, 0.16682000e+01, 0.19447000e+01},
    { 43, 32,  1,  3, 0.37742760e+03, 0.16682000e+01, 0.29186000e+01},
    { 43, 32,  1,  4, 0.32966960e+03, 0.16682000e+01, 0.38972000e+01},
    { 43, 32,  2,  0, 0.30293890e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 32,  2,  1, 0.28455050e+03, 0.95402000e+01, 0.94340000e+00},
    { 43, 32,  2,  2, 0.27164740e+03, 0.95402000e+01, 0.19447000e+01},
    { 43, 32,  2,  3, 0.24504710e+03, 0.95402000e+01, 0.29186000e+01},
    { 43, 32,  2,  4, 0.21811560e+03, 0.95402000e+01, 0.38972000e+01},
    { 43, 33,  0,  0, 0.50550910e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 33,  0,  1, 0.49610230e+03, 0.00000000e+00, 0.98890000e+00},
    { 43, 33,  0,  2, 0.48162290e+03, 0.00000000e+00, 0.19793000e+01},
    { 43, 33,  0,  3, 0.46175770e+03, 0.00000000e+00, 0.29709000e+01},
    { 43, 33,  1,  0, 0.40245400e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 33,  1,  1, 0.39524720e+03, 0.16682000e+01, 0.98890000e+00},
    { 43, 33,  1,  2, 0.38416440e+03, 0.16682000e+01, 0.19793000e+01},
    { 43, 33,  1,  3, 0.36896070e+03, 0.16682000e+01, 0.29709000e+01},
    { 43, 33,  2,  0, 0.26234800e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 33,  2,  1, 0.25816170e+03, 0.95402000e+01, 0.98890000e+00},
    { 43, 33,  2,  2, 0.25179730e+03, 0.95402000e+01, 0.19793000e+01},
    { 43, 33,  2,  3, 0.24311650e+03, 0.95402000e+01, 0.29709000e+01},
    { 43, 34,  0,  0, 0.44547780e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 34,  0,  1, 0.44579160e+03, 0.00000000e+00, 0.99010000e+00},
    { 43, 34,  0,  2, 0.44207860e+03, 0.00000000e+00, 0.19812000e+01},
    { 43, 34,  1,  0, 0.35725110e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 34,  1,  1, 0.35747370e+03, 0.16682000e+01, 0.99010000e+00},
    { 43, 34,  1,  2, 0.35457680e+03, 0.16682000e+01, 0.19812000e+01},
    { 43, 34,  2,  0, 0.23782350e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 34,  2,  1, 0.23789530e+03, 0.95402000e+01, 0.99010000e+00},
    { 43, 34,  2,  2, 0.23610840e+03, 0.95402000e+01, 0.19812000e+01},
    { 43, 35,  0,  0, 0.38275910e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 35,  0,  1, 0.38579860e+03, 0.00000000e+00, 0.99740000e+00},
    { 43, 35,  1,  0, 0.30935300e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 35,  1,  1, 0.31169010e+03, 0.16682000e+01, 0.99740000e+00},
    { 43, 35,  2,  0, 0.21038120e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 35,  2,  1, 0.21174100e+03, 0.95402000e+01, 0.99740000e+00},
    { 43, 36,  0,  0, 0.32738270e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 36,  1,  0, 0.26657770e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 36,  2,  0, 0.18484770e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 37,  0,  0, 0.22379665e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 37,  0,  1, 0.71077790e+03, 0.00000000e+00, 0.97380000e+00},
    { 43, 37,  1,  0, 0.16961214e+04, 0.16682000e+01, 0.00000000e+00},
    { 43, 37,  1,  1, 0.55612550e+03, 0.16682000e+01, 0.97380000e+00},
    { 43, 37,  2,  0, 0.86376550e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 37,  2,  1, 0.33850140e+03, 0.95402000e+01, 0.97380000e+00},
    { 43, 38,  0,  0, 0.18443774e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 38,  0,  1, 0.15092981e+04, 0.00000000e+00, 0.98010000e+00},
    { 43, 38,  0,  2, 0.71471880e+03, 0.00000000e+00, 0.19143000e+01},
    { 43, 38,  1,  0, 0.14083895e+04, 0.16682000e+01, 0.00000000e+00},
    { 43, 38,  1,  1, 0.11562604e+04, 0.16682000e+01, 0.98010000e+00},
    { 43, 38,  1,  2, 0.56243130e+03, 0.16682000e+01, 0.19143000e+01},
    { 43, 38,  2,  0, 0.77394630e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 38,  2,  1, 0.63481680e+03, 0.95402000e+01, 0.98010000e+00},
    { 43, 38,  2,  2, 0.35195640e+03, 0.95402000e+01, 0.19143000e+01},
    { 43, 39,  0,  0, 0.15723759e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 39,  0,  1, 0.10932424e+04, 0.00000000e+00, 0.19153000e+01},
    { 43, 39,  0,  2, 0.67255530e+03, 0.00000000e+00, 0.28903000e+01},
    { 43, 39,  1,  0, 0.12079868e+04, 0.16682000e+01, 0.00000000e+00},
    { 43, 39,  1,  1, 0.84837270e+03, 0.16682000e+01, 0.19153000e+01},
    { 43, 39,  1,  2, 0.53297190e+03, 0.16682000e+01, 0.28903000e+01},
    { 43, 39,  2,  0, 0.68574890e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 39,  2,  1, 0.49663990e+03, 0.95402000e+01, 0.19153000e+01},
    { 43, 39,  2,  2, 0.34203460e+03, 0.95402000e+01, 0.28903000e+01},
    { 43, 40,  0,  0, 0.13895979e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 40,  0,  1, 0.76884280e+03, 0.00000000e+00, 0.19355000e+01},
    { 43, 40,  0,  2, 0.67400680e+03, 0.00000000e+00, 0.39106000e+01},
    { 43, 40,  1,  0, 0.10721935e+04, 0.16682000e+01, 0.00000000e+00},
    { 43, 40,  1,  1, 0.60533890e+03, 0.16682000e+01, 0.19355000e+01},
    { 43, 40,  1,  2, 0.53531530e+03, 0.16682000e+01, 0.39106000e+01},
    { 43, 40,  2,  0, 0.62104380e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 40,  2,  1, 0.37865110e+03, 0.95402000e+01, 0.19355000e+01},
    { 43, 40,  2,  2, 0.34602660e+03, 0.95402000e+01, 0.39106000e+01},
    { 43, 41,  0,  0, 0.12533465e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 41,  0,  1, 0.77673680e+03, 0.00000000e+00, 0.19545000e+01},
    { 43, 41,  0,  2, 0.65360280e+03, 0.00000000e+00, 0.29225000e+01},
    { 43, 41,  1,  0, 0.97020700e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 41,  1,  1, 0.61127640e+03, 0.16682000e+01, 0.19545000e+01},
    { 43, 41,  1,  2, 0.51908450e+03, 0.16682000e+01, 0.29225000e+01},
    { 43, 41,  2,  0, 0.56941590e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 41,  2,  1, 0.38232250e+03, 0.95402000e+01, 0.19545000e+01},
    { 43, 41,  2,  2, 0.33471740e+03, 0.95402000e+01, 0.29225000e+01},
    { 43, 42,  0,  0, 0.94964900e+03, 0.00000000e+00, 0.00000000e+00},
    { 43, 42,  0,  1, 0.71936590e+03, 0.00000000e+00, 0.19420000e+01},
    { 43, 42,  0,  2, 0.56744410e+03, 0.00000000e+00, 0.11055600e+02},
    { 43, 42,  1,  0, 0.73979150e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 42,  1,  1, 0.56776700e+03, 0.16682000e+01, 0.19420000e+01},
    { 43, 42,  1,  2, 0.45371970e+03, 0.16682000e+01, 0.11055600e+02},
    { 43, 42,  2,  0, 0.44434710e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 42,  2,  1, 0.35796340e+03, 0.95402000e+01, 0.19420000e+01},
    { 43, 42,  2,  2, 0.29885080e+03, 0.95402000e+01, 0.11055600e+02},
    { 43, 43,  0,  0, 0.10670169e+04, 0.00000000e+00, 0.00000000e+00},
    { 43, 43,  1,  0, 0.82924080e+03, 0.16682000e+01, 0.00000000e+00},
    { 43, 43,  1,  1, 0.64971430e+03, 0.16682000e+01, 0.16682000e+01},
    { 43, 43,  2,  0, 0.49374300e+03, 0.95402000e+01, 0.00000000e+00},
    { 43, 43,  2,  1, 0.39703670e+03, 0.95402000e+01, 0.16682000e+01},
    { 43, 43,  2,  2, 0.26586540e+03, 0.95402000e+01, 0.95402000e+01},
    { 44,  1,  0,  0, 0.39574500e+02, 0.00000000e+00, 0.91180000e+00},
    { 44,  1,  0,  1, 0.65086300e+02, 0.00000000e+00, 0.00000000e+00},
    { 44,  1,  1,  0, 0.33187500e+02, 0.18584000e+01, 0.91180000e+00},
    { 44,  1,  1,  1, 0.53364800e+02, 0.18584000e+01, 0.00000000e+00},
    { 44,  1,  2,  0, 0.26814200e+02, 0.88895000e+01, 0.91180000e+00},
    { 44,  1,  2,  1, 0.42162700e+02, 0.88895000e+01, 0.00000000e+00},
    { 44,  2,  0,  0, 0.25462200e+02, 0.00000000e+00, 0.00000000e+00},
    { 44,  2,  1,  0, 0.22061600e+02, 0.18584000e+01, 0.00000000e+00},
    { 44,  2,  2,  0, 0.18486400e+02, 0.88895000e+01, 0.00000000e+00},
    { 44,  3,  0,  0, 0.73055330e+03, 0.00000000e+00, 0.00000000e+00},
    { 44,  3,  0,  1, 0.22388710e+03, 0.00000000e+00, 0.98650000e+00},
    { 44,  3,  1,  0, 0.51733300e+03, 0.18584000e+01, 0.00000000e+00},
    { 44,  3,  1,  1, 0.17297080e+03, 0.18584000e+01, 0.98650000e+00},
    { 44,  3,  2,  0, 0.36441020e+03, 0.88895000e+01, 0.00000000e+00},
    { 44,  3,  2,  1, 0.12989070e+03, 0.88895000e+01, 0.98650000e+00},
    { 44,  4,  0,  0, 0.38726810e+03, 0.00000000e+00, 0.00000000e+00},
    { 44,  4,  0,  1, 0.28356950e+03, 0.00000000e+00, 0.98080000e+00},
    { 44,  4,  0,  2, 0.17751740e+03, 0.00000000e+00, 0.19697000e+01},
    { 44,  4,  1,  0, 0.29751860e+03, 0.18584000e+01, 0.00000000e+00},
    { 44,  4,  1,  1, 0.22067460e+03, 0.18584000e+01, 0.98080000e+00},
    { 44,  4,  1,  2, 0.14388510e+03, 0.18584000e+01, 0.19697000e+01},
    { 44,  4,  2,  0, 0.22214890e+03, 0.88895000e+01, 0.00000000e+00},
    { 44,  4,  2,  1, 0.16698720e+03, 0.88895000e+01, 0.98080000e+00},
    { 44,  4,  2,  2, 0.11243910e+03, 0.88895000e+01, 0.19697000e+01},
    { 44,  5,  0,  0, 0.24993820e+03, 0.00000000e+00, 0.00000000e+00},
    { 44,  5,  0,  1, 0.20863620e+03, 0.00000000e+00, 0.97060000e+00},
    { 44,  5,  0,  2, 0.17387670e+03, 0.00000000e+00, 0.19441000e+01},
    { 44,  5,  0,  3, 0.12927260e+03, 0.00000000e+00, 0.29128000e+01},
    { 44,  5,  0,  4, 0.12128760e+03, 0.00000000e+00, 0.45856000e+01},
    { 44,  5,  1,  0, 0.20032990e+03, 0.18584000e+01, 0.00000000e+00},
    { 44,  5,  1,  1, 0.16859440e+03, 0.18584000e+01, 0.97060000e+00},
    { 44,  5,  1,  2, 0.14162010e+03, 0.18584000e+01, 0.19441000e+01},
    { 44,  5,  1,  3, 0.10771280e+03, 0.18584000e+01, 0.29128000e+01},
    { 44,  5,  1,  4, 0.10138250e+03, 0.18584000e+01, 0.45856000e+01},
    { 44,  5,  2,  0, 0.15516280e+03, 0.88895000e+01, 0.00000000e+00},
    { 44,  5,  2,  1, 0.13166500e+03, 0.88895000e+01, 0.97060000e+00},
    { 44,  5,  2,  2, 0.11151080e+03, 0.88895000e+01, 0.19441000e+01},
    { 44,  5,  2,  3, 0.86498600e+02, 0.88895000e+01, 0.29128000e+01},
    { 44,  5,  2,  4, 0.81685300e+02, 0.88895000e+01, 0.45856000e+01},
    { 44,  6,  0,  0, 0.16412790e+03, 0.00000000e+00, 0.00000000e+00},
    { 44,  6,  0,  1, 0.15419380e+03, 0.00000000e+00, 0.98680000e+00},
    { 44,  6,  0,  2, 0.12423890e+03, 0.00000000e+00, 0.19985000e+01},
    { 44,  6,  0,  3, 0.11632470e+03, 0.00000000e+00, 0.29987000e+01},
    { 44,  6,  0,  4, 0.93626900e+02, 0.00000000e+00, 0.39844000e+01},
    { 44,  6,  1,  0, 0.13555170e+03, 0.18584000e+01, 0.00000000e+00},
    { 44,  6,  1,  1, 0.12721250e+03, 0.18584000e+01, 0.98680000e+00},
    { 44,  6,  1,  2, 0.10379560e+03, 0.18584000e+01, 0.19985000e+01},
    { 44,  6,  1,  3, 0.97174400e+02, 0.18584000e+01, 0.29987000e+01},
    { 44,  6,  1,  4, 0.79575000e+02, 0.18584000e+01, 0.39844000e+01},
    { 44,  6,  2,  0, 0.10802000e+03, 0.88895000e+01, 0.00000000e+00},
    { 44,  6,  2,  1, 0.10141840e+03, 0.88895000e+01, 0.98680000e+00},
    { 44,  6,  2,  2, 0.83694600e+02, 0.88895000e+01, 0.19985000e+01},
    { 44,  6,  2,  3, 0.78436800e+02, 0.88895000e+01, 0.29987000e+01},
    { 44,  6,  2,  4, 0.65290500e+02, 0.88895000e+01, 0.39844000e+01},
    { 44,  7,  0,  0, 0.11263780e+03, 0.00000000e+00, 0.00000000e+00},
    { 44,  7,  0,  1, 0.10509050e+03, 0.00000000e+00, 0.99440000e+00},
    { 44,  7,  0,  2, 0.98472800e+02, 0.00000000e+00, 0.20143000e+01},
    { 44,  7,  0,  3, 0.86616300e+02, 0.00000000e+00, 0.29903000e+01},
    { 44,  7,  1,  0, 0.95019000e+02, 0.18584000e+01, 0.00000000e+00},
    { 44,  7,  1,  1, 0.88661300e+02, 0.18584000e+01, 0.99440000e+00},
    { 44,  7,  1,  2, 0.83274400e+02, 0.18584000e+01, 0.20143000e+01},
    { 44,  7,  1,  3, 0.73425900e+02, 0.18584000e+01, 0.29903000e+01},
    { 44,  7,  2,  0, 0.77377200e+02, 0.88895000e+01, 0.00000000e+00},
    { 44,  7,  2,  1, 0.72295000e+02, 0.88895000e+01, 0.99440000e+00},
    { 44,  7,  2,  2, 0.68072000e+02, 0.88895000e+01, 0.20143000e+01},
    { 44,  7,  2,  3, 0.60264100e+02, 0.88895000e+01, 0.29903000e+01},
    { 44,  8,  0,  0, 0.84272500e+02, 0.00000000e+00, 0.00000000e+00},
    { 44,  8,  0,  1, 0.75391000e+02, 0.00000000e+00, 0.99250000e+00},
    { 44,  8,  0,  2, 0.66302500e+02, 0.00000000e+00, 0.19887000e+01},
    { 44,  8,  1,  0, 0.72117300e+02, 0.18584000e+01, 0.00000000e+00},
    { 44,  8,  1,  1, 0.64744800e+02, 0.18584000e+01, 0.99250000e+00},
    { 44,  8,  1,  2, 0.57192800e+02, 0.18584000e+01, 0.19887000e+01},
    { 44,  8,  2,  0, 0.59646000e+02, 0.88895000e+01, 0.00000000e+00},
    { 44,  8,  2,  1, 0.53786300e+02, 0.88895000e+01, 0.99250000e+00},
    { 44,  8,  2,  2, 0.47784700e+02, 0.88895000e+01, 0.19887000e+01},
    { 44,  9,  0,  0, 0.63259900e+02, 0.00000000e+00, 0.00000000e+00},
    { 44,  9,  0,  1, 0.50977000e+02, 0.00000000e+00, 0.99820000e+00},
    { 44,  9,  1,  0, 0.54778100e+02, 0.18584000e+01, 0.00000000e+00},
    { 44,  9,  1,  1, 0.44708700e+02, 0.18584000e+01, 0.99820000e+00},
    { 44,  9,  2,  0, 0.45913300e+02, 0.88895000e+01, 0.00000000e+00},
    { 44,  9,  2,  1, 0.37996100e+02, 0.88895000e+01, 0.99820000e+00},
    { 44, 10,  0,  0, 0.48342900e+02, 0.00000000e+00, 0.00000000e+00},
    { 44, 10,  1,  0, 0.42243200e+02, 0.18584000e+01, 0.00000000e+00},
    { 44, 10,  2,  0, 0.35788400e+02, 0.88895000e+01, 0.00000000e+00},
    { 44, 11,  0,  0, 0.86937740e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 11,  0,  1, 0.33022730e+03, 0.00000000e+00, 0.96840000e+00},
    { 44, 11,  1,  0, 0.61866690e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 11,  1,  1, 0.25309000e+03, 0.18584000e+01, 0.96840000e+00},
    { 44, 11,  2,  0, 0.43764910e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 11,  2,  1, 0.18913000e+03, 0.88895000e+01, 0.96840000e+00},
    { 44, 12,  0,  0, 0.62621040e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 12,  0,  1, 0.51267590e+03, 0.00000000e+00, 0.96280000e+00},
    { 44, 12,  0,  2, 0.32066780e+03, 0.00000000e+00, 0.19496000e+01},
    { 44, 12,  1,  0, 0.47441800e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 12,  1,  1, 0.39136060e+03, 0.18584000e+01, 0.96280000e+00},
    { 44, 12,  1,  2, 0.25522890e+03, 0.18584000e+01, 0.19496000e+01},
    { 44, 12,  2,  0, 0.35061410e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 12,  2,  1, 0.29149160e+03, 0.88895000e+01, 0.96280000e+00},
    { 44, 12,  2,  2, 0.19631020e+03, 0.88895000e+01, 0.19496000e+01},
    { 44, 13,  0,  0, 0.56407160e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 13,  0,  1, 0.50852890e+03, 0.00000000e+00, 0.96480000e+00},
    { 44, 13,  0,  2, 0.38899560e+03, 0.00000000e+00, 0.19311000e+01},
    { 44, 13,  0,  3, 0.29592560e+03, 0.00000000e+00, 0.29146000e+01},
    { 44, 13,  1,  0, 0.43702090e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 13,  1,  1, 0.39606340e+03, 0.18584000e+01, 0.96480000e+00},
    { 44, 13,  1,  2, 0.30854590e+03, 0.18584000e+01, 0.19311000e+01},
    { 44, 13,  1,  3, 0.24026870e+03, 0.18584000e+01, 0.29146000e+01},
    { 44, 13,  2,  0, 0.32894340e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 13,  2,  1, 0.29952560e+03, 0.88895000e+01, 0.96480000e+00},
    { 44, 13,  2,  2, 0.23698540e+03, 0.88895000e+01, 0.19311000e+01},
    { 44, 13,  2,  3, 0.18804460e+03, 0.88895000e+01, 0.29146000e+01},
    { 44, 14,  0,  0, 0.43121320e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 14,  0,  1, 0.39698620e+03, 0.00000000e+00, 0.95070000e+00},
    { 44, 14,  0,  2, 0.36773060e+03, 0.00000000e+00, 0.19435000e+01},
    { 44, 14,  0,  3, 0.35969290e+03, 0.00000000e+00, 0.29407000e+01},
    { 44, 14,  0,  4, 0.28993610e+03, 0.00000000e+00, 0.38677000e+01},
    { 44, 14,  1,  0, 0.34421130e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 14,  1,  1, 0.31817950e+03, 0.18584000e+01, 0.95070000e+00},
    { 44, 14,  1,  2, 0.29596310e+03, 0.18584000e+01, 0.19435000e+01},
    { 44, 14,  1,  3, 0.28854060e+03, 0.18584000e+01, 0.29407000e+01},
    { 44, 14,  1,  4, 0.23727980e+03, 0.18584000e+01, 0.38677000e+01},
    { 44, 14,  2,  0, 0.26558080e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 14,  2,  1, 0.24646800e+03, 0.88895000e+01, 0.95070000e+00},
    { 44, 14,  2,  2, 0.23009880e+03, 0.88895000e+01, 0.19435000e+01},
    { 44, 14,  2,  3, 0.22392390e+03, 0.88895000e+01, 0.29407000e+01},
    { 44, 14,  2,  4, 0.18716590e+03, 0.88895000e+01, 0.38677000e+01},
    { 44, 15,  0,  0, 0.32840720e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 15,  0,  1, 0.31859120e+03, 0.00000000e+00, 0.99470000e+00},
    { 44, 15,  0,  2, 0.31482970e+03, 0.00000000e+00, 0.20102000e+01},
    { 44, 15,  0,  3, 0.29020770e+03, 0.00000000e+00, 0.29859000e+01},
    { 44, 15,  1,  0, 0.26854160e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 15,  1,  1, 0.26070120e+03, 0.18584000e+01, 0.99470000e+00},
    { 44, 15,  1,  2, 0.25720590e+03, 0.18584000e+01, 0.20102000e+01},
    { 44, 15,  1,  3, 0.23860140e+03, 0.18584000e+01, 0.29859000e+01},
    { 44, 15,  2,  0, 0.21173900e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 15,  2,  1, 0.20575330e+03, 0.88895000e+01, 0.99470000e+00},
    { 44, 15,  2,  2, 0.20278480e+03, 0.88895000e+01, 0.20102000e+01},
    { 44, 15,  2,  3, 0.18915600e+03, 0.88895000e+01, 0.29859000e+01},
    { 44, 16,  0,  0, 0.26878240e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 16,  0,  1, 0.26595280e+03, 0.00000000e+00, 0.99480000e+00},
    { 44, 16,  0,  2, 0.26053350e+03, 0.00000000e+00, 0.19903000e+01},
    { 44, 16,  1,  0, 0.22308830e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 16,  1,  1, 0.22064770e+03, 0.18584000e+01, 0.99480000e+00},
    { 44, 16,  1,  2, 0.21620660e+03, 0.18584000e+01, 0.19903000e+01},
    { 44, 16,  2,  0, 0.17849350e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 16,  2,  1, 0.17650780e+03, 0.88895000e+01, 0.99480000e+00},
    { 44, 16,  2,  2, 0.17302410e+03, 0.88895000e+01, 0.19903000e+01},
    { 44, 17,  0,  0, 0.21680700e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 17,  0,  1, 0.21463800e+03, 0.00000000e+00, 0.99720000e+00},
    { 44, 17,  1,  0, 0.18247210e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 17,  1,  1, 0.18059160e+03, 0.18584000e+01, 0.99720000e+00},
    { 44, 17,  2,  0, 0.14807630e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 17,  2,  1, 0.14652980e+03, 0.88895000e+01, 0.99720000e+00},
    { 44, 18,  0,  0, 0.17558760e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 18,  1,  0, 0.14952220e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 18,  2,  0, 0.12286250e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 19,  0,  0, 0.14473048e+04, 0.00000000e+00, 0.00000000e+00},
    { 44, 19,  0,  1, 0.44930300e+03, 0.00000000e+00, 0.97670000e+00},
    { 44, 19,  1,  0, 0.10157997e+04, 0.18584000e+01, 0.00000000e+00},
    { 44, 19,  1,  1, 0.34947530e+03, 0.18584000e+01, 0.97670000e+00},
    { 44, 19,  2,  0, 0.71523760e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 19,  2,  1, 0.26580330e+03, 0.88895000e+01, 0.97670000e+00},
    { 44, 20,  0,  0, 0.11311769e+04, 0.00000000e+00, 0.00000000e+00},
    { 44, 20,  0,  1, 0.90575150e+03, 0.00000000e+00, 0.98310000e+00},
    { 44, 20,  0,  2, 0.45095970e+03, 0.00000000e+00, 0.19349000e+01},
    { 44, 20,  1,  0, 0.83526920e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 20,  1,  1, 0.66876460e+03, 0.18584000e+01, 0.98310000e+00},
    { 44, 20,  1,  2, 0.35837320e+03, 0.18584000e+01, 0.19349000e+01},
    { 44, 20,  2,  0, 0.60729210e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 20,  2,  1, 0.48833520e+03, 0.88895000e+01, 0.98310000e+00},
    { 44, 20,  2,  2, 0.27628420e+03, 0.88895000e+01, 0.19349000e+01},
    { 44, 21,  0,  0, 0.92358110e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 21,  0,  1, 0.43784320e+03, 0.00000000e+00, 0.18627000e+01},
    { 44, 21,  0,  2, 0.42826290e+03, 0.00000000e+00, 0.28999000e+01},
    { 44, 21,  1,  0, 0.68960880e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 21,  1,  1, 0.34907020e+03, 0.18584000e+01, 0.18627000e+01},
    { 44, 21,  1,  2, 0.34429480e+03, 0.18584000e+01, 0.28999000e+01},
    { 44, 21,  2,  0, 0.50528540e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 21,  2,  1, 0.26990590e+03, 0.88895000e+01, 0.18627000e+01},
    { 44, 21,  2,  2, 0.26790880e+03, 0.88895000e+01, 0.28999000e+01},
    { 44, 22,  0,  0, 0.88314920e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 22,  0,  1, 0.42257080e+03, 0.00000000e+00, 0.18299000e+01},
    { 44, 22,  0,  2, 0.43319140e+03, 0.00000000e+00, 0.38675000e+01},
    { 44, 22,  1,  0, 0.66581430e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 22,  1,  1, 0.33705530e+03, 0.18584000e+01, 0.18299000e+01},
    { 44, 22,  1,  2, 0.34854900e+03, 0.18584000e+01, 0.38675000e+01},
    { 44, 22,  2,  0, 0.49186430e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 22,  2,  1, 0.26094910e+03, 0.88895000e+01, 0.18299000e+01},
    { 44, 22,  2,  2, 0.27143870e+03, 0.88895000e+01, 0.38675000e+01},
    { 44, 23,  0,  0, 0.80388070e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 23,  0,  1, 0.41435750e+03, 0.00000000e+00, 0.19138000e+01},
    { 44, 23,  0,  2, 0.39715580e+03, 0.00000000e+00, 0.29110000e+01},
    { 44, 23,  1,  0, 0.60961590e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 23,  1,  1, 0.33035670e+03, 0.18584000e+01, 0.19138000e+01},
    { 44, 23,  1,  2, 0.31915840e+03, 0.18584000e+01, 0.29110000e+01},
    { 44, 23,  2,  0, 0.45247550e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 23,  2,  1, 0.25571250e+03, 0.88895000e+01, 0.19138000e+01},
    { 44, 23,  2,  2, 0.24860210e+03, 0.88895000e+01, 0.29110000e+01},
    { 44, 24,  0,  0, 0.63343940e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 24,  0,  1, 0.41181870e+03, 0.00000000e+00, 0.18269000e+01},
    { 44, 24,  0,  2, 0.29422580e+03, 0.00000000e+00, 0.10619100e+02},
    { 44, 24,  1,  0, 0.48063820e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 24,  1,  1, 0.32735530e+03, 0.18584000e+01, 0.18269000e+01},
    { 44, 24,  1,  2, 0.24066050e+03, 0.18584000e+01, 0.10619100e+02},
    { 44, 24,  2,  0, 0.35786670e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 24,  2,  1, 0.25285150e+03, 0.88895000e+01, 0.18269000e+01},
    { 44, 24,  2,  2, 0.19071700e+03, 0.88895000e+01, 0.10619100e+02},
    { 44, 25,  0,  0, 0.68617720e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 25,  0,  1, 0.37334420e+03, 0.00000000e+00, 0.16406000e+01},
    { 44, 25,  0,  2, 0.24907370e+03, 0.00000000e+00, 0.98849000e+01},
    { 44, 25,  1,  0, 0.52477480e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 25,  1,  1, 0.30103970e+03, 0.18584000e+01, 0.16406000e+01},
    { 44, 25,  1,  2, 0.20600200e+03, 0.18584000e+01, 0.98849000e+01},
    { 44, 25,  2,  0, 0.39219220e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 25,  2,  1, 0.23492290e+03, 0.88895000e+01, 0.16406000e+01},
    { 44, 25,  2,  2, 0.16490150e+03, 0.88895000e+01, 0.98849000e+01},
    { 44, 26,  0,  0, 0.53814350e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 26,  0,  1, 0.34423220e+03, 0.00000000e+00, 0.16483000e+01},
    { 44, 26,  0,  2, 0.24481840e+03, 0.00000000e+00, 0.91376000e+01},
    { 44, 26,  1,  0, 0.41224680e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 26,  1,  1, 0.27865260e+03, 0.18584000e+01, 0.16483000e+01},
    { 44, 26,  1,  2, 0.20221300e+03, 0.18584000e+01, 0.91376000e+01},
    { 44, 26,  2,  0, 0.30933800e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 26,  2,  1, 0.21825880e+03, 0.88895000e+01, 0.16483000e+01},
    { 44, 26,  2,  2, 0.16168180e+03, 0.88895000e+01, 0.91376000e+01},
    { 44, 27,  0,  0, 0.56248000e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 27,  0,  1, 0.32850150e+03, 0.00000000e+00, 0.17149000e+01},
    { 44, 27,  0,  2, 0.29196350e+03, 0.00000000e+00, 0.29263000e+01},
    { 44, 27,  0,  3, 0.25692950e+03, 0.00000000e+00, 0.77785000e+01},
    { 44, 27,  1,  0, 0.43640540e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 27,  1,  1, 0.26587520e+03, 0.18584000e+01, 0.17149000e+01},
    { 44, 27,  1,  2, 0.23690460e+03, 0.18584000e+01, 0.29263000e+01},
    { 44, 27,  1,  3, 0.21097970e+03, 0.18584000e+01, 0.77785000e+01},
    { 44, 27,  2,  0, 0.32981210e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 27,  2,  1, 0.20833810e+03, 0.88895000e+01, 0.17149000e+01},
    { 44, 27,  2,  2, 0.18635590e+03, 0.88895000e+01, 0.29263000e+01},
    { 44, 27,  2,  3, 0.16774480e+03, 0.88895000e+01, 0.77785000e+01},
    { 44, 28,  0,  0, 0.58290140e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 28,  0,  1, 0.32155060e+03, 0.00000000e+00, 0.17937000e+01},
    { 44, 28,  0,  2, 0.27055020e+03, 0.00000000e+00, 0.65458000e+01},
    { 44, 28,  0,  3, 0.28746140e+03, 0.00000000e+00, 0.62918000e+01},
    { 44, 28,  1,  0, 0.44958060e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 28,  1,  1, 0.25994720e+03, 0.18584000e+01, 0.17937000e+01},
    { 44, 28,  1,  2, 0.22072030e+03, 0.18584000e+01, 0.65458000e+01},
    { 44, 28,  1,  3, 0.23182850e+03, 0.18584000e+01, 0.62918000e+01},
    { 44, 28,  2,  0, 0.33808050e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 28,  2,  1, 0.20352280e+03, 0.88895000e+01, 0.17937000e+01},
    { 44, 28,  2,  2, 0.17440700e+03, 0.88895000e+01, 0.65458000e+01},
    { 44, 28,  2,  3, 0.18151960e+03, 0.88895000e+01, 0.62918000e+01},
    { 44, 29,  0,  0, 0.44742590e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 29,  0,  1, 0.32125020e+03, 0.00000000e+00, 0.95760000e+00},
    { 44, 29,  1,  0, 0.34510430e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 29,  1,  1, 0.25694800e+03, 0.18584000e+01, 0.95760000e+00},
    { 44, 29,  2,  0, 0.26041990e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 29,  2,  1, 0.19956410e+03, 0.88895000e+01, 0.95760000e+00},
    { 44, 30,  0,  0, 0.45015430e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 30,  0,  1, 0.29543070e+03, 0.00000000e+00, 0.19419000e+01},
    { 44, 30,  1,  0, 0.35378800e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 30,  1,  1, 0.24091240e+03, 0.18584000e+01, 0.19419000e+01},
    { 44, 30,  2,  0, 0.27017940e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 30,  2,  1, 0.18984580e+03, 0.88895000e+01, 0.19419000e+01},
    { 44, 31,  0,  0, 0.53610930e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 31,  0,  1, 0.50051620e+03, 0.00000000e+00, 0.96010000e+00},
    { 44, 31,  0,  2, 0.38860430e+03, 0.00000000e+00, 0.19315000e+01},
    { 44, 31,  0,  3, 0.31162540e+03, 0.00000000e+00, 0.29233000e+01},
    { 44, 31,  1,  0, 0.41885730e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 31,  1,  1, 0.39335710e+03, 0.18584000e+01, 0.96010000e+00},
    { 44, 31,  1,  2, 0.31159910e+03, 0.18584000e+01, 0.19315000e+01},
    { 44, 31,  1,  3, 0.25488120e+03, 0.18584000e+01, 0.29233000e+01},
    { 44, 31,  2,  0, 0.31812240e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 31,  2,  1, 0.30020530e+03, 0.88895000e+01, 0.96010000e+00},
    { 44, 31,  2,  2, 0.24186460e+03, 0.88895000e+01, 0.19315000e+01},
    { 44, 31,  2,  3, 0.20110400e+03, 0.88895000e+01, 0.29233000e+01},
    { 44, 32,  0,  0, 0.46167950e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 32,  0,  1, 0.42969960e+03, 0.00000000e+00, 0.94340000e+00},
    { 44, 32,  0,  2, 0.40763390e+03, 0.00000000e+00, 0.19447000e+01},
    { 44, 32,  0,  3, 0.36203660e+03, 0.00000000e+00, 0.29186000e+01},
    { 44, 32,  0,  4, 0.31604420e+03, 0.00000000e+00, 0.38972000e+01},
    { 44, 32,  1,  0, 0.36917340e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 32,  1,  1, 0.34538720e+03, 0.18584000e+01, 0.94340000e+00},
    { 44, 32,  1,  2, 0.32883410e+03, 0.18584000e+01, 0.19447000e+01},
    { 44, 32,  1,  3, 0.29466340e+03, 0.18584000e+01, 0.29186000e+01},
    { 44, 32,  1,  4, 0.26011760e+03, 0.18584000e+01, 0.38972000e+01},
    { 44, 32,  2,  0, 0.28561020e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 32,  2,  1, 0.26845380e+03, 0.88895000e+01, 0.94340000e+00},
    { 44, 32,  2,  2, 0.25639940e+03, 0.88895000e+01, 0.19447000e+01},
    { 44, 32,  2,  3, 0.23155270e+03, 0.88895000e+01, 0.29186000e+01},
    { 44, 32,  2,  4, 0.20639140e+03, 0.88895000e+01, 0.38972000e+01},
    { 44, 33,  0,  0, 0.38598830e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 33,  0,  1, 0.37904270e+03, 0.00000000e+00, 0.98890000e+00},
    { 44, 33,  0,  2, 0.36836950e+03, 0.00000000e+00, 0.19793000e+01},
    { 44, 33,  0,  3, 0.35373830e+03, 0.00000000e+00, 0.29709000e+01},
    { 44, 33,  1,  0, 0.31492530e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 33,  1,  1, 0.30960350e+03, 0.18584000e+01, 0.98890000e+00},
    { 44, 33,  1,  2, 0.30149240e+03, 0.18584000e+01, 0.19793000e+01},
    { 44, 33,  1,  3, 0.29041810e+03, 0.18584000e+01, 0.29709000e+01},
    { 44, 33,  2,  0, 0.24796070e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 33,  2,  1, 0.24404670e+03, 0.88895000e+01, 0.98890000e+00},
    { 44, 33,  2,  2, 0.23809660e+03, 0.88895000e+01, 0.19793000e+01},
    { 44, 33,  2,  3, 0.22998060e+03, 0.88895000e+01, 0.29709000e+01},
    { 44, 34,  0,  0, 0.34238140e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 34,  0,  1, 0.34259700e+03, 0.00000000e+00, 0.99010000e+00},
    { 44, 34,  0,  2, 0.33981570e+03, 0.00000000e+00, 0.19812000e+01},
    { 44, 34,  1,  0, 0.28273020e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 34,  1,  1, 0.28284600e+03, 0.18584000e+01, 0.99010000e+00},
    { 44, 34,  1,  2, 0.28063740e+03, 0.18584000e+01, 0.19812000e+01},
    { 44, 34,  2,  0, 0.22516700e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 34,  2,  1, 0.22523300e+03, 0.88895000e+01, 0.99010000e+00},
    { 44, 34,  2,  2, 0.22355550e+03, 0.88895000e+01, 0.19812000e+01},
    { 44, 35,  0,  0, 0.29626680e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 35,  0,  1, 0.29851740e+03, 0.00000000e+00, 0.99740000e+00},
    { 44, 35,  1,  0, 0.24762030e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 35,  1,  1, 0.24934040e+03, 0.18584000e+01, 0.99740000e+00},
    { 44, 35,  2,  0, 0.19955490e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 35,  2,  1, 0.20082890e+03, 0.88895000e+01, 0.99740000e+00},
    { 44, 36,  0,  0, 0.25515160e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 36,  1,  0, 0.21556830e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 36,  2,  0, 0.17565240e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 37,  0,  0, 0.16158387e+04, 0.00000000e+00, 0.00000000e+00},
    { 44, 37,  0,  1, 0.53361350e+03, 0.00000000e+00, 0.97380000e+00},
    { 44, 37,  1,  0, 0.11385265e+04, 0.18584000e+01, 0.00000000e+00},
    { 44, 37,  1,  1, 0.41708310e+03, 0.18584000e+01, 0.97380000e+00},
    { 44, 37,  2,  0, 0.80500650e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 37,  2,  1, 0.31880410e+03, 0.88895000e+01, 0.97380000e+00},
    { 44, 38,  0,  0, 0.13511988e+04, 0.00000000e+00, 0.00000000e+00},
    { 44, 38,  0,  1, 0.11061259e+04, 0.00000000e+00, 0.98010000e+00},
    { 44, 38,  0,  2, 0.53996390e+03, 0.00000000e+00, 0.19143000e+01},
    { 44, 38,  1,  0, 0.99561160e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 38,  1,  1, 0.81419750e+03, 0.18584000e+01, 0.98010000e+00},
    { 44, 38,  1,  2, 0.42953830e+03, 0.18584000e+01, 0.19143000e+01},
    { 44, 38,  2,  0, 0.72369110e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 38,  2,  1, 0.59403870e+03, 0.88895000e+01, 0.98010000e+00},
    { 44, 38,  2,  2, 0.33186870e+03, 0.88895000e+01, 0.19143000e+01},
    { 44, 39,  0,  0, 0.11599071e+04, 0.00000000e+00, 0.00000000e+00},
    { 44, 39,  0,  1, 0.81262860e+03, 0.00000000e+00, 0.19153000e+01},
    { 44, 39,  0,  2, 0.51147220e+03, 0.00000000e+00, 0.28903000e+01},
    { 44, 39,  1,  0, 0.87126000e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 39,  1,  1, 0.62130580e+03, 0.18584000e+01, 0.19153000e+01},
    { 44, 39,  1,  2, 0.41319030e+03, 0.18584000e+01, 0.28903000e+01},
    { 44, 39,  2,  0, 0.64242790e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 39,  2,  1, 0.46651060e+03, 0.88895000e+01, 0.19153000e+01},
    { 44, 39,  2,  2, 0.32301240e+03, 0.88895000e+01, 0.28903000e+01},
    { 44, 40,  0,  0, 0.10297665e+04, 0.00000000e+00, 0.00000000e+00},
    { 44, 40,  0,  1, 0.58090070e+03, 0.00000000e+00, 0.19355000e+01},
    { 44, 40,  0,  2, 0.51361970e+03, 0.00000000e+00, 0.39106000e+01},
    { 44, 40,  1,  0, 0.78271660e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 40,  1,  1, 0.46191410e+03, 0.18584000e+01, 0.19355000e+01},
    { 44, 40,  1,  2, 0.41671520e+03, 0.18584000e+01, 0.39106000e+01},
    { 44, 40,  2,  0, 0.58255440e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 40,  2,  1, 0.35708190e+03, 0.88895000e+01, 0.19355000e+01},
    { 44, 40,  2,  2, 0.32694770e+03, 0.88895000e+01, 0.39106000e+01},
    { 44, 41,  0,  0, 0.93174450e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 41,  0,  1, 0.58689450e+03, 0.00000000e+00, 0.19545000e+01},
    { 44, 41,  0,  2, 0.49792860e+03, 0.00000000e+00, 0.29225000e+01},
    { 44, 41,  1,  0, 0.71364770e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 41,  1,  1, 0.46653580e+03, 0.18584000e+01, 0.19545000e+01},
    { 44, 41,  1,  2, 0.40320320e+03, 0.18584000e+01, 0.29225000e+01},
    { 44, 41,  2,  0, 0.53462660e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 41,  2,  1, 0.36054300e+03, 0.88895000e+01, 0.19545000e+01},
    { 44, 41,  2,  2, 0.31629900e+03, 0.88895000e+01, 0.29225000e+01},
    { 44, 42,  0,  0, 0.71028370e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 42,  0,  1, 0.54480750e+03, 0.00000000e+00, 0.19420000e+01},
    { 44, 42,  0,  2, 0.43508880e+03, 0.00000000e+00, 0.11055600e+02},
    { 44, 42,  1,  0, 0.55112400e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 42,  1,  1, 0.43510620e+03, 0.18584000e+01, 0.19420000e+01},
    { 44, 42,  1,  2, 0.35663380e+03, 0.18584000e+01, 0.11055600e+02},
    { 44, 42,  2,  0, 0.41798890e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 42,  2,  1, 0.33781860e+03, 0.88895000e+01, 0.19420000e+01},
    { 44, 42,  2,  2, 0.28288320e+03, 0.88895000e+01, 0.11055600e+02},
    { 44, 43,  0,  0, 0.79619510e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 43,  0,  1, 0.62313860e+03, 0.00000000e+00, 0.16682000e+01},
    { 44, 43,  0,  2, 0.38057300e+03, 0.00000000e+00, 0.95402000e+01},
    { 44, 43,  1,  0, 0.61481850e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 43,  1,  1, 0.48832640e+03, 0.18584000e+01, 0.16682000e+01},
    { 44, 43,  1,  2, 0.31491710e+03, 0.18584000e+01, 0.95402000e+01},
    { 44, 43,  2,  0, 0.46412390e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 43,  2,  1, 0.37403450e+03, 0.88895000e+01, 0.16682000e+01},
    { 44, 43,  2,  2, 0.25200750e+03, 0.88895000e+01, 0.95402000e+01},
    { 44, 44,  0,  0, 0.59819880e+03, 0.00000000e+00, 0.00000000e+00},
    { 44, 44,  1,  0, 0.46856950e+03, 0.18584000e+01, 0.00000000e+00},
    { 44, 44,  1,  1, 0.37926550e+03, 0.18584000e+01, 0.18584000e+01},
    { 44, 44,  2,  0, 0.35848400e+03, 0.88895000e+01, 0.00000000e+00},
    { 44, 44,  2,  1, 0.29766760e+03, 0.88895000e+01, 0.18584000e+01},
    { 44, 44,  2,  2, 0.23900710e+03, 0.88895000e+01, 0.88895000e+01},
    { 45,  1,  0,  0, 0.43166100e+02, 0.00000000e+00, 0.91180000e+00},
    { 45,  1,  0,  1, 0.71198500e+02, 0.00000000e+00, 0.00000000e+00},
    { 45,  1,  1,  0, 0.31102400e+02, 0.19003000e+01, 0.91180000e+00},
    { 45,  1,  1,  1, 0.49909000e+02, 0.19003000e+01, 0.00000000e+00},
    { 45,  1,  2,  0, 0.26980300e+02, 0.29696000e+01, 0.91180000e+00},
    { 45,  1,  2,  1, 0.42771400e+02, 0.29696000e+01, 0.00000000e+00},
    { 45,  2,  0,  0, 0.27574500e+02, 0.00000000e+00, 0.00000000e+00},
    { 45,  2,  1,  0, 0.20777600e+02, 0.19003000e+01, 0.00000000e+00},
    { 45,  2,  2,  0, 0.18402600e+02, 0.29696000e+01, 0.00000000e+00},
    { 45,  3,  0,  0, 0.79420060e+03, 0.00000000e+00, 0.00000000e+00},
    { 45,  3,  0,  1, 0.24525610e+03, 0.00000000e+00, 0.98650000e+00},
    { 45,  3,  1,  0, 0.48243420e+03, 0.19003000e+01, 0.00000000e+00},
    { 45,  3,  1,  1, 0.16134990e+03, 0.19003000e+01, 0.98650000e+00},
    { 45,  3,  2,  0, 0.39027660e+03, 0.29696000e+01, 0.00000000e+00},
    { 45,  3,  2,  1, 0.13469310e+03, 0.29696000e+01, 0.98650000e+00},
    { 45,  4,  0,  0, 0.42441200e+03, 0.00000000e+00, 0.00000000e+00},
    { 45,  4,  0,  1, 0.31037810e+03, 0.00000000e+00, 0.98080000e+00},
    { 45,  4,  0,  2, 0.19439840e+03, 0.00000000e+00, 0.19697000e+01},
    { 45,  4,  1,  0, 0.27741740e+03, 0.19003000e+01, 0.00000000e+00},
    { 45,  4,  1,  1, 0.20595300e+03, 0.19003000e+01, 0.98080000e+00},
    { 45,  4,  1,  2, 0.13445760e+03, 0.19003000e+01, 0.19697000e+01},
    { 45,  4,  2,  0, 0.23089960e+03, 0.29696000e+01, 0.00000000e+00},
    { 45,  4,  2,  1, 0.17260210e+03, 0.29696000e+01, 0.98080000e+00},
    { 45,  4,  2,  2, 0.11455870e+03, 0.29696000e+01, 0.19697000e+01},
    { 45,  5,  0,  0, 0.27371950e+03, 0.00000000e+00, 0.00000000e+00},
    { 45,  5,  0,  1, 0.22828220e+03, 0.00000000e+00, 0.97060000e+00},
    { 45,  5,  0,  2, 0.19004450e+03, 0.00000000e+00, 0.19441000e+01},
    { 45,  5,  0,  3, 0.14111090e+03, 0.00000000e+00, 0.29128000e+01},
    { 45,  5,  0,  4, 0.13232810e+03, 0.00000000e+00, 0.45856000e+01},
    { 45,  5,  1,  0, 0.18713270e+03, 0.19003000e+01, 0.00000000e+00},
    { 45,  5,  1,  1, 0.15759490e+03, 0.19003000e+01, 0.97060000e+00},
    { 45,  5,  1,  2, 0.13247760e+03, 0.19003000e+01, 0.19441000e+01},
    { 45,  5,  1,  3, 0.10089580e+03, 0.19003000e+01, 0.29128000e+01},
    { 45,  5,  1,  4, 0.94998700e+02, 0.19003000e+01, 0.45856000e+01},
    { 45,  5,  2,  0, 0.15871240e+03, 0.29696000e+01, 0.00000000e+00},
    { 45,  5,  2,  1, 0.13425050e+03, 0.29696000e+01, 0.97060000e+00},
    { 45,  5,  2,  2, 0.11335080e+03, 0.29696000e+01, 0.19441000e+01},
    { 45,  5,  2,  3, 0.87237600e+02, 0.29696000e+01, 0.29128000e+01},
    { 45,  5,  2,  4, 0.82288700e+02, 0.29696000e+01, 0.45856000e+01},
    { 45,  6,  0,  0, 0.17927080e+03, 0.00000000e+00, 0.00000000e+00},
    { 45,  6,  0,  1, 0.16831150e+03, 0.00000000e+00, 0.98680000e+00},
    { 45,  6,  0,  2, 0.13547600e+03, 0.00000000e+00, 0.19985000e+01},
    { 45,  6,  0,  3, 0.12677780e+03, 0.00000000e+00, 0.29987000e+01},
    { 45,  6,  0,  4, 0.10181940e+03, 0.00000000e+00, 0.39844000e+01},
    { 45,  6,  1,  0, 0.12690850e+03, 0.19003000e+01, 0.00000000e+00},
    { 45,  6,  1,  1, 0.11912650e+03, 0.19003000e+01, 0.98680000e+00},
    { 45,  6,  1,  2, 0.97296100e+02, 0.19003000e+01, 0.19985000e+01},
    { 45,  6,  1,  3, 0.91117100e+02, 0.19003000e+01, 0.29987000e+01},
    { 45,  6,  1,  4, 0.74728700e+02, 0.19003000e+01, 0.39844000e+01},
    { 45,  6,  2,  0, 0.10928410e+03, 0.29696000e+01, 0.00000000e+00},
    { 45,  6,  2,  1, 0.10261550e+03, 0.29696000e+01, 0.98680000e+00},
    { 45,  6,  2,  2, 0.84329800e+02, 0.29696000e+01, 0.19985000e+01},
    { 45,  6,  2,  3, 0.79027900e+02, 0.29696000e+01, 0.29987000e+01},
    { 45,  6,  2,  4, 0.65394900e+02, 0.29696000e+01, 0.39844000e+01},
    { 45,  7,  0,  0, 0.12264260e+03, 0.00000000e+00, 0.00000000e+00},
    { 45,  7,  0,  1, 0.11434960e+03, 0.00000000e+00, 0.99440000e+00},
    { 45,  7,  0,  2, 0.10710840e+03, 0.00000000e+00, 0.20143000e+01},
    { 45,  7,  0,  3, 0.94100700e+02, 0.00000000e+00, 0.29903000e+01},
    { 45,  7,  1,  0, 0.89165900e+02, 0.19003000e+01, 0.00000000e+00},
    { 45,  7,  1,  1, 0.83222700e+02, 0.19003000e+01, 0.99440000e+00},
    { 45,  7,  1,  2, 0.78197600e+02, 0.19003000e+01, 0.20143000e+01},
    { 45,  7,  1,  3, 0.69000500e+02, 0.19003000e+01, 0.29903000e+01},
    { 45,  7,  2,  0, 0.77707400e+02, 0.29696000e+01, 0.00000000e+00},
    { 45,  7,  2,  1, 0.72586300e+02, 0.29696000e+01, 0.99440000e+00},
    { 45,  7,  2,  2, 0.68302900e+02, 0.29696000e+01, 0.20143000e+01},
    { 45,  7,  2,  3, 0.60414900e+02, 0.29696000e+01, 0.29903000e+01},
    { 45,  8,  0,  0, 0.91495900e+02, 0.00000000e+00, 0.00000000e+00},
    { 45,  8,  0,  1, 0.81764000e+02, 0.00000000e+00, 0.99250000e+00},
    { 45,  8,  0,  2, 0.71807100e+02, 0.00000000e+00, 0.19887000e+01},
    { 45,  8,  1,  0, 0.67811400e+02, 0.19003000e+01, 0.00000000e+00},
    { 45,  8,  1,  1, 0.60915900e+02, 0.19003000e+01, 0.99250000e+00},
    { 45,  8,  1,  2, 0.53867000e+02, 0.19003000e+01, 0.19887000e+01},
    { 45,  8,  2,  0, 0.59619400e+02, 0.29696000e+01, 0.00000000e+00},
    { 45,  8,  2,  1, 0.53693400e+02, 0.29696000e+01, 0.99250000e+00},
    { 45,  8,  2,  2, 0.47642200e+02, 0.29696000e+01, 0.19887000e+01},
    { 45,  9,  0,  0, 0.68488800e+02, 0.00000000e+00, 0.00000000e+00},
    { 45,  9,  0,  1, 0.55024000e+02, 0.00000000e+00, 0.99820000e+00},
    { 45,  9,  1,  0, 0.51611700e+02, 0.19003000e+01, 0.00000000e+00},
    { 45,  9,  1,  1, 0.42208400e+02, 0.19003000e+01, 0.99820000e+00},
    { 45,  9,  2,  0, 0.45728900e+02, 0.29696000e+01, 0.00000000e+00},
    { 45,  9,  2,  1, 0.37696700e+02, 0.29696000e+01, 0.99820000e+00},
    { 45, 10,  0,  0, 0.52207200e+02, 0.00000000e+00, 0.00000000e+00},
    { 45, 10,  1,  0, 0.39876200e+02, 0.19003000e+01, 0.00000000e+00},
    { 45, 10,  2,  0, 0.35556300e+02, 0.29696000e+01, 0.00000000e+00},
    { 45, 11,  0,  0, 0.94542210e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 11,  0,  1, 0.36142870e+03, 0.00000000e+00, 0.96840000e+00},
    { 45, 11,  1,  0, 0.57701810e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 11,  1,  1, 0.23614440e+03, 0.19003000e+01, 0.96840000e+00},
    { 45, 11,  2,  0, 0.46780860e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 11,  2,  1, 0.19669260e+03, 0.29696000e+01, 0.96840000e+00},
    { 45, 12,  0,  0, 0.68566280e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 12,  0,  1, 0.56100100e+03, 0.00000000e+00, 0.96280000e+00},
    { 45, 12,  0,  2, 0.35143020e+03, 0.00000000e+00, 0.19496000e+01},
    { 45, 12,  1,  0, 0.44233810e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 12,  1,  1, 0.36507050e+03, 0.19003000e+01, 0.96280000e+00},
    { 45, 12,  1,  2, 0.23831870e+03, 0.19003000e+01, 0.19496000e+01},
    { 45, 12,  2,  0, 0.36632450e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 12,  2,  1, 0.30353120e+03, 0.29696000e+01, 0.96280000e+00},
    { 45, 12,  2,  2, 0.20139880e+03, 0.29696000e+01, 0.19496000e+01},
    { 45, 13,  0,  0, 0.61792440e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 13,  0,  1, 0.55700430e+03, 0.00000000e+00, 0.96480000e+00},
    { 45, 13,  0,  2, 0.42598370e+03, 0.00000000e+00, 0.19311000e+01},
    { 45, 13,  0,  3, 0.32404080e+03, 0.00000000e+00, 0.29146000e+01},
    { 45, 13,  1,  0, 0.40769990e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 13,  1,  1, 0.36958140e+03, 0.19003000e+01, 0.96480000e+00},
    { 45, 13,  1,  2, 0.28812910e+03, 0.19003000e+01, 0.19311000e+01},
    { 45, 13,  1,  3, 0.22456570e+03, 0.19003000e+01, 0.29146000e+01},
    { 45, 13,  2,  0, 0.34074550e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 13,  2,  1, 0.30963670e+03, 0.29696000e+01, 0.96480000e+00},
    { 45, 13,  2,  2, 0.24332100e+03, 0.29696000e+01, 0.19311000e+01},
    { 45, 13,  2,  3, 0.19149380e+03, 0.29696000e+01, 0.29146000e+01},
    { 45, 14,  0,  0, 0.47237380e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 14,  0,  1, 0.43472510e+03, 0.00000000e+00, 0.95070000e+00},
    { 45, 14,  0,  2, 0.40262390e+03, 0.00000000e+00, 0.19435000e+01},
    { 45, 14,  0,  3, 0.39366130e+03, 0.00000000e+00, 0.29407000e+01},
    { 45, 14,  0,  4, 0.31720640e+03, 0.00000000e+00, 0.38677000e+01},
    { 45, 14,  1,  0, 0.32145940e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 14,  1,  1, 0.29723390e+03, 0.19003000e+01, 0.95070000e+00},
    { 45, 14,  1,  2, 0.27654270e+03, 0.19003000e+01, 0.19435000e+01},
    { 45, 14,  1,  3, 0.26962410e+03, 0.19003000e+01, 0.29407000e+01},
    { 45, 14,  1,  4, 0.22191000e+03, 0.19003000e+01, 0.38677000e+01},
    { 45, 14,  2,  0, 0.27209130e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 14,  2,  1, 0.25211010e+03, 0.29696000e+01, 0.95070000e+00},
    { 45, 14,  2,  2, 0.23501080e+03, 0.29696000e+01, 0.19435000e+01},
    { 45, 14,  2,  3, 0.22893290e+03, 0.29696000e+01, 0.29407000e+01},
    { 45, 14,  2,  4, 0.19002130e+03, 0.29696000e+01, 0.38677000e+01},
    { 45, 15,  0,  0, 0.35925470e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 15,  0,  1, 0.34844490e+03, 0.00000000e+00, 0.99470000e+00},
    { 45, 15,  0,  2, 0.34429870e+03, 0.00000000e+00, 0.20102000e+01},
    { 45, 15,  0,  3, 0.31726290e+03, 0.00000000e+00, 0.29859000e+01},
    { 45, 15,  1,  0, 0.25114770e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 15,  1,  1, 0.24384390e+03, 0.19003000e+01, 0.99470000e+00},
    { 45, 15,  1,  2, 0.24057510e+03, 0.19003000e+01, 0.20102000e+01},
    { 45, 15,  1,  3, 0.22325490e+03, 0.19003000e+01, 0.29859000e+01},
    { 45, 15,  2,  0, 0.21501450e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 15,  2,  1, 0.20887230e+03, 0.29696000e+01, 0.99470000e+00},
    { 45, 15,  2,  2, 0.20596780e+03, 0.29696000e+01, 0.20102000e+01},
    { 45, 15,  2,  3, 0.19169620e+03, 0.29696000e+01, 0.29859000e+01},
    { 45, 16,  0,  0, 0.29352140e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 16,  0,  1, 0.29041460e+03, 0.00000000e+00, 0.99480000e+00},
    { 45, 16,  0,  2, 0.28446820e+03, 0.00000000e+00, 0.19903000e+01},
    { 45, 16,  1,  0, 0.20890670e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 16,  1,  1, 0.20662580e+03, 0.19003000e+01, 0.99480000e+00},
    { 45, 16,  1,  2, 0.20248030e+03, 0.19003000e+01, 0.19903000e+01},
    { 45, 16,  2,  0, 0.18027000e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 16,  2,  1, 0.17828770e+03, 0.29696000e+01, 0.99480000e+00},
    { 45, 16,  2,  2, 0.17475170e+03, 0.29696000e+01, 0.19903000e+01},
    { 45, 17,  0,  0, 0.23627500e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 17,  0,  1, 0.23390310e+03, 0.00000000e+00, 0.99720000e+00},
    { 45, 17,  1,  0, 0.17111870e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 17,  1,  1, 0.16935840e+03, 0.19003000e+01, 0.99720000e+00},
    { 45, 17,  2,  0, 0.14881480e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 17,  2,  1, 0.14727550e+03, 0.29696000e+01, 0.99720000e+00},
    { 45, 18,  0,  0, 0.19093520e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 18,  1,  0, 0.14042730e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 18,  2,  0, 0.12298220e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 19,  0,  0, 0.15674954e+04, 0.00000000e+00, 0.00000000e+00},
    { 45, 19,  0,  1, 0.49058070e+03, 0.00000000e+00, 0.97670000e+00},
    { 45, 19,  1,  0, 0.94851400e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 19,  1,  1, 0.32659470e+03, 0.19003000e+01, 0.97670000e+00},
    { 45, 19,  2,  0, 0.76742050e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 19,  2,  1, 0.27459280e+03, 0.29696000e+01, 0.97670000e+00},
    { 45, 20,  0,  0, 0.12346013e+04, 0.00000000e+00, 0.00000000e+00},
    { 45, 20,  0,  1, 0.98637270e+03, 0.00000000e+00, 0.98310000e+00},
    { 45, 20,  0,  2, 0.49339260e+03, 0.00000000e+00, 0.19349000e+01},
    { 45, 20,  1,  0, 0.77905470e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 20,  1,  1, 0.62428500e+03, 0.19003000e+01, 0.98310000e+00},
    { 45, 20,  1,  2, 0.33488270e+03, 0.19003000e+01, 0.19349000e+01},
    { 45, 20,  2,  0, 0.64014310e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 20,  2,  1, 0.51413850e+03, 0.29696000e+01, 0.98310000e+00},
    { 45, 20,  2,  2, 0.28343990e+03, 0.29696000e+01, 0.19349000e+01},
    { 45, 21,  0,  0, 0.10091933e+04, 0.00000000e+00, 0.00000000e+00},
    { 45, 21,  0,  1, 0.47895980e+03, 0.00000000e+00, 0.18627000e+01},
    { 45, 21,  0,  2, 0.46853580e+03, 0.00000000e+00, 0.28999000e+01},
    { 45, 21,  1,  0, 0.64318930e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 21,  1,  1, 0.32625030e+03, 0.19003000e+01, 0.18627000e+01},
    { 45, 21,  1,  2, 0.32185830e+03, 0.19003000e+01, 0.28999000e+01},
    { 45, 21,  2,  0, 0.53051110e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 21,  2,  1, 0.27656690e+03, 0.29696000e+01, 0.18627000e+01},
    { 45, 21,  2,  2, 0.27371790e+03, 0.29696000e+01, 0.28999000e+01},
    { 45, 22,  0,  0, 0.96523080e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 22,  0,  1, 0.46203140e+03, 0.00000000e+00, 0.18299000e+01},
    { 45, 22,  0,  2, 0.47389730e+03, 0.00000000e+00, 0.38675000e+01},
    { 45, 22,  1,  0, 0.62118070e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 22,  1,  1, 0.31509820e+03, 0.19003000e+01, 0.18299000e+01},
    { 45, 22,  1,  2, 0.32585820e+03, 0.19003000e+01, 0.38675000e+01},
    { 45, 22,  2,  0, 0.51447440e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 22,  2,  1, 0.26729850e+03, 0.29696000e+01, 0.18299000e+01},
    { 45, 22,  2,  2, 0.27724060e+03, 0.29696000e+01, 0.38675000e+01},
    { 45, 23,  0,  0, 0.87880270e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 23,  0,  1, 0.45302620e+03, 0.00000000e+00, 0.19138000e+01},
    { 45, 23,  0,  2, 0.43421760e+03, 0.00000000e+00, 0.29110000e+01},
    { 45, 23,  1,  0, 0.56883480e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 23,  1,  1, 0.30884820e+03, 0.19003000e+01, 0.19138000e+01},
    { 45, 23,  1,  2, 0.29845770e+03, 0.19003000e+01, 0.29110000e+01},
    { 45, 23,  2,  0, 0.47224010e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 23,  2,  1, 0.26198070e+03, 0.29696000e+01, 0.19138000e+01},
    { 45, 23,  2,  2, 0.25398530e+03, 0.29696000e+01, 0.29110000e+01},
    { 45, 24,  0,  0, 0.69163140e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 24,  0,  1, 0.45019430e+03, 0.00000000e+00, 0.18269000e+01},
    { 45, 24,  0,  2, 0.32113840e+03, 0.00000000e+00, 0.10619100e+02},
    { 45, 24,  1,  0, 0.44875270e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 24,  1,  1, 0.30603400e+03, 0.19003000e+01, 0.18269000e+01},
    { 45, 24,  1,  2, 0.22538880e+03, 0.19003000e+01, 0.10619100e+02},
    { 45, 24,  2,  0, 0.37322320e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 24,  2,  1, 0.25931910e+03, 0.29696000e+01, 0.18269000e+01},
    { 45, 24,  2,  2, 0.19359700e+03, 0.29696000e+01, 0.10619100e+02},
    { 45, 25,  0,  0, 0.75032510e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 25,  0,  1, 0.40836770e+03, 0.00000000e+00, 0.16406000e+01},
    { 45, 25,  0,  2, 0.27161880e+03, 0.00000000e+00, 0.98849000e+01},
    { 45, 25,  1,  0, 0.48979330e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 25,  1,  1, 0.28151340e+03, 0.19003000e+01, 0.16406000e+01},
    { 45, 25,  1,  2, 0.19308940e+03, 0.19003000e+01, 0.98849000e+01},
    { 45, 25,  2,  0, 0.40804110e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 25,  2,  1, 0.23979050e+03, 0.29696000e+01, 0.16406000e+01},
    { 45, 25,  2,  2, 0.16675330e+03, 0.29696000e+01, 0.98849000e+01},
    { 45, 26,  0,  0, 0.58775440e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 26,  0,  1, 0.37640450e+03, 0.00000000e+00, 0.16483000e+01},
    { 45, 26,  0,  2, 0.26700480e+03, 0.00000000e+00, 0.91376000e+01},
    { 45, 26,  1,  0, 0.38501530e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 26,  1,  1, 0.26065670e+03, 0.19003000e+01, 0.16483000e+01},
    { 45, 26,  1,  2, 0.18952850e+03, 0.19003000e+01, 0.91376000e+01},
    { 45, 26,  2,  0, 0.32148500e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 26,  2,  1, 0.22246400e+03, 0.29696000e+01, 0.16483000e+01},
    { 45, 26,  2,  2, 0.16358130e+03, 0.29696000e+01, 0.91376000e+01},
    { 45, 27,  0,  0, 0.61543640e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 27,  0,  1, 0.35910570e+03, 0.00000000e+00, 0.17149000e+01},
    { 45, 27,  0,  2, 0.31887320e+03, 0.00000000e+00, 0.29263000e+01},
    { 45, 27,  0,  3, 0.28039530e+03, 0.00000000e+00, 0.77785000e+01},
    { 45, 27,  1,  0, 0.40745740e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 27,  1,  1, 0.24873880e+03, 0.19003000e+01, 0.17149000e+01},
    { 45, 27,  1,  2, 0.22176150e+03, 0.19003000e+01, 0.29263000e+01},
    { 45, 27,  1,  3, 0.19765180e+03, 0.19003000e+01, 0.77785000e+01},
    { 45, 27,  2,  0, 0.34137600e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 27,  2,  1, 0.21235000e+03, 0.29696000e+01, 0.17149000e+01},
    { 45, 27,  2,  2, 0.18973800e+03, 0.29696000e+01, 0.29263000e+01},
    { 45, 27,  2,  3, 0.17007730e+03, 0.29696000e+01, 0.77785000e+01},
    { 45, 28,  0,  0, 0.63776340e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 28,  0,  1, 0.35149860e+03, 0.00000000e+00, 0.17937000e+01},
    { 45, 28,  0,  2, 0.29544510e+03, 0.00000000e+00, 0.65458000e+01},
    { 45, 28,  0,  3, 0.31395770e+03, 0.00000000e+00, 0.62918000e+01},
    { 45, 28,  1,  0, 0.41967090e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 28,  1,  1, 0.24319090e+03, 0.19003000e+01, 0.17937000e+01},
    { 45, 28,  1,  2, 0.20667290e+03, 0.19003000e+01, 0.65458000e+01},
    { 45, 28,  1,  3, 0.21698060e+03, 0.19003000e+01, 0.62918000e+01},
    { 45, 28,  2,  0, 0.35071710e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 28,  2,  1, 0.20752820e+03, 0.29696000e+01, 0.17937000e+01},
    { 45, 28,  2,  2, 0.17725080e+03, 0.29696000e+01, 0.65458000e+01},
    { 45, 28,  2,  3, 0.18521540e+03, 0.29696000e+01, 0.62918000e+01},
    { 45, 29,  0,  0, 0.48875010e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 29,  0,  1, 0.35112220e+03, 0.00000000e+00, 0.95760000e+00},
    { 45, 29,  1,  0, 0.32239880e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 29,  1,  1, 0.24032600e+03, 0.19003000e+01, 0.95760000e+00},
    { 45, 29,  2,  0, 0.26998860e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 29,  2,  1, 0.20425110e+03, 0.29696000e+01, 0.95760000e+00},
    { 45, 30,  0,  0, 0.49263190e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 30,  0,  1, 0.32298310e+03, 0.00000000e+00, 0.19419000e+01},
    { 45, 30,  1,  0, 0.33047130e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 30,  1,  1, 0.22543980e+03, 0.19003000e+01, 0.19419000e+01},
    { 45, 30,  2,  0, 0.27836200e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 30,  2,  1, 0.19302210e+03, 0.29696000e+01, 0.19419000e+01},
    { 45, 31,  0,  0, 0.58677320e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 31,  0,  1, 0.54783460e+03, 0.00000000e+00, 0.96010000e+00},
    { 45, 31,  0,  2, 0.42520690e+03, 0.00000000e+00, 0.19315000e+01},
    { 45, 31,  0,  3, 0.34083280e+03, 0.00000000e+00, 0.29233000e+01},
    { 45, 31,  1,  0, 0.39105080e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 31,  1,  1, 0.36731970e+03, 0.19003000e+01, 0.96010000e+00},
    { 45, 31,  1,  2, 0.29122610e+03, 0.19003000e+01, 0.19315000e+01},
    { 45, 31,  1,  3, 0.23843110e+03, 0.19003000e+01, 0.29233000e+01},
    { 45, 31,  2,  0, 0.32839780e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 31,  2,  1, 0.30923520e+03, 0.29696000e+01, 0.96010000e+00},
    { 45, 31,  2,  2, 0.24732620e+03, 0.29696000e+01, 0.19315000e+01},
    { 45, 31,  2,  3, 0.20422770e+03, 0.29696000e+01, 0.29233000e+01},
    { 45, 32,  0,  0, 0.50544520e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 32,  0,  1, 0.47030780e+03, 0.00000000e+00, 0.94340000e+00},
    { 45, 32,  0,  2, 0.44608760e+03, 0.00000000e+00, 0.19447000e+01},
    { 45, 32,  0,  3, 0.39601830e+03, 0.00000000e+00, 0.29186000e+01},
    { 45, 32,  0,  4, 0.34550510e+03, 0.00000000e+00, 0.38972000e+01},
    { 45, 32,  1,  0, 0.34491000e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 32,  1,  1, 0.32278160e+03, 0.19003000e+01, 0.94340000e+00},
    { 45, 32,  1,  2, 0.30737400e+03, 0.19003000e+01, 0.19447000e+01},
    { 45, 32,  1,  3, 0.27557070e+03, 0.19003000e+01, 0.29186000e+01},
    { 45, 32,  1,  4, 0.24341820e+03, 0.19003000e+01, 0.38972000e+01},
    { 45, 32,  2,  0, 0.29239200e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 32,  2,  1, 0.27429900e+03, 0.29696000e+01, 0.94340000e+00},
    { 45, 32,  2,  2, 0.26164130e+03, 0.29696000e+01, 0.19447000e+01},
    { 45, 32,  2,  3, 0.23553230e+03, 0.29696000e+01, 0.29186000e+01},
    { 45, 32,  2,  4, 0.20911520e+03, 0.29696000e+01, 0.38972000e+01},
    { 45, 33,  0,  0, 0.42219710e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 33,  0,  1, 0.41454110e+03, 0.00000000e+00, 0.98890000e+00},
    { 45, 33,  0,  2, 0.40280170e+03, 0.00000000e+00, 0.19793000e+01},
    { 45, 33,  0,  3, 0.38672900e+03, 0.00000000e+00, 0.29709000e+01},
    { 45, 33,  1,  0, 0.29454210e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 33,  1,  1, 0.28959340e+03, 0.19003000e+01, 0.98890000e+00},
    { 45, 33,  1,  2, 0.28204640e+03, 0.19003000e+01, 0.19793000e+01},
    { 45, 33,  1,  3, 0.27173870e+03, 0.19003000e+01, 0.29709000e+01},
    { 45, 33,  2,  0, 0.25200000e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 33,  2,  1, 0.24791670e+03, 0.29696000e+01, 0.98890000e+00},
    { 45, 33,  2,  2, 0.24169560e+03, 0.29696000e+01, 0.19793000e+01},
    { 45, 33,  2,  3, 0.23320160e+03, 0.29696000e+01, 0.29709000e+01},
    { 45, 34,  0,  0, 0.37406320e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 34,  0,  1, 0.37429000e+03, 0.00000000e+00, 0.99010000e+00},
    { 45, 34,  0,  2, 0.37122770e+03, 0.00000000e+00, 0.19812000e+01},
    { 45, 34,  1,  0, 0.26467170e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 34,  1,  1, 0.26478150e+03, 0.19003000e+01, 0.99010000e+00},
    { 45, 34,  1,  2, 0.26272550e+03, 0.19003000e+01, 0.19812000e+01},
    { 45, 34,  2,  0, 0.22783110e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 34,  2,  1, 0.22791320e+03, 0.29696000e+01, 0.99010000e+00},
    { 45, 34,  2,  2, 0.22618930e+03, 0.29696000e+01, 0.19812000e+01},
    { 45, 35,  0,  0, 0.32319410e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 35,  0,  1, 0.32566500e+03, 0.00000000e+00, 0.99740000e+00},
    { 45, 35,  1,  0, 0.23205800e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 35,  1,  1, 0.23366080e+03, 0.19003000e+01, 0.99740000e+00},
    { 45, 35,  2,  0, 0.20104720e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 35,  2,  1, 0.20237580e+03, 0.29696000e+01, 0.99740000e+00},
    { 45, 36,  0,  0, 0.27786800e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 36,  1,  0, 0.20225670e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 36,  2,  0, 0.17630020e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 37,  0,  0, 0.17497615e+04, 0.00000000e+00, 0.00000000e+00},
    { 45, 37,  0,  1, 0.58237420e+03, 0.00000000e+00, 0.97380000e+00},
    { 45, 37,  1,  0, 0.10633477e+04, 0.19003000e+01, 0.00000000e+00},
    { 45, 37,  1,  1, 0.38991830e+03, 0.19003000e+01, 0.97380000e+00},
    { 45, 37,  2,  0, 0.86212220e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 37,  2,  1, 0.32868890e+03, 0.29696000e+01, 0.97380000e+00},
    { 45, 38,  0,  0, 0.14735487e+04, 0.00000000e+00, 0.00000000e+00},
    { 45, 38,  0,  1, 0.12034301e+04, 0.00000000e+00, 0.98010000e+00},
    { 45, 38,  0,  2, 0.59037440e+03, 0.00000000e+00, 0.19143000e+01},
    { 45, 38,  1,  0, 0.92882550e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 38,  1,  1, 0.76024370e+03, 0.19003000e+01, 0.98010000e+00},
    { 45, 38,  1,  2, 0.40150480e+03, 0.19003000e+01, 0.19143000e+01},
    { 45, 38,  2,  0, 0.76317560e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 38,  2,  1, 0.62589490e+03, 0.29696000e+01, 0.98010000e+00},
    { 45, 38,  2,  2, 0.34023920e+03, 0.29696000e+01, 0.19143000e+01},
    { 45, 39,  0,  0, 0.12668436e+04, 0.00000000e+00, 0.00000000e+00},
    { 45, 39,  0,  1, 0.88627500e+03, 0.00000000e+00, 0.19153000e+01},
    { 45, 39,  0,  2, 0.55934530e+03, 0.00000000e+00, 0.28903000e+01},
    { 45, 39,  1,  0, 0.81293380e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 39,  1,  1, 0.58041450e+03, 0.19003000e+01, 0.19153000e+01},
    { 45, 39,  1,  2, 0.38639150e+03, 0.19003000e+01, 0.28903000e+01},
    { 45, 39,  2,  0, 0.67268360e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 39,  2,  1, 0.48472570e+03, 0.29696000e+01, 0.19153000e+01},
    { 45, 39,  2,  2, 0.32940570e+03, 0.29696000e+01, 0.28903000e+01},
    { 45, 40,  0,  0, 0.11253403e+04, 0.00000000e+00, 0.00000000e+00},
    { 45, 40,  0,  1, 0.63480240e+03, 0.00000000e+00, 0.19355000e+01},
    { 45, 40,  0,  2, 0.56161690e+03, 0.00000000e+00, 0.39106000e+01},
    { 45, 40,  1,  0, 0.73049700e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 40,  1,  1, 0.43182880e+03, 0.19003000e+01, 0.19355000e+01},
    { 45, 40,  1,  2, 0.38976730e+03, 0.19003000e+01, 0.39106000e+01},
    { 45, 40,  2,  0, 0.60730800e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 40,  2,  1, 0.36605390e+03, 0.29696000e+01, 0.19355000e+01},
    { 45, 40,  2,  2, 0.33291030e+03, 0.29696000e+01, 0.39106000e+01},
    { 45, 41,  0,  0, 0.10182915e+04, 0.00000000e+00, 0.00000000e+00},
    { 45, 41,  0,  1, 0.64141640e+03, 0.00000000e+00, 0.19545000e+01},
    { 45, 41,  0,  2, 0.54408210e+03, 0.00000000e+00, 0.29225000e+01},
    { 45, 41,  1,  0, 0.66622590e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 41,  1,  1, 0.43614400e+03, 0.19003000e+01, 0.19545000e+01},
    { 45, 41,  1,  2, 0.37722490e+03, 0.19003000e+01, 0.29225000e+01},
    { 45, 41,  2,  0, 0.55572040e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 41,  2,  1, 0.36967440e+03, 0.29696000e+01, 0.19545000e+01},
    { 45, 41,  2,  2, 0.32221010e+03, 0.29696000e+01, 0.29225000e+01},
    { 45, 42,  0,  0, 0.77583530e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 42,  0,  1, 0.59515030e+03, 0.00000000e+00, 0.19420000e+01},
    { 45, 42,  0,  2, 0.47502730e+03, 0.00000000e+00, 0.11055600e+02},
    { 45, 42,  1,  0, 0.51491280e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 42,  1,  1, 0.40693380e+03, 0.19003000e+01, 0.19420000e+01},
    { 45, 42,  1,  2, 0.33393870e+03, 0.19003000e+01, 0.11055600e+02},
    { 45, 42,  2,  0, 0.43227820e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 42,  2,  1, 0.34576000e+03, 0.29696000e+01, 0.19420000e+01},
    { 45, 42,  2,  2, 0.28693400e+03, 0.29696000e+01, 0.11055600e+02},
    { 45, 43,  0,  0, 0.86989620e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 43,  0,  1, 0.68005240e+03, 0.00000000e+00, 0.16682000e+01},
    { 45, 43,  0,  2, 0.41514630e+03, 0.00000000e+00, 0.95402000e+01},
    { 45, 43,  1,  0, 0.57424560e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 43,  1,  1, 0.45656180e+03, 0.19003000e+01, 0.16682000e+01},
    { 45, 43,  1,  2, 0.29510120e+03, 0.19003000e+01, 0.95402000e+01},
    { 45, 43,  2,  0, 0.48090810e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 43,  2,  1, 0.38525950e+03, 0.29696000e+01, 0.16682000e+01},
    { 45, 43,  2,  2, 0.25477490e+03, 0.29696000e+01, 0.95402000e+01},
    { 45, 44,  0,  0, 0.65317750e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 44,  0,  1, 0.51183150e+03, 0.00000000e+00, 0.18584000e+01},
    { 45, 44,  0,  2, 0.39089370e+03, 0.00000000e+00, 0.88895000e+01},
    { 45, 44,  1,  0, 0.43804260e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 44,  1,  1, 0.35492820e+03, 0.19003000e+01, 0.18584000e+01},
    { 45, 44,  1,  2, 0.27903330e+03, 0.19003000e+01, 0.88895000e+01},
    { 45, 44,  2,  0, 0.36943280e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 44,  2,  1, 0.30329340e+03, 0.29696000e+01, 0.18584000e+01},
    { 45, 44,  2,  2, 0.24134970e+03, 0.29696000e+01, 0.88895000e+01},
    { 45, 45,  0,  0, 0.71394270e+03, 0.00000000e+00, 0.00000000e+00},
    { 45, 45,  1,  0, 0.47828480e+03, 0.19003000e+01, 0.00000000e+00},
    { 45, 45,  1,  1, 0.33224250e+03, 0.19003000e+01, 0.19003000e+01},
    { 45, 45,  2,  0, 0.40294980e+03, 0.29696000e+01, 0.00000000e+00},
    { 45, 45,  2,  1, 0.28418210e+03, 0.29696000e+01, 0.19003000e+01},
    { 45, 45,  2,  2, 0.24465860e+03, 0.29696000e+01, 0.29696000e+01},
    { 46,  1,  0,  0, 0.40237200e+02, 0.00000000e+00, 0.91180000e+00},
    { 46,  1,  0,  1, 0.66121100e+02, 0.00000000e+00, 0.00000000e+00},
    { 46,  1,  1,  0, 0.28966100e+02, 0.18630000e+01, 0.91180000e+00},
    { 46,  1,  1,  1, 0.46348900e+02, 0.18630000e+01, 0.00000000e+00},
    { 46,  1,  2,  0, 0.28063100e+02, 0.57095000e+01, 0.91180000e+00},
    { 46,  1,  2,  1, 0.44649800e+02, 0.57095000e+01, 0.00000000e+00},
    { 46,  2,  0,  0, 0.25871600e+02, 0.00000000e+00, 0.00000000e+00},
    { 46,  2,  1,  0, 0.19468900e+02, 0.18630000e+01, 0.00000000e+00},
    { 46,  2,  2,  0, 0.19020800e+02, 0.57095000e+01, 0.00000000e+00},
    { 46,  3,  0,  0, 0.72242940e+03, 0.00000000e+00, 0.00000000e+00},
    { 46,  3,  0,  1, 0.22580420e+03, 0.00000000e+00, 0.98650000e+00},
    { 46,  3,  1,  0, 0.44391060e+03, 0.18630000e+01, 0.00000000e+00},
    { 46,  3,  1,  1, 0.14912090e+03, 0.18630000e+01, 0.98650000e+00},
    { 46,  3,  2,  0, 0.41221710e+03, 0.57095000e+01, 0.00000000e+00},
    { 46,  3,  2,  1, 0.14156390e+03, 0.57095000e+01, 0.98650000e+00},
    { 46,  4,  0,  0, 0.39043100e+03, 0.00000000e+00, 0.00000000e+00},
    { 46,  4,  0,  1, 0.28603950e+03, 0.00000000e+00, 0.98080000e+00},
    { 46,  4,  0,  2, 0.18021780e+03, 0.00000000e+00, 0.19697000e+01},
    { 46,  4,  1,  0, 0.25623270e+03, 0.18630000e+01, 0.00000000e+00},
    { 46,  4,  1,  1, 0.19048260e+03, 0.18630000e+01, 0.98080000e+00},
    { 46,  4,  1,  2, 0.12471510e+03, 0.18630000e+01, 0.19697000e+01},
    { 46,  4,  2,  0, 0.24288250e+03, 0.57095000e+01, 0.00000000e+00},
    { 46,  4,  2,  1, 0.18118110e+03, 0.57095000e+01, 0.98080000e+00},
    { 46,  4,  2,  2, 0.11979600e+03, 0.57095000e+01, 0.19697000e+01},
    { 46,  5,  0,  0, 0.25334250e+03, 0.00000000e+00, 0.00000000e+00},
    { 46,  5,  0,  1, 0.21155590e+03, 0.00000000e+00, 0.97060000e+00},
    { 46,  5,  0,  2, 0.17633810e+03, 0.00000000e+00, 0.19441000e+01},
    { 46,  5,  0,  3, 0.13140190e+03, 0.00000000e+00, 0.29128000e+01},
    { 46,  5,  0,  4, 0.12329130e+03, 0.00000000e+00, 0.45856000e+01},
    { 46,  5,  1,  0, 0.17343600e+03, 0.18630000e+01, 0.00000000e+00},
    { 46,  5,  1,  1, 0.14620200e+03, 0.18630000e+01, 0.97060000e+00},
    { 46,  5,  1,  2, 0.12302270e+03, 0.18630000e+01, 0.19441000e+01},
    { 46,  5,  1,  3, 0.93899700e+02, 0.18630000e+01, 0.29128000e+01},
    { 46,  5,  1,  4, 0.88451500e+02, 0.18630000e+01, 0.45856000e+01},
    { 46,  5,  2,  0, 0.16615330e+03, 0.57095000e+01, 0.00000000e+00},
    { 46,  5,  2,  1, 0.14035990e+03, 0.57095000e+01, 0.97060000e+00},
    { 46,  5,  2,  2, 0.11834870e+03, 0.57095000e+01, 0.19441000e+01},
    { 46,  5,  2,  3, 0.90828400e+02, 0.57095000e+01, 0.29128000e+01},
    { 46,  5,  2,  4, 0.85628100e+02, 0.57095000e+01, 0.45856000e+01},
    { 46,  6,  0,  0, 0.16671110e+03, 0.00000000e+00, 0.00000000e+00},
    { 46,  6,  0,  1, 0.15650060e+03, 0.00000000e+00, 0.98680000e+00},
    { 46,  6,  0,  2, 0.12623620e+03, 0.00000000e+00, 0.19985000e+01},
    { 46,  6,  0,  3, 0.11814270e+03, 0.00000000e+00, 0.29987000e+01},
    { 46,  6,  0,  4, 0.95161200e+02, 0.00000000e+00, 0.39844000e+01},
    { 46,  6,  1,  0, 0.11801370e+03, 0.18630000e+01, 0.00000000e+00},
    { 46,  6,  1,  1, 0.11079460e+03, 0.18630000e+01, 0.98680000e+00},
    { 46,  6,  1,  2, 0.90624900e+02, 0.18630000e+01, 0.19985000e+01},
    { 46,  6,  1,  3, 0.84895400e+02, 0.18630000e+01, 0.29987000e+01},
    { 46,  6,  1,  4, 0.69773000e+02, 0.18630000e+01, 0.39844000e+01},
    { 46,  6,  2,  0, 0.11391260e+03, 0.57095000e+01, 0.00000000e+00},
    { 46,  6,  2,  1, 0.10693200e+03, 0.57095000e+01, 0.98680000e+00},
    { 46,  6,  2,  2, 0.87732000e+02, 0.57095000e+01, 0.19985000e+01},
    { 46,  6,  2,  3, 0.82193000e+02, 0.57095000e+01, 0.29987000e+01},
    { 46,  6,  2,  4, 0.67836300e+02, 0.57095000e+01, 0.39844000e+01},
    { 46,  7,  0,  0, 0.11447630e+03, 0.00000000e+00, 0.00000000e+00},
    { 46,  7,  0,  1, 0.10674380e+03, 0.00000000e+00, 0.99440000e+00},
    { 46,  7,  0,  2, 0.10003700e+03, 0.00000000e+00, 0.20143000e+01},
    { 46,  7,  0,  3, 0.87943000e+02, 0.00000000e+00, 0.29903000e+01},
    { 46,  7,  1,  0, 0.83171000e+02, 0.18630000e+01, 0.00000000e+00},
    { 46,  7,  1,  1, 0.77647900e+02, 0.18630000e+01, 0.99440000e+00},
    { 46,  7,  1,  2, 0.72996500e+02, 0.18630000e+01, 0.20143000e+01},
    { 46,  7,  1,  3, 0.64465100e+02, 0.18630000e+01, 0.29903000e+01},
    { 46,  7,  2,  0, 0.80711800e+02, 0.57095000e+01, 0.00000000e+00},
    { 46,  7,  2,  1, 0.75363600e+02, 0.57095000e+01, 0.99440000e+00},
    { 46,  7,  2,  2, 0.70890900e+02, 0.57095000e+01, 0.20143000e+01},
    { 46,  7,  2,  3, 0.62653200e+02, 0.57095000e+01, 0.29903000e+01},
    { 46,  8,  0,  0, 0.85642700e+02, 0.00000000e+00, 0.00000000e+00},
    { 46,  8,  0,  1, 0.76587100e+02, 0.00000000e+00, 0.99250000e+00},
    { 46,  8,  0,  2, 0.67335400e+02, 0.00000000e+00, 0.19887000e+01},
    { 46,  8,  1,  0, 0.63412500e+02, 0.18630000e+01, 0.00000000e+00},
    { 46,  8,  1,  1, 0.57004900e+02, 0.18630000e+01, 0.99250000e+00},
    { 46,  8,  1,  2, 0.50470900e+02, 0.18630000e+01, 0.19887000e+01},
    { 46,  8,  2,  0, 0.61761900e+02, 0.57095000e+01, 0.00000000e+00},
    { 46,  8,  2,  1, 0.55574400e+02, 0.57095000e+01, 0.99250000e+00},
    { 46,  8,  2,  2, 0.49262900e+02, 0.57095000e+01, 0.19887000e+01},
    { 46,  9,  0,  0, 0.64270700e+02, 0.00000000e+00, 0.00000000e+00},
    { 46,  9,  0,  1, 0.51774000e+02, 0.00000000e+00, 0.99820000e+00},
    { 46,  9,  1,  0, 0.48382400e+02, 0.18630000e+01, 0.00000000e+00},
    { 46,  9,  1,  1, 0.39663600e+02, 0.18630000e+01, 0.99820000e+00},
    { 46,  9,  2,  0, 0.47264500e+02, 0.57095000e+01, 0.00000000e+00},
    { 46,  9,  2,  1, 0.38869700e+02, 0.57095000e+01, 0.99820000e+00},
    { 46, 10,  0,  0, 0.49099000e+02, 0.00000000e+00, 0.00000000e+00},
    { 46, 10,  1,  0, 0.37464700e+02, 0.18630000e+01, 0.00000000e+00},
    { 46, 10,  2,  0, 0.36683700e+02, 0.57095000e+01, 0.00000000e+00},
    { 46, 11,  0,  0, 0.86062090e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 11,  0,  1, 0.33243920e+03, 0.00000000e+00, 0.96840000e+00},
    { 46, 11,  1,  0, 0.53116760e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 11,  1,  1, 0.21823330e+03, 0.18630000e+01, 0.96840000e+00},
    { 46, 11,  2,  0, 0.49392410e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 11,  2,  1, 0.20679400e+03, 0.57095000e+01, 0.96840000e+00},
    { 46, 12,  0,  0, 0.62959120e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 12,  0,  1, 0.51564570e+03, 0.00000000e+00, 0.96280000e+00},
    { 46, 12,  0,  2, 0.32495510e+03, 0.00000000e+00, 0.19496000e+01},
    { 46, 12,  1,  0, 0.40830220e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 12,  1,  1, 0.33722560e+03, 0.18630000e+01, 0.96280000e+00},
    { 46, 12,  1,  2, 0.22073750e+03, 0.18630000e+01, 0.19496000e+01},
    { 46, 12,  2,  0, 0.38571180e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 12,  2,  1, 0.31921760e+03, 0.57095000e+01, 0.96280000e+00},
    { 46, 12,  2,  2, 0.21108310e+03, 0.57095000e+01, 0.19496000e+01},
    { 46, 13,  0,  0, 0.56914100e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 13,  0,  1, 0.51341630e+03, 0.00000000e+00, 0.96480000e+00},
    { 46, 13,  0,  2, 0.39367760e+03, 0.00000000e+00, 0.19311000e+01},
    { 46, 13,  0,  3, 0.30049770e+03, 0.00000000e+00, 0.29146000e+01},
    { 46, 13,  1,  0, 0.37687760e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 13,  1,  1, 0.34179460e+03, 0.18630000e+01, 0.96480000e+00},
    { 46, 13,  1,  2, 0.26684840e+03, 0.18630000e+01, 0.19311000e+01},
    { 46, 13,  1,  3, 0.20834700e+03, 0.18630000e+01, 0.29146000e+01},
    { 46, 13,  2,  0, 0.35802870e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 13,  2,  1, 0.32513700e+03, 0.57095000e+01, 0.96480000e+00},
    { 46, 13,  2,  2, 0.25499480e+03, 0.57095000e+01, 0.19311000e+01},
    { 46, 13,  2,  3, 0.20021140e+03, 0.57095000e+01, 0.29146000e+01},
    { 46, 14,  0,  0, 0.43694630e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 14,  0,  1, 0.40236620e+03, 0.00000000e+00, 0.95070000e+00},
    { 46, 14,  0,  2, 0.37288980e+03, 0.00000000e+00, 0.19435000e+01},
    { 46, 14,  0,  3, 0.36442410e+03, 0.00000000e+00, 0.29407000e+01},
    { 46, 14,  0,  4, 0.29452200e+03, 0.00000000e+00, 0.38677000e+01},
    { 46, 14,  1,  0, 0.29781740e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 14,  1,  1, 0.27549250e+03, 0.18630000e+01, 0.95070000e+00},
    { 46, 14,  1,  2, 0.25641330e+03, 0.18630000e+01, 0.19435000e+01},
    { 46, 14,  1,  3, 0.24998080e+03, 0.18630000e+01, 0.29407000e+01},
    { 46, 14,  1,  4, 0.20606750e+03, 0.18630000e+01, 0.38677000e+01},
    { 46, 14,  2,  0, 0.28501380e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 14,  2,  1, 0.26392340e+03, 0.57095000e+01, 0.95070000e+00},
    { 46, 14,  2,  2, 0.24589890e+03, 0.57095000e+01, 0.19435000e+01},
    { 46, 14,  2,  3, 0.23956050e+03, 0.57095000e+01, 0.29407000e+01},
    { 46, 14,  2,  4, 0.19842220e+03, 0.57095000e+01, 0.38677000e+01},
    { 46, 15,  0,  0, 0.33352190e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 15,  0,  1, 0.32352760e+03, 0.00000000e+00, 0.99470000e+00},
    { 46, 15,  0,  2, 0.31960770e+03, 0.00000000e+00, 0.20102000e+01},
    { 46, 15,  0,  3, 0.29479860e+03, 0.00000000e+00, 0.29859000e+01},
    { 46, 15,  1,  0, 0.23321060e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 15,  1,  1, 0.22646050e+03, 0.18630000e+01, 0.99470000e+00},
    { 46, 15,  1,  2, 0.22341250e+03, 0.18630000e+01, 0.20102000e+01},
    { 46, 15,  1,  3, 0.20745050e+03, 0.18630000e+01, 0.29859000e+01},
    { 46, 15,  2,  0, 0.22452110e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 15,  2,  1, 0.21806750e+03, 0.57095000e+01, 0.99470000e+00},
    { 46, 15,  2,  2, 0.21505640e+03, 0.57095000e+01, 0.20102000e+01},
    { 46, 15,  2,  3, 0.19999790e+03, 0.57095000e+01, 0.29859000e+01},
    { 46, 16,  0,  0, 0.27315680e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 16,  0,  1, 0.27025240e+03, 0.00000000e+00, 0.99480000e+00},
    { 46, 16,  0,  2, 0.26473450e+03, 0.00000000e+00, 0.19903000e+01},
    { 46, 16,  1,  0, 0.19433730e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 16,  1,  1, 0.19221720e+03, 0.18630000e+01, 0.99480000e+00},
    { 46, 16,  1,  2, 0.18837520e+03, 0.18630000e+01, 0.19903000e+01},
    { 46, 16,  2,  0, 0.18780070e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 16,  2,  1, 0.18573680e+03, 0.57095000e+01, 0.99480000e+00},
    { 46, 16,  2,  2, 0.18203880e+03, 0.57095000e+01, 0.19903000e+01},
    { 46, 17,  0,  0, 0.22040990e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 17,  0,  1, 0.21819030e+03, 0.00000000e+00, 0.99720000e+00},
    { 46, 17,  1,  0, 0.15949140e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 17,  1,  1, 0.15785240e+03, 0.18630000e+01, 0.99720000e+00},
    { 46, 17,  2,  0, 0.15466930e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 17,  2,  1, 0.15307080e+03, 0.57095000e+01, 0.99720000e+00},
    { 46, 18,  0,  0, 0.17850210e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 18,  1,  0, 0.13113380e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 18,  2,  0, 0.12754830e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 19,  0,  0, 0.14240271e+04, 0.00000000e+00, 0.00000000e+00},
    { 46, 19,  0,  1, 0.45224640e+03, 0.00000000e+00, 0.97670000e+00},
    { 46, 19,  1,  0, 0.87329840e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 19,  1,  1, 0.30246350e+03, 0.18630000e+01, 0.97670000e+00},
    { 46, 19,  2,  0, 0.80942550e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 19,  2,  1, 0.28782600e+03, 0.57095000e+01, 0.97670000e+00},
    { 46, 20,  0,  0, 0.11296670e+04, 0.00000000e+00, 0.00000000e+00},
    { 46, 20,  0,  1, 0.90244050e+03, 0.00000000e+00, 0.98310000e+00},
    { 46, 20,  0,  2, 0.45620630e+03, 0.00000000e+00, 0.19349000e+01},
    { 46, 20,  1,  0, 0.71849830e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 20,  1,  1, 0.57613740e+03, 0.18630000e+01, 0.98310000e+00},
    { 46, 20,  1,  2, 0.31039090e+03, 0.18630000e+01, 0.19349000e+01},
    { 46, 20,  2,  0, 0.67457400e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 20,  2,  1, 0.54107730e+03, 0.57095000e+01, 0.98310000e+00},
    { 46, 20,  2,  2, 0.29681460e+03, 0.57095000e+01, 0.19349000e+01},
    { 46, 21,  0,  0, 0.92485560e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 21,  0,  1, 0.44308160e+03, 0.00000000e+00, 0.18627000e+01},
    { 46, 21,  0,  2, 0.43394840e+03, 0.00000000e+00, 0.28999000e+01},
    { 46, 21,  1,  0, 0.59349940e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 21,  1,  1, 0.30248980e+03, 0.18630000e+01, 0.18627000e+01},
    { 46, 21,  1,  2, 0.29856920e+03, 0.18630000e+01, 0.28999000e+01},
    { 46, 21,  2,  0, 0.55875930e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 21,  2,  1, 0.28949650e+03, 0.57095000e+01, 0.18627000e+01},
    { 46, 21,  2,  2, 0.28630250e+03, 0.57095000e+01, 0.28999000e+01},
    { 46, 22,  0,  0, 0.88576570e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 22,  0,  1, 0.42745770e+03, 0.00000000e+00, 0.18299000e+01},
    { 46, 22,  0,  2, 0.43897520e+03, 0.00000000e+00, 0.38675000e+01},
    { 46, 22,  1,  0, 0.57359720e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 22,  1,  1, 0.29221350e+03, 0.18630000e+01, 0.18299000e+01},
    { 46, 22,  1,  2, 0.30231120e+03, 0.18630000e+01, 0.38675000e+01},
    { 46, 22,  2,  0, 0.54137410e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 22,  2,  1, 0.27971050e+03, 0.57095000e+01, 0.18299000e+01},
    { 46, 22,  2,  2, 0.28995300e+03, 0.57095000e+01, 0.38675000e+01},
    { 46, 23,  0,  0, 0.80712580e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 23,  0,  1, 0.41911340e+03, 0.00000000e+00, 0.19138000e+01},
    { 46, 23,  0,  2, 0.40217500e+03, 0.00000000e+00, 0.29110000e+01},
    { 46, 23,  1,  0, 0.52547320e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 23,  1,  1, 0.28642780e+03, 0.18630000e+01, 0.19138000e+01},
    { 46, 23,  1,  2, 0.27694720e+03, 0.18630000e+01, 0.29110000e+01},
    { 46, 23,  2,  0, 0.49669050e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 23,  2,  1, 0.27414900e+03, 0.57095000e+01, 0.19138000e+01},
    { 46, 23,  2,  2, 0.26557670e+03, 0.57095000e+01, 0.29110000e+01},
    { 46, 24,  0,  0, 0.63532570e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 24,  0,  1, 0.41632300e+03, 0.00000000e+00, 0.18269000e+01},
    { 46, 24,  0,  2, 0.29830140e+03, 0.00000000e+00, 0.10619100e+02},
    { 46, 24,  1,  0, 0.41479180e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 24,  1,  1, 0.28377850e+03, 0.18630000e+01, 0.18269000e+01},
    { 46, 24,  1,  2, 0.20959760e+03, 0.18630000e+01, 0.10619100e+02},
    { 46, 24,  2,  0, 0.39222970e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 24,  2,  1, 0.27142500e+03, 0.57095000e+01, 0.18269000e+01},
    { 46, 24,  2,  2, 0.20190070e+03, 0.57095000e+01, 0.10619100e+02},
    { 46, 25,  0,  0, 0.68996470e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 25,  0,  1, 0.37842950e+03, 0.00000000e+00, 0.16406000e+01},
    { 46, 25,  0,  2, 0.25275950e+03, 0.00000000e+00, 0.98849000e+01},
    { 46, 25,  1,  0, 0.45273530e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 25,  1,  1, 0.26126350e+03, 0.18630000e+01, 0.16406000e+01},
    { 46, 25,  1,  2, 0.17978240e+03, 0.18630000e+01, 0.98849000e+01},
    { 46, 25,  2,  0, 0.42885090e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 25,  2,  1, 0.25071870e+03, 0.57095000e+01, 0.16406000e+01},
    { 46, 25,  2,  2, 0.17364950e+03, 0.57095000e+01, 0.98849000e+01},
    { 46, 26,  0,  0, 0.54065990e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 26,  0,  1, 0.34902580e+03, 0.00000000e+00, 0.16483000e+01},
    { 46, 26,  0,  2, 0.24842030e+03, 0.00000000e+00, 0.91376000e+01},
    { 46, 26,  1,  0, 0.35613440e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 26,  1,  1, 0.24201470e+03, 0.18630000e+01, 0.16483000e+01},
    { 46, 26,  1,  2, 0.17645130e+03, 0.18630000e+01, 0.91376000e+01},
    { 46, 26,  2,  0, 0.33757700e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 26,  2,  1, 0.23247500e+03, 0.57095000e+01, 0.16483000e+01},
    { 46, 26,  2,  2, 0.17037740e+03, 0.57095000e+01, 0.91376000e+01},
    { 46, 27,  0,  0, 0.56710440e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 27,  0,  1, 0.33298960e+03, 0.00000000e+00, 0.17149000e+01},
    { 46, 27,  0,  2, 0.29583660e+03, 0.00000000e+00, 0.29263000e+01},
    { 46, 27,  0,  3, 0.26063370e+03, 0.00000000e+00, 0.77785000e+01},
    { 46, 27,  1,  0, 0.37699280e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 27,  1,  1, 0.23097880e+03, 0.18630000e+01, 0.17149000e+01},
    { 46, 27,  1,  2, 0.20606490e+03, 0.18630000e+01, 0.29263000e+01},
    { 46, 27,  1,  3, 0.18389000e+03, 0.18630000e+01, 0.77785000e+01},
    { 46, 27,  2,  0, 0.35837430e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 27,  2,  1, 0.22187670e+03, 0.57095000e+01, 0.17149000e+01},
    { 46, 27,  2,  2, 0.19810080e+03, 0.57095000e+01, 0.29263000e+01},
    { 46, 27,  2,  3, 0.17730100e+03, 0.57095000e+01, 0.77785000e+01},
    { 46, 28,  0,  0, 0.58718190e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 28,  0,  1, 0.32588580e+03, 0.00000000e+00, 0.17937000e+01},
    { 46, 28,  0,  2, 0.27433660e+03, 0.00000000e+00, 0.65458000e+01},
    { 46, 28,  0,  3, 0.29103090e+03, 0.00000000e+00, 0.62918000e+01},
    { 46, 28,  1,  0, 0.38812000e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 28,  1,  1, 0.22581650e+03, 0.18630000e+01, 0.17937000e+01},
    { 46, 28,  1,  2, 0.19214160e+03, 0.18630000e+01, 0.65458000e+01},
    { 46, 28,  1,  3, 0.20155360e+03, 0.18630000e+01, 0.62918000e+01},
    { 46, 28,  2,  0, 0.36840320e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 28,  2,  1, 0.21686020e+03, 0.57095000e+01, 0.17937000e+01},
    { 46, 28,  2,  2, 0.18495540e+03, 0.57095000e+01, 0.65458000e+01},
    { 46, 28,  2,  3, 0.19349000e+03, 0.57095000e+01, 0.62918000e+01},
    { 46, 29,  0,  0, 0.45005590e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 29,  0,  1, 0.32504660e+03, 0.00000000e+00, 0.95760000e+00},
    { 46, 29,  1,  0, 0.29838940e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 29,  1,  1, 0.22301540e+03, 0.18630000e+01, 0.95760000e+00},
    { 46, 29,  2,  0, 0.28332920e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 29,  2,  1, 0.21363790e+03, 0.57095000e+01, 0.95760000e+00},
    { 46, 30,  0,  0, 0.45480310e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 30,  0,  1, 0.29983170e+03, 0.00000000e+00, 0.19419000e+01},
    { 46, 30,  1,  0, 0.30606330e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 30,  1,  1, 0.20945460e+03, 0.18630000e+01, 0.19419000e+01},
    { 46, 30,  2,  0, 0.29187250e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 30,  2,  1, 0.20155080e+03, 0.57095000e+01, 0.19419000e+01},
    { 46, 31,  0,  0, 0.54115010e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 31,  0,  1, 0.50566980e+03, 0.00000000e+00, 0.96010000e+00},
    { 46, 31,  0,  2, 0.39363700e+03, 0.00000000e+00, 0.19315000e+01},
    { 46, 31,  0,  3, 0.31647210e+03, 0.00000000e+00, 0.29233000e+01},
    { 46, 31,  1,  0, 0.36187800e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 31,  1,  1, 0.34006750e+03, 0.18630000e+01, 0.96010000e+00},
    { 46, 31,  1,  2, 0.27005910e+03, 0.18630000e+01, 0.19315000e+01},
    { 46, 31,  1,  3, 0.22146490e+03, 0.18630000e+01, 0.29233000e+01},
    { 46, 31,  2,  0, 0.34456860e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 31,  2,  1, 0.32427260e+03, 0.57095000e+01, 0.96010000e+00},
    { 46, 31,  2,  2, 0.25878790e+03, 0.57095000e+01, 0.19315000e+01},
    { 46, 31,  2,  3, 0.21323450e+03, 0.57095000e+01, 0.29233000e+01},
    { 46, 32,  0,  0, 0.46770420e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 32,  0,  1, 0.43552680e+03, 0.00000000e+00, 0.94340000e+00},
    { 46, 32,  0,  2, 0.41332440e+03, 0.00000000e+00, 0.19447000e+01},
    { 46, 32,  0,  3, 0.36742870e+03, 0.00000000e+00, 0.29186000e+01},
    { 46, 32,  0,  4, 0.32111170e+03, 0.00000000e+00, 0.38972000e+01},
    { 46, 32,  1,  0, 0.31969460e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 32,  1,  1, 0.29932800e+03, 0.18630000e+01, 0.94340000e+00},
    { 46, 32,  1,  2, 0.28513600e+03, 0.18630000e+01, 0.19447000e+01},
    { 46, 32,  1,  3, 0.25584410e+03, 0.18630000e+01, 0.29186000e+01},
    { 46, 32,  1,  4, 0.22622740e+03, 0.18630000e+01, 0.38972000e+01},
    { 46, 32,  2,  0, 0.30611920e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 32,  2,  1, 0.28698700e+03, 0.57095000e+01, 0.94340000e+00},
    { 46, 32,  2,  2, 0.27362340e+03, 0.57095000e+01, 0.19447000e+01},
    { 46, 32,  2,  3, 0.24604900e+03, 0.57095000e+01, 0.29186000e+01},
    { 46, 32,  2,  4, 0.21815300e+03, 0.57095000e+01, 0.38972000e+01},
    { 46, 33,  0,  0, 0.39185280e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 33,  0,  1, 0.38481520e+03, 0.00000000e+00, 0.98890000e+00},
    { 46, 33,  0,  2, 0.37403530e+03, 0.00000000e+00, 0.19793000e+01},
    { 46, 33,  0,  3, 0.35928420e+03, 0.00000000e+00, 0.29709000e+01},
    { 46, 33,  1,  0, 0.27350100e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 33,  1,  1, 0.26894270e+03, 0.18630000e+01, 0.98890000e+00},
    { 46, 33,  1,  2, 0.26198970e+03, 0.18630000e+01, 0.19793000e+01},
    { 46, 33,  1,  3, 0.25249180e+03, 0.18630000e+01, 0.29709000e+01},
    { 46, 33,  2,  0, 0.26318210e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 33,  2,  1, 0.25886990e+03, 0.57095000e+01, 0.98890000e+00},
    { 46, 33,  2,  2, 0.25230300e+03, 0.57095000e+01, 0.19793000e+01},
    { 46, 33,  2,  3, 0.24333990e+03, 0.57095000e+01, 0.29709000e+01},
    { 46, 34,  0,  0, 0.34783930e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 34,  0,  1, 0.34804020e+03, 0.00000000e+00, 0.99010000e+00},
    { 46, 34,  0,  2, 0.34521240e+03, 0.00000000e+00, 0.19812000e+01},
    { 46, 34,  1,  0, 0.24609210e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 34,  1,  1, 0.24619370e+03, 0.18630000e+01, 0.99010000e+00},
    { 46, 34,  1,  2, 0.24429540e+03, 0.18630000e+01, 0.19812000e+01},
    { 46, 34,  2,  0, 0.23751920e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 34,  2,  1, 0.23760650e+03, 0.57095000e+01, 0.99010000e+00},
    { 46, 34,  2,  2, 0.23579430e+03, 0.57095000e+01, 0.19812000e+01},
    { 46, 35,  0,  0, 0.30113900e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 35,  0,  1, 0.30341070e+03, 0.00000000e+00, 0.99740000e+00},
    { 46, 35,  1,  0, 0.21609450e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 35,  1,  1, 0.21757380e+03, 0.18630000e+01, 0.99740000e+00},
    { 46, 35,  2,  0, 0.20919710e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 35,  2,  1, 0.21059700e+03, 0.57095000e+01, 0.99740000e+00},
    { 46, 36,  0,  0, 0.25939640e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 36,  1,  0, 0.18863390e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 36,  2,  0, 0.18310950e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 37,  0,  0, 0.15904415e+04, 0.00000000e+00, 0.00000000e+00},
    { 46, 37,  0,  1, 0.53725650e+03, 0.00000000e+00, 0.97380000e+00},
    { 46, 37,  1,  0, 0.97940320e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 37,  1,  1, 0.36130470e+03, 0.18630000e+01, 0.97380000e+00},
    { 46, 37,  2,  0, 0.90881520e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 37,  2,  1, 0.34426700e+03, 0.57095000e+01, 0.97380000e+00},
    { 46, 38,  0,  0, 0.13479007e+04, 0.00000000e+00, 0.00000000e+00},
    { 46, 38,  0,  1, 0.11005370e+04, 0.00000000e+00, 0.98010000e+00},
    { 46, 38,  0,  2, 0.54597680e+03, 0.00000000e+00, 0.19143000e+01},
    { 46, 38,  1,  0, 0.85671690e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 38,  1,  1, 0.70165500e+03, 0.18630000e+01, 0.98010000e+00},
    { 46, 38,  1,  2, 0.37226120e+03, 0.18630000e+01, 0.19143000e+01},
    { 46, 38,  2,  0, 0.80400360e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 38,  2,  1, 0.65851960e+03, 0.57095000e+01, 0.98010000e+00},
    { 46, 38,  2,  2, 0.35611480e+03, 0.57095000e+01, 0.19143000e+01},
    { 46, 39,  0,  0, 0.11619289e+04, 0.00000000e+00, 0.00000000e+00},
    { 46, 39,  0,  1, 0.81484020e+03, 0.00000000e+00, 0.19153000e+01},
    { 46, 39,  0,  2, 0.51843740e+03, 0.00000000e+00, 0.28903000e+01},
    { 46, 39,  1,  0, 0.75059330e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 39,  1,  1, 0.53685660e+03, 0.18630000e+01, 0.19153000e+01},
    { 46, 39,  1,  2, 0.35861330e+03, 0.18630000e+01, 0.28903000e+01},
    { 46, 39,  2,  0, 0.70783430e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 39,  2,  1, 0.50868390e+03, 0.57095000e+01, 0.19153000e+01},
    { 46, 39,  2,  2, 0.34430530e+03, 0.57095000e+01, 0.28903000e+01},
    { 46, 40,  0,  0, 0.10338735e+04, 0.00000000e+00, 0.00000000e+00},
    { 46, 40,  0,  1, 0.58702020e+03, 0.00000000e+00, 0.19355000e+01},
    { 46, 40,  0,  2, 0.52087810e+03, 0.00000000e+00, 0.39106000e+01},
    { 46, 40,  1,  0, 0.67499290e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 40,  1,  1, 0.40042090e+03, 0.18630000e+01, 0.19355000e+01},
    { 46, 40,  1,  2, 0.36187710e+03, 0.18630000e+01, 0.39106000e+01},
    { 46, 40,  2,  0, 0.63844630e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 40,  2,  1, 0.38304250e+03, 0.57095000e+01, 0.19355000e+01},
    { 46, 40,  2,  2, 0.34779920e+03, 0.57095000e+01, 0.39106000e+01},
    { 46, 41,  0,  0, 0.93655280e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 41,  0,  1, 0.59314140e+03, 0.00000000e+00, 0.19545000e+01},
    { 46, 41,  0,  2, 0.50450370e+03, 0.00000000e+00, 0.29225000e+01},
    { 46, 41,  1,  0, 0.61597590e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 41,  1,  1, 0.40443000e+03, 0.18630000e+01, 0.19545000e+01},
    { 46, 41,  1,  2, 0.35029100e+03, 0.18630000e+01, 0.29225000e+01},
    { 46, 41,  2,  0, 0.58376530e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 41,  2,  1, 0.38685740e+03, 0.57095000e+01, 0.19545000e+01},
    { 46, 41,  2,  2, 0.33655350e+03, 0.57095000e+01, 0.29225000e+01},
    { 46, 42,  0,  0, 0.71494950e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 42,  0,  1, 0.55075570e+03, 0.00000000e+00, 0.19420000e+01},
    { 46, 42,  0,  2, 0.44133190e+03, 0.00000000e+00, 0.11055600e+02},
    { 46, 42,  1,  0, 0.47670900e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 42,  1,  1, 0.37755350e+03, 0.18630000e+01, 0.19420000e+01},
    { 46, 42,  1,  2, 0.31050050e+03, 0.18630000e+01, 0.11055600e+02},
    { 46, 42,  2,  0, 0.45332840e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 42,  2,  1, 0.36157810e+03, 0.57095000e+01, 0.19420000e+01},
    { 46, 42,  2,  2, 0.29922510e+03, 0.57095000e+01, 0.11055600e+02},
    { 46, 43,  0,  0, 0.80104420e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 43,  0,  1, 0.62758100e+03, 0.00000000e+00, 0.16682000e+01},
    { 46, 43,  0,  2, 0.38629860e+03, 0.00000000e+00, 0.95402000e+01},
    { 46, 43,  1,  0, 0.53137000e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 43,  1,  1, 0.42312790e+03, 0.18630000e+01, 0.16682000e+01},
    { 46, 43,  1,  2, 0.27469180e+03, 0.18630000e+01, 0.95402000e+01},
    { 46, 43,  2,  0, 0.50466070e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 43,  2,  1, 0.40341880e+03, 0.57095000e+01, 0.16682000e+01},
    { 46, 43,  2,  2, 0.26533520e+03, 0.57095000e+01, 0.95402000e+01},
    { 46, 44,  0,  0, 0.60279560e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 44,  0,  1, 0.47463690e+03, 0.00000000e+00, 0.18584000e+01},
    { 46, 44,  0,  2, 0.36395130e+03, 0.00000000e+00, 0.88895000e+01},
    { 46, 44,  1,  0, 0.40593980e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 44,  1,  1, 0.32968260e+03, 0.18630000e+01, 0.18584000e+01},
    { 46, 44,  1,  2, 0.25985840e+03, 0.18630000e+01, 0.88895000e+01},
    { 46, 44,  2,  0, 0.38697280e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 44,  2,  1, 0.31674990e+03, 0.57095000e+01, 0.18584000e+01},
    { 46, 44,  2,  2, 0.25122310e+03, 0.57095000e+01, 0.88895000e+01},
    { 46, 45,  0,  0, 0.65887530e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 45,  0,  1, 0.44362800e+03, 0.00000000e+00, 0.19003000e+01},
    { 46, 45,  0,  2, 0.37453940e+03, 0.00000000e+00, 0.29696000e+01},
    { 46, 45,  1,  0, 0.44306590e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 45,  1,  1, 0.30870590e+03, 0.18630000e+01, 0.19003000e+01},
    { 46, 45,  1,  2, 0.26443210e+03, 0.18630000e+01, 0.29696000e+01},
    { 46, 45,  2,  0, 0.42232030e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 45,  2,  1, 0.29669340e+03, 0.57095000e+01, 0.19003000e+01},
    { 46, 45,  2,  2, 0.25497130e+03, 0.57095000e+01, 0.29696000e+01},
    { 46, 46,  0,  0, 0.60850410e+03, 0.00000000e+00, 0.00000000e+00},
    { 46, 46,  1,  0, 0.41113610e+03, 0.18630000e+01, 0.00000000e+00},
    { 46, 46,  1,  1, 0.28695190e+03, 0.18630000e+01, 0.18630000e+01},
    { 46, 46,  2,  0, 0.39235480e+03, 0.57095000e+01, 0.00000000e+00},
    { 46, 46,  2,  1, 0.27595750e+03, 0.57095000e+01, 0.18630000e+01},
    { 46, 46,  2,  2, 0.26587460e+03, 0.57095000e+01, 0.57095000e+01},
    { 47,  1,  0,  0, 0.33541300e+02, 0.00000000e+00, 0.91180000e+00},
    { 47,  1,  0,  1, 0.54965800e+02, 0.00000000e+00, 0.00000000e+00},
    { 47,  1,  1,  0, 0.27951800e+02, 0.96790000e+00, 0.91180000e+00},
    { 47,  1,  1,  1, 0.44783500e+02, 0.96790000e+00, 0.00000000e+00},
    { 47,  2,  0,  0, 0.21789600e+02, 0.00000000e+00, 0.00000000e+00},
    { 47,  2,  1,  0, 0.18773100e+02, 0.96790000e+00, 0.00000000e+00},
    { 47,  3,  0,  0, 0.61414770e+03, 0.00000000e+00, 0.00000000e+00},
    { 47,  3,  0,  1, 0.18833740e+03, 0.00000000e+00, 0.98650000e+00},
    { 47,  3,  1,  0, 0.43260780e+03, 0.96790000e+00, 0.00000000e+00},
    { 47,  3,  1,  1, 0.14465630e+03, 0.96790000e+00, 0.98650000e+00},
    { 47,  4,  0,  0, 0.32557750e+03, 0.00000000e+00, 0.00000000e+00},
    { 47,  4,  0,  1, 0.23869620e+03, 0.00000000e+00, 0.98080000e+00},
    { 47,  4,  0,  2, 0.14971980e+03, 0.00000000e+00, 0.19697000e+01},
    { 47,  4,  1,  0, 0.24865730e+03, 0.96790000e+00, 0.00000000e+00},
    { 47,  4,  1,  1, 0.18465300e+03, 0.96790000e+00, 0.98080000e+00},
    { 47,  4,  1,  2, 0.12059750e+03, 0.96790000e+00, 0.19697000e+01},
    { 47,  5,  0,  0, 0.21068110e+03, 0.00000000e+00, 0.00000000e+00},
    { 47,  5,  0,  1, 0.17606030e+03, 0.00000000e+00, 0.97060000e+00},
    { 47,  5,  0,  2, 0.14690170e+03, 0.00000000e+00, 0.19441000e+01},
    { 47,  5,  0,  3, 0.10947410e+03, 0.00000000e+00, 0.29128000e+01},
    { 47,  5,  0,  4, 0.10277530e+03, 0.00000000e+00, 0.45856000e+01},
    { 47,  5,  1,  0, 0.16783500e+03, 0.96790000e+00, 0.00000000e+00},
    { 47,  5,  1,  1, 0.14140600e+03, 0.96790000e+00, 0.97060000e+00},
    { 47,  5,  1,  2, 0.11892360e+03, 0.96790000e+00, 0.19441000e+01},
    { 47,  5,  1,  3, 0.90650800e+02, 0.96790000e+00, 0.29128000e+01},
    { 47,  5,  1,  4, 0.85377300e+02, 0.96790000e+00, 0.45856000e+01},
    { 47,  6,  0,  0, 0.13887580e+03, 0.00000000e+00, 0.00000000e+00},
    { 47,  6,  0,  1, 0.13051440e+03, 0.00000000e+00, 0.98680000e+00},
    { 47,  6,  0,  2, 0.10535720e+03, 0.00000000e+00, 0.19985000e+01},
    { 47,  6,  0,  3, 0.98703200e+02, 0.00000000e+00, 0.29987000e+01},
    { 47,  6,  0,  4, 0.79665700e+02, 0.00000000e+00, 0.39844000e+01},
    { 47,  6,  1,  0, 0.11399930e+03, 0.96790000e+00, 0.00000000e+00},
    { 47,  6,  1,  1, 0.10702860e+03, 0.96790000e+00, 0.98680000e+00},
    { 47,  6,  1,  2, 0.87495100e+02, 0.96790000e+00, 0.19985000e+01},
    { 47,  6,  1,  3, 0.81971500e+02, 0.96790000e+00, 0.29987000e+01},
    { 47,  6,  1,  4, 0.67307000e+02, 0.96790000e+00, 0.39844000e+01},
    { 47,  7,  0,  0, 0.95713700e+02, 0.00000000e+00, 0.00000000e+00},
    { 47,  7,  0,  1, 0.89341900e+02, 0.00000000e+00, 0.99440000e+00},
    { 47,  7,  0,  2, 0.83787500e+02, 0.00000000e+00, 0.20143000e+01},
    { 47,  7,  0,  3, 0.73805700e+02, 0.00000000e+00, 0.29903000e+01},
    { 47,  7,  1,  0, 0.80266300e+02, 0.96790000e+00, 0.00000000e+00},
    { 47,  7,  1,  1, 0.74935400e+02, 0.96790000e+00, 0.99440000e+00},
    { 47,  7,  1,  2, 0.70450900e+02, 0.96790000e+00, 0.20143000e+01},
    { 47,  7,  1,  3, 0.62220900e+02, 0.96790000e+00, 0.29903000e+01},
    { 47,  8,  0,  0, 0.71892600e+02, 0.00000000e+00, 0.00000000e+00},
    { 47,  8,  0,  1, 0.64388000e+02, 0.00000000e+00, 0.99250000e+00},
    { 47,  8,  0,  2, 0.56751100e+02, 0.00000000e+00, 0.19887000e+01},
    { 47,  8,  1,  0, 0.61174800e+02, 0.96790000e+00, 0.00000000e+00},
    { 47,  8,  1,  1, 0.54985600e+02, 0.96790000e+00, 0.99250000e+00},
    { 47,  8,  1,  2, 0.48691200e+02, 0.96790000e+00, 0.19887000e+01},
    { 47,  9,  0,  0, 0.54190300e+02, 0.00000000e+00, 0.00000000e+00},
    { 47,  9,  0,  1, 0.43848000e+02, 0.00000000e+00, 0.99820000e+00},
    { 47,  9,  1,  0, 0.46672600e+02, 0.96790000e+00, 0.00000000e+00},
    { 47,  9,  1,  1, 0.38253900e+02, 0.96790000e+00, 0.99820000e+00},
    { 47, 10,  0,  0, 0.41578000e+02, 0.00000000e+00, 0.00000000e+00},
    { 47, 10,  1,  0, 0.36148600e+02, 0.96790000e+00, 0.00000000e+00},
    { 47, 11,  0,  0, 0.73108320e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 11,  0,  1, 0.27794280e+03, 0.00000000e+00, 0.96840000e+00},
    { 47, 11,  1,  0, 0.51756800e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 11,  1,  1, 0.21184190e+03, 0.96790000e+00, 0.96840000e+00},
    { 47, 12,  0,  0, 0.52647760e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 12,  0,  1, 0.43128070e+03, 0.00000000e+00, 0.96280000e+00},
    { 47, 12,  0,  2, 0.27016330e+03, 0.00000000e+00, 0.19496000e+01},
    { 47, 12,  1,  0, 0.39661250e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 12,  1,  1, 0.32735090e+03, 0.96790000e+00, 0.96280000e+00},
    { 47, 12,  1,  2, 0.21374770e+03, 0.96790000e+00, 0.19496000e+01},
    { 47, 13,  0,  0, 0.47457130e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 13,  0,  1, 0.42799620e+03, 0.00000000e+00, 0.96480000e+00},
    { 47, 13,  0,  2, 0.32774720e+03, 0.00000000e+00, 0.19311000e+01},
    { 47, 13,  0,  3, 0.24967590e+03, 0.00000000e+00, 0.29146000e+01},
    { 47, 13,  1,  0, 0.36552690e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 13,  1,  1, 0.33138320e+03, 0.96790000e+00, 0.96480000e+00},
    { 47, 13,  1,  2, 0.25840650e+03, 0.96790000e+00, 0.19311000e+01},
    { 47, 13,  1,  3, 0.20146610e+03, 0.96790000e+00, 0.29146000e+01},
    { 47, 14,  0,  0, 0.36335850e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 14,  0,  1, 0.33466730e+03, 0.00000000e+00, 0.95070000e+00},
    { 47, 14,  0,  2, 0.31011860e+03, 0.00000000e+00, 0.19435000e+01},
    { 47, 14,  0,  3, 0.30337520e+03, 0.00000000e+00, 0.29407000e+01},
    { 47, 14,  0,  4, 0.24486850e+03, 0.00000000e+00, 0.38677000e+01},
    { 47, 14,  1,  0, 0.28828630e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 14,  1,  1, 0.26660080e+03, 0.96790000e+00, 0.95070000e+00},
    { 47, 14,  1,  2, 0.24807500e+03, 0.96790000e+00, 0.19435000e+01},
    { 47, 14,  1,  3, 0.24189890e+03, 0.96790000e+00, 0.29407000e+01},
    { 47, 14,  1,  4, 0.19915530e+03, 0.96790000e+00, 0.38677000e+01},
    { 47, 15,  0,  0, 0.27735770e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 15,  0,  1, 0.26912200e+03, 0.00000000e+00, 0.99470000e+00},
    { 47, 15,  0,  2, 0.26595030e+03, 0.00000000e+00, 0.20102000e+01},
    { 47, 15,  0,  3, 0.24529960e+03, 0.00000000e+00, 0.29859000e+01},
    { 47, 15,  1,  0, 0.22539450e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 15,  1,  1, 0.21886170e+03, 0.96790000e+00, 0.99470000e+00},
    { 47, 15,  1,  2, 0.21594190e+03, 0.96790000e+00, 0.20102000e+01},
    { 47, 15,  1,  3, 0.20043480e+03, 0.96790000e+00, 0.29859000e+01},
    { 47, 16,  0,  0, 0.22750240e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 16,  0,  1, 0.22511810e+03, 0.00000000e+00, 0.99480000e+00},
    { 47, 16,  0,  2, 0.22055850e+03, 0.00000000e+00, 0.19903000e+01},
    { 47, 16,  1,  0, 0.18765970e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 16,  1,  1, 0.18561970e+03, 0.96790000e+00, 0.99480000e+00},
    { 47, 16,  1,  2, 0.18191000e+03, 0.96790000e+00, 0.19903000e+01},
    { 47, 17,  0,  0, 0.18398760e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 17,  0,  1, 0.18215470e+03, 0.00000000e+00, 0.99720000e+00},
    { 47, 17,  1,  0, 0.15390320e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 17,  1,  1, 0.15232700e+03, 0.96790000e+00, 0.99720000e+00},
    { 47, 18,  0,  0, 0.14942690e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 18,  1,  0, 0.12648250e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 19,  0,  0, 0.12184699e+04, 0.00000000e+00, 0.00000000e+00},
    { 47, 19,  0,  1, 0.37908360e+03, 0.00000000e+00, 0.97670000e+00},
    { 47, 19,  1,  0, 0.85100880e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 19,  1,  1, 0.29329110e+03, 0.96790000e+00, 0.97670000e+00},
    { 47, 20,  0,  0, 0.95149350e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 20,  0,  1, 0.76261740e+03, 0.00000000e+00, 0.98310000e+00},
    { 47, 20,  0,  2, 0.38042830e+03, 0.00000000e+00, 0.19349000e+01},
    { 47, 20,  1,  0, 0.69886180e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 20,  1,  1, 0.56012980e+03, 0.96790000e+00, 0.98310000e+00},
    { 47, 20,  1,  2, 0.30060940e+03, 0.96790000e+00, 0.19349000e+01},
    { 47, 21,  0,  0, 0.77689140e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 21,  0,  1, 0.36949330e+03, 0.00000000e+00, 0.18627000e+01},
    { 47, 21,  0,  2, 0.36150570e+03, 0.00000000e+00, 0.28999000e+01},
    { 47, 21,  1,  0, 0.57696360e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 21,  1,  1, 0.29290630e+03, 0.96790000e+00, 0.18627000e+01},
    { 47, 21,  1,  2, 0.28894080e+03, 0.96790000e+00, 0.28999000e+01},
    { 47, 22,  0,  0, 0.74320410e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 22,  0,  1, 0.35672450e+03, 0.00000000e+00, 0.18299000e+01},
    { 47, 22,  0,  2, 0.36571240e+03, 0.00000000e+00, 0.38675000e+01},
    { 47, 22,  1,  0, 0.55728800e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 22,  1,  1, 0.28293320e+03, 0.96790000e+00, 0.18299000e+01},
    { 47, 22,  1,  2, 0.29255140e+03, 0.96790000e+00, 0.38675000e+01},
    { 47, 23,  0,  0, 0.67665530e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 23,  0,  1, 0.34982880e+03, 0.00000000e+00, 0.19138000e+01},
    { 47, 23,  0,  2, 0.33544360e+03, 0.00000000e+00, 0.29110000e+01},
    { 47, 23,  1,  0, 0.51036440e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 23,  1,  1, 0.27735250e+03, 0.96790000e+00, 0.19138000e+01},
    { 47, 23,  1,  2, 0.26803530e+03, 0.96790000e+00, 0.29110000e+01},
    { 47, 24,  0,  0, 0.53368780e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 24,  0,  1, 0.34767860e+03, 0.00000000e+00, 0.18269000e+01},
    { 47, 24,  0,  2, 0.24916130e+03, 0.00000000e+00, 0.10619100e+02},
    { 47, 24,  1,  0, 0.40283830e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 24,  1,  1, 0.27484520e+03, 0.96790000e+00, 0.18269000e+01},
    { 47, 24,  1,  2, 0.20266840e+03, 0.96790000e+00, 0.10619100e+02},
    { 47, 25,  0,  0, 0.57781270e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 25,  0,  1, 0.31534820e+03, 0.00000000e+00, 0.16406000e+01},
    { 47, 25,  0,  2, 0.21123900e+03, 0.00000000e+00, 0.98849000e+01},
    { 47, 25,  1,  0, 0.43950990e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 25,  1,  1, 0.25282980e+03, 0.96790000e+00, 0.16406000e+01},
    { 47, 25,  1,  2, 0.17373810e+03, 0.96790000e+00, 0.98849000e+01},
    { 47, 26,  0,  0, 0.45363270e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 26,  0,  1, 0.29090830e+03, 0.00000000e+00, 0.16483000e+01},
    { 47, 26,  0,  2, 0.20761810e+03, 0.00000000e+00, 0.91376000e+01},
    { 47, 26,  1,  0, 0.34569950e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 26,  1,  1, 0.23415110e+03, 0.96790000e+00, 0.16483000e+01},
    { 47, 26,  1,  2, 0.17054030e+03, 0.96790000e+00, 0.91376000e+01},
    { 47, 27,  0,  0, 0.47392440e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 27,  0,  1, 0.27768230e+03, 0.00000000e+00, 0.17149000e+01},
    { 47, 27,  0,  2, 0.24704870e+03, 0.00000000e+00, 0.29263000e+01},
    { 47, 27,  0,  3, 0.21771120e+03, 0.00000000e+00, 0.77785000e+01},
    { 47, 27,  1,  0, 0.36569250e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 27,  1,  1, 0.22348050e+03, 0.96790000e+00, 0.17149000e+01},
    { 47, 27,  1,  2, 0.19936290e+03, 0.96790000e+00, 0.29263000e+01},
    { 47, 27,  1,  3, 0.17779340e+03, 0.96790000e+00, 0.77785000e+01},
    { 47, 28,  0,  0, 0.49097830e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 28,  0,  1, 0.27180880e+03, 0.00000000e+00, 0.17937000e+01},
    { 47, 28,  0,  2, 0.22905370e+03, 0.00000000e+00, 0.65458000e+01},
    { 47, 28,  0,  3, 0.24320090e+03, 0.00000000e+00, 0.62918000e+01},
    { 47, 28,  1,  0, 0.37662810e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 28,  1,  1, 0.21850750e+03, 0.96790000e+00, 0.17937000e+01},
    { 47, 28,  1,  2, 0.18584300e+03, 0.96790000e+00, 0.65458000e+01},
    { 47, 28,  1,  3, 0.19509170e+03, 0.96790000e+00, 0.62918000e+01},
    { 47, 29,  0,  0, 0.37735310e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 29,  0,  1, 0.27146340e+03, 0.00000000e+00, 0.95760000e+00},
    { 47, 29,  1,  0, 0.28955800e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 29,  1,  1, 0.21595810e+03, 0.96790000e+00, 0.95760000e+00},
    { 47, 30,  0,  0, 0.37956550e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 30,  0,  1, 0.24983480e+03, 0.00000000e+00, 0.19419000e+01},
    { 47, 30,  1,  0, 0.29667280e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 30,  1,  1, 0.20256850e+03, 0.96790000e+00, 0.19419000e+01},
    { 47, 31,  0,  0, 0.45158870e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 31,  0,  1, 0.42174200e+03, 0.00000000e+00, 0.96010000e+00},
    { 47, 31,  0,  2, 0.32788520e+03, 0.00000000e+00, 0.19315000e+01},
    { 47, 31,  0,  3, 0.26332580e+03, 0.00000000e+00, 0.29233000e+01},
    { 47, 31,  1,  0, 0.35080100e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 31,  1,  1, 0.32953870e+03, 0.96790000e+00, 0.96010000e+00},
    { 47, 31,  1,  2, 0.26136540e+03, 0.96790000e+00, 0.19315000e+01},
    { 47, 31,  1,  3, 0.21407940e+03, 0.96790000e+00, 0.29233000e+01},
    { 47, 32,  0,  0, 0.38930750e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 32,  0,  1, 0.36250760e+03, 0.00000000e+00, 0.94340000e+00},
    { 47, 32,  0,  2, 0.34400650e+03, 0.00000000e+00, 0.19447000e+01},
    { 47, 32,  0,  3, 0.30577550e+03, 0.00000000e+00, 0.29186000e+01},
    { 47, 32,  0,  4, 0.26721350e+03, 0.00000000e+00, 0.38972000e+01},
    { 47, 32,  1,  0, 0.30945430e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 32,  1,  1, 0.28964110e+03, 0.96790000e+00, 0.94340000e+00},
    { 47, 32,  1,  2, 0.27584840e+03, 0.96790000e+00, 0.19447000e+01},
    { 47, 32,  1,  3, 0.24737280e+03, 0.96790000e+00, 0.29186000e+01},
    { 47, 32,  1,  4, 0.21858540e+03, 0.96790000e+00, 0.38972000e+01},
    { 47, 33,  0,  0, 0.32603710e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 33,  0,  1, 0.32022310e+03, 0.00000000e+00, 0.98890000e+00},
    { 47, 33,  0,  2, 0.31127990e+03, 0.00000000e+00, 0.19793000e+01},
    { 47, 33,  0,  3, 0.29901370e+03, 0.00000000e+00, 0.29709000e+01},
    { 47, 33,  1,  0, 0.26439570e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 33,  1,  1, 0.25997060e+03, 0.96790000e+00, 0.98890000e+00},
    { 47, 33,  1,  2, 0.25321800e+03, 0.96790000e+00, 0.19793000e+01},
    { 47, 33,  1,  3, 0.24399260e+03, 0.96790000e+00, 0.29709000e+01},
    { 47, 34,  0,  0, 0.28964690e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 34,  0,  1, 0.28983280e+03, 0.00000000e+00, 0.99010000e+00},
    { 47, 34,  0,  2, 0.28750250e+03, 0.00000000e+00, 0.19812000e+01},
    { 47, 34,  1,  0, 0.23772170e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 34,  1,  1, 0.23782380e+03, 0.96790000e+00, 0.99010000e+00},
    { 47, 34,  1,  2, 0.23598710e+03, 0.96790000e+00, 0.19812000e+01},
    { 47, 35,  0,  0, 0.25111890e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 35,  0,  1, 0.25300950e+03, 0.00000000e+00, 0.99740000e+00},
    { 47, 35,  1,  0, 0.20860440e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 35,  1,  1, 0.21004110e+03, 0.96790000e+00, 0.99740000e+00},
    { 47, 36,  0,  0, 0.21673360e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 36,  1,  0, 0.18200160e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 37,  0,  0, 0.13607517e+04, 0.00000000e+00, 0.00000000e+00},
    { 47, 37,  0,  1, 0.45047140e+03, 0.00000000e+00, 0.97380000e+00},
    { 47, 37,  1,  0, 0.95413200e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 37,  1,  1, 0.35022950e+03, 0.96790000e+00, 0.97380000e+00},
    { 47, 38,  0,  0, 0.11369099e+04, 0.00000000e+00, 0.00000000e+00},
    { 47, 38,  0,  1, 0.93160220e+03, 0.00000000e+00, 0.98010000e+00},
    { 47, 38,  0,  2, 0.45572670e+03, 0.00000000e+00, 0.19143000e+01},
    { 47, 38,  1,  0, 0.83331680e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 38,  1,  1, 0.68218170e+03, 0.96790000e+00, 0.98010000e+00},
    { 47, 38,  1,  2, 0.36048910e+03, 0.96790000e+00, 0.19143000e+01},
    { 47, 39,  0,  0, 0.97620250e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 39,  0,  1, 0.68497960e+03, 0.00000000e+00, 0.19153000e+01},
    { 47, 39,  0,  2, 0.43197050e+03, 0.00000000e+00, 0.28903000e+01},
    { 47, 39,  1,  0, 0.72933160e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 39,  1,  1, 0.52087240e+03, 0.96790000e+00, 0.19153000e+01},
    { 47, 39,  1,  2, 0.34693600e+03, 0.96790000e+00, 0.28903000e+01},
    { 47, 40,  0,  0, 0.86700560e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 40,  0,  1, 0.49038170e+03, 0.00000000e+00, 0.19355000e+01},
    { 47, 40,  0,  2, 0.43392780e+03, 0.00000000e+00, 0.39106000e+01},
    { 47, 40,  1,  0, 0.65543290e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 40,  1,  1, 0.38773360e+03, 0.96790000e+00, 0.19355000e+01},
    { 47, 40,  1,  2, 0.34999750e+03, 0.96790000e+00, 0.39106000e+01},
    { 47, 41,  0,  0, 0.78481880e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 41,  0,  1, 0.49548000e+03, 0.00000000e+00, 0.19545000e+01},
    { 47, 41,  0,  2, 0.42085520e+03, 0.00000000e+00, 0.29225000e+01},
    { 47, 41,  1,  0, 0.59785280e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 41,  1,  1, 0.39166370e+03, 0.96790000e+00, 0.19545000e+01},
    { 47, 41,  1,  2, 0.33883350e+03, 0.96790000e+00, 0.29225000e+01},
    { 47, 42,  0,  0, 0.59905300e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 42,  0,  1, 0.46023670e+03, 0.00000000e+00, 0.19420000e+01},
    { 47, 42,  0,  2, 0.36828980e+03, 0.00000000e+00, 0.11055600e+02},
    { 47, 42,  1,  0, 0.46233830e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 42,  1,  1, 0.36552610e+03, 0.96790000e+00, 0.19420000e+01},
    { 47, 42,  1,  2, 0.30014930e+03, 0.96790000e+00, 0.11055600e+02},
    { 47, 43,  0,  0, 0.67117170e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 43,  0,  1, 0.52609770e+03, 0.00000000e+00, 0.16682000e+01},
    { 47, 43,  0,  2, 0.32258210e+03, 0.00000000e+00, 0.95402000e+01},
    { 47, 43,  1,  0, 0.51549530e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 43,  1,  1, 0.41006670e+03, 0.96790000e+00, 0.16682000e+01},
    { 47, 43,  1,  2, 0.26540330e+03, 0.96790000e+00, 0.95402000e+01},
    { 47, 44,  0,  0, 0.50502690e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 44,  0,  1, 0.39627420e+03, 0.00000000e+00, 0.18584000e+01},
    { 47, 44,  0,  2, 0.30405500e+03, 0.00000000e+00, 0.88895000e+01},
    { 47, 44,  1,  0, 0.39350880e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 44,  1,  1, 0.31896650e+03, 0.96790000e+00, 0.18584000e+01},
    { 47, 44,  1,  2, 0.25103670e+03, 0.96790000e+00, 0.88895000e+01},
    { 47, 45,  0,  0, 0.55108020e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 45,  0,  1, 0.37063780e+03, 0.00000000e+00, 0.19003000e+01},
    { 47, 45,  0,  2, 0.31311430e+03, 0.00000000e+00, 0.29696000e+01},
    { 47, 45,  1,  0, 0.42951430e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 45,  1,  1, 0.29866780e+03, 0.96790000e+00, 0.19003000e+01},
    { 47, 45,  1,  2, 0.25564790e+03, 0.96790000e+00, 0.29696000e+01},
    { 47, 46,  0,  0, 0.50877420e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 46,  0,  1, 0.34367070e+03, 0.00000000e+00, 0.18630000e+01},
    { 47, 46,  0,  2, 0.32780150e+03, 0.00000000e+00, 0.57095000e+01},
    { 47, 46,  1,  0, 0.39846620e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 46,  1,  1, 0.27760230e+03, 0.96790000e+00, 0.18630000e+01},
    { 47, 46,  1,  2, 0.26684590e+03, 0.96790000e+00, 0.57095000e+01},
    { 47, 47,  0,  0, 0.42674500e+03, 0.00000000e+00, 0.00000000e+00},
    { 47, 47,  1,  0, 0.33315830e+03, 0.96790000e+00, 0.00000000e+00},
    { 47, 47,  1,  1, 0.26861300e+03, 0.96790000e+00, 0.96790000e+00},
    { 48,  1,  0,  0, 0.35687900e+02, 0.00000000e+00, 0.91180000e+00},
    { 48,  1,  0,  1, 0.58356800e+02, 0.00000000e+00, 0.00000000e+00},
    { 48,  1,  1,  0, 0.27928100e+02, 0.19539000e+01, 0.91180000e+00},
    { 48,  1,  1,  1, 0.44500600e+02, 0.19539000e+01, 0.00000000e+00},
    { 48,  2,  0,  0, 0.23156300e+02, 0.00000000e+00, 0.00000000e+00},
    { 48,  2,  1,  0, 0.18860700e+02, 0.19539000e+01, 0.00000000e+00},
    { 48,  3,  0,  0, 0.62105360e+03, 0.00000000e+00, 0.00000000e+00},
    { 48,  3,  0,  1, 0.19709400e+03, 0.00000000e+00, 0.98650000e+00},
    { 48,  3,  1,  0, 0.40844290e+03, 0.19539000e+01, 0.00000000e+00},
    { 48,  3,  1,  1, 0.14109010e+03, 0.19539000e+01, 0.98650000e+00},
    { 48,  4,  0,  0, 0.34041220e+03, 0.00000000e+00, 0.00000000e+00},
    { 48,  4,  0,  1, 0.24999150e+03, 0.00000000e+00, 0.98080000e+00},
    { 48,  4,  0,  2, 0.15869370e+03, 0.00000000e+00, 0.19697000e+01},
    { 48,  4,  1,  0, 0.24209500e+03, 0.19539000e+01, 0.00000000e+00},
    { 48,  4,  1,  1, 0.18052070e+03, 0.19539000e+01, 0.98080000e+00},
    { 48,  4,  1,  2, 0.11946230e+03, 0.19539000e+01, 0.19697000e+01},
    { 48,  5,  0,  0, 0.22262730e+03, 0.00000000e+00, 0.00000000e+00},
    { 48,  5,  0,  1, 0.18621990e+03, 0.00000000e+00, 0.97060000e+00},
    { 48,  5,  0,  2, 0.15547780e+03, 0.00000000e+00, 0.19441000e+01},
    { 48,  5,  0,  3, 0.11639220e+03, 0.00000000e+00, 0.29128000e+01},
    { 48,  5,  0,  4, 0.10928870e+03, 0.00000000e+00, 0.45856000e+01},
    { 48,  5,  1,  0, 0.16565870e+03, 0.19539000e+01, 0.00000000e+00},
    { 48,  5,  1,  1, 0.13987930e+03, 0.19539000e+01, 0.97060000e+00},
    { 48,  5,  1,  2, 0.11788430e+03, 0.19539000e+01, 0.19441000e+01},
    { 48,  5,  1,  3, 0.90427700e+02, 0.19539000e+01, 0.29128000e+01},
    { 48,  5,  1,  4, 0.85227400e+02, 0.19539000e+01, 0.45856000e+01},
    { 48,  6,  0,  0, 0.14741380e+03, 0.00000000e+00, 0.00000000e+00},
    { 48,  6,  0,  1, 0.13836720e+03, 0.00000000e+00, 0.98680000e+00},
    { 48,  6,  0,  2, 0.11192520e+03, 0.00000000e+00, 0.19985000e+01},
    { 48,  6,  0,  3, 0.10476920e+03, 0.00000000e+00, 0.29987000e+01},
    { 48,  6,  0,  4, 0.84713900e+02, 0.00000000e+00, 0.39844000e+01},
    { 48,  6,  1,  0, 0.11343690e+03, 0.19539000e+01, 0.00000000e+00},
    { 48,  6,  1,  1, 0.10643320e+03, 0.19539000e+01, 0.98680000e+00},
    { 48,  6,  1,  2, 0.87291500e+02, 0.19539000e+01, 0.19985000e+01},
    { 48,  6,  1,  3, 0.81750000e+02, 0.19539000e+01, 0.29987000e+01},
    { 48,  6,  1,  4, 0.67402800e+02, 0.19539000e+01, 0.39844000e+01},
    { 48,  7,  0,  0, 0.10173770e+03, 0.00000000e+00, 0.00000000e+00},
    { 48,  7,  0,  1, 0.94877000e+02, 0.00000000e+00, 0.99440000e+00},
    { 48,  7,  0,  2, 0.88985800e+02, 0.00000000e+00, 0.20143000e+01},
    { 48,  7,  0,  3, 0.78301600e+02, 0.00000000e+00, 0.29903000e+01},
    { 48,  7,  1,  0, 0.80249200e+02, 0.19539000e+01, 0.00000000e+00},
    { 48,  7,  1,  1, 0.74892500e+02, 0.19539000e+01, 0.99440000e+00},
    { 48,  7,  1,  2, 0.70442000e+02, 0.19539000e+01, 0.20143000e+01},
    { 48,  7,  1,  3, 0.62213100e+02, 0.19539000e+01, 0.29903000e+01},
    { 48,  8,  0,  0, 0.76409200e+02, 0.00000000e+00, 0.00000000e+00},
    { 48,  8,  0,  1, 0.68394300e+02, 0.00000000e+00, 0.99250000e+00},
    { 48,  8,  0,  2, 0.60233400e+02, 0.00000000e+00, 0.19887000e+01},
    { 48,  8,  1,  0, 0.61323400e+02, 0.19539000e+01, 0.00000000e+00},
    { 48,  8,  1,  1, 0.55139200e+02, 0.19539000e+01, 0.99250000e+00},
    { 48,  8,  1,  2, 0.48849700e+02, 0.19539000e+01, 0.19887000e+01},
    { 48,  9,  0,  0, 0.57550000e+02, 0.00000000e+00, 0.00000000e+00},
    { 48,  9,  0,  1, 0.46534000e+02, 0.00000000e+00, 0.99820000e+00},
    { 48,  9,  1,  0, 0.46869200e+02, 0.19539000e+01, 0.00000000e+00},
    { 48,  9,  1,  1, 0.38490600e+02, 0.19539000e+01, 0.99820000e+00},
    { 48, 10,  0,  0, 0.44106200e+02, 0.00000000e+00, 0.00000000e+00},
    { 48, 10,  1,  0, 0.36340100e+02, 0.19539000e+01, 0.00000000e+00},
    { 48, 11,  0,  0, 0.74057870e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 11,  0,  1, 0.28984740e+03, 0.00000000e+00, 0.96840000e+00},
    { 48, 11,  1,  0, 0.48951290e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 11,  1,  1, 0.20596470e+03, 0.19539000e+01, 0.96840000e+00},
    { 48, 12,  0,  0, 0.54767210e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 12,  0,  1, 0.44915670e+03, 0.00000000e+00, 0.96280000e+00},
    { 48, 12,  0,  2, 0.28521610e+03, 0.00000000e+00, 0.19496000e+01},
    { 48, 12,  1,  0, 0.38417280e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 12,  1,  1, 0.31790020e+03, 0.19539000e+01, 0.96280000e+00},
    { 48, 12,  1,  2, 0.21054980e+03, 0.19539000e+01, 0.19496000e+01},
    { 48, 13,  0,  0, 0.49703370e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 13,  0,  1, 0.44880710e+03, 0.00000000e+00, 0.96480000e+00},
    { 48, 13,  0,  2, 0.34529970e+03, 0.00000000e+00, 0.19311000e+01},
    { 48, 13,  0,  3, 0.26472910e+03, 0.00000000e+00, 0.29146000e+01},
    { 48, 13,  1,  0, 0.35686540e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 13,  1,  1, 0.32408300e+03, 0.19539000e+01, 0.96480000e+00},
    { 48, 13,  1,  2, 0.25422360e+03, 0.19539000e+01, 0.19311000e+01},
    { 48, 13,  1,  3, 0.19966700e+03, 0.19539000e+01, 0.29146000e+01},
    { 48, 14,  0,  0, 0.38367900e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 14,  0,  1, 0.35359760e+03, 0.00000000e+00, 0.95070000e+00},
    { 48, 14,  0,  2, 0.32796220e+03, 0.00000000e+00, 0.19435000e+01},
    { 48, 14,  0,  3, 0.32034290e+03, 0.00000000e+00, 0.29407000e+01},
    { 48, 14,  0,  4, 0.25988150e+03, 0.00000000e+00, 0.38677000e+01},
    { 48, 14,  1,  0, 0.28421390e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 14,  1,  1, 0.26314380e+03, 0.19539000e+01, 0.95070000e+00},
    { 48, 14,  1,  2, 0.24516140e+03, 0.19539000e+01, 0.19435000e+01},
    { 48, 14,  1,  3, 0.23876910e+03, 0.19539000e+01, 0.29407000e+01},
    { 48, 14,  1,  4, 0.19779040e+03, 0.19539000e+01, 0.38677000e+01},
    { 48, 15,  0,  0, 0.29424650e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 15,  0,  1, 0.28548020e+03, 0.00000000e+00, 0.99470000e+00},
    { 48, 15,  0,  2, 0.28194690e+03, 0.00000000e+00, 0.20102000e+01},
    { 48, 15,  0,  3, 0.26038920e+03, 0.00000000e+00, 0.29859000e+01},
    { 48, 15,  1,  0, 0.22377830e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 15,  1,  1, 0.21731990e+03, 0.19539000e+01, 0.99470000e+00},
    { 48, 15,  1,  2, 0.21429840e+03, 0.19539000e+01, 0.20102000e+01},
    { 48, 15,  1,  3, 0.19927140e+03, 0.19539000e+01, 0.29859000e+01},
    { 48, 16,  0,  0, 0.24176140e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 16,  0,  1, 0.23917840e+03, 0.00000000e+00, 0.99480000e+00},
    { 48, 16,  0,  2, 0.23431540e+03, 0.00000000e+00, 0.19903000e+01},
    { 48, 16,  1,  0, 0.18701630e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 16,  1,  1, 0.18495220e+03, 0.19539000e+01, 0.99480000e+00},
    { 48, 16,  1,  2, 0.18125820e+03, 0.19539000e+01, 0.19903000e+01},
    { 48, 17,  0,  0, 0.19570440e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 17,  0,  1, 0.19372730e+03, 0.00000000e+00, 0.99720000e+00},
    { 48, 17,  1,  0, 0.15385920e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 17,  1,  1, 0.15226460e+03, 0.19539000e+01, 0.99720000e+00},
    { 48, 18,  0,  0, 0.15896500e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 18,  1,  0, 0.12673560e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 19,  0,  0, 0.12225553e+04, 0.00000000e+00, 0.00000000e+00},
    { 48, 19,  0,  1, 0.39551350e+03, 0.00000000e+00, 0.97670000e+00},
    { 48, 19,  1,  0, 0.80025930e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 19,  1,  1, 0.28627350e+03, 0.19539000e+01, 0.97670000e+00},
    { 48, 20,  0,  0, 0.97842510e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 20,  0,  1, 0.78166000e+03, 0.00000000e+00, 0.98310000e+00},
    { 48, 20,  0,  2, 0.40045350e+03, 0.00000000e+00, 0.19349000e+01},
    { 48, 20,  1,  0, 0.67026330e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 20,  1,  1, 0.53708890e+03, 0.19539000e+01, 0.98310000e+00},
    { 48, 20,  1,  2, 0.29569410e+03, 0.19539000e+01, 0.19349000e+01},
    { 48, 21,  0,  0, 0.80260200e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 21,  0,  1, 0.38918590e+03, 0.00000000e+00, 0.18627000e+01},
    { 48, 21,  0,  2, 0.38172980e+03, 0.00000000e+00, 0.28999000e+01},
    { 48, 21,  1,  0, 0.55566790e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 21,  1,  1, 0.28838750e+03, 0.19539000e+01, 0.18627000e+01},
    { 48, 21,  1,  2, 0.28528140e+03, 0.19539000e+01, 0.28999000e+01},
    { 48, 22,  0,  0, 0.77003030e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 22,  0,  1, 0.37552610e+03, 0.00000000e+00, 0.18299000e+01},
    { 48, 22,  0,  2, 0.38622410e+03, 0.00000000e+00, 0.38675000e+01},
    { 48, 22,  1,  0, 0.53855020e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 22,  1,  1, 0.27858690e+03, 0.19539000e+01, 0.18299000e+01},
    { 48, 22,  1,  2, 0.28891110e+03, 0.19539000e+01, 0.38675000e+01},
    { 48, 23,  0,  0, 0.70242130e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 23,  0,  1, 0.36818710e+03, 0.00000000e+00, 0.19138000e+01},
    { 48, 23,  0,  2, 0.35382270e+03, 0.00000000e+00, 0.29110000e+01},
    { 48, 23,  1,  0, 0.49422370e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 23,  1,  1, 0.27303310e+03, 0.19539000e+01, 0.19138000e+01},
    { 48, 23,  1,  2, 0.26453140e+03, 0.19539000e+01, 0.29110000e+01},
    { 48, 24,  0,  0, 0.55309190e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 24,  0,  1, 0.36555310e+03, 0.00000000e+00, 0.18269000e+01},
    { 48, 24,  0,  2, 0.26345110e+03, 0.00000000e+00, 0.10619100e+02},
    { 48, 24,  1,  0, 0.38999530e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 24,  1,  1, 0.27028900e+03, 0.19539000e+01, 0.18269000e+01},
    { 48, 24,  1,  2, 0.20093810e+03, 0.19539000e+01, 0.10619100e+02},
    { 48, 25,  0,  0, 0.60140530e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 25,  0,  1, 0.33315180e+03, 0.00000000e+00, 0.16406000e+01},
    { 48, 25,  0,  2, 0.22376440e+03, 0.00000000e+00, 0.98849000e+01},
    { 48, 25,  1,  0, 0.42685790e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 25,  1,  1, 0.24982010e+03, 0.19539000e+01, 0.16406000e+01},
    { 48, 25,  1,  2, 0.17276980e+03, 0.19539000e+01, 0.98849000e+01},
    { 48, 26,  0,  0, 0.47153290e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 26,  0,  1, 0.30752090e+03, 0.00000000e+00, 0.16483000e+01},
    { 48, 26,  0,  2, 0.21987500e+03, 0.00000000e+00, 0.91376000e+01},
    { 48, 26,  1,  0, 0.33576420e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 26,  1,  1, 0.23161700e+03, 0.19539000e+01, 0.16483000e+01},
    { 48, 26,  1,  2, 0.16952460e+03, 0.19539000e+01, 0.91376000e+01},
    { 48, 27,  0,  0, 0.49563130e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 27,  0,  1, 0.29340740e+03, 0.00000000e+00, 0.17149000e+01},
    { 48, 27,  0,  2, 0.26087010e+03, 0.00000000e+00, 0.29263000e+01},
    { 48, 27,  0,  3, 0.23040100e+03, 0.00000000e+00, 0.77785000e+01},
    { 48, 27,  1,  0, 0.35691720e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 27,  1,  1, 0.22102480e+03, 0.19539000e+01, 0.17149000e+01},
    { 48, 27,  1,  2, 0.19723130e+03, 0.19539000e+01, 0.29263000e+01},
    { 48, 27,  1,  3, 0.17646970e+03, 0.19539000e+01, 0.77785000e+01},
    { 48, 28,  0,  0, 0.51262200e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 28,  0,  1, 0.28709580e+03, 0.00000000e+00, 0.17937000e+01},
    { 48, 28,  0,  2, 0.24218240e+03, 0.00000000e+00, 0.65458000e+01},
    { 48, 28,  0,  3, 0.25636430e+03, 0.00000000e+00, 0.62918000e+01},
    { 48, 28,  1,  0, 0.36686680e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 28,  1,  1, 0.21602110e+03, 0.19539000e+01, 0.17937000e+01},
    { 48, 28,  1,  2, 0.18414330e+03, 0.19539000e+01, 0.65458000e+01},
    { 48, 28,  1,  3, 0.19260990e+03, 0.19539000e+01, 0.62918000e+01},
    { 48, 29,  0,  0, 0.39305100e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 29,  0,  1, 0.28581800e+03, 0.00000000e+00, 0.95760000e+00},
    { 48, 29,  1,  0, 0.28186750e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 29,  1,  1, 0.21274680e+03, 0.19539000e+01, 0.95760000e+00},
    { 48, 30,  0,  0, 0.39845720e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 30,  0,  1, 0.26457160e+03, 0.00000000e+00, 0.19419000e+01},
    { 48, 30,  1,  0, 0.29078950e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 30,  1,  1, 0.20082240e+03, 0.19539000e+01, 0.19419000e+01},
    { 48, 31,  0,  0, 0.47342030e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 31,  0,  1, 0.44286390e+03, 0.00000000e+00, 0.96010000e+00},
    { 48, 31,  0,  2, 0.34605680e+03, 0.00000000e+00, 0.19315000e+01},
    { 48, 31,  0,  3, 0.27928860e+03, 0.00000000e+00, 0.29233000e+01},
    { 48, 31,  1,  0, 0.34329430e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 31,  1,  1, 0.32310800e+03, 0.19539000e+01, 0.96010000e+00},
    { 48, 31,  1,  2, 0.25790070e+03, 0.19539000e+01, 0.19315000e+01},
    { 48, 31,  1,  3, 0.21251480e+03, 0.19539000e+01, 0.29233000e+01},
    { 48, 32,  0,  0, 0.41090580e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 32,  0,  1, 0.38302040e+03, 0.00000000e+00, 0.94340000e+00},
    { 48, 32,  0,  2, 0.36375360e+03, 0.00000000e+00, 0.19447000e+01},
    { 48, 32,  0,  3, 0.32392920e+03, 0.00000000e+00, 0.29186000e+01},
    { 48, 32,  0,  4, 0.28372370e+03, 0.00000000e+00, 0.38972000e+01},
    { 48, 32,  1,  0, 0.30514680e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 32,  1,  1, 0.28605510e+03, 0.19539000e+01, 0.94340000e+00},
    { 48, 32,  1,  2, 0.27272280e+03, 0.19539000e+01, 0.19447000e+01},
    { 48, 32,  1,  3, 0.24521190e+03, 0.19539000e+01, 0.29186000e+01},
    { 48, 32,  1,  4, 0.21737600e+03, 0.19539000e+01, 0.38972000e+01},
    { 48, 33,  0,  0, 0.34560850e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 33,  0,  1, 0.33948140e+03, 0.00000000e+00, 0.98890000e+00},
    { 48, 33,  0,  2, 0.33010750e+03, 0.00000000e+00, 0.19793000e+01},
    { 48, 33,  0,  3, 0.31728800e+03, 0.00000000e+00, 0.29709000e+01},
    { 48, 33,  1,  0, 0.26228400e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 33,  1,  1, 0.25796890e+03, 0.19539000e+01, 0.98890000e+00},
    { 48, 33,  1,  2, 0.25140820e+03, 0.19539000e+01, 0.19793000e+01},
    { 48, 33,  1,  3, 0.24246050e+03, 0.19539000e+01, 0.29709000e+01},
    { 48, 34,  0,  0, 0.30755390e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 34,  0,  1, 0.30772140e+03, 0.00000000e+00, 0.99010000e+00},
    { 48, 34,  0,  2, 0.30524540e+03, 0.00000000e+00, 0.19812000e+01},
    { 48, 34,  1,  0, 0.23657790e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 34,  1,  1, 0.23666040e+03, 0.19539000e+01, 0.99010000e+00},
    { 48, 34,  1,  2, 0.23484700e+03, 0.19539000e+01, 0.19812000e+01},
    { 48, 35,  0,  0, 0.26697000e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 35,  0,  1, 0.26894910e+03, 0.00000000e+00, 0.99740000e+00},
    { 48, 35,  1,  0, 0.20821130e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 35,  1,  1, 0.20960830e+03, 0.19539000e+01, 0.99740000e+00},
    { 48, 36,  0,  0, 0.23054930e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 36,  1,  0, 0.18208670e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 37,  0,  0, 0.13663938e+04, 0.00000000e+00, 0.00000000e+00},
    { 48, 37,  0,  1, 0.47031190e+03, 0.00000000e+00, 0.97380000e+00},
    { 48, 37,  1,  0, 0.89853420e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 37,  1,  1, 0.34234100e+03, 0.19539000e+01, 0.97380000e+00},
    { 48, 38,  0,  0, 0.11670471e+04, 0.00000000e+00, 0.00000000e+00},
    { 48, 38,  0,  1, 0.95275330e+03, 0.00000000e+00, 0.98010000e+00},
    { 48, 38,  0,  2, 0.47937970e+03, 0.00000000e+00, 0.19143000e+01},
    { 48, 38,  1,  0, 0.79845280e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 38,  1,  1, 0.65327820e+03, 0.19539000e+01, 0.98010000e+00},
    { 48, 38,  1,  2, 0.35460960e+03, 0.19539000e+01, 0.19143000e+01},
    { 48, 39,  0,  0, 0.10094418e+04, 0.00000000e+00, 0.00000000e+00},
    { 48, 39,  0,  1, 0.71021720e+03, 0.00000000e+00, 0.19153000e+01},
    { 48, 39,  0,  2, 0.45648750e+03, 0.00000000e+00, 0.28903000e+01},
    { 48, 39,  1,  0, 0.70379920e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 39,  1,  1, 0.50567470e+03, 0.19539000e+01, 0.19153000e+01},
    { 48, 39,  1,  2, 0.34299870e+03, 0.19539000e+01, 0.28903000e+01},
    { 48, 40,  0,  0, 0.90011540e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 40,  0,  1, 0.51538610e+03, 0.00000000e+00, 0.19355000e+01},
    { 48, 40,  0,  2, 0.45901640e+03, 0.00000000e+00, 0.39106000e+01},
    { 48, 40,  1,  0, 0.63513700e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 40,  1,  1, 0.38134050e+03, 0.19539000e+01, 0.19355000e+01},
    { 48, 40,  1,  2, 0.34647920e+03, 0.19539000e+01, 0.39106000e+01},
    { 48, 41,  0,  0, 0.81654950e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 41,  0,  1, 0.52076290e+03, 0.00000000e+00, 0.19545000e+01},
    { 48, 41,  0,  2, 0.44449320e+03, 0.00000000e+00, 0.29225000e+01},
    { 48, 41,  1,  0, 0.58084120e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 41,  1,  1, 0.38512060e+03, 0.19539000e+01, 0.19545000e+01},
    { 48, 41,  1,  2, 0.33513120e+03, 0.19539000e+01, 0.29225000e+01},
    { 48, 42,  0,  0, 0.62495060e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 42,  0,  1, 0.48402860e+03, 0.00000000e+00, 0.19420000e+01},
    { 48, 42,  0,  2, 0.38983000e+03, 0.00000000e+00, 0.11055600e+02},
    { 48, 42,  1,  0, 0.45097760e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 42,  1,  1, 0.35990590e+03, 0.19539000e+01, 0.19420000e+01},
    { 48, 42,  1,  2, 0.29784780e+03, 0.19539000e+01, 0.11055600e+02},
    { 48, 43,  0,  0, 0.69953820e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 43,  0,  1, 0.54963380e+03, 0.00000000e+00, 0.16682000e+01},
    { 48, 43,  0,  2, 0.34192370e+03, 0.00000000e+00, 0.95402000e+01},
    { 48, 43,  1,  0, 0.50211680e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 43,  1,  1, 0.40123820e+03, 0.19539000e+01, 0.16682000e+01},
    { 48, 43,  1,  2, 0.26402010e+03, 0.19539000e+01, 0.95402000e+01},
    { 48, 44,  0,  0, 0.52793870e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 44,  0,  1, 0.41825790e+03, 0.00000000e+00, 0.18584000e+01},
    { 48, 44,  0,  2, 0.32240840e+03, 0.00000000e+00, 0.88895000e+01},
    { 48, 44,  1,  0, 0.38494360e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 44,  1,  1, 0.31533650e+03, 0.19539000e+01, 0.18584000e+01},
    { 48, 44,  1,  2, 0.24993600e+03, 0.19539000e+01, 0.88895000e+01},
    { 48, 45,  0,  0, 0.57701070e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 45,  0,  1, 0.39106750e+03, 0.00000000e+00, 0.19003000e+01},
    { 48, 45,  0,  2, 0.33108150e+03, 0.00000000e+00, 0.29696000e+01},
    { 48, 45,  1,  0, 0.42037460e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 45,  1,  1, 0.29530360e+03, 0.19539000e+01, 0.19003000e+01},
    { 48, 45,  1,  2, 0.25366630e+03, 0.19539000e+01, 0.29696000e+01},
    { 48, 46,  0,  0, 0.53341340e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 46,  0,  1, 0.36264320e+03, 0.00000000e+00, 0.18630000e+01},
    { 48, 46,  0,  2, 0.34660550e+03, 0.00000000e+00, 0.57095000e+01},
    { 48, 46,  1,  0, 0.39057700e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 46,  1,  1, 0.27461540e+03, 0.19539000e+01, 0.18630000e+01},
    { 48, 46,  1,  2, 0.26459410e+03, 0.19539000e+01, 0.57095000e+01},
    { 48, 47,  0,  0, 0.44587010e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 47,  0,  1, 0.35137120e+03, 0.00000000e+00, 0.96790000e+00},
    { 48, 47,  1,  0, 0.32596620e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 47,  1,  1, 0.26554500e+03, 0.19539000e+01, 0.96790000e+00},
    { 48, 48,  0,  0, 0.46819000e+03, 0.00000000e+00, 0.00000000e+00},
    { 48, 48,  1,  0, 0.34505990e+03, 0.19539000e+01, 0.00000000e+00},
    { 48, 48,  1,  1, 0.26345080e+03, 0.19539000e+01, 0.19539000e+01},
    { 49,  1,  0,  0, 0.44041700e+02, 0.00000000e+00, 0.91180000e+00},
    { 49,  1,  0,  1, 0.72907600e+02, 0.00000000e+00, 0.00000000e+00},
    { 49,  1,  1,  0, 0.42282700e+02, 0.96330000e+00, 0.91180000e+00},
    { 49,  1,  1,  1, 0.69675400e+02, 0.96330000e+00, 0.00000000e+00},
    { 49,  1,  2,  0, 0.34893100e+02, 0.19378000e+01, 0.91180000e+00},
    { 49,  1,  2,  1, 0.56518900e+02, 0.19378000e+01, 0.00000000e+00},
    { 49,  1,  3,  0, 0.30319300e+02, 0.29353000e+01, 0.91180000e+00},
    { 49,  1,  3,  1, 0.48427000e+02, 0.29353000e+01, 0.00000000e+00},
    { 49,  2,  0,  0, 0.27958600e+02, 0.00000000e+00, 0.00000000e+00},
    { 49,  2,  1,  0, 0.27023600e+02, 0.96330000e+00, 0.00000000e+00},
    { 49,  2,  2,  0, 0.22907600e+02, 0.19378000e+01, 0.00000000e+00},
    { 49,  2,  3,  0, 0.20340200e+02, 0.29353000e+01, 0.00000000e+00},
    { 49,  3,  0,  0, 0.82896730e+03, 0.00000000e+00, 0.00000000e+00},
    { 49,  3,  0,  1, 0.25313700e+03, 0.00000000e+00, 0.98650000e+00},
    { 49,  3,  1,  0, 0.76925140e+03, 0.96330000e+00, 0.00000000e+00},
    { 49,  3,  1,  1, 0.23904190e+03, 0.96330000e+00, 0.98650000e+00},
    { 49,  3,  2,  0, 0.56526540e+03, 0.19378000e+01, 0.00000000e+00},
    { 49,  3,  2,  1, 0.18591700e+03, 0.19378000e+01, 0.98650000e+00},
    { 49,  3,  3,  0, 0.44469780e+03, 0.29353000e+01, 0.00000000e+00},
    { 49,  3,  3,  1, 0.15382640e+03, 0.29353000e+01, 0.98650000e+00},
    { 49,  4,  0,  0, 0.43833960e+03, 0.00000000e+00, 0.00000000e+00},
    { 49,  4,  0,  1, 0.32009120e+03, 0.00000000e+00, 0.98080000e+00},
    { 49,  4,  0,  2, 0.19941110e+03, 0.00000000e+00, 0.19697000e+01},
    { 49,  4,  1,  0, 0.41349650e+03, 0.96330000e+00, 0.00000000e+00},
    { 49,  4,  1,  1, 0.30266780e+03, 0.96330000e+00, 0.98080000e+00},
    { 49,  4,  1,  2, 0.19013130e+03, 0.96330000e+00, 0.19697000e+01},
    { 49,  4,  2,  0, 0.32028070e+03, 0.19378000e+01, 0.00000000e+00},
    { 49,  4,  2,  1, 0.23667710e+03, 0.19378000e+01, 0.98080000e+00},
    { 49,  4,  2,  2, 0.15292390e+03, 0.19378000e+01, 0.19697000e+01},
    { 49,  4,  3,  0, 0.26404390e+03, 0.29353000e+01, 0.00000000e+00},
    { 49,  4,  3,  1, 0.19674540e+03, 0.29353000e+01, 0.98080000e+00},
    { 49,  4,  3,  2, 0.13011390e+03, 0.29353000e+01, 0.19697000e+01},
    { 49,  5,  0,  0, 0.28117370e+03, 0.00000000e+00, 0.00000000e+00},
    { 49,  5,  0,  1, 0.23421710e+03, 0.00000000e+00, 0.97060000e+00},
    { 49,  5,  0,  2, 0.19476490e+03, 0.00000000e+00, 0.19441000e+01},
    { 49,  5,  0,  3, 0.14412590e+03, 0.00000000e+00, 0.29128000e+01},
    { 49,  5,  0,  4, 0.13508140e+03, 0.00000000e+00, 0.45856000e+01},
    { 49,  5,  1,  0, 0.26747500e+03, 0.96330000e+00, 0.00000000e+00},
    { 49,  5,  1,  1, 0.22316290e+03, 0.96330000e+00, 0.97060000e+00},
    { 49,  5,  1,  2, 0.18585760e+03, 0.96330000e+00, 0.19441000e+01},
    { 49,  5,  1,  3, 0.13818550e+03, 0.96330000e+00, 0.29128000e+01},
    { 49,  5,  1,  4, 0.12959790e+03, 0.96330000e+00, 0.45856000e+01},
    { 49,  5,  2,  0, 0.21344840e+03, 0.19378000e+01, 0.00000000e+00},
    { 49,  5,  2,  1, 0.17917550e+03, 0.19378000e+01, 0.97060000e+00},
    { 49,  5,  2,  2, 0.15012670e+03, 0.19378000e+01, 0.19441000e+01},
    { 49,  5,  2,  3, 0.11348260e+03, 0.19378000e+01, 0.29128000e+01},
    { 49,  5,  2,  4, 0.10669460e+03, 0.19378000e+01, 0.45856000e+01},
    { 49,  5,  3,  0, 0.18045680e+03, 0.29353000e+01, 0.00000000e+00},
    { 49,  5,  3,  1, 0.15226150e+03, 0.29353000e+01, 0.97060000e+00},
    { 49,  5,  3,  2, 0.12821910e+03, 0.29353000e+01, 0.19441000e+01},
    { 49,  5,  3,  3, 0.98223500e+02, 0.29353000e+01, 0.29128000e+01},
    { 49,  5,  3,  4, 0.92535500e+02, 0.29353000e+01, 0.45856000e+01},
    { 49,  6,  0,  0, 0.18333680e+03, 0.00000000e+00, 0.00000000e+00},
    { 49,  6,  0,  1, 0.17212290e+03, 0.00000000e+00, 0.98680000e+00},
    { 49,  6,  0,  2, 0.13828310e+03, 0.00000000e+00, 0.19985000e+01},
    { 49,  6,  0,  3, 0.12938530e+03, 0.00000000e+00, 0.29987000e+01},
    { 49,  6,  0,  4, 0.10361980e+03, 0.00000000e+00, 0.39844000e+01},
    { 49,  6,  1,  0, 0.17545850e+03, 0.96330000e+00, 0.00000000e+00},
    { 49,  6,  1,  1, 0.16468120e+03, 0.96330000e+00, 0.98680000e+00},
    { 49,  6,  1,  2, 0.13265050e+03, 0.96330000e+00, 0.19985000e+01},
    { 49,  6,  1,  3, 0.12410850e+03, 0.96330000e+00, 0.29987000e+01},
    { 49,  6,  1,  4, 0.99752200e+02, 0.96330000e+00, 0.39844000e+01},
    { 49,  6,  2,  0, 0.14316020e+03, 0.19378000e+01, 0.00000000e+00},
    { 49,  6,  2,  1, 0.13430140e+03, 0.19378000e+01, 0.98680000e+00},
    { 49,  6,  2,  2, 0.10920000e+03, 0.19378000e+01, 0.19985000e+01},
    { 49,  6,  2,  3, 0.10218770e+03, 0.19378000e+01, 0.29987000e+01},
    { 49,  6,  2,  4, 0.83227000e+02, 0.19378000e+01, 0.39844000e+01},
    { 49,  6,  3,  0, 0.12327050e+03, 0.29353000e+01, 0.00000000e+00},
    { 49,  6,  3,  1, 0.11561300e+03, 0.29353000e+01, 0.98680000e+00},
    { 49,  6,  3,  2, 0.94715300e+02, 0.29353000e+01, 0.19985000e+01},
    { 49,  6,  3,  3, 0.88657200e+02, 0.29353000e+01, 0.29987000e+01},
    { 49,  6,  3,  4, 0.72970300e+02, 0.29353000e+01, 0.39844000e+01},
    { 49,  7,  0,  0, 0.12497980e+03, 0.00000000e+00, 0.00000000e+00},
    { 49,  7,  0,  1, 0.11649590e+03, 0.00000000e+00, 0.99440000e+00},
    { 49,  7,  0,  2, 0.10908250e+03, 0.00000000e+00, 0.20143000e+01},
    { 49,  7,  0,  3, 0.95772700e+02, 0.00000000e+00, 0.29903000e+01},
    { 49,  7,  1,  0, 0.12012790e+03, 0.96330000e+00, 0.00000000e+00},
    { 49,  7,  1,  1, 0.11197070e+03, 0.96330000e+00, 0.99440000e+00},
    { 49,  7,  1,  2, 0.10489720e+03, 0.96330000e+00, 0.20143000e+01},
    { 49,  7,  1,  3, 0.92140300e+02, 0.96330000e+00, 0.29903000e+01},
    { 49,  7,  2,  0, 0.99643500e+02, 0.19378000e+01, 0.00000000e+00},
    { 49,  7,  2,  1, 0.92908600e+02, 0.19378000e+01, 0.99440000e+00},
    { 49,  7,  2,  2, 0.87207600e+02, 0.19378000e+01, 0.20143000e+01},
    { 49,  7,  2,  3, 0.76779800e+02, 0.19378000e+01, 0.29903000e+01},
    { 49,  7,  3,  0, 0.86956900e+02, 0.29353000e+01, 0.00000000e+00},
    { 49,  7,  3,  1, 0.81111000e+02, 0.29353000e+01, 0.99440000e+00},
    { 49,  7,  3,  2, 0.76253000e+02, 0.29353000e+01, 0.20143000e+01},
    { 49,  7,  3,  3, 0.67270400e+02, 0.29353000e+01, 0.29903000e+01},
    { 49,  8,  0,  0, 0.92996800e+02, 0.00000000e+00, 0.00000000e+00},
    { 49,  8,  0,  1, 0.83027800e+02, 0.00000000e+00, 0.99250000e+00},
    { 49,  8,  0,  2, 0.72857100e+02, 0.00000000e+00, 0.19887000e+01},
    { 49,  8,  1,  0, 0.89652000e+02, 0.96330000e+00, 0.00000000e+00},
    { 49,  8,  1,  1, 0.80098600e+02, 0.96330000e+00, 0.99250000e+00},
    { 49,  8,  1,  2, 0.70351100e+02, 0.96330000e+00, 0.19887000e+01},
    { 49,  8,  2,  0, 0.75235100e+02, 0.19378000e+01, 0.00000000e+00},
    { 49,  8,  2,  1, 0.67419300e+02, 0.19378000e+01, 0.99250000e+00},
    { 49,  8,  2,  2, 0.59451100e+02, 0.19378000e+01, 0.19887000e+01},
    { 49,  8,  3,  0, 0.66274100e+02, 0.29353000e+01, 0.00000000e+00},
    { 49,  8,  3,  1, 0.59534400e+02, 0.29353000e+01, 0.99250000e+00},
    { 49,  8,  3,  2, 0.52669000e+02, 0.29353000e+01, 0.19887000e+01},
    { 49,  9,  0,  0, 0.69455800e+02, 0.00000000e+00, 0.00000000e+00},
    { 49,  9,  0,  1, 0.55658900e+02, 0.00000000e+00, 0.99820000e+00},
    { 49,  9,  1,  0, 0.67123200e+02, 0.96330000e+00, 0.00000000e+00},
    { 49,  9,  1,  1, 0.53936400e+02, 0.96330000e+00, 0.99820000e+00},
    { 49,  9,  2,  0, 0.56892200e+02, 0.19378000e+01, 0.00000000e+00},
    { 49,  9,  2,  1, 0.46208200e+02, 0.19378000e+01, 0.99820000e+00},
    { 49,  9,  3,  0, 0.50515600e+02, 0.29353000e+01, 0.00000000e+00},
    { 49,  9,  3,  1, 0.41374600e+02, 0.29353000e+01, 0.99820000e+00},
    { 49, 10,  0,  0, 0.52851700e+02, 0.00000000e+00, 0.00000000e+00},
    { 49, 10,  1,  0, 0.51174700e+02, 0.96330000e+00, 0.00000000e+00},
    { 49, 10,  2,  0, 0.43721500e+02, 0.19378000e+01, 0.00000000e+00},
    { 49, 10,  3,  0, 0.39067400e+02, 0.29353000e+01, 0.00000000e+00},
    { 49, 11,  0,  0, 0.98609990e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 11,  0,  1, 0.37337940e+03, 0.00000000e+00, 0.96840000e+00},
    { 49, 11,  1,  0, 0.91594130e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 11,  1,  1, 0.35200740e+03, 0.96330000e+00, 0.96840000e+00},
    { 49, 11,  2,  0, 0.67522680e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 11,  2,  1, 0.27237350e+03, 0.19378000e+01, 0.96840000e+00},
    { 49, 11,  3,  0, 0.53285380e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 11,  3,  1, 0.22440970e+03, 0.29353000e+01, 0.96840000e+00},
    { 49, 12,  0,  0, 0.70935650e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 12,  0,  1, 0.57992340e+03, 0.00000000e+00, 0.96280000e+00},
    { 49, 12,  0,  2, 0.36138350e+03, 0.00000000e+00, 0.19496000e+01},
    { 49, 12,  1,  0, 0.66728440e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 12,  1,  1, 0.54627620e+03, 0.96330000e+00, 0.96280000e+00},
    { 49, 12,  1,  2, 0.34330980e+03, 0.96330000e+00, 0.19496000e+01},
    { 49, 12,  2,  0, 0.51209020e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 12,  2,  1, 0.42155730e+03, 0.19378000e+01, 0.96280000e+00},
    { 49, 12,  2,  2, 0.27256770e+03, 0.19378000e+01, 0.19496000e+01},
    { 49, 12,  3,  0, 0.41885670e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 12,  3,  1, 0.34649400e+03, 0.29353000e+01, 0.96280000e+00},
    { 49, 12,  3,  2, 0.22944250e+03, 0.29353000e+01, 0.19496000e+01},
    { 49, 13,  0,  0, 0.63758320e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 13,  0,  1, 0.57434200e+03, 0.00000000e+00, 0.96480000e+00},
    { 49, 13,  0,  2, 0.43824740e+03, 0.00000000e+00, 0.19311000e+01},
    { 49, 13,  0,  3, 0.33234100e+03, 0.00000000e+00, 0.29146000e+01},
    { 49, 13,  1,  0, 0.60241430e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 13,  1,  1, 0.54321880e+03, 0.96330000e+00, 0.96480000e+00},
    { 49, 13,  1,  2, 0.41600330e+03, 0.96330000e+00, 0.19311000e+01},
    { 49, 13,  1,  3, 0.31698520e+03, 0.96330000e+00, 0.29146000e+01},
    { 49, 13,  2,  0, 0.46945400e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 13,  2,  1, 0.42489670e+03, 0.19378000e+01, 0.96480000e+00},
    { 49, 13,  2,  2, 0.32959200e+03, 0.19378000e+01, 0.19311000e+01},
    { 49, 13,  2,  3, 0.25528030e+03, 0.19378000e+01, 0.29146000e+01},
    { 49, 13,  3,  0, 0.38906980e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 13,  3,  1, 0.35326540e+03, 0.29353000e+01, 0.96480000e+00},
    { 49, 13,  3,  2, 0.27699400e+03, 0.29353000e+01, 0.19311000e+01},
    { 49, 13,  3,  3, 0.21743180e+03, 0.29353000e+01, 0.29146000e+01},
    { 49, 14,  0,  0, 0.48553920e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 14,  0,  1, 0.44659370e+03, 0.00000000e+00, 0.95070000e+00},
    { 49, 14,  0,  2, 0.41337540e+03, 0.00000000e+00, 0.19435000e+01},
    { 49, 14,  0,  3, 0.40432940e+03, 0.00000000e+00, 0.29407000e+01},
    { 49, 14,  0,  4, 0.32493450e+03, 0.00000000e+00, 0.38677000e+01},
    { 49, 14,  1,  0, 0.46150930e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 14,  1,  1, 0.42482930e+03, 0.96330000e+00, 0.95070000e+00},
    { 49, 14,  1,  2, 0.39356170e+03, 0.96330000e+00, 0.19435000e+01},
    { 49, 14,  1,  3, 0.38467520e+03, 0.96330000e+00, 0.29407000e+01},
    { 49, 14,  1,  4, 0.31041220e+03, 0.96330000e+00, 0.38677000e+01},
    { 49, 14,  2,  0, 0.36720280e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 14,  2,  1, 0.33903150e+03, 0.19378000e+01, 0.95070000e+00},
    { 49, 14,  2,  2, 0.31501770e+03, 0.19378000e+01, 0.19435000e+01},
    { 49, 14,  2,  3, 0.30725150e+03, 0.19378000e+01, 0.29407000e+01},
    { 49, 14,  2,  4, 0.25147160e+03, 0.19378000e+01, 0.38677000e+01},
    { 49, 14,  3,  0, 0.30967790e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 14,  3,  1, 0.28664120e+03, 0.29353000e+01, 0.95070000e+00},
    { 49, 14,  3,  2, 0.26699740e+03, 0.29353000e+01, 0.19435000e+01},
    { 49, 14,  3,  3, 0.25998580e+03, 0.29353000e+01, 0.29407000e+01},
    { 49, 14,  3,  4, 0.21524240e+03, 0.29353000e+01, 0.38677000e+01},
    { 49, 15,  0,  0, 0.36802750e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 15,  0,  1, 0.35690690e+03, 0.00000000e+00, 0.99470000e+00},
    { 49, 15,  0,  2, 0.35272470e+03, 0.00000000e+00, 0.20102000e+01},
    { 49, 15,  0,  3, 0.32473460e+03, 0.00000000e+00, 0.29859000e+01},
    { 49, 15,  1,  0, 0.35151570e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 15,  1,  1, 0.34093960e+03, 0.96330000e+00, 0.99470000e+00},
    { 49, 15,  1,  2, 0.33682850e+03, 0.96330000e+00, 0.20102000e+01},
    { 49, 15,  1,  3, 0.31050480e+03, 0.96330000e+00, 0.29859000e+01},
    { 49, 15,  2,  0, 0.28461460e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 15,  2,  1, 0.27621540e+03, 0.19378000e+01, 0.99470000e+00},
    { 49, 15,  2,  2, 0.27258640e+03, 0.19378000e+01, 0.20102000e+01},
    { 49, 15,  2,  3, 0.25244560e+03, 0.19378000e+01, 0.29859000e+01},
    { 49, 15,  3,  0, 0.24351060e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 15,  3,  1, 0.23644610e+03, 0.29353000e+01, 0.99470000e+00},
    { 49, 15,  3,  2, 0.23314220e+03, 0.29353000e+01, 0.20102000e+01},
    { 49, 15,  3,  3, 0.21672230e+03, 0.29353000e+01, 0.29859000e+01},
    { 49, 16,  0,  0, 0.29998530e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 16,  0,  1, 0.29682140e+03, 0.00000000e+00, 0.99480000e+00},
    { 49, 16,  0,  2, 0.29072550e+03, 0.00000000e+00, 0.19903000e+01},
    { 49, 16,  1,  0, 0.28739220e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 16,  1,  1, 0.28433500e+03, 0.96330000e+00, 0.99480000e+00},
    { 49, 16,  1,  2, 0.27850870e+03, 0.96330000e+00, 0.19903000e+01},
    { 49, 16,  2,  0, 0.23533010e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 16,  2,  1, 0.23276490e+03, 0.19378000e+01, 0.99480000e+00},
    { 49, 16,  2,  2, 0.22804730e+03, 0.19378000e+01, 0.19903000e+01},
    { 49, 16,  3,  0, 0.20320970e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 16,  3,  1, 0.20095580e+03, 0.29353000e+01, 0.99480000e+00},
    { 49, 16,  3,  2, 0.19692250e+03, 0.29353000e+01, 0.19903000e+01},
    { 49, 17,  0,  0, 0.24091040e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 17,  0,  1, 0.23849880e+03, 0.00000000e+00, 0.99720000e+00},
    { 49, 17,  1,  0, 0.23145540e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 17,  1,  1, 0.22912290e+03, 0.96330000e+00, 0.99720000e+00},
    { 49, 17,  2,  0, 0.19158160e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 17,  2,  1, 0.18961390e+03, 0.19378000e+01, 0.99720000e+00},
    { 49, 17,  3,  0, 0.16688670e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 17,  3,  1, 0.16514950e+03, 0.29353000e+01, 0.99720000e+00},
    { 49, 18,  0,  0, 0.19426460e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 18,  1,  0, 0.18709160e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 18,  2,  0, 0.15631790e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 18,  3,  0, 0.13720100e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 19,  0,  0, 0.16388153e+04, 0.00000000e+00, 0.00000000e+00},
    { 49, 19,  0,  1, 0.50568380e+03, 0.00000000e+00, 0.97670000e+00},
    { 49, 19,  1,  0, 0.15173687e+04, 0.96330000e+00, 0.00000000e+00},
    { 49, 19,  1,  1, 0.47801410e+03, 0.96330000e+00, 0.97670000e+00},
    { 49, 19,  2,  0, 0.11101907e+04, 0.19378000e+01, 0.00000000e+00},
    { 49, 19,  2,  1, 0.37405850e+03, 0.19378000e+01, 0.97670000e+00},
    { 49, 19,  3,  0, 0.86995980e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 19,  3,  1, 0.31131870e+03, 0.29353000e+01, 0.97670000e+00},
    { 49, 20,  0,  0, 0.12812612e+04, 0.00000000e+00, 0.00000000e+00},
    { 49, 20,  0,  1, 0.10241614e+04, 0.00000000e+00, 0.98310000e+00},
    { 49, 20,  0,  2, 0.50726050e+03, 0.00000000e+00, 0.19349000e+01},
    { 49, 20,  1,  0, 0.11989287e+04, 0.96330000e+00, 0.00000000e+00},
    { 49, 20,  1,  1, 0.95798970e+03, 0.96330000e+00, 0.98310000e+00},
    { 49, 20,  1,  2, 0.48167290e+03, 0.96330000e+00, 0.19349000e+01},
    { 49, 20,  2,  0, 0.90511860e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 20,  2,  1, 0.72398140e+03, 0.19378000e+01, 0.98310000e+00},
    { 49, 20,  2,  2, 0.38227200e+03, 0.19378000e+01, 0.19349000e+01},
    { 49, 20,  3,  0, 0.72995940e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 20,  3,  1, 0.58448340e+03, 0.29353000e+01, 0.98310000e+00},
    { 49, 20,  3,  2, 0.32180650e+03, 0.29353000e+01, 0.19349000e+01},
    { 49, 21,  0,  0, 0.10458401e+04, 0.00000000e+00, 0.00000000e+00},
    { 49, 21,  0,  1, 0.49219040e+03, 0.00000000e+00, 0.18627000e+01},
    { 49, 21,  0,  2, 0.48100660e+03, 0.00000000e+00, 0.28999000e+01},
    { 49, 21,  1,  0, 0.98084640e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 21,  1,  1, 0.46767000e+03, 0.96330000e+00, 0.18627000e+01},
    { 49, 21,  1,  2, 0.45781840e+03, 0.96330000e+00, 0.28999000e+01},
    { 49, 21,  2,  0, 0.74582820e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 21,  2,  1, 0.37201170e+03, 0.19378000e+01, 0.18627000e+01},
    { 49, 21,  2,  2, 0.36630170e+03, 0.19378000e+01, 0.28999000e+01},
    { 49, 21,  3,  0, 0.60530470e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 21,  3,  1, 0.31379200e+03, 0.29353000e+01, 0.18627000e+01},
    { 49, 21,  3,  2, 0.31041930e+03, 0.29353000e+01, 0.28999000e+01},
    { 49, 22,  0,  0, 0.99909710e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 22,  0,  1, 0.47481120e+03, 0.00000000e+00, 0.18299000e+01},
    { 49, 22,  0,  2, 0.48644970e+03, 0.00000000e+00, 0.38675000e+01},
    { 49, 22,  1,  0, 0.93876410e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 22,  1,  1, 0.45116580e+03, 0.96330000e+00, 0.18299000e+01},
    { 49, 22,  1,  2, 0.46307770e+03, 0.96330000e+00, 0.38675000e+01},
    { 49, 22,  2,  0, 0.71855370e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 22,  2,  1, 0.35910570e+03, 0.19378000e+01, 0.18299000e+01},
    { 49, 22,  2,  2, 0.37073900e+03, 0.19378000e+01, 0.38675000e+01},
    { 49, 22,  3,  0, 0.58657520e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 22,  3,  1, 0.30305660e+03, 0.29353000e+01, 0.18299000e+01},
    { 49, 22,  3,  2, 0.31434380e+03, 0.29353000e+01, 0.38675000e+01},
    { 49, 23,  0,  0, 0.90897530e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 23,  0,  1, 0.46556470e+03, 0.00000000e+00, 0.19138000e+01},
    { 49, 23,  0,  2, 0.44577660e+03, 0.00000000e+00, 0.29110000e+01},
    { 49, 23,  1,  0, 0.85507440e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 23,  1,  1, 0.44234200e+03, 0.96330000e+00, 0.19138000e+01},
    { 49, 23,  1,  2, 0.42422720e+03, 0.96330000e+00, 0.29110000e+01},
    { 49, 23,  2,  0, 0.65710020e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 23,  2,  1, 0.35198070e+03, 0.19378000e+01, 0.19138000e+01},
    { 49, 23,  2,  2, 0.33943990e+03, 0.19378000e+01, 0.29110000e+01},
    { 49, 23,  3,  0, 0.53826720e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 23,  3,  1, 0.29698540e+03, 0.29353000e+01, 0.19138000e+01},
    { 49, 23,  3,  2, 0.28770260e+03, 0.29353000e+01, 0.29110000e+01},
    { 49, 24,  0,  0, 0.71527990e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 24,  0,  1, 0.46283040e+03, 0.00000000e+00, 0.18269000e+01},
    { 49, 24,  0,  2, 0.32878360e+03, 0.00000000e+00, 0.10619100e+02},
    { 49, 24,  1,  0, 0.67285260e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 24,  1,  1, 0.43947280e+03, 0.96330000e+00, 0.18269000e+01},
    { 49, 24,  1,  2, 0.31400260e+03, 0.96330000e+00, 0.10619100e+02},
    { 49, 24,  2,  0, 0.51754970e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 24,  2,  1, 0.34899300e+03, 0.19378000e+01, 0.18269000e+01},
    { 49, 24,  2,  2, 0.25457810e+03, 0.19378000e+01, 0.10619100e+02},
    { 49, 24,  3,  0, 0.42440160e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 24,  3,  1, 0.29398400e+03, 0.29353000e+01, 0.18269000e+01},
    { 49, 24,  3,  2, 0.21815660e+03, 0.29353000e+01, 0.10619100e+02},
    { 49, 25,  0,  0, 0.77527360e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 25,  0,  1, 0.41907070e+03, 0.00000000e+00, 0.16406000e+01},
    { 49, 25,  0,  2, 0.27763500e+03, 0.00000000e+00, 0.98849000e+01},
    { 49, 25,  1,  0, 0.73052210e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 25,  1,  1, 0.39910790e+03, 0.96330000e+00, 0.16406000e+01},
    { 49, 25,  1,  2, 0.26575750e+03, 0.96330000e+00, 0.98849000e+01},
    { 49, 25,  2,  0, 0.56463620e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 25,  2,  1, 0.32004310e+03, 0.19378000e+01, 0.16406000e+01},
    { 49, 25,  2,  2, 0.21724670e+03, 0.19378000e+01, 0.98849000e+01},
    { 49, 25,  3,  0, 0.46484110e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 25,  3,  1, 0.27172730e+03, 0.29353000e+01, 0.16406000e+01},
    { 49, 25,  3,  2, 0.18741200e+03, 0.29353000e+01, 0.98849000e+01},
    { 49, 26,  0,  0, 0.60709640e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 26,  0,  1, 0.38606280e+03, 0.00000000e+00, 0.16483000e+01},
    { 49, 26,  0,  2, 0.27297690e+03, 0.00000000e+00, 0.91376000e+01},
    { 49, 26,  1,  0, 0.57217290e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 26,  1,  1, 0.36795920e+03, 0.96330000e+00, 0.16483000e+01},
    { 49, 26,  1,  2, 0.26122680e+03, 0.96330000e+00, 0.91376000e+01},
    { 49, 26,  2,  0, 0.44298550e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 26,  2,  1, 0.29592090e+03, 0.19378000e+01, 0.16483000e+01},
    { 49, 26,  2,  2, 0.21333730e+03, 0.19378000e+01, 0.91376000e+01},
    { 49, 26,  3,  0, 0.36531290e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 26,  3,  1, 0.25185120e+03, 0.29353000e+01, 0.16483000e+01},
    { 49, 26,  3,  2, 0.18389760e+03, 0.29353000e+01, 0.91376000e+01},
    { 49, 27,  0,  0, 0.63472630e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 27,  0,  1, 0.36832240e+03, 0.00000000e+00, 0.17149000e+01},
    { 49, 27,  0,  2, 0.32688520e+03, 0.00000000e+00, 0.29263000e+01},
    { 49, 27,  0,  3, 0.28692990e+03, 0.00000000e+00, 0.77785000e+01},
    { 49, 27,  1,  0, 0.59982550e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 27,  1,  1, 0.35103000e+03, 0.96330000e+00, 0.17149000e+01},
    { 49, 27,  1,  2, 0.31168130e+03, 0.96330000e+00, 0.29263000e+01},
    { 49, 27,  1,  3, 0.27425370e+03, 0.96330000e+00, 0.77785000e+01},
    { 49, 27,  2,  0, 0.46815800e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 27,  2,  1, 0.28231300e+03, 0.19378000e+01, 0.17149000e+01},
    { 49, 27,  2,  2, 0.25122060e+03, 0.19378000e+01, 0.29263000e+01},
    { 49, 27,  2,  3, 0.22299250e+03, 0.19378000e+01, 0.77785000e+01},
    { 49, 27,  3,  0, 0.38862700e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 27,  3,  1, 0.24028600e+03, 0.29353000e+01, 0.17149000e+01},
    { 49, 27,  3,  2, 0.21424530e+03, 0.29353000e+01, 0.29263000e+01},
    { 49, 27,  3,  3, 0.19153170e+03, 0.29353000e+01, 0.77785000e+01},
    { 49, 28,  0,  0, 0.65825260e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 28,  0,  1, 0.36057310e+03, 0.00000000e+00, 0.17937000e+01},
    { 49, 28,  0,  2, 0.30263410e+03, 0.00000000e+00, 0.65458000e+01},
    { 49, 28,  0,  3, 0.32207710e+03, 0.00000000e+00, 0.62918000e+01},
    { 49, 28,  1,  0, 0.62133050e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 28,  1,  1, 0.34356200e+03, 0.96330000e+00, 0.17937000e+01},
    { 49, 28,  1,  2, 0.28888240e+03, 0.96330000e+00, 0.65458000e+01},
    { 49, 28,  1,  3, 0.30671200e+03, 0.96330000e+00, 0.62918000e+01},
    { 49, 28,  2,  0, 0.48295770e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 28,  2,  1, 0.27608710e+03, 0.19378000e+01, 0.17937000e+01},
    { 49, 28,  2,  2, 0.23374770e+03, 0.19378000e+01, 0.65458000e+01},
    { 49, 28,  2,  3, 0.24615700e+03, 0.19378000e+01, 0.62918000e+01},
    { 49, 28,  3,  0, 0.39951060e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 28,  3,  1, 0.23483900e+03, 0.29353000e+01, 0.17937000e+01},
    { 49, 28,  3,  2, 0.19997120e+03, 0.29353000e+01, 0.65458000e+01},
    { 49, 28,  3,  3, 0.20921040e+03, 0.29353000e+01, 0.62918000e+01},
    { 49, 29,  0,  0, 0.50438020e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 29,  0,  1, 0.36066260e+03, 0.00000000e+00, 0.95760000e+00},
    { 49, 29,  1,  0, 0.47601650e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 29,  1,  1, 0.34289310e+03, 0.96330000e+00, 0.95760000e+00},
    { 49, 29,  2,  0, 0.37028130e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 29,  2,  1, 0.27351670e+03, 0.19378000e+01, 0.95760000e+00},
    { 49, 29,  3,  0, 0.30659770e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 29,  3,  1, 0.23127000e+03, 0.29353000e+01, 0.95760000e+00},
    { 49, 30,  0,  0, 0.50724520e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 30,  0,  1, 0.33095850e+03, 0.00000000e+00, 0.19419000e+01},
    { 49, 30,  1,  0, 0.48059720e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 30,  1,  1, 0.31591660e+03, 0.96330000e+00, 0.19419000e+01},
    { 49, 30,  2,  0, 0.37846340e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 30,  2,  1, 0.25541010e+03, 0.19378000e+01, 0.19419000e+01},
    { 49, 30,  3,  0, 0.31653820e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 30,  3,  1, 0.21830270e+03, 0.29353000e+01, 0.19419000e+01},
    { 49, 31,  0,  0, 0.60471830e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 31,  0,  1, 0.56415640e+03, 0.00000000e+00, 0.96010000e+00},
    { 49, 31,  0,  2, 0.43674070e+03, 0.00000000e+00, 0.19315000e+01},
    { 49, 31,  0,  3, 0.34913300e+03, 0.00000000e+00, 0.29233000e+01},
    { 49, 31,  1,  0, 0.57226580e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 31,  1,  1, 0.53451270e+03, 0.96330000e+00, 0.96010000e+00},
    { 49, 31,  1,  2, 0.41546410e+03, 0.96330000e+00, 0.19315000e+01},
    { 49, 31,  1,  3, 0.33348150e+03, 0.96330000e+00, 0.29233000e+01},
    { 49, 31,  2,  0, 0.44874480e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 31,  2,  1, 0.42085570e+03, 0.19378000e+01, 0.96010000e+00},
    { 49, 31,  2,  2, 0.33179130e+03, 0.19378000e+01, 0.19315000e+01},
    { 49, 31,  2,  3, 0.27009880e+03, 0.19378000e+01, 0.29233000e+01},
    { 49, 31,  3,  0, 0.37394790e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 31,  3,  1, 0.35191540e+03, 0.29353000e+01, 0.96010000e+00},
    { 49, 31,  3,  2, 0.28072610e+03, 0.29353000e+01, 0.19315000e+01},
    { 49, 31,  3,  3, 0.23116180e+03, 0.29353000e+01, 0.29233000e+01},
    { 49, 32,  0,  0, 0.51935010e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 32,  0,  1, 0.48291150e+03, 0.00000000e+00, 0.94340000e+00},
    { 49, 32,  0,  2, 0.45781190e+03, 0.00000000e+00, 0.19447000e+01},
    { 49, 32,  0,  3, 0.40593030e+03, 0.00000000e+00, 0.29186000e+01},
    { 49, 32,  0,  4, 0.35360350e+03, 0.00000000e+00, 0.38972000e+01},
    { 49, 32,  1,  0, 0.49379840e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 32,  1,  1, 0.45962850e+03, 0.96330000e+00, 0.94340000e+00},
    { 49, 32,  1,  2, 0.43605730e+03, 0.96330000e+00, 0.19447000e+01},
    { 49, 32,  1,  3, 0.38734040e+03, 0.96330000e+00, 0.29186000e+01},
    { 49, 32,  1,  4, 0.33818310e+03, 0.96330000e+00, 0.38972000e+01},
    { 49, 32,  2,  0, 0.39348230e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 32,  2,  1, 0.36762820e+03, 0.19378000e+01, 0.94340000e+00},
    { 49, 32,  2,  2, 0.34968000e+03, 0.19378000e+01, 0.19447000e+01},
    { 49, 32,  2,  3, 0.31261830e+03, 0.19378000e+01, 0.29186000e+01},
    { 49, 32,  2,  4, 0.27516580e+03, 0.19378000e+01, 0.38972000e+01},
    { 49, 32,  3,  0, 0.33229320e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 32,  3,  1, 0.31142600e+03, 0.29353000e+01, 0.94340000e+00},
    { 49, 32,  3,  2, 0.29685620e+03, 0.29353000e+01, 0.19447000e+01},
    { 49, 32,  3,  3, 0.26679440e+03, 0.29353000e+01, 0.29186000e+01},
    { 49, 32,  3,  4, 0.23637610e+03, 0.29353000e+01, 0.38972000e+01},
    { 49, 33,  0,  0, 0.43261670e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 33,  0,  1, 0.42470080e+03, 0.00000000e+00, 0.98890000e+00},
    { 49, 33,  0,  2, 0.41255410e+03, 0.00000000e+00, 0.19793000e+01},
    { 49, 33,  0,  3, 0.39591570e+03, 0.00000000e+00, 0.29709000e+01},
    { 49, 33,  1,  0, 0.41301260e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 33,  1,  1, 0.40554530e+03, 0.96330000e+00, 0.98890000e+00},
    { 49, 33,  1,  2, 0.39410730e+03, 0.96330000e+00, 0.19793000e+01},
    { 49, 33,  1,  3, 0.37845390e+03, 0.96330000e+00, 0.29709000e+01},
    { 49, 33,  2,  0, 0.33391140e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 33,  2,  1, 0.32815180e+03, 0.19378000e+01, 0.98890000e+00},
    { 49, 33,  2,  2, 0.31937190e+03, 0.19378000e+01, 0.19793000e+01},
    { 49, 33,  2,  3, 0.30738320e+03, 0.19378000e+01, 0.29709000e+01},
    { 49, 33,  3,  0, 0.28535990e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 33,  3,  1, 0.28063500e+03, 0.29353000e+01, 0.98890000e+00},
    { 49, 33,  3,  2, 0.27345920e+03, 0.29353000e+01, 0.19793000e+01},
    { 49, 33,  3,  3, 0.26367810e+03, 0.29353000e+01, 0.29709000e+01},
    { 49, 34,  0,  0, 0.38259680e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 34,  0,  1, 0.38283810e+03, 0.00000000e+00, 0.99010000e+00},
    { 49, 34,  0,  2, 0.37968440e+03, 0.00000000e+00, 0.19812000e+01},
    { 49, 34,  1,  0, 0.36615190e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 34,  1,  1, 0.36636520e+03, 0.96330000e+00, 0.99010000e+00},
    { 49, 34,  1,  2, 0.36336970e+03, 0.96330000e+00, 0.19812000e+01},
    { 49, 34,  2,  0, 0.29869330e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 34,  2,  1, 0.29882440e+03, 0.19378000e+01, 0.99010000e+00},
    { 49, 34,  2,  2, 0.29645520e+03, 0.19378000e+01, 0.19812000e+01},
    { 49, 34,  3,  0, 0.25714220e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 34,  3,  1, 0.25722750e+03, 0.29353000e+01, 0.99010000e+00},
    { 49, 34,  3,  2, 0.25524180e+03, 0.29353000e+01, 0.19812000e+01},
    { 49, 35,  0,  0, 0.32992500e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 35,  0,  1, 0.33247910e+03, 0.00000000e+00, 0.99740000e+00},
    { 49, 35,  1,  0, 0.31652310e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 35,  1,  1, 0.31893050e+03, 0.96330000e+00, 0.99740000e+00},
    { 49, 35,  2,  0, 0.26059250e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 35,  2,  1, 0.26244940e+03, 0.19378000e+01, 0.99740000e+00},
    { 49, 35,  3,  0, 0.22602240e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 35,  3,  1, 0.22754720e+03, 0.29353000e+01, 0.99740000e+00},
    { 49, 36,  0,  0, 0.28312690e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 36,  1,  0, 0.27222880e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 36,  2,  0, 0.22602150e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 36,  3,  0, 0.19737620e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 37,  0,  0, 0.18285696e+04, 0.00000000e+00, 0.00000000e+00},
    { 49, 37,  0,  1, 0.59989870e+03, 0.00000000e+00, 0.97380000e+00},
    { 49, 37,  1,  0, 0.16942091e+04, 0.96330000e+00, 0.00000000e+00},
    { 49, 37,  1,  1, 0.56760020e+03, 0.96330000e+00, 0.97380000e+00},
    { 49, 37,  2,  0, 0.12430036e+04, 0.19378000e+01, 0.00000000e+00},
    { 49, 37,  2,  1, 0.44576050e+03, 0.19378000e+01, 0.97380000e+00},
    { 49, 37,  3,  0, 0.97661940e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 37,  3,  1, 0.37215270e+03, 0.29353000e+01, 0.97380000e+00},
    { 49, 38,  0,  0, 0.15296862e+04, 0.00000000e+00, 0.00000000e+00},
    { 49, 38,  0,  1, 0.12501173e+04, 0.00000000e+00, 0.98010000e+00},
    { 49, 38,  0,  2, 0.60681450e+03, 0.00000000e+00, 0.19143000e+01},
    { 49, 38,  1,  0, 0.14306640e+04, 0.96330000e+00, 0.00000000e+00},
    { 49, 38,  1,  1, 0.11685036e+04, 0.96330000e+00, 0.98010000e+00},
    { 49, 38,  1,  2, 0.57628960e+03, 0.96330000e+00, 0.19143000e+01},
    { 49, 38,  2,  0, 0.10788447e+04, 0.19378000e+01, 0.00000000e+00},
    { 49, 38,  2,  1, 0.88157390e+03, 0.19378000e+01, 0.98010000e+00},
    { 49, 38,  2,  2, 0.45781020e+03, 0.19378000e+01, 0.19143000e+01},
    { 49, 38,  3,  0, 0.86927450e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 38,  3,  1, 0.71067900e+03, 0.29353000e+01, 0.98010000e+00},
    { 49, 38,  3,  2, 0.38575940e+03, 0.29353000e+01, 0.19143000e+01},
    { 49, 39,  0,  0, 0.13118922e+04, 0.00000000e+00, 0.00000000e+00},
    { 49, 39,  0,  1, 0.91615920e+03, 0.00000000e+00, 0.19153000e+01},
    { 49, 39,  0,  2, 0.57380210e+03, 0.00000000e+00, 0.28903000e+01},
    { 49, 39,  1,  0, 0.12316979e+04, 0.96330000e+00, 0.00000000e+00},
    { 49, 39,  1,  1, 0.86288330e+03, 0.96330000e+00, 0.19153000e+01},
    { 49, 39,  1,  2, 0.54666900e+03, 0.96330000e+00, 0.28903000e+01},
    { 49, 39,  2,  0, 0.94063630e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 39,  2,  1, 0.66764710e+03, 0.19378000e+01, 0.19153000e+01},
    { 49, 39,  2,  2, 0.43894830e+03, 0.19378000e+01, 0.28903000e+01},
    { 49, 39,  3,  0, 0.76640590e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 39,  3,  1, 0.55021640e+03, 0.29353000e+01, 0.19153000e+01},
    { 49, 39,  3,  2, 0.37308750e+03, 0.29353000e+01, 0.28903000e+01},
    { 49, 40,  0,  0, 0.11635963e+04, 0.00000000e+00, 0.00000000e+00},
    { 49, 40,  0,  1, 0.65256540e+03, 0.00000000e+00, 0.19355000e+01},
    { 49, 40,  0,  2, 0.57580200e+03, 0.00000000e+00, 0.39106000e+01},
    { 49, 40,  1,  0, 0.10950419e+04, 0.96330000e+00, 0.00000000e+00},
    { 49, 40,  1,  1, 0.61965370e+03, 0.96330000e+00, 0.19355000e+01},
    { 49, 40,  1,  2, 0.54905720e+03, 0.96330000e+00, 0.39106000e+01},
    { 49, 40,  2,  0, 0.84295940e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 40,  2,  1, 0.49222910e+03, 0.19378000e+01, 0.19355000e+01},
    { 49, 40,  2,  2, 0.44222600e+03, 0.19378000e+01, 0.39106000e+01},
    { 49, 40,  3,  0, 0.69159970e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 40,  3,  1, 0.41478140e+03, 0.29353000e+01, 0.19355000e+01},
    { 49, 40,  3,  2, 0.37681730e+03, 0.29353000e+01, 0.39106000e+01},
    { 49, 41,  0,  0, 0.10518917e+04, 0.00000000e+00, 0.00000000e+00},
    { 49, 41,  0,  1, 0.65928650e+03, 0.00000000e+00, 0.19545000e+01},
    { 49, 41,  0,  2, 0.55793400e+03, 0.00000000e+00, 0.29225000e+01},
    { 49, 41,  1,  0, 0.99140130e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 41,  1,  1, 0.62602540e+03, 0.96330000e+00, 0.19545000e+01},
    { 49, 41,  1,  2, 0.53177200e+03, 0.96330000e+00, 0.29225000e+01},
    { 49, 41,  2,  0, 0.76722430e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 41,  2,  1, 0.49713820e+03, 0.19378000e+01, 0.19545000e+01},
    { 49, 41,  2,  2, 0.42786320e+03, 0.19378000e+01, 0.29225000e+01},
    { 49, 41,  3,  0, 0.63235800e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 41,  3,  1, 0.41884820e+03, 0.29353000e+01, 0.19545000e+01},
    { 49, 41,  3,  2, 0.36432260e+03, 0.29353000e+01, 0.29225000e+01},
    { 49, 42,  0,  0, 0.79999940e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 42,  0,  1, 0.61139110e+03, 0.00000000e+00, 0.19420000e+01},
    { 49, 42,  0,  2, 0.48621160e+03, 0.00000000e+00, 0.11055600e+02},
    { 49, 42,  1,  0, 0.75589180e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 42,  1,  1, 0.58105490e+03, 0.96330000e+00, 0.19420000e+01},
    { 49, 42,  1,  2, 0.46456790e+03, 0.96330000e+00, 0.11055600e+02},
    { 49, 42,  2,  0, 0.59040500e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 42,  2,  1, 0.46306700e+03, 0.19378000e+01, 0.19420000e+01},
    { 49, 42,  2,  2, 0.37713750e+03, 0.19378000e+01, 0.11055600e+02},
    { 49, 42,  3,  0, 0.49057200e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 42,  3,  1, 0.39127220e+03, 0.29353000e+01, 0.19420000e+01},
    { 49, 42,  3,  2, 0.32348820e+03, 0.29353000e+01, 0.11055600e+02},
    { 49, 43,  0,  0, 0.89764510e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 43,  0,  1, 0.70042290e+03, 0.00000000e+00, 0.16682000e+01},
    { 49, 43,  0,  2, 0.42431450e+03, 0.00000000e+00, 0.95402000e+01},
    { 49, 43,  1,  0, 0.84735570e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 43,  1,  1, 0.66303800e+03, 0.96330000e+00, 0.16682000e+01},
    { 49, 43,  1,  2, 0.40621170e+03, 0.96330000e+00, 0.95402000e+01},
    { 49, 43,  2,  0, 0.65957470e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 43,  2,  1, 0.52169780e+03, 0.19378000e+01, 0.16682000e+01},
    { 49, 43,  2,  2, 0.33210880e+03, 0.19378000e+01, 0.95402000e+01},
    { 49, 43,  3,  0, 0.54639300e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 43,  3,  1, 0.43621610e+03, 0.29353000e+01, 0.16682000e+01},
    { 49, 43,  3,  2, 0.28650850e+03, 0.29353000e+01, 0.95402000e+01},
    { 49, 44,  0,  0, 0.67265160e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 44,  0,  1, 0.52482360e+03, 0.00000000e+00, 0.18584000e+01},
    { 49, 44,  0,  2, 0.39931090e+03, 0.00000000e+00, 0.88895000e+01},
    { 49, 44,  1,  0, 0.63674800e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 44,  1,  1, 0.50016280e+03, 0.96330000e+00, 0.18584000e+01},
    { 49, 44,  1,  2, 0.38254570e+03, 0.96330000e+00, 0.88895000e+01},
    { 49, 44,  2,  0, 0.50072770e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 44,  2,  1, 0.40238250e+03, 0.19378000e+01, 0.18584000e+01},
    { 49, 44,  2,  2, 0.31358880e+03, 0.19378000e+01, 0.88895000e+01},
    { 49, 44,  3,  0, 0.41848510e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 44,  3,  1, 0.34263080e+03, 0.29353000e+01, 0.18584000e+01},
    { 49, 44,  3,  2, 0.27111330e+03, 0.29353000e+01, 0.88895000e+01},
    { 49, 45,  0,  0, 0.73525250e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 45,  0,  1, 0.49033250e+03, 0.00000000e+00, 0.19003000e+01},
    { 49, 45,  0,  2, 0.41228890e+03, 0.00000000e+00, 0.29696000e+01},
    { 49, 45,  1,  0, 0.69613210e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 45,  1,  1, 0.46737710e+03, 0.96330000e+00, 0.19003000e+01},
    { 49, 45,  1,  2, 0.39403700e+03, 0.96330000e+00, 0.29696000e+01},
    { 49, 45,  2,  0, 0.54733000e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 45,  2,  1, 0.37636250e+03, 0.19378000e+01, 0.19003000e+01},
    { 49, 45,  2,  2, 0.32040110e+03, 0.19378000e+01, 0.29696000e+01},
    { 49, 45,  3,  0, 0.45727800e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 45,  3,  1, 0.32074540e+03, 0.29353000e+01, 0.19003000e+01},
    { 49, 45,  3,  2, 0.27523510e+03, 0.29353000e+01, 0.29696000e+01},
    { 49, 46,  0,  0, 0.67809960e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 46,  0,  1, 0.45405760e+03, 0.00000000e+00, 0.18630000e+01},
    { 49, 46,  0,  2, 0.43231830e+03, 0.00000000e+00, 0.57095000e+01},
    { 49, 46,  1,  0, 0.64264560e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 46,  1,  1, 0.43299730e+03, 0.96330000e+00, 0.18630000e+01},
    { 49, 46,  1,  2, 0.41294080e+03, 0.96330000e+00, 0.57095000e+01},
    { 49, 46,  2,  0, 0.50698660e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 46,  2,  1, 0.34931490e+03, 0.19378000e+01, 0.18630000e+01},
    { 49, 46,  2,  2, 0.33498740e+03, 0.19378000e+01, 0.57095000e+01},
    { 49, 46,  3,  0, 0.42477830e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 46,  3,  1, 0.29815620e+03, 0.29353000e+01, 0.18630000e+01},
    { 49, 46,  3,  2, 0.28720260e+03, 0.29353000e+01, 0.57095000e+01},
    { 49, 47,  0,  0, 0.56733030e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 47,  0,  1, 0.44027330e+03, 0.00000000e+00, 0.96790000e+00},
    { 49, 47,  1,  0, 0.53720580e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 47,  1,  1, 0.41968680e+03, 0.96330000e+00, 0.96790000e+00},
    { 49, 47,  2,  0, 0.42310210e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 47,  2,  1, 0.33811650e+03, 0.19378000e+01, 0.96790000e+00},
    { 49, 47,  3,  0, 0.35412210e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 47,  3,  1, 0.28828650e+03, 0.29353000e+01, 0.96790000e+00},
    { 49, 48,  0,  0, 0.59335740e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 48,  0,  1, 0.43036070e+03, 0.00000000e+00, 0.19539000e+01},
    { 49, 48,  1,  0, 0.56303120e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 48,  1,  1, 0.41115760e+03, 0.96330000e+00, 0.19539000e+01},
    { 49, 48,  2,  0, 0.44611840e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 48,  2,  1, 0.33364080e+03, 0.19378000e+01, 0.19539000e+01},
    { 49, 48,  3,  0, 0.37514860e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 48,  3,  1, 0.28607710e+03, 0.29353000e+01, 0.19539000e+01},
    { 49, 49,  0,  0, 0.75773970e+03, 0.00000000e+00, 0.00000000e+00},
    { 49, 49,  1,  0, 0.71679570e+03, 0.96330000e+00, 0.00000000e+00},
    { 49, 49,  1,  1, 0.67899200e+03, 0.96330000e+00, 0.96330000e+00},
    { 49, 49,  2,  0, 0.56190060e+03, 0.19378000e+01, 0.00000000e+00},
    { 49, 49,  2,  1, 0.53472480e+03, 0.19378000e+01, 0.96330000e+00},
    { 49, 49,  2,  2, 0.42791400e+03, 0.19378000e+01, 0.19378000e+01},
    { 49, 49,  3,  0, 0.46825210e+03, 0.29353000e+01, 0.00000000e+00},
    { 49, 49,  3,  1, 0.44732690e+03, 0.29353000e+01, 0.96330000e+00},
    { 49, 49,  3,  2, 0.36275140e+03, 0.29353000e+01, 0.19378000e+01},
    { 49, 49,  3,  3, 0.31083150e+03, 0.29353000e+01, 0.29353000e+01},
    { 50,  1,  0,  0, 0.41533400e+02, 0.00000000e+00, 0.91180000e+00},
    { 50,  1,  0,  1, 0.67943000e+02, 0.00000000e+00, 0.00000000e+00},
    { 50,  1,  1,  0, 0.39050000e+02, 0.95140000e+00, 0.91180000e+00},
    { 50,  1,  1,  1, 0.63518900e+02, 0.95140000e+00, 0.00000000e+00},
    { 50,  1,  2,  0, 0.37912200e+02, 0.19505000e+01, 0.91180000e+00},
    { 50,  1,  2,  1, 0.61486800e+02, 0.19505000e+01, 0.00000000e+00},
    { 50,  1,  3,  0, 0.34550300e+02, 0.29259000e+01, 0.91180000e+00},
    { 50,  1,  3,  1, 0.55564300e+02, 0.29259000e+01, 0.00000000e+00},
    { 50,  1,  4,  0, 0.31602000e+02, 0.39123000e+01, 0.91180000e+00},
    { 50,  1,  4,  1, 0.50394000e+02, 0.39123000e+01, 0.00000000e+00},
    { 50,  2,  0,  0, 0.26786200e+02, 0.00000000e+00, 0.00000000e+00},
    { 50,  2,  1,  0, 0.25410500e+02, 0.95140000e+00, 0.00000000e+00},
    { 50,  2,  2,  0, 0.24783300e+02, 0.19505000e+01, 0.00000000e+00},
    { 50,  2,  3,  0, 0.22887500e+02, 0.29259000e+01, 0.00000000e+00},
    { 50,  2,  4,  0, 0.21215400e+02, 0.39123000e+01, 0.00000000e+00},
    { 50,  3,  0,  0, 0.70845970e+03, 0.00000000e+00, 0.00000000e+00},
    { 50,  3,  0,  1, 0.22808140e+03, 0.00000000e+00, 0.98650000e+00},
    { 50,  3,  1,  0, 0.64241900e+03, 0.95140000e+00, 0.00000000e+00},
    { 50,  3,  1,  1, 0.21038150e+03, 0.95140000e+00, 0.98650000e+00},
    { 50,  3,  2,  0, 0.61156120e+03, 0.19505000e+01, 0.00000000e+00},
    { 50,  3,  2,  1, 0.20220530e+03, 0.19505000e+01, 0.98650000e+00},
    { 50,  3,  3,  0, 0.52718510e+03, 0.29259000e+01, 0.00000000e+00},
    { 50,  3,  3,  1, 0.17907060e+03, 0.29259000e+01, 0.98650000e+00},
    { 50,  3,  4,  0, 0.45591990e+03, 0.39123000e+01, 0.00000000e+00},
    { 50,  3,  4,  1, 0.15913760e+03, 0.39123000e+01, 0.98650000e+00},
    { 50,  4,  0,  0, 0.39379910e+03, 0.00000000e+00, 0.00000000e+00},
    { 50,  4,  0,  1, 0.28947130e+03, 0.00000000e+00, 0.98080000e+00},
    { 50,  4,  0,  2, 0.18468490e+03, 0.00000000e+00, 0.19697000e+01},
    { 50,  4,  1,  0, 0.36274340e+03, 0.95140000e+00, 0.00000000e+00},
    { 50,  4,  1,  1, 0.26750360e+03, 0.95140000e+00, 0.98080000e+00},
    { 50,  4,  1,  2, 0.17217670e+03, 0.95140000e+00, 0.19697000e+01},
    { 50,  4,  2,  0, 0.34839490e+03, 0.19505000e+01, 0.00000000e+00},
    { 50,  4,  2,  1, 0.25735510e+03, 0.19505000e+01, 0.98080000e+00},
    { 50,  4,  2,  2, 0.16642480e+03, 0.19505000e+01, 0.19697000e+01},
    { 50,  4,  3,  0, 0.30788140e+03, 0.29259000e+01, 0.00000000e+00},
    { 50,  4,  3,  1, 0.22855840e+03, 0.29259000e+01, 0.98080000e+00},
    { 50,  4,  3,  2, 0.14976800e+03, 0.29259000e+01, 0.19697000e+01},
    { 50,  4,  4,  0, 0.27300460e+03, 0.39123000e+01, 0.00000000e+00},
    { 50,  4,  4,  1, 0.20372270e+03, 0.39123000e+01, 0.98080000e+00},
    { 50,  4,  4,  2, 0.13526050e+03, 0.39123000e+01, 0.19697000e+01},
    { 50,  5,  0,  0, 0.25871460e+03, 0.00000000e+00, 0.00000000e+00},
    { 50,  5,  0,  1, 0.21642760e+03, 0.00000000e+00, 0.97060000e+00},
    { 50,  5,  0,  2, 0.18069960e+03, 0.00000000e+00, 0.19441000e+01},
    { 50,  5,  0,  3, 0.13544390e+03, 0.00000000e+00, 0.29128000e+01},
    { 50,  5,  0,  4, 0.12715210e+03, 0.00000000e+00, 0.45856000e+01},
    { 50,  5,  1,  0, 0.24059340e+03, 0.95140000e+00, 0.00000000e+00},
    { 50,  5,  1,  1, 0.20167580e+03, 0.95140000e+00, 0.97060000e+00},
    { 50,  5,  1,  2, 0.16872480e+03, 0.95140000e+00, 0.19441000e+01},
    { 50,  5,  1,  3, 0.12714090e+03, 0.95140000e+00, 0.29128000e+01},
    { 50,  5,  1,  4, 0.11945590e+03, 0.95140000e+00, 0.45856000e+01},
    { 50,  5,  2,  0, 0.23225130e+03, 0.19505000e+01, 0.00000000e+00},
    { 50,  5,  2,  1, 0.19488950e+03, 0.19505000e+01, 0.97060000e+00},
    { 50,  5,  2,  2, 0.16321840e+03, 0.19505000e+01, 0.19441000e+01},
    { 50,  5,  2,  3, 0.12333400e+03, 0.19505000e+01, 0.29128000e+01},
    { 50,  5,  2,  4, 0.11592860e+03, 0.19505000e+01, 0.45856000e+01},
    { 50,  5,  3,  0, 0.20823790e+03, 0.29259000e+01, 0.00000000e+00},
    { 50,  5,  3,  1, 0.17527450e+03, 0.29259000e+01, 0.97060000e+00},
    { 50,  5,  3,  2, 0.14723850e+03, 0.29259000e+01, 0.19441000e+01},
    { 50,  5,  3,  3, 0.11213310e+03, 0.29259000e+01, 0.29128000e+01},
    { 50,  5,  3,  4, 0.10552950e+03, 0.29259000e+01, 0.45856000e+01},
    { 50,  5,  4,  0, 0.18738080e+03, 0.39123000e+01, 0.00000000e+00},
    { 50,  5,  4,  1, 0.15821370e+03, 0.39123000e+01, 0.97060000e+00},
    { 50,  5,  4,  2, 0.13332140e+03, 0.39123000e+01, 0.19441000e+01},
    { 50,  5,  4,  3, 0.10232470e+03, 0.39123000e+01, 0.29128000e+01},
    { 50,  5,  4,  4, 0.96417900e+02, 0.39123000e+01, 0.45856000e+01},
    { 50,  6,  0,  0, 0.17143670e+03, 0.00000000e+00, 0.00000000e+00},
    { 50,  6,  0,  1, 0.16079100e+03, 0.00000000e+00, 0.98680000e+00},
    { 50,  6,  0,  2, 0.13007660e+03, 0.00000000e+00, 0.19985000e+01},
    { 50,  6,  0,  3, 0.12165980e+03, 0.00000000e+00, 0.29987000e+01},
    { 50,  6,  0,  4, 0.98343100e+02, 0.00000000e+00, 0.39844000e+01},
    { 50,  6,  1,  0, 0.16058760e+03, 0.95140000e+00, 0.00000000e+00},
    { 50,  6,  1,  1, 0.15060400e+03, 0.95140000e+00, 0.98680000e+00},
    { 50,  6,  1,  2, 0.12220300e+03, 0.95140000e+00, 0.19985000e+01},
    { 50,  6,  1,  3, 0.11430720e+03, 0.95140000e+00, 0.29987000e+01},
    { 50,  6,  1,  4, 0.92802100e+02, 0.95140000e+00, 0.39844000e+01},
    { 50,  6,  2,  0, 0.15560830e+03, 0.19505000e+01, 0.00000000e+00},
    { 50,  6,  2,  1, 0.14592740e+03, 0.19505000e+01, 0.98680000e+00},
    { 50,  6,  2,  2, 0.11859420e+03, 0.19505000e+01, 0.19985000e+01},
    { 50,  6,  2,  3, 0.11093720e+03, 0.19505000e+01, 0.29987000e+01},
    { 50,  6,  2,  4, 0.90268300e+02, 0.19505000e+01, 0.39844000e+01},
    { 50,  6,  3,  0, 0.14104070e+03, 0.29259000e+01, 0.00000000e+00},
    { 50,  6,  3,  1, 0.13225620e+03, 0.29259000e+01, 0.98680000e+00},
    { 50,  6,  3,  2, 0.10796360e+03, 0.29259000e+01, 0.19985000e+01},
    { 50,  6,  3,  3, 0.10101310e+03, 0.29259000e+01, 0.29987000e+01},
    { 50,  6,  3,  4, 0.82717000e+02, 0.29259000e+01, 0.39844000e+01},
    { 50,  6,  4,  0, 0.12831130e+03, 0.39123000e+01, 0.00000000e+00},
    { 50,  6,  4,  1, 0.12031900e+03, 0.39123000e+01, 0.98680000e+00},
    { 50,  6,  4,  2, 0.98654000e+02, 0.39123000e+01, 0.19985000e+01},
    { 50,  6,  4,  3, 0.92326000e+02, 0.39123000e+01, 0.29987000e+01},
    { 50,  6,  4,  4, 0.76081000e+02, 0.39123000e+01, 0.39844000e+01},
    { 50,  7,  0,  0, 0.11815090e+03, 0.00000000e+00, 0.00000000e+00},
    { 50,  7,  0,  1, 0.11009510e+03, 0.00000000e+00, 0.99440000e+00},
    { 50,  7,  0,  2, 0.10321130e+03, 0.00000000e+00, 0.20143000e+01},
    { 50,  7,  0,  3, 0.90687600e+02, 0.00000000e+00, 0.29903000e+01},
    { 50,  7,  1,  0, 0.11127680e+03, 0.95140000e+00, 0.00000000e+00},
    { 50,  7,  1,  1, 0.10370700e+03, 0.95140000e+00, 0.99440000e+00},
    { 50,  7,  1,  2, 0.97282600e+02, 0.95140000e+00, 0.20143000e+01},
    { 50,  7,  1,  3, 0.85547900e+02, 0.95140000e+00, 0.29903000e+01},
    { 50,  7,  2,  0, 0.10812990e+03, 0.19505000e+01, 0.00000000e+00},
    { 50,  7,  2,  1, 0.10078260e+03, 0.19505000e+01, 0.99440000e+00},
    { 50,  7,  2,  2, 0.94569600e+02, 0.19505000e+01, 0.20143000e+01},
    { 50,  7,  2,  3, 0.83196800e+02, 0.19505000e+01, 0.29903000e+01},
    { 50,  7,  3,  0, 0.98802500e+02, 0.29259000e+01, 0.00000000e+00},
    { 50,  7,  3,  1, 0.92115400e+02, 0.29259000e+01, 0.99440000e+00},
    { 50,  7,  3,  2, 0.86517400e+02, 0.29259000e+01, 0.20143000e+01},
    { 50,  7,  3,  3, 0.76210000e+02, 0.29259000e+01, 0.29903000e+01},
    { 50,  7,  4,  0, 0.90618400e+02, 0.39123000e+01, 0.00000000e+00},
    { 50,  7,  4,  1, 0.84513800e+02, 0.39123000e+01, 0.99440000e+00},
    { 50,  7,  4,  2, 0.79452200e+02, 0.39123000e+01, 0.20143000e+01},
    { 50,  7,  4,  3, 0.70080000e+02, 0.39123000e+01, 0.29903000e+01},
    { 50,  8,  0,  0, 0.88540800e+02, 0.00000000e+00, 0.00000000e+00},
    { 50,  8,  0,  1, 0.79170400e+02, 0.00000000e+00, 0.99250000e+00},
    { 50,  8,  0,  2, 0.69604600e+02, 0.00000000e+00, 0.19887000e+01},
    { 50,  8,  1,  0, 0.83712000e+02, 0.95140000e+00, 0.00000000e+00},
    { 50,  8,  1,  1, 0.74928900e+02, 0.95140000e+00, 0.99250000e+00},
    { 50,  8,  1,  2, 0.65963500e+02, 0.95140000e+00, 0.19887000e+01},
    { 50,  8,  2,  0, 0.81505800e+02, 0.19505000e+01, 0.00000000e+00},
    { 50,  8,  2,  1, 0.72992300e+02, 0.19505000e+01, 0.99250000e+00},
    { 50,  8,  2,  2, 0.64302200e+02, 0.19505000e+01, 0.19887000e+01},
    { 50,  8,  3,  0, 0.74902900e+02, 0.29259000e+01, 0.00000000e+00},
    { 50,  8,  3,  1, 0.67181100e+02, 0.29259000e+01, 0.99250000e+00},
    { 50,  8,  3,  2, 0.59302900e+02, 0.29259000e+01, 0.19887000e+01},
    { 50,  8,  4,  0, 0.69093900e+02, 0.39123000e+01, 0.00000000e+00},
    { 50,  8,  4,  1, 0.62066500e+02, 0.39123000e+01, 0.99250000e+00},
    { 50,  8,  4,  2, 0.54900500e+02, 0.39123000e+01, 0.19887000e+01},
    { 50,  9,  0,  0, 0.66499600e+02, 0.00000000e+00, 0.00000000e+00},
    { 50,  9,  0,  1, 0.53624300e+02, 0.00000000e+00, 0.99820000e+00},
    { 50,  9,  1,  0, 0.63080600e+02, 0.95140000e+00, 0.00000000e+00},
    { 50,  9,  1,  1, 0.51049200e+02, 0.95140000e+00, 0.99820000e+00},
    { 50,  9,  2,  0, 0.61521400e+02, 0.19505000e+01, 0.00000000e+00},
    { 50,  9,  2,  1, 0.49877800e+02, 0.19505000e+01, 0.99820000e+00},
    { 50,  9,  3,  0, 0.56815100e+02, 0.29259000e+01, 0.00000000e+00},
    { 50,  9,  3,  1, 0.46303000e+02, 0.29259000e+01, 0.99820000e+00},
    { 50,  9,  4,  0, 0.52666100e+02, 0.39123000e+01, 0.00000000e+00},
    { 50,  9,  4,  1, 0.43143200e+02, 0.39123000e+01, 0.99820000e+00},
    { 50, 10,  0,  0, 0.50811000e+02, 0.00000000e+00, 0.00000000e+00},
    { 50, 10,  1,  0, 0.48325800e+02, 0.95140000e+00, 0.00000000e+00},
    { 50, 10,  2,  0, 0.47194200e+02, 0.19505000e+01, 0.00000000e+00},
    { 50, 10,  3,  0, 0.43755600e+02, 0.29259000e+01, 0.00000000e+00},
    { 50, 10,  4,  0, 0.40719500e+02, 0.39123000e+01, 0.00000000e+00},
    { 50, 11,  0,  0, 0.84513480e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 11,  0,  1, 0.33470230e+03, 0.00000000e+00, 0.96840000e+00},
    { 50, 11,  1,  0, 0.76709550e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 11,  1,  1, 0.30824700e+03, 0.95140000e+00, 0.96840000e+00},
    { 50, 11,  2,  0, 0.73065870e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 11,  2,  1, 0.29601550e+03, 0.19505000e+01, 0.96840000e+00},
    { 50, 11,  3,  0, 0.63086870e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 11,  3,  1, 0.26154000e+03, 0.29259000e+01, 0.96840000e+00},
    { 50, 11,  4,  0, 0.54650960e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 11,  4,  1, 0.23190190e+03, 0.39123000e+01, 0.96840000e+00},
    { 50, 12,  0,  0, 0.63194340e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 12,  0,  1, 0.51865180e+03, 0.00000000e+00, 0.96280000e+00},
    { 50, 12,  0,  2, 0.33128280e+03, 0.00000000e+00, 0.19496000e+01},
    { 50, 12,  1,  0, 0.58045000e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 12,  1,  1, 0.47728480e+03, 0.95140000e+00, 0.96280000e+00},
    { 50, 12,  1,  2, 0.30754750e+03, 0.95140000e+00, 0.19496000e+01},
    { 50, 12,  2,  0, 0.55662410e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 12,  2,  1, 0.45814250e+03, 0.19505000e+01, 0.96280000e+00},
    { 50, 12,  2,  2, 0.29661470e+03, 0.19505000e+01, 0.19496000e+01},
    { 50, 12,  3,  0, 0.48975320e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 12,  3,  1, 0.40427630e+03, 0.29259000e+01, 0.96280000e+00},
    { 50, 12,  3,  2, 0.26525750e+03, 0.29259000e+01, 0.19496000e+01},
    { 50, 12,  4,  0, 0.43237650e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 12,  4,  1, 0.35800890e+03, 0.39123000e+01, 0.96280000e+00},
    { 50, 12,  4,  2, 0.23805490e+03, 0.39123000e+01, 0.19496000e+01},
    { 50, 13,  0,  0, 0.57540180e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 13,  0,  1, 0.51984240e+03, 0.00000000e+00, 0.96480000e+00},
    { 50, 13,  0,  2, 0.40078940e+03, 0.00000000e+00, 0.19311000e+01},
    { 50, 13,  0,  3, 0.30808400e+03, 0.00000000e+00, 0.29146000e+01},
    { 50, 13,  1,  0, 0.53107940e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 13,  1,  1, 0.48037350e+03, 0.95140000e+00, 0.96480000e+00},
    { 50, 13,  1,  2, 0.37187790e+03, 0.95140000e+00, 0.19311000e+01},
    { 50, 13,  1,  3, 0.28733370e+03, 0.95140000e+00, 0.29146000e+01},
    { 50, 13,  2,  0, 0.51060870e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 13,  2,  1, 0.46215210e+03, 0.19505000e+01, 0.96480000e+00},
    { 50, 13,  2,  2, 0.35855000e+03, 0.19505000e+01, 0.19311000e+01},
    { 50, 13,  2,  3, 0.27779270e+03, 0.19505000e+01, 0.29146000e+01},
    { 50, 13,  3,  0, 0.45261920e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 13,  3,  1, 0.41041760e+03, 0.29259000e+01, 0.96480000e+00},
    { 50, 13,  3,  2, 0.32039240e+03, 0.29259000e+01, 0.19311000e+01},
    { 50, 13,  3,  3, 0.25014210e+03, 0.29259000e+01, 0.29146000e+01},
    { 50, 13,  4,  0, 0.40262520e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 13,  4,  1, 0.36577110e+03, 0.39123000e+01, 0.96480000e+00},
    { 50, 13,  4,  2, 0.28733370e+03, 0.39123000e+01, 0.19311000e+01},
    { 50, 13,  4,  3, 0.22605040e+03, 0.39123000e+01, 0.29146000e+01},
    { 50, 14,  0,  0, 0.44576230e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 14,  0,  1, 0.41089600e+03, 0.00000000e+00, 0.95070000e+00},
    { 50, 14,  0,  2, 0.38122300e+03, 0.00000000e+00, 0.19435000e+01},
    { 50, 14,  0,  3, 0.37207850e+03, 0.00000000e+00, 0.29407000e+01},
    { 50, 14,  0,  4, 0.30248790e+03, 0.00000000e+00, 0.38677000e+01},
    { 50, 14,  1,  0, 0.41414030e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 14,  1,  1, 0.38212550e+03, 0.95140000e+00, 0.95070000e+00},
    { 50, 14,  1,  2, 0.35486870e+03, 0.95140000e+00, 0.19435000e+01},
    { 50, 14,  1,  3, 0.34614310e+03, 0.95140000e+00, 0.29407000e+01},
    { 50, 14,  1,  4, 0.28266840e+03, 0.95140000e+00, 0.38677000e+01},
    { 50, 14,  2,  0, 0.39957740e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 14,  2,  1, 0.36887960e+03, 0.19505000e+01, 0.95070000e+00},
    { 50, 14,  2,  2, 0.34274070e+03, 0.19505000e+01, 0.19435000e+01},
    { 50, 14,  2,  3, 0.33420220e+03, 0.19505000e+01, 0.29407000e+01},
    { 50, 14,  2,  4, 0.27356280e+03, 0.19505000e+01, 0.38677000e+01},
    { 50, 14,  3,  0, 0.35774280e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 14,  3,  1, 0.33075310e+03, 0.29259000e+01, 0.95070000e+00},
    { 50, 14,  3,  2, 0.30775700e+03, 0.29259000e+01, 0.19435000e+01},
    { 50, 14,  3,  3, 0.29982180e+03, 0.29259000e+01, 0.29407000e+01},
    { 50, 14,  3,  4, 0.24705720e+03, 0.29259000e+01, 0.38677000e+01},
    { 50, 14,  4,  0, 0.32143630e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 14,  4,  1, 0.29764030e+03, 0.39123000e+01, 0.95070000e+00},
    { 50, 14,  4,  2, 0.27734590e+03, 0.39123000e+01, 0.19435000e+01},
    { 50, 14,  4,  3, 0.26996790e+03, 0.39123000e+01, 0.29407000e+01},
    { 50, 14,  4,  4, 0.22392830e+03, 0.39123000e+01, 0.38677000e+01},
    { 50, 15,  0,  0, 0.34241690e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 15,  0,  1, 0.33217220e+03, 0.00000000e+00, 0.99470000e+00},
    { 50, 15,  0,  2, 0.32794600e+03, 0.00000000e+00, 0.20102000e+01},
    { 50, 15,  0,  3, 0.30300330e+03, 0.00000000e+00, 0.29859000e+01},
    { 50, 15,  1,  0, 0.31993070e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 15,  1,  1, 0.31042380e+03, 0.95140000e+00, 0.99470000e+00},
    { 50, 15,  1,  2, 0.30637120e+03, 0.95140000e+00, 0.20102000e+01},
    { 50, 15,  1,  3, 0.28348980e+03, 0.95140000e+00, 0.29859000e+01},
    { 50, 15,  2,  0, 0.30959920e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 15,  2,  1, 0.30043180e+03, 0.19505000e+01, 0.99470000e+00},
    { 50, 15,  2,  2, 0.29645720e+03, 0.19505000e+01, 0.20102000e+01},
    { 50, 15,  2,  3, 0.27452930e+03, 0.19505000e+01, 0.29859000e+01},
    { 50, 15,  3,  0, 0.27953920e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 15,  3,  1, 0.27134880e+03, 0.29259000e+01, 0.99470000e+00},
    { 50, 15,  3,  2, 0.26762990e+03, 0.29259000e+01, 0.20102000e+01},
    { 50, 15,  3,  3, 0.24837820e+03, 0.29259000e+01, 0.29859000e+01},
    { 50, 15,  4,  0, 0.25331660e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 15,  4,  1, 0.24597730e+03, 0.39123000e+01, 0.99470000e+00},
    { 50, 15,  4,  2, 0.24249400e+03, 0.39123000e+01, 0.20102000e+01},
    { 50, 15,  4,  3, 0.22554180e+03, 0.39123000e+01, 0.29859000e+01},
    { 50, 16,  0,  0, 0.28132550e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 16,  0,  1, 0.27827870e+03, 0.00000000e+00, 0.99480000e+00},
    { 50, 16,  0,  2, 0.27258810e+03, 0.00000000e+00, 0.19903000e+01},
    { 50, 16,  1,  0, 0.26382770e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 16,  1,  1, 0.26094970e+03, 0.95140000e+00, 0.99480000e+00},
    { 50, 16,  1,  2, 0.25563360e+03, 0.95140000e+00, 0.19903000e+01},
    { 50, 16,  2,  0, 0.25580130e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 16,  2,  1, 0.25300030e+03, 0.19505000e+01, 0.99480000e+00},
    { 50, 16,  2,  2, 0.24785630e+03, 0.19505000e+01, 0.19903000e+01},
    { 50, 16,  3,  0, 0.23224340e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 16,  3,  1, 0.22967560e+03, 0.29259000e+01, 0.99480000e+00},
    { 50, 16,  3,  2, 0.22503380e+03, 0.29259000e+01, 0.19903000e+01},
    { 50, 16,  4,  0, 0.21163180e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 16,  4,  1, 0.20927130e+03, 0.39123000e+01, 0.99480000e+00},
    { 50, 16,  4,  2, 0.20506870e+03, 0.39123000e+01, 0.19903000e+01},
    { 50, 17,  0,  0, 0.22756350e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 17,  0,  1, 0.22523810e+03, 0.00000000e+00, 0.99720000e+00},
    { 50, 17,  1,  0, 0.21417230e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 17,  1,  1, 0.21197090e+03, 0.95140000e+00, 0.99720000e+00},
    { 50, 17,  2,  0, 0.20804020e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 17,  2,  1, 0.20589540e+03, 0.19505000e+01, 0.99720000e+00},
    { 50, 17,  3,  0, 0.18988240e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 17,  3,  1, 0.18790960e+03, 0.29259000e+01, 0.99720000e+00},
    { 50, 17,  4,  0, 0.17395170e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 17,  4,  1, 0.17213180e+03, 0.39123000e+01, 0.99720000e+00},
    { 50, 18,  0,  0, 0.18458450e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 18,  1,  0, 0.17426390e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 18,  2,  0, 0.16954570e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 18,  3,  0, 0.15546270e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 18,  4,  0, 0.14307940e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 19,  0,  0, 0.13902912e+04, 0.00000000e+00, 0.00000000e+00},
    { 50, 19,  0,  1, 0.45646130e+03, 0.00000000e+00, 0.97670000e+00},
    { 50, 19,  1,  0, 0.12595964e+04, 0.95140000e+00, 0.00000000e+00},
    { 50, 19,  1,  1, 0.42200550e+03, 0.95140000e+00, 0.97670000e+00},
    { 50, 19,  2,  0, 0.11982993e+04, 0.19505000e+01, 0.00000000e+00},
    { 50, 19,  2,  1, 0.40608450e+03, 0.19505000e+01, 0.97670000e+00},
    { 50, 19,  3,  0, 0.10315350e+04, 0.29259000e+01, 0.00000000e+00},
    { 50, 19,  3,  1, 0.36096750e+03, 0.29259000e+01, 0.97670000e+00},
    { 50, 19,  4,  0, 0.89120910e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 19,  4,  1, 0.32212730e+03, 0.39123000e+01, 0.97670000e+00},
    { 50, 20,  0,  0, 0.11230616e+04, 0.00000000e+00, 0.00000000e+00},
    { 50, 20,  0,  1, 0.89641550e+03, 0.00000000e+00, 0.98310000e+00},
    { 50, 20,  0,  2, 0.46411930e+03, 0.00000000e+00, 0.19349000e+01},
    { 50, 20,  1,  0, 0.10266097e+04, 0.95140000e+00, 0.00000000e+00},
    { 50, 20,  1,  1, 0.81999260e+03, 0.95140000e+00, 0.98310000e+00},
    { 50, 20,  1,  2, 0.43088530e+03, 0.95140000e+00, 0.19349000e+01},
    { 50, 20,  2,  0, 0.98182060e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 20,  2,  1, 0.78442190e+03, 0.19505000e+01, 0.98310000e+00},
    { 50, 20,  2,  2, 0.41557270e+03, 0.19505000e+01, 0.19349000e+01},
    { 50, 20,  3,  0, 0.85745370e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 20,  3,  1, 0.68580030e+03, 0.29259000e+01, 0.98310000e+00},
    { 50, 20,  3,  2, 0.37171230e+03, 0.29259000e+01, 0.19349000e+01},
    { 50, 20,  4,  0, 0.75145760e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 20,  4,  1, 0.60186910e+03, 0.39123000e+01, 0.98310000e+00},
    { 50, 20,  4,  2, 0.33372060e+03, 0.39123000e+01, 0.19349000e+01},
    { 50, 21,  0,  0, 0.92301820e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 21,  0,  1, 0.45113400e+03, 0.00000000e+00, 0.18627000e+01},
    { 50, 21,  0,  2, 0.44306050e+03, 0.00000000e+00, 0.28999000e+01},
    { 50, 21,  1,  0, 0.84554470e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 21,  1,  1, 0.41914320e+03, 0.95140000e+00, 0.18627000e+01},
    { 50, 21,  1,  2, 0.41239390e+03, 0.95140000e+00, 0.28999000e+01},
    { 50, 21,  2,  0, 0.80962470e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 21,  2,  1, 0.40440960e+03, 0.19505000e+01, 0.18627000e+01},
    { 50, 21,  2,  2, 0.39827950e+03, 0.19505000e+01, 0.28999000e+01},
    { 50, 21,  3,  0, 0.70944180e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 21,  3,  1, 0.36213940e+03, 0.29259000e+01, 0.18627000e+01},
    { 50, 21,  3,  2, 0.35761290e+03, 0.29259000e+01, 0.28999000e+01},
    { 50, 21,  4,  0, 0.62382770e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 21,  4,  1, 0.32550230e+03, 0.39123000e+01, 0.18627000e+01},
    { 50, 21,  4,  2, 0.32229080e+03, 0.39123000e+01, 0.28999000e+01},
    { 50, 22,  0,  0, 0.88663180e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 22,  0,  1, 0.43519480e+03, 0.00000000e+00, 0.18299000e+01},
    { 50, 22,  0,  2, 0.44827700e+03, 0.00000000e+00, 0.38675000e+01},
    { 50, 22,  1,  0, 0.81389640e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 22,  1,  1, 0.40443780e+03, 0.95140000e+00, 0.18299000e+01},
    { 50, 22,  1,  2, 0.41733250e+03, 0.95140000e+00, 0.38675000e+01},
    { 50, 22,  2,  0, 0.78020170e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 22,  2,  1, 0.39026550e+03, 0.19505000e+01, 0.18299000e+01},
    { 50, 22,  2,  2, 0.40309190e+03, 0.19505000e+01, 0.38675000e+01},
    { 50, 22,  3,  0, 0.68588510e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 22,  3,  1, 0.34961060e+03, 0.29259000e+01, 0.18299000e+01},
    { 50, 22,  3,  2, 0.36204400e+03, 0.29259000e+01, 0.38675000e+01},
    { 50, 22,  4,  0, 0.60513210e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 22,  4,  1, 0.31438040e+03, 0.39123000e+01, 0.18299000e+01},
    { 50, 22,  4,  2, 0.32638510e+03, 0.39123000e+01, 0.38675000e+01},
    { 50, 23,  0,  0, 0.80941340e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 23,  0,  1, 0.42659330e+03, 0.00000000e+00, 0.19138000e+01},
    { 50, 23,  0,  2, 0.41035180e+03, 0.00000000e+00, 0.29110000e+01},
    { 50, 23,  1,  0, 0.74392530e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 23,  1,  1, 0.39640790e+03, 0.95140000e+00, 0.19138000e+01},
    { 50, 23,  1,  2, 0.38198180e+03, 0.95140000e+00, 0.29110000e+01},
    { 50, 23,  2,  0, 0.71360600e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 23,  2,  1, 0.38249970e+03, 0.19505000e+01, 0.19138000e+01},
    { 50, 23,  2,  2, 0.36892090e+03, 0.19505000e+01, 0.29110000e+01},
    { 50, 23,  3,  0, 0.62854190e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 23,  3,  1, 0.34261200e+03, 0.29259000e+01, 0.19138000e+01},
    { 50, 23,  3,  2, 0.33130930e+03, 0.29259000e+01, 0.29110000e+01},
    { 50, 23,  4,  0, 0.55562000e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 23,  4,  1, 0.30805200e+03, 0.39123000e+01, 0.19138000e+01},
    { 50, 23,  4,  2, 0.29865910e+03, 0.39123000e+01, 0.29110000e+01},
    { 50, 24,  0,  0, 0.63665610e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 24,  0,  1, 0.42332080e+03, 0.00000000e+00, 0.18269000e+01},
    { 50, 24,  0,  2, 0.30551080e+03, 0.00000000e+00, 0.10619100e+02},
    { 50, 24,  1,  0, 0.58540690e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 24,  1,  1, 0.39312150e+03, 0.95140000e+00, 0.18269000e+01},
    { 50, 24,  1,  2, 0.28561070e+03, 0.95140000e+00, 0.10619100e+02},
    { 50, 24,  2,  0, 0.56166940e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 24,  2,  1, 0.37920210e+03, 0.19505000e+01, 0.18269000e+01},
    { 50, 24,  2,  2, 0.27646740e+03, 0.19505000e+01, 0.10619100e+02},
    { 50, 24,  3,  0, 0.49509360e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 24,  3,  1, 0.33934490e+03, 0.29259000e+01, 0.18269000e+01},
    { 50, 24,  3,  2, 0.24989390e+03, 0.29259000e+01, 0.10619100e+02},
    { 50, 24,  4,  0, 0.43806280e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 24,  4,  1, 0.30483850e+03, 0.39123000e+01, 0.18269000e+01},
    { 50, 24,  4,  2, 0.22674830e+03, 0.39123000e+01, 0.10619100e+02},
    { 50, 25,  0,  0, 0.69374420e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 25,  0,  1, 0.38661840e+03, 0.00000000e+00, 0.16406000e+01},
    { 50, 25,  0,  2, 0.25955840e+03, 0.00000000e+00, 0.98849000e+01},
    { 50, 25,  1,  0, 0.63875870e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 25,  1,  1, 0.36011140e+03, 0.95140000e+00, 0.16406000e+01},
    { 50, 25,  1,  2, 0.24329840e+03, 0.95140000e+00, 0.98849000e+01},
    { 50, 25,  2,  0, 0.61332300e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 25,  2,  1, 0.34791510e+03, 0.19505000e+01, 0.16406000e+01},
    { 50, 25,  2,  2, 0.23583660e+03, 0.19505000e+01, 0.98849000e+01},
    { 50, 25,  3,  0, 0.54171840e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 25,  3,  1, 0.31272950e+03, 0.29259000e+01, 0.16406000e+01},
    { 50, 25,  3,  2, 0.21401180e+03, 0.29259000e+01, 0.98849000e+01},
    { 50, 25,  4,  0, 0.48022450e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 25,  4,  1, 0.28215030e+03, 0.39123000e+01, 0.16406000e+01},
    { 50, 25,  4,  2, 0.19495560e+03, 0.39123000e+01, 0.98849000e+01},
    { 50, 26,  0,  0, 0.54336290e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 26,  0,  1, 0.35691590e+03, 0.00000000e+00, 0.16483000e+01},
    { 50, 26,  0,  2, 0.25501000e+03, 0.00000000e+00, 0.91376000e+01},
    { 50, 26,  1,  0, 0.50063040e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 26,  1,  1, 0.33275950e+03, 0.95140000e+00, 0.16483000e+01},
    { 50, 26,  1,  2, 0.23895870e+03, 0.95140000e+00, 0.91376000e+01},
    { 50, 26,  2,  0, 0.48085880e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 26,  2,  1, 0.32164840e+03, 0.19505000e+01, 0.16483000e+01},
    { 50, 26,  2,  2, 0.23159140e+03, 0.19505000e+01, 0.91376000e+01},
    { 50, 26,  3,  0, 0.42519040e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 26,  3,  1, 0.28953010e+03, 0.29259000e+01, 0.16483000e+01},
    { 50, 26,  3,  2, 0.21006230e+03, 0.29259000e+01, 0.91376000e+01},
    { 50, 26,  4,  0, 0.37740640e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 26,  4,  1, 0.26159540e+03, 0.39123000e+01, 0.16483000e+01},
    { 50, 26,  4,  2, 0.19127030e+03, 0.39123000e+01, 0.91376000e+01},
    { 50, 27,  0,  0, 0.57281690e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 27,  0,  1, 0.34042650e+03, 0.00000000e+00, 0.17149000e+01},
    { 50, 27,  0,  2, 0.30241310e+03, 0.00000000e+00, 0.29263000e+01},
    { 50, 27,  0,  3, 0.26720820e+03, 0.00000000e+00, 0.77785000e+01},
    { 50, 27,  1,  0, 0.52899650e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 27,  1,  1, 0.31739780e+03, 0.95140000e+00, 0.17149000e+01},
    { 50, 27,  1,  2, 0.28217500e+03, 0.95140000e+00, 0.29263000e+01},
    { 50, 27,  1,  3, 0.25002640e+03, 0.95140000e+00, 0.77785000e+01},
    { 50, 27,  2,  0, 0.50875980e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 27,  2,  1, 0.30680410e+03, 0.19505000e+01, 0.17149000e+01},
    { 50, 27,  2,  2, 0.27286680e+03, 0.19505000e+01, 0.29263000e+01},
    { 50, 27,  2,  3, 0.24213510e+03, 0.19505000e+01, 0.77785000e+01},
    { 50, 27,  3,  0, 0.45143600e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 27,  3,  1, 0.27618840e+03, 0.29259000e+01, 0.17149000e+01},
    { 50, 27,  3,  2, 0.24593880e+03, 0.29259000e+01, 0.29263000e+01},
    { 50, 27,  3,  3, 0.21915410e+03, 0.29259000e+01, 0.77785000e+01},
    { 50, 27,  4,  0, 0.40204340e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 27,  4,  1, 0.24956670e+03, 0.39123000e+01, 0.17149000e+01},
    { 50, 27,  4,  2, 0.22252350e+03, 0.39123000e+01, 0.29263000e+01},
    { 50, 27,  4,  3, 0.19911820e+03, 0.39123000e+01, 0.77785000e+01},
    { 50, 28,  0,  0, 0.59204640e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 28,  0,  1, 0.33303010e+03, 0.00000000e+00, 0.17937000e+01},
    { 50, 28,  0,  2, 0.28084550e+03, 0.00000000e+00, 0.65458000e+01},
    { 50, 28,  0,  3, 0.29688720e+03, 0.00000000e+00, 0.62918000e+01},
    { 50, 28,  1,  0, 0.54604730e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 28,  1,  1, 0.31042370e+03, 0.95140000e+00, 0.17937000e+01},
    { 50, 28,  1,  2, 0.26236960e+03, 0.95140000e+00, 0.65458000e+01},
    { 50, 28,  1,  3, 0.27663930e+03, 0.95140000e+00, 0.62918000e+01},
    { 50, 28,  2,  0, 0.52479280e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 28,  2,  1, 0.30002320e+03, 0.19505000e+01, 0.17937000e+01},
    { 50, 28,  2,  2, 0.25387790e+03, 0.19505000e+01, 0.65458000e+01},
    { 50, 28,  2,  3, 0.26732250e+03, 0.19505000e+01, 0.62918000e+01},
    { 50, 28,  3,  0, 0.46473810e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 28,  3,  1, 0.26998570e+03, 0.29259000e+01, 0.17937000e+01},
    { 50, 28,  3,  2, 0.22923870e+03, 0.29259000e+01, 0.65458000e+01},
    { 50, 28,  3,  3, 0.24046050e+03, 0.29259000e+01, 0.62918000e+01},
    { 50, 28,  4,  0, 0.41305650e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 28,  4,  1, 0.24387510e+03, 0.39123000e+01, 0.17937000e+01},
    { 50, 28,  4,  2, 0.20778550e+03, 0.39123000e+01, 0.65458000e+01},
    { 50, 28,  4,  3, 0.21713920e+03, 0.39123000e+01, 0.62918000e+01},
    { 50, 29,  0,  0, 0.45320890e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 29,  0,  1, 0.33100630e+03, 0.00000000e+00, 0.95760000e+00},
    { 50, 29,  1,  0, 0.41817300e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 29,  1,  1, 0.30781940e+03, 0.95140000e+00, 0.95760000e+00},
    { 50, 29,  2,  0, 0.40197520e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 29,  2,  1, 0.29714060e+03, 0.19505000e+01, 0.95760000e+00},
    { 50, 29,  3,  0, 0.35624130e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 29,  3,  1, 0.26647580e+03, 0.29259000e+01, 0.95760000e+00},
    { 50, 29,  4,  0, 0.31692740e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 29,  4,  1, 0.23989280e+03, 0.39123000e+01, 0.95760000e+00},
    { 50, 30,  0,  0, 0.46119710e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 30,  0,  1, 0.30726350e+03, 0.00000000e+00, 0.19419000e+01},
    { 50, 30,  1,  0, 0.42710250e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 30,  1,  1, 0.28694640e+03, 0.95140000e+00, 0.19419000e+01},
    { 50, 30,  2,  0, 0.41137780e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 30,  2,  1, 0.27760830e+03, 0.19505000e+01, 0.19419000e+01},
    { 50, 30,  3,  0, 0.36657850e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 30,  3,  1, 0.25050770e+03, 0.29259000e+01, 0.19419000e+01},
    { 50, 30,  4,  0, 0.32786560e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 30,  4,  1, 0.22689510e+03, 0.39123000e+01, 0.19419000e+01},
    { 50, 31,  0,  0, 0.54805490e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 31,  0,  1, 0.51303150e+03, 0.00000000e+00, 0.96010000e+00},
    { 50, 31,  0,  2, 0.40172510e+03, 0.00000000e+00, 0.19315000e+01},
    { 50, 31,  0,  3, 0.32482290e+03, 0.00000000e+00, 0.29233000e+01},
    { 50, 31,  1,  0, 0.50688380e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 31,  1,  1, 0.47510140e+03, 0.95140000e+00, 0.96010000e+00},
    { 50, 31,  1,  2, 0.37370470e+03, 0.95140000e+00, 0.19315000e+01},
    { 50, 31,  1,  3, 0.30351790e+03, 0.95140000e+00, 0.29233000e+01},
    { 50, 31,  2,  0, 0.48787860e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 31,  2,  1, 0.45760310e+03, 0.19505000e+01, 0.96010000e+00},
    { 50, 31,  2,  2, 0.36080170e+03, 0.19505000e+01, 0.19315000e+01},
    { 50, 31,  2,  3, 0.29372900e+03, 0.19505000e+01, 0.29233000e+01},
    { 50, 31,  3,  0, 0.43386350e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 31,  3,  1, 0.40773530e+03, 0.29259000e+01, 0.96010000e+00},
    { 50, 31,  3,  2, 0.32367220e+03, 0.29259000e+01, 0.19315000e+01},
    { 50, 31,  3,  3, 0.26525500e+03, 0.29259000e+01, 0.29233000e+01},
    { 50, 31,  4,  0, 0.38724130e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 31,  4,  1, 0.36463660e+03, 0.39123000e+01, 0.96010000e+00},
    { 50, 31,  4,  2, 0.29143960e+03, 0.39123000e+01, 0.19315000e+01},
    { 50, 31,  4,  3, 0.24041780e+03, 0.39123000e+01, 0.29233000e+01},
    { 50, 32,  0,  0, 0.47710340e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 32,  0,  1, 0.44490480e+03, 0.00000000e+00, 0.94340000e+00},
    { 50, 32,  0,  2, 0.42263220e+03, 0.00000000e+00, 0.19447000e+01},
    { 50, 32,  0,  3, 0.37661080e+03, 0.00000000e+00, 0.29186000e+01},
    { 50, 32,  0,  4, 0.33013010e+03, 0.00000000e+00, 0.38972000e+01},
    { 50, 32,  1,  0, 0.44348920e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 32,  1,  1, 0.41406130e+03, 0.95140000e+00, 0.94340000e+00},
    { 50, 32,  1,  2, 0.39365950e+03, 0.95140000e+00, 0.19447000e+01},
    { 50, 32,  1,  3, 0.35152010e+03, 0.95140000e+00, 0.29186000e+01},
    { 50, 32,  1,  4, 0.30894110e+03, 0.95140000e+00, 0.38972000e+01},
    { 50, 32,  2,  0, 0.42801030e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 32,  2,  1, 0.39986460e+03, 0.19505000e+01, 0.94340000e+00},
    { 50, 32,  2,  2, 0.38032910e+03, 0.19505000e+01, 0.19447000e+01},
    { 50, 32,  2,  3, 0.33998590e+03, 0.19505000e+01, 0.29186000e+01},
    { 50, 32,  2,  4, 0.29921170e+03, 0.19505000e+01, 0.38972000e+01},
    { 50, 32,  3,  0, 0.38351890e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 32,  3,  1, 0.35895200e+03, 0.29259000e+01, 0.94340000e+00},
    { 50, 32,  3,  2, 0.34184070e+03, 0.29259000e+01, 0.19447000e+01},
    { 50, 32,  3,  3, 0.30652410e+03, 0.29259000e+01, 0.29186000e+01},
    { 50, 32,  3,  4, 0.27080520e+03, 0.29259000e+01, 0.38972000e+01},
    { 50, 32,  4,  0, 0.34490650e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 32,  4,  1, 0.32340730e+03, 0.39123000e+01, 0.94340000e+00},
    { 50, 32,  4,  2, 0.30837570e+03, 0.39123000e+01, 0.19447000e+01},
    { 50, 32,  4,  3, 0.27737170e+03, 0.39123000e+01, 0.29186000e+01},
    { 50, 32,  4,  4, 0.24599220e+03, 0.39123000e+01, 0.38972000e+01},
    { 50, 33,  0,  0, 0.40194150e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 33,  0,  1, 0.39481650e+03, 0.00000000e+00, 0.98890000e+00},
    { 50, 33,  0,  2, 0.38394660e+03, 0.00000000e+00, 0.19793000e+01},
    { 50, 33,  0,  3, 0.36910130e+03, 0.00000000e+00, 0.29709000e+01},
    { 50, 33,  1,  0, 0.37536940e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 33,  1,  1, 0.36881960e+03, 0.95140000e+00, 0.98890000e+00},
    { 50, 33,  1,  2, 0.35883980e+03, 0.95140000e+00, 0.19793000e+01},
    { 50, 33,  1,  3, 0.34521760e+03, 0.95140000e+00, 0.29709000e+01},
    { 50, 33,  2,  0, 0.36315760e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 33,  2,  1, 0.35687340e+03, 0.19505000e+01, 0.98890000e+00},
    { 50, 33,  2,  2, 0.34730490e+03, 0.19505000e+01, 0.19793000e+01},
    { 50, 33,  2,  3, 0.33424830e+03, 0.19505000e+01, 0.29709000e+01},
    { 50, 33,  3,  0, 0.32767900e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 33,  3,  1, 0.32214500e+03, 0.29259000e+01, 0.98890000e+00},
    { 50, 33,  3,  2, 0.31373420e+03, 0.29259000e+01, 0.19793000e+01},
    { 50, 33,  3,  3, 0.30226660e+03, 0.29259000e+01, 0.29709000e+01},
    { 50, 33,  4,  0, 0.29675050e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 33,  4,  1, 0.29186440e+03, 0.39123000e+01, 0.98890000e+00},
    { 50, 33,  4,  2, 0.28445060e+03, 0.39123000e+01, 0.19793000e+01},
    { 50, 33,  4,  3, 0.27434930e+03, 0.39123000e+01, 0.29709000e+01},
    { 50, 34,  0,  0, 0.35778710e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 34,  0,  1, 0.35796090e+03, 0.00000000e+00, 0.99010000e+00},
    { 50, 34,  0,  2, 0.35506520e+03, 0.00000000e+00, 0.19812000e+01},
    { 50, 34,  1,  0, 0.33511820e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 34,  1,  1, 0.33526670e+03, 0.95140000e+00, 0.99010000e+00},
    { 50, 34,  1,  2, 0.33258250e+03, 0.95140000e+00, 0.19812000e+01},
    { 50, 34,  2,  0, 0.32471350e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 34,  2,  1, 0.32485020e+03, 0.19505000e+01, 0.99010000e+00},
    { 50, 34,  2,  2, 0.32226350e+03, 0.19505000e+01, 0.19812000e+01},
    { 50, 34,  3,  0, 0.29427420e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 34,  3,  1, 0.29438040e+03, 0.29259000e+01, 0.99010000e+00},
    { 50, 34,  3,  2, 0.29207370e+03, 0.29259000e+01, 0.19812000e+01},
    { 50, 34,  4,  0, 0.26767240e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 34,  4,  1, 0.26775420e+03, 0.39123000e+01, 0.99010000e+00},
    { 50, 34,  4,  2, 0.26569090e+03, 0.39123000e+01, 0.19812000e+01},
    { 50, 35,  0,  0, 0.31050930e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 35,  0,  1, 0.31279940e+03, 0.00000000e+00, 0.99740000e+00},
    { 50, 35,  1,  0, 0.29171790e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 35,  1,  1, 0.29382390e+03, 0.95140000e+00, 0.99740000e+00},
    { 50, 35,  2,  0, 0.28310510e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 35,  2,  1, 0.28512610e+03, 0.19505000e+01, 0.99740000e+00},
    { 50, 35,  3,  0, 0.25771960e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 35,  3,  1, 0.25950110e+03, 0.29259000e+01, 0.99740000e+00},
    { 50, 35,  4,  0, 0.23547970e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 35,  4,  1, 0.23705490e+03, 0.39123000e+01, 0.99740000e+00},
    { 50, 36,  0,  0, 0.26795320e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 36,  1,  0, 0.25244080e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 36,  2,  0, 0.24534090e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 36,  3,  0, 0.22426550e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 36,  4,  0, 0.20576180e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 37,  0,  0, 0.15543698e+04, 0.00000000e+00, 0.00000000e+00},
    { 50, 37,  0,  1, 0.54287770e+03, 0.00000000e+00, 0.97380000e+00},
    { 50, 37,  1,  0, 0.14095386e+04, 0.95140000e+00, 0.00000000e+00},
    { 50, 37,  1,  1, 0.50249860e+03, 0.95140000e+00, 0.97380000e+00},
    { 50, 37,  2,  0, 0.13416152e+04, 0.19505000e+01, 0.00000000e+00},
    { 50, 37,  2,  1, 0.48384610e+03, 0.19505000e+01, 0.97380000e+00},
    { 50, 37,  3,  0, 0.11566447e+04, 0.29259000e+01, 0.00000000e+00},
    { 50, 37,  3,  1, 0.43088110e+03, 0.29259000e+01, 0.97380000e+00},
    { 50, 37,  4,  0, 0.10009319e+04, 0.39123000e+01, 0.00000000e+00},
    { 50, 37,  4,  1, 0.38525160e+03, 0.39123000e+01, 0.97380000e+00},
    { 50, 38,  0,  0, 0.13385665e+04, 0.00000000e+00, 0.00000000e+00},
    { 50, 38,  0,  1, 0.10916636e+04, 0.00000000e+00, 0.98010000e+00},
    { 50, 38,  0,  2, 0.55532330e+03, 0.00000000e+00, 0.19143000e+01},
    { 50, 38,  1,  0, 0.12233073e+04, 0.95140000e+00, 0.00000000e+00},
    { 50, 38,  1,  1, 0.99819190e+03, 0.95140000e+00, 0.98010000e+00},
    { 50, 38,  1,  2, 0.51576060e+03, 0.95140000e+00, 0.19143000e+01},
    { 50, 38,  2,  0, 0.11697495e+04, 0.19505000e+01, 0.00000000e+00},
    { 50, 38,  2,  1, 0.95464460e+03, 0.19505000e+01, 0.98010000e+00},
    { 50, 38,  2,  2, 0.49753160e+03, 0.19505000e+01, 0.19143000e+01},
    { 50, 38,  3,  0, 0.10211992e+04, 0.29259000e+01, 0.00000000e+00},
    { 50, 38,  3,  1, 0.83409790e+03, 0.29259000e+01, 0.98010000e+00},
    { 50, 38,  3,  2, 0.44529880e+03, 0.29259000e+01, 0.19143000e+01},
    { 50, 38,  4,  0, 0.89470560e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 38,  4,  1, 0.73162570e+03, 0.39123000e+01, 0.98010000e+00},
    { 50, 38,  4,  2, 0.40006500e+03, 0.39123000e+01, 0.19143000e+01},
    { 50, 39,  0,  0, 0.11613674e+04, 0.00000000e+00, 0.00000000e+00},
    { 50, 39,  0,  1, 0.81841300e+03, 0.00000000e+00, 0.19153000e+01},
    { 50, 39,  0,  2, 0.52991860e+03, 0.00000000e+00, 0.28903000e+01},
    { 50, 39,  1,  0, 0.10654342e+04, 0.95140000e+00, 0.00000000e+00},
    { 50, 39,  1,  1, 0.75411460e+03, 0.95140000e+00, 0.19153000e+01},
    { 50, 39,  1,  2, 0.49381290e+03, 0.95140000e+00, 0.28903000e+01},
    { 50, 39,  2,  0, 0.10209627e+04, 0.19505000e+01, 0.00000000e+00},
    { 50, 39,  2,  1, 0.72429340e+03, 0.19505000e+01, 0.19153000e+01},
    { 50, 39,  2,  2, 0.47720360e+03, 0.19505000e+01, 0.28903000e+01},
    { 50, 39,  3,  0, 0.89668220e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 39,  3,  1, 0.64047400e+03, 0.29259000e+01, 0.19153000e+01},
    { 50, 39,  3,  2, 0.42922790e+03, 0.29259000e+01, 0.28903000e+01},
    { 50, 39,  4,  0, 0.79039380e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 39,  4,  1, 0.56861590e+03, 0.39123000e+01, 0.19153000e+01},
    { 50, 39,  4,  2, 0.38751810e+03, 0.39123000e+01, 0.28903000e+01},
    { 50, 40,  0,  0, 0.10372812e+04, 0.00000000e+00, 0.00000000e+00},
    { 50, 40,  0,  1, 0.59689190e+03, 0.00000000e+00, 0.19355000e+01},
    { 50, 40,  0,  2, 0.53307320e+03, 0.00000000e+00, 0.39106000e+01},
    { 50, 40,  1,  0, 0.95393220e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 40,  1,  1, 0.55441070e+03, 0.95140000e+00, 0.19355000e+01},
    { 50, 40,  1,  2, 0.49724240e+03, 0.95140000e+00, 0.39106000e+01},
    { 50, 40,  2,  0, 0.91534550e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 40,  2,  1, 0.53482740e+03, 0.19505000e+01, 0.19355000e+01},
    { 50, 40,  2,  2, 0.48076680e+03, 0.19505000e+01, 0.39106000e+01},
    { 50, 40,  3,  0, 0.80699680e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 40,  3,  1, 0.47873550e+03, 0.29259000e+01, 0.19355000e+01},
    { 50, 40,  3,  2, 0.43306580e+03, 0.29259000e+01, 0.39106000e+01},
    { 50, 40,  4,  0, 0.71409530e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 40,  4,  1, 0.43018180e+03, 0.39123000e+01, 0.19355000e+01},
    { 50, 40,  4,  2, 0.39155320e+03, 0.39123000e+01, 0.39106000e+01},
    { 50, 41,  0,  0, 0.94177920e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 41,  0,  1, 0.60296920e+03, 0.00000000e+00, 0.19545000e+01},
    { 50, 41,  0,  2, 0.51573740e+03, 0.00000000e+00, 0.29225000e+01},
    { 50, 41,  1,  0, 0.86754750e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 41,  1,  1, 0.55998500e+03, 0.95140000e+00, 0.19545000e+01},
    { 50, 41,  1,  2, 0.48095640e+03, 0.95140000e+00, 0.29225000e+01},
    { 50, 41,  2,  0, 0.83320500e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 41,  2,  1, 0.54017920e+03, 0.19505000e+01, 0.19545000e+01},
    { 50, 41,  2,  2, 0.46495560e+03, 0.19505000e+01, 0.29225000e+01},
    { 50, 41,  3,  0, 0.73648020e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 41,  3,  1, 0.48344780e+03, 0.29259000e+01, 0.19545000e+01},
    { 50, 41,  3,  2, 0.41869180e+03, 0.29259000e+01, 0.29225000e+01},
    { 50, 41,  4,  0, 0.65341870e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 41,  4,  1, 0.43434220e+03, 0.39123000e+01, 0.19545000e+01},
    { 50, 41,  4,  2, 0.37846930e+03, 0.39123000e+01, 0.29225000e+01},
    { 50, 42,  0,  0, 0.72129060e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 42,  0,  1, 0.56051040e+03, 0.00000000e+00, 0.19420000e+01},
    { 50, 42,  0,  2, 0.45246160e+03, 0.00000000e+00, 0.11055600e+02},
    { 50, 42,  1,  0, 0.66641970e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 42,  1,  1, 0.52115630e+03, 0.95140000e+00, 0.19420000e+01},
    { 50, 42,  1,  2, 0.42315700e+03, 0.95140000e+00, 0.11055600e+02},
    { 50, 42,  2,  0, 0.64106430e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 42,  2,  1, 0.50302360e+03, 0.19505000e+01, 0.19420000e+01},
    { 50, 42,  2,  2, 0.40969630e+03, 0.19505000e+01, 0.11055600e+02},
    { 50, 42,  3,  0, 0.56927660e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 42,  3,  1, 0.45098400e+03, 0.29259000e+01, 0.19420000e+01},
    { 50, 42,  3,  2, 0.37051430e+03, 0.29259000e+01, 0.11055600e+02},
    { 50, 42,  4,  0, 0.50749190e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 42,  4,  1, 0.40590280e+03, 0.39123000e+01, 0.19420000e+01},
    { 50, 42,  4,  2, 0.33635920e+03, 0.39123000e+01, 0.11055600e+02},
    { 50, 43,  0,  0, 0.80723580e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 43,  0,  1, 0.63478310e+03, 0.00000000e+00, 0.16682000e+01},
    { 50, 43,  0,  2, 0.39689200e+03, 0.00000000e+00, 0.95402000e+01},
    { 50, 43,  1,  0, 0.74499930e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 43,  1,  1, 0.58793550e+03, 0.95140000e+00, 0.16682000e+01},
    { 50, 43,  1,  2, 0.37204100e+03, 0.95140000e+00, 0.95402000e+01},
    { 50, 43,  2,  0, 0.71622390e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 43,  2,  1, 0.56629020e+03, 0.19505000e+01, 0.16682000e+01},
    { 50, 43,  2,  2, 0.36063780e+03, 0.19505000e+01, 0.95402000e+01},
    { 50, 43,  3,  0, 0.63492090e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 43,  3,  1, 0.50476500e+03, 0.29259000e+01, 0.16682000e+01},
    { 50, 43,  3,  2, 0.32726370e+03, 0.29259000e+01, 0.95402000e+01},
    { 50, 43,  4,  0, 0.56500310e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 43,  4,  1, 0.45173170e+03, 0.39123000e+01, 0.16682000e+01},
    { 50, 43,  4,  2, 0.29811220e+03, 0.39123000e+01, 0.95402000e+01},
    { 50, 44,  0,  0, 0.60961520e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 44,  0,  1, 0.48488550e+03, 0.00000000e+00, 0.18584000e+01},
    { 50, 44,  0,  2, 0.37418700e+03, 0.00000000e+00, 0.88895000e+01},
    { 50, 44,  1,  0, 0.56445890e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 44,  1,  1, 0.45216820e+03, 0.95140000e+00, 0.18584000e+01},
    { 50, 44,  1,  2, 0.35105910e+03, 0.95140000e+00, 0.88895000e+01},
    { 50, 44,  2,  0, 0.54361040e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 44,  2,  1, 0.43711840e+03, 0.19505000e+01, 0.18584000e+01},
    { 50, 44,  2,  2, 0.34045080e+03, 0.19505000e+01, 0.88895000e+01},
    { 50, 44,  3,  0, 0.48434860e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 44,  3,  1, 0.39362700e+03, 0.29259000e+01, 0.18584000e+01},
    { 50, 44,  3,  2, 0.30934100e+03, 0.29259000e+01, 0.88895000e+01},
    { 50, 44,  4,  0, 0.43325440e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 44,  4,  1, 0.35582860e+03, 0.39123000e+01, 0.18584000e+01},
    { 50, 44,  4,  2, 0.28214800e+03, 0.39123000e+01, 0.88895000e+01},
    { 50, 45,  0,  0, 0.66689540e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 45,  0,  1, 0.45317940e+03, 0.00000000e+00, 0.19003000e+01},
    { 50, 45,  0,  2, 0.38378510e+03, 0.00000000e+00, 0.29696000e+01},
    { 50, 45,  1,  0, 0.61737910e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 45,  1,  1, 0.42274380e+03, 0.95140000e+00, 0.19003000e+01},
    { 50, 45,  1,  2, 0.35913800e+03, 0.95140000e+00, 0.29696000e+01},
    { 50, 45,  2,  0, 0.59452770e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 45,  2,  1, 0.40874340e+03, 0.19505000e+01, 0.19003000e+01},
    { 50, 45,  2,  2, 0.34781660e+03, 0.19505000e+01, 0.29696000e+01},
    { 50, 45,  3,  0, 0.52953710e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 45,  3,  1, 0.36827100e+03, 0.29259000e+01, 0.19003000e+01},
    { 50, 45,  3,  2, 0.31485220e+03, 0.29259000e+01, 0.29696000e+01},
    { 50, 45,  4,  0, 0.47345910e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 45,  4,  1, 0.33309730e+03, 0.39123000e+01, 0.19003000e+01},
    { 50, 45,  4,  2, 0.28612510e+03, 0.39123000e+01, 0.29696000e+01},
    { 50, 46,  0,  0, 0.61675220e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 46,  0,  1, 0.42012680e+03, 0.00000000e+00, 0.18630000e+01},
    { 50, 46,  0,  2, 0.40184330e+03, 0.00000000e+00, 0.57095000e+01},
    { 50, 46,  1,  0, 0.57156020e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 46,  1,  1, 0.39214710e+03, 0.95140000e+00, 0.18630000e+01},
    { 50, 46,  1,  2, 0.37573450e+03, 0.95140000e+00, 0.57095000e+01},
    { 50, 46,  2,  0, 0.55071590e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 46,  2,  1, 0.37927910e+03, 0.19505000e+01, 0.18630000e+01},
    { 50, 46,  2,  2, 0.36373910e+03, 0.19505000e+01, 0.57095000e+01},
    { 50, 46,  3,  0, 0.49130410e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 46,  3,  1, 0.34204040e+03, 0.29259000e+01, 0.18630000e+01},
    { 50, 46,  3,  2, 0.32886980e+03, 0.29259000e+01, 0.57095000e+01},
    { 50, 46,  4,  0, 0.43998550e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 46,  4,  1, 0.30966650e+03, 0.39123000e+01, 0.18630000e+01},
    { 50, 46,  4,  2, 0.29849500e+03, 0.39123000e+01, 0.57095000e+01},
    { 50, 47,  0,  0, 0.51444770e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 47,  0,  1, 0.40690290e+03, 0.00000000e+00, 0.96790000e+00},
    { 50, 47,  1,  0, 0.47659660e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 47,  1,  1, 0.37963350e+03, 0.95140000e+00, 0.96790000e+00},
    { 50, 47,  2,  0, 0.45912190e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 47,  2,  1, 0.36709070e+03, 0.19505000e+01, 0.96790000e+00},
    { 50, 47,  3,  0, 0.40943180e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 47,  3,  1, 0.33083540e+03, 0.29259000e+01, 0.96790000e+00},
    { 50, 47,  4,  0, 0.36659430e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 47,  4,  1, 0.29933180e+03, 0.39123000e+01, 0.96790000e+00},
    { 50, 48,  0,  0, 0.54154900e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 48,  0,  1, 0.40034740e+03, 0.00000000e+00, 0.19539000e+01},
    { 50, 48,  1,  0, 0.50255130e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 48,  1,  1, 0.37434300e+03, 0.95140000e+00, 0.19539000e+01},
    { 50, 48,  2,  0, 0.48457590e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 48,  2,  1, 0.36239660e+03, 0.19505000e+01, 0.19539000e+01},
    { 50, 48,  3,  0, 0.43319920e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 48,  3,  1, 0.32765190e+03, 0.29259000e+01, 0.19539000e+01},
    { 50, 48,  4,  0, 0.38876210e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 48,  4,  1, 0.29736580e+03, 0.39123000e+01, 0.19539000e+01},
    { 50, 49,  0,  0, 0.68561380e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 49,  0,  1, 0.65114030e+03, 0.00000000e+00, 0.96330000e+00},
    { 50, 49,  0,  2, 0.51714790e+03, 0.00000000e+00, 0.19378000e+01},
    { 50, 49,  0,  3, 0.43562520e+03, 0.00000000e+00, 0.29353000e+01},
    { 50, 49,  1,  0, 0.63411950e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 49,  1,  1, 0.60309650e+03, 0.95140000e+00, 0.96330000e+00},
    { 50, 49,  1,  2, 0.48141850e+03, 0.95140000e+00, 0.19378000e+01},
    { 50, 49,  1,  3, 0.40722750e+03, 0.95140000e+00, 0.29353000e+01},
    { 50, 49,  2,  0, 0.61033820e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 49,  2,  1, 0.58092600e+03, 0.19505000e+01, 0.96330000e+00},
    { 50, 49,  2,  2, 0.46496770e+03, 0.19505000e+01, 0.19378000e+01},
    { 50, 49,  2,  3, 0.39418070e+03, 0.19505000e+01, 0.29353000e+01},
    { 50, 49,  3,  0, 0.54284130e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 49,  3,  1, 0.51780290e+03, 0.29259000e+01, 0.96330000e+00},
    { 50, 49,  3,  2, 0.41760930e+03, 0.29259000e+01, 0.19378000e+01},
    { 50, 49,  3,  3, 0.35623590e+03, 0.29259000e+01, 0.29353000e+01},
    { 50, 49,  4,  0, 0.48465320e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 49,  4,  1, 0.46329930e+03, 0.39123000e+01, 0.96330000e+00},
    { 50, 49,  4,  2, 0.37650510e+03, 0.39123000e+01, 0.19378000e+01},
    { 50, 49,  4,  3, 0.32315090e+03, 0.39123000e+01, 0.29353000e+01},
    { 50, 50,  0,  0, 0.62756770e+03, 0.00000000e+00, 0.00000000e+00},
    { 50, 50,  1,  0, 0.58276930e+03, 0.95140000e+00, 0.00000000e+00},
    { 50, 50,  1,  1, 0.54204390e+03, 0.95140000e+00, 0.95140000e+00},
    { 50, 50,  2,  0, 0.56212760e+03, 0.19505000e+01, 0.00000000e+00},
    { 50, 50,  2,  1, 0.52329100e+03, 0.19505000e+01, 0.95140000e+00},
    { 50, 50,  2,  2, 0.50541480e+03, 0.19505000e+01, 0.19505000e+01},
    { 50, 50,  3,  0, 0.50298910e+03, 0.29259000e+01, 0.00000000e+00},
    { 50, 50,  3,  1, 0.46937510e+03, 0.29259000e+01, 0.95140000e+00},
    { 50, 50,  3,  2, 0.45391950e+03, 0.29259000e+01, 0.19505000e+01},
    { 50, 50,  3,  3, 0.40914530e+03, 0.29259000e+01, 0.29259000e+01},
    { 50, 50,  4,  0, 0.45175780e+03, 0.39123000e+01, 0.00000000e+00},
    { 50, 50,  4,  1, 0.42259500e+03, 0.39123000e+01, 0.95140000e+00},
    { 50, 50,  4,  2, 0.40920080e+03, 0.39123000e+01, 0.19505000e+01},
    { 50, 50,  4,  3, 0.37016740e+03, 0.39123000e+01, 0.29259000e+01},
    { 50, 50,  4,  4, 0.33610200e+03, 0.39123000e+01, 0.39123000e+01},
    { 51,  1,  0,  0, 0.37768100e+02, 0.00000000e+00, 0.91180000e+00},
    { 51,  1,  0,  1, 0.60947000e+02, 0.00000000e+00, 0.00000000e+00},
    { 51,  1,  1,  0, 0.37118600e+02, 0.97490000e+00, 0.91180000e+00},
    { 51,  1,  1,  1, 0.59779600e+02, 0.97490000e+00, 0.00000000e+00},
    { 51,  1,  2,  0, 0.36227700e+02, 0.19523000e+01, 0.91180000e+00},
    { 51,  1,  2,  1, 0.58196200e+02, 0.19523000e+01, 0.00000000e+00},
    { 51,  1,  3,  0, 0.35093900e+02, 0.29315000e+01, 0.91180000e+00},
    { 51,  1,  3,  1, 0.56194600e+02, 0.29315000e+01, 0.00000000e+00},
    { 51,  2,  0,  0, 0.24858300e+02, 0.00000000e+00, 0.00000000e+00},
    { 51,  2,  1,  0, 0.24506800e+02, 0.97490000e+00, 0.00000000e+00},
    { 51,  2,  2,  0, 0.24014100e+02, 0.19523000e+01, 0.00000000e+00},
    { 51,  2,  3,  0, 0.23379200e+02, 0.29315000e+01, 0.00000000e+00},
    { 51,  3,  0,  0, 0.58668880e+03, 0.00000000e+00, 0.00000000e+00},
    { 51,  3,  0,  1, 0.19776980e+03, 0.00000000e+00, 0.98650000e+00},
    { 51,  3,  1,  0, 0.56950200e+03, 0.97490000e+00, 0.00000000e+00},
    { 51,  3,  1,  1, 0.19308010e+03, 0.97490000e+00, 0.98650000e+00},
    { 51,  3,  2,  0, 0.54685470e+03, 0.19523000e+01, 0.00000000e+00},
    { 51,  3,  2,  1, 0.18683530e+03, 0.19523000e+01, 0.98650000e+00},
    { 51,  3,  3,  0, 0.51864270e+03, 0.29315000e+01, 0.00000000e+00},
    { 51,  3,  3,  1, 0.17902740e+03, 0.29315000e+01, 0.98650000e+00},
    { 51,  4,  0,  0, 0.34030300e+03, 0.00000000e+00, 0.00000000e+00},
    { 51,  4,  0,  1, 0.25216490e+03, 0.00000000e+00, 0.98080000e+00},
    { 51,  4,  0,  2, 0.16453480e+03, 0.00000000e+00, 0.19697000e+01},
    { 51,  4,  1,  0, 0.33206650e+03, 0.97490000e+00, 0.00000000e+00},
    { 51,  4,  1,  1, 0.24635800e+03, 0.97490000e+00, 0.98080000e+00},
    { 51,  4,  1,  2, 0.16122340e+03, 0.97490000e+00, 0.19697000e+01},
    { 51,  4,  2,  0, 0.32111700e+03, 0.19523000e+01, 0.00000000e+00},
    { 51,  4,  2,  1, 0.23860370e+03, 0.19523000e+01, 0.98080000e+00},
    { 51,  4,  2,  2, 0.15675410e+03, 0.19523000e+01, 0.19697000e+01},
    { 51,  4,  3,  0, 0.30744210e+03, 0.29315000e+01, 0.00000000e+00},
    { 51,  4,  3,  1, 0.22888940e+03, 0.29315000e+01, 0.98080000e+00},
    { 51,  4,  3,  2, 0.15112150e+03, 0.29315000e+01, 0.19697000e+01},
    { 51,  5,  0,  0, 0.22904210e+03, 0.00000000e+00, 0.00000000e+00},
    { 51,  5,  0,  1, 0.19255420e+03, 0.00000000e+00, 0.97060000e+00},
    { 51,  5,  0,  2, 0.16155700e+03, 0.00000000e+00, 0.19441000e+01},
    { 51,  5,  0,  3, 0.12268730e+03, 0.00000000e+00, 0.29128000e+01},
    { 51,  5,  0,  4, 0.11540180e+03, 0.00000000e+00, 0.45856000e+01},
    { 51,  5,  1,  0, 0.22424380e+03, 0.97490000e+00, 0.00000000e+00},
    { 51,  5,  1,  1, 0.18865770e+03, 0.97490000e+00, 0.97060000e+00},
    { 51,  5,  1,  2, 0.15840370e+03, 0.97490000e+00, 0.19441000e+01},
    { 51,  5,  1,  3, 0.12050990e+03, 0.97490000e+00, 0.29128000e+01},
    { 51,  5,  1,  4, 0.11338670e+03, 0.97490000e+00, 0.45856000e+01},
    { 51,  5,  2,  0, 0.21779050e+03, 0.19523000e+01, 0.00000000e+00},
    { 51,  5,  2,  1, 0.18340000e+03, 0.19523000e+01, 0.97060000e+00},
    { 51,  5,  2,  2, 0.15413350e+03, 0.19523000e+01, 0.19441000e+01},
    { 51,  5,  2,  3, 0.11753380e+03, 0.19523000e+01, 0.29128000e+01},
    { 51,  5,  2,  4, 0.11062760e+03, 0.19523000e+01, 0.45856000e+01},
    { 51,  5,  3,  0, 0.20967450e+03, 0.29315000e+01, 0.00000000e+00},
    { 51,  5,  3,  1, 0.17677430e+03, 0.29315000e+01, 0.97060000e+00},
    { 51,  5,  3,  2, 0.14873950e+03, 0.29315000e+01, 0.19441000e+01},
    { 51,  5,  3,  3, 0.11375420e+03, 0.29315000e+01, 0.29128000e+01},
    { 51,  5,  3,  4, 0.10712000e+03, 0.29315000e+01, 0.45856000e+01},
    { 51,  6,  0,  0, 0.15448510e+03, 0.00000000e+00, 0.00000000e+00},
    { 51,  6,  0,  1, 0.14484620e+03, 0.00000000e+00, 0.98680000e+00},
    { 51,  6,  0,  2, 0.11803370e+03, 0.00000000e+00, 0.19985000e+01},
    { 51,  6,  0,  3, 0.11040890e+03, 0.00000000e+00, 0.29987000e+01},
    { 51,  6,  0,  4, 0.90179700e+02, 0.00000000e+00, 0.39844000e+01},
    { 51,  6,  1,  0, 0.15163340e+03, 0.97490000e+00, 0.00000000e+00},
    { 51,  6,  1,  1, 0.14217370e+03, 0.97490000e+00, 0.98680000e+00},
    { 51,  6,  1,  2, 0.11597420e+03, 0.97490000e+00, 0.19985000e+01},
    { 51,  6,  1,  3, 0.10848830e+03, 0.97490000e+00, 0.29987000e+01},
    { 51,  6,  1,  4, 0.88743400e+02, 0.97490000e+00, 0.39844000e+01},
    { 51,  6,  2,  0, 0.14775190e+03, 0.19523000e+01, 0.00000000e+00},
    { 51,  6,  2,  1, 0.13853490e+03, 0.19523000e+01, 0.98680000e+00},
    { 51,  6,  2,  2, 0.11315480e+03, 0.19523000e+01, 0.19985000e+01},
    { 51,  6,  2,  3, 0.10585840e+03, 0.19523000e+01, 0.29987000e+01},
    { 51,  6,  2,  4, 0.86757400e+02, 0.19523000e+01, 0.39844000e+01},
    { 51,  6,  3,  0, 0.14283480e+03, 0.29315000e+01, 0.00000000e+00},
    { 51,  6,  3,  1, 0.13392400e+03, 0.29315000e+01, 0.98680000e+00},
    { 51,  6,  3,  2, 0.10957100e+03, 0.29315000e+01, 0.19985000e+01},
    { 51,  6,  3,  3, 0.10251480e+03, 0.29315000e+01, 0.29987000e+01},
    { 51,  6,  3,  4, 0.84217700e+02, 0.29315000e+01, 0.39844000e+01},
    { 51,  7,  0,  0, 0.10784360e+03, 0.00000000e+00, 0.00000000e+00},
    { 51,  7,  0,  1, 0.10051820e+03, 0.00000000e+00, 0.99440000e+00},
    { 51,  7,  0,  2, 0.94365400e+02, 0.00000000e+00, 0.20143000e+01},
    { 51,  7,  0,  3, 0.83057700e+02, 0.00000000e+00, 0.29903000e+01},
    { 51,  7,  1,  0, 0.10605380e+03, 0.97490000e+00, 0.00000000e+00},
    { 51,  7,  1,  1, 0.98858300e+02, 0.97490000e+00, 0.99440000e+00},
    { 51,  7,  1,  2, 0.92826200e+02, 0.97490000e+00, 0.20143000e+01},
    { 51,  7,  1,  3, 0.81727900e+02, 0.97490000e+00, 0.29903000e+01},
    { 51,  7,  2,  0, 0.10359080e+03, 0.19523000e+01, 0.00000000e+00},
    { 51,  7,  2,  1, 0.96572400e+02, 0.19523000e+01, 0.99440000e+00},
    { 51,  7,  2,  2, 0.90704300e+02, 0.19523000e+01, 0.20143000e+01},
    { 51,  7,  2,  3, 0.79891200e+02, 0.19523000e+01, 0.29903000e+01},
    { 51,  7,  3,  0, 0.10045000e+03, 0.29315000e+01, 0.00000000e+00},
    { 51,  7,  3,  1, 0.93656200e+02, 0.29315000e+01, 0.99440000e+00},
    { 51,  7,  3,  2, 0.87995800e+02, 0.29315000e+01, 0.20143000e+01},
    { 51,  7,  3,  3, 0.77544000e+02, 0.29315000e+01, 0.29903000e+01},
    { 51,  8,  0,  0, 0.81535800e+02, 0.00000000e+00, 0.00000000e+00},
    { 51,  8,  0,  1, 0.73071800e+02, 0.00000000e+00, 0.99250000e+00},
    { 51,  8,  0,  2, 0.64429100e+02, 0.00000000e+00, 0.19887000e+01},
    { 51,  8,  1,  0, 0.80289900e+02, 0.97490000e+00, 0.00000000e+00},
    { 51,  8,  1,  1, 0.71981600e+02, 0.97490000e+00, 0.99250000e+00},
    { 51,  8,  1,  2, 0.63497200e+02, 0.97490000e+00, 0.19887000e+01},
    { 51,  8,  2,  0, 0.78560000e+02, 0.19523000e+01, 0.00000000e+00},
    { 51,  8,  2,  1, 0.70463400e+02, 0.19523000e+01, 0.99250000e+00},
    { 51,  8,  2,  2, 0.62195400e+02, 0.19523000e+01, 0.19887000e+01},
    { 51,  8,  3,  0, 0.76342400e+02, 0.29315000e+01, 0.00000000e+00},
    { 51,  8,  3,  1, 0.68514100e+02, 0.29315000e+01, 0.99250000e+00},
    { 51,  8,  3,  2, 0.60520900e+02, 0.29315000e+01, 0.19887000e+01},
    { 51,  9,  0,  0, 0.61691200e+02, 0.00000000e+00, 0.00000000e+00},
    { 51,  9,  0,  1, 0.50147300e+02, 0.00000000e+00, 0.99820000e+00},
    { 51,  9,  1,  0, 0.60817400e+02, 0.97490000e+00, 0.00000000e+00},
    { 51,  9,  1,  1, 0.49497000e+02, 0.97490000e+00, 0.99820000e+00},
    { 51,  9,  2,  0, 0.59593700e+02, 0.19523000e+01, 0.00000000e+00},
    { 51,  9,  2,  1, 0.48576600e+02, 0.19523000e+01, 0.99820000e+00},
    { 51,  9,  3,  0, 0.58017600e+02, 0.29315000e+01, 0.00000000e+00},
    { 51,  9,  3,  1, 0.47383500e+02, 0.29315000e+01, 0.99820000e+00},
    { 51, 10,  0,  0, 0.47407300e+02, 0.00000000e+00, 0.00000000e+00},
    { 51, 10,  1,  0, 0.46777500e+02, 0.97490000e+00, 0.00000000e+00},
    { 51, 10,  2,  0, 0.45889400e+02, 0.19523000e+01, 0.00000000e+00},
    { 51, 10,  3,  0, 0.44740800e+02, 0.29315000e+01, 0.00000000e+00},
    { 51, 11,  0,  0, 0.70169030e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 11,  0,  1, 0.28898880e+03, 0.00000000e+00, 0.96840000e+00},
    { 51, 11,  1,  0, 0.68136500e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 11,  1,  1, 0.28199230e+03, 0.97490000e+00, 0.96840000e+00},
    { 51, 11,  2,  0, 0.65457160e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 11,  2,  1, 0.27268930e+03, 0.19523000e+01, 0.96840000e+00},
    { 51, 11,  3,  0, 0.62119430e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 11,  3,  1, 0.26106680e+03, 0.29315000e+01, 0.96840000e+00},
    { 51, 12,  0,  0, 0.54198260e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 12,  0,  1, 0.44692300e+03, 0.00000000e+00, 0.96280000e+00},
    { 51, 12,  0,  2, 0.29202460e+03, 0.00000000e+00, 0.19496000e+01},
    { 51, 12,  1,  0, 0.52835450e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 12,  1,  1, 0.43599230e+03, 0.97490000e+00, 0.96280000e+00},
    { 51, 12,  1,  2, 0.28572510e+03, 0.97490000e+00, 0.19496000e+01},
    { 51, 12,  2,  0, 0.51028240e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 12,  2,  1, 0.42146260e+03, 0.19523000e+01, 0.96280000e+00},
    { 51, 12,  2,  2, 0.27727810e+03, 0.19523000e+01, 0.19496000e+01},
    { 51, 12,  3,  0, 0.48774180e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 12,  3,  1, 0.40330920e+03, 0.29315000e+01, 0.96280000e+00},
    { 51, 12,  3,  2, 0.26667450e+03, 0.29315000e+01, 0.19496000e+01},
    { 51, 13,  0,  0, 0.49972920e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 13,  0,  1, 0.45284940e+03, 0.00000000e+00, 0.96480000e+00},
    { 51, 13,  0,  2, 0.35278490e+03, 0.00000000e+00, 0.19311000e+01},
    { 51, 13,  0,  3, 0.27473330e+03, 0.00000000e+00, 0.29146000e+01},
    { 51, 13,  1,  0, 0.48798470e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 13,  1,  1, 0.44239460e+03, 0.97490000e+00, 0.96480000e+00},
    { 51, 13,  1,  2, 0.34513030e+03, 0.97490000e+00, 0.19311000e+01},
    { 51, 13,  1,  3, 0.26924000e+03, 0.97490000e+00, 0.29146000e+01},
    { 51, 13,  2,  0, 0.47233520e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 13,  2,  1, 0.42844370e+03, 0.19523000e+01, 0.96480000e+00},
    { 51, 13,  2,  2, 0.33486500e+03, 0.19523000e+01, 0.19311000e+01},
    { 51, 13,  2,  3, 0.26182240e+03, 0.19523000e+01, 0.29146000e+01},
    { 51, 13,  3,  0, 0.45276050e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 13,  3,  1, 0.41097880e+03, 0.29315000e+01, 0.96480000e+00},
    { 51, 13,  3,  2, 0.32197480e+03, 0.29315000e+01, 0.19311000e+01},
    { 51, 13,  3,  3, 0.25247130e+03, 0.29315000e+01, 0.29146000e+01},
    { 51, 14,  0,  0, 0.39368990e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 14,  0,  1, 0.36378460e+03, 0.00000000e+00, 0.95070000e+00},
    { 51, 14,  0,  2, 0.33831890e+03, 0.00000000e+00, 0.19435000e+01},
    { 51, 14,  0,  3, 0.32966250e+03, 0.00000000e+00, 0.29407000e+01},
    { 51, 14,  0,  4, 0.27103870e+03, 0.00000000e+00, 0.38677000e+01},
    { 51, 14,  1,  0, 0.38531020e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 14,  1,  1, 0.35616810e+03, 0.97490000e+00, 0.95070000e+00},
    { 51, 14,  1,  2, 0.33134490e+03, 0.97490000e+00, 0.19435000e+01},
    { 51, 14,  1,  3, 0.32280720e+03, 0.97490000e+00, 0.29407000e+01},
    { 51, 14,  1,  4, 0.26580530e+03, 0.97490000e+00, 0.38677000e+01},
    { 51, 14,  2,  0, 0.37405660e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 14,  2,  1, 0.34592360e+03, 0.19523000e+01, 0.95070000e+00},
    { 51, 14,  2,  2, 0.32195190e+03, 0.19523000e+01, 0.19435000e+01},
    { 51, 14,  2,  3, 0.31357940e+03, 0.19523000e+01, 0.29407000e+01},
    { 51, 14,  2,  4, 0.25871400e+03, 0.19523000e+01, 0.38677000e+01},
    { 51, 14,  3,  0, 0.35991590e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 14,  3,  1, 0.33303840e+03, 0.29315000e+01, 0.95070000e+00},
    { 51, 14,  3,  2, 0.31012840e+03, 0.29315000e+01, 0.19435000e+01},
    { 51, 14,  3,  3, 0.30196690e+03, 0.29315000e+01, 0.29407000e+01},
    { 51, 14,  3,  4, 0.24975520e+03, 0.29315000e+01, 0.38677000e+01},
    { 51, 15,  0,  0, 0.30669120e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 15,  0,  1, 0.29765980e+03, 0.00000000e+00, 0.99470000e+00},
    { 51, 15,  0,  2, 0.29361680e+03, 0.00000000e+00, 0.20102000e+01},
    { 51, 15,  0,  3, 0.27228130e+03, 0.00000000e+00, 0.29859000e+01},
    { 51, 15,  1,  0, 0.30075580e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 15,  1,  1, 0.29192250e+03, 0.97490000e+00, 0.99470000e+00},
    { 51, 15,  1,  2, 0.28792660e+03, 0.97490000e+00, 0.20102000e+01},
    { 51, 15,  1,  3, 0.26714010e+03, 0.97490000e+00, 0.29859000e+01},
    { 51, 15,  2,  0, 0.29271450e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 15,  2,  1, 0.28414620e+03, 0.19523000e+01, 0.99470000e+00},
    { 51, 15,  2,  2, 0.28021780e+03, 0.19523000e+01, 0.20102000e+01},
    { 51, 15,  2,  3, 0.26015780e+03, 0.19523000e+01, 0.29859000e+01},
    { 51, 15,  3,  0, 0.28255640e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 15,  3,  1, 0.27432020e+03, 0.29315000e+01, 0.99470000e+00},
    { 51, 15,  3,  2, 0.27048000e+03, 0.29315000e+01, 0.20102000e+01},
    { 51, 15,  3,  3, 0.25132430e+03, 0.29315000e+01, 0.29859000e+01},
    { 51, 16,  0,  0, 0.25424180e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 16,  0,  1, 0.25143440e+03, 0.00000000e+00, 0.99480000e+00},
    { 51, 16,  0,  2, 0.24633500e+03, 0.00000000e+00, 0.19903000e+01},
    { 51, 16,  1,  0, 0.24964690e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 16,  1,  1, 0.24688440e+03, 0.97490000e+00, 0.99480000e+00},
    { 51, 16,  1,  2, 0.24188440e+03, 0.97490000e+00, 0.19903000e+01},
    { 51, 16,  2,  0, 0.24337850e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 16,  2,  1, 0.24067810e+03, 0.19523000e+01, 0.99480000e+00},
    { 51, 16,  2,  2, 0.23581280e+03, 0.19523000e+01, 0.19903000e+01},
    { 51, 16,  3,  0, 0.23542680e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 16,  3,  1, 0.23280570e+03, 0.29315000e+01, 0.99480000e+00},
    { 51, 16,  3,  2, 0.22811080e+03, 0.29315000e+01, 0.19903000e+01},
    { 51, 17,  0,  0, 0.20740430e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 17,  0,  1, 0.20525120e+03, 0.00000000e+00, 0.99720000e+00},
    { 51, 17,  1,  0, 0.20391030e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 17,  1,  1, 0.20178980e+03, 0.97490000e+00, 0.99720000e+00},
    { 51, 17,  2,  0, 0.19910820e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 17,  2,  1, 0.19703300e+03, 0.19523000e+01, 0.99720000e+00},
    { 51, 17,  3,  0, 0.19298930e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 17,  3,  1, 0.19097240e+03, 0.29315000e+01, 0.99720000e+00},
    { 51, 18,  0,  0, 0.16945330e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 18,  1,  0, 0.16677960e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 18,  2,  0, 0.16307830e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 18,  3,  0, 0.15834200e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 19,  0,  0, 0.11476700e+04, 0.00000000e+00, 0.00000000e+00},
    { 51, 19,  0,  1, 0.39784160e+03, 0.00000000e+00, 0.97670000e+00},
    { 51, 19,  1,  0, 0.11139369e+04, 0.97490000e+00, 0.00000000e+00},
    { 51, 19,  1,  1, 0.38878440e+03, 0.97490000e+00, 0.97670000e+00},
    { 51, 19,  2,  0, 0.10694211e+04, 0.19523000e+01, 0.00000000e+00},
    { 51, 19,  2,  1, 0.37667550e+03, 0.19523000e+01, 0.97670000e+00},
    { 51, 19,  3,  0, 0.10138323e+04, 0.29315000e+01, 0.00000000e+00},
    { 51, 19,  3,  1, 0.36149280e+03, 0.29315000e+01, 0.97670000e+00},
    { 51, 20,  0,  0, 0.95065430e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 20,  0,  1, 0.75979880e+03, 0.00000000e+00, 0.98310000e+00},
    { 51, 20,  0,  2, 0.40901730e+03, 0.00000000e+00, 0.19349000e+01},
    { 51, 20,  1,  0, 0.92532660e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 20,  1,  1, 0.73983800e+03, 0.97490000e+00, 0.98310000e+00},
    { 51, 20,  1,  2, 0.40023370e+03, 0.97490000e+00, 0.19349000e+01},
    { 51, 20,  2,  0, 0.89182320e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 20,  2,  1, 0.71337770e+03, 0.19523000e+01, 0.98310000e+00},
    { 51, 20,  2,  2, 0.38844680e+03, 0.19523000e+01, 0.19349000e+01},
    { 51, 20,  3,  0, 0.85006180e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 20,  3,  1, 0.68031840e+03, 0.29315000e+01, 0.98310000e+00},
    { 51, 20,  3,  2, 0.37364230e+03, 0.29315000e+01, 0.19349000e+01},
    { 51, 21,  0,  0, 0.78583230e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 21,  0,  1, 0.39831520e+03, 0.00000000e+00, 0.18627000e+01},
    { 51, 21,  0,  2, 0.39301150e+03, 0.00000000e+00, 0.28999000e+01},
    { 51, 21,  1,  0, 0.76543030e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 21,  1,  1, 0.38986450e+03, 0.97490000e+00, 0.18627000e+01},
    { 51, 21,  1,  2, 0.38490810e+03, 0.97490000e+00, 0.28999000e+01},
    { 51, 21,  2,  0, 0.73841210e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 21,  2,  1, 0.37851240e+03, 0.19523000e+01, 0.18627000e+01},
    { 51, 21,  2,  2, 0.37399630e+03, 0.19523000e+01, 0.28999000e+01},
    { 51, 21,  3,  0, 0.70472450e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 21,  3,  1, 0.36424560e+03, 0.29315000e+01, 0.18627000e+01},
    { 51, 21,  3,  2, 0.36026270e+03, 0.29315000e+01, 0.28999000e+01},
    { 51, 22,  0,  0, 0.75894060e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 22,  0,  1, 0.38444870e+03, 0.00000000e+00, 0.18299000e+01},
    { 51, 22,  0,  2, 0.39783330e+03, 0.00000000e+00, 0.38675000e+01},
    { 51, 22,  1,  0, 0.73977510e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 22,  1,  1, 0.37633360e+03, 0.97490000e+00, 0.18299000e+01},
    { 51, 22,  1,  2, 0.38965780e+03, 0.97490000e+00, 0.38675000e+01},
    { 51, 22,  2,  0, 0.71434970e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 22,  2,  1, 0.36542570e+03, 0.19523000e+01, 0.18299000e+01},
    { 51, 22,  2,  2, 0.37864590e+03, 0.19523000e+01, 0.38675000e+01},
    { 51, 22,  3,  0, 0.68261700e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 22,  3,  1, 0.35170890e+03, 0.29315000e+01, 0.18299000e+01},
    { 51, 22,  3,  2, 0.36478380e+03, 0.29315000e+01, 0.38675000e+01},
    { 51, 23,  0,  0, 0.69506830e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 23,  0,  1, 0.37675440e+03, 0.00000000e+00, 0.19138000e+01},
    { 51, 23,  0,  2, 0.36401890e+03, 0.00000000e+00, 0.29110000e+01},
    { 51, 23,  1,  0, 0.67780140e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 23,  1,  1, 0.36879080e+03, 0.97490000e+00, 0.19138000e+01},
    { 51, 23,  1,  2, 0.35653490e+03, 0.97490000e+00, 0.29110000e+01},
    { 51, 23,  2,  0, 0.65487180e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 23,  2,  1, 0.35808830e+03, 0.19523000e+01, 0.19138000e+01},
    { 51, 23,  2,  2, 0.34645320e+03, 0.19523000e+01, 0.29110000e+01},
    { 51, 23,  3,  0, 0.62623920e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 23,  3,  1, 0.34463160e+03, 0.29315000e+01, 0.19138000e+01},
    { 51, 23,  3,  2, 0.33375970e+03, 0.29315000e+01, 0.29110000e+01},
    { 51, 24,  0,  0, 0.54719810e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 24,  0,  1, 0.37325910e+03, 0.00000000e+00, 0.18269000e+01},
    { 51, 24,  0,  2, 0.27385520e+03, 0.00000000e+00, 0.10619100e+02},
    { 51, 24,  1,  0, 0.53372530e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 24,  1,  1, 0.36529400e+03, 0.97490000e+00, 0.18269000e+01},
    { 51, 24,  1,  2, 0.26862910e+03, 0.97490000e+00, 0.10619100e+02},
    { 51, 24,  2,  0, 0.51581520e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 24,  2,  1, 0.35459770e+03, 0.19523000e+01, 0.18269000e+01},
    { 51, 24,  2,  2, 0.26154130e+03, 0.19523000e+01, 0.10619100e+02},
    { 51, 24,  3,  0, 0.49343100e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 24,  3,  1, 0.34115480e+03, 0.29315000e+01, 0.18269000e+01},
    { 51, 24,  3,  2, 0.25258170e+03, 0.29315000e+01, 0.10619100e+02},
    { 51, 25,  0,  0, 0.59851680e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 25,  0,  1, 0.34352050e+03, 0.00000000e+00, 0.16406000e+01},
    { 51, 25,  0,  2, 0.23417500e+03, 0.00000000e+00, 0.98849000e+01},
    { 51, 25,  1,  0, 0.58400790e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 25,  1,  1, 0.33651780e+03, 0.97490000e+00, 0.16406000e+01},
    { 51, 25,  1,  2, 0.22991580e+03, 0.97490000e+00, 0.98849000e+01},
    { 51, 25,  2,  0, 0.56471100e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 25,  2,  1, 0.32708070e+03, 0.19523000e+01, 0.16406000e+01},
    { 51, 25,  2,  2, 0.22411260e+03, 0.19523000e+01, 0.98849000e+01},
    { 51, 25,  3,  0, 0.54059460e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 25,  3,  1, 0.31519770e+03, 0.29315000e+01, 0.16406000e+01},
    { 51, 25,  3,  2, 0.21675670e+03, 0.29315000e+01, 0.98849000e+01},
    { 51, 26,  0,  0, 0.46945690e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 26,  0,  1, 0.31786240e+03, 0.00000000e+00, 0.16483000e+01},
    { 51, 26,  0,  2, 0.22988770e+03, 0.00000000e+00, 0.91376000e+01},
    { 51, 26,  1,  0, 0.45821350e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 26,  1,  1, 0.31148590e+03, 0.97490000e+00, 0.16483000e+01},
    { 51, 26,  1,  2, 0.22568120e+03, 0.97490000e+00, 0.91376000e+01},
    { 51, 26,  2,  0, 0.44324120e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 26,  2,  1, 0.30288030e+03, 0.19523000e+01, 0.16483000e+01},
    { 51, 26,  2,  2, 0.21995380e+03, 0.19523000e+01, 0.91376000e+01},
    { 51, 26,  3,  0, 0.42451240e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 26,  3,  1, 0.29203450e+03, 0.29315000e+01, 0.16483000e+01},
    { 51, 26,  3,  2, 0.21269690e+03, 0.29315000e+01, 0.91376000e+01},
    { 51, 27,  0,  0, 0.49804720e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 27,  0,  1, 0.30318560e+03, 0.00000000e+00, 0.17149000e+01},
    { 51, 27,  0,  2, 0.26980100e+03, 0.00000000e+00, 0.29263000e+01},
    { 51, 27,  0,  3, 0.24003960e+03, 0.00000000e+00, 0.77785000e+01},
    { 51, 27,  1,  0, 0.48646450e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 27,  1,  1, 0.29711100e+03, 0.97490000e+00, 0.17149000e+01},
    { 51, 27,  1,  2, 0.26447480e+03, 0.97490000e+00, 0.29263000e+01},
    { 51, 27,  1,  3, 0.23552760e+03, 0.97490000e+00, 0.77785000e+01},
    { 51, 27,  2,  0, 0.47101860e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 27,  2,  1, 0.28891150e+03, 0.19523000e+01, 0.17149000e+01},
    { 51, 27,  2,  2, 0.25727540e+03, 0.19523000e+01, 0.29263000e+01},
    { 51, 27,  2,  3, 0.22940100e+03, 0.19523000e+01, 0.77785000e+01},
    { 51, 27,  3,  0, 0.45168930e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 27,  3,  1, 0.27857600e+03, 0.29315000e+01, 0.17149000e+01},
    { 51, 27,  3,  2, 0.24819240e+03, 0.29315000e+01, 0.29263000e+01},
    { 51, 27,  3,  3, 0.22165120e+03, 0.29315000e+01, 0.77785000e+01},
    { 51, 28,  0,  0, 0.51305850e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 28,  0,  1, 0.29640640e+03, 0.00000000e+00, 0.17937000e+01},
    { 51, 28,  0,  2, 0.25131640e+03, 0.00000000e+00, 0.65458000e+01},
    { 51, 28,  0,  3, 0.26394960e+03, 0.00000000e+00, 0.62918000e+01},
    { 51, 28,  1,  0, 0.50090110e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 28,  1,  1, 0.29044330e+03, 0.97490000e+00, 0.17937000e+01},
    { 51, 28,  1,  2, 0.24645550e+03, 0.97490000e+00, 0.65458000e+01},
    { 51, 28,  1,  3, 0.25861940e+03, 0.97490000e+00, 0.62918000e+01},
    { 51, 28,  2,  0, 0.48471110e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 28,  2,  1, 0.28239730e+03, 0.19523000e+01, 0.17937000e+01},
    { 51, 28,  2,  2, 0.23987350e+03, 0.19523000e+01, 0.65458000e+01},
    { 51, 28,  2,  3, 0.25143010e+03, 0.19523000e+01, 0.62918000e+01},
    { 51, 28,  3,  0, 0.46446650e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 28,  3,  1, 0.27225780e+03, 0.29315000e+01, 0.17937000e+01},
    { 51, 28,  3,  2, 0.23156140e+03, 0.29315000e+01, 0.65458000e+01},
    { 51, 28,  3,  3, 0.24237210e+03, 0.29315000e+01, 0.62918000e+01},
    { 51, 29,  0,  0, 0.39302490e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 29,  0,  1, 0.29285890e+03, 0.00000000e+00, 0.95760000e+00},
    { 51, 29,  1,  0, 0.38380100e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 29,  1,  1, 0.28674360e+03, 0.97490000e+00, 0.95760000e+00},
    { 51, 29,  2,  0, 0.37150280e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 29,  2,  1, 0.27851920e+03, 0.19523000e+01, 0.95760000e+00},
    { 51, 29,  3,  0, 0.35610950e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 29,  3,  1, 0.26817480e+03, 0.29315000e+01, 0.95760000e+00},
    { 51, 30,  0,  0, 0.40386210e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 30,  0,  1, 0.27478160e+03, 0.00000000e+00, 0.19419000e+01},
    { 51, 30,  1,  0, 0.39484340e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 30,  1,  1, 0.26942080e+03, 0.97490000e+00, 0.19419000e+01},
    { 51, 30,  2,  0, 0.38278190e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 30,  2,  1, 0.26216840e+03, 0.19523000e+01, 0.19419000e+01},
    { 51, 30,  3,  0, 0.36766370e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 30,  3,  1, 0.25301490e+03, 0.29315000e+01, 0.19419000e+01},
    { 51, 31,  0,  0, 0.47839930e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 31,  0,  1, 0.44930060e+03, 0.00000000e+00, 0.96010000e+00},
    { 51, 31,  0,  2, 0.35584740e+03, 0.00000000e+00, 0.19315000e+01},
    { 51, 31,  0,  3, 0.29096000e+03, 0.00000000e+00, 0.29233000e+01},
    { 51, 31,  1,  0, 0.46751190e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 31,  1,  1, 0.43926920e+03, 0.97490000e+00, 0.96010000e+00},
    { 51, 31,  1,  2, 0.34844250e+03, 0.97490000e+00, 0.19315000e+01},
    { 51, 31,  1,  3, 0.28533630e+03, 0.97490000e+00, 0.29233000e+01},
    { 51, 31,  2,  0, 0.45296620e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 31,  2,  1, 0.42584750e+03, 0.19523000e+01, 0.96010000e+00},
    { 51, 31,  2,  2, 0.33847720e+03, 0.19523000e+01, 0.19315000e+01},
    { 51, 31,  2,  3, 0.27771860e+03, 0.19523000e+01, 0.29233000e+01},
    { 51, 31,  3,  0, 0.43474170e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 31,  3,  1, 0.40901750e+03, 0.29315000e+01, 0.96010000e+00},
    { 51, 31,  3,  2, 0.32593780e+03, 0.29315000e+01, 0.19315000e+01},
    { 51, 31,  3,  3, 0.26809680e+03, 0.29315000e+01, 0.29233000e+01},
    { 51, 32,  0,  0, 0.42186160e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 32,  0,  1, 0.39458220e+03, 0.00000000e+00, 0.94340000e+00},
    { 51, 32,  0,  2, 0.37560470e+03, 0.00000000e+00, 0.19447000e+01},
    { 51, 32,  0,  3, 0.33642890e+03, 0.00000000e+00, 0.29186000e+01},
    { 51, 32,  0,  4, 0.29681450e+03, 0.00000000e+00, 0.38972000e+01},
    { 51, 32,  1,  0, 0.41296610e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 32,  1,  1, 0.38642600e+03, 0.97490000e+00, 0.94340000e+00},
    { 51, 32,  1,  2, 0.36794630e+03, 0.97490000e+00, 0.19447000e+01},
    { 51, 32,  1,  3, 0.32980470e+03, 0.97490000e+00, 0.29186000e+01},
    { 51, 32,  1,  4, 0.29123020e+03, 0.97490000e+00, 0.38972000e+01},
    { 51, 32,  2,  0, 0.40100980e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 32,  2,  1, 0.37544380e+03, 0.19523000e+01, 0.94340000e+00},
    { 51, 32,  2,  2, 0.35762210e+03, 0.19523000e+01, 0.19447000e+01},
    { 51, 32,  2,  3, 0.32084600e+03, 0.19523000e+01, 0.29186000e+01},
    { 51, 32,  2,  4, 0.28364510e+03, 0.19523000e+01, 0.38972000e+01},
    { 51, 32,  3,  0, 0.38597850e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 32,  3,  1, 0.36162180e+03, 0.29315000e+01, 0.94340000e+00},
    { 51, 32,  3,  2, 0.34461890e+03, 0.29315000e+01, 0.19447000e+01},
    { 51, 32,  3,  3, 0.30954100e+03, 0.29315000e+01, 0.29186000e+01},
    { 51, 32,  3,  4, 0.27404840e+03, 0.29315000e+01, 0.38972000e+01},
    { 51, 33,  0,  0, 0.35955640e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 33,  0,  1, 0.35342450e+03, 0.00000000e+00, 0.98890000e+00},
    { 51, 33,  0,  2, 0.34410360e+03, 0.00000000e+00, 0.19793000e+01},
    { 51, 33,  0,  3, 0.33139460e+03, 0.00000000e+00, 0.29709000e+01},
    { 51, 33,  1,  0, 0.35254270e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 33,  1,  1, 0.34656560e+03, 0.97490000e+00, 0.98890000e+00},
    { 51, 33,  1,  2, 0.33748280e+03, 0.97490000e+00, 0.19793000e+01},
    { 51, 33,  1,  3, 0.32509990e+03, 0.97490000e+00, 0.29709000e+01},
    { 51, 33,  2,  0, 0.34304870e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 33,  2,  1, 0.33727630e+03, 0.19523000e+01, 0.98890000e+00},
    { 51, 33,  2,  2, 0.32850830e+03, 0.19523000e+01, 0.19793000e+01},
    { 51, 33,  2,  3, 0.31655690e+03, 0.19523000e+01, 0.29709000e+01},
    { 51, 33,  3,  0, 0.33106180e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 33,  3,  1, 0.32554390e+03, 0.29315000e+01, 0.98890000e+00},
    { 51, 33,  3,  2, 0.31716790e+03, 0.29315000e+01, 0.19793000e+01},
    { 51, 33,  3,  3, 0.30575380e+03, 0.29315000e+01, 0.29709000e+01},
    { 51, 34,  0,  0, 0.32236080e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 34,  0,  1, 0.32248120e+03, 0.00000000e+00, 0.99010000e+00},
    { 51, 34,  0,  2, 0.31993540e+03, 0.00000000e+00, 0.19812000e+01},
    { 51, 34,  1,  0, 0.31639840e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 34,  1,  1, 0.31651250e+03, 0.97490000e+00, 0.99010000e+00},
    { 51, 34,  1,  2, 0.31402340e+03, 0.97490000e+00, 0.19812000e+01},
    { 51, 34,  2,  0, 0.30828460e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 34,  2,  1, 0.30839060e+03, 0.19523000e+01, 0.99010000e+00},
    { 51, 34,  2,  2, 0.30597730e+03, 0.19523000e+01, 0.19812000e+01},
    { 51, 34,  3,  0, 0.29800720e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 34,  3,  1, 0.29810330e+03, 0.29315000e+01, 0.99010000e+00},
    { 51, 34,  3,  2, 0.29578510e+03, 0.29315000e+01, 0.19812000e+01},
    { 51, 35,  0,  0, 0.28180500e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 35,  0,  1, 0.28377610e+03, 0.00000000e+00, 0.99740000e+00},
    { 51, 35,  1,  0, 0.27688560e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 35,  1,  1, 0.27880760e+03, 0.97490000e+00, 0.99740000e+00},
    { 51, 35,  2,  0, 0.27015060e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 35,  2,  1, 0.27200760e+03, 0.19523000e+01, 0.99740000e+00},
    { 51, 35,  3,  0, 0.26158890e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 35,  3,  1, 0.26336490e+03, 0.29315000e+01, 0.99740000e+00},
    { 51, 36,  0,  0, 0.24479020e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 36,  1,  0, 0.24075150e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 36,  2,  0, 0.23518820e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 36,  3,  0, 0.22809040e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 37,  0,  0, 0.12861750e+04, 0.00000000e+00, 0.00000000e+00},
    { 51, 37,  0,  1, 0.47456410e+03, 0.00000000e+00, 0.97380000e+00},
    { 51, 37,  1,  0, 0.12488109e+04, 0.97490000e+00, 0.00000000e+00},
    { 51, 37,  1,  1, 0.46396320e+03, 0.97490000e+00, 0.97380000e+00},
    { 51, 37,  2,  0, 0.11994646e+04, 0.19523000e+01, 0.00000000e+00},
    { 51, 37,  2,  1, 0.44976690e+03, 0.19523000e+01, 0.97380000e+00},
    { 51, 37,  3,  0, 0.11378099e+04, 0.29315000e+01, 0.00000000e+00},
    { 51, 37,  3,  1, 0.43194800e+03, 0.29315000e+01, 0.97380000e+00},
    { 51, 38,  0,  0, 0.11321713e+04, 0.00000000e+00, 0.00000000e+00},
    { 51, 38,  0,  1, 0.92413690e+03, 0.00000000e+00, 0.98010000e+00},
    { 51, 38,  0,  2, 0.48982280e+03, 0.00000000e+00, 0.19143000e+01},
    { 51, 38,  1,  0, 0.11019644e+04, 0.97490000e+00, 0.00000000e+00},
    { 51, 38,  1,  1, 0.89977960e+03, 0.97490000e+00, 0.98010000e+00},
    { 51, 38,  1,  2, 0.47938630e+03, 0.97490000e+00, 0.19143000e+01},
    { 51, 38,  2,  0, 0.10619947e+04, 0.19523000e+01, 0.00000000e+00},
    { 51, 38,  2,  1, 0.86748280e+03, 0.19523000e+01, 0.98010000e+00},
    { 51, 38,  2,  2, 0.46536830e+03, 0.19523000e+01, 0.19143000e+01},
    { 51, 38,  3,  0, 0.10121518e+04, 0.29315000e+01, 0.00000000e+00},
    { 51, 38,  3,  1, 0.82711060e+03, 0.29315000e+01, 0.98010000e+00},
    { 51, 38,  3,  2, 0.44775000e+03, 0.29315000e+01, 0.19143000e+01},
    { 51, 39,  0,  0, 0.99240010e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 39,  0,  1, 0.70709330e+03, 0.00000000e+00, 0.19153000e+01},
    { 51, 39,  0,  2, 0.47140640e+03, 0.00000000e+00, 0.28903000e+01},
    { 51, 39,  1,  0, 0.96716720e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 39,  1,  1, 0.69024350e+03, 0.97490000e+00, 0.19153000e+01},
    { 51, 39,  1,  2, 0.46187660e+03, 0.97490000e+00, 0.28903000e+01},
    { 51, 39,  2,  0, 0.93369560e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 39,  2,  1, 0.66777030e+03, 0.19523000e+01, 0.19153000e+01},
    { 51, 39,  2,  2, 0.44902050e+03, 0.19523000e+01, 0.28903000e+01},
    { 51, 39,  3,  0, 0.89191400e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 39,  3,  1, 0.63960320e+03, 0.29315000e+01, 0.19153000e+01},
    { 51, 39,  3,  2, 0.43282190e+03, 0.29315000e+01, 0.28903000e+01},
    { 51, 40,  0,  0, 0.89208770e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 40,  0,  1, 0.52654260e+03, 0.00000000e+00, 0.19355000e+01},
    { 51, 40,  0,  2, 0.47538210e+03, 0.00000000e+00, 0.39106000e+01},
    { 51, 40,  1,  0, 0.87013340e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 40,  1,  1, 0.51535410e+03, 0.97490000e+00, 0.19355000e+01},
    { 51, 40,  1,  2, 0.46592890e+03, 0.97490000e+00, 0.39106000e+01},
    { 51, 40,  2,  0, 0.84095330e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 40,  2,  1, 0.50031680e+03, 0.19523000e+01, 0.19355000e+01},
    { 51, 40,  2,  2, 0.45315700e+03, 0.19523000e+01, 0.39106000e+01},
    { 51, 40,  3,  0, 0.80449370e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 40,  3,  1, 0.48140710e+03, 0.29315000e+01, 0.19355000e+01},
    { 51, 40,  3,  2, 0.43705000e+03, 0.29315000e+01, 0.39106000e+01},
    { 51, 41,  0,  0, 0.81343450e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 41,  0,  1, 0.53174240e+03, 0.00000000e+00, 0.19545000e+01},
    { 51, 41,  0,  2, 0.45957500e+03, 0.00000000e+00, 0.29225000e+01},
    { 51, 41,  1,  0, 0.79387710e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 41,  1,  1, 0.52041820e+03, 0.97490000e+00, 0.19545000e+01},
    { 51, 41,  1,  2, 0.45041590e+03, 0.97490000e+00, 0.29225000e+01},
    { 51, 41,  2,  0, 0.76784150e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 41,  2,  1, 0.50520350e+03, 0.19523000e+01, 0.19545000e+01},
    { 51, 41,  2,  2, 0.43804100e+03, 0.19523000e+01, 0.29225000e+01},
    { 51, 41,  3,  0, 0.73528120e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 41,  3,  1, 0.48607860e+03, 0.29315000e+01, 0.19545000e+01},
    { 51, 41,  3,  2, 0.42243200e+03, 0.29315000e+01, 0.29225000e+01},
    { 51, 42,  0,  0, 0.62768490e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 42,  0,  1, 0.49569480e+03, 0.00000000e+00, 0.19420000e+01},
    { 51, 42,  0,  2, 0.40603120e+03, 0.00000000e+00, 0.11055600e+02},
    { 51, 42,  1,  0, 0.61324700e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 42,  1,  1, 0.48533740e+03, 0.97490000e+00, 0.19420000e+01},
    { 51, 42,  1,  2, 0.39833180e+03, 0.97490000e+00, 0.11055600e+02},
    { 51, 42,  2,  0, 0.59396240e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 42,  2,  1, 0.47139900e+03, 0.19523000e+01, 0.19420000e+01},
    { 51, 42,  2,  2, 0.38788180e+03, 0.19523000e+01, 0.11055600e+02},
    { 51, 42,  3,  0, 0.56979780e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 42,  3,  1, 0.45385780e+03, 0.29315000e+01, 0.19420000e+01},
    { 51, 42,  3,  2, 0.37466630e+03, 0.29315000e+01, 0.11055600e+02},
    { 51, 43,  0,  0, 0.70051630e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 43,  0,  1, 0.55577940e+03, 0.00000000e+00, 0.16682000e+01},
    { 51, 43,  0,  2, 0.35815190e+03, 0.00000000e+00, 0.95402000e+01},
    { 51, 43,  1,  0, 0.68412920e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 43,  1,  1, 0.54348220e+03, 0.97490000e+00, 0.16682000e+01},
    { 51, 43,  1,  2, 0.35163900e+03, 0.97490000e+00, 0.95402000e+01},
    { 51, 43,  2,  0, 0.66226990e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 43,  2,  1, 0.52700000e+03, 0.19523000e+01, 0.16682000e+01},
    { 51, 43,  2,  2, 0.34276350e+03, 0.19523000e+01, 0.95402000e+01},
    { 51, 43,  3,  0, 0.63489910e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 43,  3,  1, 0.50629760e+03, 0.29315000e+01, 0.16682000e+01},
    { 51, 43,  3,  2, 0.33151190e+03, 0.29315000e+01, 0.95402000e+01},
    { 51, 44,  0,  0, 0.53338040e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 44,  0,  1, 0.43198650e+03, 0.00000000e+00, 0.18584000e+01},
    { 51, 44,  0,  2, 0.33835410e+03, 0.00000000e+00, 0.88895000e+01},
    { 51, 44,  1,  0, 0.52150710e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 44,  1,  1, 0.42337510e+03, 0.97490000e+00, 0.18584000e+01},
    { 51, 44,  1,  2, 0.33229950e+03, 0.97490000e+00, 0.88895000e+01},
    { 51, 44,  2,  0, 0.50560890e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 44,  2,  1, 0.41174300e+03, 0.19523000e+01, 0.18584000e+01},
    { 51, 44,  2,  2, 0.32403570e+03, 0.19523000e+01, 0.88895000e+01},
    { 51, 44,  3,  0, 0.48565920e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 44,  3,  1, 0.39707420e+03, 0.29315000e+01, 0.18584000e+01},
    { 51, 44,  3,  2, 0.31355000e+03, 0.29315000e+01, 0.88895000e+01},
    { 51, 45,  0,  0, 0.58333460e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 45,  0,  1, 0.40403840e+03, 0.00000000e+00, 0.19003000e+01},
    { 51, 45,  0,  2, 0.34480820e+03, 0.00000000e+00, 0.29696000e+01},
    { 51, 45,  1,  0, 0.57027900e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 45,  1,  1, 0.39603590e+03, 0.97490000e+00, 0.19003000e+01},
    { 51, 45,  1,  2, 0.33834720e+03, 0.97490000e+00, 0.29696000e+01},
    { 51, 45,  2,  0, 0.55281280e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 45,  2,  1, 0.38521960e+03, 0.19523000e+01, 0.19003000e+01},
    { 51, 45,  2,  2, 0.32956900e+03, 0.19523000e+01, 0.29696000e+01},
    { 51, 45,  3,  0, 0.53091130e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 45,  3,  1, 0.37157400e+03, 0.29315000e+01, 0.19003000e+01},
    { 51, 45,  3,  2, 0.31846020e+03, 0.29315000e+01, 0.29696000e+01},
    { 51, 46,  0,  0, 0.54091250e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 46,  0,  1, 0.37509950e+03, 0.00000000e+00, 0.18630000e+01},
    { 51, 46,  0,  2, 0.36034200e+03, 0.00000000e+00, 0.57095000e+01},
    { 51, 46,  1,  0, 0.52899540e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 46,  1,  1, 0.36774930e+03, 0.97490000e+00, 0.18630000e+01},
    { 51, 46,  1,  2, 0.35348570e+03, 0.97490000e+00, 0.57095000e+01},
    { 51, 46,  2,  0, 0.51303450e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 46,  2,  1, 0.35780550e+03, 0.19523000e+01, 0.18630000e+01},
    { 51, 46,  2,  2, 0.34418570e+03, 0.19523000e+01, 0.57095000e+01},
    { 51, 46,  3,  0, 0.49300840e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 46,  3,  1, 0.34525330e+03, 0.29315000e+01, 0.18630000e+01},
    { 51, 46,  3,  2, 0.33242910e+03, 0.29315000e+01, 0.57095000e+01},
    { 51, 47,  0,  0, 0.45064270e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 47,  0,  1, 0.36287400e+03, 0.00000000e+00, 0.96790000e+00},
    { 51, 47,  1,  0, 0.44070410e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 47,  1,  1, 0.35570800e+03, 0.97490000e+00, 0.96790000e+00},
    { 51, 47,  2,  0, 0.42738710e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 47,  2,  1, 0.34602160e+03, 0.19523000e+01, 0.96790000e+00},
    { 51, 47,  3,  0, 0.41066850e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 47,  3,  1, 0.33380120e+03, 0.29315000e+01, 0.96790000e+00},
    { 51, 48,  0,  0, 0.47657830e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 48,  0,  1, 0.35905550e+03, 0.00000000e+00, 0.19539000e+01},
    { 51, 48,  1,  0, 0.46629410e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 48,  1,  1, 0.35221320e+03, 0.97490000e+00, 0.19539000e+01},
    { 51, 48,  2,  0, 0.45249980e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 48,  2,  1, 0.34293620e+03, 0.19523000e+01, 0.19539000e+01},
    { 51, 48,  3,  0, 0.43517770e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 48,  3,  1, 0.33121190e+03, 0.29315000e+01, 0.19539000e+01},
    { 51, 49,  0,  0, 0.59828910e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 49,  0,  1, 0.57030150e+03, 0.00000000e+00, 0.96330000e+00},
    { 51, 49,  0,  2, 0.45876760e+03, 0.00000000e+00, 0.19378000e+01},
    { 51, 49,  0,  3, 0.39051070e+03, 0.00000000e+00, 0.29353000e+01},
    { 51, 49,  1,  0, 0.58471100e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 49,  1,  1, 0.55762720e+03, 0.97490000e+00, 0.96330000e+00},
    { 51, 49,  1,  2, 0.44934480e+03, 0.97490000e+00, 0.19378000e+01},
    { 51, 49,  1,  3, 0.38302800e+03, 0.97490000e+00, 0.29353000e+01},
    { 51, 49,  2,  0, 0.56656420e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 49,  2,  1, 0.54066240e+03, 0.19523000e+01, 0.96330000e+00},
    { 51, 49,  2,  2, 0.43665200e+03, 0.19523000e+01, 0.19378000e+01},
    { 51, 49,  2,  3, 0.37288760e+03, 0.19523000e+01, 0.29353000e+01},
    { 51, 49,  3,  0, 0.54381980e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 49,  3,  1, 0.51938200e+03, 0.29315000e+01, 0.96330000e+00},
    { 51, 49,  3,  2, 0.42067140e+03, 0.29315000e+01, 0.19378000e+01},
    { 51, 49,  3,  3, 0.36007570e+03, 0.29315000e+01, 0.29353000e+01},
    { 51, 50,  0,  0, 0.55335920e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 50,  0,  1, 0.51594670e+03, 0.00000000e+00, 0.95140000e+00},
    { 51, 50,  0,  2, 0.49873950e+03, 0.00000000e+00, 0.19505000e+01},
    { 51, 50,  0,  3, 0.44897690e+03, 0.00000000e+00, 0.29259000e+01},
    { 51, 50,  0,  4, 0.40568490e+03, 0.00000000e+00, 0.39123000e+01},
    { 51, 50,  1,  0, 0.54152090e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 50,  1,  1, 0.50519000e+03, 0.97490000e+00, 0.95140000e+00},
    { 51, 50,  1,  2, 0.48848390e+03, 0.97490000e+00, 0.19505000e+01},
    { 51, 50,  1,  3, 0.44010850e+03, 0.97490000e+00, 0.29259000e+01},
    { 51, 50,  1,  4, 0.39800110e+03, 0.97490000e+00, 0.39123000e+01},
    { 51, 50,  2,  0, 0.52563100e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 50,  2,  1, 0.49072030e+03, 0.19523000e+01, 0.95140000e+00},
    { 51, 50,  2,  2, 0.47467200e+03, 0.19523000e+01, 0.19505000e+01},
    { 51, 50,  2,  3, 0.42812220e+03, 0.19523000e+01, 0.29259000e+01},
    { 51, 50,  2,  4, 0.38757520e+03, 0.19523000e+01, 0.39123000e+01},
    { 51, 50,  3,  0, 0.50566970e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 50,  3,  1, 0.47251890e+03, 0.29315000e+01, 0.95140000e+00},
    { 51, 50,  3,  2, 0.45728600e+03, 0.29315000e+01, 0.19505000e+01},
    { 51, 50,  3,  3, 0.41300240e+03, 0.29315000e+01, 0.29259000e+01},
    { 51, 50,  3,  4, 0.37439290e+03, 0.29315000e+01, 0.39123000e+01},
    { 51, 51,  0,  0, 0.49293790e+03, 0.00000000e+00, 0.00000000e+00},
    { 51, 51,  1,  0, 0.48305960e+03, 0.97490000e+00, 0.00000000e+00},
    { 51, 51,  1,  1, 0.47347030e+03, 0.97490000e+00, 0.97490000e+00},
    { 51, 51,  2,  0, 0.46972550e+03, 0.19523000e+01, 0.00000000e+00},
    { 51, 51,  2,  1, 0.46051500e+03, 0.19523000e+01, 0.97490000e+00},
    { 51, 51,  2,  2, 0.44805730e+03, 0.19523000e+01, 0.19523000e+01},
    { 51, 51,  3,  0, 0.45291870e+03, 0.29315000e+01, 0.00000000e+00},
    { 51, 51,  3,  1, 0.44417700e+03, 0.29315000e+01, 0.97490000e+00},
    { 51, 51,  3,  2, 0.43233570e+03, 0.29315000e+01, 0.19523000e+01},
    { 51, 51,  3,  3, 0.41737900e+03, 0.29315000e+01, 0.29315000e+01},
    { 52,  1,  0,  0, 0.35484100e+02, 0.00000000e+00, 0.91180000e+00},
    { 52,  1,  0,  1, 0.56742700e+02, 0.00000000e+00, 0.00000000e+00},
    { 52,  1,  1,  0, 0.35486100e+02, 0.98110000e+00, 0.91180000e+00},
    { 52,  1,  1,  1, 0.56715600e+02, 0.98110000e+00, 0.00000000e+00},
    { 52,  1,  2,  0, 0.35246100e+02, 0.19639000e+01, 0.91180000e+00},
    { 52,  1,  2,  1, 0.56276900e+02, 0.19639000e+01, 0.00000000e+00},
    { 52,  2,  0,  0, 0.23691100e+02, 0.00000000e+00, 0.00000000e+00},
    { 52,  2,  1,  0, 0.23710000e+02, 0.98110000e+00, 0.00000000e+00},
    { 52,  2,  2,  0, 0.23585100e+02, 0.19639000e+01, 0.00000000e+00},
    { 52,  3,  0,  0, 0.52125110e+03, 0.00000000e+00, 0.00000000e+00},
    { 52,  3,  0,  1, 0.18030560e+03, 0.00000000e+00, 0.98650000e+00},
    { 52,  3,  1,  0, 0.51945180e+03, 0.98110000e+00, 0.00000000e+00},
    { 52,  3,  1,  1, 0.17998120e+03, 0.98110000e+00, 0.98650000e+00},
    { 52,  3,  2,  0, 0.51271640e+03, 0.19639000e+01, 0.00000000e+00},
    { 52,  3,  2,  1, 0.17817450e+03, 0.19639000e+01, 0.98650000e+00},
    { 52,  4,  0,  0, 0.30954390e+03, 0.00000000e+00, 0.00000000e+00},
    { 52,  4,  0,  1, 0.23063090e+03, 0.00000000e+00, 0.98080000e+00},
    { 52,  4,  0,  2, 0.15249560e+03, 0.00000000e+00, 0.19697000e+01},
    { 52,  4,  1,  0, 0.30894260e+03, 0.98110000e+00, 0.00000000e+00},
    { 52,  4,  1,  1, 0.23026410e+03, 0.98110000e+00, 0.98080000e+00},
    { 52,  4,  1,  2, 0.15238060e+03, 0.98110000e+00, 0.19697000e+01},
    { 52,  4,  2,  0, 0.30576290e+03, 0.19639000e+01, 0.00000000e+00},
    { 52,  4,  2,  1, 0.22803400e+03, 0.19639000e+01, 0.98080000e+00},
    { 52,  4,  2,  2, 0.15112750e+03, 0.19639000e+01, 0.19697000e+01},
    { 52,  5,  0,  0, 0.21148980e+03, 0.00000000e+00, 0.00000000e+00},
    { 52,  5,  0,  1, 0.17839190e+03, 0.00000000e+00, 0.97060000e+00},
    { 52,  5,  0,  2, 0.15017540e+03, 0.00000000e+00, 0.19441000e+01},
    { 52,  5,  0,  3, 0.11497520e+03, 0.00000000e+00, 0.29128000e+01},
    { 52,  5,  0,  4, 0.10829220e+03, 0.00000000e+00, 0.45856000e+01},
    { 52,  5,  1,  0, 0.21127990e+03, 0.98110000e+00, 0.00000000e+00},
    { 52,  5,  1,  1, 0.17825090e+03, 0.98110000e+00, 0.97060000e+00},
    { 52,  5,  1,  2, 0.15008700e+03, 0.98110000e+00, 0.19441000e+01},
    { 52,  5,  1,  3, 0.11496400e+03, 0.98110000e+00, 0.29128000e+01},
    { 52,  5,  1,  4, 0.10828980e+03, 0.98110000e+00, 0.45856000e+01},
    { 52,  5,  2,  0, 0.20945590e+03, 0.19639000e+01, 0.00000000e+00},
    { 52,  5,  2,  1, 0.17677650e+03, 0.19639000e+01, 0.97060000e+00},
    { 52,  5,  2,  2, 0.14889980e+03, 0.19639000e+01, 0.19441000e+01},
    { 52,  5,  2,  3, 0.11415530e+03, 0.19639000e+01, 0.29128000e+01},
    { 52,  5,  2,  4, 0.10754340e+03, 0.19639000e+01, 0.45856000e+01},
    { 52,  6,  0,  0, 0.14430320e+03, 0.00000000e+00, 0.00000000e+00},
    { 52,  6,  0,  1, 0.13531220e+03, 0.00000000e+00, 0.98680000e+00},
    { 52,  6,  0,  2, 0.11077470e+03, 0.00000000e+00, 0.19985000e+01},
    { 52,  6,  0,  3, 0.10365030e+03, 0.00000000e+00, 0.29987000e+01},
    { 52,  6,  0,  4, 0.85234300e+02, 0.00000000e+00, 0.39844000e+01},
    { 52,  6,  1,  0, 0.14426000e+03, 0.98110000e+00, 0.00000000e+00},
    { 52,  6,  1,  1, 0.13527200e+03, 0.98110000e+00, 0.98680000e+00},
    { 52,  6,  1,  2, 0.11077110e+03, 0.98110000e+00, 0.19985000e+01},
    { 52,  6,  1,  3, 0.10364770e+03, 0.98110000e+00, 0.29987000e+01},
    { 52,  6,  1,  4, 0.85265700e+02, 0.98110000e+00, 0.39844000e+01},
    { 52,  6,  2,  0, 0.14319470e+03, 0.19639000e+01, 0.00000000e+00},
    { 52,  6,  2,  1, 0.13427420e+03, 0.19639000e+01, 0.98680000e+00},
    { 52,  6,  2,  2, 0.11000870e+03, 0.19639000e+01, 0.19985000e+01},
    { 52,  6,  2,  3, 0.10293730e+03, 0.19639000e+01, 0.29987000e+01},
    { 52,  6,  2,  4, 0.84742500e+02, 0.19639000e+01, 0.39844000e+01},
    { 52,  7,  0,  0, 0.10161240e+03, 0.00000000e+00, 0.00000000e+00},
    { 52,  7,  0,  1, 0.94750800e+02, 0.00000000e+00, 0.99440000e+00},
    { 52,  7,  0,  2, 0.89035900e+02, 0.00000000e+00, 0.20143000e+01},
    { 52,  7,  0,  3, 0.78481900e+02, 0.00000000e+00, 0.29903000e+01},
    { 52,  7,  1,  0, 0.10163150e+03, 0.98110000e+00, 0.00000000e+00},
    { 52,  7,  1,  1, 0.94770500e+02, 0.98110000e+00, 0.99440000e+00},
    { 52,  7,  1,  2, 0.89058200e+02, 0.98110000e+00, 0.20143000e+01},
    { 52,  7,  1,  3, 0.78506700e+02, 0.98110000e+00, 0.29903000e+01},
    { 52,  7,  2,  0, 0.10097450e+03, 0.19639000e+01, 0.00000000e+00},
    { 52,  7,  2,  1, 0.94162200e+02, 0.19639000e+01, 0.99440000e+00},
    { 52,  7,  2,  2, 0.88495300e+02, 0.19639000e+01, 0.20143000e+01},
    { 52,  7,  2,  3, 0.78022400e+02, 0.19639000e+01, 0.29903000e+01},
    { 52,  8,  0,  0, 0.77297000e+02, 0.00000000e+00, 0.00000000e+00},
    { 52,  8,  0,  1, 0.69390100e+02, 0.00000000e+00, 0.99250000e+00},
    { 52,  8,  0,  2, 0.61315900e+02, 0.00000000e+00, 0.19887000e+01},
    { 52,  8,  1,  0, 0.77336500e+02, 0.98110000e+00, 0.00000000e+00},
    { 52,  8,  1,  1, 0.69431700e+02, 0.98110000e+00, 0.99250000e+00},
    { 52,  8,  1,  2, 0.61358500e+02, 0.98110000e+00, 0.19887000e+01},
    { 52,  8,  2,  0, 0.76886300e+02, 0.19639000e+01, 0.00000000e+00},
    { 52,  8,  2,  1, 0.69039900e+02, 0.19639000e+01, 0.99250000e+00},
    { 52,  8,  2,  2, 0.61025800e+02, 0.19639000e+01, 0.19887000e+01},
    { 52,  9,  0,  0, 0.58788100e+02, 0.00000000e+00, 0.00000000e+00},
    { 52,  9,  0,  1, 0.48053500e+02, 0.00000000e+00, 0.99820000e+00},
    { 52,  9,  1,  0, 0.58833200e+02, 0.98110000e+00, 0.00000000e+00},
    { 52,  9,  1,  1, 0.48103700e+02, 0.98110000e+00, 0.99820000e+00},
    { 52,  9,  2,  0, 0.58522300e+02, 0.19639000e+01, 0.00000000e+00},
    { 52,  9,  2,  1, 0.47877100e+02, 0.19639000e+01, 0.99820000e+00},
    { 52, 10,  0,  0, 0.45361300e+02, 0.00000000e+00, 0.00000000e+00},
    { 52, 10,  1,  0, 0.45404400e+02, 0.98110000e+00, 0.00000000e+00},
    { 52, 10,  2,  0, 0.45183600e+02, 0.19639000e+01, 0.00000000e+00},
    { 52, 11,  0,  0, 0.62440760e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 11,  0,  1, 0.26288460e+03, 0.00000000e+00, 0.96840000e+00},
    { 52, 11,  1,  0, 0.62230990e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 11,  1,  1, 0.26236970e+03, 0.98110000e+00, 0.96840000e+00},
    { 52, 11,  2,  0, 0.61435230e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 11,  2,  1, 0.25966980e+03, 0.19639000e+01, 0.96840000e+00},
    { 52, 12,  0,  0, 0.49087600e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 12,  0,  1, 0.40607280e+03, 0.00000000e+00, 0.96280000e+00},
    { 52, 12,  0,  2, 0.26885950e+03, 0.00000000e+00, 0.19496000e+01},
    { 52, 12,  1,  0, 0.48978200e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 12,  1,  1, 0.40525290e+03, 0.98110000e+00, 0.96280000e+00},
    { 52, 12,  1,  2, 0.26854180e+03, 0.98110000e+00, 0.19496000e+01},
    { 52, 12,  2,  0, 0.48450380e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 12,  2,  1, 0.40103040e+03, 0.19639000e+01, 0.96280000e+00},
    { 52, 12,  2,  2, 0.26613770e+03, 0.19639000e+01, 0.19496000e+01},
    { 52, 13,  0,  0, 0.45604000e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 13,  0,  1, 0.41405440e+03, 0.00000000e+00, 0.96480000e+00},
    { 52, 13,  0,  2, 0.32462780e+03, 0.00000000e+00, 0.19311000e+01},
    { 52, 13,  0,  3, 0.25478050e+03, 0.00000000e+00, 0.29146000e+01},
    { 52, 13,  1,  0, 0.45524770e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 13,  1,  1, 0.41338560e+03, 0.98110000e+00, 0.96480000e+00},
    { 52, 13,  1,  2, 0.32423490e+03, 0.98110000e+00, 0.19311000e+01},
    { 52, 13,  1,  3, 0.25459630e+03, 0.98110000e+00, 0.29146000e+01},
    { 52, 13,  2,  0, 0.45072670e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 13,  2,  1, 0.40936850e+03, 0.19639000e+01, 0.96480000e+00},
    { 52, 13,  2,  2, 0.32131290e+03, 0.19639000e+01, 0.19311000e+01},
    { 52, 13,  2,  3, 0.25251890e+03, 0.19639000e+01, 0.29146000e+01},
    { 52, 14,  0,  0, 0.36295180e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 14,  0,  1, 0.33592400e+03, 0.00000000e+00, 0.95070000e+00},
    { 52, 14,  0,  2, 0.31287500e+03, 0.00000000e+00, 0.19435000e+01},
    { 52, 14,  0,  3, 0.30462850e+03, 0.00000000e+00, 0.29407000e+01},
    { 52, 14,  0,  4, 0.25216040e+03, 0.00000000e+00, 0.38677000e+01},
    { 52, 14,  1,  0, 0.36255610e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 14,  1,  1, 0.33559140e+03, 0.98110000e+00, 0.95070000e+00},
    { 52, 14,  1,  2, 0.31259390e+03, 0.98110000e+00, 0.19435000e+01},
    { 52, 14,  1,  3, 0.30433880e+03, 0.98110000e+00, 0.29407000e+01},
    { 52, 14,  1,  4, 0.25202720e+03, 0.98110000e+00, 0.38677000e+01},
    { 52, 14,  2,  0, 0.35936400e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 14,  2,  1, 0.33269600e+03, 0.19639000e+01, 0.95070000e+00},
    { 52, 14,  2,  2, 0.30994780e+03, 0.19639000e+01, 0.19435000e+01},
    { 52, 14,  2,  3, 0.30173570e+03, 0.19639000e+01, 0.29407000e+01},
    { 52, 14,  2,  4, 0.25005790e+03, 0.19639000e+01, 0.38677000e+01},
    { 52, 15,  0,  0, 0.28527790e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 15,  0,  1, 0.27698090e+03, 0.00000000e+00, 0.99470000e+00},
    { 52, 15,  0,  2, 0.27309200e+03, 0.00000000e+00, 0.20102000e+01},
    { 52, 15,  0,  3, 0.25382690e+03, 0.00000000e+00, 0.29859000e+01},
    { 52, 15,  1,  0, 0.28512390e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 15,  1,  1, 0.27683720e+03, 0.98110000e+00, 0.99470000e+00},
    { 52, 15,  1,  2, 0.27294170e+03, 0.98110000e+00, 0.20102000e+01},
    { 52, 15,  1,  3, 0.25372280e+03, 0.98110000e+00, 0.29859000e+01},
    { 52, 15,  2,  0, 0.28289020e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 15,  2,  1, 0.27467950e+03, 0.19639000e+01, 0.99470000e+00},
    { 52, 15,  2,  2, 0.27080050e+03, 0.19639000e+01, 0.20102000e+01},
    { 52, 15,  2,  3, 0.25179490e+03, 0.19639000e+01, 0.29859000e+01},
    { 52, 16,  0,  0, 0.23790180e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 16,  0,  1, 0.23525190e+03, 0.00000000e+00, 0.99480000e+00},
    { 52, 16,  0,  2, 0.23051370e+03, 0.00000000e+00, 0.19903000e+01},
    { 52, 16,  1,  0, 0.23785710e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 16,  1,  1, 0.23520590e+03, 0.98110000e+00, 0.99480000e+00},
    { 52, 16,  1,  2, 0.23047020e+03, 0.98110000e+00, 0.19903000e+01},
    { 52, 16,  2,  0, 0.23614560e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 16,  2,  1, 0.23351090e+03, 0.19639000e+01, 0.99480000e+00},
    { 52, 16,  2,  2, 0.22881280e+03, 0.19639000e+01, 0.19903000e+01},
    { 52, 17,  0,  0, 0.19518610e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 17,  0,  1, 0.19314490e+03, 0.00000000e+00, 0.99720000e+00},
    { 52, 17,  1,  0, 0.19521310e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 17,  1,  1, 0.19317040e+03, 0.98110000e+00, 0.99720000e+00},
    { 52, 17,  2,  0, 0.19392690e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 17,  2,  1, 0.19189600e+03, 0.19639000e+01, 0.99720000e+00},
    { 52, 18,  0,  0, 0.16026740e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 18,  1,  0, 0.16033310e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 18,  2,  0, 0.15936080e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 19,  0,  0, 0.10193121e+04, 0.00000000e+00, 0.00000000e+00},
    { 52, 19,  0,  1, 0.36440900e+03, 0.00000000e+00, 0.97670000e+00},
    { 52, 19,  1,  0, 0.10157738e+04, 0.98110000e+00, 0.00000000e+00},
    { 52, 19,  1,  1, 0.36384820e+03, 0.98110000e+00, 0.97670000e+00},
    { 52, 19,  2,  0, 0.10025559e+04, 0.19639000e+01, 0.00000000e+00},
    { 52, 19,  2,  1, 0.36037990e+03, 0.19639000e+01, 0.97670000e+00},
    { 52, 20,  0,  0, 0.85518820e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 20,  0,  1, 0.68470730e+03, 0.00000000e+00, 0.98310000e+00},
    { 52, 20,  0,  2, 0.37680930e+03, 0.00000000e+00, 0.19349000e+01},
    { 52, 20,  1,  0, 0.85290360e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 20,  1,  1, 0.68296210e+03, 0.98110000e+00, 0.98310000e+00},
    { 52, 20,  1,  2, 0.37637060e+03, 0.98110000e+00, 0.19349000e+01},
    { 52, 20,  2,  0, 0.84305400e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 20,  2,  1, 0.67520960e+03, 0.19639000e+01, 0.98310000e+00},
    { 52, 20,  2,  2, 0.37302450e+03, 0.19639000e+01, 0.19349000e+01},
    { 52, 21,  0,  0, 0.70913030e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 21,  0,  1, 0.36739080e+03, 0.00000000e+00, 0.18627000e+01},
    { 52, 21,  0,  2, 0.36347770e+03, 0.00000000e+00, 0.28999000e+01},
    { 52, 21,  1,  0, 0.70737690e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 21,  1,  1, 0.36699000e+03, 0.98110000e+00, 0.18627000e+01},
    { 52, 21,  1,  2, 0.36314460e+03, 0.98110000e+00, 0.28999000e+01},
    { 52, 21,  2,  0, 0.69945860e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 21,  2,  1, 0.36377550e+03, 0.19639000e+01, 0.18627000e+01},
    { 52, 21,  2,  2, 0.36007160e+03, 0.19639000e+01, 0.28999000e+01},
    { 52, 22,  0,  0, 0.68712350e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 22,  0,  1, 0.35477930e+03, 0.00000000e+00, 0.18299000e+01},
    { 52, 22,  0,  2, 0.36805570e+03, 0.00000000e+00, 0.38675000e+01},
    { 52, 22,  1,  0, 0.68556870e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 22,  1,  1, 0.35440290e+03, 0.98110000e+00, 0.18299000e+01},
    { 52, 22,  1,  2, 0.36772520e+03, 0.98110000e+00, 0.38675000e+01},
    { 52, 22,  2,  0, 0.67814850e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 22,  2,  1, 0.35131790e+03, 0.19639000e+01, 0.18299000e+01},
    { 52, 22,  2,  2, 0.36462620e+03, 0.19639000e+01, 0.38675000e+01},
    { 52, 23,  0,  0, 0.63049010e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 23,  0,  1, 0.34763740e+03, 0.00000000e+00, 0.19138000e+01},
    { 52, 23,  0,  2, 0.33677190e+03, 0.00000000e+00, 0.29110000e+01},
    { 52, 23,  1,  0, 0.62913900e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 23,  1,  1, 0.34726480e+03, 0.98110000e+00, 0.19138000e+01},
    { 52, 23,  1,  2, 0.33646710e+03, 0.98110000e+00, 0.29110000e+01},
    { 52, 23,  2,  0, 0.62246350e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 23,  2,  1, 0.34423720e+03, 0.19639000e+01, 0.19138000e+01},
    { 52, 23,  2,  2, 0.33363080e+03, 0.19639000e+01, 0.29110000e+01},
    { 52, 24,  0,  0, 0.49691430e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 24,  0,  1, 0.34409820e+03, 0.00000000e+00, 0.18269000e+01},
    { 52, 24,  0,  2, 0.25510770e+03, 0.00000000e+00, 0.10619100e+02},
    { 52, 24,  1,  0, 0.49588010e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 24,  1,  1, 0.34370870e+03, 0.98110000e+00, 0.18269000e+01},
    { 52, 24,  1,  2, 0.25497950e+03, 0.98110000e+00, 0.10619100e+02},
    { 52, 24,  2,  0, 0.49067860e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 24,  2,  1, 0.34067740e+03, 0.19639000e+01, 0.18269000e+01},
    { 52, 24,  2,  2, 0.25301950e+03, 0.19639000e+01, 0.10619100e+02},
    { 52, 25,  0,  0, 0.54441560e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 25,  0,  1, 0.31804850e+03, 0.00000000e+00, 0.16406000e+01},
    { 52, 25,  0,  2, 0.21904270e+03, 0.00000000e+00, 0.98849000e+01},
    { 52, 25,  1,  0, 0.54334380e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 25,  1,  1, 0.31777500e+03, 0.98110000e+00, 0.16406000e+01},
    { 52, 25,  1,  2, 0.21898580e+03, 0.98110000e+00, 0.98849000e+01},
    { 52, 25,  2,  0, 0.53774700e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 25,  2,  1, 0.31512290e+03, 0.19639000e+01, 0.16406000e+01},
    { 52, 25,  2,  2, 0.21739930e+03, 0.19639000e+01, 0.98849000e+01},
    { 52, 26,  0,  0, 0.42764390e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 26,  0,  1, 0.29473480e+03, 0.00000000e+00, 0.16483000e+01},
    { 52, 26,  0,  2, 0.21492360e+03, 0.00000000e+00, 0.91376000e+01},
    { 52, 26,  1,  0, 0.42683610e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 26,  1,  1, 0.29450790e+03, 0.98110000e+00, 0.16483000e+01},
    { 52, 26,  1,  2, 0.21486070e+03, 0.98110000e+00, 0.91376000e+01},
    { 52, 26,  2,  0, 0.42250680e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 26,  2,  1, 0.29209790e+03, 0.19639000e+01, 0.16483000e+01},
    { 52, 26,  2,  2, 0.21329230e+03, 0.19639000e+01, 0.91376000e+01},
    { 52, 27,  0,  0, 0.45508360e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 27,  0,  1, 0.28116330e+03, 0.00000000e+00, 0.17149000e+01},
    { 52, 27,  0,  2, 0.25056260e+03, 0.00000000e+00, 0.29263000e+01},
    { 52, 27,  0,  3, 0.22389640e+03, 0.00000000e+00, 0.77785000e+01},
    { 52, 27,  1,  0, 0.45431700e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 27,  1,  1, 0.28094820e+03, 0.98110000e+00, 0.17149000e+01},
    { 52, 27,  1,  2, 0.25038960e+03, 0.98110000e+00, 0.29263000e+01},
    { 52, 27,  1,  3, 0.22379990e+03, 0.98110000e+00, 0.77785000e+01},
    { 52, 27,  2,  0, 0.44986640e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 27,  2,  1, 0.27865290e+03, 0.19639000e+01, 0.17149000e+01},
    { 52, 27,  2,  2, 0.24838210e+03, 0.19639000e+01, 0.29263000e+01},
    { 52, 27,  2,  3, 0.22211080e+03, 0.19639000e+01, 0.77785000e+01},
    { 52, 28,  0,  0, 0.46784930e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 28,  0,  1, 0.27477510e+03, 0.00000000e+00, 0.17937000e+01},
    { 52, 28,  0,  2, 0.23382360e+03, 0.00000000e+00, 0.65458000e+01},
    { 52, 28,  0,  3, 0.24463100e+03, 0.00000000e+00, 0.62918000e+01},
    { 52, 28,  1,  0, 0.46700090e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 28,  1,  1, 0.27455800e+03, 0.98110000e+00, 0.17937000e+01},
    { 52, 28,  1,  2, 0.23368760e+03, 0.98110000e+00, 0.65458000e+01},
    { 52, 28,  1,  3, 0.24442920e+03, 0.98110000e+00, 0.62918000e+01},
    { 52, 28,  2,  0, 0.46232080e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 28,  2,  1, 0.27230380e+03, 0.19639000e+01, 0.17937000e+01},
    { 52, 28,  2,  2, 0.23186030e+03, 0.19639000e+01, 0.65458000e+01},
    { 52, 28,  2,  3, 0.24241490e+03, 0.19639000e+01, 0.62918000e+01},
    { 52, 29,  0,  0, 0.35881670e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 29,  0,  1, 0.27055260e+03, 0.00000000e+00, 0.95760000e+00},
    { 52, 29,  1,  0, 0.35818700e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 29,  1,  1, 0.27027830e+03, 0.98110000e+00, 0.95760000e+00},
    { 52, 29,  2,  0, 0.35464230e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 29,  2,  1, 0.26795690e+03, 0.19639000e+01, 0.95760000e+00},
    { 52, 30,  0,  0, 0.37059360e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 30,  0,  1, 0.25542890e+03, 0.00000000e+00, 0.19419000e+01},
    { 52, 30,  1,  0, 0.37006740e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 30,  1,  1, 0.25527130e+03, 0.98110000e+00, 0.19419000e+01},
    { 52, 30,  2,  0, 0.36661620e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 30,  2,  1, 0.25325200e+03, 0.19639000e+01, 0.19419000e+01},
    { 52, 31,  0,  0, 0.43811020e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 31,  0,  1, 0.41227930e+03, 0.00000000e+00, 0.96010000e+00},
    { 52, 31,  0,  2, 0.32880760e+03, 0.00000000e+00, 0.19315000e+01},
    { 52, 31,  0,  3, 0.27067740e+03, 0.00000000e+00, 0.29233000e+01},
    { 52, 31,  1,  0, 0.43744170e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 31,  1,  1, 0.41170180e+03, 0.98110000e+00, 0.96010000e+00},
    { 52, 31,  1,  2, 0.32849050e+03, 0.98110000e+00, 0.19315000e+01},
    { 52, 31,  1,  3, 0.27052970e+03, 0.98110000e+00, 0.29233000e+01},
    { 52, 31,  2,  0, 0.43326650e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 31,  2,  1, 0.40786260e+03, 0.19639000e+01, 0.96010000e+00},
    { 52, 31,  2,  2, 0.32567860e+03, 0.19639000e+01, 0.19315000e+01},
    { 52, 31,  2,  3, 0.26841360e+03, 0.19639000e+01, 0.29233000e+01},
    { 52, 32,  0,  0, 0.38929970e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 32,  0,  1, 0.36482430e+03, 0.00000000e+00, 0.94340000e+00},
    { 52, 32,  0,  2, 0.34772860e+03, 0.00000000e+00, 0.19447000e+01},
    { 52, 32,  0,  3, 0.31246310e+03, 0.00000000e+00, 0.29186000e+01},
    { 52, 32,  0,  4, 0.27677860e+03, 0.00000000e+00, 0.38972000e+01},
    { 52, 32,  1,  0, 0.38889460e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 32,  1,  1, 0.36448820e+03, 0.98110000e+00, 0.94340000e+00},
    { 52, 32,  1,  2, 0.34743580e+03, 0.98110000e+00, 0.19447000e+01},
    { 52, 32,  1,  3, 0.31226190e+03, 0.98110000e+00, 0.29186000e+01},
    { 52, 32,  1,  4, 0.27666850e+03, 0.98110000e+00, 0.38972000e+01},
    { 52, 32,  2,  0, 0.38551090e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 32,  2,  1, 0.36139310e+03, 0.19639000e+01, 0.94340000e+00},
    { 52, 32,  2,  2, 0.34453460e+03, 0.19639000e+01, 0.19447000e+01},
    { 52, 32,  2,  3, 0.30976360e+03, 0.19639000e+01, 0.29186000e+01},
    { 52, 32,  2,  4, 0.27457510e+03, 0.19639000e+01, 0.38972000e+01},
    { 52, 33,  0,  0, 0.33422340e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 33,  0,  1, 0.32867560e+03, 0.00000000e+00, 0.98890000e+00},
    { 52, 33,  0,  2, 0.32025290e+03, 0.00000000e+00, 0.19793000e+01},
    { 52, 33,  0,  3, 0.30877390e+03, 0.00000000e+00, 0.29709000e+01},
    { 52, 33,  1,  0, 0.33402630e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 33,  1,  1, 0.32849090e+03, 0.98110000e+00, 0.98890000e+00},
    { 52, 33,  1,  2, 0.32008780e+03, 0.98110000e+00, 0.19793000e+01},
    { 52, 33,  1,  3, 0.30863590e+03, 0.98110000e+00, 0.29709000e+01},
    { 52, 33,  2,  0, 0.33138440e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 33,  2,  1, 0.32590920e+03, 0.19639000e+01, 0.98890000e+00},
    { 52, 33,  2,  2, 0.31759860e+03, 0.19639000e+01, 0.19793000e+01},
    { 52, 33,  2,  3, 0.30627350e+03, 0.19639000e+01, 0.29709000e+01},
    { 52, 34,  0,  0, 0.30105450e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 34,  0,  1, 0.30115060e+03, 0.00000000e+00, 0.99010000e+00},
    { 52, 34,  0,  2, 0.29881560e+03, 0.00000000e+00, 0.19812000e+01},
    { 52, 34,  1,  0, 0.30096170e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 34,  1,  1, 0.30105670e+03, 0.98110000e+00, 0.99010000e+00},
    { 52, 34,  1,  2, 0.29872470e+03, 0.98110000e+00, 0.19812000e+01},
    { 52, 34,  2,  0, 0.29873310e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 34,  2,  1, 0.29882550e+03, 0.19639000e+01, 0.99010000e+00},
    { 52, 34,  2,  2, 0.29651530e+03, 0.19639000e+01, 0.19812000e+01},
    { 52, 35,  0,  0, 0.26445160e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 35,  0,  1, 0.26623860e+03, 0.00000000e+00, 0.99740000e+00},
    { 52, 35,  1,  0, 0.26444460e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 35,  1,  1, 0.26622780e+03, 0.98110000e+00, 0.99740000e+00},
    { 52, 35,  2,  0, 0.26262260e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 35,  2,  1, 0.26438680e+03, 0.19639000e+01, 0.99740000e+00},
    { 52, 36,  0,  0, 0.23074260e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 36,  1,  0, 0.23079470e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 36,  2,  0, 0.22931350e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 37,  0,  0, 0.11441913e+04, 0.00000000e+00, 0.00000000e+00},
    { 52, 37,  0,  1, 0.43555550e+03, 0.00000000e+00, 0.97380000e+00},
    { 52, 37,  1,  0, 0.11403397e+04, 0.98110000e+00, 0.00000000e+00},
    { 52, 37,  1,  1, 0.43493910e+03, 0.98110000e+00, 0.97380000e+00},
    { 52, 37,  2,  0, 0.11257134e+04, 0.19639000e+01, 0.00000000e+00},
    { 52, 37,  2,  1, 0.43088900e+03, 0.19639000e+01, 0.97380000e+00},
    { 52, 38,  0,  0, 0.10183413e+04, 0.00000000e+00, 0.00000000e+00},
    { 52, 38,  0,  1, 0.83250600e+03, 0.00000000e+00, 0.98010000e+00},
    { 52, 38,  0,  2, 0.45162950e+03, 0.00000000e+00, 0.19143000e+01},
    { 52, 38,  1,  0, 0.10156122e+04, 0.98110000e+00, 0.00000000e+00},
    { 52, 38,  1,  1, 0.83036610e+03, 0.98110000e+00, 0.98010000e+00},
    { 52, 38,  1,  2, 0.45112580e+03, 0.98110000e+00, 0.19143000e+01},
    { 52, 38,  2,  0, 0.10038665e+04, 0.19639000e+01, 0.00000000e+00},
    { 52, 38,  2,  1, 0.82090550e+03, 0.19639000e+01, 0.98010000e+00},
    { 52, 38,  2,  2, 0.44715550e+03, 0.19639000e+01, 0.19143000e+01},
    { 52, 39,  0,  0, 0.89780430e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 39,  0,  1, 0.64444940e+03, 0.00000000e+00, 0.19153000e+01},
    { 52, 39,  0,  2, 0.43680220e+03, 0.00000000e+00, 0.28903000e+01},
    { 52, 39,  1,  0, 0.89573040e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 39,  1,  1, 0.64326970e+03, 0.98110000e+00, 0.19153000e+01},
    { 52, 39,  1,  2, 0.43645200e+03, 0.98110000e+00, 0.28903000e+01},
    { 52, 39,  2,  0, 0.88595760e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 39,  2,  1, 0.63678340e+03, 0.19639000e+01, 0.19153000e+01},
    { 52, 39,  2,  2, 0.43284780e+03, 0.19639000e+01, 0.28903000e+01},
    { 52, 40,  0,  0, 0.81010280e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 40,  0,  1, 0.48561760e+03, 0.00000000e+00, 0.19355000e+01},
    { 52, 40,  0,  2, 0.44115130e+03, 0.00000000e+00, 0.39106000e+01},
    { 52, 40,  1,  0, 0.80842520e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 40,  1,  1, 0.48508560e+03, 0.98110000e+00, 0.19355000e+01},
    { 52, 40,  1,  2, 0.44083920e+03, 0.98110000e+00, 0.39106000e+01},
    { 52, 40,  2,  0, 0.79994710e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 40,  2,  1, 0.48083080e+03, 0.19639000e+01, 0.19355000e+01},
    { 52, 40,  2,  2, 0.43727120e+03, 0.19639000e+01, 0.39106000e+01},
    { 52, 41,  0,  0, 0.74062110e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 41,  0,  1, 0.49032060e+03, 0.00000000e+00, 0.19545000e+01},
    { 52, 41,  0,  2, 0.42642020e+03, 0.00000000e+00, 0.29225000e+01},
    { 52, 41,  1,  0, 0.73920970e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 41,  1,  1, 0.48977500e+03, 0.98110000e+00, 0.19545000e+01},
    { 52, 41,  1,  2, 0.42611180e+03, 0.98110000e+00, 0.29225000e+01},
    { 52, 41,  2,  0, 0.73167410e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 41,  2,  1, 0.48546850e+03, 0.19639000e+01, 0.19545000e+01},
    { 52, 41,  2,  2, 0.42265520e+03, 0.19639000e+01, 0.29225000e+01},
    { 52, 42,  0,  0, 0.57429320e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 42,  0,  1, 0.45793020e+03, 0.00000000e+00, 0.19420000e+01},
    { 52, 42,  0,  2, 0.37843120e+03, 0.00000000e+00, 0.11055600e+02},
    { 52, 42,  1,  0, 0.57337000e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 42,  1,  1, 0.45747170e+03, 0.98110000e+00, 0.19420000e+01},
    { 52, 42,  1,  2, 0.37825790e+03, 0.98110000e+00, 0.11055600e+02},
    { 52, 42,  2,  0, 0.56783410e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 42,  2,  1, 0.45354170e+03, 0.19639000e+01, 0.19420000e+01},
    { 52, 42,  2,  2, 0.37537250e+03, 0.19639000e+01, 0.11055600e+02},
    { 52, 43,  0,  0, 0.63974650e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 43,  0,  1, 0.51056820e+03, 0.00000000e+00, 0.16682000e+01},
    { 52, 43,  0,  2, 0.33500590e+03, 0.00000000e+00, 0.95402000e+01},
    { 52, 43,  1,  0, 0.63864620e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 43,  1,  1, 0.50987810e+03, 0.98110000e+00, 0.16682000e+01},
    { 52, 43,  1,  2, 0.33492300e+03, 0.98110000e+00, 0.95402000e+01},
    { 52, 43,  2,  0, 0.63235020e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 43,  2,  1, 0.50518300e+03, 0.19639000e+01, 0.16682000e+01},
    { 52, 43,  2,  2, 0.33249710e+03, 0.19639000e+01, 0.95402000e+01},
    { 52, 44,  0,  0, 0.48969560e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 44,  0,  1, 0.40083190e+03, 0.00000000e+00, 0.18584000e+01},
    { 52, 44,  0,  2, 0.31691230e+03, 0.00000000e+00, 0.88895000e+01},
    { 52, 44,  1,  0, 0.48901000e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 44,  1,  1, 0.40053650e+03, 0.98110000e+00, 0.18584000e+01},
    { 52, 44,  1,  2, 0.31685780e+03, 0.98110000e+00, 0.88895000e+01},
    { 52, 44,  2,  0, 0.48447400e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 44,  2,  1, 0.39728740e+03, 0.19639000e+01, 0.18584000e+01},
    { 52, 44,  2,  2, 0.31460820e+03, 0.19639000e+01, 0.88895000e+01},
    { 52, 45,  0,  0, 0.53521890e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 45,  0,  1, 0.37513030e+03, 0.00000000e+00, 0.19003000e+01},
    { 52, 45,  0,  2, 0.32172250e+03, 0.00000000e+00, 0.29696000e+01},
    { 52, 45,  1,  0, 0.53445110e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 45,  1,  1, 0.37486560e+03, 0.98110000e+00, 0.19003000e+01},
    { 52, 45,  1,  2, 0.32158990e+03, 0.98110000e+00, 0.29696000e+01},
    { 52, 45,  2,  0, 0.52945790e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 45,  2,  1, 0.37184930e+03, 0.19639000e+01, 0.19003000e+01},
    { 52, 45,  2,  2, 0.31917350e+03, 0.19639000e+01, 0.29696000e+01},
    { 52, 46,  0,  0, 0.49709590e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 46,  0,  1, 0.34860740e+03, 0.00000000e+00, 0.18630000e+01},
    { 52, 46,  0,  2, 0.33576050e+03, 0.00000000e+00, 0.57095000e+01},
    { 52, 46,  1,  0, 0.49643130e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 46,  1,  1, 0.34838020e+03, 0.98110000e+00, 0.18630000e+01},
    { 52, 46,  1,  2, 0.33559490e+03, 0.98110000e+00, 0.57095000e+01},
    { 52, 46,  2,  0, 0.49188120e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 46,  2,  1, 0.34561400e+03, 0.19639000e+01, 0.18630000e+01},
    { 52, 46,  2,  2, 0.33302450e+03, 0.19639000e+01, 0.57095000e+01},
    { 52, 47,  0,  0, 0.41415120e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 47,  0,  1, 0.33701310e+03, 0.00000000e+00, 0.96790000e+00},
    { 52, 47,  1,  0, 0.41359130e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 47,  1,  1, 0.33677710e+03, 0.98110000e+00, 0.96790000e+00},
    { 52, 47,  2,  0, 0.40979950e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 47,  2,  1, 0.33407750e+03, 0.19639000e+01, 0.96790000e+00},
    { 52, 48,  0,  0, 0.43888610e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 48,  0,  1, 0.33449170e+03, 0.00000000e+00, 0.19539000e+01},
    { 52, 48,  1,  0, 0.43835340e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 48,  1,  1, 0.33432410e+03, 0.98110000e+00, 0.19539000e+01},
    { 52, 48,  2,  0, 0.43443580e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 48,  2,  1, 0.33175670e+03, 0.19639000e+01, 0.19539000e+01},
    { 52, 49,  0,  0, 0.54812670e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 49,  0,  1, 0.52361310e+03, 0.00000000e+00, 0.96330000e+00},
    { 52, 49,  0,  2, 0.42447180e+03, 0.00000000e+00, 0.19378000e+01},
    { 52, 49,  0,  3, 0.36359740e+03, 0.00000000e+00, 0.29353000e+01},
    { 52, 49,  1,  0, 0.54729130e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 49,  1,  1, 0.52288630e+03, 0.98110000e+00, 0.96330000e+00},
    { 52, 49,  1,  2, 0.42408620e+03, 0.98110000e+00, 0.19378000e+01},
    { 52, 49,  1,  3, 0.36340770e+03, 0.98110000e+00, 0.29353000e+01},
    { 52, 49,  2,  0, 0.54208910e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 49,  2,  1, 0.51804080e+03, 0.19639000e+01, 0.96330000e+00},
    { 52, 49,  2,  2, 0.42051550e+03, 0.19639000e+01, 0.19378000e+01},
    { 52, 49,  2,  3, 0.36059670e+03, 0.19639000e+01, 0.29353000e+01},
    { 52, 50,  0,  0, 0.50996980e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 50,  0,  1, 0.47668110e+03, 0.00000000e+00, 0.95140000e+00},
    { 52, 50,  0,  2, 0.46138680e+03, 0.00000000e+00, 0.19505000e+01},
    { 52, 50,  0,  3, 0.41689450e+03, 0.00000000e+00, 0.29259000e+01},
    { 52, 50,  0,  4, 0.37809630e+03, 0.00000000e+00, 0.39123000e+01},
    { 52, 50,  1,  0, 0.50938490e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 50,  1,  1, 0.47620870e+03, 0.98110000e+00, 0.95140000e+00},
    { 52, 50,  1,  2, 0.46096710e+03, 0.98110000e+00, 0.19505000e+01},
    { 52, 50,  1,  3, 0.41661070e+03, 0.98110000e+00, 0.29259000e+01},
    { 52, 50,  1,  4, 0.37792500e+03, 0.98110000e+00, 0.39123000e+01},
    { 52, 50,  2,  0, 0.50487630e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 50,  2,  1, 0.47212430e+03, 0.19639000e+01, 0.95140000e+00},
    { 52, 50,  2,  2, 0.45707930e+03, 0.19639000e+01, 0.19505000e+01},
    { 52, 50,  2,  3, 0.41326530e+03, 0.19639000e+01, 0.29259000e+01},
    { 52, 50,  2,  4, 0.37504230e+03, 0.19639000e+01, 0.39123000e+01},
    { 52, 51,  0,  0, 0.45710570e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 51,  0,  1, 0.44833330e+03, 0.00000000e+00, 0.97490000e+00},
    { 52, 51,  0,  2, 0.43644300e+03, 0.00000000e+00, 0.19523000e+01},
    { 52, 51,  0,  3, 0.42141870e+03, 0.00000000e+00, 0.29315000e+01},
    { 52, 51,  1,  0, 0.45675890e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 51,  1,  1, 0.44801730e+03, 0.98110000e+00, 0.97490000e+00},
    { 52, 51,  1,  2, 0.43616550e+03, 0.98110000e+00, 0.19523000e+01},
    { 52, 51,  1,  3, 0.42118710e+03, 0.98110000e+00, 0.29315000e+01},
    { 52, 51,  2,  0, 0.45302540e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 51,  2,  1, 0.44439750e+03, 0.19639000e+01, 0.97490000e+00},
    { 52, 51,  2,  2, 0.43269410e+03, 0.19639000e+01, 0.19523000e+01},
    { 52, 51,  2,  3, 0.41789910e+03, 0.19639000e+01, 0.29315000e+01},
    { 52, 52,  0,  0, 0.42553550e+03, 0.00000000e+00, 0.00000000e+00},
    { 52, 52,  1,  0, 0.42531520e+03, 0.98110000e+00, 0.00000000e+00},
    { 52, 52,  1,  1, 0.42510150e+03, 0.98110000e+00, 0.98110000e+00},
    { 52, 52,  2,  0, 0.42201870e+03, 0.19639000e+01, 0.00000000e+00},
    { 52, 52,  2,  1, 0.42181780e+03, 0.19639000e+01, 0.98110000e+00},
    { 52, 52,  2,  2, 0.41857890e+03, 0.19639000e+01, 0.19639000e+01},
    { 53,  1,  0,  0, 0.32517100e+02, 0.00000000e+00, 0.91180000e+00},
    { 53,  1,  0,  1, 0.51465600e+02, 0.00000000e+00, 0.00000000e+00},
    { 53,  1,  1,  0, 0.32815100e+02, 0.99680000e+00, 0.91180000e+00},
    { 53,  1,  1,  1, 0.51949600e+02, 0.99680000e+00, 0.00000000e+00},
    { 53,  2,  0,  0, 0.22081300e+02, 0.00000000e+00, 0.00000000e+00},
    { 53,  2,  1,  0, 0.22271700e+02, 0.99680000e+00, 0.00000000e+00},
    { 53,  3,  0,  0, 0.44985120e+03, 0.00000000e+00, 0.00000000e+00},
    { 53,  3,  0,  1, 0.15986700e+03, 0.00000000e+00, 0.98650000e+00},
    { 53,  3,  1,  0, 0.45439540e+03, 0.99680000e+00, 0.00000000e+00},
    { 53,  3,  1,  1, 0.16143030e+03, 0.99680000e+00, 0.98650000e+00},
    { 53,  4,  0,  0, 0.27373980e+03, 0.00000000e+00, 0.00000000e+00},
    { 53,  4,  0,  1, 0.20522370e+03, 0.00000000e+00, 0.98080000e+00},
    { 53,  4,  0,  2, 0.13761920e+03, 0.00000000e+00, 0.19697000e+01},
    { 53,  4,  1,  0, 0.27643090e+03, 0.99680000e+00, 0.00000000e+00},
    { 53,  4,  1,  1, 0.20721850e+03, 0.99680000e+00, 0.98080000e+00},
    { 53,  4,  1,  2, 0.13892730e+03, 0.99680000e+00, 0.19697000e+01},
    { 53,  5,  0,  0, 0.19010940e+03, 0.00000000e+00, 0.00000000e+00},
    { 53,  5,  0,  1, 0.16096790e+03, 0.00000000e+00, 0.97060000e+00},
    { 53,  5,  0,  2, 0.13602390e+03, 0.00000000e+00, 0.19441000e+01},
    { 53,  5,  0,  3, 0.10506600e+03, 0.00000000e+00, 0.29128000e+01},
    { 53,  5,  0,  4, 0.99110900e+02, 0.00000000e+00, 0.45856000e+01},
    { 53,  5,  1,  0, 0.19192730e+03, 0.99680000e+00, 0.00000000e+00},
    { 53,  5,  1,  1, 0.16249390e+03, 0.99680000e+00, 0.97060000e+00},
    { 53,  5,  1,  2, 0.13730200e+03, 0.99680000e+00, 0.19441000e+01},
    { 53,  5,  1,  3, 0.10603500e+03, 0.99680000e+00, 0.29128000e+01},
    { 53,  5,  1,  4, 0.10002100e+03, 0.99680000e+00, 0.45856000e+01},
    { 53,  6,  0,  0, 0.13140510e+03, 0.00000000e+00, 0.00000000e+00},
    { 53,  6,  0,  1, 0.12325380e+03, 0.00000000e+00, 0.98680000e+00},
    { 53,  6,  0,  2, 0.10142160e+03, 0.00000000e+00, 0.19985000e+01},
    { 53,  6,  0,  3, 0.94948900e+02, 0.00000000e+00, 0.29987000e+01},
    { 53,  6,  0,  4, 0.78668600e+02, 0.00000000e+00, 0.39844000e+01},
    { 53,  6,  1,  0, 0.13262510e+03, 0.99680000e+00, 0.00000000e+00},
    { 53,  6,  1,  1, 0.12439580e+03, 0.99680000e+00, 0.98680000e+00},
    { 53,  6,  1,  2, 0.10234890e+03, 0.99680000e+00, 0.19985000e+01},
    { 53,  6,  1,  3, 0.95813900e+02, 0.99680000e+00, 0.29987000e+01},
    { 53,  6,  1,  4, 0.79371600e+02, 0.99680000e+00, 0.39844000e+01},
    { 53,  7,  0,  0, 0.93456200e+02, 0.00000000e+00, 0.00000000e+00},
    { 53,  7,  0,  1, 0.87202800e+02, 0.00000000e+00, 0.99440000e+00},
    { 53,  7,  0,  2, 0.82037400e+02, 0.00000000e+00, 0.20143000e+01},
    { 53,  7,  0,  3, 0.72453100e+02, 0.00000000e+00, 0.29903000e+01},
    { 53,  7,  1,  0, 0.94299100e+02, 0.99680000e+00, 0.00000000e+00},
    { 53,  7,  1,  1, 0.87986900e+02, 0.99680000e+00, 0.99440000e+00},
    { 53,  7,  1,  2, 0.82771300e+02, 0.99680000e+00, 0.20143000e+01},
    { 53,  7,  1,  3, 0.73095400e+02, 0.99680000e+00, 0.29903000e+01},
    { 53,  8,  0,  0, 0.71605900e+02, 0.00000000e+00, 0.00000000e+00},
    { 53,  8,  0,  1, 0.64414100e+02, 0.00000000e+00, 0.99250000e+00},
    { 53,  8,  0,  2, 0.57073800e+02, 0.00000000e+00, 0.19887000e+01},
    { 53,  8,  1,  0, 0.72235800e+02, 0.99680000e+00, 0.00000000e+00},
    { 53,  8,  1,  1, 0.64976400e+02, 0.99680000e+00, 0.99250000e+00},
    { 53,  8,  1,  2, 0.57565500e+02, 0.99680000e+00, 0.19887000e+01},
    { 53,  9,  0,  0, 0.54799000e+02, 0.00000000e+00, 0.00000000e+00},
    { 53,  9,  0,  1, 0.45084800e+02, 0.00000000e+00, 0.99820000e+00},
    { 53,  9,  1,  0, 0.55268900e+02, 0.99680000e+00, 0.00000000e+00},
    { 53,  9,  1,  1, 0.45461800e+02, 0.99680000e+00, 0.99820000e+00},
    { 53, 10,  0,  0, 0.42495400e+02, 0.00000000e+00, 0.00000000e+00},
    { 53, 10,  1,  0, 0.42851200e+02, 0.99680000e+00, 0.00000000e+00},
    { 53, 11,  0,  0, 0.53985360e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 11,  0,  1, 0.23260530e+03, 0.00000000e+00, 0.96840000e+00},
    { 53, 11,  1,  0, 0.54528550e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 11,  1,  1, 0.23487760e+03, 0.99680000e+00, 0.96840000e+00},
    { 53, 12,  0,  0, 0.43217920e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 12,  0,  1, 0.35880520e+03, 0.00000000e+00, 0.96280000e+00},
    { 53, 12,  0,  2, 0.24089430e+03, 0.00000000e+00, 0.19496000e+01},
    { 53, 12,  1,  0, 0.43644520e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 12,  1,  1, 0.36232580e+03, 0.99680000e+00, 0.96280000e+00},
    { 53, 12,  1,  2, 0.24320970e+03, 0.99680000e+00, 0.19496000e+01},
    { 53, 13,  0,  0, 0.40476310e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 13,  0,  1, 0.36827920e+03, 0.00000000e+00, 0.96480000e+00},
    { 53, 13,  0,  2, 0.29073780e+03, 0.00000000e+00, 0.19311000e+01},
    { 53, 13,  0,  3, 0.23007980e+03, 0.00000000e+00, 0.29146000e+01},
    { 53, 13,  1,  0, 0.40871490e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 13,  1,  1, 0.37186150e+03, 0.99680000e+00, 0.96480000e+00},
    { 53, 13,  1,  2, 0.29353370e+03, 0.99680000e+00, 0.19311000e+01},
    { 53, 13,  1,  3, 0.23226170e+03, 0.99680000e+00, 0.29146000e+01},
    { 53, 14,  0,  0, 0.32569120e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 14,  0,  1, 0.30198520e+03, 0.00000000e+00, 0.95070000e+00},
    { 53, 14,  0,  2, 0.28172560e+03, 0.00000000e+00, 0.19435000e+01},
    { 53, 14,  0,  3, 0.27410450e+03, 0.00000000e+00, 0.29407000e+01},
    { 53, 14,  0,  4, 0.22853700e+03, 0.00000000e+00, 0.38677000e+01},
    { 53, 14,  1,  0, 0.32881570e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 14,  1,  1, 0.30487150e+03, 0.99680000e+00, 0.95070000e+00},
    { 53, 14,  1,  2, 0.28440960e+03, 0.99680000e+00, 0.19435000e+01},
    { 53, 14,  1,  3, 0.27671610e+03, 0.99680000e+00, 0.29407000e+01},
    { 53, 14,  1,  4, 0.23068720e+03, 0.99680000e+00, 0.38677000e+01},
    { 53, 15,  0,  0, 0.25851210e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 15,  0,  1, 0.25110810e+03, 0.00000000e+00, 0.99470000e+00},
    { 53, 15,  0,  2, 0.24747320e+03, 0.00000000e+00, 0.20102000e+01},
    { 53, 15,  0,  3, 0.23058600e+03, 0.00000000e+00, 0.29859000e+01},
    { 53, 15,  1,  0, 0.26094460e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 15,  1,  1, 0.25346770e+03, 0.99680000e+00, 0.99470000e+00},
    { 53, 15,  1,  2, 0.24979920e+03, 0.99680000e+00, 0.20102000e+01},
    { 53, 15,  1,  3, 0.23274260e+03, 0.99680000e+00, 0.29859000e+01},
    { 53, 16,  0,  0, 0.21703370e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 16,  0,  1, 0.21460020e+03, 0.00000000e+00, 0.99480000e+00},
    { 53, 16,  0,  2, 0.21031760e+03, 0.00000000e+00, 0.19903000e+01},
    { 53, 16,  1,  0, 0.21904300e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 16,  1,  1, 0.21658660e+03, 0.99680000e+00, 0.99480000e+00},
    { 53, 16,  1,  2, 0.21226280e+03, 0.99680000e+00, 0.19903000e+01},
    { 53, 17,  0,  0, 0.17923060e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 17,  0,  1, 0.17734580e+03, 0.00000000e+00, 0.99720000e+00},
    { 53, 17,  1,  0, 0.18086040e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 17,  1,  1, 0.17895810e+03, 0.99680000e+00, 0.99720000e+00},
    { 53, 18,  0,  0, 0.14802160e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 18,  1,  0, 0.14934300e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 19,  0,  0, 0.88017410e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 19,  0,  1, 0.32510680e+03, 0.00000000e+00, 0.97670000e+00},
    { 53, 19,  1,  0, 0.88900260e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 19,  1,  1, 0.32822070e+03, 0.99680000e+00, 0.97670000e+00},
    { 53, 20,  0,  0, 0.74793060e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 20,  0,  1, 0.60026980e+03, 0.00000000e+00, 0.98310000e+00},
    { 53, 20,  0,  2, 0.33804940e+03, 0.00000000e+00, 0.19349000e+01},
    { 53, 20,  1,  0, 0.75534780e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 20,  1,  1, 0.60618590e+03, 0.99680000e+00, 0.98310000e+00},
    { 53, 20,  1,  2, 0.34127320e+03, 0.99680000e+00, 0.19349000e+01},
    { 53, 21,  0,  0, 0.62218410e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 21,  0,  1, 0.33004180e+03, 0.00000000e+00, 0.18627000e+01},
    { 53, 21,  0,  2, 0.32743400e+03, 0.00000000e+00, 0.28999000e+01},
    { 53, 21,  1,  0, 0.62833170e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 21,  1,  1, 0.33318010e+03, 0.99680000e+00, 0.18627000e+01},
    { 53, 21,  1,  2, 0.33053650e+03, 0.99680000e+00, 0.28999000e+01},
    { 53, 22,  0,  0, 0.60505080e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 22,  0,  1, 0.31891710e+03, 0.00000000e+00, 0.18299000e+01},
    { 53, 22,  0,  2, 0.33168000e+03, 0.00000000e+00, 0.38675000e+01},
    { 53, 22,  1,  0, 0.61099490e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 22,  1,  1, 0.32194330e+03, 0.99680000e+00, 0.18299000e+01},
    { 53, 22,  1,  2, 0.33481970e+03, 0.99680000e+00, 0.38675000e+01},
    { 53, 23,  0,  0, 0.55631660e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 23,  0,  1, 0.31247140e+03, 0.00000000e+00, 0.19138000e+01},
    { 53, 23,  0,  2, 0.30354590e+03, 0.00000000e+00, 0.29110000e+01},
    { 53, 23,  1,  0, 0.56176430e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 23,  1,  1, 0.31543490e+03, 0.99680000e+00, 0.19138000e+01},
    { 53, 23,  1,  2, 0.30641230e+03, 0.99680000e+00, 0.29110000e+01},
    { 53, 24,  0,  0, 0.43916600e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 24,  0,  1, 0.30900630e+03, 0.00000000e+00, 0.18269000e+01},
    { 53, 24,  0,  2, 0.23174840e+03, 0.00000000e+00, 0.10619100e+02},
    { 53, 24,  1,  0, 0.44344010e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 24,  1,  1, 0.31193950e+03, 0.99680000e+00, 0.18269000e+01},
    { 53, 24,  1,  2, 0.23389400e+03, 0.99680000e+00, 0.10619100e+02},
    { 53, 25,  0,  0, 0.48180770e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 25,  0,  1, 0.28687200e+03, 0.00000000e+00, 0.16406000e+01},
    { 53, 25,  0,  2, 0.19989240e+03, 0.00000000e+00, 0.98849000e+01},
    { 53, 25,  1,  0, 0.48650250e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 25,  1,  1, 0.28957840e+03, 0.99680000e+00, 0.16406000e+01},
    { 53, 25,  1,  2, 0.20172290e+03, 0.99680000e+00, 0.98849000e+01},
    { 53, 26,  0,  0, 0.37922120e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 26,  0,  1, 0.26629100e+03, 0.00000000e+00, 0.16483000e+01},
    { 53, 26,  0,  2, 0.19602880e+03, 0.00000000e+00, 0.91376000e+01},
    { 53, 26,  1,  0, 0.38289000e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 26,  1,  1, 0.26879340e+03, 0.99680000e+00, 0.16483000e+01},
    { 53, 26,  1,  2, 0.19782510e+03, 0.99680000e+00, 0.91376000e+01},
    { 53, 27,  0,  0, 0.40469290e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 27,  0,  1, 0.25408770e+03, 0.00000000e+00, 0.17149000e+01},
    { 53, 27,  0,  2, 0.22685100e+03, 0.00000000e+00, 0.29263000e+01},
    { 53, 27,  0,  3, 0.20368550e+03, 0.00000000e+00, 0.77785000e+01},
    { 53, 27,  1,  0, 0.40860640e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 27,  1,  1, 0.25647210e+03, 0.99680000e+00, 0.17149000e+01},
    { 53, 27,  1,  2, 0.22896540e+03, 0.99680000e+00, 0.29263000e+01},
    { 53, 27,  1,  3, 0.20556330e+03, 0.99680000e+00, 0.77785000e+01},
    { 53, 28,  0,  0, 0.41513030e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 28,  0,  1, 0.24822370e+03, 0.00000000e+00, 0.17937000e+01},
    { 53, 28,  0,  2, 0.21211680e+03, 0.00000000e+00, 0.65458000e+01},
    { 53, 28,  0,  3, 0.22102500e+03, 0.00000000e+00, 0.62918000e+01},
    { 53, 28,  1,  0, 0.41915920e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 28,  1,  1, 0.25055360e+03, 0.99680000e+00, 0.17937000e+01},
    { 53, 28,  1,  2, 0.21408530e+03, 0.99680000e+00, 0.65458000e+01},
    { 53, 28,  1,  3, 0.22308960e+03, 0.99680000e+00, 0.62918000e+01},
    { 53, 29,  0,  0, 0.31896420e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 29,  0,  1, 0.24354750e+03, 0.00000000e+00, 0.95760000e+00},
    { 53, 29,  1,  0, 0.32203460e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 29,  1,  1, 0.24584350e+03, 0.99680000e+00, 0.95760000e+00},
    { 53, 30,  0,  0, 0.33106510e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 30,  0,  1, 0.23140060e+03, 0.00000000e+00, 0.19419000e+01},
    { 53, 30,  1,  0, 0.33424140e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 30,  1,  1, 0.23356320e+03, 0.99680000e+00, 0.19419000e+01},
    { 53, 31,  0,  0, 0.39045420e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 31,  0,  1, 0.36821830e+03, 0.00000000e+00, 0.96010000e+00},
    { 53, 31,  0,  2, 0.29588170e+03, 0.00000000e+00, 0.19315000e+01},
    { 53, 31,  0,  3, 0.24534690e+03, 0.00000000e+00, 0.29233000e+01},
    { 53, 31,  1,  0, 0.39422890e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 31,  1,  1, 0.37176550e+03, 0.99680000e+00, 0.96010000e+00},
    { 53, 31,  1,  2, 0.29869480e+03, 0.99680000e+00, 0.19315000e+01},
    { 53, 31,  1,  3, 0.24764850e+03, 0.99680000e+00, 0.29233000e+01},
    { 53, 32,  0,  0, 0.34977600e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 32,  0,  1, 0.32847500e+03, 0.00000000e+00, 0.94340000e+00},
    { 53, 32,  0,  2, 0.31352800e+03, 0.00000000e+00, 0.19447000e+01},
    { 53, 32,  0,  3, 0.28271950e+03, 0.00000000e+00, 0.29186000e+01},
    { 53, 32,  0,  4, 0.25152290e+03, 0.00000000e+00, 0.38972000e+01},
    { 53, 32,  1,  0, 0.35311560e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 32,  1,  1, 0.33159870e+03, 0.99680000e+00, 0.94340000e+00},
    { 53, 32,  1,  2, 0.31650110e+03, 0.99680000e+00, 0.19447000e+01},
    { 53, 32,  1,  3, 0.28538200e+03, 0.99680000e+00, 0.29186000e+01},
    { 53, 32,  1,  4, 0.25387120e+03, 0.99680000e+00, 0.38972000e+01},
    { 53, 33,  0,  0, 0.30267430e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 33,  0,  1, 0.29780640e+03, 0.00000000e+00, 0.98890000e+00},
    { 53, 33,  0,  2, 0.29042110e+03, 0.00000000e+00, 0.19793000e+01},
    { 53, 33,  0,  3, 0.28035770e+03, 0.00000000e+00, 0.29709000e+01},
    { 53, 33,  1,  0, 0.30552140e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 33,  1,  1, 0.30060430e+03, 0.99680000e+00, 0.98890000e+00},
    { 53, 33,  1,  2, 0.29314450e+03, 0.99680000e+00, 0.19793000e+01},
    { 53, 33,  1,  3, 0.28298000e+03, 0.99680000e+00, 0.29709000e+01},
    { 53, 34,  0,  0, 0.27406300e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 34,  0,  1, 0.27413770e+03, 0.00000000e+00, 0.99010000e+00},
    { 53, 34,  0,  2, 0.27205830e+03, 0.00000000e+00, 0.19812000e+01},
    { 53, 34,  1,  0, 0.27661090e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 34,  1,  1, 0.27668620e+03, 0.99680000e+00, 0.99010000e+00},
    { 53, 34,  1,  2, 0.27458620e+03, 0.99680000e+00, 0.19812000e+01},
    { 53, 35,  0,  0, 0.24205560e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 35,  0,  1, 0.24362960e+03, 0.00000000e+00, 0.99740000e+00},
    { 53, 35,  1,  0, 0.24427520e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 35,  1,  1, 0.24586470e+03, 0.99680000e+00, 0.99740000e+00},
    { 53, 36,  0,  0, 0.21228200e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 36,  1,  0, 0.21420040e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 37,  0,  0, 0.98989210e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 37,  0,  1, 0.38946840e+03, 0.00000000e+00, 0.97380000e+00},
    { 53, 37,  1,  0, 0.99978710e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 37,  1,  1, 0.39318090e+03, 0.99680000e+00, 0.97380000e+00},
    { 53, 38,  0,  0, 0.89067230e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 38,  0,  1, 0.72971760e+03, 0.00000000e+00, 0.98010000e+00},
    { 53, 38,  0,  2, 0.40561580e+03, 0.00000000e+00, 0.19143000e+01},
    { 53, 38,  1,  0, 0.89949300e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 38,  1,  1, 0.73690210e+03, 0.99680000e+00, 0.98010000e+00},
    { 53, 38,  1,  2, 0.40947120e+03, 0.99680000e+00, 0.19143000e+01},
    { 53, 39,  0,  0, 0.79002570e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 39,  0,  1, 0.57184320e+03, 0.00000000e+00, 0.19153000e+01},
    { 53, 39,  0,  2, 0.39431850e+03, 0.00000000e+00, 0.28903000e+01},
    { 53, 39,  1,  0, 0.79779010e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 39,  1,  1, 0.57738050e+03, 0.99680000e+00, 0.19153000e+01},
    { 53, 39,  1,  2, 0.39803820e+03, 0.99680000e+00, 0.28903000e+01},
    { 53, 40,  0,  0, 0.71573180e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 40,  0,  1, 0.43630460e+03, 0.00000000e+00, 0.19355000e+01},
    { 53, 40,  0,  2, 0.39888950e+03, 0.00000000e+00, 0.39106000e+01},
    { 53, 40,  1,  0, 0.72272400e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 40,  1,  1, 0.44044740e+03, 0.99680000e+00, 0.19355000e+01},
    { 53, 40,  1,  2, 0.40264130e+03, 0.99680000e+00, 0.39106000e+01},
    { 53, 41,  0,  0, 0.65622760e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 41,  0,  1, 0.44045990e+03, 0.00000000e+00, 0.19545000e+01},
    { 53, 41,  0,  2, 0.38559230e+03, 0.00000000e+00, 0.29225000e+01},
    { 53, 41,  1,  0, 0.66260680e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 41,  1,  1, 0.44464020e+03, 0.99680000e+00, 0.19545000e+01},
    { 53, 41,  1,  2, 0.38921120e+03, 0.99680000e+00, 0.29225000e+01},
    { 53, 42,  0,  0, 0.51167720e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 42,  0,  1, 0.41222750e+03, 0.00000000e+00, 0.19420000e+01},
    { 53, 42,  0,  2, 0.34390960e+03, 0.00000000e+00, 0.11055600e+02},
    { 53, 42,  1,  0, 0.51659320e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 42,  1,  1, 0.41612070e+03, 0.99680000e+00, 0.19420000e+01},
    { 53, 42,  1,  2, 0.34710000e+03, 0.99680000e+00, 0.11055600e+02},
    { 53, 43,  0,  0, 0.56879090e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 43,  0,  1, 0.45697070e+03, 0.00000000e+00, 0.16682000e+01},
    { 53, 43,  0,  2, 0.30566670e+03, 0.00000000e+00, 0.95402000e+01},
    { 53, 43,  1,  0, 0.57428050e+03, 0.99680000e+00, 0.00000000e+00},
    { 53, 43,  1,  1, 0.46132230e+03, 0.99680000e+00, 0.16682000e+01},
    { 53, 43,  1,  2, 0.30847430e+03, 0.99680000e+00, 0.95402000e+01},
    { 53, 44,  0,  0, 0.43799920e+03, 0.00000000e+00, 0.00000000e+00},
    { 53, 44,  0,  1, 0.36253740e+03, 0.00000000e+00, 0.18584000e+01},
    { 53, 44,  0,  2, 0.28960010e+03, 0.00000000e+00, 0.88