/* ../IrFactorials.inl v20180522 EST [storm, Gerald Knizia] */
namespace ir {
static double const s_BinomialTableF[441] = {
   1.0, 1.0, 1.0, 2.0, 1.0, 3.0, 1.0, 4.0,
   6.0, 1.0, 5.0, 10.0, 1.0, 6.0, 15.0, 20.0,
   1.0, 7.0, 21.0, 35.0, 1.0, 8.0, 28.0, 56.0,
   70.0, 1.0, 9.0, 36.0, 84.0, 126.0, 1.0, 10.0,
   45.0, 120.0, 210.0, 252.0, 1.0, 11.0, 55.0, 165.0,
   330.0, 462.0, 1.0, 12.0, 66.0, 220.0, 495.0, 792.0,
   924.0, 1.0, 13.0, 78.0, 286.0, 715.0, 1287.0, 1716.0,
   1.0, 14.0, 91.0, 364.0, 1001.0, 2002.0, 3003.0, 3432.0,
   1.0, 15.0, 105.0, 455.0, 1365.0, 3003.0, 5005.0, 6435.0,
   1.0, 16.0, 120.0, 560.0, 1820.0, 4368.0, 8008.0, 11440.0,
   12870.0, 1.0, 17.0, 136.0, 680.0, 2380.0, 6188.0, 12376.0,
   19448.0, 24310.0, 1.0, 18.0, 153.0, 816.0, 3060.0, 8568.0,
   18564.0, 31824.0, 43758.0, 48620.0, 1.0, 19.0, 171.0, 969.0,
   3876.0, 11628.0, 27132.0, 50388.0, 75582.0, 92378.0, 1.0, 20.0,
   190.0, 1140.0, 4845.0, 15504.0, 38760.0, 77520.0, 125970.0, 167960.0,
   184756.0, 1.0, 21.0, 210.0, 1330.0, 5985.0, 20349.0, 54264.0,
   116280.0, 203490.0, 293930.0, 352716.0, 1.0, 22.0, 231.0, 1540.0,
   7315.0, 26334.0, 74613.0, 170544.0, 319770.0, 497420.0, 646646.0, 705432.0,
   1.0, 23.0, 253.0, 1771.0, 8855.0, 33649.0, 100947.0, 245157.0,
   490314.0, 817190.0, 1144066.0, 1352078.0, 1.0, 24.0, 276.0, 2024.0,
   10626.0, 42504.0, 134596.0, 346104.0, 735471.0, 1307504.0, 1961256.0, 2496144.0,
   2704156.0, 1.0, 25.0, 300.0, 2300.0, 12650.0, 53130.0, 177100.0,
   480700.0, 1081575.0, 2042975.0, 3268760.0, 4457400.0, 5200300.0, 1.0, 26.0,
   325.0, 2600.0, 14950.0, 65780.0, 230230.0, 657800.0, 1562275.0, 3124550.0,
   5311735.0, 7726160.0, 9657700.0, 10400600.0, 1.0, 27.0, 351.0, 2925.0,
   17550.0, 80730.0, 296010.0, 888030.0, 2220075.0, 4686825.0, 8436285.0, 13037895.0,
   17383860.0, 20058300.0, 1.0, 28.0, 378.0, 3276.0, 20475.0, 98280.0,
   376740.0, 1184040.0, 3108105.0, 6906900.0, 13123110.0, 21474180.0, 30421755.0, 37442160.0,
   40116600.0, 1.0, 29.0, 406.0, 3654.0, 23751.0, 118755.0, 475020.0,
   1560780.0, 4292145.0, 10015005.0, 20030010.0, 34597290.0, 51895935.0, 67863915.0, 77558760.0,
   1.0, 30.0, 435.0, 4060.0, 27405.0, 142506.0, 593775.0, 2035800.0,
   5852925.0, 14307150.0, 30045015.0, 54627300.0, 86493225.0, 119759850.0, 145422675.0, 155117520.0,
   1.0, 31.0, 465.0, 4495.0, 31465.0, 169911.0, 736281.0, 2629575.0,
   7888725.0, 20160075.0, 44352165.0, 84672315.0, 141120525.0, 206253075.0, 265182525.0, 300540195.0,
   1.0, 32.0, 496.0, 4960.0, 35960.0, 201376.0, 906192.0, 3365856.0,
   10518300.0, 28048800.0, 64512240.0, 129024480.0, 225792840.0, 347373600.0, 471435600.0, 565722720.0,
   601080390.0, 1.0, 33.0, 528.0, 5456.0, 40920.0, 237336.0, 1107568.0,
   4272048.0, 13884156.0, 38567100.0, 92561040.0, 193536720.0, 354817320.0, 573166440.0, 818809200.0,
   1037158320.0, 1166803110.0, 1.0, 34.0, 561.0, 5984.0, 46376.0, 278256.0,
   1344904.0, 5379616.0, 18156204.0, 52451256.0, 131128140.0, 286097760.0, 548354040.0, 927983760.0,
   1391975640.0, 1855967520.0, 2203961430.0, 2333606220.0, 1.0, 35.0, 595.0, 6545.0,
   52360.0, 324632.0, 1623160.0, 6724520.0, 23535820.0, 70607460.0, 183579396.0, 417225900.0,
   834451800.0, 1476337800.0, 2319959400.0, 3247943160.0, 4059928950.0, 4537567650.0, 1.0, 36.0,
   630.0, 7140.0, 58905.0, 376992.0, 1947792.0, 8347680.0, 30260340.0, 94143280.0,
   254186856.0, 600805296.0, 1251677700.0, 2310789600.0, 3796297200.0, 5567902560.0, 7307872110.0, 8597496600.0,
   9075135300.0, 1.0, 37.0, 666.0, 7770.0, 66045.0, 435897.0, 2324784.0,
   10295472.0, 38608020.0, 124403620.0, 348330136.0, 854992152.0, 1852482996.0, 3562467300.0, 6107086800.0,
   9364199760.0, 12875774670.0, 15905368710.0, 17672631900.0, 1.0, 38.0, 703.0, 8436.0,
   73815.0, 501942.0, 2760681.0, 12620256.0, 48903492.0, 163011640.0, 472733756.0, 1203322288.0,
   2707475148.0, 5414950296.0, 9669554100.0, 15471286560.0, 22239974430.0, 28781143380.0, 33578000610.0, 35345263800.0,
   1.0, 39.0, 741.0, 9139.0, 82251.0, 575757.0, 3262623.0, 15380937.0,
   61523748.0, 211915132.0, 635745396.0, 1676056044.0, 3910797436.0, 8122425444.0, 15084504396.0, 25140840660.0,
   37711260990.0, 51021117810.0, 62359143990.0, 68923264410.0, 1.0, 40.0, 780.0, 9880.0,
   91390.0, 658008.0, 3838380.0, 18643560.0, 76904685.0, 273438880.0, 847660528.0, 2311801440.0,
   5586853480.0, 12033222880.0, 23206929840.0, 40225345056.0, 62852101650.0, 88732378800.0, 113380261800.0, 131282408400.0,
   137846528820.0
}; // 3.45 kb

double GetBinomialCoeffF(size_t N, size_t K) {
   assert(K <= N);
   if (N > 40)
      throw std::runtime_error("GetBinomialCoeffF: ran out of binomial coefficients.");
   if (K > N/2)
      K = N - K;
   return s_BinomialTableF[((N+1)/2)*((N+2)/2) + K];
}

static size_t const s_FactorialTableI[21] = {
   1, 1, 2, 6, 24, 120, 720, 5040,
   40320, 362880, 3628800, 39916800, 479001600, 6227020800, 87178291200, 1307674368000,
   20922789888000, 355687428096000, 6402373705728000, 121645100408832000, 2432902008176640000
}; // 0.16 kb

size_t GetFactorialI(ptrdiff_t N) {
   N += 0;
   if (size_t(N) >= 21)
      throw std::runtime_error("integer overflow in ir::GetFactorialI()");
   return s_FactorialTableI[N];
}

static size_t const s_DoubleFactorialTableI[35] = {
   1, 1, 1, 2, 3, 8, 15, 48,
   105, 384, 945, 3840, 10395, 46080, 135135, 645120,
   2027025, 10321920, 34459425, 185794560, 654729075, 3715891200, 13749310575, 81749606400,
   316234143225, 1961990553600, 7905853580625, 51011754393600, 213458046676875, 1428329123020800, 6190283353629375, 42849873690624000,
   191898783962510625, 1371195958099968000, 6332659870762850625
}; // 0.27 kb

size_t GetDoubleFactorialI(ptrdiff_t N) {
   N += 1;
   if (size_t(N) >= 35)
      throw std::runtime_error("integer overflow in ir::GetDoubleFactorialI()");
   return s_DoubleFactorialTableI[N];
}

} // namespace ir
