# Default compilation command sequence:
#
#     mkdir build && cd build
#     qmake-qt4 ../main.pro && make -j 12 && make install
#     cd ..
#
# Afterwards there should be a "iboview" executable in the main directory ("make
# install" copies the exe from the build directory to the project file
# directory)
#
# Note: if the external blas does not work, you can compile with
#
#     BLASLIB= MKLROOT= qmake-qt4 main.pro && make -j 12 && make install
#
# to force internal LAPACK emulation


BLASLIB=$$(BLASLIB)
# ^-- pick up environment variable BLASLIB if present. See: https://doc.qt.io/archives/qt-4.8/qmake-advanced-usage.html
!isEmpty($$BLASLIB) {
   message(using BLAS linker line from environment variable BLASLIB: $$BLASLIB)
}
# no BLAS/LAPACK linker line explicitly specified as environment variable?
isEmpty(BLASLIB) {
   # try to pick up MKL from the (default) MKLROOT environment variable.
   # You may need to "load module mkl" before doing that.
   # If the MKLROOT environment variable is not set, you can also override
   # the path manually (e.g., setting MKLDIR = /opt/intel/composerxe/mkl)
   MKLDIR = $$(MKLROOT)
#    message(MKLROOT environment variable: $$MKLDIR)
   !isEmpty(MKLDIR) {
      exists($$MKLDIR) {
         message(Using MKL from MKLROOT: $$MKLDIR)
         BLASLIB = -L$$MKLDIR/lib/intel64 -lmkl_intel_ilp64 -lmkl_gnu_thread -lmkl_core -fopenmp -lpthread -Wl,-rpath,$$MKLDIR/lib/intel64
      }
      !exists($$MKLDIR) {
         message(Directory $$MKLDIR specified in MKLROOT environment variable does not exist)
      }
   }
   # To set up some other sort of BLAS/LAPACK manually: set the required linker
   # line to BLASLIB. E.g.:
   #
   # BLASLIB = -LC:\Users\cgk\Develop\Libraries\OpenBLAS\bin -lopenblas
   #
   # Notes: 
   # - Header or include files are not needed, and will not be used if
   #   provided.
   # - Make sure that is a BLAS with 64bit integer interface!
   #   (e.g., -lmkl_intel_ilp64, NOT -lmkl_intel_lp64).
}

# message(final BLASLIB:$$BLASLIB)
!isEmpty(BLASLIB) {
   message(Using external BLAS/LAPACK: $$BLASLIB)
   LIBS += $$BLASLIB
   HAVE_EXTERNAL_BLAS = 1
}
isEmpty(BLASLIB) {
   message(Using internal BLAS/LAPACK emulation.)
   # set HAVE_EXTERNAL_BLAS to 0. In this case, we will include compilation of
   # our hacked f2c LAPACK and a eigen BLAS wrapper. This is normally good
   # enough for IboView analysis applications (MicroScf might suffer a bit,
   # though)
   HAVE_EXTERNAL_BLAS = 0
}


###! START_DIRS
MICROSCF = src/MicroScf
MIGRID = src/MicroScf
IRCORE = src/IrCore
CXF = src/Common
IV = src/IboView
OTHER = src/External
GL = src/GL
PUGIXML = src/pugixml
equals(HAVE_EXTERNAL_BLAS,0) {
   EIGEN = src/eigen
   EIGENBLAS = src/eigen/blas
   INCLUDEPATH += $$EIGEN
   INCLUDEPATH += $$EIGENBLAS
   # INCLUDEPATH += $$EIGENLAPACK
}
###! END_DIRS

TEMPLATE = app
TARGET = iboview
DEPENDPATH += .
#/ LIBS += -L/opt/local/lib
#/ INCLUDEPATH += /opt/local/include/
INCLUDEPATH += src
INCLUDEPATH += $$IV
INCLUDEPATH += $$MICROSCF
INCLUDEPATH += $$IRCORE
INCLUDEPATH += $$CXF
INCLUDEPATH += $$OTHER
INCLUDEPATH += $$PUGIXML
DEFINES += USE_CTINT1E_H
DEFINES += PROG_IBOVIEW
DEFINES += ENABLE_GLOBAL_RNG
DEFINES += IR_ECP


# By default, make "make install" copy the final executable to the same
# directory in which the main project file (main.pro) lies. IboView has all its
# data files embedded as QT resources, so apart from the exe itself no extra
# files are needed.
target.path = $$_PRO_FILE_PWD_
# program.files = $$TARGET
INSTALLS += target
# ^-- see: https://doc.qt.io/qt-5/qmake-advanced-usage.html#installing-files


!lessThan(QT_MAJOR_VERSION, 5) {
   load(configure) # to enable qtCompileTest (unfortunately, that's QT5+ only...)

   # Enable test for presence of boost libraries (optional).
   # - https://stackoverflow.com/questions/22238446/qmake-checking-for-library
   # - https://doc.qt.io/qt-5/qmake-test-function-reference.html#qtcompiletest-test
   qtCompileTest(boost_special)
}
lessThan(QT_MAJOR_VERSION, 5) {
   BOOST_ROOT=$$(BOOST_ROOT)
   isEmpty($$BOOST_ROOT) {
      BOOST_ROOT=/usr/include/boost
   }
   exists($$BOOST_ROOT/math/special_functions/beta.hpp) {
      CONFIG += config_boost_special
   }
}

CONFIG(config_boost_special) {
   # enabling this will enable the log Gamma optional functionals for IBO localization
   # (which use gamma/digamma/trigamma functions) and a cgk special for radial DFT grids
   # using incomplete beta functions. Boost special functions are header only, and do not
   # need compiled libraries. However, they are still a pain to install on some platforms,
   # so this functionality is optional.
   DEFINES += HAVE_BOOST_SPECIAL_FUNCTIONS
}

# LIBS += -lGLEW     # OpenGL extension wrangler library (rest is included automatically via QT += opengl).
# (brings own implementation of glew.c now, from glew-20140726.tgz)
DEFINES += GLEW_STATIC
SOURCES += $$GL/glew.c
HEADERS += $$GL/glew.h $$GL/glxew.h $$GL/wglew.h

# OPTFLAGS = -O2 -march=native
# QMAKE_CFLAGS_RELEASE  = $$OPTFLAGS
# QMAKE_CXXFLAGS_RELEASE = $$OPTFLAGS
# ^- still makes it slower... (but DOES get rid of the -g switch which qmake
#    otherwise also sets for release builds. Still not sure where that comes
#    from.)


#msvc:QMAKE_CXXFLAGS_RELEASE += /O2 /openmp /arch:AVX
#gcc:QMAKE_CXXFLAGS_RELEASE += -O3 -march=native -fopenmp -D_GLIBCXX_PARALLEL

# LIBS += -lboost_program_options
# ^- no longer used

QT += core gui widgets opengl script svg
CONFIG += qt
CONFIG -= debug
CONFIG += release
DEFINES += NDEBUG
# ^- does this work?! assertions are still there!!

# CONFIG += debug
# CONFIG -= release
# DEFINES += _DEBUG
# 
# QMAKE_LFLAGS += -lmcheck

# flags for profiling (gprof)
# QMAKE_CFLAGS_RELEASE += -g -pg
# QMAKE_CXXFLAGS_RELEASE += -g -pg
# QMAKE_LFLAGS_RELEASE += -g -pg

# flags for profiling (callgrind)
# QMAKE_CFLAGS_RELEASE += -g
# QMAKE_CXXFLAGS_RELEASE += -g
# QMAKE_LFLAGS_RELEASE += -g

# # remove -g's. Make very large executables.
# QMAKE_CFLAGS_RELEASE -= -g
# QMAKE_CXXFLAGS_RELEASE -= -g
# QMAKE_LFLAGS_RELEASE -= -g

# OpenMP
msvc {
   QMAKE_CXXFLAGS += /openmp
   QMAKE_LFLAGS += /openmp
}
!msvc {
   QMAKE_CXXFLAGS += -fopenmp
   QMAKE_LFLAGS += -fopenmp
}
# ^- warning: need to replace all OpenMP loop variables by "int". Otherwise won't work
#    in vc or gcc <= 4.4 (unsigned integral types only allowed since OpenMP 3.0... wtf
#    were they thinking?!)
# https://stackoverflow.com/questions/18371797/qmake-handling-options-for-both-gcc-and-msvc
# gcc:QMAKE_CXXFLAGS += -Wno-deprecated-copy -Wno-class-memaccess
# message($${QMAKE_CXXFLAGS})
# message($${QMAKE_COMPILER})
# ^- doesn't work. Apparently no compiler is set.
#QMAKE_CXXFLAGS += -Wno-deprecated-copy -Wno-class-memaccess -Wno-implicit-fallthrough -fmax-errors=10
QMAKE_CXXFLAGS += /MP
INCLUDEPATH += C:\SDKs\boost_1_77_0
LIBS += opengl32.lib

QMAKE_CXXFLAGS_RELEASE -= -O2 -mtune=generic
QMAKE_CXXFLAGS_RELEASE -= -fstack-protector -fstack-protector-strong --param=ssp-buffer-size=4
# QMAKE_CXXFLAGS_RELEASE += -Ofast -march=native -DNDEBUG
QMAKE_CXXFLAGS_RELEASE += /O2 -Ofast -ffast-math -march=native -DNDEBUG
QMAKE_CXXFLAGS_RELEASE += /MP /O2 /openmp /arch:AVX -DNDEBUG
DEFINES += NDEBUG
# QMAKE_CXXFLAGS_RELEASE += -DINCLUDE_OPTIONALS

# note: for compiling with clang instead of g++ on linux:
#   /usr/bin/qmake-qt4 -spec /usr/lib64/qt4/mkspecs/unsupported/linux-clang
# (works for me, but doesn't do OpenMP)

# Input
# FORMS += MainForm.ui
FORMS += $$IV/MainForm2.ui $$IV/AboutForm.ui $$IV/FindOrbitalsForm.ui $$IV/ShowTextForm.ui $$IV/ComputeWfForm.ui $$IV/TablesForm.ui $$IV/EditFramesForm.ui $$IV/PreferencesForm.ui $$IV/ComputeEosForm.ui $$IV/$$IV/EditVolumeSurfaceForm.ui
# OpenFiles.ui
RESOURCES += resources.qrc

equals(HAVE_EXTERNAL_BLAS,0) {
   SOURCES += $$EIGENBLAS/double.cpp $$EIGENBLAS/xerbla.cpp
   DEFINES += NO_OVERWRITE USE_EIGEN_LA
}

HEADERS += $$IV/Iv.h $$IV/IvMain.h $$IV/IvSettings.h $$IV/IvView3D.h $$IV/IvDataSet.h $$IV/IvDataOptions.h $$IV/IvVolumeDataSet.h $$IV/IvOrbital.h $$IV/IvDocument.h $$IV/IvAnalysis.h $$IV/IvIsoSurface.h $$IV/IvMesh.h $$IV/IvScript.h $$IV/IvIao.h $$IV/IvIrc.h $$IV/IvGl.h $$IV/IvLog.h $$IV/fn_LiberationSans.h
SOURCES += $$IV/IvMain.cpp $$IV/IvSettings.cpp $$IV/IvView3D.cpp $$IV/IvDataSet.cpp $$IV/IvDataOptions.cpp $$IV/IvVolumeDataSet.cpp $$IV/IvOrbital.cpp $$IV/IvDocument.cpp  $$IV/IvAnalysis.cpp $$IV/IvScript.cpp $$IV/IvMesh.cpp $$IV/IvIsoSurface.cpp $$IV/IvIao.cpp $$IV/IvIrc.cpp $$IV/IvGl.cpp $$IV/IvLog.cpp

HEADERS += $$IV/IvOrbitalFile.h $$IV/IvCurveView.h $$IV/IvComputeWfForm.h $$IV/IvFindOrbitalsForm.h $$IV/IvShowTextForm.h $$IV/IvFixedAspectSvg.h $$IV/IvStatusBar.h $$IV/IvTables.h $$IV/IvEditFramesForm.h $$IV/IvPreferencesForm.h $$IV/IvEditVolumeSurface.h $$IV/IvFileConvert.h $$IV/IvComputeEosForm.h
SOURCES += $$IV/IvOrbitalFile.cpp $$IV/IvCurveView.cpp $$IV/IvComputeWfForm.cpp $$IV/IvFindOrbitalsForm.cpp $$IV/IvShowTextForm.cpp $$IV/IvFixedAspectSvg.cpp $$IV/IvStatusBar.cpp $$IV/IvTables.cpp $$IV/IvEditFramesForm.cpp $$IV/IvPreferencesForm.cpp $$IV/IvEditVolumeSurface.cpp $$IV/IvFileConvert.cpp $$IV/IvComputeEosForm.cpp
# SOURCES += $$IV/IvIntInit.cpp 


HEADERS += $$PUGIXML/pugixml.hpp $$PUGIXML/pugiconfig.hpp
SOURCES += $$PUGIXML/pugixml.cpp

SOURCES += $$OTHER/memory_size.c
HEADERS += $$OTHER/optionparser.h
HEADERS += $$OTHER/vector_math.h

# HEADERS += LoadMolproXml.h pugixml/pugixml.hpp pugixml/pugiconfig.hpp
# SOURCES += LoadMolproXml.cpp pugixml/pugixml.cpp

# INCLUDEPATH += ./cppformat/
# HEADERS += cppformat/format.h
# SOURCES += cppformat/format.cpp

HEADERS += $$OTHER/QPropertyModel.h
SOURCES += $$OTHER/QPropertyModel.cpp


SOURCES += $$CXF/CxAssertFail.cpp
SOURCES += $$CXF/CxAlgebra.cpp
SOURCES += $$CXF/CxDiis.cpp
SOURCES += $$CXF/CxIndentStream.cpp
SOURCES += $$CXF/CxMemoryStack.cpp
# SOURCES += $$CXF/CxNumpyArray.cpp
SOURCES += $$CXF/CxStorageDevice.cpp
SOURCES += $$CXF/CxColor.cpp
SOURCES += $$CXF/CxIntrusivePtr.h

# SOURCES += $$CXF/CxLebedevGrid.cpp
# HEADERS += $$CXF/CxLebedevGrid.h
HEADERS += $$CXF/CxAngularGrid_Orbits.inl
HEADERS += $$CXF/CxAngularGrid_Grids.inl
HEADERS += $$CXF/CxAngularGrid.h
SOURCES += $$CXF/CxAngularGrid.cpp
DEFINES += USE_AIGG_GRIDS


# SOURCES += $$CXF/CxOsInt.cpp
SOURCES += $$IRCORE/IrAmrr.cpp
SOURCES += $$IRCORE/IrBoysFn.cpp
HEADERS += $$IRCORE/IrBoysFn.inl
SOURCES += $$IRCORE/IrCore.cpp
SOURCES += $$IRCORE/IrDrv.cpp
SOURCES += $$IRCORE/IrGridOps.cpp
HEADERS += $$IRCORE/IrInternal.h
HEADERS += $$IRCORE/IrDrvAux.h
SOURCES += $$IRCORE/IrDrvAux.cpp
# SOURCES += $$IRCORE/IrSlmX.cpp
# ^- part of IrAmrr.cpp now, for the time being.
SOURCES += $$IRCORE/IrMeta2i.cpp
HEADERS += $$IRCORE/IrMeta2i.h
SOURCES += $$IRCORE/IrSlmRot.cpp
SOURCES += $$IRCORE/IrImportTrafo.cpp
SOURCES += $$IRCORE/IrEcp.cpp
SOURCES += $$IRCORE/IrEcpBesselFn.cpp
SOURCES += $$IRCORE/IrComplexRlm.cpp
HEADERS += $$IRCORE/IrComplexRlm.h
DEFINES += IR_KERNEL_PTRS


# SOURCES += $$IV/CtDftGrid_ivb.cpp
# HEADERS += $$IV/CtDftGrid_ivb.h
HEADERS += $$CXF/CxParse1.h
SOURCES += $$CXF/CxParse1.cpp
HEADERS += $$MIGRID/CtDftGrid.h
SOURCES += $$MIGRID/CtDftGrid.cpp
HEADERS += $$MIGRID/CtDftGrid_Params.h
SOURCES += $$MIGRID/CtDftGrid_Params.cpp
HEADERS += $$MIGRID/CtDftGrid_Radial.h
SOURCES += $$MIGRID/CtDftGrid_Radial.cpp
SOURCES += $$MIGRID/CtDftGrid_CommonDefs.h
HEADERS += $$MIGRID/CtDftGrid_QuadCriteria.h
SOURCES += $$MIGRID/CtDftGrid_QuadCriteria.cpp
SOURCES += $$MIGRID/CtVoronoiPartition.cpp
HEADERS += $$MIGRID/CtVoronoiPartition.h
SOURCES += $$CXF/CxDensityModel.cpp
HEADERS += $$CXF/CxDensityModel.h
HEADERS += $$MICROSCF/CtAtomDensity.inl
HEADERS += $$MICROSCF/CtAtomDensity.h
SOURCES += $$MICROSCF/CtAtomDensity.cpp
# HEADERS += atomic_density_tab_backup/CtAtomDensity.inl
# HEADERS += atomic_density_tab_backup/CtAtomDensity.h
# SOURCES += atomic_density_tab_backup/CtAtomDensity.cpp

# HEADERS += $$MICROSCF/CtCosmo.h
# SOURCES += $$MICROSCF/CtCosmo.cpp
# SOURCES += $$MICROSCF/CtAtomPropMap.h
HEADERS += $$MICROSCF/CtAtomSet.h
HEADERS += $$MICROSCF/CtBasisLibrary.h
HEADERS += $$MICROSCF/CtBasisSet.h
HEADERS += $$MICROSCF/CtBasisShell.h
HEADERS += $$MICROSCF/CtBasisDesc.h
SOURCES += $$MICROSCF/CtBasisDesc.cpp
# HEADERS += $$MICROSCF/CtAtomDensity.h
HEADERS += $$MICROSCF/CtInt1e.h
HEADERS += $$MICROSCF/CtMatrix.h
HEADERS += $$CXF/CxArgSort.h
HEADERS += $$MICROSCF/CtWfi.h
SOURCES += $$MICROSCF/CtWfi.cpp
HEADERS += $$MICROSCF/CtWfa.h
SOURCES += $$MICROSCF/CtWfa.cpp
HEADERS += $$MICROSCF/CtIvStubs.h
# ^-- note: the .cpp of it should *not* be included!
HEADERS += $$MICROSCF/CtVolumeProperty.h
SOURCES += $$MICROSCF/CtVolumeProperty.cpp

HEADERS += $$CXF/CxRawAtom.h
SOURCES += $$CXF/CxRawAtom.cpp
HEADERS += $$CXF/CxXyzFrameIo.h
SOURCES += $$CXF/CxXyzFrameIo.cpp
HEADERS += $$CXF/CxIo.h
SOURCES += $$CXF/CxIo.cpp
HEADERS += $$CXF/CxTiming.h
SOURCES += $$CXF/CxTiming.cpp
HEADERS += $$CXF/CxPhysicalUnits.h
HEADERS += $$CXF/CxAtomData.h
HEADERS += $$CXF/CxAtomData.inl
SOURCES += $$CXF/CxAtomData.cpp
HEADERS += $$CXF/CxSortedTable.h
HEADERS += $$CXF/CxSequenceIo.h
HEADERS += $$CXF/CxIterTools.h
HEADERS += $$CXF/CxPrintLevel.h
SOURCES += $$CXF/CxPrintLevel.cpp
HEADERS += $$CXF/CxAtomParamSpec.h
HEADERS += $$CXF/CxNewtonAux.h
HEADERS += $$CXF/CxNewtonAux.cpp
HEADERS += $$CXF/CxAlgebra.h
HEADERS += $$CXF/CxDefs.h
HEADERS += $$CXF/CxDiis.h
# HEADERS += $$CXF/CxFixedSizeArray.h
HEADERS += $$CXF/CxFortranInt.h
HEADERS += $$CXF/CxIndentStream.h
HEADERS += $$CXF/CxMemoryStack.h
# HEADERS += $$CXF/CxNumpyArray.h
HEADERS += $$CXF/CxOpenMpProxy.h
HEADERS += $$CXF/CxOpenMpAcc.h
HEADERS += $$CXF/CxPodArray.h
HEADERS += $$CXF/CxStorageDevice.h
HEADERS += $$CXF/CxTypes.h
HEADERS += $$CXF/CxVec3.h
HEADERS += $$CXF/CxMathAlgo.h
HEADERS += $$CXF/CxColor.h
HEADERS += $$CXF/CxPoly.h
SOURCES += $$CXF/CxPoly.cpp
HEADERS += $$CXF/CxOsInt.h
SOURCES += $$CXF/CxOsInt.cpp
# CxRandom used for random rotation code in orbital localization to test for stability
# of finding global optimum.
HEADERS += $$CXF/CxRandom.h
SOURCES += $$CXF/CxRandom.cpp


# HEADERS += $$CXF/CxOsInt.h
HEADERS += $$IRCORE/IrAmrr.h
HEADERS += $$IRCORE/IrBoysFn.h
HEADERS += $$IRCORE/IrBoysFn.inl
HEADERS += $$IRCORE/IrEcp.h
HEADERS += $$IRCORE/IrMeta2i.h
HEADERS += $$IRCORE/Ir.h
HEADERS += $$IRCORE/IrFactorials.inl
HEADERS += $$IRCORE/IrFactorials.h
HEADERS += $$IRCORE/IrComplexRlm.h

# SOURCES += $$MICROSCF/CtDftGrid.cpp
# SOURCES += $$IV/CtDftGrid_ivb.cpp
SOURCES += $$MICROSCF/CtAtomSet.cpp
SOURCES += $$MICROSCF/CtBasisLibrary.cpp
SOURCES += $$MICROSCF/CtBasisSet.cpp
SOURCES += $$MICROSCF/CtBasisShell.cpp
SOURCES += $$MICROSCF/CtInt1e.cpp
# SOURCES += $$MICROSCF/CtMain.cpp
SOURCES += $$MICROSCF/CtMatrix.cpp

# SOURCES += $$MICROSCF/CtAtomDensity.cpp
SOURCES += $$MICROSCF/CtAtomConfigs.cpp
SOURCES += $$MICROSCF/CtDft.cpp
HEADERS += $$MICROSCF/CtDft.h
SOURCES += $$MICROSCF/CtDfti.cpp
HEADERS += $$MICROSCF/CtDfti.h
SOURCES += $$MICROSCF/CtDftFunc.cpp
HEADERS += $$MICROSCF/CtDftFunc.h
SOURCES += $$MICROSCF/CtFockBuild.cpp
HEADERS += $$MICROSCF/CtFockBuild.h
SOURCES += $$MICROSCF/CtRhf.cpp
HEADERS += $$MICROSCF/CtRhf.h
HEADERS += $$MICROSCF/CtRhfOptions.h
SOURCES += $$MICROSCF/CtRhfOptions.cpp
SOURCES += $$MICROSCF/CtRhfGuess.cpp
HEADERS += $$MICROSCF/CtRhfGuess.h
# SOURCES += $$MICROSCF/CtRhfProp.cpp
# HEADERS += $$MICROSCF/CtRhfProp.h
SOURCES += $$MICROSCF/CtIao.cpp
HEADERS += $$MICROSCF/CtIao.h
SOURCES += $$MICROSCF/CtOrbLoc.cpp
HEADERS += $$MICROSCF/CtOrbLoc.h
HEADERS += $$MICROSCF/CtWfDecl.h
SOURCES += $$MICROSCF/CtWfDecl.cpp
SOURCES += $$MICROSCF/format.cpp
HEADERS += $$MICROSCF/format.h
SOURCES += $$MICROSCF/xc_meta.cpp
HEADERS += $$MICROSCF/xc_meta.h
SOURCES += $$MICROSCF/coords_meta.cpp
HEADERS += $$MICROSCF/coords_meta.h
HEADERS += $$MICROSCF/CtDftDispCorr.h
HEADERS += $$MICROSCF/CtDftDispCorr.inl
SOURCES += $$MICROSCF/CtDftDispCorr.cpp




#CONFIG -= dynamic
#CONFIG += static
# ^- I wonder if that works? ... nop. no effect at all.
