// xc functional: MN15-L non-separable exchange-correlation functional.
// Functional Form: Pure functional; Semi-local meta-GGA (tau-form)
// Parameterization: With broad set of diverse thermochemical and other data, mostly from non-empirical high-level reference calculations, some from accurate experimental references (see: http://truhlar.chem.umn.edu/content/databases)
// Original article: Yu, He, Truhlar; J. Chem. Theory Comput., 2016, 12, pp 1280-1293; http://dx.doi.org/10.1021/acs.jctc.5b01082
// 
// Implemented by Alyssa Bienvenu, July 2016
void xc_mn15l(double &E, double *dE, double const *D, double const Factor)
{
   double const Au = 0.0310907;
   double const Alpha1u = 0.2137;
   double const Beta1u = 7.5957;
   double const Beta2u = 3.5876;
   double const Beta3u = 1.6382;
   double const Beta4u = 0.49294;
   double const Ap = 0.01554535;
   double const Alpha1p = 0.20548;
   double const Beta1p = 14.1189;
   double const Beta2p = 6.1977;
   double const Beta3p = 3.3662;
   double const Beta4p = 0.62517;
   double const Aa = 0.0168869;
   double const Alpha1a = 0.11125;
   double const Beta1a = 10.357;
   double const Beta2a = 3.6231;
   double const Beta3a = 0.88026;
   double const Beta4a = 0.49671;
   double rhoc = D[0];
   double rhoo = D[1];
   double sigmacc = D[2];
   double sigmaco = D[3];
   double sigmaoo = D[4];
   double tauc = D[5];
   double tauo = D[6];
   double r1 = 1.0/rhoc;
   double r2 = 1 - 1.0*r1*rhoo;
   double r3 = r1*rhoo + 1;
   double r4 = pow(r3,(2.0/3.0)) + pow(r2,(2.0/3.0));
   double r5 = pow(r4,3);
   double r6 = 1.442249570307408;
   double r7 = 1.0/r6;
   double r8 = 1.464591887561523;
   double r9 = 1.0/pow(rhoc,(7.0/3.0));
   double r10 = sqr(r4);
   double r11 = 1.0/r10;
   double r12 = 1.0/r5;
   double r13 = 2.080083823051904;
   double r14 = 2.519842099789746;
   double r15 = 1.0/r14;
   double r16 = 2.145029397111025;
   double r17 = 1.0/r16;
   double r18 = pow(rhoc,(2.0/3.0));
   double r19 = 1.0/r18;
   double r20 = 1.732050807568877;
   double r21 = 0.5641895835477563;
   double r22 = sqrt(rhoc);
   double r23 = 1.0/r22;
   double r24 = 0.6299605249474366;
   double r25 = 1.0/r8;
   double r26 = 1.0/pow(rhoc,(1.0/3.0));
   double r27 = 1.259921049894873;
   double r28 = 1.0/r27;
   double r29 = 1.200936955176003;
   double r30 = 0.8263074871107581;
   double r31 = 1.0/pow(rhoc,(1.0/6.0));
   double r32 = 0.5*r20*r21*r23*Beta3u + r28*r29*r30*Beta1u*r31 + r6*r24*r25*Beta2u*r26 + r13*r15*r17*Beta4u*r19;
   double r33 = 0.5/(r32*Au) + 1;
   double r34 = log(r33);
   double r35 = r6*r24*r25*Alpha1u*r26 + 1;
   double r36 = 2.0*r34*r35*Au;
   double r37 = 2.519842099789746;
   double r38 = 1.0/(r37 - 2.0);
   double r39 = 0.5*r20*r21*r23*Beta3p + r28*r29*r30*Beta1p*r31 + r6*r24*r25*Beta2p*r26 + r13*r15*r17*Beta4p*r19;
   double r40 = 0.5/(r39*Ap) + 1;
   double r41 = log(r40);
   double r42 = r6*r24*r25*Alpha1p*r26 + 1;
   double r43 = r36 - 2.0*r41*r42*Ap;
   double r44 = 1.0/pow(rhoc,4);
   double r45 = pow(rhoo,4);
   double r46 = pow(r3,(4.0/3.0)) + pow(r2,(4.0/3.0)) - 2;
   double r47 = 0.5*r20*r21*r23*Beta3a + r28*r29*r30*Beta1a*r31 + r6*r24*r25*Beta2a*r26 + r13*r15*r17*Beta4a*r19;
   double r48 = 0.5/(r47*Aa) + 1;
   double r49 = log(r48);
   double r50 = r6*r24*r25*Alpha1a*r26 + 1;
   double r51 = 1 - 1.0*r44*r45;
   double r52 = (-2.25*r46*r49*r50*r51*Aa) - 1.0*r38*r43*r44*r45*r46 + r36;
   double r53 = pow(2.718281828459045,(257.3117475433186*r12*r52));
   double r54 = r53 - 1;
   double r55 = 1.0/r54;
   double r56 = 0.5365315849918411*r7*r8*r9*r11*r55*sigmacc;
   double r57 = r56 + 1;
   double r58 = 1.0/r13;
   double r59 = 1.0/pow(rhoc,(14.0/3.0));
   double r60 = 1.0/pow(r4,4);
   double r61 = 1.0/sqr(r54);
   double r62 = sqr(sigmacc);
   double r63 = 0.2878661416938572*r58*r16*r59*r60*r61*r62 + r56 + 1;
   double r64 = 1.0/r63;
   double r65 = 0.5365315849918411*r7*r8*r9*r11*sigmacc*r57*r64 + 1;
   double r66 = log(r65);
   double r67 = 6.240251469155714;
   double r68 = 4.601151114470489;
   double r69 = pow(rhoc,(5.0/3.0));
   double r70 = 1.0/tauc;
   double r71 = 0.1*r67*r68*r69*r70;
   double r72 = r71 - 1;
   double r73 = pow(r72,8);
   double r74 = r71 + 1;
   double r75 = 1.0/pow(r74,8);
   double r76 = pow(r72,7);
   double r77 = 1.0/pow(r74,7);
   double r78 = pow(r72,6);
   double r79 = 1.0/pow(r74,6);
   double r80 = pow(r72,5);
   double r81 = 1.0/pow(r74,5);
   double r82 = pow(r72,4);
   double r83 = 1.0/pow(r74,4);
   double r84 = pow(r72,3);
   double r85 = 1.0/pow(r74,3);
   double r86 = sqr(r72);
   double r87 = 1.0/sqr(r74);
   double r88 = 1.0/r74;
   double r89 = (-7.689358913*r72*r88) - 0.70532663*r86*r87 - 0.600096421*r84*r85 + 11.03332527*r82*r83 + 5.861969337*r80*r81 + 8.913865465*r78*r79 + 5.74529876*r76*r77 + 4.254880837*r73*r75 + 0.819504932;
   double r90 = (-2.0*r34*r35*Au) + 2.25*r46*r49*r50*r51*Aa + r38*r43*r44*r45*r46;
   double r91 = (-0.756954364*r72*r88) + 5.677396094*r86*r87 - 5.017104782*r84*r85 - 5.10654071*r82*r83 - 4.812053335*r80*r81 + 3.397640087*r78*r79 + 1.980041517*r76*r77 + 10.1231046*r73*r75 + 0.952058087;
   double r92 = 5.039684199579494;
   double r93 = 1.0/r92;
   double r94 = 4.326748710922225;
   double r95 = rhoc - 1.0*rhoo;
   double r96 = pow(r95,(4.0/3.0));
   double r97 = pow(r95,(1.0/3.0));
   double r98 = 2.5*r28*r97 + 1;
   double r99 = 1.0/r98;
   double r100 = 1.587401051968199;
   double r101 = 1.0/r100;
   double r102 = 1.0/sqr(r98);
   double r103 = pow(r95,(2.0/3.0));
   double r104 = 1.0/pow(r98,3);
   double r105 = 1.0/pow(r95,8);
   double r106 = sigmaoo - 2.0*sigmaco + sigmacc;
   double r107 = pow(r106,3);
   double r108 = pow(r95,(8.0/3.0));
   double r109 = 1.0/r108;
   double r110 = 0.004*r100*r109*r106 + 1;
   double r111 = 1.0/pow(r110,3);
   double r112 = 1.0/pow(r95,(16.0/3.0));
   double r113 = sqr(r106);
   double r114 = 1.0/sqr(r110);
   double r115 = 1.0/pow(r95,5);
   double r116 = 1.0/r110;
   double r117 = pow(r95,(7.0/3.0));
   double r118 = 1.0/r117;
   double r119 = sqr(r95);
   double r120 = 1.0/r119;
   double r121 = 3.301927248894626;
   double r122 = pow(r95,(5.0/3.0));
   double r123 = 2.0*tauc;
   double r124 = r123 - 2.0*tauo;
   double r125 = 1.0/r124;
   double r126 = 0.6*r101*r121*r122*r125*r68;
   double r127 = r126 - 1;
   double r128 = pow(r127,5);
   double r129 = r126 + 1;
   double r130 = 1.0/pow(r129,5);
   double r131 = pow(r127,4);
   double r132 = 1.0/pow(r129,4);
   double r133 = pow(r127,3);
   double r134 = 1.0/pow(r129,3);
   double r135 = sqr(r127);
   double r136 = 1.0/sqr(r129);
   double r137 = 1.0/r129;
   double r138 = 0.298350171*r102*r120*r106*r116*r127*r137 + 0.02537532196*r27*r99*r118*r106*r116*r127*r137 - 0.026790567964*r100*r109*r106*r116*r127*r137 + 0.00017933621904*r99*r115*r113*r114*r127*r137 + 0.00018943030496*r37*r112*r113*r114*r127*r137 + 6.220771783679999e-07*r105*r107*r111*r127*r137 - 5.6323525859375*r104*r95*r127*r137 - 14.53672306875*r101*r102*r103*r127*r137 + 9.251213227500001*r28*r99*r97*r127*r137 - 0.822003903*r127*r137 + 0.246323207575*r102*r120*r106*r116*r135*r136 + 0.03143390933*r27*r99*r118*r106*r116*r135*r136 - 0.01729125798*r100*r109*r106*r116*r135*r136 + 0.00016285710704*r99*r115*r113*r114*r135*r136 + 8.139122097599998e-05*r37*r112*r113*r114*r135*r136 + 2.84028338688e-06*r105*r107*r111*r135*r136 - 22.156539671875*r104*r95*r135*r136 + 7.13712914375*r101*r102*r103*r135*r136 + 2.169479035*r28*r99*r97*r135*r136 - 1.022407046*r135*r136 + 0.02939126332*r27*r99*r118*r106*r116*r133*r134 - 0.027146565504*r100*r109*r106*r116*r133*r134 + 6.8837919168e-05*r37*r112*r113*r114*r133*r134 - 9.7697814125*r101*r102*r103*r133*r134 - 1.477976295*r28*r99*r97*r133*r134 + 1.689460986*r133*r134 - 0.022749845848*r100*r109*r106*r116*r131*r132 - 0.7382635875*r28*r99*r97*r131*r132 - 0.00562032*r131*r132 - 0.110293849*r128*r130 + 0.197050821775*r102*r120*r106*r116 - 0.05825759145*r27*r99*r118*r106*r116 + 0.003888980712*r100*r109*r106*r116 + 4.794736912e-05*r99*r115*r113*r114 + 0.000150714301088*r37*r112*r113*r114 - 2.0668008064e-06*r105*r107*r111 + 4.5627362890625*r104*r95 - 9.53340026875*r101*r102*r103 + 3.1183347725*r28*r99*r97 + 0.670864162;
   double r139 = rhoo + rhoc;
   double r140 = pow(r139,(4.0/3.0));
   double r141 = pow(r139,(1.0/3.0));
   double r142 = 2.5*r28*r141 + 1;
   double r143 = 1.0/pow(r142,3);
   double r144 = pow(r139,(2.0/3.0));
   double r145 = 1.0/sqr(r142);
   double r146 = 1.0/r142;
   double r147 = 1.0/pow(r139,8);
   double r148 = sigmaoo + 2.0*sigmaco + sigmacc;
   double r149 = pow(r148,3);
   double r150 = pow(r139,(8.0/3.0));
   double r151 = 1.0/r150;
   double r152 = 0.004*r100*r151*r148 + 1;
   double r153 = 1.0/pow(r152,3);
   double r154 = 1.0/pow(r139,(16.0/3.0));
   double r155 = sqr(r148);
   double r156 = 1.0/sqr(r152);
   double r157 = 1.0/pow(r139,5);
   double r158 = 1.0/r152;
   double r159 = sqr(r139);
   double r160 = 1.0/r159;
   double r161 = pow(r139,(7.0/3.0));
   double r162 = 1.0/r161;
   double r163 = pow(r139,(5.0/3.0));
   double r164 = 2.0*tauo + r123;
   double r165 = 1.0/r164;
   double r166 = 0.6*r101*r121*r163*r165*r68;
   double r167 = r166 - 1;
   double r168 = pow(r167,5);
   double r169 = r166 + 1;
   double r170 = 1.0/pow(r169,5);
   double r171 = pow(r167,4);
   double r172 = 1.0/pow(r169,4);
   double r173 = pow(r167,3);
   double r174 = 1.0/pow(r169,3);
   double r175 = sqr(r167);
   double r176 = 1.0/sqr(r169);
   double r177 = 1.0/r169;
   double r178 = 0.02537532196*r27*r162*r146*r148*r158*r167*r177 + 0.298350171*r160*r145*r148*r158*r167*r177 - 0.026790567964*r100*r151*r148*r158*r167*r177 + 0.00017933621904*r157*r146*r155*r156*r167*r177 + 0.00018943030496*r37*r154*r155*r156*r167*r177 + 6.220771783679999e-07*r147*r149*r153*r167*r177 + 9.251213227500001*r28*r141*r146*r167*r177 - 14.53672306875*r101*r144*r145*r167*r177 - 5.6323525859375*r139*r143*r167*r177 - 0.822003903*r167*r177 + 0.03143390933*r27*r162*r146*r148*r158*r175*r176 + 0.246323207575*r160*r145*r148*r158*r175*r176 - 0.01729125798*r100*r151*r148*r158*r175*r176 + 0.00016285710704*r157*r146*r155*r156*r175*r176 + 8.139122097599998e-05*r37*r154*r155*r156*r175*r176 + 2.84028338688e-06*r147*r149*r153*r175*r176 + 2.169479035*r28*r141*r146*r175*r176 + 7.13712914375*r101*r144*r145*r175*r176 - 22.156539671875*r139*r143*r175*r176 - 1.022407046*r175*r176 + 0.02939126332*r27*r162*r146*r148*r158*r173*r174 - 0.027146565504*r100*r151*r148*r158*r173*r174 + 6.8837919168e-05*r37*r154*r155*r156*r173*r174 - 1.477976295*r28*r141*r146*r173*r174 - 9.7697814125*r101*r144*r145*r173*r174 + 1.689460986*r173*r174 - 0.022749845848*r100*r151*r148*r158*r171*r172 - 0.7382635875*r28*r141*r146*r171*r172 - 0.00562032*r171*r172 - 0.110293849*r168*r170 - 0.05825759145*r27*r162*r146*r148*r158 + 0.197050821775*r160*r145*r148*r158 + 0.003888980712*r100*r151*r148*r158 + 4.794736912e-05*r157*r146*r155*r156 + 0.000150714301088*r37*r154*r155*r156 - 2.0668008064e-06*r147*r149*r153 + 3.1183347725*r28*r141*r146 - 9.53340026875*r101*r144*r145 + 4.5627362890625*r139*r143 + 0.670864162;
   double r179 = 1.0/r65;
   double r180 = 1.0/sqr(r63);
   double r181 = 1.0/sqr(rhoc);
   double r182 = pow(r2,(1.0/3.0));
   double r183 = 1.0/r182;
   double r184 = pow(r3,(1.0/3.0));
   double r185 = 1.0/r184;
   double r186 = 0.6666666666666666*r181*r183*rhoo - 0.6666666666666666*r181*r185*rhoo;
   double r187 = -1.073063169983682*r7*r8*r9*r186*r12*r55*sigmacc;
   double r188 = 1.0/r94;
   double r189 = 1.0/pow(rhoc,(10.0/3.0));
   double r190 = -3.755721094942888*r188*r8*r189*r11*r55*sigmacc;
   double r191 = 1.0/r33;
   double r192 = 1.0/r69;
   double r193 = 1.0/pow(r22,3);
   double r194 = 1.0/pow(rhoc,(4.0/3.0));
   double r195 = 1.0/r37;
   double r196 = 0.4003123183920009;
   double r197 = 1.0/pow(rhoc,(7.0/6.0));
   double r198 = (-2.0*r15*r17*r192*r7*Beta4u) - 0.25*r193*r20*r21*Beta3u - 1.0*r194*r24*r25*r58*Beta2u - 1.0*r195*r196*r197*r30*Beta1u;
   double r199 = 1.0/sqr(r32);
   double r200 = -1.0*r191*r198*r199*r35;
   double r201 = -2.0*r194*r24*r25*r34*r58*Alpha1u*Au;
   double r202 = 1.333333333333333*r181*r182*rhoo - 1.333333333333333*r181*r184*rhoo;
   double r203 = 1.0/pow(rhoc,5);
   double r204 = (1.0*r42*((-2.0*r15*r17*r192*r7*Beta4p) - 0.25*r193*r20*r21*Beta3p - 1.0*r194*r24*r25*r58*Beta2p - 1.0*r195*r196*r197*r30*Beta1p))/(sqr(r39)*r40) + 2.0*r194*r24*r25*r41*r58*Alpha1p*Ap + r201 + r200;
   double r205 = 1.0/r48;
   double r206 = (-2.0*r15*r17*r192*r7*Beta4a) - 0.25*r193*r20*r21*Beta3a - 1.0*r194*r24*r25*r58*Beta2a - 1.0*r195*r196*r197*r30*Beta1a;
   double r207 = 1.0/sqr(r47);
   double r208 = 0.1574901312368591;
   double r209 = 257.3117475433186*r12*((-2.25*r202*r49*r50*r51*Aa) - 9.0*r203*r45*r46*r49*r50*Aa + 1.125*r205*r206*r207*r46*r50*r51 + r94*r208*r25*Aa*Alpha1a*r49*r194*r51*r46 - 1.0*r204*r38*r44*r45*r46 + 4.0*r203*r38*r43*r45*r46 - 1.0*r202*r38*r43*r44*r45 + r201 + r200) - 771.9352426299557*r186*r60*r52;
   double r210 = -0.5365315849918411*r7*r8*r9*r11*r209*r61*r53*sigmacc;
   double r211 = 1.0/pow(r4,5);
   double r212 = 1.0/pow(r54,3);
   double r213 = 1.0/pow(r74,9);
   double r214 = 1.0/r103;
   double r215 = 1.0/r97;
   double r216 = 1.0/pow(r98,4);
   double r217 = 12.69920841574559;
   double r218 = 1.0/pow(r95,(35.0/3.0));
   double r219 = pow(r106,4);
   double r220 = 1.0/pow(r110,4);
   double r221 = 1.0/pow(r95,9);
   double r222 = 1.0/pow(r95,(26.0/3.0));
   double r223 = 20.15873679831796;
   double r224 = 1.0/pow(r95,(19.0/3.0));
   double r225 = 40.31747359663593;
   double r226 = 1.0/pow(r95,6);
   double r227 = 1.0/pow(r95,(17.0/3.0));
   double r228 = 1.0/pow(r95,(11.0/3.0));
   double r229 = 1.0/pow(r95,(10.0/3.0));
   double r230 = 1.0/pow(r95,3);
   double r231 = 1.0/pow(r129,6);
   double r232 = 1.0/pow(r95,(14.0/3.0));
   double r233 = 1.0/r122;
   double r234 = 1.0/pow(r95,(22.0/3.0));
   double r235 = 3.174802103936399;
   double r236 = 1.0/pow(r95,(13.0/3.0));
   double r237 = 1.0/r96;
   double r238 = 1.0/pow(r142,4);
   double r239 = 1.0/r141;
   double r240 = 1.0/r144;
   double r241 = 1.0/pow(r139,(35.0/3.0));
   double r242 = pow(r148,4);
   double r243 = 1.0/pow(r152,4);
   double r244 = 1.0/pow(r139,9);
   double r245 = 1.0/pow(r139,(26.0/3.0));
   double r246 = 1.0/pow(r139,(19.0/3.0));
   double r247 = 1.0/pow(r139,(17.0/3.0));
   double r248 = 1.0/pow(r139,6);
   double r249 = 1.0/pow(r139,(11.0/3.0));
   double r250 = 1.0/pow(r139,3);
   double r251 = 1.0/pow(r139,(10.0/3.0));
   double r252 = 1.0/pow(r169,6);
   double r253 = 1.0/pow(r139,(14.0/3.0));
   double r254 = 1.0/r163;
   double r255 = 1.0/pow(r139,(22.0/3.0));
   double r256 = 1.0/pow(r139,(13.0/3.0));
   double r257 = 1.0/r140;
   double r258 = -1.0*r140*((-0.05920908457333333*r27*r251*r146*r148*r158*r167*r177) - 0.6178464436333333*r250*r145*r148*r158*r167*r177 - 0.497250285*r28*r151*r143*r148*r158*r167*r177 + 0.008930189321333333*r217*r249*r148*r158*r167*r177 - 0.0003553408933866666*r248*r146*r155*r156*r167*r177 + 0.000397800228*r217*r247*r145*r155*r156*r167*r177 - 0.0001494468492*r28*r247*r145*r155*r156*r167*r177 - 6.314343498666666e-05*r225*r246*r155*r156*r167*r177 - 3.572075728533334e-05*r223*r246*r155*r156*r167*r177 + 4.782299174399998e-07*r217*r245*r146*r149*r153*r167*r177 + 1.118810192964266e-05*r244*r149*r153*r167*r177 + 2.488308713472e-09*r217*r241*r242*r243*r167*r177 + 3.0837377425*r28*r240*r146*r167*r177 - 4.845574356249999*r27*r239*r145*r167*r177 - 7.70934435625*r101*r239*r145*r167*r177 + 6.481583304687497*r143*r167*r177 + 14.08088146484375*r28*r141*r238*r167*r177 + 0.02537532196*r28*r121*r68*r254*r146*r148*r158*r165*r177 + 0.298350171*r101*r121*r68*r257*r145*r148*r158*r165*r177 - 0.026790567964*r121*r68*r160*r148*r158*r165*r177 + 0.00017933621904*r101*r121*r68*r256*r146*r155*r156*r165*r177 + 0.00018943030496*r100*r121*r68*r253*r155*r156*r165*r177 + 6.220771783679999e-07*r101*r121*r68*r255*r149*r153*r165*r177 + 4.62560661375*r121*r68*r139*r146*r165*r177 - 14.53672306875*r195*r121*r68*r140*r145*r165*r177 - 5.6323525859375*r101*r121*r68*r163*r143*r165*r177 - 0.822003903*r101*r121*r68*r144*r165*r177 - 0.07334578843666668*r27*r251*r146*r148*r158*r175*r176 - 0.5188413395916668*r250*r145*r148*r158*r175*r176 - 0.4105386792916667*r28*r151*r143*r148*r158*r175*r176 + 0.00576375266*r217*r249*r148*r158*r175*r176 - 0.0001436954694933332*r248*r146*r155*r156*r175*r176 + 0.0003284309434333333*r217*r247*r145*r155*r156*r175*r176 - 0.0001357142558666666*r28*r247*r145*r155*r156*r175*r176 - 2.713040699199999e-05*r225*r246*r155*r156*r175*r176 - 2.305501064e-05*r223*r246*r155*r156*r175*r176 + 4.342856187733332e-07*r217*r245*r146*r149*r153*r175*r176 - 1.5776882905088e-05*r244*r149*r153*r175*r176 + 1.136113354752e-08*r217*r241*r242*r243*r175*r176 + 0.7231596783333334*r28*r240*r146*r175*r176 + 2.379043047916666*r27*r239*r145*r175*r176 - 1.807899195833333*r101*r239*r145*r175*r176 - 28.10414729166666*r143*r175*r176 + 55.3913491796875*r28*r141*r238*r175*r176 + 0.03143390933*r100*r121*r68*r254*r146*r148*r158*r165*r167*r176 - 0.02537532196*r28*r121*r68*r254*r146*r148*r158*r165*r167*r176 + 0.246323207575*r27*r121*r68*r257*r145*r148*r158*r165*r167*r176 - 0.298350171*r101*r121*r68*r257*r145*r148*r158*r165*r167*r176 - 0.007791947996000002*r121*r68*r160*r148*r158*r165*r167*r176 + 0.00016285710704*r27*r121*r68*r256*r146*r155*r156*r165*r167*r176 - 0.00017933621904*r101*r121*r68*r256*r146*r155*r156*r165*r167*r176 + 8.139122097599998e-05*r235*r121*r68*r253*r155*r156*r165*r167*r176 - 0.00018943030496*r100*r121*r68*r253*r155*r156*r165*r167*r176 + 2.84028338688e-06*r27*r121*r68*r255*r149*r153*r165*r167*r176 - 6.220771783679999e-07*r101*r121*r68*r255*r149*r153*r165*r167*r176 - 2.45612757875*r121*r68*r139*r146*r165*r167*r176 + 7.13712914375*r28*r121*r68*r140*r145*r165*r167*r176 + 14.53672306875*r195*r121*r68*r140*r145*r165*r167*r176 - 22.156539671875*r27*r121*r68*r163*r143*r165*r167*r176 + 5.6323525859375*r101*r121*r68*r163*r143*r165*r167*r176 - 1.022407046*r27*r121*r68*r144*r165*r167*r176 + 0.822003903*r101*r121*r68*r144*r165*r167*r176 - 0.06857961441333334*r27*r251*r146*r148*r158*r173*r174 - 0.02449271943333333*r250*r145*r148*r158*r173*r174 + 0.009048855168*r217*r249*r148*r158*r173*r174 + 0.0006270136174933333*r248*r146*r155*r156*r173*r174 - 2.2945973056e-05*r225*r246*r155*r156*r173*r174 - 3.6195420672e-05*r223*r246*r155*r156*r173*r174 + 5.874169102335999e-06*r244*r149*r153*r173*r174 - 0.4926587649999999*r28*r240*r146*r173*r174 - 3.256593804166667*r27*r239*r145*r173*r174 + 1.2316469125*r101*r239*r145*r173*r174 + 8.141484510416666*r143*r173*r174 - 0.03143390933*r100*r121*r68*r254*r146*r148*r158*r165*r175*r174 + 0.08817378996*r28*r121*r68*r254*r146*r148*r158*r165*r175*r174 - 0.246323207575*r27*r121*r68*r257*r145*r148*r158*r165*r175*r174 - 0.046857180552*r121*r68*r160*r148*r158*r165*r175*r174 - 0.00016285710704*r27*r121*r68*r256*r146*r155*r156*r165*r175*r174 - 8.139122097599998e-05*r235*r121*r68*r253*r155*r156*r165*r175*r174 + 0.000206513757504*r100*r121*r68*r253*r155*r156*r165*r175*r174 - 2.84028338688e-06*r27*r121*r68*r255*r149*r153*r165*r175*r174 - 4.3864434775*r121*r68*r139*r146*r165*r175*r174 - 7.13712914375*r28*r121*r68*r140*r145*r165*r175*r174 - 29.3093442375*r195*r121*r68*r140*r145*r165*r175*r174 + 22.156539671875*r27*r121*r68*r163*r143*r165*r175*r174 + 1.022407046*r27*r121*r68*r144*r165*r175*r174 + 5.068382958*r101*r121*r68*r144*r165*r175*r174 + 0.007583281949333333*r217*r249*r148*r158*r171*r172 - 3.033312779733333e-05*r223*r246*r155*r156*r171*r172 - 0.2460878625*r28*r240*r146*r171*r172 + 0.61521965625*r101*r239*r145*r171*r172 - 0.08817378996*r28*r121*r68*r254*r146*r148*r158*r165*r173*r172 - 0.009559686880000001*r121*r68*r160*r148*r158*r165*r173*r172 - 0.000206513757504*r100*r121*r68*r253*r155*r156*r165*r173*r172 + 0.7404372675000002*r121*r68*r139*r146*r165*r173*r172 + 29.3093442375*r195*r121*r68*r140*r145*r165*r173*r172 - 0.00562032*r37*r121*r68*r144*r165*r173*r172 - 5.068382958*r101*r121*r68*r144*r165*r173*r172 + 0.090999383392*r121*r68*r160*r148*r158*r165*r171*r170 + 1.476527175*r121*r68*r139*r146*r165*r171*r170 + 0.00562032*r37*r121*r68*r144*r165*r171*r170 - 0.551469245*r101*r121*r68*r144*r165*r171*r170 + 0.551469245*r101*r121*r68*r144*r165*r168*r252 + 0.13593438005*r27*r251*r146*r148*r158 - 0.345553650675*r250*r145*r148*r158 - 0.3284180362916666*r28*r151*r143*r148*r158 - 0.001296326904*r217*r249*r148*r158 - 0.0014825654632*r248*r146*r155*r156 + 0.0002627344290333333*r217*r247*r145*r155*r156 - 3.995614093333333e-05*r28*r247*r145*r155*r156 - 5.023810036266667e-05*r225*r246*r155*r156 + 5.185307616e-06*r223*r246*r155*r156 + 1.278596509866667e-07*r217*r245*r146*r149*r153 + 2.939536014404267e-05*r244*r149*r153 - 8.2672032256e-09*r217*r241*r242*r243 + 1.039444924166667*r28*r240*r146 - 3.177800089583333*r27*r239*r145 - 2.598612310416666*r101*r239*r145 + 12.50723651302083*r143 - 11.40684072265625*r28*r141*r238)*r24*r25*r93*r94;
   double r259 = -1.0*r14*r141*r178*r25*r6*r93;
   double r260 = 0.6666666666666666*r1*r185 - 0.6666666666666666*r1*r183;
   double r261 = -1.073063169983682*r7*r8*r9*r260*r12*r55*sigmacc;
   double r262 = 1.333333333333333*r1*r184 - 1.333333333333333*r1*r182;
   double r263 = pow(rhoo,3);
   double r264 = 257.3117475433186*r12*((-2.25*r262*r49*r50*r51*Aa) + 9.0*r263*r44*r46*r49*r50*Aa - 4.0*r263*r38*r43*r44*r46 - 1.0*r262*r38*r43*r44*r45) - 771.9352426299557*r260*r60*r52;
   double r265 = -0.5365315849918411*r7*r8*r9*r11*r264*r61*r53*sigmacc;
   double r266 = 1.0/pow(r95,(32.0/3.0));
   double r267 = 1.0/pow(r95,(23.0/3.0));
   double r268 = -1.0*(0.298350171*r102*r120*r116*r127*r137 + 0.02537532196*r27*r99*r118*r116*r127*r137 - 0.026790567964*r100*r109*r116*r127*r137 - 0.001193400684*r100*r102*r232*r106*r114*r127*r137 + 0.0001556698624*r99*r115*r106*r114*r127*r137 + 0.00018943030496*r92*r112*r106*r114*r127*r137 + 0.000107162271856*r37*r112*r106*r114*r127*r137 - 1.43468975232e-06*r100*r99*r267*r113*r111*r127*r137 - 4.195538223616e-06*r105*r113*r111*r127*r137 - 7.464926140416002e-09*r100*r266*r107*r220*r127*r137 + 0.246323207575*r102*r120*r116*r135*r136 + 0.03143390933*r27*r99*r118*r116*r135*r136 - 0.01729125798*r100*r109*r116*r135*r136 - 0.0009852928303000002*r100*r102*r232*r106*r114*r135*r136 + 7.424293943999988e-05*r99*r115*r106*r114*r135*r136 + 8.139122097599998e-05*r92*r112*r106*r114*r135*r136 + 6.916503192000002e-05*r37*r112*r106*r114*r135*r136 - 1.30285685632e-06*r100*r99*r267*r113*r111*r135*r136 + 5.916331089408e-06*r105*r113*r111*r135*r136 - 3.408340064256001e-08*r100*r266*r107*r220*r135*r136 + 0.02939126332*r27*r99*r118*r116*r133*r134 - 0.027146565504*r100*r109*r116*r133*r134 - 0.00023513010656*r99*r115*r106*r114*r133*r134 + 6.8837919168e-05*r92*r112*r106*r114*r133*r134 + 0.000108586262016*r37*r112*r106*r114*r133*r134 - 2.202813413376e-06*r105*r113*r111*r133*r134 - 0.022749845848*r100*r109*r116*r131*r132 + 9.0999383392e-05*r37*r112*r106*r114*r131*r132 + 0.197050821775*r102*r120*r116 - 0.05825759145*r27*r99*r118*r116 + 0.003888980712*r100*r109*r116 - 0.0007882032871*r100*r102*r232*r106*r114 + 0.00056195546984*r99*r115*r106*r114 + 0.000150714301088*r92*r112*r106*r114 - 1.5555922848e-05*r37*r112*r106*r114 - 3.8357895296e-07*r100*r99*r267*r113*r111 - 1.1023260054016e-05*r105*r113*r111 + 2.480160967680001e-08*r100*r266*r107*r220)*r24*r25*r93*r94*r96;
   double r269 = 1.0/pow(r139,(32.0/3.0));
   double r270 = 1.0/pow(r139,(23.0/3.0));
   double r271 = -1.0*r140*(0.02537532196*r27*r162*r146*r158*r167*r177 + 0.298350171*r160*r145*r158*r167*r177 - 0.026790567964*r100*r151*r158*r167*r177 + 0.0001556698624*r157*r146*r148*r156*r167*r177 - 0.001193400684*r100*r253*r145*r148*r156*r167*r177 + 0.00018943030496*r92*r154*r148*r156*r167*r177 + 0.000107162271856*r37*r154*r148*r156*r167*r177 - 1.43468975232e-06*r100*r270*r146*r155*r153*r167*r177 - 4.195538223616e-06*r147*r155*r153*r167*r177 - 7.464926140416002e-09*r100*r269*r149*r243*r167*r177 + 0.03143390933*r27*r162*r146*r158*r175*r176 + 0.246323207575*r160*r145*r158*r175*r176 - 0.01729125798*r100*r151*r158*r175*r176 + 7.424293943999988e-05*r157*r146*r148*r156*r175*r176 - 0.0009852928303000002*r100*r253*r145*r148*r156*r175*r176 + 8.139122097599998e-05*r92*r154*r148*r156*r175*r176 + 6.916503192000002e-05*r37*r154*r148*r156*r175*r176 - 1.30285685632e-06*r100*r270*r146*r155*r153*r175*r176 + 5.916331089408e-06*r147*r155*r153*r175*r176 - 3.408340064256001e-08*r100*r269*r149*r243*r175*r176 + 0.02939126332*r27*r162*r146*r158*r173*r174 - 0.027146565504*r100*r151*r158*r173*r174 - 0.00023513010656*r157*r146*r148*r156*r173*r174 + 6.8837919168e-05*r92*r154*r148*r156*r173*r174 + 0.000108586262016*r37*r154*r148*r156*r173*r174 - 2.202813413376e-06*r147*r155*r153*r173*r174 - 0.022749845848*r100*r151*r158*r171*r172 + 9.0999383392e-05*r37*r154*r148*r156*r171*r172 - 0.05825759145*r27*r162*r146*r158 + 0.197050821775*r160*r145*r158 + 0.003888980712*r100*r151*r158 + 0.00056195546984*r157*r146*r148*r156 - 0.0007882032871*r100*r253*r145*r148*r156 + 0.000150714301088*r92*r154*r148*r156 - 1.5555922848e-05*r37*r154*r148*r156 - 3.8357895296e-07*r100*r270*r146*r155*r153 - 1.1023260054016e-05*r147*r155*r153 + 2.480160967680001e-08*r100*r269*r149*r243)*r24*r25*r93*r94;
   double r272 = 10.07936839915899;
   double r273 = 1.0/sqr(tauc);
   double r274 = 18.72075440746714;
   double r275 = 1.0/sqr(r124);
   double r276 = 1.0/r95;
   double r277 = 6.349604207872797;
   double r278 = 1.0/sqr(r164);
   double r279 = 1.0/r139;
   double r280 = -1.0*r140*((-0.015225193176*r100*r121*r68*r240*r146*r148*r158*r278*r177) - 0.1790101026*r27*r121*r68*r239*r145*r148*r158*r278*r177 + 0.0321486815568*r121*r68*r279*r148*r158*r278*r177 - 0.000107601731424*r27*r121*r68*r251*r146*r155*r156*r278*r177 - 0.000113658182976*r235*r121*r68*r249*r155*r156*r278*r177 - 3.732463070208e-07*r27*r121*r68*r246*r149*r153*r278*r177 - 5.5507279365*r121*r68*r159*r146*r278*r177 + 8.72203384125*r28*r121*r68*r161*r145*r278*r177 + 3.3794115515625*r27*r121*r68*r150*r143*r278*r177 + 0.4932023418*r27*r121*r68*r163*r278*r177 - 0.018860345598*r235*r121*r68*r240*r146*r148*r158*r278*r167*r176 + 0.015225193176*r100*r121*r68*r240*r146*r148*r158*r278*r167*r176 - 0.147793924545*r37*r121*r68*r239*r145*r148*r158*r278*r167*r176 + 0.1790101026*r27*r121*r68*r239*r145*r148*r158*r278*r167*r176 + 0.0093503375952*r121*r68*r279*r148*r158*r278*r167*r176 - 9.771426422399999e-05*r37*r121*r68*r251*r146*r155*r156*r278*r167*r176 + 0.000107601731424*r27*r121*r68*r251*r146*r155*r156*r278*r167*r176 - 4.88347325856e-05*r277*r121*r68*r249*r155*r156*r278*r167*r176 + 0.000113658182976*r235*r121*r68*r249*r155*r156*r278*r167*r176 - 1.704170032128e-06*r37*r121*r68*r246*r149*r153*r278*r167*r176 + 3.732463070208e-07*r27*r121*r68*r246*r149*r153*r278*r167*r176 + 2.9473530945*r121*r68*r159*r146*r278*r167*r176 - 4.28227748625*r100*r121*r68*r161*r145*r278*r167*r176 - 8.72203384125*r28*r121*r68*r161*r145*r278*r167*r176 + 13.293923803125*r37*r121*r68*r150*r143*r278*r167*r176 - 3.3794115515625*r27*r121*r68*r150*r143*r278*r167*r176 + 0.6134442276000001*r37*r121*r68*r163*r278*r167*r176 - 0.4932023418*r27*r121*r68*r163*r278*r167*r176 + 0.018860345598*r235*r121*r68*r240*r146*r148*r158*r278*r175*r174 - 0.052904273976*r100*r121*r68*r240*r146*r148*r158*r278*r175*r174 + 0.147793924545*r37*r121*r68*r239*r145*r148*r158*r278*r175*r174 + 0.05622861666240001*r121*r68*r279*r148*r158*r278*r175*r174 + 9.771426422399999e-05*r37*r121*r68*r251*r146*r155*r156*r278*r175*r174 + 4.88347325856e-05*r277*r121*r68*r249*r155*r156*r278*r175*r174 - 0.0001239082545024*r235*r121*r68*r249*r155*r156*r278*r175*r174 + 1.704170032128e-06*r37*r121*r68*r246*r149*r153*r278*r175*r174 + 5.263732173*r121*r68*r159*r146*r278*r175*r174 + 4.28227748625*r100*r121*r68*r161*r145*r278*r175*r174 + 17.5856065425*r28*r121*r68*r161*r145*r278*r175*r174 - 13.293923803125*r37*r121*r68*r150*r143*r278*r175*r174 - 0.6134442276000001*r37*r121*r68*r163*r278*r175*r174 - 3.0410297748*r27*r121*r68*r163*r278*r175*r174 + 0.052904273976*r100*r121*r68*r240*r146*r148*r158*r278*r173*r172 + 0.01147162425599998*r121*r68*r279*r148*r158*r278*r173*r172 + 0.0001239082545024*r235*r121*r68*r249*r155*r156*r278*r173*r172 - 0.8885247210000002*r121*r68*r159*r146*r278*r173*r172 - 17.5856065425*r28*r121*r68*r161*r145*r278*r173*r172 + 0.003372192*r92*r121*r68*r163*r278*r173*r172 + 3.0410297748*r27*r121*r68*r163*r278*r173*r172 - 0.1091992600704*r121*r68*r279*r148*r158*r278*r171*r170 - 1.77183261*r121*r68*r159*r146*r278*r171*r170 - 0.003372192*r92*r121*r68*r163*r278*r171*r170 + 0.330881547*r27*r121*r68*r163*r278*r171*r170 - 0.330881547*r27*r121*r68*r163*r278*r168*r252)*r24*r25*r93*r94;
   E += Factor*((-1.0*r138*r24*r25*r93*r94*r96) - 1.0*r140*r178*r24*r25*r93*r94 + rhoc*r90*r91 + 0.003886336358706862*rhoc*r5*r66*r89);
   dE[0] += Factor*(0.003886336358706862*r179*r5*r89*rhoc*((-0.5365315849918411*r11*r180*r57*r7*r8*r9*((-(4.030125983714*r16*r60*r61*r62)/(r67*pow(rhoc,(17.0/3.0)))) - 1.151464566775429*r58*r16*r59*r186*r211*r61*r62 - 0.5757322833877143*r58*r16*r59*r60*r209*r212*r53*r62 + r210 + r190 + r187)*sigmacc) - 1.073063169983682*r7*r8*r9*r186*r12*sigmacc*r57*r64 - 3.755721094942888*r188*r8*r189*r11*sigmacc*r57*r64 + 0.5365315849918411*r7*r8*r9*r11*sigmacc*(r210 + r190 + r187)*r64) + r91*(2.0*r194*r24*r25*r34*r58*Alpha1u*Au - 1.0*r194*r208*r25*r46*r49*r51*r94*Aa*Alpha1a + 2.25*r202*r49*r50*r51*Aa + 9.0*r203*r45*r46*r49*r50*Aa - 1.125*r205*r206*r207*r46*r50*r51 + r38*r204*r44*r45*r46 - 4.0*r203*r38*r43*r45*r46 + r38*r43*r44*r45*r202 + r191*r198*r35*r199)*rhoc - 1.0*r138*r14*r25*r6*r93*r97 - 1.0*(0.298350171*r101*r121*r68*r102*r237*r106*r116*r137*r125 + 0.02537532196*r28*r121*r68*r99*r233*r106*r116*r137*r125 - 0.026790567964*r121*r68*r120*r106*r116*r137*r125 + 0.00017933621904*r101*r121*r68*r99*r236*r113*r114*r137*r125 + 0.00018943030496*r100*r121*r68*r232*r113*r114*r137*r125 + 6.220771783679999e-07*r101*r121*r68*r234*r107*r111*r137*r125 + 4.62560661375*r121*r68*r99*r95*r137*r125 - 5.6323525859375*r101*r121*r68*r104*r122*r137*r125 - 14.53672306875*r195*r121*r68*r102*r96*r137*r125 - 0.822003903*r101*r121*r68*r103*r137*r125 + 0.246323207575*r27*r121*r68*r102*r237*r106*r116*r127*r136*r125 - 0.298350171*r101*r121*r68*r102*r237*r106*r116*r127*r136*r125 + 0.03143390933*r100*r121*r68*r99*r233*r106*r116*r127*r136*r125 - 0.02537532196*r28*r121*r68*r99*r233*r106*r116*r127*r136*r125 - 0.007791947996000002*r121*r68*r120*r106*r116*r127*r136*r125 + 0.00016285710704*r27*r121*r68*r99*r236*r113*r114*r127*r136*r125 - 0.00017933621904*r101*r121*r68*r99*r236*r113*r114*r127*r136*r125 + 8.139122097599998e-05*r235*r121*r68*r232*r113*r114*r127*r136*r125 - 0.00018943030496*r100*r121*r68*r232*r113*r114*r127*r136*r125 + 2.84028338688e-06*r27*r121*r68*r234*r107*r111*r127*r136*r125 - 6.220771783679999e-07*r101*r121*r68*r234*r107*r111*r127*r136*r125 - 2.45612757875*r121*r68*r99*r95*r127*r136*r125 - 22.156539671875*r27*r121*r68*r104*r122*r127*r136*r125 + 5.6323525859375*r101*r121*r68*r104*r122*r127*r136*r125 + 7.13712914375*r28*r121*r68*r102*r96*r127*r136*r125 + 14.53672306875*r195*r121*r68*r102*r96*r127*r136*r125 - 1.022407046*r27*r121*r68*r103*r127*r136*r125 + 0.822003903*r101*r121*r68*r103*r127*r136*r125 - 0.246323207575*r27*r121*r68*r102*r237*r106*r116*r135*r134*r125 - 0.03143390933*r100*r121*r68*r99*r233*r106*r116*r135*r134*r125 + 0.08817378996*r28*r121*r68*r99*r233*r106*r116*r135*r134*r125 - 0.046857180552*r121*r68*r120*r106*r116*r135*r134*r125 - 0.00016285710704*r27*r121*r68*r99*r236*r113*r114*r135*r134*r125 - 8.139122097599998e-05*r235*r121*r68*r232*r113*r114*r135*r134*r125 + 0.000206513757504*r100*r121*r68*r232*r113*r114*r135*r134*r125 - 2.84028338688e-06*r27*r121*r68*r234*r107*r111*r135*r134*r125 - 4.3864434775*r121*r68*r99*r95*r135*r134*r125 + 22.156539671875*r27*r121*r68*r104*r122*r135*r134*r125 - 7.13712914375*r28*r121*r68*r102*r96*r135*r134*r125 - 29.3093442375*r195*r121*r68*r102*r96*r135*r134*r125 + 1.022407046*r27*r121*r68*r103*r135*r134*r125 + 5.068382958*r101*r121*r68*r103*r135*r134*r125 - 0.08817378996*r28*r121*r68*r99*r233*r106*r116*r133*r132*r125 - 0.009559686880000001*r121*r68*r120*r106*r116*r133*r132*r125 - 0.000206513757504*r100*r121*r68*r232*r113*r114*r133*r132*r125 + 0.7404372675000002*r121*r68*r99*r95*r133*r132*r125 + 29.3093442375*r195*r121*r68*r102*r96*r133*r132*r125 - 0.00562032*r37*r121*r68*r103*r133*r132*r125 - 5.068382958*r101*r121*r68*r103*r133*r132*r125 + 0.090999383392*r121*r68*r120*r106*r116*r131*r130*r125 + 1.476527175*r121*r68*r99*r95*r131*r130*r125 + 0.00562032*r37*r121*r68*r103*r131*r130*r125 - 0.551469245*r101*r121*r68*r103*r131*r130*r125 + 0.551469245*r101*r121*r68*r103*r128*r231*r125 - 0.497250285*r28*r104*r109*r106*r116*r127*r137 - 0.6178464436333333*r102*r230*r106*r116*r127*r137 - 0.05920908457333333*r27*r99*r229*r106*r116*r127*r137 + 0.008930189321333333*r217*r228*r106*r116*r127*r137 + 0.000397800228*r217*r102*r227*r113*r114*r127*r137 - 0.0001494468492*r28*r102*r227*r113*r114*r127*r137 - 0.0003553408933866666*r99*r226*r113*r114*r127*r137 - 6.314343498666666e-05*r225*r224*r113*r114*r127*r137 - 3.572075728533334e-05*r223*r224*r113*r114*r127*r137 + 4.782299174399998e-07*r217*r99*r222*r107*r111*r127*r137 + 1.118810192964266e-05*r221*r107*r111*r127*r137 + 2.488308713472e-09*r217*r218*r219*r220*r127*r137 + 14.08088146484375*r28*r216*r97*r127*r137 - 4.845574356249999*r27*r102*r215*r127*r137 - 7.70934435625*r101*r102*r215*r127*r137 + 3.0837377425*r28*r99*r214*r127*r137 + 6.481583304687497*r104*r127*r137 - 0.4105386792916667*r28*r104*r109*r106*r116*r135*r136 - 0.5188413395916668*r102*r230*r106*r116*r135*r136 - 0.07334578843666668*r27*r99*r229*r106*r116*r135*r136 + 0.00576375266*r217*r228*r106*r116*r135*r136 + 0.0003284309434333333*r217*r102*r227*r113*r114*r135*r136 - 0.0001357142558666666*r28*r102*r227*r113*r114*r135*r136 - 0.0001436954694933332*r99*r226*r113*r114*r135*r136 - 2.713040699199999e-05*r225*r224*r113*r114*r135*r136 - 2.305501064e-05*r223*r224*r113*r114*r135*r136 + 4.342856187733332e-07*r217*r99*r222*r107*r111*r135*r136 - 1.5776882905088e-05*r221*r107*r111*r135*r136 + 1.136113354752e-08*r217*r218*r219*r220*r135*r136 + 55.3913491796875*r28*r216*r97*r135*r136 + 2.379043047916666*r27*r102*r215*r135*r136 - 1.807899195833333*r101*r102*r215*r135*r136 + 0.7231596783333334*r28*r99*r214*r135*r136 - 28.10414729166666*r104*r135*r136 - 0.02449271943333333*r102*r230*r106*r116*r133*r134 - 0.06857961441333334*r27*r99*r229*r106*r116*r133*r134 + 0.009048855168*r217*r228*r106*r116*r133*r134 + 0.0006270136174933333*r99*r226*r113*r114*r133*r134 - 2.2945973056e-05*r225*r224*r113*r114*r133*r134 - 3.6195420672e-05*r223*r224*r113*r114*r133*r134 + 5.874169102335999e-06*r221*r107*r111*r133*r134 - 3.256593804166667*r27*r102*r215*r133*r134 + 1.2316469125*r101*r102*r215*r133*r134 - 0.4926587649999999*r28*r99*r214*r133*r134 + 8.141484510416666*r104*r133*r134 + 0.007583281949333333*r217*r228*r106*r116*r131*r132 - 3.033312779733333e-05*r223*r224*r113*r114*r131*r132 + 0.61521965625*r101*r102*r215*r131*r132 - 0.2460878625*r28*r99*r214*r131*r132 - 0.3284180362916666*r28*r104*r109*r106*r116 - 0.345553650675*r102*r230*r106*r116 + 0.13593438005*r27*r99*r229*r106*r116 - 0.001296326904*r217*r228*r106*r116 + 0.0002627344290333333*r217*r102*r227*r113*r114 - 3.995614093333333e-05*r28*r102*r227*r113*r114 - 0.0014825654632*r99*r226*r113*r114 - 5.023810036266667e-05*r225*r224*r113*r114 + 5.185307616e-06*r223*r224*r113*r114 + 1.278596509866667e-07*r217*r99*r222*r107*r111 + 2.939536014404267e-05*r221*r107*r111 - 8.2672032256e-09*r217*r218*r219*r220 - 11.40684072265625*r28*r216*r97 - 3.177800089583333*r27*r102*r215 - 2.598612310416666*r101*r102*r215 + 1.039444924166667*r28*r99*r214 + 12.50723651302083*r104)*r24*r25*r93*r94*r96 + r90*r91 + 0.003886336358706862*r5*r66*r89 + 0.01165900907612059*rhoc*r186*r10*r66*r89 + rhoc*r90*((-0.378477182*r13*r68*r18*r88*r70) + 6.055873276*r13*r68*r18*r72*r87*r70 - 2.508552391*r67*r68*r18*r86*r85*r70 - 5.677396094*r13*r68*r18*r86*r85*r70 + 2.508552391*r67*r68*r18*r84*r83*r70 - 10.21308142*r13*r68*r18*r84*r83*r70 - 1.817051917500001*r13*r68*r18*r82*r81*r70 + 3.397640087*r67*r68*r18*r80*r79*r70 + 12.0301333375*r13*r68*r18*r80*r79*r70 - 3.397640087*r67*r68*r18*r78*r77*r70 + 6.9301453095*r13*r68*r18*r78*r77*r70 + 33.5622730905*r13*r68*r18*r76*r75*r70 - 40.4924184*r13*r68*r18*r73*r213*r70) + 0.003886336358706862*rhoc*r5*r66*((-3.8446794565*r13*r68*r18*r88*r70) + 3.1393528265*r13*r68*r18*r72*r87*r70 - 0.3000482105*r67*r68*r18*r86*r85*r70 + 0.70532663*r13*r68*r18*r86*r85*r70 + 0.3000482105*r67*r68*r18*r84*r83*r70 + 22.06665054*r13*r68*r18*r84*r83*r70 - 7.411727197500003*r13*r68*r18*r82*r81*r70 + 8.913865465*r67*r68*r18*r80*r79*r70 - 14.6549233425*r13*r68*r18*r80*r79*r70 - 8.913865465*r67*r68*r18*r78*r77*r70 + 20.10854566*r13*r68*r18*r78*r77*r70 - 3.089022312000001*r13*r68*r18*r76*r75*r70 - 17.019523348*r13*r68*r18*r73*r213*r70) + r259 + r258);
   dE[1] += Factor*(r91*(2.25*r262*r49*r50*r51*Aa - 9.0*r263*r44*r46*r49*r50*Aa + 4.0*r263*r38*r43*r44*r46 + r38*r43*r44*r45*r262)*rhoc - 1.0*((-0.298350171*r101*r121*r68*r102*r237*r106*r116*r137*r125) - 0.02537532196*r28*r121*r68*r99*r233*r106*r116*r137*r125 + 0.026790567964*r121*r68*r120*r106*r116*r137*r125 - 0.00017933621904*r101*r121*r68*r99*r236*r113*r114*r137*r125 - 0.00018943030496*r100*r121*r68*r232*r113*r114*r137*r125 - 6.220771783679999e-07*r101*r121*r68*r234*r107*r111*r137*r125 - 4.62560661375*r121*r68*r99*r95*r137*r125 + 5.6323525859375*r101*r121*r68*r104*r122*r137*r125 + 14.53672306875*r195*r121*r68*r102*r96*r137*r125 + 0.822003903*r101*r121*r68*r103*r137*r125 - 0.246323207575*r27*r121*r68*r102*r237*r106*r116*r127*r136*r125 + 0.298350171*r101*r121*r68*r102*r237*r106*r116*r127*r136*r125 - 0.03143390933*r100*r121*r68*r99*r233*r106*r116*r127*r136*r125 + 0.02537532196*r28*r121*r68*r99*r233*r106*r116*r127*r136*r125 + 0.007791947996000002*r121*r68*r120*r106*r116*r127*r136*r125 - 0.00016285710704*r27*r121*r68*r99*r236*r113*r114*r127*r136*r125 + 0.00017933621904*r101*r121*r68*r99*r236*r113*r114*r127*r136*r125 - 8.139122097599998e-05*r235*r121*r68*r232*r113*r114*r127*r136*r125 + 0.00018943030496*r100*r121*r68*r232*r113*r114*r127*r136*r125 - 2.84028338688e-06*r27*r121*r68*r234*r107*r111*r127*r136*r125 + 6.220771783679999e-07*r101*r121*r68*r234*r107*r111*r127*r136*r125 + 2.45612757875*r121*r68*r99*r95*r127*r136*r125 + 22.156539671875*r27*r121*r68*r104*r122*r127*r136*r125 - 5.6323525859375*r101*r121*r68*r104*r122*r127*r136*r125 - 7.13712914375*r28*r121*r68*r102*r96*r127*r136*r125 - 14.53672306875*r195*r121*r68*r102*r96*r127*r136*r125 + 1.022407046*r27*r121*r68*r103*r127*r136*r125 - 0.822003903*r101*r121*r68*r103*r127*r136*r125 + 0.246323207575*r27*r121*r68*r102*r237*r106*r116*r135*r134*r125 + 0.03143390933*r100*r121*r68*r99*r233*r106*r116*r135*r134*r125 - 0.08817378996*r28*r121*r68*r99*r233*r106*r116*r135*r134*r125 + 0.046857180552*r121*r68*r120*r106*r116*r135*r134*r125 + 0.00016285710704*r27*r121*r68*r99*r236*r113*r114*r135*r134*r125 + 8.139122097599998e-05*r235*r121*r68*r232*r113*r114*r135*r134*r125 - 0.000206513757504*r100*r121*r68*r232*r113*r114*r135*r134*r125 + 2.84028338688e-06*r27*r121*r68*r234*r107*r111*r135*r134*r125 + 4.3864434775*r121*r68*r99*r95*r135*r134*r125 - 22.156539671875*r27*r121*r68*r104*r122*r135*r134*r125 + 7.13712914375*r28*r121*r68*r102*r96*r135*r134*r125 + 29.3093442375*r195*r121*r68*r102*r96*r135*r134*r125 - 1.022407046*r27*r121*r68*r103*r135*r134*r125 - 5.068382958*r101*r121*r68*r103*r135*r134*r125 + 0.08817378996*r28*r121*r68*r99*r233*r106*r116*r133*r132*r125 + 0.009559686880000001*r121*r68*r120*r106*r116*r133*r132*r125 + 0.000206513757504*r100*r121*r68*r232*r113*r114*r133*r132*r125 - 0.7404372675000002*r121*r68*r99*r95*r133*r132*r125 - 29.3093442375*r195*r121*r68*r102*r96*r133*r132*r125 + 0.00562032*r37*r121*r68*r103*r133*r132*r125 + 5.068382958*r101*r121*r68*r103*r133*r132*r125 - 0.090999383392*r121*r68*r120*r106*r116*r131*r130*r125 - 1.476527175*r121*r68*r99*r95*r131*r130*r125 - 0.00562032*r37*r121*r68*r103*r131*r130*r125 + 0.551469245*r101*r121*r68*r103*r131*r130*r125 - 0.551469245*r101*r121*r68*r103*r128*r231*r125 + 0.497250285*r28*r104*r109*r106*r116*r127*r137 + 0.6178464436333333*r102*r230*r106*r116*r127*r137 + 0.05920908457333333*r27*r99*r229*r106*r116*r127*r137 - 0.008930189321333333*r217*r228*r106*r116*r127*r137 - 0.000397800228*r217*r102*r227*r113*r114*r127*r137 + 0.0001494468492*r28*r102*r227*r113*r114*r127*r137 + 0.0003553408933866666*r99*r226*r113*r114*r127*r137 + 6.314343498666666e-05*r225*r224*r113*r114*r127*r137 + 3.572075728533334e-05*r223*r224*r113*r114*r127*r137 - 4.782299174399998e-07*r217*r99*r222*r107*r111*r127*r137 - 1.118810192964266e-05*r221*r107*r111*r127*r137 - 2.488308713472e-09*r217*r218*r219*r220*r127*r137 - 14.08088146484375*r28*r216*r97*r127*r137 + 4.845574356249999*r27*r102*r215*r127*r137 + 7.70934435625*r101*r102*r215*r127*r137 - 3.0837377425*r28*r99*r214*r127*r137 - 6.481583304687497*r104*r127*r137 + 0.4105386792916667*r28*r104*r109*r106*r116*r135*r136 + 0.5188413395916668*r102*r230*r106*r116*r135*r136 + 0.07334578843666668*r27*r99*r229*r106*r116*r135*r136 - 0.00576375266*r217*r228*r106*r116*r135*r136 - 0.0003284309434333333*r217*r102*r227*r113*r114*r135*r136 + 0.0001357142558666666*r28*r102*r227*r113*r114*r135*r136 + 0.0001436954694933332*r99*r226*r113*r114*r135*r136 + 2.713040699199999e-05*r225*r224*r113*r114*r135*r136 + 2.305501064e-05*r223*r224*r113*r114*r135*r136 - 4.342856187733332e-07*r217*r99*r222*r107*r111*r135*r136 + 1.5776882905088e-05*r221*r107*r111*r135*r136 - 1.136113354752e-08*r217*r218*r219*r220*r135*r136 - 55.3913491796875*r28*r216*r97*r135*r136 - 2.379043047916666*r27*r102*r215*r135*r136 + 1.807899195833333*r101*r102*r215*r135*r136 - 0.7231596783333334*r28*r99*r214*r135*r136 + 28.10414729166666*r104*r135*r136 + 0.02449271943333333*r102*r230*r106*r116*r133*r134 + 0.06857961441333334*r27*r99*r229*r106*r116*r133*r134 - 0.009048855168*r217*r228*r106*r116*r133*r134 - 0.0006270136174933333*r99*r226*r113*r114*r133*r134 + 2.2945973056e-05*r225*r224*r113*r114*r133*r134 + 3.6195420672e-05*r223*r224*r113*r114*r133*r134 - 5.874169102335999e-06*r221*r107*r111*r133*r134 + 3.256593804166667*r27*r102*r215*r133*r134 - 1.2316469125*r101*r102*r215*r133*r134 + 0.4926587649999999*r28*r99*r214*r133*r134 - 8.141484510416666*r104*r133*r134 - 0.007583281949333333*r217*r228*r106*r116*r131*r132 + 3.033312779733333e-05*r223*r224*r113*r114*r131*r132 - 0.61521965625*r101*r102*r215*r131*r132 + 0.2460878625*r28*r99*r214*r131*r132 + 0.3284180362916666*r28*r104*r109*r106*r116 + 0.345553650675*r102*r230*r106*r116 - 0.13593438005*r27*r99*r229*r106*r116 + 0.001296326904*r217*r228*r106*r116 - 0.0002627344290333333*r217*r102*r227*r113*r114 + 3.995614093333333e-05*r28*r102*r227*r113*r114 + 0.0014825654632*r99*r226*r113*r114 + 5.023810036266667e-05*r225*r224*r113*r114 - 5.185307616e-06*r223*r224*r113*r114 - 1.278596509866667e-07*r217*r99*r222*r107*r111 - 2.939536014404267e-05*r221*r107*r111 + 8.2672032256e-09*r217*r218*r219*r220 + 11.40684072265625*r28*r216*r97 + 3.177800089583333*r27*r102*r215 + 2.598612310416666*r101*r102*r215 - 1.039444924166667*r28*r99*r214 - 12.50723651302083*r104)*r24*r25*r93*r94*r96 + 0.01165900907612059*rhoc*r260*r10*r66*r89 + 0.003886336358706862*rhoc*r5*r179*(0.5365315849918411*r7*r8*r9*r11*sigmacc*(r265 + r261)*r64 - 1.073063169983682*r7*r8*r9*r260*r12*sigmacc*r57*r64 - 0.5365315849918411*r7*r8*r9*r11*sigmacc*r57*r180*((-0.5757322833877143*r58*r16*r59*r60*r264*r212*r53*r62) - 1.151464566775429*r58*r16*r59*r260*r211*r61*r62 + r265 + r261))*r89 + r259 + r258 + r93*r6*r14*r25*r97*r138);
   dE[2] += Factor*(r271 + r268 + 0.003886336358706862*rhoc*r5*(0.5365315849918411*r7*r8*r9*r11*r57*r64 + 0.2878661416938572*r58*r16*r59*r60*r55*sigmacc*r64 - 0.5365315849918411*r7*r8*r9*r11*sigmacc*(0.5757322833877143*r58*r16*r59*r60*r61*sigmacc + 0.5365315849918411*r7*r8*r9*r11*r55)*r57*r180)*r179*r89);
   dE[3] += Factor*((-1.0*((-0.596700342*r102*r120*r116*r127*r137) - 0.02537532196*r37*r99*r118*r116*r127*r137 + 0.026790567964*r235*r109*r116*r127*r137 + 0.001193400684*r235*r102*r232*r106*r114*r127*r137 - 0.0003113397247999999*r99*r115*r106*r114*r127*r137 - 0.00018943030496*r272*r112*r106*r114*r127*r137 - 0.000107162271856*r92*r112*r106*r114*r127*r137 + 1.43468975232e-06*r235*r99*r267*r113*r111*r127*r137 + 8.391076447232e-06*r105*r113*r111*r127*r137 + 7.464926140416002e-09*r235*r266*r107*r220*r127*r137 - 0.4926464151500001*r102*r120*r116*r135*r136 - 0.03143390933*r37*r99*r118*r116*r135*r136 + 0.01729125798*r235*r109*r116*r135*r136 + 0.0009852928303000002*r235*r102*r232*r106*r114*r135*r136 - 0.0001484858788799998*r99*r115*r106*r114*r135*r136 - 8.139122097599998e-05*r272*r112*r106*r114*r135*r136 - 6.916503192000002e-05*r92*r112*r106*r114*r135*r136 + 1.30285685632e-06*r235*r99*r267*r113*r111*r135*r136 - 1.1832662178816e-05*r105*r113*r111*r135*r136 + 3.408340064256001e-08*r235*r266*r107*r220*r135*r136 - 0.02939126332*r37*r99*r118*r116*r133*r134 + 0.027146565504*r235*r109*r116*r133*r134 + 0.00047026021312*r99*r115*r106*r114*r133*r134 - 6.8837919168e-05*r272*r112*r106*r114*r133*r134 - 0.000108586262016*r92*r112*r106*r114*r133*r134 + 4.405626826751999e-06*r105*r113*r111*r133*r134 + 0.022749845848*r235*r109*r116*r131*r132 - 9.0999383392e-05*r92*r112*r106*r114*r131*r132 - 0.39410164355*r102*r120*r116 + 0.05825759145*r37*r99*r118*r116 - 0.003888980712*r235*r109*r116 + 0.0007882032871*r235*r102*r232*r106*r114 - 0.00112391093968*r99*r115*r106*r114 - 0.000150714301088*r272*r112*r106*r114 + 1.5555922848e-05*r92*r112*r106*r114 + 3.8357895296e-07*r235*r99*r267*r113*r111 + 2.2046520108032e-05*r105*r113*r111 - 2.480160967680001e-08*r235*r266*r107*r220)*r24*r25*r93*r94*r96) - 1.0*r140*(0.02537532196*r37*r162*r146*r158*r167*r177 + 0.596700342*r160*r145*r158*r167*r177 - 0.026790567964*r235*r151*r158*r167*r177 + 0.0003113397247999999*r157*r146*r148*r156*r167*r177 - 0.001193400684*r235*r253*r145*r148*r156*r167*r177 + 0.00018943030496*r272*r154*r148*r156*r167*r177 + 0.000107162271856*r92*r154*r148*r156*r167*r177 - 1.43468975232e-06*r235*r270*r146*r155*r153*r167*r177 - 8.391076447232e-06*r147*r155*r153*r167*r177 - 7.464926140416002e-09*r235*r269*r149*r243*r167*r177 + 0.03143390933*r37*r162*r146*r158*r175*r176 + 0.4926464151500001*r160*r145*r158*r175*r176 - 0.01729125798*r235*r151*r158*r175*r176 + 0.0001484858788799998*r157*r146*r148*r156*r175*r176 - 0.0009852928303000002*r235*r253*r145*r148*r156*r175*r176 + 8.139122097599998e-05*r272*r154*r148*r156*r175*r176 + 6.916503192000002e-05*r92*r154*r148*r156*r175*r176 - 1.30285685632e-06*r235*r270*r146*r155*r153*r175*r176 + 1.1832662178816e-05*r147*r155*r153*r175*r176 - 3.408340064256001e-08*r235*r269*r149*r243*r175*r176 + 0.02939126332*r37*r162*r146*r158*r173*r174 - 0.027146565504*r235*r151*r158*r173*r174 - 0.00047026021312*r157*r146*r148*r156*r173*r174 + 6.8837919168e-05*r272*r154*r148*r156*r173*r174 + 0.000108586262016*r92*r154*r148*r156*r173*r174 - 4.405626826751999e-06*r147*r155*r153*r173*r174 - 0.022749845848*r235*r151*r158*r171*r172 + 9.0999383392e-05*r92*r154*r148*r156*r171*r172 - 0.05825759145*r37*r162*r146*r158 + 0.39410164355*r160*r145*r158 + 0.003888980712*r235*r151*r158 + 0.00112391093968*r157*r146*r148*r156 - 0.0007882032871*r235*r253*r145*r148*r156 + 0.000150714301088*r272*r154*r148*r156 - 1.5555922848e-05*r92*r154*r148*r156 - 3.8357895296e-07*r235*r270*r146*r155*r153 - 2.2046520108032e-05*r147*r155*r153 + 2.480160967680001e-08*r235*r269*r149*r243)*r24*r25*r93*r94);
   dE[4] += Factor*(r271 + r268);
   dE[5] += Factor*((-1.0*r24*r25*((-0.1790101026*r27*r121*r68*r102*r215*r106*r116*r137*r275) - 0.015225193176*r100*r121*r68*r99*r214*r106*r116*r137*r275 + 0.0321486815568*r121*r68*r276*r106*r116*r137*r275 - 0.000107601731424*r27*r121*r68*r99*r229*r113*r114*r137*r275 - 0.000113658182976*r235*r121*r68*r228*r113*r114*r137*r275 - 3.732463070208e-07*r27*r121*r68*r224*r107*r111*r137*r275 + 3.3794115515625*r27*r121*r68*r104*r108*r137*r275 + 8.72203384125*r28*r121*r68*r102*r117*r137*r275 - 5.5507279365*r121*r68*r99*r119*r137*r275 + 0.4932023418*r27*r121*r68*r122*r137*r275 - 0.147793924545*r37*r121*r68*r102*r215*r106*r116*r127*r136*r275 + 0.1790101026*r27*r121*r68*r102*r215*r106*r116*r127*r136*r275 - 0.018860345598*r235*r121*r68*r99*r214*r106*r116*r127*r136*r275 + 0.015225193176*r100*r121*r68*r99*r214*r106*r116*r127*r136*r275 + 0.0093503375952*r121*r68*r276*r106*r116*r127*r136*r275 - 9.771426422399999e-05*r37*r121*r68*r99*r229*r113*r114*r127*r136*r275 + 0.000107601731424*r27*r121*r68*r99*r229*r113*r114*r127*r136*r275 - 4.88347325856e-05*r277*r121*r68*r228*r113*r114*r127*r136*r275 + 0.000113658182976*r235*r121*r68*r228*r113*r114*r127*r136*r275 - 1.704170032128e-06*r37*r121*r68*r224*r107*r111*r127*r136*r275 + 3.732463070208e-07*r27*r121*r68*r224*r107*r111*r127*r136*r275 + 13.293923803125*r37*r121*r68*r104*r108*r127*r136*r275 - 3.3794115515625*r27*r121*r68*r104*r108*r127*r136*r275 - 4.28227748625*r100*r121*r68*r102*r117*r127*r136*r275 - 8.72203384125*r28*r121*r68*r102*r117*r127*r136*r275 + 2.9473530945*r121*r68*r99*r119*r127*r136*r275 + 0.6134442276000001*r37*r121*r68*r122*r127*r136*r275 - 0.4932023418*r27*r121*r68*r122*r127*r136*r275 + 0.147793924545*r37*r121*r68*r102*r215*r106*r116*r135*r134*r275 + 0.018860345598*r235*r121*r68*r99*r214*r106*r116*r135*r134*r275 - 0.052904273976*r100*r121*r68*r99*r214*r106*r116*r135*r134*r275 + 0.05622861666240001*r121*r68*r276*r106*r116*r135*r134*r275 + 9.771426422399999e-05*r37*r121*r68*r99*r229*r113*r114*r135*r134*r275 + 4.88347325856e-05*r277*r121*r68*r228*r113*r114*r135*r134*r275 - 0.0001239082545024*r235*r121*r68*r228*r113*r114*r135*r134*r275 + 1.704170032128e-06*r37*r121*r68*r224*r107*r111*r135*r134*r275 - 13.293923803125*r37*r121*r68*r104*r108*r135*r134*r275 + 4.28227748625*r100*r121*r68*r102*r117*r135*r134*r275 + 17.5856065425*r28*r121*r68*r102*r117*r135*r134*r275 + 5.263732173*r121*r68*r99*r119*r135*r134*r275 - 0.6134442276000001*r37*r121*r68*r122*r135*r134*r275 - 3.0410297748*r27*r121*r68*r122*r135*r134*r275 + 0.052904273976*r100*r121*r68*r99*r214*r106*r116*r133*r132*r275 + 0.01147162425599998*r121*r68*r276*r106*r116*r133*r132*r275 + 0.0001239082545024*r235*r121*r68*r228*r113*r114*r133*r132*r275 - 17.5856065425*r28*r121*r68*r102*r117*r133*r132*r275 - 0.8885247210000002*r121*r68*r99*r119*r133*r132*r275 + 0.003372192*r92*r121*r68*r122*r133*r132*r275 + 3.0410297748*r27*r121*r68*r122*r133*r132*r275 - 0.1091992600704*r121*r68*r276*r106*r116*r131*r130*r275 - 1.77183261*r121*r68*r99*r119*r131*r130*r275 - 0.003372192*r92*r121*r68*r122*r131*r130*r275 + 0.330881547*r27*r121*r68*r122*r131*r130*r275 - 0.330881547*r27*r121*r68*r122*r128*r231*r275)*r93*r94*r96) + r280 + 0.003886336358706862*rhoc*r5*r66*(0.7689358913000001*r67*r68*r69*r88*r273 - 0.6278705653000001*r67*r68*r69*r72*r87*r273 + 0.06000964210000001*r274*r68*r69*r86*r85*r273 - 0.141065326*r67*r68*r69*r86*r85*r273 - 0.06000964210000001*r274*r68*r69*r84*r83*r273 - 4.413330108*r67*r68*r69*r84*r83*r273 + 1.4823454395*r67*r68*r69*r82*r81*r273 - 1.782773093*r274*r68*r69*r80*r79*r273 + 2.9309846685*r67*r68*r69*r80*r79*r273 + 1.782773093*r274*r68*r69*r78*r77*r273 - 4.021709132*r67*r68*r69*r78*r77*r273 + 0.6178044623999996*r67*r68*r69*r76*r75*r273 + 3.4039046696*r67*r68*r69*r73*r213*r273) + rhoc*r90*(0.07569543640000001*r67*r68*r69*r88*r273 - 1.2111746552*r67*r68*r69*r72*r87*r273 + 0.5017104782*r274*r68*r69*r86*r85*r273 + 1.1354792188*r67*r68*r69*r86*r85*r273 - 0.5017104782*r274*r68*r69*r84*r83*r273 + 2.042616284*r67*r68*r69*r84*r83*r273 + 0.3634103834999998*r67*r68*r69*r82*r81*r273 - 0.6795280174*r274*r68*r69*r80*r79*r273 - 2.4060266675*r67*r68*r69*r80*r79*r273 + 0.6795280174*r274*r68*r69*r78*r77*r273 - 1.3860290619*r67*r68*r69*r78*r77*r273 - 6.712454618099999*r67*r68*r69*r76*r75*r273 + 8.09848368*r67*r68*r69*r73*r213*r273));
   dE[6] += Factor*(r280 - 1.0*r24*r25*(0.1790101026*r27*r121*r68*r102*r215*r106*r116*r137*r275 + 0.015225193176*r100*r121*r68*r99*r214*r106*r116*r137*r275 - 0.0321486815568*r121*r68*r276*r106*r116*r137*r275 + 0.000107601731424*r27*r121*r68*r99*r229*r113*r114*r137*r275 + 0.000113658182976*r235*r121*r68*r228*r113*r114*r137*r275 + 3.732463070208e-07*r27*r121*r68*r224*r107*r111*r137*r275 - 3.3794115515625*r27*r121*r68*r104*r108*r137*r275 - 8.72203384125*r28*r121*r68*r102*r117*r137*r275 + 5.5507279365*r121*r68*r99*r119*r137*r275 - 0.4932023418*r27*r121*r68*r122*r137*r275 + 0.147793924545*r37*r121*r68*r102*r215*r106*r116*r127*r136*r275 - 0.1790101026*r27*r121*r68*r102*r215*r106*r116*r127*r136*r275 + 0.018860345598*r235*r121*r68*r99*r214*r106*r116*r127*r136*r275 - 0.015225193176*r100*r121*r68*r99*r214*r106*r116*r127*r136*r275 - 0.0093503375952*r121*r68*r276*r106*r116*r127*r136*r275 + 9.771426422399999e-05*r37*r121*r68*r99*r229*r113*r114*r127*r136*r275 - 0.000107601731424*r27*r121*r68*r99*r229*r113*r114*r127*r136*r275 + 4.88347325856e-05*r277*r121*r68*r228*r113*r114*r127*r136*r275 - 0.000113658182976*r235*r121*r68*r228*r113*r114*r127*r136*r275 + 1.704170032128e-06*r37*r121*r68*r224*r107*r111*r127*r136*r275 - 3.732463070208e-07*r27*r121*r68*r224*r107*r111*r127*r136*r275 - 13.293923803125*r37*r121*r68*r104*r108*r127*r136*r275 + 3.3794115515625*r27*r121*r68*r104*r108*r127*r136*r275 + 4.28227748625*r100*r121*r68*r102*r117*r127*r136*r275 + 8.72203384125*r28*r121*r68*r102*r117*r127*r136*r275 - 2.9473530945*r121*r68*r99*r119*r127*r136*r275 - 0.6134442276000001*r37*r121*r68*r122*r127*r136*r275 + 0.4932023418*r27*r121*r68*r122*r127*r136*r275 - 0.147793924545*r37*r121*r68*r102*r215*r106*r116*r135*r134*r275 - 0.018860345598*r235*r121*r68*r99*r214*r106*r116*r135*r134*r275 + 0.052904273976*r100*r121*r68*r99*r214*r106*r116*r135*r134*r275 - 0.05622861666240001*r121*r68*r276*r106*r116*r135*r134*r275 - 9.771426422399999e-05*r37*r121*r68*r99*r229*r113*r114*r135*r134*r275 - 4.88347325856e-05*r277*r121*r68*r228*r113*r114*r135*r134*r275 + 0.0001239082545024*r235*r121*r68*r228*r113*r114*r135*r134*r275 - 1.704170032128e-06*r37*r121*r68*r224*r107*r111*r135*r134*r275 + 13.293923803125*r37*r121*r68*r104*r108*r135*r134*r275 - 4.28227748625*r100*r121*r68*r102*r117*r135*r134*r275 - 17.5856065425*r28*r121*r68*r102*r117*r135*r134*r275 - 5.263732173*r121*r68*r99*r119*r135*r134*r275 + 0.6134442276000001*r37*r121*r68*r122*r135*r134*r275 + 3.0410297748*r27*r121*r68*r122*r135*r134*r275 - 0.052904273976*r100*r121*r68*r99*r214*r106*r116*r133*r132*r275 - 0.01147162425599998*r121*r68*r276*r106*r116*r133*r132*r275 - 0.0001239082545024*r235*r121*r68*r228*r113*r114*r133*r132*r275 + 17.5856065425*r28*r121*r68*r102*r117*r133*r132*r275 + 0.8885247210000002*r121*r68*r99*r119*r133*r132*r275 - 0.003372192*r92*r121*r68*r122*r133*r132*r275 - 3.0410297748*r27*r121*r68*r122*r133*r132*r275 + 0.1091992600704*r121*r68*r276*r106*r116*r131*r130*r275 + 1.77183261*r121*r68*r99*r119*r131*r130*r275 + 0.003372192*r92*r121*r68*r122*r131*r130*r275 - 0.330881547*r27*r121*r68*r122*r131*r130*r275 + 0.330881547*r27*r121*r68*r122*r128*r231*r275)*r93*r94*r96);
   // suppress potential unused variable warnings.
   (void)rhoc; (void)rhoo; (void)sigmacc; (void)sigmaco; (void)sigmaoo; (void)tauc;
   (void)tauo; (void)Au; (void)Alpha1u; (void)Beta1u; (void)Beta2u; (void)Beta3u;
   (void)Beta4u; (void)Ap; (void)Alpha1p; (void)Beta1p; (void)Beta2p; (void)Beta3p;
   (void)Beta4p; (void)Aa; (void)Alpha1a; (void)Beta1a; (void)Beta2a; (void)Beta3a;
   (void)Beta4a;
}

/* kate: syntax c++; */

