/* IrBoysFn.inl v20200519 EST [mirage, Gerald Knizia] */
namespace ir {
   static unsigned const
      StepsPerT = 8, // first entry: T=0, other: equidistant entries at distance 1/StepsPerT.
      TableSize = 97, // number of tabulated points. Each point comes with one set of derivatives.
      TableOrder = 37, // tabulated are Fm(T) for m = 0..(TableOrder-1)
      TableMaxM = 28, // maximum m supported (inclusive). Differs from TableOrder because we still need some derivatives for Taylor expansion.
      TaylorOrder = 8;

   static double const
      TsPerStep = 1.25e-01,
      HalfSqrtPi = 8.86226925452758014e-1;

   // Denominators for downward recursion. It's just 1/(2*m+1).
   static double const Inv2mp1[37] = {
      1.0, 3.33333333333333333e-1, 2.0e-1, 1.42857142857142857e-1, 1.11111111111111111e-1, 9.09090909090909091e-2, 7.69230769230769231e-2, 6.66666666666666667e-2, 5.88235294117647059e-2, 5.26315789473684211e-2, 4.7619047619047619e-2, 4.34782608695652174e-2, 4.0e-2, 3.7037037037037037e-2, 3.44827586206896552e-2, 3.22580645161290323e-2, 3.0303030303030303e-2, 2.85714285714285714e-2, 2.7027027027027027e-2, 2.5641025641025641e-2, 2.43902439024390244e-2, 2.32558139534883721e-2, 2.22222222222222222e-2, 2.12765957446808511e-2, 2.04081632653061224e-2, 1.9607843137254902e-2, 1.88679245283018868e-2, 1.81818181818181818e-2, 1.7543859649122807e-2, 1.69491525423728814e-2, 1.63934426229508197e-2, 1.5873015873015873e-2, 1.53846153846153846e-2, 1.49253731343283582e-2, 1.44927536231884058e-2, 1.40845070422535211e-2, 1.36986301369863014e-2
   }; // 0.29 kb

   // This is a TableOrder x TableSize matrix of Fm(T) values. The values have full 1e-16 precision.
   static double const BoysData[3589] = {
      1.0, 3.33333333333333333e-1, 2.0e-1, 1.42857142857142857e-1, 1.11111111111111111e-1, 9.09090909090909091e-2, 7.69230769230769231e-2, 6.66666666666666667e-2, 5.88235294117647059e-2, 5.26315789473684211e-2, 4.7619047619047619e-2, 4.34782608695652174e-2, 4.0e-2, 3.7037037037037037e-2, 3.44827586206896552e-2, 3.22580645161290323e-2, 3.0303030303030303e-2, 2.85714285714285714e-2, 2.7027027027027027e-2, 2.5641025641025641e-2, 2.43902439024390244e-2, 2.32558139534883721e-2, 2.22222222222222222e-2, 2.12765957446808511e-2, 2.04081632653061224e-2, 1.9607843137254902e-2, 1.88679245283018868e-2, 1.81818181818181818e-2, 1.7543859649122807e-2, 1.69491525423728814e-2, 1.63934426229508197e-2, 1.5873015873015873e-2, 1.53846153846153846e-2, 1.49253731343283582e-2, 1.44927536231884058e-2, 1.40845070422535211e-2, 1.36986301369863014e-2,
      9.59850437919768433e-1, 3.09414141340692119e-1, 1.82982085749923814e-1, 1.29654104660094671e-1, 1.00327320144269185e-1, 8.17959148553090529e-2, 6.9032643295216718e-2, 5.97098410128877249e-2, 5.26028504348818833e-2, 4.70062192335864555e-2, 4.24850514141890037e-2, 3.87567084534946956e-2, 3.56295673831303811e-2, 3.29691279746565003e-2, 3.06782109245204257e-2, 2.86848569059877749e-2, 2.69346460041024768e-2, 2.53856622031453226e-2, 2.40050981019635486e-2, 2.27669087522235869e-2, 2.16501550084979501e-2, 2.06378110552822106e-2, 1.97158911701586111e-2, 1.88728002901683787e-2, 1.80988442132735889e-2, 1.73858554632418142e-2, 1.67269041629484767e-2, 1.61160722066954541e-2, 1.55482751346182804e-2, 1.50191203545863176e-2, 1.45247933439893482e-2, 1.40619655950193472e-2, 1.36277196064938804e-2, 1.32194873500273015e-2, 1.283499946893518e-2, 1.24722430877280725e-2, 1.21294265763909879e-2,
      9.22562012825584898e-1, 2.87522459508360059e-1, 1.67533190907350615e-1, 1.17730342930696411e-1, 9.06232348869400113e-2, 7.36166618221104664e-2, 6.19649939436205248e-2, 5.34882763913239095e-2, 4.70467255969075475e-2, 4.19871041520468785e-2, 3.79083916349716465e-2, 3.45508825259994157e-2, 3.17390300531633865e-2, 2.93499365153595886e-2, 2.72950056866080459e-2, 2.55087636804569266e-2, 2.39417820455197107e-2, 2.25560488614911719e-2, 2.13218541615722936e-2, 2.0215641813539989e-2, 1.92184953133094029e-2, 1.83150495485613015e-2, 1.74926950334621903e-2, 1.67409868687873918e-2, 1.60511995232050916e-2, 1.54159871312892428e-2, 1.48291212486930274e-2, 1.42852862186511719e-2, 1.37799179088191743e-2, 1.33090754625761338e-2, 1.2869338441174056e-2, 1.24577236804251e-2, 1.20716175907528631e-2, 1.1708720655062463e-2, 1.13670016355603109e-2, 1.10446595645131707e-2, 1.07400920180605098e-2,
      8.8789313823050627e-1, 2.67471812586045429e-1, 1.53501545289552118e-1, 1.06957930209051188e-1, 8.18883102298481525e-2, 6.62740177035482315e-2, 5.56332212640777975e-2, 4.79234635227188916e-2, 4.20835653997482341e-2, 3.75084440063303753e-2, 3.38282097724065772e-2, 3.08041685727545625e-2, 2.82754645098436531e-2, 2.61297786068255048e-2, 2.4286324791088573e-2, 2.26855202007952247e-2, 2.1282463244906355e-2, 2.00426777212500238e-2, 1.89392552703715125e-2, 1.79508882836983533e-2, 1.7060485697684773e-2, 1.62541797521379928e-2, 1.55206007346153236e-2, 1.48503390222898196e-2, 1.42355403421990955e-2, 1.36695973023779767e-2, 1.31469115070728173e-2, 1.26627081118494882e-2, 1.22128898143328694e-2, 1.17939208346684796e-2, 1.14027339392907935e-2, 1.10366553410216028e-2, 1.06933435911850374e-2, 1.03707395147403114e-2, 1.00670249288382196e-2, 9.78058839848660439e-3, 9.5099966687689513e-3,
      8.55624391892148803e-1, 2.4909373217951538e-1, 1.40750536825912715e-1, 9.72220244169301519e-2, 7.40235112058776398e-2, 5.96809411402653349e-2, 4.99596928302852604e-2, 4.29453470810749614e-2, 3.76495465034909974e-2, 3.35116308467135329e-2, 3.0190326374923702e-2, 2.74661941607643174e-2, 2.51918059849458768e-2, 2.32644899110134958e-2, 2.16105678847309638e-2, 2.01758089445645278e-2, 1.89194175688669391e-2, 1.7810120059975568e-2, 1.6823542386511456e-2, 1.59404085882904469e-2, 1.51452752306940054e-2, 1.44256247458207964e-2, 1.37712043576608199e-2, 1.31735363821034731e-2, 1.26255502462298103e-2, 1.2121302352627282e-2, 1.16557602713579603e-2, 1.12246346693384704e-2, 1.08242471009824472e-2, 1.04514250433660664e-2, 1.01034178459644965e-2, 9.77782889120086437e-3, 9.47256043302103181e-3, 9.18576843373364421e-3, 8.91582534752073822e-3, 8.66128926629751358e-3, 8.4208781944900403e-3,
      8.25556379233390381e-1, 2.32235960571520111e-1, 1.29157162556456073e-1, 8.84195074106320996e-2, 6.69400986843475641e-2, 5.37595677121102681e-2, 4.48750530513781655e-2, 3.84914089191407281e-2, 3.36877642144965432e-2, 2.99444505019607944e-2, 2.69465048146118817e-2, 2.44921380702874182e-2, 2.24461976780963018e-2, 2.07148107467338429e-2, 1.92307693142588136e-2, 1.79447052756122827e-2, 1.68195480199924163e-2, 1.58269249126075966e-2, 1.49447547378205112e-2, 1.41555974242949394e-2, 1.34454968228099164e-2, 1.2803152972973063e-2, 1.22193194550811746e-2, 1.16863575677300904e-2, 1.11979017314592044e-2, 1.07486050580086194e-2, 1.03339435515594767e-2, 9.95006377092961755e-3, 9.59366310571097856e-3, 9.26189480522842872e-3, 8.95229199158964202e-3, 8.66270637438233692e-3, 8.3912584536775874e-3, 8.13629677604235143e-3, 7.89636438067784311e-3, 7.67017099822474622e-3, 7.45656988397339179e-3,
      7.97507809614983568e-1, 2.16760837915979241e-1, 1.1861064067128201e-1, 8.04577670769302297e-2, 6.05585445316646006e-2, 4.84402320293111322e-2, 4.03173330542718314e-2, 3.45058513096794005e-2, 3.01474779361175336e-2, 2.67603814486555757e-2, 2.40537965222941535e-2, 2.18421161514416775e-2, 2.00014124947625842e-2, 1.84458397520332652e-2, 1.71140803759223027e-2, 1.5961185440488047e-2, 1.49534639427431662e-2, 1.40651715796731846e-2, 1.32763016983645025e-2, 1.25710733989812565e-2, 1.19368732128361965e-2, 1.13634993235128983e-2, 1.08426121133599467e-2, 1.03673282401219294e-2, 9.93191636314398384e-3, 9.53156603536033402e-3, 9.16221004157488539e-3, 8.8203863083028125e-3, 8.50312947709332024e-3, 8.20788496886969769e-3, 7.93244028153163756e-3, 7.67486962161012267e-3, 7.43348894694868091e-3, 7.20681920709970116e-3, 6.9935560897768471e-3, 6.7925449690584951e-3, 6.60276004142563008e-3,
      7.71313763751115105e-1, 2.02543853755775258e-1, 1.09011166622181356e-1, 7.32536076756562143e-2, 5.480756231490577e-2, 4.36605949460820155e-2, 3.62311569876535817e-2, 3.09388692348503766e-2, 2.69834393395698553e-2, 2.39179709109595071e-2, 2.14739586455555614e-2, 1.94806353589476493e-2, 1.78243391870214468e-2, 1.64265485697301522e-2, 1.52313095452604031e-2, 1.41976897908818789e-2, 1.32950650507599101e-2, 1.25000725694677889e-2, 1.17945830016366909e-2, 1.11643150754566632e-2, 1.05978675796008365e-2, 1.00860291915005116e-2, 9.6212774605791967e-3, 9.19740917003168504e-3, 8.80926360741759675e-3, 8.4525126199736217e-3, 8.12349939436931655e-3, 7.81911327032307116e-3, 7.53669153672029203e-3, 7.27394166545613896e-3, 7.0288791905164549e-3, 6.79977768171162653e-3, 6.5851281538994679e-3, 6.38360589997543479e-3, 6.19404321134041604e-3, 6.01540680227445952e-3, 5.84677901884469922e-3,
      7.46824132812427025e-1, 1.89472345820492352e-1, 1.00268798145017367e-1, 6.67322747768222568e-2, 4.96232411331567381e-2, 3.93648645134841608e-2, 3.25670342384417239e-2, 2.77460019641500443e-2, 2.41552941454041711e-2, 2.13802796502142938e-2, 1.91729360913146307e-2, 1.73761083730824617e-2, 1.58855257047271492e-2, 1.4629350723368204e-2, 1.3556514179749593e-2, 1.26297350206479381e-2, 1.18211722343218805e-2, 1.11096212805898677e-2, 1.04786518246015238e-2, 9.91533816940702972e-3, 9.40937371771591874e-3, 8.95244062745517334e-3, 8.53775290456506606e-3, 8.15971976699282546e-3, 7.81369393861023742e-3, 7.49578091022965594e-3, 7.20269262513506575e-3, 6.93163398035808159e-3, 6.68021387412608286e-3, 6.44637482687220083e-3, 6.22833680700876379e-3, 6.02455202804613487e-3, 5.83366829773208768e-3, 5.65449909057168867e-3, 5.48599894843040955e-3, 5.32724313512796872e-3, 5.17741071132172893e-3,
      7.2390221177734438e-1, 1.77444330852886511e-1, 9.23024556445821349e-2, 6.0826582606471531e-2, 4.49482715053115499e-2, 3.55031005286463195e-2, 2.92807282030043488e-2, 2.48875552358696911e-2, 2.16270494131980608e-2, 1.91143878515632458e-2, 1.71204008094897513e-2, 1.55004220626377993e-2, 1.41587733699198465e-2, 1.30297186176206363e-2, 1.20666379188477552e-2, 1.12355699058822977e-2, 1.05111998773339989e-2, 9.87427937496543717e-3, 9.30991589575136501e-3, 8.80640923753367801e-3, 8.35444129131720553e-3, 7.94650026029142086e-3, 7.57646392630282989e-3, 7.23929303345671783e-3, 6.93080231738489255e-3, 6.64748719711555774e-3, 6.3863909753527622e-3, 6.1450019268207409e-3, 5.92117271857378646e-3, 5.71305671126937702e-3, 5.51905715846378405e-3, 5.33778635908493221e-3, 5.168032561778222e-3, 5.00873295877097783e-3, 4.8589515019136822e-3, 4.71786056608637436e-3, 4.58472570390348867e-3,
      7.02423431396966873e-1, 1.66367453814710709e-1, 8.50390258335768107e-2, 5.54761329230775813e-2, 4.07312534405411875e-2, 3.20305936418722347e-2, 2.63326932801617928e-2, 2.23280863127652822e-2, 1.93665991325156532e-2, 1.70909553570304014e-2, 1.52893419693550108e-2, 1.38285537985060506e-2, 1.26207762021796257e-2, 1.16058432777202168e-2, 1.07411886553023009e-2, 9.99586965743065055e-3, 9.34686500806402671e-3, 8.77669936236911248e-3, 8.27187232909153461e-3, 7.82179172647867204e-3, 7.41803218899124364e-3, 7.05380915538035552e-3, 6.72359872846607476e-3, 6.42285836831330557e-3, 6.1478185802141046e-3, 5.89532542812041009e-3, 5.6627199895803257e-3, 5.44774503502686476e-3, 5.24847202651498455e-3, 5.06324346046560766e-3, 4.89062692291230056e-3, 4.72937817498409343e-3, 4.57841126552311442e-3, 4.43677415952493466e-3, 4.30362873119220884e-3, 4.17823423682892385e-3, 4.05993358186539733e-3,
      6.82274214753800196e-1, 1.56158043254201352e-1, 7.84125578028573013e-2, 5.06266157125600104e-2, 3.69260778847903982e-2, 2.89073109666789477e-2, 2.3687572664989799e-2, 2.00359450327712398e-2, 1.73453017042989526e-2, 1.52838302430311696e-2, 1.36557013864893617e-2, 1.23382302951018613e-2, 1.1250800357307757e-2, 1.03383320465263443e-2, 9.56195252780538869e-3, 8.89346454603992513e-3, 8.31192913545134584e-3, 7.80147842369015821e-3, 7.34987237251238524e-3, 6.94752071934973671e-3, 6.58680445450663771e-3, 6.26159521091842477e-3, 5.96690845990755904e-3, 5.69864905130679241e-3, 5.4534216751537329e-3, 5.22838773737688521e-3, 5.02115592780897023e-3, 4.82969758877416159e-3, 4.6522805737572398e-3, 4.4874170543331603e-3, 4.33382196396726546e-3, 4.19037963536607831e-3, 4.05611680847871121e-3, 3.93018063504354587e-3, 3.81182063388039842e-3, 3.70037379381855029e-3, 3.59525220231657919e-3,
      6.63350945840334806e-1, 1.46740261897301659e-1, 7.23635418478250493e-2, 4.62291830302318058e-2, 3.34913736877309372e-2, 2.6097401013716202e-2, 2.13137503341494644e-2, 1.7982864731837736e-2, 1.55376036097120705e-2, 1.36697004055584563e-2, 1.21980491857269472e-2, 1.10096242506120207e-2, 1.00303992052155488e-2, 9.2099399939862971e-3, 8.51273989640006429e-3, 7.91309894905734518e-3, 7.3919690907826239e-3, 6.93493994913225328e-3, 6.53091269039967864e-3, 6.17120313211942694e-3, 5.84892066807594057e-3, 5.55852908089457819e-3, 5.29553011001234443e-3, 5.05623160070855678e-3, 4.83757502829077991e-3, 4.63700541260612883e-3, 4.45237196482758051e-3, 4.28185132914397931e-3, 4.12388765149634441e-3, 3.97714532895393414e-3, 3.84047141995076182e-3, 3.71286548952221406e-3, 3.59345523048988566e-3, 3.48147661113757972e-3, 3.37625759926267068e-3, 3.27720473356481589e-3, 3.1837919782240331e-3,
      6.45559038877878271e-1, 1.38045342668825914e-1, 6.68382624007026745e-2, 4.22398882459444068e-2, 3.03900130822820916e-2, 2.3568751549644546e-2, 1.91829513359679864e-2, 1.61435975887353149e-2, 1.39207041928725147e-2, 1.22277834075811385e-2, 1.08972952430300249e-2, 9.82508458444199154e-3, 8.94316007322207858e-3, 8.20533126964858905e-3, 7.57915971579010897e-3, 7.0412174011443416e-3, 6.57417360962478139e-3, 6.16493966566884175e-3, 5.80345018283551112e-3, 5.48184048022149586e-3, 5.1938780075213195e-3, 4.93456095513232296e-3, 4.69982949738333451e-3, 4.48635451632492397e-3, 4.29138063479303895e-3, 4.11260796943534104e-3, 3.94810191907949021e-3, 3.79622354062120954e-3, 3.65557523999153066e-3, 3.52495799240713776e-3, 3.40333733779294703e-3, 3.28981612343868275e-3, 3.18361248382860398e-3, 3.08404192143544873e-3, 2.99050262522492773e-3, 2.90246336502337322e-3, 2.81945344998936878e-3,
      6.28812098255142717e-1, 1.3001090137277074e-1, 6.17882173336763124e-2, 3.86191837765532673e-2, 2.7588669424407927e-2, 2.12925946769217761e-2, 1.72698851416269743e-2, 1.44955895402015825e-2, 1.24742570435938887e-2, 1.0939550368757423e-2, 9.7364324445559745e-3, 8.76889653863723935e-3, 7.97447912520325097e-3, 7.31086705132461361e-3, 6.74841912437698307e-3, 6.26577461613925207e-3, 5.84716275710619644e-3, 5.48069358115981591e-3, 5.15723768289955151e-3, 4.86967166195379405e-3, 4.61235753307224038e-3, 4.38077583014763678e-3, 4.17126207025807277e-3, 3.9808142031908994e-3, 3.80694974272204144e-3, 3.64759826940997247e-3, 3.501019511275277e-3, 3.36574018489844414e-3, 3.24050477684837174e-3, 3.12423680854630357e-3, 3.0160080725105097e-3, 2.91501399219884717e-3, 2.82055373088064141e-3, 2.73201401622758999e-3, 2.64885589622954359e-3, 2.57060382554096594e-3, 2.49683661798955861e-3,
      6.13031160004197379e-1, 1.22580318175805044e-1, 5.71695967153297785e-2, 3.53314711284587811e-2, 2.50574216144754679e-2, 1.92431540494268661e-2, 1.55519273863378836e-2, 1.30186904473237397e-2, 1.11801039639807018e-2, 9.7884801447315915e-3, 8.70030824132580673e-3, 7.82706832611026079e-3, 7.11136124149534263e-3, 6.51441711798802733e-3, 6.0091454241995399e-3, 5.57606678849551837e-3, 5.20082762624869501e-3, 4.87262528567425917e-3, 4.58317817431216203e-3, 4.32603349456574181e-3, 4.09609051816945796e-3, 3.8892651733384835e-3, 3.7022494956336873e-3, 3.53233612228999072e-3, 3.37728824072029347e-3, 3.23524185343091111e-3, 3.10463138134613421e-3, 2.98413236437777332e-3, 2.87261685222641851e-3, 2.76911832852730453e-3, 2.67280387684866778e-3, 2.58295190475740565e-3, 2.49893417461015809e-3, 2.42020120126181676e-3, 2.34627030389686924e-3, 2.2767157663881371e-3, 2.21116068496780558e-3,
      5.98144006661304101e-1, 1.15702180856172852e-1, 5.29428148329764663e-2, 3.23446977320674099e-2, 2.27694002219647944e-2, 1.73973296902676144e-2, 1.40088358390827667e-2, 1.16948956678658188e-2, 1.00220379453436476e-2, 8.75984045855732916e-3, 7.77542136899414055e-3, 6.98714137806606493e-3, 6.34224211472670036e-3, 5.80519240788870427e-3, 5.35122794409558085e-3, 4.96258178553978818e-3, 4.62618802878018543e-3, 4.3322304282833568e-3, 4.07319543832619899e-3, 3.84323699536416771e-3, 3.63773989564746218e-3, 3.45301312123331438e-3, 3.28607024410495657e-3, 3.13446943702758845e-3, 2.99619507592099136e-3, 2.86956887087897119e-3, 2.75318229455370964e-3, 2.6458445936834798e-3, 2.54654235399467429e-3, 2.45440773527093567e-3, 2.36869328609312813e-3, 2.288751803767031e-3, 2.21402010017756523e-3, 2.14400581873226198e-3, 2.07827665461221526e-3, 2.01645148290754023e-3, 1.95819301245566617e-3,
      5.84084548193282104e-1, 1.0932978351213235e-1, 4.90720899458064544e-2, 2.96299956381912127e-2, 2.07004708707338519e-2, 1.57344163693847175e-2, 1.26224968932970057e-2, 1.05081156108568133e-2, 8.98559197556060741e-3, 7.84049301595546071e-3, 6.94974094974920837e-3, 6.23802157129735476e-3, 5.65683008779283326e-3, 5.17359621837675615e-3, 4.76567755987124658e-3, 4.41686611048153714e-3, 4.11526615487247844e-3, 3.85195643389933424e-3, 3.62011927523696012e-3, 3.4144576275406839e-3, 3.23079510761577742e-3, 3.06579556365347205e-3, 2.91676258126580707e-3, 2.7814936212333412e-3, 2.65817221911703962e-3, 2.54528716941537021e-3, 2.44157114669747364e-3, 2.34595353135211404e-3, 2.25752375474038922e-3, 2.1755025302311924e-3, 2.09921906280487856e-3, 2.02809283867717033e-3, 1.96161895763343837e-3, 1.8993562304597356e-3, 1.84091745272533348e-3, 1.78596140501844523e-3, 1.73418623284470428e-3,
      5.70792262416600707e-1, 1.03420675078830305e-1, 4.55250668165836838e-2, 2.71613576713453516e-2, 1.88289509194562498e-2, 1.42358519362759804e-2, 1.13766992749269883e-2, 9.44397022493033585e-3, 8.05785084713126687e-3, 7.01871996430382224e-3, 6.21254550220184128e-3, 5.56982910763874004e-3, 5.04596553640592983e-3, 4.61109196628531308e-3, 4.24450189507535921e-3, 3.93140675451579562e-3, 3.66097440625007278e-3, 3.42509574319734778e-3, 3.21758365556507458e-3, 3.0336379320096495e-3, 2.86947884144710975e-3, 2.72209065277048067e-3, 2.58903855717029603e-3, 2.46833566906644105e-3, 2.3583448631685317e-3, 2.25770527408749253e-3, 2.16527653702172944e-3, 2.08009597784162741e-3, 2.00134538209448245e-3, 1.92832493722692507e-3, 1.86043260767205386e-3, 1.79714766802909973e-3, 1.73801744977087693e-3, 1.68264659405392532e-3, 1.63068827549970212e-3, 1.58183698835891329e-3, 1.53582258035966823e-3,
      5.58211689005491232e-1, 9.79362525883847885e-2, 4.22724775904191324e-2, 2.49153471034594053e-2, 1.71353558975899685e-2, 1.28849923931886799e-2, 1.02569320240867352e-2, 8.48960570578190972e-3, 7.22728344759266508e-3, 6.28406934703406731e-3, 5.5542796595755352e-3, 4.97376497693110579e-3, 4.50149584394777821e-3, 4.11008566063809866e-3, 3.78059444769793201e-3, 3.49952626791085084e-3, 3.25701580938376616e-3, 3.04569105242122033e-3, 2.85993634191141575e-3, 2.69540114527555707e-3, 2.54866430633331347e-3, 2.41699944189523484e-3, 2.29820774543823401e-3, 2.19049670190674606e-3, 2.09239069030601645e-3, 2.00266412933290938e-3, 1.92029081796102979e-3, 1.84440508237286147e-3, 1.77427164628292511e-3, 1.7092620268343673e-3, 1.6488358679082493e-3, 1.59252604878730966e-3, 1.53992670798674141e-3, 1.49068353862625367e-3, 1.44448586890431768e-3, 1.40106015657567011e-3, 1.36016461183349287e-3,
      5.46291971785147992e-1, 9.28413946322498393e-2, 3.92878370545701446e-2, 2.28708373297903855e-2, 1.56021725369267807e-2, 1.16669108416884462e-2, 9.25020412693482264e-3, 7.63353100525077982e-3, 6.48359329097258044e-3, 5.62721746452701445e-3, 4.96642664042289586e-3, 4.44199216499640357e-3, 4.0161642342036974e-3, 3.66382144623872798e-3, 3.36763608490937204e-3, 3.11528956769459881e-3, 2.89779559492675356e-3, 2.70845120173681446e-3, 2.54215868737794218e-3, 2.39497456181701306e-3, 2.26380185739294287e-3, 2.14617550584237252e-3, 2.04010962546464465e-3, 1.94398690440204278e-3, 1.85647717659944311e-3, 1.77647660589478346e-3, 1.7030616553470323e-3, 1.63545382189878335e-3, 1.57299231610685781e-3, 1.51511267883842001e-3, 1.46132988551359714e-3, 1.41122487848612608e-3, 1.36443374414542962e-3, 1.32063894911082601e-3, 1.2795621933053095e-3, 1.24095854283351207e-3, 1.20461158345611242e-3,
      5.34986444543833149e-1, 8.81041309542060354e-2, 3.6547168729212694e-2, 2.10087784022499062e-2, 1.42136555774281677e-2, 1.05682177452575327e-2, 8.34488345972978981e-3, 6.86547198899729616e-3, 5.81758529537294851e-3, 5.03984628325498323e-3, 4.44139473287489877e-3, 3.96752997259455457e-3, 3.58351092103300809e-3, 3.26628876029975989e-3, 3.00000752263658176e-3, 2.77342116613512537e-3, 2.57834268874998548e-3, 2.40867651323772536e-3, 2.25979446267979519e-3, 2.12812153998113511e-3, 2.01085390952624888e-3, 1.90576252501423643e-3, 1.81105362692584833e-3, 1.72526784331651664e-3, 1.6472060193571084e-3, 1.57587388842797124e-3, 1.51044024296668012e-3, 1.45020492247287308e-3, 1.39457403842982037e-3, 1.34304060119015201e-3, 1.29516922589857259e-3, 1.25058395153551721e-3, 1.20895845952116599e-3, 1.17000815897606225e-3, 1.133483736598992e-3, 1.09916586496742571e-3, 1.06686083398776436e-3,
      5.24252256079918041e-1, 8.36953445224019033e-2, 3.40287586109996613e-2, 1.93119876087801334e-2, 1.29556458281369748e-2, 9.57690022664094552e-3, 7.53055296115324147e-3, 6.17624132514264843e-3, 5.22104703098766432e-3, 4.51453424001504013e-3, 3.9724162461051254e-3, 3.54415999300001105e-3, 3.19778520587139661e-3, 2.91213980728678956e-3, 2.67271156182468096e-3, 2.46923165203785005e-3, 2.29424000117559613e-3, 2.14219251492492721e-3, 2.00888669375725086e-3, 1.8910811749655835e-3, 1.78623720308185163e-3, 1.6923389308451535e-3, 1.60776596720618691e-3, 1.53120133046742511e-3, 1.46156387732025591e-3, 1.39795796036090308e-3, 1.33963541303608811e-3, 1.28596648803729039e-3, 1.2364173882442543e-3, 1.19053271331180407e-3, 1.14792161430706677e-3, 1.10824677564063636e-3, 1.07121557430045786e-3, 1.03657293142221604e-3, 1.00409549065107304e-3, 9.73586845130266774e-4, 9.44873599552976046e-4,
      5.14050030632400998e-1, 7.95885028049780261e-2, 3.17129337236794313e-2, 1.7764961585151271e-2, 1.18154072334402693e-2, 8.68217836472783926e-3, 6.79788217534415366e-3, 5.55762239577333031e-3, 4.68664285788219241e-3, 4.04465897047303002e-3, 3.55345755394960384e-3, 3.16634245724597082e-3, 2.85386730658782272e-3, 2.59661620189882081e-3, 2.38130399086796759e-3, 2.19855238806847162e-3, 2.04156252632091685e-3, 1.90529110692398398e-3, 1.78592160670645059e-3, 1.6805147729324041e-3, 1.58677158966720205e-3, 1.50286881262224966e-3, 1.42734251112684993e-3, 1.35900408642276496e-3, 1.29687870575523563e-3, 1.24015949186594744e-3, 1.18817297067582108e-3, 1.1403526855723772e-3, 1.0962188178614605e-3, 1.05536228075233045e-3, 1.01743218445393886e-3, 9.82125869202247381e-4, 9.49180914080736813e-4, 9.18368680255746874e-4, 8.89489056236120394e-4, 8.62366152437384159e-4, 8.36844751178595992e-4,
      5.04343560231438807e-1, 7.57594153105958107e-2, 2.95818629273205815e-2, 1.63537077114564941e-2, 1.07814809353885859e-2, 7.87437667510555509e-3, 6.13851250971619383e-3, 5.00226570974109614e-3, 4.20781954637541653e-3, 3.62431065341968967e-3, 3.17913900785169345e-3, 2.82914179950360326e-3, 2.54719883678648866e-3, 2.31548375863304557e-3, 2.12183218587138124e-3, 1.95767750373435218e-3, 1.81682237465016242e-3, 1.69467833259856947e-3, 1.58777887884766473e-3, 1.49345835824994201e-3, 1.40963460064729926e-3, 1.3346583764458878e-3, 1.2672069698848721e-3, 1.20620754615921691e-3, 1.15078105026987534e-3, 1.10020051589332474e-3, 1.0538596571159365e-3, 1.01124890988011527e-3, 9.71936945923732771e-4, 9.35556258298137493e-4, 9.01791811954361516e-4, 8.70372026892018253e-4, 8.41061554388867824e-4, 8.13655444568744265e-4, 7.87974403040320468e-4, 7.6386090698636155e-4, 7.41176004694621182e-4,
      4.95099525853565627e-1, 7.21860147568253136e-2, 2.76193777035309637e-2, 1.50655927830795842e-2, 9.84355453730394756e-3, 7.14480915397249771e-3, 5.54495473124640919e-3, 4.50359646124734435e-3, 3.77872212724843967e-3, 3.24821480637056912e-3, 2.84466363162134335e-3, 2.52816042250252687e-3, 2.27372097506411211e-3, 2.06497452051126165e-3, 1.89078054886346356e-3, 1.74331236698128413e-3, 1.61691996048198253e-3, 1.50742801159968098e-3, 1.41168748521302671e-3, 1.32728053271593132e-3, 1.25232114440222469e-3, 1.1853173275334072e-3, 1.12507383368465474e-3, 1.07062222278432737e-3, 1.02116973559295504e-3, 9.76061347303580707e-4, 9.34751214252031794e-4, 8.96780917112042838e-4, 8.61762690840790202e-4, 8.29366360722819867e-4, 7.99309065478232771e-4, 7.71347099322365073e-4, 7.45269381424253165e-4, 7.20892187067046143e-4, 6.98054865613547885e-4, 6.7661633662838188e-4, 6.56452204353231387e-4,
      4.86287244578707493e-1, 6.88481594995362282e-2, 2.58108108718287192e-2, 1.38892071580648594e-2, 8.99234496534338552e-3, 6.48567643944130151e-3, 5.0104973849434318e-3, 4.05573202654501593e-3, 3.39411885637741985e-3, 2.91166349641448117e-3, 2.5457536307927896e-3, 2.2594797561425495e-3, 2.02981947070101979e-3, 1.84173522089284381e-3, 1.68502202036688814e-3, 1.55252780906426864e-3, 1.43910065373389508e-3, 1.34094057561485042e-3, 1.25518650996888534e-3, 1.17964508263488427e-3, 1.11260775246745797e-3, 1.05272461837596414e-3, 9.98915501299145883e-4, 9.50306111806085363e-4, 9.06181449717538797e-4, 8.65951262221137105e-4, 8.29124083316304992e-4, 7.95287474468023795e-4, 7.64092809849122901e-4, 7.35243435335076223e-4, 7.0848536200730573e-4, 6.83599884726713791e-4, 6.60397677855532146e-4, 6.38714035213473782e-4, 6.18405004243189769e-4, 5.99344224778166799e-4, 5.81420327311974281e-4,
      4.77878440226551531e-1, 6.57274550985015551e-2, 2.41428514050131304e-2, 1.28142427723554989e-2, 8.21949349552925297e-3, 5.88997379971810993e-3, 4.52912496077528512e-3, 3.65340832272780324e-3, 3.04933430062977983e-3, 2.61045404430225518e-3, 2.2785938563076761e-3, 2.01960780308076494e-3, 1.81227572728763835e-3, 1.64278146229998874e-3, 1.50177498821239426e-3, 1.3827194587397628e-3, 1.28091628285431289e-3, 1.19290652185574676e-3, 1.11609036344964472e-3, 1.04847779792160293e-3, 9.88520860337256251e-4, 9.34998068468366163e-4, 8.86933130736845974e-4, 8.4353667725807913e-4, 8.04163780661286578e-4, 7.68282509738815943e-4, 7.35450323705715315e-4, 7.05296125146203998e-4, 6.77506455018545951e-4, 6.51814759169049553e-4, 6.27992959897465027e-4, 6.05844776604345471e-4, 5.852003873196637e-4, 5.65912128016608266e-4, 5.47851002288402829e-4, 5.30903829071668218e-4, 5.14970896655171669e-4,
      4.69847035201623517e-1, 6.2807093111329288e-2, 2.26034137016670519e-2, 1.18313835837166798e-2, 7.51747166624260828e-3, 5.35140879626642483e-3, 4.09544476237316748e-3, 3.29191406979038236e-3, 2.74018966064817637e-3, 2.34083440124292823e-3, 2.03978145732816222e-3, 1.80543245451041514e-3, 1.61822329020300678e-3, 1.46545697610809552e-3, 1.33856499037143976e-3, 1.23157161406475035e-3, 1.14019094481268001e-3, 1.06127396521427707e-3, 9.92457908597313801e-4, 9.31937027968872844e-4, 8.7830866692393431e-4, 8.30467417366115141e-4, 7.87530789203492902e-4, 7.48786013119811408e-4, 7.13651313473233632e-4, 6.81647276838563892e-4, 6.52375385206893965e-4, 6.25501713378125633e-4, 6.00744401925487011e-4, 5.77863926776322698e-4, 5.56655465354934066e-4, 5.36942852047496751e-4, 5.18573750953399228e-4, 5.01415769950349869e-4, 4.85353309193562928e-4, 4.70284987433905899e-4, 4.56121526498402583e-4,
      4.62168961502541631e-1, 6.00717054022325717e-2, 2.11815198441851351e-2, 1.09322071564924399e-2, 6.8794969322884956e-3, 4.86432759368841025e-3, 3.70462154402993471e-3, 2.96703210152188486e-3, 2.46294954296176369e-3, 2.09945446813717195e-3, 1.8262810425173491e-3, 1.6141799388288062e-3, 1.44510913885614572e-3, 1.30739739793767682e-3, 1.19319067696024661e-3, 1.09702514420574699e-3, 1.01499063917554079e-3, 9.44219828474118607e-4, 8.8256505658464347e-4, 8.28387552727768593e-4, 7.80416168279653661e-4, 7.37650422497974345e-4, 6.9929252842171183e-4, 6.64698819671937414e-4, 6.33344439755251364e-4, 6.04797270572666309e-4, 5.78698408669033883e-4, 5.54747354910801338e-4, 5.32690646032908619e-4, 5.12313032761421409e-4, 4.93430565043914076e-4, 4.75885121561830697e-4, 4.59540044419289355e-4, 4.4427662771011338e-4, 4.29991271754773847e-4, 4.16593160651573708e-4, 4.04002354469827196e-4,
      4.54821989054011398e-1, 5.75072324264003053e-2, 1.9867193523092241e-2, 1.01090962345936129e-2, 6.2994570381528243e-3, 4.42364899831550806e-3, 3.35231908339486406e-3, 2.67498696374988327e-3, 2.21427448003188544e-3, 1.88332270727105923e-3, 1.63538474428546895e-3, 1.44337783653143195e-3, 1.29065925122851022e-3, 1.16649805662715296e-3, 1.06369355638986956e-3, 9.77248970572947857e-4, 9.03596297566970045e-4, 8.401242618267871e-4, 7.84880441057125368e-4, 7.36377395080604049e-4, 6.93463006951259956e-4, 6.55231657199006664e-4, 6.20962053806423773e-4, 5.90072875370661541e-4, 5.6209057152159789e-4, 5.36625619806558451e-4, 5.13354767216716365e-4, 4.9200757419691455e-4, 4.72356096642825602e-4, 4.54206887017593477e-4, 4.37394730403854251e-4, 4.21777693150133479e-4, 4.07233174993240123e-4, 3.93654735806866638e-4, 3.80949525740127531e-4, 3.69036189341292184e-4, 3.57843144963018244e-4,
      4.47785569702590018e-1, 5.5100804106953584e-2, 1.8651364444794969e-2, 9.35515927100323907e-3, 5.77184219655779759e-3, 4.0248054058477982e-3, 3.03464794717755329e-3, 2.41239812123980007e-3, 1.99117857353513018e-3, 1.6897674679222543e-3, 1.46467664733201155e-3, 1.29082215745451617e-3, 1.15284796745214575e-3, 1.04088533065856795e-3, 9.48331103752463552e-4, 8.70614727112477522e-4, 8.04479827972523995e-4, 7.47547928954006401e-4, 6.98043824476191202e-4, 6.54617242828300934e-4, 6.16223818916644416e-4, 5.82043703468732755e-4, 5.51424693607195643e-4, 5.23841721112782156e-4, 4.9886748627109924e-4, 4.76150832720531683e-4, 4.55400592909338529e-4, 4.3637336135421933e-4, 4.18864129133202699e-4, 4.02699030566814404e-4, 3.87729668353846146e-4, 3.73828631727080349e-4, 3.60885925820170291e-4, 3.48806103820816346e-4, 3.3750594610257458e-4, 3.2691256869392307e-4, 3.16961871428231706e-4,
      4.4104069538121084e-1, 5.28406320615595825e-2, 1.75257821619930709e-2, 8.66415899015389677e-3, 5.29168425529288713e-3, 3.66368992611272549e-3, 2.74811878731322501e-3, 2.17623816829221811e-3, 1.79099170445613641e-3, 1.51640251087751734e-3, 1.31200110224233115e-3, 1.15454803229434674e-3, 1.02987073175447435e-3, 9.28891175640959799e-4, 8.45552856696466786e-4, 7.75674244432919562e-4, 7.16282836085790765e-4, 6.65211837762114368e-4, 6.20846929117477821e-4, 5.81962186076562388e-4, 5.47610796031469103e-4, 5.17050468569506615e-4, 4.89691407469325521e-4, 4.65059305923183517e-4, 4.42768561206930625e-4, 4.22502576300677542e-4, 4.03999062825046796e-4, 3.87038930124162488e-4, 3.71437783511844566e-4, 3.57039346430119994e-4, 3.43710318830362417e-4, 3.31336319989740891e-4, 3.19818658827436978e-4, 3.09071741881152908e-4, 2.99020977162883069e-4, 2.89601066938093938e-4, 2.8075460798381116e-4,
      4.34569769094829996e-1, 5.07159120614138329e-2, 1.64829383752818938e-2, 8.03044815615073863e-3, 4.85450212180476307e-3, 3.3366090312820597e-3, 2.48960057647718564e-3, 1.96379550376212585e-3, 1.61132581433527426e-3, 1.36109627339803482e-3, 1.17543449774506503e-3, 1.03280361993702916e-3, 9.2011983883464189e-4, 8.29030470630323895e-4, 7.53979165921560007e-4, 6.91139542249620011e-4, 6.37797723826950939e-4, 5.91979430075576471e-4, 5.52216419936885016e-4, 5.17395509030166118e-4, 4.86658213819467092e-4, 4.59332385264518263e-4, 4.34884603419201235e-4, 4.12886371599779451e-4, 3.92989682063485949e-4, 3.74909070659992288e-4, 3.58408244302270495e-4, 3.43289983012661954e-4, 3.29388421518852409e-4, 3.16563083443480267e-4, 3.0469422242417705e-4, 2.93679149055627264e-4, 2.83429309374380912e-4, 2.73867941959864746e-4, 2.64928184623643982e-4, 2.56551533438249654e-4, 2.48686580115133376e-4,
      4.28356487512046961e-1, 4.87167357180056124e-2, 1.55159968523550096e-2, 7.44891180620891681e-3, 4.45625279228978381e-3, 3.04024014371868224e-3, 2.25628325551838228e-3, 1.77264098973408404e-3, 1.45004481611905946e-3, 1.22194446647350064e-3, 1.0532601122349714e-3, 9.24026876227664025e-4, 8.22162852263178507e-4, 7.39980870303553811e-4, 6.7238230461137619e-4, 6.15865049968312264e-4, 5.67950898825697047e-4, 5.26840676735146737e-4, 4.91198797262456534e-4, 4.60014304671957233e-4, 4.3250870273024433e-4, 4.08073282698913204e-4, 3.86225558476942649e-4, 3.66578379113313405e-4, 3.48817636391349973e-4, 3.3268591460904628e-4, 3.17970321889659414e-4, 3.04493311900316902e-4, 2.92105675943314625e-4, 2.80681131737609219e-4, 2.70112101590551607e-4, 2.60306386826399149e-4, 2.51184524831046012e-4, 2.42677671178674762e-4, 2.34725889408465154e-4, 2.2727676002174592e-4, 2.20284241475847653e-4,
      4.22385734066689853e-1, 4.68340104942006691e-2, 1.46187301988763439e-2, 6.91491528593688242e-3, 4.09328740104276328e-3, 2.77159364193724243e-3, 2.04564432215721925e-3, 1.60059816521255451e-3, 1.30523774122906508e-3, 1.09724564096686949e-3, 9.4394570696417394e-4, 8.26824869007274798e-4, 7.34723399398093953e-4, 6.60564884859240063e-4, 5.99669674144626678e-4, 5.48831806601162901e-4, 5.05787858537377333e-4, 4.6889795306279471e-4, 4.36946984544436179e-4, 4.09016706938301755e-4, 3.84401066075402306e-4, 3.62548739046571005e-4, 3.43023261322120563e-4, 3.25474801949877381e-4, 3.09619822766884417e-4, 2.95226179787810075e-4, 2.82102048770778921e-4, 2.70087581990546807e-4, 2.59048544805265843e-4, 2.48871407024703406e-4, 2.3945951680268602e-4, 2.30730089431982741e-4, 2.22611816203533074e-4, 2.15042949805217316e-4, 2.07969759373207078e-4, 2.01345274779118869e-4, 1.95128259072393303e-4,
      4.16643481580515841e-1, 4.50593872269192816e-2, 1.37854627936128376e-2, 6.42425749220243128e-3, 3.76231176746385694e-3, 2.52797881877026733e-3, 1.8554189409145149e-3, 1.44571663262737636e-3, 1.17519477235203765e-3, 9.85479399082481515e-4, 8.46123560480538031e-4, 7.39955359094332462e-4, 6.56664080103037793e-4, 5.8973394048151537e-4, 5.34868872750956498e-4, 4.89133419059492439e-4, 4.50459939177995457e-4, 4.17353494959060397e-4, 3.88708420591645267e-4, 3.63690558183174264e-4, 3.41659470100165535e-4, 3.22115748429386713e-4, 3.04664516024591353e-4, 2.88989631429367153e-4, 2.74835126548661077e-4, 2.61991629182454032e-4, 2.50286283340316572e-4, 2.3957516431049687e-4, 2.29737499870557931e-4, 2.20671217153277287e-4, 2.12289474866783714e-4, 2.0451793651461112e-4, 1.97292606908688226e-4, 1.9055810120249202e-4, 1.84266249147184318e-4, 1.78374961434823494e-4, 1.72847302625573505e-4,
      4.11116703514585094e-1, 4.33851944301365693e-2, 1.30110192707662573e-2, 5.97312879113615762e-3, 3.46035097320338108e-3, 2.30697337546038934e-3, 1.68357319937756264e-3, 1.30624827633367417e-3, 1.05838584964143613e-3, 8.8528696303595523e-4, 7.58572676957980655e-4, 6.62310397869812481e-4, 5.86971255695552296e-4, 5.26554200709943686e-4, 4.77114419821259589e-4, 4.35963582594021595e-4, 4.01212543199226069e-4, 3.71498258351635887e-4, 3.45814487187613808e-4, 3.23403350283230549e-4, 3.03683851375585202e-4, 2.86203553575909725e-4, 2.70605164101869172e-4, 2.56602956622949668e-4, 2.43965829779114172e-4, 2.32504932254569307e-4, 2.22064487476887175e-4, 2.12514897346291022e-4, 2.03747493862073284e-4, 1.95670498845010691e-4, 1.88205880652302967e-4, 1.81286884753367857e-4, 1.74856076069226668e-4, 1.68863773911124876e-4, 1.63266790943085227e-4, 1.58027409648762415e-4, 1.53112545863816554e-4,
      4.0579329304362376e-1, 4.18043787200529606e-2, 1.22906779954777103e-2, 5.55807313413346497e-3, 3.18471755113827585e-3, 2.10639607969724721e-3, 1.52828017616306159e-3, 1.180626009157807e-3, 9.53441572025944304e-4, 7.95453844349517789e-4, 6.80202930475810928e-4, 5.92901719670673191e-4, 5.24741510453142023e-4, 4.70193953495570147e-4, 4.25635951711553662e-4, 3.88604989106781267e-4, 3.57374679914693167e-4, 3.30702024638341089e-4, 3.0767112202329515e-4, 2.87593295972766988e-4, 2.69941404191292458e-4, 2.54305512497090167e-4, 2.40362298342551894e-4, 2.27853497083600113e-4, 2.16570437874586433e-4, 2.06342763445694848e-4, 1.97030077116821377e-4, 1.88515672007463029e-4, 1.8070176392524552e-4, 1.73505825328248469e-4, 1.6685773592063426e-4, 1.60697546109269018e-4, 1.54973705448769892e-4, 1.49641647478885134e-4, 1.44662650312070504e-4, 1.40002912464445324e-4, 1.35632798089998301e-4,
      4.00661989225783272e-1, 4.03104507699408523e-2, 1.16201290349705226e-2, 5.1759539442043745e-3, 2.93298291185340101e-3, 1.92428225516109205e-3, 1.38789852183713343e-3, 1.06744477589977158e-3, 8.59136145603755083e-4, 7.14894385272192284e-4, 6.10040933467865822e-4, 5.30847731688740576e-4, 4.69169601023699653e-4, 4.1991239043410561e-4, 3.79747725421629726e-4, 3.46419468550492349e-4, 3.18349672431312943e-4, 2.94404612448550307e-4, 2.73750483778389651e-4, 2.55761403173380045e-4, 2.39959026143780524e-4, 2.25971882362568189e-4, 2.13507356177484153e-4, 2.02331980423264129e-4, 1.92257319080354096e-4, 1.83129683700245034e-4, 1.74822528190003602e-4, 1.67230746175408128e-4, 1.60266340593588244e-4, 1.53855096920468542e-4, 1.47933999943352038e-4, 1.42449207967642326e-4, 1.37354449548872295e-4, 1.32609743776075642e-4, 1.28180370680728858e-4, 1.2403603672926457e-4, 1.20150193735161318e-4,
      3.95712309610513542e-1, 3.88974362611428075e-2, 1.09954361784342955e-2, 4.82392338930860106e-3, 2.70295167260747403e-3, 1.75886180543817992e-3, 1.2609532860734512e-3, 9.65444571986939852e-4, 7.74372158071863069e-4, 6.42637968813620508e-4, 5.47217440837332255e-4, 4.75361925849851025e-4, 4.19537729546110648e-4, 3.7504962395672991e-4, 3.38839284774624049e-4, 3.08839225937863031e-4, 2.83606900498828687e-4, 2.62108071737587959e-4, 2.43583551173011146e-4, 2.2746443943159453e-4, 2.13316613874671955e-4, 2.00803416977608308e-4, 1.89659993095169013e-4, 1.79675269019713849e-4, 1.70679064484108382e-4, 1.62532716063584363e-4, 1.55122152015733543e-4, 1.48352705774841069e-4, 1.42145181853079168e-4, 1.36432836654004545e-4, 1.31159036350080107e-4, 1.2627542182694194e-4, 1.21740457601187513e-4, 1.17518274499172126e-4, 1.13577739235906533e-4, 1.0989170081920837e-4, 1.06436375907832716e-4,
      3.90934488690588237e-1, 3.75598313496698676e-2, 1.04130026041500008e-2, 4.49939469895394241e-3, 2.49263858889809781e-3, 1.60853950669373521e-3, 1.14611875289356028e-3, 8.73495261575042856e-4, 6.98166982161321801e-4, 5.77816716123939144e-4, 4.90956121939780424e-4, 4.25742556513492149e-4, 3.75205994472021955e-4, 3.35017805397897999e-4, 3.02367159928892837e-4, 2.75359051850321746e-4, 2.5267446350125656e-4, 2.33369750153109473e-4, 2.16753551110901186e-4, 2.02308686305487756e-4, 1.89641113116285667e-4, 1.7844568598006029e-4, 1.68482647870292496e-4, 1.59561150994250529e-4, 1.51527486854407853e-4, 1.44256536526233213e-4, 1.37645464035687753e-4, 1.31608998772620147e-4, 1.26075861075318408e-4, 1.20986021933761449e-4, 1.16288579279983525e-4, 1.1194009557140494e-4, 1.07903284344040665e-4, 1.04145963501516961e-4, 1.00640214451662636e-4, 9.73617015309880484e-5, 9.4289117290542151e-5,
      3.86319421661361469e-1, 3.62925622154457223e-2, 9.86953983306245549e-3, 4.20001721582198983e-3, 2.30024782014976614e-3, 1.47187733163490581e-3, 1.04220307131453139e-3, 7.90583002657859415e-4, 6.29640632446333995e-4, 5.19654509752980346e-4, 4.40563551059546885e-4, 3.81363445054200029e-4, 3.35603889244306324e-4, 2.99293222088216554e-4, 2.69847485447663112e-4, 2.4552939798103295e-4, 2.25132660783870208e-4, 2.07796133970126912e-4, 1.92890122835529301e-4, 1.79944394831733318e-4, 1.68601238024401442e-4, 1.58584034268483319e-4, 1.4967572136794271e-4, 1.41703720226289301e-4, 1.34529185852782177e-4, 1.2803921024808975e-4, 1.22141078425827903e-4, 1.16757976894047105e-4, 1.11825745713448237e-4, 1.07290391093825263e-4, 1.03106159557552973e-4, 9.92340317932711517e-5, 9.56405336947331694e-5, 9.22967896167877842e-5, 8.91777623946092633e-5, 8.62616386711099898e-5, 8.35293282349928568e-5,
      3.81858613001733449e-1, 3.50909483040186235e-2, 9.36203964451373251e-3, 3.92365390595678292e-3, 2.12415428913155669e-3, 1.34757859243262922e-3, 9.48134491462853516e-4, 7.15798107486869732e-4, 5.68004918955330222e-4, 4.67457198949522574e-4, 3.95420283396063518e-4, 3.41665787700845375e-4, 3.00222733356855585e-4, 2.67409265152385445e-4, 2.4084943493778241e-4, 2.18950221363948261e-4, 2.00608198023176745e-4, 1.85037376858752231e-4, 1.71664135490519254e-4, 1.60060863220089891e-4, 1.49902784376768338e-4, 1.40939109387372631e-4, 1.32973299546397864e-4, 1.25849278702758862e-4, 1.19441615395015853e-4, 1.13648411239305184e-4, 1.0838606880663426e-4, 1.03585387276127412e-4, 9.91886108515127041e-5, 9.51471706979514458e-5, 9.14199383856641124e-5, 8.79718612085827686e-5, 8.47728858239505422e-5, 8.17971018626548046e-5, 7.90220550013605409e-5, 7.64281917730819746e-5, 7.39984076609836377e-5,
      3.77544129437629076e-1, 3.39506689090150008e-2, 8.88774866259826686e-3, 3.66836107950247884e-3, 1.9628869198230259e-3, 1.23447371272210601e-3, 8.6294903649809992e-4, 6.48324185091930179e-4, 5.12553757992262336e-4, 4.20603858854944793e-4, 3.54972898161807642e-4, 3.06150856630353954e-4, 2.68608933094006723e-4, 2.38950171716918281e-4, 2.14989381626611508e-4, 1.95265511700696976e-4, 1.78769038568867205e-4, 1.64782439482595525e-4, 1.5278308576607058e-4, 1.42382066807322224e-4, 1.33284469729227248e-4, 1.25262892766750017e-4, 1.18139359136925793e-4, 1.1177270206341761e-4, 1.06049596228778241e-4, 1.00878070613278804e-4, 9.61827420739229083e-5, 9.19012628594406498e-5, 8.79816380731971586e-5, 8.43801756098337314e-5, 8.10599020469202872e-5, 7.79893260361882294e-5, 7.51414638014355874e-5, 7.24930644208405624e-5, 7.00239888847500625e-5, 6.77167085985170288e-5, 6.55558974573310955e-5,
      3.73368556890560071e-1, 3.28677327781817191e-2, 8.4441453509803935e-3, 3.43237009945655439e-3, 1.81511356090490224e-3, 1.13150745885585685e-3, 7.85779458790995097e-4, 5.87428429179307173e-4, 4.62654515704344626e-4, 3.78538989418500275e-4, 3.18726903372068859e-4, 2.74373496426463598e-4, 2.40357980603816196e-4, 2.13545455918193276e-4, 1.91925704335598923e-4, 1.74158425752590063e-4, 1.59319827761294348e-4, 1.46754771565065148e-4, 1.35987010556582188e-4, 1.26662778184694258e-4, 1.1851424117220849e-4, 1.11335177959539335e-4, 1.04964401443952077e-4, 9.9274215907743371e-5, 9.41622232576184785e-5, 8.9545404765117768e-5, 8.53557784004689434e-5, 8.15371661519220841e-5, 7.80427557635541394e-5, 7.48332393339427014e-5, 7.187537641661234e-5, 6.91408733686775278e-5, 6.66055009965292172e-5, 6.42483936674372054e-5, 6.20514879735610848e-5, 5.99990697031097152e-5, 5.80774055915608197e-5,
      3.69324961051507855e-1, 3.18384504569563642e-2, 8.02891918037908047e-3, 3.21407087872919437e-3, 1.679627422138669e-3, 1.0377274784989873e-3, 7.15845344954712457e-4, 5.3245292938274738e-4, 4.17740273411438576e-4, 3.40765552303025107e-4, 2.86240408456331302e-4, 2.45936328788981762e-4, 2.15109110055383779e-4, 1.90864952597819775e-4, 1.71354167272301465e-4, 1.55346961251050036e-4, 1.41997826284598614e-4, 1.30708475728877147e-4, 1.21044856869655049e-4, 1.12685122405875631e-4, 1.05385998027781091e-4, 9.89604454460311019e-5, 9.32624658843191578e-5, 8.81765363725821768e-5, 8.36101228697126295e-5, 7.94882803570653721e-5, 7.57496958000579919e-5, 7.23437461646440437e-5, 6.92282819605004638e-5, 6.63679369772921191e-5, 6.37328247957015618e-5, 6.12975231328807131e-5, 5.9040274857549379e-5, 5.69423538461776143e-5, 5.49875574942811383e-5, 5.3161797443107085e-5, 5.14527671261683452e-5,
      3.65406851254343052e-1, 3.08594091114738331e-2, 7.63995175658689249e-3, 3.0119969862475702e-3, 1.5553348688687216e-3, 9.52274010663232489e-4, 6.52444248746386788e-4, 4.82806896951277925e-4, 3.77302915722864362e-4, 3.06838755128781407e-4, 2.5711848109968801e-4, 2.2048458796322856e-4, 1.9254053860670164e-4, 1.70614406012087521e-4, 1.53003810025604292e-4, 1.38580110316341434e-4, 1.26569295768601857e-4, 1.16424899220284993e-4, 1.07751257717826564e-4, 1.0025551838587832e-4, 9.37166827679780289e-5, 8.79650892733265161e-5, 8.28684803597895804e-5, 7.83223337587249782e-5, 7.42430206071967107e-5, 7.0562877891670315e-5, 6.72266023786956122e-5, 6.41885728974770062e-5, 6.14108353051678909e-5, 5.88615674782176307e-5, 5.65138967395172414e-5, 5.43449792838331151e-5, 5.23352766260403087e-5, 5.04679818014559526e-5, 4.87285605252796766e-5, 4.71043814228753245e-5, 4.55844158722242906e-5,
      3.61608147353658497e-1, 2.99274495980826782e-2, 7.27529971813180635e-3, 2.82481220116605611e-3, 1.44124443595800286e-3, 8.74370645579638944e-4, 5.9494374372580583e-4, 4.37959707647426447e-4, 3.40886953170419857e-4, 2.76360502269231596e-4, 2.31008113870753492e-4, 1.97701517884955409e-4, 1.72365227890634665e-4, 1.5253154338329235e-4, 1.36633291223544586e-4, 1.23634439068036215e-4, 1.12826286203563688e-4, 1.03709605670936939e-4, 9.59236684847028695e-5, 8.92019631056373123e-5, 8.33436987044580632e-5, 7.81949558513685139e-5, 7.36359104118739728e-5, 6.95719826556641959e-5, 6.59275840124882321e-5, 6.26416199954637458e-5, 5.96642035918577179e-5, 5.69542178085083853e-5, 5.44774835668002305e-5, 5.2205365553437893e-5, 5.01136992488731054e-5, 4.81819564595750838e-5, 4.63925900239059878e-5, 4.47305145739608987e-5, 4.31826916490851491e-5, 4.17377955933764056e-5, 4.03859425386138644e-5,
      3.57923149339568124e-1, 2.90396455690926726e-2, 6.93317923176286797e-3, 2.65129837066379222e-3, 1.33645693685417636e-3, 8.03316025592220582e-4, 5.42774299047472757e-4, 3.97434675055858018e-4, 3.08084000624896747e-4, 2.48974440199213026e-4, 2.07593734334870398e-4, 1.77304269620358632e-4, 1.54327108823294972e-4, 1.36382579787713402e-4, 1.22027635598806263e-4, 1.10311046055714001e-4, 1.00583780370959094e-4, 9.23896844129604074e-5, 8.53998233690391131e-5, 7.93716201201275152e-5, 7.41226176736398342e-5, 6.9513159709089639e-5, 6.54346734128954575e-5, 6.180156615489065e-5, 5.85455094773041167e-5, 5.56113343840829872e-5, 5.29540355432936508e-5, 5.05365522948308874e-5, 4.83281026965562192e-5, 4.63029171853730098e-5, 4.44392649595202004e-5, 4.27186974977834368e-5, 4.11254550348956239e-5, 3.96459966600269741e-5, 3.82686251460344606e-5, 3.6983185052530013e-5, 3.57808180038159836e-5,
      3.54346509447012388e-1, 2.81932844248627743e-2, 6.6119519310688491e-3, 2.4903444415293229e-3, 1.24015655635820408e-3, 7.38476389679690201e-4, 4.95422892019910638e-4, 3.60803476802490324e-4, 2.78527841264771649e-4, 2.24361533221872704e-4, 1.8659319959902977e-4, 1.59040244428153275e-4, 1.38197718849585286e-4, 1.21959106800953832e-4, 1.08995339791843539e-4, 9.84328574188602705e-5, 8.96771555005567315e-5, 8.23113596232530317e-5, 7.60354760468917494e-5, 7.06286782005828389e-5, 6.59251450876017181e-5, 6.1798144989116896e-5, 5.81492878643453827e-5, 5.49011054134266384e-5, 5.19918254562674209e-5, 4.93716248903515504e-5, 4.69998986544175862e-5, 4.48432393965138263e-5, 4.28739224464440964e-5, 4.10687554575683403e-5, 3.94081948615058268e-5, 3.78756600259316955e-5, 3.64569956324790061e-5, 3.51400463906740922e-5, 3.39143177557963946e-5, 3.27707031137793589e-5, 3.17012627880500195e-5,
      3.50873206539679847e-1, 2.73858499406962567e-2, 6.31011215892440754e-3, 2.34093654892701676e-3, 1.15160282719110144e-3, 6.79278874424889331e-4, 4.52427280225192836e-4, 3.27681164480386892e-4, 2.51890013443390541e-4, 2.02236112371377664e-4, 1.6775422268655699e-4, 1.42683833773735122e-4, 1.23773206352418338e-4, 1.09075322588853684e-4, 9.73657971840372921e-5, 8.78422213752554889e-5, 7.9959926810223229e-5, 7.33378657988072604e-5, 6.77023927180925591e-5, 6.2852449785635349e-5, 5.86373133989964412e-5, 5.49419649848062827e-5, 5.16772312583604839e-5, 4.87729890842076696e-5, 4.61733875415832538e-5, 4.38334269596082706e-5, 4.17164689519566913e-5, 3.97923967569514239e-5, 3.80362373199807317e-5, 3.6427116191084527e-5, 3.49474556448167142e-5, 3.35823528259800455e-5, 3.23190927242485394e-5, 3.11467632371436138e-5, 3.0055948320474364e-5, 2.90384814360907554e-5, 2.80872459733231096e-5,
      3.47498522569044835e-1, 2.66150064135436356e-2, 6.02627538828102572e-3, 2.20214905757135047e-3, 1.07012340077091391e-3, 6.25205493381588674e-4, 4.13370864170761767e-4, 2.97721695480179271e-4, 2.27875864555778201e-4, 1.82342346497742844e-4, 1.50851183883041661e-4, 1.28033512966638648e-4, 1.10871661942701267e-4, 9.75655658146122477e-5, 8.69870064628429416e-5, 7.83987688034517583e-5, 7.13017415330332354e-5, 6.53475598163480246e-5, 6.02865692765083395e-5, 5.59356823271720089e-5, 5.21578782909335307e-5, 4.8848755150054024e-5, 4.59274829595961988e-5, 4.33305800157120384e-5, 4.10075436739148737e-5, 3.89177266957120281e-5, 3.70280668079800759e-5, 3.53114113727208905e-5, 3.37452640401597333e-5, 3.23108351778101806e-5, 3.0992314039479093e-5, 2.97763048792809403e-5, 2.86513857243943685e-5, 2.76077599313893465e-5, 2.66369786481164438e-5, 2.57317179801893979e-5, 2.48855987396826769e-5,
      3.44218020927448948e-1, 2.58785841884092042e-2, 5.75916770824155632e-3, 2.07313646114572001e-3, 9.95107531848531969e-4, 5.75787724951682735e-4, 3.77878078750303291e-4, 2.70613931526562362e-4, 2.06221022028033506e-4, 1.64451090071666273e-4, 1.35682285308276808e-4, 1.14909249845043131e-4, 9.93307407855849456e-5, 8.72821198952929931e-5, 7.77235325393146665e-5, 6.99775103858968942e-5, 6.35865955423254521e-5, 5.82322431599810143e-5, 5.36866475148938882e-5, 4.97830586433269723e-5, 4.63968947971894671e-5, 4.34333777854925789e-5, 4.08192312263539177e-5, 3.84969791818064013e-5, 3.64209502277667457e-5, 3.45544249157418159e-5, 3.28675652585540474e-5, 3.13358888812357006e-5, 2.99391288634695886e-5, 2.86603708823226469e-5, 2.74853925305694101e-5, 2.64021519500183047e-5, 2.54003880622008844e-5, 2.44713051332880003e-5, 2.36073217285512862e-5, 2.28018693013620579e-5, 2.20492293863935572e-5,
      3.41027526530813648e-1, 2.51745664377794425e-2, 5.50761627352201135e-3, 1.95312605531991721e-3, 9.26000204922092301e-4, 5.30601646185752319e-4, 3.45610258314970453e-4, 2.46078054615069739e-4, 1.86688236921101607e-4, 1.4835706717537429e-4, 1.22067011521550897e-4, 1.03150194160103291e-4, 8.90055440660149111e-5, 7.80932578414221019e-5, 6.94546919205349889e-5, 6.24671440669881687e-5, 5.67112477989228761e-5, 5.18956708572800379e-5, 4.78125080898982907e-5, 4.43098650766712857e-5, 4.1274453125852277e-5, 3.86202190643532561e-5, 3.62807258500752305e-5, 3.42039290712748869e-5, 3.23485218932403913e-5, 3.0681329776118872e-5, 2.91754220585843017e-5, 2.78087220973180436e-5, 2.65629699675050367e-5, 2.54229383227120511e-5, 2.43758326110249342e-5, 2.34108272949145621e-5, 2.25187036139587414e-5, 2.16915640086032436e-5, 2.09226050211291051e-5, 2.0205935234572878e-5, 1.95364282121111063e-5,
      3.37923107481637299e-1, 2.45010770794901572e-2, 5.2705406254416607e-3, 1.84141130825895756e-3, 8.62296837757459338e-4, 4.89263556448690691e-4, 3.1626192598457895e-4, 2.23862356301955586e-4, 1.69064560427759763e-4, 1.33876355536311195e-4, 1.09843863021256412e-4, 9.26126170762725534e-5, 7.97667312077550318e-5, 6.98815012033628185e-5, 6.20729377340479314e-5, 5.57685495010729433e-5, 5.05838106098635782e-5, 4.62522262892989846e-5, 4.25840204711147214e-5, 3.9440808638807829e-5, 3.67195562375176939e-5, 3.43421212429518841e-5, 3.22482599854031983e-5, 3.03908407778550459e-5, 2.87325002117490992e-5, 2.72432633984050052e-5, 2.58988214306195072e-5, 2.46792652491052246e-5, 2.35681418220472953e-5, 2.25517414697497303e-5, 2.16185533140070579e-5, 2.07588446186758902e-5, 1.99643325330141122e-5, 1.92279255271476547e-5, 1.85435179397276965e-5, 1.79058253958962921e-5, 1.73102519607999782e-5,
      3.34901058176559283e-1, 2.38563697293574833e-2, 5.04694480160842384e-3, 1.73734586017768593e-3, 8.03538503977806093e-4, 4.51426040731838473e-4, 2.89557463035407643e-4, 2.03740360993270225e-4, 1.53158817810324083e-4, 1.20844138372928086e-4, 9.88683331093655305e-5, 8.31680735530114238e-5, 7.14988375831961814e-5, 6.25420695732420234e-5, 5.5482422351644173e-5, 4.97934487602260579e-5, 4.5122496143749399e-5, 4.12257433706581399e-5, 3.79299323156084776e-5, 3.51089664373569618e-5, 3.26691232501718072e-5, 3.0539434835894849e-5, 2.86652665992115929e-5, 2.7003930815000391e-5, 2.55216273393215835e-5, 2.41912695765886703e-5, 2.29909130608218555e-5, 2.19026019049315809e-5, 2.09115099440514815e-5, 2.00052929468870169e-5, 1.91735941651298419e-5, 1.84076627513145821e-5, 1.77000562698787475e-5, 1.7044406570543027e-5, 1.64352339051333286e-5, 1.58677981356916759e-5, 1.53379787199709128e-5,
      3.31957883735107827e-1, 2.32388175947356641e-2, 4.83591015958472836e-3, 1.64033809037186165e-3, 7.49307622630064441e-4, 4.16774427617260821e-4, 2.65248118853702158e-4, 1.85508248068316827e-4, 1.38799348133343097e-4, 1.09112695308225922e-4, 8.90111018057318768e-5, 7.47017633540881504e-5, 6.40987752294325746e-5, 5.59814996920141119e-5, 4.95977180041942281e-5, 4.44632148769838136e-5, 4.02545018289042071e-5, 3.67484596652088115e-5, 3.37868826777329917e-5, 3.12548525580005209e-5, 2.9067104535958389e-5, 2.71591772526091705e-5, 2.54815166131635833e-5, 2.39954552608945949e-5, 2.26704131324514167e-5, 2.14819111133688526e-5, 2.04101373092770676e-5, 1.94388959485664077e-5, 1.85548257576518705e-5, 1.77468110920381295e-5, 1.70055329337288683e-5, 1.63231227251121188e-5, 1.56928927408736993e-5, 1.51091240724334867e-5, 1.45668984370828306e-5, 1.40619636515159325e-5, 1.35906252023170481e-5,
      3.29090285637413572e-1, 2.26469042240393809e-2, 4.63658884712245473e-3, 1.54984619632894652e-3, 6.99224067962763904e-4, 3.85023601573953522e-4, 2.43109326101444116e-4, 1.6898254141215341e-4, 1.25831981540672557e-4, 9.85496067137161663e-5, 8.01564233598660756e-5, 6.71110690837681741e-5, 5.74744965575254442e-5, 5.0116415523833589e-5, 4.43426779517901959e-5, 3.97078118454735598e-5, 3.59150191977331923e-5, 3.27600858401825023e-5, 3.00985252112992081e-5, 2.78255892396911473e-5, 2.5863695965890047e-5, 2.41542859144098527e-5, 2.26524072742810071e-5, 2.13230302413859486e-5, 2.01384850001786566e-5, 1.90766466321520765e-5, 1.81196268549797819e-5, 1.72528161704399571e-5, 1.64641724504585227e-5, 1.57436855747301192e-5, 1.50829696597605497e-5, 1.44749489932996186e-5, 1.39136136369190972e-5, 1.33938274177373969e-5, 1.29111757341970018e-5, 1.2461843918416832e-5, 1.20425192665548971e-5,
      3.26295148468782137e-1, 2.20792150352768596e-2, 4.44819785812760144e-3, 1.46537373506369828e-3, 6.529416574235546e-4, 3.55915133448375173e-4, 2.22938289456519953e-4, 1.53998038270257749e-4, 1.14118228854603975e-4, 8.90361486155803376e-5, 7.22006864574622926e-5, 6.03042520107288507e-5, 5.15438032405631166e-5, 4.48724327163132418e-5, 3.96494227045423683e-5, 3.54648515242895649e-5, 3.20463524613233163e-5, 2.92069784932347009e-5, 2.68147490721869109e-5, 2.47741706591497021e-5, 2.30146411700597142e-5, 2.14829552219654702e-5, 2.01383305827835676e-5, 1.89490290018171488e-5, 1.789001116182701e-5, 1.69412778631231113e-5, 1.60866761064963442e-5, 1.53130261149727896e-5, 1.46094737542403954e-5, 1.3967003765643725e-5, 1.33780694050523509e-5, 1.28363074752363259e-5, 1.23363167790800634e-5, 1.1873484216389595e-5, 1.14438470542132384e-5, 1.10439829350681933e-5, 1.06709213519582461e-5,
      3.2356952767817865e-1, 2.15344295538687211e-2, 4.27001361943055531e-3, 1.38646558180032953e-3, 6.10144980163631543e-4, 3.2921469675499002e-4, 2.04551819610470443e-4, 1.40405952319218811e-4, 1.03533660976029906e-4, 8.04658577629783211e-5, 6.50511284899169679e-5, 5.41992885426948495e-5, 4.62332844222765304e-5, 4.01831826939386451e-5, 3.54574375059006556e-5, 3.16787545015523619e-5, 2.85971346266859757e-5, 2.6041404835520241e-5, 2.38909866063583235e-5, 2.20588089524949591e-5, 2.04806119332979882e-5, 1.91080479411589288e-5, 1.79041127548000236e-5, 1.68400469212111653e-5, 1.58931890099394124e-5, 1.5045459422613175e-5, 1.42822706936958894e-5, 1.35917317745365705e-5, 1.29640584967785195e-5, 1.23911309445694686e-5, 1.18661570387843374e-5, 1.13834139478674001e-5, 1.09380472378541748e-5, 1.05259133541791852e-5, 1.01434549721447886e-5, 9.78760152867712182e-6, 9.4556892258828044e-6,
      3.20910638265977981e-1, 2.10113142965543977e-2, 4.10136705876326415e-3, 1.31270426559297743e-3, 5.70546532172290294e-4, 3.04709740723094927e-4, 1.87784387175778964e-4, 1.28072248508964691e-4, 9.39664579744954335e-5, 7.27432486585578604e-5, 5.86246872779793015e-5, 4.87228320861737923e-5, 4.14773701284316212e-5, 3.59894432581885594e-5, 3.17127688162410561e-5, 2.83000034195131559e-5, 2.55216303266552677e-5, 2.32208890004071368e-5, 2.12875981305465435e-5, 1.96423532660201384e-5, 1.82266579574669113e-5, 1.69965726382116961e-5, 1.59185167160451102e-5, 1.49664267999091778e-5, 1.41197912178568103e-5, 1.33622640099389316e-5, 1.2680670228424296e-5, 1.20642805628244386e-5, 1.15042745857002705e-5, 1.09933382204262569e-5, 1.0525358129949781e-5, 1.00951870428538782e-5, 9.69846165091011977e-6, 9.33145992037657612e-6, 8.99098827159446563e-6, 8.67429162076086093e-6, 8.37898108528564766e-6,
      3.18315844323859513e-1, 2.05087162440828274e-2, 3.94163910914018031e-3, 1.24370664549194929e-3, 5.33884127604384355e-4, 2.82207394055727204e-4, 1.7248637380885882e-4, 1.16876149608998524e-4, 8.53161099070509883e-5, 6.57826663125276945e-5, 5.28469754427315264e-5, 4.38092866917209366e-5, 3.72174873118641293e-5, 3.22383640142526256e-5, 2.83673088909118292e-5, 2.52844785329519684e-5, 2.27791157384402248e-5, 2.07076308898606376e-5, 1.89693251980280502e-5, 1.749177366137744e-5, 1.62217182076150079e-5, 1.51192197378405024e-5, 1.41538005259002624e-5, 1.33018376186983402e-5, 1.25447630647183518e-5, 1.18677967480975292e-5, 1.12590382953088034e-5, 1.07088057468180026e-5, 1.02091468064066199e-5, 9.75347273480579324e-6, 9.33628069534543639e-6, 8.95294076389574728e-6, 8.5995308096609382e-6, 8.27270722917893201e-6, 7.96960282447102631e-6, 7.68774543953634055e-6, 7.42499262138017047e-6,
      3.15782649356549727e-1, 2.0025556850709858e-2, 3.79025660915937208e-3, 1.17912089447158075e-3, 4.99918558948038195e-4, 2.61532576042087625e-4, 1.58522500228158744e-4, 1.06708796514069842e-4, 7.74922533232751732e-5, 5.95072602302358278e-5, 4.76513642225407664e-5, 3.93999803685011071e-5, 3.34013073400674163e-5, 2.88827762306172541e-5, 2.53781587528382351e-5, 2.25928664103393753e-5, 2.03333270381623478e-5, 1.84679894850726235e-5, 1.69048047052748041e-5, 1.55777026175050218e-5, 1.44381869341734726e-5, 1.34499496147078552e-5, 1.25853254325697853e-5, 1.18229007362651862e-5, 1.11458651895238155e-5, 1.05408531058541779e-5, 9.99711431930789954e-6, 9.50591117802254086e-6, 9.06007345535086289e-6, 8.65366533876416051e-6, 8.2817331503251945e-6, 7.94011201907131479e-6, 7.62527614806534444e-6, 7.3342216987164274e-6, 7.06437434568488753e-6, 6.81351568144721161e-6, 6.57972415957386462e-6,
      3.13308687321307169e-1, 1.95608265433377911e-2, 3.64668856263192884e-3, 1.11862376157857077e-3, 4.68431481446717723e-4, 2.42526294069871729e-4, 1.45770412929129824e-4, 9.7472046261010992e-5, 7.0413629125790815e-5, 5.38480667022457511e-5, 4.29781649650098395e-5, 3.54424272726684244e-5, 2.99820749605538701e-5, 2.58805778819584321e-5, 2.27070609318978642e-5, 2.0190133695157889e-5, 1.81519697904614199e-5, 1.64720234489196887e-5, 1.50661370506048291e-5, 1.38740276856166773e-5, 1.28515282397836611e-5, 1.19656268705386417e-5, 1.11912079706656096e-5, 1.0508858173590037e-5, 9.90335664101374363e-6, 9.36261546919759994e-6, 8.87692256416035988e-6, 8.43839174987420219e-6, 8.04055739628558008e-6, 7.67807148036038913e-6, 7.34647433992194497e-6, 7.04201917704542529e-6, 6.76153626570937214e-6, 6.5023268355373344e-6, 6.26207937990559786e-6, 6.03880308193590085e-6, 5.83077443218357009e-6,
      3.1089171432666347e-1, 1.9113579667483484e-2, 3.51044272445499056e-3, 1.06191808567495984e-3, 4.39223499671868524e-4, 2.25044108737843776e-4, 1.34119413295964687e-4, 8.90773934025037272e-5, 6.40071489834277257e-5, 4.87431878560871367e-5, 3.87738977974646296e-5, 3.18896691501478065e-5, 2.69180098705565651e-5, 2.31941856435113084e-5, 2.03198942964892284e-5, 1.80450587410050621e-5, 1.62062825178031728e-5, 1.46930826480399592e-5, 1.34285023153565049e-5, 1.23575295760821734e-5, 1.14399337483291935e-5, 1.06456956076702504e-5, 9.95201114295171699e-6, 9.34127823852134761e-6, 8.79971367099372135e-6, 8.31638398903612187e-6, 7.88251405439919073e-6, 7.49098552777241495e-6, 7.13596762896168962e-6, 6.81264152578221184e-6, 6.51699199780277739e-6, 6.2456481113300957e-6, 5.99576005888865618e-6, 5.76490300128660222e-6, 5.55100129411366048e-6, 5.35226826073767431e-6, 5.16715793572427752e-6,
      3.08529600937035727e-1, 1.86829298411960036e-2, 3.38106248280523292e-3, 1.00873053677118164e-3, 4.12112436369491149e-4, 2.08954749698409261e-4, 1.23469314507929354e-4, 8.14450018970553981e-5, 5.82070588578280872e-5, 4.41370571685703e-5, 3.49906381152223132e-5, 2.8699687461697033e-5, 2.41717729889311652e-5, 2.07900465104007029e-5, 1.81862241502516027e-5, 1.61298147306441785e-5, 1.44706484453516365e-5, 1.31074449330264529e-5, 1.1969819112379292e-5, 1.10075605973555316e-5, 1.01840185451635272e-5, 9.47189109394164136e-6, 8.85047028714079066e-6, 8.30379427997988164e-6, 7.81938023378102452e-6, 7.38733782749107085e-6, 6.9997376909319443e-6, 6.65015395865003125e-6, 6.33332790448995068e-6, 6.04491716692482764e-6, 5.78130639678165444e-6, 5.53946260012202354e-6, 5.31682342460726971e-6, 5.11121001804878781e-6, 4.92075841864250006e-6, 4.74386506573727101e-6, 4.57914317367749751e-6,
      3.06220325034459297e-1, 1.82680456816039914e-2, 3.2581240105802706e-3, 9.58809563302024559e-4, 3.86931765702789868e-4, 1.94138867088517444e-4, 1.13729413157089567e-4, 7.45028360268491192e-5, 5.29541894215101588e-5, 3.99797822431779744e-5, 3.15854325389814857e-5, 2.58348785508160938e-5, 2.17099903926166286e-5, 1.86382025207745723e-5, 1.62789015205057805e-5, 1.44195985971478212e-5, 1.29222500847248256e-5, 1.16939931464762757e-5, 1.0670441345327046e-5, 9.80575893639755658e-6, 9.06655110012316885e-6, 8.42798373209601758e-6, 7.87124972463803747e-6, 7.38187283679224224e-6, 6.94854661115186609e-6, 6.5623233644178991e-6, 6.21603725330574483e-6, 5.90388697509031925e-6, 5.62112931567318986e-6, 5.3638509493092653e-6, 5.12879632339134472e-6, 4.91323630653315818e-6, 4.71486684890431861e-6, 4.53173000515457203e-6, 4.36215180614416104e-6, 4.20469295710480499e-6, 4.05810939474624036e-6,
      3.03961965192900388e-1, 1.78681468719935143e-2, 3.14123366158646463e-3, 9.11923525818922294e-4, 3.63529194807165405e-4, 1.80487904956108498e-4, 1.0481756385332643e-4, 6.81858800636823184e-5, 4.81952842320347413e-5, 3.62265566431733192e-5, 2.85197768946852289e-5, 2.32615850457497431e-5, 1.95028286495058774e-5, 1.6711902778058986e-5, 1.45737062351146145e-5, 1.28923006945693909e-5, 1.15407619130004085e-5, 1.04339278893158416e-5, 9.51288865384766359e-6, 8.73579477539525756e-6, 8.07221336645711002e-6, 7.49955170671160802e-6, 7.00072672811499827e-6, 6.56260786791357341e-6, 6.17495298713492798e-6, 5.82966631523337039e-6, 5.52027135683868916e-6, 5.24153017069449123e-6, 4.98916413985604962e-6, 4.7596462918323914e-6, 4.55004483573334813e-6, 4.35790388053470951e-6, 4.18115149782603086e-6, 4.01802813812046069e-6, 3.86703036726039366e-6, 3.72686625472488164e-6, 3.5964197102836719e-6,
      3.01752694524434998e-1, 1.74825005402324154e-2, 3.03002558929109641e-3, 8.67858999479979658e-4, 3.41765379184581139e-4, 1.67903084477414335e-4, 9.66593463087376653e-5, 6.24354374833482138e-5, 4.38823974970661011e-5, 3.28371334506835222e-5, 2.57591495731683454e-5, 2.09496774267073793e-5, 1.75236159645470586e-5, 1.4987257605092377e-5, 1.30490289803861575e-5, 1.15282107249487307e-5, 1.03080769302943588e-5, 9.3105120738481669e-6, 8.48160679181755823e-6, 7.78314468819806914e-6, 7.18738767616763677e-6, 6.67377908968348669e-6, 6.22679973510475162e-6, 5.8345381248626586e-6, 5.48771515609924593e-6, 5.17900505640754137e-6, 4.90255376527255931e-6, 4.65363154397754673e-6, 4.42837852132939759e-6, 4.22361566898218553e-6, 4.03670255328208603e-6, 3.8654290043115528e-6, 3.70793170120549937e-6, 3.56262928420431866e-6, 3.42817139802066019e-6, 3.30339832101986036e-6, 3.18730871690302166e-6,
      2.9959077496006109e-1, 1.71104179219968765e-2, 2.92415956804999304e-3, 8.26419229436240798e-4, 3.21512758910739105e-4, 1.56294486004622897e-4, 8.91873154820057494e-5, 5.71985014943041996e-5, 3.9972354131360671e-5, 2.97753540067074375e-5, 2.32725943435251465e-5, 1.88721803484729614e-5, 1.57485041656643922e-5, 1.34429302300490602e-5, 1.16855880626041928e-5, 1.03097559257011624e-5, 9.20806334748484482e-6, 8.3088437343570645e-6, 7.56275460495691468e-6, 6.93489115815169102e-6, 6.39996743155226853e-6, 5.93927654730810053e-6, 5.53871808105697556e-6, 5.18748505896072285e-6, 4.87716986602301277e-6, 4.60114276110722143e-6, 4.35411175432668815e-6, 4.13180559220361267e-6, 3.93074185459699695e-6, 3.74805489121586147e-6, 3.58136648377054723e-6, 3.42868745110012174e-6, 3.28834196020322394e-6, 3.1589087027119032e-6, 3.03917474091121507e-6, 2.92809897183557654e-6, 2.82478296483283907e-6,
      2.9747455193107697e-1, 1.67512512846469222e-2, 2.82331899861107975e-3, 7.87422724758382971e-4, 3.02654503927581958e-4, 1.45580220098824597e-4, 8.23403263376320864e-5, 5.24271895095840051e-5, 3.64262655802624814e-5, 2.70087259870626001e-5, 2.1032347332962725e-5, 1.7004938895668518e-5, 1.41561670989450637e-5, 1.20598619087056654e-5, 1.04661770670958836e-5, 9.22126796347490658e-6, 8.22634807175329982e-6, 7.41565395908494997e-6, 6.74401464641533616e-6, 6.17954441257838906e-6, 5.69918892937781077e-6, 5.28592211326136391e-6, 4.92693083245845724e-6, 4.61240895022701656e-6, 4.33473758121514063e-6, 4.08791621889807656e-6, 3.86716048280004914e-6, 3.66861278841135619e-6, 3.48913097287456668e-6, 3.32613165407038134e-6, 3.1774726194958573e-6, 3.041363447613874e-6, 2.91629682284918478e-6, 2.80099520513216779e-6, 2.69436902252136395e-6, 2.5954836033731313e-6, 2.50353280255725577e-6,
      2.95402449419840411e-1, 1.64043910897640962e-2, 2.72720908140031162e-3, 7.50701977939715474e-4, 2.85083557860629376e-4, 1.35685678703276935e-4, 7.6062925647187041e-5, 4.80782349625973324e-5, 3.32090955751266909e-5, 2.45080455939152331e-5, 1.90135034554283267e-5, 1.53263204709619617e-5, 1.27275314858580872e-5, 1.0821026836654035e-5, 9.37544002794329975e-6, 8.24877537353756352e-6, 7.35012402738805108e-6, 6.61912715650700757e-6, 6.01442479950365085e-6, 5.50688408305308511e-6, 5.07548195291059833e-6, 4.70471977681416567e-6, 4.3829525731294208e-6, 4.10128120578579924e-6, 3.85280069918072304e-6, 3.63207945406532665e-6, 3.43479155948067274e-6, 3.25745269809978366e-6, 3.09722746160047511e-6, 2.95178673469708511e-6, 2.81920073669158178e-6, 2.69785782508371883e-6, 2.58640216075526315e-6, 2.48368535346736419e-6, 2.38872858864632508e-6, 2.30069269610649337e-6, 2.21885429649341556e-6,
      2.93372965351346655e-1, 1.60692633743283062e-2, 2.63555514263725218e-3, 7.16102298264722983e-4, 2.68701770849205174e-4, 1.26542858508919459e-4, 7.0304804040714937e-5, 4.41125305574919307e-5, 3.02892706031404118e-5, 2.22470591999079756e-5, 1.7193718079078635e-5, 1.38169484824978022e-5, 1.14455367256100276e-5, 9.71121360466762984e-6, 8.39967109429915396e-6, 7.3798187331292613e-6, 6.5679786779145564e-6, 5.90874117896514605e-6, 5.36422857034047482e-6, 4.90781847931677383e-6, 4.5203370322349443e-6, 4.18767388857897372e-6, 3.89924423856599583e-6, 3.64697100714538993e-6, 3.42459547839818524e-6, 3.22720047049011674e-6, 3.05087419944819221e-6, 2.89246918990069814e-6, 2.74942660764229874e-6, 2.61964639893394969e-6, 2.50139000997460745e-6, 2.39320661662381414e-6, 2.29387654751966274e-6, 2.20236743746365108e-6, 2.11779991534236583e-6, 2.03942050978393404e-6, 1.96658007340234908e-6,
      2.91384667299453195e-1, 1.57453273322914486e-2, 2.54810109971961899e-3, 6.83480748461443256e-4, 2.53419112819930167e-4, 1.18089749368539287e-4, 6.5020302215812836e-5, 4.04947176618471445e-5, 2.76383304252060797e-5, 2.02021602793031708e-5, 1.5552940175425165e-5, 1.24594644120288525e-5, 1.02949205089334548e-5, 8.71683030605090137e-6, 7.52663601091781855e-6, 6.60328606784984022e-6, 5.86974140767299205e-6, 5.27512510226021859e-6, 4.78474197393043009e-6, 4.37425951210979565e-6, 4.0261875086966128e-6, 3.7276776105495368e-6, 3.46910730768839938e-6, 3.24314469105855559e-6, 3.04411613072202264e-6, 2.86756964021537382e-6, 2.70996754538320925e-6, 2.56846636994137278e-6, 2.44075666407463832e-6, 2.32494474545187517e-6, 2.21946421190626708e-6, 2.12300891161554584e-6, 2.03448158758836183e-6, 1.95295411523507162e-6, 1.87763641401919486e-6, 1.80785191923944604e-6, 1.74301806511383649e-6,
      2.89436188483756964e-1, 1.54320730799205597e-2, 2.46460805357414453e-3, 6.52705175073293521e-4, 2.39152959480884559e-4, 1.10269781337679566e-4, 6.01679658382936571e-5, 3.7192817101405247e-5, 2.52306144679791757e-5, 1.83521179044894307e-5, 1.40731735967376012e-5, 1.12383152152010914e-5, 9.26202745083498349e-6, 7.82573072130162273e-6, 6.74541302552931482e-6, 5.90926626634031833e-6, 5.24634768053763771e-6, 4.70993270460122044e-6, 4.26823516877725624e-6, 3.89901151990876372e-6, 3.58630474826520662e-6, 3.31841383639489655e-6, 3.08658985165394083e-6, 2.88417643082443607e-6, 2.70602970678823116e-6, 2.54811842059488885e-6, 2.40724289087307575e-6, 2.28083402505620554e-6, 2.16680726035318098e-6, 2.06345485832864826e-6, 1.96936540772912459e-6, 1.88336291333373008e-6, 1.80446017565631115e-6, 1.73182272913019005e-6, 1.66474067228019053e-6, 1.60260646084607924e-6, 1.54489725192546481e-6,
      2.87526224035114883e-1, 1.51290195897487991e-2, 2.38485299680835246e-3, 6.23653323902845352e-4, 2.25827444075379836e-4, 1.03031324567932523e-4, 5.57101442294503767e-5, 3.41778971102712792e-5, 2.3042980356124663e-5, 1.66778334824430884e-5, 1.27382634883535836e-5, 1.01395633351434033e-5, 8.33463825371566766e-6, 7.02705928711532105e-6, 6.04625109812700405e-6, 5.28891852410434347e-6, 4.68971812418600295e-6, 4.20572990581250031e-6, 3.80782720082825891e-6, 3.47567244962868358e-6, 3.19470503409568781e-6, 2.95426718474855835e-6, 2.74640310823617987e-6, 2.56506894646986856e-6, 2.40560055770438057e-6, 2.26434723367442403e-6, 2.13841468577342285e-6, 2.02548149780477998e-6, 1.92366592060854251e-6, 1.83142776773612271e-6, 1.74749517940687623e-6, 1.67080926611151886e-6, 1.60048178301711034e-6, 1.53576242149534636e-6, 1.47601328170987444e-6, 1.42068876580424974e-6, 1.36931960444216526e-6,
      2.85653527509609439e-1, 1.48357127793028963e-2, 2.30862762752623398e-3, 5.96212032706622602e-4, 2.13372868619099917e-4, 9.63272368593877629e-5, 5.16126284376405494e-5, 3.14237746317216793e-5, 2.10545512440072922e-5, 1.51621227594513845e-5, 1.15337051636826748e-5, 9.15071690434552494e-6, 7.5018171829227147e-6, 6.31111280750041829e-6, 5.42044352071825861e-6, 4.73435605569582775e-6, 4.19265089339666727e-6, 3.7558946209561145e-6, 3.39739240024826972e-6, 3.09854601457148905e-6, 2.84606683322614324e-6, 2.63024582512140558e-6, 2.44384740007977269e-6, 2.2813831155794782e-6, 2.13862329369094337e-6, 2.01226147335955374e-6, 1.89967933052739872e-6, 1.79877903840349696e-6, 1.70786177057181907e-6, 1.62553833215111021e-6, 1.55066252302497073e-6, 1.48228082471887788e-6, 1.41959397031711642e-6, 1.36192727490533774e-6, 1.30870750077780847e-6, 1.25944465064851786e-6, 1.21371751518753002e-6,
      2.83816907632413186e-1, 1.45517237419837086e-2, 2.23573725960103882e-3, 5.70276494065350015e-4, 2.01725168960337502e-4, 9.01144542006240366e-5, 4.78443247423587484e-5, 2.89067465599894832e-5, 1.92464889573832533e-5, 1.37895204381869999e-5, 1.04464730561376508e-5, 8.26057797169342869e-6, 6.75377587785025909e-6, 5.66921708796859843e-6, 4.86021526380940256e-6, 4.23854250869763417e-6, 3.74872584814142829e-6, 3.35452765424606799e-6, 3.03147713680736266e-6, 2.76256360671813388e-6, 2.53565727851991864e-6, 2.34191203530501828e-6, 2.17474634806394761e-6, 2.02917548369276075e-6, 1.90136328218927935e-6, 1.78831472289260925e-6, 1.68766087880278278e-6, 1.59750578695788101e-6, 1.5163156180417768e-6, 1.44283725628269076e-6, 1.37603766101589473e-6, 1.31505813287696262e-6, 1.25917941745537627e-6, 1.20779478993490511e-6, 1.16038908691127358e-6, 1.11652221876969585e-6, 1.07581609239895372e-6,
      2.82015225254514303e-1, 1.42766471085739038e-2, 2.16599982104010173e-3, 5.45749582026369943e-4, 1.90825428557209485e-4, 8.43536200929206626e-5, 4.4376960042654431e-5, 2.66053478670787506e-5, 1.76017902696951384e-5, 1.25461050331703836e-5, 9.46486761774860812e-6, 7.4591068249629617e-6, 6.08175173642763757e-6, 5.09361687245512214e-6, 4.35862255071321624e-6, 3.79519968561929083e-6, 3.35221924427826524e-6, 2.99637341172053043e-6, 2.70522578382360952e-6, 2.46321487705171014e-6, 2.25926683672478068e-6, 2.08532051270955599e-6, 1.93538844895233573e-6, 1.8049427859824218e-6, 1.69050383602387584e-6, 1.58935836888443742e-6, 1.49936286751412816e-6, 1.41880363536944383e-6, 1.34629568433504474e-6, 1.28070854822254548e-6, 1.22111109698369147e-6, 1.16672996133179252e-6, 1.11691784223800769e-6, 1.07112909193763154e-6, 1.0289007078541284e-6, 9.89837400619371274e-7, 9.53599760216358653e-7,
      2.80247390506642741e-1, 1.40100995288440128e-2, 2.09924493283847768e-3, 5.22541236721495176e-4, 1.80619436364399069e-4, 7.90087498758553385e-5, 4.11848159435961936e-5, 2.45001338752132833e-5, 1.61051039182857199e-5, 1.14193418424186193e-5, 8.57837826217344578e-6, 6.73730068715787549e-6, 5.47789930210731424e-6, 4.57737763950990022e-6, 3.90946332521412272e-6, 3.39872533343623537e-6, 2.99802777870192225e-6, 2.67674934673392913e-6, 2.4143148686601334e-6, 2.19648601889700422e-6, 2.01315124872491564e-6, 1.85696357176183449e-6, 1.72247519116370159e-6, 1.60557269199408599e-6, 1.50309933806185951e-6, 1.41259689012731322e-6, 1.33212558170040614e-6, 1.26013630338183369e-6, 1.19537834617580006e-6, 1.1368317984767876e-6, 1.08365731738228085e-6, 1.03515832989171402e-6, 9.90752251034656583e-7, 9.49948327738391317e-7, 9.12330409799368336e-7, 8.77543425683578183e-7, 8.45282673052459971e-7,
      2.78512360135995078e-1, 1.37517182636346729e-2, 2.03531306140795396e-3, 5.00567901710954011e-4, 1.71057284670801334e-4, 7.40469266490993056e-5, 3.8244488678871175e-5, 2.25734842188826769e-5, 1.47425662168043993e-5, 1.03979421379122825e-5, 7.7775606532040642e-6, 6.08708525058440892e-6, 4.93519325286372038e-6, 4.11429797178478726e-6, 3.50719742445620684e-6, 3.04411989710019411e-6, 2.68160095887184938e-6, 2.39148317283061541e-6, 2.15489450153681342e-6, 1.95880489698326069e-6, 1.79397993034054812e-6, 1.6537224568400694e-6, 1.53307497536651441e-6, 1.42830007400207807e-6, 1.3365336338344001e-6, 1.25554818098442159e-6, 1.18358814011133004e-6, 1.11925303866416913e-6, 1.06141332017670294e-6, 1.00914873368498765e-6, 9.6170261207225699e-7, 9.18447503380573276e-7, 8.78859028149385128e-7, 8.42495774654763743e-7, 8.08983679452745839e-7, 7.78003777248809648e-7, 7.49282508232810741e-7,
      2.76809135012506576e-1, 1.3501159878617374e-2, 1.97405473829276644e-3, 4.79752009298215717e-4, 1.62093003133517075e-4, 6.94380257244509118e-5, 3.5534672298465856e-5, 2.08094262941290803e-5, 1.35016533444646937e-5, 9.47173687831657614e-6, 7.05392682134658362e-6, 5.50121767794479384e-6, 4.44734174352781834e-6, 3.69883135306270615e-6, 3.14687539913576017e-6, 2.72692125485497867e-6, 2.39888088049240762e-6, 2.13685698565070581e-6, 1.9235362754812059e-6, 1.74699226060461639e-6, 1.59879011283756375e-6, 1.47282408663073811e-6, 1.36458218901032957e-6, 1.27066817829535845e-6, 1.18848309899862755e-6, 1.1160083414889155e-6, 1.0516548568548638e-6, 9.94156417702331654e-7, 9.42492786498451637e-7, 8.95833560000085896e-7, 8.53496545833906609e-7, 8.14916509534552232e-7, 7.79621426842283327e-7, 7.47214238748216284e-7, 7.17358690035146763e-7, 6.89768232293421671e-7, 6.64197250849900303e-7,
      2.7513675779247107e-1, 1.32580990316861422e-2, 1.91532984144938832e-3, 4.60021509506666148e-4, 1.53684225617496098e-4, 6.51544648469323313e-5, 3.30359628112114042e-5, 1.91934762198616505e-5, 1.2371048593460518e-5, 8.63156342675709877e-6, 6.39984675300076478e-6, 4.97319984719985798e-6, 4.00870898804711933e-6, 3.32601637193055306e-6, 2.82407503896414098e-6, 2.44314656126944969e-6, 2.14624859834862327e-6, 1.90955753069328003e-6, 1.71718692003112259e-6, 1.5582183642184351e-6, 1.4249460829349379e-6, 1.3118026224922143e-6, 1.21468085703837145e-6, 1.13049414858350399e-6, 1.05688385541232195e-6, 9.92020430437820145e-7, 9.34465396082400967e-7, 8.83073783554132235e-7, 8.36924005390759787e-7, 7.95266666200207253e-7, 7.57486666129793763e-7, 7.23074778327634321e-7, 6.91606074748046019e-7, 6.62723367470071512e-7, 6.36124368042206455e-7, 6.11551634279192195e-7, 5.88784628925476554e-7,
      2.73494310728271882e-1, 1.30222273466153398e-2, 1.85900693288077486e-3, 4.41309438812101294e-4, 1.45791886777855328e-4, 6.11709776976643237e-5, 3.07306812059314478e-5, 1.77124955393981744e-5, 1.13405230352964504e-5, 7.8691639166805952e-6, 5.80846024129448338e-6, 4.49720074844938062e-6, 3.61424608878993316e-6, 2.99141442238100815e-6, 2.53484476450190773e-6, 2.18924042003848411e-6, 1.92047636530694522e-6, 1.70663193835152544e-6, 1.53312707107410631e-6, 1.38996439428546551e-6, 1.27010295368504748e-6, 1.16846532149237089e-6, 1.08131235592499003e-6, 1.00583841270844731e-6, 9.39902668930945977e-7, 8.81846734660437857e-7, 8.30368291330246326e-7, 7.84431909083614162e-7, 7.43205030945315287e-7, 7.06011305435038739e-7, 6.72296079567625131e-7, 6.41600547803713102e-7, 6.13542150566036552e-7, 5.87799544621200858e-7, 5.64100959041585697e-7, 5.42215086862964535e-7, 5.21943896072539243e-7,
      2.71880913613868155e-1, 1.27932523662404153e-2, 1.80496264788056077e-3, 4.23553525089104678e-4, 1.3837994561714839e-4, 5.74644084374120492e-5, 2.86027134848095566e-5, 1.63545620726209305e-5, 1.0400828227293388e-5, 7.17709405198391212e-6, 5.27359791662893493e-6, 4.06798705834720802e-6, 3.25942922741912101e-6, 2.69105409064228529e-6, 2.27565313825939952e-6, 1.9620286941267352e-6, 1.71868509452232133e-6, 1.52544832281915958e-6, 1.36893459008664104e-6, 1.23998816818241203e-6, 1.13217446116633441e-6, 1.04086219522307048e-6, 9.62646735777061999e-7, 8.94977498853568328e-7, 8.3591111467238816e-7, 7.83944158099649734e-7, 7.37897449588361104e-7, 6.96834520887231789e-7, 6.60003171269095785e-7, 6.2679291778865867e-7, 5.96703571303595225e-7, 5.69321721891286859e-7, 5.44302927991605135e-7, 5.21358073417640977e-7, 5.00242807513057999e-7, 4.80749292191601833e-7, 4.62699693471730218e-7,
      2.70295721856487878e-1, 1.25708965789847111e-2, 1.75308113156453693e-3, 4.06695825558423047e-4, 1.31415133515924287e-4, 5.40135252710106705e-5, 2.66373660309082889e-5, 1.51088534923357485e-5, 9.54359972411381689e-6, 6.54864125550445224e-6, 4.78971049013932227e-6, 3.68086102215519087e-6, 2.94020442758047563e-6, 2.42138150571733613e-6, 2.04334382966413542e-6, 1.75867733691491922e-6, 1.53830647105922474e-6, 1.36366070829605826e-6, 1.22245192901269187e-6, 1.10629363055257839e-6, 1.00930433837029736e-6, 9.27259049143861763e-7, 8.57057246353343807e-7, 7.96379896247037554e-7, 7.43462642187051213e-7, 6.96942379096574211e-7, 6.55751303131912596e-7, 6.19042360437311799e-7, 5.86135884068045815e-7, 5.56480794199509186e-7, 5.29625978659622236e-7, 5.05198901471990346e-7, 4.8288941749517339e-7, 4.62437387004516577e-7, 4.43623098265741708e-7, 4.2625978901148902e-7, 4.10187753638444489e-7,
      2.6873792466571832e-1, 1.23548965130714606e-2, 1.70325351874944046e-3, 3.90682394819914962e-4, 1.24866724474728868e-4, 5.07988512118854231e-5, 2.48212348007672549e-5, 1.39655423446401128e-5, 8.76127028761148658e-6, 5.97775119426866264e-6, 4.35180534607138992e-6, 3.33160486682516454e-6, 2.65293818496215747e-6, 2.17921600965526792e-6, 1.8350954412248448e-6, 1.57665569569970757e-6, 1.37704920242018736e-6, 1.21917780532479648e-6, 1.09175709298004677e-6, 9.87103725342982579e-7, 8.99840867785032694e-7, 8.2611352483376924e-7, 7.6309770822069967e-7, 7.08684618661132214e-7, 6.61272214391786418e-7, 6.19624463960720689e-7, 5.82774310250340029e-7, 5.49955495596145381e-7, 5.2055383189591432e-7, 4.94071816276563529e-7, 4.70102563046684539e-7, 4.48310341691765398e-7, 4.28415867242729221e-7, 4.10185055481634018e-7, 3.93420335780120446e-7, 3.77953873782825346e-7, 3.63642235610516784e-7,
      2.67206743351862277e-1, 1.21450018932305469e-2, 1.65537745358642704e-3, 3.75462980324631344e-4, 1.18706325521916988e-4, 4.78025104048639653e-5, 2.31420869846935436e-5, 1.29157013641259276e-5, 8.04699180325651158e-6, 5.45896181205068353e-6, 3.95538971085078762e-6, 3.01643105171004003e-6, 2.39437333632205734e-6, 1.9617105735366261e-6, 1.64838566796560206e-6, 1.41370379912530911e-6, 1.23286895375631469e-6, 1.09013521289603298e-6, 9.75137802777977038e-7, 8.8083626875179505e-7, 8.0231425868519762e-7, 7.36053809811247415e-7, 6.79482410528999069e-7, 6.30682167434513582e-7, 5.88198230871658138e-7, 5.50909660112072249e-7, 5.17940539794092062e-7, 4.88597628129146363e-7, 4.62325852584426848e-7, 4.38676036684848684e-7, 4.17281153370927866e-7, 3.97838616608224568e-7, 3.80096911639658567e-7, 3.63845384833279433e-7, 3.48906363344730123e-7, 3.35129012751850872e-7, 3.22384505233443299e-7,
      2.65701429726050143e-1, 1.19409748551386452e-2, 1.60935664567193929e-3, 3.6099074288289483e-4, 1.12907685436628195e-4, 4.50080885264884165e-5, 2.15887539135319594e-5, 1.19512180521631006e-5, 7.39456501425438319e-6, 4.98734409110283283e-6, 3.59641970856931866e-6, 2.73193773773794194e-6, 2.16158960686230027e-6, 1.76631644747285497e-6, 1.48095931984182474e-6, 1.26780319371354758e-6, 1.10394156358802209e-6, 9.74870668904190796e-7, 8.71068503207199739e-7, 7.86082490039546367e-7, 7.1541653466318313e-7, 6.55859717119282008e-7, 6.05068252622141243e-7, 5.61297624840893137e-7, 5.23226478752157023e-7, 4.89838123306481369e-7, 4.60339104419958029e-7, 4.34102171639159186e-7, 4.10625628083922319e-7, 3.89503891483015213e-7, 3.70405859874670289e-7, 3.53058797171613661e-7, 3.37236180068547279e-7, 3.22748426479509638e-7, 3.09435746464748858e-7, 2.97162574866570228e-7, 2.85813195516404607e-7,
      2.64221264595168159e-1, 1.17425892132228485e-2, 1.5651004596450879e-3, 3.47222000025394307e-4, 1.07446520112164112e-4, 4.2400505926907084e-5, 2.01510341129737912e-5, 1.10647175917596296e-5, 6.79837627654785877e-6, 4.55844884654426569e-6, 3.2712546857899301e-6, 2.47506892211204049e-6, 1.95196833575596935e-6, 1.59075158843696057e-6, 1.33079978816579175e-6, 1.1371509423440151e-6, 9.8863918038208209e-7, 8.719020132684928e-7, 7.78189902681316756e-7, 7.01587944228493288e-7, 6.37983652037494101e-7, 5.8444587019865054e-7, 5.38838878421082322e-7, 4.99575638883603711e-7, 4.6545588326496682e-7, 4.35557361151811252e-7, 4.09161233985544573e-7, 3.85699899874055173e-7, 3.64719859511351712e-7, 3.45854859470196738e-7, 3.28806180207732737e-7, 3.13327970604625599e-7, 2.99216199734390745e-7, 2.86300236829678998e-7, 2.74436365045372084e-7, 2.63502734847246792e-7, 2.53395400892751167e-7,
      2.62765556345186725e-1, 1.15496297778152094e-2, 1.5225235355408755e-3, 3.34115990233567779e-4, 1.02300353043703908e-4, 3.99659023078076756e-5, 1.88196055162713794e-5, 1.02494932668491157e-5, 6.25334062030884336e-6, 4.16825892986988077e-6, 2.97661625392603011e-6, 2.24307874469169594e-6, 1.76316093350322888e-6, 1.4329724592030845e-6, 1.19610358275924096e-6, 1.02013643996955772e-6, 8.85508999927285264e-7, 7.79907565138016004e-7, 6.9529076435692354e-7, 6.2623553364815918e-7, 5.6897960094802894e-7, 5.20846758160819205e-7, 4.79890580668337415e-7, 4.44667087444599299e-7, 4.14085855788378789e-7, 3.87310199688791694e-7, 3.636888041062781e-7, 3.42707987996579765e-7, 3.23957777982476372e-7, 3.07107404584202356e-7, 2.91887339769555576e-7, 2.78075948801421561e-7, 2.65489445440835549e-7, 2.53974244525000486e-7, 2.43401076591845403e-7, 2.3366041292864981e-7, 2.24658875921915906e-7,
      2.61333639606953566e-1, 1.13618917179719537e-2, 1.48154543740509697e-3, 3.21634656235950181e-4, 9.74483695675226328e-5, 3.76915318482205645e-5, 1.75859459448606739e-5, 9.49944363845904564e-6, 5.75485047731543365e-6, 3.81314628329268093e-6, 2.70955155582305334e-6, 2.03349952494145258e-6, 1.59306067282707386e-6, 1.29114883574113633e-6, 1.07525760723391175e-6, 9.15320739615336091e-7, 7.93254318671509047e-7, 6.9770864858822121e-7, 6.21291700085088331e-7, 5.59030404544241632e-7, 5.07482268634552735e-7, 4.64203452842867453e-7, 4.27419777113590858e-7, 3.95817233542646864e-7, 3.68405059907551821e-7, 3.44424101601709934e-7, 3.2328415578506504e-7, 3.04520289477292887e-7, 2.87761840113930351e-7, 2.7271005599405736e-7, 2.59121726305159717e-7, 2.46797030694957914e-7, 2.35570405876158167e-7, 2.2530359927476392e-7, 2.15880328381672691e-7, 2.07202133030639347e-7, 1.991851237628123e-7,
      2.5992487399895838e-1, 1.11791799665692343e-2, 1.44209032789178577e-3, 3.09742445730548181e-4, 9.28712836081786507e-5, 3.55656677956956652e-5, 1.64422610550094055e-5, 8.80901580608338201e-6, 5.29872949968030496e-6, 3.48983334498415245e-6, 2.46740031531248416e-6, 1.84411313539262484e-6, 1.43977745764932179e-6, 1.1636412996795443e-6, 9.66818876028561556e-7, 8.21418115318049261e-7, 7.10717649512941389e-7, 6.24254030548104345e-7, 5.5523074604301128e-7, 4.99086510963775379e-7, 4.52670868985101074e-7, 4.13751802352924914e-7, 3.80711882902887376e-7, 3.5235520459984052e-7, 3.27781436236940414e-7, 3.06301683953825398e-7, 2.87381060557481956e-7, 2.70598709069372209e-7, 2.55619474199218567e-7, 2.42173497018142733e-7, 2.30041294640291674e-7, 2.19042698897813003e-7, 2.09028550833487286e-7, 1.99874390558840163e-7, 1.91475610484243059e-7, 1.83743694612005645e-7, 1.76603272850269289e-7,
      2.5853864294198185e-1, 1.10013086645597723e-2, 1.40408666675966455e-3, 2.98406128041324362e-4, 8.85512158068966089e-5, 3.35775156355263514e-5, 1.53814190282378571e-5, 8.17315415063369868e-6, 4.88119095456618115e-6, 3.1953583574648875e-6, 2.24776527509075061e-6, 1.67292535956193785e-6, 1.30161525288188712e-6, 1.04898112744029595e-6, 8.69496409093096484e-7, 7.37279618574449991e-7, 6.36865674408839425e-7, 5.58606060778360757e-7, 4.96250523406059712e-7, 4.45614661226552601e-7, 4.03814764282354391e-7, 3.68811936526651353e-7, 3.3913142312535255e-7, 3.13684647380452831e-7, 2.9165334466727914e-7, 2.72412300489210835e-7, 2.55476702031894865e-7, 2.40465548105966154e-7, 2.27075758239485755e-7, 2.15063548614913396e-7, 2.04230831535304984e-7, 1.94415144529931098e-7, 1.85482096944061103e-7, 1.7731963719845738e-7, 1.69833653833890265e-7, 1.62944565418647023e-7, 1.56584651809519803e-7,
      2.5717435254091554e-1, 1.08281006415238759e-2, 1.36746693136202693e-3, 2.87594625351016704e-4, 8.44715820098370097e-5, 3.17171340364229533e-5, 1.43968913548279807e-5, 7.58725401639056015e-6, 4.49880023252086134e-6, 2.92704417807859779e-6, 2.04848566989496474e-6, 1.51814291976026586e-6, 1.17705189183150187e-6, 9.45852318833667427e-7, 7.82135068842992639e-7, 6.61878411493003838e-7, 5.70775832959796783e-7, 4.99928326913067304e-7, 4.43586809198712012e-7, 3.97911882815343118e-7, 3.60263524476228894e-7, 3.28778938106839549e-7, 3.02113246951838115e-7, 2.79275426919779782e-7, 2.5952169859965071e-7, 2.42284568753471134e-7, 2.27124559281645577e-7, 2.13696712355337694e-7, 2.01726924465500118e-7, 1.90994946149286795e-7, 1.81321983129262127e-7, 1.72561526206191341e-7, 1.64592481157983543e-7, 1.57313960074988838e-7, 1.50641288485739232e-7, 1.44502912927497333e-7, 1.38837982920604854e-7,
      2.55831430529383064e-1, 1.0659386929876239e-2, 1.33216735738647453e-3, 2.77278857274126852e-4, 8.06169911902316565e-5, 2.99753628482815291e-5, 1.34826991240736921e-5, 7.04711984415124115e-6, 4.14844105453918364e-6, 2.68247023224324634e-6, 1.86761341913722795e-6, 1.37815289368973238e-6, 1.06472100839731812e-6, 8.53075535691864307e-7, 7.03701129598005272e-7, 5.9429668354224763e-7, 5.11624368186727782e-7, 4.47474658201408627e-7, 3.96558361821712175e-7, 3.55351959753130863e-7, 3.21438086543495579e-7, 2.93114549789796207e-7, 2.69154720318042798e-7, 2.48656252540988173e-7, 2.30942979837426432e-7, 2.15499735779403559e-7, 2.0192809047589049e-7, 1.89915685078916091e-7, 1.79214596917173969e-7, 1.69625819622946104e-7, 1.60987958517733765e-7, 1.53168879843897912e-7, 1.46059461534889945e-7, 1.39568860268318195e-7, 1.33620886860379553e-7, 1.28151201668249143e-7, 1.23105123546561641e-7
   }; // 28.04 kb
} // namespace ir
// kate: syntax c++;
