// bond torsion coordinate: dihedral X=B-A,Y=C-B,Z=D-C.  plane defined by X,Y  and Y,Z
void pc_torsion_hess(void *, double *dVdXX, index_t nb, double const &Factor, double const *pXyz, index_t const *iAtom)
{
   index_t iAx = 3.0*iAtom[0] + 0;
   index_t iAy = 3.0*iAtom[0] + 1;
   index_t iAz = 3.0*iAtom[0] + 2;
   index_t iBx = 3.0*iAtom[1] + 0;
   index_t iBy = 3.0*iAtom[1] + 1;
   index_t iBz = 3.0*iAtom[1] + 2;
   index_t iCx = 3.0*iAtom[2] + 0;
   index_t iCy = 3.0*iAtom[2] + 1;
   index_t iCz = 3.0*iAtom[2] + 2;
   index_t iDx = 3.0*iAtom[3] + 0;
   index_t iDy = 3.0*iAtom[3] + 1;
   index_t iDz = 3.0*iAtom[3] + 2;
   double Ax = pXyz[iAx];
   double Ay = pXyz[iAy];
   double Az = pXyz[iAz];
   double Bx = pXyz[iBx];
   double By = pXyz[iBy];
   double Bz = pXyz[iBz];
   double Cx = pXyz[iCx];
   double Cy = pXyz[iCy];
   double Cz = pXyz[iCz];
   double Dx = pXyz[iDx];
   double Dy = pXyz[iDy];
   double Dz = pXyz[iDz];
   double r1 = -1.0*Bx;
   double r2 = Cx + r1;
   double r3 = sqr(r2);
   double r4 = -1.0*By;
   double r5 = Cy + r4;
   double r6 = sqr(r5);
   double r7 = -1.0*Bz;
   double r8 = Cz + r7;
   double r9 = sqr(r8);
   double r10 = r9 + r6 + r3;
   double r11 = sqrt(r10);
   double r12 = -1.0*Cy;
   double r13 = r12 + By;
   double r14 = -1.0*Cx;
   double r15 = Dx + r14;
   double r16 = -1.0*r15*r5;
   double r17 = Dy + r12;
   double r18 = r2*r17;
   double r19 = r18 + r16;
   double r20 = r8*r15;
   double r21 = -1.0*Cz;
   double r22 = Dz + r21;
   double r23 = -1.0*r2*r22;
   double r24 = r23 + r20;
   double r25 = r8*r24 + r13*r19;
   double r26 = -1.0*Az;
   double r27 = Bz + r26;
   double r28 = -1.0*Ay;
   double r29 = By + r28;
   double r30 = -1.0*Ax;
   double r31 = Bx + r30;
   double r32 = -1.0*r17*r8;
   double r33 = r5*r22;
   double r34 = r33 + r32;
   double r35 = r31*r34 + r29*r24 + r27*r19;
   double r36 = r8*r17;
   double r37 = -1.0*r22*r5;
   double r38 = r37 + r36;
   double r39 = -1.0*r2*r29;
   double r40 = r31*r5;
   double r41 = r40 + r39;
   double r42 = r27*r2;
   double r43 = -1.0*r31*r8;
   double r44 = r43 + r42;
   double r45 = -1.0*r27*r5;
   double r46 = r29*r8;
   double r47 = r46 + r45;
   double r48 = r47*r34 + r44*r24 + r41*r19;
   double r49 = 2.0*r25*r48 + 2.0*r10*r35*r38;
   double r50 = sqr(r35);
   double r51 = sqr(r48) + r10*r50;
   double r52 = 1.0/sqr(r51);
   double r53 = -1.0*r15*r8;
   double r54 = r2*r22;
   double r55 = r54 + r53;
   double r56 = r21 + Bz;
   double r57 = r56*r34 + r2*r19;
   double r58 = 2.0*r48*r57 + 2.0*r10*r35*r55;
   double r59 = 1.0/r51;
   double r60 = r5*r15;
   double r61 = -1.0*r17*r2;
   double r62 = r61 + r60;
   double r63 = r14 + Bx;
   double r64 = r5*r34 + r63*r24;
   double r65 = 2.0*r48*r64 + 2.0*r10*r35*r62;
   double r66 = -1.0*Dy;
   double r67 = r66 + Cy;
   double r68 = r33 + r29*r22 + r32 + r27*r67;
   double r69 = Cy + r28;
   double r70 = r21 + Az;
   double r71 = r70*r24 + r44*r22 + r69*r19 + r41*r67;
   double r72 = 2.0*r48*r71 + 2.0*r10*r35*r68 - 2.0*r2*r50;
   double r73 = -1.0*r11*(r8*r22 + r13*r67)*r35*r59;
   double r74 = 1.0/r11;
   double r75 = -1.0*r2*r38*r48*r59*r74;
   double r76 = -1.0*Dz;
   double r77 = r76 + Cz;
   double r78 = r23 + r31*r77 + r20 + r27*r15;
   double r79 = r14 + Ax;
   double r80 = Cz + r26;
   double r81 = r80*r34 + r47*r77 + r79*r19 + r41*r15;
   double r82 = 2.0*r48*r81 + 2.0*r10*r35*r78 - 2.0*r5*r50;
   double r83 = -1.0*r11*(r18 + r16 + r13*r15)*r35*r59;
   double r84 = -1.0*Dx;
   double r85 = r84 + Cx;
   double r86 = r18 + r31*r17 + r16 + r29*r85;
   double r87 = Cx + r30;
   double r88 = r12 + Ay;
   double r89 = r88*r34 + r87*r24 + r47*r17 + r44*r85;
   double r90 = 2.0*r48*r89 + 2.0*r10*r35*r86 - 2.0*r50*r8;
   double r91 = -1.0*r11*r35*(r54 + r53 + r8*r85)*r59;
   double r92 = Dy + r4;
   double r93 = r76 + Bz;
   double r94 = r29*r93 + r27*r92;
   double r95 = r4 + Ay;
   double r96 = r27*r24 + r44*r93 + r95*r19 + r41*r92;
   double r97 = 2.0*r48*r96 + 2.0*r10*r35*r94 + 2.0*r2*r50;
   double r98 = -1.0*r11*r35*r59*(r8*r93 + r13*r92);
   double r99 = r2*r74*r38*r48*r59;
   double r100 = r84 + Bx;
   double r101 = Dz + r7;
   double r102 = r31*r101 + r27*r100;
   double r103 = r7 + Az;
   double r104 = r103*r34 + r47*r101 + r31*r19 + r41*r100;
   double r105 = 2.0*r5*r50 + 2.0*r104*r48 + 2.0*r10*r102*r35;
   double r106 = -1.0*r11*r35*r59*(r61 + r60 + r13*r100);
   double r107 = Dx + r1;
   double r108 = r66 + By;
   double r109 = r31*r108 + r29*r107;
   double r110 = r1 + Ax;
   double r111 = r29*r34 + r110*r24 + r47*r108 + r44*r107;
   double r112 = 2.0*r50*r8 + 2.0*r111*r48 + 2.0*r10*r109*r35;
   double r113 = -1.0*r11*(r23 + r20 + r8*r107)*r35*r59;
   double r114 = r46 + r27*r13;
   double r115 = r8*r44 + r13*r41;
   double r116 = 2.0*r115*r48 + 2.0*r10*r114*r35;
   double r117 = -1.0*r11*r35*r59*(r9 + sqr(r13));
   double r118 = r31*r56 + r42;
   double r119 = r56*r47 + r2*r41;
   double r120 = 2.0*r119*r48 + 2.0*r10*r118*r35;
   double r121 = -1.0*r11*r13*r2*r35*r59;
   double r122 = r8*r11*r48*r59;
   double r123 = r40 + r29*r63;
   double r124 = r5*r47 + r63*r44;
   double r125 = 2.0*r124*r48 + 2.0*r10*r123*r35;
   double r126 = -1.0*r11*r35*r59*r63*r8;
   double r127 = r13*r11*r48*r59;
   double r128 = -1.0*r11*r35*r59*(r61 + r2*r67 + r60);
   double r129 = -1.0*r11*r35*r59*(r56*r77 + r2*r15);
   double r130 = -1.0*r48*r5*r55*r59*r74;
   double r131 = -1.0*r11*(r33 + r32 + r56*r17)*r35*r59;
   double r132 = -1.0*r11*(r18 + r2*r92 + r16)*r35*r59;
   double r133 = -1.0*(r56*r101 + r2*r100)*r11*r35*r59;
   double r134 = r5*r74*r55*r48*r59;
   double r135 = -1.0*r11*r35*(r37 + r36 + r56*r108)*r59;
   double r136 = r56*r11*r48*r59;
   double r137 = -1.0*r11*r35*(sqr(r56) + r3)*r59;
   double r138 = -1.0*r11*r35*r5*r56*r59;
   double r139 = r2*r11*r48*r59;
   double r140 = -1.0*r11*(r23 + r63*r22 + r20)*r35*r59;
   double r141 = -1.0*r11*r35*(r37 + r5*r77 + r36)*r59;
   double r142 = -1.0*r11*(r5*r17 + r63*r85)*r35*r59;
   double r143 = -1.0*r48*r59*r62*r74*r8;
   double r144 = -1.0*r11*r35*(r54 + r63*r93 + r53)*r59;
   double r145 = -1.0*r11*(r33 + r5*r101 + r32)*r35*r59;
   double r146 = -1.0*(r5*r108 + r63*r107)*r11*r35*r59;
   double r147 = r8*r74*r62*r48*r59;
   double r148 = r5*r11*r48*r59;
   double r149 = r63*r11*r48*r59;
   double r150 = -1.0*r11*r35*r59*(r6 + sqr(r63));
   double r151 = r11*r68 - 1.0*r2*r35*r74;
   double r152 = 1.0/pow(r11,3);
   double r153 = -1.0*r152*r3*r35;
   double r154 = r74*r35;
   double r155 = -1.0*r11*r35*r59*(r79*r67 + r69*r15);
   double r156 = -1.0*r152*r2*r35*r5;
   double r157 = r48*r59*((-1.0*r2*r74*r78) - 1.0*r5*r68*r74 + r156);
   double r158 = -1.0*r11*(r87*r22 + r70*r85)*r35*r59;
   double r159 = -1.0*r152*r2*r35*r8;
   double r160 = r48*r59*((-1.0*r2*r74*r86) - 1.0*r68*r74*r8 + r159);
   double r161 = -1.0*r11*(r27*r22 + r70*r93 + r69*r92 + r95*r67)*r35*r59;
   double r162 = -1.0*r35*r74;
   double r163 = r48*r59*((-1.0*r2*r74*r94) + r2*r74*r68 + r3*r152*r35 + r162);
   double r164 = -1.0*r11*(r18 + r31*r67 + r16 + r69*r100 + r40 + r39)*r35*r59;
   double r165 = r2*r5*r152*r35;
   double r166 = r48*r59*(r11*(Dz + r26) - 1.0*r102*r2*r74 + r5*r74*r68 + r165);
   double r167 = -1.0*r2*r27;
   double r168 = r31*r8;
   double r169 = -1.0*r11*r35*(r54 + r110*r22 + r53 + r70*r107 + r168 + r167)*r59;
   double r170 = r2*r8*r152*r35;
   double r171 = r48*r59*((-1.0*r109*r2*r74) + r8*r74*r68 + r11*(r66 + Ay) + r170);
   double r172 = -1.0*r11*r35*r59*(r70*r8 + r13*r69);
   double r173 = -1.0*r114*r2*r48*r59*r74;
   double r174 = r29*r2;
   double r175 = -1.0*r31*r5;
   double r176 = -1.0*r11*(r175 + r2*r69 + r174)*r35*r59;
   double r177 = -1.0*r11*r35*(r43 + r63*r70 + r42)*r59;
   double r178 = r11*r78 - 1.0*r35*r5*r74;
   double r179 = -1.0*r152*r35*r6;
   double r180 = -1.0*r11*r35*r59*(r88*r77 + r80*r17);
   double r181 = -1.0*r152*r35*r5*r8;
   double r182 = r48*r59*((-1.0*r5*r74*r86) - 1.0*r74*r78*r8 + r181);
   double r183 = -1.0*r11*r35*r59*(r61 + r79*r92 + r60 + r95*r15 + r175 + r174);
   double r184 = r48*r59*((-1.0*r5*r74*r94) + r2*r74*r78 + r11*(r76 + Az) + r165);
   double r185 = -1.0*(r80*r101 + r103*r77 + r31*r15 + r79*r100)*r11*r35*r59;
   double r186 = r48*r59*(r5*r74*r78 - 1.0*r102*r5*r74 + r6*r152*r35 + r162);
   double r187 = -1.0*r11*(r33 + r29*r77 + r32 + r80*r108 + r46 + r45)*r35*r59;
   double r188 = r5*r8*r152*r35;
   double r189 = r48*r59*(r11*(Dx + r30) + r8*r74*r78 - 1.0*r109*r5*r74 + r188);
   double r190 = -1.0*r11*r35*(r40 + r79*r13 + r39)*r59;
   double r191 = -1.0*r11*r35*r59*(r56*r80 + r79*r2);
   double r192 = -1.0*r118*r48*r5*r59*r74;
   double r193 = r27*r5;
   double r194 = -1.0*r29*r8;
   double r195 = -1.0*r11*(r194 + r5*r80 + r193)*r35*r59;
   double r196 = r11*r86 - 1.0*r35*r74*r8;
   double r197 = -1.0*r152*r35*r9;
   double r198 = -1.0*r11*(r23 + r87*r93 + r20 + r27*r85 + r43 + r42)*r35*r59;
   double r199 = r48*r59*(r11*(Dy + r28) - 1.0*r74*r8*r94 + r2*r74*r86 + r170);
   double r200 = -1.0*r11*r35*(r37 + r88*r101 + r36 + r103*r17 + r194 + r193)*r59;
   double r201 = r48*r59*(r5*r74*r86 + r11*(r84 + Ax) - 1.0*r102*r74*r8 + r188);
   double r202 = -1.0*r11*(r29*r17 + r88*r108 + r87*r107 + r110*r85)*r35*r59;
   double r203 = r48*r59*(r8*r74*r86 - 1.0*r109*r74*r8 + r9*r152*r35 + r162);
   double r204 = -1.0*r11*r35*r59*(r87*r8 + r168 + r167);
   double r205 = -1.0*r11*r35*(r46 + r88*r56 + r45)*r59;
   double r206 = -1.0*r11*r35*(r88*r5 + r63*r87)*r59;
   double r207 = -1.0*r123*r48*r59*r74*r8;
   double r208 = r2*r74*r35 + r11*r94;
   double r209 = -1.0*r11*r35*r59*(r31*r92 + r95*r100);
   double r210 = r48*(r156 + r2*r74*r102 + r5*r74*r94)*r59;
   double r211 = -1.0*r11*r35*r59*(r110*r93 + r27*r107);
   double r212 = r48*(r159 + r8*r74*r94 + r2*r74*r109)*r59;
   double r213 = -1.0*r11*r35*r59*(r27*r8 + r95*r13);
   double r214 = r2*r114*r74*r48*r59;
   double r215 = -1.0*r11*r35*(r40 + r39 + r95*r2)*r59;
   double r216 = -1.0*r11*(r168 + r167 + r27*r63)*r35*r59;
   double r217 = r5*r74*r35 + r11*r102;
   double r218 = -1.0*(r29*r101 + r103*r108)*r11*r35*r59;
   double r219 = r48*(r181 + r8*r74*r102 + r5*r74*r109)*r59;
   double r220 = -1.0*r11*(r175 + r31*r13 + r174)*r35*r59;
   double r221 = -1.0*r11*r35*(r103*r56 + r31*r2)*r59;
   double r222 = r5*r118*r74*r48*r59;
   double r223 = -1.0*r11*r35*(r46 + r45 + r103*r5)*r59;
   double r224 = r8*r74*r35 + r11*r109;
   double r225 = -1.0*r11*r35*(r43 + r110*r8 + r42)*r59;
   double r226 = -1.0*r11*(r194 + r29*r56 + r193)*r35*r59;
   double r227 = -1.0*r11*r35*(r29*r5 + r110*r63)*r59;
   double r228 = r123*r8*r74*r48*r59;
   dVdXX[iAx + nb*(iAx)] += Factor*(r11*r25*r35*r49*r52 - 1.0*r11*r38*r48*r49*r52);
   dVdXX[iAx + nb*(iAy)] += Factor*(r11*r38*r57*r59 - 1.0*r11*r25*r55*r59 - 1.0*r11*r38*r48*r52*r58 + r11*r25*r35*r58*r52);
   dVdXX[iAx + nb*(iAz)] += Factor*((-1.0*r11*r38*r48*r52*r65) - 1.0*r11*r25*r59*r62 + r11*r38*r64*r59 + r11*r25*r35*r65*r52);
   dVdXX[iAx + nb*(iBx)] += Factor*(r75 + r73 - 1.0*r11*r38*r48*r52*r72 - 1.0*r11*r25*r59*r68 + r11*r38*r71*r59 + r2*r74*r25*r35*r59 + r11*r25*r35*r72*r52);
   dVdXX[iAx + nb*(iBy)] += Factor*(r83 - 1.0*r11*r38*r48*r52*r82 - 1.0*r11*r25*r59*r78 - 1.0*r38*r48*r5*r59*r74 + r11*r38*r81*r59 + r11*r22*r48*r59 + r5*r74*r25*r35*r59 + r11*r25*r35*r82*r52);
   dVdXX[iAx + nb*(iBz)] += Factor*(r91 - 1.0*r11*r38*r48*r52*r90 - 1.0*r11*r25*r59*r86 - 1.0*r38*r48*r59*r74*r8 + r11*r38*r89*r59 + r11*r67*r48*r59 + r8*r74*r25*r35*r59 + r11*r25*r35*r90*r52);
   dVdXX[iAx + nb*(iCx)] += Factor*(r99 + r98 - 1.0*r11*r38*r48*r52*r97 - 1.0*r11*r25*r59*r94 - 1.0*r2*r25*r35*r59*r74 + r11*r38*r96*r59 + r11*r25*r35*r97*r52);
   dVdXX[iAx + nb*(iCy)] += Factor*((-1.0*r25*r35*r5*r59*r74) + r11*r93*r48*r59 + r5*r74*r38*r48*r59 - 1.0*r102*r11*r25*r59 + r11*r38*r104*r59 - 1.0*r105*r11*r38*r48*r52 + r11*r25*r35*r105*r52 + r106);
   dVdXX[iAx + nb*(iCz)] += Factor*((-1.0*r25*r35*r59*r74*r8) + r11*r92*r48*r59 + r8*r74*r38*r48*r59 - 1.0*r109*r11*r25*r59 + r11*r38*r111*r59 - 1.0*r11*r112*r38*r48*r52 + r11*r25*r35*r112*r52 + r113);
   dVdXX[iAx + nb*(iDx)] += Factor*(r115*r11*r38*r59 - 1.0*r11*r114*r25*r59 - 1.0*r11*r116*r38*r48*r52 + r11*r25*r35*r116*r52 + r117);
   dVdXX[iAx + nb*(iDy)] += Factor*(r119*r11*r38*r59 - 1.0*r11*r118*r25*r59 - 1.0*r11*r120*r38*r48*r52 + r11*r25*r35*r120*r52 + r122 + r121);
   dVdXX[iAx + nb*(iDz)] += Factor*(r124*r11*r38*r59 - 1.0*r11*r123*r25*r59 - 1.0*r11*r125*r38*r48*r52 + r11*r25*r35*r125*r52 + r127 + r126);
   dVdXX[iAy + nb*(iAx)] += Factor*((-1.0*r11*r38*r57*r59) + r11*r55*r25*r59 - 1.0*r11*r48*r49*r52*r55 + r11*r35*r57*r49*r52);
   dVdXX[iAy + nb*(iAy)] += Factor*(r11*r35*r57*r58*r52 - 1.0*r11*r48*r52*r55*r58);
   dVdXX[iAy + nb*(iAz)] += Factor*((-1.0*r11*r48*r52*r55*r65) - 1.0*r11*r57*r59*r62 + r11*r55*r64*r59 + r11*r35*r57*r65*r52);
   dVdXX[iAy + nb*(iBx)] += Factor*((-1.0*r2*r48*r55*r59*r74) - 1.0*r11*r48*r52*r55*r72 - 1.0*r11*r57*r59*r68 + r11*r55*r71*r59 + r2*r74*r35*r57*r59 + r11*r77*r48*r59 + r11*r35*r57*r72*r52 + r128);
   dVdXX[iAy + nb*(iBy)] += Factor*((-1.0*r11*r48*r52*r55*r82) - 1.0*r11*r57*r59*r78 + r11*r55*r81*r59 + r5*r74*r35*r57*r59 + r11*r35*r57*r82*r52 + r130 + r129);
   dVdXX[iAy + nb*(iBz)] += Factor*((-1.0*r11*r48*r52*r55*r90) - 1.0*r11*r57*r59*r86 - 1.0*r48*r55*r59*r74*r8 + r11*r55*r89*r59 + r8*r74*r35*r57*r59 + r11*r15*r48*r59 + r11*r35*r57*r90*r52 + r131);
   dVdXX[iAy + nb*(iCx)] += Factor*((-1.0*r11*r48*r52*r55*r97) - 1.0*r11*r57*r59*r94 - 1.0*r2*r35*r57*r59*r74 + r11*r55*r96*r59 + r2*r74*r55*r48*r59 + r11*r101*r48*r59 + r11*r35*r57*r97*r52 + r132);
   dVdXX[iAy + nb*(iCy)] += Factor*((-1.0*r35*r5*r57*r59*r74) - 1.0*r102*r11*r57*r59 + r11*r55*r104*r59 - 1.0*r105*r11*r48*r52*r55 + r11*r35*r57*r105*r52 + r134 + r133);
   dVdXX[iAy + nb*(iCz)] += Factor*((-1.0*r35*r57*r59*r74*r8) - 1.0*r109*r11*r57*r59 + r8*r74*r55*r48*r59 + r11*r100*r48*r59 + r11*r55*r111*r59 - 1.0*r11*r112*r48*r52*r55 + r11*r35*r57*r112*r52 + r135);
   dVdXX[iAy + nb*(iDx)] += Factor*((-1.0*r11*r114*r57*r59) + r115*r11*r55*r59 - 1.0*r11*r116*r48*r52*r55 + r11*r35*r57*r116*r52 + r136 + r121);
   dVdXX[iAy + nb*(iDy)] += Factor*((-1.0*r11*r118*r57*r59) + r119*r11*r55*r59 - 1.0*r11*r120*r48*r52*r55 + r11*r35*r57*r120*r52 + r137);
   dVdXX[iAy + nb*(iDz)] += Factor*((-1.0*r11*r123*r57*r59) + r124*r11*r55*r59 - 1.0*r11*r125*r48*r52*r55 + r11*r35*r57*r125*r52 + r139 + r138);
   dVdXX[iAz + nb*(iAx)] += Factor*((-1.0*r11*r38*r59*r64) - 1.0*r11*r48*r49*r52*r62 + r11*r62*r25*r59 + r11*r35*r64*r49*r52);
   dVdXX[iAz + nb*(iAy)] += Factor*((-1.0*r11*r55*r59*r64) - 1.0*r11*r48*r52*r58*r62 + r11*r62*r57*r59 + r11*r35*r64*r58*r52);
   dVdXX[iAz + nb*(iAz)] += Factor*(r11*r35*r64*r65*r52 - 1.0*r11*r48*r52*r62*r65);
   dVdXX[iAz + nb*(iBx)] += Factor*((-1.0*r2*r48*r59*r62*r74) - 1.0*r11*r48*r52*r62*r72 - 1.0*r11*r59*r64*r68 + r11*r62*r71*r59 + r2*r74*r35*r64*r59 + r11*r17*r48*r59 + r11*r35*r64*r72*r52 + r140);
   dVdXX[iAz + nb*(iBy)] += Factor*((-1.0*r11*r48*r52*r62*r82) - 1.0*r11*r59*r64*r78 - 1.0*r48*r5*r59*r62*r74 + r11*r62*r81*r59 + r5*r74*r35*r64*r59 + r11*r85*r48*r59 + r11*r35*r64*r82*r52 + r141);
   dVdXX[iAz + nb*(iBz)] += Factor*((-1.0*r11*r48*r52*r62*r90) - 1.0*r11*r59*r64*r86 + r11*r62*r89*r59 + r8*r74*r35*r64*r59 + r11*r35*r64*r90*r52 + r143 + r142);
   dVdXX[iAz + nb*(iCx)] += Factor*((-1.0*r11*r48*r52*r62*r97) - 1.0*r11*r59*r64*r94 - 1.0*r2*r35*r59*r64*r74 + r11*r62*r96*r59 + r2*r74*r62*r48*r59 + r11*r108*r48*r59 + r11*r35*r64*r97*r52 + r144);
   dVdXX[iAz + nb*(iCy)] += Factor*((-1.0*r35*r5*r59*r64*r74) - 1.0*r102*r11*r59*r64 - 1.0*r105*r11*r48*r52*r62 + r5*r74*r62*r48*r59 + r11*r107*r48*r59 + r11*r62*r104*r59 + r11*r35*r64*r105*r52 + r145);
   dVdXX[iAz + nb*(iCz)] += Factor*((-1.0*r35*r59*r64*r74*r8) - 1.0*r109*r11*r59*r64 - 1.0*r11*r112*r48*r52*r62 + r11*r62*r111*r59 + r11*r35*r64*r112*r52 + r147 + r146);
   dVdXX[iAz + nb*(iDx)] += Factor*((-1.0*r11*r114*r59*r64) - 1.0*r11*r116*r48*r52*r62 + r115*r11*r62*r59 + r11*r35*r64*r116*r52 + r148 + r126);
   dVdXX[iAz + nb*(iDy)] += Factor*((-1.0*r11*r118*r59*r64) - 1.0*r11*r120*r48*r52*r62 + r119*r11*r62*r59 + r11*r35*r64*r120*r52 + r149 + r138);
   dVdXX[iAz + nb*(iDz)] += Factor*((-1.0*r11*r123*r59*r64) - 1.0*r11*r125*r48*r52*r62 + r124*r11*r62*r59 + r11*r35*r64*r125*r52 + r150);
   dVdXX[iBx + nb*(iAx)] += Factor*(r75 + r73 - 1.0*r11*r38*r59*r71 + r25*r151*r59 - 1.0*r151*r48*r49*r52 + r11*r71*r35*r49*r52);
   dVdXX[iBx + nb*(iAy)] += Factor*(r48*r59*(r11*r77 - 1.0*r2*r55*r74) - 1.0*r11*r55*r59*r71 + r57*r151*r59 - 1.0*r151*r48*r52*r58 + r11*r71*r35*r58*r52 + r128);
   dVdXX[iBx + nb*(iAz)] += Factor*(r48*r59*(r11*r17 - 1.0*r2*r62*r74) - 1.0*r11*r59*r62*r71 - 1.0*r151*r48*r52*r65 + r64*r151*r59 + r11*r71*r35*r65*r52 + r140);
   dVdXX[iBx + nb*(iBx)] += Factor*(r48*r59*((-2.0*r2*r68*r74) + r154 + r153) - 1.0*r151*r48*r52*r72 - 1.0*r11*r59*r68*r71 - 1.0*r11*r35*r59*(2.0*r22*r70 + 2.0*r67*r69) + r2*r74*r71*r35*r59 + r71*r151*r59 + r11*r71*r35*r72*r52);
   dVdXX[iBx + nb*(iBy)] += Factor*((-1.0*r151*r48*r52*r82) - 1.0*r11*r59*r71*r78 + r5*r74*r71*r35*r59 + r81*r151*r59 + r11*r71*r35*r82*r52 + r157 + r155);
   dVdXX[iBx + nb*(iBz)] += Factor*((-1.0*r151*r48*r52*r90) - 1.0*r11*r59*r71*r86 + r8*r74*r71*r35*r59 + r89*r151*r59 + r11*r71*r35*r90*r52 + r160 + r158);
   dVdXX[iBx + nb*(iCx)] += Factor*((-1.0*r151*r48*r52*r97) - 1.0*r11*r59*r71*r94 - 1.0*r2*r35*r59*r71*r74 + r96*r151*r59 + r11*r71*r35*r97*r52 + r163 + r161);
   dVdXX[iBx + nb*(iCy)] += Factor*((-1.0*r35*r5*r59*r71*r74) - 1.0*r102*r11*r59*r71 + r104*r151*r59 - 1.0*r105*r151*r48*r52 + r11*r71*r35*r105*r52 + r166 + r164);
   dVdXX[iBx + nb*(iCz)] += Factor*((-1.0*r35*r59*r71*r74*r8) - 1.0*r109*r11*r59*r71 + r111*r151*r59 - 1.0*r112*r151*r48*r52 + r11*r71*r35*r112*r52 + r171 + r169);
   dVdXX[iBx + nb*(iDx)] += Factor*((-1.0*r11*r114*r59*r71) + r115*r151*r59 - 1.0*r116*r151*r48*r52 + r11*r71*r35*r116*r52 + r173 + r172);
   dVdXX[iBx + nb*(iDy)] += Factor*(r48*r59*(r70*r11 - 1.0*r118*r2*r74) - 1.0*r11*r118*r59*r71 + r119*r151*r59 - 1.0*r120*r151*r48*r52 + r11*r71*r35*r120*r52 + r176);
   dVdXX[iBx + nb*(iDz)] += Factor*(r48*r59*(r69*r11 - 1.0*r123*r2*r74) - 1.0*r11*r123*r59*r71 + r124*r151*r59 - 1.0*r125*r151*r48*r52 + r11*r71*r35*r125*r52 + r177);
   dVdXX[iBy + nb*(iAx)] += Factor*(r83 - 1.0*r11*r38*r59*r81 + r48*r59*(r11*r22 - 1.0*r38*r5*r74) + r25*r178*r59 + r11*r35*r81*r49*r52 - 1.0*r178*r48*r49*r52);
   dVdXX[iBy + nb*(iAy)] += Factor*((-1.0*r11*r55*r59*r81) + r57*r178*r59 - 1.0*r178*r48*r52*r58 + r11*r35*r81*r58*r52 + r130 + r129);
   dVdXX[iBy + nb*(iAz)] += Factor*(r48*r59*(r11*r85 - 1.0*r5*r62*r74) - 1.0*r11*r59*r62*r81 - 1.0*r178*r48*r52*r65 + r64*r178*r59 + r11*r35*r81*r65*r52 + r141);
   dVdXX[iBy + nb*(iBx)] += Factor*((-1.0*r11*r59*r68*r81) - 1.0*r178*r48*r52*r72 + r2*r74*r35*r81*r59 + r71*r178*r59 + r11*r35*r81*r72*r52 + r157 + r155);
   dVdXX[iBy + nb*(iBy)] += Factor*((-1.0*r178*r48*r52*r82) - 1.0*r11*r59*r78*r81 - 1.0*r11*r35*r59*(2.0*r77*r80 + 2.0*r15*r79) + r48*r59*((-2.0*r5*r74*r78) + r179 + r154) + r5*r74*r35*r81*r59 + r81*r178*r59 + r11*r35*r81*r82*r52);
   dVdXX[iBy + nb*(iBz)] += Factor*((-1.0*r178*r48*r52*r90) - 1.0*r11*r59*r81*r86 + r8*r74*r35*r81*r59 + r89*r178*r59 + r11*r35*r81*r90*r52 + r182 + r180);
   dVdXX[iBy + nb*(iCx)] += Factor*((-1.0*r178*r48*r52*r97) - 1.0*r11*r59*r81*r94 - 1.0*r2*r35*r59*r74*r81 + r96*r178*r59 + r11*r35*r81*r97*r52 + r184 + r183);
   dVdXX[iBy + nb*(iCy)] += Factor*((-1.0*r35*r5*r59*r74*r81) - 1.0*r102*r11*r59*r81 + r104*r178*r59 - 1.0*r105*r178*r48*r52 + r11*r35*r81*r105*r52 + r186 + r185);
   dVdXX[iBy + nb*(iCz)] += Factor*((-1.0*r35*r59*r74*r8*r81) - 1.0*r109*r11*r59*r81 + r111*r178*r59 - 1.0*r112*r178*r48*r52 + r11*r35*r81*r112*r52 + r189 + r187);
   dVdXX[iBy + nb*(iDx)] += Factor*((-1.0*r11*r114*r59*r81) + r48*r59*(r80*r11 - 1.0*r114*r5*r74) + r115*r178*r59 - 1.0*r116*r178*r48*r52 + r11*r35*r81*r116*r52 + r190);
   dVdXX[iBy + nb*(iDy)] += Factor*((-1.0*r11*r118*r59*r81) + r119*r178*r59 - 1.0*r120*r178*r48*r52 + r11*r35*r81*r120*r52 + r192 + r191);
   dVdXX[iBy + nb*(iDz)] += Factor*((-1.0*r11*r123*r59*r81) + r48*r59*(r79*r11 - 1.0*r123*r5*r74) + r124*r178*r59 - 1.0*r125*r178*r48*r52 + r11*r35*r81*r125*r52 + r195);
   dVdXX[iBz + nb*(iAx)] += Factor*(r91 - 1.0*r11*r38*r59*r89 + r48*r59*(r11*r67 - 1.0*r38*r74*r8) + r25*r196*r59 + r11*r35*r89*r49*r52 - 1.0*r196*r48*r49*r52);
   dVdXX[iBz + nb*(iAy)] += Factor*((-1.0*r11*r55*r59*r89) + r48*r59*(r11*r15 - 1.0*r55*r74*r8) + r57*r196*r59 - 1.0*r196*r48*r52*r58 + r11*r35*r89*r58*r52 + r131);
   dVdXX[iBz + nb*(iAz)] += Factor*((-1.0*r11*r59*r62*r89) - 1.0*r196*r48*r52*r65 + r64*r196*r59 + r11*r35*r89*r65*r52 + r143 + r142);
   dVdXX[iBz + nb*(iBx)] += Factor*((-1.0*r11*r59*r68*r89) - 1.0*r196*r48*r52*r72 + r2*r74*r35*r89*r59 + r71*r196*r59 + r11*r35*r89*r72*r52 + r160 + r158);
   dVdXX[iBz + nb*(iBy)] += Factor*((-1.0*r11*r59*r78*r89) - 1.0*r196*r48*r52*r82 + r5*r74*r35*r89*r59 + r81*r196*r59 + r11*r35*r89*r82*r52 + r182 + r180);
   dVdXX[iBz + nb*(iBz)] += Factor*((-1.0*r196*r48*r52*r90) - 1.0*r11*r59*r86*r89 - 1.0*r11*r35*r59*(2.0*r17*r88 + 2.0*r85*r87) + r48*r59*((-2.0*r74*r8*r86) + r197 + r154) + r8*r74*r35*r89*r59 + r89*r196*r59 + r11*r35*r89*r90*r52);
   dVdXX[iBz + nb*(iCx)] += Factor*((-1.0*r196*r48*r52*r97) - 1.0*r11*r59*r89*r94 - 1.0*r2*r35*r59*r74*r89 + r96*r196*r59 + r11*r35*r89*r97*r52 + r199 + r198);
   dVdXX[iBz + nb*(iCy)] += Factor*((-1.0*r35*r5*r59*r74*r89) - 1.0*r102*r11*r59*r89 + r104*r196*r59 - 1.0*r105*r196*r48*r52 + r11*r35*r89*r105*r52 + r201 + r200);
   dVdXX[iBz + nb*(iCz)] += Factor*((-1.0*r35*r59*r74*r8*r89) - 1.0*r109*r11*r59*r89 + r111*r196*r59 - 1.0*r112*r196*r48*r52 + r11*r35*r89*r112*r52 + r203 + r202);
   dVdXX[iBz + nb*(iDx)] += Factor*((-1.0*r11*r114*r59*r89) + r48*r59*(r88*r11 - 1.0*r114*r74*r8) + r115*r196*r59 - 1.0*r116*r196*r48*r52 + r11*r35*r89*r116*r52 + r204);
   dVdXX[iBz + nb*(iDy)] += Factor*((-1.0*r11*r118*r59*r89) + r48*r59*(r87*r11 - 1.0*r118*r74*r8) + r119*r196*r59 - 1.0*r120*r196*r48*r52 + r11*r35*r89*r120*r52 + r205);
   dVdXX[iBz + nb*(iDz)] += Factor*((-1.0*r11*r123*r59*r89) + r124*r196*r59 - 1.0*r125*r196*r48*r52 + r11*r35*r89*r125*r52 + r207 + r206);
   dVdXX[iCx + nb*(iAx)] += Factor*(r99 + r98 - 1.0*r11*r38*r59*r96 + r25*r208*r59 - 1.0*r208*r48*r49*r52 + r11*r96*r35*r49*r52);
   dVdXX[iCx + nb*(iAy)] += Factor*((-1.0*r11*r55*r59*r96) + (r2*r74*r55 + r11*r101)*r48*r59 + r57*r208*r59 - 1.0*r208*r48*r52*r58 + r11*r96*r35*r58*r52 + r132);
   dVdXX[iCx + nb*(iAz)] += Factor*((-1.0*r11*r59*r62*r96) - 1.0*r208*r48*r52*r65 + (r2*r74*r62 + r11*r108)*r48*r59 + r64*r208*r59 + r11*r96*r35*r65*r52 + r144);
   dVdXX[iCx + nb*(iBx)] += Factor*((-1.0*r11*r59*r68*r96) - 1.0*r208*r48*r52*r72 + r2*r74*r96*r35*r59 + r71*r208*r59 + r11*r96*r35*r72*r52 + r163 + r161);
   dVdXX[iCx + nb*(iBy)] += Factor*((-1.0*r11*r59*r78*r96) - 1.0*r208*r48*r52*r82 + r5*r74*r96*r35*r59 + r81*r208*r59 + r11*r96*r35*r82*r52 + r184 + r183);
   dVdXX[iCx + nb*(iBz)] += Factor*((-1.0*r11*r59*r86*r96) - 1.0*r208*r48*r52*r90 + r8*r74*r96*r35*r59 + r89*r208*r59 + r11*r96*r35*r90*r52 + r199 + r198);
   dVdXX[iCx + nb*(iCx)] += Factor*((-1.0*r208*r48*r52*r97) - 1.0*r11*r59*r94*r96 - 1.0*r2*r35*r59*r74*r96 - 1.0*r11*r35*r59*(2.0*r92*r95 + 2.0*r27*r93) + r48*r59*(2.0*r2*r74*r94 + r154 + r153) + r96*r208*r59 + r11*r96*r35*r97*r52);
   dVdXX[iCx + nb*(iCy)] += Factor*((-1.0*r35*r5*r59*r74*r96) - 1.0*r102*r11*r59*r96 + r104*r208*r59 - 1.0*r105*r208*r48*r52 + r11*r96*r35*r105*r52 + r210 + r209);
   dVdXX[iCx + nb*(iCz)] += Factor*((-1.0*r35*r59*r74*r8*r96) - 1.0*r109*r11*r59*r96 + r111*r208*r59 - 1.0*r112*r208*r48*r52 + r11*r96*r35*r112*r52 + r212 + r211);
   dVdXX[iCx + nb*(iDx)] += Factor*((-1.0*r11*r114*r59*r96) + r115*r208*r59 - 1.0*r116*r208*r48*r52 + r11*r96*r35*r116*r52 + r214 + r213);
   dVdXX[iCx + nb*(iDy)] += Factor*((-1.0*r11*r118*r59*r96) + (r27*r11 + r2*r118*r74)*r48*r59 + r119*r208*r59 - 1.0*r120*r208*r48*r52 + r11*r96*r35*r120*r52 + r215);
   dVdXX[iCx + nb*(iDz)] += Factor*((-1.0*r11*r123*r59*r96) + (r95*r11 + r2*r123*r74)*r48*r59 + r124*r208*r59 - 1.0*r125*r208*r48*r52 + r11*r96*r35*r125*r52 + r216);
   dVdXX[iCy + nb*(iAx)] += Factor*((r5*r74*r38 + r11*r93)*r48*r59 - 1.0*r104*r11*r38*r59 + r25*r217*r59 - 1.0*r217*r48*r49*r52 + r11*r35*r104*r49*r52 + r106);
   dVdXX[iCy + nb*(iAy)] += Factor*((-1.0*r104*r11*r55*r59) + r57*r217*r59 - 1.0*r217*r48*r52*r58 + r11*r35*r104*r58*r52 + r134 + r133);
   dVdXX[iCy + nb*(iAz)] += Factor*((-1.0*r217*r48*r52*r65) - 1.0*r104*r11*r59*r62 + (r5*r74*r62 + r11*r107)*r48*r59 + r64*r217*r59 + r11*r35*r104*r65*r52 + r145);
   dVdXX[iCy + nb*(iBx)] += Factor*((-1.0*r217*r48*r52*r72) - 1.0*r104*r11*r59*r68 + r71*r217*r59 + r2*r74*r35*r104*r59 + r11*r35*r104*r72*r52 + r166 + r164);
   dVdXX[iCy + nb*(iBy)] += Factor*((-1.0*r217*r48*r52*r82) - 1.0*r104*r11*r59*r78 + r81*r217*r59 + r5*r74*r35*r104*r59 + r11*r35*r104*r82*r52 + r186 + r185);
   dVdXX[iCy + nb*(iBz)] += Factor*((-1.0*r217*r48*r52*r90) - 1.0*r104*r11*r59*r86 + r89*r217*r59 + r8*r74*r35*r104*r59 + r11*r35*r104*r90*r52 + r201 + r200);
   dVdXX[iCy + nb*(iCx)] += Factor*((-1.0*r217*r48*r52*r97) - 1.0*r104*r11*r59*r94 - 1.0*r104*r2*r35*r59*r74 + r96*r217*r59 + r11*r35*r104*r97*r52 + r210 + r209);
   dVdXX[iCy + nb*(iCy)] += Factor*(r48*r59*(2.0*r102*r5*r74 + r179 + r154) - 1.0*r104*r35*r5*r59*r74 - 1.0*r11*(2.0*r100*r31 + 2.0*r101*r103)*r35*r59 + r104*r217*r59 - 1.0*r102*r104*r11*r59 - 1.0*r105*r217*r48*r52 + r11*r35*r104*r105*r52);
   dVdXX[iCy + nb*(iCz)] += Factor*((-1.0*r104*r35*r59*r74*r8) + r111*r217*r59 - 1.0*r104*r109*r11*r59 - 1.0*r112*r217*r48*r52 + r11*r35*r104*r112*r52 + r219 + r218);
   dVdXX[iCy + nb*(iDx)] += Factor*((r103*r11 + r5*r114*r74)*r48*r59 + r115*r217*r59 - 1.0*r104*r11*r114*r59 - 1.0*r116*r217*r48*r52 + r11*r35*r104*r116*r52 + r220);
   dVdXX[iCy + nb*(iDy)] += Factor*(r119*r217*r59 - 1.0*r104*r11*r118*r59 - 1.0*r120*r217*r48*r52 + r11*r35*r104*r120*r52 + r222 + r221);
   dVdXX[iCy + nb*(iDz)] += Factor*((r31*r11 + r5*r123*r74)*r48*r59 + r124*r217*r59 - 1.0*r104*r11*r123*r59 - 1.0*r125*r217*r48*r52 + r11*r35*r104*r125*r52 + r223);
   dVdXX[iCz + nb*(iAx)] += Factor*((r8*r74*r38 + r11*r92)*r48*r59 - 1.0*r11*r111*r38*r59 + r25*r224*r59 - 1.0*r224*r48*r49*r52 + r11*r35*r111*r49*r52 + r113);
   dVdXX[iCz + nb*(iAy)] += Factor*((-1.0*r11*r111*r55*r59) + (r8*r74*r55 + r11*r100)*r48*r59 + r57*r224*r59 - 1.0*r224*r48*r52*r58 + r11*r35*r111*r58*r52 + r135);
   dVdXX[iCz + nb*(iAz)] += Factor*((-1.0*r224*r48*r52*r65) - 1.0*r11*r111*r59*r62 + r64*r224*r59 + r11*r35*r111*r65*r52 + r147 + r146);
   dVdXX[iCz + nb*(iBx)] += Factor*((-1.0*r224*r48*r52*r72) - 1.0*r11*r111*r59*r68 + r71*r224*r59 + r2*r74*r35*r111*r59 + r11*r35*r111*r72*r52 + r171 + r169);
   dVdXX[iCz + nb*(iBy)] += Factor*((-1.0*r224*r48*r52*r82) - 1.0*r11*r111*r59*r78 + r81*r224*r59 + r5*r74*r35*r111*r59 + r11*r35*r111*r82*r52 + r189 + r187);
   dVdXX[iCz + nb*(iBz)] += Factor*((-1.0*r224*r48*r52*r90) - 1.0*r11*r111*r59*r86 + r89*r224*r59 + r8*r74*r35*r111*r59 + r11*r35*r111*r90*r52 + r203 + r202);
   dVdXX[iCz + nb*(iCx)] += Factor*((-1.0*r224*r48*r52*r97) - 1.0*r11*r111*r59*r94 - 1.0*r111*r2*r35*r59*r74 + r96*r224*r59 + r11*r35*r111*r97*r52 + r212 + r211);
   dVdXX[iCz + nb*(iCy)] += Factor*((-1.0*r111*r35*r5*r59*r74) + r104*r224*r59 - 1.0*r102*r11*r111*r59 - 1.0*r105*r224*r48*r52 + r11*r35*r111*r105*r52 + r219 + r218);
   dVdXX[iCz + nb*(iCz)] += Factor*(r48*r59*(2.0*r109*r74*r8 + r197 + r154) - 1.0*r111*r35*r59*r74*r8 - 1.0*r11*(2.0*r108*r29 + 2.0*r107*r110)*r35*r59 + r111*r224*r59 - 1.0*r109*r11*r111*r59 - 1.0*r112*r224*r48*r52 + r11*r35*r111*r112*r52);
   dVdXX[iCz + nb*(iDx)] += Factor*((r29*r11 + r8*r114*r74)*r48*r59 + r115*r224*r59 - 1.0*r11*r111*r114*r59 - 1.0*r116*r224*r48*r52 + r11*r35*r111*r116*r52 + r225);
   dVdXX[iCz + nb*(iDy)] += Factor*((r110*r11 + r118*r8*r74)*r48*r59 + r119*r224*r59 - 1.0*r11*r111*r118*r59 - 1.0*r120*r224*r48*r52 + r11*r35*r111*r120*r52 + r226);
   dVdXX[iCz + nb*(iDz)] += Factor*(r124*r224*r59 - 1.0*r11*r111*r123*r59 - 1.0*r125*r224*r48*r52 + r11*r35*r111*r125*r52 + r228 + r227);
   dVdXX[iDx + nb*(iAx)] += Factor*((-1.0*r11*r115*r38*r59) + r114*r11*r25*r59 - 1.0*r11*r114*r48*r49*r52 + r115*r11*r35*r49*r52 + r117);
   dVdXX[iDx + nb*(iAy)] += Factor*(r114*r11*r57*r59 - 1.0*r11*r115*r55*r59 - 1.0*r11*r114*r48*r52*r58 + r115*r11*r35*r58*r52 + r136 + r121);
   dVdXX[iDx + nb*(iAz)] += Factor*((-1.0*r11*r114*r48*r52*r65) - 1.0*r11*r115*r59*r62 + r114*r11*r64*r59 + r115*r11*r35*r65*r52 + r148 + r126);
   dVdXX[iDx + nb*(iBx)] += Factor*((-1.0*r11*r114*r48*r52*r72) - 1.0*r11*r115*r59*r68 + r114*r11*r71*r59 + r2*r115*r74*r35*r59 + r115*r11*r35*r72*r52 + r173 + r172);
   dVdXX[iDx + nb*(iBy)] += Factor*((-1.0*r11*r114*r48*r52*r82) - 1.0*r11*r115*r59*r78 - 1.0*r114*r48*r5*r59*r74 + r114*r11*r81*r59 + r80*r11*r48*r59 + r5*r115*r74*r35*r59 + r115*r11*r35*r82*r52 + r190);
   dVdXX[iDx + nb*(iBz)] += Factor*((-1.0*r11*r114*r48*r52*r90) - 1.0*r11*r115*r59*r86 - 1.0*r114*r48*r59*r74*r8 + r114*r11*r89*r59 + r88*r11*r48*r59 + r8*r115*r74*r35*r59 + r115*r11*r35*r90*r52 + r204);
   dVdXX[iDx + nb*(iCx)] += Factor*((-1.0*r11*r114*r48*r52*r97) - 1.0*r11*r115*r59*r94 - 1.0*r115*r2*r35*r59*r74 + r114*r11*r96*r59 + r115*r11*r35*r97*r52 + r214 + r213);
   dVdXX[iDx + nb*(iCy)] += Factor*((-1.0*r115*r35*r5*r59*r74) + r5*r114*r74*r48*r59 + r103*r11*r48*r59 - 1.0*r102*r11*r115*r59 + r114*r11*r104*r59 - 1.0*r105*r11*r114*r48*r52 + r115*r11*r35*r105*r52 + r220);
   dVdXX[iDx + nb*(iCz)] += Factor*((-1.0*r115*r35*r59*r74*r8) + r8*r114*r74*r48*r59 + r29*r11*r48*r59 - 1.0*r109*r11*r115*r59 + r114*r11*r111*r59 - 1.0*r11*r112*r114*r48*r52 + r115*r11*r35*r112*r52 + r225);
   dVdXX[iDx + nb*(iDx)] += Factor*(r115*r11*r35*r116*r52 - 1.0*r11*r114*r116*r48*r52);
   dVdXX[iDx + nb*(iDy)] += Factor*((-1.0*r11*r115*r118*r59) + r114*r119*r11*r59 - 1.0*r11*r114*r120*r48*r52 + r115*r11*r35*r120*r52);
   dVdXX[iDx + nb*(iDz)] += Factor*((-1.0*r11*r115*r123*r59) + r114*r124*r11*r59 - 1.0*r11*r114*r125*r48*r52 + r115*r11*r35*r125*r52);
   dVdXX[iDy + nb*(iAx)] += Factor*((-1.0*r11*r119*r38*r59) + r118*r11*r25*r59 - 1.0*r11*r118*r48*r49*r52 + r119*r11*r35*r49*r52 + r122 + r121);
   dVdXX[iDy + nb*(iAy)] += Factor*(r118*r11*r57*r59 - 1.0*r11*r119*r55*r59 - 1.0*r11*r118*r48*r52*r58 + r119*r11*r35*r58*r52 + r137);
   dVdXX[iDy + nb*(iAz)] += Factor*((-1.0*r11*r118*r48*r52*r65) - 1.0*r11*r119*r59*r62 + r118*r11*r64*r59 + r119*r11*r35*r65*r52 + r149 + r138);
   dVdXX[iDy + nb*(iBx)] += Factor*((-1.0*r118*r2*r48*r59*r74) - 1.0*r11*r118*r48*r52*r72 - 1.0*r11*r119*r59*r68 + r118*r11*r71*r59 + r70*r11*r48*r59 + r2*r119*r74*r35*r59 + r119*r11*r35*r72*r52 + r176);
   dVdXX[iDy + nb*(iBy)] += Factor*((-1.0*r11*r118*r48*r52*r82) - 1.0*r11*r119*r59*r78 + r118*r11*r81*r59 + r5*r119*r74*r35*r59 + r119*r11*r35*r82*r52 + r192 + r191);
   dVdXX[iDy + nb*(iBz)] += Factor*((-1.0*r11*r118*r48*r52*r90) - 1.0*r11*r119*r59*r86 - 1.0*r118*r48*r59*r74*r8 + r118*r11*r89*r59 + r87*r11*r48*r59 + r8*r119*r74*r35*r59 + r119*r11*r35*r90*r52 + r205);
   dVdXX[iDy + nb*(iCx)] += Factor*((-1.0*r11*r118*r48*r52*r97) - 1.0*r11*r119*r59*r94 - 1.0*r119*r2*r35*r59*r74 + r118*r11*r96*r59 + r2*r118*r74*r48*r59 + r27*r11*r48*r59 + r119*r11*r35*r97*r52 + r215);
   dVdXX[iDy + nb*(iCy)] += Factor*((-1.0*r119*r35*r5*r59*r74) - 1.0*r102*r11*r119*r59 + r118*r11*r104*r59 - 1.0*r105*r11*r118*r48*r52 + r119*r11*r35*r105*r52 + r222 + r221);
   dVdXX[iDy + nb*(iCz)] += Factor*((-1.0*r119*r35*r59*r74*r8) + r118*r8*r74*r48*r59 + r110*r11*r48*r59 - 1.0*r109*r11*r119*r59 + r118*r11*r111*r59 - 1.0*r11*r112*r118*r48*r52 + r119*r11*r35*r112*r52 + r226);
   dVdXX[iDy + nb*(iDx)] += Factor*((-1.0*r11*r114*r119*r59) + r118*r115*r11*r59 - 1.0*r11*r116*r118*r48*r52 + r119*r11*r35*r116*r52);
   dVdXX[iDy + nb*(iDy)] += Factor*(r119*r11*r35*r120*r52 - 1.0*r11*r118*r120*r48*r52);
   dVdXX[iDy + nb*(iDz)] += Factor*((-1.0*r11*r119*r123*r59) + r118*r124*r11*r59 - 1.0*r11*r118*r125*r48*r52 + r119*r11*r35*r125*r52);
   dVdXX[iDz + nb*(iAx)] += Factor*((-1.0*r11*r124*r38*r59) + r123*r11*r25*r59 - 1.0*r11*r123*r48*r49*r52 + r124*r11*r35*r49*r52 + r127 + r126);
   dVdXX[iDz + nb*(iAy)] += Factor*(r123*r11*r57*r59 - 1.0*r11*r124*r55*r59 - 1.0*r11*r123*r48*r52*r58 + r124*r11*r35*r58*r52 + r139 + r138);
   dVdXX[iDz + nb*(iAz)] += Factor*((-1.0*r11*r123*r48*r52*r65) - 1.0*r11*r124*r59*r62 + r123*r11*r64*r59 + r124*r11*r35*r65*r52 + r150);
   dVdXX[iDz + nb*(iBx)] += Factor*((-1.0*r123*r2*r48*r59*r74) - 1.0*r11*r123*r48*r52*r72 - 1.0*r11*r124*r59*r68 + r123*r11*r71*r59 + r69*r11*r48*r59 + r2*r124*r74*r35*r59 + r124*r11*r35*r72*r52 + r177);
   dVdXX[iDz + nb*(iBy)] += Factor*((-1.0*r11*r123*r48*r52*r82) - 1.0*r11*r124*r59*r78 - 1.0*r123*r48*r5*r59*r74 + r123*r11*r81*r59 + r79*r11*r48*r59 + r5*r124*r74*r35*r59 + r124*r11*r35*r82*r52 + r195);
   dVdXX[iDz + nb*(iBz)] += Factor*((-1.0*r11*r123*r48*r52*r90) - 1.0*r11*r124*r59*r86 + r123*r11*r89*r59 + r8*r124*r74*r35*r59 + r124*r11*r35*r90*r52 + r207 + r206);
   dVdXX[iDz + nb*(iCx)] += Factor*((-1.0*r11*r123*r48*r52*r97) - 1.0*r11*r124*r59*r94 - 1.0*r124*r2*r35*r59*r74 + r123*r11*r96*r59 + r2*r123*r74*r48*r59 + r95*r11*r48*r59 + r124*r11*r35*r97*r52 + r216);
   dVdXX[iDz + nb*(iCy)] += Factor*((-1.0*r124*r35*r5*r59*r74) + r5*r123*r74*r48*r59 + r31*r11*r48*r59 - 1.0*r102*r11*r124*r59 + r123*r11*r104*r59 - 1.0*r105*r11*r123*r48*r52 + r124*r11*r35*r105*r52 + r223);
   dVdXX[iDz + nb*(iCz)] += Factor*((-1.0*r124*r35*r59*r74*r8) - 1.0*r109*r11*r124*r59 + r123*r11*r111*r59 - 1.0*r11*r112*r123*r48*r52 + r124*r11*r35*r112*r52 + r228 + r227);
   dVdXX[iDz + nb*(iDx)] += Factor*((-1.0*r11*r114*r124*r59) + r123*r115*r11*r59 - 1.0*r11*r116*r123*r48*r52 + r124*r11*r35*r116*r52);
   dVdXX[iDz + nb*(iDy)] += Factor*((-1.0*r11*r118*r124*r59) + r123*r119*r11*r59 - 1.0*r11*r120*r123*r48*r52 + r124*r11*r35*r120*r52);
   dVdXX[iDz + nb*(iDz)] += Factor*(r124*r11*r35*r125*r52 - 1.0*r11*r123*r125*r48*r52);
   // suppress potential unused variable warnings.
   (void)Ax; (void)Ay; (void)Az; (void)Bx; (void)By; (void)Bz; (void)Cx; (void)Cy;
   (void)Cz; (void)Dx; (void)Dy; (void)Dz;
}

/* kate: syntax c++; */

