/* CxAngularGrid_Grids.inl v20170719 EST [storm, Gerald Knizia] */
static void make_grid_tet_n4_l2(double *IR_RP p)
{
   // npts =  4  lmax = 2  wtsp = 1.000e+00  res = 2.25e-34  source = tetrahedral-sp-barycentric-100.txt.dat
   make_orbit_tet_cof(&p[0], -5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 2.500000000000000000000000e-01);
}

static void make_grid_oct_n6_l3(double *IR_RP p)
{
   // npts =  6  lmax = 3  wtsp = 1.000e+00  res = 0.00e+00  source = octahedral-brksp-barycentric-001.txt.dat
   make_orbit_oct_cof(&p[0], 1.000000000000000000000000e+00, 0.000000000000000000000000e+00, 0.000000000000000000000000e+00, 1.666666666666666666666667e-01);
}

static void make_grid_ico_n12_l5(double *IR_RP p)
{
   // npts =  12  lmax = 5  wtsp = 1.000e+00  res = 1.23e-35  source = icosahedral_1_0-v3.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 8.333333333333333333333333e-02);
}

static void make_grid_tet_n22_l6(double *IR_RP p)
{
   // npts =  22  lmax = 6  wtsp = 1.077e+00  res = 2.70e-34  source = tetrahedral-sp-veg.dat
   make_orbit_tet_v(&p[0], 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 4.730936953723087253957660e-02);
   make_orbit_tet_coe(&p[16], 0.000000000000000000000000e+00, 0.000000000000000000000000e+00, 1.000000000000000000000000e+00, 4.723315852472125459978457e-02);
   make_orbit_tet_g(&p[40], -7.000511077305162820401427e-01, 1.409144887176410019769538e-01, 7.000511077305162820401427e-01, 4.394696422522908185358218e-02);
}

static void make_grid_oct_n24_l7(double *IR_RP p)
{
   // npts =  24  lmax = 7  wtsp = 1.000e+00  res = 1.51e-27  source = octahedral-sp-barycentric-010.txt.dat
   make_orbit_oct_g(&p[0], 8.662468181078205913835981e-01, 4.225186537611115291185464e-01, -2.666354015167047203315345e-01, 4.166666666666666666666667e-02);
}

static void make_grid_tet_n28_l8(double *IR_RP p)
{
   // npts =  28  lmax = 8  wtsp = 1.113e+00  res = 4.82e-27  source = tetrahedral_3_1.dat
   make_orbit_tet_v(&p[0], 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 3.461538461538461538461538e-02);
   make_orbit_tet_g(&p[16], -5.823210657345521373678487e-01, 2.004628646301184012624421e-01, 7.878558347223572053469743e-01, 3.781077565960163210267829e-02);
   make_orbit_tet_g(&p[64], 1.274805251100765375771208e-01, 3.076764528041864753009011e-01, 9.429124647110633873753710e-01, 3.398409613527016276911658e-02);
}

static void make_grid_ico_n32_l9(double *IR_RP p)
{
   // npts =  32  lmax = 9  wtsp = 1.080e+00  res = 4.63e-34  source = icosahedral-sp-barycentric-101.txt.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 2.976190476190476190476190e-02);
   make_orbit_ico_cof(&p[48], 9.341723589627156964511186e-01, 3.568220897730899319419698e-01, 0.000000000000000000000000e+00, 3.214285714285714285714286e-02);
}

static void make_grid_oct_n48_l11(double *IR_RP p)
{
   // npts =  48  lmax = 11  wtsp = 1.106e+00  res = 2.46e-28  source = octahedral-brksp-barycentric-010-randpt1-trial0016.txt.dat
   make_orbit_oct_g(&p[0], 7.170910336977387605917472e-01, 6.352344011620706800669242e-01, -2.868060406800629949890633e-01, 2.188400924041703161115201e-02);
   make_orbit_oct_g(&p[96], 9.372020824673557081854014e-01, 3.307484322683272437559761e-01, 1.107146384670768635362890e-01, 1.978265742624963505551465e-02);
}

static void make_grid_ico_n72_l14(double *IR_RP p)
{
   // npts =  72  lmax = 14  wtsp = 1.144e+00  res = 4.85e-25  source = icosahedral_2_1-v3.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 1.240079365079365079365081e-02);
   make_orbit_ico_g(&p[48], 9.762513228834464697661112e-01, 1.511082746645615755241129e-01, 1.552406000253160752989310e-01, 1.418650793650793650793650e-02);
}

static void make_grid_tet_n106_l16(double *IR_RP p)
{
   // npts = 106  lmax = 16  wtsp = 1.392e+00  res = 1.81e-33  source = tetrahedral_6_2.dat
   make_orbit_tet_v(&p[0], 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 9.966641447706929471709056e-03);
   make_orbit_tet_coe(&p[16], 0.000000000000000000000000e+00, 0.000000000000000000000000e+00, 1.000000000000000000000000e+00, 8.321904604811558343737726e-03);
   make_orbit_tet_g(&p[40], -8.256220305198631909058435e-01, 3.767656531068882089893197e-02, 5.629642432221139686816807e-01, 9.704238971534901460342295e-03);
   make_orbit_tet_g(&p[88], -6.303294554748720014553336e-01, -2.209273563953108597673227e-01, 7.442283794353253852414271e-01, 1.014765251663054847767245e-02);
   make_orbit_tet_g(&p[136], -5.908958132375440616566796e-01, 1.859887356881801221777074e-01, 7.850161323791083223894892e-01, 9.899833322516362536994355e-03);
   make_orbit_tet_g(&p[184], -4.256513266525633085779882e-01, 5.286989684284729631086539e-01, 7.343693545495899826691926e-01, 1.027936519588253421111074e-02);
   make_orbit_tet_g(&p[232], -3.675047679462801585889580e-01, -6.328067090525678076553131e-02, 9.278662631147504759833090e-01, 9.325525513638023630881955e-03);
   make_orbit_tet_g(&p[280], -2.469664408184276524186050e-01, 2.743918864660026841884360e-01, 9.293635831853464468366463e-01, 9.528943251463686000155538e-03);
   make_orbit_tet_g(&p[328], 1.056157626492862834130785e-01, 2.783223811294314142780638e-01, 9.546632719668506994824450e-01, 7.384798372670157078031964e-03);
   make_orbit_tet_g(&p[376], 3.440365908361612617388014e-01, 4.506333364326892709447356e-01, 8.237526450709426678178884e-01, 9.579810070689030942372156e-03);
}

static void make_grid_tet_n116_l17(double *IR_RP p)
{
   // npts = 116  lmax = 17  wtsp = 1.320e+00  res = 1.19e-24  source = tetrahedral_7_1.dat
   make_orbit_tet_v(&p[0], 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 8.717031900815141179258233e-03);
   make_orbit_tet_cof(&p[16], -5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 8.951042919125361201846996e-03);
   make_orbit_tet_g(&p[32], -7.067872007851448420264762e-01, 3.006169676845526878924532e-02, 7.067872007851449459158425e-01, 6.980679926159520782309307e-03);
   make_orbit_tet_g(&p[80], -5.368689826707394210721578e-01, 2.945972833041821415959426e-01, 7.905593817771570416634392e-01, 8.531090327078468726317225e-03);
   make_orbit_tet_g(&p[128], -3.814884713829087689592493e-01, -3.814884713829087587045293e-01, 8.419816461205453154885756e-01, 9.215897328034818956023497e-03);
   make_orbit_tet_g(&p[176], -2.945972833041820922627682e-01, 5.368689826707394596260310e-01, 7.905593817771570338652147e-01, 8.531090327078469071876789e-03);
   make_orbit_tet_g(&p[224], -1.260355143639958314788085e-01, -1.260355143639958669241306e-01, 9.839868384475505737114431e-01, 9.081674074707912339056184e-03);
   make_orbit_tet_g(&p[272], 4.559224579045921710459197e-02, 4.521479825633855705875253e-01, 8.907769355947889223626897e-01, 8.700838350434520476821493e-03);
   make_orbit_tet_g(&p[320], 4.559224579045921730602766e-02, 8.907769355947889521916346e-01, 4.521479825633855118011963e-01, 8.700838350434519340497153e-03);
   make_orbit_tet_g(&p[368], 2.247208546797423508754301e-01, -2.247208546797423509687004e-01, 9.481566721507644596611951e-01, 9.089712346291695779559288e-03);
   make_orbit_tet_g(&p[416], 2.759145345891108462859558e-01, 6.796584324506223443335614e-01, 6.796584324506223458758858e-01, 8.612154029799907067170651e-03);
}

static void make_grid_ico_n132_l19(double *IR_RP p)
{
   // npts = 132  lmax = 19  wtsp = 1.235e+00  res = 2.94e-21  source = icosahedral_3_1.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 6.359381359381359381554741e-03);
   make_orbit_ico_g(&p[48], 9.642920807066985392999734e-01, 7.312596334058243053862614e-02, 2.545454312531611421919192e-01, 7.540532344007262677839990e-03);
   make_orbit_ico_g(&p[288], 9.833212471706808990402579e-01, 1.739856189321967239236747e-01, -5.299367195691492103485655e-02, 7.854258050783132112515976e-03);
}

static void make_grid_oct_n170_l21(double *IR_RP p)
{
   // npts = 170  lmax = 21  wtsp = 1.232e+00  res = 3.76e-33  source = octahedral_brrk_5_2.dat
   make_orbit_oct_v(&p[0], 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 6.383674773515092765584791e-03);
   make_orbit_oct_cof(&p[32], 1.000000000000000000000000e+00, 0.000000000000000000000000e+00, 0.000000000000000000000000e+00, 5.544842902037364644854743e-03);
   make_orbit_oct_coe(&p[56], 7.071067811865475244008444e-01, 7.071067811865475244008444e-01, 0.000000000000000000000000e+00, 6.071332770670751573307695e-03);
   make_orbit_oct_g(&p[104], 6.743601460362765742404655e-01, 6.743601460362765742404655e-01, 3.007935951377014683003569e-01, 6.317929009813725218215126e-03);
   make_orbit_oct_g(&p[200], 7.917955593934921434660375e-01, 4.318910696719410378375732e-01, 4.318910696719410378375732e-01, 6.201670006589076610267929e-03);
   make_orbit_oct_g(&p[296], 8.544158046846587828316636e-01, 4.990453161796037145881954e-01, 1.446630744325115388861590e-01, 5.968383987681156136670620e-03);
   make_orbit_oct_g(&p[392], 8.544158046846587828316636e-01, 4.990453161796037145881954e-01, -1.446630744325115388861590e-01, 5.968383987681156136670620e-03);
   make_orbit_oct_g(&p[488], 9.326425903126905644503617e-01, 2.551252621114134437246596e-01, 2.551252621114134437246596e-01, 5.183387587747790324299128e-03);
   make_orbit_oct_g(&p[584], 9.652324219764483687800518e-01, 2.613931360335988472307842e-01, 4.210469398936428048435129e-34, 5.477143385137347704147446e-03);
}

static void make_grid_oct_n186_l22(double *IR_RP p)
{
   // npts = 186  lmax = 22  wtsp = 1.204e+00  res = 1.36e-21  source = octahedral_brrk_5_0.dat
   make_orbit_oct_cof(&p[0], 1.000000000000000000000000e+00, 0.000000000000000000000000e+00, 0.000000000000000000000000e+00, 5.458029971850913491929660e-03);
   make_orbit_oct_coe(&p[24], 7.071067811865475244008444e-01, 7.071067811865475244008444e-01, 0.000000000000000000000000e+00, 5.669605474412795055195910e-03);
   make_orbit_oct_g(&p[72], 4.778896053345942094903490e-01, 7.015825780181613167885894e-01, 5.285862383136136611518031e-01, 5.730145756628083888753258e-03);
   make_orbit_oct_g(&p[168], 7.221459813248013006261954e-01, 6.317967066621482240561292e-01, -2.816702027323855231468379e-01, 5.671102371218347254261105e-03);
   make_orbit_oct_g(&p[264], 8.196406986366439641467395e-01, 5.349211122775190968243542e-01, 2.050573792337549540525112e-01, 5.587008535329758081910397e-03);
   make_orbit_oct_g(&p[360], 8.633925875002541012099125e-01, 3.239882052947398484383968e-01, 3.867620491717220845475935e-01, 5.443920474159091057367388e-03);
   make_orbit_oct_g(&p[456], 8.653900671350642349437102e-01, 4.955059721464956910265307e-01, -7.465831012770951242855001e-02, 5.421775037482671065806953e-03);
   make_orbit_oct_g(&p[552], 9.420301707605855128607203e-01, -1.187524752030891024132411e-01, 3.138104635124867969172479e-01, 4.759181596770398988572577e-03);
   make_orbit_oct_g(&p[648], 9.660531848448473513261648e-01, 2.349129678820503837556154e-01, -1.075041467664106463976654e-01, 4.854222664909190429413591e-03);
}

static void make_grid_ico_n192_l23(double *IR_RP p)
{
   // npts = 192  lmax = 23  wtsp = 1.298e+00  res = 1.39e-21  source = icosahedral_3_2-v3.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 4.164880157580242505195160e-03);
   make_orbit_ico_g(&p[48], 9.389133803811559787524566e-01, 1.134729659940559359587057e-01, 3.249085257880170314892151e-01, 5.077679306001083356988484e-03);
   make_orbit_ico_g(&p[288], 9.696669087810822363842752e-01, 2.278851408290567536922401e-01, 8.839936993135930626389157e-02, 5.349546802216596883196342e-03);
   make_orbit_ico_g(&p[528], 9.903922163546059654138963e-01, 6.106051248825701526067271e-02, -1.240760718224218169129842e-01, 5.406464526932937925442806e-03);
}

static void make_grid_ico_n282_l27(double *IR_RP p)
{
   // npts = 282  lmax = 27  wtsp = 1.386e+00  res = 2.28e-22  source = icosahedral_4_2.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 2.672491962268128156229164e-03);
   make_orbit_ico_coe(&p[48], 1.000000000000000000000000e+00, 0.000000000000000000000000e+00, 0.000000000000000000000000e+00, 3.704649949041797977734385e-03);
   make_orbit_ico_g(&p[168], 9.307521968071135789250186e-01, 7.274093599682348108352580e-02, 3.583421610263550069043011e-01, 3.349108147650560393069189e-03);
   make_orbit_ico_g(&p[408], 9.706051785986187507272396e-01, 2.362054229207273702683941e-01, -4.617992486333989807636330e-02, 3.687132640307904535515543e-03);
   make_orbit_ico_g(&p[648], 9.743408540366430475966826e-01, 8.360826114102083393105886e-02, -2.089726269732950287827346e-01, 3.627073609400477510528759e-03);
   make_orbit_ico_g(&p[888], 9.746854407326467969712319e-01, 1.529101241423545618639904e-01, 1.631158654410287113834358e-01, 3.616528902333199607440152e-03);
}

static void make_grid_oct_n314_l29(double *IR_RP p)
{
   // npts = 314  lmax = 29  wtsp = 1.321e+00  res = 9.18e-33  source = octahedral_brrk_4_4.dat
   make_orbit_oct_v(&p[0], 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 5.773502691896257645091488e-01, 3.421949659398894617907607e-03);
   make_orbit_oct_cof(&p[32], 1.000000000000000000000000e+00, 0.000000000000000000000000e+00, 0.000000000000000000000000e+00, 2.749616523642426412226152e-03);
   make_orbit_oct_coe(&p[56], 7.071067811865475244008444e-01, 7.071067811865475244008444e-01, 0.000000000000000000000000e+00, 3.438639198946710295938491e-03);
   make_orbit_oct_g(&p[104], 6.385917405624162214044609e-01, 7.354959606170189453353914e-01, 2.263764139691063517000028e-01, 3.422704294525257704220431e-03);
   make_orbit_oct_g(&p[200], 7.008920820076951938741208e-01, 5.997098878603620690836536e-01, 3.861325417281354012577201e-01, 3.441678269431474087140298e-03);
   make_orbit_oct_g(&p[296], 7.306043671282433115274953e-01, 4.310725346626517994755138e-01, 5.295221700671804043065230e-01, 3.404138481448370045947023e-03);
   make_orbit_oct_g(&p[392], 7.876198003274388492546405e-01, 5.928792124619495156939905e-01, 1.677775001681211247929908e-01, 3.407716603585038315207490e-03);
   make_orbit_oct_g(&p[488], 8.342865199587200095793770e-01, 4.456050300377027236811761e-01, 3.246569879430694349737497e-01, 3.352213984095493128277680e-03);
   make_orbit_oct_g(&p[584], 8.350774516453359295052804e-01, 5.469354123659022432299036e-01, -5.922249955609860988049314e-02, 3.334197702128740546178295e-03);
   make_orbit_oct_g(&p[680], 8.470307013544170573440928e-01, 2.712689348364407719965906e-01, 4.571128481630626754378750e-01, 3.250409703112353250105640e-03);
   make_orbit_oct_g(&p[776], 8.981977717657020702580642e-01, 4.270634417733331101473433e-01, 1.041997096725451207069546e-01, 3.184725878389761055906645e-03);
   make_orbit_oct_g(&p[872], 9.248769286216724929987792e-01, 3.640100813617651740692019e-01, -1.099969434590926383583221e-01, 2.950346573627979968671597e-03);
   make_orbit_oct_g(&p[968], 9.284593103243219349618497e-01, 2.776525359609174064945452e-01, 2.467232829437787908033241e-01, 3.085110083991766740892265e-03);
   make_orbit_oct_g(&p[1064], 9.671784009155928788192731e-01, 2.519296302299796742488613e-01, 3.312706166478396633423180e-02, 2.605974578223571112266491e-03);
   make_orbit_oct_g(&p[1160], 9.827187793816611682849060e-01, 1.457214915295070878765491e-01, -1.141448533970487795806224e-01, 2.680076897256600754857826e-03);
}

static void make_grid_ico_n372_l32(double *IR_RP p)
{
   // npts = 372  lmax = 32  wtsp = 1.427e+00  res = 3.06e-21  source = icosahedral_4_3.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 1.959200890475540129535013e-03);
   make_orbit_ico_g(&p[48], 9.155528316014614906647507e-01, 8.618109219848171752984511e-02, 3.928559938374654495200745e-01, 2.481956300687512050184050e-03);
   make_orbit_ico_g(&p[288], 9.562422657906511859326416e-01, 1.748270318262252512953009e-01, 2.345980350693364944909098e-01, 2.712872598554725243975325e-03);
   make_orbit_ico_g(&p[528], 9.625792338280294683692817e-01, 2.636894850546747455711097e-01, 6.252258851522570461266337e-02, 2.779927846294796857873225e-03);
   make_orbit_ico_g(&p[768], 9.679638543374261447190244e-01, 3.063271246400248916198685e-02, -2.492139916283429851161297e-01, 2.710611420155166126888330e-03);
   make_orbit_ico_g(&p[1008], 9.837278337041553020367771e-01, 1.507340840825242707698186e-01, -9.776903953467209466367601e-02, 2.793671508881098019468167e-03);
   make_orbit_ico_g(&p[1248], 9.952031184015478924856751e-01, 5.917038014019995397633714e-02, 7.790776108898828737687824e-02, 2.795786813998260342370566e-03);
}

static void make_grid_ico_n482_l35(double *IR_RP p)
{
   // npts = 482  lmax = 35  wtsp = 1.537e+00  res = 9.30e-33  source = icosahedral_4_4.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 1.414538317505857735300162e-03);
   make_orbit_ico_cof(&p[48], 9.341723589627156964511186e-01, 3.568220897730899319419698e-01, 0.000000000000000000000000e+00, 2.155011954862117299203929e-03);
   make_orbit_ico_coe(&p[128], 1.000000000000000000000000e+00, 0.000000000000000000000000e+00, 0.000000000000000000000000e+00, 2.174117334888586767510364e-03);
   make_orbit_ico_g(&p[248], 9.037628491114736632905592e-01, 8.607092093739131885821436e-02, 4.192904830006293150621141e-01, 1.853009734009204933565495e-03);
   make_orbit_ico_g(&p[488], 9.396872955435046778909076e-01, 1.786757883081453713073351e-01, 2.916551889930932042520826e-01, 2.068437812830930775093510e-03);
   make_orbit_ico_g(&p[728], 9.509558268139833645229260e-01, 2.704876316704356362233492e-01, 1.500648411915729926734390e-01, 2.145753512113262837000085e-03);
   make_orbit_ico_g(&p[968], 9.579171628245948735225736e-01, -2.155731380064254917356880e-21, 2.870447859935424662808825e-01, 2.053814974148032413445887e-03);
   make_orbit_ico_g(&p[1208], 9.829674880617637201567768e-01, 1.837795348060996651626748e-01, 1.551907308466009771056537e-21, 2.164531453771856943262768e-03);
   make_orbit_ico_g(&p[1448], 9.848902591428666223178355e-01, 9.216994444403552020581884e-02, 1.466147290918631933531177e-01, 2.146407765280270700210183e-03);
   make_orbit_ico_g(&p[1688], 9.848902591428666223180199e-01, 9.216994444403552020647327e-02, -1.466147290918631933514677e-01, 2.146407765280270700205547e-03);
}

static void make_grid_ico_n492_l37(double *IR_RP p)
{
   // npts = 492  lmax = 37  wtsp = 1.178e+00  res = 2.60e-26  source = icosahedral_7_0.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 1.810116583703527736049095e-03);
   make_orbit_ico_g(&p[48], 9.206260641255015628309434e-01, -4.185952017739721575662240e-02, 3.881950935075119670093225e-01, 2.053651956995703088546842e-03);
   make_orbit_ico_g(&p[288], 9.468253596951861988592429e-01, 1.131268665987708479655952e-01, 3.012043331222596780583590e-01, 2.009649302146136401970075e-03);
   make_orbit_ico_g(&p[528], 9.520270479920082541465816e-01, 2.957516742782960019821186e-01, 7.858401270746562889239130e-02, 2.131945593405037734427375e-03);
   make_orbit_ico_g(&p[768], 9.636711644602816963365364e-01, 1.830244388566900403045390e-01, -1.945249124635670837687055e-01, 2.029024998823183232057682e-03);
   make_orbit_ico_g(&p[1008], 9.721635020521242432331106e-01, -3.344540492568194688420971e-02, 2.319041400387379718180026e-01, 1.983217653708875596331721e-03);
   make_orbit_ico_g(&p[1248], 9.812830458200717040024993e-01, 1.343729691355154731026477e-01, 1.379401651144033636603330e-01, 2.085266414954252982801413e-03);
   make_orbit_ico_g(&p[1488], 9.865194756388377168384533e-01, 1.609116974381627787680294e-01, -2.977834469613505499765420e-02, 2.088778235556993271891821e-03);
   make_orbit_ico_g(&p[1728], 9.969875277967490536608799e-01, -1.186493378423437880716361e-02, 7.664915370714974000115564e-02, 1.923109194335778811429918e-03);
}

static void make_grid_ico_n632_l42(double *IR_RP p)
{
   // npts = 632  lmax = 42  wtsp = 1.489e+00  res = 5.77e-22  source = icosahedral_6_3.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 1.153106872419919976753506e-03);
   make_orbit_ico_cof(&p[48], 9.341723589627156964511186e-01, 3.568220897730899319419698e-01, 0.000000000000000000000000e+00, 1.693617163305251866709910e-03);
   make_orbit_ico_g(&p[128], 9.102084034429066265742850e-01, -3.483825437475094621245820e-02, 4.126826363369739243686878e-01, 1.513608951771182312469876e-03);
   make_orbit_ico_g(&p[368], 9.427528101398376703751404e-01, 9.184438287891817850610893e-02, 3.205959268409844722320958e-01, 1.703449483483807598051730e-03);
   make_orbit_ico_g(&p[608], 9.532823546838240821523486e-01, 5.442719960906092107190234e-02, -2.971370596057975073611920e-01, 1.193118800141749751842555e-03);
   make_orbit_ico_g(&p[848], 9.596209884579533998806126e-01, 2.571727265301826030083346e-01, -1.139725723146248060478660e-01, 1.685326761955612411664862e-03);
   make_orbit_ico_g(&p[1088], 9.602301229748824456157630e-01, 1.578288765032029208697030e-01, -2.303218545283509491398653e-01, 1.520340961113049676281475e-03);
   make_orbit_ico_g(&p[1328], 9.718271769569501586883083e-01, 1.550612388282974122819692e-01, 1.775047896281066367757372e-01, 1.666006183333416925345031e-03);
   make_orbit_ico_g(&p[1568], 9.780445306360842477226405e-01, 2.059012904896052117056489e-01, 3.214894504578450059819781e-02, 1.716667996680923320075055e-03);
   make_orbit_ico_g(&p[1808], 9.818363829731546177743490e-01, 8.465497084120644123564487e-03, 1.895406352983750074268101e-01, 1.525113751825078208907551e-03);
   make_orbit_ico_g(&p[2048], 9.901305161001479101308935e-01, 1.049965221459687724147483e-01, -9.282936725253398629836313e-02, 1.696246379598597365305062e-03);
   make_orbit_ico_g(&p[2288], 9.971777351303233513249325e-01, 5.443059370758171014971132e-02, 5.170952551512006225718251e-02, 1.651626967844181145802785e-03);
}

static void make_grid_ico_n812_l47(double *IR_RP p)
{
   // npts = 812  lmax = 47  wtsp = 1.273e+00  res = 1.46e-32  source = icosahedral_9_0-v2.dat
   make_orbit_ico_v(&p[0], 8.5065080835203988e-01, 0.0000000000000000e+00, 5.2573111211913359e-01, 1.2051242565098144e-03);
   make_orbit_ico_cof(&p[48], 9.3417235896271567e-01, 3.5682208977308993e-01, 0.0000000000000000e+00, 1.3048199604300745e-03);
   make_orbit_ico_g(&p[128], 9.1127755832159063e-01, -4.1873320018012136e-04, 4.1179246758767585e-01, 1.3029863716236827e-03);
   make_orbit_ico_g(&p[368], 9.2196266090940937e-01, 1.2243425175982504e-01, 3.6741625696865032e-01, 1.2840620063343398e-03);
   make_orbit_ico_g(&p[608], 9.5245428320095737e-01, 2.3521966882235298e-01, 1.9365574045520312e-01, 1.2564734691355513e-03);
   make_orbit_ico_g(&p[848], 9.5723586879191802e-01, -4.7507692900386582e-03, 2.8926963492446739e-01, 1.2775134396672734e-03);
   make_orbit_ico_g(&p[1088], 9.6052544892162040e-01, 1.2763321317315016e-01, -2.4718540585766138e-01, 1.2320635633938357e-03);
   make_orbit_ico_g(&p[1328], 9.6232682106422773e-01, 1.1644100615559669e-01, 2.4570018629600218e-01, 1.2408395689636395e-03);
   make_orbit_ico_g(&p[1568], 9.6704211762877468e-01, 2.4475316030587446e-01, -7.0181430965334982e-02, 1.2776758616174961e-03);
   make_orbit_ico_g(&p[1808], 9.6895254352610061e-01, 2.3915886583714627e-01, 6.2721649259167220e-02, 1.2854603400011290e-03);
   make_orbit_ico_g(&p[2048], 9.8628749308383090e-01, -5.8053275172339439e-03, 1.6493416613555217e-01, 1.1998949434684344e-03);
   make_orbit_ico_g(&p[2288], 9.8398974571859765e-01, 1.2701225540886160e-01, -1.2502826599054973e-01, 1.1883172071740183e-03);
   make_orbit_ico_g(&p[2528], 9.8575052962625032e-01, 1.1702078665656547e-01, 1.2083885481022037e-01, 1.2258279211992238e-03);
   make_orbit_ico_g(&p[2768], 9.9247879420130791e-01, 1.2237345785711122e-01, -3.2526716421456248e-03, 1.1944098525693034e-03);
   make_orbit_ico_g(&p[3008], 9.9869902842967662e-01, -2.5500476006197876e-03, 5.0928851065527136e-02, 1.0251772834067516e-03);
}

static void make_grid_ico_n1112_l56(double *IR_RP p)
{
   // npts = 1112  lmax = 56  wtsp = 1.224e+00  res = 1.78e-18  source = icosahedral_10_1-v2.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 9.392626738423944542773378e-04);
   make_orbit_ico_cof(&p[48], 9.341723589627156964511186e-01, 3.568220897730899319419698e-01, 0.000000000000000000000000e+00, 9.731387365435710070088164e-04);
   make_orbit_ico_g(&p[128], 9.042144970775719601632610e-01, -5.762879659296923110853969e-04, 4.270782260510759564320587e-01, 9.305333549629225208829076e-04);
   make_orbit_ico_g(&p[368], 9.122741757534847329491498e-01, 9.753490464530412133968065e-02, -3.977973989723053489738557e-01, 7.949339476751182130704854e-04);
   make_orbit_ico_g(&p[608], 9.418924457491293336214606e-01, 1.400488114472992317625479e-01, 3.053276126604377109718425e-01, 8.516226268561919916150467e-04);
   make_orbit_ico_g(&p[848], 9.452035565531943317946581e-01, 3.212653554350800931122529e-02, 3.248970950826801114999118e-01, 8.563098994714768756596304e-04);
   make_orbit_ico_g(&p[1088], 9.492915194626484687147923e-01, 6.619060666521787083152790e-02, -3.073506379781674035432609e-01, 8.761508329194856628205221e-04);
   make_orbit_ico_g(&p[1328], 9.514807886910198878469616e-01, 2.554321137435765434157709e-01, 1.715772246552651749155311e-01, 9.324764911911370645062096e-04);
   make_orbit_ico_g(&p[1568], 9.594144716834864536933248e-01, 1.588651027192591938518085e-01, -2.329930270679699865176384e-01, 9.042317182312889954799800e-04);
   make_orbit_ico_g(&p[1808], 9.643011590453980430808357e-01, 2.580191391412882362006227e-01, -5.957682855347780887771347e-02, 9.613634825955713501953426e-04);
   make_orbit_ico_g(&p[2048], 9.644204035296621587785955e-01, 2.582253333848728311016439e-01, 5.668299969086751126274623e-02, 9.590753652117156120491309e-04);
   make_orbit_ico_g(&p[2288], 9.669675452927029776524564e-01, 1.541852060484021727869821e-01, 2.029795275056481687995903e-01, 8.629187210990738739479346e-04);
   make_orbit_ico_g(&p[2528], 9.730218633690451029439667e-01, 5.046709142450780025733873e-02, 2.251255784867230383745534e-01, 8.652687162665365858020075e-04);
   make_orbit_ico_g(&p[2768], 9.779941120298919886317835e-01, 5.279190863806255978383218e-02, -2.018428379140898175445453e-01, 9.226248776766378114994850e-04);
   make_orbit_ico_g(&p[3008], 9.800310664044867182429195e-01, 1.554005362411300858497026e-01, -1.240555610122083937843707e-01, 9.330069131869401298297562e-04);
   make_orbit_ico_g(&p[3248], 9.828986979674894378059829e-01, 1.562530647512794946561484e-01, 9.744295402771014113785799e-02, 8.978770321811868789873375e-04);
   make_orbit_ico_g(&p[3488], 9.876163564210623756643362e-01, 1.563981640854574389394860e-01, -1.239140025515343081149597e-02, 9.258622139335062284817865e-04);
   make_orbit_ico_g(&p[3728], 9.912515471987050000093247e-01, 5.257568917586284781953602e-02, 1.210626576771572937312195e-01, 8.825893175713293768486079e-04);
   make_orbit_ico_g(&p[3968], 9.943164436730745407917370e-01, 5.168897885879077995503152e-02, -9.307555697316596664329082e-02, 9.044487266440953032732414e-04);
   make_orbit_ico_g(&p[4208], 9.985141833099116168239135e-01, 5.250862555515261759466008e-02, 1.456948767970221440858911e-02, 8.931403153761162984287217e-04);
}

static void make_grid_ico_n1572_l64(double *IR_RP p)
{
   // npts = 1572  lmax = 64  wtsp = 1.717e+00  res = 5.12e-19  source = icosahedral_12_1.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 4.980800224125537604448445e-04);
   make_orbit_ico_g(&p[48], 8.886050869801902412265619e-01, 8.055137589795496781498179e-03, 4.586023486107959297432567e-01, 4.035409849254953403895845e-04);
   make_orbit_ico_g(&p[288], 8.986762832817623992287333e-01, 6.294372445794427911505406e-02, -4.340726038558986583844137e-01, 4.791530107341368992816833e-04);
   make_orbit_ico_g(&p[528], 9.206341554266065371653220e-01, 1.137156020472704988858163e-02, 3.902607326909141459747540e-01, 4.773338980523964911458605e-04);
   make_orbit_ico_g(&p[768], 9.268264275823238760548823e-01, 9.245920304809498446174050e-02, 3.639286590895233397733548e-01, 5.837314766150509977831576e-04);
   make_orbit_ico_g(&p[1008], 9.334954588228032706218470e-01, 6.244067974309773912901271e-02, -3.531110163538145790251655e-01, 5.758899984414443200908472e-04);
   make_orbit_ico_g(&p[1248], 9.415134431868120870674772e-01, 1.425040073156581426104428e-01, -3.053605151251425613158221e-01, 6.332062301299336977331248e-04);
   make_orbit_ico_g(&p[1488], 9.506513702857821712930274e-01, 2.032395338133857266746981e-02, 3.095947497822239410502588e-01, 5.862311387338991084005467e-04);
   make_orbit_ico_g(&p[1728], 9.508016398130266420915625e-01, 2.946219466319727698832679e-01, 9.578178475914165002719565e-02, 6.901410267904602680171800e-04);
   make_orbit_ico_g(&p[1968], 9.522173433866318679326477e-01, 1.949889463795147565571341e-01, 2.350775228377054554279847e-01, 6.642361706347125741137324e-04);
   make_orbit_ico_g(&p[2208], 9.532351802393918232627873e-01, 3.022048732030303423426503e-01, -3.860798662781805693253424e-03, 6.928953031289335944608492e-04);
   make_orbit_ico_g(&p[2448], 9.557482436425263091889008e-01, 1.064602069918832192138702e-01, 2.742471861322765654882483e-01, 6.383852743295331621234560e-04);
   make_orbit_ico_g(&p[2688], 9.615428912640317658270759e-01, 2.246622036361953342044047e-01, -1.579941850731699683137709e-01, 6.812467350629753421196421e-04);
   make_orbit_ico_g(&p[2928], 9.628250784949958657953365e-01, 5.877422384624461154375164e-02, -2.636540514241656420593859e-01, 6.373897591963274412382262e-04);
   make_orbit_ico_g(&p[3168], 9.670205974840604408634653e-01, 1.412730427663045597395790e-01, -2.119270898897086272566515e-01, 6.654791654650440578149822e-04);
   make_orbit_ico_g(&p[3408], 9.686335144059577316846677e-01, 2.064793173602884781820929e-01, 1.382584763115540361443414e-01, 6.825948759503046589102055e-04);
   make_orbit_ico_g(&p[3648], 9.734615448942142515416795e-01, 2.209484019570970861789771e-01, -5.961899265145921394312756e-02, 6.901210769288456937913167e-04);
   make_orbit_ico_g(&p[3888], 9.752277655954405702508009e-01, 2.830832701792565783431080e-02, 2.193842378867966937373106e-01, 6.459255151379072536121080e-04);
   make_orbit_ico_g(&p[4128], 9.758287399057968863894415e-01, 2.149194519874388319915105e-01, 3.959671111700548796013520e-02, 6.907982870454688429046284e-04);
   make_orbit_ico_g(&p[4368], 9.767391520468092646627606e-01, 1.171315978184072595869882e-01, 1.796129662674354497546826e-01, 6.701680831219281463725686e-04);
   make_orbit_ico_g(&p[4608], 9.837621237611224852569786e-01, 1.377152368342527313293430e-01, -1.150938634189138958391427e-01, 6.836543558003118590854388e-04);
   make_orbit_ico_g(&p[4848], 9.841021056747955293670916e-01, 5.404716678966813122042349e-02, -1.691802274748540671958682e-01, 6.702175221016938312010884e-04);
   make_orbit_ico_g(&p[5088], 9.886781393676435578833333e-01, 1.255368985749347328004141e-01, 8.219503532891102463059099e-02, 6.863091424542772414284157e-04);
   make_orbit_ico_g(&p[5328], 9.910618725134638319595450e-01, 1.323752242298569715836383e-01, -1.652769978556757511958002e-02, 6.903770281419633123876598e-04);
   make_orbit_ico_g(&p[5568], 9.916263549044291688591361e-01, 3.544408986054307863354908e-02, 1.241808711231839932793888e-01, 6.754320847512969338115647e-04);
   make_orbit_ico_g(&p[5808], 9.962367637246709238878136e-01, 4.844651052003212193990684e-02, -7.186964743079387407203998e-02, 6.854253700287776950528981e-04);
   make_orbit_ico_g(&p[6048], 9.987595597843400834235234e-01, 4.216499974780242944119908e-02, 2.648498698619706315199162e-02, 6.871671484810371512991349e-04);
}

static void make_grid_ico_n1832_l69(double *IR_RP p)
{
   // npts = 1832  lmax = 69  wtsp = 1.698e+00  res = 2.34e-19  source = icosahedral_13_1.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 3.770147526198964019014061e-04);
   make_orbit_ico_cof(&p[48], 9.341723589627156964511186e-01, 3.568220897730899319419698e-01, 0.000000000000000000000000e+00, 6.031174271166406471535307e-04);
   make_orbit_ico_g(&p[128], 8.858696762623942142975900e-01, 3.254848632883427028941802e-03, 4.639227550348634123452670e-01, 3.914092468708911066697732e-04);
   make_orbit_ico_g(&p[368], 8.968323072677017702826189e-01, 6.506240088315396588925371e-02, -4.375599349028774189498243e-01, 3.770142426309495959794676e-04);
   make_orbit_ico_g(&p[608], 9.136206274909781551719344e-01, 7.259826717356274430257472e-03, 4.065029445637820848337746e-01, 3.552041910919557794432705e-04);
   make_orbit_ico_g(&p[848], 9.215894302947368749438522e-01, 8.179784944454333469981781e-02, 3.794496459285080745864815e-01, 4.475651212893856583995106e-04);
   make_orbit_ico_g(&p[1088], 9.276630187165851849515602e-01, 5.526190034223182346654853e-02, -3.693067100340823256437234e-01, 4.503693271746719095363480e-04);
   make_orbit_ico_g(&p[1328], 9.347774085185086786452364e-01, 1.290445560284455490281670e-01, -3.309663110995475864798815e-01, 5.331369098475418311184309e-04);
   make_orbit_ico_g(&p[1568], 9.417820926896480061300645e-01, 1.792133431677014144637948e-02, 3.357459093800158401242840e-01, 4.773707639891857524329547e-04);
   make_orbit_ico_g(&p[1808], 9.486199560180047249858484e-01, 1.745041375087603263652216e-01, 2.639478831828784500523091e-01, 5.659302953136338904095236e-04);
   make_orbit_ico_g(&p[2048], 9.495385654091258648898927e-01, 9.400049091684594535508346e-02, 2.992330538362551358138896e-01, 5.252244480852344050812186e-04);
   make_orbit_ico_g(&p[2288], 9.536132802837530199841303e-01, 2.692052387337852241708803e-01, 1.347228677869722581696682e-01, 5.971985299513474291515951e-04);
   make_orbit_ico_g(&p[2528], 9.555785657318371869696983e-01, 5.404443687436229246086008e-02, -2.897391992064898109792118e-01, 5.292792912003759631479461e-04);
   make_orbit_ico_g(&p[2768], 9.579611996782054814962066e-01, 2.823496041177635855397830e-01, -5.088261948480548299430383e-02, 6.015996330017571669269128e-04);
   make_orbit_ico_g(&p[3008], 9.585676975317743119224576e-01, 2.078994596977484578881316e-01, -1.947454335947754652711469e-01, 5.861942925340662349884767e-04);
   make_orbit_ico_g(&p[3248], 9.598385317636798105345695e-01, 2.773205685131566093835843e-01, 4.246522366929243413336819e-02, 6.019449369600471336110672e-04);
   make_orbit_ico_g(&p[3488], 9.607777038291584469214954e-01, 1.304988476158765521738078e-01, -2.446962496559727106488953e-01, 5.690296511099851015985936e-04);
   make_orbit_ico_g(&p[3728], 9.668730994236878020195793e-01, 1.860265366859214365887277e-01, 1.747871198328785564812882e-01, 5.870353355365653012412744e-04);
   make_orbit_ico_g(&p[3968], 9.674577328302138024915107e-01, 2.264214669339312962399489e-02, 2.520175953780559287284525e-01, 5.457681287928633270059375e-04);
   make_orbit_ico_g(&p[4208], 9.716665904566525706726288e-01, 1.031705170564633209239890e-01, 2.126496682354473330047728e-01, 5.673228188971559657067503e-04);
   make_orbit_ico_g(&p[4448], 9.731247964866894869479692e-01, 2.063240770884917922266797e-01, -1.022668356620134435928105e-01, 5.961801348486180001274218e-04);
   make_orbit_ico_g(&p[4688], 9.772271073304739604159264e-01, 1.950232547524481951191897e-01, 8.362482169951705681956203e-02, 5.977163062433368418572327e-04);
   make_orbit_ico_g(&p[4928], 9.778879983626774438500960e-01, 5.263724431179977037356962e-02, -2.023965987102946836820763e-01, 5.677137393121213103766714e-04);
   make_orbit_ico_g(&p[5168], 9.793685872341755102858763e-01, 2.018819029878060613044033e-01, -8.992640599802474342886190e-03, 6.001262708155024721589410e-04);
   make_orbit_ico_g(&p[5408], 9.795747273652790604527191e-01, 1.295029351833904063943120e-01, -1.538256912421516870446292e-01, 5.866844032065233459771914e-04);
   make_orbit_ico_g(&p[5648], 9.861397689354139487194732e-01, 1.113893494609477479631161e-01, 1.229665358976792759960029e-01, 5.884746935794803335242297e-04);
   make_orbit_ico_g(&p[5888], 9.861604967669924901825830e-01, 2.813823994126474621518065e-02, 1.633882311223375955235115e-01, 5.779884679941847004653799e-04);
   make_orbit_ico_g(&p[6128], 9.902155029382166765332294e-01, 1.253735999181307230746176e-01, -6.127575527386906384801032e-02, 5.956345890564589274442709e-04);
   make_orbit_ico_g(&p[6368], 9.924006162298180391746363e-01, 1.189882380636144632132678e-01, 3.134989807310427086597065e-02, 5.966677895324540295093983e-04);
   make_orbit_ico_g(&p[6608], 9.925610420203449590582548e-01, 4.838489975265417770952812e-02, -1.117205412599339950390475e-01, 5.872909183161239532493145e-04);
   make_orbit_ico_g(&p[6848], 9.967668994858388540620800e-01, 3.488695226939988323550826e-02, 7.237850959186875344616514e-02, 5.922706296400247821649443e-04);
   make_orbit_ico_g(&p[7088], 9.989215365418508292361964e-01, 4.204313558618275094709925e-02, -1.970123303119964748763408e-02, 5.948794669480315879296033e-04);
}

static void make_grid_ico_n2112_l74(double *IR_RP p)
{
   // npts = 2112  lmax = 74  wtsp = 1.777e+00  res = 2.50e-19  source = icosahedral_14_1.dat
   make_orbit_ico_v(&p[0], 8.506508083520399321815405e-01, 0.000000000000000000000000e+00, 5.257311121191336060256691e-01, 3.418014158308599267083772e-04);
   make_orbit_ico_g(&p[48], 8.842334257760993091058894e-01, 5.356568983688474800823713e-03, 4.670145135956552480858119e-01, 3.521816648172653153713516e-04);
   make_orbit_ico_g(&p[288], 8.947729458238589365226264e-01, 5.895570018802906208400079e-02, -4.426122465963101099844708e-01, 3.229890014421826686539435e-04);
   make_orbit_ico_g(&p[528], 9.107027930322630621667938e-01, 6.033012452587813384850995e-03, 4.130181903064100513705748e-01, 2.951407921484743010932147e-04);
   make_orbit_ico_g(&p[768], 9.171123512135775863859585e-01, 7.356608767303051117952760e-02, 3.917817836449105535168103e-01, 3.737151529107029868926643e-04);
   make_orbit_ico_g(&p[1008], 9.229029105961383323045303e-01, 5.356562937949936167187593e-02, -3.812885271842760432019773e-01, 3.650718841620561788466615e-04);
   make_orbit_ico_g(&p[1248], 9.298296058431952887410530e-01, 1.193215790241218802291881e-01, -3.481081223940032213935266e-01, 4.451180770778671207228557e-04);
   make_orbit_ico_g(&p[1488], 9.360197440595269044181949e-01, 1.386152302610295069636234e-02, 3.516744189021069044746736e-01, 3.895945732876547319036330e-04);
   make_orbit_ico_g(&p[1728], 9.430083661370804408825070e-01, 3.301331696055602999857973e-01, 4.180085790579417964915968e-02, 5.244083361859328240429039e-04);
   make_orbit_ico_g(&p[1968], 9.435158646389119328546593e-01, 8.482985379810084722710794e-02, 3.202837945936060783159835e-01, 4.432322599795929589469074e-04);
   make_orbit_ico_g(&p[2208], 9.446888579542158200258639e-01, 1.590550352544245420825793e-01, 2.868178122386634679666802e-01, 4.815107010986747305102196e-04);
   make_orbit_ico_g(&p[2448], 9.495075643080586240216168e-01, 4.986170612918761149106708e-02, -3.097566715724851843896803e-01, 4.401287300636691258811725e-04);
   make_orbit_ico_g(&p[2688], 9.547464544535264489108168e-01, 2.463831901438809257503567e-01, 1.665969127053216525329481e-01, 5.149147562317913715208796e-04);
   make_orbit_ico_g(&p[2928], 9.548447676076350747078212e-01, 1.931021204162988485247090e-01, -2.257942445303922873870167e-01, 5.039196039186236136556410e-04);
   make_orbit_ico_g(&p[3168], 9.553714326763316338445274e-01, 1.200384820724433239830595e-01, -2.699188553023245821343498e-01, 4.837197027530750612245600e-04);
   make_orbit_ico_g(&p[3408], 9.596356795736846268050815e-01, 2.650896659291628724993081e-01, -9.395121876121304927428676e-02, 5.218668653617667699247293e-04);
   make_orbit_ico_g(&p[3648], 9.609217571436159480047451e-01, 2.144442052424281804498878e-02, 2.759882488012940854248086e-01, 4.584759962687176812641828e-04);
   make_orbit_ico_g(&p[3888], 9.636035678245246265841113e-01, 2.551609570028282445478150e-01, 7.975619159192346765463892e-02, 5.214504992849908666402558e-04);
   make_orbit_ico_g(&p[4128], 9.641603256748975259617937e-01, 1.703389795900053885707080e-01, 2.034195133872639718519294e-01, 5.017853829503880836825159e-04);
   make_orbit_ico_g(&p[4368], 9.652251345303981750727224e-01, 2.613147240429344063384970e-01, -7.419883364297811931613414e-03, 5.238512420791433159516257e-04);
   make_orbit_ico_g(&p[4608], 9.661457176281046085026247e-01, 9.498065109253377536485879e-02, 2.398773191173211325376046e-01, 4.815811161261485031095698e-04);
   make_orbit_ico_g(&p[4848], 9.709793706345782982436945e-01, 1.925122238362732839410516e-01, -1.419087928061219170460262e-01, 5.163352738055267423839641e-04);
   make_orbit_ico_g(&p[5088], 9.718638980086840030473843e-01, 4.706152618059068598438327e-02, -2.307937964957460361936553e-01, 4.822327052046466603305301e-04);
   make_orbit_ico_g(&p[5328], 9.749626292492594972805033e-01, 1.192462296542425494165810e-01, -1.876917906585650704112999e-01, 5.049407847452147212240630e-04);
   make_orbit_ico_g(&p[5568], 9.767772762690355080543758e-01, 1.791101731497086676161914e-01, 1.175827301891126475270390e-01, 5.146894299361879526163789e-04);
   make_orbit_ico_g(&p[5808], 9.801974822288163283768350e-01, 1.899215269523900885616099e-01, -5.605987363847570496846488e-02, 5.217280468374251255222375e-04);
   make_orbit_ico_g(&p[6048], 9.805908417593461818162387e-01, 2.721422395675296948511948e-02, 1.941674202128889312457419e-01, 4.922291196885572091220960e-04);
   make_orbit_ico_g(&p[6288], 9.821610571238253434042657e-01, 1.855091455448738299085351e-01, 3.075735340728634159186146e-02, 5.212072820324558100956203e-04);
   make_orbit_ico_g(&p[6528], 9.824285515719407940523009e-01, 1.028224883184891461650418e-01, 1.557616029458243301205629e-01, 5.039357066811380000820981e-04);
   make_orbit_ico_g(&p[6768], 9.877858940338177687200200e-01, 1.170184706713539078683889e-01, -1.028868556694625568495616e-01, 5.159802094776380975665986e-04);
   make_orbit_ico_g(&p[7008], 9.880408694976554481829442e-01, 4.402107132151983503205086e-02, -1.477747795871225778047735e-01, 5.043045551290045996299195e-04);
   make_orbit_ico_g(&p[7248], 9.915979971330515455072251e-01, 1.088633317720730404763013e-01, 6.987264899232210601896641e-02, 5.158066479108960529903318e-04);
   make_orbit_ico_g(&p[7488], 9.933931909072862999590234e-01, 1.135418392265852495614918e-01, -1.667989820364928831890537e-02, 5.194880251198581852215989e-04);
   make_orbit_ico_g(&p[7728], 9.934623941875864020501349e-01, 3.210579025625974048432094e-02, 1.095522230129984580364838e-01, 5.095582689873659718403665e-04);
   make_orbit_ico_g(&p[7968], 9.972203029031068975652652e-01, 4.049137684059275174114597e-02, -6.254690943115285431630609e-02, 5.147716329138674920220173e-04);
   make_orbit_ico_g(&p[8208], 9.990546464103626187946636e-01, 3.650626696993670011353638e-02, 2.360309212338567373961233e-02, 5.164423568819938508465167e-04);
}

static FAngularGridEntry s_AngularGridInfos[26] = {
   {2, 4, SYMMETRY_Tetrahedral, 1.0, &make_grid_tet_n4_l2},
   {3, 6, SYMMETRY_Octahedral, 1.0, &make_grid_oct_n6_l3},
   {5, 12, SYMMETRY_Icosahedral, 1.0, &make_grid_ico_n12_l5},
   {6, 22, SYMMETRY_Tetrahedral, 1.077, &make_grid_tet_n22_l6},
   {7, 24, SYMMETRY_Octahedral, 1.0, &make_grid_oct_n24_l7},
   {8, 28, SYMMETRY_Tetrahedral, 1.113, &make_grid_tet_n28_l8},
   {9, 32, SYMMETRY_Icosahedral, 1.08, &make_grid_ico_n32_l9},
   {11, 48, SYMMETRY_Octahedral, 1.106, &make_grid_oct_n48_l11},
   {14, 72, SYMMETRY_Icosahedral, 1.144, &make_grid_ico_n72_l14},
   {16, 106, SYMMETRY_Tetrahedral, 1.392, &make_grid_tet_n106_l16},
   {17, 116, SYMMETRY_Tetrahedral, 1.32, &make_grid_tet_n116_l17},
   {19, 132, SYMMETRY_Icosahedral, 1.235, &make_grid_ico_n132_l19},
   {21, 170, SYMMETRY_Octahedral, 1.232, &make_grid_oct_n170_l21},
   {22, 186, SYMMETRY_Octahedral, 1.204, &make_grid_oct_n186_l22},
   {23, 192, SYMMETRY_Icosahedral, 1.298, &make_grid_ico_n192_l23},
   {27, 282, SYMMETRY_Icosahedral, 1.386, &make_grid_ico_n282_l27},
   {29, 314, SYMMETRY_Octahedral, 1.321, &make_grid_oct_n314_l29},
   {32, 372, SYMMETRY_Icosahedral, 1.427, &make_grid_ico_n372_l32},
   {35, 482, SYMMETRY_Icosahedral, 1.537, &make_grid_ico_n482_l35},
   {37, 492, SYMMETRY_Icosahedral, 1.178, &make_grid_ico_n492_l37},
   {42, 632, SYMMETRY_Icosahedral, 1.489, &make_grid_ico_n632_l42},
   {47, 812, SYMMETRY_Icosahedral, 1.273, &make_grid_ico_n812_l47},
   {56, 1112, SYMMETRY_Icosahedral, 1.224, &make_grid_ico_n1112_l56},
   {64, 1572, SYMMETRY_Icosahedral, 1.717, &make_grid_ico_n1572_l64},
   {69, 1832, SYMMETRY_Icosahedral, 1.698, &make_grid_ico_n1832_l69},
   {74, 2112, SYMMETRY_Icosahedral, 1.777, &make_grid_ico_n2112_l74}
};
