/* Copyright (c) 2015  Gerald Knizia
 * 
 * This file is part of the IboView program (see: http://www.iboview.org)
 * 
 * IboView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.
 * 
 * IboView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with bfint (LICENSE). If not, see http://www.gnu.org/licenses/
 * 
 * Please see IboView documentation in README.txt for:
 * -- A list of included external software and their licenses. The included
 *    external software's copyright is not touched by this agreement.
 * -- Notes on re-distribution and contributions to/further development of
 *    the IboView software
 */

#include "Iv.h"
#include "IvPreferencesForm.h"
#include "IvSettings.h"
// #include "QPropertyModel.h"
#include "ui_PreferencesForm.h"
#include <QSettings>
#include <QFileDialog>

FPreferencesForm::FPreferencesForm(FDocument *document, QWidget *parent)
   : QDialog(parent),
     ui(new Ui::PreferencesForm),
     m_pDocument(document)
{
   ui->setupUi(this);
   connect(ui->toolButton_ClearScriptFile, SIGNAL(clicked()), this, SLOT(ClearStartupScriptFile()));
   connect(ui->toolButton_FindScriptFile, SIGNAL(clicked()), this, SLOT(SearchStartupScriptFile()));

   QSettings
      settings;
   ui->lineEdit_StartupScriptFile->setText(settings.value("IboView/StartupScriptFile").toString());
}



FPreferencesForm::~FPreferencesForm()
{
   delete ui;
}

void FPreferencesForm::accept()
{
   QSettings
      settings;
   settings.setValue("IboView/StartupScriptFile", ui->lineEdit_StartupScriptFile->text());
   return QDialog::accept();
}

void FPreferencesForm::ClearStartupScriptFile()
{
   ui->lineEdit_StartupScriptFile->setText("");
}

void FPreferencesForm::SearchStartupScriptFile()
{
   QString FileName = QFileDialog::getOpenFileName(this, "Select Script File",
      "", "IboView Scripts (*.js);;All Files (*.*)");
   if (!FileName.isEmpty())
      ui->lineEdit_StartupScriptFile->setText(FileName);
}
