/* Copyright (c) 2015  Gerald Knizia
 * 
 * This file is part of the IboView program (see: http://www.iboview.org)
 * 
 * IboView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.
 * 
 * IboView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with bfint (LICENSE). If not, see http://www.gnu.org/licenses/
 * 
 * Please see IboView documentation in README.txt for:
 * -- A list of included external software and their licenses. The included
 *    external software's copyright is not touched by this agreement.
 * -- Notes on re-distribution and contributions to/further development of
 *    the IboView software
 */

/* CtAtomData.cpp v20140711 CET [storm, Gerald Knizia] */
#include "CtAtomData.h"

// see AtomicMassTable2.py

#include "CtAtomData.inl"

namespace ct {

// note: data in this file is from http://physics.nist.gov/cgi-bin/Compositions/stand_alone.pl?ele=&ascii=html&isotype=some (accessed: 2014-07-11)
char const *g_ElementNames[119] = {"X", "H", "He", "Li", "Be", "B", "C", "N",
   "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca",
   "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As",
   "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd",
   "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr",
   "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf",
   "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At",
   "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf",
   "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg",
   "Cn", "Uut", "Uuq", "Uup", "Uuh", "Uus", "Uuo"
};
double const g_ElementAverageMasses[119] = {-1, 1.00794, 4.002602, 6.941,
   9.012182, 10.811, 12.0107, 14.0067, 15.9994, 18.9984032, 20.1797,
   22.98976928, 24.3050, 26.9815386, 28.0855, 30.973762, 32.065, 35.453, 39.948,
   39.0983, 40.078, 44.955912, 47.867, 50.9415, 51.9961, 54.938045, 55.845,
   58.933195, 58.6934, 63.546, 65.38, 69.723, 72.64, 74.92160, 78.96, 79.904,
   83.798, 85.4678, 87.62, 88.90585, 91.224, 92.90638, 95.96, 98, 101.07,
   102.90550, 106.42, 107.8682, 112.411, 114.818, 118.710, 121.760, 127.60,
   126.90447, 131.293, 132.9054519, 137.327, 138.90547, 140.116, 140.90765,
   144.242, 145, 150.36, 151.964, 157.25, 158.92535, 162.500, 164.93032,
   167.259, 168.93421, 173.054, 174.9668, 178.49, 180.94788, 183.84, 186.207,
   190.23, 192.217, 195.084, 196.966569, 200.59, 204.3833, 207.2, 208.98040,
   209, 210, 222, 223, 226, 227, 232.03806, 231.03588, 238.02891, 237, 244, 243,
   247, 247, 251, 252, 257, 258, 259, 262, 265, 268, 271, 272, 270, 276, 281,
   280, 285, 284, 289, 288, 293, 292, 294
};
// note: for synthetic elements the isotope mass which is closest to the standard atomic mass is used.
double const g_ElementMostCommonIsotopeMasses[119] = {-1, 1.00782503207,
   4.00260325415, 7.01600455, 9.0121822, 11.0093054, 12.0000000, 14.0030740048,
   15.99491461956, 18.99840322, 19.9924401754, 22.9897692809, 23.985041700,
   26.98153863, 27.9769265325, 30.97376163, 31.97207100, 34.96885268,
   39.9623831225, 38.96370668, 39.96259098, 44.9559119, 47.9479463, 50.9439595,
   51.9405075, 54.9380451, 55.9349375, 58.9331950, 57.9353429, 62.9295975,
   63.9291422, 68.9255736, 73.9211778, 74.9215965, 79.9165213, 78.9183371,
   83.911507, 84.911789738, 87.9056121, 88.9058483, 89.9047044, 92.9063781,
   97.9054082, 97.907216, 101.9043493, 102.905504, 105.903486, 106.905097,
   113.9033585, 114.903878, 119.9021947, 120.9038157, 129.9062244, 126.904473,
   131.9041535, 132.905451933, 137.9052472, 138.9063533, 139.9054387,
   140.9076528, 141.9077233, 144.912749, 151.9197324, 152.9212303, 157.9241039,
   158.9253468, 163.9291748, 164.9303221, 165.9302931, 168.9342133, 173.9388621,
   174.9407718, 179.9465500, 180.9479958, 183.9509312, 186.9557531, 191.9614807,
   192.9629264, 194.9647911, 196.9665687, 201.9706430, 204.9744275, 207.9766521,
   208.9803987, 208.9824304, 209.987148, 222.0175777, 223.0197359, 226.0254098,
   227.0277521, 232.0380553, 231.0358840, 238.0507882, 237.0481734, 244.064204,
   243.0613811, 247.070354, 247.070307, 251.079587, 252.082980, 257.095105,
   258.098431, 259.10103, 262.10963, 265.11670, 268.12545, 271.13347, 272.13803,
   270.13465, 276.15116, 281.16206, 280.16447, 285.17411, 284.17808, 289.18728,
   288.19249, 293, 292.20755, 294
};
// iElement, Number of nucleons, mass/[amu], relative natural abundance
FIsotopeInfo const g_IsotopeInfo[355] = {
   {  1,   1,   1.00782503207,   0.999885, "1 H"},
   {  1,   2,    2.0141017778,   0.000115, "2 H"},
   {  1,   3,    3.0160492777,        0.0, "3 H"},
   {  2,   4,   4.00260325415, 0.99999866, "4 He"},
   {  2,   3,    3.0160293191, 0.00000134, "3 He"},
   {  3,   7,      7.01600455,     0.9241, "7 Li"},
   {  3,   6,     6.015122795,     0.0759, "6 Li"},
   {  4,   9,       9.0121822,     1.0000, "9 Be"},
   {  5,  11,      11.0093054,      0.801, "11 B"},
   {  5,  10,      10.0129370,      0.199, "10 B"},
   {  6,  12,      12.0000000,     0.9893, "12 C"},
   {  6,  13,   13.0033548378,     0.0107, "13 C"},
   {  6,  14,    14.003241989,        0.0, "14 C"},
   {  7,  14,   14.0030740048,    0.99636, "14 N"},
   {  7,  15,   15.0001088982,    0.00364, "15 N"},
   {  8,  16,  15.99491461956,    0.99757, "16 O"},
   {  8,  18,      17.9991610,    0.00205, "18 O"},
   {  8,  17,     16.99913170,    0.00038, "17 O"},
   {  9,  19,     18.99840322,     1.0000, "19 F"},
   { 10,  20,   19.9924401754,     0.9048, "20 Ne"},
   { 10,  22,    21.991385114,     0.0925, "22 Ne"},
   { 10,  21,     20.99384668,     0.0027, "21 Ne"},
   { 11,  23,   22.9897692809,     1.0000, "23 Na"},
   { 12,  24,    23.985041700,     0.7899, "24 Mg"},
   { 12,  26,    25.982592929,     0.1101, "26 Mg"},
   { 12,  25,     24.98583692,     0.1000, "25 Mg"},
   { 13,  27,     26.98153863,     1.0000, "27 Al"},
   { 14,  28,   27.9769265325,    0.92223, "28 Si"},
   { 14,  29,    28.976494700,    0.04685, "29 Si"},
   { 14,  30,     29.97377017,    0.03092, "30 Si"},
   { 15,  31,     30.97376163,     1.0000, "31 P"},
   { 16,  32,     31.97207100,     0.9499, "32 S"},
   { 16,  34,     33.96786690,     0.0425, "34 S"},
   { 16,  33,     32.97145876,     0.0075, "33 S"},
   { 16,  36,     35.96708076,     0.0001, "36 S"},
   { 17,  35,     34.96885268,     0.7576, "35 Cl"},
   { 17,  37,     36.96590259,     0.2424, "37 Cl"},
   { 18,  40,   39.9623831225,   0.996003, "40 Ar"},
   { 18,  36,    35.967545106,   0.003365, "36 Ar"},
   { 18,  38,      37.9627324,   0.000632, "38 Ar"},
   { 19,  39,     38.96370668,   0.932581, "39 K"},
   { 19,  41,     40.96182576,   0.067302, "41 K"},
   { 19,  40,     39.96399848,   0.000117, "40 K"},
   { 20,  40,     39.96259098,    0.96941, "40 Ca"},
   { 20,  44,      43.9554818,    0.02086, "44 Ca"},
   { 20,  42,     41.95861801,    0.00647, "42 Ca"},
   { 20,  48,       47.952534,    0.00187, "48 Ca"},
   { 20,  43,      42.9587666,    0.00135, "43 Ca"},
   { 20,  46,      45.9536926,    0.00004, "46 Ca"},
   { 21,  45,      44.9559119,     1.0000, "45 Sc"},
   { 22,  48,      47.9479463,     0.7372, "48 Ti"},
   { 22,  46,      45.9526316,     0.0825, "46 Ti"},
   { 22,  47,      46.9517631,     0.0744, "47 Ti"},
   { 22,  49,      48.9478700,     0.0541, "49 Ti"},
   { 22,  50,      49.9447912,     0.0518, "50 Ti"},
   { 23,  51,      50.9439595,    0.99750, "51 V"},
   { 23,  50,      49.9471585,    0.00250, "50 V"},
   { 24,  52,      51.9405075,    0.83789, "52 Cr"},
   { 24,  53,      52.9406494,    0.09501, "53 Cr"},
   { 24,  50,      49.9460442,    0.04345, "50 Cr"},
   { 24,  54,      53.9388804,    0.02365, "54 Cr"},
   { 25,  55,      54.9380451,     1.0000, "55 Mn"},
   { 26,  56,      55.9349375,    0.91754, "56 Fe"},
   { 26,  54,      53.9396105,    0.05845, "54 Fe"},
   { 26,  57,      56.9353940,    0.02119, "57 Fe"},
   { 26,  58,      57.9332756,    0.00282, "58 Fe"},
   { 27,  59,      58.9331950,     1.0000, "59 Co"},
   { 28,  58,      57.9353429,   0.680769, "58 Ni"},
   { 28,  60,      59.9307864,   0.262231, "60 Ni"},
   { 28,  62,      61.9283451,   0.036345, "62 Ni"},
   { 28,  61,      60.9310560,   0.011399, "61 Ni"},
   { 28,  64,      63.9279660,   0.009256, "64 Ni"},
   { 29,  63,      62.9295975,     0.6915, "63 Cu"},
   { 29,  65,      64.9277895,     0.3085, "65 Cu"},
   { 30,  64,      63.9291422,    0.48268, "64 Zn"},
   { 30,  66,      65.9260334,    0.27975, "66 Zn"},
   { 30,  68,      67.9248442,    0.19024, "68 Zn"},
   { 30,  67,      66.9271273,    0.04102, "67 Zn"},
   { 30,  70,      69.9253193,    0.00631, "70 Zn"},
   { 31,  69,      68.9255736,    0.60108, "69 Ga"},
   { 31,  71,      70.9247013,    0.39892, "71 Ga"},
   { 32,  74,      73.9211778,     0.3672, "74 Ge"},
   { 32,  72,      71.9220758,     0.2731, "72 Ge"},
   { 32,  70,      69.9242474,     0.2038, "70 Ge"},
   { 32,  76,      75.9214026,     0.0783, "76 Ge"},
   { 32,  73,      72.9234589,     0.0776, "73 Ge"},
   { 33,  75,      74.9215965,     1.0000, "75 As"},
   { 34,  80,      79.9165213,     0.4961, "80 Se"},
   { 34,  78,      77.9173091,     0.2377, "78 Se"},
   { 34,  76,      75.9192136,     0.0937, "76 Se"},
   { 34,  82,      81.9166994,     0.0873, "82 Se"},
   { 34,  77,      76.9199140,     0.0763, "77 Se"},
   { 34,  74,      73.9224764,     0.0089, "74 Se"},
   { 35,  79,      78.9183371,     0.5069, "79 Br"},
   { 35,  81,      80.9162906,     0.4931, "81 Br"},
   { 36,  84,       83.911507,    0.56987, "84 Kr"},
   { 36,  86,     85.91061073,    0.17279, "86 Kr"},
   { 36,  82,      81.9134836,    0.11593, "82 Kr"},
   { 36,  83,       82.914136,    0.11500, "83 Kr"},
   { 36,  80,      79.9163790,    0.02286, "80 Kr"},
   { 36,  78,      77.9203648,    0.00355, "78 Kr"},
   { 37,  85,    84.911789738,     0.7217, "85 Rb"},
   { 37,  87,    86.909180527,     0.2783, "87 Rb"},
   { 38,  88,      87.9056121,     0.8258, "88 Sr"},
   { 38,  86,      85.9092602,     0.0986, "86 Sr"},
   { 38,  87,      86.9088771,     0.0700, "87 Sr"},
   { 38,  84,       83.913425,     0.0056, "84 Sr"},
   { 39,  89,      88.9058483,     1.0000, "89 Y"},
   { 40,  90,      89.9047044,     0.5145, "90 Zr"},
   { 40,  94,      93.9063152,     0.1738, "94 Zr"},
   { 40,  92,      91.9050408,     0.1715, "92 Zr"},
   { 40,  91,      90.9056458,     0.1122, "91 Zr"},
   { 40,  96,      95.9082734,     0.0280, "96 Zr"},
   { 41,  93,      92.9063781,     1.0000, "93 Nb"},
   { 42,  98,      97.9054082,     0.2419, "98 Mo"},
   { 42,  96,      95.9046795,     0.1668, "96 Mo"},
   { 42,  95,      94.9058421,     0.1590, "95 Mo"},
   { 42,  92,       91.906811,     0.1477, "92 Mo"},
   { 42, 100,       99.907477,     0.0967, "100 Mo"},
   { 42,  97,      96.9060215,     0.0956, "97 Mo"},
   { 42,  94,      93.9050883,     0.0923, "94 Mo"},
   { 43,  98,       97.907216,         -1, "98 Tc"}, // (synthetic)
   { 43,  99,      98.9062547,         -1, "99 Tc"}, // (synthetic)
   { 43,  97,       96.906365,         -1, "97 Tc"}, // (synthetic)
   { 44, 102,     101.9043493,     0.3155, "102 Ru"},
   { 44, 104,      103.905433,     0.1862, "104 Ru"},
   { 44, 101,     100.9055821,     0.1706, "101 Ru"},
   { 44,  99,      98.9059393,     0.1276, "99 Ru"},
   { 44, 100,      99.9042195,     0.1260, "100 Ru"},
   { 44,  96,       95.907598,     0.0554, "96 Ru"},
   { 44,  98,       97.905287,     0.0187, "98 Ru"},
   { 45, 103,      102.905504,     1.0000, "103 Rh"},
   { 46, 106,      105.903486,     0.2733, "106 Pd"},
   { 46, 108,      107.903892,     0.2646, "108 Pd"},
   { 46, 105,      104.905085,     0.2233, "105 Pd"},
   { 46, 110,      109.905153,     0.1172, "110 Pd"},
   { 46, 104,      103.904036,     0.1114, "104 Pd"},
   { 46, 102,      101.905609,     0.0102, "102 Pd"},
   { 47, 107,      106.905097,    0.51839, "107 Ag"},
   { 47, 109,      108.904752,    0.48161, "109 Ag"},
   { 48, 114,     113.9033585,     0.2873, "114 Cd"},
   { 48, 112,     111.9027578,     0.2413, "112 Cd"},
   { 48, 111,     110.9041781,     0.1280, "111 Cd"},
   { 48, 110,     109.9030021,     0.1249, "110 Cd"},
   { 48, 113,     112.9044017,     0.1222, "113 Cd"},
   { 48, 116,      115.904756,     0.0749, "116 Cd"},
   { 48, 106,      105.906459,     0.0125, "106 Cd"},
   { 48, 108,      107.904184,     0.0089, "108 Cd"},
   { 49, 115,      114.903878,     0.9571, "115 In"},
   { 49, 113,      112.904058,     0.0429, "113 In"},
   { 50, 120,     119.9021947,     0.3258, "120 Sn"},
   { 50, 118,      117.901603,     0.2422, "118 Sn"},
   { 50, 116,      115.901741,     0.1454, "116 Sn"},
   { 50, 119,      118.903308,     0.0859, "119 Sn"},
   { 50, 117,      116.902952,     0.0768, "117 Sn"},
   { 50, 124,     123.9052739,     0.0579, "124 Sn"},
   { 50, 122,     121.9034390,     0.0463, "122 Sn"},
   { 50, 112,      111.904818,     0.0097, "112 Sn"},
   { 50, 114,      113.902779,     0.0066, "114 Sn"},
   { 50, 115,      114.903342,     0.0034, "115 Sn"},
   { 51, 121,     120.9038157,     0.5721, "121 Sb"},
   { 51, 123,     122.9042140,     0.4279, "123 Sb"},
   { 52, 130,     129.9062244,     0.3408, "130 Te"},
   { 52, 128,     127.9044631,     0.3174, "128 Te"},
   { 52, 126,     125.9033117,     0.1884, "126 Te"},
   { 52, 125,     124.9044307,     0.0707, "125 Te"},
   { 52, 124,     123.9028179,     0.0474, "124 Te"},
   { 52, 122,     121.9030439,     0.0255, "122 Te"},
   { 52, 123,     122.9042700,     0.0089, "123 Te"},
   { 52, 120,      119.904020,     0.0009, "120 Te"},
   { 53, 127,      126.904473,     1.0000, "127 I"},
   { 54, 132,     131.9041535,   0.269086, "132 Xe"},
   { 54, 129,     128.9047794,   0.264006, "129 Xe"},
   { 54, 131,     130.9050824,   0.212324, "131 Xe"},
   { 54, 134,     133.9053945,   0.104357, "134 Xe"},
   { 54, 136,      135.907219,   0.088573, "136 Xe"},
   { 54, 130,     129.9035080,   0.040710, "130 Xe"},
   { 54, 128,     127.9035313,   0.019102, "128 Xe"},
   { 54, 124,     123.9058930,   0.000952, "124 Xe"},
   { 54, 126,      125.904274,   0.000890, "126 Xe"},
   { 55, 133,   132.905451933,     1.0000, "133 Cs"},
   { 56, 138,     137.9052472,    0.71698, "138 Ba"},
   { 56, 137,     136.9058274,    0.11232, "137 Ba"},
   { 56, 136,     135.9045759,    0.07854, "136 Ba"},
   { 56, 135,     134.9056886,    0.06592, "135 Ba"},
   { 56, 134,     133.9045084,    0.02417, "134 Ba"},
   { 56, 130,     129.9063208,    0.00106, "130 Ba"},
   { 56, 132,     131.9050613,    0.00101, "132 Ba"},
   { 57, 139,     138.9063533,    0.99910, "139 La"},
   { 57, 138,      137.907112,    0.00090, "138 La"},
   { 58, 140,     139.9054387,    0.88450, "140 Ce"},
   { 58, 142,      141.909244,    0.11114, "142 Ce"},
   { 58, 138,      137.905991,    0.00251, "138 Ce"},
   { 58, 136,      135.907172,    0.00185, "136 Ce"},
   { 59, 141,     140.9076528,     1.0000, "141 Pr"},
   { 60, 142,     141.9077233,      0.272, "142 Nd"},
   { 60, 144,     143.9100873,      0.238, "144 Nd"},
   { 60, 146,     145.9131169,      0.172, "146 Nd"},
   { 60, 143,     142.9098143,      0.122, "143 Nd"},
   { 60, 145,     144.9125736,      0.083, "145 Nd"},
   { 60, 148,      147.916893,      0.057, "148 Nd"},
   { 60, 150,      149.920891,      0.056, "150 Nd"},
   { 61, 145,      144.912749,         -1, "145 Pm"}, // (synthetic)
   { 61, 147,     146.9151385,         -1, "147 Pm"}, // (synthetic)
   { 62, 152,     151.9197324,     0.2675, "152 Sm"},
   { 62, 154,     153.9222093,     0.2275, "154 Sm"},
   { 62, 147,     146.9148979,     0.1499, "147 Sm"},
   { 62, 149,     148.9171847,     0.1382, "149 Sm"},
   { 62, 148,     147.9148227,     0.1124, "148 Sm"},
   { 62, 150,     149.9172755,     0.0738, "150 Sm"},
   { 62, 144,      143.911999,     0.0307, "144 Sm"},
   { 63, 153,     152.9212303,     0.5219, "153 Eu"},
   { 63, 151,     150.9198502,     0.4781, "151 Eu"},
   { 64, 158,     157.9241039,     0.2484, "158 Gd"},
   { 64, 160,     159.9270541,     0.2186, "160 Gd"},
   { 64, 156,     155.9221227,     0.2047, "156 Gd"},
   { 64, 157,     156.9239601,     0.1565, "157 Gd"},
   { 64, 155,     154.9226220,     0.1480, "155 Gd"},
   { 64, 154,     153.9208656,     0.0218, "154 Gd"},
   { 64, 152,     151.9197910,     0.0020, "152 Gd"},
   { 65, 159,     158.9253468,     1.0000, "159 Tb"},
   { 66, 164,     163.9291748,    0.28260, "164 Dy"},
   { 66, 162,     161.9267984,    0.25475, "162 Dy"},
   { 66, 163,     162.9287312,    0.24896, "163 Dy"},
   { 66, 161,     160.9269334,    0.18889, "161 Dy"},
   { 66, 160,     159.9251975,    0.02329, "160 Dy"},
   { 66, 158,      157.924409,    0.00095, "158 Dy"},
   { 66, 156,      155.924283,    0.00056, "156 Dy"},
   { 67, 165,     164.9303221,     1.0000, "165 Ho"},
   { 68, 166,     165.9302931,    0.33503, "166 Er"},
   { 68, 168,     167.9323702,    0.26978, "168 Er"},
   { 68, 167,     166.9320482,    0.22869, "167 Er"},
   { 68, 170,     169.9354643,    0.14910, "170 Er"},
   { 68, 164,      163.929200,    0.01601, "164 Er"},
   { 68, 162,      161.928778,    0.00139, "162 Er"},
   { 69, 169,     168.9342133,     1.0000, "169 Tm"},
   { 70, 174,     173.9388621,     0.3183, "174 Yb"},
   { 70, 172,     171.9363815,     0.2183, "172 Yb"},
   { 70, 173,     172.9382108,     0.1613, "173 Yb"},
   { 70, 171,     170.9363258,     0.1428, "171 Yb"},
   { 70, 176,     175.9425717,     0.1276, "176 Yb"},
   { 70, 170,     169.9347618,     0.0304, "170 Yb"},
   { 70, 168,      167.933897,     0.0013, "168 Yb"},
   { 71, 175,     174.9407718,     0.9741, "175 Lu"},
   { 71, 176,     175.9426863,     0.0259, "176 Lu"},
   { 72, 180,     179.9465500,     0.3508, "180 Hf"},
   { 72, 178,     177.9436988,     0.2728, "178 Hf"},
   { 72, 177,     176.9432207,     0.1860, "177 Hf"},
   { 72, 179,     178.9458161,     0.1362, "179 Hf"},
   { 72, 176,     175.9414086,     0.0526, "176 Hf"},
   { 72, 174,      173.940046,     0.0016, "174 Hf"},
   { 73, 181,     180.9479958,    0.99988, "181 Ta"},
   { 73, 180,     179.9474648,    0.00012, "180 Ta"},
   { 74, 184,     183.9509312,     0.3064, "184 W"},
   { 74, 186,     185.9543641,     0.2843, "186 W"},
   { 74, 182,     181.9482042,     0.2650, "182 W"},
   { 74, 183,     182.9502230,     0.1431, "183 W"},
   { 74, 180,      179.946704,     0.0012, "180 W"},
   { 75, 187,     186.9557531,     0.6260, "187 Re"},
   { 75, 185,     184.9529550,     0.3740, "185 Re"},
   { 76, 192,     191.9614807,     0.4078, "192 Os"},
   { 76, 190,     189.9584470,     0.2626, "190 Os"},
   { 76, 189,     188.9581475,     0.1615, "189 Os"},
   { 76, 188,     187.9558382,     0.1324, "188 Os"},
   { 76, 187,     186.9557505,     0.0196, "187 Os"},
   { 76, 186,     185.9538382,     0.0159, "186 Os"},
   { 76, 184,     183.9524891,     0.0002, "184 Os"},
   { 77, 193,     192.9629264,      0.627, "193 Ir"},
   { 77, 191,     190.9605940,      0.373, "191 Ir"},
   { 78, 195,     194.9647911,    0.33832, "195 Pt"},
   { 78, 194,     193.9626803,    0.32967, "194 Pt"},
   { 78, 196,     195.9649515,    0.25242, "196 Pt"},
   { 78, 198,      197.967893,    0.07163, "198 Pt"},
   { 78, 192,     191.9610380,    0.00782, "192 Pt"},
   { 78, 190,      189.959932,    0.00014, "190 Pt"},
   { 79, 197,     196.9665687,     1.0000, "197 Au"},
   { 80, 202,     201.9706430,     0.2986, "202 Hg"},
   { 80, 200,     199.9683260,     0.2310, "200 Hg"},
   { 80, 199,     198.9682799,     0.1687, "199 Hg"},
   { 80, 201,     200.9703023,     0.1318, "201 Hg"},
   { 80, 198,     197.9667690,     0.0997, "198 Hg"},
   { 80, 204,     203.9734939,     0.0687, "204 Hg"},
   { 80, 196,      195.965833,     0.0015, "196 Hg"},
   { 81, 205,     204.9744275,     0.7048, "205 Tl"},
   { 81, 203,     202.9723442,     0.2952, "203 Tl"},
   { 82, 208,     207.9766521,      0.524, "208 Pb"},
   { 82, 206,     205.9744653,      0.241, "206 Pb"},
   { 82, 207,     206.9758969,      0.221, "207 Pb"},
   { 82, 204,     203.9730436,      0.014, "204 Pb"},
   { 83, 209,     208.9803987,     1.0000, "209 Bi"},
   { 84, 209,     208.9824304,         -1, "209 Po"}, // (synthetic)
   { 84, 210,     209.9828737,         -1, "210 Po"}, // (synthetic)
   { 85, 210,      209.987148,         -1, "210 At"}, // (synthetic)
   { 85, 211,     210.9874963,         -1, "211 At"}, // (synthetic)
   { 86, 222,     222.0175777,         -1, "222 Rn"}, // (synthetic)
   { 86, 220,     220.0113940,         -1, "220 Rn"}, // (synthetic)
   { 86, 211,      210.990601,         -1, "211 Rn"}, // (synthetic)
   { 87, 223,     223.0197359,         -1, "223 Fr"}, // (synthetic)
   { 88, 226,     226.0254098,         -1, "226 Ra"}, // (synthetic)
   { 88, 224,     224.0202118,         -1, "224 Ra"}, // (synthetic)
   { 88, 228,     228.0310703,         -1, "228 Ra"}, // (synthetic)
   { 88, 223,     223.0185022,         -1, "223 Ra"}, // (synthetic)
   { 89, 227,     227.0277521,         -1, "227 Ac"}, // (synthetic)
   { 90, 232,     232.0380553,     1.0000, "232 Th"},
   { 90, 230,     230.0331338,     0.0000, "230 Th"},
   { 91, 231,     231.0358840,     1.0000, "231 Pa"},
   { 92, 238,     238.0507882,   0.992742, "238 U"},
   { 92, 235,     235.0439299,   0.007204, "235 U"},
   { 92, 234,     234.0409521,   0.000054, "234 U"},
   { 92, 236,     236.0455680,        0.0, "236 U"},
   { 92, 233,     233.0396352,        0.0, "233 U"},
   { 93, 237,     237.0481734,         -1, "237 Np"}, // (synthetic)
   { 93, 236,      236.046570,         -1, "236 Np"}, // (synthetic)
   { 94, 244,      244.064204,         -1, "244 Pu"}, // (synthetic)
   { 94, 242,     242.0587426,         -1, "242 Pu"}, // (synthetic)
   { 94, 241,     241.0568515,         -1, "241 Pu"}, // (synthetic)
   { 94, 240,     240.0538135,         -1, "240 Pu"}, // (synthetic)
   { 94, 239,     239.0521634,         -1, "239 Pu"}, // (synthetic)
   { 94, 238,     238.0495599,         -1, "238 Pu"}, // (synthetic)
   { 95, 243,     243.0613811,         -1, "243 Am"}, // (synthetic)
   { 95, 241,     241.0568291,         -1, "241 Am"}, // (synthetic)
   { 96, 247,      247.070354,         -1, "247 Cm"}, // (synthetic)
   { 96, 246,     246.0672237,         -1, "246 Cm"}, // (synthetic)
   { 96, 248,      248.072349,         -1, "248 Cm"}, // (synthetic)
   { 96, 245,     245.0654912,         -1, "245 Cm"}, // (synthetic)
   { 96, 244,     244.0627526,         -1, "244 Cm"}, // (synthetic)
   { 96, 243,     243.0613891,         -1, "243 Cm"}, // (synthetic)
   { 97, 247,      247.070307,         -1, "247 Bk"}, // (synthetic)
   { 97, 249,     249.0749867,         -1, "249 Bk"}, // (synthetic)
   { 98, 251,      251.079587,         -1, "251 Cf"}, // (synthetic)
   { 98, 250,     250.0764061,         -1, "250 Cf"}, // (synthetic)
   { 98, 252,      252.081626,         -1, "252 Cf"}, // (synthetic)
   { 98, 249,     249.0748535,         -1, "249 Cf"}, // (synthetic)
   { 99, 252,      252.082980,         -1, "252 Es"}, // (synthetic)
   {100, 257,      257.095105,         -1, "257 Fm"}, // (synthetic)
   {101, 258,      258.098431,         -1, "258 Md"}, // (synthetic)
   {101, 260,       260.10365,         -1, "260 Md"}, // (synthetic)
   {102, 259,       259.10103,         -1, "259 No"}, // (synthetic)
   {103, 262,       262.10963,         -1, "262 Lr"}, // (synthetic)
   {104, 265,       265.11670,         -1, "265 Rf"}, // (synthetic)
   {105, 268,       268.12545,         -1, "268 Db"}, // (synthetic)
   {106, 271,       271.13347,         -1, "271 Sg"}, // (synthetic)
   {107, 272,       272.13803,         -1, "272 Bh"}, // (synthetic)
   {108, 270,       270.13465,         -1, "270 Hs"}, // (synthetic)
   {109, 276,       276.15116,         -1, "276 Mt"}, // (synthetic)
   {110, 281,       281.16206,         -1, "281 Ds"}, // (synthetic)
   {111, 280,       280.16447,         -1, "280 Rg"}, // (synthetic)
   {112, 285,       285.17411,         -1, "285 Cn"}, // (synthetic)
   {113, 284,       284.17808,         -1, "284 Uut"}, // (synthetic)
   {114, 289,       289.18728,         -1, "289 Uuq"}, // (synthetic)
   {115, 288,       288.19249,         -1, "288 Uup"}, // (synthetic)
   {116, 293,             293,         -1, "293 Uuh"}, // (synthetic)
   {117, 292,       292.20755,         -1, "292 Uus"}, // (synthetic)
   {118, 294,             294,         -1, "294 Uuo"}, // (synthetic)
   {0, 0, 0, -1, "X"}
};
unsigned const g_IsotopeInfoElementOffsets[120] = {0, 0, 3, 5, 7, 8, 10, 13,
   15, 18, 19, 22, 23, 26, 27, 30, 31, 35, 37, 40, 43, 49, 50, 55, 57, 61, 62,
   66, 67, 72, 74, 79, 81, 86, 87, 93, 95, 101, 103, 107, 108, 113, 114, 121,
   124, 131, 132, 138, 140, 148, 150, 160, 162, 170, 171, 180, 181, 188, 190,
   194, 195, 202, 204, 211, 213, 220, 221, 228, 229, 235, 236, 243, 245, 251,
   253, 258, 260, 267, 269, 275, 276, 283, 285, 289, 290, 292, 294, 297, 298,
   302, 303, 305, 306, 311, 313, 319, 321, 327, 329, 333, 334, 335, 337, 338,
   339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353,
   354
};
// Covalent radii in bohr units; the table is a mixture of data derived from
// http://en.wikipedia.org/wiki/Atomic_radii_of_the_elements_%28data_page%29
// and from UFF bond radii as follows:
//   1. If the above table has a single bond covalent radius, take it.
//   2. Otherwise, if the above table has a metallic bond radius, take it.
//   3. Otherwise, take UFF bond radius if present.
//   4. If there is still no data, use 3.2
double const g_CovalentRadii[119] = {0.0,   0.7181,   0.6047,   2.5322,
   1.7008,   1.5496,   1.4551,   1.4173,   1.3795,   1.3417,   1.3039,   2.9102,
   2.4566,   2.2299,   2.0976,   2.0031,   1.9275,   1.8708,   1.8330,   3.7039,
   3.2881,   2.7212,   2.5700,   2.3622,   2.4000,   2.6267,   2.3622,   2.3811,
   2.2866,   2.6078,   2.4755,   2.3811,   2.3055,   2.2488,   2.1921,   2.1543,
   2.0787,   3.9873,   3.6283,   3.0614,   2.7968,   2.5889,   2.7401,   2.9480,
   2.3811,   2.5511,   2.4755,   2.8913,   2.7968,   2.7212,   2.6645,   2.6078,
   2.5511,   2.5133,   2.4566,   4.2519,   3.7417,   3.1936,   3.4355,   3.4469,
   3.4280,   3.4658,   3.4091,   3.4091,   3.4091,   3.3505,   3.3656,   3.3297,
   3.3278,   3.3240,   3.3259,   3.0236,   2.8346,   2.6078,   2.7590,   3.0047,
   2.4188,   2.5889,   2.4188,   2.7212,   2.8157,   2.7968,   2.7779,   2.7590,
   2.8300,   2.9200,   2.7401,   5.4400,   4.7500,   3.7500,   3.3826,   3.0803,
   2.9480,   2.9291,   3.0047,   3.2692,   3.2881,   3.2125,   3.5149,   3.5149,
   3.2400,   3.1900,   3.1700,   3.2100,   3.2000,   3.2000,   3.2000,   3.2000,
   3.2000,   3.2000,   3.2000,   3.2000,   3.2000,   3.2000,   3.2000,   3.2000,
   3.2000,   3.2000,   3.2000
};
} // namespace ct
