/* IrBoysFn.inl v20121214 EST [storm, Gerald Knizia] */
namespace ir {
   static unsigned const
      StepsPerT = 8, // first entry: T=0, other: equidistant entries at distance 1/StepsPerT.
      TableSize = 97, // number of tabulated points. Each point comes with one set of derivatives.
      TableOrder = 32, // tabulated are Fm(T) for m = 0..TableOrder-1
      TableMaxM = 24, // maximum m allowed. Differs from TableOrder because we still need some derivatives for Taylor expansion.
      TaylorOrder = 8;

   static double const
      TsPerStep = 1.25e-01,
      HalfSqrtPi = 8.8622692545275794e-01;

   // Denominators for downward recursion. It's just 1/(2*m+1).
   static double const Inv2mp1[32] = {
      1., 3.3333333333333331e-01, 2.0000000000000001e-01, 1.4285714285714285e-01, 1.111111111111111e-01, 9.0909090909090912e-02, 7.6923076923076927e-02, 6.6666666666666666e-02, 5.8823529411764705e-02, 5.2631578947368418e-02, 4.7619047619047616e-02, 4.3478260869565216e-02, 4.0000000000000001e-02, 3.7037037037037035e-02, 3.4482758620689655e-02, 3.2258064516129031e-02, 3.0303030303030304e-02, 2.8571428571428571e-02, 2.7027027027027029e-02, 2.564102564102564e-02, 2.4390243902439025e-02, 2.3255813953488372e-02, 2.2222222222222223e-02, 2.1276595744680851e-02, 2.0408163265306121e-02, 1.9607843137254902e-02, 1.8867924528301886e-02, 1.8181818181818181e-02, 1.7543859649122806e-02, 1.6949152542372881e-02, 1.6393442622950821e-02, 1.5873015873015872e-02
   }; // 0.25 kb

   // This is a TableOrder x TableSize matrix of Fm(T) values. The values have full 1e-16 precision.
   static double const BoysData[3104] = {
      1., 3.3333333333333331e-01, 2.0000000000000001e-01, 1.4285714285714285e-01, 1.111111111111111e-01, 9.0909090909090912e-02, 7.6923076923076927e-02, 6.6666666666666666e-02, 5.8823529411764705e-02, 5.2631578947368418e-02, 4.7619047619047616e-02, 4.3478260869565216e-02, 4.0000000000000001e-02, 3.7037037037037035e-02, 3.4482758620689655e-02, 3.2258064516129031e-02, 3.0303030303030304e-02, 2.8571428571428571e-02, 2.7027027027027029e-02, 2.564102564102564e-02, 2.4390243902439025e-02, 2.3255813953488372e-02, 2.2222222222222223e-02, 2.1276595744680851e-02, 2.0408163265306121e-02, 1.9607843137254902e-02, 1.8867924528301886e-02, 1.8181818181818181e-02, 1.7543859649122806e-02, 1.6949152542372881e-02, 1.6393442622950821e-02, 1.5873015873015872e-02,
      9.5985043791976843e-01, 3.0941414134069212e-01, 1.8298208574992381e-01, 1.2965410466009467e-01, 1.0032732014426918e-01, 8.1795914855309043e-02, 6.9032643295216717e-02, 5.9709841012887718e-02, 5.260285043488188e-02, 4.7006219233586451e-02, 4.2485051414188998e-02, 3.8756708453494694e-02, 3.5629567383130376e-02, 3.2969127974656495e-02, 3.0678210924520423e-02, 2.8684856905987773e-02, 2.6934646004102475e-02, 2.538566220314532e-02, 2.4005098101963548e-02, 2.2766908752223584e-02, 2.165015500849795e-02, 2.0637811055282208e-02, 1.9715891170158609e-02, 1.8872800290168378e-02, 1.8098844213273586e-02, 1.7385855463241812e-02, 1.6726904162948475e-02, 1.6116072206695451e-02, 1.554827513461828e-02, 1.5019120354586317e-02, 1.4524793343989347e-02, 1.4061965595019345e-02,
      9.2256201282558481e-01, 2.8752245950836003e-01, 1.6753319090735061e-01, 1.1773034293069641e-01, 9.0623234886940005e-02, 7.3616661822110463e-02, 6.1964993943620518e-02, 5.3488276391323905e-02, 4.7046725596907542e-02, 4.1987104152046872e-02, 3.7908391634971644e-02, 3.4550882525999416e-02, 3.1739030053163385e-02, 2.9349936515359588e-02, 2.7295005686608045e-02, 2.5508763680456924e-02, 2.3941782045519708e-02, 2.2556048861491169e-02, 2.1321854161572291e-02, 2.0215641813539988e-02, 1.9218495313309401e-02, 1.83150495485613e-02, 1.7492695033462187e-02, 1.6740986868787389e-02, 1.6051199523205089e-02, 1.5415987131289242e-02, 1.4829121248693027e-02, 1.4285286218651171e-02, 1.3779917908819174e-02, 1.3309075462576134e-02, 1.2869338441174055e-02, 1.2457723680425099e-02,
      8.878931382305062e-01, 2.6747181258604541e-01, 1.5350154528955209e-01, 1.0695793020905119e-01, 8.1888310229848146e-02, 6.6274017703548224e-02, 5.5633221264077791e-02, 4.7923463522718888e-02, 4.2083565399748231e-02, 3.7508444006330369e-02, 3.3828209772406574e-02, 3.0804168572754562e-02, 2.827546450984365e-02, 2.6129778606825502e-02, 2.4286324791088571e-02, 2.2685520200795221e-02, 2.1282463244906354e-02, 2.0042677721250023e-02, 1.8939255270371512e-02, 1.7950888283698351e-02, 1.7060485697684771e-02, 1.6254179752137991e-02, 1.5520600734615322e-02, 1.4850339022289818e-02, 1.4235540342199095e-02, 1.3669597302377975e-02, 1.3146911507072817e-02, 1.2662708111849488e-02, 1.2212889814332868e-02, 1.1793920834668478e-02, 1.1402733939290793e-02, 1.1036655341021603e-02,
      8.5562439189214878e-01, 2.4909373217951536e-01, 1.4075053682591271e-01, 9.7222024416930147e-02, 7.4023511205877635e-02, 5.9680941140265328e-02, 4.9959692830285257e-02, 4.2945347081074961e-02, 3.7649546503490991e-02, 3.3511630846713526e-02, 3.01903263749237e-02, 2.7466194160764314e-02, 2.5191805984945876e-02, 2.3264489911013493e-02, 2.1610567884730963e-02, 2.0175808944564527e-02, 1.8919417568866937e-02, 1.7810120059975565e-02, 1.6823542386511455e-02, 1.5940408588290444e-02, 1.5145275230694005e-02, 1.4425624745820795e-02, 1.377120435766082e-02, 1.3173536382103472e-02, 1.262555024622981e-02, 1.2121302352627282e-02, 1.165576027135796e-02, 1.1224634669338469e-02, 1.0824247100982447e-02, 1.0451425043366066e-02, 1.0103417845964496e-02, 9.7778288912008637e-03,
      8.2555637923339031e-01, 2.322359605715201e-01, 1.2915716255645607e-01, 8.8419507410632092e-02, 6.6940098684347554e-02, 5.3759567712110268e-02, 4.4875053051378164e-02, 3.8491408919140727e-02, 3.3687764214496541e-02, 2.9944450501960793e-02, 2.6946504814611881e-02, 2.4492138070287415e-02, 2.2446197678096299e-02, 2.0714810746733842e-02, 1.9230769314258812e-02, 1.7944705275612281e-02, 1.6819548019992414e-02, 1.5826924912607596e-02, 1.4944754737820511e-02, 1.4155597424294938e-02, 1.3445496822809915e-02, 1.2803152972973061e-02, 1.2219319455081173e-02, 1.168635756773009e-02, 1.1197901731459204e-02, 1.0748605058008618e-02, 1.0333943551559475e-02, 9.9500637709296173e-03, 9.593663105710977e-03, 9.261894805228427e-03, 8.9522919915896414e-03, 8.6627063743823368e-03,
      7.9750780961498346e-01, 2.1676083791597922e-01, 1.1861064067128201e-01, 8.0457767076930226e-02, 6.05585445316646e-02, 4.844023202931113e-02, 4.0317333054271827e-02, 3.4505851309679397e-02, 3.0147477936117533e-02, 2.6760381448655574e-02, 2.4053796522294151e-02, 2.1842116151441677e-02, 2.0001412494762581e-02, 1.8445839752033264e-02, 1.71140803759223e-02, 1.5961185440488045e-02, 1.4953463942743165e-02, 1.4065171579673184e-02, 1.3276301698364502e-02, 1.2571073398981256e-02, 1.1936873212836195e-02, 1.1363499323512898e-02, 1.0842612113359946e-02, 1.0367328240121928e-02, 9.9319163631439826e-03, 9.5315660353603327e-03, 9.1622100415748847e-03, 8.8203863083028116e-03, 8.5031294770933196e-03, 8.2078849688696966e-03, 7.9324402815316372e-03, 7.6748696216101218e-03,
      7.7131376375111504e-01, 2.0254385375577524e-01, 1.0901116662218135e-01, 7.325360767565621e-02, 5.4807562314905765e-02, 4.3660594946082015e-02, 3.6231156987653577e-02, 3.0938869234850376e-02, 2.6983439339569853e-02, 2.3917970910959506e-02, 2.1473958645555558e-02, 1.9480635358947649e-02, 1.7824339187021445e-02, 1.6426548569730151e-02, 1.5231309545260403e-02, 1.4197689790881879e-02, 1.3295065050759908e-02, 1.2500072569467788e-02, 1.179458300163669e-02, 1.1164315075456663e-02, 1.0597867579600836e-02, 1.0086029191500511e-02, 9.6212774605791956e-03, 9.1974091700316833e-03, 8.8092636074175966e-03, 8.4525126199736216e-03, 8.123499394369316e-03, 7.8191132703230703e-03, 7.5366915367202914e-03, 7.2739416654561389e-03, 7.0288791905164542e-03, 6.7997776817116263e-03,
      7.4682413281242699e-01, 1.8947234582049233e-01, 1.0026879814501737e-01, 6.6732274776822254e-02, 4.9623241133156734e-02, 3.9364864513484157e-02, 3.2567034238441719e-02, 2.7746001964150044e-02, 2.4155294145404169e-02, 2.1380279650214291e-02, 1.9172936091314628e-02, 1.7376108373082459e-02, 1.5885525704727146e-02, 1.4629350723368203e-02, 1.3556514179749592e-02, 1.2629735020647938e-02, 1.1821172234321879e-02, 1.1109621280589867e-02, 1.0478651824601523e-02, 9.9153381694070293e-03, 9.4093737177159183e-03, 8.9524406274551719e-03, 8.5377529045650644e-03, 8.1597197669928245e-03, 7.8136939386102364e-03, 7.4957809102296552e-03, 7.2026926251350654e-03, 6.9316339803580816e-03, 6.6802138741260822e-03, 6.4463748268722004e-03, 6.2283368070087637e-03, 6.0245520280461347e-03,
      7.2390221177734437e-01, 1.7744433085288649e-01, 9.2302455644582129e-02, 6.082658260647153e-02, 4.4948271505311548e-02, 3.5503100528646317e-02, 2.9280728203004348e-02, 2.4887555235869691e-02, 2.1627049413198058e-02, 1.9114387851563244e-02, 1.712040080948975e-02, 1.5500422062637799e-02, 1.4158773369919846e-02, 1.3029718617620636e-02, 1.2066637918847755e-02, 1.1235569905882297e-02, 1.0511199877333998e-02, 9.8742793749654369e-03, 9.3099158957513639e-03, 8.8064092375336779e-03, 8.3544412913172054e-03, 7.9465002602914208e-03, 7.5764639263028299e-03, 7.2392930334567174e-03, 6.9308023173848925e-03, 6.6474871971155571e-03, 6.3863909753527617e-03, 6.1450019268207406e-03, 5.9211727185737861e-03, 5.7130567112693769e-03, 5.5190571584637837e-03, 5.3377863590849317e-03,
      7.0242343139696684e-01, 1.6636745381471069e-01, 8.5039025833576809e-02, 5.5476132923077577e-02, 4.0731253440541182e-02, 3.2030593641872232e-02, 2.633269328016179e-02, 2.2328086312765279e-02, 1.9366599132515653e-02, 1.70909553570304e-02, 1.5289341969355009e-02, 1.382855379850605e-02, 1.2620776202179626e-02, 1.1605843277720216e-02, 1.0741188655302301e-02, 9.9958696574306491e-03, 9.3468650080640262e-03, 8.7766993623691111e-03, 8.2718723290915331e-03, 7.8217917264786704e-03, 7.4180321889912434e-03, 7.0538091553803547e-03, 6.7235987284660747e-03, 6.4228583683133052e-03, 6.1478185802141044e-03, 5.8953254281204097e-03, 5.6627199895803249e-03, 5.4477450350268646e-03, 5.2484720265149843e-03, 5.0632434604656069e-03, 4.8906269229122999e-03, 4.7293781749840934e-03,
      6.8227421475380012e-01, 1.5615804325420135e-01, 7.8412557802857288e-02, 5.0626615712560004e-02, 3.6926077884790395e-02, 2.8907310966678947e-02, 2.3687572664989796e-02, 2.0035945032771237e-02, 1.7345301704298949e-02, 1.5283830243031168e-02, 1.3655701386489361e-02, 1.233823029510186e-02, 1.1250800357307756e-02, 1.0338332046526344e-02, 9.5619525278053882e-03, 8.8934645460399236e-03, 8.3119291354513455e-03, 7.8014784236901582e-03, 7.349872372512385e-03, 6.9475207193497365e-03, 6.5868044545066371e-03, 6.2615952109184242e-03, 5.966908459907559e-03, 5.6986490513067922e-03, 5.4534216751537324e-03, 5.2283877373768845e-03, 5.0211559278089696e-03, 4.8296975887741614e-03, 4.6522805737572396e-03, 4.48741705433316e-03, 4.3338219639672652e-03, 4.1903796353660776e-03,
      6.6335094584033472e-01, 1.4674026189730163e-01, 7.2363541847825036e-02, 4.6229183030231803e-02, 3.3491373687730933e-02, 2.6097401013716201e-02, 2.1313750334149461e-02, 1.7982864731837734e-02, 1.553760360971207e-02, 1.3669700405558455e-02, 1.2198049185726947e-02, 1.100962425061202e-02, 1.0030399205215548e-02, 9.2099399939862964e-03, 8.5127398964000636e-03, 7.9130989490573435e-03, 7.3919690907826236e-03, 6.934939949132253e-03, 6.5309126903996782e-03, 6.1712031321194266e-03, 5.8489206680759406e-03, 5.5585290808945779e-03, 5.2955301100123444e-03, 5.0562316007085563e-03, 4.8375750282907796e-03, 4.6370054126061286e-03, 4.4523719648275799e-03, 4.2818513291439791e-03, 4.1238876514963435e-03, 3.977145328953934e-03, 3.8404714199507615e-03, 3.7128654895222137e-03,
      6.4555903887787824e-01, 1.380453426688259e-01, 6.6838262400702661e-02, 4.22398882459444e-02, 3.0390013082282091e-02, 2.3568751549644544e-02, 1.9182951335967986e-02, 1.6143597588735313e-02, 1.3920704192872514e-02, 1.2227783407581138e-02, 1.0897295243030024e-02, 9.8250845844419909e-03, 8.9431600732220781e-03, 8.2053312696485879e-03, 7.5791597157901089e-03, 7.0412174011443415e-03, 6.5741736096247812e-03, 6.1649396656688416e-03, 5.8034501828355105e-03, 5.4818404802214954e-03, 5.1938780075213194e-03, 4.9345609551323224e-03, 4.6998294973833342e-03, 4.4863545163249235e-03, 4.2913806347930385e-03, 4.1126079694353409e-03, 3.9481019190794895e-03, 3.7962235406212093e-03, 3.6555752399915304e-03, 3.5249579924071374e-03, 3.403337337792947e-03, 3.2898161234386825e-03,
      6.2881209825514262e-01, 1.3001090137277072e-01, 6.1788217333676308e-02, 3.8619183776553261e-02, 2.7588669424407925e-02, 2.1292594676921774e-02, 1.7269885141626973e-02, 1.4495589540201581e-02, 1.2474257043593888e-02, 1.0939550368757421e-02, 9.7364324445559734e-03, 8.768896538637239e-03, 7.9744791252032501e-03, 7.3108670513246134e-03, 6.748419124376983e-03, 6.2657746161392516e-03, 5.8471627571061958e-03, 5.4806935811598156e-03, 5.1572376828995514e-03, 4.8696716619537938e-03, 4.6123575330722401e-03, 4.3807758301476363e-03, 4.1712620702580722e-03, 3.9808142031908991e-03, 3.8069497427220414e-03, 3.6475982694099724e-03, 3.5010195112752766e-03, 3.3657401848984441e-03, 3.2405047768483716e-03, 3.1242368085463035e-03, 3.0160080725105095e-03, 2.9150139921988471e-03,
      6.1303116000419733e-01, 1.2258031817580503e-01, 5.7169596715329778e-02, 3.5331471128458775e-02, 2.5057421614475467e-02, 1.9243154049426864e-02, 1.5551927386337882e-02, 1.3018690447323738e-02, 1.1180103963980701e-02, 9.78848014473159e-03, 8.7003082413258052e-03, 7.8270683261102598e-03, 7.111361241495342e-03, 6.5144171179880271e-03, 6.0091454241995397e-03, 5.5760667884955182e-03, 5.2008276262486943e-03, 4.8726252856742588e-03, 4.5831781743121613e-03, 4.3260334945657416e-03, 4.0960905181694571e-03, 3.8892651733384831e-03, 3.7022494956336872e-03, 3.5323361222899907e-03, 3.3772882407202931e-03, 3.2352418534309108e-03, 3.104631381346134e-03, 2.9841323643777732e-03, 2.8726168522264185e-03, 2.7691183285273044e-03, 2.6728038768486675e-03, 2.5829519047574053e-03,
      5.9814400666130407e-01, 1.1570218085617284e-01, 5.2942814832976463e-02, 3.2344697732067405e-02, 2.2769400221964792e-02, 1.7397329690267613e-02, 1.4008835839082766e-02, 1.1694895667865818e-02, 1.0022037945343646e-02, 8.7598404585573289e-03, 7.7754213689941402e-03, 6.9871413780660642e-03, 6.3422421147267e-03, 5.8051924078887035e-03, 5.3512279440955804e-03, 4.9625817855397875e-03, 4.6261880287801847e-03, 4.3322304282833561e-03, 4.0731954383261982e-03, 3.8432369953641677e-03, 3.6377398956474621e-03, 3.4530131212333142e-03, 3.2860702441049562e-03, 3.1344694370275881e-03, 2.996195075920991e-03, 2.8695688708789708e-03, 2.7531822945537094e-03, 2.6458445936834796e-03, 2.546542353994674e-03, 2.4544077352709353e-03, 2.3686932860931278e-03, 2.2887518037670307e-03,
      5.8408454819328204e-01, 1.0932978351213234e-01, 4.9072089945806453e-02, 2.9629995638191211e-02, 2.0700470870733852e-02, 1.5734416369384715e-02, 1.2622496893297004e-02, 1.0508115610856813e-02, 8.9855919755606074e-03, 7.8404930159554596e-03, 6.9497409497492084e-03, 6.2380215712973548e-03, 5.6568300877928327e-03, 5.1735962183767558e-03, 4.765677559871246e-03, 4.4168661104815364e-03, 4.1152661548724779e-03, 3.8519564338993341e-03, 3.6201192752369597e-03, 3.4144576275406836e-03, 3.2307951076157772e-03, 3.0657955636534716e-03, 2.916762581265807e-03, 2.7814936212333411e-03, 2.6581722191170395e-03, 2.54528716941537e-03, 2.4415711466974736e-03, 2.3459535313521138e-03, 2.2575237547403891e-03, 2.175502530231192e-03, 2.0992190628048783e-03, 2.0280928386771702e-03,
      5.7079226241660064e-01, 1.0342067507883029e-01, 4.5525066816583679e-02, 2.7161357671345351e-02, 1.8828950919456248e-02, 1.4235851936275979e-02, 1.1376699274926988e-02, 9.4439702249303342e-03, 8.0578508471312663e-03, 7.0187199643038222e-03, 6.2125455022018407e-03, 5.56982910763874e-03, 5.0459655364059296e-03, 4.6110919662853125e-03, 4.2445018950753588e-03, 3.9314067545157955e-03, 3.6609744062500726e-03, 3.4250957431973474e-03, 3.2175836555650744e-03, 3.0336379320096492e-03, 2.8694788414471094e-03, 2.7220906527704804e-03, 2.5890385571702957e-03, 2.468335669066441e-03, 2.3583448631685315e-03, 2.2577052740874923e-03, 2.1652765370217294e-03, 2.0800959778416272e-03, 2.0013453820944822e-03, 1.9283249372269249e-03, 1.8604326076720537e-03, 1.7971476680290997e-03,
      5.5821168900549123e-01, 9.7936252588384787e-02, 4.2272477590419126e-02, 2.4915347103459405e-02, 1.7135355897589966e-02, 1.2884992393188679e-02, 1.0256932024086734e-02, 8.4896057057819094e-03, 7.2272834475926645e-03, 6.284069347034067e-03, 5.5542796595755345e-03, 4.9737649769311058e-03, 4.5014958439477774e-03, 4.1100856606380983e-03, 3.7805944476979316e-03, 3.4995262679108508e-03, 3.257015809383766e-03, 3.0456910524212203e-03, 2.8599363419114154e-03, 2.6954011452755568e-03, 2.5486643063333133e-03, 2.4169994418952348e-03, 2.2982077454382337e-03, 2.1904967019067459e-03, 2.0923906903060163e-03, 2.0026641293329093e-03, 1.9202908179610297e-03, 1.8444050823728613e-03, 1.774271646282925e-03, 1.7092620268343672e-03, 1.6488358679082491e-03, 1.5925260487873096e-03,
      5.4629197178514799e-01, 9.284139463224983e-02, 3.9287837054570139e-02, 2.2870837329790384e-02, 1.560217253692678e-02, 1.1666910841688445e-02, 9.2502041269348217e-03, 7.6335310052507797e-03, 6.4835932909725804e-03, 5.6272174645270144e-03, 4.9664266404228956e-03, 4.4419921649964033e-03, 4.0161642342036973e-03, 3.6638214462387277e-03, 3.3676360849093719e-03, 3.1152895676945986e-03, 2.8977955949267531e-03, 2.7084512017368141e-03, 2.542158687377942e-03, 2.3949745618170129e-03, 2.2638018573929428e-03, 2.1461755058423725e-03, 2.0401096254646445e-03, 1.9439869044020426e-03, 1.856477176599443e-03, 1.7764766058947833e-03, 1.7030616553470321e-03, 1.6354538218987832e-03, 1.5729923161068578e-03, 1.5151126788384198e-03, 1.4613298855135971e-03, 1.4112248784861261e-03,
      5.3498644454383304e-01, 8.8104130954206022e-02, 3.6547168729212688e-02, 2.1008778402249906e-02, 1.4213655577428166e-02, 1.0568217745257532e-02, 8.3448834597297881e-03, 6.8654719889972961e-03, 5.8175852953729484e-03, 5.0398462832549826e-03, 4.4413947328748983e-03, 3.9675299725945544e-03, 3.5835109210330079e-03, 3.2662887602997598e-03, 3.0000075226365814e-03, 2.7734211661351251e-03, 2.5783426887499854e-03, 2.4086765132377251e-03, 2.2597944626797949e-03, 2.1281215399811351e-03, 2.0108539095262485e-03, 1.9057625250142364e-03, 1.8110536269258482e-03, 1.7252678433165166e-03, 1.6472060193571084e-03, 1.5758738884279712e-03, 1.51044024296668e-03, 1.4502049224728729e-03, 1.3945740384298203e-03, 1.3430406011901519e-03, 1.2951692258985725e-03, 1.250583951535517e-03,
      5.2425225607991799e-01, 8.369534452240189e-02, 3.402875861099966e-02, 1.9311987608780133e-02, 1.2955645828136974e-02, 9.5769002266409449e-03, 7.5305529611532415e-03, 6.1762413251426479e-03, 5.2210470309876642e-03, 4.5145342400150397e-03, 3.9724162461051253e-03, 3.5441599930000106e-03, 3.1977852058713962e-03, 2.9121398072867893e-03, 2.6727115618246809e-03, 2.46923165203785e-03, 2.294240001175596e-03, 2.1421925149249271e-03, 2.0088866937572505e-03, 1.8910811749655834e-03, 1.7862372030818514e-03, 1.6923389308451534e-03, 1.6077659672061868e-03, 1.531201330467425e-03, 1.4615638773202559e-03, 1.397957960360903e-03, 1.339635413036088e-03, 1.2859664880372902e-03, 1.2364173882442541e-03, 1.1905327133118039e-03, 1.1479216143070667e-03, 1.1082467756406362e-03,
      5.1405003063240096e-01, 7.958850280497802e-02, 3.1712933723679428e-02, 1.776496158515127e-02, 1.1815407233440269e-02, 8.6821783647278387e-03, 6.7978821753441531e-03, 5.5576223957733298e-03, 4.6866428578821919e-03, 4.0446589704730296e-03, 3.5534575539496035e-03, 3.1663424572459706e-03, 2.8538673065878224e-03, 2.5966162018988205e-03, 2.3813039908679675e-03, 2.1985523880684713e-03, 2.0415625263209168e-03, 1.9052911069239839e-03, 1.7859216067064505e-03, 1.680514772932404e-03, 1.5867715896672018e-03, 1.5028688126222495e-03, 1.4273425111268499e-03, 1.3590040864227648e-03, 1.2968787057552355e-03, 1.2401594918659473e-03, 1.1881729706758209e-03, 1.1403526855723772e-03, 1.0962188178614603e-03, 1.0553622807523302e-03, 1.0174321844539389e-03, 9.8212586920224721e-04,
      5.0434356023143878e-01, 7.575941531059581e-02, 2.9581862927320578e-02, 1.6353707711456493e-02, 1.0781480935388586e-02, 7.8743766751055537e-03, 6.1385125097161933e-03, 5.0022657097410954e-03, 4.2078195463754161e-03, 3.6243106534196894e-03, 3.1791390078516934e-03, 2.8291417995036029e-03, 2.5471988367864883e-03, 2.3154837586330454e-03, 2.1218321858713809e-03, 1.9576775037343521e-03, 1.8168223746501623e-03, 1.6946783325985694e-03, 1.5877788788476645e-03, 1.4934583582499419e-03, 1.4096346006472991e-03, 1.3346583764458878e-03, 1.267206969884872e-03, 1.2062075461592167e-03, 1.1507810502698753e-03, 1.1002005158933246e-03, 1.0538596571159364e-03, 1.0112489098801152e-03, 9.7193694592373275e-04, 9.3555625829813748e-04, 9.0179181195436148e-04, 8.7037202689201824e-04,
      4.9509952585356559e-01, 7.2186014756825304e-02, 2.7619377703530963e-02, 1.5065592783079583e-02, 9.843554537303947e-03, 7.1448091539724973e-03, 5.5449547312464084e-03, 4.5035964612473436e-03, 3.7787221272484396e-03, 3.248214806370569e-03, 2.8446636316213432e-03, 2.5281604225025267e-03, 2.2737209750641118e-03, 2.0649745205112615e-03, 1.8907805488634635e-03, 1.743312366981284e-03, 1.6169199604819824e-03, 1.507428011599681e-03, 1.4116874852130267e-03, 1.3272805327159312e-03, 1.2523211444022246e-03, 1.185317327533407e-03, 1.1250738336846546e-03, 1.0706222227843273e-03, 1.021169735592955e-03, 9.7606134730358061e-04, 9.3475121425203175e-04, 8.9678091711204279e-04, 8.6176269084079014e-04, 8.2936636072281978e-04, 7.9930906547823275e-04, 7.7134709932236503e-04,
      4.8628724457870748e-01, 6.8848159499536224e-02, 2.5810810871828717e-02, 1.3889207158064859e-02, 8.9923449653433844e-03, 6.4856764394413012e-03, 5.0104973849434313e-03, 4.0557320265450156e-03, 3.3941188563774197e-03, 2.9116634964144808e-03, 2.5457536307927895e-03, 2.2594797561425492e-03, 2.0298194707010194e-03, 1.8417352208928437e-03, 1.6850220203668881e-03, 1.5525278090642684e-03, 1.4391006537338949e-03, 1.3409405756148504e-03, 1.2551865099688852e-03, 1.1796450826348842e-03, 1.112607752467458e-03, 1.052724618375964e-03, 9.9891550129914582e-04, 9.5030611180608527e-04, 9.0618144971753875e-04, 8.6595126222113706e-04, 8.291240833163049e-04, 7.9528747446802378e-04, 7.6409280984912284e-04, 7.3524343533507616e-04, 7.0848536200730566e-04, 6.8359988472671378e-04,
      4.7787844022655152e-01, 6.5727455098501544e-02, 2.4142851405013127e-02, 1.2814242772355497e-02, 8.2194934955292526e-03, 5.8899737997181092e-03, 4.5291249607752847e-03, 3.6534083227278032e-03, 3.0493343006297796e-03, 2.6104540443022549e-03, 2.278593856307676e-03, 2.0196078030807647e-03, 1.8122757272876382e-03, 1.6427814622999887e-03, 1.5017749882123941e-03, 1.3827194587397627e-03, 1.2809162828543129e-03, 1.1929065218557466e-03, 1.1160903634496446e-03, 1.0484777979216028e-03, 9.8852086033725619e-04, 9.349980684683661e-04, 8.8693313073684595e-04, 8.4353667725807903e-04, 8.0416378066128647e-04, 7.6828250973881584e-04, 7.3545032370571524e-04, 7.0529612514620395e-04, 6.7750645501854587e-04, 6.5181475916904947e-04, 6.2799295989746497e-04, 6.0584477660434542e-04,
      4.6984703520162346e-01, 6.2807093111329287e-02, 2.260341370166705e-02, 1.1831383583716678e-02, 7.5174716662426075e-03, 5.3514087962664245e-03, 4.0954447623731674e-03, 3.2919140697903822e-03, 2.740189660648176e-03, 2.3408344012429282e-03, 2.0397814573281619e-03, 1.805432454510415e-03, 1.6182232902030066e-03, 1.4654569761080954e-03, 1.3385649903714396e-03, 1.2315716140647503e-03, 1.1401909448126798e-03, 1.0612739652142769e-03, 9.9245790859731368e-04, 9.3193702796887275e-04, 8.7830866692393422e-04, 8.3046741736611507e-04, 7.8753078920349286e-04, 7.4878601311981132e-04, 7.1365131347323352e-04, 6.8164727683856386e-04, 6.523753852068939e-04, 6.2550171337812555e-04, 6.0074440192548699e-04, 5.7786392677632264e-04, 5.5665546535493403e-04, 5.3694285204749668e-04,
      4.6216896150254161e-01, 6.007170540223257e-02, 2.1181519844185134e-02, 1.093220715649244e-02, 6.8794969322884952e-03, 4.86432759368841e-03, 3.7046215440299343e-03, 2.9670321015218847e-03, 2.4629495429617635e-03, 2.0994544681371716e-03, 1.8262810425173489e-03, 1.614179938828806e-03, 1.4451091388561455e-03, 1.3073973979376768e-03, 1.1931906769602465e-03, 1.0970251442057469e-03, 1.0149906391755407e-03, 9.4421982847411857e-04, 8.8256505658464341e-04, 8.2838755272776859e-04, 7.8041616827965359e-04, 7.3765042249797428e-04, 6.9929252842171178e-04, 6.6469881967193734e-04, 6.333444397552513e-04, 6.0479727057266629e-04, 5.7869840866903383e-04, 5.5474735491080123e-04, 5.3269064603290854e-04, 5.1231303276142131e-04, 4.93430565043914e-04, 4.7588512156183064e-04,
      4.5482198905401139e-01, 5.7507232426400302e-02, 1.9867193523092238e-02, 1.0109096234593612e-02, 6.2994570381528243e-03, 4.423648998315508e-03, 3.3523190833948638e-03, 2.6749869637498831e-03, 2.2142744800318854e-03, 1.8833227072710592e-03, 1.6353847442854689e-03, 1.4433778365314318e-03, 1.2906592512285102e-03, 1.1664980566271528e-03, 1.0636935563898694e-03, 9.7724897057294776e-04, 9.0359629756696998e-04, 8.4012426182678707e-04, 7.8488044105712535e-04, 7.3637739508060395e-04, 6.9346300695125995e-04, 6.5523165719900663e-04, 6.2096205380642369e-04, 5.9007287537066145e-04, 5.6209057152159785e-04, 5.3662561980655839e-04, 5.1335476721671631e-04, 4.9200757419691444e-04, 4.7235609664282558e-04, 4.5420688701759346e-04, 4.3739473040385423e-04, 4.2177769315013345e-04,
      4.4778556970258998e-01, 5.5100804106953581e-02, 1.8651364444794968e-02, 9.355159271003239e-03, 5.7718421965577971e-03, 4.0248054058477974e-03, 3.0346479471775531e-03, 2.4123981212397999e-03, 1.9911785735351301e-03, 1.6897674679222541e-03, 1.4646766473320114e-03, 1.2908221574545161e-03, 1.1528479674521456e-03, 1.0408853306585679e-03, 9.483311037524635e-04, 8.7061472711247746e-04, 8.0447982797252396e-04, 7.4754792895400637e-04, 6.9804382447619117e-04, 6.5461724282830089e-04, 6.162238189166444e-04, 5.8204370346873267e-04, 5.5142469360719556e-04, 5.2384172111278205e-04, 4.9886748627109919e-04, 4.7615083272053164e-04, 4.554005929093385e-04, 4.3637336135421932e-04, 4.1886412913320269e-04, 4.0269903056681439e-04, 3.8772966835384613e-04, 3.738286317270803e-04,
      4.4104069538121082e-01, 5.2840632061559582e-02, 1.7525782161993068e-02, 8.6641589901538963e-03, 5.2916842552928863e-03, 3.6636899261127251e-03, 2.7481187873132249e-03, 2.1762381682922179e-03, 1.7909917044561362e-03, 1.5164025108775172e-03, 1.3120011022423311e-03, 1.1545480322943467e-03, 1.0298707317544743e-03, 9.2889117564095972e-04, 8.4555285669646676e-04, 7.756742444329195e-04, 7.1628283608579071e-04, 6.6521183776211432e-04, 6.2084692911747782e-04, 5.8196218607656236e-04, 5.4761079603146906e-04, 5.1705046856950656e-04, 4.8969140746932542e-04, 4.6505930592318347e-04, 4.427685612069306e-04, 4.2250257630067754e-04, 4.0399906282504675e-04, 3.8703893012416245e-04, 3.7143778351184456e-04, 3.5703934643011996e-04, 3.4371031883036239e-04, 3.3133631998974087e-04,
      4.3456976909482997e-01, 5.0715912061413827e-02, 1.6482938375281891e-02, 8.0304481561507372e-03, 4.8545021218047626e-03, 3.3366090312820593e-03, 2.4896005764771852e-03, 1.9637955037621257e-03, 1.6113258143352742e-03, 1.3610962733980347e-03, 1.1754344977450649e-03, 1.0328036199370291e-03, 9.2011983883464189e-04, 8.290304706303238e-04, 7.5397916592155991e-04, 6.9113954224962e-04, 6.3779772382695091e-04, 5.9197943007557646e-04, 5.5221641993688498e-04, 5.1739550903016603e-04, 4.8665821381946707e-04, 4.5933238526451822e-04, 4.3488460341920118e-04, 4.1288637159977943e-04, 3.9298968206348593e-04, 3.7490907065999227e-04, 3.5840824430227047e-04, 3.4328998301266192e-04, 3.2938842151885239e-04, 3.1656308344348022e-04, 3.04694222424177e-04, 2.9367914905562725e-04,
      4.2835648751204691e-01, 4.871673571800561e-02, 1.5515996852355008e-02, 7.4489118062089164e-03, 4.4562527922897832e-03, 3.040240143718682e-03, 2.256283255518382e-03, 1.772640989734084e-03, 1.4500448161190594e-03, 1.2219444664735004e-03, 1.0532601122349712e-03, 9.2402687622766399e-04, 8.2216285226317841e-04, 7.3998087030355372e-04, 6.7238230461137618e-04, 6.158650499683122e-04, 5.6795089882569704e-04, 5.2684067673514664e-04, 4.9119879726245645e-04, 4.6001430467195722e-04, 4.3250870273024429e-04, 4.0807328269891317e-04, 3.8622555847694261e-04, 3.6657837911331339e-04, 3.4881763639134995e-04, 3.3268591460904626e-04, 3.179703218896594e-04, 3.0449331190031685e-04, 2.9210567594331458e-04, 2.8068113173760918e-04, 2.701121015905516e-04, 2.6030638682639912e-04,
      4.2238573406668983e-01, 4.6834010494200669e-02, 1.4618730198876342e-02, 6.9149152859368816e-03, 4.0932874010427625e-03, 2.7715936419372422e-03, 2.045644322157219e-03, 1.6005981652125543e-03, 1.305237741229065e-03, 1.0972456409668694e-03, 9.439457069641739e-04, 8.2682486900727476e-04, 7.3472339939809387e-04, 6.6056488485924001e-04, 5.9966967414462667e-04, 5.4883180660116287e-04, 5.0578785853737731e-04, 4.6889795306279467e-04, 4.3694698454443617e-04, 4.0901670693830174e-04, 3.8440106607540229e-04, 3.6254873904657098e-04, 3.4302326132212054e-04, 3.2547480194987735e-04, 3.0961982276688437e-04, 2.9522617978781007e-04, 2.8210204877077887e-04, 2.7008758199054676e-04, 2.5904854480526579e-04, 2.4887140702470339e-04, 2.3945951680268601e-04, 2.3073008943198272e-04,
      4.1664348158051584e-01, 4.5059387226919281e-02, 1.3785462793612837e-02, 6.4242574922024308e-03, 3.7623117674638567e-03, 2.527978818770267e-03, 1.8554189409145149e-03, 1.4457166326273762e-03, 1.1751947723520376e-03, 9.8547939908248151e-04, 8.4612356048053802e-04, 7.3995535909433243e-04, 6.5666408010303776e-04, 5.8973394048151531e-04, 5.3486887275095644e-04, 4.891334190594924e-04, 4.5045993917799542e-04, 4.1735349495906036e-04, 3.8870842059164526e-04, 3.6369055818317422e-04, 3.4165947010016552e-04, 3.221157484293867e-04, 3.0466451602459134e-04, 2.8898963142936715e-04, 2.7483512654866106e-04, 2.6199162918245401e-04, 2.5028628334031655e-04, 2.3957516431049686e-04, 2.2973749987055791e-04, 2.2067121715327727e-04, 2.122894748667837e-04, 2.0451793651461109e-04,
      4.1111670351458507e-01, 4.3385194430136567e-02, 1.3011019270766257e-02, 5.9731287911361569e-03, 3.4603509732033808e-03, 2.3069733754603893e-03, 1.6835731993775625e-03, 1.3062482763336741e-03, 1.058385849641436e-03, 8.8528696303595523e-04, 7.5857267695798056e-04, 6.6231039786981245e-04, 5.8697125569555223e-04, 5.2655420070994361e-04, 4.7711441982125957e-04, 4.3596358259402157e-04, 4.0121254319922602e-04, 3.7149825835163587e-04, 3.4581448718761377e-04, 3.2340335028323053e-04, 3.0368385137558517e-04, 2.8620355357590968e-04, 2.7060516410186913e-04, 2.5660295662294962e-04, 2.4396582977911417e-04, 2.325049322545693e-04, 2.2206448747688715e-04, 2.1251489734629102e-04, 2.0374749386207328e-04, 1.9567049884501068e-04, 1.8820588065230294e-04, 1.8128688475336783e-04,
      4.0579329304362372e-01, 4.1804378720052958e-02, 1.2290677995477709e-02, 5.5580731341334649e-03, 3.1847175511382757e-03, 2.106396079697247e-03, 1.5282801761630615e-03, 1.1806260091578068e-03, 9.5344157202594427e-04, 7.9545384434951771e-04, 6.8020293047581085e-04, 5.9290171967067316e-04, 5.24741510453142e-04, 4.7019395349557014e-04, 4.2563595171155364e-04, 3.8860498910678126e-04, 3.5737467991469316e-04, 3.3070202463834106e-04, 3.0767112202329514e-04, 2.8759329597276696e-04, 2.6994140419129241e-04, 2.5430551249709015e-04, 2.4036229834255188e-04, 2.2785349708360009e-04, 2.1657043787458641e-04, 2.0634276344569483e-04, 1.9703007711682137e-04, 1.8851567200746302e-04, 1.8070176392524551e-04, 1.7350582532824847e-04, 1.6685773592063424e-04, 1.6069754610926901e-04,
      4.0066198922578322e-01, 4.0310450769940852e-02, 1.1620129034970521e-02, 5.175953944204374e-03, 2.9329829118534007e-03, 1.9242822551610919e-03, 1.3878985218371332e-03, 1.0674447758997714e-03, 8.59136145603755e-04, 7.1489438527219218e-04, 6.1004093346786578e-04, 5.308477316887405e-04, 4.6916960102369963e-04, 4.1991239043410561e-04, 3.7974772542162972e-04, 3.4641946855049234e-04, 3.1834967243131294e-04, 2.9440461244855027e-04, 2.7375048377838965e-04, 2.5576140317338001e-04, 2.3995902614378051e-04, 2.2597188236256818e-04, 2.1350735617748414e-04, 2.0233198042326412e-04, 1.9225731908035408e-04, 1.8312968370024502e-04, 1.7482252819000358e-04, 1.6723074617540812e-04, 1.6026634059358822e-04, 1.5385509692046853e-04, 1.4793399994335202e-04, 1.4244920796764232e-04,
      3.9571230961051351e-01, 3.8897436261142802e-02, 1.0995436178434294e-02, 4.8239233893086009e-03, 2.7029516726074739e-03, 1.7588618054381797e-03, 1.2609532860734512e-03, 9.6544457198693978e-04, 7.7437215807186306e-04, 6.4263796881362041e-04, 5.4721744083733215e-04, 4.7536192584985099e-04, 4.1953772954611063e-04, 3.7504962395672989e-04, 3.3883928477462403e-04, 3.0883922593786303e-04, 2.8360690049882866e-04, 2.6210807173758792e-04, 2.4358355117301114e-04, 2.2746443943159452e-04, 2.1331661387467195e-04, 2.0080341697760831e-04, 1.8965999309516899e-04, 1.7967526901971383e-04, 1.7067906448410837e-04, 1.6253271606358436e-04, 1.5512215201573352e-04, 1.4835270577484105e-04, 1.4214518185307916e-04, 1.3643283665400454e-04, 1.3115903635008009e-04, 1.2627542182694191e-04,
      3.9093448869058822e-01, 3.7559831349669864e-02, 1.041300260415e-02, 4.4993946989539419e-03, 2.4926385888980975e-03, 1.6085395066937351e-03, 1.1461187528935602e-03, 8.7349526157504283e-04, 6.9816698216132174e-04, 5.778167161239391e-04, 4.909561219397804e-04, 4.2574255651349214e-04, 3.7520599447202191e-04, 3.3501780539789796e-04, 3.0236715992889283e-04, 2.753590518503217e-04, 2.5267446350125651e-04, 2.3336975015310945e-04, 2.1675355111090117e-04, 2.0230868630548773e-04, 1.8964111311628565e-04, 1.7844568598006028e-04, 1.6848264787029248e-04, 1.5956115099425051e-04, 1.5152748685440785e-04, 1.4425653652623319e-04, 1.3764546403568774e-04, 1.3160899877262013e-04, 1.260758610753184e-04, 1.2098602193376144e-04, 1.1628857927998351e-04, 1.1194009557140493e-04,
      3.8631942166136146e-01, 3.6292562215445717e-02, 9.8695398330624542e-03, 4.2000172158219891e-03, 2.3002478201497659e-03, 1.4718773316349056e-03, 1.0422030713145313e-03, 7.9058300265785937e-04, 6.2964063244633391e-04, 5.1965450975298031e-04, 4.4056355105954683e-04, 3.813634450542e-04, 3.356038892443063e-04, 2.9929322208821653e-04, 2.6984748544766306e-04, 2.4552939798103292e-04, 2.2513266078387021e-04, 2.077961339701269e-04, 1.928901228355293e-04, 1.799443948317333e-04, 1.6860123802440143e-04, 1.5858403426848331e-04, 1.4967572136794269e-04, 1.4170372022628927e-04, 1.3452918585278215e-04, 1.2803921024808973e-04, 1.2214107842582788e-04, 1.1675797689404709e-04, 1.1182574571344823e-04, 1.0729039109382525e-04, 1.0310615955755297e-04, 9.9234031793271146e-05,
      3.818586130017334e-01, 3.509094830401862e-02, 9.3620396445137314e-03, 3.9236539059567827e-03, 2.1241542891315564e-03, 1.3475785924326291e-03, 9.4813449146285349e-04, 7.1579810748686969e-04, 5.6800491895533012e-04, 4.6745719894952255e-04, 3.9542028339606351e-04, 3.4166578770084536e-04, 3.0022273335685555e-04, 2.6740926515238543e-04, 2.4084943493778239e-04, 2.1895022136394826e-04, 2.0060819802317673e-04, 1.8503737685875222e-04, 1.7166413549051925e-04, 1.6006086322008987e-04, 1.4990278437676833e-04, 1.4093910938737261e-04, 1.3297329954639785e-04, 1.2584927870275885e-04, 1.1944161539501584e-04, 1.1364841123930518e-04, 1.0838606880663425e-04, 1.035853872761274e-04, 9.9188610851512696e-05, 9.5147170697951436e-05, 9.1419938385664109e-05, 8.7971861208582762e-05,
      3.7754412943762905e-01, 3.3950668909014999e-02, 8.8877486625982653e-03, 3.6683610795024786e-03, 1.9628869198230255e-03, 1.234473712722106e-03, 8.6294903649809991e-04, 6.483241850919301e-04, 5.1255375799226228e-04, 4.2060385885494476e-04, 3.5497289816180763e-04, 3.0615085663035393e-04, 2.6860893309400667e-04, 2.3895017171691828e-04, 2.1498938162661148e-04, 1.9526551170069697e-04, 1.7876903856886718e-04, 1.6478243948259551e-04, 1.5278308576607057e-04, 1.4238206680732221e-04, 1.3328446972922723e-04, 1.2526289276674999e-04, 1.1813935913692578e-04, 1.117727020634176e-04, 1.0604959622877824e-04, 1.0087807061327879e-04, 9.6182742073922908e-05, 9.1901262859440648e-05, 8.7981638073197154e-05, 8.4380175609833724e-05, 8.1059902046920284e-05, 7.7989326036188229e-05,
      3.7336855689056003e-01, 3.2867732778181717e-02, 8.4441453509803924e-03, 3.4323700994565542e-03, 1.8151135609049021e-03, 1.1315074588558567e-03, 7.8577945879099501e-04, 5.8742842917930708e-04, 4.6265451570434458e-04, 3.7853898941850024e-04, 3.1872690337206885e-04, 2.7437349642646359e-04, 2.4035798060381618e-04, 2.1354545591819327e-04, 1.9192570433559892e-04, 1.7415842575259005e-04, 1.5931982776129435e-04, 1.4675477156506515e-04, 1.3598701055658218e-04, 1.2666277818469424e-04, 1.1851424117220849e-04, 1.1133517795953933e-04, 1.0496440144395208e-04, 9.927421590774337e-05, 9.4162223257618472e-05, 8.9545404765117755e-05, 8.5355778400468931e-05, 8.1537166151922071e-05, 7.8042755763554138e-05, 7.4833239333942699e-05, 7.1875376416612329e-05, 6.9140873368677514e-05,
      3.6932496105150781e-01, 3.1838450456956359e-02, 8.0289191803790804e-03, 3.2140708787291943e-03, 1.6796274221386688e-03, 1.0377274784989872e-03, 7.1584534495471237e-04, 5.3245292938274729e-04, 4.1774027341143856e-04, 3.4076555230302507e-04, 2.8624040845633125e-04, 2.4593632878898176e-04, 2.1510911005538375e-04, 1.9086495259781975e-04, 1.7135416727230145e-04, 1.5534696125105003e-04, 1.4199782628459859e-04, 1.3070847572887713e-04, 1.2104485686965504e-04, 1.1268512240587562e-04, 1.0538599802778109e-04, 9.8960445446031096e-05, 9.3262465884319149e-05, 8.8176536372582164e-05, 8.3610122869712622e-05, 7.9488280357065371e-05, 7.5749695800057988e-05, 7.2343746164644037e-05, 6.9228281960500462e-05, 6.636793697729211e-05, 6.3732824795701551e-05, 6.1297523132880703e-05,
      3.6540685125434302e-01, 3.0859409111473831e-02, 7.639951756586892e-03, 3.01199698624757e-03, 1.5553348688687216e-03, 9.5227401066323247e-04, 6.5244424874638673e-04, 4.8280689695127791e-04, 3.7730291572286433e-04, 3.0683875512878137e-04, 2.57118481099688e-04, 2.2048458796322854e-04, 1.9254053860670163e-04, 1.7061440601208751e-04, 1.5300381002560429e-04, 1.3858011031634142e-04, 1.2656929576860184e-04, 1.1642489922028498e-04, 1.0775125771782656e-04, 1.0025551838587831e-04, 9.3716682767978028e-05, 8.7965089273326513e-05, 8.2868480359789577e-05, 7.8322333758724976e-05, 7.4243020607196709e-05, 7.0562877891670308e-05, 6.72266023786956e-05, 6.4188572897477006e-05, 6.1410835305167886e-05, 5.8861567478217626e-05, 5.6513896739517236e-05, 5.4344979283833109e-05,
      3.6160814735365848e-01, 2.9927449598082675e-02, 7.2752997181318056e-03, 2.8248122011660559e-03, 1.4412444359580027e-03, 8.7437064557963887e-04, 5.9494374372580578e-04, 4.3795970764742641e-04, 3.4088695317041981e-04, 2.7636050226923159e-04, 2.3100811387075348e-04, 1.977015178849554e-04, 1.7236522789063465e-04, 1.5253154338329235e-04, 1.3663329122354457e-04, 1.236344390680362e-04, 1.1282628620356368e-04, 1.0370960567093693e-04, 9.5923668484702864e-05, 8.9201963105637304e-05, 8.3343698704458052e-05, 7.8194955851368505e-05, 7.3635910411873963e-05, 6.9571982655664184e-05, 6.5927584012488225e-05, 6.264161999546374e-05, 5.9664203591857711e-05, 5.6954217808508382e-05, 5.447748356680023e-05, 5.2205365553437888e-05, 5.0113699248873105e-05, 4.818195645957508e-05,
      3.5792314933956809e-01, 2.9039645569092672e-02, 6.9331792317628678e-03, 2.651298370663792e-03, 1.3364569368541762e-03, 8.033160255922205e-04, 5.4277429904747276e-04, 3.97434675055858e-04, 3.080840006248967e-04, 2.4897444019921302e-04, 2.0759373433487039e-04, 1.7730426962035863e-04, 1.5432710882329497e-04, 1.3638257978771339e-04, 1.2202763559880626e-04, 1.1031104605571399e-04, 1.0058378037095909e-04, 9.23896844129604e-05, 8.53998233690391e-05, 7.9371620120127512e-05, 7.4122617673639822e-05, 6.9513159709089632e-05, 6.5434673412895444e-05, 6.1801566154890642e-05, 5.8545509477304111e-05, 5.5611334384082984e-05, 5.2954035543293645e-05, 5.0536552294830887e-05, 4.8328102696556217e-05, 4.6302917185373005e-05, 4.4439264959520198e-05, 4.2718697497783435e-05,
      3.5434650944701235e-01, 2.8193284424862772e-02, 6.6119519310688483e-03, 2.4903444415293229e-03, 1.2401565563582039e-03, 7.3847638967969016e-04, 4.9542289201991055e-04, 3.6080347680249032e-04, 2.7852784126477164e-04, 2.2436153322187268e-04, 1.8659319959902975e-04, 1.5904024442815325e-04, 1.3819771884958528e-04, 1.2195910680095383e-04, 1.0899533979184353e-04, 9.8432857418860259e-05, 8.9677155500556728e-05, 8.231135962325303e-05, 7.6035476046891739e-05, 7.0628678200582826e-05, 6.5925145087601713e-05, 6.1798144989116884e-05, 5.8149287864345379e-05, 5.4901105413426633e-05, 5.1991825456267417e-05, 4.9371624890351546e-05, 4.6999898654417586e-05, 4.484323939651382e-05, 4.2873922446444093e-05, 4.1068755457568336e-05, 3.9408194861505823e-05, 3.7875660025931695e-05,
      3.5087320653967979e-01, 2.7385849940696254e-02, 6.3101121589244072e-03, 2.3409365489270167e-03, 1.1516028271911013e-03, 6.7927887442488922e-04, 4.5242728022519281e-04, 3.2768116448038685e-04, 2.518900134433905e-04, 2.0223611237137764e-04, 1.6775422268655699e-04, 1.4268383377373511e-04, 1.2377320635241832e-04, 1.0907532258885368e-04, 9.7365797184037288e-05, 8.7842221375255479e-05, 7.9959926810223224e-05, 7.3337865798807247e-05, 6.7702392718092553e-05, 6.2852449785635346e-05, 5.8637313398996439e-05, 5.4941964984806276e-05, 5.1677231258360484e-05, 4.8772989084207664e-05, 4.6173387541583249e-05, 4.3833426959608265e-05, 4.1716468951956686e-05, 3.9792396756951418e-05, 3.8036237319980731e-05, 3.6427116191084527e-05, 3.4947455644816713e-05, 3.3582352825980039e-05,
      3.4749852256904479e-01, 2.6615006413543633e-02, 6.0262753882810256e-03, 2.2021490575713501e-03, 1.0701234007709137e-03, 6.2520549338158861e-04, 4.1337086417076173e-04, 2.9772169548017923e-04, 2.2787586455577817e-04, 1.8234234649774282e-04, 1.5085118388304166e-04, 1.2803351296663865e-04, 1.1087166194270126e-04, 9.7565565814612237e-05, 8.6987006462842928e-05, 7.8398768803451745e-05, 7.1301741533033234e-05, 6.5347559816348019e-05, 6.0286569276508337e-05, 5.5935682327172003e-05, 5.2157878290933528e-05, 4.8848755150054024e-05, 4.5927482959596193e-05, 4.3330580015712034e-05, 4.100754367391487e-05, 3.8917726695712022e-05, 3.7028066807980072e-05, 3.5311411372720889e-05, 3.3745264040159728e-05, 3.2310835177810178e-05, 3.0992314039479091e-05, 2.9776304879280937e-05,
      3.4421802092744891e-01, 2.5878584188409201e-02, 5.7591677082415556e-03, 2.0731364611457199e-03, 9.9510753184853186e-04, 5.7578772495168269e-04, 3.7787807875030326e-04, 2.7061393152656233e-04, 2.0622102202803348e-04, 1.6445109007166627e-04, 1.3568228530827679e-04, 1.1490924984504313e-04, 9.9330740785584932e-05, 8.7282119895292989e-05, 7.7723532539314663e-05, 6.9977510385896887e-05, 6.358659554232544e-05, 5.8232243159981009e-05, 5.3686647514893884e-05, 4.9783058643326971e-05, 4.6396894797189463e-05, 4.3433377785492575e-05, 4.0819231226353917e-05, 3.8496979181806396e-05, 3.6420950227766745e-05, 3.4554424915741815e-05, 3.2867565258554044e-05, 3.1335888881235697e-05, 2.9939128863469587e-05, 2.8660370882322646e-05, 2.7485392530569408e-05, 2.6402151950018302e-05,
      3.4102752653081364e-01, 2.517456643777944e-02, 5.5076162735220105e-03, 1.953126055319917e-03, 9.2600020492209227e-04, 5.3060164618575227e-04, 3.4561025831497043e-04, 2.4607805461506973e-04, 1.8668823692110159e-04, 1.4835706717537429e-04, 1.2206701152155089e-04, 1.0315019416010328e-04, 8.9005544066014902e-05, 7.8093257841422095e-05, 6.9454691920534976e-05, 6.2467144066988167e-05, 5.6711247798922874e-05, 5.1895670857280037e-05, 4.7812508089898289e-05, 4.4309865076671279e-05, 4.1274453125852275e-05, 3.8620219064353252e-05, 3.6280725850075227e-05, 3.4203929071274881e-05, 3.2348521893240385e-05, 3.0681329776118868e-05, 2.9175422058584301e-05, 2.7808722097318042e-05, 2.6562969967505035e-05, 2.5422938322712049e-05, 2.4375832611024932e-05, 2.3410827294914561e-05,
      3.3792310748163729e-01, 2.4501077079490157e-02, 5.27054062544166e-03, 1.8414113082589575e-03, 8.6229683775745924e-04, 4.892635564486906e-04, 3.1626192598457892e-04, 2.2386235630195557e-04, 1.6906456042775975e-04, 1.3387635553631117e-04, 1.098438630212564e-04, 9.261261707627254e-05, 7.9766731207755025e-05, 6.9881501203362806e-05, 6.2072937734047922e-05, 5.5768549501072939e-05, 5.0583810609863575e-05, 4.6252226289298982e-05, 4.2584020471114717e-05, 3.9440808638807826e-05, 3.6719556237517687e-05, 3.434212124295188e-05, 3.2248259985403195e-05, 3.0390840777855045e-05, 2.8732500211749099e-05, 2.7243263398405002e-05, 2.5898821430619506e-05, 2.4679265249105224e-05, 2.3568141822047292e-05, 2.2551741469749729e-05, 2.1618553314007055e-05, 2.0758844618675889e-05,
      3.3490105817655924e-01, 2.3856369729357483e-02, 5.0469448016084231e-03, 1.7373458601776858e-03, 8.0353850397780601e-04, 4.5142604073183847e-04, 2.8955746303540762e-04, 2.0374036099327021e-04, 1.5315881781032407e-04, 1.2084413837292808e-04, 9.886833310936552e-05, 8.316807355301142e-05, 7.1498837583196172e-05, 6.2542069573242023e-05, 5.5482422351644172e-05, 4.9793448760226058e-05, 4.5122496143749395e-05, 4.122574337065814e-05, 3.7929932315608472e-05, 3.5108966437356957e-05, 3.2669123250171803e-05, 3.0539434835894844e-05, 2.866526659921159e-05, 2.700393081500039e-05, 2.5521627339321582e-05, 2.4191269576588668e-05, 2.2990913060821854e-05, 2.1902601904931578e-05, 2.091150994405148e-05, 2.0005292946887016e-05, 1.9173594165129841e-05, 1.8407662751314581e-05,
      3.3195788373510782e-01, 2.3238817594735662e-02, 4.8359101595847279e-03, 1.6403380903718616e-03, 7.4930762263006442e-04, 4.1677442761726079e-04, 2.6524811885370215e-04, 1.8550824806831681e-04, 1.3879934813334309e-04, 1.0911269530822592e-04, 8.9011101805731873e-05, 7.470176335408814e-05, 6.4098775229432564e-05, 5.598149969201411e-05, 4.9597718004194226e-05, 4.4463214876983812e-05, 4.0254501828904201e-05, 3.6748459665208811e-05, 3.3786882677732987e-05, 3.1254852558000518e-05, 2.9067104535958389e-05, 2.7159177252609168e-05, 2.5481516613163583e-05, 2.3995455260894592e-05, 2.2670413132451414e-05, 2.148191111336885e-05, 2.0410137309277066e-05, 1.9438895948566405e-05, 1.8554825757651868e-05, 1.7746811092038127e-05, 1.7005532933728866e-05, 1.6323122725112116e-05,
      3.2909028563741355e-01, 2.264690422403938e-02, 4.6365888471224543e-03, 1.5498461963289465e-03, 6.9922406796276381e-04, 3.8502360157395348e-04, 2.4310932610144411e-04, 1.6898254141215339e-04, 1.2583198154067255e-04, 9.8549606713716154e-05, 8.0156423359866068e-05, 6.7111069083768167e-05, 5.7474496557525443e-05, 5.0116415523833589e-05, 4.4342677951790189e-05, 3.9707811845473556e-05, 3.591501919773319e-05, 3.2760085840182501e-05, 3.0098525211299208e-05, 2.7825589239691147e-05, 2.5863695965890044e-05, 2.415428591440985e-05, 2.2652407274281004e-05, 2.1323030241385946e-05, 2.0138485000178656e-05, 1.9076646632152075e-05, 1.8119626854979779e-05, 1.7252816170439955e-05, 1.6464172450458522e-05, 1.5743685574730119e-05, 1.5082969659760549e-05, 1.4474948993299617e-05,
      3.262951484687821e-01, 2.2079215035276857e-02, 4.4481978581276012e-03, 1.4653737350636981e-03, 6.529416574235546e-04, 3.5591513344837512e-04, 2.2293828945651995e-04, 1.5399803827025773e-04, 1.1411822885460396e-04, 8.9036148615580325e-05, 7.2200686457462291e-05, 6.0304252010728845e-05, 5.1543803240563111e-05, 4.4872432716313241e-05, 3.9649422704542362e-05, 3.5464851524289561e-05, 3.2046352461323316e-05, 2.9206978493234698e-05, 2.6814749072186909e-05, 2.4774170659149702e-05, 2.3014641170059713e-05, 2.1482955221965469e-05, 2.0138330582783566e-05, 1.8949029001817147e-05, 1.789001116182701e-05, 1.6941277863123111e-05, 1.6086676106496342e-05, 1.5313026114972788e-05, 1.4609473754240394e-05, 1.3967003765643723e-05, 1.337806940505235e-05, 1.2836307475236324e-05,
      3.2356952767817865e-01, 2.1534429553868719e-02, 4.270013619430555e-03, 1.3864655818003294e-03, 6.1014498016363154e-04, 3.2921469675499e-04, 2.0455181961047042e-04, 1.4040595231921879e-04, 1.035336609760299e-04, 8.0465857762978318e-05, 6.505112848991696e-05, 5.4199288542694845e-05, 4.6233284422276525e-05, 4.0183182693938643e-05, 3.5457437505900651e-05, 3.1678754501552359e-05, 2.8597134626685973e-05, 2.604140483552024e-05, 2.3890986606358321e-05, 2.2058808952494958e-05, 2.0480611933297986e-05, 1.9108047941158927e-05, 1.7904112754800021e-05, 1.6840046921211164e-05, 1.5893189009939412e-05, 1.5045459422613174e-05, 1.4282270693695889e-05, 1.359173177453657e-05, 1.2964058496778518e-05, 1.2391130944569468e-05, 1.1866157038784337e-05, 1.1383413947867399e-05,
      3.2091063826597793e-01, 2.1011314296554395e-02, 4.1013670587632641e-03, 1.3127042655929773e-03, 5.7054653217229029e-04, 3.0470974072309491e-04, 1.8778438717577896e-04, 1.2807224850896467e-04, 9.3966457974495432e-05, 7.274324865855786e-05, 5.8624687277979299e-05, 4.8722832086173786e-05, 4.1477370128431616e-05, 3.5989443258188553e-05, 3.1712768816241055e-05, 2.8300003419513154e-05, 2.5521630326655266e-05, 2.3220889000407135e-05, 2.1287598130546541e-05, 1.9642353266020138e-05, 1.8226657957466909e-05, 1.6996572638211695e-05, 1.591851671604511e-05, 1.4966426799909176e-05, 1.411979121785681e-05, 1.3362264009938931e-05, 1.2680670228424294e-05, 1.2064280562824438e-05, 1.1504274585700269e-05, 1.0993338220426256e-05, 1.052535812994978e-05, 1.0095187042853878e-05,
      3.1831584432385951e-01, 2.0508716244082827e-02, 3.9416391091401798e-03, 1.2437066454919492e-03, 5.3388412760438429e-04, 2.8220739405572715e-04, 1.724863738088588e-04, 1.1687614960899851e-04, 8.5316109907050984e-05, 6.5782666312527683e-05, 5.284697544273152e-05, 4.3809286691720934e-05, 3.7217487311864126e-05, 3.2238364014252625e-05, 2.8367308890911826e-05, 2.5284478532951966e-05, 2.2779115738440224e-05, 2.0707630889860637e-05, 1.8969325198028049e-05, 1.7491773661377437e-05, 1.6221718207615006e-05, 1.5119219737840501e-05, 1.4153800525900261e-05, 1.330183761869834e-05, 1.2544763064718351e-05, 1.1867796748097528e-05, 1.1259038295308802e-05, 1.0708805746818001e-05, 1.0209146806406619e-05, 9.753472734805792e-06, 9.336280695345436e-06, 8.9529407638957467e-06,
      3.1578264935654971e-01, 2.0025556850709857e-02, 3.7902566091593719e-03, 1.1791208944715807e-03, 4.9991855894803816e-04, 2.6153257604208759e-04, 1.5852250022815872e-04, 1.0670879651406984e-04, 7.7492253323275167e-05, 5.9507260230235823e-05, 4.765136422254076e-05, 3.9399980368501102e-05, 3.3401307340067412e-05, 2.8882776230617251e-05, 2.5378158752838234e-05, 2.2592866410339374e-05, 2.0333327038162346e-05, 1.8467989485072621e-05, 1.6904804705274803e-05, 1.557770261750502e-05, 1.4438186934173471e-05, 1.3449949614707855e-05, 1.2585325432569785e-05, 1.1822900736265185e-05, 1.1145865189523815e-05, 1.0540853105854177e-05, 9.9971143193078985e-06, 9.5059111780225408e-06, 9.0600734553508612e-06, 8.6536653387641602e-06, 8.2817331503251929e-06, 7.9401120190713143e-06,
      3.1330868732130712e-01, 1.9560826543337788e-02, 3.6466885626319288e-03, 1.1186237615785706e-03, 4.6843148144671767e-04, 2.4252629406987171e-04, 1.4577041292912981e-04, 9.7472046261010991e-05, 7.0413629125790802e-05, 5.3848066702245747e-05, 4.2978164965009834e-05, 3.5442427272668422e-05, 2.9982074960553869e-05, 2.5880577881958431e-05, 2.2707060931897861e-05, 2.0190133695157889e-05, 1.8151969790461419e-05, 1.6472023448919687e-05, 1.5066137050604829e-05, 1.3874027685616677e-05, 1.2851528239783661e-05, 1.1965626870538641e-05, 1.1191207970665608e-05, 1.0508858173590036e-05, 9.9033566410137436e-06, 9.3626154691975993e-06, 8.8769225641603584e-06, 8.4383917498742015e-06, 8.0405573962855786e-06, 7.6780714803603881e-06, 7.3464743399219446e-06, 7.0420191770454248e-06,
      3.1089171432666346e-01, 1.9113579667483484e-02, 3.5104427244549903e-03, 1.0619180856749598e-03, 4.3922349967186848e-04, 2.2504410873784377e-04, 1.3411941329596468e-04, 8.9077393402503717e-05, 6.4007148983427726e-05, 4.8743187856087135e-05, 3.8773897797464623e-05, 3.18896691501478e-05, 2.6918009870556563e-05, 2.3194185643511308e-05, 2.0319894296489228e-05, 1.8045058741005059e-05, 1.6206282517803172e-05, 1.4693082648039958e-05, 1.3428502315356505e-05, 1.2357529576082172e-05, 1.1439933748329193e-05, 1.0645695607670249e-05, 9.9520111429517166e-06, 9.341278238521347e-06, 8.7997136709937209e-06, 8.3163839890361208e-06, 7.8825140543991896e-06, 7.4909855277724149e-06, 7.1359676289616889e-06, 6.8126415257822116e-06, 6.5169919978027773e-06, 6.2456481113300952e-06,
      3.0852960093703569e-01, 1.8682929841196003e-02, 3.3810624828052326e-03, 1.0087305367711815e-03, 4.1211243636949112e-04, 2.0895474969840925e-04, 1.2346931450792935e-04, 8.1445001897055392e-05, 5.8207058857828083e-05, 4.4137057168570294e-05, 3.4990638115222313e-05, 2.8699687461697033e-05, 2.4171772988931164e-05, 2.07900465104007e-05, 1.8186224150251601e-05, 1.6129814730644177e-05, 1.4470648445351636e-05, 1.3107444933026452e-05, 1.196981911237929e-05, 1.1007560597355531e-05, 1.0184018545163526e-05, 9.4718910939416411e-06, 8.8504702871407901e-06, 8.30379427997988e-06, 7.8193802337810243e-06, 7.3873378274910704e-06, 6.999737690931944e-06, 6.6501539586500312e-06, 6.3333279044899505e-06, 6.0449171669248271e-06, 5.7813063967816538e-06, 5.5394626001220235e-06,
      3.0622032503445928e-01, 1.8268045681603989e-02, 3.2581240105802704e-03, 9.5880956330202452e-04, 3.8693176570278983e-04, 1.9413886708851742e-04, 1.1372941315708956e-04, 7.4502836026849107e-05, 5.2954189421510156e-05, 3.9979782243177972e-05, 3.1585432538981483e-05, 2.5834878550816092e-05, 2.1709990392616627e-05, 1.8638202520774571e-05, 1.6278901520505778e-05, 1.4419598597147821e-05, 1.2922250084724824e-05, 1.1693993146476275e-05, 1.0670441345327044e-05, 9.8057589363975561e-06, 9.0665511001231685e-06, 8.4279837320960174e-06, 7.8712497246380374e-06, 7.3818728367922415e-06, 6.9485466111518656e-06, 6.5623233644178984e-06, 6.2160372533057448e-06, 5.9038869750903185e-06, 5.6211293156731896e-06, 5.3638509493092647e-06, 5.1287963233913447e-06, 4.9132363065331581e-06,
      3.0396196519290036e-01, 1.7868146871993514e-02, 3.1412336615864642e-03, 9.1192352581892229e-04, 3.6352919480716538e-04, 1.8048790495610848e-04, 1.0481756385332643e-04, 6.8185880063682315e-05, 4.8195284232034741e-05, 3.6226556643173316e-05, 2.8519776894685227e-05, 2.326158504574974e-05, 1.9502828649505876e-05, 1.6711902778058984e-05, 1.4573706235114613e-05, 1.289230069456939e-05, 1.1540761913000408e-05, 1.043392788931584e-05, 9.5128886538476634e-06, 8.7357947753952566e-06, 8.0722133664571098e-06, 7.4995517067116077e-06, 7.0007267281149976e-06, 6.5626078679135728e-06, 6.1749529871349273e-06, 5.8296663152333696e-06, 5.520271356838689e-06, 5.2415301706944905e-06, 4.9891641398560488e-06, 4.7596462918323907e-06, 4.5500448357333473e-06, 4.3579038805347089e-06,
      3.0175269452443498e-01, 1.7482500540232412e-02, 3.0300255892910964e-03, 8.6785899947997957e-04, 3.4176537918458109e-04, 1.6790308447741433e-04, 9.6659346308737665e-05, 6.2435437483348208e-05, 4.3882397497066096e-05, 3.2837133450683519e-05, 2.5759149573168343e-05, 2.0949677426707376e-05, 1.7523615964547056e-05, 1.4987257605092376e-05, 1.3049028980386157e-05, 1.152821072494873e-05, 1.0308076930294358e-05, 9.3105120738481655e-06, 8.4816067918175579e-06, 7.783144688198068e-06, 7.1873876761676361e-06, 6.6737790896834864e-06, 6.2267997351047515e-06, 5.8345381248626586e-06, 5.4877151560992455e-06, 5.179005056407541e-06, 4.9025537652725593e-06, 4.6536315439775467e-06, 4.4283785213293969e-06, 4.2236156689821849e-06, 4.0367025532820858e-06, 3.8654290043115523e-06,
      2.9959077496006103e-01, 1.7110417921996874e-02, 2.9241595680499929e-03, 8.2641922943624073e-04, 3.2151275891073908e-04, 1.5629448600462288e-04, 8.9187315482005739e-05, 5.7198501494304197e-05, 3.9972354131360666e-05, 2.9775354006707437e-05, 2.3272594343525144e-05, 1.887218034847296e-05, 1.5748504165664392e-05, 1.344293023004906e-05, 1.1685588062604192e-05, 1.0309755925701162e-05, 9.2080633474848443e-06, 8.3088437343570638e-06, 7.5627546049569142e-06, 6.9348911581516907e-06, 6.3999674315522679e-06, 5.9392765473081004e-06, 5.5387180810569755e-06, 5.1874850589607222e-06, 4.8771698660230124e-06, 4.6011427611072211e-06, 4.3541117543266875e-06, 4.1318055922036123e-06, 3.9307418545969963e-06, 3.7480548912158614e-06, 3.5813664837705469e-06, 3.4286874511001216e-06,
      2.9747455193107697e-01, 1.6751251284646919e-02, 2.8233189986110797e-03, 7.8742272475838294e-04, 3.0265450392758192e-04, 1.4558022009882458e-04, 8.2340326337632076e-05, 5.2427189509584001e-05, 3.642626558026248e-05, 2.7008725987062597e-05, 2.1032347332962723e-05, 1.7004938895668516e-05, 1.4156167098945063e-05, 1.2059861908705665e-05, 1.0466177067095882e-05, 9.221267963474906e-06, 8.2263480717532985e-06, 7.4156539590849493e-06, 6.744014646415336e-06, 6.1795444125783884e-06, 5.6991889293778101e-06, 5.2859221132613636e-06, 4.9269308324584568e-06, 4.6124089502270164e-06, 4.3347375812151405e-06, 4.0879162188980765e-06, 3.8671604828000485e-06, 3.6686127884113562e-06, 3.4891309728745665e-06, 3.3261316540703813e-06, 3.1774726194958573e-06, 3.0413634476138739e-06,
      2.954024494198404e-01, 1.6404391089764093e-02, 2.7272090814003114e-03, 7.5070197793971542e-04, 2.8508355786062932e-04, 1.3568567870327693e-04, 7.6062925647187038e-05, 4.8078234962597328e-05, 3.3209095575126691e-05, 2.4508045593915233e-05, 1.9013503455428326e-05, 1.5326320470961961e-05, 1.2727531485858086e-05, 1.0821026836654034e-05, 9.3754400279432996e-06, 8.2487753735375619e-06, 7.3501240273880505e-06, 6.6191271565070074e-06, 6.0144247995036503e-06, 5.506884083053085e-06, 5.0754819529105982e-06, 4.7047197768141653e-06, 4.3829525731294207e-06, 4.1012812057857987e-06, 3.8528006991807228e-06, 3.6320794540653263e-06, 3.4347915594806727e-06, 3.2574526980997833e-06, 3.0972274616004749e-06, 2.951786734697085e-06, 2.8192007366915814e-06, 2.6978578250837185e-06,
      2.933729653513466e-01, 1.6069263374328305e-02, 2.6355551426372518e-03, 7.1610229826472296e-04, 2.6870177084920515e-04, 1.2654285850891944e-04, 7.0304804040714931e-05, 4.4112530557491929e-05, 3.0289270603140411e-05, 2.2247059199907975e-05, 1.7193718079078634e-05, 1.3816948482497801e-05, 1.1445536725610026e-05, 9.7112136046676289e-06, 8.3996710942991523e-06, 7.3798187331292608e-06, 6.567978677914556e-06, 5.9087411789651457e-06, 5.3642285703404745e-06, 4.907818479316773e-06, 4.5203370322349435e-06, 4.1876738885789732e-06, 3.8992442385659955e-06, 3.6469710071453898e-06, 3.4245954783981852e-06, 3.2272004704901166e-06, 3.0508741994481918e-06, 2.8924691899006978e-06, 2.7494266076422987e-06, 2.6196463989339494e-06, 2.5013900099746071e-06, 2.393206616623814e-06,
      2.9138466729945317e-01, 1.5745327332291448e-02, 2.5481010997196189e-03, 6.834807484614432e-04, 2.5341911281993016e-04, 1.1808974936853928e-04, 6.5020302215812825e-05, 4.0494717661847141e-05, 2.7638330425206079e-05, 2.020216027930317e-05, 1.5552940175425163e-05, 1.2459464412028852e-05, 1.0294920508933455e-05, 8.7168303060509013e-06, 7.5266360109178178e-06, 6.6032860678498395e-06, 5.8697414076729912e-06, 5.2751251022602182e-06, 4.7847419739304299e-06, 4.3742595121097952e-06, 4.0261875086966123e-06, 3.7276776105495366e-06, 3.4691073076883992e-06, 3.2431446910585553e-06, 3.0441161307220224e-06, 2.8675696402153737e-06, 2.7099675453832089e-06, 2.5684663699413724e-06, 2.4407566640746379e-06, 2.3249447454518751e-06, 2.2194642119062668e-06, 2.1230089116155457e-06,
      2.8943618848375696e-01, 1.5432073079920559e-02, 2.4646080535741443e-03, 6.5270517507329349e-04, 2.3915295948088454e-04, 1.1026978133767956e-04, 6.0167965838293656e-05, 3.7192817101405247e-05, 2.5230614467979175e-05, 1.8352117904489428e-05, 1.40731735967376e-05, 1.123831521520109e-05, 9.2620274508349829e-06, 7.8257307213016219e-06, 6.7454130255293142e-06, 5.9092662663403181e-06, 5.2463476805376375e-06, 4.7099327046012202e-06, 4.2682351687772558e-06, 3.8990115199087633e-06, 3.5863047482652066e-06, 3.3184138363948961e-06, 3.0865898516539407e-06, 2.8841764308244359e-06, 2.7060297067882311e-06, 2.5481184205948887e-06, 2.4072428908730753e-06, 2.2808340250562052e-06, 2.1668072603531808e-06, 2.0634548583286481e-06, 1.9693654077291244e-06, 1.88336291333373e-06,
      2.8752622403511485e-01, 1.5129019589748799e-02, 2.3848529968083522e-03, 6.2365332390284525e-04, 2.2582744407537983e-04, 1.0303132456793252e-04, 5.5710144229450371e-05, 3.4177897110271278e-05, 2.304298035612466e-05, 1.6677833482443087e-05, 1.2738263488353583e-05, 1.0139563335143403e-05, 8.334638253715667e-06, 7.0270592871153204e-06, 6.0462510981270036e-06, 5.2889185241043428e-06, 4.6897181241860028e-06, 4.2057299058125e-06, 3.8078272008282587e-06, 3.4756724496286835e-06, 3.1947050340956875e-06, 2.954267184748558e-06, 2.7464031082361798e-06, 2.5650689464698683e-06, 2.4056005577043804e-06, 2.2643472336744239e-06, 2.1384146857734228e-06, 2.0254814978047796e-06, 1.9236659206085423e-06, 1.8314277677361226e-06, 1.7474951794068761e-06, 1.6708092661115188e-06,
      2.8565352750960943e-01, 1.4835712779302896e-02, 2.3086276275262338e-03, 5.962120327066225e-04, 2.1337286861909991e-04, 9.632723685938775e-05, 5.1612628437640549e-05, 3.1423774631721676e-05, 2.1054551244007291e-05, 1.5162122759451384e-05, 1.1533705163682674e-05, 9.1507169043455249e-06, 7.5018171829227143e-06, 6.3111128075004177e-06, 5.4204435207182578e-06, 4.7343560556958277e-06, 4.1926508933966665e-06, 3.7558946209561141e-06, 3.3973924002482694e-06, 3.0985460145714888e-06, 2.846066833226143e-06, 2.6302458251214052e-06, 2.4438474000797725e-06, 2.2813831155794778e-06, 2.1386232936909433e-06, 2.0122614733595537e-06, 1.8996793305273987e-06, 1.7987790384034969e-06, 1.707861770571819e-06, 1.6255383321511101e-06, 1.5506625230249707e-06, 1.4822808247188778e-06,
      2.8381690763241318e-01, 1.4551723741983708e-02, 2.2357372596010388e-03, 5.7027649406534992e-04, 2.0172516896033749e-04, 9.0114454200624036e-05, 4.7844324742358748e-05, 2.8906746559989482e-05, 1.9246488957383251e-05, 1.3789520438186998e-05, 1.0446473056137649e-05, 8.2605779716934277e-06, 6.7537758778502585e-06, 5.669217087968598e-06, 4.8602152638094023e-06, 4.2385425086976339e-06, 3.7487258481414282e-06, 3.3545276542460677e-06, 3.0314771368073623e-06, 2.7625636067181335e-06, 2.5356572785199185e-06, 2.3419120353050179e-06, 2.1747463480639473e-06, 2.0291754836927604e-06, 1.9013632821892792e-06, 1.7883147228926092e-06, 1.6876608788027826e-06, 1.5975057869578809e-06, 1.5163156180417766e-06, 1.4428372562826907e-06, 1.3760376610158945e-06, 1.3150581328769625e-06,
      2.8201522525451428e-01, 1.4276647108573903e-02, 2.1659998210401014e-03, 5.4574958202636991e-04, 1.9082542855720946e-04, 8.4353620092920652e-05, 4.4376960042654427e-05, 2.660534786707875e-05, 1.7601790269695135e-05, 1.2546105033170383e-05, 9.4648676177486072e-06, 7.4591068249629609e-06, 6.0817517364276375e-06, 5.0936168724551218e-06, 4.3586225507132161e-06, 3.7951996856192905e-06, 3.3522192442782649e-06, 2.9963734117205303e-06, 2.7052257838236095e-06, 2.4632148770517097e-06, 2.2592668367247804e-06, 2.0853205127095557e-06, 1.9353884489523354e-06, 1.8049427859824218e-06, 1.6905038360238756e-06, 1.5893583688844372e-06, 1.4993628675141281e-06, 1.4188036353694438e-06, 1.3462956843350447e-06, 1.2807085482225454e-06, 1.2211110969836914e-06, 1.1667299613317925e-06,
      2.8024739050664271e-01, 1.4010099528844012e-02, 2.0992449328384776e-03, 5.2254123672149512e-04, 1.8061943636439907e-04, 7.9008749875855326e-05, 4.1184815943596187e-05, 2.4500133875213282e-05, 1.6105103918285719e-05, 1.1419341842418618e-05, 8.5783782621734453e-06, 6.7373006871578754e-06, 5.4778993021073139e-06, 4.5773776395098997e-06, 3.9094633252141226e-06, 3.3987253334362352e-06, 2.9980277787019219e-06, 2.6767493467339288e-06, 2.4143148686601331e-06, 2.196486018897004e-06, 2.0131512487249156e-06, 1.8569635717618344e-06, 1.7224751911637015e-06, 1.605572691994086e-06, 1.5030993380618594e-06, 1.4125968901273131e-06, 1.3321255817004061e-06, 1.2601363033818337e-06, 1.1953783461758e-06, 1.1368317984767874e-06, 1.0836573173822808e-06, 1.0351583298917139e-06,
      2.7851236013599506e-01, 1.3751718263634673e-02, 2.0353130614079538e-03, 5.00567901710954e-04, 1.7105728467080132e-04, 7.4046926649099293e-05, 3.8244488678871174e-05, 2.2573484218882674e-05, 1.4742566216804399e-05, 1.0397942137912282e-05, 7.777560653204064e-06, 6.0870852505844089e-06, 4.9351932528637198e-06, 4.1142979717847871e-06, 3.5071974244562065e-06, 3.0441198971001937e-06, 2.6816009588718491e-06, 2.3914831728306152e-06, 2.1548945015368132e-06, 1.9588048969832606e-06, 1.793979930340548e-06, 1.6537224568400694e-06, 1.5330749753665143e-06, 1.428300074002078e-06, 1.3365336338344e-06, 1.2555481809844214e-06, 1.1835881401113299e-06, 1.119253038664169e-06, 1.0614133201767029e-06, 1.0091487336849876e-06, 9.6170261207225698e-07, 9.1844750338057319e-07,
      2.7680913501250654e-01, 1.3501159878617374e-02, 1.9740547382927662e-03, 4.7975200929821569e-04, 1.6209300313351705e-04, 6.9438025724450912e-05, 3.5534672298465849e-05, 2.0809426294129079e-05, 1.3501653344464692e-05, 9.4717368783165756e-06, 7.0539268213465831e-06, 5.5012176779447937e-06, 4.4473417435278177e-06, 3.698831353062706e-06, 3.14687539913576e-06, 2.7269212548549784e-06, 2.3988808804924075e-06, 2.1368569856507055e-06, 1.9235362754812056e-06, 1.7469922606046162e-06, 1.5987901128375637e-06, 1.472824086630738e-06, 1.3645821890103295e-06, 1.2706681782953584e-06, 1.1884830989986275e-06, 1.1160083414889153e-06, 1.0516548568548637e-06, 9.9415641770233148e-07, 9.4249278649845153e-07, 8.9583356000008581e-07, 8.534965458339065e-07, 8.1491650953455221e-07,
      2.7513675779247104e-01, 1.3258099031686142e-02, 1.9153298414493882e-03, 4.600215095066661e-04, 1.5368422561749608e-04, 6.5154464846932329e-05, 3.3035962811211398e-05, 1.9193476219861648e-05, 1.2371048593460518e-05, 8.6315634267570973e-06, 6.3998467530007646e-06, 4.9731998471998575e-06, 4.008708988047119e-06, 3.3260163719305527e-06, 2.8240750389641408e-06, 2.4431465612694494e-06, 2.1462485983486229e-06, 1.9095575306932797e-06, 1.7171869200311226e-06, 1.5582183642184351e-06, 1.4249460829349378e-06, 1.3118026224922141e-06, 1.2146808570383713e-06, 1.1304941485835038e-06, 1.0568838554123219e-06, 9.9202043043782009e-07, 9.344653960824009e-07, 8.8307378355413217e-07, 8.3692400539075973e-07, 7.9526666620020717e-07, 7.5748666612979368e-07, 7.2307477832763425e-07,
      2.7349431072827185e-01, 1.302222734661534e-02, 1.8590069328807747e-03, 4.4130943881210127e-04, 1.4579188677785532e-04, 6.1170977697664323e-05, 3.0730681205931445e-05, 1.7712495539398174e-05, 1.134052303529645e-05, 7.8691639166805952e-06, 5.8084602412944833e-06, 4.4972007484493803e-06, 3.6142460887899331e-06, 2.991414422381008e-06, 2.5348447645019077e-06, 2.1892404200384839e-06, 1.920476365306945e-06, 1.7066319383515254e-06, 1.5331270710741063e-06, 1.3899643942854654e-06, 1.2701029536850474e-06, 1.1684653214923707e-06, 1.08131235592499e-06, 1.0058384127084471e-06, 9.3990266893094589e-07, 8.8184673466043782e-07, 8.3036829133024627e-07, 7.844319090836141e-07, 7.4320503094531521e-07, 7.0601130543503869e-07, 6.7229607956762512e-07, 6.4160054780371304e-07,
      2.7188091361386812e-01, 1.2793252366240414e-02, 1.8049626478805606e-03, 4.2355352508910465e-04, 1.3837994561714838e-04, 5.7464408437412042e-05, 2.8602713484809555e-05, 1.6354562072620929e-05, 1.0400828227293387e-05, 7.1770940519839118e-06, 5.2735979166289341e-06, 4.0679870583472074e-06, 3.2594292274191207e-06, 2.6910540906422852e-06, 2.2756531382593993e-06, 1.9620286941267349e-06, 1.7186850945223213e-06, 1.5254483228191594e-06, 1.3689345900866409e-06, 1.239988168182412e-06, 1.1321744611663343e-06, 1.0408621952230704e-06, 9.626467357770618e-07, 8.9497749885356824e-07, 8.3591111467238808e-07, 7.8394415809964973e-07, 7.3789744958836107e-07, 6.9683452088723177e-07, 6.6000317126909569e-07, 6.2679291778865862e-07, 5.9670357130359522e-07, 5.6932172189128683e-07,
      2.7029572185648787e-01, 1.2570896578984711e-02, 1.7530811315645369e-03, 4.06695825558423e-04, 1.3141513351592427e-04, 5.4013525271010667e-05, 2.6637366030908287e-05, 1.5108853492335747e-05, 9.5435997241138165e-06, 6.5486412555044519e-06, 4.7897104901393215e-06, 3.6808610221551905e-06, 2.9402044275804754e-06, 2.4213815057173361e-06, 2.0433438296641353e-06, 1.7586773369149192e-06, 1.5383064710592246e-06, 1.3636607082960581e-06, 1.2224519290126917e-06, 1.1062936305525783e-06, 1.0093043383702973e-06, 9.2725904914386166e-07, 8.5705724635334375e-07, 7.9637989624703751e-07, 7.434626421870512e-07, 6.9694237909657419e-07, 6.5575130313191256e-07, 6.1904236043731173e-07, 5.8613588406804579e-07, 5.5648079419950917e-07, 5.2962597865962223e-07, 5.0519890147199024e-07,
      2.6873792466571828e-01, 1.2354896513071459e-02, 1.7032535187494404e-03, 3.9068239481991493e-04, 1.2486672447472886e-04, 5.0798851211885419e-05, 2.4821234800767254e-05, 1.3965542344640112e-05, 8.7612702876114856e-06, 5.9777511942686623e-06, 4.3518053460713897e-06, 3.3316048668251643e-06, 2.6529381849621571e-06, 2.1792160096552678e-06, 1.8350954412248448e-06, 1.5766556956997074e-06, 1.3770492024201873e-06, 1.2191778053247964e-06, 1.0917570929800466e-06, 9.8710372534298239e-07, 8.9984086778503263e-07, 8.2611352483376921e-07, 7.6309770822069962e-07, 7.0868461866113218e-07, 6.6127221439178633e-07, 6.1962446396072063e-07, 5.8277431025033999e-07, 5.4995549559614533e-07, 5.2055383189591423e-07, 4.9407181627656346e-07, 4.7010256304668453e-07, 4.4831034169176539e-07,
      2.6720674335186223e-01, 1.2145001893230546e-02, 1.6553774535864269e-03, 3.7546298032463133e-04, 1.1870632552191698e-04, 4.7802510404863964e-05, 2.3142086984693543e-05, 1.2915701364125927e-05, 8.0469918032565106e-06, 5.4589618120506828e-06, 3.9553897108507874e-06, 3.0164310517100399e-06, 2.3943733363220573e-06, 1.9617105735366258e-06, 1.6483856679656021e-06, 1.413703799125309e-06, 1.2328689537563147e-06, 1.0901352128960329e-06, 9.75137802777977e-07, 8.8083626875179495e-07, 8.0231425868519754e-07, 7.3605380981124737e-07, 6.7948241052899902e-07, 6.3068216743451356e-07, 5.8819823087165807e-07, 5.5090966011207219e-07, 5.1794053979409205e-07, 4.8859762812914631e-07, 4.6232585258442682e-07, 4.3867603668484867e-07, 4.1728115337092784e-07, 3.9783861660822453e-07,
      2.657014297260501e-01, 1.1940974855138644e-02, 1.6093566456719392e-03, 3.6099074288289479e-04, 1.1290768543662819e-04, 4.5008088526488413e-05, 2.1588753913531959e-05, 1.19512180521631e-05, 7.3945650142543825e-06, 4.9873440911028328e-06, 3.5964197085693183e-06, 2.7319377377379419e-06, 2.1615896068623003e-06, 1.7663164474728549e-06, 1.4809593198418246e-06, 1.2678031937135475e-06, 1.1039415635880219e-06, 9.7487066890419061e-07, 8.7106850320719972e-07, 7.8608249003954626e-07, 7.1541653466318308e-07, 6.5585971711928196e-07, 6.0506825262214122e-07, 5.6129762484089311e-07, 5.2322647875215694e-07, 4.8983812330648137e-07, 4.6033910441995802e-07, 4.3410217163915914e-07, 4.1062562808392232e-07, 3.8950389148301521e-07, 3.7040585987467026e-07, 3.5305879717161363e-07,
      2.6422126459516815e-01, 1.1742589213222847e-02, 1.5651004596450879e-03, 3.472220000253943e-04, 1.074465201121641e-04, 4.2400505926907079e-05, 2.0151034112973789e-05, 1.1064717591759629e-05, 6.7983762765478583e-06, 4.558448846544265e-06, 3.27125468578993e-06, 2.4750689221120404e-06, 1.951968335755969e-06, 1.5907515884369604e-06, 1.3307997881657916e-06, 1.137150942344015e-06, 9.8863918038208193e-07, 8.7190201326849278e-07, 7.7818990268131669e-07, 7.0158794422849326e-07, 6.3798365203749408e-07, 5.8444587019865053e-07, 5.3883887842108224e-07, 4.9957563888360368e-07, 4.6545588326496682e-07, 4.355573611518112e-07, 4.0916123398554456e-07, 3.8569989987405512e-07, 3.6471985951135169e-07, 3.4585485947019671e-07, 3.2880618020773272e-07, 3.1332797060462557e-07,
      2.6276555634518672e-01, 1.1549629777815209e-02, 1.5225235355408753e-03, 3.3411599023356773e-04, 1.023003530437039e-04, 3.9965902307807675e-05, 1.8819605516271378e-05, 1.0249493266849116e-05, 6.2533406203088429e-06, 4.1682589298698799e-06, 2.9766162539260298e-06, 2.2430787446916957e-06, 1.7631609335032288e-06, 1.4329724592030844e-06, 1.1961035827592409e-06, 1.0201364399695577e-06, 8.8550899992728526e-07, 7.7990756513801593e-07, 6.9529076435692348e-07, 6.2623553364815911e-07, 5.689796009480289e-07, 5.2084675816081911e-07, 4.7989058066833735e-07, 4.4466708744459927e-07, 4.1408585578837874e-07, 3.8731019968879165e-07, 3.6368880410627807e-07, 3.4270798799657972e-07, 3.2395777798247635e-07, 3.0710740458420234e-07, 2.9188733976955557e-07, 2.7807594880142152e-07,
      2.6133363960695355e-01, 1.1361891717971953e-02, 1.4815454374050969e-03, 3.2163465623595013e-04, 9.7448369567522627e-05, 3.7691531848220563e-05, 1.7585945944860672e-05, 9.4994436384590446e-06, 5.7548504773154329e-06, 3.8131462832926806e-06, 2.709551555823053e-06, 2.0334995249414522e-06, 1.5930606728270738e-06, 1.2911488357411363e-06, 1.0752576072339117e-06, 9.1532073961533608e-07, 7.9325431867150896e-07, 6.9770864858822111e-07, 6.2129170008508832e-07, 5.5903040454424157e-07, 5.0748226863455268e-07, 4.6420345284286741e-07, 4.2741977711359081e-07, 3.9581723354264682e-07, 3.6840505990755178e-07, 3.4442410160170993e-07, 3.2328415578506503e-07, 3.0452028947729287e-07, 2.8776184011393031e-07, 2.7271005599405733e-07, 2.5912172630515968e-07, 2.4679703069495791e-07,
      2.5992487399895836e-01, 1.1179179966569234e-02, 1.4420903278917856e-03, 3.0974244573054818e-04, 9.2871283608178648e-05, 3.5565667795695663e-05, 1.6442261055009403e-05, 8.8090158060833809e-06, 5.2987294996803048e-06, 3.4898333449841522e-06, 2.4674003153124839e-06, 1.8441131353926247e-06, 1.4397774576493217e-06, 1.1636412996795442e-06, 9.6681887602856139e-07, 8.2141811531804917e-07, 7.1071764951294134e-07, 6.2425403054810433e-07, 5.552307460430112e-07, 4.9908651096377537e-07, 4.5267086898510103e-07, 4.1375180235292489e-07, 3.8071188290288733e-07, 3.523552045998405e-07, 3.2778143623694038e-07, 3.0630168395382538e-07, 2.8738106055748194e-07, 2.7059870906937219e-07, 2.5561947419921856e-07, 2.4217349701814269e-07, 2.3004129464029166e-07, 2.19042698897813e-07,
      2.5853864294198181e-01, 1.1001308664559771e-02, 1.4040866667596645e-03, 2.9840612804132432e-04, 8.8551215806896604e-05, 3.357751563552635e-05, 1.5381419028237856e-05, 8.1731541506336974e-06, 4.8811909545661805e-06, 3.1953583574648872e-06, 2.2477652750907505e-06, 1.6729253595619378e-06, 1.3016152528818871e-06, 1.0489811274402959e-06, 8.6949640909309643e-07, 7.372796185744499e-07, 6.3686567440883939e-07, 5.586060607783607e-07, 4.9625052340605966e-07, 4.4561466122655257e-07, 4.0381476428235434e-07, 3.6881193652665132e-07, 3.3913142312535253e-07, 3.136846473804528e-07, 2.9165334466727911e-07, 2.7241230048921083e-07, 2.5547670203189482e-07, 2.4046554810596613e-07, 2.2707575823948574e-07, 2.1506354861491339e-07, 2.0423083153530496e-07, 1.9441514452993108e-07,
      2.5717435254091553e-01, 1.0828100641523874e-02, 1.3674669313620269e-03, 2.875946253510167e-04, 8.4471582009836997e-05, 3.1717134036422947e-05, 1.439689135482798e-05, 7.5872540163905595e-06, 4.4988002325208609e-06, 2.9270441780785975e-06, 2.0484856698949644e-06, 1.5181429197602657e-06, 1.1770518918315018e-06, 9.4585231883366736e-07, 7.8213506884299254e-07, 6.6187841149300378e-07, 5.7077583295979675e-07, 4.9992832691306723e-07, 4.4358680919871201e-07, 3.9791188281534311e-07, 3.6026352447622887e-07, 3.2877893810683952e-07, 3.021132469518381e-07, 2.7927542691977976e-07, 2.5952169859965068e-07, 2.4228456875347109e-07, 2.2712455928164555e-07, 2.1369671235533768e-07, 2.0172692446550012e-07, 1.9099494614928679e-07, 1.813219831292621e-07, 1.7256152620619133e-07,
      2.5583143052938306e-01, 1.0659386929876238e-02, 1.3321673573864744e-03, 2.7727885727412685e-04, 8.0616991190231646e-05, 2.9975362848281528e-05, 1.348269912407369e-05, 7.0471198441512405e-06, 4.1484410545391831e-06, 2.682470232243246e-06, 1.8676134191372278e-06, 1.3781528936897323e-06, 1.0647210083973181e-06, 8.5307553569186426e-07, 7.0370112959800526e-07, 5.9429668354224763e-07, 5.1162436818672777e-07, 4.4747465820140858e-07, 3.9655836182171215e-07, 3.5535195975313085e-07, 3.2143808654349556e-07, 2.9311454978979617e-07, 2.6915472031804279e-07, 2.4865625254098815e-07, 2.3094297983742641e-07, 2.1549973577940354e-07, 2.0192809047589047e-07, 1.8991568507891609e-07, 1.7921459691717394e-07, 1.6962581962294608e-07, 1.6098795851773374e-07, 1.5316887984389789e-07
   }; // 24.25 kb
} // namespace ir
// kate: syntax c++;
