// this code is GENERATED. Do not change it directly!
void FWfOptions::InitProperties() {
   m_RunScf = true;
   m_RunIbba = true;
   m_Charge = 0;
   m_ExtraSpin = 0;
   m_ScfMethod = "Kohn-Sham (DF-RKS)";
   m_Functional = "PBE";
   m_OrbBasis = "def2-TZVP";
   m_FitBasis = "univ-JFIT";
   m_LocMethod = "IBO (exponent 4)";
   m_OrbDivision = "Closed/Open";
   m_OrbDisplay = "Occupied only";
   m_AoType = "IAO (Sym Orth.)";
   m_BondOrderType = "IAO/ReNorm";
   m_LevelShiftClosed = -1.0;
   m_LevelShiftOpen = -0.5;
   m_ThrGrad = 1e-05;
   m_ThrEnergy = 1e-06;
   m_MaxIter = 4096;
   m_WorkSpaceMb = 200;
   m_NumThreads = 0;
}

static char const *BoolToCstr(bool o) { return o? "true" : "false"; }

QString FWfOptions::GetOptionsDesc() {
   std::stringstream str;
   if (m_RunScf != true)
      str << boost::format("doc.wf.run_scf = %s;\n") % BoolToCstr(m_RunScf);
   if (m_RunIbba != true)
      str << boost::format("doc.wf.run_ibba = %s;\n") % BoolToCstr(m_RunIbba);
   if (m_Charge != 0)
      str << boost::format("doc.wf.charge = %i;\n") % m_Charge;
   if (m_ExtraSpin != 0)
      str << boost::format("doc.wf.extra_spin = %i;\n") % m_ExtraSpin;
   if (m_ScfMethod != "Kohn-Sham (DF-RKS)")
      str << boost::format("doc.wf.scf_method = %s;\n") % q2s(m_ScfMethod);
   if (m_Functional != "PBE")
      str << boost::format("doc.wf.functional = %s;\n") % q2s(m_Functional);
   if (m_OrbBasis != "def2-TZVP")
      str << boost::format("doc.wf.orb_basis = %s;\n") % q2s(m_OrbBasis);
   if (m_FitBasis != "univ-JFIT")
      str << boost::format("doc.wf.fit_basis = %s;\n") % q2s(m_FitBasis);
   if (m_LocMethod != "IBO (exponent 4)")
      str << boost::format("doc.wf.loc_method = %s;\n") % q2s(m_LocMethod);
   if (m_OrbDivision != "Closed/Open")
      str << boost::format("doc.wf.orb_division = %s;\n") % q2s(m_OrbDivision);
   if (m_OrbDisplay != "Occupied only")
      str << boost::format("doc.wf.orb_display = %s;\n") % q2s(m_OrbDisplay);
   if (m_AoType != "IAO (Sym Orth.)")
      str << boost::format("doc.wf.ao_type = %s;\n") % q2s(m_AoType);
   if (m_BondOrderType != "IAO/ReNorm")
      str << boost::format("doc.wf.bond_order_type = %s;\n") % q2s(m_BondOrderType);
   if (std::abs(m_LevelShiftClosed - -1.0) > 1e-4)
      str << boost::format("doc.wf.level_shift_closed = %.5f;\n") % m_LevelShiftClosed;
   if (std::abs(m_LevelShiftOpen - -0.5) > 1e-4)
      str << boost::format("doc.wf.level_shift_open = %.5f;\n") % m_LevelShiftOpen;
   if (std::abs(m_ThrGrad - 1e-05) > 1e-4)
      str << boost::format("doc.wf.thr_grad = %.5f;\n") % m_ThrGrad;
   if (std::abs(m_ThrEnergy - 1e-06) > 1e-4)
      str << boost::format("doc.wf.thr_energy = %.5f;\n") % m_ThrEnergy;
   if (m_MaxIter != 4096)
      str << boost::format("doc.wf.max_iter = %i;\n") % m_MaxIter;
   if (m_WorkSpaceMb != 200)
      str << boost::format("doc.wf.work_space_mb = %i;\n") % m_WorkSpaceMb;
   if (m_NumThreads != 0)
      str << boost::format("doc.wf.num_threads = %i;\n") % m_NumThreads;
   return s2q(str.str());
}

void FWfOptions::SetRunScf(bool o) {
   if (o != m_RunScf) {
      m_RunScf = o;
      emit RunScfChanged(m_RunScf);
   }
}

void FWfOptions::SetRunIbba(bool o) {
   if (o != m_RunIbba) {
      m_RunIbba = o;
      emit RunIbbaChanged(m_RunIbba);
   }
}

void FWfOptions::SetCharge(int o) {
   if (o < -32) o = -32;
   if (o > 32) o = 32;
   if (o != m_Charge) {
      m_Charge = o;
      emit ChargeChanged(m_Charge);
   }
}

void FWfOptions::SetExtraSpin(int o) {
   if (o < 0) o = 0;
   if (o > 32) o = 32;
   if (o != m_ExtraSpin) {
      m_ExtraSpin = o;
      emit ExtraSpinChanged(m_ExtraSpin);
   }
}

void FWfOptions::SetScfMethod(QString o) {
   if (o != m_ScfMethod) {
      m_ScfMethod = o;
      emit ScfMethodChanged(m_ScfMethod);
   }
}

void FWfOptions::SetFunctional(QString o) {
   if (o != m_Functional) {
      m_Functional = o;
      emit FunctionalChanged(m_Functional);
   }
}

void FWfOptions::SetOrbBasis(QString o) {
   if (o != m_OrbBasis) {
      m_OrbBasis = o;
      emit OrbBasisChanged(m_OrbBasis);
   }
}

void FWfOptions::SetFitBasis(QString o) {
   if (o != m_FitBasis) {
      m_FitBasis = o;
      emit FitBasisChanged(m_FitBasis);
   }
}

void FWfOptions::SetLocMethod(QString o) {
   if (o != m_LocMethod) {
      m_LocMethod = o;
      emit LocMethodChanged(m_LocMethod);
   }
}

void FWfOptions::SetOrbDivision(QString o) {
   if (o != m_OrbDivision) {
      m_OrbDivision = o;
      emit OrbDivisionChanged(m_OrbDivision);
   }
}

void FWfOptions::SetOrbDisplay(QString o) {
   if (o != m_OrbDisplay) {
      m_OrbDisplay = o;
      emit OrbDisplayChanged(m_OrbDisplay);
   }
}

void FWfOptions::SetAoType(QString o) {
   if (o != m_AoType) {
      m_AoType = o;
      emit AoTypeChanged(m_AoType);
   }
}

void FWfOptions::SetBondOrderType(QString o) {
   if (o != m_BondOrderType) {
      m_BondOrderType = o;
      emit BondOrderTypeChanged(m_BondOrderType);
   }
}

void FWfOptions::SetLevelShiftClosed(double o) {
   if (o < -32.0) o = -32.0;
   if (o > 32.0) o = 32.0;
   if (o != m_LevelShiftClosed) {
      m_LevelShiftClosed = o;
      emit LevelShiftClosedChanged(m_LevelShiftClosed);
   }
}

void FWfOptions::SetLevelShiftOpen(double o) {
   if (o < -32.0) o = -32.0;
   if (o > 32.0) o = 32.0;
   if (o != m_LevelShiftOpen) {
      m_LevelShiftOpen = o;
      emit LevelShiftOpenChanged(m_LevelShiftOpen);
   }
}

void FWfOptions::SetThrGrad(double o) {
   if (o < 1e-14) o = 1e-14;
   if (o > 100000000.0) o = 100000000.0;
   if (o != m_ThrGrad) {
      m_ThrGrad = o;
      emit ThrGradChanged(m_ThrGrad);
   }
}

void FWfOptions::SetThrEnergy(double o) {
   if (o < 1e-14) o = 1e-14;
   if (o > 100000000.0) o = 100000000.0;
   if (o != m_ThrEnergy) {
      m_ThrEnergy = o;
      emit ThrEnergyChanged(m_ThrEnergy);
   }
}

void FWfOptions::SetMaxIter(int o) {
   if (o < 0) o = 0;
   if (o != m_MaxIter) {
      m_MaxIter = o;
      emit MaxIterChanged(m_MaxIter);
   }
}

void FWfOptions::SetWorkSpaceMb(int o) {
   if (o < 0) o = 0;
   if (o > 128000) o = 128000;
   if (o != m_WorkSpaceMb) {
      m_WorkSpaceMb = o;
      emit WorkSpaceMbChanged(m_WorkSpaceMb);
   }
}

void FWfOptions::SetNumThreads(int o) {
   if (o < 0) o = 0;
   if (o > 128000) o = 128000;
   if (o != m_NumThreads) {
      m_NumThreads = o;
      emit NumThreadsChanged(m_NumThreads);
   }
}
// kate: syntax c++;
