# /usr/bin/qmake-qt4 -o Makefile main.pro && make -j 4
MKLDIR = $$(MKLROOT)
# MKLDIR = /opt/intel/composerxe/mkl
# ^- FIXME: adjust path of MKL here if MKLROOT environment variable is not set.
# (e.g., 
# MKLDIR = /opt/intel/composerxe/mkl
# )

# LIBS += -L$$MKLDIR/lib/em64t -lmkl_intel_ilp64 -lmkl_sequential -lmkl_core -lmkl_lapack -Wl,-rpath,$$MKLDIR/lib/em64t
# LIBS += -L$$MKLDIR/lib/intel64 -lmkl_gf_ilp64 -lmkl_sequential -lmkl_core -Wl,-rpath,$$MKLDIR/lib/intel64
LIBS += -L$$MKLDIR/lib/intel64 -fopenmp -lmkl_gf_ilp64 -lmkl_gnu_thread -lmkl_core -Wl,-rpath,$$MKLDIR/lib/intel64
# LIBS += -LC:\Users\cgk\Develop\Libraries\OpenBLAS\bin -lopenblas

# MICROSCF = ../wmme

###! START_DIRS
MICROSCF = src/MicroScf
IRCORE = src/IrCore
CXF = src/Common
IV = src/IboView
OTHER = src/External
GL = src/GL
PUGIXML = src/pugixml
###! END_DIRS

TEMPLATE = app
TARGET = iboview
DEPENDPATH += .
# LIBS += -L/opt/local/lib
# INCLUDEPATH += /opt/local/include/
INCLUDEPATH += $$IV
INCLUDEPATH += $$MICROSCF
INCLUDEPATH += $$IRCORE
INCLUDEPATH += $$CXF
INCLUDEPATH += $$OTHER
INCLUDEPATH += $$PUGIXML
INCLUDEPATH += src
DEFINES += USE_CTINT1E_H
DEFINES += PROG_IBOVIEW

# LIBS += -lGLEW     # OpenGL extension wrangler library (rest is included automatically via QT += opengl).
# (brings own implementation of glew.c now, from glew-20140726.tgz)
DEFINES += GLEW_STATIC
SOURCES += $$GL/glew.c
HEADERS += $$GL/glew.h $$GL/glxew.h $$GL/wglew.h

# OPTFLAGS = -O2 -march=native
# QMAKE_CFLAGS_RELEASE  = $$OPTFLAGS
# QMAKE_CXXFLAGS_RELEASE = $$OPTFLAGS
# ^- still makes it slower... (but DOES get rid of the -g switch which qmake
#    otherwise also sets for release builds. Still not sure where that comes
#    from.)

# OpenMP
msvc {
   QMAKE_CXXFLAGS += /openmp
   QMAKE_LFLAGS += /openmp
}
!msvc {
   QMAKE_CXXFLAGS += -fopenmp
   QMAKE_LFLAGS += -fopenmp
}
# ^- warning: need to replace all OpenMP loop variables by "int". Otherwise won't work
#    in vc or gcc <= 4.4 (unsigned integral types only allowed since OpenMP 3.0... wtf
#    were they thinking?!)

#msvc:QMAKE_CXXFLAGS_RELEASE += /O2 /openmp /arch:AVX
#gcc:QMAKE_CXXFLAGS_RELEASE += -O3 -march=native -fopenmp -D_GLIBCXX_PARALLEL

# LIBS += -lboost_program_options
# ^- currently not used.

QT += core gui widgets opengl script svg
CONFIG += qt
CONFIG -= debug
CONFIG += release
DEFINES += NDEBUG
# ^- does this work?! assertions are still there!!

# CONFIG += debug
# CONFIG -= release

# flags for profiling (gprof)
# QMAKE_CFLAGS_RELEASE += -g -pg
# QMAKE_CXXFLAGS_RELEASE += -g -pg
# QMAKE_LFLAGS_RELEASE += -g -pg

# flags for profiling (callgrind)
# QMAKE_CFLAGS_RELEASE += -g
# QMAKE_CXXFLAGS_RELEASE += -g
# QMAKE_LFLAGS_RELEASE += -g

# remove -g's. Make very large executables.
QMAKE_CFLAGS_RELEASE -= -g
QMAKE_CXXFLAGS_RELEASE -= -g
QMAKE_LFLAGS_RELEASE -= -g


QMAKE_CXXFLAGS_RELEASE -= -O2 -mtune=generic
QMAKE_CXXFLAGS_RELEASE -= -fstack-protector --param=ssp-buffer-size=4
# QMAKE_CXXFLAGS_RELEASE += -Ofast -march=native -DNDEBUG
QMAKE_CXXFLAGS_RELEASE += -Ofast -march=native -DNDEBUG -DINCLUDE_OPTIONALS

# note: for compiling with clang instead of g++ on linux:
#   /usr/bin/qmake-qt4 -spec /usr/lib64/qt4/mkspecs/unsupported/linux-clang
# (works for me, but doesn't do OpenMP)

# Input
# FORMS += MainForm.ui
FORMS += $$IV/MainForm2.ui $$IV/AboutForm.ui $$IV/FindOrbitalsForm.ui $$IV/ShowTextForm.ui $$IV/ComputeWfForm.ui $$IV/TablesForm.ui $$IV/EditFramesForm.ui
# OpenFiles.ui
RESOURCES += resources.qrc

HEADERS += $$IV/Iv.h $$IV/IvMain.h $$IV/IvView3D.h $$IV/IvDocument.h $$IV/IvIsoSurface.h $$IV/IvMesh.h $$IV/IvScript.h $$IV/IvIao.h $$IV/IvIrc.h $$IV/IvGl.h $$IV/IvLog.h $$IV/fn_LiberationSans.h
SOURCES += $$IV/IvMain.cpp $$IV/IvView3D.cpp $$IV/IvDocument.cpp $$IV/IvScript.cpp $$IV/IvMesh.cpp $$IV/IvIsoSurface.cpp $$IV/IvIao.cpp $$IV/IvIrc.cpp $$IV/IvGl.cpp $$IV/IvLog.cpp

HEADERS += $$IV/IvOrbitalFile.h $$IV/IvCurveView.h $$IV/IvComputeWfForm.h $$IV/IvFindOrbitalsForm.h $$IV/IvShowTextForm.h $$IV/IvFixedAspectSvg.h $$IV/IvStatusBar.h $$IV/IvTables.h $$IV/IvEditFramesForm.h
SOURCES += $$IV/IvOrbitalFile.cpp $$IV/IvCurveView.cpp $$IV/IvComputeWfForm.cpp $$IV/IvFindOrbitalsForm.cpp $$IV/IvShowTextForm.cpp $$IV/IvFixedAspectSvg.cpp $$IV/IvIntInit.cpp $$IV/IvStatusBar.cpp $$IV/IvTables.cpp $$IV/IvEditFramesForm.cpp


HEADERS += $$PUGIXML/pugixml.hpp $$PUGIXML/pugiconfig.hpp
SOURCES += $$PUGIXML/pugixml.cpp

SOURCES += $$OTHER/memory_size.c
HEADERS += $$OTHER/optionparser.h
HEADERS += $$OTHER/vector_math.h

# HEADERS += LoadMolproXml.h pugixml/pugixml.hpp pugixml/pugiconfig.hpp
# SOURCES += LoadMolproXml.cpp pugixml/pugixml.cpp

# INCLUDEPATH += ./cppformat/
# HEADERS += cppformat/format.h
# SOURCES += cppformat/format.cpp

HEADERS += $$OTHER/QPropertyModel.h
SOURCES += $$OTHER/QPropertyModel.cpp


SOURCES += $$CXF/CxLebedevGrid.cpp
SOURCES += $$CXF/CxAlgebra.cpp
SOURCES += $$CXF/CxDiis.cpp
SOURCES += $$CXF/CxIndentStream.cpp
SOURCES += $$CXF/CxMemoryStack.cpp
SOURCES += $$CXF/CxNumpyArray.cpp
SOURCES += $$CXF/CxStorageDevice.cpp
SOURCES += $$CXF/CxColor.cpp
# SOURCES += $$CXF/CxOsInt.cpp
SOURCES += $$IRCORE/IrAmrr.cpp
SOURCES += $$IRCORE/IrBoysFn.cpp
SOURCES += $$IRCORE/IrCore.cpp
SOURCES += $$IRCORE/IrDrv.cpp
SOURCES += $$IRCORE/IrGridOps.cpp
SOURCES += $$IRCORE/IrSlmX.cpp
SOURCES += $$IRCORE/IrSlmRot.cpp
SOURCES += $$IRCORE/IrImportTrafo.cpp


HEADERS += $$MICROSCF/CtDftGrid.h
HEADERS += $$MICROSCF/CtAtomSet.h
HEADERS += $$MICROSCF/CtBasisLibrary.h
HEADERS += $$MICROSCF/CtBasisSet.h
HEADERS += $$MICROSCF/CtBasisShell.h
HEADERS += $$MICROSCF/CtConstants.h
HEADERS += $$MICROSCF/CtAtomData.h
HEADERS += $$MICROSCF/CtAtomData.inl
HEADERS += $$MICROSCF/CtInt1e.h
HEADERS += $$MICROSCF/CtIo.h
HEADERS += $$MICROSCF/CtMatrix.h
HEADERS += $$MICROSCF/CtTiming.h
HEADERS += $$CXF/CxLebedevGrid.h
HEADERS += $$CXF/CxAlgebra.h
HEADERS += $$CXF/CxDefs.h
HEADERS += $$CXF/CxDiis.h
HEADERS += $$CXF/CxFixedSizeArray.h
HEADERS += $$CXF/CxFortranInt.h
HEADERS += $$CXF/CxIndentStream.h
HEADERS += $$CXF/CxMemoryStack.h
HEADERS += $$CXF/CxNumpyArray.h
HEADERS += $$CXF/CxOpenMpProxy.h
HEADERS += $$CXF/CxPodArray.h
HEADERS += $$CXF/CxStorageDevice.h
HEADERS += $$CXF/CxTypes.h
HEADERS += $$CXF/CxVec3.h
HEADERS += $$CXF/CxColor.h
# HEADERS += $$CXF/CxOsInt.h
HEADERS += $$IRCORE/IrAmrr.h
HEADERS += $$IRCORE/IrBoysFn.h
HEADERS += $$IRCORE/IrBoysFn.inl
HEADERS += $$IRCORE/Ir.h

SOURCES += $$MICROSCF/CtDftGrid.cpp
SOURCES += $$MICROSCF/CtAtomSet.cpp
SOURCES += $$MICROSCF/CtBasisLibrary.cpp
SOURCES += $$MICROSCF/CtAtomData.cpp
SOURCES += $$MICROSCF/CtBasisSet.cpp
SOURCES += $$MICROSCF/CtBasisShell.cpp
SOURCES += $$MICROSCF/CtInt1e.cpp
SOURCES += $$MICROSCF/CtIo.cpp
# SOURCES += $$MICROSCF/CtMain.cpp
SOURCES += $$MICROSCF/CtMatrix.cpp
SOURCES += $$MICROSCF/CtTiming.cpp

SOURCES += $$MICROSCF/CtAtomConfigs.cpp
SOURCES += $$MICROSCF/CtDft.cpp
HEADERS += $$MICROSCF/CtDft.h
SOURCES += $$MICROSCF/CtDftFunc.cpp
HEADERS += $$MICROSCF/CtDftFunc.h
SOURCES += $$MICROSCF/CtFockBuild.cpp
HEADERS += $$MICROSCF/CtFockBuild.h
SOURCES += $$MICROSCF/CtRhf.cpp
HEADERS += $$MICROSCF/CtRhf.h
HEADERS += $$MICROSCF/CtRhfOptions.h
SOURCES += $$MICROSCF/format.cpp
HEADERS += $$MICROSCF/format.h
SOURCES += $$MICROSCF/xc_meta.cpp
HEADERS += $$MICROSCF/xc_meta.h




#CONFIG -= dynamic
#CONFIG += static
# ^- I wonder if that works? ... nop. no effect at all.
