// xc functional: PBE GGA exchange functional. (http://dx.doi.org/10.1103/PhysRevLett.77.3865)
void xc_pbex(double &E, double *dE, double const *D, double const Factor)
{
   double rhoc = D[0];
   double rhoo = D[1];
   double sigmacc = D[2];
   double sigmaco = D[3];
   double sigmaoo = D[4];
   double r1 = 1.442249570307408;
   double r2 = .6827840632552957;
   double r3 = rhoc - 1.0*rhoo;
   double r4 = pow(r3,(4.0/3.0));
   double r5 = 0.39685026299205;
   double r6 = 0.30285343213869;
   double r7 = .2173369174628993;
   double r8 = sigmaoo - 2.0*sigmaco + sigmacc;
   double r9 = 0.2730285730901953*r5*r6*r7*r8/pow(r3,(8.0/3.0)) + 1;
   double r10 = 1.804 - 0.804/r9;
   double r11 = rhoo + rhoc;
   double r12 = pow(r11,(4.0/3.0));
   double r13 = sigmaoo + 2.0*sigmaco + sigmacc;
   double r14 = 0.2730285730901953*r13*r5*r6*r7/pow(r11,(8.0/3.0)) + 1;
   double r15 = 1.804 - 0.804/r14;
   double r16 = 3.174802103936399;
   double r17 = .1483941836006992;
   double r18 = 1.0/pow(r3,(7.0/3.0));
   double r19 = 1.0/sqr(r9);
   double r20 = .4807498567691361;
   double r21 = pow(r3,(1.0/3.0));
   double r22 = 1.0/sqr(r14);
   double r23 = 0.02743937159556464*r1*r13*r16*r17*r22*r6/pow(r11,(7.0/3.0));
   double r24 = -1.5*r20*r2*pow(r11,(1.0/3.0))*r15;
   double r25 = 1.0/r4;
   double r26 = 1.0/r12;
   double r27 = -0.0823181147866939*r5*r1*r6*r17*r26*r22 - 0.0823181147866939*r5*r1*r6*r17*r25*r19;
   double r28 = .7937005259840997;
   E += Factor*(-0.375*r1*r2*r12*r15 - 0.375*r1*r2*r4*r10);
   dE[0] += Factor*(r24 + r23 - 1.5*r20*r2*r21*r10 + 0.02743937159556464*r16*r1*r6*r17*r18*r8*r19);
   dE[1] += Factor*(r24 + r23 + 1.5*r20*r2*r21*r10 - 0.02743937159556464*r16*r1*r6*r17*r18*r8*r19);
   dE[2] += Factor*(r27);
   dE[3] += Factor*(0.0823181147866939*r28*r1*r6*r17*r25*r19 - 0.0823181147866939*r28*r1*r6*r17*r26*r22);
   dE[4] += Factor*(r27);
}

/* kate: syntax c++; */

