// xc functional: Dirac-Slater LSDA exchange functional (http://dx.doi.org/10.1103/PhysRev.81.385).
void xc_diracx(double &E, double *dE, double const *D, double const Factor)
{
   double rhoc = D[0];
   double rhoo = D[1];
   double r1 = 1.442249570307408;
   double r2 = .6827840632552957;
   double r3 = pow(rhoc,(4.0/3.0));
   double r4 = 1.0/rhoc;
   double r5 = 1 - 1.0*r4*rhoo;
   double r6 = r4*rhoo + 1;
   double r7 = pow(r6,(4.0/3.0)) + pow(r5,(4.0/3.0));
   double r8 = 1.0/sqr(rhoc);
   double r9 = pow(r5,(1.0/3.0));
   double r10 = pow(r6,(1.0/3.0));
   E += Factor*(-0.375*r1*r2*r3*r7);
   dE[0] += Factor*(-0.375*r1*r2*r3*(1.333333333333333*r8*r9*rhoo - 1.333333333333333*r10*r8*rhoo) - 0.7211247851537042*r2*r7*pow(rhoc,(1.0/3.0)));
   dE[1] += Factor*(-0.375*r1*r2*r3*(1.333333333333333*r10*r4 - 1.333333333333333*r4*r9));
}

/* kate: syntax c++; */

