/* Copyright (c) 2015  Gerald Knizia
 * 
 * This file is part of the IboView program (see: http://www.iboview.org)
 * 
 * IboView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.
 * 
 * IboView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with bfint (LICENSE). If not, see http://www.gnu.org/licenses/
 * 
 * Please see IboView documentation in README.txt for:
 * -- A list of included external software and their licenses. The included
 *    external software's copyright is not touched by this agreement.
 * -- Notes on re-distribution and contributions to/further development of
 *    the IboView software
 */

#ifndef ISO_SURFACE_H
#define ISO_SURFACE_H

#include "IvMesh.h"

enum FIsoSurfaceFlags {
   ISOFLAGS_PlusAndMinus = 0x01,
   ISOFLAGS_AllowFlip = 0x02 // if true, put the larger lobe on the positive side.
};

enum FIsoType {
   ISOTYPE_Undefined,
   ISOTYPE_Absolute,
   ISOTYPE_Density
};

struct FIsoSurfaceSettings
{
   // absolute or density based iso values?
   FIsoType IsoType;
   // either the absolute iso value c (surfaces are always [c,-c]), or the
   // density to derive the iso value c from. 0.80 would be 80%.
   double fIsoValue;
   // number of points per Angstrom in each direction. surface grid is derived from that.
   double fLinearDensity;

   uint Flags;
   uint32_t dwColorPlus, dwColorMinus;

   bool PlusAndMinus() const { return 0 != (Flags & ISOFLAGS_PlusAndMinus); }
   bool AllowFlip() const { return PlusAndMinus() && (0 != (Flags & ISOFLAGS_AllowFlip)); }

   FIsoSurfaceSettings(FIsoType IsoType_ = ISOTYPE_Density, double fIsoValue_ = 0.8,
//       double fLinearDensity_ = 20., uint Flags_ = ISOFLAGS_PlusAndMinus | ISOFLAGS_AllowFlip,
      double fLinearDensity_ = 20., uint Flags_ = ISOFLAGS_PlusAndMinus,
      uint32_t dwColorPlus_ = 0xffff0000, uint32_t dwColorMinus_ = 0xff0000ff)
      : IsoType(IsoType_), fIsoValue(fIsoValue_), fLinearDensity(fLinearDensity_), Flags(Flags_),
        dwColorPlus(dwColorPlus_), dwColorMinus(dwColorMinus_)
   {};
};

struct FOrbital;

FIndexedTriangleListPtr MakeIsoSurface(FOrbital const *pOrbital, FIsoSurfaceSettings const &Options);

#endif // ISO_SURFACE_H
