/* Copyright (c) 2015  Gerald Knizia
 * 
 * This file is part of the IboView program (see: http://www.iboview.org)
 * 
 * IboView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.
 * 
 * IboView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with bfint (LICENSE). If not, see http://www.gnu.org/licenses/
 * 
 * Please see IboView documentation in README.txt for:
 * -- A list of included external software and their licenses. The included
 *    external software's copyright is not touched by this agreement.
 * -- Notes on re-distribution and contributions to/further development of
 *    the IboView software
 */

#ifndef IV_IRC_H
#define IV_IRC_H

#include "IvDocument.h"

bool MakeIboChangeCurve(TArray<float> &CurveData, uint iRow, FDocument *document);

enum FIrcArcLengthFlags {
   // if set, do not do the mass weighting. This will not produce approximate IRC coordinates, but
   // actual arc lengths as X-axis.
   ARCLENGTH_NoMassWeighting = 0x1,
   // if set, use most-common-isotope masses instead of average masses.
   ARCLENGTH_UseIsotopeMasses = 0x2
};

void MakeIrcArcLengths(TArray<float> &ArcLengths, FDocument *document, uint Flags);


#endif // IV_IRC_H
