// this code is GENERATED. Do not change it directly!
void FView3d::InitProperties() {
   m_IsoResolution = 12.0;
   m_IsoThreshold = 80.0;
   m_IsoAutoFlip = false;
   m_AtomScale = 100.0;
   m_BondScale = 100.0;
   m_BondThinning = 0.72;
   m_ShaderRegA0 = 0.8;
   m_ShaderRegO0 = 0.8;
   m_ShaderRegA1 = 0.7;
   m_ShaderRegO1 = 0.7;
   m_ShaderRegA2 = 0.4;
   m_ShaderRegO2 = 0.7;
   m_ShaderRegA3 = -0.5;
   m_ShaderRegO3 = -0.5;
   m_ShaderPath = ":/shader";
   m_LabelAtomNumbers = false;
   m_LabelElements = true;
   m_LabelElementsC = true;
   m_LabelElementsH = false;
   m_LabelSize = 80.0;
   m_LabelSizeH = 0.8;
   m_LabelBrightness = -0.2;
   m_DepthPeelingLayers = 4;
   m_SaveAlpha = true;
   m_CropImages = true;
   m_RenderBacksides = false;
   m_SuperSample = true;
   m_FakeAntiAliasing = true;
   connect(this, SIGNAL(IsoResolutionChanged(double)), this, SLOT(update()));
   connect(this, SIGNAL(IsoThresholdChanged(double)), this, SLOT(update()));
   connect(this, SIGNAL(IsoAutoFlipChanged(bool)), this, SLOT(update()));
   connect(this, SIGNAL(AtomScaleChanged(double)), this, SLOT(update()));
   connect(this, SIGNAL(BondScaleChanged(double)), this, SLOT(update()));
   connect(this, SIGNAL(BondThinningChanged(double)), this, SLOT(update()));
   connect(this, SIGNAL(ShaderRegA0Changed(double)), this, SLOT(update()));
   connect(this, SIGNAL(ShaderRegO0Changed(double)), this, SLOT(update()));
   connect(this, SIGNAL(ShaderRegA1Changed(double)), this, SLOT(update()));
   connect(this, SIGNAL(ShaderRegO1Changed(double)), this, SLOT(update()));
   connect(this, SIGNAL(ShaderRegA2Changed(double)), this, SLOT(update()));
   connect(this, SIGNAL(ShaderRegO2Changed(double)), this, SLOT(update()));
   connect(this, SIGNAL(ShaderRegA3Changed(double)), this, SLOT(update()));
   connect(this, SIGNAL(ShaderRegO3Changed(double)), this, SLOT(update()));
   connect(this, SIGNAL(ShaderPathChanged(QString)), this, SLOT(update()));
   connect(this, SIGNAL(LabelAtomNumbersChanged(bool)), this, SLOT(update()));
   connect(this, SIGNAL(LabelElementsChanged(bool)), this, SLOT(update()));
   connect(this, SIGNAL(LabelElementsCChanged(bool)), this, SLOT(update()));
   connect(this, SIGNAL(LabelElementsHChanged(bool)), this, SLOT(update()));
   connect(this, SIGNAL(LabelSizeChanged(double)), this, SLOT(update()));
   connect(this, SIGNAL(LabelSizeHChanged(double)), this, SLOT(update()));
   connect(this, SIGNAL(LabelBrightnessChanged(double)), this, SLOT(update()));
   connect(this, SIGNAL(DepthPeelingLayersChanged(int)), this, SLOT(update()));
   connect(this, SIGNAL(SaveAlphaChanged(bool)), this, SLOT(update()));
   connect(this, SIGNAL(CropImagesChanged(bool)), this, SLOT(update()));
   connect(this, SIGNAL(RenderBacksidesChanged(bool)), this, SLOT(update()));
   connect(this, SIGNAL(SuperSampleChanged(bool)), this, SLOT(update()));
   connect(this, SIGNAL(FakeAntiAliasingChanged(bool)), this, SLOT(update()));
}

static char const *BoolToCstr(bool o) { return o? "true" : "false"; }

QString FView3d::GetOptionsDesc() {
   std::stringstream str;
   if (std::abs(m_IsoResolution - 12.0) > 1e-4)
      str << boost::format("view.iso_resolution = %.5f;\n") % m_IsoResolution;
   if (std::abs(m_IsoThreshold - 80.0) > 1e-4)
      str << boost::format("view.iso_threshold = %.5f;\n") % m_IsoThreshold;
   if (m_IsoAutoFlip != false)
      str << boost::format("view.iso_auto_flip = %s;\n") % BoolToCstr(m_IsoAutoFlip);
   if (std::abs(m_AtomScale - 100.0) > 1e-4)
      str << boost::format("view.atom_scale = %.5f;\n") % m_AtomScale;
   if (std::abs(m_BondScale - 100.0) > 1e-4)
      str << boost::format("view.bond_scale = %.5f;\n") % m_BondScale;
   if (std::abs(m_BondThinning - 0.72) > 1e-4)
      str << boost::format("view.bond_thinning = %.5f;\n") % m_BondThinning;
   if (std::abs(m_ShaderRegA0 - 0.8) > 1e-4)
      str << boost::format("view.shader_reg_a0 = %.5f;\n") % m_ShaderRegA0;
   if (std::abs(m_ShaderRegO0 - 0.8) > 1e-4)
      str << boost::format("view.shader_reg_o0 = %.5f;\n") % m_ShaderRegO0;
   if (std::abs(m_ShaderRegA1 - 0.7) > 1e-4)
      str << boost::format("view.shader_reg_a1 = %.5f;\n") % m_ShaderRegA1;
   if (std::abs(m_ShaderRegO1 - 0.7) > 1e-4)
      str << boost::format("view.shader_reg_o1 = %.5f;\n") % m_ShaderRegO1;
   if (std::abs(m_ShaderRegA2 - 0.4) > 1e-4)
      str << boost::format("view.shader_reg_a2 = %.5f;\n") % m_ShaderRegA2;
   if (std::abs(m_ShaderRegO2 - 0.7) > 1e-4)
      str << boost::format("view.shader_reg_o2 = %.5f;\n") % m_ShaderRegO2;
   if (std::abs(m_ShaderRegA3 - -0.5) > 1e-4)
      str << boost::format("view.shader_reg_a3 = %.5f;\n") % m_ShaderRegA3;
   if (std::abs(m_ShaderRegO3 - -0.5) > 1e-4)
      str << boost::format("view.shader_reg_o3 = %.5f;\n") % m_ShaderRegO3;
   if (m_ShaderPath != ":/shader")
      str << boost::format("view.shader_path = '%s';\n") % q2s(m_ShaderPath);
   if (m_LabelAtomNumbers != false)
      str << boost::format("view.label_atom_numbers = %s;\n") % BoolToCstr(m_LabelAtomNumbers);
   if (m_LabelElements != true)
      str << boost::format("view.label_elements = %s;\n") % BoolToCstr(m_LabelElements);
   if (m_LabelElementsC != true)
      str << boost::format("view.label_elements_c = %s;\n") % BoolToCstr(m_LabelElementsC);
   if (m_LabelElementsH != false)
      str << boost::format("view.label_elements_h = %s;\n") % BoolToCstr(m_LabelElementsH);
   if (std::abs(m_LabelSize - 80.0) > 1e-4)
      str << boost::format("view.label_size = %.5f;\n") % m_LabelSize;
   if (std::abs(m_LabelSizeH - 0.8) > 1e-4)
      str << boost::format("view.label_size_h = %.5f;\n") % m_LabelSizeH;
   if (std::abs(m_LabelBrightness - -0.2) > 1e-4)
      str << boost::format("view.label_brightness = %.5f;\n") % m_LabelBrightness;
   if (m_DepthPeelingLayers != 4)
      str << boost::format("view.depth_peeling_layers = %i;\n") % m_DepthPeelingLayers;
   if (m_SaveAlpha != true)
      str << boost::format("view.save_alpha = %s;\n") % BoolToCstr(m_SaveAlpha);
   if (m_CropImages != true)
      str << boost::format("view.crop_images = %s;\n") % BoolToCstr(m_CropImages);
   if (m_RenderBacksides != false)
      str << boost::format("view.render_backsides = %s;\n") % BoolToCstr(m_RenderBacksides);
   if (m_SuperSample != true)
      str << boost::format("view.super_sample = %s;\n") % BoolToCstr(m_SuperSample);
   if (m_FakeAntiAliasing != true)
      str << boost::format("view.fake_anti_aliasing = %s;\n") % BoolToCstr(m_FakeAntiAliasing);
   return s2q(str.str());
}

void FView3d::SetIsoResolution(double o) {
   if (o < 1.0) o = 1.0;
   if (o > 100.0) o = 100.0;
   if (o != m_IsoResolution) {
      m_IsoResolution = o;
      emit IsoResolutionChanged(m_IsoResolution);
      IvEmit(" New iso-surfaces will be traced with a resolution of [%1 pt/angstrom]^3.", m_IsoResolution);
   }
}

void FView3d::SetIsoThreshold(double o) {
   if (o < 0.0) o = 0.0;
   if (o > 100.0) o = 100.0;
   if (o != m_IsoThreshold) {
      m_IsoThreshold = o;
      emit IsoThresholdChanged(m_IsoThreshold);
      IvEmit(" New iso-surfaces will be traced with a threshold of %1%.", m_IsoThreshold);
   }
}

void FView3d::SetIsoAutoFlip(bool o) {
   if (o != m_IsoAutoFlip) {
      m_IsoAutoFlip = o;
      emit IsoAutoFlipChanged(m_IsoAutoFlip);
   }
}

void FView3d::SetAtomScale(double o) {
   if (o < 0.0) o = 0.0;
   if (o > 4096.0) o = 4096.0;
   if (o != m_AtomScale) {
      m_AtomScale = o;
      emit AtomScaleChanged(m_AtomScale);
   }
}

void FView3d::SetBondScale(double o) {
   if (o < 0.0) o = 0.0;
   if (o > 4096.0) o = 4096.0;
   if (o != m_BondScale) {
      m_BondScale = o;
      emit BondScaleChanged(m_BondScale);
   }
}

void FView3d::SetBondThinning(double o) {
   if (o < 0.0) o = 0.0;
   if (o > 10.0) o = 10.0;
   if (o != m_BondThinning) {
      m_BondThinning = o;
      emit BondThinningChanged(m_BondThinning);
   }
}

void FView3d::SetShaderRegA0(double o) {
   if (o < -9999.0) o = -9999.0;
   if (o > 9999.0) o = 9999.0;
   if (o != m_ShaderRegA0) {
      m_ShaderRegA0 = o;
      emit ShaderRegA0Changed(m_ShaderRegA0);
   }
}

void FView3d::SetShaderRegO0(double o) {
   if (o < -9999.0) o = -9999.0;
   if (o > 9999.0) o = 9999.0;
   if (o != m_ShaderRegO0) {
      m_ShaderRegO0 = o;
      emit ShaderRegO0Changed(m_ShaderRegO0);
   }
}

void FView3d::SetShaderRegA1(double o) {
   if (o < -9999.0) o = -9999.0;
   if (o > 9999.0) o = 9999.0;
   if (o != m_ShaderRegA1) {
      m_ShaderRegA1 = o;
      emit ShaderRegA1Changed(m_ShaderRegA1);
   }
}

void FView3d::SetShaderRegO1(double o) {
   if (o < -9999.0) o = -9999.0;
   if (o > 9999.0) o = 9999.0;
   if (o != m_ShaderRegO1) {
      m_ShaderRegO1 = o;
      emit ShaderRegO1Changed(m_ShaderRegO1);
   }
}

void FView3d::SetShaderRegA2(double o) {
   if (o < -9999.0) o = -9999.0;
   if (o > 9999.0) o = 9999.0;
   if (o != m_ShaderRegA2) {
      m_ShaderRegA2 = o;
      emit ShaderRegA2Changed(m_ShaderRegA2);
   }
}

void FView3d::SetShaderRegO2(double o) {
   if (o < -9999.0) o = -9999.0;
   if (o > 9999.0) o = 9999.0;
   if (o != m_ShaderRegO2) {
      m_ShaderRegO2 = o;
      emit ShaderRegO2Changed(m_ShaderRegO2);
   }
}

void FView3d::SetShaderRegA3(double o) {
   if (o < -9999.0) o = -9999.0;
   if (o > 9999.0) o = 9999.0;
   if (o != m_ShaderRegA3) {
      m_ShaderRegA3 = o;
      emit ShaderRegA3Changed(m_ShaderRegA3);
   }
}

void FView3d::SetShaderRegO3(double o) {
   if (o < -9999.0) o = -9999.0;
   if (o > 9999.0) o = 9999.0;
   if (o != m_ShaderRegO3) {
      m_ShaderRegO3 = o;
      emit ShaderRegO3Changed(m_ShaderRegO3);
   }
}

void FView3d::SetShaderPath(QString o) {
   if (o != m_ShaderPath) {
      m_ShaderPath = o;
      emit ShaderPathChanged(m_ShaderPath);
   }
}

void FView3d::SetLabelAtomNumbers(bool o) {
   if (o != m_LabelAtomNumbers) {
      m_LabelAtomNumbers = o;
      emit LabelAtomNumbersChanged(m_LabelAtomNumbers);
   }
}

void FView3d::SetLabelElements(bool o) {
   if (o != m_LabelElements) {
      m_LabelElements = o;
      emit LabelElementsChanged(m_LabelElements);
   }
}

void FView3d::SetLabelElementsC(bool o) {
   if (o != m_LabelElementsC) {
      m_LabelElementsC = o;
      emit LabelElementsCChanged(m_LabelElementsC);
   }
}

void FView3d::SetLabelElementsH(bool o) {
   if (o != m_LabelElementsH) {
      m_LabelElementsH = o;
      emit LabelElementsHChanged(m_LabelElementsH);
   }
}

void FView3d::SetLabelSize(double o) {
   if (o < 0.0) o = 0.0;
   if (o > 1000.0) o = 1000.0;
   if (o != m_LabelSize) {
      m_LabelSize = o;
      emit LabelSizeChanged(m_LabelSize);
   }
}

void FView3d::SetLabelSizeH(double o) {
   if (o < 0.0) o = 0.0;
   if (o > 10.0) o = 10.0;
   if (o != m_LabelSizeH) {
      m_LabelSizeH = o;
      emit LabelSizeHChanged(m_LabelSizeH);
   }
}

void FView3d::SetLabelBrightness(double o) {
   if (o < -1.0) o = -1.0;
   if (o > 1.0) o = 1.0;
   if (o != m_LabelBrightness) {
      m_LabelBrightness = o;
      emit LabelBrightnessChanged(m_LabelBrightness);
   }
}

void FView3d::SetDepthPeelingLayers(int o) {
   if (o < 0) o = 0;
   if (o > 16) o = 16;
   if (o != m_DepthPeelingLayers) {
      m_DepthPeelingLayers = o;
      emit DepthPeelingLayersChanged(m_DepthPeelingLayers);
   }
}

void FView3d::SetSaveAlpha(bool o) {
   if (o != m_SaveAlpha) {
      m_SaveAlpha = o;
      emit SaveAlphaChanged(m_SaveAlpha);
   }
}

void FView3d::SetCropImages(bool o) {
   if (o != m_CropImages) {
      m_CropImages = o;
      emit CropImagesChanged(m_CropImages);
   }
}

void FView3d::SetRenderBacksides(bool o) {
   if (o != m_RenderBacksides) {
      m_RenderBacksides = o;
      emit RenderBacksidesChanged(m_RenderBacksides);
   }
}

void FView3d::SetSuperSample(bool o) {
   if (o != m_SuperSample) {
      m_SuperSample = o;
      emit SuperSampleChanged(m_SuperSample);
   }
}

void FView3d::SetFakeAntiAliasing(bool o) {
   if (o != m_FakeAntiAliasing) {
      m_FakeAntiAliasing = o;
      emit FakeAntiAliasingChanged(m_FakeAntiAliasing);
   }
}

void FView3d::CopyPropertiesFrom(FView3d const &other) {
   SetIsoResolution(other.GetIsoResolution());
   SetIsoThreshold(other.GetIsoThreshold());
   SetIsoAutoFlip(other.GetIsoAutoFlip());
   SetAtomScale(other.GetAtomScale());
   SetBondScale(other.GetBondScale());
   SetBondThinning(other.GetBondThinning());
   SetShaderRegA0(other.GetShaderRegA0());
   SetShaderRegO0(other.GetShaderRegO0());
   SetShaderRegA1(other.GetShaderRegA1());
   SetShaderRegO1(other.GetShaderRegO1());
   SetShaderRegA2(other.GetShaderRegA2());
   SetShaderRegO2(other.GetShaderRegO2());
   SetShaderRegA3(other.GetShaderRegA3());
   SetShaderRegO3(other.GetShaderRegO3());
   SetShaderPath(other.GetShaderPath());
   SetLabelAtomNumbers(other.GetLabelAtomNumbers());
   SetLabelElements(other.GetLabelElements());
   SetLabelElementsC(other.GetLabelElementsC());
   SetLabelElementsH(other.GetLabelElementsH());
   SetLabelSize(other.GetLabelSize());
   SetLabelSizeH(other.GetLabelSizeH());
   SetLabelBrightness(other.GetLabelBrightness());
   SetDepthPeelingLayers(other.GetDepthPeelingLayers());
   SetSaveAlpha(other.GetSaveAlpha());
   SetCropImages(other.GetCropImages());
   SetRenderBacksides(other.GetRenderBacksides());
   SetSuperSample(other.GetSuperSample());
   SetFakeAntiAliasing(other.GetFakeAntiAliasing());
}
// kate: syntax c++;
