// this code is GENERATED. Do not change it directly!
void FElementOptions::InitProperties() {
   m_Color = (int)GetDefaultColor();
   m_BondColor = (int)GetDefaultBondColor();
   m_BondRadiusFactor = 1.3;
   m_CovalentRadius = GetDefaultCovalentRadius();
   m_DrawRadius = GetDefaultDrawRadius();
   m_DrawName = ElementName();
}

QString FElementOptions::GetOptionsDesc() {
   std::stringstream str;
   if (m_Color != (int)GetDefaultColor())
      str << boost::format("doc.elements(ielem).color = %i;\n") % m_Color;
   if (m_BondColor != (int)GetDefaultBondColor())
      str << boost::format("doc.elements(ielem).bond_color = %i;\n") % m_BondColor;
   if (std::abs(m_BondRadiusFactor - 1.3) > 1e-4)
      str << boost::format("doc.elements(ielem).bond_radius_factor = %.5f;\n") % m_BondRadiusFactor;
   if (std::abs(m_CovalentRadius - GetDefaultCovalentRadius()) > 1e-4)
      str << boost::format("doc.elements(ielem).covalent_radius = %.5f;\n") % m_CovalentRadius;
   if (std::abs(m_DrawRadius - GetDefaultDrawRadius()) > 1e-4)
      str << boost::format("doc.elements(ielem).draw_radius = %.5f;\n") % m_DrawRadius;
   if (m_DrawName != ElementName())
      str << boost::format("doc.elements(ielem).draw_name = '%s';\n") % q2s(m_DrawName);
   return s2q(str.str());
}

void FElementOptions::SetColor(int o) {
   if (o != m_Color) {
      m_Color = o;
      emit ColorChanged(m_Color);
   }
}

void FElementOptions::SetBondColor(int o) {
   if (o != m_BondColor) {
      m_BondColor = o;
      emit BondColorChanged(m_BondColor);
   }
}

void FElementOptions::SetBondRadiusFactor(double o) {
   if (o < 0.0) o = 0.0;
   if (o > 4096.0) o = 4096.0;
   if (o != m_BondRadiusFactor) {
      m_BondRadiusFactor = o;
      emit BondRadiusFactorChanged(m_BondRadiusFactor);
   }
}

void FElementOptions::SetCovalentRadius(double o) {
   if (o < -1.0) o = -1.0;
   if (o > 4096.0) o = 4096.0;
   if (o != m_CovalentRadius) {
      m_CovalentRadius = o;
      emit CovalentRadiusChanged(m_CovalentRadius);
   }
}

void FElementOptions::SetDrawRadius(double o) {
   if (o < -1.0) o = -1.0;
   if (o > 4096.0) o = 4096.0;
   if (o != m_DrawRadius) {
      m_DrawRadius = o;
      emit DrawRadiusChanged(m_DrawRadius);
   }
}

void FElementOptions::SetDrawName(QString o) {
   if (o != m_DrawName) {
      m_DrawName = o;
      emit DrawNameChanged(m_DrawName);
   }
}

void FElementOptions::CopyPropertiesFrom(FElementOptions const &other) {
   SetColor(other.GetColor());
   SetBondColor(other.GetBondColor());
   SetBondRadiusFactor(other.GetBondRadiusFactor());
   SetCovalentRadius(other.GetCovalentRadius());
   SetDrawRadius(other.GetDrawRadius());
   SetDrawName(other.GetDrawName());
}
// kate: syntax c++;
